---
name: Bug report
about: Create a report to help us improve
title: ''
labels: ''
assignees: ''

---

**Due diligence**
Please try searching the issue tracker for your problem if you haven't already!
If you find related issues that aren't an exact match, feel free to continue
making a report, and link to those issues.

**Describe the bug**
A clear and concise description of what the bug is.

**To Reproduce**
Steps to reproduce the behaviour (please attach a minimal example):
1. ...
2. ...

**Expected behaviour**
A clear and concise description of what you expected to happen.

**Environment**
Make sure your report gets the attention it deserves: bug reports with missing
information may be ignored or punted back to you, delaying a fix. The below
constitutes a bare minimum; more info is almost always better:

- What version of the Python interpreter are you using? Are you using an
alternative interpreter such as PyPy?
- What operating system are you using both client & server-side?
- Are you using OpenSSH server or something else?
- Which version or versions of the software are you using?
  - Have you already tried the latest release?
  - Have you, or can you, try some older releases to pin down where the bug
  appeared?
- How can the developers recreate the bug on their end? If possible, include a
  copy of your code, the command you used to invoke it, and the full output of
  your run (if applicable.)
  - A common tactic is to pare down your code until a simple (but still
  bug-causing) “base case” remains. Not only can this help you identify
  problems which aren’t real bugs, but it means the developer can get to fixing
  the bug faster.

**Additional context**
Add any other context about the problem here.
