/*
 * Decompiled with CFR 0.152.
 */
package jalview.schemes;

import jalview.analysis.Conservation;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.ResidueProperties;
import jalview.util.Comparison;
import java.awt.Color;
import java.util.Hashtable;

public class ResidueColourScheme
implements ColourSchemeI {
    boolean conservationColouring = false;
    Color[] colors;
    int threshold = 0;
    protected String ignoreGaps = "G";
    Hashtable[] consensus;
    char[] conservation;
    int conservationLength = 0;
    int inc = 30;

    public ResidueColourScheme(Color[] colours, int threshold) {
        this.colors = colours;
        this.threshold = threshold;
    }

    public ResidueColourScheme() {
    }

    public Color findColour(char c) {
        return this.colors[ResidueProperties.aaIndex[c]];
    }

    public Color findColour(char c, int j) {
        Color currentColour = this.threshold == 0 || this.aboveThreshold(c, j) ? this.colors[ResidueProperties.aaIndex[c]] : Color.white;
        if (this.conservationColouring) {
            currentColour = this.applyConservation(currentColour, j);
        }
        return currentColour;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int ct, boolean ignoreGaps) {
        this.threshold = ct;
        this.ignoreGaps = ignoreGaps ? "N" : "G";
    }

    public boolean aboveThreshold(char c, int j) {
        if ('a' <= c && c <= 'z') {
            c = (char)(c - 32);
        }
        if (this.consensus == null || this.consensus.length < j || this.consensus[j] == null) {
            return false;
        }
        return (Integer)this.consensus[j].get("C") != -1 && this.consensus[j].contains(String.valueOf(c)) && ((Float)this.consensus[j].get(this.ignoreGaps)).floatValue() >= (float)this.threshold;
    }

    public boolean conservationApplied() {
        return this.conservationColouring;
    }

    public void setConservationInc(int i) {
        this.inc = i;
    }

    public int getConservationInc() {
        return this.inc;
    }

    public void setConsensus(Hashtable[] consensus) {
        if (consensus == null) {
            return;
        }
        this.consensus = consensus;
    }

    public void setConservation(Conservation cons) {
        if (cons == null) {
            this.conservationColouring = false;
            this.conservation = null;
        } else {
            this.conservationColouring = true;
            int iSize = cons.getConsSequence().getLength();
            this.conservation = new char[iSize];
            for (int i = 0; i < iSize; ++i) {
                this.conservation[i] = cons.getConsSequence().getCharAt(i);
            }
            this.conservationLength = this.conservation.length;
        }
    }

    Color applyConservation(Color currentColour, int i) {
        if (this.conservationLength > i && this.conservation[i] != '*' && this.conservation[i] != '+') {
            if (Comparison.isGap(this.conservation[i])) {
                currentColour = Color.white;
            } else {
                float t = 11 - (this.conservation[i] - 48);
                if (t == 0.0f) {
                    return Color.white;
                }
                int red = currentColour.getRed();
                int green = currentColour.getGreen();
                int blue = currentColour.getBlue();
                int dr = 255 - red;
                int dg = 255 - green;
                int db = 255 - blue;
                dr = (int)((float)dr * (t / 10.0f));
                dg = (int)((float)dg * (t / 10.0f));
                db = (int)((float)db * (t / 10.0f));
                red = (int)((float)red + (float)this.inc / 20.0f * (float)dr);
                green = (int)((float)green + (float)this.inc / 20.0f * (float)dg);
                blue = (int)((float)blue + (float)this.inc / 20.0f * (float)db);
                currentColour = red > 255 || green > 255 || blue > 255 ? Color.white : new Color(red, green, blue);
            }
        }
        return currentColour;
    }
}

