Elvish 0.19.1 has been released on 2023-03-05, almost a year after 0.18.0,
bringing new features and bugfixes.

As usual, [prebuilt binaries](https://elv.sh/get) are offered for most common
platforms.

**Note**: The 0.19.0 version was tagged prematurely by mistake, but it has been
picked up by some package managers. As a result, the 0.19.0 version is
considered to be "skipped" officially. If your package manager provides a 0.19.0
version, it is probably identical to 0.19.1 in functionalities.

**Note 2**: The commit tagged 0.19.1 would advertise itself as 0.19.0 when
built. To fix this inconsistency, 0.19.2 was tagged with the correct version
information.

# Notable new features

-   A new `doc` module provides access to the documentation of builtin modules.

-   A new `conj` command "appends" values to a list, and has a guaranteed time
    complexity independent of the size of the list.

-   A new `inexact-num` converts its argument to an inexact number.

    It is functionally identical to the now deprecated `float64` command since
    the Go float64 type is the only underlying inexact number type for now. Its
    behavior may change in future if there are more underlying types for inexact
    numbers.

-   A new type of interactive abbreviation: `edit:command-abbr`
    ([#1472](https://b.elv.sh/1472)).

-   The `order` and `compare` commands now support boolean values
    ([#1585](https://b.elv.sh/1585)).

-   A new `path:join` command and `path:separator` and `path:list-separator`
    variables ([#1562](https://b.elv.sh/1562)).

-   A new `runtime:` module that contains paths important for the Elvish runtime
    ([#1385](https://b.elv.sh/1385), [#1423](https://b.elv.sh/1423)).

-   A new `compact` command that replaces consecutive runs of equal values with
    a single copy, similar to the Unix `uniq` command.

-   The `order` command has a new `&key` option
    ([#1570](https://b.elv.sh/1570)).

-   A new `benchmark` command has been added ([#1586](https://b.elv.sh/1586)).

-   When checking compilation errors, Elvish no longer stops after the first
    error found. For example, if `$a` and `$b` are both not defined,
    `echo $a $b` now yields two errors. This applies to both the interactive
    REPL and `elvish -compile-only`.

-   When using an unimported builtin modules from the REPL, the REPL now shows
    the `use` command needed to import it, which can be executed from a key
    binding. This functionality is bound to Ctrl-A by default.

-   New variables exposing the terminal and null device in an OS-agnostic
    fashion: `$path:dev-tty` and `$path:dev-null`. They are `/dev/tty` and
    `/dev/null` on Unix, and `CON` and `NUL` on Windows
    ([#1633](https://b.elv.sh/1633)).

# Breaking changes

-   When a `styled` or `styled-segment` is printed to terminal, the resulting
    sequence will now always ignore any existing SGR state.

-   Symbolic links are now always treated as ordinary files by the global
    modifiers `type:dir` and `type:regular` in wildcard expansions.

-   Support for shared vars has been removed, along with its API
    (`store:shared-var`, `store:set-shared-var` and `store:del-shared-var`).

-   The `try` command no longer supports the `except` keyword. It has been
    superseded by the `catch` keyword.

# Deprecated features

Deprecated features will be removed in 0.20.0.

The following deprecated features trigger a warning whenever the code is parsed
and compiled, even if it is not executed:

-   The `float64` command is now deprecated. Use `num` for constructing a typed
    number, or `inexact-num` for constructing an inexact number.

    The documentation has advertised it as deprecated since the 0.16.0 release,
    but deprecation warnings were never added.

# Notable bugfixes

-   Temporary assignment on an unset environment variables no longer leave it
    set to an empty string ([#1448](https://b.elv.sh/1448)).

-   Broken symbolic links no longer terminate a wildcard expansion prematurely
    ([#1240](https://b.elv.sh/1240)).

-   On Windows, command completion for executables now also works for local
    files.
