/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.webservices.dns.client.util;

import com.amazon.webservices.dns.client.util.HttpResponse;
import com.amazon.webservices.dns.client.util.HttpRestClientSetupException;
import com.amazon.webservices.dns.client.util.Path;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpRestClient {
    private static final String CONTENT_TYPE = "text/xml";
    private static final String CHARSET = "UTF-8";
    private final URL url_;

    public HttpRestClient(URL url) {
        this.url_ = url;
    }

    public HttpResponse post(Path path, Map<String, String> header, String data) {
        String escapedUrl = HttpRestClient.getEscapedUrl(this.url_, path);
        PostMethod postMethod = new PostMethod(escapedUrl);
        return this.performAction((EntityEnclosingMethod)postMethod, header, data);
    }

    public HttpResponse put(Path path, Map<String, String> header, String data) {
        String escapedUrl = HttpRestClient.getEscapedUrl(this.url_, path);
        PutMethod putMethod = new PutMethod(escapedUrl);
        return this.performAction((EntityEnclosingMethod)putMethod, header, data);
    }

    public HttpResponse get(Path path, Map<String, String> header) {
        String escapedUrl = HttpRestClient.getEscapedUrl(this.url_, path);
        GetMethod getMethod = new GetMethod(escapedUrl);
        return this.performAction((HttpMethod)getMethod, header);
    }

    public HttpResponse delete(Path path, Map<String, String> header) {
        String escapedUrl = HttpRestClient.getEscapedUrl(this.url_, path);
        DeleteMethod deleteMethod = new DeleteMethod(escapedUrl);
        return this.performAction((HttpMethod)deleteMethod, header);
    }

    public static String getEscapedUrl(URL url, Path path) {
        try {
            URI uri = new URI(url.getProtocol(), url.getAuthority() + url.getFile() + path.getValue(), null);
            String queryArgs = uri.getRawQuery() == null ? "" : uri.getRawQuery();
            String escapedUri = uri.getScheme() + "://" + uri.getRawSchemeSpecificPart() + queryArgs;
            return escapedUri;
        }
        catch (URISyntaxException e) {
            throw new HttpRestClientSetupException("Exception thrown while trying to escape url: " + url.getProtocol() + url.getHost() + url.getFile() + path.getValue());
        }
    }

    private HttpResponse performAction(EntityEnclosingMethod method, Map<String, String> headers, String data) {
        try {
            method.setRequestEntity((RequestEntity)new StringRequestEntity(data, CONTENT_TYPE, CHARSET));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        return this.performAction((HttpMethod)method, headers);
    }

    private HttpResponse performAction(HttpMethod method, Map<String, String> requestHeaders) {
        HttpClient client = new HttpClient();
        this.addHeaders(method, requestHeaders);
        try {
            int statusCode = client.executeMethod(method);
            return new HttpResponse(method.getResponseBodyAsString(), statusCode, this.getResponseHeaders(method));
        }
        catch (HttpException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new IllegalStateException("IOException occured " + e);
        }
    }

    private void addHeaders(HttpMethod method, Map<String, String> headers) {
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            method.setRequestHeader(entry.getKey(), entry.getValue());
        }
    }

    private Map<String, String> getResponseHeaders(HttpMethod method) {
        HashMap<String, String> responseHeaders = new HashMap<String, String>();
        if (method.getResponseHeaders() != null) {
            for (Header header : method.getResponseHeaders()) {
                responseHeaders.put(header.getName(), header.getValue());
            }
        }
        return responseHeaders;
    }
}

