#ifndef CLRTBLWIDGET_H
#define CLRTBLWIDGET_H

#include <QWidget>
#include <QImage>
#include <QLabel>
#include <QPushButton>
#include <QSpinBox>
#include <QComboBox>
#include <QCheckBox>
#include <QDialog>

class QFitsMainWindow;
class QFitsSingleBuffer;

class QFits2dFit : public QDialog {
	Q_OBJECT
//----- Functions -----
public:
    QFits2dFit(QFitsMainWindow *parent = NULL);
    ~QFits2dFit() {}

    void centre(int, int, int, int);
    void fitGauss();
protected:
    void paintEvent( QPaintEvent * );
    void resizeEvent(QResizeEvent *);

//----- Slots -----
public slots:
    void refit();
    void zoomChanged(int);
    void fitfunctionChanged(const QString &);
    void createFitFunction();

//----- Signals -----
signals:
    void newposinfo(const QString &);

//----- Members -----
public:
    QLabel *resultLabel1, *resultLabel2, *resultLabel3;
    QSpinBox *fitwindow;
    QDoubleSpinBox *slm;
    QCheckBox *fitslm;
    QComboBox *fitfunction;
    QPushButton *refitButton, *closeButton, *createButton;
    int zoom;
    double fitresult[20];
    int cenx, ceny, cencx, cency, savex, savey, savefitwidth, fitx, fity;
    QFitsMainWindow *myParent;
};

#endif /* CLRTBLWIDGET_H */
