# Copyright © The Debusine Developers
# See the AUTHORS file at the top-level directory of this distribution
#
# This file is part of Debusine. It is subject to the license terms
# in the LICENSE file found in the top-level directory of this
# distribution. No part of Debusine, including this file, may be copied,
# modified, propagated, or distributed except according to the terms
# contained in the LICENSE file.

"""Rename ``system:host_architecture`` to ``system:native_architecture``."""

from django.db import migrations

from debusine.db.migrations._utils import make_data_field_renamer


class Migration(migrations.Migration):

    dependencies = [
        ("db", "0026_rename_publish_target_to_suite"),
    ]

    operations = [
        make_data_field_renamer(
            "Worker",
            "static_metadata",
            {},
            [("system:host_architecture", "system:native_architecture")],
        )
    ]
