#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "binary_section.hpp"

binary_section::binary_section(package_name const &name) :
	name(name),
	optional(false), cross_compiling(false), bootstrap(false)
{
	return;
}

binary_section::attribute binary_section::operator[](std::string const &key)
{
	if(key == "Section")
		return attribute(&binary_section::section, *this);
	if(key == "Depends")
		return attribute(&binary_section::depends, *this);
	if(key == "Recommends")
		return attribute(&binary_section::recommends, *this);
	if(key == "Suggests")
		return attribute(&binary_section::suggests, *this);
	if(key == "Conflicts")
		return attribute(&binary_section::conflicts, *this);
	if(key == "Replaces")
		return attribute(&binary_section::replaces, *this);
	if(key == "Provides")
		return attribute(&binary_section::provides, *this);
	if(key == "Breaks")
		return attribute(&binary_section::breaks, *this);
	if(key == "Description")
		return attribute(&binary_section::description, *this);
	if(key == "Architecture")
		return attribute(&binary_section::architecture, *this);
	if(key == "Build-Depends")
		return attribute(&binary_section::build_depends, *this);
	if(key == "Build-Depends-Tools")
		return attribute(&binary_section::build_depends_tools, *this);
	if(key == "Build-Depends-Indep")
		return attribute(&binary_section::build_depends_indep, *this);
	if(key == "Optional")
		return attribute(&binary_section::optional, *this);
	if(key == "Cross-Compiling")
		return attribute(&binary_section::cross_compiling, *this);
	if(key == "Bootstrap")
		return attribute(&binary_section::bootstrap, *this);
	throw attribute::unknown_attribute(key);
}

bool binary_section::operator==(binary_section const &rhs) const
{
	if(name != rhs.name)
		return false;
	if(section != rhs.section)
		return false;
	if(depends != rhs.depends)
		return false;
	if(recommends != rhs.recommends)
		return false;
	if(suggests != rhs.suggests)
		return false;
	if(conflicts != rhs.conflicts)
		return false;
	if(replaces != rhs.replaces)
		return false;
	if(provides != rhs.provides)
		return false;
	if(breaks != rhs.breaks)
		return false;
	if(description != rhs.description)
		return false;
	if(architecture != rhs.architecture)
		return false;
	if(build_depends != rhs.build_depends)
		return false;
	if(build_depends_tools != rhs.build_depends_tools)
		return false;
	if(build_depends_indep != rhs.build_depends_indep)
		return false;
	if(optional != rhs.optional)
		return false;
	if(cross_compiling != rhs.cross_compiling)
		return false;
	if(bootstrap != rhs.bootstrap)
		return false;
	return true;
}

control_file_ostream &operator<<(control_file_ostream &stream, binary_section const &sec)
{
	stream << std::make_pair("Package", sec.name);
	if(!sec.section.empty())
		stream << std::make_pair("Section", sec.section);
	stream << std::make_pair("Architecture", sec.architecture);
	if(!sec.depends.empty())
		stream << std::make_pair("Depends", sec.depends);
	if(!sec.recommends.empty())
		stream << std::make_pair("Recommends", sec.recommends);
	if(!sec.suggests.empty())
		stream << std::make_pair("Suggests", sec.suggests);
	if(!sec.conflicts.empty())
		stream << std::make_pair("Conflicts", sec.conflicts);
	if(!sec.replaces.empty())
		stream << std::make_pair("Replaces", sec.replaces);
	if(!sec.provides.empty())
		stream << std::make_pair("Provides", sec.provides);
	if(!sec.breaks.empty())
		stream << std::make_pair("Breaks", sec.breaks);
	if(!sec.build_depends.empty())
		stream << std::make_pair("Build-Depends", sec.build_depends);
	if(!sec.build_depends_tools.empty())
		stream << std::make_pair("Build-Depends-Tools", sec.build_depends_tools);
	if(!sec.build_depends_indep.empty())
		stream << std::make_pair("Build-Depends-Indep", sec.build_depends_indep);
	if(sec.optional)
		stream << std::make_pair("Optional", sec.optional);
	if(sec.cross_compiling)
		stream << std::make_pair("Cross-Compiling", sec.cross_compiling);
	if(sec.bootstrap)
		stream << std::make_pair("Bootstrap", sec.bootstrap);
	stream << std::make_pair("Description", sec.description);
	return stream;
}
