//
// C++ Implementation: UserList
//
// Description: 
//
//
// Author: Rikard Björklind <olof@linux.nu>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "userlistmodel.h"
#include "util.h"

template <class T, size_t blocksPerBatch, size_t blockAlignment>
typename BlockAllocator<T,blocksPerBatch,blockAlignment>::BlockStore BlockAllocator<T,blocksPerBatch,blockAlignment>::s_Store;

QVariant UserListModel::data( const QModelIndex & index, int role ) const
{
	if(index.row() < 0 || index.row() >= users.size()) return QVariant();
	//User* u = userIndexMap.value(index.row());
	User *u = users[index.row()];
	if(u==0) return QVariant();
	
	if(role==Qt::DisplayRole) {
		switch(index.column()) {
			case 0:
				return u->nick;
			case 1:
				return Util::bytesToStr(u->shared);
			case 2:
				return u->description;
			default:
				Q_ASSERT_X(false,"data","wrong column");
		}
	} else if(role==Qt::DecorationRole) {
		if(index.column()==0) {
			bool op = u->flags & User::OP;
			bool passive = u->flags & User::PASSIVE;
			bool dcpp = u->flags & User::DCPLUSPLUS;
			if(op) {
				if(passive) {
					if(dcpp) return iconDcppPassiveOp;
				    else return iconPassiveOp;
				} else if(dcpp) return iconDcppOp;
				else return iconOp;
			} else {
				if(passive) { if(dcpp) return iconDcppPassive; else return iconPassive;}
				else if(dcpp) return iconDcpp; else return iconNormal;
			}
			return iconNormal;
		}
		
	}
	return QVariant();
}

QVariant UserListModel::headerData( int section, Qt::Orientation orientation, int role ) const
{
	if( orientation==Qt::Horizontal && role==Qt::DisplayRole )
	{
		switch(section) {
			case 0: return tr("Nick");
			case 1: return tr("Shared");
			case 2: return tr("Description");
		}
	}
	return QVariant();
}

void UserListModel::setUser( User *u )
{
	// See if the userid is already in the list. In that case, just copy the new values.
	if(userIdMap.contains(u->id)) {
		User* oldUser = userIdMap[u->id];
		u->index = oldUser->index;
		(*oldUser) = *u;
		delete u;
		emit dataChanged(createIndex(oldUser->index,0),createIndex(oldUser->index,2));
	} else {   // Not in list - put it in.
	   userIdMap[u->id] = u;
	   //int index = userIndexMap.size();
	   int index = users.size();
	   u->index = index;
	   //userIndexMap[index] = u;
	   users.append(u);
	   if(updateSignals) emit layoutChanged();
	}
}

void UserListModel::removeUser( int userId )
{
	User* u = userIdMap.take(userId);
	if(u) {
	   //userIndexMap.take(u->index);

		users.removeAt(u->index);
		for(int i=u->index;i<users.size();i++) users[i]->index=i;

		
	   delete u;
	   if(updateSignals) emit layoutChanged();
	}
}

bool userNickLessThan(User* a,User*b) {return a->nick < b->nick;}
bool userShareLessThan(User* a,User*b) {return a->shared < b->shared;}
bool userDescLessThan(User* a,User*b) {return a->description < b->description;}
bool userNickG(User* a,User*b) {return a->nick > b->nick;}
bool userShareG(User* a,User*b) {return a->shared > b->shared;}
bool userDescG(User* a,User*b) {return a->description > b->description;}

void UserListModel::sort( int col, Qt::SortOrder order )
{
	if( order==Qt::AscendingOrder ) {
		switch(col) {
			case 0:
				qSort(users.begin(),users.end(),userNickLessThan);break;
			case 1:
				qSort(users.begin(),users.end(),userShareLessThan);break;
			case 2:
				qSort(users.begin(),users.end(),userDescLessThan);break;
		}
	}
	else {
		switch(col) {
			case 0:
				qSort(users.begin(),users.end(),userNickG);break;
			case 1:
				qSort(users.begin(),users.end(),userShareG);break;
			case 2:
				qSort(users.begin(),users.end(),userDescG);break;
		}

	}

	// Fix indexes
	for(int i=0;i < users.size();i++) users[i]->index = i;

	if(updateSignals) emit layoutChanged();
}
