//
// C++ Interface: datainputstream
//
// Description: 
//
//
// Author: Rikard Bjorklind <olof@linux.nu>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef RPCDATAINPUTSTREAM_H
#define RPCDATAINPUTSTREAM_H

#include <string>

#include <boost/shared_ptr.hpp>

#include "inputbuffer.h"
#include "types.h"

namespace rpc {

/**
	@author Rikard Bjorklind <olof@linux.nu>
*/
class DataInputStream{
public:
    DataInputStream(CmdInputBufferPtr buf);

	int readInt();
	char readByte();
	short readShort();
	bool readBool();
	int64 readLong();
	
	/**
	 * Read a string from the internal buffer and advance its
	 * possition to the end of the string.
	 */
	std::string readUTF();
	
	/**
	 * Check how many bytes remain in the internal buffer.
	 */
	int remainingBytes() const { return data->remaining(); }

    ~DataInputStream();
private:
	void checkRead(int);
	CmdInputBufferPtr data;
};

typedef boost::shared_ptr<DataInputStream> DataInputStreamPtr;

}

#endif
