/*
 * Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either 
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this library.  If not, see <http://www.gnu.org/licenses/>. */

#ifndef _PROCESSING_OPTIONS_INFO_H_
#define _PROCESSING_OPTIONS_INFO_H_

#include <QObject>

#include "RawImageInfo.h"

class QString;
class ProcessingOptions;
class QImage;

class ProcessingOptionsInfo : public QObject {
  Q_OBJECT
  public:
    ProcessingOptionsInfo();
    ProcessingOptionsInfo( const QString& _name, const ProcessingOptions& _options, const QImage& _preview);
    const QString& name() const;
    void setName( const QString& _name);
    const ProcessingOptions& processingOptions() const;
    const QImage& preview() const;
    void changeRawImageInfo(RawImageInfoSP ) const;
  private slots:
    void setPreviewInfo( const PreviewInfo* previewInfo );
    void jobDone();
  signals:
    void previewChanged( );
  private:
    struct Private;
    Private* const d;
};

#endif
