DACSINFOCARD(1)              DACS Commands Manual              DACSINFOCARD(1)



[1mNAME[0m
       dacsinfocard - manage InfoCard accounts

[1mSYNOPSIS[0m
       [1mdacsinfocard [22m[[34m[1mdacsoptions[0m[1m[22m[1]]

[1mDESCRIPTION[0m
       This program is part of the [1mDACS [22msuite.

       The [1mdacsinfocard [22mcommand manages accounts that are used by the
       [34m[1mlocal_infocard_authenticate[0m[1m[22m[2] authentication module. This utility
       serves a similar purpose for these authentication modules that the
       [34m[1mdacspasswd(1)[0m[1m[22m[3] command does for its [34m[1mlocal_passwd_authenticate[0m[1m[22m[4]
       module.

       Apart from their use by [1mlocal_infocard_authenticate[22m, [4mthese[24m [4maccounts[24m [4mare[0m
       [4mcompletely[24m [4mseparate[24m [4mfrom[24m [4many[24m [4mother[24m [4maccounts[24m.

           [1mSecurity[0m
           The digest algorithm used depends on the [34m[1mINFOCARD_DIGEST[0m[1m[22m[5]
           directive in effect.

           Plaintext PPIDs are not stored. This makes it more difficult for an
           attacker that gains access to the InfoCard account file to discover
           PPIDs.

           Only a [1mDACS [22madministrator should be able to successfully run this
           program from the command line. Because [1mDACS [22mkeys and configuration
           files, including the file used to store accounts, must be
           restricted to an administrator, this will normally be the case, but
           a careful administrator will set file permissions to deny access to
           all other users. An ordinary user is able to change his own
           InfoCard registration using the [34m[1mdacs_infocard(8)[0m[1m[22m[6] web service.

       This program is also available as a [1mDACS [22mweb service,
       [34m[1mdacs_infocard(8)[0m[1m[22m[6].

[1mOPTIONS[0m
       The [1mdacsinfocard [22mcommand recognizes these command line flags:

[1mEXAMPLES[0m
       To list all of the InfoCard accounts configured for the jurisdiction
       named INFOCARDS:

           % dacsinfocard -uj INFOCARDS -list
           DSS::INFOCARDS:bob managed,istatic,enabled,passwd
           DSS::INFOCARDS:alice managed,istatic,disabled,passwd

       To re-enable the alice account:

           % dacsinfocard -uj INFOCARDS -ena alice

       To test if alice's account is enabled:

           % dacsinfocard -uj INFOCARDS -test ena alice
           % echo $status
           0

       To test if there are accounts for usernames bob and carol:

           % dacsinfocard -uj INFOCARDS -test exists carol
           % echo $status
           0
           % dacsinfocard -uj INFOCARDS -test exists bob
           % echo $status
           1

       To get the private data for username bob:

           % set x=`dacsinfocard -uj INFOCARDS -pdg bob`
           % echo "$x"
           On vacation


[1mDIAGNOSTICS[0m
       The program exits 0 if everything was fine, and non-zero otherwise. A
       "false" outcome from the [1m-test [22moperation is reflected by an exit status
       of 1. An error condition is indicated by an exit status of 2.

[1mBUGS[0m
       As this is a relatively new and complicated feature, please test
       carefully.

[1mSEE ALSO[0m
       [34m[1mdacs_infocard(8)[0m[1m[22m[6], [34m[1mdacsauth(1)[0m[1m[22m[7], [34m[1mdacs_authenticate(8)[0m[1m[22m[8],
       [34m[1mdacs_admin(8)[0m[1m[22m[9], [34m[1mdacs.conf(5)[0m[1m[22m[10], [34m[1mUsing InfoCards With DACS[0m[1m[22m[11]

[1mAUTHOR[0m
       Distributed Systems Software ([34m[1mwww.dss.ca[0m[1m[22m[12])

[1mCOPYING[0m
       Copyright (C) 2003-2012 Distributed Systems Software. See the
       [34m[1mLICENSE[0m[1m[22m[13] file that accompanies the distribution for licensing
       information.

[1mNOTES[0m
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. local_infocard_authenticate
           http://dacs.dss.ca/man/dacs_authenticate.8.html#local_infocard_authenticate

        3. dacspasswd(1)
           http://dacs.dss.ca/man/dacspasswd.1.html

        4. local_passwd_authenticate
           http://dacs.dss.ca/man/dacs_authenticate.8.html#local_passwd_authenticate

        5. INFOCARD_DIGEST
           http://dacs.dss.ca/man/dacs.conf.5.html#INFOCARD_DIGEST

        6. dacs_infocard(8)
           http://dacs.dss.ca/man/dacs_infocard.8.html

        7. dacsauth(1)
           http://dacs.dss.ca/man/dacsauth.1.html

        8. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html

        9. dacs_admin(8)
           http://dacs.dss.ca/man/dacs_admin.8.html

       10. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html

       11. Using InfoCards With DACS
           http://dacs.dss.ca/man/using-infocards-with-dacs.html

       12. www.dss.ca
           http://www.dss.ca

       13. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.38a                      11/23/2016                   DACSINFOCARD(1)
