#include "ipstore"

void IPStore::clearoldest() {
    time_t oldest_time = time(0) + 100;
    StoreMap::iterator oldest_entry;
    bool found = false;

    Mutex::lock(&store);

    dump();
    
    // Find oldest entry.
    for (StoreMap::iterator iter = store.begin();
	 iter != store.end();
	 iter++) {
	if ((*iter).second.lastaccess < oldest_time) {
	    oldest_time = (*iter).second.lastaccess;
	    oldest_entry = iter;
	    found = true;
	}
    }

    // Kill it if we got it.
    if (found) {
	if (config.debug()) {
	    Timestamp tm((*oldest_entry).second.lastaccess);
	    _debugmsg(Mstr("Erasing oldest IP store entry: ") +
		      Mstr(inet_ntoa(oldest_entry->first)) + " on " +
		      tm.desc() + "\n");
	}
	store.erase(oldest_entry);
    }

    Mutex::unlock(&store);
    dump();
}
