/* $Id: vector_utils.h,v 1.1 2013-07-24 07:44:56 cgarcia Exp $
 *
 * This file is part of the MOSCA library
 * Copyright (C) 2013 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/*
 * $Author: cgarcia $
 * $Date: 2013-07-24 07:44:56 $
 * $Revision: 1.1 $
 * $Name: not supported by cvs2svn $
 */

#ifndef VECTOR_UTILS_H
#define VECTOR_UTILS_H

#include <vector>

namespace mosca
{
template<typename T>
void vector_divide(std::vector<T>& input, 
                   std::vector<T>& input_err,
                   const std::vector<int>& dividend);

template<typename T>
void vector_smooth(std::vector<T>& input, 
                   std::vector<T>& input_err,
                   size_t smooth_size);
}


#include "vector_utils.tcc"

#endif
