!   This module computes the basic integrals for the
!   truncated coulomb operator
!
!   fm(0) = G_0(R,T)= ((2*erf(sqrt(t))+erf(R-sqrt(t))-erf(R+sqrt(t)))/sqrt(t))
!
!   and up to 21 derivatives with respect to T
!
!   fm(n) = (-1)**n d^n/dT^n G_0(R,T)
!
!   The implementation here is based on source code generated by mapple, 
!   and converted to use arbitrary precision.
!   This is required to evaluate these expressions accurately.  
!
MODULE mpfr_cutoff_gamma
  USE mpfr
  USE mpfr_ops

  IMPLICIT NONE

  CONTAINS

  SUBROUTINE cutoff_gamma_T0(nmax,R,fm)

    INTEGER, INTENT(IN)                      :: nmax
    TYPE(mpfr_type), INTENT(IN)              :: R
    TYPE(mpfr_type), DIMENSION(0:nmax) &
                                  :: fm
    TYPE(mpfr_type) :: t1,t2,t4,t9,t16,t25,t33,t39,t53,t67,t80,t82,t93,t96,t108,&
        t111,t125,t127,t142,t144,t159,t162,t179,t181,t199,t201,t217,t222,t242,&
        t244,t265,t268,t281,t283,t294,t308,t321
    INTEGER :: i

      ! XXXXXXXXXXXX a fast fake function for testing XXXXXXXXXX
      ! fm=1/(R+10)
      ! RETURN

      t1 = R ** 2
      t2 = exp(t1)
      t4 = .CONVERT."0.1D1" / t2
      fm(0) = (t2 - .CONVERT."0.1D1") * t4
      fm(1) = (-t2 + .CONVERT."0.1D1" - .CONVERT."0.2D1" * t1) * t4 / .CONVERT."0.3D1"
      t9 = t1 ** 2
      fm(2) = (.CONVERT."-0.3D1" + .CONVERT."0.12D2" * t1 - .CONVERT."0.4D1" * t9 + .CONVERT."0.3D1" * t2) * t4 / .CONVERT."0.15D2"
      t16 = t9 * t1
      fm(3) = (.CONVERT."0.15D2" - .CONVERT."0.90D2" * t1 + .CONVERT."0.60D2" * t9 - .CONVERT."0.8D1" * t16 - .CONVERT."0.15D2"  &
      * t2) * t4 / .CONVERT."0.105D3"
      t25 = t9 ** 2
      fm(4) = (.CONVERT."0.105D3" * t2 - .CONVERT."0.840D3" * t9 + .CONVERT."0.224D3" * t16 + .CONVERT."0.840D3" * t1  &
      - .CONVERT."0.16D2" * t25 - .CONVERT."0.105D3") * t4 / .CONVERT."0.945D3"
      t33 = t25 * t1
      fm(5) = (.CONVERT."0.720D3" * t25 + .CONVERT."0.945D3" - .CONVERT."0.9450D4" * t1 + .CONVERT."0.12600D5" * t9 -  &
      .CONVERT."0.5040D4" * t16 - .CONVERT."0.32D2" * t33 - .CONVERT."0.945D3" * t2) * t4 / .CONVERT."0.10395D5"
      t39 = t25 * t9
      fm(6) = (.CONVERT."0.2112D4" * t33 - .CONVERT."0.10395D5" - .CONVERT."0.64D2" * t39 + .CONVERT."0.10395D5" * t2  &
      - .CONVERT."0.207900D6" * t9 + .CONVERT."0.124740D6" * t1 - .CONVERT."0.23760D5" * t25 + .CONVERT."0.110880D6"  &
      * t16) * t4 / .CONVERT."0.135135D6"
      t53 = t25 * t16
      fm(7) = (.CONVERT."-0.1891890D7" * t1 + .CONVERT."0.3783780D7" * t9 + .CONVERT."0.5824D4" * t39 + .CONVERT."0.135135D6"  &
      - .CONVERT."0.2522520D7" * t16 - .CONVERT."0.96096D5" * t33 - .CONVERT."0.128D3" * t53 - .CONVERT."0.135135D6"  &
      * t2 + .CONVERT."0.720720D6" * t25) * t4 / .CONVERT."0.2027025D7"
      t67 = t25 ** 2
      fm(8) = (.CONVERT."0.2027025D7" * t2 + .CONVERT."0.32432400D8" * t1 - .CONVERT."0.2027025D7" - .CONVERT."0.75675600D8"  &
      * t9 + .CONVERT."0.60540480D8" * t16 - .CONVERT."0.21621600D8" * t25 + .CONVERT."0.3843840D7"  &
      * t33 - .CONVERT."0.349440D6" * t39 + .CONVERT."0.15360D5" * t53 - .CONVERT."0.256D3" * t67) * t4  &
      / .CONVERT."0.34459425D8"
      t80 = t67 * t1
      t82 = -0.620269650D9 * t1 + .CONVERT."0.1654052400D10" * t9 + .CONVERT."0.34459425D8" - .CONVERT."0.1543782240D10"  &
      * t16 + .CONVERT."0.661620960D9" * t25 - .CONVERT."0.34459425D8" * t2 - .CONVERT."0.147026880D9"  &
      * t33 + .CONVERT."0.17821440D8" * t39 - .CONVERT."0.1175040D7" * t53 + .CONVERT."0.39168D5"  &
      * t67 - .CONVERT."0.512D3" * t80
      fm(9) = t82 * t4 / .CONVERT."0.654729075D9"
      t93 = t67 * t9
      t96 = .CONVERT."0.13094581500D11" * t1 - .CONVERT."0.39283744500D11" * t9 - .CONVERT."0.654729075D9"  &
      + .CONVERT."0.41902660800D11" * t16 - .CONVERT."0.20951330400D11" * t25 + .CONVERT."0.5587021440D10"  &
      * t33 - .CONVERT."0.846518400D9" * t39 + .CONVERT."0.74419200D8" * t53 - .CONVERT."0.3720960D7"  &
      * t67 + .CONVERT."0.97280D5" * t80 - .CONVERT."0.1024D4" * t93 + .CONVERT."0.654729075D9" * t2
      fm(10) = t96 * t4 / .CONVERT."0.13749310575D11"
      t108 = t67 * t16
      t111 = .CONVERT."0.1008282775500D13" * t9 - .CONVERT."0.1209939330600D13" * t16 + .CONVERT."0.13749310575D11"  &
      - .CONVERT."0.302484832650D12" * t1 + .CONVERT."0.691393903200D12" * t25 - .CONVERT."0.215100325440D12"  &
      * t33 + .CONVERT."0.39109150080D11" * t39 - .CONVERT."0.4297708800D10" *  &
      t53 + .CONVERT."0.286513920D9" * t67 - .CONVERT."0.11235840D8" * t80 + .CONVERT."0.236544D6" * t93  &
      - .CONVERT."0.2048D4" * t108 - .CONVERT."0.13749310575D11" * t2
      fm(11) = t111 * t4 / .CONVERT."0.316234143225D12"
      t125 = t67 * t25
      t127 = .CONVERT."0.316234143225D12" * t2 - .CONVERT."0.23853089660400D14" * t25 + .CONVERT."0.37104806138400D14"  &
      * t16 - .CONVERT."0.27828604603800D14" * t9 + .CONVERT."0.7589619437400D13"  &
      * t1 - .CONVERT."0.1799020903680D13" * t39 + .CONVERT."0.8481098545920D13" * t33 + .CONVERT."0.237233525760D12"  &
      * t53 - .CONVERT."0.19769460480D11" * t67 + .CONVERT."0.1033697280D10" * t80  &
      - .CONVERT."0.32643072D8" * t93 - .CONVERT."0.316234143225D12" + .CONVERT."0.565248D6" * t108 -  &
      .CONVERT."0.4096D4" * t125
      fm(12) = t127 * t4 / .CONVERT."0.7905853580625D13"
      t142 = t67 * t33
      t144 = -0.205552193096250D15 * t1 + .CONVERT."0.822208772385000D15" * t9 + .CONVERT."0.7905853580625D13"  &
      - .CONVERT."0.1205906199498000D16" * t16 + .CONVERT."0.861361571070000D15"  &
      * t25 - .CONVERT."0.344544628428000D15" * t33 + .CONVERT."0.83525970528000D14" * t39  &
      - .CONVERT."0.12850149312000D14" * t53 + .CONVERT."0.1285014931200D13" * t67 - .CONVERT."0.83987904000D11"  &
      * t80 + .CONVERT."0.3536332800D10" * t93 - .CONVERT."0.7905853580625D13" * t2 -  &
      .CONVERT."0.91852800D8" * t108 + .CONVERT."0.1331200D7" * t125 - .CONVERT."0.8192D4" * t142
      fm(13) = t144 * t4 / .CONVERT."0.213458046676875D15"
      t159 = t67 * t39
      t162 = .CONVERT."0.5976825306952500D16" * t1 - .CONVERT."0.25899576330127500D17" * t9 + .CONVERT."0.41439322128204000D17"  &
      * t16 - .CONVERT."0.32559467386446000D17" * t25 - .CONVERT."0.213458046676875D15"  &
      + .CONVERT."0.14470874393976000D17" * t33 - .CONVERT."0.3946602107448000D16"  &
      * t39 + .CONVERT."0.693908062848000D15" * t53 - .CONVERT."0.80955940665600D14" * t67  &
      + .CONVERT."0.6349485542400D13" * t80 - .CONVERT."0.334183449600D12" * t93 + .CONVERT."0.11573452800D11"  &
      * t108 - .CONVERT."0.251596800D9" * t125 + .CONVERT."0.3096576D7" * t142 - .CONVERT."0.16384D5"  &
      * t159 + .CONVERT."0.213458046676875D15" * t2
      fm(14) = t162 * t4 / .CONVERT."0.6190283353629375D16"
      t179 = t67 * t53
      t181 = -0.185708500608881250D18 * t1 + .CONVERT."0.866639669508112500D18" * t9  &
      + .CONVERT."0.6190283353629375D16" - .CONVERT."0.1502175427147395000D19" * t16 + .CONVERT."0.1287578937554910000D19"  &
      * t25 - .CONVERT."0.629483036137956000D18" * t33 + .CONVERT."0.190752435193320000D18"  &
      * t39 - .CONVERT."0.37731250917360000D17" * t53 - .CONVERT."0.6190283353629375D16"  &
      * t2 + .CONVERT."0.5030833455648000D16" * t67 - .CONVERT."0.460337701824000D15"  &
      * t80 + .CONVERT."0.29073960115200D14" * t93 - .CONVERT."0.1258612992000D13" * t108  &
      + .CONVERT."0.36481536000D11" * t125 - .CONVERT."0.673505280D9" * t142 + .CONVERT."0.7127040D7" * t159  &
      - .CONVERT."0.32768D5" * t179
      fm(15) = t181 * t4 / .CONVERT."0.191898783962510625D18"
      t199 = t67 ** 2
      t201 = .CONVERT."0.6140761086800340000D19" * t1 - .CONVERT."0.30703805434001700000D20" *  &
      t9 + .CONVERT."0.57313770143469840000D20" * t16 - .CONVERT."0.53219929418936280000D20" *  &
      t25 - .CONVERT."0.191898783962510625D18" + .CONVERT."0.28383962356766016000D20" * t33 -  &
      .CONVERT."0.9461320785588672000D19" * t39 + .CONVERT."0.2079411161667840000D19" * t53 -  &
      .CONVERT."0.311911674250176000D18" * t67 + .CONVERT."0.191898783962510625D18" * t2 + .CONVERT."0.32618214300672000D17"  &
      * t80 - .CONVERT."0.2403447369523200D16" * t93 + .CONVERT."0.124854408806400D15"  &
      * t108 - .CONVERT."0.4523710464000D13" * t125 + .CONVERT."0.111352872960D12"  &
      * t142 - .CONVERT."0.1767505920D10" * t159 + .CONVERT."0.16252928D8" * t179 - .CONVERT."0.65536D5"  &
      * t199
      fm(16) = t201 * t4 / .CONVERT."0.6332659870762850625D19"
      t217 = t199 * t1
      t222 = .CONVERT."0.330523607040D12" * t159 - .CONVERT."0.1326950240178811248000D22" * t33  &
      + .CONVERT."0.2296644646463327160000D22" * t25 + .CONVERT."0.1148322323231663580000D22"  &
      * t9 - .CONVERT."0.2296644646463327160000D22" * t16 - .CONVERT."0.116654966169565824000D21"  &
      * t53 + .CONVERT."0.482527360065022272000D21" * t39 + .CONVERT."0.19442494361594304000D20"  &
      * t67 - .CONVERT."0.2287352277834624000D19" * t80 + .CONVERT."0.192619139186073600D18"  &
      * t93 - .CONVERT."0.11673887223398400D17" * t108 - .CONVERT."0.15617240432640D14"  &
      * t142 + .CONVERT."0.507560314060800D15" * t125 - .CONVERT."0.4558946304D10" * t179 - .CONVERT."0.131072D6"  &
      * t217 + .CONVERT."0.36765696D8" * t199 - .CONVERT."0.6332659870762850625D19"  &
      * t2 - .CONVERT."0.215310435605936921250D21" * t1 + .CONVERT."0.6332659870762850625D19"
      fm(17) = t222 * t4 / .CONVERT."0.221643095476699771875D21"
      t242 = t199 * t9
      t244 = .CONVERT."0.7979151437161191787500D22" * t1 - .CONVERT."0.45215191477246753462500D23"  &
      * t9 + .CONVERT."0.96459075151459740720000D23" * t16 - .CONVERT."0.221643095476699771875D21"  &
      - .CONVERT."0.103349009090849722200000D24" * t25 + .CONVERT."0.64306050100973160480000D23"  &
      * t33 + .CONVERT."0.221643095476699771875D21" * t2 - .CONVERT."0.25332686403413669280000D23"  &
      * t39 + .CONVERT."0.6681148062438769920000D22" * t53 - .CONVERT."0.1224877144780441152000D22"  &
      * t67 + .CONVERT."0.160114659448423680000D21" * t80 -  &
      .CONVERT."0.15168757210903296000D20" * t93 + .CONVERT."0.1050649850105856000D19" * t108  &
      - .CONVERT."0.53293832976384000D17" * t125 + .CONVERT."0.1967772294512640D16" * t142 - .CONVERT."0.52057468108800D14"  &
      * t159 + .CONVERT."0.957378723840D12" * t179 - .CONVERT."0.11581194240D11"  &
      * t199 + .CONVERT."0.82575360D8" * t217 - .CONVERT."0.262144D6" * t242
      fm(18) = t244 * t4 / .CONVERT."0.8200794532637891559375D22"
      t265 = t199 * t16
      t268 = .CONVERT."0.8200794532637891559375D22" + .CONVERT."0.1184848479918335232000D22" *  &
      t93 - .CONVERT."0.168259310714880D15" * t179 + .CONVERT."0.5352223511771136000D19" * t125  &
      + .CONVERT."0.184287232D9" * t242 - .CONVERT."0.230557320507064320D18" * t142 + .CONVERT."0.2713859850240D13"  &
      * t199 + .CONVERT."0.7319280016097280D16" * t159 - .CONVERT."0.29025239040D11"  &
      * t217 - .CONVERT."0.524288D6" * t265 - .CONVERT."0.8200794532637891559375D22" * t2
      fm(19) = (.CONVERT."-0.311630192240239879256250D24" * t1 - .CONVERT."0.4238170614467262357885000D25"  &
      * t16 + .CONVERT."0.1869781153441439275537500D25" * t9 - .CONVERT."0.3229082372927437986960000D25"  &
      * t33 + .CONVERT."0.4843623559391156980440000D25" * t25  &
      + .CONVERT."0.1369913733969216115680000D25" * t39 - .CONVERT."0.391403923991204604480000D24"  &
      * t53 - .CONVERT."0.92325855578052096000D20" * t108 + .CONVERT."0.78280784798240920896000D23"  &
      * t67 - .CONVERT."0.11256060559224184704000D23" * t80 + t268) *  &
      t4 / .CONVERT."0.319830986772877770815625D24"
      t281 = -0.319830986772877770815625D24 + .CONVERT."0.798157021472260369920000D24"  &
      * t80 - .CONVERT."0.5088251011885659858240000D25" * t67 - .CONVERT."0.92418181433630148096000D23"  &
      * t93 + .CONVERT."0.8001574150097848320000D22" * t108 + .CONVERT."0.319830986772877770815625D24"  &
      * t2 + .CONVERT."0.25690672856501452800D20" * t142 - .CONVERT."0.521841792397685760000D21"  &
      * t125 - .CONVERT."0.529202670796800D15" * t199 + .CONVERT."0.26248452471521280D17"  &
      * t179 + .CONVERT."0.7546562150400D13" * t217
      t283 = t199 * t25
      t294 = -0.951506402092646400D18 * t159 - .CONVERT."0.1048576D7" * t283 - .CONVERT."0.236126648520318902796450000D27"  &
      * t25 + .CONVERT."0.167912283392226775321920000D27"  &
      * t33 - .CONVERT."0.81023849982462368606625000D26" * t9 + .CONVERT."0.194457239957909684655900000D27"  &
      * t16 + .CONVERT."0.12793239470915110832625000D26" * t1 - .CONVERT."0.76323765178284897873600000D26"  &
      * t39 + .CONVERT."0.23484235439472276268800000D26"  &
      * t53 + .CONVERT."0.408944640D9" * t265 - .CONVERT."0.71872020480D11" * t242
      fm(20) = (t281 + t294) * t4 / .CONVERT."0.13113070457687988603440625D26"
      t308 = .CONVERT."0.13113070457687988603440625D26" + .CONVERT."0.902823936D9" * t283 - .CONVERT."0.1624397502873600D16"  &
      * t217 - .CONVERT."0.176050667520D12" * t265 + .CONVERT."0.20627269877760D14"  &
      * t242 - .CONVERT."0.2097152D7" * t199 * t33 + .CONVERT."0.336998778556427164457280000D27"  &
      * t67 - .CONVERT."0.57267766290634681541760000D26" * t80 - .CONVERT."0.1444280479527544990531200000D28"  &
      * t53 + .CONVERT."0.4380984121233553137944640000D28"  &
      * t39 - .CONVERT."0.9035779750044203347010820000D28" * t33
      t321 = -0.550748959222895521344506250D27 * t1 - .CONVERT."0.9301537977986679916040550000D28"  &
      * t16 + .CONVERT."0.11959120257411445606337850000D29" * t25 +  &
      .CONVERT."0.3671659728152636808963375000D28" * t9 - .CONVERT."0.2764958666180968857600D22"  &
      * t142 - .CONVERT."0.688935534323424740352000D24" * t108 + .CONVERT."0.7233823110395959773696000D25"  &
      * t93 + .CONVERT."0.49922864806045271040000D23" * t125 + .CONVERT."0.117035287457395507200D21"  &
      * t159 - .CONVERT."0.3766652929663303680D19" * t179 +  &
      .CONVERT."0.91128699911208960D17" * t199 - .CONVERT."0.13113070457687988603440625D26" *  &
      t2
      fm(21) = (t308 + t321) * t4 / .CONVERT."0.563862029680583509947946875D27"

      DO i=0,21
         fm(i)=((-1)**i) * fm(i)
      ENDDO


  END SUBROUTINE cutoff_gamma_T0


  SUBROUTINE cutoff_gamma(nmax,T,R,fm)

    INTEGER, INTENT(IN)                      :: nmax
    TYPE(mpfr_type), INTENT(IN)              :: T, R
    TYPE(mpfr_type), DIMENSION(0:nmax)  :: fm
    INTEGER :: i

    TYPE(mpfr_type) :: t1,t2,t3,t5,t6,t7,t8,t13,t14,t16,t17,t18,t20,t21,t22,t24,&
        t26,t27,t29,t33,t36,t38,t41,t43,t51,t52,t53,t56,t59,t60,t62,t63,t65,&
        t68,t70,t71,t73,t84,t85,t86,t93,t94,t99,t101,t103,t105,t107,t109,t110,&
        t112,t113,t115,t116,t130,t132,t133,t143,t145,t146,t148,t149,t151,t153,&
        t155,t156,t158,t163,t165,t167,t178,t187,t189,t191,t192,t199,t209,t218,&
        t220,t225,t229,t241,t245,t247,t248,t250,t251,t253,t255,t257,t259,t261,&
        t262,t264,t267,t270,t271,t276,t277,t279,t281,t282,t284,t286,t288,t291,&
        t299,t317,t327,t330,t332,t333,t335,t340,t353,t355,t357,t360,t362,t365,&
        t366,t381,t383,t385,t393,t399,t400,t418,t443,t452,t454,t455,t457,t460,&
        t461,t463,t465,t467,t469,t471,t473,t475,t477,t479,t482,t486,t487,t501
    TYPE(mpfr_type) :: t503,t507,t509,t519,t534,t548,t563,t573,t575,t577,t579,&
        t581,t583,t585,t587,t588,t590,t592,t593,t595,t597,t599,t601,t603,t605,&
        t607,t608,t611,t625,t629,t630,t634,t636,t638,t640,t642,t644,t646,t648,&
        t649,t651,t653,t655,t657,t658,t660,t662,t663,t665,t667,t668,t670,t672,&
        t674,t676,t688,t701,t706,t723,t741,t758,t775,t792,t796,t797,t818,t821,&
        t823,t824,t826,t828,t830,t832,t834,t836,t838,t840,t842,t844,t846,t848,&
        t850,t851,t853,t855,t857,t859,t860,t862,t864,t866,t868,t882,t902,t923,&
        t942,t962,t981,t983,t987,t988,t1014,t1038,t1053,t1054,t1056,t1058,t1060,&
        t1062,t1065,t1067,t1069,t1071,t1073,t1075,t1077,t1079,t1080,t1082,t1083,&
        t1088,t1090,t1092,t1094,t1096,t1097,t1099,t1101,t1103,t1105,t1113,t1125
    TYPE(mpfr_type) :: t1134,t1141,t1154,t1166,t1191,t1204,t1215,t1217,t1222,&
        t1223,t1238,t1251,t1265,t1279,t1291,t1293,t1295,t1297,t1311,t1324,t1326,&
        t1327,t1329,t1342,t1354,t1356,t1358,t1361,t1369,t1370,t1372,t1377,t1381,&
        t1383,t1385,t1388,t1389,t1396,t1397,t1411,t1420,t1423,t1428,t1442,t1444,&
        t1457,t1462,t1464,t1466,t1469,t1471,t1473,t1475,t1476,t1478,t1480,t1485,&
        t1486,t1503,t1518,t1534,t1536,t1538,t1540,t1542,t1544,t1554,t1560,t1561,&
        t1573,t1574,t1589,t1596,t1598,t1600,t1604,t1605,t1607,t1611,t1626,t1628,&
        t1632,t1645,t1647,t1649,t1651,t1659,t1664,t1666,t1667,t1669,t1676,t1678,&
        t1684,t1686,t1689,t1694,t1706,t1721,t1723,t1725,t1726,t1735,t1742,t1758,&
        t1774,t1779,t1780,t1799,t1816,t1834,t1842,t1844,t1845,t1847,t1849,t1851
    TYPE(mpfr_type) :: t1852,t1856,t1859,t1878,t1882,t1884,t1886,t1888,t1890,&
        t1900,t1918,t1921,t1923,t1925,t1927,t1929,t1941,t1957,t1959,t1961,t1963,&
        t1965,t1966,t1983,t1999,t2002,t2004,t2006,t2008,t2010,t2012,t2024,t2043,&
        t2055,t2056,t2058,t2060,t2064,t2082,t2089,t2101,t2106,t2107,t2129,t2148,&
        t2156,t2158,t2170,t2189,t2198,t2200,t2202,t2204,t2214,t2233,t2237,t2239,&
        t2241,t2256,t2267,t2269,t2271,t2273,t2275,t2281,t2285,t2292,t2294,t2296,&
        t2297,t2299,t2301,t2303,t2305,t2312,t2329,t2331,t2332,t2334,t2337,t2339,&
        t2341,t2343,t2345,t2347,t2350,t2361,t2381,t2385,t2386,t2388,t2405,t2424,&
        t2444,t2464,t2469,t2470,t2493,t2514,t2527,t2528,t2530,t2532,t2534,t2536,&
        t2538,t2543,t2566,t2577,t2579,t2581,t2583,t2585,t2595,t2618,t2631,t2633
    TYPE(mpfr_type) :: t2635,t2637,t2645,t2647,t2650,t2652,t2667,t2672,t2684,&
        t2698,t2714,t2716,t2718,t2719,t2721,t2723,t2725,t2727,t2748,t2771,t2795,&
        t2796,t2798,t2800,t2802,t2804,t2805,t2808,t2810,t2820,t2822,t2828,t2851,&
        t2874,t2880,t2881,t2895,t2907,t2920,t2933,t2936,t2944,t2946,t2950,t2962,&
        t2968,t2970,t2972,t2977,t2979,t2983,t2985,t2987,t2988,t2990,t2996,t2998,&
        t3013,t3025,t3038,t3051,t3055,t3057,t3059,t3061,t3063,t3065,t3071,t3084,&
        t3093,t3098,t3110,t3112,t3117,t3119,t3125,t3131,t3138,t3140,t3145,t3158,&
        t3171,t3185,t3198,t3202,t3204,t3206,t3208,t3210,t3211,t3213,t3218,t3223,&
        t3224,t3226,t3234,t3249,t3261,t3274,t3287,t3297,t3302,t3315,t3327,t3329,&
        t3330,t3336,t3344,t3350,t3351,t3366,t3380,t3394,t3408,t3423,t3433,t3438
    TYPE(mpfr_type) :: t3441,t3443,t3454,t3468,t3475,t3477,t3486,t3500,t3505,&
        t3507,t3509,t3511,t3513,t3515,t3517,t3521,t3535,t3550,t3551,t3565,t3571,&
        t3580,t3582,t3596,t3609,t3614,t3628,t3636,t3643,t3657,t3668,t3670,t3672,&
        t3674,t3676,t3677,t3679,t3681,t3683,t3691,t3693,t3696,t3710,t3711,t3725,&
        t3741,t3743,t3745,t3747,t3749,t3750,t3752,t3754,t3756,t3758,t3759,t3761,&
        t3762,t3767,t3781,t3786,t3788,t3797,t3812,t3826,t3841,t3855,t3861,t3862,&
        t3879,t3894,t3910,t3925,t3941,t3956,t3972,t3975,t3977,t3979,t3981,t3983,&
        t3985,t3987,t3994,t4011,t4026,t4042,t4044,t4045,t4059,t4066,t4077,t4092,&
        t4108,t4114,t4124,t4142,t4157,t4171,t4173,t4175,t4176,t4191,t4206,t4208,&
        t4210,t4211,t4226,t4242,t4257,t4267,t4269,t4271,t4272,t4274,t4276,t4277
    TYPE(mpfr_type) :: t4279,t4281,t4283,t4284,t4286,t4288,t4290,t4292,t4294,&
        t4296,t4298,t4300,t4307,t4316,t4318,t4325,t4332,t4341,t4358,t4373,t4386,&
        t4388,t4390,t4392,t4393,t4395,t4397,t4410,t4416,t4417,t4436,t4454,t4471,&
        t4487,t4506,t4522,t4539,t4556,t4575,t4591,t4608,t4625,t4643,t4659,t4676,&
        t4693,t4713,t4729,t4746,t4762,t4781,t4797,t4814,t4837,t4865,t4882,t4899,&
        t4916,t4934,t4945,t4956,t4988,t5010,pi

    REAL(dp) :: tt2, tt3, tt5, tt6, tt7,tt8

      ! XXXXXXXXXXXX fast fake function for testing XXXXXXXXXX
      ! fm=1/(R+T+10)
      ! RETURN
  
      pi = get_pi()
      t1 = sqrt(pi)
      t2 = sqrt(T)
      t3 = erf(t2)
      t5 = R - t2
      t6 = erf(t5)
      t7 = R + t2
      t8 = erf(t7)
      
      fm(0) =  t1 * (2 * t3 + t6 - t8) / t2 / .CONVERT."0.4E1"
      t13 = exp(-T)
      t14 = t2 * t13
      t16 = t5 ** 2
      t17 = exp(-t16)
      t18 = t2 * t17
      t20 = t7 ** 2
      t21 = exp(-t20)
      t22 = t2 * t21
      t24 = t1 * t3
      t26 = t1 * t6
      t27 = t1 * t8
      t29 = t2 * T
      fm(1) =  -(.CONVERT."-0.4E1" * t14 + .CONVERT."0.2E1" * t18 + .CONVERT."0.2E1" * t22 + .CONVERT."0.2E1" * t24 + t26  &
      - t27) / t29 / .CONVERT."0.8E1"
      t33 = t29 * t13
      t36 = T * t17 * R
      t38 = t29 * t17
      t41 = T * t21 * R
      t43 = t29 * t21
      t51 =  .CONVERT."-0.8E1" * t33 - .CONVERT."0.4E1" * t36 + .CONVERT."0.4E1" * t38 + .CONVERT."0.4E1" * t41 + .CONVERT."0.4E1"  &
      * t43 - .CONVERT."0.12E2" * t14 + .CONVERT."0.6E1" * t18 + .CONVERT."0.6E1" * t22 + .CONVERT."0.6E1" * t24 +  &
      .CONVERT."0.3E1" * t26 - .CONVERT."0.3E1" * t27
      t52 = T ** 2
      t53 = t2 * t52
      fm(2) =  t51 / t53 / .CONVERT."0.16E2"
      t56 = t53 * t13
      t59 = R ** 2
      t60 = t38 * t59
      t62 = t52 * t17
      t63 = t62 * R
      t65 = t53 * t17
      t68 = t43 * t59
      t70 = t52 * t21
      t71 = t70 * R
      t73 = t53 * t21
      t84 =  .CONVERT."-0.16E2" * t56 - .CONVERT."0.24E2" * t36 + .CONVERT."0.8E1" * t60 - .CONVERT."0.16E2" * t63 + .CONVERT."0.8E1"  &
      * t65 + .CONVERT."0.24E2" * t41 + .CONVERT."0.8E1" * t68 + .CONVERT."0.16E2" * t71 + .CONVERT."0.8E1" * t73  &
      - .CONVERT."0.40E2" * t33 + .CONVERT."0.20E2" * t38 + .CONVERT."0.20E2" * t43 - .CONVERT."0.60E2" * t14 + .CONVERT."0.30E2"  &
      * t18 + .CONVERT."0.30E2" * t22 + .CONVERT."0.30E2" * t24 + .CONVERT."0.15E2" * t26 - .CONVERT."0.15E2"  &
      * t27
      t85 = t52 * T
      t86 = t2 * t85
      fm(3) =  -t84 / t86 / .CONVERT."0.32E2"
      t93 = t59 * R
      t94 = t62 * t93
      t99 = t86 * t17
      t101 = t86 * t21
      t103 = t86 * t13
      t105 = t70 * t93
      t107 = t73 * t59
      t109 = t85 * t21
      t110 = t109 * R
      t112 = .CONVERT."0.210E3" * t22 + .CONVERT."0.210E3" * t24 - .CONVERT."0.105E3" * t27 - .CONVERT."0.16E2" * t94  &
      - .CONVERT."0.280E3" * t33 - .CONVERT."0.180E3" * t36 + .CONVERT."0.180E3" * t41 + .CONVERT."0.16E2" * t99 +  &
      .CONVERT."0.16E2" * t101 - .CONVERT."0.32E2" * t103 + .CONVERT."0.16E2" * t105 + .CONVERT."0.48E2" * t107 + .CONVERT."0.48E2"  &
      * t110
      t113 = t65 * t59
      t115 = t85 * t17
      t116 = t115 * R
      t130 = .CONVERT."0.48E2" * t113 - .CONVERT."0.48E2" * t116 + .CONVERT."0.140E3" * t38 + .CONVERT."0.80E2" * t60  &
      - .CONVERT."0.136E3" * t63 + .CONVERT."0.80E2" * t68 + .CONVERT."0.136E3" * t71 + .CONVERT."0.140E3" * t43 -  &
      .CONVERT."0.420E3" * t14 + .CONVERT."0.210E3" * t18 + .CONVERT."0.105E3" * t26 - .CONVERT."0.112E3" * t56 + .CONVERT."0.56E2"  &
      * t65 + .CONVERT."0.56E2" * t73
      t132 = t52 ** 2
      t133 = t2 * t132
      fm(4) =  (t112 + t130) / t133 / .CONVERT."0.64E2"
      t143 = t109 * t93
      t145 = t132 * t21
      t146 = t145 * R
      t148 = t132 * t17
      t149 = t148 * R
      t151 = t101 * t59
      t153 = t99 * t59
      t155 = t59 ** 2
      t156 = t73 * t155
      t158 = t65 * t155
      t163 = t133 * t21
      t165 = t133 * t17
      t167 = .CONVERT."0.1890E4" * t22 + .CONVERT."0.1890E4" * t24 - .CONVERT."0.945E3" * t27 - .CONVERT."0.240E3" *  &
      t94 - .CONVERT."0.2520E4" * t33 - .CONVERT."0.1680E4" * t36 + .CONVERT."0.1680E4" * t41 + .CONVERT."0.128E3" *  &
      t143 + .CONVERT."0.128E3" * t146 - .CONVERT."0.128E3" * t149 + .CONVERT."0.192E3" * t151 + .CONVERT."0.192E3"  &
      * t153 + .CONVERT."0.32E2" * t156 + .CONVERT."0.32E2" * t158 + .CONVERT."0.144E3" * t99 + .CONVERT."0.144E3"  &
      * t101 - .CONVERT."0.288E3" * t103 + .CONVERT."0.32E2" * t163 + .CONVERT."0.32E2" * t165
      t178 = t133 * t13
      t187 = t115 * t93
      t189 = .CONVERT."0.240E3" * t105 + .CONVERT."0.624E3" * t107 + .CONVERT."0.528E3" * t110 + .CONVERT."0.624E3" *  &
      t113 - .CONVERT."0.528E3" * t116 + .CONVERT."0.1260E4" * t38 + .CONVERT."0.840E3" * t60 - .CONVERT."0.1320E4"  &
      * t63 + .CONVERT."0.840E3" * t68 + .CONVERT."0.1320E4" * t71 - .CONVERT."0.64E2" * t178 + .CONVERT."0.1260E4"  &
      * t43 - .CONVERT."0.3780E4" * t14 + .CONVERT."0.1890E4" * t18 + .CONVERT."0.945E3" * t26 - .CONVERT."0.1008E4"  &
      * t56 + .CONVERT."0.504E3" * t65 + .CONVERT."0.504E3" * t73 - .CONVERT."0.128E3" * t187
      t191 = t132 * T
      t192 = t2 * t191
      fm(5) =  -(t167 + t189) / t192 / .CONVERT."0.128E3"
      t199 = t148 * t93
      t209 = .CONVERT."0.20790E5" * t22 + .CONVERT."0.20790E5" * t24 - .CONVERT."0.10395E5" * t27 - .CONVERT."0.640E3"  &
      * t199 - .CONVERT."0.3360E4" * t94 - .CONVERT."0.27720E5" * t33 - .CONVERT."0.18900E5" * t36 + .CONVERT."0.18900E5"  &
      * t41 + .CONVERT."0.2368E4" * t143 + .CONVERT."0.1728E4" * t146 - .CONVERT."0.1728E4" * t149  &
      + .CONVERT."0.3072E4" * t151
      t218 = t192 * t17
      t220 = t192 * t13
      t225 = .CONVERT."0.3072E4" * t153 + .CONVERT."0.672E3" * t156 + .CONVERT."0.672E3" * t158 + .CONVERT."0.1584E4"  &
      * t99 + .CONVERT."0.1584E4" * t101 - .CONVERT."0.3168E4" * t103 + .CONVERT."0.352E3" * t163 + .CONVERT."0.352E3"  &
      * t165 + .CONVERT."0.64E2" * t218 - .CONVERT."0.128E3" * t220 + .CONVERT."0.3360E4" * t105 + .CONVERT."0.8064E4"  &
      * t107 + .CONVERT."0.6288E4" * t110
      t229 = t192 * t21
      t241 = .CONVERT."0.8064E4" * t113 - .CONVERT."0.6288E4" * t116 + .CONVERT."0.64E2" * t229 + .CONVERT."0.13860E5"  &
      * t38 + .CONVERT."0.10080E5" * t60 - .CONVERT."0.15120E5" * t63 + .CONVERT."0.10080E5" * t68 + .CONVERT."0.15120E5"  &
      * t71 - .CONVERT."0.704E3" * t178 + .CONVERT."0.13860E5" * t43 - .CONVERT."0.41580E5" * t14  &
      + .CONVERT."0.20790E5" * t18 + .CONVERT."0.10395E5" * t26
      t245 = t145 * t93
      t247 = t191 * t21
      t248 = t247 * R
      t250 = t191 * t17
      t251 = t250 * R
      t253 = t99 * t155
      t255 = t163 * t59
      t257 = t101 * t155
      t259 = t165 * t59
      t261 = t155 * R
      t262 = t115 * t261
      t264 = t109 * t261
      t267 =  .CONVERT."-0.11088E5" * t56 + .CONVERT."0.5544E4" * t65 + .CONVERT."0.5544E4" * t73 + .CONVERT."0.640E3"  &
      * t245 + .CONVERT."0.320E3" * t248 - .CONVERT."0.320E3" * t251 + .CONVERT."0.320E3" * t253 + .CONVERT."0.640E3"  &
      * t255 + .CONVERT."0.320E3" * t257 + .CONVERT."0.640E3" * t259 - .CONVERT."0.64E2" * t262 + .CONVERT."0.64E2"  &
      * t264 - .CONVERT."0.2368E4" * t187
      t270 = t132 * t52
      t271 = t2 * t270
      fm(6) =  (t209 + t225 + t241 + t267) / t271 / .CONVERT."0.256E3"
      t276 = t270 * t17
      t277 = t276 * R
      t279 = t247 * t93
      t281 = t270 * t21
      t282 = t281 * R
      t284 = t218 * t59
      t286 = t145 * t261
      t288 = t250 * t93
      t291 = t271 * t21
      t299 = .CONVERT."0.270270E6" * t22 + .CONVERT."0.270270E6" * t24 - .CONVERT."0.768E3" * t277 + .CONVERT."0.2560E4"  &
      * t279 + .CONVERT."0.768E3" * t282 + .CONVERT."0.1920E4" * t284 + .CONVERT."0.768E3" * t286 - .CONVERT."0.2560E4"  &
      * t288 - .CONVERT."0.135135E6" * t27 + .CONVERT."0.128E3" * t291 - .CONVERT."0.14080E5" * t199  &
      - .CONVERT."0.50400E5" * t94 - .CONVERT."0.360360E6" * t33 - .CONVERT."0.249480E6" * t36 + .CONVERT."0.249480E6"  &
      * t41 + .CONVERT."0.39424E5" * t143
      t317 = .CONVERT."0.24384E5" * t146 - .CONVERT."0.24384E5" * t149 + .CONVERT."0.47136E5" * t151 + .CONVERT."0.47136E5"  &
      * t153 + .CONVERT."0.12096E5" * t156 + .CONVERT."0.12096E5" * t158 + .CONVERT."0.20592E5" *  &
      t99 + .CONVERT."0.20592E5" * t101 - .CONVERT."0.41184E5" * t103 + .CONVERT."0.4576E4" * t163 + .CONVERT."0.4576E4"  &
      * t165 + .CONVERT."0.832E3" * t218 - .CONVERT."0.1664E4" * t220 + .CONVERT."0.50400E5" * t105  &
      + .CONVERT."0.114912E6" * t107 + .CONVERT."0.85344E5" * t110 + .CONVERT."0.114912E6" * t113
      t327 = t271 * t13
      t330 = t229 * t59
      t332 = t155 * t59
      t333 = t99 * t332
      t335 = t101 * t332
      t340 =  .CONVERT."-0.85344E5" * t116 + .CONVERT."0.832E3" * t229 + .CONVERT."0.180180E6" * t38 + .CONVERT."0.138600E6"  &
      * t60 - .CONVERT."0.201600E6" * t63 + .CONVERT."0.138600E6" * t68 + .CONVERT."0.201600E6" *  &
      t71 - .CONVERT."0.9152E4" * t178 - .CONVERT."0.256E3" * t327 + .CONVERT."0.180180E6" * t43 + .CONVERT."0.1920E4"  &
      * t330 + .CONVERT."0.128E3" * t333 + .CONVERT."0.128E3" * t335 - .CONVERT."0.540540E6" * t14 + .CONVERT."0.270270E6"  &
      * t18 + .CONVERT."0.135135E6" * t26
      t353 = t148 * t261
      t355 = t165 * t155
      t357 = t271 * t17
      t360 = t163 * t155
      t362 =  .CONVERT."-0.144144E6" * t56 + .CONVERT."0.72072E5" * t65 + .CONVERT."0.72072E5" * t73 + .CONVERT."0.14080E5"  &
      * t245 + .CONVERT."0.5120E4" * t248 - .CONVERT."0.5120E4" * t251 + .CONVERT."0.8000E4" * t253  &
      + .CONVERT."0.12160E5" * t255 + .CONVERT."0.8000E4" * t257 + .CONVERT."0.12160E5" * t259 - .CONVERT."0.1792E4"  &
      * t262 + .CONVERT."0.1792E4" * t264 - .CONVERT."0.768E3" * t353 + .CONVERT."0.1920E4" * t355 + .CONVERT."0.128E3"  &
      * t357 - .CONVERT."0.39424E5" * t187 + .CONVERT."0.1920E4" * t360
      t365 = t132 * t85
      t366 = t2 * t365
      fm(7) =  -(t299 + t317 + t340 + t362) / t366 / .CONVERT."0.512E3"
      t381 = t366 * t21
      t383 = t366 * t13
      t385 = t366 * t17
      t393 = .CONVERT."0.4054050E7" * t22 + .CONVERT."0.4054050E7" * t24 - .CONVERT."0.14208E5" * t277 + .CONVERT."0.65280E5"  &
      * t279 + .CONVERT."0.14208E5" * t282 + .CONVERT."0.42240E5" * t284 + .CONVERT."0.24960E5"  &
      * t286 - .CONVERT."0.65280E5" * t288 - .CONVERT."0.2027025E7" * t27 + .CONVERT."0.1920E4" * t291 -  &
      .CONVERT."0.271680E6" * t199 + .CONVERT."0.256E3" * t381 - .CONVERT."0.512E3" * t383 + .CONVERT."0.256E3" * t385  &
      - .CONVERT."0.831600E6" * t94 - .CONVERT."0.5405400E7" * t33 - .CONVERT."0.3783780E7" * t36 + .CONVERT."0.3783780E7"  &
      * t41 + .CONVERT."0.685440E6" * t143 + .CONVERT."0.382560E6" * t146
      t399 = t155 * t93
      t400 = t145 * t399
      t418 = .CONVERT."0.68640E5" * t165 + .CONVERT."0.12480E5" * t218 - .CONVERT."0.24960E5" * t220 + .CONVERT."0.831600E6"  &
      * t105 + .CONVERT."0.1829520E7" * t107 + .CONVERT."0.1315440E7" * t110 + .CONVERT."0.1829520E7"  &
      * t113 - .CONVERT."0.1315440E7" * t116 + .CONVERT."0.12480E5" * t229 + .CONVERT."0.2702700E7"  &
      * t38 + .CONVERT."0.2162160E7" * t60
      t443 = .CONVERT."0.4054050E7" * t18 + .CONVERT."0.2027025E7" * t26 - .CONVERT."0.2162160E7" * t56 +  &
      .CONVERT."0.1081080E7" * t65 + .CONVERT."0.1081080E7" * t73 + .CONVERT."0.271680E6" * t245 + .CONVERT."0.83520E5"  &
      * t248 - .CONVERT."0.83520E5" * t251 + .CONVERT."0.167040E6" * t253 + .CONVERT."0.216000E6" * t255  &
      + .CONVERT."0.167040E6" * t257
      t452 = t250 * t261
      t454 = t365 * t17
      t455 = t454 * R
      t457 = t281 * t93
      t460 = t365 * t21
      t461 = t460 * R
      t463 = t247 * t261
      t465 = t276 * t93
      t467 = t218 * t155
      t469 = t165 * t332
      t471 = t163 * t332
      t473 = t229 * t155
      t475 = t357 * t59
      t477 = t291 * t59
      t479 = t148 * t399
      t482 = .CONVERT."0.1792E4" * t461 + .CONVERT."0.5376E4" * t463 - .CONVERT."0.8960E4" * t465 + .CONVERT."0.8960E4"  &
      * t467 + .CONVERT."0.1792E4" * t469 + .CONVERT."0.1792E4" * t471 + .CONVERT."0.8960E4" * t473 +  &
      .CONVERT."0.5376E4" * t475 + .CONVERT."0.5376E4" * t477 - .CONVERT."0.256E3" * t479 + .CONVERT."0.55680E5" * t360
      t486 = t132 ** 2
      t487 = t2 * t486
      fm(8) =  (.CONVERT."0.308880E6" * t99 - .CONVERT."0.8108100E7" * t14 + .CONVERT."0.2702700E7" * t43 -  &
      .CONVERT."0.3076920E7" * t63 + .CONVERT."0.221760E6" * t158 - .CONVERT."0.685440E6" * t187 + .CONVERT."0.308880E6"  &
      * t101 + .CONVERT."0.2162160E7" * t68 + t482 + .CONVERT."0.3076920E7" * t71 - .CONVERT."0.5376E4"  &
      * t452 - .CONVERT."0.3840E4" * t327 + .CONVERT."0.68640E5" * t163 + t393 - .CONVERT."0.617760E6"  &
      * t103 + .CONVERT."0.42240E5" * t330 - .CONVERT."0.1792E4" * t455 + .CONVERT."0.4608E4" * t333 +  &
      .CONVERT."0.4608E4" * t335 + .CONVERT."0.8960E4" * t457 + .CONVERT."0.216000E6" * t259 + t418 - .CONVERT."0.382560E6"  &
      * t149 + t443 + .CONVERT."0.777600E6" * t151 - .CONVERT."0.40320E5" * t262 - .CONVERT."0.24960E5"  &
      * t353 - .CONVERT."0.137280E6" * t178 + .CONVERT."0.55680E5" * t355 + .CONVERT."0.40320E5" *  &
      t264 + .CONVERT."0.1920E4" * t357 + .CONVERT."0.777600E6" * t153 + .CONVERT."0.256E3" * t400 + .CONVERT."0.221760E6"  &
      * t156) / t487 / .CONVERT."0.1024E4"
      t501 = t385 * t59
      t503 = .CONVERT."0.68918850E8" * t22 + .CONVERT."0.68918850E8" * t24 - .CONVERT."0.263040E6" * t277  &
      + .CONVERT."0.1432320E7" * t279 + .CONVERT."0.263040E6" * t282 + .CONVERT."0.852480E6" * t284 + .CONVERT."0.639360E6"  &
      * t286 - .CONVERT."0.1432320E7" * t288 - .CONVERT."0.34459425E8" * t27 + .CONVERT."0.32640E5"  &
      * t291 - .CONVERT."0.5371200E7" * t199 + .CONVERT."0.14336E5" * t501
      t507 = t487 * t17
      t509 = t487 * t21
      t519 = .CONVERT."0.4352E4" * t381 - .CONVERT."0.8704E4" * t383 + .CONVERT."0.4352E4" * t385 + .CONVERT."0.512E3"  &
      * t507 + .CONVERT."0.512E3" * t509 - .CONVERT."0.15135120E8" * t94 - .CONVERT."0.91891800E8" * t33  &
      - .CONVERT."0.64864800E8" * t36 + .CONVERT."0.64864800E8" * t41 + .CONVERT."0.12862080E8" * t143  &
      + .CONVERT."0.6691680E7" * t146 - .CONVERT."0.6691680E7" * t149 + .CONVERT."0.14065920E8" * t151
      t534 = .CONVERT."0.14065920E8" * t153 + .CONVERT."0.4324320E7" * t156 + .CONVERT."0.4324320E7" * t158  &
      + .CONVERT."0.11520E5" * t400 + .CONVERT."0.5250960E7" * t99 + .CONVERT."0.5250960E7" * t101 - .CONVERT."0.10501920E8"  &
      * t103 + .CONVERT."0.1166880E7" * t163 + .CONVERT."0.1166880E7" * t165 + .CONVERT."0.212160E6"  &
      * t218 - .CONVERT."0.424320E6" * t220 + .CONVERT."0.15135120E8" * t105 + .CONVERT."0.32432400E8"  &
      * t107
      t548 = .CONVERT."0.22785840E8" * t110 + .CONVERT."0.32432400E8" * t113 - .CONVERT."0.22785840E8" * t116  &
      + .CONVERT."0.212160E6" * t229 + .CONVERT."0.45945900E8" * t38 + .CONVERT."0.37837800E8" * t60  &
      - .CONVERT."0.52972920E8" * t63 + .CONVERT."0.37837800E8" * t68 + .CONVERT."0.52972920E8" * t71 - .CONVERT."0.2333760E7"  &
      * t178 - .CONVERT."0.65280E5" * t327 + .CONVERT."0.45945900E8" * t43 + .CONVERT."0.852480E6"  &
      * t330
      t563 = .CONVERT."0.126720E6" * t333 + .CONVERT."0.126720E6" * t335 - .CONVERT."0.137837700E9" * t14  &
      + .CONVERT."0.68918850E8" * t18 + .CONVERT."0.34459425E8" * t26 - .CONVERT."0.36756720E8" * t56 + .CONVERT."0.18378360E8"  &
      * t65 + .CONVERT."0.18378360E8" * t73 + .CONVERT."0.5371200E7" * t245 + .CONVERT."0.1487040E7"  &
      * t248 - .CONVERT."0.1487040E7" * t251 + .CONVERT."0.3484800E7" * t253
      t573 = t487 * t13
      t575 = t460 * t93
      t577 = t281 * t261
      t579 = t454 * t93
      t581 = .CONVERT."0.4048320E7" * t255 + .CONVERT."0.3484800E7" * t257 + .CONVERT."0.4048320E7" * t259  &
      - .CONVERT."0.887040E6" * t262 + .CONVERT."0.887040E6" * t264 - .CONVERT."0.639360E6" * t353 + .CONVERT."0.1322880E7"  &
      * t355 + .CONVERT."0.32640E5" * t357 - .CONVERT."0.12862080E8" * t187 - .CONVERT."0.1024E4"  &
      * t573 + .CONVERT."0.28672E5" * t575 + .CONVERT."0.28672E5" * t577 - .CONVERT."0.28672E5" * t579
      t583 = t357 * t155
      t585 = t381 * t59
      t587 = t486 * t21
      t588 = t587 * R
      t590 = t291 * t155
      t592 = t155 ** 2
      t593 = t165 * t592
      t595 = t250 * t399
      t597 = t163 * t592
      t599 = t247 * t399
      t601 = t218 * t332
      t603 = t229 * t332
      t605 = t276 * t261
      t607 = t486 * t17
      t608 = t607 * R
      t611 = .CONVERT."0.35840E5" * t583 + .CONVERT."0.14336E5" * t585 + .CONVERT."0.4096E4" * t588 + .CONVERT."0.35840E5"  &
      * t590 + .CONVERT."0.512E3" * t593 - .CONVERT."0.4096E4" * t595 + .CONVERT."0.512E3" * t597 +  &
      .CONVERT."0.4096E4" * t599 + .CONVERT."0.14336E5" * t601 + .CONVERT."0.14336E5" * t603 - .CONVERT."0.28672E5"  &
      * t605 - .CONVERT."0.4096E4" * t608 - .CONVERT."0.198912E6" * t452
      t625 =  .CONVERT."-0.37632E5" * t455 + .CONVERT."0.259840E6" * t457 + .CONVERT."0.37632E5" * t461 + .CONVERT."0.198912E6"  &
      * t463 - .CONVERT."0.259840E6" * t465 + .CONVERT."0.295680E6" * t467 + .CONVERT."0.73472E5"  &
      * t469 + .CONVERT."0.73472E5" * t471 + .CONVERT."0.295680E6" * t473 + .CONVERT."0.134400E6" * t475  &
      + .CONVERT."0.134400E6" * t477 - .CONVERT."0.11520E5" * t479 + .CONVERT."0.1322880E7" * t360
      t629 = t486 * T
      t630 = t2 * t629
      fm(9) =  -(t503 + t519 + t534 + t548 + t563 + t581 + t611 + t625) / t630  &
      / .CONVERT."0.2048E4"
      t634 = t630 * t17
      t636 = t630 * t21
      t638 = t357 * t332
      t640 = t218 * t592
      t642 = t630 * t13
      t644 = t385 * t155
      t646 = t381 * t155
      t648 = t592 * R
      t649 = t250 * t648
      t651 = t247 * t648
      t653 = t607 * t93
      t655 = t460 * t261
      t657 = t629 * t21
      t658 = t657 * R
      t660 = t587 * t93
      t662 = t629 * t17
      t663 = t662 * R
      t665 = t454 * t261
      t667 = .CONVERT."0.1024E4" * t634 + .CONVERT."0.1024E4" * t636 + .CONVERT."0.86016E5" * t638 + .CONVERT."0.9216E4"  &
      * t640 - .CONVERT."0.2048E4" * t642 + .CONVERT."0.129024E6" * t644 + .CONVERT."0.129024E6" * t646  &
      - .CONVERT."0.1024E4" * t649 + .CONVERT."0.1024E4" * t651 - .CONVERT."0.86016E5" * t653 + .CONVERT."0.129024E6"  &
      * t655 + .CONVERT."0.9216E4" * t658 + .CONVERT."0.86016E5" * t660 - .CONVERT."0.9216E4" * t663  &
      - .CONVERT."0.129024E6" * t665
      t668 = t281 * t399
      t670 = t276 * t399
      t672 = t509 * t59
      t674 = t291 * t332
      t676 = t229 * t592
      t688 = .CONVERT."0.36864E5" * t668 - .CONVERT."0.36864E5" * t670 + .CONVERT."0.36864E5" * t672 + .CONVERT."0.86016E5"  &
      * t674 + .CONVERT."0.9216E4" * t676 + .CONVERT."0.1309458150E10" * t22 + .CONVERT."0.1309458150E10"  &
      * t24 - .CONVERT."0.5239680E7" * t277 + .CONVERT."0.31729920E8" * t279 + .CONVERT."0.5239680E7"  &
      * t282 + .CONVERT."0.17890560E8" * t284 + .CONVERT."0.15776640E8" * t286 - .CONVERT."0.31729920E8"  &
      * t288 - .CONVERT."0.654729075E9" * t27 + .CONVERT."0.620160E6" * t291
      t701 = t507 * t59
      t706 =  .CONVERT."-0.112939200E9" * t199 + .CONVERT."0.401408E6" * t501 + .CONVERT."0.82688E5" * t381  &
      - .CONVERT."0.165376E6" * t383 + .CONVERT."0.82688E5" * t385 + .CONVERT."0.9728E4" * t507 + .CONVERT."0.9728E4"  &
      * t509 - .CONVERT."0.302702400E9" * t94 - .CONVERT."0.1745944200E10" * t33 - .CONVERT."0.1240539300E10"  &
      * t36 + .CONVERT."0.1240539300E10" * t41 + .CONVERT."0.36864E5" * t701 + .CONVERT."0.262342080E9"  &
      * t143 + .CONVERT."0.129682080E9" * t146 - .CONVERT."0.129682080E9" * t149
      t723 = .CONVERT."0.279227520E9" * t151 + .CONVERT."0.279227520E9" * t153 + .CONVERT."0.90810720E8" *  &
      t156 + .CONVERT."0.90810720E8" * t158 + .CONVERT."0.380160E6" * t400 + .CONVERT."0.99768240E8" * t99  &
      + .CONVERT."0.99768240E8" * t101 - .CONVERT."0.199536480E9" * t103 + .CONVERT."0.22170720E8" * t163  &
      + .CONVERT."0.22170720E8" * t165 + .CONVERT."0.4031040E7" * t218 - .CONVERT."0.8062080E7" * t220  &
      + .CONVERT."0.302702400E9" * t105 + .CONVERT."0.635675040E9" * t107 + .CONVERT."0.438918480E9" *  &
      t110 + .CONVERT."0.635675040E9" * t113
      t741 =  .CONVERT."-0.438918480E9" * t116 + .CONVERT."0.4031040E7" * t229 + .CONVERT."0.872972100E9" *  &
      t38 + .CONVERT."0.735134400E9" * t60 - .CONVERT."0.1016215200E10" * t63 + .CONVERT."0.735134400E9"  &
      * t68 + .CONVERT."0.1016215200E10" * t71 - .CONVERT."0.44341440E8" * t178 - .CONVERT."0.1240320E7"  &
      * t327 + .CONVERT."0.872972100E9" * t43 + .CONVERT."0.17890560E8" * t330 + .CONVERT."0.3294720E7"  &
      * t333 + .CONVERT."0.3294720E7" * t335 - .CONVERT."0.2618916300E10" * t14 + .CONVERT."0.1309458150E10"  &
      * t18
      t758 = .CONVERT."0.654729075E9" * t26 - .CONVERT."0.698377680E9" * t56 + .CONVERT."0.349188840E9" *  &
      t65 + .CONVERT."0.349188840E9" * t73 + .CONVERT."0.112939200E9" * t245 + .CONVERT."0.29100480E8" *  &
      t248 - .CONVERT."0.29100480E8" * t251 + .CONVERT."0.76190400E8" * t253 + .CONVERT."0.81998400E8" *  &
      t255 + .CONVERT."0.76190400E8" * t257 + .CONVERT."0.81998400E8" * t259 - .CONVERT."0.20180160E8" *  &
      t262 + .CONVERT."0.20180160E8" * t264 - .CONVERT."0.15776640E8" * t353 + .CONVERT."0.30940800E8" *  &
      t355 + .CONVERT."0.620160E6" * t357
      t775 =  .CONVERT."-0.262342080E9" * t187 - .CONVERT."0.19456E5" * t573 + .CONVERT."0.931840E6" * t575  &
      + .CONVERT."0.1189888E7" * t577 - .CONVERT."0.931840E6" * t579 + .CONVERT."0.1326080E7" * t583 + .CONVERT."0.401408E6"  &
      * t585 + .CONVERT."0.96256E5" * t588 + .CONVERT."0.1326080E7" * t590 + .CONVERT."0.28160E5"  &
      * t593 - .CONVERT."0.206848E6" * t595 + .CONVERT."0.28160E5" * t597 + .CONVERT."0.206848E6" * t599  &
      + .CONVERT."0.659456E6" * t601 + .CONVERT."0.659456E6" * t603
      t792 =  .CONVERT."-0.1189888E7" * t605 - .CONVERT."0.96256E5" * t608 - .CONVERT."0.5714688E7" * t452  &
      - .CONVERT."0.779520E6" * t455 + .CONVERT."0.6388480E7" * t457 + .CONVERT."0.779520E6" * t461 + .CONVERT."0.5714688E7"  &
      * t463 - .CONVERT."0.6388480E7" * t465 + .CONVERT."0.7875840E7" * t467 + .CONVERT."0.2266880E7"  &
      * t469 + .CONVERT."0.2266880E7" * t471 + .CONVERT."0.7875840E7" * t473 + .CONVERT."0.3037440E7"  &
      * t475 + .CONVERT."0.3037440E7" * t477 - .CONVERT."0.380160E6" * t479 + .CONVERT."0.30940800E8"  &
      * t360
      t796 = t486 * t52
      t797 = t2 * t796
      fm(10) =  (t667 + t688 + t706 + t723 + t741 + t758 + t775 + t792) / t797  &
      / .CONVERT."0.4096E4"
      t818 = .CONVERT."0.21504E5" * t634 + .CONVERT."0.21504E5" * t636 + .CONVERT."0.4386816E7" * t638 + .CONVERT."0.562176E6"  &
      * t640 - .CONVERT."0.43008E5" * t642 + .CONVERT."0.5289984E7" * t644 + .CONVERT."0.5289984E7"  &
      * t646 - .CONVERT."0.67584E5" * t649 + .CONVERT."0.67584E5" * t651 - .CONVERT."0.3096576E7" *  &
      t653 + .CONVERT."0.5935104E7" * t655 + .CONVERT."0.239616E6" * t658 + .CONVERT."0.3096576E7" * t660  &
      - .CONVERT."0.239616E6" * t663 - .CONVERT."0.5935104E7" * t665 + .CONVERT."0.2064384E7" * t668 - .CONVERT."0.2064384E7"  &
      * t670 + .CONVERT."0.1142784E7" * t672
      t821 = t657 * t93
      t823 = t796 * t21
      t824 = t823 * R
      t826 = t662 * t93
      t828 = t381 * t332
      t830 = t636 * t59
      t832 = t291 * t592
      t834 = t509 * t155
      t836 = t507 * t155
      t838 = t385 * t332
      t840 = t587 * t261
      t842 = t357 * t592
      t844 = t634 * t59
      t846 = t797 * t21
      t848 = t797 * t17
      t850 = t796 * t17
      t851 = t850 * R
      t853 = t607 * t261
      t855 = .CONVERT."0.4386816E7" * t674 + .CONVERT."0.562176E6" * t676 + .CONVERT."0.245760E6" * t821 +  &
      .CONVERT."0.20480E5" * t824 - .CONVERT."0.245760E6" * t826 + .CONVERT."0.430080E6" * t828 + .CONVERT."0.92160E5"  &
      * t830 + .CONVERT."0.92160E5" * t832 + .CONVERT."0.430080E6" * t834 + .CONVERT."0.430080E6" * t836  &
      + .CONVERT."0.430080E6" * t838 + .CONVERT."0.516096E6" * t840 + .CONVERT."0.92160E5" * t842 + .CONVERT."0.92160E5"  &
      * t844 + .CONVERT."0.2048E4" * t846 + .CONVERT."0.2048E4" * t848 - .CONVERT."0.20480E5" *  &
      t851 - .CONVERT."0.516096E6" * t853
      t857 = t276 * t648
      t859 = t592 * t59
      t860 = t218 * t859
      t862 = t281 * t648
      t864 = t229 * t859
      t866 = t460 * t399
      t868 = t454 * t399
      t882 =  .CONVERT."-0.20480E5" * t857 + .CONVERT."0.2048E4" * t860 + .CONVERT."0.20480E5" * t862 + .CONVERT."0.2048E4"  &
      * t864 + .CONVERT."0.245760E6" * t866 - .CONVERT."0.245760E6" * t868 + .CONVERT."0.27498621150E11"  &
      * t22 + .CONVERT."0.27498621150E11" * t24 - .CONVERT."0.113420160E9" * t277 + .CONVERT."0.738904320E9"  &
      * t279 + .CONVERT."0.113420160E9" * t282 + .CONVERT."0.401103360E9" * t284 + .CONVERT."0.397837440E9"  &
      * t286 - .CONVERT."0.738904320E9" * t288 - .CONVERT."0.13749310575E11" * t27  &
      + .CONVERT."0.13023360E8" * t291 - .CONVERT."0.2551348800E10" * t199 + .CONVERT."0.10042368E8" *  &
      t501
      t902 = .CONVERT."0.1736448E7" * t381 - .CONVERT."0.3472896E7" * t383 + .CONVERT."0.1736448E7" * t385  &
      + .CONVERT."0.204288E6" * t507 + .CONVERT."0.204288E6" * t509 - .CONVERT."0.6616209600E10" * t94 -  &
      .CONVERT."0.36664828200E11" * t33 - .CONVERT."0.26189163000E11" * t36 + .CONVERT."0.26189163000E11"  &
      * t41 + .CONVERT."0.1142784E7" * t701 + .CONVERT."0.5811886080E10" * t143 + .CONVERT."0.2763240480E10"  &
      * t146 - .CONVERT."0.2763240480E10" * t149 + .CONVERT."0.6058372320E10" * t151 + .CONVERT."0.6058372320E10"  &
      * t153 + .CONVERT."0.2058376320E10" * t156 + .CONVERT."0.2058376320E10" *  &
      t158 + .CONVERT."0.11531520E8" * t400 + .CONVERT."0.2095133040E10" * t99
      t923 = .CONVERT."0.2095133040E10" * t101 - .CONVERT."0.4190266080E10" * t103 + .CONVERT."0.465585120E9"  &
      * t163 + .CONVERT."0.465585120E9" * t165 + .CONVERT."0.84651840E8" * t218 - .CONVERT."0.169303680E9"  &
      * t220 + .CONVERT."0.6616209600E10" * t105 + .CONVERT."0.13673499840E11" * t107 +  &
      .CONVERT."0.9314585280E10" * t110 + .CONVERT."0.13673499840E11" * t113 - .CONVERT."0.9314585280E10"  &
      * t116 + .CONVERT."0.84651840E8" * t229 + .CONVERT."0.18332414100E11" * t38 + .CONVERT."0.15713497800E11"  &
      * t60 - .CONVERT."0.21502681200E11" * t63 + .CONVERT."0.15713497800E11" * t68 +  &
      .CONVERT."0.21502681200E11" * t71 - .CONVERT."0.931170240E9" * t178
      t942 =  .CONVERT."-0.26046720E8" * t327 + .CONVERT."0.18332414100E11" * t43 + .CONVERT."0.401103360E9"  &
      * t330 + .CONVERT."0.86486400E8" * t333 + .CONVERT."0.86486400E8" * t335 - .CONVERT."0.54997242300E11"  &
      * t14 + .CONVERT."0.27498621150E11" * t18 + .CONVERT."0.13749310575E11" * t26 - .CONVERT."0.14665931280E11"  &
      * t56 + .CONVERT."0.7332965640E10" * t65 + .CONVERT."0.7332965640E10" * t73  &
      + .CONVERT."0.2551348800E10" * t245 + .CONVERT."0.623810880E9" * t248 - .CONVERT."0.623810880E9"  &
      * t251 + .CONVERT."0.1772971200E10" * t253 + .CONVERT."0.1801800000E10" * t255 + .CONVERT."0.1772971200E10"  &
      * t257 + .CONVERT."0.1801800000E10" * t259
      t962 =  .CONVERT."-0.484323840E9" * t262 + .CONVERT."0.484323840E9" * t264 - .CONVERT."0.397837440E9"  &
      * t353 + .CONVERT."0.749548800E9" * t355 + .CONVERT."0.13023360E8" * t357 - .CONVERT."0.5811886080E10"  &
      * t187 - .CONVERT."0.408576E6" * t573 + .CONVERT."0.25374720E8" * t575 + .CONVERT."0.37890048E8"  &
      * t577 - .CONVERT."0.25374720E8" * t579 + .CONVERT."0.39137280E8" * t583 + .CONVERT."0.10042368E8"  &
      * t585 + .CONVERT."0.2205696E7" * t588 + .CONVERT."0.39137280E8" * t590 + .CONVERT."0.1098240E7"  &
      * t593 - .CONVERT."0.7569408E7" * t595 + .CONVERT."0.1098240E7" * t597 + .CONVERT."0.7569408E7" *  &
      t599
      t981 = t797 * t13
      t983 = .CONVERT."0.22557696E8" * t601 + .CONVERT."0.22557696E8" * t603 - .CONVERT."0.37890048E8" * t605  &
      - .CONVERT."0.2205696E7" * t608 - .CONVERT."0.156296448E9" * t452 - .CONVERT."0.17176320E8" * t455  &
      + .CONVERT."0.156737280E9" * t457 + .CONVERT."0.17176320E8" * t461 + .CONVERT."0.156296448E9" *  &
      t463 - .CONVERT."0.156737280E9" * t465 + .CONVERT."0.204099840E9" * t467 + .CONVERT."0.65345280E8"  &
      * t469 + .CONVERT."0.65345280E8" * t471 + .CONVERT."0.204099840E9" * t473 + .CONVERT."0.70560000E8"  &
      * t475 + .CONVERT."0.70560000E8" * t477 - .CONVERT."0.11531520E8" * t479 + .CONVERT."0.749548800E9"  &
      * t360 - .CONVERT."0.4096E4" * t981
      t987 = t486 * t85
      t988 = t2 * t987
      fm(11) =  -(t818 + t855 + t882 + t902 + t923 + t942 + t962 + t983) /  &
      t988 / .CONVERT."0.8192E4"
      t1014 = .CONVERT."0.207470592E9" * t655 + .CONVERT."0.6018048E7" * t658 + .CONVERT."0.92510208E8" *  &
      t660 - .CONVERT."0.6018048E7" * t663 - .CONVERT."0.207470592E9" * t665 + .CONVERT."0.82962432E8" *  &
      t668 - .CONVERT."0.82962432E8" * t670 + .CONVERT."0.31352832E8" * t672 + .CONVERT."0.164763648E9" *  &
      t674 + .CONVERT."0.24081408E8" * t676 + .CONVERT."0.9707520E7" * t821
      t1038 = .CONVERT."0.3133440E7" * t844 + .CONVERT."0.47104E5" * t846 + .CONVERT."0.47104E5" * t848 -  &
      .CONVERT."0.583680E6" * t851 - .CONVERT."0.26062848E8" * t853 - .CONVERT."0.1484800E7" * t857 + .CONVERT."0.159744E6"  &
      * t860 + .CONVERT."0.1484800E7" * t862 + .CONVERT."0.159744E6" * t864 + .CONVERT."0.15114240E8"  &
      * t866 - .CONVERT."0.15114240E8" * t868
      t1053 = t987 * t21
      t1054 = t1053 * R
      t1056 = t454 * t648
      t1058 = t850 * t93
      t1060 = t657 * t261
      t1062 = t823 * t93
      t1065 = t460 * t648
      t1067 = t357 * t859
      t1069 = t634 * t155
      t1071 = t662 * t261
      t1073 =  .CONVERT."-0.62010748800E11" * t199 + .CONVERT."0.45056E5" * t1054 - .CONVERT."0.225280E6" *  &
      t1056 - .CONVERT."0.675840E6" * t1058 + .CONVERT."0.1892352E7" * t1060 + .CONVERT."0.675840E6" * t1062  &
      + .CONVERT."0.255811584E9" * t501 + .CONVERT."0.225280E6" * t1065 + .CONVERT."0.45056E5" * t1067  &
      + .CONVERT."0.1351680E7" * t1069 - .CONVERT."0.1892352E7" * t1071
      t1075 = t507 * t332
      t1077 = t636 * t155
      t1079 = t987 * t17
      t1080 = t1079 * R
      t1082 = t592 * t93
      t1083 = t276 * t1082
      t1088 = t385 * t592
      t1090 = t587 * t399
      t1092 = t848 * t59
      t1094 = t281 * t1082
      t1096 = .CONVERT."0.1892352E7" * t1075 + .CONVERT."0.1351680E7" * t1077 - .CONVERT."0.45056E5" * t1080  &
      - .CONVERT."0.4096E4" * t1083 + .CONVERT."0.39938304E8" * t381 - .CONVERT."0.79876608E8" * t383  &
      + .CONVERT."0.39938304E8" * t385 + .CONVERT."0.675840E6" * t1088 + .CONVERT."0.1351680E7" * t1090 +  &
      .CONVERT."0.225280E6" * t1092 + .CONVERT."0.4096E4" * t1094
      t1097 = t607 * t399
      t1099 = t846 * t59
      t1101 = t291 * t859
      t1103 = t509 * t332
      t1105 = t381 * t592
      t1113 =  .CONVERT."-0.1351680E7" * t1097 + .CONVERT."0.225280E6" * t1099 + .CONVERT."0.45056E5" * t1101  &
      + .CONVERT."0.1892352E7" * t1103 + .CONVERT."0.675840E6" * t1105 + .CONVERT."0.4698624E7" * t507  &
      + .CONVERT."0.4698624E7" * t509 - .CONVERT."0.157134978000E12" * t94 - .CONVERT."0.843291048600E12"  &
      * t33 - .CONVERT."0.604969665300E12" * t36 + .CONVERT."0.604969665300E12" * t41
      t1125 = t988 * t21
      t1134 = t988 * t13
      t1141 = .CONVERT."0.48188059920E11" * t99 + .CONVERT."0.48188059920E11" * t101 - .CONVERT."0.96376119840E11"  &
      * t103 + .CONVERT."0.10708457760E11" * t163 + .CONVERT."0.10708457760E11" * t165  &
      - .CONVERT."0.8192E4" * t1134 + .CONVERT."0.1946992320E10" * t218 - .CONVERT."0.3893984640E10" *  &
      t220 + .CONVERT."0.157134978000E12" * t105 + .CONVERT."0.320555355120E12" * t107 + .CONVERT."0.216019243440E12"  &
      * t110
      t1154 = .CONVERT."0.320555355120E12" * t113 - .CONVERT."0.216019243440E12" * t116 + .CONVERT."0.1946992320E10"  &
      * t229 + .CONVERT."0.421645524300E12" * t38 + .CONVERT."0.366648282000E12" *  &
      t60 - .CONVERT."0.497594097000E12" * t63 + .CONVERT."0.366648282000E12" * t68 + .CONVERT."0.497594097000E12"  &
      * t71 - .CONVERT."0.21416915520E11" * t178 - .CONVERT."0.599074560E9" * t327 +  &
      .CONVERT."0.421645524300E12" * t43
      t1166 = .CONVERT."0.9664462080E10" * t330 + .CONVERT."0.2352430080E10" * t333 + .CONVERT."0.2352430080E10"  &
      * t335 - .CONVERT."0.1264936572900E13" * t14 + .CONVERT."0.632468286450E12" * t18  &
      + .CONVERT."0.316234143225E12" * t26 - .CONVERT."0.337316419440E12" * t56 + .CONVERT."0.168658209720E12"  &
      * t65 + .CONVERT."0.168658209720E12" * t73 + .CONVERT."0.62010748800E11" * t245 +  &
      .CONVERT."0.14567192640E11" * t248
      t1191 =  .CONVERT."-0.139381482240E12" * t187 - .CONVERT."0.9397248E7" * t573 + .CONVERT."0.682967040E9"  &
      * t575 + .CONVERT."0.1137583104E10" * t577 - .CONVERT."0.682967040E9" * t579 + .CONVERT."0.1113047040E10"  &
      * t583 + .CONVERT."0.255811584E9" * t585 + .CONVERT."0.53265408E8" * t588 + .CONVERT."0.1113047040E10"  &
      * t590 + .CONVERT."0.38438400E8" * t593 - .CONVERT."0.252155904E9" * t595
      t1204 = .CONVERT."0.38438400E8" * t597 + .CONVERT."0.252155904E9" * t599 + .CONVERT."0.713975808E9"  &
      * t601 + .CONVERT."0.713975808E9" * t603 - .CONVERT."0.1137583104E10" * t605 - .CONVERT."0.53265408E8"  &
      * t608 - .CONVERT."0.4326626304E10" * t452 - .CONVERT."0.407473920E9" * t455 + .CONVERT."0.4004125440E10"  &
      * t457 + .CONVERT."0.407473920E9" * t461 + .CONVERT."0.4326626304E10" * t463
      t1215 = t988 * t17
      t1217 =  .CONVERT."-0.4004125440E10" * t465 + .CONVERT."0.5426104320E10" * t467 + .CONVERT."0.1883481600E10"  &
      * t469 + .CONVERT."0.1883481600E10" * t471 + .CONVERT."0.5426104320E10" * t473 +  &
      .CONVERT."0.1734647040E10" * t475 + .CONVERT."0.1734647040E10" * t477 - .CONVERT."0.345945600E9" *  &
      t479 + .CONVERT."0.19142323200E11" * t360 - .CONVERT."0.94208E5" * t981 + .CONVERT."0.4096E4" * t1215
      t1222 = t486 * t132
      t1223 = t2 * t1222
      fm(12) =  (.CONVERT."0.3075072E7" * t651 + .CONVERT."0.583680E6" * t824 + .CONVERT."0.50283192960E11"  &
      * t158 - .CONVERT."0.92510208E8" * t653 - .CONVERT."0.9707520E7" * t826 + .CONVERT."0.494592E6" * t634  &
      + .CONVERT."0.4096E4" * t1125 + .CONVERT."0.24084480E8" * t828 + .CONVERT."0.494592E6" * t636 +  &
      .CONVERT."0.3133440E7" * t830 + t1096 + t1113 + t1014 + t1141 + .CONVERT."0.164763648E9"  &
      * t638 + .CONVERT."0.632468286450E12" * t22 + .CONVERT."0.6174720E7" * t832 + .CONVERT."0.139381482240E12"  &
      * t143 + t1073 - .CONVERT."0.14567192640E11" * t251 + .CONVERT."0.632468286450E12"  &
      * t24 + .CONVERT."0.19353600E8" * t834 + .CONVERT."0.24081408E8" * t640 + .CONVERT."0.44108064000E11"  &
      * t253 + .CONVERT."0.64268043840E11" * t146 + .CONVERT."0.19353600E8" * t836 + t1166  &
      + .CONVERT."0.42868425600E11" * t255 - .CONVERT."0.2664547200E10" * t277 + .CONVERT."0.24084480E8"  &
      * t838 - .CONVERT."0.316234143225E12" * t27 - .CONVERT."0.989184E6" * t642 + .CONVERT."0.44108064000E11"  &
      * t257 + .CONVERT."0.26062848E8" * t840 + .CONVERT."0.18312053760E11" * t279  &
      + t1038 + .CONVERT."0.6174720E7" * t842 + .CONVERT."0.42868425600E11" * t259 + t1191 + .CONVERT."0.31352832E8"  &
      * t701 + t1154 + .CONVERT."0.2664547200E10" * t282 - .CONVERT."0.64268043840E11"  &
      * t149 + t1217 + .CONVERT."0.171343872E9" * t644 + .CONVERT."0.9664462080E10" * t284  &
      + .CONVERT."0.142910127360E12" * t151 - .CONVERT."0.12350257920E11" * t262 + .CONVERT."0.171343872E9"  &
      * t646 - .CONVERT."0.10482151680E11" * t353 + .CONVERT."0.10482151680E11" * t286 +  &
      .CONVERT."0.19142323200E11" * t355 + .CONVERT."0.12350257920E11" * t264 + .CONVERT."0.299537280E9"  &
      * t357 + .CONVERT."0.142910127360E12" * t153 - .CONVERT."0.18312053760E11" * t288 + t1204  &
      - .CONVERT."0.3075072E7" * t649 + .CONVERT."0.299537280E9" * t291 + .CONVERT."0.345945600E9" * t400  &
      + .CONVERT."0.50283192960E11" * t156) / t1223 / .CONVERT."0.16384E5"
      t1238 =  .CONVERT."-0.12364800E8" * t634 - .CONVERT."0.12364800E8" * t636 - .CONVERT."0.5680281600E10"  &
      * t638 - .CONVERT."0.918328320E9" * t640 + .CONVERT."0.24729600E8" * t642 - .CONVERT."0.5305466880E10"  &
      * t644 - .CONVERT."0.5305466880E10" * t646 + .CONVERT."0.123002880E9" * t649 - .CONVERT."0.123002880E9"  &
      * t651 + .CONVERT."0.2710149120E10" * t653 - .CONVERT."0.6783436800E10" * t655  &
      - .CONVERT."0.158054400E9" * t658
      t1251 =  .CONVERT."-0.2710149120E10" * t660 + .CONVERT."0.158054400E9" * t663 + .CONVERT."0.6783436800E10"  &
      * t665 - .CONVERT."0.3010775040E10" * t668 + .CONVERT."0.3010775040E10" * t670 - .CONVERT."0.868976640E9"  &
      * t672 - .CONVERT."0.5680281600E10" * t674 - .CONVERT."0.918328320E9" * t676  &
      - .CONVERT."0.315678720E9" * t821 - .CONVERT."0.15943680E8" * t824 + .CONVERT."0.315678720E9" * t826  &
      - .CONVERT."0.985313280E9" * t828
      t1265 =  .CONVERT."-0.93542400E8" * t830 - .CONVERT."0.288184320E9" * t832 - .CONVERT."0.682536960E9"  &
      * t834 - .CONVERT."0.682536960E9" * t836 - .CONVERT."0.985313280E9" * t838 - .CONVERT."0.992194560E9"  &
      * t840 - .CONVERT."0.288184320E9" * t842 - .CONVERT."0.93542400E8" * t844 - .CONVERT."0.1177600E7"  &
      * t846 - .CONVERT."0.1177600E7" * t848 + .CONVERT."0.15943680E8" * t851 + .CONVERT."0.992194560E9"  &
      * t853
      t1279 = .CONVERT."0.73615360E8" * t857 - .CONVERT."0.8386560E7" * t860 - .CONVERT."0.73615360E8" * t862  &
      - .CONVERT."0.8386560E7" * t864 - .CONVERT."0.661708800E9" * t866 + .CONVERT."0.661708800E9" *  &
      t868 - .CONVERT."0.15811707161250E14" * t22 - .CONVERT."0.15811707161250E14" * t24 + .CONVERT."0.67667483520E11"  &
      * t277 - .CONVERT."0.484439155200E12" * t279 - .CONVERT."0.67667483520E11"  &
      * t282 - .CONVERT."0.250173705600E12" * t284 - .CONVERT."0.291113222400E12" * t286
      t1291 = t460 * t1082
      t1293 = t657 * t399
      t1295 = t385 * t859
      t1297 = .CONVERT."0.484439155200E12" * t288 + .CONVERT."0.7905853580625E13" * t27 - .CONVERT."0.7488432000E10"  &
      * t291 + .CONVERT."0.1618765948800E13" * t199 - .CONVERT."0.1396736E7" * t1054  &
      + .CONVERT."0.17797120E8" * t1056 + .CONVERT."0.29061120E8" * t1058 - .CONVERT."0.104079360E9" *  &
      t1060 - .CONVERT."0.29061120E8" * t1062 - .CONVERT."0.98304E5" * t1291 - .CONVERT."0.6488064E7" * t1293  &
      - .CONVERT."0.540672E6" * t1295
      t1311 =  .CONVERT."-0.6842357760E10" * t501 - .CONVERT."0.17797120E8" * t1065 - .CONVERT."0.3829760E7"  &
      * t1067 - .CONVERT."0.66232320E8" * t1069 + .CONVERT."0.104079360E9" * t1071 - .CONVERT."0.115433472E9"  &
      * t1075 - .CONVERT."0.66232320E8" * t1077 + .CONVERT."0.1396736E7" * t1080 + .CONVERT."0.372736E6"  &
      * t1083 - .CONVERT."0.998457600E9" * t381 + .CONVERT."0.1996915200E10" * t383 - .CONVERT."0.998457600E9"  &
      * t385 - .CONVERT."0.49336320E8" * t1088
      t1324 = t509 * t592
      t1326 =  .CONVERT."-0.90562560E8" * t1090 - .CONVERT."0.8335360E7" * t1092 - .CONVERT."0.372736E6" *  &
      t1094 + .CONVERT."0.90562560E8" * t1097 - .CONVERT."0.8335360E7" * t1099 - .CONVERT."0.3829760E7" *  &
      t1101 - .CONVERT."0.115433472E9" * t1103 - .CONVERT."0.49336320E8" * t1105 - .CONVERT."0.117465600E9"  &
      * t507 - .CONVERT."0.117465600E9" * t509 + .CONVERT."0.4033131102000E13" * t94 - .CONVERT."0.4055040E7"  &
      * t1324
      t1327 = t636 * t332
      t1329 = t846 * t155
      t1342 =  .CONVERT."-0.7569408E7" * t1327 - .CONVERT."0.4055040E7" * t1329 + .CONVERT."0.21082276215000E14"  &
      * t33 + .CONVERT."0.15179238874800E14" * t36 - .CONVERT."0.15179238874800E14" * t41  &
      - .CONVERT."0.868976640E9" * t701 - .CONVERT."0.3603628828800E13" * t143 - .CONVERT."0.1620971352000E13"  &
      * t146 + .CONVERT."0.1620971352000E13" * t149 - .CONVERT."0.3645531489600E13" *  &
      t151 - .CONVERT."0.3645531489600E13" * t153 - .CONVERT."0.1319933815200E13" * t156 - .CONVERT."0.1319933815200E13"  &
      * t158
      t1354 = t848 * t155
      t1356 = t1215 * t59
      t1358 = t507 * t592
      t1361 =  .CONVERT."-0.102400E6" * t1125 - .CONVERT."0.10585935360E11" * t400 - .CONVERT."0.1204701498000E13"  &
      * t99 - .CONVERT."0.1204701498000E13" * t101 + .CONVERT."0.2409402996000E13" * t103  &
      - .CONVERT."0.267711444000E12" * t163 - .CONVERT."0.267711444000E12" * t165 + .CONVERT."0.204800E6"  &
      * t1134 - .CONVERT."0.4055040E7" * t1354 - .CONVERT."0.540672E6" * t1356 - .CONVERT."0.4055040E7"  &
      * t1358 - .CONVERT."0.48674808000E11" * t218
      t1369 = t592 * t155
      t1370 = t357 * t1369
      t1372 = t291 * t1369
      t1377 = .CONVERT."0.97349616000E11" * t220 - .CONVERT."0.4033131102000E13" * t105 - .CONVERT."0.8139591860400E13"  &
      * t107 - .CONVERT."0.5436870238800E13" * t110 - .CONVERT."0.8139591860400E13"  &
      * t113 + .CONVERT."0.5436870238800E13" * t116 - .CONVERT."0.48674808000E11" * t229 -  &
      .CONVERT."0.8192E4" * t1370 - .CONVERT."0.8192E4" * t1372 - .CONVERT."0.10541138107500E14" * t38 -  &
      .CONVERT."0.9276201534600E13" * t60 + .CONVERT."0.12502706416200E14" * t63
      t1381 = t587 * t648
      t1383 = t850 * t261
      t1385 = t662 * t399
      t1388 = t1222 * t21
      t1389 = t1388 * R
      t1396 =  .CONVERT."-0.9276201534600E13" * t68 - .CONVERT."0.12502706416200E14" * t71 - .CONVERT."0.1802240E7"  &
      * t1381 + .CONVERT."0.6488064E7" * t1383 + .CONVERT."0.6488064E7" * t1385 + .CONVERT."0.535422888000E12"  &
      * t178 - .CONVERT."0.98304E5" * t1389 + .CONVERT."0.14976864000E11" * t327  &
      - .CONVERT."0.10541138107500E14" * t43 - .CONVERT."0.250173705600E12" * t330 - .CONVERT."0.67044257280E11"  &
      * t333 - .CONVERT."0.67044257280E11" * t335
      t1397 = t634 * t332
      t1411 =  .CONVERT."-0.7569408E7" * t1397 + .CONVERT."0.31623414322500E14" * t14 - .CONVERT."0.15811707161250E14"  &
      * t18 - .CONVERT."0.7905853580625E13" * t26 + .CONVERT."0.8432910486000E13"  &
      * t56 - .CONVERT."0.4216455243000E13" * t65 - .CONVERT."0.4216455243000E13" * t73 - .CONVERT."0.1618765948800E13"  &
      * t245 - .CONVERT."0.368460892800E12" * t248 + .CONVERT."0.368460892800E12"  &
      * t251 - .CONVERT."0.1173274502400E13" * t253 - .CONVERT."0.1100251152000E13" * t255  &
      - .CONVERT."0.1173274502400E13" * t257
      t1420 = t1223 * t17
      t1423 = t1223 * t21
      t1428 =  .CONVERT."-0.1100251152000E13" * t259 + .CONVERT."0.335221286400E12" * t262 - .CONVERT."0.335221286400E12"  &
      * t264 + .CONVERT."0.291113222400E12" * t353 - .CONVERT."0.518514796800E12"  &
      * t355 - .CONVERT."0.7488432000E10" * t357 - .CONVERT."0.8192E4" * t1420 + .CONVERT."0.3603628828800E13"  &
      * t187 - .CONVERT."0.8192E4" * t1423 + .CONVERT."0.234931200E9" * t573 - .CONVERT."0.18990182400E11"  &
      * t575 - .CONVERT."0.34294041600E11" * t577
      t1442 = .CONVERT."0.18990182400E11" * t579 - .CONVERT."0.32217024000E11" * t583 - .CONVERT."0.6842357760E10"  &
      * t585 - .CONVERT."0.1374213120E10" * t588 - .CONVERT."0.32217024000E11" * t590  &
      - .CONVERT."0.1306905600E10" * t593 + .CONVERT."0.8241192960E10" * t595 - .CONVERT."0.1306905600E10"  &
      * t597 - .CONVERT."0.8241192960E10" * t599 - .CONVERT."0.22415877120E11" * t601 - .CONVERT."0.22415877120E11"  &
      * t603 + .CONVERT."0.34294041600E11" * t605 + .CONVERT."0.1374213120E10" *  &
      t608
      t1444 = t1223 * t13
      t1457 = .CONVERT."0.16384E5" * t1444 + .CONVERT."0.124148344320E12" * t452 + .CONVERT."0.10410382080E11"  &
      * t455 - .CONVERT."0.108006662400E12" * t457 - .CONVERT."0.10410382080E11" * t461 -  &
      .CONVERT."0.124148344320E12" * t463 + .CONVERT."0.108006662400E12" * t465 - .CONVERT."0.150874214400E12"  &
      * t467 - .CONVERT."0.55804869120E11" * t469 - .CONVERT."0.55804869120E11" * t471  &
      - .CONVERT."0.150874214400E12" * t473 - .CONVERT."0.45473783040E11" * t475
      t1462 = t381 * t859
      t1464 = t607 * t648
      t1466 = t1079 * t93
      t1469 = t454 * t1082
      t1471 = t1053 * t93
      t1473 = t823 * t261
      t1475 = t1222 * t17
      t1476 = t1475 * R
      t1478 = t1125 * t59
      t1480 =  .CONVERT."-0.45473783040E11" * t477 + .CONVERT."0.10585935360E11" * t479 - .CONVERT."0.518514796800E12"  &
      * t360 + .CONVERT."0.2355200E7" * t981 - .CONVERT."0.540672E6" * t1462 + .CONVERT."0.1802240E7"  &
      * t1464 + .CONVERT."0.1802240E7" * t1466 - .CONVERT."0.102400E6" * t1215 + .CONVERT."0.98304E5"  &
      * t1469 - .CONVERT."0.1802240E7" * t1471 - .CONVERT."0.6488064E7" * t1473 + .CONVERT."0.98304E5"  &
      * t1476 - .CONVERT."0.540672E6" * t1478
      t1485 = t486 * t191
      t1486 = t2 * t1485
      fm(13) =  (t1238 + t1251 + t1265 + t1279 + t1297 + t1311 + t1326 + t1342  &
      + t1361 + t1377 + t1396 + t1411 + t1428 + t1442 + t1457 + t1480)  &
      / t1486 / .CONVERT."0.32768E5"
      t1503 = .CONVERT."0.333849600E9" * t634 + .CONVERT."0.333849600E9" * t636 + .CONVERT."0.192943779840E12"  &
      * t638 + .CONVERT."0.33789450240E11" * t640 - .CONVERT."0.667699200E9" * t642 + .CONVERT."0.166080015360E12"  &
      * t644 + .CONVERT."0.166080015360E12" * t646 - .CONVERT."0.4704860160E10"  &
      * t649 + .CONVERT."0.4704860160E10" * t651 - .CONVERT."0.81476720640E11" * t653 + .CONVERT."0.221206809600E12"  &
      * t655 + .CONVERT."0.4405847040E10" * t658 + .CONVERT."0.81476720640E11" *  &
      t660 - .CONVERT."0.4405847040E10" * t663
      t1518 =  .CONVERT."-0.221206809600E12" * t665 + .CONVERT."0.106475765760E12" * t668 - .CONVERT."0.106475765760E12"  &
      * t670 + .CONVERT."0.25122908160E11" * t672 + .CONVERT."0.192943779840E12"  &
      * t674 + .CONVERT."0.33789450240E11" * t676 + .CONVERT."0.9999360000E10" * t821 + .CONVERT."0.452444160E9"  &
      * t824 - .CONVERT."0.9999360000E10" * t826 + .CONVERT."0.36751196160E11" * t828  &
      + .CONVERT."0.2802401280E10" * t830 + .CONVERT."0.11892787200E11" * t832 + .CONVERT."0.22856601600E11"  &
      * t834 + .CONVERT."0.22856601600E11" * t836
      t1534 = .CONVERT."0.36751196160E11" * t838 + .CONVERT."0.35091947520E11" * t840 + .CONVERT."0.11892787200E11"  &
      * t842 + .CONVERT."0.2802401280E10" * t844 + .CONVERT."0.31795200E8" * t846 +  &
      .CONVERT."0.31795200E8" * t848 - .CONVERT."0.452444160E9" * t851 - .CONVERT."0.35091947520E11" * t853  &
      - .CONVERT."0.3186892800E10" * t857 + .CONVERT."0.380190720E9" * t860 + .CONVERT."0.3186892800E10"  &
      * t862 + .CONVERT."0.380190720E9" * t864 + .CONVERT."0.25984327680E11" * t866 - .CONVERT."0.25984327680E11"  &
      * t868
      t1536 = t1420 * t59
      t1538 = t381 * t1369
      t1540 = t385 * t1369
      t1542 = t657 * t648
      t1544 = t1475 * t93
      t1554 = .CONVERT."0.426916093353750E15" * t22 + .CONVERT."0.1277952E7" * t1536 + .CONVERT."0.212992E6"  &
      * t1538 + .CONVERT."0.212992E6" * t1540 + .CONVERT."0.11714560E8" * t1542 - .CONVERT."0.4685824E7"  &
      * t1544 + .CONVERT."0.426916093353750E15" * t24 - .CONVERT."0.1849283654400E13" * t277  &
      + .CONVERT."0.13673499840000E14" * t279 + .CONVERT."0.1849283654400E13" * t282 + .CONVERT."0.6940203379200E13"  &
      * t284 + .CONVERT."0.8548142803200E13" * t286 - .CONVERT."0.13673499840000E14"  &
      * t288 - .CONVERT."0.213458046676875E15" * t27
      t1560 = t1485 * t21
      t1561 = t1560 * R
      t1573 = .CONVERT."0.202187664000E12" * t291 - .CONVERT."0.45254873664000E14" * t199 + .CONVERT."0.41226240E8"  &
      * t1054 + .CONVERT."0.212992E6" * t1561 - .CONVERT."0.954961920E9" * t1056 - .CONVERT."0.1021870080E10"  &
      * t1058 + .CONVERT."0.4286177280E10" * t1060 + .CONVERT."0.1021870080E10"  &
      * t1062 + .CONVERT."0.9682944E7" * t1291 + .CONVERT."0.470384640E9" * t1293 + .CONVERT."0.49741824E8"  &
      * t1295 + .CONVERT."0.193876623360E12" * t501 + .CONVERT."0.954961920E9" * t1065 + .CONVERT."0.217620480E9"  &
      * t1067
      t1574 = t848 * t332
      t1589 = .CONVERT."0.28114944E8" * t1574 + .CONVERT."0.2526289920E10" * t1069 - .CONVERT."0.4286177280E10"  &
      * t1071 + .CONVERT."0.5109350400E10" * t1075 + .CONVERT."0.2526289920E10" * t1077  &
      - .CONVERT."0.41226240E8" * t1080 - .CONVERT."0.22364160E8" * t1083 + .CONVERT."0.26958355200E11" *  &
      t381 - .CONVERT."0.53916710400E11" * t383 + .CONVERT."0.26958355200E11" * t385 + .CONVERT."0.2491822080E10"  &
      * t1088 + .CONVERT."0.4290232320E10" * t1090 + .CONVERT."0.268984320E9" * t1092  &
      + .CONVERT."0.22364160E8" * t1094
      t1596 = t509 * t859
      t1598 = t1423 * t59
      t1600 = t634 * t592
      t1604 = t592 * t261
      t1605 = t460 * t1604
      t1607 = t454 * t1604
      t1611 =  .CONVERT."-0.4290232320E10" * t1097 + .CONVERT."0.268984320E9" * t1099 + .CONVERT."0.217620480E9"  &
      * t1101 + .CONVERT."0.5109350400E10" * t1103 + .CONVERT."0.2491822080E10" * t1105  &
      + .CONVERT."0.4685824E7" * t1596 + .CONVERT."0.1277952E7" * t1598 + .CONVERT."0.21086208E8" * t1600  &
      + .CONVERT."0.3171571200E10" * t507 + .CONVERT."0.3171571200E10" * t509 + .CONVERT."0.16384E5" * t1605  &
      - .CONVERT."0.16384E5" * t1607 - .CONVERT."0.111314418415200E15" * t94 + .CONVERT."0.320348160E9"  &
      * t1324
      t1626 = t1125 * t155
      t1628 = .CONVERT."0.499580928E9" * t1327 + .CONVERT."0.214917120E9" * t1329 - .CONVERT."0.569221457805000E15"  &
      * t33 - .CONVERT."0.411104386192500E15" * t36 + .CONVERT."0.411104386192500E15"  &
      * t41 + .CONVERT."0.25122908160E11" * t701 + .CONVERT."0.100021651329600E15" * t143 +  &
      .CONVERT."0.44081599161600E14" * t146 - .CONVERT."0.44081599161600E14" * t149 + .CONVERT."0.100063553990400E15"  &
      * t151 + .CONVERT."0.100063553990400E15" * t153 + .CONVERT."0.37104806138400E14"  &
      * t156 + .CONVERT."0.37104806138400E14" * t158 + .CONVERT."0.2764800E7" * t1125 +  &
      .CONVERT."0.11714560E8" * t1626
      t1632 = t1215 * t155
      t1645 = t850 * t399
      t1647 = t662 * t648
      t1649 = .CONVERT."0.11714560E8" * t1632 + .CONVERT."0.335221286400E12" * t400 + .CONVERT."0.32526940446000E14"  &
      * t99 + .CONVERT."0.32526940446000E14" * t101 - .CONVERT."0.65053880892000E14"  &
      * t103 + .CONVERT."0.7228208988000E13" * t163 + .CONVERT."0.7228208988000E13" * t165 -  &
      .CONVERT."0.5529600E7" * t1134 + .CONVERT."0.214917120E9" * t1354 + .CONVERT."0.21626880E8" * t1356  &
      + .CONVERT."0.320348160E9" * t1358 + .CONVERT."0.1314219816000E13" * t218 - .CONVERT."0.28114944E8"  &
      * t1645 - .CONVERT."0.11714560E8" * t1647
      t1651 = t846 * t332
      t1659 = t1486 * t13
      t1664 = t1053 * t261
      t1666 = t1485 * t17
      t1667 = t1666 * R
      t1669 =  .CONVERT."-0.2628439632000E13" * t220 + .CONVERT."0.28114944E8" * t1651 + .CONVERT."0.111314418415200E15"  &
      * t105 + .CONVERT."0.222628836830400E15" * t107 + .CONVERT."0.147612598333200E15"  &
      * t110 + .CONVERT."0.222628836830400E15" * t113 - .CONVERT."0.147612598333200E15"  &
      * t116 + .CONVERT."0.1314219816000E13" * t229 - .CONVERT."0.32768E5" * t1659 + .CONVERT."0.860160E6"  &
      * t1370 + .CONVERT."0.860160E6" * t1372 + .CONVERT."0.284610728902500E15" * t38 + .CONVERT."0.21086208E8"  &
      * t1664 - .CONVERT."0.212992E6" * t1667
      t1676 = t636 * t592
      t1678 = t507 * t859
      t1684 = t1079 * t261
      t1686 = t1388 * t93
      t1689 = .CONVERT."0.252987314580000E15" * t60 - .CONVERT."0.339003001537200E15" * t63 + .CONVERT."0.252987314580000E15"  &
      * t68 + .CONVERT."0.339003001537200E15" * t71 + .CONVERT."0.154091520E9"  &
      * t1381 + .CONVERT."0.21086208E8" * t1676 + .CONVERT."0.4685824E7" * t1678 - .CONVERT."0.386039808E9"  &
      * t1383 - .CONVERT."0.470384640E9" * t1385 - .CONVERT."0.14456417976000E14" * t178  &
      + .CONVERT."0.3293184E7" * t1389 - .CONVERT."0.21086208E8" * t1684 + .CONVERT."0.4685824E7" * t1686  &
      - .CONVERT."0.404375328000E12" * t327
      t1694 = t1486 * t21
      t1706 = .CONVERT."0.284610728902500E15" * t43 + .CONVERT."0.6940203379200E13" * t330 + .CONVERT."0.2011327718400E13"  &
      * t333 + .CONVERT."0.2011327718400E13" * t335 + .CONVERT."0.16384E5" *  &
      t1694 + .CONVERT."0.499580928E9" * t1397 - .CONVERT."0.853832186707500E15" * t14 + .CONVERT."0.426916093353750E15"  &
      * t18 + .CONVERT."0.213458046676875E15" * t26 - .CONVERT."0.227688583122000E15"  &
      * t56 + .CONVERT."0.113844291561000E15" * t65 + .CONVERT."0.113844291561000E15"  &
      * t73 + .CONVERT."0.45254873664000E14" * t245 + .CONVERT."0.10041200769600E14" * t248 -  &
      .CONVERT."0.10041200769600E14" * t251
      t1721 = t607 * t1082
      t1723 = t823 * t399
      t1725 = .CONVERT."0.33312615336000E14" * t253 + .CONVERT."0.30337526419200E14" * t255 + .CONVERT."0.33312615336000E14"  &
      * t257 + .CONVERT."0.30337526419200E14" * t259 - .CONVERT."0.9679514644800E13"  &
      * t262 + .CONVERT."0.9679514644800E13" * t264 - .CONVERT."0.8548142803200E13"  &
      * t353 + .CONVERT."0.14917347244800E14" * t355 + .CONVERT."0.202187664000E12" * t357 + .CONVERT."0.221184E6"  &
      * t1420 - .CONVERT."0.100021651329600E15" * t187 + .CONVERT."0.221184E6" * t1423  &
      - .CONVERT."0.1277952E7" * t1721 + .CONVERT."0.28114944E8" * t1723
      t1726 = t587 * t1082
      t1735 = t1486 * t17
      t1742 = .CONVERT."0.1277952E7" * t1726 - .CONVERT."0.6343142400E10" * t573 + .CONVERT."0.553833262080E12"  &
      * t575 + .CONVERT."0.1064455741440E13" * t577 - .CONVERT."0.553833262080E12" * t579  &
      + .CONVERT."0.968800089600E12" * t583 + .CONVERT."0.193876623360E12" * t585 + .CONVERT."0.37934023680E11"  &
      * t588 + .CONVERT."0.16384E5" * t1735 + .CONVERT."0.968800089600E12" * t590 + .CONVERT."0.44696171520E11"  &
      * t593 - .CONVERT."0.272881889280E12" * t595 + .CONVERT."0.44696171520E11"  &
      * t597 + .CONVERT."0.272881889280E12" * t599
      t1758 = .CONVERT."0.718560460800E12" * t601 + .CONVERT."0.718560460800E12" * t603 - .CONVERT."0.1064455741440E13"  &
      * t605 - .CONVERT."0.37934023680E11" * t608 - .CONVERT."0.442368E6" * t1444  &
      - .CONVERT."0.3729777891840E13" * t452 - .CONVERT."0.285646798080E12" * t455 + .CONVERT."0.3089325657600E13"  &
      * t457 + .CONVERT."0.285646798080E12" * t461 + .CONVERT."0.3729777891840E13"  &
      * t463 - .CONVERT."0.3089325657600E13" * t465 + .CONVERT."0.4419895334400E13" * t467 +  &
      .CONVERT."0.1720802603520E13" * t469 + .CONVERT."0.1720802603520E13" * t471
      t1774 = .CONVERT."0.4419895334400E13" * t473 + .CONVERT."0.1272315340800E13" * t475 + .CONVERT."0.1272315340800E13"  &
      * t477 - .CONVERT."0.335221286400E12" * t479 + .CONVERT."0.14917347244800E14"  &
      * t360 - .CONVERT."0.63590400E8" * t981 + .CONVERT."0.49741824E8" * t1462 - .CONVERT."0.154091520E9"  &
      * t1464 - .CONVERT."0.83804160E8" * t1466 + .CONVERT."0.2764800E7" * t1215 - .CONVERT."0.9682944E7"  &
      * t1469 + .CONVERT."0.83804160E8" * t1471 + .CONVERT."0.386039808E9" * t1473 -  &
      .CONVERT."0.3293184E7" * t1476 + .CONVERT."0.21626880E8" * t1478
      t1779 = t486 * t270
      t1780 = t2 * t1779
      fm(14) =  (t1503 + t1518 + t1534 + t1554 + t1573 + t1589 + t1611 + t1628  &
      + t1649 + t1669 + t1689 + t1706 + t1725 + t1742 + t1758 + t1774)  &
      / t1780 / .CONVERT."0.65536E5"
      t1799 = .CONVERT."0.9681638400E10" * t634 + .CONVERT."0.9681638400E10" * t636 + .CONVERT."0.6653132881920E13"  &
      * t638 + .CONVERT."0.1243366225920E13" * t640 - .CONVERT."0.19363276800E11" *  &
      t642 + .CONVERT."0.5370386918400E13" * t644 + .CONVERT."0.5370386918400E13" * t646 - .CONVERT."0.178784686080E12"  &
      * t649 + .CONVERT."0.178784686080E12" * t651 - .CONVERT."0.2554617139200E13"  &
      * t653 + .CONVERT."0.7384613806080E13" * t655 + .CONVERT."0.130675507200E12" * t658  &
      + .CONVERT."0.2554617139200E13" * t660 - .CONVERT."0.130675507200E12" * t663 - .CONVERT."0.7384613806080E13"  &
      * t665 + .CONVERT."0.3792972718080E13" * t668
      t1816 =  .CONVERT."-0.3792972718080E13" * t670 + .CONVERT."0.765096192000E12" * t672 + .CONVERT."0.6653132881920E13"  &
      * t674 + .CONVERT."0.1243366225920E13" * t676 + .CONVERT."0.323192217600E12"  &
      * t821 + .CONVERT."0.13551390720E11" * t824 - .CONVERT."0.323192217600E12" * t826 +  &
      .CONVERT."0.1342817925120E13" * t828 + .CONVERT."0.87081523200E11" * t830 + .CONVERT."0.470815027200E12"  &
      * t832 + .CONVERT."0.769392691200E12" * t834 + .CONVERT."0.769392691200E12" * t836  &
      + .CONVERT."0.1342817925120E13" * t838 + .CONVERT."0.1230768967680E13" * t840 + .CONVERT."0.470815027200E12"  &
      * t842 + .CONVERT."0.87081523200E11" * t844
      t1834 = .CONVERT."0.922060800E9" * t846 + .CONVERT."0.922060800E9" * t848 - .CONVERT."0.13551390720E11"  &
      * t851 - .CONVERT."0.1230768967680E13" * t853 - .CONVERT."0.131165798400E12" * t857  &
      + .CONVERT."0.16253153280E11" * t860 + .CONVERT."0.131165798400E12" * t862 + .CONVERT."0.16253153280E11"  &
      * t864 + .CONVERT."0.988604006400E12" * t866 - .CONVERT."0.988604006400E12" * t868  &
      + .CONVERT."0.12380566707258750E17" * t22 + .CONVERT."0.54951936E8" * t1536 + .CONVERT."0.24068096E8"  &
      * t1538 + .CONVERT."0.24068096E8" * t1540 + .CONVERT."0.1077739520E10" * t1542 - .CONVERT."0.234291200E9"  &
      * t1544
      t1842 = t1666 * t93
      t1844 = t1779 * t17
      t1845 = t1844 * R
      t1847 = t1475 * t261
      t1849 = t1560 * t93
      t1851 = t1779 * t21
      t1852 = t1851 * R
      t1856 = t1780 * t17
      t1859 = .CONVERT."0.12380566707258750E17" * t24 - .CONVERT."0.54148663296000E14" * t277 +  &
      .CONVERT."0.410981297126400E15" * t279 + .CONVERT."0.54148663296000E14" * t282 + .CONVERT."0.205681115203200E15"  &
      * t284 + .CONVERT."0.265495258828800E15" * t286 - .CONVERT."0.410981297126400E15"  &
      * t288 - .CONVERT."0.11927552E8" * t1842 - .CONVERT."0.458752E6" * t1845 - .CONVERT."0.65601536E8"  &
      * t1847 + .CONVERT."0.11927552E8" * t1849 + .CONVERT."0.458752E6" * t1852 - .CONVERT."0.6190283353629375E16"  &
      * t27 + .CONVERT."0.5863442256000E13" * t291 + .CONVERT."0.32768E5" *  &
      t1856 - .CONVERT."0.1350522757584000E16" * t199
      t1878 = .CONVERT."0.1257062400E10" * t1054 + .CONVERT."0.7667712E7" * t1561 - .CONVERT."0.44483788800E11"  &
      * t1056 - .CONVERT."0.34800353280E11" * t1058 + .CONVERT."0.163045048320E12" * t1060  &
      + .CONVERT."0.34800353280E11" * t1062 + .CONVERT."0.625213440E9" * t1291 + .CONVERT."0.23973396480E11"  &
      * t1293 + .CONVERT."0.3041550336E10" * t1295 + .CONVERT."0.5830197004800E13" * t501  &
      + .CONVERT."0.44483788800E11" * t1065 + .CONVERT."0.10616094720E11" * t1067 + .CONVERT."0.1996161024E10"  &
      * t1574 + .CONVERT."0.90974822400E11" * t1069 - .CONVERT."0.163045048320E12" *  &
      t1071 + .CONVERT."0.204998492160E12" * t1075
      t1882 = t657 * t1082
      t1884 = t662 * t1082
      t1886 = t1053 * t399
      t1888 = t587 * t1604
      t1890 = t607 * t1604
      t1900 = .CONVERT."0.90974822400E11" * t1077 - .CONVERT."0.1257062400E10" * t1080 - .CONVERT."0.1140572160E10"  &
      * t1083 + .CONVERT."0.11927552E8" * t1882 - .CONVERT."0.11927552E8" * t1884 +  &
      .CONVERT."0.112459776E9" * t1886 + .CONVERT."0.458752E6" * t1888 - .CONVERT."0.458752E6" * t1890 +  &
      .CONVERT."0.781792300800E12" * t381 - .CONVERT."0.1563584601600E13" * t383 + .CONVERT."0.781792300800E12"  &
      * t385 + .CONVERT."0.110639738880E12" * t1088 + .CONVERT."0.181244067840E12" * t1090  &
      + .CONVERT."0.8661565440E10" * t1092 + .CONVERT."0.1140572160E10" * t1094 - .CONVERT."0.181244067840E12"  &
      * t1097
      t1918 = .CONVERT."0.8661565440E10" * t1099 + .CONVERT."0.10616094720E11" * t1101 + .CONVERT."0.204998492160E12"  &
      * t1103 + .CONVERT."0.110639738880E12" * t1105 + .CONVERT."0.463896576E9" *  &
      t1596 + .CONVERT."0.54951936E8" * t1598 + .CONVERT."0.1792327680E10" * t1600 + .CONVERT."0.91975564800E11"  &
      * t507 + .CONVERT."0.91975564800E11" * t509 + .CONVERT."0.1966080E7" * t1605 - .CONVERT."0.1966080E7"  &
      * t1607 - .CONVERT."0.3288835089540000E16" * t94 + .CONVERT."0.17408286720E11"  &
      * t1324 + .CONVERT."0.23786864640E11" * t1327 + .CONVERT."0.8815656960E10" * t1329 - .CONVERT."0.16507422276345000E17"  &
      * t33
      t1921 = t1079 * t399
      t1923 = t850 * t648
      t1925 = t1388 * t261
      t1927 = t509 * t1369
      t1929 = t507 * t1369
      t1941 =  .CONVERT."-0.11953650613905000E17" * t36 + .CONVERT."0.11953650613905000E17" * t41  &
      - .CONVERT."0.112459776E9" * t1921 - .CONVERT."0.65601536E8" * t1923 + .CONVERT."0.65601536E8" *  &
      t1925 + .CONVERT."0.2981888E7" * t1927 + .CONVERT."0.2981888E7" * t1929 + .CONVERT."0.765096192000E12"  &
      * t701 + .CONVERT."0.2968384491072000E16" * t143 + .CONVERT."0.1285992659952000E16"  &
      * t146 - .CONVERT."0.1285992659952000E16" * t149 + .CONVERT."0.2941881058116000E16" * t151  &
      + .CONVERT."0.2941881058116000E16" * t153 + .CONVERT."0.1113144184152000E16" * t156 +  &
      .CONVERT."0.1113144184152000E16" * t158 + .CONVERT."0.80179200E8" * t1125 + .CONVERT."0.667729920E9"  &
      * t1626
      t1957 = t1215 * t332
      t1959 = t848 * t592
      t1961 = t1735 * t59
      t1963 = t1420 * t155
      t1965 = .CONVERT."0.667729920E9" * t1632 + .CONVERT."0.11062302451200E14" * t400 + .CONVERT."0.943281272934000E15"  &
      * t99 + .CONVERT."0.943281272934000E15" * t101 - .CONVERT."0.1886562545868000E16"  &
      * t103 + .CONVERT."0.209618060652000E15" * t163 + .CONVERT."0.209618060652000E15"  &
      * t165 - .CONVERT."0.160358400E9" * t1134 + .CONVERT."0.8815656960E10" * t1354 + .CONVERT."0.750182400E9"  &
      * t1356 + .CONVERT."0.17408286720E11" * t1358 + .CONVERT."0.38112374664000E14"  &
      * t218 + .CONVERT."0.98402304E8" * t1957 + .CONVERT."0.98402304E8" * t1959 + .CONVERT."0.2981888E7"  &
      * t1961 + .CONVERT."0.32800768E8" * t1963
      t1966 = t1423 * t155
      t1983 = .CONVERT."0.32800768E8" * t1966 - .CONVERT."0.2192965632E10" * t1645 - .CONVERT."0.1077739520E10"  &
      * t1647 - .CONVERT."0.76224749328000E14" * t220 + .CONVERT."0.1996161024E10" * t1651  &
      + .CONVERT."0.3288835089540000E16" * t105 + .CONVERT."0.6527072716164000E16" * t107 +  &
      .CONVERT."0.4300784347860000E16" * t110 + .CONVERT."0.6527072716164000E16" * t113 - .CONVERT."0.4300784347860000E16"  &
      * t116 + .CONVERT."0.38112374664000E14" * t229 - .CONVERT."0.950272E6"  &
      * t1659 + .CONVERT."0.58490880E8" * t1370 + .CONVERT."0.58490880E8" * t1372 + .CONVERT."0.8253711138172500E16"  &
      * t38 + .CONVERT."0.1349517312E10" * t1664
      t1999 = t1780 * t13
      t2002 =  .CONVERT."-0.7667712E7" * t1667 + .CONVERT."0.7399878951465000E16" * t60 - .CONVERT."0.9866505268620000E16"  &
      * t63 + .CONVERT."0.7399878951465000E16" * t68 + .CONVERT."0.9866505268620000E16"  &
      * t71 + .CONVERT."0.8896757760E10" * t1381 + .CONVERT."0.1792327680E10" * t1676  &
      + .CONVERT."0.463896576E9" * t1678 - .CONVERT."0.17099292672E11" * t1383 - .CONVERT."0.23973396480E11"  &
      * t1385 - .CONVERT."0.419236121304000E15" * t178 + .CONVERT."0.104448000E9" * t1389  &
      - .CONVERT."0.1349517312E10" * t1684 + .CONVERT."0.234291200E9" * t1686 - .CONVERT."0.65536E5" *  &
      t1999 - .CONVERT."0.11726884512000E14" * t327
      t2004 = t1125 * t332
      t2006 = t846 * t592
      t2008 = t634 * t859
      t2010 = t636 * t859
      t2012 = t1694 * t59
      t2024 = .CONVERT."0.8253711138172500E16" * t43 + .CONVERT."0.98402304E8" * t2004 + .CONVERT."0.98402304E8"  &
      * t2006 + .CONVERT."0.32800768E8" * t2008 + .CONVERT."0.32800768E8" * t2010 + .CONVERT."0.2981888E7"  &
      * t2012 + .CONVERT."0.205681115203200E15" * t330 + .CONVERT."0.63608239094400E14"  &
      * t333 + .CONVERT."0.63608239094400E14" * t335 + .CONVERT."0.475136E6" * t1694 + .CONVERT."0.23786864640E11"  &
      * t1397 - .CONVERT."0.24761133414517500E17" * t14 + .CONVERT."0.12380566707258750E17"  &
      * t18 + .CONVERT."0.6190283353629375E16" * t26 - .CONVERT."0.6602968910538000E16"  &
      * t56 + .CONVERT."0.3301484455269000E16" * t65
      t2043 = .CONVERT."0.3301484455269000E16" * t73 + .CONVERT."0.1350522757584000E16" * t245  &
      + .CONVERT."0.293402430921600E15" * t248 - .CONVERT."0.293402430921600E15" * t251 + .CONVERT."0.1007130452328000E16"  &
      * t253 + .CONVERT."0.895040834688000E15" * t255 + .CONVERT."0.1007130452328000E16"  &
      * t257 + .CONVERT."0.895040834688000E15" * t259 - .CONVERT."0.296838449107200E15"  &
      * t262 + .CONVERT."0.296838449107200E15" * t264 - .CONVERT."0.265495258828800E15"  &
      * t353 + .CONVERT."0.455481922896000E15" * t355 + .CONVERT."0.5863442256000E13" * t357  &
      + .CONVERT."0.6414336E7" * t1420 - .CONVERT."0.2968384491072000E16" * t187 + .CONVERT."0.6414336E7"  &
      * t1423
      t2055 = t592 * t332
      t2056 = t381 * t2055
      t2058 = t385 * t2055
      t2060 = t1780 * t21
      t2064 =  .CONVERT."-0.135462912E9" * t1721 + .CONVERT."0.2192965632E10" * t1723 + .CONVERT."0.135462912E9"  &
      * t1726 - .CONVERT."0.183951129600E12" * t573 + .CONVERT."0.17030780928000E14" * t575  &
      + .CONVERT."0.34395094056960E14" * t577 - .CONVERT."0.17030780928000E14" * t579 + .CONVERT."0.30519243417600E14"  &
      * t583 + .CONVERT."0.5830197004800E13" * t585 + .CONVERT."0.1118352614400E13"  &
      * t588 + .CONVERT."0.475136E6" * t1735 + .CONVERT."0.32768E5" * t2056 + .CONVERT."0.32768E5"  &
      * t2058 + .CONVERT."0.32768E5" * t2060 + .CONVERT."0.30519243417600E14" * t590 + .CONVERT."0.1564366003200E13"  &
      * t593
      t2082 =  .CONVERT."-0.9296803676160E13" * t595 + .CONVERT."0.1564366003200E13" * t597 + .CONVERT."0.9296803676160E13"  &
      * t599 + .CONVERT."0.23835249285120E14" * t601 + .CONVERT."0.23835249285120E14"  &
      * t603 - .CONVERT."0.34395094056960E14" * t605 - .CONVERT."0.1118352614400E13"  &
      * t608 - .CONVERT."0.12828672E8" * t1444 - .CONVERT."0.117796760040960E15" * t452 - .CONVERT."0.8387644608000E13"  &
      * t455 + .CONVERT."0.93745942617600E14" * t457 + .CONVERT."0.8387644608000E13"  &
      * t461 + .CONVERT."0.117796760040960E15" * t463 - .CONVERT."0.93745942617600E14" *  &
      t465 + .CONVERT."0.136739810188800E15" * t467 + .CONVERT."0.55534993113600E14" * t469
      t2089 = t823 * t648
      t2101 = .CONVERT."0.55534993113600E14" * t471 + .CONVERT."0.136739810188800E15" * t473 +  &
      .CONVERT."0.37936019520000E14" * t475 + .CONVERT."0.37936019520000E14" * t477 - .CONVERT."0.11062302451200E14"  &
      * t479 + .CONVERT."0.455481922896000E15" * t360 + .CONVERT."0.65601536E8" *  &
      t2089 - .CONVERT."0.1844121600E10" * t981 + .CONVERT."0.3041550336E10" * t1462 - .CONVERT."0.8896757760E10"  &
      * t1464 - .CONVERT."0.3168337920E10" * t1466 + .CONVERT."0.80179200E8" * t1215  &
      - .CONVERT."0.625213440E9" * t1469 + .CONVERT."0.3168337920E10" * t1471 + .CONVERT."0.17099292672E11"  &
      * t1473 - .CONVERT."0.104448000E9" * t1476 + .CONVERT."0.750182400E9" * t1478
      t2106 = t486 * t365
      t2107 = t2 * t2106
      fm(15) =  -(t1799 + t1816 + t1834 + t1859 + t1878 + t1900 + t1918 + t1941  &
      + t1965 + t1983 + t2002 + t2024 + t2043 + t2064 + t2082 + t2101)  &
      / t2107 / .CONVERT."0.131072E6"
      t2129 = .CONVERT."0.300130790400E12" * t634 + .CONVERT."0.300130790400E12" * t636 + .CONVERT."0.236217078558720E15"  &
      * t638 + .CONVERT."0.46589663877120E14" * t640 - .CONVERT."0.600261580800E12"  &
      * t642 + .CONVERT."0.181026239385600E15" * t644 + .CONVERT."0.181026239385600E15"  &
      * t646 - .CONVERT."0.6883210414080E13" * t649 + .CONVERT."0.6883210414080E13" * t651 - .CONVERT."0.84041212953600E14"  &
      * t653 + .CONVERT."0.255367109652480E15" * t655 + .CONVERT."0.4119437952000E13"  &
      * t658 + .CONVERT."0.84041212953600E14" * t660 - .CONVERT."0.4119437952000E13"  &
      * t663 - .CONVERT."0.255367109652480E15" * t665 + .CONVERT."0.138330587566080E15" * t668  &
      - .CONVERT."0.138330587566080E15" * t670 + .CONVERT."0.24608445926400E14" * t672
      t2148 = .CONVERT."0.236217078558720E15" * t674 + .CONVERT."0.46589663877120E14" * t676 +  &
      .CONVERT."0.10840925491200E14" * t821 + .CONVERT."0.429779589120E12" * t824 - .CONVERT."0.10840925491200E14"  &
      * t826 + .CONVERT."0.49560580177920E14" * t828 + .CONVERT."0.2836521676800E13"  &
      * t830 + .CONVERT."0.18547348377600E14" * t832 + .CONVERT."0.26621505792000E14" * t834  &
      + .CONVERT."0.26621505792000E14" * t836 + .CONVERT."0.49560580177920E14" * t838 + .CONVERT."0.43971535964160E14"  &
      * t840 + .CONVERT."0.18547348377600E14" * t842 + .CONVERT."0.2836521676800E13"  &
      * t844 + .CONVERT."0.28583884800E11" * t846 + .CONVERT."0.28583884800E11" * t848 -  &
      .CONVERT."0.429779589120E12" * t851 - .CONVERT."0.43971535964160E14" * t853
      t2156 = t850 * t1082
      t2158 = t1388 * t399
      t2170 =  .CONVERT."-0.5336451993600E13" * t857 + .CONVERT."0.682632437760E12" * t860 + .CONVERT."0.5336451993600E13"  &
      * t862 + .CONVERT."0.682632437760E12" * t864 + .CONVERT."0.37698479308800E14"  &
      * t866 - .CONVERT."0.37698479308800E14" * t868 - .CONVERT."0.89456640E8" * t2156 +  &
      .CONVERT."0.421724160E9" * t2158 + .CONVERT."0.383797567925021250E18" * t22 + .CONVERT."0.2038972416E10"  &
      * t1536 + .CONVERT."0.1752498176E10" * t1538 + .CONVERT."0.1752498176E10" * t1540  &
      + .CONVERT."0.66620702720E11" * t1542 - .CONVERT."0.9477079040E10" * t1544 + .CONVERT."0.383797567925021250E18"  &
      * t24 - .CONVERT."0.1691854213795200E16" * t277 + .CONVERT."0.13121734424198400E17"  &
      * t279 + .CONVERT."0.1691854213795200E16" * t282
      t2189 = .CONVERT."0.6490508835283200E16" * t284 + .CONVERT."0.8714328755932800E16" * t286  &
      - .CONVERT."0.13121734424198400E17" * t288 - .CONVERT."0.638124032E9" * t1842 - .CONVERT."0.17661952E8"  &
      * t1845 - .CONVERT."0.4493705216E10" * t1847 + .CONVERT."0.638124032E9" * t1849 +  &
      .CONVERT."0.17661952E8" * t1852 - .CONVERT."0.191898783962510625E18" * t27 + .CONVERT."0.181766709936000E15"  &
      * t291 + .CONVERT."0.1015808E7" * t1856 - .CONVERT."0.42882554522808000E17" *  &
      t199 + .CONVERT."0.40260464640E11" * t1054 + .CONVERT."0.260063232E9" * t1561 - .CONVERT."0.1960186060800E13"  &
      * t1056 - .CONVERT."0.1203351367680E13" * t1058 + .CONVERT."0.6119908945920E13"  &
      * t1060 + .CONVERT."0.1203351367680E13" * t1062
      t2198 = t1423 * t332
      t2200 = t1125 * t592
      t2202 = t848 * t859
      t2204 = t846 * t859
      t2214 = .CONVERT."0.34141962240E11" * t1291 + .CONVERT."0.1084139274240E13" * t1293 + .CONVERT."0.158864572416E12"  &
      * t1295 + .CONVERT."0.185930480332800E15" * t501 + .CONVERT."0.1960186060800E13"  &
      * t1065 + .CONVERT."0.485927608320E12" * t1067 + .CONVERT."0.328007680E9" * t2198  &
      + .CONVERT."0.421724160E9" * t2200 + .CONVERT."0.196804608E9" * t2202 + .CONVERT."0.196804608E9"  &
      * t2204 + .CONVERT."0.101733924864E12" * t1574 + .CONVERT."0.3276867686400E13" * t1069 -  &
      .CONVERT."0.6119908945920E13" * t1071 + .CONVERT."0.8017152675840E13" * t1075 + .CONVERT."0.3276867686400E13"  &
      * t1077 - .CONVERT."0.40260464640E11" * t1080 - .CONVERT."0.54177177600E11"  &
      * t1083 + .CONVERT."0.1353777152E10" * t1882
      t2233 =  .CONVERT."-0.1353777152E10" * t1884 + .CONVERT."0.9390391296E10" * t1886 + .CONVERT."0.58949632E8"  &
      * t1888 - .CONVERT."0.58949632E8" * t1890 + .CONVERT."0.24235561324800E14" * t381  &
      - .CONVERT."0.48471122649600E14" * t383 + .CONVERT."0.24235561324800E14" * t385 + .CONVERT."0.4689073889280E13"  &
      * t1088 + .CONVERT."0.7381504880640E13" * t1090 + .CONVERT."0.287881482240E12"  &
      * t1092 + .CONVERT."0.54177177600E11" * t1094 - .CONVERT."0.7381504880640E13" * t1097  &
      + .CONVERT."0.287881482240E12" * t1099 + .CONVERT."0.485927608320E12" * t1101 + .CONVERT."0.8017152675840E13"  &
      * t1103 + .CONVERT."0.4689073889280E13" * t1105 + .CONVERT."0.30371168256E11"  &
      * t1596 + .CONVERT."0.2038972416E10" * t1598
      t2237 = t2060 * t59
      t2239 = t509 * t2055
      t2241 = t507 * t2055
      t2256 = .CONVERT."0.104271298560E12" * t1600 + .CONVERT."0.2851242508800E13" * t507 + .CONVERT."0.6881280E7"  &
      * t2237 + .CONVERT."0.983040E6" * t2239 + .CONVERT."0.983040E6" * t2241 + .CONVERT."0.2851242508800E13"  &
      * t509 + .CONVERT."0.150405120E9" * t1605 - .CONVERT."0.150405120E9" * t1607  &
      - .CONVERT."0.103598305320510000E18" * t94 + .CONVERT."0.827483627520E12" * t1324 + .CONVERT."0.1021529456640E13"  &
      * t1327 + .CONVERT."0.339706920960E12" * t1329 - .CONVERT."0.511730090566695000E18"  &
      * t33 - .CONVERT."0.371417001217762500E18" * t36 + .CONVERT."0.371417001217762500E18"  &
      * t41 - .CONVERT."0.9390391296E10" * t1921 - .CONVERT."0.6461751296E10" * t1923  &
      + .CONVERT."0.4493705216E10" * t1925
      t2267 = t657 * t1604
      t2269 = t662 * t1604
      t2271 = t1475 * t399
      t2273 = t1079 * t648
      t2275 = t1560 * t261
      t2281 = .CONVERT."0.360808448E9" * t1927 + .CONVERT."0.360808448E9" * t1929 + .CONVERT."0.24608445926400E14"  &
      * t701 + .CONVERT."0.93841427888208000E17" * t143 + .CONVERT."0.40065962420484000E17"  &
      * t146 - .CONVERT."0.40065962420484000E17" * t149 + .CONVERT."0.92260859522832000E17"  &
      * t151 + .CONVERT."0.92260859522832000E17" * t153 + .CONVERT."0.35519418967032000E17"  &
      * t156 + .CONVERT."0.35519418967032000E17" * t158 + .CONVERT."0.6881280E7" * t2267 -  &
      .CONVERT."0.6881280E7" * t2269 - .CONVERT."0.421724160E9" * t2271 - .CONVERT."0.328007680E9" * t2273  &
      + .CONVERT."0.196804608E9" * t2275 + .CONVERT."0.2485555200E10" * t1125 + .CONVERT."0.29309829120E11"  &
      * t1626 + .CONVERT."0.29309829120E11" * t1632 + .CONVERT."0.381649434566400E15" * t400
      t2285 = t1053 * t648
      t2292 = t1666 * t261
      t2294 = t1851 * t93
      t2296 = t2106 * t21
      t2297 = t2296 * R
      t2299 = t823 * t1082
      t2301 = t1694 * t155
      t2303 = t1735 * t155
      t2305 = t1856 * t59
      t2312 = .CONVERT."0.328007680E9" * t2285 + .CONVERT."0.29241719460954000E17" * t99 + .CONVERT."0.29241719460954000E17"  &
      * t101 - .CONVERT."0.58483438921908000E17" * t103 + .CONVERT."0.6498159880212000E16"  &
      * t163 + .CONVERT."0.6498159880212000E16" * t165 - .CONVERT."0.196804608E9"  &
      * t2292 + .CONVERT."0.29818880E8" * t2294 + .CONVERT."0.983040E6" * t2297 + .CONVERT."0.89456640E8"  &
      * t2299 + .CONVERT."0.89456640E8" * t2301 + .CONVERT."0.89456640E8" * t2303 + .CONVERT."0.6881280E7"  &
      * t2305 - .CONVERT."0.4971110400E10" * t1134 + .CONVERT."0.339706920960E12" * t1354  &
      + .CONVERT."0.25838714880E11" * t1356 + .CONVERT."0.827483627520E12" * t1358 + .CONVERT."0.1181483614584000E16"  &
      * t218
      t2329 = t1844 * t93
      t2331 = t2106 * t17
      t2332 = t2331 * R
      t2334 = .CONVERT."0.7478575104E10" * t1957 + .CONVERT."0.8954609664E10" * t1959 + .CONVERT."0.137166848E9"  &
      * t1961 + .CONVERT."0.2000846848E10" * t1963 + .CONVERT."0.2000846848E10" * t1966  &
      - .CONVERT."0.119643144192E12" * t1645 - .CONVERT."0.66620702720E11" * t1647 - .CONVERT."0.2362967229168000E16"  &
      * t220 + .CONVERT."0.101733924864E12" * t1651 + .CONVERT."0.103598305320510000E18"  &
      * t105 + .CONVERT."0.204236659060434000E18" * t107 + .CONVERT."0.133855588144278000E18"  &
      * t110 + .CONVERT."0.204236659060434000E18" * t113 - .CONVERT."0.133855588144278000E18"  &
      * t116 + .CONVERT."0.1181483614584000E16" * t229 - .CONVERT."0.29458432E8" * t1659  &
      - .CONVERT."0.29818880E8" * t2329 - .CONVERT."0.983040E6" * t2332
      t2337 = t636 * t1369
      t2339 = t634 * t1369
      t2341 = t1420 * t332
      t2343 = t1215 * t592
      t2345 = t2107 * t17
      t2347 = t2107 * t21
      t2350 = t2107 * t13
      t2361 = .CONVERT."0.3333980160E10" * t1370 + .CONVERT."0.29818880E8" * t2337 + .CONVERT."0.29818880E8"  &
      * t2339 + .CONVERT."0.328007680E9" * t2341 + .CONVERT."0.421724160E9" * t2343 + .CONVERT."0.65536E5"  &
      * t2345 + .CONVERT."0.65536E5" * t2347 + .CONVERT."0.3333980160E10" * t1372 - .CONVERT."0.131072E6"  &
      * t2350 + .CONVERT."0.255865045283347500E18" * t38 + .CONVERT."0.63975555072E11" *  &
      t1664 - .CONVERT."0.260063232E9" * t1667 + .CONVERT."0.231103911868830000E18" * t60 - .CONVERT."0.306810365756895000E18"  &
      * t63 + .CONVERT."0.231103911868830000E18" * t68 + .CONVERT."0.306810365756895000E18"  &
      * t71 + .CONVERT."0.443698421760E12" * t1381 + .CONVERT."0.104271298560E12"  &
      * t1676
      t2381 = .CONVERT."0.30371168256E11" * t1678 - .CONVERT."0.696131960832E12" * t1383 - .CONVERT."0.1084139274240E13"  &
      * t1385 - .CONVERT."0.12996319760424000E17" * t178 + .CONVERT."0.3405619200E10"  &
      * t1389 - .CONVERT."0.63975555072E11" * t1684 + .CONVERT."0.9477079040E10" * t1686  &
      - .CONVERT."0.2031616E7" * t1999 - .CONVERT."0.363533419872000E15" * t327 + .CONVERT."0.255865045283347500E18"  &
      * t43 + .CONVERT."0.7478575104E10" * t2004 + .CONVERT."0.8954609664E10" *  &
      t2006 + .CONVERT."0.3476881408E10" * t2008 + .CONVERT."0.3476881408E10" * t2010 + .CONVERT."0.137166848E9"  &
      * t2012 + .CONVERT."0.6490508835283200E16" * t330 + .CONVERT."0.2120274636480000E16"  &
      * t333 + .CONVERT."0.2120274636480000E16" * t335 + .CONVERT."0.14729216E8" * t1694
      t2385 = t592 * t399
      t2386 = t607 * t2385
      t2388 = t587 * t2385
      t2405 = .CONVERT."0.1021529456640E13" * t1397 - .CONVERT."0.65536E5" * t2386 + .CONVERT."0.65536E5"  &
      * t2388 - .CONVERT."0.767595135850042500E18" * t14 + .CONVERT."0.383797567925021250E18"  &
      * t18 + .CONVERT."0.191898783962510625E18" * t26 - .CONVERT."0.204692036226678000E18" *  &
      t56 + .CONVERT."0.102346018113339000E18" * t65 + .CONVERT."0.102346018113339000E18" * t73  &
      + .CONVERT."0.42882554522808000E17" * t245 + .CONVERT."0.9152672490561600E16" * t248 -  &
      .CONVERT."0.9152672490561600E16" * t251 + .CONVERT."0.32334188206320000E17" * t253 + .CONVERT."0.28146645799272000E17"  &
      * t255 + .CONVERT."0.32334188206320000E17" * t257 + .CONVERT."0.28146645799272000E17"  &
      * t259 - .CONVERT."0.9647249595984000E16" * t262 + .CONVERT."0.9647249595984000E16"  &
      * t264
      t2424 =  .CONVERT."-0.8714328755932800E16" * t353 + .CONVERT."0.14735908723536000E17" * t355  &
      + .CONVERT."0.181766709936000E15" * t357 + .CONVERT."0.198844416E9" * t1420 - .CONVERT."0.93841427888208000E17"  &
      * t187 + .CONVERT."0.198844416E9" * t1423 - .CONVERT."0.9365471232E10" *  &
      t1721 + .CONVERT."0.119643144192E12" * t1723 + .CONVERT."0.9365471232E10" * t1726 - .CONVERT."0.5702485017600E13"  &
      * t573 + .CONVERT."0.552887200051200E15" * t575 + .CONVERT."0.1162579927541760E16"  &
      * t577 - .CONVERT."0.552887200051200E15" * t579 + .CONVERT."0.1010317887129600E16"  &
      * t583 + .CONVERT."0.185930480332800E15" * t585 + .CONVERT."0.35114163033600E14" *  &
      t588 + .CONVERT."0.14729216E8" * t1735 + .CONVERT."0.4456448E7" * t2056
      t2444 = .CONVERT."0.4456448E7" * t2058 + .CONVERT."0.1015808E7" * t2060 + .CONVERT."0.1010317887129600E16"  &
      * t590 + .CONVERT."0.56540656972800E14" * t593 - .CONVERT."0.328427468328960E15"  &
      * t595 + .CONVERT."0.56540656972800E14" * t597 + .CONVERT."0.328427468328960E15" * t599  &
      + .CONVERT."0.823368492011520E15" * t601 + .CONVERT."0.823368492011520E15" * t603 - .CONVERT."0.1162579927541760E16"  &
      * t605 - .CONVERT."0.35114163033600E14" * t608 - .CONVERT."0.397688832E9"  &
      * t1444 - .CONVERT."0.3915686324309760E16" * t452 - .CONVERT."0.262614169440000E15"  &
      * t455 + .CONVERT."0.3014497734393600E16" * t457 + .CONVERT."0.262614169440000E15" * t461  &
      + .CONVERT."0.3915686324309760E16" * t463 - .CONVERT."0.3014497734393600E16" * t465
      t2464 = .CONVERT."0.4467722643820800E16" * t467 + .CONVERT."0.1879976844345600E16" * t469  &
      + .CONVERT."0.1879976844345600E16" * t471 + .CONVERT."0.4467722643820800E16" * t473 + .CONVERT."0.1202507908358400E16"  &
      * t475 + .CONVERT."0.1202507908358400E16" * t477 - .CONVERT."0.381649434566400E15"  &
      * t479 + .CONVERT."0.14735908723536000E17" * t360 + .CONVERT."0.6461751296E10"  &
      * t2089 - .CONVERT."0.57167769600E11" * t981 + .CONVERT."0.158864572416E12" * t1462  &
      - .CONVERT."0.443698421760E12" * t1464 - .CONVERT."0.115438878720E12" * t1466 + .CONVERT."0.2485555200E10"  &
      * t1215 - .CONVERT."0.34141962240E11" * t1469 + .CONVERT."0.115438878720E12"  &
      * t1471 + .CONVERT."0.696131960832E12" * t1473 - .CONVERT."0.3405619200E10" * t1476 + .CONVERT."0.25838714880E11"  &
      * t1478
      t2469 = t486 ** 2
      t2470 = t2 * t2469
      fm(16) =  (t2129 + t2148 + t2170 + t2189 + t2214 + t2233 + t2256 + t2281  &
      + t2312 + t2334 + t2361 + t2381 + t2405 + t2424 + t2444 + t2464)  &
      / t2470 / .CONVERT."0.262144E6"
      t2493 =  .CONVERT."-0.9904316083200E13" * t634 - .CONVERT."0.9904316083200E13" * t636 - .CONVERT."0.8696238410280960E16"  &
      * t638 - .CONVERT."0.1794908855900160E16" * t640 + .CONVERT."0.19808632166400E14"  &
      * t642 - .CONVERT."0.6384882483302400E16" * t644 - .CONVERT."0.6384882483302400E16"  &
      * t646 + .CONVERT."0.271395153469440E15" * t649 - .CONVERT."0.271395153469440E15"  &
      * t651 + .CONVERT."0.2906335980979200E16" * t653 - .CONVERT."0.9197770712739840E16"  &
      * t655 - .CONVERT."0.137722380364800E15" * t658 - .CONVERT."0.2906335980979200E16" * t660  &
      + .CONVERT."0.137722380364800E15" * t663 + .CONVERT."0.9197770712739840E16" * t665 - .CONVERT."0.5208534259568640E16"  &
      * t668 + .CONVERT."0.5208534259568640E16" * t670 - .CONVERT."0.835824421555200E15"  &
      * t672 - .CONVERT."0.8696238410280960E16" * t674 - .CONVERT."0.1794908855900160E16"  &
      * t676
      t2514 =  .CONVERT."-0.379913200128000E15" * t821 - .CONVERT."0.14426272143360E14" * t824 +  &
      .CONVERT."0.379913200128000E15" * t826 - .CONVERT."0.1875258819624960E16" * t828 - .CONVERT."0.97167071232000E14"  &
      * t830 - .CONVERT."0.740787470438400E15" * t832 - .CONVERT."0.956078997350400E15"  &
      * t834 - .CONVERT."0.956078997350400E15" * t836 - .CONVERT."0.1875258819624960E16"  &
      * t838 - .CONVERT."0.1620302809466880E16" * t840 - .CONVERT."0.740787470438400E15"  &
      * t842 - .CONVERT."0.97167071232000E14" * t844 - .CONVERT."0.943268198400E12" * t846 - .CONVERT."0.943268198400E12"  &
      * t848 + .CONVERT."0.14426272143360E14" * t851 + .CONVERT."0.1620302809466880E16"  &
      * t853 + .CONVERT."0.219011240448000E15" * t857 - .CONVERT."0.28784334458880E14"  &
      * t860 - .CONVERT."0.219011240448000E15" * t862 - .CONVERT."0.28784334458880E14" * t864
      t2527 = t2469 * t17
      t2528 = t2527 * R
      t2530 = t662 * t2385
      t2532 = t657 * t2385
      t2534 = t823 * t1604
      t2536 = t850 * t1604
      t2538 = t1666 * t399
      t2543 =  .CONVERT."-0.1465366439116800E16" * t866 + .CONVERT."0.1465366439116800E16" * t868  &
      + .CONVERT."0.10824253440E11" * t2156 - .CONVERT."0.37533450240E11" * t2158 - .CONVERT."0.12665319741525701250E20"  &
      * t22 - .CONVERT."0.74800447488E11" * t1536 - .CONVERT."0.106496851968E12"  &
      * t1538 - .CONVERT."0.106496851968E12" * t1540 - .CONVERT."0.3541674639360E13" * t1542  &
      + .CONVERT."0.367848898560E12" * t1544 - .CONVERT."0.12665319741525701250E20" * t24  &
      + .CONVERT."0.2097152E7" * t2528 + .CONVERT."0.2097152E7" * t2530 - .CONVERT."0.2097152E7" * t2532  &
      - .CONVERT."0.73400320E8" * t2534 + .CONVERT."0.73400320E8" * t2536 + .CONVERT."0.1499463680E10" *  &
      t2538 + .CONVERT."0.56197250699990400E17" * t277 - .CONVERT."0.443858292400723200E18" *  &
      t279 - .CONVERT."0.56197250699990400E17" * t282
      t2566 =  .CONVERT."-0.33521664E8" * t1856 + .CONVERT."0.1444268437892280000E19" * t199 - .CONVERT."0.1359592058880E13"  &
      * t1054 - .CONVERT."0.9029369856E10" * t1561 + .CONVERT."0.85011135897600E14"  &
      * t1056 + .CONVERT."0.42998462115840E14" * t1058 - .CONVERT."0.232984717701120E15"  &
      * t1060 - .CONVERT."0.42998462115840E14" * t1062 - .CONVERT."0.1728906854400E13" * t1291  &
      - .CONVERT."0.47059404226560E14" * t1293 - .CONVERT."0.7751789641728E13" * t1295
      t2577 = t1475 * t648
      t2579 = t846 * t1369
      t2581 = t848 * t1369
      t2583 = t1694 * t332
      t2585 = t1215 * t859
      t2595 =  .CONVERT."-0.6276992801587200E16" * t501 - .CONVERT."0.85011135897600E14" * t1065  &
      - .CONVERT."0.21756721029120E14" * t1067 - .CONVERT."0.26568622080E11" * t2198 - .CONVERT."0.40907243520E11"  &
      * t2200 - .CONVERT."0.22238920704E11" * t2202 - .CONVERT."0.22238920704E11" *  &
      t2204 + .CONVERT."0.1499463680E10" * t2577 - .CONVERT."0.238551040E9" * t2579 - .CONVERT."0.238551040E9"  &
      * t2581 - .CONVERT."0.1049624576E10" * t2583 - .CONVERT."0.1049624576E10" * t2585  &
      - .CONVERT."0.4656129933312E13" * t1574 - .CONVERT."0.120801010176000E15" * t1069 + .CONVERT."0.232984717701120E15"  &
      * t1071 - .CONVERT."0.315338675097600E15" * t1075 - .CONVERT."0.120801010176000E15"  &
      * t1077 + .CONVERT."0.1359592058880E13" * t1080 + .CONVERT."0.2502985605120E13"  &
      * t1083 - .CONVERT."0.99779936256E11" * t1882
      t2618 =  .CONVERT."-0.2502985605120E13" * t1094 + .CONVERT."0.300003701944320E15" * t1097  &
      - .CONVERT."0.9987180318720E13" * t1099 - .CONVERT."0.21756721029120E14" * t1101 - .CONVERT."0.315338675097600E15"  &
      * t1103 - .CONVERT."0.196894985379840E15" * t1105 - .CONVERT."0.1691064680448E13"  &
      * t1596 - .CONVERT."0.74800447488E11" * t1598 - .CONVERT."0.5283043983360E13"  &
      * t1600 - .CONVERT."0.94091002790400E14" * t507 - .CONVERT."0.337182720E9" * t2237
      t2631 = t636 * t2055
      t2633 = t634 * t2055
      t2635 = t1735 * t332
      t2637 = t1420 * t592
      t2645 =  .CONVERT."-0.142540800E9" * t2239 - .CONVERT."0.142540800E9" * t2241 - .CONVERT."0.94091002790400E14"  &
      * t509 - .CONVERT."0.9525657600E10" * t1605 + .CONVERT."0.9525657600E10" * t1607  &
      + .CONVERT."0.3466558678032450000E19" * t94 - .CONVERT."0.37380895580160E14" * t1324  &
      - .CONVERT."0.42575535636480E14" * t1327 - .CONVERT."0.13036921159680E14" * t1329 + .CONVERT."0.16887092988700935000E20"  &
      * t33 - .CONVERT."0.15728640E8" * t2631 - .CONVERT."0.15728640E8"  &
      * t2633 - .CONVERT."0.1049624576E10" * t2635 - .CONVERT."0.1686896640E10" * t2637 + .CONVERT."0.12281522173600680000E20"  &
      * t36 - .CONVERT."0.12281522173600680000E20" * t41 + .CONVERT."0.546048442368E12"  &
      * t1921 + .CONVERT."0.425786769408E12" * t1923 - .CONVERT."0.227014115328E12"  &
      * t1925 - .CONVERT."0.28008873984E11" * t1927
      t2647 = t2060 * t155
      t2650 = t1856 * t155
      t2652 = t2345 * t59
      t2667 = t2470 * t17
      t2672 =  .CONVERT."-0.1201740341717916000E19" * t156 - .CONVERT."0.1201740341717916000E19"  &
      * t158 - .CONVERT."0.942735360E9" * t2267 + .CONVERT."0.942735360E9" * t2269 + .CONVERT."0.37533450240E11"  &
      * t2271 + .CONVERT."0.34440806400E11" * t2273 - .CONVERT."0.14366736384E11" * t2275  &
      - .CONVERT."0.131072E6" * t2667 - .CONVERT."0.82023321600E11" * t1125 - .CONVERT."0.1203389890560E13"  &
      * t1626 - .CONVERT."0.1203389890560E13" * t1632
      t2684 = t1388 * t648
      t2698 =  .CONVERT."-0.13781785137120000E17" * t400 - .CONVERT."0.34440806400E11" * t2285 -  &
      .CONVERT."0.964976742211482000E18" * t99 - .CONVERT."0.964976742211482000E18" * t101 +  &
      .CONVERT."0.1929953484422964000E19" * t103 - .CONVERT."0.214439276046996000E18" * t163 -  &
      .CONVERT."0.214439276046996000E18" * t165 - .CONVERT."0.1499463680E10" * t2684 + .CONVERT."0.14366736384E11"  &
      * t2292 - .CONVERT."0.1699676160E10" * t2294 - .CONVERT."0.40304640E8" * t2297  &
      - .CONVERT."0.10824253440E11" * t2299 - .CONVERT."0.5814681600E10" * t2301 - .CONVERT."0.5814681600E10"  &
      * t2303 - .CONVERT."0.337182720E9" * t2305 + .CONVERT."0.164046643200E12" * t1134  &
      - .CONVERT."0.13036921159680E14" * t1354 - .CONVERT."0.914671042560E12" * t1356 - .CONVERT."0.37380895580160E14"  &
      * t1358 - .CONVERT."0.38988959281272000E17" * t218
      t2714 = t1844 * t261
      t2716 = t2296 * t93
      t2718 = t2469 * t21
      t2719 = t2718 * R
      t2721 = t1053 * t1082
      t2723 = t1079 * t1082
      t2725 =  .CONVERT."-0.406204710912E12" * t1957 - .CONVERT."0.555284201472E12" * t1959 - .CONVERT."0.5421072384E10"  &
      * t1961 - .CONVERT."0.93580591104E11" * t1963 - .CONVERT."0.93580591104E11"  &
      * t1966 + .CONVERT."0.5766698336256E13" * t1645 + .CONVERT."0.3541674639360E13" * t1647  &
      + .CONVERT."0.77977918562544000E17" * t220 - .CONVERT."0.4656129933312E13" * t1651 - .CONVERT."0.3466558678032450000E19"  &
      * t105 - .CONVERT."0.6794455008943602000E19" * t107 -  &
      .CONVERT."0.4432413647635974000E19" * t110 - .CONVERT."0.6794455008943602000E19" * t113  &
      + .CONVERT."0.4432413647635974000E19" * t116 - .CONVERT."0.38988959281272000E17" * t229  &
      + .CONVERT."0.572522496E9" * t2714 - .CONVERT."0.73400320E8" * t2716 - .CONVERT."0.2097152E7" * t2719  &
      - .CONVERT."0.572522496E9" * t2721 + .CONVERT."0.572522496E9" * t2723
      t2727 = t1560 * t399
      t2748 =  .CONVERT."-0.1499463680E10" * t2727 + .CONVERT."0.972128256E9" * t1659 + .CONVERT."0.1699676160E10"  &
      * t2329 + .CONVERT."0.40304640E8" * t2332 - .CONVERT."0.175033958400E12" * t1370  &
      - .CONVERT."0.3846635520E10" * t2337 - .CONVERT."0.3846635520E10" * t2339 - .CONVERT."0.26568622080E11"  &
      * t2341 - .CONVERT."0.40907243520E11" * t2343 - .CONVERT."0.2162688E7" * t2345 - .CONVERT."0.2162688E7"  &
      * t2347 - .CONVERT."0.175033958400E12" * t1372 + .CONVERT."0.4325376E7" * t2350  &
      - .CONVERT."0.8443546494350467500E19" * t38 - .CONVERT."0.2775408869376E13" * t1664 +  &
      .CONVERT."0.9029369856E10" * t1667 - .CONVERT."0.7675951358500425000E19" * t60 + .CONVERT."0.10152064699952175000E20"  &
      * t63 - .CONVERT."0.7675951358500425000E19" * t68 - .CONVERT."0.10152064699952175000E20"  &
      * t71
      t2771 = .CONVERT."0.11996602855776000E17" * t327 - .CONVERT."0.8443546494350467500E19" *  &
      t43 - .CONVERT."0.406204710912E12" * t2004 - .CONVERT."0.555284201472E12" * t2006 - .CONVERT."0.242660081664E12"  &
      * t2008 - .CONVERT."0.242660081664E12" * t2010 - .CONVERT."0.5421072384E10"  &
      * t2012 - .CONVERT."0.217389830955897600E18" * t330 - .CONVERT."0.74421639740448000E17"  &
      * t333 - .CONVERT."0.74421639740448000E17" * t335 - .CONVERT."0.486064128E9" * t1694
      t2795 =  .CONVERT."-0.42575535636480E14" * t1397 + .CONVERT."0.10027008E8" * t2386 - .CONVERT."0.10027008E8"  &
      * t2388 + .CONVERT."0.25330639483051402500E20" * t14 - .CONVERT."0.12665319741525701250E20"  &
      * t18 - .CONVERT."0.6332659870762850625E19" * t26 + .CONVERT."0.6754837195480374000E19"  &
      * t56 - .CONVERT."0.3377418597740187000E19" * t65 - .CONVERT."0.3377418597740187000E19"  &
      * t73 - .CONVERT."0.1444268437892280000E19" * t245 - .CONVERT."0.303639711884308800E18"  &
      * t248 + .CONVERT."0.303639711884308800E18" * t251 - .CONVERT."0.1099410587074800000E19"  &
      * t253 - .CONVERT."0.940173143069160000E18" * t255 - .CONVERT."0.1099410587074800000E19"  &
      * t257 - .CONVERT."0.940173143069160000E18" * t259 + .CONVERT."0.331514577025632000E18"  &
      * t262 - .CONVERT."0.331514577025632000E18" * t264 + .CONVERT."0.301821094502928000E18"  &
      * t353 - .CONVERT."0.504095294823120000E18" * t355
      t2796 = t1851 * t261
      t2798 = t1423 * t592
      t2800 = t1125 * t859
      t2802 = t2347 * t59
      t2804 = t592 ** 2
      t2805 = t507 * t2804
      t2808 = t509 * t2804
      t2810 = t2331 * t93
      t2820 = t2470 * t13
      t2822 = t2470 * t21
      t2828 =  .CONVERT."-0.6561865728E10" * t1423 + .CONVERT."0.545226080256E12" * t1721 - .CONVERT."0.5766698336256E13"  &
      * t1723 - .CONVERT."0.545226080256E12" * t1726 + .CONVERT."0.188182005580800E15"  &
      * t573 + .CONVERT."0.262144E6" * t2820 - .CONVERT."0.131072E6" * t2822 - .CONVERT."0.18938868086476800E17"  &
      * t575 - .CONVERT."0.41180996414638080E17" * t577 + .CONVERT."0.18938868086476800E17"  &
      * t579 - .CONVERT."0.35170798499020800E17" * t583
      t2851 =  .CONVERT."-0.6276992801587200E16" * t585 - .CONVERT."0.1170640233100800E16" * t588  &
      - .CONVERT."0.486064128E9" * t1735 - .CONVERT."0.381026304E9" * t2056 - .CONVERT."0.381026304E9"  &
      * t2058 - .CONVERT."0.33521664E8" * t2060 - .CONVERT."0.35170798499020800E17" * t590 - .CONVERT."0.2120274636480000E16"  &
      * t593 + .CONVERT."0.12077084329390080E17" * t595 - .CONVERT."0.2120274636480000E16"  &
      * t597 - .CONVERT."0.12077084329390080E17" * t599 - .CONVERT."0.29705433161564160E17"  &
      * t601 - .CONVERT."0.29705433161564160E17" * t603 + .CONVERT."0.41180996414638080E17"  &
      * t605 + .CONVERT."0.1170640233100800E16" * t608 + .CONVERT."0.13123731456E11"  &
      * t1444 + .CONVERT."0.136961260418062080E18" * t452 + .CONVERT."0.8736911066822400E16"  &
      * t455 - .CONVERT."0.102528938941228800E18" * t457 - .CONVERT."0.8736911066822400E16"  &
      * t461
      t2874 =  .CONVERT."-0.425786769408E12" * t2089 + .CONVERT."0.1886536396800E13" * t981 - .CONVERT."0.7751789641728E13"  &
      * t1462 + .CONVERT."0.20841393070080E14" * t1464 + .CONVERT."0.4252293365760E13"  &
      * t1466 - .CONVERT."0.82023321600E11" * t1215 + .CONVERT."0.1728906854400E13"  &
      * t1469 - .CONVERT."0.4252293365760E13" * t1471 - .CONVERT."0.27843268755456E14" * t1473  &
      + .CONVERT."0.116142612480E12" * t1476 - .CONVERT."0.914671042560E12" * t1478
      t2880 = t2469 * T
      t2881 = t2 * t2880
      fm(17) =  (.CONVERT."0.67043328E8" * t1999 - .CONVERT."0.154005184459526400E18" * t473 - .CONVERT."0.9987180318720E13"  &
      * t1092 - .CONVERT."0.799773523718400E15" * t385 - .CONVERT."0.40414884265324800E17"  &
      * t475 - .CONVERT."0.20841393070080E14" * t1381 + t2828 - .CONVERT."0.40414884265324800E17"  &
      * t477 + .CONVERT."0.3149388481743504000E19" * t187 + .CONVERT."0.13781785137120000E17"  &
      * t479 + .CONVERT."0.27843268755456E14" * t1383 + .CONVERT."0.47059404226560E14"  &
      * t1385 + t2595 + t2771 - .CONVERT."0.3149388481743504000E19" * t143  &
      + t2672 + t2543 + t2493 - .CONVERT."0.1327843675722564000E19" * t146 + t2748  &
      - .CONVERT."0.116142612480E12" * t1389 + .CONVERT."0.6332659870762850625E19" * t27 +  &
      .CONVERT."0.2775408869376E13" * t1684 + t2874 - .CONVERT."0.367848898560E12" * t1686 - .CONVERT."0.835824421555200E15"  &
      * t701 - .CONVERT."0.799773523718400E15" * t381 + .CONVERT."0.1327843675722564000E19"  &
      * t149 + t2645 + t2566 - .CONVERT."0.217389830955897600E18"  &
      * t284 - .CONVERT."0.3074966842003056000E19" * t151 - .CONVERT."0.1691064680448E13" * t1678  &
      - .CONVERT."0.196894985379840E15" * t1088 + t2698 - .CONVERT."0.136961260418062080E18"  &
      * t463 - .CONVERT."0.301821094502928000E18" * t286 + t2795 - .CONVERT."0.238551040E9"  &
      * t2647 + .CONVERT."0.428878552093992000E18" * t178 + .CONVERT."0.1599547047436800E16"  &
      * t383 - .CONVERT."0.5998301427888000E16" * t357 - .CONVERT."0.6561865728E10" * t1420 -  &
      .CONVERT."0.3074966842003056000E19" * t153 + .CONVERT."0.102528938941228800E18" * t465  &
      - .CONVERT."0.572522496E9" * t2796 + t2514 + .CONVERT."0.443858292400723200E18" * t288 -  &
      .CONVERT."0.504095294823120000E18" * t360 - .CONVERT."0.1686896640E10" * t2798 - .CONVERT."0.238551040E9"  &
      * t2650 - .CONVERT."0.1049624576E10" * t2800 - .CONVERT."0.5283043983360E13" * t1676  &
      - .CONVERT."0.154005184459526400E18" * t467 - .CONVERT."0.15728640E8" * t2802 + t2618  &
      - .CONVERT."0.300003701944320E15" * t1090 - .CONVERT."0.15728640E8" * t2652 - .CONVERT."0.131072E6"  &
      * t2805 + t2851 - .CONVERT."0.66788651049120000E17" * t469 - .CONVERT."0.131072E6" *  &
      t2808 - .CONVERT."0.5998301427888000E16" * t291 + .CONVERT."0.27498971136E11" * t1842 +  &
      .CONVERT."0.637894656E9" * t1845 + .CONVERT."0.227014115328E12" * t1847 + .CONVERT."0.73400320E8"  &
      * t2810 - .CONVERT."0.66788651049120000E17" * t471 - .CONVERT."0.27498971136E11" * t1849  &
      - .CONVERT."0.637894656E9" * t1852 + t2725 + .CONVERT."0.99779936256E11" * t1884 - .CONVERT."0.546048442368E12"  &
      * t1886 - .CONVERT."0.4807950336E10" * t1888 + .CONVERT."0.4807950336E10"  &
      * t1890 - .CONVERT."0.28008873984E11" * t1929) / t2881 / .CONVERT."0.524288E6"
      t2895 = .CONVERT."0.346651062912000E15" * t634 + .CONVERT."0.346651062912000E15" * t636 +  &
      .CONVERT."0.333090104178585600E18" * t638 + .CONVERT."0.71472530473344000E17" * t640 -  &
      .CONVERT."0.693302125824000E15" * t642 + .CONVERT."0.235916982837043200E18" * t644 + .CONVERT."0.235916982837043200E18"  &
      * t646 - .CONVERT."0.11025428109696000E17" * t649 + .CONVERT."0.11025428109696000E17"  &
      * t651 - .CONVERT."0.105652105414732800E18" * t653 + .CONVERT."0.345856774794854400E18"  &
      * t655
      t2907 = .CONVERT."0.4870742937984000E16" * t658 + .CONVERT."0.105652105414732800E18" * t660  &
      - .CONVERT."0.4870742937984000E16" * t663 - .CONVERT."0.345856774794854400E18" * t665  &
      + .CONVERT."0.203361322951987200E18" * t668 - .CONVERT."0.203361322951987200E18" * t670  &
      + .CONVERT."0.29940105657369600E17" * t672 + .CONVERT."0.333090104178585600E18" * t674  &
      + .CONVERT."0.71472530473344000E17" * t676 + .CONVERT."0.13942845207244800E17" * t821 +  &
      .CONVERT."0.511647475046400E15" * t824
      t2920 =  .CONVERT."-0.13942845207244800E17" * t826 + .CONVERT."0.73293194638540800E17" * t828  &
      + .CONVERT."0.3501766743552000E16" * t830 + .CONVERT."0.30304210580582400E17" * t832  &
      + .CONVERT."0.35791858880870400E17" * t834 + .CONVERT."0.35791858880870400E17" * t836 +  &
      .CONVERT."0.73293194638540800E17" * t838 + .CONVERT."0.61951059771955200E17" * t840 + .CONVERT."0.30304210580582400E17"  &
      * t842 + .CONVERT."0.3501766743552000E16" * t844 + .CONVERT."0.33014386944000E14"  &
      * t846
      t2933 = .CONVERT."0.33014386944000E14" * t848 - .CONVERT."0.511647475046400E15" * t851 -  &
      .CONVERT."0.61951059771955200E17" * t853 - .CONVERT."0.9169866549043200E16" * t857 + .CONVERT."0.1233614333952000E16"  &
      * t860 + .CONVERT."0.9169866549043200E16" * t862 + .CONVERT."0.1233614333952000E16"  &
      * t864 + .CONVERT."0.58582240561152000E17" * t866 - .CONVERT."0.58582240561152000E17"  &
      * t868 - .CONVERT."0.847243837440E12" * t2156 + .CONVERT."0.2317374259200E13"  &
      * t2158 + .CONVERT."0.443286190953399543750E21" * t22
      t2936 = t1388 * t1082
      t2944 = t1053 * t1604
      t2946 = t823 * t2385
      t2950 = .CONVERT."0.3244294144E10" * t2936 + .CONVERT."0.2809631784960E13" * t1536 + .CONVERT."0.5937818664960E13"  &
      * t1538 + .CONVERT."0.5937818664960E13" * t1540 + .CONVERT."0.176653046169600E15"  &
      * t1542 - .CONVERT."0.14380266700800E14" * t1544 + .CONVERT."0.443286190953399543750E21"  &
      * t24 + .CONVERT."0.623902720E9" * t2944 + .CONVERT."0.35651584E8" * t2946 - .CONVERT."0.91226112E8"  &
      * t2528 - .CONVERT."0.340787200E9" * t2530
      t2962 = .CONVERT."0.340787200E9" * t2532 + .CONVERT."0.10679746560E11" * t2534 - .CONVERT."0.10679746560E11"  &
      * t2536 - .CONVERT."0.141699317760E12" * t2538 - .CONVERT."0.1977794108430940800E19"  &
      * t277 + .CONVERT."0.15865340471940960000E20" * t279 + .CONVERT."0.1977794108430940800E19"  &
      * t282 + .CONVERT."0.7704981652848480000E19" * t284 + .CONVERT."0.11011019879779920000E20"  &
      * t286 - .CONVERT."0.15865340471940960000E20" * t288 - .CONVERT."0.1132789432320E13"  &
      * t1842
      t2968 = t1420 * t859
      t2970 = t846 * t2055
      t2972 = t1423 * t859
      t2977 = t634 * t2804
      t2979 =  .CONVERT."-0.23496130560E11" * t1845 - .CONVERT."0.10454752788480E14" * t1847 + .CONVERT."0.1132789432320E13"  &
      * t1849 + .CONVERT."0.23496130560E11" * t1852 + .CONVERT."0.5098176512E10"  &
      * t2968 + .CONVERT."0.178257920E9" * t2970 + .CONVERT."0.5098176512E10" * t2972 - .CONVERT."0.221643095476699771875E21"  &
      * t27 + .CONVERT."0.209940549976080000E18" * t291 +  &
      .CONVERT."0.1173258240E10" * t1856 + .CONVERT."0.4456448E7" * t2977
      t2983 = t1475 * t1082
      t2985 = t2527 * t93
      t2987 = t2880 * t17
      t2988 = t2987 * R
      t2990 = t850 * t2385
      t2996 = t848 * t2055
      t2998 =  .CONVERT."-0.51443958470584680000E20" * t199 + .CONVERT."0.48413777448960E14" * t1054  &
      + .CONVERT."0.326673285120E12" * t1561 - .CONVERT."0.3244294144E10" * t2983 - .CONVERT."0.178257920E9"  &
      * t2985 - .CONVERT."0.4456448E7" * t2988 - .CONVERT."0.35651584E8" * t2990 - .CONVERT."0.3704831275622400E16"  &
      * t1056 - .CONVERT."0.1599137474457600E16" * t1058 + .CONVERT."0.9113503814553600E16"  &
      * t1060 + .CONVERT."0.1599137474457600E16" * t1062 + .CONVERT."0.178257920E9"  &
      * t2996
      t3013 = .CONVERT."0.84826457210880E14" * t1291 + .CONVERT."0.2030694625935360E16" * t1293  &
      + .CONVERT."0.368571506688000E15" * t1295 + .CONVERT."0.223843446696038400E18" * t501 +  &
      .CONVERT."0.3704831275622400E16" * t1065 + .CONVERT."0.974239012454400E15" * t1067 + .CONVERT."0.1532123873280E13"  &
      * t2198 + .CONVERT."0.2693552209920E13" * t2200 + .CONVERT."0.1648238592000E13"  &
      * t2202 + .CONVERT."0.1648238592000E13" * t2204 - .CONVERT."0.167190200320E12"  &
      * t2577
      t3025 = .CONVERT."0.32681492480E11" * t2579 + .CONVERT."0.32681492480E11" * t2581 + .CONVERT."0.90267713536E11"  &
      * t2583 + .CONVERT."0.125954949120E12" * t2585 + .CONVERT."0.206023427850240E15"  &
      * t1574 + .CONVERT."0.4604800557772800E16" * t1069 - .CONVERT."0.9113503814553600E16"  &
      * t1071 + .CONVERT."0.12667219409940480E17" * t1075 + .CONVERT."0.4604800557772800E16"  &
      * t1077 - .CONVERT."0.48413777448960E14" * t1080 - .CONVERT."0.115137337835520E15" * t1083
      t3038 = .CONVERT."0.6168840437760E13" * t1882 - .CONVERT."0.6168840437760E13" * t1884 + .CONVERT."0.27944286289920E14"  &
      * t1886 + .CONVERT."0.323396075520E12" * t1888 - .CONVERT."0.323396075520E12"  &
      * t1890 + .CONVERT."0.27992073330144000E17" * t381 - .CONVERT."0.55984146660288000E17"  &
      * t383 + .CONVERT."0.27992073330144000E17" * t385 + .CONVERT."0.8350207526707200E16"  &
      * t1088 + .CONVERT."0.12381320854425600E17" * t1090 + .CONVERT."0.363007211212800E15"  &
      * t1092
      t3051 = .CONVERT."0.115137337835520E15" * t1094 - .CONVERT."0.12381320854425600E17" * t1097  &
      + .CONVERT."0.363007211212800E15" * t1099 + .CONVERT."0.974239012454400E15" * t1101 +  &
      .CONVERT."0.12667219409940480E17" * t1103 + .CONVERT."0.8350207526707200E16" * t1105 +  &
      .CONVERT."0.87625529671680E14" * t1596 + .CONVERT."0.2809631784960E13" * t1598 + .CONVERT."0.253409303347200E15"  &
      * t1600 + .CONVERT."0.3293185097664000E16" * t507 + .CONVERT."0.14141030400E11"  &
      * t2237 + .CONVERT."0.12943687680E11" * t2239
      t3055 = t1079 * t1604
      t3057 = t1666 * t648
      t3059 = t1844 * t399
      t3061 = t1851 * t399
      t3063 = t2296 * t261
      t3065 = t2331 * t261
      t3071 = .CONVERT."0.12943687680E11" * t2241 - .CONVERT."0.623902720E9" * t3055 - .CONVERT."0.6372720640E10"  &
      * t3057 - .CONVERT."0.5098176512E10" * t3059 + .CONVERT."0.5098176512E10" * t3061  &
      + .CONVERT."0.1622147072E10" * t3063 - .CONVERT."0.1622147072E10" * t3065 + .CONVERT."0.3293185097664000E16"  &
      * t509 + .CONVERT."0.550106726400E12" * t1605 - .CONVERT."0.550106726400E12"  &
      * t1607 - .CONVERT."0.122815221736006800000E21" * t94
      t3084 = .CONVERT."0.1666653495091200E16" * t1324 + .CONVERT."0.1777855355781120E16" * t1327  &
      + .CONVERT."0.510115840819200E15" * t1329 - .CONVERT."0.591048254604532725000E21" * t33  &
      + .CONVERT."0.2422210560E10" * t2631 + .CONVERT."0.2422210560E10" * t2633 + .CONVERT."0.90267713536E11"  &
      * t2635 + .CONVERT."0.173750353920E12" * t2637 - .CONVERT."0.430620871211873842500E21"  &
      * t36 + .CONVERT."0.430620871211873842500E21" * t41 - .CONVERT."0.27944286289920E14"  &
      * t1921 - .CONVERT."0.24036238786560E14" * t1923
      t3093 = t1856 * t332
      t3098 = .CONVERT."0.10454752788480E14" * t1925 + .CONVERT."0.1807605596160E13" * t1927 +  &
      .CONVERT."0.1807605596160E13" * t1929 + .CONVERT."0.16460021760E11" * t2647 + .CONVERT."0.29940105657369600E17"  &
      * t701 + .CONVERT."0.16460021760E11" * t2650 + .CONVERT."0.817889280E9" * t2652  &
      + .CONVERT."0.3244294144E10" * t3093 + .CONVERT."0.111854293344513720000E21" * t143  &
      + .CONVERT."0.46646560024204140000E20" * t146 - .CONVERT."0.46646560024204140000E20" *  &
      t149
      t3110 = t2060 * t332
      t3112 = .CONVERT."0.108552808889244720000E21" * t151 + .CONVERT."0.108552808889244720000E21"  &
      * t153 + .CONVERT."0.42985327607602380000E20" * t156 + .CONVERT."0.42985327607602380000E20"  &
      * t158 + .CONVERT."0.81660149760E11" * t2267 - .CONVERT."0.81660149760E11" * t2269  &
      - .CONVERT."0.2317374259200E13" * t2271 - .CONVERT."0.2409872424960E13" * t2273 + .CONVERT."0.770490040320E12"  &
      * t2275 + .CONVERT."0.4587520E7" * t2667 + .CONVERT."0.2870816256000E13"  &
      * t1125 + .CONVERT."0.3244294144E10" * t3110
      t3117 = t1125 * t1369
      t3119 = t2822 * t59
      t3125 = t2347 * t155
      t3131 = .CONVERT."0.1622147072E10" * t3117 + .CONVERT."0.35651584E8" * t3119 + .CONVERT."0.49019107737600E14"  &
      * t1626 + .CONVERT."0.49019107737600E14" * t1632 + .CONVERT."0.520951478183136000E18"  &
      * t400 + .CONVERT."0.2409872424960E13" * t2285 + .CONVERT."0.623902720E9" * t3125  &
      + .CONVERT."0.33774185977401870000E20" * t99 + .CONVERT."0.33774185977401870000E20" *  &
      t101 - .CONVERT."0.67548371954803740000E20" * t103 + .CONVERT."0.7505374661644860000E19"  &
      * t163
      t3138 = t1735 * t592
      t3140 = t1215 * t1369
      t3145 = .CONVERT."0.7505374661644860000E19" * t165 + .CONVERT."0.167190200320E12" * t2684  &
      - .CONVERT."0.770490040320E12" * t2292 + .CONVERT."0.77737820160E11" * t2294 + .CONVERT."0.1544355840E10"  &
      * t2297 + .CONVERT."0.847243837440E12" * t2299 + .CONVERT."0.6372720640E10" * t3138  &
      + .CONVERT."0.1622147072E10" * t3140 + .CONVERT."0.288676577280E12" * t2301 + .CONVERT."0.288676577280E12"  &
      * t2303 + .CONVERT."0.14141030400E11" * t2305
      t3158 =  .CONVERT."-0.5741632512000E13" * t1134 + .CONVERT."0.510115840819200E15" * t1354  &
      + .CONVERT."0.33669597265920E14" * t1356 + .CONVERT."0.1666653495091200E16" * t1358 + .CONVERT."0.1364613574844520000E19"  &
      * t218 + .CONVERT."0.19737534136320E14" * t1957 + .CONVERT."0.29873463459840E14"  &
      * t1959 + .CONVERT."0.211028213760E12" * t1961 + .CONVERT."0.4078283489280E13"  &
      * t1963 + .CONVERT."0.4078283489280E13" * t1966 - .CONVERT."0.265770354769920E15"  &
      * t1645
      t3171 =  .CONVERT."-0.176653046169600E15" * t1647 - .CONVERT."0.2729227149689040000E19" *  &
      t220 + .CONVERT."0.206023427850240E15" * t1651 + .CONVERT."0.122815221736006800000E21" *  &
      t105 + .CONVERT."0.239489682385213260000E21" * t107 + .CONVERT."0.155598962376827970000E21"  &
      * t110 + .CONVERT."0.239489682385213260000E21" * t113 - .CONVERT."0.155598962376827970000E21"  &
      * t116 + .CONVERT."0.1364613574844520000E19" * t229 - .CONVERT."0.44370493440E11"  &
      * t2714 + .CONVERT."0.4440719360E10" * t2716 + .CONVERT."0.91226112E8" * t2719
      t3185 = .CONVERT."0.73569140736E11" * t2721 - .CONVERT."0.73569140736E11" * t2723 + .CONVERT."0.141699317760E12"  &
      * t2727 - .CONVERT."0.34024488960E11" * t1659 - .CONVERT."0.77737820160E11"  &
      * t2329 - .CONVERT."0.1544355840E10" * t2332 + .CONVERT."0.8856718295040E13" * t1370 +  &
      .CONVERT."0.317123788800E12" * t2337 + .CONVERT."0.317123788800E12" * t2339 + .CONVERT."0.1532123873280E13"  &
      * t2341 + .CONVERT."0.2693552209920E13" * t2343
      t3198 = .CONVERT."0.75694080E8" * t2345 + .CONVERT."0.75694080E8" * t2347 + .CONVERT."0.8856718295040E13"  &
      * t1372 - .CONVERT."0.151388160E9" * t2350 + .CONVERT."0.295524127302266362500E21"  &
      * t38 + .CONVERT."0.117840695132160E15" * t1664 - .CONVERT."0.326673285120E12" * t1667  &
      + .CONVERT."0.270193487819214960000E21" * t60 - .CONVERT."0.356164143034419720000E21" *  &
      t63 + .CONVERT."0.270193487819214960000E21" * t68 + .CONVERT."0.356164143034419720000E21"  &
      * t71 + .CONVERT."0.959798710886400E15" * t1381
      t3202 = t636 * t2804
      t3204 = t1560 * t648
      t3206 = t2667 * t59
      t3208 = t2345 * t155
      t3210 = t2804 * R
      t3211 = t662 * t3210
      t3213 = t657 * t3210
      t3218 = .CONVERT."0.253409303347200E15" * t1676 + .CONVERT."0.87625529671680E14" * t1678  &
      + .CONVERT."0.4456448E7" * t3202 + .CONVERT."0.6372720640E10" * t3204 + .CONVERT."0.35651584E8" * t3206  &
      + .CONVERT."0.623902720E9" * t3208 - .CONVERT."0.262144E6" * t3211 + .CONVERT."0.262144E6" * t3213  &
      - .CONVERT."0.1125220487086080E16" * t1383 - .CONVERT."0.2030694625935360E16" * t1385  &
      - .CONVERT."0.15010749323289720000E20" * t178
      t3223 = t2880 * t21
      t3224 = t3223 * R
      t3226 = t2718 * t93
      t3234 = .CONVERT."0.4160799498240E13" * t1389 - .CONVERT."0.117840695132160E15" * t1684 +  &
      .CONVERT."0.14380266700800E14" * t1686 - .CONVERT."0.2346516480E10" * t1999 + .CONVERT."0.4456448E7"  &
      * t3224 + .CONVERT."0.178257920E9" * t3226 - .CONVERT."0.419881099952160000E18" * t327  &
      + .CONVERT."0.295524127302266362500E21" * t43 + .CONVERT."0.19737534136320E14" * t2004  &
      + .CONVERT."0.29873463459840E14" * t2006 + .CONVERT."0.14348039946240E14" * t2008 + .CONVERT."0.14348039946240E14"  &
      * t2010
      t3249 = .CONVERT."0.211028213760E12" * t2012 + .CONVERT."0.7704981652848480000E19" * t330  &
      + .CONVERT."0.2746835066783808000E19" * t333 + .CONVERT."0.2746835066783808000E19" * t335  &
      + .CONVERT."0.17012244480E11" * t1694 + .CONVERT."0.1777855355781120E16" * t1397 - .CONVERT."0.952565760E9"  &
      * t2386 + .CONVERT."0.952565760E9" * t2388 - .CONVERT."0.886572381906799087500E21"  &
      * t14 + .CONVERT."0.443286190953399543750E21" * t18 + .CONVERT."0.221643095476699771875E21"  &
      * t26
      t3261 =  .CONVERT."-0.236419301841813090000E21" * t56 + .CONVERT."0.118209650920906545000E21"  &
      * t65 + .CONVERT."0.118209650920906545000E21" * t73 + .CONVERT."0.51443958470584680000E20"  &
      * t245 + .CONVERT."0.10675558700646840000E20" * t248 - .CONVERT."0.10675558700646840000E20"  &
      * t251 + .CONVERT."0.39485754085017240000E20" * t253 + .CONVERT."0.33250122755249400000E20"  &
      * t255 + .CONVERT."0.39485754085017240000E20" * t257 + .CONVERT."0.33250122755249400000E20"  &
      * t259 - .CONVERT."0.12017403417179160000E20" * t262
      t3274 = .CONVERT."0.12017403417179160000E20" * t264 - .CONVERT."0.11011019879779920000E20"  &
      * t353 + .CONVERT."0.18193835715335280000E20" * t355 + .CONVERT."0.44370493440E11" * t2796  &
      + .CONVERT."0.173750353920E12" * t2798 + .CONVERT."0.125954949120E12" * t2800 + .CONVERT."0.817889280E9"  &
      * t2802 + .CONVERT."0.22413312E8" * t2805 + .CONVERT."0.209940549976080000E18"  &
      * t357 + .CONVERT."0.22413312E8" * t2808 - .CONVERT."0.4440719360E10" * t2810
      t3287 = .CONVERT."0.229665300480E12" * t1420 - .CONVERT."0.111854293344513720000E21" * t187  &
      + .CONVERT."0.229665300480E12" * t1423 - .CONVERT."0.29320688517120E14" * t1721 + .CONVERT."0.265770354769920E15"  &
      * t1723 + .CONVERT."0.29320688517120E14" * t1726 - .CONVERT."0.6586370195328000E16"  &
      * t573 - .CONVERT."0.9175040E7" * t2820 + .CONVERT."0.4587520E7" * t2822 +  &
      .CONVERT."0.683603876229120000E18" * t575 + .CONVERT."0.1529095807291852800E19" * t577  &
      - .CONVERT."0.683603876229120000E18" * t579
      t3297 = t2881 * t13
      t3302 = .CONVERT."0.1286825813779968000E19" * t583 + .CONVERT."0.223843446696038400E18" *  &
      t585 + .CONVERT."0.41315533609996800E17" * t588 + .CONVERT."0.17012244480E11" * t1735 +  &
      .CONVERT."0.26671841280E11" * t2056 + .CONVERT."0.26671841280E11" * t2058 + .CONVERT."0.1173258240E10"  &
      * t2060 - .CONVERT."0.524288E6" * t3297 + .CONVERT."0.1286825813779968000E19" * t590  &
      + .CONVERT."0.82690710822720000E17" * t593 - .CONVERT."0.463067980607232000E18" * t595
      t3315 = .CONVERT."0.82690710822720000E17" * t597 + .CONVERT."0.463067980607232000E18" * t599  &
      + .CONVERT."0.1120430218811904000E19" * t601 + .CONVERT."0.1120430218811904000E19" *  &
      t603 - .CONVERT."0.1529095807291852800E19" * t605 - .CONVERT."0.41315533609996800E17" *  &
      t608 - .CONVERT."0.459330600960E12" * t1444 - .CONVERT."0.5035864289103648000E19" * t452  &
      - .CONVERT."0.307866236659027200E18" * t455 + .CONVERT."0.3680661842361504000E19" * t457  &
      + .CONVERT."0.307866236659027200E18" * t461 + .CONVERT."0.5035864289103648000E19" * t463
      t3327 = t2881 * t21
      t3329 =  .CONVERT."-0.3680661842361504000E19" * t465 + .CONVERT."0.5592031601476320000E19"  &
      * t467 + .CONVERT."0.2488990395763872000E19" * t469 + .CONVERT."0.2488990395763872000E19"  &
      * t471 + .CONVERT."0.5592031601476320000E19" * t473 + .CONVERT."0.1436301617148921600E19"  &
      * t475 + .CONVERT."0.1436301617148921600E19" * t477 - .CONVERT."0.520951478183136000E18"  &
      * t479 + .CONVERT."0.18193835715335280000E20" * t360 + .CONVERT."0.24036238786560E14"  &
      * t2089 + .CONVERT."0.262144E6" * t3327
      t3330 = t1694 * t592
      t3336 = t2881 * t17
      t3344 = .CONVERT."0.6372720640E10" * t3330 - .CONVERT."0.66028773888000E14" * t981 + .CONVERT."0.368571506688000E15"  &
      * t1462 - .CONVERT."0.959798710886400E15" * t1464 - .CONVERT."0.161251098624000E15"  &
      * t1466 + .CONVERT."0.262144E6" * t3336 + .CONVERT."0.2870816256000E13" * t1215  &
      - .CONVERT."0.84826457210880E14" * t1469 + .CONVERT."0.161251098624000E15" * t1471  &
      + .CONVERT."0.1125220487086080E16" * t1473 - .CONVERT."0.4160799498240E13" * t1476 + .CONVERT."0.33669597265920E14"  &
      * t1478
      t3350 = t2469 * t52
      t3351 = t2 * t3350
      fm(18) =  (t3084 + t2920 + t3051 + t3249 + t3171 + t2950 + t3013 + t2907  &
      + t3287 + t2998 + t3098 + t3302 + t3234 + t3158 + t2962 + t3261  &
      + t3025 + t3112 + t3218 + t3185 + t3329 + t2979 + t3145 + t3038  &
      + t2933 + t3071 + t3315 + t3274 + t3344 + t2895 + t3198 + t3131) /  &
      t3351 / .CONVERT."0.1048576E7"
      t3366 = .CONVERT."0.12826089327744000E17" * t634 + .CONVERT."0.12826089327744000E17" * t636  &
      + .CONVERT."0.13293214552493568000E20" * t638 + .CONVERT."0.2949803175166848000E19" *  &
      t640 - .CONVERT."0.25652178655488000E17" * t642 + .CONVERT."0.9131033002433126400E19" *  &
      t644 + .CONVERT."0.9131033002433126400E19" * t646 - .CONVERT."0.463067980607232000E18"  &
      * t649 + .CONVERT."0.463067980607232000E18" * t651 - .CONVERT."0.4033588859559705600E19"  &
      * t653 + .CONVERT."0.13586549062425292800E20" * t655 + .CONVERT."0.181761553237017600E18"  &
      * t658
      t3380 = .CONVERT."0.4033588859559705600E19" * t660 - .CONVERT."0.181761553237017600E18" *  &
      t663 - .CONVERT."0.13586549062425292800E20" * t665 + .CONVERT."0.8251029472637952000E19"  &
      * t668 - .CONVERT."0.8251029472637952000E19" * t670 + .CONVERT."0.1129120073759462400E19"  &
      * t672 + .CONVERT."0.13293214552493568000E20" * t674 + .CONVERT."0.2949803175166848000E19"  &
      * t676 + .CONVERT."0.536098481081856000E18" * t821 + .CONVERT."0.19132795077580800E17"  &
      * t824 - .CONVERT."0.536098481081856000E18" * t826 + .CONVERT."0.2970344039994777600E19"  &
      * t828 + .CONVERT."0.132653498574643200E18" * t830
      t3394 = .CONVERT."0.1276968760784640000E19" * t832 + .CONVERT."0.1398975354120960000E19"  &
      * t834 + .CONVERT."0.1398975354120960000E19" * t836 + .CONVERT."0.2970344039994777600E19"  &
      * t838 + .CONVERT."0.2464519770474854400E19" * t840 + .CONVERT."0.1276968760784640000E19"  &
      * t842 + .CONVERT."0.132653498574643200E18" * t844 + .CONVERT."0.1221532316928000E16"  &
      * t846 + .CONVERT."0.1221532316928000E16" * t848 - .CONVERT."0.19132795077580800E17" *  &
      t851 - .CONVERT."0.2464519770474854400E19" * t853 - .CONVERT."0.394242580892160000E18"  &
      * t857
      t3408 = .CONVERT."0.54124828902144000E17" * t860 + .CONVERT."0.394242580892160000E18" * t862  &
      + .CONVERT."0.54124828902144000E17" * t864 + .CONVERT."0.2420294387167641600E19" * t866  &
      - .CONVERT."0.2420294387167641600E19" * t868 - .CONVERT."0.55436906004480E14" * t2156  &
      + .CONVERT."0.125489506222080E15" * t2158 + .CONVERT."0.16401589065275783118750E23" *  &
      t22 + .CONVERT."0.441224003584E12" * t2936 + .CONVERT."0.109376374947840E15" * t1536 + .CONVERT."0.317998361640960E15"  &
      * t1538 + .CONVERT."0.317998361640960E15" * t1540 + .CONVERT."0.8609312289177600E16"  &
      * t1542
      t3423 =  .CONVERT."-0.576784858890240E15" * t1544 + .CONVERT."0.16401589065275783118750E23"  &
      * t24 + .CONVERT."0.96081018880E11" * t2944 + .CONVERT."0.6132072448E10" * t2946 - .CONVERT."0.3696230400E10"  &
      * t2528 - .CONVERT."0.34267463680E11" * t2530 + .CONVERT."0.34267463680E11"  &
      * t2532 + .CONVERT."0.979123568640E12" * t2534 - .CONVERT."0.979123568640E12" * t2536 -  &
      .CONVERT."0.9257688760320E13" * t2538 - .CONVERT."0.73525197261756240000E20" * t277 + .CONVERT."0.597752355194074080000E21"  &
      * t279
      t3433 = t1735 * t859
      t3438 = .CONVERT."0.73525197261756240000E20" * t282 + .CONVERT."0.288180885885852960000E21"  &
      * t284 + .CONVERT."0.422325891518010480000E21" * t286 - .CONVERT."0.597752355194074080000E21"  &
      * t288 - .CONVERT."0.46840480727040E14" * t1842 - .CONVERT."0.898836234240E12"  &
      * t1845 - .CONVERT."0.469631391989760E15" * t1847 + .CONVERT."0.46840480727040E14" * t1849  &
      + .CONVERT."0.898836234240E12" * t1852 + .CONVERT."0.22941794304E11" * t3433 + .CONVERT."0.647468417024E12"  &
      * t2968 + .CONVERT."0.29056040960E11" * t2970 + .CONVERT."0.647468417024E12"  &
      * t2972
      t3441 = t1423 * t1369
      t3443 = t3327 * t59
      t3454 =  .CONVERT."-0.8200794532637891559375E22" * t27 + .CONVERT."0.9732882432E10" * t3441  &
      + .CONVERT."0.80216064E8" * t3443 + .CONVERT."0.7767800349114960000E19" * t291 + .CONVERT."0.43410554880E11"  &
      * t1856 + .CONVERT."0.806617088E9" * t2977 - .CONVERT."0.1932689000114472600000E22"  &
      * t199 + .CONVERT."0.1815530385715200E16" * t1054 + .CONVERT."0.12374335733760E14"  &
      * t1561 - .CONVERT."0.441224003584E12" * t2983 - .CONVERT."0.11408506880E11" * t2985  &
      - .CONVERT."0.204996608E9" * t2988
      t3468 =  .CONVERT."-0.6132072448E10" * t2990 - .CONVERT."0.164159273598566400E18" * t1056  &
      - .CONVERT."0.62074560967372800E17" * t1058 + .CONVERT."0.368642409782169600E18" * t1060  &
      + .CONVERT."0.62074560967372800E17" * t1062 + .CONVERT."0.29056040960E11" * t2996 + .CONVERT."0.4129761216430080E16"  &
      * t1291 + .CONVERT."0.88680278421504000E17" * t1293 + .CONVERT."0.17466713723289600E17"  &
      * t1295 + .CONVERT."0.8412891534928742400E19" * t501 + .CONVERT."0.164159273598566400E18"  &
      * t1065 + .CONVERT."0.44188698064896000E17" * t1067 + .CONVERT."0.78770060328960E14"  &
      * t2198
      t3475 = t1560 * t1082
      t3477 = t2822 * t155
      t3486 = .CONVERT."0.153345230438400E15" * t2200 + .CONVERT."0.103140374937600E15" * t2202  &
      + .CONVERT."0.103140374937600E15" * t2204 + .CONVERT."0.16684941312E11" * t3475 + .CONVERT."0.1604321280E10"  &
      * t3477 - .CONVERT."0.12380321873920E14" * t2577 + .CONVERT."0.2851639132160E13"  &
      * t2579 + .CONVERT."0.2851639132160E13" * t2581 + .CONVERT."0.5507904962560E13" * t2583  &
      + .CONVERT."0.9879591321600E13" * t2585 + .CONVERT."0.9102526531338240E16" * t1574 +  &
      .CONVERT."0.182355818216140800E18" * t1069
      t3500 =  .CONVERT."-0.368642409782169600E18" * t1071 + .CONVERT."0.523832897019801600E18"  &
      * t1075 + .CONVERT."0.182355818216140800E18" * t1077 - .CONVERT."0.1815530385715200E16"  &
      * t1080 - .CONVERT."0.5345662113792000E16" * t1083 + .CONVERT."0.351100404695040E15" * t1882  &
      - .CONVERT."0.351100404695040E15" * t1884 + .CONVERT."0.1362751859589120E16" * t1886  &
      + .CONVERT."0.19767168368640E14" * t1888 - .CONVERT."0.19767168368640E14" * t1890 + .CONVERT."0.1035706713215328000E19"  &
      * t381 - .CONVERT."0.2071413426430656000E19" * t383 +  &
      .CONVERT."0.1035706713215328000E19" * t385
      t3505 = t3336 * t59
      t3507 = t2667 * t155
      t3509 = t1215 * t2055
      t3511 = t2345 * t332
      t3513 = t2060 * t592
      t3515 = t1856 * t592
      t3517 = t1420 * t1369
      t3521 = .CONVERT."0.361477467871027200E18" * t1088 + .CONVERT."0.523758608342323200E18" *  &
      t1090 + .CONVERT."0.13834943816601600E17" * t1092 + .CONVERT."0.80216064E8" * t3505 + .CONVERT."0.1604321280E10"  &
      * t3507 + .CONVERT."0.1604321280E10" * t3509 + .CONVERT."0.9732882432E10"  &
      * t3511 + .CONVERT."0.22941794304E11" * t3513 + .CONVERT."0.22941794304E11" * t3515 + .CONVERT."0.9732882432E10"  &
      * t3517 + .CONVERT."0.5345662113792000E16" * t1094 - .CONVERT."0.523758608342323200E18"  &
      * t1097
      t3535 = .CONVERT."0.13834943816601600E17" * t1099 + .CONVERT."0.44188698064896000E17" * t1101  &
      + .CONVERT."0.523832897019801600E18" * t1103 + .CONVERT."0.361477467871027200E18" *  &
      t1105 + .CONVERT."0.4409251028582400E16" * t1596 + .CONVERT."0.109376374947840E15" * t1598  &
      + .CONVERT."0.11956063702302720E17" * t1600 + .CONVERT."0.121847848613568000E18" * t507  &
      + .CONVERT."0.582176931840E12" * t2237 + .CONVERT."0.959009587200E12" * t2239 + .CONVERT."0.959009587200E12"  &
      * t2241 - .CONVERT."0.96081018880E11" * t3055 - .CONVERT."0.751981035520E12"  &
      * t3057
      t3550 =  .CONVERT."-0.509817651200E12" * t3059 + .CONVERT."0.509817651200E12" * t3061 + .CONVERT."0.133016059904E12"  &
      * t3063 - .CONVERT."0.133016059904E12" * t3065 + .CONVERT."0.121847848613568000E18"  &
      * t509 + .CONVERT."0.30365891297280E14" * t1605 - .CONVERT."0.30365891297280E14"  &
      * t1607 - .CONVERT."0.4593289292926654320000E22" * t94 + .CONVERT."0.74796126664089600E17"  &
      * t1324 + .CONVERT."0.75562842853048320E17" * t1327 + .CONVERT."0.20569729517568000E17"  &
      * t1329 - .CONVERT."0.21868785420367710825000E23" * t33
      t3551 = t848 * t2804
      t3565 = .CONVERT."0.80216064E8" * t3551 + .CONVERT."0.232807464960E12" * t2631 + .CONVERT."0.232807464960E12"  &
      * t2633 + .CONVERT."0.5507904962560E13" * t2635 + .CONVERT."0.12106857185280E14"  &
      * t2637 - .CONVERT."0.15958302874322383575000E23" * t36 + .CONVERT."0.15958302874322383575000E23"  &
      * t41 - .CONVERT."0.1362751859589120E16" * t1921 - .CONVERT."0.1268740758405120E16"  &
      * t1923 + .CONVERT."0.469631391989760E15" * t1925 + .CONVERT."0.106669126287360E15"  &
      * t1927 + .CONVERT."0.106669126287360E15" * t1929 + .CONVERT."0.864508968960E12" *  &
      t2647
      t3571 = t3351 * t13
      t3580 = t850 * t3210
      t3582 = .CONVERT."0.1129120073759462400E19" * t701 + .CONVERT."0.864508968960E12" * t2650  &
      + .CONVERT."0.36278108160E11" * t2652 + .CONVERT."0.295230767104E12" * t3093 - .CONVERT."0.1048576E7"  &
      * t3571 + .CONVERT."0.4192092901922365440000E22" * t143 + .CONVERT."0.1731496537410379740000E22"  &
      * t146 - .CONVERT."0.1731496537410379740000E22" * t149 + .CONVERT."0.4046761556201424060000E22"  &
      * t151 + .CONVERT."0.4046761556201424060000E22" * t153 +  &
      .CONVERT."0.1621160926915289760000E22" * t156 + .CONVERT."0.1621160926915289760000E22"  &
      * t158 - .CONVERT."0.9437184E7" * t3580
      t3596 = .CONVERT."0.5813546188800E13" * t2267 - .CONVERT."0.5813546188800E13" * t2269 - .CONVERT."0.125489506222080E15"  &
      * t2271 - .CONVERT."0.143967490867200E15" * t2273 + .CONVERT."0.37541462999040E14"  &
      * t2275 + .CONVERT."0.169738240E9" * t2667 + .CONVERT."0.106220201472000E15"  &
      * t1125 + .CONVERT."0.295230767104E12" * t3110 + .CONVERT."0.235211325440E12" * t3117  &
      + .CONVERT."0.1960837120E10" * t3119 + .CONVERT."0.2029001387212800E16" * t1626 + .CONVERT."0.2029001387212800E16"  &
      * t1632 + .CONVERT."0.20601263000878560000E20" * t400
      t3609 = t3351 * t21
      t3614 = .CONVERT."0.143967490867200E15" * t2285 + .CONVERT."0.45544898560E11" * t3125 + .CONVERT."0.1249644881163869190000E22"  &
      * t99 + .CONVERT."0.1249644881163869190000E22" * t101  &
      - .CONVERT."0.2499289762327738380000E22" * t103 + .CONVERT."0.277698862480859820000E21"  &
      * t163 + .CONVERT."0.277698862480859820000E21" * t165 + .CONVERT."0.12380321873920E14"  &
      * t2684 + .CONVERT."0.524288E6" * t3609 - .CONVERT."0.37541462999040E14" * t2292 + .CONVERT."0.3387275673600E13"  &
      * t2294 + .CONVERT."0.60149268480E11" * t2297
      t3628 = .CONVERT."0.55436906004480E14" * t2299 + .CONVERT."0.694626549760E12" * t3138 + .CONVERT."0.235211325440E12"  &
      * t3140 + .CONVERT."0.13308911616000E14" * t2301 + .CONVERT."0.13308911616000E14"  &
      * t2303 + .CONVERT."0.582176931840E12" * t2305 - .CONVERT."0.212440402944000E15"  &
      * t1134 + .CONVERT."0.20569729517568000E17" * t1354 + .CONVERT."0.1294216339046400E16"  &
      * t1356 + .CONVERT."0.74796126664089600E17" * t1358 + .CONVERT."0.50490702269247240000E20"  &
      * t218 + .CONVERT."0.924053723873280E15" * t1957 + .CONVERT."0.1516334731591680E16"  &
      * t1959
      t3636 = t3351 * t17
      t3643 = .CONVERT."0.8382892277760E13" * t1961 + .CONVERT."0.175738150748160E15" * t1963 +  &
      .CONVERT."0.175738150748160E15" * t1966 - .CONVERT."0.12135195994521600E17" * t1645 - .CONVERT."0.8609312289177600E16"  &
      * t1647 - .CONVERT."0.100981404538494480000E21" * t220 +  &
      .CONVERT."0.524288E6" * t3636 + .CONVERT."0.9102526531338240E16" * t1651 + .CONVERT."0.4593289292926654320000E22"  &
      * t105 + .CONVERT."0.8916385098034093680000E22" * t107 + .CONVERT."0.5772315421592319600000E22"  &
      * t110 + .CONVERT."0.8916385098034093680000E22" * t113
      t3657 =  .CONVERT."-0.5772315421592319600000E22" * t116 + .CONVERT."0.50490702269247240000E20"  &
      * t229 - .CONVERT."0.2517667676160E13" * t2714 + .CONVERT."0.214842736640E12" * t2716  &
      + .CONVERT."0.3696230400E10" * t2719 + .CONVERT."0.6094501969920E13" * t2721 - .CONVERT."0.6094501969920E13"  &
      * t2723 + .CONVERT."0.9257688760320E13" * t2727 - .CONVERT."0.1258906091520E13"  &
      * t1659 - .CONVERT."0.3387275673600E13" * t2329 - .CONVERT."0.60149268480E11" * t2332  &
      + .CONVERT."0.442835914752000E15" * t1370 + .CONVERT."0.21661120266240E14" * t2337
      t3668 = t1851 * t648
      t3670 = t823 * t3210
      t3672 = t1475 * t1604
      t3674 = t1844 * t648
      t3676 = .CONVERT."0.21661120266240E14" * t2339 + .CONVERT."0.78770060328960E14" * t2341 +  &
      .CONVERT."0.153345230438400E15" * t2343 + .CONVERT."0.2800680960E10" * t2345 + .CONVERT."0.2800680960E10"  &
      * t2347 + .CONVERT."0.442835914752000E15" * t1372 - .CONVERT."0.5601361920E10" *  &
      t2350 + .CONVERT."0.10934392710183855412500E23" * t38 + .CONVERT."0.25490882560E11" * t3668  &
      + .CONVERT."0.9437184E7" * t3670 - .CONVERT."0.4492099584E10" * t3672 - .CONVERT."0.25490882560E11"  &
      * t3674
      t3677 = t2331 * t399
      t3679 = t2296 * t399
      t3681 = t2718 * t261
      t3683 = t2527 * t261
      t3691 = t1388 * t1604
      t3693 = t1053 * t2385
      t3696 =  .CONVERT."-0.16684941312E11" * t3677 + .CONVERT."0.16684941312E11" * t3679 + .CONVERT."0.4492099584E10"  &
      * t3681 - .CONVERT."0.4492099584E10" * t3683 + .CONVERT."0.5038283082792960E16"  &
      * t1664 - .CONVERT."0.12374335733760E14" * t1667 + .CONVERT."0.10047820328277056325000E23"  &
      * t60 - .CONVERT."0.13205706717164131170000E23" * t63 + .CONVERT."0.10047820328277056325000E23"  &
      * t68 + .CONVERT."0.13205706717164131170000E23" * t71 + .CONVERT."0.4492099584E10"  &
      * t3691 + .CONVERT."0.427819008E9" * t3693 + .CONVERT."0.44265850533273600E17"  &
      * t1381
      t3710 = .CONVERT."0.11956063702302720E17" * t1676 + .CONVERT."0.4409251028582400E16" * t1678  &
      + .CONVERT."0.806617088E9" * t3202 + .CONVERT."0.751981035520E12" * t3204 + .CONVERT."0.1960837120E10"  &
      * t3206 + .CONVERT."0.45544898560E11" * t3208 - .CONVERT."0.49807360E8" * t3211  &
      + .CONVERT."0.49807360E8" * t3213 - .CONVERT."0.46565357025116160E17" * t1383 - .CONVERT."0.88680278421504000E17"  &
      * t1385 - .CONVERT."0.555397724961719640000E21" * t178 + .CONVERT."0.156659580887040E15"  &
      * t1389
      t3711 = t2347 * t332
      t3725 = .CONVERT."0.9732882432E10" * t3711 - .CONVERT."0.5038283082792960E16" * t1684 + .CONVERT."0.576784858890240E15"  &
      * t1686 - .CONVERT."0.86821109760E11" * t1999 + .CONVERT."0.204996608E9"  &
      * t3224 + .CONVERT."0.11408506880E11" * t3226 - .CONVERT."0.15535600698229920000E20"  &
      * t327 + .CONVERT."0.10934392710183855412500E23" * t43 + .CONVERT."0.924053723873280E15"  &
      * t2004 + .CONVERT."0.1516334731591680E16" * t2006 + .CONVERT."0.786821870714880E15"  &
      * t2008 + .CONVERT."0.786821870714880E15" * t2010 + .CONVERT."0.8382892277760E13" * t2012
      t3741 = .CONVERT."0.288180885885852960000E21" * t330 + .CONVERT."0.106439858837872560000E21"  &
      * t333 + .CONVERT."0.106439858837872560000E21" * t335 + .CONVERT."0.629453045760E12"  &
      * t1694 + .CONVERT."0.75562842853048320E17" * t1397 - .CONVERT."0.73347563520E11" * t2386  &
      + .CONVERT."0.73347563520E11" * t2388 - .CONVERT."0.32803178130551566237500E23" * t14  &
      + .CONVERT."0.16401589065275783118750E23" * t18 + .CONVERT."0.8200794532637891559375E22"  &
      * t26 - .CONVERT."0.8747514168147084330000E22" * t56 + .CONVERT."0.4373757084073542165000E22"  &
      * t65
      t3743 = t3223 * t93
      t3745 = t1666 * t1082
      t3747 = t2987 * t93
      t3749 = t3350 * t17
      t3750 = t3749 * R
      t3752 = t1079 * t2385
      t3754 = t1125 * t2055
      t3756 = t1694 * t859
      t3758 = t3350 * t21
      t3759 = t3758 * R
      t3761 = t2804 * t59
      t3762 = t634 * t3761
      t3767 = .CONVERT."0.4373757084073542165000E22" * t73 + .CONVERT."0.427819008E9" * t3743 -  &
      .CONVERT."0.16684941312E11" * t3745 - .CONVERT."0.427819008E9" * t3747 - .CONVERT."0.9437184E7" *  &
      t3750 - .CONVERT."0.427819008E9" * t3752 + .CONVERT."0.1604321280E10" * t3754 + .CONVERT."0.22941794304E11"  &
      * t3756 + .CONVERT."0.9437184E7" * t3759 + .CONVERT."0.524288E6" * t3762 + .CONVERT."0.1932689000114472600000E22"  &
      * t245 + .CONVERT."0.396543954289162680000E21" * t248  &
      - .CONVERT."0.396543954289162680000E21" * t251
      t3781 = .CONVERT."0.1494251864454749400000E22" * t253 + .CONVERT."0.1241402174973880920000E22"  &
      * t255 + .CONVERT."0.1494251864454749400000E22" * t257 + .CONVERT."0.1241402174973880920000E22"  &
      * t259 - .CONVERT."0.458510161147758720000E21" * t262 + .CONVERT."0.458510161147758720000E21"  &
      * t264 - .CONVERT."0.422325891518010480000E21" * t353 + .CONVERT."0.691286825140591680000E21"  &
      * t355 + .CONVERT."0.2517667676160E13" * t2796 + .CONVERT."0.12106857185280E14"  &
      * t2798 + .CONVERT."0.9879591321600E13" * t2800 + .CONVERT."0.36278108160E11"  &
      * t2802
      t3786 = t636 * t3761
      t3788 = t846 * t2804
      t3797 = .CONVERT."0.2353397760E10" * t2805 + .CONVERT."0.7767800349114960000E19" * t357 +  &
      .CONVERT."0.2353397760E10" * t2808 - .CONVERT."0.214842736640E12" * t2810 + .CONVERT."0.524288E6"  &
      * t3786 + .CONVERT."0.80216064E8" * t3788 + .CONVERT."0.8497616117760E13" * t1420 - .CONVERT."0.4192092901922365440000E22"  &
      * t187 + .CONVERT."0.8497616117760E13" * t1423 - .CONVERT."0.1522530386657280E16"  &
      * t1721 + .CONVERT."0.12135195994521600E17" * t1723 + .CONVERT."0.1522530386657280E16"  &
      * t1726 - .CONVERT."0.243695697227136000E18" * t573
      t3812 =  .CONVERT."-0.339476480E9" * t2820 + .CONVERT."0.169738240E9" * t2822 + .CONVERT."0.25956816072290611200E20"  &
      * t575 + .CONVERT."0.59483186963456256000E20" * t577 - .CONVERT."0.25956816072290611200E20"  &
      * t579 + .CONVERT."0.49429206418394880000E20" * t583 + .CONVERT."0.8412891534928742400E19"  &
      * t585 + .CONVERT."0.1539342825788275200E19" * t588 +  &
      .CONVERT."0.629453045760E12" * t1735 + .CONVERT."0.1686993960960E13" * t2056 + .CONVERT."0.1686993960960E13"  &
      * t2058 + .CONVERT."0.43410554880E11" * t2060
      t3826 =  .CONVERT."-0.19398656E8" * t3297 + .CONVERT."0.49429206418394880000E20" * t590 +  &
      .CONVERT."0.3357242859402432000E19" * t593 - .CONVERT."0.18522719224289280000E20" * t595  &
      + .CONVERT."0.3357242859402432000E19" * t597 + .CONVERT."0.18522719224289280000E20" * t599  &
      + .CONVERT."0.44180895058844544000E20" * t601 + .CONVERT."0.44180895058844544000E20"  &
      * t603 - .CONVERT."0.59483186963456256000E20" * t605 - .CONVERT."0.1539342825788275200E19"  &
      * t608 - .CONVERT."0.16995232235520E14" * t1444 - .CONVERT."0.194378046996028896000E21"  &
      * t452 - .CONVERT."0.11456392759971667200E20" * t455
      t3841 = .CONVERT."0.139157190308616480000E21" * t457 + .CONVERT."0.11456392759971667200E20"  &
      * t461 + .CONVERT."0.194378046996028896000E21" * t463 - .CONVERT."0.139157190308616480000E21"  &
      * t465 + .CONVERT."0.213511174012936800000E21" * t467 + .CONVERT."0.97207440974515872000E20"  &
      * t469 + .CONVERT."0.97207440974515872000E20" * t471 + .CONVERT."0.213511174012936800000E21"  &
      * t473 + .CONVERT."0.53836790334132960000E20" * t475 + .CONVERT."0.53836790334132960000E20"  &
      * t477 - .CONVERT."0.20601263000878560000E20" * t479 +  &
      .CONVERT."0.691286825140591680000E21" * t360 + .CONVERT."0.1268740758405120E16" * t2089
      t3855 = .CONVERT."0.9699328E7" * t3327 + .CONVERT."0.694626549760E12" * t3330 - .CONVERT."0.2443064633856000E16"  &
      * t981 + .CONVERT."0.17466713723289600E17" * t1462 - .CONVERT."0.44265850533273600E17"  &
      * t1464 - .CONVERT."0.6343055850700800E16" * t1466 + .CONVERT."0.9699328E7"  &
      * t3336 + .CONVERT."0.106220201472000E15" * t1215 - .CONVERT."0.4129761216430080E16" * t1469  &
      + .CONVERT."0.6343055850700800E16" * t1471 + .CONVERT."0.46565357025116160E17" * t1473  &
      - .CONVERT."0.156659580887040E15" * t1476 + .CONVERT."0.1294216339046400E16" * t1478
      t3861 = t2469 * t85
      t3862 = t2 * t3861
      fm(19) =  -(t3366 + t3454 + t3380 + t3521 + t3696 + t3423 + t3468 + t3535  &
      + t3486 + t3841 + t3565 + t3550 + t3614 + t3676 + t3710 + t3438  &
      + t3826 + t3500 + t3394 + t3767 + t3643 + t3812 + t3797 + t3855  &
      + t3408 + t3781 + t3741 + t3582 + t3628 + t3657 + t3725 + t3596)  &
      / t3862 / .CONVERT."0.2097152E7"
      t3879 =  .CONVERT."-0.500217483782016000E18" * t634 - .CONVERT."0.500217483782016000E18" *  &
      t636 - .CONVERT."0.552951742409434368000E21" * t638 - .CONVERT."0.126354413072055168000E21"  &
      * t640 + .CONVERT."0.1000434967564032000E19" * t642 - .CONVERT."0.369916837039766016000E21"  &
      * t644 - .CONVERT."0.369916837039766016000E21" * t646 + .CONVERT."0.20143457156414592000E20"  &
      * t649 - .CONVERT."0.20143457156414592000E20" * t651 + .CONVERT."0.161511958984311936000E21"  &
      * t653 - .CONVERT."0.557488513324334592000E21" * t655 - .CONVERT."0.7139373966781056000E19"  &
      * t658 - .CONVERT."0.161511958984311936000E21" * t660
      t3894 = .CONVERT."0.7139373966781056000E19" * t663 + .CONVERT."0.557488513324334592000E21"  &
      * t665 - .CONVERT."0.348185024327492352000E21" * t668 + .CONVERT."0.348185024327492352000E21"  &
      * t670 - .CONVERT."0.44745110344142208000E20" * t672 - .CONVERT."0.552951742409434368000E21"  &
      * t674 - .CONVERT."0.126354413072055168000E21" * t676 - .CONVERT."0.21583485969357312000E20"  &
      * t821 - .CONVERT."0.752698391603558400E18" * t824 + .CONVERT."0.21583485969357312000E20"  &
      * t826 - .CONVERT."0.125047784189712384000E21" * t828 - .CONVERT."0.5274833225485824000E19"  &
      * t830 - .CONVERT."0.55602853076010240000E20" * t832  &
      - .CONVERT."0.57106701514646784000E20" * t834
      t3910 =  .CONVERT."-0.57106701514646784000E20" * t836 - .CONVERT."0.125047784189712384000E21"  &
      * t838 - .CONVERT."0.102119118850638489600E21" * t840 - .CONVERT."0.55602853076010240000E20"  &
      * t842 - .CONVERT."0.5274833225485824000E19" * t844 - .CONVERT."0.47639760360192000E17"  &
      * t846 - .CONVERT."0.47639760360192000E17" * t848 + .CONVERT."0.752698391603558400E18"  &
      * t851 + .CONVERT."0.102119118850638489600E21" * t853 + .CONVERT."0.17470291995636480000E20"  &
      * t857 - .CONVERT."0.2441631170474496000E19" * t860 - .CONVERT."0.17470291995636480000E20"  &
      * t862 - .CONVERT."0.2441631170474496000E19" * t864 - .CONVERT."0.103595847729454080000E21"  &
      * t866
      t3925 = .CONVERT."0.103595847729454080000E21" * t868 + .CONVERT."0.3329145764904960E16" *  &
      t2156 - .CONVERT."0.6455953760256000E16" * t2158 - .CONVERT."0.639661973545755541631250E24"  &
      * t22 - .CONVERT."0.38566546636800E14" * t2936 - .CONVERT."0.4433021089136640E16" *  &
      t1536 - .CONVERT."0.16777154941747200E17" * t1538 - .CONVERT."0.16777154941747200E17" *  &
      t1540 - .CONVERT."0.418919512467456000E18" * t1542 + .CONVERT."0.23926317262848000E17"  &
      * t1544 - .CONVERT."0.639661973545755541631250E24" * t24 - .CONVERT."0.9294902722560E13"  &
      * t2944 - .CONVERT."0.650659233792E12" * t2946 + .CONVERT."0.151773511680E12" * t2528
      t3941 = .CONVERT."0.2784331038720E13" * t2530 - .CONVERT."0.2784331038720E13" * t2532 - .CONVERT."0.73552680714240E14"  &
      * t2534 + .CONVERT."0.73552680714240E14" * t2536 + .CONVERT."0.528869086986240E15"  &
      * t2538 + .CONVERT."0.2879249639184238320000E22" * t277 - .CONVERT."0.23683000650804855360000E23"  &
      * t279 - .CONVERT."0.2879249639184238320000E22" * t282  &
      - .CONVERT."0.11344957063329970080000E23" * t284 - .CONVERT."0.16997626688263341120000E23"  &
      * t286 + .CONVERT."0.23683000650804855360000E23" * t288 + .CONVERT."0.1981248717127680E16"  &
      * t1842 + .CONVERT."0.35894776135680E14" * t1845
      t3956 = .CONVERT."0.21179039819857920E17" * t1847 - .CONVERT."0.1981248717127680E16" * t1849  &
      - .CONVERT."0.35894776135680E14" * t1852 - .CONVERT."0.3074200436736E13" * t3433 - .CONVERT."0.53584384229376E14"  &
      * t2968 - .CONVERT."0.2946870804480E13" * t2970 - .CONVERT."0.53584384229376E14"  &
      * t2972 + .CONVERT."0.319830986772877770815625E24" * t27 - .CONVERT."0.1489131012096E13"  &
      * t3441 - .CONVERT."0.4652531712E10" * t3443 - .CONVERT."0.302944213615483440000E21"  &
      * t291 - .CONVERT."0.1693011640320E13" * t1856 - .CONVERT."0.89374064640E11" *  &
      t2977 + .CONVERT."0.76391067919796229600000E23" * t199
      t3972 =  .CONVERT."-0.71572671346176000E17" * t1054 - .CONVERT."0.491180758548480E15" * t1561  &
      + .CONVERT."0.38566546636800E14" * t2983 + .CONVERT."0.582101237760E12" * t2985 + .CONVERT."0.8756920320E10"  &
      * t2988 + .CONVERT."0.650659233792E12" * t2990 + .CONVERT."0.7446404523317760000E19"  &
      * t1056 + .CONVERT."0.2516920617693081600E19" * t1058 - .CONVERT."0.15468480854617190400E20"  &
      * t1060 - .CONVERT."0.2516920617693081600E19" * t1062 - .CONVERT."0.2946870804480E13"  &
      * t2996 - .CONVERT."0.202312750768128000E18" * t1291 - .CONVERT."0.3957468857575833600E19"  &
      * t1293 - .CONVERT."0.835897072685875200E18" * t1295
      t3975 = t1215 * t2804
      t3977 = t2667 * t332
      t3979 = t2345 * t592
      t3981 = t1735 * t1369
      t3983 = t848 * t3761
      t3985 = t1856 * t859
      t3987 = t3327 * t155
      t3994 =  .CONVERT."-0.332495763026499072000E21" * t501 - .CONVERT."0.7446404523317760000E19"  &
      * t1065 - .CONVERT."0.1016070144E10" * t3975 - .CONVERT."0.28449964032E11" * t3977 -  &
      .CONVERT."0.79253471232E11" * t3979 - .CONVERT."0.52835647488E11" * t3981 - .CONVERT."0.19922944E8"  &
      * t3983 - .CONVERT."0.96865353728E11" * t3985 - .CONVERT."0.4064280576E10" * t3987 - .CONVERT."0.2045640969275904000E19"  &
      * t1067 - .CONVERT."0.3890151076331520E16" * t2198 - .CONVERT."0.8211696869376000E16"  &
      * t2200 - .CONVERT."0.5967652007116800E16" * t2202 - .CONVERT."0.5967652007116800E16"  &
      * t2204
      t4011 =  .CONVERT."-0.2394289078272E13" * t3475 - .CONVERT."0.123532738560E12" * t3477 + .CONVERT."0.780330270720000E15"  &
      * t2577 - .CONVERT."0.205525556920320E15" * t2579 - .CONVERT."0.205525556920320E15"  &
      * t2581 - .CONVERT."0.298717906206720E15" * t2583 - .CONVERT."0.652289192755200E15"  &
      * t2585 - .CONVERT."0.408101877320417280E18" * t1574 - .CONVERT."0.7517264034728448000E19"  &
      * t1069 + .CONVERT."0.15468480854617190400E20" * t1071 - .CONVERT."0.22394051355374899200E20"  &
      * t1075 - .CONVERT."0.7517264034728448000E19" * t1077 +  &
      .CONVERT."0.71572671346176000E17" * t1080
      t4026 = .CONVERT."0.252582534876672000E18" * t1083 - .CONVERT."0.19236671329075200E17" *  &
      t1882 + .CONVERT."0.19236671329075200E17" * t1884 - .CONVERT."0.65642226664734720E17" *  &
      t1886 - .CONVERT."0.1151373378355200E16" * t1888 + .CONVERT."0.1151373378355200E16" * t1890  &
      - .CONVERT."0.40392561815397792000E20" * t381 + .CONVERT."0.80785123630795584000E20"  &
      * t383 - .CONVERT."0.40392561815397792000E20" * t385 - .CONVERT."0.16069985524809216000E20"  &
      * t1088 - .CONVERT."0.22827724846198272000E20" * t1090 - .CONVERT."0.552601576003276800E18"  &
      * t1092 - .CONVERT."0.4652531712E10" * t3505 - .CONVERT."0.123532738560E12" * t3507
      t4042 =  .CONVERT."-0.275943260160E12" * t3509 - .CONVERT."0.934356713472E12" * t3511 - .CONVERT."0.2638306344960E13"  &
      * t3513 - .CONVERT."0.2638306344960E13" * t3515 - .CONVERT."0.1489131012096E13"  &
      * t3517 - .CONVERT."0.252582534876672000E18" * t1094 + .CONVERT."0.22827724846198272000E20"  &
      * t1097 - .CONVERT."0.552601576003276800E18" * t1099 - .CONVERT."0.2045640969275904000E19"  &
      * t1101 - .CONVERT."0.22394051355374899200E20" * t1103 - .CONVERT."0.16069985524809216000E20"  &
      * t1105 - .CONVERT."0.220468651141939200E18" * t1596 -  &
      .CONVERT."0.4433021089136640E16" * t1598 - .CONVERT."0.566074084217241600E18" * t1600
      t4044 = t2804 * t93
      t4045 = t823 * t4044
      t4059 =  .CONVERT."-0.4752066095929152000E19" * t507 - .CONVERT."0.1048576E7" * t4045 - .CONVERT."0.24385226342400E14"  &
      * t2237 - .CONVERT."0.64006535577600E14" * t2239 - .CONVERT."0.64006535577600E14"  &
      * t2241 + .CONVERT."0.9294902722560E13" * t3055 + .CONVERT."0.58750111580160E14"  &
      * t3057 + .CONVERT."0.35139181608960E14" * t3059 - .CONVERT."0.35139181608960E14" *  &
      t3061 - .CONVERT."0.7961497829376E13" * t3063 + .CONVERT."0.7961497829376E13" * t3065 -  &
      .CONVERT."0.4752066095929152000E19" * t509 - .CONVERT."0.1644819111936000E16" * t1605 +  &
      .CONVERT."0.1644819111936000E16" * t1607
      t4066 = t3862 * t13
      t4077 = .CONVERT."0.180860765908987013850000E24" * t94 - .CONVERT."0.3415986939036672000E19"  &
      * t1324 - .CONVERT."0.3296207470664908800E19" * t1327 - .CONVERT."0.859115889683251200E18"  &
      * t1329 + .CONVERT."0.2097152E7" * t4066 + .CONVERT."0.852882631394340722175000E24"  &
      * t33 - .CONVERT."0.15321268224E11" * t3551 - .CONVERT."0.18201260851200E14" * t2631  &
      - .CONVERT."0.18201260851200E14" * t2633 - .CONVERT."0.298717906206720E15" * t2635 - .CONVERT."0.727165473914880E15"  &
      * t2637 + .CONVERT."0.623260384480479758512500E24" * t36 -  &
      .CONVERT."0.623260384480479758512500E24" * t41 + .CONVERT."0.65642226664734720E17" * t1921
      t4092 = .CONVERT."0.65236826392657920E17" * t1923 - .CONVERT."0.21179039819857920E17" * t1925  &
      - .CONVERT."0.6027778274918400E16" * t1927 - .CONVERT."0.6027778274918400E16" * t1929  &
      - .CONVERT."0.42037464268800E14" * t2647 - .CONVERT."0.44745110344142208000E20" * t701  &
      - .CONVERT."0.42037464268800E14" * t2650 - .CONVERT."0.1574877265920E13" * t2652 - .CONVERT."0.19003452948480E14"  &
      * t3093 + .CONVERT."0.40894464E8" * t3571 - .CONVERT."0.165358414545359555520000E24"  &
      * t143 - .CONVERT."0.67720313265234149520000E23" * t146 + .CONVERT."0.67720313265234149520000E23"  &
      * t149 - .CONVERT."0.158873770837698396480000E24" * t151
      t4108 =  .CONVERT."-0.158873770837698396480000E24" * t153 - .CONVERT."0.64306050100973160480000E23"  &
      * t156 - .CONVERT."0.64306050100973160480000E23" * t158 + .CONVERT."0.1892155392E10"  &
      * t3580 - .CONVERT."0.374957059276800E15" * t2267 + .CONVERT."0.374957059276800E15"  &
      * t2269 + .CONVERT."0.6455953760256000E16" * t2271 + .CONVERT."0.8017598324736000E16"  &
      * t2273 - .CONVERT."0.1778778104463360E16" * t2275 - .CONVERT."0.6619791360E10" * t2667  &
      - .CONVERT."0.4142587857408000E16" * t1125 - .CONVERT."0.19003452948480E14" * t3110 - .CONVERT."0.21655663411200E14"  &
      * t3117 - .CONVERT."0.91713699840E11" * t3119
      t4114 = t1388 * t2385
      t4124 =  .CONVERT."-0.86289592931942400E17" * t1626 - .CONVERT."0.86289592931942400E17" *  &
      t1632 - .CONVERT."0.851518870702980480000E21" * t400 - .CONVERT."0.8017598324736000E16"  &
      * t2285 - .CONVERT."0.2523062599680E13" * t3125 - .CONVERT."0.4064280576E10" * t4114 - .CONVERT."0.48736150365390898410000E23"  &
      * t99 - .CONVERT."0.48736150365390898410000E23" *  &
      t101 + .CONVERT."0.97472300730781796820000E23" * t103 - .CONVERT."0.10830255636753532980000E23"  &
      * t163 - .CONVERT."0.10830255636753532980000E23" * t165 - .CONVERT."0.780330270720000E15"  &
      * t2684 - .CONVERT."0.20447232E8" * t3609 + .CONVERT."0.1778778104463360E16"  &
      * t2292
      t4142 =  .CONVERT."-0.147706778419200E15" * t2294 - .CONVERT."0.2425836994560E13" * t2297  &
      - .CONVERT."0.3329145764904960E16" * t2299 - .CONVERT."0.51064610488320E14" * t3138 - .CONVERT."0.21655663411200E14"  &
      * t3140 - .CONVERT."0.604864202342400E15" * t2301 - .CONVERT."0.604864202342400E15"  &
      * t2303 - .CONVERT."0.24385226342400E14" * t2305 + .CONVERT."0.8285175714816000E16"  &
      * t1134 - .CONVERT."0.859115889683251200E18" * t1354 - .CONVERT."0.52008409829376000E17"  &
      * t1356 - .CONVERT."0.3415986939036672000E19" * t1358 - .CONVERT."0.1969137388500642360000E22"  &
      * t218
      t4157 =  .CONVERT."-0.43066478810234880E17" * t1957 - .CONVERT."0.75476544562298880E17" *  &
      t1959 - .CONVERT."0.344096128696320E15" * t1961 - .CONVERT."0.7671906602680320E16" * t1963  &
      - .CONVERT."0.7671906602680320E16" * t1966 + .CONVERT."0.559054966445015040E18" * t1645  &
      + .CONVERT."0.418919512467456000E18" * t1647 + .CONVERT."0.3938274777001284720000E22"  &
      * t220 - .CONVERT."0.20447232E8" * t3636 - .CONVERT."0.408101877320417280E18" * t1651 -  &
      .CONVERT."0.180860765908987013850000E24" * t105 - .CONVERT."0.349664147424041560110000E24"  &
      * t107 - .CONVERT."0.225645336515021893470000E24" * t110 - .CONVERT."0.349664147424041560110000E24"  &
      * t113
      t4171 = t2296 * t648
      t4173 = t1079 * t3210
      t4175 = .CONVERT."0.225645336515021893470000E24" * t116 - .CONVERT."0.1969137388500642360000E22"  &
      * t229 + .CONVERT."0.129395093667840E15" * t2714 - .CONVERT."0.9872489840640E13"  &
      * t2716 - .CONVERT."0.151773511680E12" * t2719 - .CONVERT."0.420761095372800E15" * t2721  &
      + .CONVERT."0.420761095372800E15" * t2723 - .CONVERT."0.528869086986240E15" * t2727 +  &
      .CONVERT."0.49097337569280E14" * t1659 + .CONVERT."0.147706778419200E15" * t2329 + .CONVERT."0.2425836994560E13"  &
      * t2332 - .CONVERT."0.22205058011136000E17" * t1370 - .CONVERT."0.96865353728E11"  &
      * t4171 + .CONVERT."0.179306496E9" * t4173
      t4176 = t1053 * t3210
      t4191 =  .CONVERT."-0.179306496E9" * t4176 - .CONVERT."0.1348761467289600E16" * t2337 - .CONVERT."0.1348761467289600E16"  &
      * t2339 - .CONVERT."0.3890151076331520E16" * t2341 - .CONVERT."0.8211696869376000E16"  &
      * t2343 - .CONVERT."0.109226557440E12" * t2345 - .CONVERT."0.109226557440E12"  &
      * t2347 - .CONVERT."0.22205058011136000E17" * t1372 + .CONVERT."0.218453114880E12"  &
      * t2350 - .CONVERT."0.426441315697170361087500E24" * t38 - .CONVERT."0.3173614878720E13"  &
      * t3668 - .CONVERT."0.1892155392E10" * t3670 + .CONVERT."0.729966182400E12" * t3672  &
      + .CONVERT."0.3173614878720E13" * t3674
      t4206 = t2347 * t592
      t4208 = t1125 * t2804
      t4210 = .CONVERT."0.1760261308416E13" * t3677 - .CONVERT."0.1760261308416E13" * t3679 - .CONVERT."0.388566614016E12"  &
      * t3681 + .CONVERT."0.388566614016E12" * t3683 - .CONVERT."0.219920985492848640E18"  &
      * t1664 + .CONVERT."0.491180758548480E15" * t1667 - .CONVERT."0.393638137566618794850000E24"  &
      * t60 + .CONVERT."0.515985126269757068925000E24" * t63 - .CONVERT."0.393638137566618794850000E24"  &
      * t68 - .CONVERT."0.515985126269757068925000E24"  &
      * t71 - .CONVERT."0.729966182400E12" * t3691 - .CONVERT."0.77649149952E11" * t3693 - .CONVERT."0.79253471232E11"  &
      * t4206 - .CONVERT."0.1016070144E10" * t4208
      t4211 = t846 * t3761
      t4226 =  .CONVERT."-0.19922944E8" * t4211 - .CONVERT."0.2069388045204480000E19" * t1381 -  &
      .CONVERT."0.566074084217241600E18" * t1676 - .CONVERT."0.220468651141939200E18" * t1678  &
      - .CONVERT."0.89374064640E11" * t3202 - .CONVERT."0.58750111580160E14" * t3204 - .CONVERT."0.91713699840E11"  &
      * t3206 - .CONVERT."0.2523062599680E13" * t3208 + .CONVERT."0.5752750080E10" *  &
      t3211 - .CONVERT."0.5752750080E10" * t3213 + .CONVERT."0.1986738239473827840E19" * t1383  &
      + .CONVERT."0.3957468857575833600E19" * t1385 + .CONVERT."0.21660511273507065960000E23"  &
      * t178 - .CONVERT."0.6193394887680000E16" * t1389
      t4242 =  .CONVERT."-0.934356713472E12" * t3711 + .CONVERT."0.219920985492848640E18" * t1684  &
      - .CONVERT."0.23926317262848000E17" * t1686 + .CONVERT."0.3386023280640E13" * t1999 -  &
      .CONVERT."0.8756920320E10" * t3224 - .CONVERT."0.582101237760E12" * t3226 + .CONVERT."0.605888427230966880000E21"  &
      * t327 - .CONVERT."0.426441315697170361087500E24" * t43 - .CONVERT."0.43066478810234880E17"  &
      * t2004 - .CONVERT."0.75476544562298880E17" * t2006 - .CONVERT."0.41773564049817600E17"  &
      * t2008 - .CONVERT."0.41773564049817600E17" * t2010 - .CONVERT."0.344096128696320E15"  &
      * t2012 - .CONVERT."0.11344957063329970080000E23" * t330
      t4257 =  .CONVERT."-0.4323095805107439360000E22" * t333 - .CONVERT."0.4323095805107439360000E22"  &
      * t335 - .CONVERT."0.24548668784640E14" * t1694 - .CONVERT."0.3296207470664908800E19"  &
      * t1397 + .CONVERT."0.5060981882880E13" * t2386 - .CONVERT."0.5060981882880E13" * t2388  &
      + .CONVERT."0.1279323947091511083262500E25" * t14 - .CONVERT."0.639661973545755541631250E24"  &
      * t18 - .CONVERT."0.319830986772877770815625E24" * t26 + .CONVERT."0.341153052557736288870000E24"  &
      * t56 - .CONVERT."0.170576526278868144435000E24" * t65 -  &
      .CONVERT."0.170576526278868144435000E24" * t73 - .CONVERT."0.28877783040E11" * t3743 + .CONVERT."0.2394289078272E13"  &
      * t3745
      t4267 = t1844 * t1082
      t4269 = t3749 * t93
      t4271 = t3861 * t17
      t4272 = t4271 * R
      t4274 = t1475 * t2385
      t4276 = t3861 * t21
      t4277 = t4276 * R
      t4279 = t3636 * t59
      t4281 = t3336 * t155
      t4283 = .CONVERT."0.28877783040E11" * t3747 + .CONVERT."0.457703424E9" * t3750 + .CONVERT."0.77649149952E11"  &
      * t3752 - .CONVERT."0.275943260160E12" * t3754 - .CONVERT."0.3074200436736E13"  &
      * t3756 - .CONVERT."0.457703424E9" * t3759 + .CONVERT."0.79253471232E11" * t4267 + .CONVERT."0.1016070144E10"  &
      * t4269 + .CONVERT."0.19922944E8" * t4272 + .CONVERT."0.4064280576E10" * t4274  &
      - .CONVERT."0.19922944E8" * t4277 - .CONVERT."0.179306496E9" * t4279 - .CONVERT."0.4064280576E10"  &
      * t4281
      t4284 = t1423 * t2055
      t4286 = t2060 * t859
      t4288 = t1694 * t1369
      t4290 = t3609 * t59
      t4292 = t2822 * t332
      t4294 = t1666 * t1604
      t4296 = t2331 * t648
      t4298 = t2527 * t399
      t4300 = t1560 * t1604
      t4307 =  .CONVERT."-0.12192841728E11" * t4284 - .CONVERT."0.96865353728E11" * t4286 - .CONVERT."0.52835647488E11"  &
      * t4288 - .CONVERT."0.179306496E9" * t4290 - .CONVERT."0.28449964032E11" *  &
      t4292 + .CONVERT."0.28449964032E11" * t4294 + .CONVERT."0.96865353728E11" * t4296 + .CONVERT."0.52835647488E11"  &
      * t4298 - .CONVERT."0.28449964032E11" * t4300 - .CONVERT."0.110100480E9" *  &
      t3762 - .CONVERT."0.76391067919796229600000E23" * t245 - .CONVERT."0.15518165474168196840000E23"  &
      * t248 + .CONVERT."0.15518165474168196840000E23" * t251 - .CONVERT."0.59442567320227291200000E23"  &
      * t253
      t4316 = t3862 * t21
      t4318 = t3862 * t17
      t4325 =  .CONVERT."-0.48798581436440035200000E23" * t255 - .CONVERT."0.59442567320227291200000E23"  &
      * t257 - .CONVERT."0.48798581436440035200000E23" * t259 + .CONVERT."0.18373157171706617280000E23"  &
      * t262 - .CONVERT."0.18373157171706617280000E23" * t264 +  &
      .CONVERT."0.16997626688263341120000E23" * t353 - .CONVERT."0.27592486483356194400000E23"  &
      * t355 - .CONVERT."0.1048576E7" * t4316 - .CONVERT."0.1048576E7" * t4318 - .CONVERT."0.129395093667840E15"  &
      * t2796 - .CONVERT."0.727165473914880E15" * t2798 - .CONVERT."0.652289192755200E15"  &
      * t2800 - .CONVERT."0.1574877265920E13" * t2802 - .CONVERT."0.198469877760E12" * t2805
      t4332 = t850 * t4044
      t4341 =  .CONVERT."-0.302944213615483440000E21" * t357 - .CONVERT."0.198469877760E12" * t2808  &
      + .CONVERT."0.9872489840640E13" * t2810 - .CONVERT."0.110100480E9" * t3786 - .CONVERT."0.15321268224E11"  &
      * t3788 - .CONVERT."0.331407028592640E15" * t1420 + .CONVERT."0.1048576E7" * t4332  &
      + .CONVERT."0.165358414545359555520000E24" * t187 - .CONVERT."0.331407028592640E15"  &
      * t1423 + .CONVERT."0.78211148772556800E17" * t1721 - .CONVERT."0.559054966445015040E18"  &
      * t1723 - .CONVERT."0.78211148772556800E17" * t1726 + .CONVERT."0.9504132191858304000E19"  &
      * t573 + .CONVERT."0.13239582720E11" * t2820
      t4358 =  .CONVERT."-0.6619791360E10" * t2822 - .CONVERT."0.1034908363092764160000E22" * t575  &
      - .CONVERT."0.2421824490031250304000E22" * t577 + .CONVERT."0.1034908363092764160000E22"  &
      * t579 - .CONVERT."0.1990496095521373440000E22" * t583 - .CONVERT."0.332495763026499072000E21"  &
      * t585 - .CONVERT."0.60389083939504320000E20" * t588 - .CONVERT."0.24548668784640E14"  &
      * t1735 - .CONVERT."0.101219637657600E15" * t2056 - .CONVERT."0.101219637657600E15"  &
      * t2058 - .CONVERT."0.1693011640320E13" * t2060 + .CONVERT."0.756547584E9" * t3297  &
      - .CONVERT."0.1990496095521373440000E22" * t590 - .CONVERT."0.141919811783830080000E21"  &
      * t593
      t4373 = .CONVERT."0.772776265455177984000E21" * t595 - .CONVERT."0.141919811783830080000E21"  &
      * t597 - .CONVERT."0.772776265455177984000E21" * t599 - .CONVERT."0.1820236037588736768000E22"  &
      * t601 - .CONVERT."0.1820236037588736768000E22" * t603 + .CONVERT."0.2421824490031250304000E22"  &
      * t605 + .CONVERT."0.60389083939504320000E20" * t608 + .CONVERT."0.662814057185280E15"  &
      * t1444 + .CONVERT."0.7864188796202042304000E22" * t452 + .CONVERT."0.448995814221034080000E21"  &
      * t455 - .CONVERT."0.5529110620492499040000E22" * t457  &
      - .CONVERT."0.448995814221034080000E21" * t461 - .CONVERT."0.7864188796202042304000E22"  &
      * t463 + .CONVERT."0.5529110620492499040000E22" * t465
      t4386 = t3223 * t261
      t4388 = t2987 * t261
      t4390 = t1851 * t1082
      t4392 =  .CONVERT."-0.8556391233031561920000E22" * t467 - .CONVERT."0.3973754729947242240000E22"  &
      * t469 - .CONVERT."0.3973754729947242240000E22" * t471 - .CONVERT."0.8556391233031561920000E22"  &
      * t473 - .CONVERT."0.2123168714982675360000E22" * t475 - .CONVERT."0.2123168714982675360000E22"  &
      * t477 + .CONVERT."0.851518870702980480000E21" * t479  &
      - .CONVERT."0.27592486483356194400000E23" * t360 - .CONVERT."0.65236826392657920E17" * t2089  &
      - .CONVERT."0.378273792E9" * t3327 - .CONVERT."0.51064610488320E14" * t3330 - .CONVERT."0.12192841728E11"  &
      * t4386 + .CONVERT."0.12192841728E11" * t4388 - .CONVERT."0.79253471232E11"  &
      * t4390
      t4393 = t2718 * t399
      t4395 = t3758 * t93
      t4397 = t1420 * t2055
      t4410 =  .CONVERT."-0.52835647488E11" * t4393 - .CONVERT."0.1016070144E10" * t4395 - .CONVERT."0.12192841728E11"  &
      * t4397 + .CONVERT."0.95279520720384000E17" * t981 - .CONVERT."0.835897072685875200E18"  &
      * t1462 + .CONVERT."0.2069388045204480000E19" * t1464 + .CONVERT."0.259650959029862400E18"  &
      * t1466 - .CONVERT."0.378273792E9" * t3336 - .CONVERT."0.4142587857408000E16"  &
      * t1215 + .CONVERT."0.202312750768128000E18" * t1469 - .CONVERT."0.259650959029862400E18"  &
      * t1471 - .CONVERT."0.1986738239473827840E19" * t1473 + .CONVERT."0.6193394887680000E16"  &
      * t1476 - .CONVERT."0.52008409829376000E17" * t1478
      t4416 = t2469 * t132
      t4417 = t2 * t4416
      fm(20) =  -(t4210 + t4283 + t4092 + t4059 + t4358 + t4108 + t4191 + t3994  &
      + t4226 + t4124 + t4341 + t4011 + t4373 + t4242 + t4307 + t4142  &
      + t4026 + t4257 + t4157 + t4392 + t4077 + t4042 + t3879 + t3972  &
      + t3910 + t4325 + t4175 + t3925 + t3941 + t3956 + t3894 + t4410)  &
      / t4417 / .CONVERT."0.4194304E7"
      t4436 =  .CONVERT."-0.20508916835062656000E20" * t634 - .CONVERT."0.20508916835062656000E20"  &
      * t636 - .CONVERT."0.23966769842704136448000E23" * t638 - .CONVERT."0.5620024546639671168000E22"  &
      * t640 + .CONVERT."0.41017833670125312000E20" * t642 - .CONVERT."0.15668646680262191616000E23"  &
      * t644 - .CONVERT."0.15668646680262191616000E23" * t646 +  &
      .CONVERT."0.908286795416512512000E21" * t649 - .CONVERT."0.908286795416512512000E21" * t651  &
      + .CONVERT."0.6772607226846324864000E22" * t653 - .CONVERT."0.23876831030862281472000E23"  &
      * t655 - .CONVERT."0.294487901306831232000E21" * t658 - .CONVERT."0.6772607226846324864000E22"  &
      * t660 + .CONVERT."0.294487901306831232000E21" * t663 + .CONVERT."0.23876831030862281472000E23"  &
      * t665
      t4454 =  .CONVERT."-0.15283390311585107712000E23" * t668 + .CONVERT."0.15283390311585107712000E23"  &
      * t670 - .CONVERT."0.264178237440E12" * t2667 * t592 - .CONVERT."0.41943040E8"  &
      * t1053 * t4044 - .CONVERT."0.1859652342191419776000E22" * t672 - .CONVERT."0.23966769842704136448000E23"  &
      * t674 - .CONVERT."0.5620024546639671168000E22" * t676 - .CONVERT."0.908934315952126464000E21"  &
      * t821 - .CONVERT."0.31085849124800870400E20" * t824  &
      + .CONVERT."0.908934315952126464000E21" * t826 - .CONVERT."0.5472122900400059904000E22"  &
      * t828 - .CONVERT."0.219815299582534656000E21" * t830 - .CONVERT."0.2505958760927381760000E22"  &
      * t832 - .CONVERT."0.2433418428399678720000E22" * t834 - .CONVERT."0.2433418428399678720000E22"  &
      * t836
      t4471 =  .CONVERT."-0.5472122900400059904000E22" * t838 - .CONVERT."0.4407788671994163456000E22"  &
      * t840 - .CONVERT."0.2505958760927381760000E22" * t842 - .CONVERT."0.219815299582534656000E21"  &
      * t844 - .CONVERT."0.1953230174767872000E19" * t846 - .CONVERT."0.1953230174767872000E19"  &
      * t848 + .CONVERT."0.31085849124800870400E20" * t851 + .CONVERT."0.4407788671994163456000E22"  &
      * t853 + .CONVERT."0.799634208330397440000E21" * t857 -  &
      .CONVERT."0.113535849427064064000E21" * t860 - .CONVERT."0.799634208330397440000E21" *  &
      t862 - .CONVERT."0.113535849427064064000E21" * t864 - .CONVERT."0.4599361422169113600000E22"  &
      * t866 + .CONVERT."0.4599361422169113600000E22" * t868 + .CONVERT."0.191932531820789760E18"  &
      * t2156
      t4487 =  .CONVERT."-0.327168624874291200E18" * t2158 - .CONVERT."0.26226140915375977206881250E26"  &
      * t22 - .CONVERT."0.2801731869081600E16" * t2936 - .CONVERT."0.187331946860298240E18"  &
      * t1536 - .CONVERT."0.885241646043955200E18" * t1538 - .CONVERT."0.885241646043955200E18"  &
      * t1540 - .CONVERT."0.20605898755233792000E20" * t1542 + .CONVERT."0.1030066131186892800E19"  &
      * t1544 - .CONVERT."0.26226140915375977206881250E26" * t24 - .CONVERT."0.734759626997760E15"  &
      * t2944 - .CONVERT."0.55635027689472E14" * t2946 + .CONVERT."0.6436088709120E13"  &
      * t2528 + .CONVERT."0.202174648811520E15" * t2530 - .CONVERT."0.202174648811520E15"  &
      * t2532 - .CONVERT."0.4992043348131840E16" * t2534
      t4506 = .CONVERT."0.4992043348131840E16" * t2536 + .CONVERT."0.28625245977968640E17" * t2538  &
      + .CONVERT."0.118472845261680589680000E24" * t277 - .CONVERT."0.984552318887423045760000E24"  &
      * t279 - .CONVERT."0.118472845261680589680000E24" * t282 - .CONVERT."0.468982205721115566480000E24"  &
      * t284 - .CONVERT."0.716553129696558073920000E24" * t286  &
      + .CONVERT."0.984552318887423045760000E24" * t288 + .CONVERT."0.86437407460884480E17" *  &
      t1842 + .CONVERT."0.1498090944430080E16" * t1845 + .CONVERT."0.972464833787166720E18" *  &
      t1847 - .CONVERT."0.86437407460884480E17" * t1849 - .CONVERT."0.1498090944430080E16" *  &
      t1852 - .CONVERT."0.267707797733376E15" * t3433 + .CONVERT."0.4194304E7" * t4417 * t13
      t4522 =  .CONVERT."-0.3722589074620416E16" * t2968 - .CONVERT."0.242445299220480E15" * t2970  &
      - .CONVERT."0.3722589074620416E16" * t2972 + .CONVERT."0.13113070457687988603440625E26"  &
      * t27 - .CONVERT."0.144270516289536E15" * t3441 - .CONVERT."0.228856430592E12" * t3443  &
      - .CONVERT."0.12420712758234821040000E23" * t291 - .CONVERT."0.69413477253120E14" * t1856  &
      - .CONVERT."0.7931831255040E13" * t2977 + .CONVERT."0.3169369612119391480800000E25"  &
      * t199 - .CONVERT."0.2960557059504844800E19" * t1054 - .CONVERT."0.20417315210772480E17"  &
      * t1561 + .CONVERT."0.2801731869081600E16" * t2983 + .CONVERT."0.28133645352960E14" * t2985  &
      + .CONVERT."0.378085048320E12" * t2988
      t4539 = .CONVERT."0.55635027689472E14" * t2990 + .CONVERT."0.347199212272872960000E21" *  &
      t1056 + .CONVERT."0.106571971361240985600E21" * t1058 - .CONVERT."0.674226700386765926400E21"  &
      * t1060 - .CONVERT."0.106571971361240985600E21" * t1062 - .CONVERT."0.242445299220480E15"  &
      * t2996 - .CONVERT."0.10058891279044608000E20" * t1291 - .CONVERT."0.181465336127390515200E21"  &
      * t1293 - .CONVERT."0.40717414875020083200E20" * t1295 - .CONVERT."0.13789218897096394752000E23"  &
      * t501 - .CONVERT."0.347199212272872960000E21" * t1065  &
      - .CONVERT."0.204230098944E12" * t3975 - .CONVERT."0.2873446367232E13" * t3977 - .CONVERT."0.9589670019072E13"  &
      * t3979 - .CONVERT."0.8506539245568E13" * t3981
      t4556 =  .CONVERT."-0.4402970624E10" * t3983 - .CONVERT."0.13658014875648E14" * t3985 - .CONVERT."0.329206726656E12"  &
      * t3987 - .CONVERT."0.97101793471947264000E20" * t1067 - .CONVERT."0.190733454481489920E18"  &
      * t2198 - .CONVERT."0.430048086102835200E18" * t2200 - .CONVERT."0.333373821027287040E18"  &
      * t2202 - .CONVERT."0.333373821027287040E18" * t2204 -  &
      .CONVERT."0.220216197906432E15" * t3475 - .CONVERT."0.7198589583360E13" * t3477 + .CONVERT."0.45724204990464000E17"  &
      * t2577 - .CONVERT."0.13466325602795520E17" * t2579 - .CONVERT."0.13466325602795520E17"  &
      * t2581 - .CONVERT."0.15519909048483840E17" * t2583 - .CONVERT."0.39711706133299200E17"  &
      * t2585 - .CONVERT."0.18727928966685818880E20" * t1574
      t4575 =  .CONVERT."-0.322760183732034048000E21" * t1069 + .CONVERT."0.674226700386765926400E21"  &
      * t1071 - .CONVERT."0.991791038609699328000E21" * t1075 - .CONVERT."0.322760183732034048000E21"  &
      * t1077 + .CONVERT."0.2960557059504844800E19" * t1080 + .CONVERT."0.12208155852372480000E20"  &
      * t1083 - .CONVERT."0.1039803040397721600E19" * t1882 + .CONVERT."0.1039803040397721600E19"  &
      * t1884 - .CONVERT."0.3181515994160824320E19" * t1886  &
      - .CONVERT."0.65628282566246400E17" * t1888 + .CONVERT."0.65628282566246400E17" * t1890  &
      - .CONVERT."0.1656095034431309472000E22" * t381 + .CONVERT."0.3312190068862618944000E22"  &
      * t383 - .CONVERT."0.1656095034431309472000E22" * t385 - .CONVERT."0.736217025255968256000E21"  &
      * t1088
      t4591 =  .CONVERT."-0.1027980384993289728000E22" * t1090 - .CONVERT."0.23107094754244300800E20"  &
      * t1092 - .CONVERT."0.228856430592E12" * t3505 - .CONVERT."0.7198589583360E13" * t3507  &
      - .CONVERT."0.29450525736960E14" * t3509 - .CONVERT."0.63273468690432E14" * t3511 -  &
      .CONVERT."0.204067260334080E15" * t3513 - .CONVERT."0.204067260334080E15" * t3515 - .CONVERT."0.144270516289536E15"  &
      * t3517 - .CONVERT."0.12208155852372480000E20" * t1094 + .CONVERT."0.1027980384993289728000E22"  &
      * t1097 - .CONVERT."0.23107094754244300800E20" * t1099  &
      - .CONVERT."0.97101793471947264000E20" * t1101 - .CONVERT."0.991791038609699328000E21"  &
      * t1103 - .CONVERT."0.736217025255968256000E21" * t1105
      t4608 =  .CONVERT."-0.11101817863187251200E20" * t1596 - .CONVERT."0.187331946860298240E18"  &
      * t1598 - .CONVERT."0.27200541446004326400E20" * t1600 - .CONVERT."0.194834709933095232000E21"  &
      * t507 - .CONVERT."0.242221056E9" * t4045 - .CONVERT."0.1052604525772800E16" *  &
      t2237 - .CONVERT."0.4041342885888000E16" * t2239 - .CONVERT."0.4041342885888000E16" * t2241  &
      + .CONVERT."0.734759626997760E15" * t3055 + .CONVERT."0.3896243162972160E16" * t3057  &
      + .CONVERT."0.2111983347302400E16" * t3059 - .CONVERT."0.2111983347302400E16" * t3061 -  &
      .CONVERT."0.430441591996416E15" * t3063 + .CONVERT."0.430441591996416E15" * t3065 - .CONVERT."0.194834709933095232000E21"  &
      * t509
      t4625 =  .CONVERT."-0.88820232044544000E17" * t1605 + .CONVERT."0.88820232044544000E17" *  &
      t1607 + .CONVERT."0.7479124613765757102150000E25" * t94 - .CONVERT."0.159779107278895104000E21"  &
      * t1324 - .CONVERT."0.148241628774612172800E21" * t1327 - .CONVERT."0.37250687098508083200E20"  &
      * t1329 + .CONVERT."0.85983232E8" * t4066 + .CONVERT."0.34968187887167969609175000E26"  &
      * t33 - .CONVERT."0.1786491961344E13" * t3551 - .CONVERT."0.1278354928435200E16"  &
      * t2631 - .CONVERT."0.1278354928435200E16" * t2633 - .CONVERT."0.15519909048483840E17"  &
      * t2635 - .CONVERT."0.40969948841902080E17" * t2637 + .CONVERT."0.25586478941830221665250000E26"  &
      * t36 - .CONVERT."0.25586478941830221665250000E26" * t41 + .CONVERT."0.3181515994160824320E19"  &
      * t1921
      t4643 = .CONVERT."0.3339960547615211520E19" * t1923 - .CONVERT."0.972464833787166720E18"  &
      * t1925 - .CONVERT."0.334643286026649600E18" * t1927 - .CONVERT."0.334643286026649600E18"  &
      * t1929 - .CONVERT."0.2009591532748800E16" * t2647 - .CONVERT."0.1859652342191419776000E22"  &
      * t701 - .CONVERT."0.2009591532748800E16" * t2650 - .CONVERT."0.69370899333120E14"  &
      * t2652 - .CONVERT."0.1084267435130880E16" * t3093 + .CONVERT."0.1676673024E10" * t3571  &
      - .CONVERT."0.6848594335753641591120000E25" * t143 - .CONVERT."0.2783533311513552517920000E25"  &
      * t146 + .CONVERT."0.2783533311513552517920000E25" * t149 - .CONVERT."0.6552327176359872387480000E25"  &
      * t151 - .CONVERT."0.6552327176359872387480000E25" * t153
      t4659 =  .CONVERT."-0.2676739335453007804980000E25" * t156 - .CONVERT."0.2676739335453007804980000E25"  &
      * t158 + .CONVERT."0.229988892672E12" * t3580 - .CONVERT."0.22982315669913600E17"  &
      * t2267 + .CONVERT."0.22982315669913600E17" * t2269 + .CONVERT."0.327168624874291200E18"  &
      * t2271 + .CONVERT."0.433761110079897600E18" * t2273 - .CONVERT."0.84383564412026880E17"  &
      * t2275 - .CONVERT."0.271411445760E12" * t2667 - .CONVERT."0.169846102153728000E18"  &
      * t1125 - .CONVERT."0.1084267435130880E16" * t3110 - .CONVERT."0.1642375245987840E16"  &
      * t3117 - .CONVERT."0.4187011153920E13" * t3119 - .CONVERT."0.3790746370201190400E19"  &
      * t1626 - .CONVERT."0.3790746370201190400E19" * t1632
      t4676 =  .CONVERT."-0.36746314343413234560000E23" * t400 - .CONVERT."0.433761110079897600E18"  &
      * t2285 - .CONVERT."0.129050534215680E15" * t3125 - .CONVERT."0.776277590016E12" * t4114  &
      - .CONVERT."0.1998182164981026834810000E25" * t99 - .CONVERT."0.1998182164981026834810000E25"  &
      * t101 + .CONVERT."0.3996364329962053669620000E25" * t103 - .CONVERT."0.444040481106894852180000E24"  &
      * t163 - .CONVERT."0.444040481106894852180000E24" * t165  &
      - .CONVERT."0.45724204990464000E17" * t2684 - .CONVERT."0.838336512E9" * t3609 + .CONVERT."0.84383564412026880E17"  &
      * t2292 - .CONVERT."0.6570877811097600E16" * t2294 - .CONVERT."0.101859782492160E15"  &
      * t2297 - .CONVERT."0.191932531820789760E18" * t2299
      t4693 =  .CONVERT."-0.3226973668638720E16" * t3138 - .CONVERT."0.1642375245987840E16" * t3140  &
      - .CONVERT."0.27774409472409600E17" * t2301 - .CONVERT."0.27774409472409600E17" * t2303  &
      - .CONVERT."0.1052604525772800E16" * t2305 + .CONVERT."0.339692204307456000E18" * t1134  &
      - .CONVERT."0.37250687098508083200E20" * t1354 - .CONVERT."0.2184499871627673600E19"  &
      * t1356 - .CONVERT."0.159779107278895104000E21" * t1358 - .CONVERT."0.80734632928526336760000E23"  &
      * t218 - .CONVERT."0.2031242344210759680E19" * t1957 - .CONVERT."0.3759788992570490880E19"  &
      * t1959 - .CONVERT."0.14665749497118720E17" * t1961 - .CONVERT."0.343182326032465920E18"  &
      * t1963 - .CONVERT."0.343182326032465920E18" * t1966 + .CONVERT."0.26247506951826800640E20"  &
      * t1645
      t4713 = .CONVERT."0.20605898755233792000E20" * t1647 + .CONVERT."0.161469265857052673520000E24"  &
      * t220 - .CONVERT."0.838336512E9" * t3636 - .CONVERT."0.18727928966685818880E20"  &
      * t1651 - .CONVERT."0.7479124613765757102150000E25" * t105 - .CONVERT."0.14407155834938247891510000E26"  &
      * t107 - .CONVERT."0.9270710083123016698170000E25" * t110 - .CONVERT."0.14407155834938247891510000E26"  &
      * t113 + .CONVERT."0.9270710083123016698170000E25"  &
      * t116 - .CONVERT."0.80734632928526336760000E23" * t229 + .CONVERT."0.6449420831293440E16"  &
      * t2714 - .CONVERT."0.452781397770240E15" * t2716 - .CONVERT."0.6436088709120E13"  &
      * t2719 - .CONVERT."0.26588056356126720E17" * t2721 + .CONVERT."0.26588056356126720E17"  &
      * t2723
      t4729 =  .CONVERT."-0.28625245977968640E17" * t2727 + .CONVERT."0.2012990840340480E16" * t1659  &
      + .CONVERT."0.6570877811097600E16" * t2329 + .CONVERT."0.101859782492160E15" * t2332  &
      - .CONVERT."0.1126906694065152000E19" * t1370 - .CONVERT."0.12689361338368E14" * t4171  &
      + .CONVERT."0.37833670656E11" * t4173 - .CONVERT."0.37833670656E11" * t4176 - .CONVERT."0.80201651488358400E17"  &
      * t2337 - .CONVERT."0.80201651488358400E17" * t2339 - .CONVERT."0.190733454481489920E18"  &
      * t2341 - .CONVERT."0.430048086102835200E18" * t2343 - .CONVERT."0.4478288855040E13"  &
      * t2345 - .CONVERT."0.4478288855040E13" * t2347 - .CONVERT."0.1126906694065152000E19"  &
      * t1372
      t4746 = .CONVERT."0.8956577710080E13" * t2350 - .CONVERT."0.17484093943583984804587500E26"  &
      * t38 - .CONVERT."0.260886437560320E15" * t3668 - .CONVERT."0.229988892672E12" * t3670  &
      + .CONVERT."0.74310557368320E14" * t3672 + .CONVERT."0.260886437560320E15" * t3674 + .CONVERT."0.127648143507456E15"  &
      * t3677 - .CONVERT."0.127648143507456E15" * t3679 - .CONVERT."0.24466220384256E14"  &
      * t3681 + .CONVERT."0.24466220384256E14" * t3683 - .CONVERT."0.9870206982678282240E19"  &
      * t1664 + .CONVERT."0.20417315210772480E17" * t1667 - .CONVERT."0.16204769996492473721325000E26"  &
      * t60 + .CONVERT."0.21190853072336311789425000E26" * t63  &
      - .CONVERT."0.16204769996492473721325000E26" * t68
      t4762 =  .CONVERT."-0.21190853072336311789425000E26" * t71 - .CONVERT."0.74310557368320E14"  &
      * t3691 - .CONVERT."0.8670393925632E13" * t3693 - .CONVERT."0.9589670019072E13" * t4206  &
      - .CONVERT."0.204230098944E12" * t4208 - .CONVERT."0.4402970624E10" * t4211 - .CONVERT."0.98767481226365952000E20"  &
      * t1381 - .CONVERT."0.27200541446004326400E20" * t1676 - .CONVERT."0.11101817863187251200E20"  &
      * t1678 - .CONVERT."0.7931831255040E13" * t3202 - .CONVERT."0.3896243162972160E16"  &
      * t3204 - .CONVERT."0.4187011153920E13" * t3206 - .CONVERT."0.129050534215680E15"  &
      * t3208 + .CONVERT."0.529253007360E12" * t3211 - .CONVERT."0.529253007360E12"  &
      * t3213
      t4781 = .CONVERT."0.87692992807641661440E20" * t1383 + .CONVERT."0.181465336127390515200E21"  &
      * t1385 + .CONVERT."0.888080962213789704360000E24" * t178 - .CONVERT."0.256718231497728000E18"  &
      * t1389 - .CONVERT."0.2097152E7" * t4417 * t17 - .CONVERT."0.63273468690432E14"  &
      * t3711 + .CONVERT."0.9870206982678282240E19" * t1684 - .CONVERT."0.1030066131186892800E19"  &
      * t1686 + .CONVERT."0.138826954506240E15" * t1999 - .CONVERT."0.378085048320E12"  &
      * t3224 - .CONVERT."0.28133645352960E14" * t3226 + .CONVERT."0.24841425516469642080000E23"  &
      * t327 - .CONVERT."0.17484093943583984804587500E26" * t43 - .CONVERT."0.2031242344210759680E19"  &
      * t2004 - .CONVERT."0.3759788992570490880E19" * t2006
      t4797 =  .CONVERT."-0.2197794736314777600E19" * t2008 - .CONVERT."0.2197794736314777600E19"  &
      * t2010 - .CONVERT."0.14665749497118720E17" * t2012 - .CONVERT."0.468982205721115566480000E24"  &
      * t330 - .CONVERT."0.183731571717066172800000E24" * t333 - .CONVERT."0.183731571717066172800000E24"  &
      * t335 - .CONVERT."0.1006495420170240E16" * t1694 - .CONVERT."0.148241628774612172800E21"  &
      * t1397 + .CONVERT."0.328963822387200E15" * t2386 - .CONVERT."0.328963822387200E15"  &
      * t2388 + .CONVERT."0.52452281830751954413762500E26" * t14  &
      - .CONVERT."0.26226140915375977206881250E26" * t18 - .CONVERT."0.13113070457687988603440625E26"  &
      * t26 + .CONVERT."0.13987275154867187843670000E26" * t56 - .CONVERT."0.6993637577433593921835000E25"  &
      * t65
      t4814 =  .CONVERT."-0.6993637577433593921835000E25" * t73 - .CONVERT."0.1549774356480E13"  &
      * t3743 + .CONVERT."0.220216197906432E15" * t3745 + .CONVERT."0.1549774356480E13" * t3747  &
      + .CONVERT."0.20558905344E11" * t3750 + .CONVERT."0.8670393925632E13" * t3752 - .CONVERT."0.29450525736960E14"  &
      * t3754 - .CONVERT."0.267707797733376E15" * t3756 - .CONVERT."0.20558905344E11"  &
      * t3759 + .CONVERT."0.11967274156032E14" * t4267 + .CONVERT."0.72140980224E11" * t4269  &
      + .CONVERT."0.1016070144E10" * t4272 + .CONVERT."0.776277590016E12" * t4274 - .CONVERT."0.1016070144E10"  &
      * t4277 - .CONVERT."0.10937696256E11" * t4279
      t4837 =  .CONVERT."-0.329206726656E12" * t4281 - .CONVERT."0.2206904352768E13" * t4284 - .CONVERT."0.13658014875648E14"  &
      * t4286 - .CONVERT."0.8506539245568E13" * t4288 - .CONVERT."0.10937696256E11"  &
      * t4290 - .CONVERT."0.2873446367232E13" * t4292 + .CONVERT."0.4864943849472E13"  &
      * t4294 + .CONVERT."0.12689361338368E14" * t4296 + .CONVERT."0.5864756871168E13" * t4298  &
      - .CONVERT."0.4864943849472E13" * t4300 - .CONVERT."0.162571223040E12" * t3223 * t399  &
      - .CONVERT."0.81285611520E11" * t1694 * t2055 - .CONVERT."0.387461414912E12" * t2347 * t859  &
      - .CONVERT."0.81285611520E11" * t3336 * t332 - .CONVERT."0.32514244608E11" * t1560 *  &
      t2385 + .CONVERT."0.41943040E8" * t1079 * t4044
      t4865 = .CONVERT."0.352237649920E12" * t2331 * t1082 + .CONVERT."0.2390753280E10" * t4271  &
      * t93 + .CONVERT."0.41943040E8" * t4416 * t17 * R + .CONVERT."0.32514244608E11" * t1666  &
      * t2385 - .CONVERT."0.41943040E8" * t4416 * t21 * R + .CONVERT."0.162571223040E12" * t1844  &
      * t1604 - .CONVERT."0.10160701440E11" * t3636 * t155 - .CONVERT."0.13927710720E11" *  &
      t3762 - .CONVERT."0.3169369612119391480800000E25" * t245 - .CONVERT."0.638164267503189467040000E24"  &
      * t248 + .CONVERT."0.638164267503189467040000E24" * t251 - .CONVERT."0.2480376218180393332800000E25"  &
      * t253 - .CONVERT."0.2014742774171946218400000E25"  &
      * t255 - .CONVERT."0.2480376218180393332800000E25" * t257 - .CONVERT."0.2014742774171946218400000E25"  &
      * t259
      t4882 = .CONVERT."0.771672601211677925760000E24" * t262 - .CONVERT."0.771672601211677925760000E24"  &
      * t264 + .CONVERT."0.716553129696558073920000E24" * t353 - .CONVERT."0.1154626837947445262400000E25"  &
      * t355 - .CONVERT."0.42991616E8" * t4316 - .CONVERT."0.42991616E8"  &
      * t4318 - .CONVERT."0.2097152E7" * t4417 * t21 - .CONVERT."0.6449420831293440E16" * t2796  &
      - .CONVERT."0.40969948841902080E17" * t2798 - .CONVERT."0.39711706133299200E17" * t2800  &
      - .CONVERT."0.69370899333120E14" * t2802 - .CONVERT."0.14885240832000E14" * t2805 -  &
      .CONVERT."0.12420712758234821040000E23" * t357 - .CONVERT."0.14885240832000E14" * t2808  &
      + .CONVERT."0.452781397770240E15" * t2810
      t4899 =  .CONVERT."-0.13927710720E11" * t3786 - .CONVERT."0.1786491961344E13" * t3788 - .CONVERT."0.13587688172298240E17"  &
      * t1420 + .CONVERT."0.242221056E9" * t4332 + .CONVERT."0.6848594335753641591120000E25"  &
      * t187 - .CONVERT."0.13587688172298240E17" * t1423 + .CONVERT."0.4031698366221926400E19"  &
      * t1721 - .CONVERT."0.26247506951826800640E20" * t1723 -  &
      .CONVERT."0.4031698366221926400E19" * t1726 + .CONVERT."0.389669419866190464000E21" * t573  &
      + .CONVERT."0.542822891520E12" * t2820 - .CONVERT."0.271411445760E12" * t2822 - .CONVERT."0.43247084474454981120000E23"  &
      * t575 - .CONVERT."0.103074070269373467264000E24" *  &
      t577 + .CONVERT."0.43247084474454981120000E23" * t579
      t4916 =  .CONVERT."-0.83904894381646578240000E23" * t583 - .CONVERT."0.13789218897096394752000E23"  &
      * t585 - .CONVERT."0.2488503850560471744000E22" * t588 - .CONVERT."0.1006495420170240E16"  &
      * t1735 - .CONVERT."0.5921348802969600E16" * t2056 - .CONVERT."0.5921348802969600E16"  &
      * t2058 - .CONVERT."0.69413477253120E14" * t2060 + .CONVERT."0.31018450944E11"  &
      * t3297 - .CONVERT."0.83904894381646578240000E23" * t590 - .CONVERT."0.6244471718488523520000E22"  &
      * t593 + .CONVERT."0.33606611430410962944000E23" * t595 - .CONVERT."0.6244471718488523520000E22"  &
      * t597 - .CONVERT."0.33606611430410962944000E23" * t599 -  &
      .CONVERT."0.78282968179960672128000E23" * t601 - .CONVERT."0.78282968179960672128000E23"  &
      * t603 + .CONVERT."0.103074070269373467264000E24" * t605
      t4934 = .CONVERT."0.2488503850560471744000E22" * t608 + .CONVERT."0.27175376344596480E17"  &
      * t1444 + .CONVERT."0.332970079025502382464000E24" * t452 + .CONVERT."0.18487274689567363680000E23"  &
      * t455 - .CONVERT."0.230400123422552123040000E24" * t457 - .CONVERT."0.18487274689567363680000E23"  &
      * t461 - .CONVERT."0.332970079025502382464000E24" * t463  &
      + .CONVERT."0.230400123422552123040000E24" * t465 - .CONVERT."0.359242711259268957120000E24"  &
      * t467 - .CONVERT."0.169801596345053312640000E24" * t469 - .CONVERT."0.169801596345053312640000E24"  &
      * t471 - .CONVERT."0.359242711259268957120000E24" * t473  &
      - .CONVERT."0.87897137424543326880000E23" * t475 - .CONVERT."0.87897137424543326880000E23"  &
      * t477 + .CONVERT."0.36746314343413234560000E23" * t479
      t4945 = t2804 * t155
      t4956 =  .CONVERT."-0.1154626837947445262400000E25" * t360 - .CONVERT."0.3339960547615211520E19"  &
      * t2089 - .CONVERT."0.15509225472E11" * t3327 - .CONVERT."0.3226973668638720E16"  &
      * t3330 - .CONVERT."0.1109548597248E13" * t4386 + .CONVERT."0.1109548597248E13" * t4388  &
      - .CONVERT."0.11967274156032E14" * t4390 - .CONVERT."0.5864756871168E13" * t4393 - .CONVERT."0.72140980224E11"  &
      * t4395 - .CONVERT."0.2206904352768E13" * t4397 - .CONVERT."0.2097152E7" * t848  &
      * t4945 - .CONVERT."0.264178237440E12" * t2822 * t592 - .CONVERT."0.398458880E9" * t1125  &
      * t3761 - .CONVERT."0.10160701440E11" * t1423 * t2804 + .CONVERT."0.32514244608E11"  &
      * t3749 * t261
      t4988 = .CONVERT."0.352237649920E12" * t2527 * t648 + .CONVERT."0.162571223040E12" * t2987  &
      * t399 - .CONVERT."0.162571223040E12" * t1851 * t1604 - .CONVERT."0.352237649920E12" *  &
      t2296 * t1082 + .CONVERT."0.2390753280E10" * t1475 * t3210 - .CONVERT."0.2390753280E10"  &
      * t1388 * t3210 - .CONVERT."0.10160701440E11" * t1420 * t2804 - .CONVERT."0.2097152E7"  &
      * t846 * t4945 - .CONVERT."0.264178237440E12" * t2060 * t1369 - .CONVERT."0.398458880E9"  &
      * t4316 * t59 - .CONVERT."0.81285611520E11" * t3327 * t332 - .CONVERT."0.81285611520E11"  &
      * t1735 * t2055 - .CONVERT."0.387461414912E12" * t2345 * t859 - .CONVERT."0.264178237440E12"  &
      * t1856 * t1369 - .CONVERT."0.10160701440E11" * t3609 * t155
      t5010 =  .CONVERT."-0.2390753280E10" * t4276 * t93 - .CONVERT."0.398458880E9" * t1215 * t3761  &
      - .CONVERT."0.398458880E9" * t4318 * t59 - .CONVERT."0.32514244608E11" * t3758 * t261  &
      - .CONVERT."0.352237649920E12" * t2718 * t648 + .CONVERT."0.3906460349535744000E19" *  &
      t981 - .CONVERT."0.40717414875020083200E20" * t1462 + .CONVERT."0.98767481226365952000E20"  &
      * t1464 + .CONVERT."0.11072412608960102400E20" * t1466 - .CONVERT."0.15509225472E11"  &
      * t3336 - .CONVERT."0.169846102153728000E18" * t1215 + .CONVERT."0.10058891279044608000E20"  &
      * t1469 - .CONVERT."0.11072412608960102400E20" * t1471 - .CONVERT."0.87692992807641661440E20"  &
      * t1473 + .CONVERT."0.256718231497728000E18" * t1476 - .CONVERT."0.2184499871627673600E19"  &
      * t1478
      fm(21) =  (t4643 + t4471 + t4556 + t5010 + t4814 + t4934 + t4713 + t4865  &
      + t4575 + t4676 + t4436 + t4899 + t4487 + t4729 + t4591 + t4522  &
      + t4988 + t4746 + t4837 + t4539 + t4454 + t4608 + t4693 + t4916  &
      + t4762 + t4797 + t4956 + t4506 + t4625 + t4882 + t4781 + t4659) /  &
      t2 / t2469 / t191 / .CONVERT."0.8388608E7"

      DO i=0,21
         fm(i)=((-1)**i) * fm(i)
      ENDDO

  END SUBROUTINE cutoff_gamma

END MODULE mpfr_cutoff_gamma
