Name:		conman
Version:	0.3.1
Release:	1%{?dist}

# Disable source file verification by default.
%bcond_with verify

Summary:	ConMan: The Console Manager
License:	GPLv3+
URL:		https://dun.github.io/conman/
Source0:	https://github.com/dun/conman/releases/download/%{name}-%{version}/%{name}-%{version}.tar.xz
%if %{with verify}
Source1:	https://github.com/dun/conman/releases/download/%{name}-%{version}/%{name}-%{version}.tar.xz.asc
Source2:	https://github.com/dun.gpg
%endif

BuildRequires:	freeipmi-devel >= 1.0.4
BuildRequires:	gcc
BuildRequires:	gnupg2
BuildRequires:	make
BuildRequires:	%{?el7:systemd}%{!?el7:systemd-rpm-macros}
Requires:	expect
Requires:	logrotate
Requires:	perl
%{?systemd_requires}

%description
ConMan is a serial console management program designed to support a large
number of console devices and simultaneous users.

Supported console types:
- Local serial devices
- Remote terminal servers (via the telnet protocol)
- IPMI Serial-Over-LAN (via FreeIPMI's libipmiconsole)
- External processes (e.g., Expect)
- Unix domain sockets

Features:
- Mapping symbolic names to console devices
- Logging (and optionally timestamping) console output to file
- Connecting to a console in monitor (R/O) or interactive (R/W) mode
- Connecting to multiple consoles for broadcasting (W/O) client output
- Sharing a console session amongst multiple simultaneous clients
- Allowing clients to share or steal console "write" privileges
- Executing Expect scripts across multiple consoles in parallel

%prep
%if %{with verify}
%{gpgverify} --keyring='%{SOURCE2}' --signature='%{SOURCE1}' --data='%{SOURCE0}'
%endif
%setup -q

%build
%configure runstatedir=%{_rundir} --with-systemdunitdir=%{_unitdir}
%make_build

%install
%make_install

%post
%systemd_post conman.service

%preun
%systemd_preun conman.service

%postun
%systemd_postun_with_restart conman.service

%files
%license COPYING
%doc AUTHORS
%doc DISCLAIMER.LLNS
%doc DISCLAIMER.UC
%doc FAQ
%doc NEWS
%doc README
%doc THANKS
%config(noreplace) %{_sysconfdir}/conman.conf
%config(noreplace) %{_sysconfdir}/logrotate.d/conman
%{_bindir}/conman
%{_bindir}/conmen
%{_sbindir}/conmand
%{_datadir}/conman
%{_mandir}/man1/conman.1*
%{_mandir}/man5/conman.conf.5*
%{_mandir}/man8/conmand.8*
%{_unitdir}/conman.service
