# CiviCRM 5.28.0

Released August 5, 2020

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| **Require attention to configuration options?**                 | **yes** |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### CiviCRM Core

- **End of life planning for MySQL server 5.0 - 5.6 (Work Towards
  [dev/core#1681](https://lab.civicrm.org/dev/core/-/issues/1681):
  [17558](https://github.com/civicrm/civicrm-core/pull/17558))**

  Block sites from upgrading if on a MySQL version less than 5.6.5.

- **Ability to enable SSL for database connection. (Work Towards
  [dev/core#1137](https://lab.civicrm.org/dev/core/-/issues/1137):
  [298](https://github.com/civicrm/civicrm-packages/pull/298))**

  Makes SSL database connections without client certificates work in PHP 7.

- **Create new customPre hook
  ([dev/core#1716](https://lab.civicrm.org/dev/core/-/issues/1716):
  [17144](https://github.com/civicrm/civicrm-core/pull/17144))**

   Creates a new hook customPre which makes it so one can impact or observe
   custom data before it is saved.

- **Investigate PHP currency library
  ([dev/translation#48](https://lab.civicrm.org/dev/translation/-/issues/48):
  [17608](https://github.com/civicrm/civicrm-core/pull/17608))**

  Implements the PHP library [brick/money](https://github.com/brick/money) to
  better handle currency amounts.

- **Replace all instances of CRM_Core_Fatal with throw new CRM_Core_Exception
  (Work Towards [dev/core#560](https://lab.civicrm.org/dev/core/-/issues/560):
  [17555](https://github.com/civicrm/civicrm-core/pull/17555),
  [295](https://github.com/civicrm/civicrm-packages/pull/295),
  [602](https://github.com/civicrm/civicrm-drupal/pull/602),
  [17550](https://github.com/civicrm/civicrm-core/pull/17550),
  [17534](https://github.com/civicrm/civicrm-core/pull/17534),
  [17541](https://github.com/civicrm/civicrm-core/pull/17541),
  [17545](https://github.com/civicrm/civicrm-core/pull/17545) and
  [17539](https://github.com/civicrm/civicrm-core/pull/17539))**

  Work towards throwing exceptions instead of fatal errors.

- **APIv4 - Activity has no default for activity_date_time
  ([dev/core#1782](https://lab.civicrm.org/dev/core/-/issues/1782):
  [17450](https://github.com/civicrm/civicrm-core/pull/17450))**

  Sets the default for `activity_date_time` and `created_date` as the current
  date when using the APIv4 Activity.

- **Update guzzle to d8 latest
  ([dev/core#1803](https://lab.civicrm.org/dev/core/-/issues/1803):
  [17551](https://github.com/civicrm/civicrm-core/pull/17551))**

  This updates guzzle to version 6.5.4, civicrm/civicrm-cxn-rpc to "version"
  "v0.19.01.00", guzzlehttp/psr7 to version 1.6.1 and  psr/log to version 1.1.3

- **APIv4 - Improve row_count to work with HAVING, GROUP BY, and SELECT
  ([17704](https://github.com/civicrm/civicrm-core/pull/17704))**

  This changes the meaning of $result->count(), to give a total count of
  filtered items, ignoring limit and offset.

- **APIv4 - Add more SQL functions
  ([17692](https://github.com/civicrm/civicrm-core/pull/17692))**

  Adds support for additional SQL functions in APIv4. Also categorizes them and
  adds translated titles for the new Search Builder.

- **APIv4 - Add titles and icons to entities
  ([17527](https://github.com/civicrm/civicrm-core/pull/17527) and
  [17685](https://github.com/civicrm/civicrm-core/pull/17685))**

  Adds titles and icons to DAO entities and expose them to APIv4 Entity::get and
  adds meta-metadata.

- **APIv4 Explorer - UI support for join ON clause
  ([17682](https://github.com/civicrm/civicrm-core/pull/17682))**

  Improves the APIv4 explorer to give selectable clauses when adding a JOIN.

- **Add permission metadata to contact is_deleted field
  ([17721](https://github.com/civicrm/civicrm-core/pull/17721))**

  Improves the contact schema metadata.

- **API/DAO Metadata - Retain versioning metadata for possible usage in
  runtime+tooling
  ([17735](https://github.com/civicrm/civicrm-core/pull/17735))**

  Adds metadata to indicate when fields are created.

- **Connect to database using SET NAMES utf8mb4
  ([17716](https://github.com/civicrm/civicrm-core/pull/17716))**

  This change makes it so one can use utf8mb4 characters.  However, databases
  that do not support utf8mb4 will not be affected.

- **Remove slow join from activity search
  ([17250](https://github.com/civicrm/civicrm-core/pull/17250))**

  Improves performance of the activity search.

- **Add icons to standalone contact tasks
  ([17667](https://github.com/civicrm/civicrm-core/pull/17667))**

  This adds icon data to contact tasks that appear in the new search builder
  extension.

- **Add icons to multi-valued custom groups and display on contact tab
  ([17531](https://github.com/civicrm/civicrm-core/pull/17531))**

  Custom data sets that appear as tabs can now have configurable icons to
  display on the tab.

- **Add serialize metadata to domain.locales field
  ([17651](https://github.com/civicrm/civicrm-core/pull/17651))**

  Adds metadata to help APIv4 serialize/unserialize the domain.locales
  field correctly.

- **Add Smarty error event
  ([16918](https://github.com/civicrm/civicrm-core/pull/16918) and
  [292](https://github.com/civicrm/civicrm-packages/pull/292))**

  Improves debugging errors in Smarty templates.

- **Allow HEAD requests to generate a form key
  ([17321](https://github.com/civicrm/civicrm-core/pull/17321))**

  Avoids generating crashes (500 errors) when bots check links.

- **Include a new SqlParallel queue type that enables multiple queue runners to
  process in parallel
  ([15422](https://github.com/civicrm/civicrm-core/pull/15422))**

  Adds a new SQL queue type which will allow multiple runners to fetch the next
  available job from a queue and run in parallel.

- **Allow adding datepicker to metadata based settings pages
  ([16610](https://github.com/civicrm/civicrm-core/pull/16610))**

  Makes it so that datepicker can be added to metadata based settings pages by
  specifying html_Type='datepicker' in settings metadata.

### CiviContribute

- **Add payment processor to details on list of recurring contributions
  ([17179](https://github.com/civicrm/civicrm-core/pull/17179))**

  The list of recurring contributions now has a column showing the payment
  processor.

- **Fix all core processors to throw exceptions and not rely on the
  CRM_Core_Payment to convert errors to exceptions
  ([dev/financial#131](https://lab.civicrm.org/dev/financial/-/issues/131):
  [17565](https://github.com/civicrm/civicrm-core/pull/17565),
  [17559](https://github.com/civicrm/civicrm-core/pull/17559),
  [17542](https://github.com/civicrm/civicrm-core/pull/17542),
  [17502](https://github.com/civicrm/civicrm-core/pull/17502),
  [17500](https://github.com/civicrm/civicrm-core/pull/17500),
  [17597](https://github.com/civicrm/civicrm-core/pull/17597),
  [17592](https://github.com/civicrm/civicrm-core/pull/17592) and
  [17596](https://github.com/civicrm/civicrm-core/pull/17596))**

  Makes it so that core payment processors fail gracefully more often.

- **Add selfService flag to cancelSubscription getText so we can display
  different text for each case
  ([17687](https://github.com/civicrm/civicrm-core/pull/17687))**

  Makes it so payment processor developers can identify the different contexts
  someone may be canceling from and display appropriate messaging.

- **Price Field Form - Save the fid for the postProcess hook
  ([17639](https://github.com/civicrm/civicrm-core/pull/17639))**

  Improves `postProcess` hook for Price Field Form by making the field id
  available.

- **Improve error handling on IPN
  ([18062](https://github.com/civicrm/civicrm-core/pull/18062))**

  The error message and backtrace from a failed PayPal Website Payments Standard
  instant payment notification (IPN) are now logged.

### CiviMember

- **Display start/end adjustment on membership status page.
  ([dev/core#1809](https://lab.civicrm.org/dev/core/-/issues/1809):
  [17571](https://github.com/civicrm/civicrm-core/pull/17571))**

  Improves the Membership Status administration page by adding columns for the
  start/end adjustment.

### WordPress Integration

- **Provide concrete details about civicrm.files
  ([18011](https://github.com/civicrm/civicrm-core/pull/18011) follows on
  [dev/wordpress#66](https://lab.civicrm.org/dev/wordpress/-/issues/66), see
  also [17868](https://github.com/civicrm/civicrm-core/pull/17868))**

  A message will appear after an upgrade to 5.28.0 or later specifying the
  calculated and expected file upload locations.

  Changes appearing in 5.27 have been reverted but will be reapplied in 5.29
  after more notice is provided.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **Contact image is broken
  ([dev/wordpress#62](https://lab.civicrm.org/dev/wordpress/-/issues/62):
  [17853](https://github.com/civicrm/civicrm-core/pull/17853))**

  This resolves a problem on sites managed with Git where the `db.json` file
  would be missed.

- **Evaluate if any indexed fields are unused (Work Towards
  [dev/core#1634](https://lab.civicrm.org/dev/core/-/issues/1634):
  [17686](https://github.com/civicrm/civicrm-core/pull/17686))**

  Remove database index on `medium_id` from `civicrm_activity`.

- **Activity - Default priority value when adding an activity
  ([dev/core#1801](https://lab.civicrm.org/dev/core/-/issues/1801):
  [17557](https://github.com/civicrm/civicrm-core/pull/17557))**

  Ensures when creating a new activity the priority field defaults correctly for
  sites not in english.

- **The multi-lingual multi-domain problem
  ([dev/core#1852](https://lab.civicrm.org/dev/core/-/issues/1852):
  [17738](https://github.com/civicrm/civicrm-core/pull/17738) and
  [17733](https://github.com/civicrm/civicrm-core/pull/17733))**

  Ensures that the list of languages civicrm_domain.locales is the same for all
  domains in a multi-domain set up.

- **APIv4 - Skip empty leaves in WHERE clause
  ([17576](https://github.com/civicrm/civicrm-core/pull/17576))**

  Fixes a bug in search builder where APIv4 gives a SQL error while building
  your where clause.

- **Offset is not respected in Date Preferences
  ([dev/core#1847](https://lab.civicrm.org/dev/core/-/issues/1847) and
  [dev/core#1874](https://lab.civicrm.org/dev/core/-/issues/1874):
  [17762](https://github.com/civicrm/civicrm-core/pull/17762) and
  [17836](https://github.com/civicrm/civicrm-core/pull/17836))**

- **Fix CRM_Utils_JS::dedupeClosures to ignore comments
  ([17717](https://github.com/civicrm/civicrm-core/pull/17717))**

  Ensures comments do not interfere with deduping.

- **Use PHPUnit7 as the primary test runner
  ([17615](https://github.com/civicrm/civicrm-core/pull/17615),
  [17661](https://github.com/civicrm/civicrm-core/pull/17661),
  [120](https://github.com/civicrm/civicrm-backdrop/pull/120),
  [605](https://github.com/civicrm/civicrm-drupal/pull/605),
  [206](https://github.com/civicrm/civicrm-wordpress/pull/206))**

- **Fix isMultilingual to use static caching and respect current domain
  ([17646](https://github.com/civicrm/civicrm-core/pull/17646))**

  Improves the efficiency and accuracy of the `CRM_Core_I18n::isMultilingual`
  function, preventing a large number of duplicate queries on every request.

- **Update has_separator field in civicrm_navigation
  ([17579](https://github.com/civicrm/civicrm-core/pull/17579))**

  This field was incorrectly marked as a boolean; it's actually an int with an
  option list.

- **Civi\Payment\PropertyBag - Remove warning
  ([17506](https://github.com/civicrm/civicrm-core/pull/17506))**

- **Fix duplicate upgrade function
  ([17582](https://github.com/civicrm/civicrm-core/pull/17582))**

  Fixes a fatal error on upgrade caused by a merge conflict.

- **CRM_Case_XMLProcessor::allActivityTypes() doesn't do caching right
  ([dev/core#1433](https://lab.civicrm.org/dev/core/-/issues/1433):
  [17627](https://github.com/civicrm/civicrm-core/pull/17627),
  [17616](https://github.com/civicrm/civicrm-core/pull/17616) and
  [17614](https://github.com/civicrm/civicrm-core/pull/17614))**

- **CustomValue.GetTree API Does Not Return Display Value for Money Select/Radio
  Custom field ([dev/core#1566](https://lab.civicrm.org/dev/core/-/issues/1566):
  [17008](https://github.com/civicrm/civicrm-core/pull/17008))**

- **whom_url missing contact ID parameter in detailed logging report
  ([dev/core#1749](https://lab.civicrm.org/dev/core/-/issues/1749):
  [17440](https://github.com/civicrm/civicrm-core/pull/17440))**

- **Regression - File fields export results in DB error
  ([dev/core#1787](https://lab.civicrm.org/dev/core/-/issues/1787):
  [17578](https://github.com/civicrm/civicrm-core/pull/17578))**

- **Relative date filter - End of yesterday not working properly
  ([dev/core#1798](https://lab.civicrm.org/dev/core/-/issues/1798):
  [17512](https://github.com/civicrm/civicrm-core/pull/17512))**

- **Editing a custom field choice label changes the `name` if you do it from the
  custom field admin screens
  ([dev/core#1817](https://lab.civicrm.org/dev/core/-/issues/1817):
  [17681](https://github.com/civicrm/civicrm-core/pull/17681))**

- **Custom Date field with format=yy displays calendar icon that doesn't work
  ([dev/core#1829](https://lab.civicrm.org/dev/core/-/issues/1829):
  [17664](https://github.com/civicrm/civicrm-core/pull/17664))**

- **Unable to install 5.28 on Maria DB 10.3 on Ubuntu
  ([dev/core#1860](https://lab.civicrm.org/dev/core/-/issues/1860):
  [17772](https://github.com/civicrm/civicrm-core/pull/17772))**

- **APIv4 - Filter getActions results based on user permissions
  ([17540](https://github.com/civicrm/civicrm-core/pull/17540))**

- **Pre-upgrade message for php-intl shows twice
  ([17748](https://github.com/civicrm/civicrm-core/pull/17748))**

- **Fix saving of State/Province Multi-select values
  ([17737](https://github.com/civicrm/civicrm-core/pull/17737))**

- **[regression] Attempting to access Multi-Record Custom Field import results
  in crash ([dev/core#1841](https://lab.civicrm.org/dev/core/-/issues/1841):
  [17697](https://github.com/civicrm/civicrm-core/pull/17697))**

- **Use PSR-4 instead of PSR-0 in Civi directory
  ([17690](https://github.com/civicrm/civicrm-core/pull/17690))**

- **Sort options without relying on unavailable buildOptions param
  ([17621](https://github.com/civicrm/civicrm-core/pull/17621))**

- **Throw exception if id not passed into discard
  ([17666](https://github.com/civicrm/civicrm-core/pull/17666))**

- **Fix validation of select2 fields in "On behalf of Organisation" block
  ([17672](https://github.com/civicrm/civicrm-core/pull/17672))**

- **Pass required attribute for quickform fields through to form
  ([16488](https://github.com/civicrm/civicrm-core/pull/16488) and
  [17929](https://github.com/civicrm/civicrm-core/pull/17929) related to
  [dev/core#1903](https://lab.civicrm.org/dev/core/-/issues/1903))**

- **CRM_Core_I18n::setLocale() - Fix bug with repeated usage
  ([17374](https://github.com/civicrm/civicrm-core/pull/17374))**

- **Fix retrieving MySQL version for checking as part of install requirements
  ([17593](https://github.com/civicrm/civicrm-core/pull/17593))**

- **Set ContactType.name as required in the schema.
  ([17548](https://github.com/civicrm/civicrm-core/pull/17548),
  [17570](https://github.com/civicrm/civicrm-core/pull/17570), and
  [18070](https://github.com/civicrm/civicrm-core/pull/18070) related to
  [dev/core#1927](https://lab.civicrm.org/dev/core/-/issues/1927))**

- **Fix "Undefined variable: entryFound" notice on Bookkeeping report
  ([17554](https://github.com/civicrm/civicrm-core/pull/17554))**

- **Zip code range search only supports numeric zip codes
  ([17523](https://github.com/civicrm/civicrm-core/pull/17523))**

  Rather than causing a database error, this displays an error message when
  attempting to search a postal code range using non-numeric postal codes.

- **Remove isThrowException from CRM_Utils_Type::validate() signature
   ([17546](https://github.com/civicrm/civicrm-core/pull/17546))**

- **`codeVersion` not displayed in system status check error message about db
  version vs codeversion
  ([dev/core#1882](https://lab.civicrm.org/dev/core/-/issues/1882):
  [17854](https://github.com/civicrm/civicrm-core/pull/17854))**

- **"Merge" form moves unchecked related entities (intra-RC regression)
  ([dev/core#1930](https://lab.civicrm.org/dev/core/-/issues/1930):
  [18079](https://github.com/civicrm/civicrm-core/pull/18079))**

### CiviCase

- **Non-compliant query leads to (semi-)random sorting and failing unit test
  CRM_Case_BAO_CaseTest::testSortByCaseContact
  ([dev/core#1844](https://lab.civicrm.org/dev/core/-/issues/1844):
  [17708](https://github.com/civicrm/civicrm-core/pull/17708))**

### CiviContribute

- **Payment instrument ID is not required at processorform level
  ([17510](https://github.com/civicrm/civicrm-core/pull/17510))**

  Do not throw warning if payment instrument is not sent.

- **Bank fee has wrong date on import in civicrm_financial_item.transaction_date
  incorrected uses import date rather than payment date on
  ([dev/core#1776](https://lab.civicrm.org/dev/core/-/issues/1776):
  [17389](https://github.com/civicrm/civicrm-core/pull/17389))**

  Ensures the `civicrm_financial_item.transaction_date` gets recorded correctly
  when importing a transaction with a bank fee.

- **Payment.create should not set contribution date to today
  ([17688](https://github.com/civicrm/civicrm-core/pull/17688))**

- **Fix PHP notice when we don't have credit card params
  ([16514](https://github.com/civicrm/civicrm-core/pull/16514) and
  [17584](https://github.com/civicrm/civicrm-core/pull/17584))**

- **Improve PropertyBag handling of offsetGet and custom properties; add more
  tests ([17588](https://github.com/civicrm/civicrm-core/pull/17588) and
  [17654](https://github.com/civicrm/civicrm-core/pull/17654))**

- **Graphs on Contribution Summary report replace final row with grand total
  value ([dev/report#40](https://lab.civicrm.org/dev/report/-/issues/40):
  [17412](https://github.com/civicrm/civicrm-core/pull/17412))**

- **"Undefined offset" bug in BAO/FinancialAccount.php
  ([dev/wordpress#61](https://lab.civicrm.org/dev/wordpress/-/issues/61):
  [17701](https://github.com/civicrm/civicrm-core/pull/17701) and
  [17689](https://github.com/civicrm/civicrm-core/pull/17689))**

  Ensures that the financial account is set correctly even when the name does
  not match the label.

### CiviEvent

- **Event participant_listing_id field defaults to 0 instead of Null
  ([dev/core#1833](https://lab.civicrm.org/dev/core/-/issues/1833):
  [17677](https://github.com/civicrm/civicrm-core/pull/17677))**

- **Multiple line item shown on view contribution if participant is transferred
  to another contact.
  ([dev/core#890](https://lab.civicrm.org/dev/core/-/issues/890):
  [16956](https://github.com/civicrm/civicrm-core/pull/16956))**

### CiviGrant

- **Bug in Grant statistics report
  ([17640](https://github.com/civicrm/civicrm-core/pull/17640))**

### CiviSMS

- **Can't change SMS recipient on non-bulk SMS
  ([dev/core#1840](https://lab.civicrm.org/dev/core/-/issues/1840):
  [17691](https://github.com/civicrm/civicrm-core/pull/17691))**

### Drupal Integration

- **Error: Class 'CRM_Upgrade_Incremental_General' not found in
  Civi\Install\Requirements->checkMysqlVersion()
  ([dev/drupal#131](https://lab.civicrm.org/dev/drupal/-/issues/131):
  [18066](https://github.com/civicrm/civicrm-core/pull/18066))**

### Joomla Integration

- **Ensure that when normal routing trackable urls and opens in Joomla go to the
  frontend not administrator site
  ([17760](https://github.com/civicrm/civicrm-core/pull/17760))**

### WordPress Integration

- **Remove `/` from the beginning and end of query string
  ([207](https://github.com/civicrm/civicrm-wordpress/pull/207))**

  Fixes a 'You do not have permission to access this content.' error resulting
  from an extra '/' in the `q=` string in the url.

- **Base page fails to recognise Page Templates in subdirectories.
  ([dev/wordpress#58](https://lab.civicrm.org/dev/wordpress/-/issues/58):
  [204](https://github.com/civicrm/civicrm-wordpress/pull/204))**

  Ensures that the CiviCRM base page is correctly identified when it does not
  reside in the theme root directory.

- **Prevent session from starting during WordPress pseudo cron procedures
  ([dev/core#1889](https://lab.civicrm.org/dev/core/-/issues/1889):
  [17890](https://github.com/civicrm/civicrm-core/pull/17890) and
  [210](https://github.com/civicrm/civicrm-wordpress/pull/210))**

## <a name="misc"></a>Miscellany

- **Ship Flexmailer extension with civicrm-core
  ([17669](https://github.com/civicrm/civicrm-core/pull/17669),
  ([17768](https://github.com/civicrm/civicrm-core/pull/17768))**

- **Support passing old method name into deprecatedFunctionWarning
  ([17552](https://github.com/civicrm/civicrm-core/pull/17552))**

- **Add CRM_Core_Form::isFormInViewMode and CRM_Core_Form::isFormInEditMode
  ([17637](https://github.com/civicrm/civicrm-core/pull/17637))**

- **CRM_Utils_JS - Dedupe 'use strict' directive
  ([17711](https://github.com/civicrm/civicrm-core/pull/17711))**

- **Add isBackOffice, isPayLater, getPaymentMode helpers to
  frontendpaymentformtrait
  ([17511](https://github.com/civicrm/civicrm-core/pull/17511))**

- **Fix issue $this
  ([589](https://github.com/civicrm/civicrm-drupal/pull/589))**

- **Fix validateAll to no longer support unused abort param
  ([17544](https://github.com/civicrm/civicrm-core/pull/17544))**

- **Remove deprecated billingID from baseIPN
  ([17525](https://github.com/civicrm/civicrm-core/pull/17525))**

- **Add EntityFormTrait to pricefieldForm - stdised getEntityId()
  ([17516](https://github.com/civicrm/civicrm-core/pull/17516))**

- **Update contributor-key.yml
  ([17553](https://github.com/civicrm/civicrm-core/pull/17553))**

- **Export fix ([17644](https://github.com/civicrm/civicrm-core/pull/17644))**

- **Upgrade HTML Purifier to v4.12.0 to support for PHP7.4
  ([297](https://github.com/civicrm/civicrm-packages/pull/297))**

- **Temporary tables should follow consistent naming convention
  ([dev/core#183](https://lab.civicrm.org/dev/core/-/issues/183):
  [15796](https://github.com/civicrm/civicrm-core/pull/15796))**

- **Remove unreachable lines
  ([17563](https://github.com/civicrm/civicrm-core/pull/17563))**

- **EventInfo template cleanup
  ([17581](https://github.com/civicrm/civicrm-core/pull/17581))**

- **[NFC] Misspelled word
  ([17652](https://github.com/civicrm/civicrm-core/pull/17652))**

- **Remove a usage of deprecated funtion get_magic_quotes_gpc and also switch out
  {} for [] whne acecssing string or array offsets
  ([296](https://github.com/civicrm/civicrm-packages/pull/296))**

- **Remove unused deprecated class
  ([17535](https://github.com/civicrm/civicrm-core/pull/17535))**

- **Remove obsolete function formatWikiURL
  ([17726](https://github.com/civicrm/civicrm-core/pull/17726))**

- **[REF] Simplify the replacing of the email with the email from the url
  ([17491](https://github.com/civicrm/civicrm-core/pull/17491))**

- **[REF] Replace incorrect usages of array_key_exists when the variable is not
  an array with property_exists and also fix the parameter order for an implode
  statement ([17573](https://github.com/civicrm/civicrm-core/pull/17573))**

- **[REF] Convert Authorize.net to use Guzzle for update subscription class, add
  test ([17585](https://github.com/civicrm/civicrm-core/pull/17585))**

- **[REF] Using {} to access string or array offsets has been deprecated in
  PHP7.4 ([17574](https://github.com/civicrm/civicrm-core/pull/17574))**

- **[REF] Mark unused date functions as deprecated
  ([17487](https://github.com/civicrm/civicrm-core/pull/17487))**

- **[REF] Using ternary operation without nesting is deprecated and also using
  methods and properly instanciate the CiviCase Info object in test
  ([17575](https://github.com/civicrm/civicrm-core/pull/17575))**

- **[REF] Convert Authorize.net doDirectPayment to use guzzle & add test
  ([17501](https://github.com/civicrm/civicrm-core/pull/17501))**

- **[REF] Replace the deprecated system_rebuild_module_data function with
  equivilant extension.list.module service function calls to be Drupal 9
  compatiable ([17515](https://github.com/civicrm/civicrm-core/pull/17515))**

- **[REF] Remove never reachable lines.
  ([17556](https://github.com/civicrm/civicrm-core/pull/17556))**

- **[REF] Remove another instance of fatal()
  ([17549](https://github.com/civicrm/civicrm-core/pull/17549))**

- **[REF] Readability extraction in Dummy class
  ([17543](https://github.com/civicrm/civicrm-core/pull/17543))**

- **[REF] Replace some instances of fatal with thrown exceptions.
  ([17533](https://github.com/civicrm/civicrm-core/pull/17533))**

- **[REF] Remove calls to, and deprecate, unhandled function
  ([17499](https://github.com/civicrm/civicrm-core/pull/17499))**

- **[REF] Remove handling for 2 fields not on the form
  ([17504](https://github.com/civicrm/civicrm-core/pull/17504))**

- **[REF] Remove some instances of fatal in BAO classes
  ([17536](https://github.com/civicrm/civicrm-core/pull/17536))**

- **[REF] Access the method not the property directly to check if a payment
  processor supports recurring
  ([17602](https://github.com/civicrm/civicrm-core/pull/17602))**

- **[REF] Ensure that our custom error handler is called when jQuery validates
  and expand any collapsed accordions that are hiding required fields that
  haven't been filled in
  ([17673](https://github.com/civicrm/civicrm-core/pull/17673))**

- **[REF] Consolidate code in processMembership
  ([17611](https://github.com/civicrm/civicrm-core/pull/17611))**

- **[REF] Cleanup function for retrieving contact types.
  ([17676](https://github.com/civicrm/civicrm-core/pull/17676))**

- **[REF] Fix Javascript syntax error
  ([17678](https://github.com/civicrm/civicrm-core/pull/17678))**

- **[REF] Fix jQuery error message display on select2 field validation
  ([17671](https://github.com/civicrm/civicrm-core/pull/17671))**

- **[REF] Fix allowing users to clear values for raido custom fields when not
  required ([17670](https://github.com/civicrm/civicrm-core/pull/17670))**

- **[REF] Extract getTestTrxnID
  ([17642](https://github.com/civicrm/civicrm-core/pull/17642))**

- **Update Flexmailer to be PHP7.4 compatible
  ([17779](https://github.com/civicrm/civicrm-core/pull/17779), [17660](https://github.com/civicrm/civicrm-core/pull/17660))**

- **[REF] Ensure that the Manual Payment Processor sets the _paymentProcessor
  variable like other Processors to fix issues in PHP7.4 and UnitTests
  ([17648](https://github.com/civicrm/civicrm-core/pull/17648))**

- **[REF] Fix PHP7.4 Test fails when we are accessing array keys when the value
  is not an array
  ([17649](https://github.com/civicrm/civicrm-core/pull/17649))**

- **[REF] Fix parts of code where curly brackets were being used for array or
  string access which is deprecated in PHP7.4
  ([17647](https://github.com/civicrm/civicrm-core/pull/17647))**

- **[REF] Fix issue with using array access tools on NULL values
  ([17600](https://github.com/civicrm/civicrm-core/pull/17600))**

- **[REF] Replace incorrect usage of array_key_exists with property_exists in
  Group BAO Class
  ([17604](https://github.com/civicrm/civicrm-core/pull/17604))**

- **[REF] Add test for renewing old expired membership via form
  ([17564](https://github.com/civicrm/civicrm-core/pull/17564))**

- **[REF] Update packages to work with PHP7.4
  ([17598](https://github.com/civicrm/civicrm-core/pull/17598))**

- **[REF] Fix another couple of uses of array_key_exists when the variable being
  checked is an object
  ([17601](https://github.com/civicrm/civicrm-core/pull/17601))**

- **[REF] Remove deprecated methods of booting Drupal container and getting
  Drupal timezone information
  ([17522](https://github.com/civicrm/civicrm-core/pull/17522))**

- **[REF] Fix some additional issues where curly braces were being used to
  access string or array offsets
  ([17599](https://github.com/civicrm/civicrm-core/pull/17599))**

- **[NFC] Update existing APIv3 MembershipType Tests to also test against APIv4
  as appropriate ([17528](https://github.com/civicrm/civicrm-core/pull/17528))**

- **[NFC] cleanup docblocks in CRM_Utils_JS
  ([17714](https://github.com/civicrm/civicrm-core/pull/17714))**

- **[NFC] Fix some outdated wiki links
  ([17739](https://github.com/civicrm/civicrm-core/pull/17739))**

- **[NFC] Fix contributor key for Lighthouse Consulting and Design
  ([17727](https://github.com/civicrm/civicrm-core/pull/17727))**

- **[NFC] Fix unit test failure on MySQL 8 due to ordering issue
  ([17674](https://github.com/civicrm/civicrm-core/pull/17674))**

- **[NFC] Remove instances where html is passed to crmMoney
  ([17612](https://github.com/civicrm/civicrm-core/pull/17612))**

- **[NFC] Add assertions to existing test to lock in current behaviour
  ([17605](https://github.com/civicrm/civicrm-core/pull/17605))**

- **[NFC] Update mocking to use getMockBuilder instead instead of createMock
  ([17606](https://github.com/civicrm/civicrm-core/pull/17606))**

- **[NFC] Formatting cleanup on contribution/recur templates
  ([17603](https://github.com/civicrm/civicrm-core/pull/17603))**

- **[NFC] Minor code cleanup
  ([17566](https://github.com/civicrm/civicrm-core/pull/17566))**

- **MembershipRenewalTest - Fix failure
  ([17830](https://github.com/civicrm/civicrm-core/pull/17830))**

- **[REF] Fix regression where adding any date based field onto a profile
  triggers an error date preferences not configured when previewing the profile
  ([17973](https://github.com/civicrm/civicrm-core/pull/17973))**

- **[NFC] Port some recent test fixes from master to 5.28
  ([18053](https://github.com/civicrm/civicrm-core/pull/18053))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin, Andrew Hunt; British Humanist Association -
Andrew West; Christian Wach; Circle Interactive - Pradeep Nayak; CiviCRM -
Coleman Watts, Tim Otten; CiviDesk - Yashodha Chaku; CompuCorp - Ivan; Coop
SymbioTIC - Mathieu Lutfy, Samuel Vanhove; Dave D; Dietermartens; ES-Progress -
Sandor Semsey; Flinders University of South Australia - Tom Anderson; Fuzion -
Jitendra Purohit; JMA Consulting - Seamus Lee; Lighthouse Consulting and
Design- Brian Shaughnessy; Marcin Lewandowski; Megaphone Technology Consulting -
Jon Goldberg; MJW Consulting - Matthew Wire; Tadpole Collective - Kevin
Cristiano; Wikimedia Foundation - Eileen McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

a-n The Artists Information Company - William Mortada; Agileware - Francis
Whittle, Justin Freeman; Andrew Thompson; Artful Robot - Rich Lott; Betty
Dolfing; Blackfly Solutions - Alan Dixon; CiviCoop - Jaap Jansma; Fuzion - Luke
Stewart, Peter Davis; JMA Consulting - Joe Murray; MJCO - Mikey O'Toole; Semper
IT - Karin Gerritsen; Squiffle Consulting - Aidan Saunders; Third Sector Design:
Eriol Fox; Timbsoft Technologies - Tunbola Ogunwande

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andrew Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
