# +========================================================================+
# || Copyright (C) 2009 by Christian Kuelker                              ||
# ||                                                                      ||
# || License: GNU General Public License - GNU GPL - version 2            ||
# ||          or (at your opinion) any later version.                     ||
# +========================================================================+
#  ID:       $Id$
#  Revision: $Revision$
#  Head URL: $HeadURL$
#  Date:     $Date$
#  Source:   $Source$

package CipUX::CAT::Web::Exception;

use 5.008001;
use warnings;
use strict;
use Class::Std;
use CGI::Carp qw(carpout fatalsToBrowser warningsToBrowser cluck);
use CGI::FormBuilder;
use Data::Dumper;
use English qw( -no_match_vars);
use Log::Log4perl qw(get_logger :levels);
use Readonly;

use base qw(CipUX::CAT::Web::L10N);
{

    use version; our $VERSION = qv('3.4.0.3');
    use re 'taint';    # Keep data captured by parens tainted
    delete @ENV{qw(PATH IFS CDPATH ENV BASH_ENV)};    # Make %ENV safer

    # CONST
    Readonly::Scalar my $EMPTY_STRING => q{};

    # OBJECT
    my %login_of :
        ATTR( init_arg => 'cat_login' :set<login> :default('view_login') );
    my %session_of :
        ATTR( init_arg => 'cat_session' :set<session> :default('view_session') );
    my %locale_of :
        ATTR( init_arg => 'cat_locale' :set<locale> :default('en') );
    my %theme_of :
        ATTR( init_arg => 'cat_theme' :set<theme> :default('default') );

    sub exception {
        my ( $self, $arg_r ) = @_;
        $arg_r->{type} = 'exception';
        return $self->throw($arg_r);
    }

    sub error {
        my ( $self, $arg_r ) = @_;
        $arg_r->{type} = 'error';
        return $self->throw($arg_r);
    }

    sub throw {

        my ( $self, $arg_r ) = @_;
        my $module
            = ( exists $arg_r->{module} )
            ? $self->l( $arg_r->{module} )
            : 'unknown';
        my $msg
            = ( exists $arg_r->{msg} )
            ? $arg_r->{msg}
            : 'unknown';

        # exception, error
        my $type = ( exists $arg_r->{type} ) ? $arg_r->{type} : 'exception';

#TODO?
#my $cfg_hr = ( exists $arg_r->{cfg_hr} ) ? $self->h( $arg_r->{cfg_hr} ) : $self->perr('cfg_hr');

        my $tag
            = ( defined $locale_of{ ident $self}
                and $locale_of{ ident $self} )
            ? $locale_of{ ident $self}
            : 'en';
        my $lh = CipUX::CAT::Web::L10N->get_handle($tag);

        my $theme
            = ( defined $theme_of{ ident $self} and $theme_of{ ident $self} )
            ? $theme_of{ ident $self}
            : 'default';

        my $path = 'tpl/' . $theme;

        my $style    = $path . '/form.css';
        my $template = $path . "/$type/index.html";
        my $layout   = $path . "/$type/layout.html";

        my $cookie_hr = {};
        if ( $type eq 'exception' ) {
            $cookie_hr = { cat_login => 'login', cat_session => 'login' };
        }

        return {
            cookie_hr => $cookie_hr,
            layout    => $layout,
            layout_ar => [
                { begin_html => 1, },
                {
                    tt2_hr => {
                        tpl      => $template,
                        param_hr => {
                            SHOW_DEBUG => 0,
                            LOGIN      => $login_of{ ident $self},
                            SESSION    => $session_of{ ident $self},
                            THEME      => $theme_of{ ident $self},
                            LOCALE     => $locale_of{ ident $self},
                            PATH       => $path,
                            MODULE     => $module,
                            MSG        => $msg,
                            TAG        => $tag,
                            lh         => $lh,
                        },

                    },
                },

                { end_html => 1, },
            ],

        };
    }

}
1;

__END__


