// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef REMOTING_HOST_WIN_COM_SECURITY_H_
#define REMOTING_HOST_WIN_COM_SECURITY_H_

#include <string>

// Concatenates ACE type, permissions and sid given as SDDL strings into an ACE
// definition in SDDL form.
#define SDDL_ACE(type, permissions, sid) \
    L"(" type L";;" permissions L";;;" sid L")"

// Text representation of COM_RIGHTS_EXECUTE and COM_RIGHTS_EXECUTE_LOCAL
// permission bits that is used in the SDDL definition below.
#define SDDL_COM_EXECUTE_LOCAL L"0x3"

namespace remoting {

// Initializes COM security of the process applying the passed security
// descriptor. The mandatory label is applied if mandatory integrity control is
// supported by the OS (i.e. on Vista and above). The function configures
// the following settings:
//  - the server authenticates that all data received is from the expected
//    client.
//  - the server can impersonate clients to check their identity but cannot act
//    on their behalf.
//  - the caller's identity is verified on every call (Dynamic cloaking).
//  - Unless |activate_as_activator| is true, activations where the server would
//    run under this process's identity are prohibited.
bool InitializeComSecurity(const std::string& security_descriptor,
                           const std::string& mandatory_label,
                           bool activate_as_activator);

} // namespace remoting

#endif  // REMOTING_HOST_WIN_COM_SECURITY_H_
