// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ppapi/proxy/plugin_resource_var.h"

PluginResourceVar::PluginResourceVar() {}

PluginResourceVar::PluginResourceVar(ppapi::Resource* resource)
    : resource_(resource) {}

PP_Resource PluginResourceVar::GetPPResource() const {
  return resource_ ? resource_->pp_resource() : 0;
}

bool PluginResourceVar::IsPending() const {
  return false;
}

PluginResourceVar::~PluginResourceVar() {}
