/***********************************************************************
    filename:   CEGUIFribidiVisualMapping.h
    created:    Wed Aug 5 2009
    author:     Paul D Turner <paul@cegui.org.uk>
*************************************************************************/
/***************************************************************************
 *   Copyright (C) 2004 - 2009 Paul D Turner & The CEGUI Development Team
 *
 *   Permission is hereby granted, free of charge, to any person obtaining
 *   a copy of this software and associated documentation files (the
 *   "Software"), to deal in the Software without restriction, including
 *   without limitation the rights to use, copy, modify, merge, publish,
 *   distribute, sublicense, and/or sell copies of the Software, and to
 *   permit persons to whom the Software is furnished to do so, subject to
 *   the following conditions:
 *
 *   The above copyright notice and this permission notice shall be
 *   included in all copies or substantial portions of the Software.
 *
 *   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 *   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 *   MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 *   IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR
 *   OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 *   ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 *   OTHER DEALINGS IN THE SOFTWARE.
 ***************************************************************************/
#ifndef _CEGUIFribidiVisualMapping_h_
#define _CEGUIFribidiVisualMapping_h_

#include "CEGUIBiDiVisualMapping.h"

// Start of CEGUI namespace section
namespace CEGUI
{
//! fribidi based implementation of BiDiVisualMapping.
class FribidiVisualMapping : public BiDiVisualMapping
{
public:
    // implement required interface.
    BidiCharType getBidiCharType(const utf32 char_to_check) const;
    bool reorderFromLogicalToVisual(const String& logical, String& visual,
                                    StrIndexList& l2v, StrIndexList& v2l) const;
};

} // End of  CEGUI namespace section

#endif  // end of guard _CEGUIFribidiVisualMapping_h_
