from __future__ import absolute_import, division, print_function
from libtbx import easy_run
from libtbx.test_utils import approx_equal
import time

# angle = 90
pdb_str_1 = """\
CRYST1   15.000   15.000   15.000  80.00  70.00 100.00 P 1
HETATM    1  O   HOH X   1       0.000   1.000   0.000  1.00 20.00           O
HETATM    1  O   HOH X   1       0.000   2.000   0.000  1.00 20.00           O
HETATM    1  O   HOH X   1       0.000   3.000   0.000  1.00 20.00           O
HETATM    1  O   HOH X   1       0.000   4.000   0.000  1.00 20.00           O
HETATM    1  O   HOH X   1       0.000   5.000   0.000  1.00 20.00           O
HETATM    1  O   HOH Y   1       1.000   0.000   0.000  1.00 20.00           O
HETATM    1  O   HOH Y   1       2.000   0.000   0.000  1.00 20.00           O
HETATM    1  O   HOH Y   1       3.000   0.000   0.000  1.00 20.00           O
HETATM    1  O   HOH Y   1       4.000   0.000   0.000  1.00 20.00           O
HETATM    1  O   HOH Y   1       5.000   0.000   0.000  1.00 20.00           O
END
"""

pdb_str_2 = """\
CRYST1   15.000   15.000   15.000  80.00  70.00 100.00 P 1
HETATM    1  O   HOH X   1       1.000   0.000   0.000  1.00 20.00           O
HETATM    1  O   HOH X   1       2.000   0.000   0.000  1.00 20.00           O
HETATM    1  O   HOH X   1       3.000   0.000   0.000  1.00 20.00           O
HETATM    1  O   HOH X   1       4.000   0.000   0.000  1.00 20.00           O
HETATM    1  O   HOH X   1       5.000   0.000   0.000  1.00 20.00           O
HETATM    1  O   HOH Y   1       0.000   0.000   1.000  1.00 20.00           O
HETATM    1  O   HOH Y   1       0.000   0.000   2.000  1.00 20.00           O
HETATM    1  O   HOH Y   1       0.000   0.000   3.000  1.00 20.00           O
HETATM    1  O   HOH Y   1       0.000   0.000   4.000  1.00 20.00           O
HETATM    1  O   HOH Y   1       0.000   0.000   5.000  1.00 20.00           O
END
"""

pdb_str_3 = """\
CRYST1   15.000   15.000   15.000  80.00  70.00 100.00 P 1
HETATM    1  O   HOH X   1       1.000   0.000   0.000  1.00 20.00           O
HETATM    1  O   HOH X   1       2.000   0.000   0.000  1.00 20.00           O
HETATM    1  O   HOH X   1       3.000   0.000   0.000  1.00 20.00           O
HETATM    1  O   HOH X   1       4.000   0.000   0.000  1.00 20.00           O
HETATM    1  O   HOH X   1       5.000   0.000   0.000  1.00 20.00           O
HETATM    1  O   HOH Y   1       0.000   1.000   0.000  1.00 20.00           O
HETATM    1  O   HOH Y   1       0.000   2.000   0.000  1.00 20.00           O
HETATM    1  O   HOH Y   1       0.000   3.000   0.000  1.00 20.00           O
HETATM    1  O   HOH Y   1       0.000   4.000   0.000  1.00 20.00           O
HETATM    1  O   HOH Y   1       0.000   5.000   0.000  1.00 20.00           O
END
"""

# angle = 0
pdb_str_4 = """\
CRYST1   15.000   15.000   15.000  80.00  70.00 100.00 P 1
HETATM    1  O   HOH X   1       1.000   0.000   0.000  1.00 20.00           O
HETATM    1  O   HOH X   1       2.000   0.000   0.000  1.00 20.00           O
HETATM    1  O   HOH X   1       3.000   0.000   0.000  1.00 20.00           O
HETATM    1  O   HOH X   1       4.000   0.000   0.000  1.00 20.00           O
HETATM    1  O   HOH X   1       5.000   0.000   0.000  1.00 20.00           O
HETATM    1  O   HOH Y   1      11.000   0.000   0.000  1.00 20.00           O
HETATM    1  O   HOH Y   1      12.000   0.000   0.000  1.00 20.00           O
HETATM    1  O   HOH Y   1      13.000   0.000   0.000  1.00 20.00           O
HETATM    1  O   HOH Y   1      14.000   0.000   0.000  1.00 20.00           O
HETATM    1  O   HOH Y   1      15.000   0.000   0.000  1.00 20.00           O
END
"""

pdb_str_5 = """\
CRYST1   15.000   15.000   15.000  80.00  70.00 100.00 P 1
HETATM    1  O   HOH X   1       0.000   1.000   0.000  1.00 20.00           O
HETATM    1  O   HOH X   1       0.000   2.000   0.000  1.00 20.00           O
HETATM    1  O   HOH X   1       0.000   3.000   0.000  1.00 20.00           O
HETATM    1  O   HOH X   1       0.000   4.000   0.000  1.00 20.00           O
HETATM    1  O   HOH X   1       0.000   5.000   0.000  1.00 20.00           O
HETATM    1  O   HOH Y   1       0.000  11.000   0.000  1.00 20.00           O
HETATM    1  O   HOH Y   1       0.000  12.000   0.000  1.00 20.00           O
HETATM    1  O   HOH Y   1       0.000  13.000   0.000  1.00 20.00           O
HETATM    1  O   HOH Y   1       0.000  14.000   0.000  1.00 20.00           O
HETATM    1  O   HOH Y   1       0.000  15.000   0.000  1.00 20.00           O
END
"""

pdb_str_6 = """\
CRYST1   15.000   15.000   15.000  80.00  70.00 100.00 P 1
HETATM    1  O   HOH X   1       0.000   0.000   1.000  1.00 20.00           O
HETATM    1  O   HOH X   1       0.000   0.000   2.000  1.00 20.00           O
HETATM    1  O   HOH X   1       0.000   0.000   3.000  1.00 20.00           O
HETATM    1  O   HOH X   1       0.000   0.000   4.000  1.00 20.00           O
HETATM    1  O   HOH X   1       0.000   0.000   5.000  1.00 20.00           O
HETATM    1  O   HOH Y   1       0.000   0.000  11.000  1.00 20.00           O
HETATM    1  O   HOH Y   1       0.000   0.000  12.000  1.00 20.00           O
HETATM    1  O   HOH Y   1       0.000   0.000  13.000  1.00 20.00           O
HETATM    1  O   HOH Y   1       0.000   0.000  14.000  1.00 20.00           O
HETATM    1  O   HOH Y   1       0.000   0.000  15.000  1.00 20.00           O
END
"""

pdb_str_7 = """\
CRYST1   15.000   15.000   15.000  80.00  70.00 100.00 P 1
HETATM    1  O   HOH X   1       0.000   0.000   0.000  1.00 20.00           O
HETATM    1  O   HOH X   1       0.000   0.000   0.000  1.00 20.00           O
HETATM    1  O   HOH X   1       0.000   0.000   0.000  1.00 20.00           O
HETATM    1  O   HOH X   1       0.000   0.000   0.000  1.00 20.00           O
HETATM    1  O   HOH X   1       0.000   0.000   0.000  1.00 20.00           O
HETATM    1  O   HOH Y   1       0.000   0.000   0.000  1.00 20.00           O
HETATM    1  O   HOH Y   1       0.000   0.000   0.000  1.00 20.00           O
HETATM    1  O   HOH Y   1       0.000   0.000   0.000  1.00 20.00           O
HETATM    1  O   HOH Y   1       0.000   0.000   0.000  1.00 20.00           O
HETATM    1  O   HOH Y   1       0.000   0.000   0.000  1.00 20.00           O
END
"""

# 45
pdb_str_8 = """\
CRYST1   15.000   15.000   15.000  80.00  70.00 100.00 P 1
HETATM    1  O   HOH X   1       1.000   0.000   0.000  1.00 20.00           O
HETATM    1  O   HOH X   1       2.000   0.000   0.000  1.00 20.00           O
HETATM    1  O   HOH X   1       3.000   0.000   0.000  1.00 20.00           O
HETATM    1  O   HOH X   1       4.000   0.000   0.000  1.00 20.00           O
HETATM    1  O   HOH X   1       5.000   0.000   0.000  1.00 20.00           O
HETATM    1  O   HOH Y   1       1.000   1.000   0.000  1.00 20.00           O
HETATM    1  O   HOH Y   1       2.000   2.000   0.000  1.00 20.00           O
HETATM    1  O   HOH Y   1       3.000   3.000   0.000  1.00 20.00           O
HETATM    1  O   HOH Y   1       4.000   4.000   0.000  1.00 20.00           O
HETATM    1  O   HOH Y   1       5.000   5.000   0.000  1.00 20.00           O
END
"""

pdb_str_9 = """\
CRYST1   15.000   15.000   15.000  80.00  70.00 100.00 P 1
HETATM    1  O   HOH X   1       1.000   0.000   0.000  1.00 20.00           O
HETATM    1  O   HOH X   1       2.000   0.000   0.000  1.00 20.00           O
HETATM    1  O   HOH X   1       3.000   0.000   0.000  1.00 20.00           O
HETATM    1  O   HOH X   1       4.000   0.000   0.000  1.00 20.00           O
HETATM    1  O   HOH X   1       5.000   0.000   0.000  1.00 20.00           O
HETATM    1  O   HOH Y   1      -1.000  -1.000   0.000  1.00 20.00           O
HETATM    1  O   HOH Y   1      -2.000  -2.000   0.000  1.00 20.00           O
HETATM    1  O   HOH Y   1      -3.000  -3.000   0.000  1.00 20.00           O
HETATM    1  O   HOH Y   1      -4.000  -4.000   0.000  1.00 20.00           O
HETATM    1  O   HOH Y   1      -5.000  -5.000   0.000  1.00 20.00           O
END
"""

# real case
pdb_str_10 = """\
CRYST1  167.218  167.218   80.113  90.00  90.00 120.00 H 3
ATOM      1  P    DA X   1     -22.252  -4.076  16.901  1.00 30.00           P
ATOM      2  OP1  DA X   1     -21.894  -2.937  17.777  1.00 30.00           O
ATOM      3  OP2  DA X   1     -22.778  -3.816  15.541  1.00 30.00           O
ATOM      4  O5'  DA X   1     -20.992  -5.062  16.794  1.00 30.00           O
ATOM      5  C5'  DA X   1     -20.219  -5.368  17.962  1.00 30.00           C
ATOM      6  C4'  DA X   1     -18.753  -5.626  17.619  1.00 30.00           C
ATOM      7  O4'  DA X   1     -18.660  -6.677  16.626  1.00 30.00           O
ATOM      8  C3'  DA X   1     -18.001  -4.445  17.014  1.00 30.00           C
ATOM      9  O3'  DA X   1     -16.607  -4.570  17.262  1.00 30.00           O
ATOM     10  C2'  DA X   1     -18.289  -4.614  15.538  1.00 30.00           C
ATOM     11  C1'  DA X   1     -18.218  -6.130  15.397  1.00 30.00           C
ATOM     12  N9   DA X   1     -19.076  -6.629  14.347  1.00 30.00           N
ATOM     13  C8   DA X   1     -20.403  -6.936  14.445  1.00 30.00           C
ATOM     14  N7   DA X   1     -20.928  -7.358  13.325  1.00 30.00           N
ATOM     15  C5   DA X   1     -19.871  -7.315  12.432  1.00 30.00           C
ATOM     16  C6   DA X   1     -19.774  -7.635  11.075  1.00 30.00           C
ATOM     17  N6   DA X   1     -20.805  -8.088  10.364  1.00 30.00           N
ATOM     18  N1   DA X   1     -18.572  -7.478  10.476  1.00 30.00           N
ATOM     19  C2   DA X   1     -17.541  -7.038  11.204  1.00 30.00           C
ATOM     20  N3   DA X   1     -17.514  -6.699  12.489  1.00 30.00           N
ATOM     21  C4   DA X   1     -18.724  -6.865  13.048  1.00 30.00           C
ATOM     22  P    DA X   2     -15.623  -3.332  16.967  1.00 30.00           P
ATOM     23  OP1  DA X   2     -14.608  -3.313  18.042  1.00 30.00           O
ATOM     24  OP2  DA X   2     -16.467  -2.142  16.723  1.00 30.00           O
ATOM     25  O5'  DA X   2     -14.901  -3.698  15.585  1.00 30.00           O
ATOM     26  C5'  DA X   2     -13.821  -2.886  15.121  1.00 30.00           C
ATOM     27  C4'  DA X   2     -13.517  -3.152  13.657  1.00 30.00           C
ATOM     28  O4'  DA X   2     -14.632  -3.871  13.053  1.00 30.00           O
ATOM     29  C3'  DA X   2     -13.327  -1.887  12.813  1.00 30.00           C
ATOM     30  O3'  DA X   2     -12.303  -2.071  11.822  1.00 30.00           O
ATOM     31  C2'  DA X   2     -14.693  -1.723  12.174  1.00 30.00           C
ATOM     32  C1'  DA X   2     -15.061  -3.170  11.912  1.00 30.00           C
ATOM     33  N9   DA X   2     -16.493  -3.362  11.737  1.00 30.00           N
ATOM     34  C8   DA X   2     -17.485  -3.036  12.619  1.00 30.00           C
ATOM     35  N7   DA X   2     -18.691  -3.300  12.177  1.00 30.00           N
ATOM     36  C5   DA X   2     -18.472  -3.826  10.915  1.00 30.00           C
ATOM     37  C6   DA X   2     -19.343  -4.306   9.920  1.00 30.00           C
ATOM     38  N6   DA X   2     -20.675  -4.334  10.048  1.00 30.00           N
ATOM     39  N1   DA X   2     -18.792  -4.754   8.777  1.00 30.00           N
ATOM     40  C2   DA X   2     -17.463  -4.734   8.643  1.00 30.00           C
ATOM     41  N3   DA X   2     -16.545  -4.315   9.505  1.00 30.00           N
ATOM     42  C4   DA X   2     -17.121  -3.863  10.629  1.00 30.00           C
ATOM     43  P    DG X   3     -11.350  -0.840  11.404  1.00 30.00           P
ATOM     44  OP1  DG X   3      -9.966  -1.340  11.327  1.00 30.00           O
ATOM     45  OP2  DG X   3     -11.663   0.296  12.295  1.00 30.00           O
ATOM     46  O5'  DG X   3     -11.812  -0.444   9.923  1.00 30.00           O
ATOM     47  C5'  DG X   3     -13.083   0.157   9.706  1.00 30.00           C
ATOM     48  C4'  DG X   3     -13.884  -0.639   8.690  1.00 30.00           C
ATOM     49  O4'  DG X   3     -15.169  -0.989   9.235  1.00 30.00           O
ATOM     50  C3'  DG X   3     -14.199   0.103   7.398  1.00 30.00           C
ATOM     51  O3'  DG X   3     -13.216  -0.199   6.401  1.00 30.00           O
ATOM     52  C2'  DG X   3     -15.607  -0.386   7.002  1.00 30.00           C
ATOM     53  C1'  DG X   3     -16.033  -1.286   8.169  1.00 30.00           C
ATOM     54  N9   DG X   3     -17.411  -1.063   8.603  1.00 30.00           N
ATOM     55  C8   DG X   3     -17.825  -0.414   9.740  1.00 30.00           C
ATOM     56  N7   DG X   3     -19.121  -0.359   9.863  1.00 30.00           N
ATOM     57  C5   DG X   3     -19.598  -1.012   8.734  1.00 30.00           C
ATOM     58  C6   DG X   3     -20.927  -1.261   8.328  1.00 30.00           C
ATOM     59  O6   DG X   3     -21.966  -0.934   8.909  1.00 30.00           O
ATOM     60  N1   DG X   3     -20.980  -1.967   7.118  1.00 30.00           N
ATOM     61  C2   DG X   3     -19.869  -2.356   6.401  1.00 30.00           C
ATOM     62  N2   DG X   3     -20.096  -3.006   5.259  1.00 30.00           N
ATOM     63  N3   DG X   3     -18.618  -2.126   6.780  1.00 30.00           N
ATOM     64  C4   DG X   3     -18.559  -1.450   7.949  1.00 30.00           C
ATOM     65  P    DC X   4     -13.188  -1.621   5.640  1.00 30.00           P
ATOM     66  OP1  DC X   4     -11.804  -1.757   5.138  1.00 30.00           O
ATOM     67  OP2  DC X   4     -13.754  -2.709   6.473  1.00 30.00           O
ATOM     68  O5'  DC X   4     -14.144  -1.403   4.375  1.00 30.00           O
ATOM     69  C5'  DC X   4     -13.955  -2.190   3.197  1.00 30.00           C
ATOM     70  C4'  DC X   4     -14.524  -1.482   1.984  1.00 30.00           C
ATOM     71  O4'  DC X   4     -15.947  -1.775   1.887  1.00 30.00           O
ATOM     72  C3'  DC X   4     -14.427   0.027   2.048  1.00 30.00           C
ATOM     73  O3'  DC X   4     -13.164   0.505   1.487  1.00 30.00           O
ATOM     74  C2'  DC X   4     -15.632   0.468   1.213  1.00 30.00           C
ATOM     75  C1'  DC X   4     -16.668  -0.622   1.488  1.00 30.00           C
ATOM     76  N1   DC X   4     -17.683  -0.282   2.571  1.00 30.00           N
ATOM     77  C2   DC X   4     -19.052  -0.141   2.251  1.00 30.00           C
ATOM     78  O2   DC X   4     -19.417  -0.277   1.076  1.00 30.00           O
ATOM     79  N3   DC X   4     -19.938   0.151   3.250  1.00 30.00           N
ATOM     80  C4   DC X   4     -19.490   0.294   4.507  1.00 30.00           C
ATOM     81  N4   DC X   4     -20.370   0.575   5.469  1.00 30.00           N
ATOM     82  C5   DC X   4     -18.116   0.152   4.836  1.00 30.00           C
ATOM     83  C6   DC X   4     -17.262  -0.140   3.857  1.00 30.00           C
ATOM     84  P    DC X   5     -11.972   1.062   2.428  1.00 30.00           P
ATOM     85  OP1  DC X   5     -10.698   0.780   1.730  1.00 30.00           O
ATOM     86  OP2  DC X   5     -12.176   0.591   3.811  1.00 30.00           O
ATOM     87  O5'  DC X   5     -12.164   2.653   2.443  1.00 30.00           O
ATOM     88  C5'  DC X   5     -12.886   3.290   3.505  1.00 30.00           C
ATOM     89  C4'  DC X   5     -14.372   3.021   3.359  1.00 30.00           C
ATOM     90  O4'  DC X   5     -15.004   2.870   4.653  1.00 30.00           O
ATOM     91  C3'  DC X   5     -15.202   4.073   2.597  1.00 30.00           C
ATOM     92  O3'  DC X   5     -16.015   3.409   1.614  1.00 30.00           O
ATOM     93  C2'  DC X   5     -16.078   4.655   3.707  1.00 30.00           C
ATOM     94  C1'  DC X   5     -16.290   3.402   4.527  1.00 30.00           C
ATOM     95  N1   DC X   5     -16.869   3.620   5.862  1.00 30.00           N
ATOM     96  C2   DC X   5     -18.253   3.538   6.020  1.00 30.00           C
ATOM     97  O2   DC X   5     -18.948   3.302   5.034  1.00 30.00           O
ATOM     98  N3   DC X   5     -18.791   3.724   7.249  1.00 30.00           N
ATOM     99  C4   DC X   5     -17.988   3.980   8.286  1.00 30.00           C
ATOM    100  N4   DC X   5     -18.551   4.159   9.485  1.00 30.00           N
ATOM    101  C5   DC X   5     -16.569   4.060   8.141  1.00 30.00           C
ATOM    102  C6   DC X   5     -16.058   3.872   6.922  1.00 30.00           C
ATOM    103  P    DG X   6     -15.767   3.603   0.033  1.00 30.00           P
ATOM    104  OP1  DG X   6     -14.509   2.906  -0.328  1.00 30.00           O
ATOM    105  OP2  DG X   6     -15.921   5.044  -0.249  1.00 30.00           O
ATOM    106  O5'  DG X   6     -17.002   2.829  -0.647  1.00 30.00           O
ATOM    107  C5'  DG X   6     -17.284   2.994  -2.042  1.00 30.00           C
ATOM    108  C4'  DG X   6     -18.787   2.987  -2.306  1.00 30.00           C
ATOM    109  O4'  DG X   6     -19.502   2.825  -1.052  1.00 30.00           O
ATOM    110  C3'  DG X   6     -19.337   4.270  -2.919  1.00 30.00           C
ATOM    111  O3'  DG X   6     -20.489   3.998  -3.714  1.00 30.00           O
ATOM    112  C2'  DG X   6     -19.704   5.076  -1.690  1.00 30.00           C
ATOM    113  C1'  DG X   6     -20.237   4.002  -0.758  1.00 30.00           C
ATOM    114  N9   DG X   6     -20.026   4.326   0.643  1.00 30.00           N
ATOM    115  C8   DG X   6     -18.900   4.058   1.374  1.00 30.00           C
ATOM    116  N7   DG X   6     -18.972   4.464   2.602  1.00 30.00           N
ATOM    117  C5   DG X   6     -20.227   5.042   2.703  1.00 30.00           C
ATOM    118  C6   DG X   6     -20.854   5.652   3.812  1.00 30.00           C
ATOM    119  O6   DG X   6     -20.404   5.795   4.956  1.00 30.00           O
ATOM    120  N1   DG X   6     -22.130   6.120   3.494  1.00 30.00           N
ATOM    121  C2   DG X   6     -22.721   5.994   2.251  1.00 30.00           C
ATOM    122  N2   DG X   6     -23.953   6.491   2.121  1.00 30.00           N
ATOM    123  N3   DG X   6     -22.140   5.425   1.205  1.00 30.00           N
ATOM    124  C4   DG X   6     -20.896   4.972   1.503  1.00 30.00           C
ATOM    125  P    DA X   7     -21.090   5.134  -4.683  1.00 30.00           P
ATOM    126  OP1  DA X   7     -22.135   4.497  -5.514  1.00 30.00           O
ATOM    127  OP2  DA X   7     -19.954   5.813  -5.345  1.00 30.00           O
ATOM    128  O5'  DA X   7     -21.796   6.179  -3.688  1.00 30.00           O
ATOM    129  C5'  DA X   7     -23.114   5.920  -3.197  1.00 30.00           C
ATOM    130  C4'  DA X   7     -23.593   7.012  -2.242  1.00 30.00           C
ATOM    131  O4'  DA X   7     -22.746   7.060  -1.062  1.00 30.00           O
ATOM    132  C3'  DA X   7     -23.594   8.437  -2.795  1.00 30.00           C
ATOM    133  O3'  DA X   7     -24.673   9.164  -2.201  1.00 30.00           O
ATOM    134  C2'  DA X   7     -22.251   8.963  -2.291  1.00 30.00           C
ATOM    135  C1'  DA X   7     -22.273   8.380  -0.892  1.00 30.00           C
ATOM    136  N9   DA X   7     -20.981   8.320  -0.219  1.00 30.00           N
ATOM    137  C8   DA X   7     -19.767   8.039  -0.769  1.00 30.00           C
ATOM    138  N7   DA X   7     -18.782   8.022   0.099  1.00 30.00           N
ATOM    139  C5   DA X   7     -19.397   8.323   1.299  1.00 30.00           C
ATOM    140  C6   DA X   7     -18.911   8.472   2.612  1.00 30.00           C
ATOM    141  N6   DA X   7     -17.636   8.325   2.966  1.00 30.00           N
ATOM    142  N1   DA X   7     -19.793   8.770   3.558  1.00 30.00           N
ATOM    143  C2   DA X   7     -21.076   8.919   3.236  1.00 30.00           C
ATOM    144  N3   DA X   7     -21.653   8.810   2.050  1.00 30.00           N
ATOM    145  C4   DA X   7     -20.752   8.504   1.116  1.00 30.00           C
ATOM    146  P    DG X   8     -26.131   9.188  -2.879  1.00 30.00           P
ATOM    147  OP1  DG X   8     -26.599   7.790  -3.027  1.00 30.00           O
ATOM    148  OP2  DG X   8     -26.051  10.074  -4.061  1.00 30.00           O
ATOM    149  O5'  DG X   8     -27.041   9.918  -1.784  1.00 30.00           O
ATOM    150  C5'  DG X   8     -27.592   9.169  -0.717  1.00 30.00           C
ATOM    151  C4'  DG X   8     -27.340   9.849   0.620  1.00 30.00           C
ATOM    152  O4'  DG X   8     -25.917   9.834   0.931  1.00 30.00           O
ATOM    153  C3'  DG X   8     -27.778  11.325   0.708  1.00 30.00           C
ATOM    154  O3'  DG X   8     -28.595  11.521   1.869  1.00 30.00           O
ATOM    155  C2'  DG X   8     -26.448  12.076   0.826  1.00 30.00           C
ATOM    156  C1'  DG X   8     -25.614  11.049   1.562  1.00 30.00           C
ATOM    157  N9   DG X   8     -24.168  11.305   1.539  1.00 30.00           N
ATOM    158  C8   DG X   8     -23.311  11.270   0.464  1.00 30.00           C
ATOM    159  N7   DG X   8     -22.073  11.564   0.779  1.00 30.00           N
ATOM    160  C5   DG X   8     -22.122  11.812   2.146  1.00 30.00           C
ATOM    161  C6   DG X   8     -21.095  12.173   3.054  1.00 30.00           C
ATOM    162  O6   DG X   8     -19.893  12.353   2.819  1.00 30.00           O
ATOM    163  N1   DG X   8     -21.587  12.326   4.354  1.00 30.00           N
ATOM    164  C2   DG X   8     -22.906  12.135   4.715  1.00 30.00           C
ATOM    165  N2   DG X   8     -23.224  12.330   6.003  1.00 30.00           N
ATOM    166  N3   DG X   8     -23.860  11.803   3.873  1.00 30.00           N
ATOM    167  C4   DG X   8     -23.401  11.650   2.619  1.00 30.00           C
ATOM    168  P    DT X   9     -29.453  12.870   2.063  1.00 30.00           P
ATOM    169  OP1  DT X   9     -30.263  12.712   3.292  1.00 30.00           O
ATOM    170  OP2  DT X   9     -30.107  13.189   0.774  1.00 30.00           O
ATOM    171  O5'  DT X   9     -28.352  13.995   2.339  1.00 30.00           O
ATOM    172  C5'  DT X   9     -28.636  15.075   3.221  1.00 30.00           C
ATOM    173  C4'  DT X   9     -27.778  14.972   4.468  1.00 30.00           C
ATOM    174  O4'  DT X   9     -26.621  14.160   4.170  1.00 30.00           O
ATOM    175  C3'  DT X   9     -27.212  16.288   4.975  1.00 30.00           C
ATOM    176  O3'  DT X   9     -28.112  16.899   5.889  1.00 30.00           O
ATOM    177  C2'  DT X   9     -25.938  15.854   5.686  1.00 30.00           C
ATOM    178  C1'  DT X   9     -25.518  14.599   4.938  1.00 30.00           C
ATOM    179  N1   DT X   9     -24.342  14.789   4.043  1.00 30.00           N
ATOM    180  C2   DT X   9     -23.128  15.119   4.594  1.00 30.00           C
ATOM    181  O2   DT X   9     -22.951  15.286   5.789  1.00 30.00           O
ATOM    182  N3   DT X   9     -22.118  15.240   3.696  1.00 30.00           N
ATOM    183  C4   DT X   9     -22.174  15.085   2.332  1.00 30.00           C
ATOM    184  O4   DT X   9     -21.182  15.217   1.621  1.00 30.00           O
ATOM    185  C5   DT X   9     -23.475  14.739   1.809  1.00 30.00           C
ATOM    186  C7   DT X   9     -23.672  14.538   0.336  1.00 30.00           C
ATOM    187  C6   DT X   9     -24.486  14.612   2.682  1.00 30.00           C
ATOM    188  P    DA X  10     -27.979  18.466   6.227  1.00 30.00           P
ATOM    189  OP1  DA X  10     -29.022  18.792   7.222  1.00 30.00           O
ATOM    190  OP2  DA X  10     -27.904  19.205   4.949  1.00 30.00           O
ATOM    191  O5'  DA X  10     -26.558  18.606   6.940  1.00 30.00           O
ATOM    192  C5'  DA X  10     -26.339  18.016   8.207  1.00 30.00           C
ATOM    193  C4'  DA X  10     -24.867  18.045   8.546  1.00 30.00           C
ATOM    194  O4'  DA X  10     -24.094  17.586   7.400  1.00 30.00           O
ATOM    195  C3'  DA X  10     -24.330  19.435   8.879  1.00 30.00           C
ATOM    196  O3'  DA X  10     -23.425  19.350   9.970  1.00 30.00           O
ATOM    197  C2'  DA X  10     -23.625  19.848   7.590  1.00 30.00           C
ATOM    198  C1'  DA X  10     -23.069  18.514   7.144  1.00 30.00           C
ATOM    199  N9   DA X  10     -22.696  18.462   5.734  1.00 30.00           N
ATOM    200  C8   DA X  10     -23.502  18.207   4.659  1.00 30.00           C
ATOM    201  N7   DA X  10     -22.865  18.222   3.507  1.00 30.00           N
ATOM    202  C5   DA X  10     -21.556  18.517   3.856  1.00 30.00           C
ATOM    203  C6   DA X  10     -20.370  18.684   3.100  1.00 30.00           C
ATOM    204  N6   DA X  10     -20.307  18.581   1.756  1.00 30.00           N
ATOM    205  N1   DA X  10     -19.243  18.974   3.781  1.00 30.00           N
ATOM    206  C2   DA X  10     -19.299  19.093   5.112  1.00 30.00           C
ATOM    207  N3   DA X  10     -20.339  18.955   5.920  1.00 30.00           N
ATOM    208  C4   DA X  10     -21.444  18.665   5.226  1.00 30.00           C
ATOM    209  P    DC X  11     -22.654  20.665  10.476  1.00 30.00           P
ATOM    210  OP1  DC X  11     -22.184  20.417  11.858  1.00 30.00           O
ATOM    211  OP2  DC X  11     -23.515  21.834  10.194  1.00 30.00           O
ATOM    212  O5'  DC X  11     -21.390  20.753   9.512  1.00 30.00           O
ATOM    213  C5'  DC X  11     -20.143  20.261   9.943  1.00 30.00           C
ATOM    214  C4'  DC X  11     -19.031  21.189   9.499  1.00 30.00           C
ATOM    215  O4'  DC X  11     -18.892  21.121   8.058  1.00 30.00           O
ATOM    216  C3'  DC X  11     -19.251  22.661   9.821  1.00 30.00           C
ATOM    217  O3'  DC X  11     -18.008  23.272  10.064  1.00 30.00           O
ATOM    218  C2'  DC X  11     -19.884  23.195   8.540  1.00 30.00           C
ATOM    219  C1'  DC X  11     -19.138  22.393   7.490  1.00 30.00           C
ATOM    220  N1   DC X  11     -19.907  22.199   6.246  1.00 30.00           N
ATOM    221  C2   DC X  11     -19.240  22.236   5.028  1.00 30.00           C
ATOM    222  O2   DC X  11     -18.023  22.420   5.029  1.00 30.00           O
ATOM    223  N3   DC X  11     -19.945  22.057   3.885  1.00 30.00           N
ATOM    224  C4   DC X  11     -21.268  21.855   3.945  1.00 30.00           C
ATOM    225  N4   DC X  11     -21.927  21.686   2.796  1.00 30.00           N
ATOM    226  C5   DC X  11     -21.971  21.825   5.187  1.00 30.00           C
ATOM    227  C6   DC X  11     -21.256  22.000   6.303  1.00 30.00           C
ATOM    228  P    DG X  12     -17.936  24.675  10.835  1.00 30.00           P
ATOM    229  OP1  DG X  12     -17.261  24.429  12.125  1.00 30.00           O
ATOM    230  OP2  DG X  12     -19.279  25.294  10.802  1.00 30.00           O
ATOM    231  O5'  DG X  12     -16.959  25.539   9.927  1.00 30.00           O
ATOM    232  C5'  DG X  12     -15.771  24.949   9.420  1.00 30.00           C
ATOM    233  C4'  DG X  12     -15.171  25.827   8.349  1.00 30.00           C
ATOM    234  O4'  DG X  12     -15.672  25.412   7.049  1.00 30.00           O
ATOM    235  C3'  DG X  12     -15.529  27.307   8.476  1.00 30.00           C
ATOM    236  O3'  DG X  12     -14.457  28.117   7.995  1.00 30.00           O
ATOM    237  C2'  DG X  12     -16.751  27.412   7.580  1.00 30.00           C
ATOM    238  C1'  DG X  12     -16.335  26.497   6.442  1.00 30.00           C
ATOM    239  N9   DG X  12     -17.460  26.000   5.662  1.00 30.00           N
ATOM    240  C8   DG X  12     -18.685  25.594   6.145  1.00 30.00           C
ATOM    241  N7   DG X  12     -19.507  25.210   5.211  1.00 30.00           N
ATOM    242  C5   DG X  12     -18.782  25.368   4.029  1.00 30.00           C
ATOM    243  C6   DG X  12     -19.159  25.107   2.684  1.00 30.00           C
ATOM    244  O6   DG X  12     -20.241  24.661   2.265  1.00 30.00           O
ATOM    245  N1   DG X  12     -18.128  25.410   1.782  1.00 30.00           N
ATOM    246  C2   DG X  12     -16.886  25.901   2.151  1.00 30.00           C
ATOM    247  N2   DG X  12     -16.019  26.133   1.162  1.00 30.00           N
ATOM    248  N3   DG X  12     -16.521  26.144   3.405  1.00 30.00           N
ATOM    249  C4   DG X  12     -17.516  25.850   4.291  1.00 30.00           C
ATOM    250  P    DG X  13     -16.206  33.094   5.526  1.00 30.00           P
ATOM    251  OP1  DG X  13     -15.400  33.893   4.576  1.00 30.00           O
ATOM    252  OP2  DG X  13     -17.594  32.760   5.161  1.00 30.00           O
ATOM    253  O5'  DG X  13     -15.466  31.703   5.852  1.00 30.00           O
ATOM    254  C5'  DG X  13     -16.223  30.521   6.196  1.00 30.00           C
ATOM    255  C4'  DG X  13     -16.386  29.628   5.001  1.00 30.00           C
ATOM    256  O4'  DG X  13     -17.755  29.191   4.901  1.00 30.00           O
ATOM    257  C3'  DG X  13     -16.062  30.300   3.680  1.00 30.00           C
ATOM    258  O3'  DG X  13     -14.854  29.789   3.180  1.00 30.00           O
ATOM    259  C2'  DG X  13     -17.255  29.974   2.774  1.00 30.00           C
ATOM    260  C1'  DG X  13     -17.997  28.904   3.559  1.00 30.00           C
ATOM    261  N9   DG X  13     -19.432  28.876   3.319  1.00 30.00           N
ATOM    262  C8   DG X  13     -20.434  28.811   4.257  1.00 30.00           C
ATOM    263  N7   DG X  13     -21.626  28.799   3.732  1.00 30.00           N
ATOM    264  C5   DG X  13     -21.395  28.857   2.360  1.00 30.00           C
ATOM    265  C6   DG X  13     -22.311  28.873   1.282  1.00 30.00           C
ATOM    266  O6   DG X  13     -23.541  28.825   1.350  1.00 30.00           O
ATOM    267  N1   DG X  13     -21.662  28.947   0.029  1.00 30.00           N
ATOM    268  C2   DG X  13     -20.285  28.975  -0.111  1.00 30.00           C
ATOM    269  N2   DG X  13     -19.804  29.036  -1.346  1.00 30.00           N
ATOM    270  N3   DG X  13     -19.434  28.958   0.897  1.00 30.00           N
ATOM    271  C4   DG X  13     -20.053  28.901   2.095  1.00 30.00           C
ATOM    272  P    DG X  14     -13.681  30.798   2.758  1.00 30.00           P
ATOM    273  OP1  DG X  14     -12.397  30.073   2.863  1.00 30.00           O
ATOM    274  OP2  DG X  14     -13.858  32.067   3.496  1.00 30.00           O
ATOM    275  O5'  DG X  14     -13.987  31.071   1.224  1.00 30.00           O
ATOM    276  C5'  DG X  14     -14.487  30.022   0.406  1.00 30.00           C
ATOM    277  C4'  DG X  14     -15.244  30.611  -0.756  1.00 30.00           C
ATOM    278  O4'  DG X  14     -16.673  30.563  -0.486  1.00 30.00           O
ATOM    279  C3'  DG X  14     -14.937  32.095  -1.004  1.00 30.00           C
ATOM    280  O3'  DG X  14     -14.983  32.366  -2.389  1.00 30.00           O
ATOM    281  C2'  DG X  14     -16.095  32.773  -0.297  1.00 30.00           C
ATOM    282  C1'  DG X  14     -17.175  31.840  -0.770  1.00 30.00           C
ATOM    283  N9   DG X  14     -18.481  32.041  -0.171  1.00 30.00           N
ATOM    284  C8   DG X  14     -18.785  32.361   1.127  1.00 30.00           C
ATOM    285  N7   DG X  14     -20.066  32.500   1.333  1.00 30.00           N
ATOM    286  C5   DG X  14     -20.632  32.270   0.085  1.00 30.00           C
ATOM    287  C6   DG X  14     -21.982  32.284  -0.322  1.00 30.00           C
ATOM    288  O6   DG X  14     -22.979  32.500   0.378  1.00 30.00           O
ATOM    289  N1   DG X  14     -22.116  32.012  -1.695  1.00 30.00           N
ATOM    290  C2   DG X  14     -21.054  31.726  -2.533  1.00 30.00           C
ATOM    291  N2   DG X  14     -21.330  31.471  -3.817  1.00 30.00           N
ATOM    292  N3   DG X  14     -19.799  31.715  -2.145  1.00 30.00           N
ATOM    293  C4   DG X  14     -19.665  31.993  -0.839  1.00 30.00           C
ATOM    294  P    DC X  15     -14.354  33.731  -2.949  1.00 30.00           P
ATOM    295  OP1  DC X  15     -13.670  33.436  -4.229  1.00 30.00           O
ATOM    296  OP2  DC X  15     -13.603  34.337  -1.832  1.00 30.00           O
ATOM    297  O5'  DC X  15     -15.615  34.667  -3.217  1.00 30.00           O
ATOM    298  C5'  DC X  15     -16.025  34.907  -4.538  1.00 30.00           C
ATOM    299  C4'  DC X  15     -16.843  33.750  -5.063  1.00 30.00           C
ATOM    300  O4'  DC X  15     -17.752  33.314  -4.026  1.00 30.00           O
ATOM    301  C3'  DC X  15     -17.757  34.132  -6.200  1.00 30.00           C
ATOM    302  O3'  DC X  15     -18.273  32.978  -6.799  1.00 30.00           O
ATOM    303  C2'  DC X  15     -18.840  34.855  -5.434  1.00 30.00           C
ATOM    304  C1'  DC X  15     -19.024  33.879  -4.281  1.00 30.00           C
ATOM    305  N1   DC X  15     -19.544  34.482  -3.029  1.00 30.00           N
ATOM    306  C2   DC X  15     -20.897  34.767  -2.942  1.00 30.00           C
ATOM    307  O2   DC X  15     -21.607  34.536  -3.918  1.00 30.00           O
ATOM    308  N3   DC X  15     -21.394  35.284  -1.796  1.00 30.00           N
ATOM    309  C4   DC X  15     -20.580  35.527  -0.771  1.00 30.00           C
ATOM    310  N4   DC X  15     -21.113  36.054   0.335  1.00 30.00           N
ATOM    311  C5   DC X  15     -19.181  35.240  -0.834  1.00 30.00           C
ATOM    312  C6   DC X  15     -18.708  34.722  -1.976  1.00 30.00           C
ATOM    313  P    DT X  16     -18.914  33.076  -8.263  1.00 30.00           P
ATOM    314  OP1  DT X  16     -19.130  31.701  -8.759  1.00 30.00           O
ATOM    315  OP2  DT X  16     -18.062  34.030  -9.009  1.00 30.00           O
ATOM    316  O5'  DT X  16     -20.353  33.740  -8.033  1.00 30.00           O
ATOM    317  C5'  DT X  16     -21.267  33.776  -9.119  1.00 30.00           C
ATOM    318  C4'  DT X  16     -22.576  34.443  -8.741  1.00 30.00           C
ATOM    319  O4'  DT X  16     -22.599  34.739  -7.336  1.00 30.00           O
ATOM    320  C3'  DT X  16     -22.826  35.768  -9.445  1.00 30.00           C
ATOM    321  O3'  DT X  16     -23.731  35.572 -10.512  1.00 30.00           O
ATOM    322  C2'  DT X  16     -23.413  36.688  -8.361  1.00 30.00           C
ATOM    323  C1'  DT X  16     -23.483  35.806  -7.118  1.00 30.00           C
ATOM    324  N1   DT X  16     -23.047  36.499  -5.900  1.00 30.00           N
ATOM    325  C2   DT X  16     -23.945  36.715  -4.891  1.00 30.00           C
ATOM    326  O2   DT X  16     -25.112  36.370  -4.948  1.00 30.00           O
ATOM    327  N3   DT X  16     -23.428  37.363  -3.807  1.00 30.00           N
ATOM    328  C4   DT X  16     -22.137  37.812  -3.636  1.00 30.00           C
ATOM    329  O4   DT X  16     -21.770  38.378  -2.617  1.00 30.00           O
ATOM    330  C5   DT X  16     -21.245  37.554  -4.728  1.00 30.00           C
ATOM    331  C7   DT X  16     -19.817  38.003  -4.647  1.00 30.00           C
ATOM    332  C6   DT X  16     -21.735  36.918  -5.800  1.00 30.00           C
ATOM    333  P    DG X  17     -23.977  36.742 -11.580  1.00 30.00           P
ATOM    334  OP1  DG X  17     -24.567  36.126 -12.789  1.00 30.00           O
ATOM    335  OP2  DG X  17     -22.716  37.507 -11.691  1.00 30.00           O
ATOM    336  O5'  DG X  17     -25.071  37.671 -10.874  1.00 30.00           O
ATOM    337  C5'  DG X  17     -26.282  37.097 -10.397  1.00 30.00           C
ATOM    338  C4'  DG X  17     -26.954  38.010  -9.389  1.00 30.00           C
ATOM    339  O4'  DG X  17     -26.206  38.019  -8.165  1.00 30.00           O
ATOM    340  C3'  DG X  17     -27.023  39.474  -9.794  1.00 30.00           C
ATOM    341  O3'  DG X  17     -28.224  39.731 -10.496  1.00 30.00           O
ATOM    342  C2'  DG X  17     -26.993  40.226  -8.455  1.00 30.00           C
ATOM    343  C1'  DG X  17     -26.607  39.150  -7.437  1.00 30.00           C
ATOM    344  N9   DG X  17     -25.537  39.563  -6.539  1.00 30.00           N
ATOM    345  C8   DG X  17     -24.187  39.599  -6.796  1.00 30.00           C
ATOM    346  N7   DG X  17     -23.482  40.032  -5.786  1.00 30.00           N
ATOM    347  C5   DG X  17     -24.429  40.307  -4.806  1.00 30.00           C
ATOM    348  C6   DG X  17     -24.268  40.805  -3.491  1.00 30.00           C
ATOM    349  O6   DG X  17     -23.216  41.110  -2.909  1.00 30.00           O
ATOM    350  N1   DG X  17     -25.497  40.939  -2.838  1.00 30.00           N
ATOM    351  C2   DG X  17     -26.722  40.621  -3.394  1.00 30.00           C
ATOM    352  N2   DG X  17     -27.808  40.806  -2.626  1.00 30.00           N
ATOM    353  N3   DG X  17     -26.874  40.157  -4.619  1.00 30.00           N
ATOM    354  C4   DG X  17     -25.694  40.026  -5.262  1.00 30.00           C
ATOM    355  P    DC X  18     -28.399  41.116 -11.290  1.00 30.00           P
ATOM    356  OP1  DC X  18     -29.475  40.937 -12.291  1.00 30.00           O
ATOM    357  OP2  DC X  18     -27.045  41.534 -11.717  1.00 30.00           O
ATOM    358  O5'  DC X  18     -28.889  42.148 -10.167  1.00 30.00           O
ATOM    359  C5'  DC X  18     -30.190  42.028  -9.598  1.00 30.00           C
ATOM    360  C4'  DC X  18     -30.357  42.996  -8.440  1.00 30.00           C
ATOM    361  O4'  DC X  18     -29.522  42.567  -7.341  1.00 30.00           O
ATOM    362  C3'  DC X  18     -29.930  44.423  -8.738  1.00 30.00           C
ATOM    363  O3'  DC X  18     -31.031  45.159  -9.256  1.00 30.00           O
ATOM    364  C2'  DC X  18     -29.505  44.947  -7.367  1.00 30.00           C
ATOM    365  C1'  DC X  18     -29.004  43.687  -6.651  1.00 30.00           C
ATOM    366  N1   DC X  18     -27.504  43.568  -6.588  1.00 30.00           N
ATOM    367  C2   DC X  18     -26.875  43.416  -5.345  1.00 30.00           C
ATOM    368  O2   DC X  18     -27.567  43.383  -4.323  1.00 30.00           O
ATOM    369  N3   DC X  18     -25.521  43.319  -5.296  1.00 30.00           N
ATOM    370  C4   DC X  18     -24.813  43.348  -6.434  1.00 30.00           C
ATOM    371  N4   DC X  18     -23.484  43.238  -6.349  1.00 30.00           N
ATOM    372  C5   DC X  18     -25.437  43.503  -7.708  1.00 30.00           C
ATOM    373  C6   DC X  18     -26.769  43.608  -7.737  1.00 30.00           C
TER
ATOM    374  O5'  DT Y   5     -29.913 -51.862  23.113  1.00 30.00           O
ATOM    375  C5'  DT Y   5     -30.530 -50.710  22.551  1.00 30.00           C
ATOM    376  C4'  DT Y   5     -29.803 -49.443  22.968  1.00 30.00           C
ATOM    377  O4'  DT Y   5     -28.370 -49.645  22.882  1.00 30.00           O
ATOM    378  C3'  DT Y   5     -30.110 -48.213  22.114  1.00 30.00           C
ATOM    379  O3'  DT Y   5     -30.260 -47.085  22.945  1.00 30.00           O
ATOM    380  C2'  DT Y   5     -28.873 -48.085  21.232  1.00 30.00           C
ATOM    381  C1'  DT Y   5     -27.790 -48.572  22.178  1.00 30.00           C
ATOM    382  N1   DT Y   5     -26.569 -49.068  21.481  1.00 30.00           N
ATOM    383  C2   DT Y   5     -25.717 -49.924  22.135  1.00 30.00           C
ATOM    384  O2   DT Y   5     -25.895 -50.302  23.272  1.00 30.00           O
ATOM    385  N3   DT Y   5     -24.633 -50.322  21.404  1.00 30.00           N
ATOM    386  C4   DT Y   5     -24.317 -49.957  20.112  1.00 30.00           C
ATOM    387  O4   DT Y   5     -23.314 -50.370  19.539  1.00 30.00           O
ATOM    388  C5   DT Y   5     -25.252 -49.056  19.482  1.00 30.00           C
ATOM    389  C7   DT Y   5     -25.019 -48.589  18.077  1.00 30.00           C
ATOM    390  C6   DT Y   5     -26.320 -48.660  20.189  1.00 30.00           C
ATOM    391  P    DC Y   6     -31.679 -46.769  23.625  1.00 30.00           P
ATOM    392  OP1  DC Y   6     -32.607 -47.877  23.306  1.00 30.00           O
ATOM    393  OP2  DC Y   6     -32.034 -45.378  23.264  1.00 30.00           O
ATOM    394  O5'  DC Y   6     -31.370 -46.798  25.191  1.00 30.00           O
ATOM    395  C5'  DC Y   6     -30.887 -45.636  25.827  1.00 30.00           C
ATOM    396  C4'  DC Y   6     -29.422 -45.779  26.179  1.00 30.00           C
ATOM    397  O4'  DC Y   6     -28.725 -46.486  25.128  1.00 30.00           O
ATOM    398  C3'  DC Y   6     -28.685 -44.470  26.316  1.00 30.00           C
ATOM    399  O3'  DC Y   6     -28.894 -43.952  27.620  1.00 30.00           O
ATOM    400  C2'  DC Y   6     -27.237 -44.898  26.083  1.00 30.00           C
ATOM    401  C1'  DC Y   6     -27.395 -46.012  25.038  1.00 30.00           C
ATOM    402  N1   DC Y   6     -27.139 -45.573  23.630  1.00 30.00           N
ATOM    403  C2   DC Y   6     -25.916 -45.870  23.029  1.00 30.00           C
ATOM    404  O2   DC Y   6     -25.063 -46.492  23.673  1.00 30.00           O
ATOM    405  N3   DC Y   6     -25.702 -45.478  21.752  1.00 30.00           N
ATOM    406  C4   DC Y   6     -26.634 -44.812  21.088  1.00 30.00           C
ATOM    407  N4   DC Y   6     -26.355 -44.444  19.833  1.00 30.00           N
ATOM    408  C5   DC Y   6     -27.894 -44.497  21.677  1.00 30.00           C
ATOM    409  C6   DC Y   6     -28.105 -44.901  22.936  1.00 30.00           C
ATOM    410  P    DT Y   7     -28.533 -42.425  27.954  1.00 30.00           P
ATOM    411  OP1  DT Y   7     -29.347 -41.996  29.115  1.00 30.00           O
ATOM    412  OP2  DT Y   7     -28.584 -41.659  26.689  1.00 30.00           O
ATOM    413  O5'  DT Y   7     -27.012 -42.511  28.411  1.00 30.00           O
ATOM    414  C5'  DT Y   7     -26.349 -41.371  28.891  1.00 30.00           C
ATOM    415  C4'  DT Y   7     -24.859 -41.609  28.869  1.00 30.00           C
ATOM    416  O4'  DT Y   7     -24.570 -42.685  27.949  1.00 30.00           O
ATOM    417  C3'  DT Y   7     -24.042 -40.423  28.400  1.00 30.00           C
ATOM    418  O3'  DT Y   7     -23.633 -39.684  29.522  1.00 30.00           O
ATOM    419  C2'  DT Y   7     -22.853 -41.068  27.693  1.00 30.00           C
ATOM    420  C1'  DT Y   7     -23.442 -42.372  27.162  1.00 30.00           C
ATOM    421  N1   DT Y   7     -23.865 -42.329  25.732  1.00 30.00           N
ATOM    422  C2   DT Y   7     -22.921 -42.505  24.756  1.00 30.00           C
ATOM    423  O2   DT Y   7     -21.743 -42.668  24.999  1.00 30.00           O
ATOM    424  N3   DT Y   7     -23.405 -42.478  23.475  1.00 30.00           N
ATOM    425  C4   DT Y   7     -24.718 -42.292  23.083  1.00 30.00           C
ATOM    426  O4   DT Y   7     -25.055 -42.279  21.902  1.00 30.00           O
ATOM    427  C5   DT Y   7     -25.663 -42.120  24.161  1.00 30.00           C
ATOM    428  C7   DT Y   7     -27.114 -41.906  23.864  1.00 30.00           C
ATOM    429  C6   DT Y   7     -25.197 -42.150  25.419  1.00 30.00           C
ATOM    430  P    DG Y   8     -23.593 -38.086  29.451  1.00 30.00           P
ATOM    431  OP1  DG Y   8     -23.347 -37.579  30.820  1.00 30.00           O
ATOM    432  OP2  DG Y   8     -24.795 -37.660  28.700  1.00 30.00           O
ATOM    433  O5'  DG Y   8     -22.303 -37.789  28.564  1.00 30.00           O
ATOM    434  C5'  DG Y   8     -21.034 -38.257  28.992  1.00 30.00           C
ATOM    435  C4'  DG Y   8     -20.019 -38.120  27.880  1.00 30.00           C
ATOM    436  O4'  DG Y   8     -20.495 -38.844  26.718  1.00 30.00           O
ATOM    437  C3'  DG Y   8     -19.786 -36.688  27.400  1.00 30.00           C
ATOM    438  O3'  DG Y   8     -18.437 -36.539  26.951  1.00 30.00           O
ATOM    439  C2'  DG Y   8     -20.776 -36.572  26.248  1.00 30.00           C
ATOM    440  C1'  DG Y   8     -20.639 -37.952  25.637  1.00 30.00           C
ATOM    441  N9   DG Y   8     -21.776 -38.362  24.834  1.00 30.00           N
ATOM    442  C8   DG Y   8     -23.045 -38.675  25.260  1.00 30.00           C
ATOM    443  N7   DG Y   8     -23.848 -39.014  24.288  1.00 30.00           N
ATOM    444  C5   DG Y   8     -23.055 -38.917  23.149  1.00 30.00           C
ATOM    445  C6   DG Y   8     -23.370 -39.157  21.783  1.00 30.00           C
ATOM    446  O6   DG Y   8     -24.443 -39.536  21.288  1.00 30.00           O
ATOM    447  N1   DG Y   8     -22.260 -38.946  20.959  1.00 30.00           N
ATOM    448  C2   DG Y   8     -21.029 -38.544  21.412  1.00 30.00           C
ATOM    449  N2   DG Y   8     -20.096 -38.371  20.489  1.00 30.00           N
ATOM    450  N3   DG Y   8     -20.731 -38.313  22.678  1.00 30.00           N
ATOM    451  C4   DG Y   8     -21.786 -38.518  23.484  1.00 30.00           C
ATOM    452  P    DA Y   9     -17.749 -35.085  26.899  1.00 30.00           P
ATOM    453  OP1  DA Y   9     -16.592 -35.057  27.832  1.00 30.00           O
ATOM    454  OP2  DA Y   9     -18.828 -34.091  27.076  1.00 30.00           O
ATOM    455  O5'  DA Y   9     -17.219 -34.975  25.392  1.00 30.00           O
ATOM    456  C5'  DA Y   9     -15.982 -35.582  25.028  1.00 30.00           C
ATOM    457  C4'  DA Y   9     -15.841 -35.668  23.514  1.00 30.00           C
ATOM    458  O4'  DA Y   9     -17.057 -36.237  22.944  1.00 30.00           O
ATOM    459  C3'  DA Y   9     -15.641 -34.331  22.802  1.00 30.00           C
ATOM    460  O3'  DA Y   9     -14.816 -34.505  21.655  1.00 30.00           O
ATOM    461  C2'  DA Y   9     -17.062 -33.961  22.404  1.00 30.00           C
ATOM    462  C1'  DA Y   9     -17.629 -35.320  22.036  1.00 30.00           C
ATOM    463  N9   DA Y   9     -19.075 -35.381  22.157  1.00 30.00           N
ATOM    464  C8   DA Y   9     -19.818 -35.263  23.296  1.00 30.00           C
ATOM    465  N7   DA Y   9     -21.108 -35.344  23.097  1.00 30.00           N
ATOM    466  C5   DA Y   9     -21.215 -35.512  21.731  1.00 30.00           C
ATOM    467  C6   DA Y   9     -22.319 -35.677  20.872  1.00 30.00           C
ATOM    468  N6   DA Y   9     -23.595 -35.676  21.272  1.00 30.00           N
ATOM    469  N1   DA Y   9     -22.065 -35.851  19.571  1.00 30.00           N
ATOM    470  C2   DA Y   9     -20.801 -35.824  19.140  1.00 30.00           C
ATOM    471  N3   DA Y   9     -19.684 -35.690  19.843  1.00 30.00           N
ATOM    472  C4   DA Y   9     -19.964 -35.538  21.143  1.00 30.00           C
ATOM    473  P    DT Y  10     -14.338 -33.230  20.800  1.00 30.00           P
ATOM    474  OP1  DT Y  10     -12.873 -33.327  20.634  1.00 30.00           O
ATOM    475  OP2  DT Y  10     -14.911 -32.004  21.391  1.00 30.00           O
ATOM    476  O5'  DT Y  10     -15.033 -33.445  19.381  1.00 30.00           O
ATOM    477  C5'  DT Y  10     -14.762 -34.621  18.637  1.00 30.00           C
ATOM    478  C4'  DT Y  10     -15.447 -34.580  17.286  1.00 30.00           C
ATOM    479  O4'  DT Y  10     -16.882 -34.553  17.463  1.00 30.00           O
ATOM    480  C3'  DT Y  10     -15.130 -33.356  16.424  1.00 30.00           C
ATOM    481  O3'  DT Y  10     -15.199 -33.728  15.073  1.00 30.00           O
ATOM    482  C2'  DT Y  10     -16.275 -32.433  16.762  1.00 30.00           C
ATOM    483  C1'  DT Y  10     -17.386 -33.448  16.751  1.00 30.00           C
ATOM    484  N1   DT Y  10     -18.570 -32.995  17.402  1.00 30.00           N
ATOM    485  C2   DT Y  10     -19.668 -32.755  16.642  1.00 30.00           C
ATOM    486  O2   DT Y  10     -19.692 -32.918  15.441  1.00 30.00           O
ATOM    487  N3   DT Y  10     -20.751 -32.323  17.331  1.00 30.00           N
ATOM    488  C4   DT Y  10     -20.862 -32.125  18.693  1.00 30.00           C
ATOM    489  O4   DT Y  10     -21.926 -31.750  19.231  1.00 30.00           O
ATOM    490  C5   DT Y  10     -19.658 -32.395  19.444  1.00 30.00           C
ATOM    491  C7   DT Y  10     -19.647 -32.203  20.927  1.00 30.00           C
ATOM    492  C6   DT Y  10     -18.574 -32.813  18.768  1.00 30.00           C
ATOM    493  P    DG Y  11     -13.989 -33.377  14.087  1.00 30.00           P
ATOM    494  OP1  DG Y  11     -13.929 -34.472  13.091  1.00 30.00           O
ATOM    495  OP2  DG Y  11     -12.791 -33.084  14.910  1.00 30.00           O
ATOM    496  O5'  DG Y  11     -14.453 -32.009  13.410  1.00 30.00           O
ATOM    497  C5'  DG Y  11     -14.432 -31.883  12.015  1.00 30.00           C
ATOM    498  C4'  DG Y  11     -15.605 -32.605  11.398  1.00 30.00           C
ATOM    499  O4'  DG Y  11     -16.668 -32.706  12.384  1.00 30.00           O
ATOM    500  C3'  DG Y  11     -16.218 -31.855  10.247  1.00 30.00           C
ATOM    501  O3'  DG Y  11     -16.987 -32.728   9.438  1.00 30.00           O
ATOM    502  C2'  DG Y  11     -17.090 -30.866  10.995  1.00 30.00           C
ATOM    503  C1'  DG Y  11     -17.678 -31.776  12.061  1.00 30.00           C
ATOM    504  N9   DG Y  11     -18.090 -31.056  13.252  1.00 30.00           N
ATOM    505  C8   DG Y  11     -17.300 -30.361  14.136  1.00 30.00           C
ATOM    506  N7   DG Y  11     -17.977 -29.789  15.095  1.00 30.00           N
ATOM    507  C5   DG Y  11     -19.294 -30.112  14.811  1.00 30.00           C
ATOM    508  C6   DG Y  11     -20.484 -29.780  15.497  1.00 30.00           C
ATOM    509  O6   DG Y  11     -20.612 -29.103  16.532  1.00 30.00           O
ATOM    510  N1   DG Y  11     -21.605 -30.322  14.862  1.00 30.00           N
ATOM    511  C2   DG Y  11     -21.561 -31.100  13.716  1.00 30.00           C
ATOM    512  N2   DG Y  11     -22.723 -31.534  13.233  1.00 30.00           N
ATOM    513  N3   DG Y  11     -20.455 -31.413  13.078  1.00 30.00           N
ATOM    514  C4   DG Y  11     -19.369 -30.883  13.671  1.00 30.00           C
ATOM    515  P    DA Y  12     -17.511 -32.196   8.020  1.00 30.00           P
ATOM    516  OP1  DA Y  12     -17.983 -33.314   7.174  1.00 30.00           O
ATOM    517  OP2  DA Y  12     -16.398 -31.364   7.524  1.00 30.00           O
ATOM    518  O5'  DA Y  12     -18.740 -31.244   8.412  1.00 30.00           O
ATOM    519  C5'  DA Y  12     -19.813 -31.754   9.195  1.00 30.00           C
ATOM    520  C4'  DA Y  12     -21.140 -31.490   8.528  1.00 30.00           C
ATOM    521  O4'  DA Y  12     -22.109 -31.130   9.534  1.00 30.00           O
ATOM    522  C3'  DA Y  12     -21.119 -30.353   7.528  1.00 30.00           C
ATOM    523  O3'  DA Y  12     -21.912 -30.664   6.382  1.00 30.00           O
ATOM    524  C2'  DA Y  12     -21.650 -29.145   8.302  1.00 30.00           C
ATOM    525  C1'  DA Y  12     -22.386 -29.743   9.496  1.00 30.00           C
ATOM    526  N9   DA Y  12     -22.000 -29.159  10.783  1.00 30.00           N
ATOM    527  C8   DA Y  12     -20.759 -29.160  11.348  1.00 30.00           C
ATOM    528  N7   DA Y  12     -20.711 -28.574  12.522  1.00 30.00           N
ATOM    529  C5   DA Y  12     -22.008 -28.160  12.743  1.00 30.00           C
ATOM    530  C6   DA Y  12     -22.612 -27.479  13.814  1.00 30.00           C
ATOM    531  N6   DA Y  12     -21.948 -27.095  14.902  1.00 30.00           N
ATOM    532  N1   DA Y  12     -23.917 -27.181  13.707  1.00 30.00           N
ATOM    533  C2   DA Y  12     -24.585 -27.599  12.627  1.00 30.00           C
ATOM    534  N3   DA Y  12     -24.130 -28.259  11.562  1.00 30.00           N
ATOM    535  C4   DA Y  12     -22.821 -28.513  11.685  1.00 30.00           C
ATOM    536  P    DA Y  13     -17.968 -25.215   7.927  1.00 30.00           P
ATOM    537  OP1  DA Y  13     -17.098 -24.747   6.824  1.00 30.00           O
ATOM    538  OP2  DA Y  13     -17.598 -24.992   9.344  1.00 30.00           O
ATOM    539  O5'  DA Y  13     -19.406 -24.555   7.708  1.00 30.00           O
ATOM    540  C5'  DA Y  13     -20.391 -25.252   6.993  1.00 30.00           C
ATOM    541  C4'  DA Y  13     -21.436 -25.796   7.937  1.00 30.00           C
ATOM    542  O4'  DA Y  13     -20.808 -26.201   9.177  1.00 30.00           O
ATOM    543  C3'  DA Y  13     -22.534 -24.806   8.321  1.00 30.00           C
ATOM    544  O3'  DA Y  13     -23.779 -25.402   8.143  1.00 30.00           O
ATOM    545  C2'  DA Y  13     -22.274 -24.524   9.789  1.00 30.00           C
ATOM    546  C1'  DA Y  13     -21.639 -25.818  10.236  1.00 30.00           C
ATOM    547  N9   DA Y  13     -20.833 -25.649  11.423  1.00 30.00           N
ATOM    548  C8   DA Y  13     -19.525 -25.997  11.594  1.00 30.00           C
ATOM    549  N7   DA Y  13     -19.058 -25.701  12.781  1.00 30.00           N
ATOM    550  C5   DA Y  13     -20.131 -25.106  13.419  1.00 30.00           C
ATOM    551  C6   DA Y  13     -20.285 -24.565  14.703  1.00 30.00           C
ATOM    552  N6   DA Y  13     -19.307 -24.541  15.608  1.00 30.00           N
ATOM    553  N1   DA Y  13     -21.483 -24.044  15.021  1.00 30.00           N
ATOM    554  C2   DA Y  13     -22.464 -24.082  14.119  1.00 30.00           C
ATOM    555  N3   DA Y  13     -22.440 -24.566  12.885  1.00 30.00           N
ATOM    556  C4   DA Y  13     -21.226 -25.055  12.590  1.00 30.00           C
ATOM    557  P    DC Y  14     -24.681 -24.939   6.908  1.00 30.00           P
ATOM    558  OP1  DC Y  14     -25.718 -25.968   6.676  1.00 30.00           O
ATOM    559  OP2  DC Y  14     -23.731 -24.578   5.831  1.00 30.00           O
ATOM    560  O5'  DC Y  14     -25.377 -23.607   7.441  1.00 30.00           O
ATOM    561  C5'  DC Y  14     -26.129 -23.645   8.644  1.00 30.00           C
ATOM    562  C4'  DC Y  14     -26.006 -22.339   9.396  1.00 30.00           C
ATOM    563  O4'  DC Y  14     -24.818 -22.361  10.236  1.00 30.00           O
ATOM    564  C3'  DC Y  14     -25.858 -21.092   8.516  1.00 30.00           C
ATOM    565  O3'  DC Y  14     -26.502 -20.029   9.149  1.00 30.00           O
ATOM    566  C2'  DC Y  14     -24.356 -20.872   8.534  1.00 30.00           C
ATOM    567  C1'  DC Y  14     -24.106 -21.174   9.993  1.00 30.00           C
ATOM    568  N1   DC Y  14     -22.689 -21.345  10.351  1.00 30.00           N
ATOM    569  C2   DC Y  14     -22.340 -21.594  11.682  1.00 30.00           C
ATOM    570  O2   DC Y  14     -23.234 -21.701  12.534  1.00 30.00           O
ATOM    571  N3   DC Y  14     -21.031 -21.718  11.999  1.00 30.00           N
ATOM    572  C4   DC Y  14     -20.098 -21.612  11.044  1.00 30.00           C
ATOM    573  N4   DC Y  14     -18.814 -21.759  11.397  1.00 30.00           N
ATOM    574  C5   DC Y  14     -20.440 -21.344   9.687  1.00 30.00           C
ATOM    575  C6   DC Y  14     -21.733 -21.210   9.391  1.00 30.00           C
ATOM    576  P    DG Y  15     -27.092 -18.797   8.312  1.00 30.00           P
ATOM    577  OP1  DG Y  15     -27.900 -19.356   7.205  1.00 30.00           O
ATOM    578  OP2  DG Y  15     -25.983 -17.865   8.004  1.00 30.00           O
ATOM    579  O5'  DG Y  15     -28.067 -18.118   9.377  1.00 30.00           O
ATOM    580  C5'  DG Y  15     -28.904 -18.957  10.175  1.00 30.00           C
ATOM    581  C4'  DG Y  15     -28.919 -18.511  11.627  1.00 30.00           C
ATOM    582  O4'  DG Y  15     -28.019 -19.336  12.424  1.00 30.00           O
ATOM    583  C3'  DG Y  15     -28.448 -17.092  11.874  1.00 30.00           C
ATOM    584  O3'  DG Y  15     -29.503 -16.170  11.637  1.00 30.00           O
ATOM    585  C2'  DG Y  15     -28.080 -17.181  13.347  1.00 30.00           C
ATOM    586  C1'  DG Y  15     -27.332 -18.508  13.358  1.00 30.00           C
ATOM    587  N9   DG Y  15     -25.949 -18.386  12.911  1.00 30.00           N
ATOM    588  C8   DG Y  15     -25.465 -18.739  11.681  1.00 30.00           C
ATOM    589  N7   DG Y  15     -24.195 -18.519  11.537  1.00 30.00           N
ATOM    590  C5   DG Y  15     -23.800 -17.985  12.747  1.00 30.00           C
ATOM    591  C6   DG Y  15     -22.524 -17.561  13.162  1.00 30.00           C
ATOM    592  O6   DG Y  15     -21.479 -17.579  12.512  1.00 30.00           O
ATOM    593  N1   DG Y  15     -22.534 -17.069  14.464  1.00 30.00           N
ATOM    594  C2   DG Y  15     -23.655 -17.005  15.264  1.00 30.00           C
ATOM    595  N2   DG Y  15     -23.476 -16.506  16.495  1.00 30.00           N
ATOM    596  N3   DG Y  15     -24.869 -17.409  14.884  1.00 30.00           N
ATOM    597  C4   DG Y  15     -24.864 -17.885  13.612  1.00 30.00           C
ATOM    598  P    DA Y  16     -29.206 -14.590  11.569  1.00 30.00           P
ATOM    599  OP1  DA Y  16     -30.416 -13.966  10.989  1.00 30.00           O
ATOM    600  OP2  DA Y  16     -27.889 -14.375  10.923  1.00 30.00           O
ATOM    601  O5'  DA Y  16     -29.098 -14.167  13.109  1.00 30.00           O
ATOM    602  C5'  DA Y  16     -28.530 -12.922  13.492  1.00 30.00           C
ATOM    603  C4'  DA Y  16     -28.268 -12.919  14.988  1.00 30.00           C
ATOM    604  O4'  DA Y  16     -27.616 -14.148  15.368  1.00 30.00           O
ATOM    605  C3'  DA Y  16     -27.391 -11.781  15.496  1.00 30.00           C
ATOM    606  O3'  DA Y  16     -28.111 -11.042  16.457  1.00 30.00           O
ATOM    607  C2'  DA Y  16     -26.170 -12.462  16.129  1.00 30.00           C
ATOM    608  C1'  DA Y  16     -26.269 -13.902  15.665  1.00 30.00           C
ATOM    609  N9   DA Y  16     -25.473 -14.224  14.488  1.00 30.00           N
ATOM    610  C8   DA Y  16     -25.916 -14.815  13.343  1.00 30.00           C
ATOM    611  N7   DA Y  16     -24.987 -15.017  12.451  1.00 30.00           N
ATOM    612  C5   DA Y  16     -23.847 -14.532  13.053  1.00 30.00           C
ATOM    613  C6   DA Y  16     -22.521 -14.458  12.615  1.00 30.00           C
ATOM    614  N6   DA Y  16     -22.125 -14.911  11.421  1.00 30.00           N
ATOM    615  N1   DA Y  16     -21.614 -13.918  13.457  1.00 30.00           N
ATOM    616  C2   DA Y  16     -22.027 -13.484  14.658  1.00 30.00           C
ATOM    617  N3   DA Y  16     -23.255 -13.493  15.175  1.00 30.00           N
ATOM    618  C4   DA Y  16     -24.125 -14.040  14.314  1.00 30.00           C
ATOM    619  P    DC Y  17     -27.805  -9.482  16.652  1.00 30.00           P
ATOM    620  OP1  DC Y  17     -28.655  -8.987  17.757  1.00 30.00           O
ATOM    621  OP2  DC Y  17     -27.880  -8.841  15.320  1.00 30.00           O
ATOM    622  O5'  DC Y  17     -26.280  -9.456  17.113  1.00 30.00           O
ATOM    623  C5'  DC Y  17     -25.925  -9.741  18.462  1.00 30.00           C
ATOM    624  C4'  DC Y  17     -24.433  -9.547  18.671  1.00 30.00           C
ATOM    625  O4'  DC Y  17     -23.708 -10.309  17.671  1.00 30.00           O
ATOM    626  C3'  DC Y  17     -23.947  -8.105  18.503  1.00 30.00           C
ATOM    627  O3'  DC Y  17     -22.738  -7.899  19.238  1.00 30.00           O
ATOM    628  C2'  DC Y  17     -23.664  -8.066  17.014  1.00 30.00           C
ATOM    629  C1'  DC Y  17     -22.985  -9.413  16.862  1.00 30.00           C
ATOM    630  N1   DC Y  17     -22.948  -9.923  15.494  1.00 30.00           N
ATOM    631  C2   DC Y  17     -21.719 -10.017  14.895  1.00 30.00           C
ATOM    632  O2   DC Y  17     -20.734  -9.655  15.558  1.00 30.00           O
ATOM    633  N3   DC Y  17     -21.635 -10.491  13.620  1.00 30.00           N
ATOM    634  C4   DC Y  17     -22.754 -10.857  12.975  1.00 30.00           C
ATOM    635  N4   DC Y  17     -22.630 -11.326  11.725  1.00 30.00           N
ATOM    636  C5   DC Y  17     -24.042 -10.767  13.591  1.00 30.00           C
ATOM    637  C6   DC Y  17     -24.091 -10.293  14.842  1.00 30.00           C
TER
END
"""


def run(prefix, target, pdb_strs, eps=1.e-3):
  """
  Exercise phenix.angle command.
  """
  cntr = 0
  for pdb_str in pdb_strs:
    of = open("%s.pdb"%prefix, "w")
    print(pdb_str, file=of)
    of.close()
    cmd1='phenix.angle %s.pdb "chain X" "chain Y" '%(prefix)
    cmd2='phenix.angle %s.pdb "chain Y" "chain X" '%(prefix)
    for cmd in [cmd1,cmd2]:
      print(cmd)
      r = float(easy_run.go(cmd).stdout_lines[2].split()[2])
      assert approx_equal(r, target, eps)
      cntr += 1
  assert cntr == len(pdb_strs)*2, cntr

if (__name__ == "__main__"):
  t0 = time.time()
  run(prefix="tst_angle_exercise_1", target=90., pdb_strs=[pdb_str_1, pdb_str_2, pdb_str_3])
  run(prefix="tst_angle_exercise_2", target=0.,  pdb_strs=[pdb_str_4, pdb_str_5, pdb_str_6, pdb_str_7])
  run(prefix="tst_angle_exercise_3", target=45., pdb_strs=[pdb_str_8, pdb_str_9])
  run(prefix="tst_angle_exercise_4", target=8.98, pdb_strs=[pdb_str_10], eps=0.1)
  print("Time: %6.4f"%(time.time()-t0))
  print("OK")
