{ -*- buffer-read-only: t -*-

  Copyright 2015-2021 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetFilled: Boolean;
    procedure SetFilled(const Value: Boolean);
    function GetHatchColor: TCastleColorRGB;
    procedure SetHatchColor(const Value: TCastleColorRGB);
    function GetHatched: Boolean;
    procedure SetHatched(const Value: Boolean);
    function GetHatchStyle: Integer;
    procedure SetHatchStyle(const Value: Integer);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdFilled: TSFBool;
    { X3D field "filled". } { }
    public property FdFilled: TSFBool read FFdFilled;
    { X3D field "filled". } { }
    property Filled: Boolean read GetFilled write SetFilled;

    strict private FFdHatchColor: TSFColor;
    { X3D field "hatchColor". } { }
    public property FdHatchColor: TSFColor read FFdHatchColor;
    { X3D field "hatchColor". } { }
    property HatchColor: TCastleColorRGB read GetHatchColor write SetHatchColor;

    strict private FFdHatched: TSFBool;
    { X3D field "hatched". } { }
    public property FdHatched: TSFBool read FFdHatched;
    { X3D field "hatched". } { }
    property Hatched: Boolean read GetHatched write SetHatched;

    strict private FFdHatchStyle: TSFInt32;
    { X3D field "hatchStyle". } { }
    public property FdHatchStyle: TSFInt32 read FFdHatchStyle;
    { X3D field "hatchStyle". } { }
    property HatchStyle: Integer read GetHatchStyle write SetHatchStyle;

{$endif read_interface}

{$ifdef read_implementation}

{ TFillPropertiesNode ----------------------------------------------- }

function TFillPropertiesNode.GetFilled: Boolean;
begin
  Result := FdFilled.Value;
end;

procedure TFillPropertiesNode.SetFilled(const Value: Boolean);
begin
  FdFilled.Send(Value);
end;

function TFillPropertiesNode.GetHatchColor: TCastleColorRGB;
begin
  Result := FdHatchColor.Value;
end;

procedure TFillPropertiesNode.SetHatchColor(const Value: TCastleColorRGB);
begin
  FdHatchColor.Send(Value);
end;

function TFillPropertiesNode.GetHatched: Boolean;
begin
  Result := FdHatched.Value;
end;

procedure TFillPropertiesNode.SetHatched(const Value: Boolean);
begin
  FdHatched.Send(Value);
end;

function TFillPropertiesNode.GetHatchStyle: Integer;
begin
  Result := FdHatchStyle.Value;
end;

procedure TFillPropertiesNode.SetHatchStyle(const Value: Integer);
begin
  FdHatchStyle.Send(Value);
end;

class function TFillPropertiesNode.ClassX3DType: String;
begin
  Result := 'FillProperties';
end;

procedure TFillPropertiesNode.CreateNode;
begin
  inherited;

  FFdFilled := TSFBool.Create(Self, True, 'filled', true);
   FdFilled.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdFilled);

  FFdHatchColor := TSFColor.Create(Self, True, 'hatchColor', Vector3(1, 1, 1));
   FdHatchColor.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdHatchColor);
  { X3D specification comment: [0,1] }

  FFdHatched := TSFBool.Create(Self, True, 'hatched', true);
   FdHatched.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdHatched);

  FFdHatchStyle := TSFInt32.Create(Self, True, 'hatchStyle', 1);
   FdHatchStyle.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdHatchStyle);
  { X3D specification comment: [0,Inf) }

  DefaultContainerField := 'fillProperties';
end;

{$endif read_implementation}
