{ -*- buffer-read-only: t -*-

  Copyright 2015-2018 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in nodes_specification/components/ ,
  - and regenerate include files by running
    nodes_specification/x3d-nodes-to-pascal/x3d-nodes-to-pascal.lpr .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetActiveLayer: Integer;
    procedure SetActiveLayer(const Value: Integer);
  public
    property ActiveLayer: Integer read GetActiveLayer write SetActiveLayer;
    procedure SetLayers(const Value: array of TAbstractLayerNode);
    procedure SetOrder(const Value: array of LongInt);
    procedure SetOrder(const Value: TLongIntList);

{$endif read_interface}

{$ifdef read_implementation}

{ TLayerSetNode ----------------------------------------------- }

function TLayerSetNode.GetActiveLayer: Integer;
begin
  Result := FdActiveLayer.Value;
end;

procedure TLayerSetNode.SetActiveLayer(const Value: Integer);
begin
  FdActiveLayer.Send(Value);
end;

procedure TLayerSetNode.SetLayers(const Value: array of TAbstractLayerNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(TAbstractLayerNode));
  FdLayers.Send(A);
end;

procedure TLayerSetNode.SetOrder(const Value: array of LongInt);
begin
  FdOrder.Send(Value);
end;

procedure TLayerSetNode.SetOrder(const Value: TLongIntList);
begin
  FdOrder.Send(Value);
end;

{$endif read_implementation}
