(* AFM data for standard 14 fonts *)

let afmnotice =
"This file constitutes a modification of Adobe's AFM data files. This file also\
constitutes a modification of Adobe's license file.\
\
This file and the 14 PostScript(R) AFM files it accompanies may be used,\
copied, and distributed for any purpose and without charge, with or without\
modification, provided that all copyright notices are retained; that the AFM\
files are not distributed without this file; that all modifications to this\
file or any of the AFM files are prominently noted in the modified file(s); and\
that this paragraph is not modified. Adobe Systems has no responsibility or\
obligation to support the use of the AFM files."

let courier_afm = "StartFontMetrics 4.1
Comment Copyright (c) 1989, 1990, 1991, 1992, 1993, 1997 Adobe Systems Incorporated.  All Rights Reserved.
Comment Creation Date: Thu May  1 17:27:09 1997
Comment UniqueID 43050
Comment VMusage 39754 50779
FontName Courier
FullName Courier
FamilyName Courier
Weight Medium
ItalicAngle 0
IsFixedPitch true
CharacterSet ExtendedRoman
FontBBox -23 -250 715 805 
UnderlinePosition -100
UnderlineThickness 50
Version 003.000
Notice Copyright (c) 1989, 1990, 1991, 1992, 1993, 1997 Adobe Systems Incorporated.  All Rights Reserved.
EncodingScheme AdobeStandardEncoding
CapHeight 562
XHeight 426
Ascender 629
Descender -157
StdHW 51
StdVW 51
StartCharMetrics 315
C 32 ; WX 600 ; N space ; B 0 0 0 0 ;
C 33 ; WX 600 ; N exclam ; B 236 -15 364 572 ;
C 34 ; WX 600 ; N quotedbl ; B 187 328 413 562 ;
C 35 ; WX 600 ; N numbersign ; B 93 -32 507 639 ;
C 36 ; WX 600 ; N dollar ; B 105 -126 496 662 ;
C 37 ; WX 600 ; N percent ; B 81 -15 518 622 ;
C 38 ; WX 600 ; N ampersand ; B 63 -15 538 543 ;
C 39 ; WX 600 ; N quoteright ; B 213 328 376 562 ;
C 40 ; WX 600 ; N parenleft ; B 269 -108 440 622 ;
C 41 ; WX 600 ; N parenright ; B 160 -108 331 622 ;
C 42 ; WX 600 ; N asterisk ; B 116 257 484 607 ;
C 43 ; WX 600 ; N plus ; B 80 44 520 470 ;
C 44 ; WX 600 ; N comma ; B 181 -112 344 122 ;
C 45 ; WX 600 ; N hyphen ; B 103 231 497 285 ;
C 46 ; WX 600 ; N period ; B 229 -15 371 109 ;
C 47 ; WX 600 ; N slash ; B 125 -80 475 629 ;
C 48 ; WX 600 ; N zero ; B 106 -15 494 622 ;
C 49 ; WX 600 ; N one ; B 96 0 505 622 ;
C 50 ; WX 600 ; N two ; B 70 0 471 622 ;
C 51 ; WX 600 ; N three ; B 75 -15 466 622 ;
C 52 ; WX 600 ; N four ; B 78 0 500 622 ;
C 53 ; WX 600 ; N five ; B 92 -15 497 607 ;
C 54 ; WX 600 ; N six ; B 111 -15 497 622 ;
C 55 ; WX 600 ; N seven ; B 82 0 483 607 ;
C 56 ; WX 600 ; N eight ; B 102 -15 498 622 ;
C 57 ; WX 600 ; N nine ; B 96 -15 489 622 ;
C 58 ; WX 600 ; N colon ; B 229 -15 371 385 ;
C 59 ; WX 600 ; N semicolon ; B 181 -112 371 385 ;
C 60 ; WX 600 ; N less ; B 41 42 519 472 ;
C 61 ; WX 600 ; N equal ; B 80 138 520 376 ;
C 62 ; WX 600 ; N greater ; B 66 42 544 472 ;
C 63 ; WX 600 ; N question ; B 129 -15 492 572 ;
C 64 ; WX 600 ; N at ; B 77 -15 533 622 ;
C 65 ; WX 600 ; N A ; B 3 0 597 562 ;
C 66 ; WX 600 ; N B ; B 43 0 559 562 ;
C 67 ; WX 600 ; N C ; B 41 -18 540 580 ;
C 68 ; WX 600 ; N D ; B 43 0 574 562 ;
C 69 ; WX 600 ; N E ; B 53 0 550 562 ;
C 70 ; WX 600 ; N F ; B 53 0 545 562 ;
C 71 ; WX 600 ; N G ; B 31 -18 575 580 ;
C 72 ; WX 600 ; N H ; B 32 0 568 562 ;
C 73 ; WX 600 ; N I ; B 96 0 504 562 ;
C 74 ; WX 600 ; N J ; B 34 -18 566 562 ;
C 75 ; WX 600 ; N K ; B 38 0 582 562 ;
C 76 ; WX 600 ; N L ; B 47 0 554 562 ;
C 77 ; WX 600 ; N M ; B 4 0 596 562 ;
C 78 ; WX 600 ; N N ; B 7 -13 593 562 ;
C 79 ; WX 600 ; N O ; B 43 -18 557 580 ;
C 80 ; WX 600 ; N P ; B 79 0 558 562 ;
C 81 ; WX 600 ; N Q ; B 43 -138 557 580 ;
C 82 ; WX 600 ; N R ; B 38 0 588 562 ;
C 83 ; WX 600 ; N S ; B 72 -20 529 580 ;
C 84 ; WX 600 ; N T ; B 38 0 563 562 ;
C 85 ; WX 600 ; N U ; B 17 -18 583 562 ;
C 86 ; WX 600 ; N V ; B -4 -13 604 562 ;
C 87 ; WX 600 ; N W ; B -3 -13 603 562 ;
C 88 ; WX 600 ; N X ; B 23 0 577 562 ;
C 89 ; WX 600 ; N Y ; B 24 0 576 562 ;
C 90 ; WX 600 ; N Z ; B 86 0 514 562 ;
C 91 ; WX 600 ; N bracketleft ; B 269 -108 442 622 ;
C 92 ; WX 600 ; N backslash ; B 118 -80 482 629 ;
C 93 ; WX 600 ; N bracketright ; B 158 -108 331 622 ;
C 94 ; WX 600 ; N asciicircum ; B 94 354 506 622 ;
C 95 ; WX 600 ; N underscore ; B 0 -125 600 -75 ;
C 96 ; WX 600 ; N quoteleft ; B 224 328 387 562 ;
C 97 ; WX 600 ; N a ; B 53 -15 559 441 ;
C 98 ; WX 600 ; N b ; B 14 -15 575 629 ;
C 99 ; WX 600 ; N c ; B 66 -15 529 441 ;
C 100 ; WX 600 ; N d ; B 45 -15 591 629 ;
C 101 ; WX 600 ; N e ; B 66 -15 548 441 ;
C 102 ; WX 600 ; N f ; B 114 0 531 629 ; L i fi ; L l fl ;
C 103 ; WX 600 ; N g ; B 45 -157 566 441 ;
C 104 ; WX 600 ; N h ; B 18 0 582 629 ;
C 105 ; WX 600 ; N i ; B 95 0 505 657 ;
C 106 ; WX 600 ; N j ; B 82 -157 410 657 ;
C 107 ; WX 600 ; N k ; B 43 0 580 629 ;
C 108 ; WX 600 ; N l ; B 95 0 505 629 ;
C 109 ; WX 600 ; N m ; B -5 0 605 441 ;
C 110 ; WX 600 ; N n ; B 26 0 575 441 ;
C 111 ; WX 600 ; N o ; B 62 -15 538 441 ;
C 112 ; WX 600 ; N p ; B 9 -157 555 441 ;
C 113 ; WX 600 ; N q ; B 45 -157 591 441 ;
C 114 ; WX 600 ; N r ; B 60 0 559 441 ;
C 115 ; WX 600 ; N s ; B 80 -15 513 441 ;
C 116 ; WX 600 ; N t ; B 87 -15 530 561 ;
C 117 ; WX 600 ; N u ; B 21 -15 562 426 ;
C 118 ; WX 600 ; N v ; B 10 -10 590 426 ;
C 119 ; WX 600 ; N w ; B -4 -10 604 426 ;
C 120 ; WX 600 ; N x ; B 20 0 580 426 ;
C 121 ; WX 600 ; N y ; B 7 -157 592 426 ;
C 122 ; WX 600 ; N z ; B 99 0 502 426 ;
C 123 ; WX 600 ; N braceleft ; B 182 -108 437 622 ;
C 124 ; WX 600 ; N bar ; B 275 -250 326 750 ;
C 125 ; WX 600 ; N braceright ; B 163 -108 418 622 ;
C 126 ; WX 600 ; N asciitilde ; B 63 197 540 320 ;
C 161 ; WX 600 ; N exclamdown ; B 236 -157 364 430 ;
C 162 ; WX 600 ; N cent ; B 96 -49 500 614 ;
C 163 ; WX 600 ; N sterling ; B 84 -21 521 611 ;
C 164 ; WX 600 ; N fraction ; B 92 -57 509 665 ;
C 165 ; WX 600 ; N yen ; B 26 0 574 562 ;
C 166 ; WX 600 ; N florin ; B 4 -143 539 622 ;
C 167 ; WX 600 ; N section ; B 113 -78 488 580 ;
C 168 ; WX 600 ; N currency ; B 73 58 527 506 ;
C 169 ; WX 600 ; N quotesingle ; B 259 328 341 562 ;
C 170 ; WX 600 ; N quotedblleft ; B 143 328 471 562 ;
C 171 ; WX 600 ; N guillemotleft ; B 37 70 563 446 ;
C 172 ; WX 600 ; N guilsinglleft ; B 149 70 451 446 ;
C 173 ; WX 600 ; N guilsinglright ; B 149 70 451 446 ;
C 174 ; WX 600 ; N fi ; B 3 0 597 629 ;
C 175 ; WX 600 ; N fl ; B 3 0 597 629 ;
C 177 ; WX 600 ; N endash ; B 75 231 525 285 ;
C 178 ; WX 600 ; N dagger ; B 141 -78 459 580 ;
C 179 ; WX 600 ; N daggerdbl ; B 141 -78 459 580 ;
C 180 ; WX 600 ; N periodcentered ; B 222 189 378 327 ;
C 182 ; WX 600 ; N paragraph ; B 50 -78 511 562 ;
C 183 ; WX 600 ; N bullet ; B 172 130 428 383 ;
C 184 ; WX 600 ; N quotesinglbase ; B 213 -134 376 100 ;
C 185 ; WX 600 ; N quotedblbase ; B 143 -134 457 100 ;
C 186 ; WX 600 ; N quotedblright ; B 143 328 457 562 ;
C 187 ; WX 600 ; N guillemotright ; B 37 70 563 446 ;
C 188 ; WX 600 ; N ellipsis ; B 37 -15 563 111 ;
C 189 ; WX 600 ; N perthousand ; B 3 -15 600 622 ;
C 191 ; WX 600 ; N questiondown ; B 108 -157 471 430 ;
C 193 ; WX 600 ; N grave ; B 151 497 378 672 ;
C 194 ; WX 600 ; N acute ; B 242 497 469 672 ;
C 195 ; WX 600 ; N circumflex ; B 124 477 476 654 ;
C 196 ; WX 600 ; N tilde ; B 105 489 503 606 ;
C 197 ; WX 600 ; N macron ; B 120 525 480 565 ;
C 198 ; WX 600 ; N breve ; B 153 501 447 609 ;
C 199 ; WX 600 ; N dotaccent ; B 249 537 352 640 ;
C 200 ; WX 600 ; N dieresis ; B 148 537 453 640 ;
C 202 ; WX 600 ; N ring ; B 218 463 382 627 ;
C 203 ; WX 600 ; N cedilla ; B 224 -151 362 10 ;
C 205 ; WX 600 ; N hungarumlaut ; B 133 497 540 672 ;
C 206 ; WX 600 ; N ogonek ; B 211 -172 407 4 ;
C 207 ; WX 600 ; N caron ; B 124 492 476 669 ;
C 208 ; WX 600 ; N emdash ; B 0 231 600 285 ;
C 225 ; WX 600 ; N AE ; B 3 0 550 562 ;
C 227 ; WX 600 ; N ordfeminine ; B 156 249 442 580 ;
C 232 ; WX 600 ; N Lslash ; B 47 0 554 562 ;
C 233 ; WX 600 ; N Oslash ; B 43 -80 557 629 ;
C 234 ; WX 600 ; N OE ; B 7 0 567 562 ;
C 235 ; WX 600 ; N ordmasculine ; B 157 249 443 580 ;
C 241 ; WX 600 ; N ae ; B 19 -15 570 441 ;
C 245 ; WX 600 ; N dotlessi ; B 95 0 505 426 ;
C 248 ; WX 600 ; N lslash ; B 95 0 505 629 ;
C 249 ; WX 600 ; N oslash ; B 62 -80 538 506 ;
C 250 ; WX 600 ; N oe ; B 19 -15 559 441 ;
C 251 ; WX 600 ; N germandbls ; B 48 -15 588 629 ;
C -1 ; WX 600 ; N Idieresis ; B 96 0 504 753 ;
C -1 ; WX 600 ; N eacute ; B 66 -15 548 672 ;
C -1 ; WX 600 ; N abreve ; B 53 -15 559 609 ;
C -1 ; WX 600 ; N uhungarumlaut ; B 21 -15 580 672 ;
C -1 ; WX 600 ; N ecaron ; B 66 -15 548 669 ;
C -1 ; WX 600 ; N Ydieresis ; B 24 0 576 753 ;
C -1 ; WX 600 ; N divide ; B 87 48 513 467 ;
C -1 ; WX 600 ; N Yacute ; B 24 0 576 805 ;
C -1 ; WX 600 ; N Acircumflex ; B 3 0 597 787 ;
C -1 ; WX 600 ; N aacute ; B 53 -15 559 672 ;
C -1 ; WX 600 ; N Ucircumflex ; B 17 -18 583 787 ;
C -1 ; WX 600 ; N yacute ; B 7 -157 592 672 ;
C -1 ; WX 600 ; N scommaaccent ; B 80 -250 513 441 ;
C -1 ; WX 600 ; N ecircumflex ; B 66 -15 548 654 ;
C -1 ; WX 600 ; N Uring ; B 17 -18 583 760 ;
C -1 ; WX 600 ; N Udieresis ; B 17 -18 583 753 ;
C -1 ; WX 600 ; N aogonek ; B 53 -172 587 441 ;
C -1 ; WX 600 ; N Uacute ; B 17 -18 583 805 ;
C -1 ; WX 600 ; N uogonek ; B 21 -172 590 426 ;
C -1 ; WX 600 ; N Edieresis ; B 53 0 550 753 ;
C -1 ; WX 600 ; N Dcroat ; B 30 0 574 562 ;
C -1 ; WX 600 ; N commaaccent ; B 198 -250 335 -58 ;
C -1 ; WX 600 ; N copyright ; B 0 -18 600 580 ;
C -1 ; WX 600 ; N Emacron ; B 53 0 550 698 ;
C -1 ; WX 600 ; N ccaron ; B 66 -15 529 669 ;
C -1 ; WX 600 ; N aring ; B 53 -15 559 627 ;
C -1 ; WX 600 ; N Ncommaaccent ; B 7 -250 593 562 ;
C -1 ; WX 600 ; N lacute ; B 95 0 505 805 ;
C -1 ; WX 600 ; N agrave ; B 53 -15 559 672 ;
C -1 ; WX 600 ; N Tcommaaccent ; B 38 -250 563 562 ;
C -1 ; WX 600 ; N Cacute ; B 41 -18 540 805 ;
C -1 ; WX 600 ; N atilde ; B 53 -15 559 606 ;
C -1 ; WX 600 ; N Edotaccent ; B 53 0 550 753 ;
C -1 ; WX 600 ; N scaron ; B 80 -15 513 669 ;
C -1 ; WX 600 ; N scedilla ; B 80 -151 513 441 ;
C -1 ; WX 600 ; N iacute ; B 95 0 505 672 ;
C -1 ; WX 600 ; N lozenge ; B 18 0 443 706 ;
C -1 ; WX 600 ; N Rcaron ; B 38 0 588 802 ;
C -1 ; WX 600 ; N Gcommaaccent ; B 31 -250 575 580 ;
C -1 ; WX 600 ; N ucircumflex ; B 21 -15 562 654 ;
C -1 ; WX 600 ; N acircumflex ; B 53 -15 559 654 ;
C -1 ; WX 600 ; N Amacron ; B 3 0 597 698 ;
C -1 ; WX 600 ; N rcaron ; B 60 0 559 669 ;
C -1 ; WX 600 ; N ccedilla ; B 66 -151 529 441 ;
C -1 ; WX 600 ; N Zdotaccent ; B 86 0 514 753 ;
C -1 ; WX 600 ; N Thorn ; B 79 0 538 562 ;
C -1 ; WX 600 ; N Omacron ; B 43 -18 557 698 ;
C -1 ; WX 600 ; N Racute ; B 38 0 588 805 ;
C -1 ; WX 600 ; N Sacute ; B 72 -20 529 805 ;
C -1 ; WX 600 ; N dcaron ; B 45 -15 715 629 ;
C -1 ; WX 600 ; N Umacron ; B 17 -18 583 698 ;
C -1 ; WX 600 ; N uring ; B 21 -15 562 627 ;
C -1 ; WX 600 ; N threesuperior ; B 155 240 406 622 ;
C -1 ; WX 600 ; N Ograve ; B 43 -18 557 805 ;
C -1 ; WX 600 ; N Agrave ; B 3 0 597 805 ;
C -1 ; WX 600 ; N Abreve ; B 3 0 597 732 ;
C -1 ; WX 600 ; N multiply ; B 87 43 515 470 ;
C -1 ; WX 600 ; N uacute ; B 21 -15 562 672 ;
C -1 ; WX 600 ; N Tcaron ; B 38 0 563 802 ;
C -1 ; WX 600 ; N partialdiff ; B 17 -38 459 710 ;
C -1 ; WX 600 ; N ydieresis ; B 7 -157 592 620 ;
C -1 ; WX 600 ; N Nacute ; B 7 -13 593 805 ;
C -1 ; WX 600 ; N icircumflex ; B 94 0 505 654 ;
C -1 ; WX 600 ; N Ecircumflex ; B 53 0 550 787 ;
C -1 ; WX 600 ; N adieresis ; B 53 -15 559 620 ;
C -1 ; WX 600 ; N edieresis ; B 66 -15 548 620 ;
C -1 ; WX 600 ; N cacute ; B 66 -15 529 672 ;
C -1 ; WX 600 ; N nacute ; B 26 0 575 672 ;
C -1 ; WX 600 ; N umacron ; B 21 -15 562 565 ;
C -1 ; WX 600 ; N Ncaron ; B 7 -13 593 802 ;
C -1 ; WX 600 ; N Iacute ; B 96 0 504 805 ;
C -1 ; WX 600 ; N plusminus ; B 87 44 513 558 ;
C -1 ; WX 600 ; N brokenbar ; B 275 -175 326 675 ;
C -1 ; WX 600 ; N registered ; B 0 -18 600 580 ;
C -1 ; WX 600 ; N Gbreve ; B 31 -18 575 732 ;
C -1 ; WX 600 ; N Idotaccent ; B 96 0 504 753 ;
C -1 ; WX 600 ; N summation ; B 15 -10 585 706 ;
C -1 ; WX 600 ; N Egrave ; B 53 0 550 805 ;
C -1 ; WX 600 ; N racute ; B 60 0 559 672 ;
C -1 ; WX 600 ; N omacron ; B 62 -15 538 565 ;
C -1 ; WX 600 ; N Zacute ; B 86 0 514 805 ;
C -1 ; WX 600 ; N Zcaron ; B 86 0 514 802 ;
C -1 ; WX 600 ; N greaterequal ; B 98 0 502 710 ;
C -1 ; WX 600 ; N Eth ; B 30 0 574 562 ;
C -1 ; WX 600 ; N Ccedilla ; B 41 -151 540 580 ;
C -1 ; WX 600 ; N lcommaaccent ; B 95 -250 505 629 ;
C -1 ; WX 600 ; N tcaron ; B 87 -15 530 717 ;
C -1 ; WX 600 ; N eogonek ; B 66 -172 548 441 ;
C -1 ; WX 600 ; N Uogonek ; B 17 -172 583 562 ;
C -1 ; WX 600 ; N Aacute ; B 3 0 597 805 ;
C -1 ; WX 600 ; N Adieresis ; B 3 0 597 753 ;
C -1 ; WX 600 ; N egrave ; B 66 -15 548 672 ;
C -1 ; WX 600 ; N zacute ; B 99 0 502 672 ;
C -1 ; WX 600 ; N iogonek ; B 95 -172 505 657 ;
C -1 ; WX 600 ; N Oacute ; B 43 -18 557 805 ;
C -1 ; WX 600 ; N oacute ; B 62 -15 538 672 ;
C -1 ; WX 600 ; N amacron ; B 53 -15 559 565 ;
C -1 ; WX 600 ; N sacute ; B 80 -15 513 672 ;
C -1 ; WX 600 ; N idieresis ; B 95 0 505 620 ;
C -1 ; WX 600 ; N Ocircumflex ; B 43 -18 557 787 ;
C -1 ; WX 600 ; N Ugrave ; B 17 -18 583 805 ;
C -1 ; WX 600 ; N Delta ; B 6 0 598 688 ;
C -1 ; WX 600 ; N thorn ; B -6 -157 555 629 ;
C -1 ; WX 600 ; N twosuperior ; B 177 249 424 622 ;
C -1 ; WX 600 ; N Odieresis ; B 43 -18 557 753 ;
C -1 ; WX 600 ; N mu ; B 21 -157 562 426 ;
C -1 ; WX 600 ; N igrave ; B 95 0 505 672 ;
C -1 ; WX 600 ; N ohungarumlaut ; B 62 -15 580 672 ;
C -1 ; WX 600 ; N Eogonek ; B 53 -172 561 562 ;
C -1 ; WX 600 ; N dcroat ; B 45 -15 591 629 ;
C -1 ; WX 600 ; N threequarters ; B 8 -56 593 666 ;
C -1 ; WX 600 ; N Scedilla ; B 72 -151 529 580 ;
C -1 ; WX 600 ; N lcaron ; B 95 0 533 629 ;
C -1 ; WX 600 ; N Kcommaaccent ; B 38 -250 582 562 ;
C -1 ; WX 600 ; N Lacute ; B 47 0 554 805 ;
C -1 ; WX 600 ; N trademark ; B -23 263 623 562 ;
C -1 ; WX 600 ; N edotaccent ; B 66 -15 548 620 ;
C -1 ; WX 600 ; N Igrave ; B 96 0 504 805 ;
C -1 ; WX 600 ; N Imacron ; B 96 0 504 698 ;
C -1 ; WX 600 ; N Lcaron ; B 47 0 554 562 ;
C -1 ; WX 600 ; N onehalf ; B 0 -57 611 665 ;
C -1 ; WX 600 ; N lessequal ; B 98 0 502 710 ;
C -1 ; WX 600 ; N ocircumflex ; B 62 -15 538 654 ;
C -1 ; WX 600 ; N ntilde ; B 26 0 575 606 ;
C -1 ; WX 600 ; N Uhungarumlaut ; B 17 -18 590 805 ;
C -1 ; WX 600 ; N Eacute ; B 53 0 550 805 ;
C -1 ; WX 600 ; N emacron ; B 66 -15 548 565 ;
C -1 ; WX 600 ; N gbreve ; B 45 -157 566 609 ;
C -1 ; WX 600 ; N onequarter ; B 0 -57 600 665 ;
C -1 ; WX 600 ; N Scaron ; B 72 -20 529 802 ;
C -1 ; WX 600 ; N Scommaaccent ; B 72 -250 529 580 ;
C -1 ; WX 600 ; N Ohungarumlaut ; B 43 -18 580 805 ;
C -1 ; WX 600 ; N degree ; B 123 269 477 622 ;
C -1 ; WX 600 ; N ograve ; B 62 -15 538 672 ;
C -1 ; WX 600 ; N Ccaron ; B 41 -18 540 802 ;
C -1 ; WX 600 ; N ugrave ; B 21 -15 562 672 ;
C -1 ; WX 600 ; N radical ; B 3 -15 597 792 ;
C -1 ; WX 600 ; N Dcaron ; B 43 0 574 802 ;
C -1 ; WX 600 ; N rcommaaccent ; B 60 -250 559 441 ;
C -1 ; WX 600 ; N Ntilde ; B 7 -13 593 729 ;
C -1 ; WX 600 ; N otilde ; B 62 -15 538 606 ;
C -1 ; WX 600 ; N Rcommaaccent ; B 38 -250 588 562 ;
C -1 ; WX 600 ; N Lcommaaccent ; B 47 -250 554 562 ;
C -1 ; WX 600 ; N Atilde ; B 3 0 597 729 ;
C -1 ; WX 600 ; N Aogonek ; B 3 -172 608 562 ;
C -1 ; WX 600 ; N Aring ; B 3 0 597 750 ;
C -1 ; WX 600 ; N Otilde ; B 43 -18 557 729 ;
C -1 ; WX 600 ; N zdotaccent ; B 99 0 502 620 ;
C -1 ; WX 600 ; N Ecaron ; B 53 0 550 802 ;
C -1 ; WX 600 ; N Iogonek ; B 96 -172 504 562 ;
C -1 ; WX 600 ; N kcommaaccent ; B 43 -250 580 629 ;
C -1 ; WX 600 ; N minus ; B 80 232 520 283 ;
C -1 ; WX 600 ; N Icircumflex ; B 96 0 504 787 ;
C -1 ; WX 600 ; N ncaron ; B 26 0 575 669 ;
C -1 ; WX 600 ; N tcommaaccent ; B 87 -250 530 561 ;
C -1 ; WX 600 ; N logicalnot ; B 87 108 513 369 ;
C -1 ; WX 600 ; N odieresis ; B 62 -15 538 620 ;
C -1 ; WX 600 ; N udieresis ; B 21 -15 562 620 ;
C -1 ; WX 600 ; N notequal ; B 15 -16 540 529 ;
C -1 ; WX 600 ; N gcommaaccent ; B 45 -157 566 708 ;
C -1 ; WX 600 ; N eth ; B 62 -15 538 629 ;
C -1 ; WX 600 ; N zcaron ; B 99 0 502 669 ;
C -1 ; WX 600 ; N ncommaaccent ; B 26 -250 575 441 ;
C -1 ; WX 600 ; N onesuperior ; B 172 249 428 622 ;
C -1 ; WX 600 ; N imacron ; B 95 0 505 565 ;
C -1 ; WX 600 ; N Euro ; B 0 0 0 0 ;
EndCharMetrics
EndFontMetrics"

let courier_oblique_afm = "StartFontMetrics 4.1
Comment Copyright (c) 1989, 1990, 1991, 1992, 1993, 1997 Adobe Systems Incorporated.  All Rights Reserved.
Comment Creation Date: Thu May  1 17:37:52 1997
Comment UniqueID 43051
Comment VMusage 16248 75829
FontName Courier-Oblique
FullName Courier Oblique
FamilyName Courier
Weight Medium
ItalicAngle -12
IsFixedPitch true
CharacterSet ExtendedRoman
FontBBox -27 -250 849 805 
UnderlinePosition -100
UnderlineThickness 50
Version 003.000
Notice Copyright (c) 1989, 1990, 1991, 1992, 1993, 1997 Adobe Systems Incorporated.  All Rights Reserved.
EncodingScheme AdobeStandardEncoding
CapHeight 562
XHeight 426
Ascender 629
Descender -157
StdHW 51
StdVW 51
StartCharMetrics 315
C 32 ; WX 600 ; N space ; B 0 0 0 0 ;
C 33 ; WX 600 ; N exclam ; B 243 -15 464 572 ;
C 34 ; WX 600 ; N quotedbl ; B 273 328 532 562 ;
C 35 ; WX 600 ; N numbersign ; B 133 -32 596 639 ;
C 36 ; WX 600 ; N dollar ; B 108 -126 596 662 ;
C 37 ; WX 600 ; N percent ; B 134 -15 599 622 ;
C 38 ; WX 600 ; N ampersand ; B 87 -15 580 543 ;
C 39 ; WX 600 ; N quoteright ; B 283 328 495 562 ;
C 40 ; WX 600 ; N parenleft ; B 313 -108 572 622 ;
C 41 ; WX 600 ; N parenright ; B 137 -108 396 622 ;
C 42 ; WX 600 ; N asterisk ; B 212 257 580 607 ;
C 43 ; WX 600 ; N plus ; B 129 44 580 470 ;
C 44 ; WX 600 ; N comma ; B 157 -112 370 122 ;
C 45 ; WX 600 ; N hyphen ; B 152 231 558 285 ;
C 46 ; WX 600 ; N period ; B 238 -15 382 109 ;
C 47 ; WX 600 ; N slash ; B 112 -80 604 629 ;
C 48 ; WX 600 ; N zero ; B 154 -15 575 622 ;
C 49 ; WX 600 ; N one ; B 98 0 515 622 ;
C 50 ; WX 600 ; N two ; B 70 0 568 622 ;
C 51 ; WX 600 ; N three ; B 82 -15 538 622 ;
C 52 ; WX 600 ; N four ; B 108 0 541 622 ;
C 53 ; WX 600 ; N five ; B 99 -15 589 607 ;
C 54 ; WX 600 ; N six ; B 155 -15 629 622 ;
C 55 ; WX 600 ; N seven ; B 182 0 612 607 ;
C 56 ; WX 600 ; N eight ; B 132 -15 588 622 ;
C 57 ; WX 600 ; N nine ; B 93 -15 574 622 ;
C 58 ; WX 600 ; N colon ; B 238 -15 441 385 ;
C 59 ; WX 600 ; N semicolon ; B 157 -112 441 385 ;
C 60 ; WX 600 ; N less ; B 96 42 610 472 ;
C 61 ; WX 600 ; N equal ; B 109 138 600 376 ;
C 62 ; WX 600 ; N greater ; B 85 42 599 472 ;
C 63 ; WX 600 ; N question ; B 222 -15 583 572 ;
C 64 ; WX 600 ; N at ; B 127 -15 582 622 ;
C 65 ; WX 600 ; N A ; B 3 0 607 562 ;
C 66 ; WX 600 ; N B ; B 43 0 616 562 ;
C 67 ; WX 600 ; N C ; B 93 -18 655 580 ;
C 68 ; WX 600 ; N D ; B 43 0 645 562 ;
C 69 ; WX 600 ; N E ; B 53 0 660 562 ;
C 70 ; WX 600 ; N F ; B 53 0 660 562 ;
C 71 ; WX 600 ; N G ; B 83 -18 645 580 ;
C 72 ; WX 600 ; N H ; B 32 0 687 562 ;
C 73 ; WX 600 ; N I ; B 96 0 623 562 ;
C 74 ; WX 600 ; N J ; B 52 -18 685 562 ;
C 75 ; WX 600 ; N K ; B 38 0 671 562 ;
C 76 ; WX 600 ; N L ; B 47 0 607 562 ;
C 77 ; WX 600 ; N M ; B 4 0 715 562 ;
C 78 ; WX 600 ; N N ; B 7 -13 712 562 ;
C 79 ; WX 600 ; N O ; B 94 -18 625 580 ;
C 80 ; WX 600 ; N P ; B 79 0 644 562 ;
C 81 ; WX 600 ; N Q ; B 95 -138 625 580 ;
C 82 ; WX 600 ; N R ; B 38 0 598 562 ;
C 83 ; WX 600 ; N S ; B 76 -20 650 580 ;
C 84 ; WX 600 ; N T ; B 108 0 665 562 ;
C 85 ; WX 600 ; N U ; B 125 -18 702 562 ;
C 86 ; WX 600 ; N V ; B 105 -13 723 562 ;
C 87 ; WX 600 ; N W ; B 106 -13 722 562 ;
C 88 ; WX 600 ; N X ; B 23 0 675 562 ;
C 89 ; WX 600 ; N Y ; B 133 0 695 562 ;
C 90 ; WX 600 ; N Z ; B 86 0 610 562 ;
C 91 ; WX 600 ; N bracketleft ; B 246 -108 574 622 ;
C 92 ; WX 600 ; N backslash ; B 249 -80 468 629 ;
C 93 ; WX 600 ; N bracketright ; B 135 -108 463 622 ;
C 94 ; WX 600 ; N asciicircum ; B 175 354 587 622 ;
C 95 ; WX 600 ; N underscore ; B -27 -125 584 -75 ;
C 96 ; WX 600 ; N quoteleft ; B 343 328 457 562 ;
C 97 ; WX 600 ; N a ; B 76 -15 569 441 ;
C 98 ; WX 600 ; N b ; B 29 -15 625 629 ;
C 99 ; WX 600 ; N c ; B 106 -15 608 441 ;
C 100 ; WX 600 ; N d ; B 85 -15 640 629 ;
C 101 ; WX 600 ; N e ; B 106 -15 598 441 ;
C 102 ; WX 600 ; N f ; B 114 0 662 629 ; L i fi ; L l fl ;
C 103 ; WX 600 ; N g ; B 61 -157 657 441 ;
C 104 ; WX 600 ; N h ; B 33 0 592 629 ;
C 105 ; WX 600 ; N i ; B 95 0 515 657 ;
C 106 ; WX 600 ; N j ; B 52 -157 550 657 ;
C 107 ; WX 600 ; N k ; B 58 0 633 629 ;
C 108 ; WX 600 ; N l ; B 95 0 515 629 ;
C 109 ; WX 600 ; N m ; B -5 0 615 441 ;
C 110 ; WX 600 ; N n ; B 26 0 585 441 ;
C 111 ; WX 600 ; N o ; B 102 -15 588 441 ;
C 112 ; WX 600 ; N p ; B -24 -157 605 441 ;
C 113 ; WX 600 ; N q ; B 85 -157 682 441 ;
C 114 ; WX 600 ; N r ; B 60 0 636 441 ;
C 115 ; WX 600 ; N s ; B 78 -15 584 441 ;
C 116 ; WX 600 ; N t ; B 167 -15 561 561 ;
C 117 ; WX 600 ; N u ; B 101 -15 572 426 ;
C 118 ; WX 600 ; N v ; B 90 -10 681 426 ;
C 119 ; WX 600 ; N w ; B 76 -10 695 426 ;
C 120 ; WX 600 ; N x ; B 20 0 655 426 ;
C 121 ; WX 600 ; N y ; B -4 -157 683 426 ;
C 122 ; WX 600 ; N z ; B 99 0 593 426 ;
C 123 ; WX 600 ; N braceleft ; B 233 -108 569 622 ;
C 124 ; WX 600 ; N bar ; B 222 -250 485 750 ;
C 125 ; WX 600 ; N braceright ; B 140 -108 477 622 ;
C 126 ; WX 600 ; N asciitilde ; B 116 197 600 320 ;
C 161 ; WX 600 ; N exclamdown ; B 225 -157 445 430 ;
C 162 ; WX 600 ; N cent ; B 151 -49 588 614 ;
C 163 ; WX 600 ; N sterling ; B 124 -21 621 611 ;
C 164 ; WX 600 ; N fraction ; B 84 -57 646 665 ;
C 165 ; WX 600 ; N yen ; B 120 0 693 562 ;
C 166 ; WX 600 ; N florin ; B -26 -143 671 622 ;
C 167 ; WX 600 ; N section ; B 104 -78 590 580 ;
C 168 ; WX 600 ; N currency ; B 94 58 628 506 ;
C 169 ; WX 600 ; N quotesingle ; B 345 328 460 562 ;
C 170 ; WX 600 ; N quotedblleft ; B 262 328 541 562 ;
C 171 ; WX 600 ; N guillemotleft ; B 92 70 652 446 ;
C 172 ; WX 600 ; N guilsinglleft ; B 204 70 540 446 ;
C 173 ; WX 600 ; N guilsinglright ; B 170 70 506 446 ;
C 174 ; WX 600 ; N fi ; B 3 0 619 629 ;
C 175 ; WX 600 ; N fl ; B 3 0 619 629 ;
C 177 ; WX 600 ; N endash ; B 124 231 586 285 ;
C 178 ; WX 600 ; N dagger ; B 217 -78 546 580 ;
C 179 ; WX 600 ; N daggerdbl ; B 163 -78 546 580 ;
C 180 ; WX 600 ; N periodcentered ; B 275 189 434 327 ;
C 182 ; WX 600 ; N paragraph ; B 100 -78 630 562 ;
C 183 ; WX 600 ; N bullet ; B 224 130 485 383 ;
C 184 ; WX 600 ; N quotesinglbase ; B 185 -134 397 100 ;
C 185 ; WX 600 ; N quotedblbase ; B 115 -134 478 100 ;
C 186 ; WX 600 ; N quotedblright ; B 213 328 576 562 ;
C 187 ; WX 600 ; N guillemotright ; B 58 70 618 446 ;
C 188 ; WX 600 ; N ellipsis ; B 46 -15 575 111 ;
C 189 ; WX 600 ; N perthousand ; B 59 -15 627 622 ;
C 191 ; WX 600 ; N questiondown ; B 105 -157 466 430 ;
C 193 ; WX 600 ; N grave ; B 294 497 484 672 ;
C 194 ; WX 600 ; N acute ; B 348 497 612 672 ;
C 195 ; WX 600 ; N circumflex ; B 229 477 581 654 ;
C 196 ; WX 600 ; N tilde ; B 212 489 629 606 ;
C 197 ; WX 600 ; N macron ; B 232 525 600 565 ;
C 198 ; WX 600 ; N breve ; B 279 501 576 609 ;
C 199 ; WX 600 ; N dotaccent ; B 373 537 478 640 ;
C 200 ; WX 600 ; N dieresis ; B 272 537 579 640 ;
C 202 ; WX 600 ; N ring ; B 332 463 500 627 ;
C 203 ; WX 600 ; N cedilla ; B 197 -151 344 10 ;
C 205 ; WX 600 ; N hungarumlaut ; B 239 497 683 672 ;
C 206 ; WX 600 ; N ogonek ; B 189 -172 377 4 ;
C 207 ; WX 600 ; N caron ; B 262 492 614 669 ;
C 208 ; WX 600 ; N emdash ; B 49 231 661 285 ;
C 225 ; WX 600 ; N AE ; B 3 0 655 562 ;
C 227 ; WX 600 ; N ordfeminine ; B 209 249 512 580 ;
C 232 ; WX 600 ; N Lslash ; B 47 0 607 562 ;
C 233 ; WX 600 ; N Oslash ; B 94 -80 625 629 ;
C 234 ; WX 600 ; N OE ; B 59 0 672 562 ;
C 235 ; WX 600 ; N ordmasculine ; B 210 249 535 580 ;
C 241 ; WX 600 ; N ae ; B 41 -15 626 441 ;
C 245 ; WX 600 ; N dotlessi ; B 95 0 515 426 ;
C 248 ; WX 600 ; N lslash ; B 95 0 587 629 ;
C 249 ; WX 600 ; N oslash ; B 102 -80 588 506 ;
C 250 ; WX 600 ; N oe ; B 54 -15 615 441 ;
C 251 ; WX 600 ; N germandbls ; B 48 -15 617 629 ;
C -1 ; WX 600 ; N Idieresis ; B 96 0 623 753 ;
C -1 ; WX 600 ; N eacute ; B 106 -15 612 672 ;
C -1 ; WX 600 ; N abreve ; B 76 -15 576 609 ;
C -1 ; WX 600 ; N uhungarumlaut ; B 101 -15 723 672 ;
C -1 ; WX 600 ; N ecaron ; B 106 -15 614 669 ;
C -1 ; WX 600 ; N Ydieresis ; B 133 0 695 753 ;
C -1 ; WX 600 ; N divide ; B 136 48 573 467 ;
C -1 ; WX 600 ; N Yacute ; B 133 0 695 805 ;
C -1 ; WX 600 ; N Acircumflex ; B 3 0 607 787 ;
C -1 ; WX 600 ; N aacute ; B 76 -15 612 672 ;
C -1 ; WX 600 ; N Ucircumflex ; B 125 -18 702 787 ;
C -1 ; WX 600 ; N yacute ; B -4 -157 683 672 ;
C -1 ; WX 600 ; N scommaaccent ; B 78 -250 584 441 ;
C -1 ; WX 600 ; N ecircumflex ; B 106 -15 598 654 ;
C -1 ; WX 600 ; N Uring ; B 125 -18 702 760 ;
C -1 ; WX 600 ; N Udieresis ; B 125 -18 702 753 ;
C -1 ; WX 600 ; N aogonek ; B 76 -172 569 441 ;
C -1 ; WX 600 ; N Uacute ; B 125 -18 702 805 ;
C -1 ; WX 600 ; N uogonek ; B 101 -172 572 426 ;
C -1 ; WX 600 ; N Edieresis ; B 53 0 660 753 ;
C -1 ; WX 600 ; N Dcroat ; B 43 0 645 562 ;
C -1 ; WX 600 ; N commaaccent ; B 145 -250 323 -58 ;
C -1 ; WX 600 ; N copyright ; B 53 -18 667 580 ;
C -1 ; WX 600 ; N Emacron ; B 53 0 660 698 ;
C -1 ; WX 600 ; N ccaron ; B 106 -15 614 669 ;
C -1 ; WX 600 ; N aring ; B 76 -15 569 627 ;
C -1 ; WX 600 ; N Ncommaaccent ; B 7 -250 712 562 ;
C -1 ; WX 600 ; N lacute ; B 95 0 640 805 ;
C -1 ; WX 600 ; N agrave ; B 76 -15 569 672 ;
C -1 ; WX 600 ; N Tcommaaccent ; B 108 -250 665 562 ;
C -1 ; WX 600 ; N Cacute ; B 93 -18 655 805 ;
C -1 ; WX 600 ; N atilde ; B 76 -15 629 606 ;
C -1 ; WX 600 ; N Edotaccent ; B 53 0 660 753 ;
C -1 ; WX 600 ; N scaron ; B 78 -15 614 669 ;
C -1 ; WX 600 ; N scedilla ; B 78 -151 584 441 ;
C -1 ; WX 600 ; N iacute ; B 95 0 612 672 ;
C -1 ; WX 600 ; N lozenge ; B 94 0 519 706 ;
C -1 ; WX 600 ; N Rcaron ; B 38 0 642 802 ;
C -1 ; WX 600 ; N Gcommaaccent ; B 83 -250 645 580 ;
C -1 ; WX 600 ; N ucircumflex ; B 101 -15 572 654 ;
C -1 ; WX 600 ; N acircumflex ; B 76 -15 581 654 ;
C -1 ; WX 600 ; N Amacron ; B 3 0 607 698 ;
C -1 ; WX 600 ; N rcaron ; B 60 0 636 669 ;
C -1 ; WX 600 ; N ccedilla ; B 106 -151 614 441 ;
C -1 ; WX 600 ; N Zdotaccent ; B 86 0 610 753 ;
C -1 ; WX 600 ; N Thorn ; B 79 0 606 562 ;
C -1 ; WX 600 ; N Omacron ; B 94 -18 628 698 ;
C -1 ; WX 600 ; N Racute ; B 38 0 670 805 ;
C -1 ; WX 600 ; N Sacute ; B 76 -20 650 805 ;
C -1 ; WX 600 ; N dcaron ; B 85 -15 849 629 ;
C -1 ; WX 600 ; N Umacron ; B 125 -18 702 698 ;
C -1 ; WX 600 ; N uring ; B 101 -15 572 627 ;
C -1 ; WX 600 ; N threesuperior ; B 213 240 501 622 ;
C -1 ; WX 600 ; N Ograve ; B 94 -18 625 805 ;
C -1 ; WX 600 ; N Agrave ; B 3 0 607 805 ;
C -1 ; WX 600 ; N Abreve ; B 3 0 607 732 ;
C -1 ; WX 600 ; N multiply ; B 103 43 607 470 ;
C -1 ; WX 600 ; N uacute ; B 101 -15 602 672 ;
C -1 ; WX 600 ; N Tcaron ; B 108 0 665 802 ;
C -1 ; WX 600 ; N partialdiff ; B 45 -38 546 710 ;
C -1 ; WX 600 ; N ydieresis ; B -4 -157 683 620 ;
C -1 ; WX 600 ; N Nacute ; B 7 -13 712 805 ;
C -1 ; WX 600 ; N icircumflex ; B 95 0 551 654 ;
C -1 ; WX 600 ; N Ecircumflex ; B 53 0 660 787 ;
C -1 ; WX 600 ; N adieresis ; B 76 -15 575 620 ;
C -1 ; WX 600 ; N edieresis ; B 106 -15 598 620 ;
C -1 ; WX 600 ; N cacute ; B 106 -15 612 672 ;
C -1 ; WX 600 ; N nacute ; B 26 0 602 672 ;
C -1 ; WX 600 ; N umacron ; B 101 -15 600 565 ;
C -1 ; WX 600 ; N Ncaron ; B 7 -13 712 802 ;
C -1 ; WX 600 ; N Iacute ; B 96 0 640 805 ;
C -1 ; WX 600 ; N plusminus ; B 96 44 594 558 ;
C -1 ; WX 600 ; N brokenbar ; B 238 -175 469 675 ;
C -1 ; WX 600 ; N registered ; B 53 -18 667 580 ;
C -1 ; WX 600 ; N Gbreve ; B 83 -18 645 732 ;
C -1 ; WX 600 ; N Idotaccent ; B 96 0 623 753 ;
C -1 ; WX 600 ; N summation ; B 15 -10 670 706 ;
C -1 ; WX 600 ; N Egrave ; B 53 0 660 805 ;
C -1 ; WX 600 ; N racute ; B 60 0 636 672 ;
C -1 ; WX 600 ; N omacron ; B 102 -15 600 565 ;
C -1 ; WX 600 ; N Zacute ; B 86 0 670 805 ;
C -1 ; WX 600 ; N Zcaron ; B 86 0 642 802 ;
C -1 ; WX 600 ; N greaterequal ; B 98 0 594 710 ;
C -1 ; WX 600 ; N Eth ; B 43 0 645 562 ;
C -1 ; WX 600 ; N Ccedilla ; B 93 -151 658 580 ;
C -1 ; WX 600 ; N lcommaaccent ; B 95 -250 515 629 ;
C -1 ; WX 600 ; N tcaron ; B 167 -15 587 717 ;
C -1 ; WX 600 ; N eogonek ; B 106 -172 598 441 ;
C -1 ; WX 600 ; N Uogonek ; B 124 -172 702 562 ;
C -1 ; WX 600 ; N Aacute ; B 3 0 660 805 ;
C -1 ; WX 600 ; N Adieresis ; B 3 0 607 753 ;
C -1 ; WX 600 ; N egrave ; B 106 -15 598 672 ;
C -1 ; WX 600 ; N zacute ; B 99 0 612 672 ;
C -1 ; WX 600 ; N iogonek ; B 95 -172 515 657 ;
C -1 ; WX 600 ; N Oacute ; B 94 -18 640 805 ;
C -1 ; WX 600 ; N oacute ; B 102 -15 612 672 ;
C -1 ; WX 600 ; N amacron ; B 76 -15 600 565 ;
C -1 ; WX 600 ; N sacute ; B 78 -15 612 672 ;
C -1 ; WX 600 ; N idieresis ; B 95 0 545 620 ;
C -1 ; WX 600 ; N Ocircumflex ; B 94 -18 625 787 ;
C -1 ; WX 600 ; N Ugrave ; B 125 -18 702 805 ;
C -1 ; WX 600 ; N Delta ; B 6 0 598 688 ;
C -1 ; WX 600 ; N thorn ; B -24 -157 605 629 ;
C -1 ; WX 600 ; N twosuperior ; B 230 249 535 622 ;
C -1 ; WX 600 ; N Odieresis ; B 94 -18 625 753 ;
C -1 ; WX 600 ; N mu ; B 72 -157 572 426 ;
C -1 ; WX 600 ; N igrave ; B 95 0 515 672 ;
C -1 ; WX 600 ; N ohungarumlaut ; B 102 -15 723 672 ;
C -1 ; WX 600 ; N Eogonek ; B 53 -172 660 562 ;
C -1 ; WX 600 ; N dcroat ; B 85 -15 704 629 ;
C -1 ; WX 600 ; N threequarters ; B 73 -56 659 666 ;
C -1 ; WX 600 ; N Scedilla ; B 76 -151 650 580 ;
C -1 ; WX 600 ; N lcaron ; B 95 0 667 629 ;
C -1 ; WX 600 ; N Kcommaaccent ; B 38 -250 671 562 ;
C -1 ; WX 600 ; N Lacute ; B 47 0 607 805 ;
C -1 ; WX 600 ; N trademark ; B 75 263 742 562 ;
C -1 ; WX 600 ; N edotaccent ; B 106 -15 598 620 ;
C -1 ; WX 600 ; N Igrave ; B 96 0 623 805 ;
C -1 ; WX 600 ; N Imacron ; B 96 0 628 698 ;
C -1 ; WX 600 ; N Lcaron ; B 47 0 632 562 ;
C -1 ; WX 600 ; N onehalf ; B 65 -57 669 665 ;
C -1 ; WX 600 ; N lessequal ; B 98 0 645 710 ;
C -1 ; WX 600 ; N ocircumflex ; B 102 -15 588 654 ;
C -1 ; WX 600 ; N ntilde ; B 26 0 629 606 ;
C -1 ; WX 600 ; N Uhungarumlaut ; B 125 -18 761 805 ;
C -1 ; WX 600 ; N Eacute ; B 53 0 670 805 ;
C -1 ; WX 600 ; N emacron ; B 106 -15 600 565 ;
C -1 ; WX 600 ; N gbreve ; B 61 -157 657 609 ;
C -1 ; WX 600 ; N onequarter ; B 65 -57 674 665 ;
C -1 ; WX 600 ; N Scaron ; B 76 -20 672 802 ;
C -1 ; WX 600 ; N Scommaaccent ; B 76 -250 650 580 ;
C -1 ; WX 600 ; N Ohungarumlaut ; B 94 -18 751 805 ;
C -1 ; WX 600 ; N degree ; B 214 269 576 622 ;
C -1 ; WX 600 ; N ograve ; B 102 -15 588 672 ;
C -1 ; WX 600 ; N Ccaron ; B 93 -18 672 802 ;
C -1 ; WX 600 ; N ugrave ; B 101 -15 572 672 ;
C -1 ; WX 600 ; N radical ; B 85 -15 765 792 ;
C -1 ; WX 600 ; N Dcaron ; B 43 0 645 802 ;
C -1 ; WX 600 ; N rcommaaccent ; B 60 -250 636 441 ;
C -1 ; WX 600 ; N Ntilde ; B 7 -13 712 729 ;
C -1 ; WX 600 ; N otilde ; B 102 -15 629 606 ;
C -1 ; WX 600 ; N Rcommaaccent ; B 38 -250 598 562 ;
C -1 ; WX 600 ; N Lcommaaccent ; B 47 -250 607 562 ;
C -1 ; WX 600 ; N Atilde ; B 3 0 655 729 ;
C -1 ; WX 600 ; N Aogonek ; B 3 -172 607 562 ;
C -1 ; WX 600 ; N Aring ; B 3 0 607 750 ;
C -1 ; WX 600 ; N Otilde ; B 94 -18 655 729 ;
C -1 ; WX 600 ; N zdotaccent ; B 99 0 593 620 ;
C -1 ; WX 600 ; N Ecaron ; B 53 0 660 802 ;
C -1 ; WX 600 ; N Iogonek ; B 96 -172 623 562 ;
C -1 ; WX 600 ; N kcommaaccent ; B 58 -250 633 629 ;
C -1 ; WX 600 ; N minus ; B 129 232 580 283 ;
C -1 ; WX 600 ; N Icircumflex ; B 96 0 623 787 ;
C -1 ; WX 600 ; N ncaron ; B 26 0 614 669 ;
C -1 ; WX 600 ; N tcommaaccent ; B 165 -250 561 561 ;
C -1 ; WX 600 ; N logicalnot ; B 155 108 591 369 ;
C -1 ; WX 600 ; N odieresis ; B 102 -15 588 620 ;
C -1 ; WX 600 ; N udieresis ; B 101 -15 575 620 ;
C -1 ; WX 600 ; N notequal ; B 43 -16 621 529 ;
C -1 ; WX 600 ; N gcommaaccent ; B 61 -157 657 708 ;
C -1 ; WX 600 ; N eth ; B 102 -15 639 629 ;
C -1 ; WX 600 ; N zcaron ; B 99 0 624 669 ;
C -1 ; WX 600 ; N ncommaaccent ; B 26 -250 585 441 ;
C -1 ; WX 600 ; N onesuperior ; B 231 249 491 622 ;
C -1 ; WX 600 ; N imacron ; B 95 0 543 565 ;
C -1 ; WX 600 ; N Euro ; B 0 0 0 0 ;
EndCharMetrics
EndFontMetrics"

let courier_bold_afm = "StartFontMetrics 4.1
Comment Copyright (c) 1989, 1990, 1991, 1993, 1997 Adobe Systems Incorporated.  All Rights Reserved.
Comment Creation Date: Mon Jun 23 16:28:00 1997
Comment UniqueID 43048
Comment VMusage 41139 52164
FontName Courier-Bold
FullName Courier Bold
FamilyName Courier
Weight Bold
ItalicAngle 0
IsFixedPitch true
CharacterSet ExtendedRoman
FontBBox -113 -250 749 801 
UnderlinePosition -100
UnderlineThickness 50
Version 003.000
Notice Copyright (c) 1989, 1990, 1991, 1993, 1997 Adobe Systems Incorporated.  All Rights Reserved.
EncodingScheme AdobeStandardEncoding
CapHeight 562
XHeight 439
Ascender 629
Descender -157
StdHW 84
StdVW 106
StartCharMetrics 315
C 32 ; WX 600 ; N space ; B 0 0 0 0 ;
C 33 ; WX 600 ; N exclam ; B 202 -15 398 572 ;
C 34 ; WX 600 ; N quotedbl ; B 135 277 465 562 ;
C 35 ; WX 600 ; N numbersign ; B 56 -45 544 651 ;
C 36 ; WX 600 ; N dollar ; B 82 -126 519 666 ;
C 37 ; WX 600 ; N percent ; B 5 -15 595 616 ;
C 38 ; WX 600 ; N ampersand ; B 36 -15 546 543 ;
C 39 ; WX 600 ; N quoteright ; B 171 277 423 562 ;
C 40 ; WX 600 ; N parenleft ; B 219 -102 461 616 ;
C 41 ; WX 600 ; N parenright ; B 139 -102 381 616 ;
C 42 ; WX 600 ; N asterisk ; B 91 219 509 601 ;
C 43 ; WX 600 ; N plus ; B 71 39 529 478 ;
C 44 ; WX 600 ; N comma ; B 123 -111 393 174 ;
C 45 ; WX 600 ; N hyphen ; B 100 203 500 313 ;
C 46 ; WX 600 ; N period ; B 192 -15 408 171 ;
C 47 ; WX 600 ; N slash ; B 98 -77 502 626 ;
C 48 ; WX 600 ; N zero ; B 87 -15 513 616 ;
C 49 ; WX 600 ; N one ; B 81 0 539 616 ;
C 50 ; WX 600 ; N two ; B 61 0 499 616 ;
C 51 ; WX 600 ; N three ; B 63 -15 501 616 ;
C 52 ; WX 600 ; N four ; B 53 0 507 616 ;
C 53 ; WX 600 ; N five ; B 70 -15 521 601 ;
C 54 ; WX 600 ; N six ; B 90 -15 521 616 ;
C 55 ; WX 600 ; N seven ; B 55 0 494 601 ;
C 56 ; WX 600 ; N eight ; B 83 -15 517 616 ;
C 57 ; WX 600 ; N nine ; B 79 -15 510 616 ;
C 58 ; WX 600 ; N colon ; B 191 -15 407 425 ;
C 59 ; WX 600 ; N semicolon ; B 123 -111 408 425 ;
C 60 ; WX 600 ; N less ; B 66 15 523 501 ;
C 61 ; WX 600 ; N equal ; B 71 118 529 398 ;
C 62 ; WX 600 ; N greater ; B 77 15 534 501 ;
C 63 ; WX 600 ; N question ; B 98 -14 501 580 ;
C 64 ; WX 600 ; N at ; B 16 -15 584 616 ;
C 65 ; WX 600 ; N A ; B -9 0 609 562 ;
C 66 ; WX 600 ; N B ; B 30 0 573 562 ;
C 67 ; WX 600 ; N C ; B 22 -18 560 580 ;
C 68 ; WX 600 ; N D ; B 30 0 594 562 ;
C 69 ; WX 600 ; N E ; B 25 0 560 562 ;
C 70 ; WX 600 ; N F ; B 39 0 570 562 ;
C 71 ; WX 600 ; N G ; B 22 -18 594 580 ;
C 72 ; WX 600 ; N H ; B 20 0 580 562 ;
C 73 ; WX 600 ; N I ; B 77 0 523 562 ;
C 74 ; WX 600 ; N J ; B 37 -18 601 562 ;
C 75 ; WX 600 ; N K ; B 21 0 599 562 ;
C 76 ; WX 600 ; N L ; B 39 0 578 562 ;
C 77 ; WX 600 ; N M ; B -2 0 602 562 ;
C 78 ; WX 600 ; N N ; B 8 -12 610 562 ;
C 79 ; WX 600 ; N O ; B 22 -18 578 580 ;
C 80 ; WX 600 ; N P ; B 48 0 559 562 ;
C 81 ; WX 600 ; N Q ; B 32 -138 578 580 ;
C 82 ; WX 600 ; N R ; B 24 0 599 562 ;
C 83 ; WX 600 ; N S ; B 47 -22 553 582 ;
C 84 ; WX 600 ; N T ; B 21 0 579 562 ;
C 85 ; WX 600 ; N U ; B 4 -18 596 562 ;
C 86 ; WX 600 ; N V ; B -13 0 613 562 ;
C 87 ; WX 600 ; N W ; B -18 0 618 562 ;
C 88 ; WX 600 ; N X ; B 12 0 588 562 ;
C 89 ; WX 600 ; N Y ; B 12 0 589 562 ;
C 90 ; WX 600 ; N Z ; B 62 0 539 562 ;
C 91 ; WX 600 ; N bracketleft ; B 245 -102 475 616 ;
C 92 ; WX 600 ; N backslash ; B 99 -77 503 626 ;
C 93 ; WX 600 ; N bracketright ; B 125 -102 355 616 ;
C 94 ; WX 600 ; N asciicircum ; B 108 250 492 616 ;
C 95 ; WX 600 ; N underscore ; B 0 -125 600 -75 ;
C 96 ; WX 600 ; N quoteleft ; B 178 277 428 562 ;
C 97 ; WX 600 ; N a ; B 35 -15 570 454 ;
C 98 ; WX 600 ; N b ; B 0 -15 584 626 ;
C 99 ; WX 600 ; N c ; B 40 -15 545 459 ;
C 100 ; WX 600 ; N d ; B 20 -15 591 626 ;
C 101 ; WX 600 ; N e ; B 40 -15 563 454 ;
C 102 ; WX 600 ; N f ; B 83 0 547 626 ; L i fi ; L l fl ;
C 103 ; WX 600 ; N g ; B 30 -146 580 454 ;
C 104 ; WX 600 ; N h ; B 5 0 592 626 ;
C 105 ; WX 600 ; N i ; B 77 0 523 658 ;
C 106 ; WX 600 ; N j ; B 63 -146 440 658 ;
C 107 ; WX 600 ; N k ; B 20 0 585 626 ;
C 108 ; WX 600 ; N l ; B 77 0 523 626 ;
C 109 ; WX 600 ; N m ; B -22 0 626 454 ;
C 110 ; WX 600 ; N n ; B 18 0 592 454 ;
C 111 ; WX 600 ; N o ; B 30 -15 570 454 ;
C 112 ; WX 600 ; N p ; B -1 -142 570 454 ;
C 113 ; WX 600 ; N q ; B 20 -142 591 454 ;
C 114 ; WX 600 ; N r ; B 47 0 580 454 ;
C 115 ; WX 600 ; N s ; B 68 -17 535 459 ;
C 116 ; WX 600 ; N t ; B 47 -15 532 562 ;
C 117 ; WX 600 ; N u ; B -1 -15 569 439 ;
C 118 ; WX 600 ; N v ; B -1 0 601 439 ;
C 119 ; WX 600 ; N w ; B -18 0 618 439 ;
C 120 ; WX 600 ; N x ; B 6 0 594 439 ;
C 121 ; WX 600 ; N y ; B -4 -142 601 439 ;
C 122 ; WX 600 ; N z ; B 81 0 520 439 ;
C 123 ; WX 600 ; N braceleft ; B 160 -102 464 616 ;
C 124 ; WX 600 ; N bar ; B 255 -250 345 750 ;
C 125 ; WX 600 ; N braceright ; B 136 -102 440 616 ;
C 126 ; WX 600 ; N asciitilde ; B 71 153 530 356 ;
C 161 ; WX 600 ; N exclamdown ; B 202 -146 398 449 ;
C 162 ; WX 600 ; N cent ; B 66 -49 518 614 ;
C 163 ; WX 600 ; N sterling ; B 72 -28 558 611 ;
C 164 ; WX 600 ; N fraction ; B 25 -60 576 661 ;
C 165 ; WX 600 ; N yen ; B 10 0 590 562 ;
C 166 ; WX 600 ; N florin ; B -30 -131 572 616 ;
C 167 ; WX 600 ; N section ; B 83 -70 517 580 ;
C 168 ; WX 600 ; N currency ; B 54 49 546 517 ;
C 169 ; WX 600 ; N quotesingle ; B 227 277 373 562 ;
C 170 ; WX 600 ; N quotedblleft ; B 71 277 535 562 ;
C 171 ; WX 600 ; N guillemotleft ; B 8 70 553 446 ;
C 172 ; WX 600 ; N guilsinglleft ; B 141 70 459 446 ;
C 173 ; WX 600 ; N guilsinglright ; B 141 70 459 446 ;
C 174 ; WX 600 ; N fi ; B 12 0 593 626 ;
C 175 ; WX 600 ; N fl ; B 12 0 593 626 ;
C 177 ; WX 600 ; N endash ; B 65 203 535 313 ;
C 178 ; WX 600 ; N dagger ; B 106 -70 494 580 ;
C 179 ; WX 600 ; N daggerdbl ; B 106 -70 494 580 ;
C 180 ; WX 600 ; N periodcentered ; B 196 165 404 351 ;
C 182 ; WX 600 ; N paragraph ; B 6 -70 576 580 ;
C 183 ; WX 600 ; N bullet ; B 140 132 460 430 ;
C 184 ; WX 600 ; N quotesinglbase ; B 175 -142 427 143 ;
C 185 ; WX 600 ; N quotedblbase ; B 65 -142 529 143 ;
C 186 ; WX 600 ; N quotedblright ; B 61 277 525 562 ;
C 187 ; WX 600 ; N guillemotright ; B 47 70 592 446 ;
C 188 ; WX 600 ; N ellipsis ; B 26 -15 574 116 ;
C 189 ; WX 600 ; N perthousand ; B -113 -15 713 616 ;
C 191 ; WX 600 ; N questiondown ; B 99 -146 502 449 ;
C 193 ; WX 600 ; N grave ; B 132 508 395 661 ;
C 194 ; WX 600 ; N acute ; B 205 508 468 661 ;
C 195 ; WX 600 ; N circumflex ; B 103 483 497 657 ;
C 196 ; WX 600 ; N tilde ; B 89 493 512 636 ;
C 197 ; WX 600 ; N macron ; B 88 505 512 585 ;
C 198 ; WX 600 ; N breve ; B 83 468 517 631 ;
C 199 ; WX 600 ; N dotaccent ; B 230 498 370 638 ;
C 200 ; WX 600 ; N dieresis ; B 128 498 472 638 ;
C 202 ; WX 600 ; N ring ; B 198 481 402 678 ;
C 203 ; WX 600 ; N cedilla ; B 205 -206 387 0 ;
C 205 ; WX 600 ; N hungarumlaut ; B 68 488 588 661 ;
C 206 ; WX 600 ; N ogonek ; B 169 -199 400 0 ;
C 207 ; WX 600 ; N caron ; B 103 493 497 667 ;
C 208 ; WX 600 ; N emdash ; B -10 203 610 313 ;
C 225 ; WX 600 ; N AE ; B -29 0 602 562 ;
C 227 ; WX 600 ; N ordfeminine ; B 147 196 453 580 ;
C 232 ; WX 600 ; N Lslash ; B 39 0 578 562 ;
C 233 ; WX 600 ; N Oslash ; B 22 -22 578 584 ;
C 234 ; WX 600 ; N OE ; B -25 0 595 562 ;
C 235 ; WX 600 ; N ordmasculine ; B 147 196 453 580 ;
C 241 ; WX 600 ; N ae ; B -4 -15 601 454 ;
C 245 ; WX 600 ; N dotlessi ; B 77 0 523 439 ;
C 248 ; WX 600 ; N lslash ; B 77 0 523 626 ;
C 249 ; WX 600 ; N oslash ; B 30 -24 570 463 ;
C 250 ; WX 600 ; N oe ; B -18 -15 611 454 ;
C 251 ; WX 600 ; N germandbls ; B 22 -15 596 626 ;
C -1 ; WX 600 ; N Idieresis ; B 77 0 523 761 ;
C -1 ; WX 600 ; N eacute ; B 40 -15 563 661 ;
C -1 ; WX 600 ; N abreve ; B 35 -15 570 661 ;
C -1 ; WX 600 ; N uhungarumlaut ; B -1 -15 628 661 ;
C -1 ; WX 600 ; N ecaron ; B 40 -15 563 667 ;
C -1 ; WX 600 ; N Ydieresis ; B 12 0 589 761 ;
C -1 ; WX 600 ; N divide ; B 71 16 529 500 ;
C -1 ; WX 600 ; N Yacute ; B 12 0 589 784 ;
C -1 ; WX 600 ; N Acircumflex ; B -9 0 609 780 ;
C -1 ; WX 600 ; N aacute ; B 35 -15 570 661 ;
C -1 ; WX 600 ; N Ucircumflex ; B 4 -18 596 780 ;
C -1 ; WX 600 ; N yacute ; B -4 -142 601 661 ;
C -1 ; WX 600 ; N scommaaccent ; B 68 -250 535 459 ;
C -1 ; WX 600 ; N ecircumflex ; B 40 -15 563 657 ;
C -1 ; WX 600 ; N Uring ; B 4 -18 596 801 ;
C -1 ; WX 600 ; N Udieresis ; B 4 -18 596 761 ;
C -1 ; WX 600 ; N aogonek ; B 35 -199 586 454 ;
C -1 ; WX 600 ; N Uacute ; B 4 -18 596 784 ;
C -1 ; WX 600 ; N uogonek ; B -1 -199 585 439 ;
C -1 ; WX 600 ; N Edieresis ; B 25 0 560 761 ;
C -1 ; WX 600 ; N Dcroat ; B 30 0 594 562 ;
C -1 ; WX 600 ; N commaaccent ; B 205 -250 397 -57 ;
C -1 ; WX 600 ; N copyright ; B 0 -18 600 580 ;
C -1 ; WX 600 ; N Emacron ; B 25 0 560 708 ;
C -1 ; WX 600 ; N ccaron ; B 40 -15 545 667 ;
C -1 ; WX 600 ; N aring ; B 35 -15 570 678 ;
C -1 ; WX 600 ; N Ncommaaccent ; B 8 -250 610 562 ;
C -1 ; WX 600 ; N lacute ; B 77 0 523 801 ;
C -1 ; WX 600 ; N agrave ; B 35 -15 570 661 ;
C -1 ; WX 600 ; N Tcommaaccent ; B 21 -250 579 562 ;
C -1 ; WX 600 ; N Cacute ; B 22 -18 560 784 ;
C -1 ; WX 600 ; N atilde ; B 35 -15 570 636 ;
C -1 ; WX 600 ; N Edotaccent ; B 25 0 560 761 ;
C -1 ; WX 600 ; N scaron ; B 68 -17 535 667 ;
C -1 ; WX 600 ; N scedilla ; B 68 -206 535 459 ;
C -1 ; WX 600 ; N iacute ; B 77 0 523 661 ;
C -1 ; WX 600 ; N lozenge ; B 66 0 534 740 ;
C -1 ; WX 600 ; N Rcaron ; B 24 0 599 790 ;
C -1 ; WX 600 ; N Gcommaaccent ; B 22 -250 594 580 ;
C -1 ; WX 600 ; N ucircumflex ; B -1 -15 569 657 ;
C -1 ; WX 600 ; N acircumflex ; B 35 -15 570 657 ;
C -1 ; WX 600 ; N Amacron ; B -9 0 609 708 ;
C -1 ; WX 600 ; N rcaron ; B 47 0 580 667 ;
C -1 ; WX 600 ; N ccedilla ; B 40 -206 545 459 ;
C -1 ; WX 600 ; N Zdotaccent ; B 62 0 539 761 ;
C -1 ; WX 600 ; N Thorn ; B 48 0 557 562 ;
C -1 ; WX 600 ; N Omacron ; B 22 -18 578 708 ;
C -1 ; WX 600 ; N Racute ; B 24 0 599 784 ;
C -1 ; WX 600 ; N Sacute ; B 47 -22 553 784 ;
C -1 ; WX 600 ; N dcaron ; B 20 -15 727 626 ;
C -1 ; WX 600 ; N Umacron ; B 4 -18 596 708 ;
C -1 ; WX 600 ; N uring ; B -1 -15 569 678 ;
C -1 ; WX 600 ; N threesuperior ; B 138 222 433 616 ;
C -1 ; WX 600 ; N Ograve ; B 22 -18 578 784 ;
C -1 ; WX 600 ; N Agrave ; B -9 0 609 784 ;
C -1 ; WX 600 ; N Abreve ; B -9 0 609 784 ;
C -1 ; WX 600 ; N multiply ; B 81 39 520 478 ;
C -1 ; WX 600 ; N uacute ; B -1 -15 569 661 ;
C -1 ; WX 600 ; N Tcaron ; B 21 0 579 790 ;
C -1 ; WX 600 ; N partialdiff ; B 63 -38 537 728 ;
C -1 ; WX 600 ; N ydieresis ; B -4 -142 601 638 ;
C -1 ; WX 600 ; N Nacute ; B 8 -12 610 784 ;
C -1 ; WX 600 ; N icircumflex ; B 73 0 523 657 ;
C -1 ; WX 600 ; N Ecircumflex ; B 25 0 560 780 ;
C -1 ; WX 600 ; N adieresis ; B 35 -15 570 638 ;
C -1 ; WX 600 ; N edieresis ; B 40 -15 563 638 ;
C -1 ; WX 600 ; N cacute ; B 40 -15 545 661 ;
C -1 ; WX 600 ; N nacute ; B 18 0 592 661 ;
C -1 ; WX 600 ; N umacron ; B -1 -15 569 585 ;
C -1 ; WX 600 ; N Ncaron ; B 8 -12 610 790 ;
C -1 ; WX 600 ; N Iacute ; B 77 0 523 784 ;
C -1 ; WX 600 ; N plusminus ; B 71 24 529 515 ;
C -1 ; WX 600 ; N brokenbar ; B 255 -175 345 675 ;
C -1 ; WX 600 ; N registered ; B 0 -18 600 580 ;
C -1 ; WX 600 ; N Gbreve ; B 22 -18 594 784 ;
C -1 ; WX 600 ; N Idotaccent ; B 77 0 523 761 ;
C -1 ; WX 600 ; N summation ; B 15 -10 586 706 ;
C -1 ; WX 600 ; N Egrave ; B 25 0 560 784 ;
C -1 ; WX 600 ; N racute ; B 47 0 580 661 ;
C -1 ; WX 600 ; N omacron ; B 30 -15 570 585 ;
C -1 ; WX 600 ; N Zacute ; B 62 0 539 784 ;
C -1 ; WX 600 ; N Zcaron ; B 62 0 539 790 ;
C -1 ; WX 600 ; N greaterequal ; B 26 0 523 696 ;
C -1 ; WX 600 ; N Eth ; B 30 0 594 562 ;
C -1 ; WX 600 ; N Ccedilla ; B 22 -206 560 580 ;
C -1 ; WX 600 ; N lcommaaccent ; B 77 -250 523 626 ;
C -1 ; WX 600 ; N tcaron ; B 47 -15 532 703 ;
C -1 ; WX 600 ; N eogonek ; B 40 -199 563 454 ;
C -1 ; WX 600 ; N Uogonek ; B 4 -199 596 562 ;
C -1 ; WX 600 ; N Aacute ; B -9 0 609 784 ;
C -1 ; WX 600 ; N Adieresis ; B -9 0 609 761 ;
C -1 ; WX 600 ; N egrave ; B 40 -15 563 661 ;
C -1 ; WX 600 ; N zacute ; B 81 0 520 661 ;
C -1 ; WX 600 ; N iogonek ; B 77 -199 523 658 ;
C -1 ; WX 600 ; N Oacute ; B 22 -18 578 784 ;
C -1 ; WX 600 ; N oacute ; B 30 -15 570 661 ;
C -1 ; WX 600 ; N amacron ; B 35 -15 570 585 ;
C -1 ; WX 600 ; N sacute ; B 68 -17 535 661 ;
C -1 ; WX 600 ; N idieresis ; B 77 0 523 618 ;
C -1 ; WX 600 ; N Ocircumflex ; B 22 -18 578 780 ;
C -1 ; WX 600 ; N Ugrave ; B 4 -18 596 784 ;
C -1 ; WX 600 ; N Delta ; B 6 0 594 688 ;
C -1 ; WX 600 ; N thorn ; B -14 -142 570 626 ;
C -1 ; WX 600 ; N twosuperior ; B 143 230 436 616 ;
C -1 ; WX 600 ; N Odieresis ; B 22 -18 578 761 ;
C -1 ; WX 600 ; N mu ; B -1 -142 569 439 ;
C -1 ; WX 600 ; N igrave ; B 77 0 523 661 ;
C -1 ; WX 600 ; N ohungarumlaut ; B 30 -15 668 661 ;
C -1 ; WX 600 ; N Eogonek ; B 25 -199 576 562 ;
C -1 ; WX 600 ; N dcroat ; B 20 -15 591 626 ;
C -1 ; WX 600 ; N threequarters ; B -47 -60 648 661 ;
C -1 ; WX 600 ; N Scedilla ; B 47 -206 553 582 ;
C -1 ; WX 600 ; N lcaron ; B 77 0 597 626 ;
C -1 ; WX 600 ; N Kcommaaccent ; B 21 -250 599 562 ;
C -1 ; WX 600 ; N Lacute ; B 39 0 578 784 ;
C -1 ; WX 600 ; N trademark ; B -9 230 749 562 ;
C -1 ; WX 600 ; N edotaccent ; B 40 -15 563 638 ;
C -1 ; WX 600 ; N Igrave ; B 77 0 523 784 ;
C -1 ; WX 600 ; N Imacron ; B 77 0 523 708 ;
C -1 ; WX 600 ; N Lcaron ; B 39 0 637 562 ;
C -1 ; WX 600 ; N onehalf ; B -47 -60 648 661 ;
C -1 ; WX 600 ; N lessequal ; B 26 0 523 696 ;
C -1 ; WX 600 ; N ocircumflex ; B 30 -15 570 657 ;
C -1 ; WX 600 ; N ntilde ; B 18 0 592 636 ;
C -1 ; WX 600 ; N Uhungarumlaut ; B 4 -18 638 784 ;
C -1 ; WX 600 ; N Eacute ; B 25 0 560 784 ;
C -1 ; WX 600 ; N emacron ; B 40 -15 563 585 ;
C -1 ; WX 600 ; N gbreve ; B 30 -146 580 661 ;
C -1 ; WX 600 ; N onequarter ; B -56 -60 656 661 ;
C -1 ; WX 600 ; N Scaron ; B 47 -22 553 790 ;
C -1 ; WX 600 ; N Scommaaccent ; B 47 -250 553 582 ;
C -1 ; WX 600 ; N Ohungarumlaut ; B 22 -18 628 784 ;
C -1 ; WX 600 ; N degree ; B 86 243 474 616 ;
C -1 ; WX 600 ; N ograve ; B 30 -15 570 661 ;
C -1 ; WX 600 ; N Ccaron ; B 22 -18 560 790 ;
C -1 ; WX 600 ; N ugrave ; B -1 -15 569 661 ;
C -1 ; WX 600 ; N radical ; B -19 -104 473 778 ;
C -1 ; WX 600 ; N Dcaron ; B 30 0 594 790 ;
C -1 ; WX 600 ; N rcommaaccent ; B 47 -250 580 454 ;
C -1 ; WX 600 ; N Ntilde ; B 8 -12 610 759 ;
C -1 ; WX 600 ; N otilde ; B 30 -15 570 636 ;
C -1 ; WX 600 ; N Rcommaaccent ; B 24 -250 599 562 ;
C -1 ; WX 600 ; N Lcommaaccent ; B 39 -250 578 562 ;
C -1 ; WX 600 ; N Atilde ; B -9 0 609 759 ;
C -1 ; WX 600 ; N Aogonek ; B -9 -199 625 562 ;
C -1 ; WX 600 ; N Aring ; B -9 0 609 801 ;
C -1 ; WX 600 ; N Otilde ; B 22 -18 578 759 ;
C -1 ; WX 600 ; N zdotaccent ; B 81 0 520 638 ;
C -1 ; WX 600 ; N Ecaron ; B 25 0 560 790 ;
C -1 ; WX 600 ; N Iogonek ; B 77 -199 523 562 ;
C -1 ; WX 600 ; N kcommaaccent ; B 20 -250 585 626 ;
C -1 ; WX 600 ; N minus ; B 71 203 529 313 ;
C -1 ; WX 600 ; N Icircumflex ; B 77 0 523 780 ;
C -1 ; WX 600 ; N ncaron ; B 18 0 592 667 ;
C -1 ; WX 600 ; N tcommaaccent ; B 47 -250 532 562 ;
C -1 ; WX 600 ; N logicalnot ; B 71 103 529 413 ;
C -1 ; WX 600 ; N odieresis ; B 30 -15 570 638 ;
C -1 ; WX 600 ; N udieresis ; B -1 -15 569 638 ;
C -1 ; WX 600 ; N notequal ; B 12 -47 537 563 ;
C -1 ; WX 600 ; N gcommaaccent ; B 30 -146 580 714 ;
C -1 ; WX 600 ; N eth ; B 58 -27 543 626 ;
C -1 ; WX 600 ; N zcaron ; B 81 0 520 667 ;
C -1 ; WX 600 ; N ncommaaccent ; B 18 -250 592 454 ;
C -1 ; WX 600 ; N onesuperior ; B 153 230 447 616 ;
C -1 ; WX 600 ; N imacron ; B 77 0 523 585 ;
C -1 ; WX 600 ; N Euro ; B 0 0 0 0 ;
EndCharMetrics
EndFontMetrics"

let courier_bold_oblique_afm = "StartFontMetrics 4.1
Comment Copyright (c) 1989, 1990, 1991, 1993, 1997 Adobe Systems Incorporated.  All Rights Reserved.
Comment Creation Date: Mon Jun 23 16:28:46 1997
Comment UniqueID 43049
Comment VMusage 17529 79244
FontName Courier-BoldOblique
FullName Courier Bold Oblique
FamilyName Courier
Weight Bold
ItalicAngle -12
IsFixedPitch true
CharacterSet ExtendedRoman
FontBBox -57 -250 869 801 
UnderlinePosition -100
UnderlineThickness 50
Version 003.000
Notice Copyright (c) 1989, 1990, 1991, 1993, 1997 Adobe Systems Incorporated.  All Rights Reserved.
EncodingScheme AdobeStandardEncoding
CapHeight 562
XHeight 439
Ascender 629
Descender -157
StdHW 84
StdVW 106
StartCharMetrics 315
C 32 ; WX 600 ; N space ; B 0 0 0 0 ;
C 33 ; WX 600 ; N exclam ; B 215 -15 495 572 ;
C 34 ; WX 600 ; N quotedbl ; B 211 277 585 562 ;
C 35 ; WX 600 ; N numbersign ; B 88 -45 641 651 ;
C 36 ; WX 600 ; N dollar ; B 87 -126 630 666 ;
C 37 ; WX 600 ; N percent ; B 101 -15 625 616 ;
C 38 ; WX 600 ; N ampersand ; B 61 -15 595 543 ;
C 39 ; WX 600 ; N quoteright ; B 229 277 543 562 ;
C 40 ; WX 600 ; N parenleft ; B 265 -102 592 616 ;
C 41 ; WX 600 ; N parenright ; B 117 -102 444 616 ;
C 42 ; WX 600 ; N asterisk ; B 179 219 598 601 ;
C 43 ; WX 600 ; N plus ; B 114 39 596 478 ;
C 44 ; WX 600 ; N comma ; B 99 -111 430 174 ;
C 45 ; WX 600 ; N hyphen ; B 143 203 567 313 ;
C 46 ; WX 600 ; N period ; B 206 -15 427 171 ;
C 47 ; WX 600 ; N slash ; B 90 -77 626 626 ;
C 48 ; WX 600 ; N zero ; B 135 -15 593 616 ;
C 49 ; WX 600 ; N one ; B 93 0 562 616 ;
C 50 ; WX 600 ; N two ; B 61 0 594 616 ;
C 51 ; WX 600 ; N three ; B 71 -15 571 616 ;
C 52 ; WX 600 ; N four ; B 81 0 559 616 ;
C 53 ; WX 600 ; N five ; B 77 -15 621 601 ;
C 54 ; WX 600 ; N six ; B 135 -15 652 616 ;
C 55 ; WX 600 ; N seven ; B 147 0 622 601 ;
C 56 ; WX 600 ; N eight ; B 115 -15 604 616 ;
C 57 ; WX 600 ; N nine ; B 75 -15 592 616 ;
C 58 ; WX 600 ; N colon ; B 205 -15 480 425 ;
C 59 ; WX 600 ; N semicolon ; B 99 -111 481 425 ;
C 60 ; WX 600 ; N less ; B 120 15 613 501 ;
C 61 ; WX 600 ; N equal ; B 96 118 614 398 ;
C 62 ; WX 600 ; N greater ; B 97 15 589 501 ;
C 63 ; WX 600 ; N question ; B 183 -14 592 580 ;
C 64 ; WX 600 ; N at ; B 65 -15 642 616 ;
C 65 ; WX 600 ; N A ; B -9 0 632 562 ;
C 66 ; WX 600 ; N B ; B 30 0 630 562 ;
C 67 ; WX 600 ; N C ; B 74 -18 675 580 ;
C 68 ; WX 600 ; N D ; B 30 0 664 562 ;
C 69 ; WX 600 ; N E ; B 25 0 670 562 ;
C 70 ; WX 600 ; N F ; B 39 0 684 562 ;
C 71 ; WX 600 ; N G ; B 74 -18 675 580 ;
C 72 ; WX 600 ; N H ; B 20 0 700 562 ;
C 73 ; WX 600 ; N I ; B 77 0 643 562 ;
C 74 ; WX 600 ; N J ; B 58 -18 721 562 ;
C 75 ; WX 600 ; N K ; B 21 0 692 562 ;
C 76 ; WX 600 ; N L ; B 39 0 636 562 ;
C 77 ; WX 600 ; N M ; B -2 0 722 562 ;
C 78 ; WX 600 ; N N ; B 8 -12 730 562 ;
C 79 ; WX 600 ; N O ; B 74 -18 645 580 ;
C 80 ; WX 600 ; N P ; B 48 0 643 562 ;
C 81 ; WX 600 ; N Q ; B 83 -138 636 580 ;
C 82 ; WX 600 ; N R ; B 24 0 617 562 ;
C 83 ; WX 600 ; N S ; B 54 -22 673 582 ;
C 84 ; WX 600 ; N T ; B 86 0 679 562 ;
C 85 ; WX 600 ; N U ; B 101 -18 716 562 ;
C 86 ; WX 600 ; N V ; B 84 0 733 562 ;
C 87 ; WX 600 ; N W ; B 79 0 738 562 ;
C 88 ; WX 600 ; N X ; B 12 0 690 562 ;
C 89 ; WX 600 ; N Y ; B 109 0 709 562 ;
C 90 ; WX 600 ; N Z ; B 62 0 637 562 ;
C 91 ; WX 600 ; N bracketleft ; B 223 -102 606 616 ;
C 92 ; WX 600 ; N backslash ; B 222 -77 496 626 ;
C 93 ; WX 600 ; N bracketright ; B 103 -102 486 616 ;
C 94 ; WX 600 ; N asciicircum ; B 171 250 556 616 ;
C 95 ; WX 600 ; N underscore ; B -27 -125 585 -75 ;
C 96 ; WX 600 ; N quoteleft ; B 297 277 487 562 ;
C 97 ; WX 600 ; N a ; B 61 -15 593 454 ;
C 98 ; WX 600 ; N b ; B 13 -15 636 626 ;
C 99 ; WX 600 ; N c ; B 81 -15 631 459 ;
C 100 ; WX 600 ; N d ; B 60 -15 645 626 ;
C 101 ; WX 600 ; N e ; B 81 -15 605 454 ;
C 102 ; WX 600 ; N f ; B 83 0 677 626 ; L i fi ; L l fl ;
C 103 ; WX 600 ; N g ; B 40 -146 674 454 ;
C 104 ; WX 600 ; N h ; B 18 0 615 626 ;
C 105 ; WX 600 ; N i ; B 77 0 546 658 ;
C 106 ; WX 600 ; N j ; B 36 -146 580 658 ;
C 107 ; WX 600 ; N k ; B 33 0 643 626 ;
C 108 ; WX 600 ; N l ; B 77 0 546 626 ;
C 109 ; WX 600 ; N m ; B -22 0 649 454 ;
C 110 ; WX 600 ; N n ; B 18 0 615 454 ;
C 111 ; WX 600 ; N o ; B 71 -15 622 454 ;
C 112 ; WX 600 ; N p ; B -32 -142 622 454 ;
C 113 ; WX 600 ; N q ; B 60 -142 685 454 ;
C 114 ; WX 600 ; N r ; B 47 0 655 454 ;
C 115 ; WX 600 ; N s ; B 66 -17 608 459 ;
C 116 ; WX 600 ; N t ; B 118 -15 567 562 ;
C 117 ; WX 600 ; N u ; B 70 -15 592 439 ;
C 118 ; WX 600 ; N v ; B 70 0 695 439 ;
C 119 ; WX 600 ; N w ; B 53 0 712 439 ;
C 120 ; WX 600 ; N x ; B 6 0 671 439 ;
C 121 ; WX 600 ; N y ; B -21 -142 695 439 ;
C 122 ; WX 600 ; N z ; B 81 0 614 439 ;
C 123 ; WX 600 ; N braceleft ; B 203 -102 595 616 ;
C 124 ; WX 600 ; N bar ; B 201 -250 505 750 ;
C 125 ; WX 600 ; N braceright ; B 114 -102 506 616 ;
C 126 ; WX 600 ; N asciitilde ; B 120 153 590 356 ;
C 161 ; WX 600 ; N exclamdown ; B 196 -146 477 449 ;
C 162 ; WX 600 ; N cent ; B 121 -49 605 614 ;
C 163 ; WX 600 ; N sterling ; B 106 -28 650 611 ;
C 164 ; WX 600 ; N fraction ; B 22 -60 708 661 ;
C 165 ; WX 600 ; N yen ; B 98 0 710 562 ;
C 166 ; WX 600 ; N florin ; B -57 -131 702 616 ;
C 167 ; WX 600 ; N section ; B 74 -70 620 580 ;
C 168 ; WX 600 ; N currency ; B 77 49 644 517 ;
C 169 ; WX 600 ; N quotesingle ; B 303 277 493 562 ;
C 170 ; WX 600 ; N quotedblleft ; B 190 277 594 562 ;
C 171 ; WX 600 ; N guillemotleft ; B 62 70 639 446 ;
C 172 ; WX 600 ; N guilsinglleft ; B 195 70 545 446 ;
C 173 ; WX 600 ; N guilsinglright ; B 165 70 514 446 ;
C 174 ; WX 600 ; N fi ; B 12 0 644 626 ;
C 175 ; WX 600 ; N fl ; B 12 0 644 626 ;
C 177 ; WX 600 ; N endash ; B 108 203 602 313 ;
C 178 ; WX 600 ; N dagger ; B 175 -70 586 580 ;
C 179 ; WX 600 ; N daggerdbl ; B 121 -70 587 580 ;
C 180 ; WX 600 ; N periodcentered ; B 248 165 461 351 ;
C 182 ; WX 600 ; N paragraph ; B 61 -70 700 580 ;
C 183 ; WX 600 ; N bullet ; B 196 132 523 430 ;
C 184 ; WX 600 ; N quotesinglbase ; B 144 -142 458 143 ;
C 185 ; WX 600 ; N quotedblbase ; B 34 -142 560 143 ;
C 186 ; WX 600 ; N quotedblright ; B 119 277 645 562 ;
C 187 ; WX 600 ; N guillemotright ; B 71 70 647 446 ;
C 188 ; WX 600 ; N ellipsis ; B 35 -15 587 116 ;
C 189 ; WX 600 ; N perthousand ; B -45 -15 743 616 ;
C 191 ; WX 600 ; N questiondown ; B 100 -146 509 449 ;
C 193 ; WX 600 ; N grave ; B 272 508 503 661 ;
C 194 ; WX 600 ; N acute ; B 312 508 609 661 ;
C 195 ; WX 600 ; N circumflex ; B 212 483 607 657 ;
C 196 ; WX 600 ; N tilde ; B 199 493 643 636 ;
C 197 ; WX 600 ; N macron ; B 195 505 637 585 ;
C 198 ; WX 600 ; N breve ; B 217 468 652 631 ;
C 199 ; WX 600 ; N dotaccent ; B 348 498 493 638 ;
C 200 ; WX 600 ; N dieresis ; B 246 498 595 638 ;
C 202 ; WX 600 ; N ring ; B 319 481 528 678 ;
C 203 ; WX 600 ; N cedilla ; B 168 -206 368 0 ;
C 205 ; WX 600 ; N hungarumlaut ; B 171 488 729 661 ;
C 206 ; WX 600 ; N ogonek ; B 143 -199 367 0 ;
C 207 ; WX 600 ; N caron ; B 238 493 633 667 ;
C 208 ; WX 600 ; N emdash ; B 33 203 677 313 ;
C 225 ; WX 600 ; N AE ; B -29 0 708 562 ;
C 227 ; WX 600 ; N ordfeminine ; B 188 196 526 580 ;
C 232 ; WX 600 ; N Lslash ; B 39 0 636 562 ;
C 233 ; WX 600 ; N Oslash ; B 48 -22 673 584 ;
C 234 ; WX 600 ; N OE ; B 26 0 701 562 ;
C 235 ; WX 600 ; N ordmasculine ; B 188 196 543 580 ;
C 241 ; WX 600 ; N ae ; B 21 -15 652 454 ;
C 245 ; WX 600 ; N dotlessi ; B 77 0 546 439 ;
C 248 ; WX 600 ; N lslash ; B 77 0 587 626 ;
C 249 ; WX 600 ; N oslash ; B 54 -24 638 463 ;
C 250 ; WX 600 ; N oe ; B 18 -15 662 454 ;
C 251 ; WX 600 ; N germandbls ; B 22 -15 629 626 ;
C -1 ; WX 600 ; N Idieresis ; B 77 0 643 761 ;
C -1 ; WX 600 ; N eacute ; B 81 -15 609 661 ;
C -1 ; WX 600 ; N abreve ; B 61 -15 658 661 ;
C -1 ; WX 600 ; N uhungarumlaut ; B 70 -15 769 661 ;
C -1 ; WX 600 ; N ecaron ; B 81 -15 633 667 ;
C -1 ; WX 600 ; N Ydieresis ; B 109 0 709 761 ;
C -1 ; WX 600 ; N divide ; B 114 16 596 500 ;
C -1 ; WX 600 ; N Yacute ; B 109 0 709 784 ;
C -1 ; WX 600 ; N Acircumflex ; B -9 0 632 780 ;
C -1 ; WX 600 ; N aacute ; B 61 -15 609 661 ;
C -1 ; WX 600 ; N Ucircumflex ; B 101 -18 716 780 ;
C -1 ; WX 600 ; N yacute ; B -21 -142 695 661 ;
C -1 ; WX 600 ; N scommaaccent ; B 66 -250 608 459 ;
C -1 ; WX 600 ; N ecircumflex ; B 81 -15 607 657 ;
C -1 ; WX 600 ; N Uring ; B 101 -18 716 801 ;
C -1 ; WX 600 ; N Udieresis ; B 101 -18 716 761 ;
C -1 ; WX 600 ; N aogonek ; B 61 -199 593 454 ;
C -1 ; WX 600 ; N Uacute ; B 101 -18 716 784 ;
C -1 ; WX 600 ; N uogonek ; B 70 -199 592 439 ;
C -1 ; WX 600 ; N Edieresis ; B 25 0 670 761 ;
C -1 ; WX 600 ; N Dcroat ; B 30 0 664 562 ;
C -1 ; WX 600 ; N commaaccent ; B 151 -250 385 -57 ;
C -1 ; WX 600 ; N copyright ; B 53 -18 667 580 ;
C -1 ; WX 600 ; N Emacron ; B 25 0 670 708 ;
C -1 ; WX 600 ; N ccaron ; B 81 -15 633 667 ;
C -1 ; WX 600 ; N aring ; B 61 -15 593 678 ;
C -1 ; WX 600 ; N Ncommaaccent ; B 8 -250 730 562 ;
C -1 ; WX 600 ; N lacute ; B 77 0 639 801 ;
C -1 ; WX 600 ; N agrave ; B 61 -15 593 661 ;
C -1 ; WX 600 ; N Tcommaaccent ; B 86 -250 679 562 ;
C -1 ; WX 600 ; N Cacute ; B 74 -18 675 784 ;
C -1 ; WX 600 ; N atilde ; B 61 -15 643 636 ;
C -1 ; WX 600 ; N Edotaccent ; B 25 0 670 761 ;
C -1 ; WX 600 ; N scaron ; B 66 -17 633 667 ;
C -1 ; WX 600 ; N scedilla ; B 66 -206 608 459 ;
C -1 ; WX 600 ; N iacute ; B 77 0 609 661 ;
C -1 ; WX 600 ; N lozenge ; B 145 0 614 740 ;
C -1 ; WX 600 ; N Rcaron ; B 24 0 659 790 ;
C -1 ; WX 600 ; N Gcommaaccent ; B 74 -250 675 580 ;
C -1 ; WX 600 ; N ucircumflex ; B 70 -15 597 657 ;
C -1 ; WX 600 ; N acircumflex ; B 61 -15 607 657 ;
C -1 ; WX 600 ; N Amacron ; B -9 0 633 708 ;
C -1 ; WX 600 ; N rcaron ; B 47 0 655 667 ;
C -1 ; WX 600 ; N ccedilla ; B 81 -206 631 459 ;
C -1 ; WX 600 ; N Zdotaccent ; B 62 0 637 761 ;
C -1 ; WX 600 ; N Thorn ; B 48 0 620 562 ;
C -1 ; WX 600 ; N Omacron ; B 74 -18 663 708 ;
C -1 ; WX 600 ; N Racute ; B 24 0 665 784 ;
C -1 ; WX 600 ; N Sacute ; B 54 -22 673 784 ;
C -1 ; WX 600 ; N dcaron ; B 60 -15 861 626 ;
C -1 ; WX 600 ; N Umacron ; B 101 -18 716 708 ;
C -1 ; WX 600 ; N uring ; B 70 -15 592 678 ;
C -1 ; WX 600 ; N threesuperior ; B 193 222 526 616 ;
C -1 ; WX 600 ; N Ograve ; B 74 -18 645 784 ;
C -1 ; WX 600 ; N Agrave ; B -9 0 632 784 ;
C -1 ; WX 600 ; N Abreve ; B -9 0 684 784 ;
C -1 ; WX 600 ; N multiply ; B 104 39 606 478 ;
C -1 ; WX 600 ; N uacute ; B 70 -15 599 661 ;
C -1 ; WX 600 ; N Tcaron ; B 86 0 679 790 ;
C -1 ; WX 600 ; N partialdiff ; B 91 -38 627 728 ;
C -1 ; WX 600 ; N ydieresis ; B -21 -142 695 638 ;
C -1 ; WX 600 ; N Nacute ; B 8 -12 730 784 ;
C -1 ; WX 600 ; N icircumflex ; B 77 0 577 657 ;
C -1 ; WX 600 ; N Ecircumflex ; B 25 0 670 780 ;
C -1 ; WX 600 ; N adieresis ; B 61 -15 595 638 ;
C -1 ; WX 600 ; N edieresis ; B 81 -15 605 638 ;
C -1 ; WX 600 ; N cacute ; B 81 -15 649 661 ;
C -1 ; WX 600 ; N nacute ; B 18 0 639 661 ;
C -1 ; WX 600 ; N umacron ; B 70 -15 637 585 ;
C -1 ; WX 600 ; N Ncaron ; B 8 -12 730 790 ;
C -1 ; WX 600 ; N Iacute ; B 77 0 643 784 ;
C -1 ; WX 600 ; N plusminus ; B 76 24 614 515 ;
C -1 ; WX 600 ; N brokenbar ; B 217 -175 489 675 ;
C -1 ; WX 600 ; N registered ; B 53 -18 667 580 ;
C -1 ; WX 600 ; N Gbreve ; B 74 -18 684 784 ;
C -1 ; WX 600 ; N Idotaccent ; B 77 0 643 761 ;
C -1 ; WX 600 ; N summation ; B 15 -10 672 706 ;
C -1 ; WX 600 ; N Egrave ; B 25 0 670 784 ;
C -1 ; WX 600 ; N racute ; B 47 0 655 661 ;
C -1 ; WX 600 ; N omacron ; B 71 -15 637 585 ;
C -1 ; WX 600 ; N Zacute ; B 62 0 665 784 ;
C -1 ; WX 600 ; N Zcaron ; B 62 0 659 790 ;
C -1 ; WX 600 ; N greaterequal ; B 26 0 627 696 ;
C -1 ; WX 600 ; N Eth ; B 30 0 664 562 ;
C -1 ; WX 600 ; N Ccedilla ; B 74 -206 675 580 ;
C -1 ; WX 600 ; N lcommaaccent ; B 77 -250 546 626 ;
C -1 ; WX 600 ; N tcaron ; B 118 -15 627 703 ;
C -1 ; WX 600 ; N eogonek ; B 81 -199 605 454 ;
C -1 ; WX 600 ; N Uogonek ; B 101 -199 716 562 ;
C -1 ; WX 600 ; N Aacute ; B -9 0 655 784 ;
C -1 ; WX 600 ; N Adieresis ; B -9 0 632 761 ;
C -1 ; WX 600 ; N egrave ; B 81 -15 605 661 ;
C -1 ; WX 600 ; N zacute ; B 81 0 614 661 ;
C -1 ; WX 600 ; N iogonek ; B 77 -199 546 658 ;
C -1 ; WX 600 ; N Oacute ; B 74 -18 645 784 ;
C -1 ; WX 600 ; N oacute ; B 71 -15 649 661 ;
C -1 ; WX 600 ; N amacron ; B 61 -15 637 585 ;
C -1 ; WX 600 ; N sacute ; B 66 -17 609 661 ;
C -1 ; WX 600 ; N idieresis ; B 77 0 561 618 ;
C -1 ; WX 600 ; N Ocircumflex ; B 74 -18 645 780 ;
C -1 ; WX 600 ; N Ugrave ; B 101 -18 716 784 ;
C -1 ; WX 600 ; N Delta ; B 6 0 594 688 ;
C -1 ; WX 600 ; N thorn ; B -32 -142 622 626 ;
C -1 ; WX 600 ; N twosuperior ; B 191 230 542 616 ;
C -1 ; WX 600 ; N Odieresis ; B 74 -18 645 761 ;
C -1 ; WX 600 ; N mu ; B 49 -142 592 439 ;
C -1 ; WX 600 ; N igrave ; B 77 0 546 661 ;
C -1 ; WX 600 ; N ohungarumlaut ; B 71 -15 809 661 ;
C -1 ; WX 600 ; N Eogonek ; B 25 -199 670 562 ;
C -1 ; WX 600 ; N dcroat ; B 60 -15 712 626 ;
C -1 ; WX 600 ; N threequarters ; B 8 -60 699 661 ;
C -1 ; WX 600 ; N Scedilla ; B 54 -206 673 582 ;
C -1 ; WX 600 ; N lcaron ; B 77 0 731 626 ;
C -1 ; WX 600 ; N Kcommaaccent ; B 21 -250 692 562 ;
C -1 ; WX 600 ; N Lacute ; B 39 0 636 784 ;
C -1 ; WX 600 ; N trademark ; B 86 230 869 562 ;
C -1 ; WX 600 ; N edotaccent ; B 81 -15 605 638 ;
C -1 ; WX 600 ; N Igrave ; B 77 0 643 784 ;
C -1 ; WX 600 ; N Imacron ; B 77 0 663 708 ;
C -1 ; WX 600 ; N Lcaron ; B 39 0 757 562 ;
C -1 ; WX 600 ; N onehalf ; B 22 -60 716 661 ;
C -1 ; WX 600 ; N lessequal ; B 26 0 671 696 ;
C -1 ; WX 600 ; N ocircumflex ; B 71 -15 622 657 ;
C -1 ; WX 600 ; N ntilde ; B 18 0 643 636 ;
C -1 ; WX 600 ; N Uhungarumlaut ; B 101 -18 805 784 ;
C -1 ; WX 600 ; N Eacute ; B 25 0 670 784 ;
C -1 ; WX 600 ; N emacron ; B 81 -15 637 585 ;
C -1 ; WX 600 ; N gbreve ; B 40 -146 674 661 ;
C -1 ; WX 600 ; N onequarter ; B 13 -60 707 661 ;
C -1 ; WX 600 ; N Scaron ; B 54 -22 689 790 ;
C -1 ; WX 600 ; N Scommaaccent ; B 54 -250 673 582 ;
C -1 ; WX 600 ; N Ohungarumlaut ; B 74 -18 795 784 ;
C -1 ; WX 600 ; N degree ; B 173 243 570 616 ;
C -1 ; WX 600 ; N ograve ; B 71 -15 622 661 ;
C -1 ; WX 600 ; N Ccaron ; B 74 -18 689 790 ;
C -1 ; WX 600 ; N ugrave ; B 70 -15 592 661 ;
C -1 ; WX 600 ; N radical ; B 67 -104 635 778 ;
C -1 ; WX 600 ; N Dcaron ; B 30 0 664 790 ;
C -1 ; WX 600 ; N rcommaaccent ; B 47 -250 655 454 ;
C -1 ; WX 600 ; N Ntilde ; B 8 -12 730 759 ;
C -1 ; WX 600 ; N otilde ; B 71 -15 643 636 ;
C -1 ; WX 600 ; N Rcommaaccent ; B 24 -250 617 562 ;
C -1 ; WX 600 ; N Lcommaaccent ; B 39 -250 636 562 ;
C -1 ; WX 600 ; N Atilde ; B -9 0 669 759 ;
C -1 ; WX 600 ; N Aogonek ; B -9 -199 632 562 ;
C -1 ; WX 600 ; N Aring ; B -9 0 632 801 ;
C -1 ; WX 600 ; N Otilde ; B 74 -18 669 759 ;
C -1 ; WX 600 ; N zdotaccent ; B 81 0 614 638 ;
C -1 ; WX 600 ; N Ecaron ; B 25 0 670 790 ;
C -1 ; WX 600 ; N Iogonek ; B 77 -199 643 562 ;
C -1 ; WX 600 ; N kcommaaccent ; B 33 -250 643 626 ;
C -1 ; WX 600 ; N minus ; B 114 203 596 313 ;
C -1 ; WX 600 ; N Icircumflex ; B 77 0 643 780 ;
C -1 ; WX 600 ; N ncaron ; B 18 0 633 667 ;
C -1 ; WX 600 ; N tcommaaccent ; B 118 -250 567 562 ;
C -1 ; WX 600 ; N logicalnot ; B 135 103 617 413 ;
C -1 ; WX 600 ; N odieresis ; B 71 -15 622 638 ;
C -1 ; WX 600 ; N udieresis ; B 70 -15 595 638 ;
C -1 ; WX 600 ; N notequal ; B 30 -47 626 563 ;
C -1 ; WX 600 ; N gcommaaccent ; B 40 -146 674 714 ;
C -1 ; WX 600 ; N eth ; B 93 -27 661 626 ;
C -1 ; WX 600 ; N zcaron ; B 81 0 643 667 ;
C -1 ; WX 600 ; N ncommaaccent ; B 18 -250 615 454 ;
C -1 ; WX 600 ; N onesuperior ; B 212 230 514 616 ;
C -1 ; WX 600 ; N imacron ; B 77 0 575 585 ;
C -1 ; WX 600 ; N Euro ; B 0 0 0 0 ;
EndCharMetrics
EndFontMetrics"


let times_roman_afm = "StartFontMetrics 4.1
Comment Copyright (c) 1985, 1987, 1989, 1990, 1993, 1997 Adobe Systems Incorporated.  All Rights Reserved.
Comment Creation Date: Thu May  1 12:49:17 1997
Comment UniqueID 43068
Comment VMusage 43909 54934
FontName Times-Roman
FullName Times Roman
FamilyName Times
Weight Roman
ItalicAngle 0
IsFixedPitch false
CharacterSet ExtendedRoman
FontBBox -168 -218 1000 898 
UnderlinePosition -100
UnderlineThickness 50
Version 002.000
Notice Copyright (c) 1985, 1987, 1989, 1990, 1993, 1997 Adobe Systems Incorporated.  All Rights Reserved.Times is a trademark of Linotype-Hell AG and/or its subsidiaries.
EncodingScheme AdobeStandardEncoding
CapHeight 662
XHeight 450
Ascender 683
Descender -217
StdHW 28
StdVW 84
StartCharMetrics 315
C 32 ; WX 250 ; N space ; B 0 0 0 0 ;
C 33 ; WX 333 ; N exclam ; B 130 -9 238 676 ;
C 34 ; WX 408 ; N quotedbl ; B 77 431 331 676 ;
C 35 ; WX 500 ; N numbersign ; B 5 0 496 662 ;
C 36 ; WX 500 ; N dollar ; B 44 -87 457 727 ;
C 37 ; WX 833 ; N percent ; B 61 -13 772 676 ;
C 38 ; WX 778 ; N ampersand ; B 42 -13 750 676 ;
C 39 ; WX 333 ; N quoteright ; B 79 433 218 676 ;
C 40 ; WX 333 ; N parenleft ; B 48 -177 304 676 ;
C 41 ; WX 333 ; N parenright ; B 29 -177 285 676 ;
C 42 ; WX 500 ; N asterisk ; B 69 265 432 676 ;
C 43 ; WX 564 ; N plus ; B 30 0 534 506 ;
C 44 ; WX 250 ; N comma ; B 56 -141 195 102 ;
C 45 ; WX 333 ; N hyphen ; B 39 194 285 257 ;
C 46 ; WX 250 ; N period ; B 70 -11 181 100 ;
C 47 ; WX 278 ; N slash ; B -9 -14 287 676 ;
C 48 ; WX 500 ; N zero ; B 24 -14 476 676 ;
C 49 ; WX 500 ; N one ; B 111 0 394 676 ;
C 50 ; WX 500 ; N two ; B 30 0 475 676 ;
C 51 ; WX 500 ; N three ; B 43 -14 431 676 ;
C 52 ; WX 500 ; N four ; B 12 0 472 676 ;
C 53 ; WX 500 ; N five ; B 32 -14 438 688 ;
C 54 ; WX 500 ; N six ; B 34 -14 468 684 ;
C 55 ; WX 500 ; N seven ; B 20 -8 449 662 ;
C 56 ; WX 500 ; N eight ; B 56 -14 445 676 ;
C 57 ; WX 500 ; N nine ; B 30 -22 459 676 ;
C 58 ; WX 278 ; N colon ; B 81 -11 192 459 ;
C 59 ; WX 278 ; N semicolon ; B 80 -141 219 459 ;
C 60 ; WX 564 ; N less ; B 28 -8 536 514 ;
C 61 ; WX 564 ; N equal ; B 30 120 534 386 ;
C 62 ; WX 564 ; N greater ; B 28 -8 536 514 ;
C 63 ; WX 444 ; N question ; B 68 -8 414 676 ;
C 64 ; WX 921 ; N at ; B 116 -14 809 676 ;
C 65 ; WX 722 ; N A ; B 15 0 706 674 ;
C 66 ; WX 667 ; N B ; B 17 0 593 662 ;
C 67 ; WX 667 ; N C ; B 28 -14 633 676 ;
C 68 ; WX 722 ; N D ; B 16 0 685 662 ;
C 69 ; WX 611 ; N E ; B 12 0 597 662 ;
C 70 ; WX 556 ; N F ; B 12 0 546 662 ;
C 71 ; WX 722 ; N G ; B 32 -14 709 676 ;
C 72 ; WX 722 ; N H ; B 19 0 702 662 ;
C 73 ; WX 333 ; N I ; B 18 0 315 662 ;
C 74 ; WX 389 ; N J ; B 10 -14 370 662 ;
C 75 ; WX 722 ; N K ; B 34 0 723 662 ;
C 76 ; WX 611 ; N L ; B 12 0 598 662 ;
C 77 ; WX 889 ; N M ; B 12 0 863 662 ;
C 78 ; WX 722 ; N N ; B 12 -11 707 662 ;
C 79 ; WX 722 ; N O ; B 34 -14 688 676 ;
C 80 ; WX 556 ; N P ; B 16 0 542 662 ;
C 81 ; WX 722 ; N Q ; B 34 -178 701 676 ;
C 82 ; WX 667 ; N R ; B 17 0 659 662 ;
C 83 ; WX 556 ; N S ; B 42 -14 491 676 ;
C 84 ; WX 611 ; N T ; B 17 0 593 662 ;
C 85 ; WX 722 ; N U ; B 14 -14 705 662 ;
C 86 ; WX 722 ; N V ; B 16 -11 697 662 ;
C 87 ; WX 944 ; N W ; B 5 -11 932 662 ;
C 88 ; WX 722 ; N X ; B 10 0 704 662 ;
C 89 ; WX 722 ; N Y ; B 22 0 703 662 ;
C 90 ; WX 611 ; N Z ; B 9 0 597 662 ;
C 91 ; WX 333 ; N bracketleft ; B 88 -156 299 662 ;
C 92 ; WX 278 ; N backslash ; B -9 -14 287 676 ;
C 93 ; WX 333 ; N bracketright ; B 34 -156 245 662 ;
C 94 ; WX 469 ; N asciicircum ; B 24 297 446 662 ;
C 95 ; WX 500 ; N underscore ; B 0 -125 500 -75 ;
C 96 ; WX 333 ; N quoteleft ; B 115 433 254 676 ;
C 97 ; WX 444 ; N a ; B 37 -10 442 460 ;
C 98 ; WX 500 ; N b ; B 3 -10 468 683 ;
C 99 ; WX 444 ; N c ; B 25 -10 412 460 ;
C 100 ; WX 500 ; N d ; B 27 -10 491 683 ;
C 101 ; WX 444 ; N e ; B 25 -10 424 460 ;
C 102 ; WX 333 ; N f ; B 20 0 383 683 ; L i fi ; L l fl ;
C 103 ; WX 500 ; N g ; B 28 -218 470 460 ;
C 104 ; WX 500 ; N h ; B 9 0 487 683 ;
C 105 ; WX 278 ; N i ; B 16 0 253 683 ;
C 106 ; WX 278 ; N j ; B -70 -218 194 683 ;
C 107 ; WX 500 ; N k ; B 7 0 505 683 ;
C 108 ; WX 278 ; N l ; B 19 0 257 683 ;
C 109 ; WX 778 ; N m ; B 16 0 775 460 ;
C 110 ; WX 500 ; N n ; B 16 0 485 460 ;
C 111 ; WX 500 ; N o ; B 29 -10 470 460 ;
C 112 ; WX 500 ; N p ; B 5 -217 470 460 ;
C 113 ; WX 500 ; N q ; B 24 -217 488 460 ;
C 114 ; WX 333 ; N r ; B 5 0 335 460 ;
C 115 ; WX 389 ; N s ; B 51 -10 348 460 ;
C 116 ; WX 278 ; N t ; B 13 -10 279 579 ;
C 117 ; WX 500 ; N u ; B 9 -10 479 450 ;
C 118 ; WX 500 ; N v ; B 19 -14 477 450 ;
C 119 ; WX 722 ; N w ; B 21 -14 694 450 ;
C 120 ; WX 500 ; N x ; B 17 0 479 450 ;
C 121 ; WX 500 ; N y ; B 14 -218 475 450 ;
C 122 ; WX 444 ; N z ; B 27 0 418 450 ;
C 123 ; WX 480 ; N braceleft ; B 100 -181 350 680 ;
C 124 ; WX 200 ; N bar ; B 67 -218 133 782 ;
C 125 ; WX 480 ; N braceright ; B 130 -181 380 680 ;
C 126 ; WX 541 ; N asciitilde ; B 40 183 502 323 ;
C 161 ; WX 333 ; N exclamdown ; B 97 -218 205 467 ;
C 162 ; WX 500 ; N cent ; B 53 -138 448 579 ;
C 163 ; WX 500 ; N sterling ; B 12 -8 490 676 ;
C 164 ; WX 167 ; N fraction ; B -168 -14 331 676 ;
C 165 ; WX 500 ; N yen ; B -53 0 512 662 ;
C 166 ; WX 500 ; N florin ; B 7 -189 490 676 ;
C 167 ; WX 500 ; N section ; B 70 -148 426 676 ;
C 168 ; WX 500 ; N currency ; B -22 58 522 602 ;
C 169 ; WX 180 ; N quotesingle ; B 48 431 133 676 ;
C 170 ; WX 444 ; N quotedblleft ; B 43 433 414 676 ;
C 171 ; WX 500 ; N guillemotleft ; B 42 33 456 416 ;
C 172 ; WX 333 ; N guilsinglleft ; B 63 33 285 416 ;
C 173 ; WX 333 ; N guilsinglright ; B 48 33 270 416 ;
C 174 ; WX 556 ; N fi ; B 31 0 521 683 ;
C 175 ; WX 556 ; N fl ; B 32 0 521 683 ;
C 177 ; WX 500 ; N endash ; B 0 201 500 250 ;
C 178 ; WX 500 ; N dagger ; B 59 -149 442 676 ;
C 179 ; WX 500 ; N daggerdbl ; B 58 -153 442 676 ;
C 180 ; WX 250 ; N periodcentered ; B 70 199 181 310 ;
C 182 ; WX 453 ; N paragraph ; B -22 -154 450 662 ;
C 183 ; WX 350 ; N bullet ; B 40 196 310 466 ;
C 184 ; WX 333 ; N quotesinglbase ; B 79 -141 218 102 ;
C 185 ; WX 444 ; N quotedblbase ; B 45 -141 416 102 ;
C 186 ; WX 444 ; N quotedblright ; B 30 433 401 676 ;
C 187 ; WX 500 ; N guillemotright ; B 44 33 458 416 ;
C 188 ; WX 1000 ; N ellipsis ; B 111 -11 888 100 ;
C 189 ; WX 1000 ; N perthousand ; B 7 -19 994 706 ;
C 191 ; WX 444 ; N questiondown ; B 30 -218 376 466 ;
C 193 ; WX 333 ; N grave ; B 19 507 242 678 ;
C 194 ; WX 333 ; N acute ; B 93 507 317 678 ;
C 195 ; WX 333 ; N circumflex ; B 11 507 322 674 ;
C 196 ; WX 333 ; N tilde ; B 1 532 331 638 ;
C 197 ; WX 333 ; N macron ; B 11 547 322 601 ;
C 198 ; WX 333 ; N breve ; B 26 507 307 664 ;
C 199 ; WX 333 ; N dotaccent ; B 118 581 216 681 ;
C 200 ; WX 333 ; N dieresis ; B 18 581 315 681 ;
C 202 ; WX 333 ; N ring ; B 67 512 266 711 ;
C 203 ; WX 333 ; N cedilla ; B 52 -215 261 0 ;
C 205 ; WX 333 ; N hungarumlaut ; B -3 507 377 678 ;
C 206 ; WX 333 ; N ogonek ; B 62 -165 243 0 ;
C 207 ; WX 333 ; N caron ; B 11 507 322 674 ;
C 208 ; WX 1000 ; N emdash ; B 0 201 1000 250 ;
C 225 ; WX 889 ; N AE ; B 0 0 863 662 ;
C 227 ; WX 276 ; N ordfeminine ; B 4 394 270 676 ;
C 232 ; WX 611 ; N Lslash ; B 12 0 598 662 ;
C 233 ; WX 722 ; N Oslash ; B 34 -80 688 734 ;
C 234 ; WX 889 ; N OE ; B 30 -6 885 668 ;
C 235 ; WX 310 ; N ordmasculine ; B 6 394 304 676 ;
C 241 ; WX 667 ; N ae ; B 38 -10 632 460 ;
C 245 ; WX 278 ; N dotlessi ; B 16 0 253 460 ;
C 248 ; WX 278 ; N lslash ; B 19 0 259 683 ;
C 249 ; WX 500 ; N oslash ; B 29 -112 470 551 ;
C 250 ; WX 722 ; N oe ; B 30 -10 690 460 ;
C 251 ; WX 500 ; N germandbls ; B 12 -9 468 683 ;
C -1 ; WX 333 ; N Idieresis ; B 18 0 315 835 ;
C -1 ; WX 444 ; N eacute ; B 25 -10 424 678 ;
C -1 ; WX 444 ; N abreve ; B 37 -10 442 664 ;
C -1 ; WX 500 ; N uhungarumlaut ; B 9 -10 501 678 ;
C -1 ; WX 444 ; N ecaron ; B 25 -10 424 674 ;
C -1 ; WX 722 ; N Ydieresis ; B 22 0 703 835 ;
C -1 ; WX 564 ; N divide ; B 30 -10 534 516 ;
C -1 ; WX 722 ; N Yacute ; B 22 0 703 890 ;
C -1 ; WX 722 ; N Acircumflex ; B 15 0 706 886 ;
C -1 ; WX 444 ; N aacute ; B 37 -10 442 678 ;
C -1 ; WX 722 ; N Ucircumflex ; B 14 -14 705 886 ;
C -1 ; WX 500 ; N yacute ; B 14 -218 475 678 ;
C -1 ; WX 389 ; N scommaaccent ; B 51 -218 348 460 ;
C -1 ; WX 444 ; N ecircumflex ; B 25 -10 424 674 ;
C -1 ; WX 722 ; N Uring ; B 14 -14 705 898 ;
C -1 ; WX 722 ; N Udieresis ; B 14 -14 705 835 ;
C -1 ; WX 444 ; N aogonek ; B 37 -165 469 460 ;
C -1 ; WX 722 ; N Uacute ; B 14 -14 705 890 ;
C -1 ; WX 500 ; N uogonek ; B 9 -155 487 450 ;
C -1 ; WX 611 ; N Edieresis ; B 12 0 597 835 ;
C -1 ; WX 722 ; N Dcroat ; B 16 0 685 662 ;
C -1 ; WX 250 ; N commaaccent ; B 59 -218 184 -50 ;
C -1 ; WX 760 ; N copyright ; B 38 -14 722 676 ;
C -1 ; WX 611 ; N Emacron ; B 12 0 597 813 ;
C -1 ; WX 444 ; N ccaron ; B 25 -10 412 674 ;
C -1 ; WX 444 ; N aring ; B 37 -10 442 711 ;
C -1 ; WX 722 ; N Ncommaaccent ; B 12 -198 707 662 ;
C -1 ; WX 278 ; N lacute ; B 19 0 290 890 ;
C -1 ; WX 444 ; N agrave ; B 37 -10 442 678 ;
C -1 ; WX 611 ; N Tcommaaccent ; B 17 -218 593 662 ;
C -1 ; WX 667 ; N Cacute ; B 28 -14 633 890 ;
C -1 ; WX 444 ; N atilde ; B 37 -10 442 638 ;
C -1 ; WX 611 ; N Edotaccent ; B 12 0 597 835 ;
C -1 ; WX 389 ; N scaron ; B 39 -10 350 674 ;
C -1 ; WX 389 ; N scedilla ; B 51 -215 348 460 ;
C -1 ; WX 278 ; N iacute ; B 16 0 290 678 ;
C -1 ; WX 471 ; N lozenge ; B 13 0 459 724 ;
C -1 ; WX 667 ; N Rcaron ; B 17 0 659 886 ;
C -1 ; WX 722 ; N Gcommaaccent ; B 32 -218 709 676 ;
C -1 ; WX 500 ; N ucircumflex ; B 9 -10 479 674 ;
C -1 ; WX 444 ; N acircumflex ; B 37 -10 442 674 ;
C -1 ; WX 722 ; N Amacron ; B 15 0 706 813 ;
C -1 ; WX 333 ; N rcaron ; B 5 0 335 674 ;
C -1 ; WX 444 ; N ccedilla ; B 25 -215 412 460 ;
C -1 ; WX 611 ; N Zdotaccent ; B 9 0 597 835 ;
C -1 ; WX 556 ; N Thorn ; B 16 0 542 662 ;
C -1 ; WX 722 ; N Omacron ; B 34 -14 688 813 ;
C -1 ; WX 667 ; N Racute ; B 17 0 659 890 ;
C -1 ; WX 556 ; N Sacute ; B 42 -14 491 890 ;
C -1 ; WX 588 ; N dcaron ; B 27 -10 589 695 ;
C -1 ; WX 722 ; N Umacron ; B 14 -14 705 813 ;
C -1 ; WX 500 ; N uring ; B 9 -10 479 711 ;
C -1 ; WX 300 ; N threesuperior ; B 15 262 291 676 ;
C -1 ; WX 722 ; N Ograve ; B 34 -14 688 890 ;
C -1 ; WX 722 ; N Agrave ; B 15 0 706 890 ;
C -1 ; WX 722 ; N Abreve ; B 15 0 706 876 ;
C -1 ; WX 564 ; N multiply ; B 38 8 527 497 ;
C -1 ; WX 500 ; N uacute ; B 9 -10 479 678 ;
C -1 ; WX 611 ; N Tcaron ; B 17 0 593 886 ;
C -1 ; WX 476 ; N partialdiff ; B 17 -38 459 710 ;
C -1 ; WX 500 ; N ydieresis ; B 14 -218 475 623 ;
C -1 ; WX 722 ; N Nacute ; B 12 -11 707 890 ;
C -1 ; WX 278 ; N icircumflex ; B -16 0 295 674 ;
C -1 ; WX 611 ; N Ecircumflex ; B 12 0 597 886 ;
C -1 ; WX 444 ; N adieresis ; B 37 -10 442 623 ;
C -1 ; WX 444 ; N edieresis ; B 25 -10 424 623 ;
C -1 ; WX 444 ; N cacute ; B 25 -10 413 678 ;
C -1 ; WX 500 ; N nacute ; B 16 0 485 678 ;
C -1 ; WX 500 ; N umacron ; B 9 -10 479 601 ;
C -1 ; WX 722 ; N Ncaron ; B 12 -11 707 886 ;
C -1 ; WX 333 ; N Iacute ; B 18 0 317 890 ;
C -1 ; WX 564 ; N plusminus ; B 30 0 534 506 ;
C -1 ; WX 200 ; N brokenbar ; B 67 -143 133 707 ;
C -1 ; WX 760 ; N registered ; B 38 -14 722 676 ;
C -1 ; WX 722 ; N Gbreve ; B 32 -14 709 876 ;
C -1 ; WX 333 ; N Idotaccent ; B 18 0 315 835 ;
C -1 ; WX 600 ; N summation ; B 15 -10 585 706 ;
C -1 ; WX 611 ; N Egrave ; B 12 0 597 890 ;
C -1 ; WX 333 ; N racute ; B 5 0 335 678 ;
C -1 ; WX 500 ; N omacron ; B 29 -10 470 601 ;
C -1 ; WX 611 ; N Zacute ; B 9 0 597 890 ;
C -1 ; WX 611 ; N Zcaron ; B 9 0 597 886 ;
C -1 ; WX 549 ; N greaterequal ; B 26 0 523 666 ;
C -1 ; WX 722 ; N Eth ; B 16 0 685 662 ;
C -1 ; WX 667 ; N Ccedilla ; B 28 -215 633 676 ;
C -1 ; WX 278 ; N lcommaaccent ; B 19 -218 257 683 ;
C -1 ; WX 326 ; N tcaron ; B 13 -10 318 722 ;
C -1 ; WX 444 ; N eogonek ; B 25 -165 424 460 ;
C -1 ; WX 722 ; N Uogonek ; B 14 -165 705 662 ;
C -1 ; WX 722 ; N Aacute ; B 15 0 706 890 ;
C -1 ; WX 722 ; N Adieresis ; B 15 0 706 835 ;
C -1 ; WX 444 ; N egrave ; B 25 -10 424 678 ;
C -1 ; WX 444 ; N zacute ; B 27 0 418 678 ;
C -1 ; WX 278 ; N iogonek ; B 16 -165 265 683 ;
C -1 ; WX 722 ; N Oacute ; B 34 -14 688 890 ;
C -1 ; WX 500 ; N oacute ; B 29 -10 470 678 ;
C -1 ; WX 444 ; N amacron ; B 37 -10 442 601 ;
C -1 ; WX 389 ; N sacute ; B 51 -10 348 678 ;
C -1 ; WX 278 ; N idieresis ; B -9 0 288 623 ;
C -1 ; WX 722 ; N Ocircumflex ; B 34 -14 688 886 ;
C -1 ; WX 722 ; N Ugrave ; B 14 -14 705 890 ;
C -1 ; WX 612 ; N Delta ; B 6 0 608 688 ;
C -1 ; WX 500 ; N thorn ; B 5 -217 470 683 ;
C -1 ; WX 300 ; N twosuperior ; B 1 270 296 676 ;
C -1 ; WX 722 ; N Odieresis ; B 34 -14 688 835 ;
C -1 ; WX 500 ; N mu ; B 36 -218 512 450 ;
C -1 ; WX 278 ; N igrave ; B -8 0 253 678 ;
C -1 ; WX 500 ; N ohungarumlaut ; B 29 -10 491 678 ;
C -1 ; WX 611 ; N Eogonek ; B 12 -165 597 662 ;
C -1 ; WX 500 ; N dcroat ; B 27 -10 500 683 ;
C -1 ; WX 750 ; N threequarters ; B 15 -14 718 676 ;
C -1 ; WX 556 ; N Scedilla ; B 42 -215 491 676 ;
C -1 ; WX 344 ; N lcaron ; B 19 0 347 695 ;
C -1 ; WX 722 ; N Kcommaaccent ; B 34 -198 723 662 ;
C -1 ; WX 611 ; N Lacute ; B 12 0 598 890 ;
C -1 ; WX 980 ; N trademark ; B 30 256 957 662 ;
C -1 ; WX 444 ; N edotaccent ; B 25 -10 424 623 ;
C -1 ; WX 333 ; N Igrave ; B 18 0 315 890 ;
C -1 ; WX 333 ; N Imacron ; B 11 0 322 813 ;
C -1 ; WX 611 ; N Lcaron ; B 12 0 598 676 ;
C -1 ; WX 750 ; N onehalf ; B 31 -14 746 676 ;
C -1 ; WX 549 ; N lessequal ; B 26 0 523 666 ;
C -1 ; WX 500 ; N ocircumflex ; B 29 -10 470 674 ;
C -1 ; WX 500 ; N ntilde ; B 16 0 485 638 ;
C -1 ; WX 722 ; N Uhungarumlaut ; B 14 -14 705 890 ;
C -1 ; WX 611 ; N Eacute ; B 12 0 597 890 ;
C -1 ; WX 444 ; N emacron ; B 25 -10 424 601 ;
C -1 ; WX 500 ; N gbreve ; B 28 -218 470 664 ;
C -1 ; WX 750 ; N onequarter ; B 37 -14 718 676 ;
C -1 ; WX 556 ; N Scaron ; B 42 -14 491 886 ;
C -1 ; WX 556 ; N Scommaaccent ; B 42 -218 491 676 ;
C -1 ; WX 722 ; N Ohungarumlaut ; B 34 -14 688 890 ;
C -1 ; WX 400 ; N degree ; B 57 390 343 676 ;
C -1 ; WX 500 ; N ograve ; B 29 -10 470 678 ;
C -1 ; WX 667 ; N Ccaron ; B 28 -14 633 886 ;
C -1 ; WX 500 ; N ugrave ; B 9 -10 479 678 ;
C -1 ; WX 453 ; N radical ; B 2 -60 452 768 ;
C -1 ; WX 722 ; N Dcaron ; B 16 0 685 886 ;
C -1 ; WX 333 ; N rcommaaccent ; B 5 -218 335 460 ;
C -1 ; WX 722 ; N Ntilde ; B 12 -11 707 850 ;
C -1 ; WX 500 ; N otilde ; B 29 -10 470 638 ;
C -1 ; WX 667 ; N Rcommaaccent ; B 17 -198 659 662 ;
C -1 ; WX 611 ; N Lcommaaccent ; B 12 -218 598 662 ;
C -1 ; WX 722 ; N Atilde ; B 15 0 706 850 ;
C -1 ; WX 722 ; N Aogonek ; B 15 -165 738 674 ;
C -1 ; WX 722 ; N Aring ; B 15 0 706 898 ;
C -1 ; WX 722 ; N Otilde ; B 34 -14 688 850 ;
C -1 ; WX 444 ; N zdotaccent ; B 27 0 418 623 ;
C -1 ; WX 611 ; N Ecaron ; B 12 0 597 886 ;
C -1 ; WX 333 ; N Iogonek ; B 18 -165 315 662 ;
C -1 ; WX 500 ; N kcommaaccent ; B 7 -218 505 683 ;
C -1 ; WX 564 ; N minus ; B 30 220 534 286 ;
C -1 ; WX 333 ; N Icircumflex ; B 11 0 322 886 ;
C -1 ; WX 500 ; N ncaron ; B 16 0 485 674 ;
C -1 ; WX 278 ; N tcommaaccent ; B 13 -218 279 579 ;
C -1 ; WX 564 ; N logicalnot ; B 30 108 534 386 ;
C -1 ; WX 500 ; N odieresis ; B 29 -10 470 623 ;
C -1 ; WX 500 ; N udieresis ; B 9 -10 479 623 ;
C -1 ; WX 549 ; N notequal ; B 12 -31 537 547 ;
C -1 ; WX 500 ; N gcommaaccent ; B 28 -218 470 749 ;
C -1 ; WX 500 ; N eth ; B 29 -10 471 686 ;
C -1 ; WX 444 ; N zcaron ; B 27 0 418 674 ;
C -1 ; WX 500 ; N ncommaaccent ; B 16 -218 485 460 ;
C -1 ; WX 300 ; N onesuperior ; B 57 270 248 676 ;
C -1 ; WX 278 ; N imacron ; B 6 0 271 601 ;
C -1 ; WX 500 ; N Euro ; B 0 0 0 0 ;
EndCharMetrics
StartKernData
StartKernPairs 2073
KPX A C -40
KPX A Cacute -40
KPX A Ccaron -40
KPX A Ccedilla -40
KPX A G -40
KPX A Gbreve -40
KPX A Gcommaaccent -40
KPX A O -55
KPX A Oacute -55
KPX A Ocircumflex -55
KPX A Odieresis -55
KPX A Ograve -55
KPX A Ohungarumlaut -55
KPX A Omacron -55
KPX A Oslash -55
KPX A Otilde -55
KPX A Q -55
KPX A T -111
KPX A Tcaron -111
KPX A Tcommaaccent -111
KPX A U -55
KPX A Uacute -55
KPX A Ucircumflex -55
KPX A Udieresis -55
KPX A Ugrave -55
KPX A Uhungarumlaut -55
KPX A Umacron -55
KPX A Uogonek -55
KPX A Uring -55
KPX A V -135
KPX A W -90
KPX A Y -105
KPX A Yacute -105
KPX A Ydieresis -105
KPX A quoteright -111
KPX A v -74
KPX A w -92
KPX A y -92
KPX A yacute -92
KPX A ydieresis -92
KPX Aacute C -40
KPX Aacute Cacute -40
KPX Aacute Ccaron -40
KPX Aacute Ccedilla -40
KPX Aacute G -40
KPX Aacute Gbreve -40
KPX Aacute Gcommaaccent -40
KPX Aacute O -55
KPX Aacute Oacute -55
KPX Aacute Ocircumflex -55
KPX Aacute Odieresis -55
KPX Aacute Ograve -55
KPX Aacute Ohungarumlaut -55
KPX Aacute Omacron -55
KPX Aacute Oslash -55
KPX Aacute Otilde -55
KPX Aacute Q -55
KPX Aacute T -111
KPX Aacute Tcaron -111
KPX Aacute Tcommaaccent -111
KPX Aacute U -55
KPX Aacute Uacute -55
KPX Aacute Ucircumflex -55
KPX Aacute Udieresis -55
KPX Aacute Ugrave -55
KPX Aacute Uhungarumlaut -55
KPX Aacute Umacron -55
KPX Aacute Uogonek -55
KPX Aacute Uring -55
KPX Aacute V -135
KPX Aacute W -90
KPX Aacute Y -105
KPX Aacute Yacute -105
KPX Aacute Ydieresis -105
KPX Aacute quoteright -111
KPX Aacute v -74
KPX Aacute w -92
KPX Aacute y -92
KPX Aacute yacute -92
KPX Aacute ydieresis -92
KPX Abreve C -40
KPX Abreve Cacute -40
KPX Abreve Ccaron -40
KPX Abreve Ccedilla -40
KPX Abreve G -40
KPX Abreve Gbreve -40
KPX Abreve Gcommaaccent -40
KPX Abreve O -55
KPX Abreve Oacute -55
KPX Abreve Ocircumflex -55
KPX Abreve Odieresis -55
KPX Abreve Ograve -55
KPX Abreve Ohungarumlaut -55
KPX Abreve Omacron -55
KPX Abreve Oslash -55
KPX Abreve Otilde -55
KPX Abreve Q -55
KPX Abreve T -111
KPX Abreve Tcaron -111
KPX Abreve Tcommaaccent -111
KPX Abreve U -55
KPX Abreve Uacute -55
KPX Abreve Ucircumflex -55
KPX Abreve Udieresis -55
KPX Abreve Ugrave -55
KPX Abreve Uhungarumlaut -55
KPX Abreve Umacron -55
KPX Abreve Uogonek -55
KPX Abreve Uring -55
KPX Abreve V -135
KPX Abreve W -90
KPX Abreve Y -105
KPX Abreve Yacute -105
KPX Abreve Ydieresis -105
KPX Abreve quoteright -111
KPX Abreve v -74
KPX Abreve w -92
KPX Abreve y -92
KPX Abreve yacute -92
KPX Abreve ydieresis -92
KPX Acircumflex C -40
KPX Acircumflex Cacute -40
KPX Acircumflex Ccaron -40
KPX Acircumflex Ccedilla -40
KPX Acircumflex G -40
KPX Acircumflex Gbreve -40
KPX Acircumflex Gcommaaccent -40
KPX Acircumflex O -55
KPX Acircumflex Oacute -55
KPX Acircumflex Ocircumflex -55
KPX Acircumflex Odieresis -55
KPX Acircumflex Ograve -55
KPX Acircumflex Ohungarumlaut -55
KPX Acircumflex Omacron -55
KPX Acircumflex Oslash -55
KPX Acircumflex Otilde -55
KPX Acircumflex Q -55
KPX Acircumflex T -111
KPX Acircumflex Tcaron -111
KPX Acircumflex Tcommaaccent -111
KPX Acircumflex U -55
KPX Acircumflex Uacute -55
KPX Acircumflex Ucircumflex -55
KPX Acircumflex Udieresis -55
KPX Acircumflex Ugrave -55
KPX Acircumflex Uhungarumlaut -55
KPX Acircumflex Umacron -55
KPX Acircumflex Uogonek -55
KPX Acircumflex Uring -55
KPX Acircumflex V -135
KPX Acircumflex W -90
KPX Acircumflex Y -105
KPX Acircumflex Yacute -105
KPX Acircumflex Ydieresis -105
KPX Acircumflex quoteright -111
KPX Acircumflex v -74
KPX Acircumflex w -92
KPX Acircumflex y -92
KPX Acircumflex yacute -92
KPX Acircumflex ydieresis -92
KPX Adieresis C -40
KPX Adieresis Cacute -40
KPX Adieresis Ccaron -40
KPX Adieresis Ccedilla -40
KPX Adieresis G -40
KPX Adieresis Gbreve -40
KPX Adieresis Gcommaaccent -40
KPX Adieresis O -55
KPX Adieresis Oacute -55
KPX Adieresis Ocircumflex -55
KPX Adieresis Odieresis -55
KPX Adieresis Ograve -55
KPX Adieresis Ohungarumlaut -55
KPX Adieresis Omacron -55
KPX Adieresis Oslash -55
KPX Adieresis Otilde -55
KPX Adieresis Q -55
KPX Adieresis T -111
KPX Adieresis Tcaron -111
KPX Adieresis Tcommaaccent -111
KPX Adieresis U -55
KPX Adieresis Uacute -55
KPX Adieresis Ucircumflex -55
KPX Adieresis Udieresis -55
KPX Adieresis Ugrave -55
KPX Adieresis Uhungarumlaut -55
KPX Adieresis Umacron -55
KPX Adieresis Uogonek -55
KPX Adieresis Uring -55
KPX Adieresis V -135
KPX Adieresis W -90
KPX Adieresis Y -105
KPX Adieresis Yacute -105
KPX Adieresis Ydieresis -105
KPX Adieresis quoteright -111
KPX Adieresis v -74
KPX Adieresis w -92
KPX Adieresis y -92
KPX Adieresis yacute -92
KPX Adieresis ydieresis -92
KPX Agrave C -40
KPX Agrave Cacute -40
KPX Agrave Ccaron -40
KPX Agrave Ccedilla -40
KPX Agrave G -40
KPX Agrave Gbreve -40
KPX Agrave Gcommaaccent -40
KPX Agrave O -55
KPX Agrave Oacute -55
KPX Agrave Ocircumflex -55
KPX Agrave Odieresis -55
KPX Agrave Ograve -55
KPX Agrave Ohungarumlaut -55
KPX Agrave Omacron -55
KPX Agrave Oslash -55
KPX Agrave Otilde -55
KPX Agrave Q -55
KPX Agrave T -111
KPX Agrave Tcaron -111
KPX Agrave Tcommaaccent -111
KPX Agrave U -55
KPX Agrave Uacute -55
KPX Agrave Ucircumflex -55
KPX Agrave Udieresis -55
KPX Agrave Ugrave -55
KPX Agrave Uhungarumlaut -55
KPX Agrave Umacron -55
KPX Agrave Uogonek -55
KPX Agrave Uring -55
KPX Agrave V -135
KPX Agrave W -90
KPX Agrave Y -105
KPX Agrave Yacute -105
KPX Agrave Ydieresis -105
KPX Agrave quoteright -111
KPX Agrave v -74
KPX Agrave w -92
KPX Agrave y -92
KPX Agrave yacute -92
KPX Agrave ydieresis -92
KPX Amacron C -40
KPX Amacron Cacute -40
KPX Amacron Ccaron -40
KPX Amacron Ccedilla -40
KPX Amacron G -40
KPX Amacron Gbreve -40
KPX Amacron Gcommaaccent -40
KPX Amacron O -55
KPX Amacron Oacute -55
KPX Amacron Ocircumflex -55
KPX Amacron Odieresis -55
KPX Amacron Ograve -55
KPX Amacron Ohungarumlaut -55
KPX Amacron Omacron -55
KPX Amacron Oslash -55
KPX Amacron Otilde -55
KPX Amacron Q -55
KPX Amacron T -111
KPX Amacron Tcaron -111
KPX Amacron Tcommaaccent -111
KPX Amacron U -55
KPX Amacron Uacute -55
KPX Amacron Ucircumflex -55
KPX Amacron Udieresis -55
KPX Amacron Ugrave -55
KPX Amacron Uhungarumlaut -55
KPX Amacron Umacron -55
KPX Amacron Uogonek -55
KPX Amacron Uring -55
KPX Amacron V -135
KPX Amacron W -90
KPX Amacron Y -105
KPX Amacron Yacute -105
KPX Amacron Ydieresis -105
KPX Amacron quoteright -111
KPX Amacron v -74
KPX Amacron w -92
KPX Amacron y -92
KPX Amacron yacute -92
KPX Amacron ydieresis -92
KPX Aogonek C -40
KPX Aogonek Cacute -40
KPX Aogonek Ccaron -40
KPX Aogonek Ccedilla -40
KPX Aogonek G -40
KPX Aogonek Gbreve -40
KPX Aogonek Gcommaaccent -40
KPX Aogonek O -55
KPX Aogonek Oacute -55
KPX Aogonek Ocircumflex -55
KPX Aogonek Odieresis -55
KPX Aogonek Ograve -55
KPX Aogonek Ohungarumlaut -55
KPX Aogonek Omacron -55
KPX Aogonek Oslash -55
KPX Aogonek Otilde -55
KPX Aogonek Q -55
KPX Aogonek T -111
KPX Aogonek Tcaron -111
KPX Aogonek Tcommaaccent -111
KPX Aogonek U -55
KPX Aogonek Uacute -55
KPX Aogonek Ucircumflex -55
KPX Aogonek Udieresis -55
KPX Aogonek Ugrave -55
KPX Aogonek Uhungarumlaut -55
KPX Aogonek Umacron -55
KPX Aogonek Uogonek -55
KPX Aogonek Uring -55
KPX Aogonek V -135
KPX Aogonek W -90
KPX Aogonek Y -105
KPX Aogonek Yacute -105
KPX Aogonek Ydieresis -105
KPX Aogonek quoteright -111
KPX Aogonek v -74
KPX Aogonek w -52
KPX Aogonek y -52
KPX Aogonek yacute -52
KPX Aogonek ydieresis -52
KPX Aring C -40
KPX Aring Cacute -40
KPX Aring Ccaron -40
KPX Aring Ccedilla -40
KPX Aring G -40
KPX Aring Gbreve -40
KPX Aring Gcommaaccent -40
KPX Aring O -55
KPX Aring Oacute -55
KPX Aring Ocircumflex -55
KPX Aring Odieresis -55
KPX Aring Ograve -55
KPX Aring Ohungarumlaut -55
KPX Aring Omacron -55
KPX Aring Oslash -55
KPX Aring Otilde -55
KPX Aring Q -55
KPX Aring T -111
KPX Aring Tcaron -111
KPX Aring Tcommaaccent -111
KPX Aring U -55
KPX Aring Uacute -55
KPX Aring Ucircumflex -55
KPX Aring Udieresis -55
KPX Aring Ugrave -55
KPX Aring Uhungarumlaut -55
KPX Aring Umacron -55
KPX Aring Uogonek -55
KPX Aring Uring -55
KPX Aring V -135
KPX Aring W -90
KPX Aring Y -105
KPX Aring Yacute -105
KPX Aring Ydieresis -105
KPX Aring quoteright -111
KPX Aring v -74
KPX Aring w -92
KPX Aring y -92
KPX Aring yacute -92
KPX Aring ydieresis -92
KPX Atilde C -40
KPX Atilde Cacute -40
KPX Atilde Ccaron -40
KPX Atilde Ccedilla -40
KPX Atilde G -40
KPX Atilde Gbreve -40
KPX Atilde Gcommaaccent -40
KPX Atilde O -55
KPX Atilde Oacute -55
KPX Atilde Ocircumflex -55
KPX Atilde Odieresis -55
KPX Atilde Ograve -55
KPX Atilde Ohungarumlaut -55
KPX Atilde Omacron -55
KPX Atilde Oslash -55
KPX Atilde Otilde -55
KPX Atilde Q -55
KPX Atilde T -111
KPX Atilde Tcaron -111
KPX Atilde Tcommaaccent -111
KPX Atilde U -55
KPX Atilde Uacute -55
KPX Atilde Ucircumflex -55
KPX Atilde Udieresis -55
KPX Atilde Ugrave -55
KPX Atilde Uhungarumlaut -55
KPX Atilde Umacron -55
KPX Atilde Uogonek -55
KPX Atilde Uring -55
KPX Atilde V -135
KPX Atilde W -90
KPX Atilde Y -105
KPX Atilde Yacute -105
KPX Atilde Ydieresis -105
KPX Atilde quoteright -111
KPX Atilde v -74
KPX Atilde w -92
KPX Atilde y -92
KPX Atilde yacute -92
KPX Atilde ydieresis -92
KPX B A -35
KPX B Aacute -35
KPX B Abreve -35
KPX B Acircumflex -35
KPX B Adieresis -35
KPX B Agrave -35
KPX B Amacron -35
KPX B Aogonek -35
KPX B Aring -35
KPX B Atilde -35
KPX B U -10
KPX B Uacute -10
KPX B Ucircumflex -10
KPX B Udieresis -10
KPX B Ugrave -10
KPX B Uhungarumlaut -10
KPX B Umacron -10
KPX B Uogonek -10
KPX B Uring -10
KPX D A -40
KPX D Aacute -40
KPX D Abreve -40
KPX D Acircumflex -40
KPX D Adieresis -40
KPX D Agrave -40
KPX D Amacron -40
KPX D Aogonek -40
KPX D Aring -40
KPX D Atilde -40
KPX D V -40
KPX D W -30
KPX D Y -55
KPX D Yacute -55
KPX D Ydieresis -55
KPX Dcaron A -40
KPX Dcaron Aacute -40
KPX Dcaron Abreve -40
KPX Dcaron Acircumflex -40
KPX Dcaron Adieresis -40
KPX Dcaron Agrave -40
KPX Dcaron Amacron -40
KPX Dcaron Aogonek -40
KPX Dcaron Aring -40
KPX Dcaron Atilde -40
KPX Dcaron V -40
KPX Dcaron W -30
KPX Dcaron Y -55
KPX Dcaron Yacute -55
KPX Dcaron Ydieresis -55
KPX Dcroat A -40
KPX Dcroat Aacute -40
KPX Dcroat Abreve -40
KPX Dcroat Acircumflex -40
KPX Dcroat Adieresis -40
KPX Dcroat Agrave -40
KPX Dcroat Amacron -40
KPX Dcroat Aogonek -40
KPX Dcroat Aring -40
KPX Dcroat Atilde -40
KPX Dcroat V -40
KPX Dcroat W -30
KPX Dcroat Y -55
KPX Dcroat Yacute -55
KPX Dcroat Ydieresis -55
KPX F A -74
KPX F Aacute -74
KPX F Abreve -74
KPX F Acircumflex -74
KPX F Adieresis -74
KPX F Agrave -74
KPX F Amacron -74
KPX F Aogonek -74
KPX F Aring -74
KPX F Atilde -74
KPX F a -15
KPX F aacute -15
KPX F abreve -15
KPX F acircumflex -15
KPX F adieresis -15
KPX F agrave -15
KPX F amacron -15
KPX F aogonek -15
KPX F aring -15
KPX F atilde -15
KPX F comma -80
KPX F o -15
KPX F oacute -15
KPX F ocircumflex -15
KPX F odieresis -15
KPX F ograve -15
KPX F ohungarumlaut -15
KPX F omacron -15
KPX F oslash -15
KPX F otilde -15
KPX F period -80
KPX J A -60
KPX J Aacute -60
KPX J Abreve -60
KPX J Acircumflex -60
KPX J Adieresis -60
KPX J Agrave -60
KPX J Amacron -60
KPX J Aogonek -60
KPX J Aring -60
KPX J Atilde -60
KPX K O -30
KPX K Oacute -30
KPX K Ocircumflex -30
KPX K Odieresis -30
KPX K Ograve -30
KPX K Ohungarumlaut -30
KPX K Omacron -30
KPX K Oslash -30
KPX K Otilde -30
KPX K e -25
KPX K eacute -25
KPX K ecaron -25
KPX K ecircumflex -25
KPX K edieresis -25
KPX K edotaccent -25
KPX K egrave -25
KPX K emacron -25
KPX K eogonek -25
KPX K o -35
KPX K oacute -35
KPX K ocircumflex -35
KPX K odieresis -35
KPX K ograve -35
KPX K ohungarumlaut -35
KPX K omacron -35
KPX K oslash -35
KPX K otilde -35
KPX K u -15
KPX K uacute -15
KPX K ucircumflex -15
KPX K udieresis -15
KPX K ugrave -15
KPX K uhungarumlaut -15
KPX K umacron -15
KPX K uogonek -15
KPX K uring -15
KPX K y -25
KPX K yacute -25
KPX K ydieresis -25
KPX Kcommaaccent O -30
KPX Kcommaaccent Oacute -30
KPX Kcommaaccent Ocircumflex -30
KPX Kcommaaccent Odieresis -30
KPX Kcommaaccent Ograve -30
KPX Kcommaaccent Ohungarumlaut -30
KPX Kcommaaccent Omacron -30
KPX Kcommaaccent Oslash -30
KPX Kcommaaccent Otilde -30
KPX Kcommaaccent e -25
KPX Kcommaaccent eacute -25
KPX Kcommaaccent ecaron -25
KPX Kcommaaccent ecircumflex -25
KPX Kcommaaccent edieresis -25
KPX Kcommaaccent edotaccent -25
KPX Kcommaaccent egrave -25
KPX Kcommaaccent emacron -25
KPX Kcommaaccent eogonek -25
KPX Kcommaaccent o -35
KPX Kcommaaccent oacute -35
KPX Kcommaaccent ocircumflex -35
KPX Kcommaaccent odieresis -35
KPX Kcommaaccent ograve -35
KPX Kcommaaccent ohungarumlaut -35
KPX Kcommaaccent omacron -35
KPX Kcommaaccent oslash -35
KPX Kcommaaccent otilde -35
KPX Kcommaaccent u -15
KPX Kcommaaccent uacute -15
KPX Kcommaaccent ucircumflex -15
KPX Kcommaaccent udieresis -15
KPX Kcommaaccent ugrave -15
KPX Kcommaaccent uhungarumlaut -15
KPX Kcommaaccent umacron -15
KPX Kcommaaccent uogonek -15
KPX Kcommaaccent uring -15
KPX Kcommaaccent y -25
KPX Kcommaaccent yacute -25
KPX Kcommaaccent ydieresis -25
KPX L T -92
KPX L Tcaron -92
KPX L Tcommaaccent -92
KPX L V -100
KPX L W -74
KPX L Y -100
KPX L Yacute -100
KPX L Ydieresis -100
KPX L quoteright -92
KPX L y -55
KPX L yacute -55
KPX L ydieresis -55
KPX Lacute T -92
KPX Lacute Tcaron -92
KPX Lacute Tcommaaccent -92
KPX Lacute V -100
KPX Lacute W -74
KPX Lacute Y -100
KPX Lacute Yacute -100
KPX Lacute Ydieresis -100
KPX Lacute quoteright -92
KPX Lacute y -55
KPX Lacute yacute -55
KPX Lacute ydieresis -55
KPX Lcaron quoteright -92
KPX Lcaron y -55
KPX Lcaron yacute -55
KPX Lcaron ydieresis -55
KPX Lcommaaccent T -92
KPX Lcommaaccent Tcaron -92
KPX Lcommaaccent Tcommaaccent -92
KPX Lcommaaccent V -100
KPX Lcommaaccent W -74
KPX Lcommaaccent Y -100
KPX Lcommaaccent Yacute -100
KPX Lcommaaccent Ydieresis -100
KPX Lcommaaccent quoteright -92
KPX Lcommaaccent y -55
KPX Lcommaaccent yacute -55
KPX Lcommaaccent ydieresis -55
KPX Lslash T -92
KPX Lslash Tcaron -92
KPX Lslash Tcommaaccent -92
KPX Lslash V -100
KPX Lslash W -74
KPX Lslash Y -100
KPX Lslash Yacute -100
KPX Lslash Ydieresis -100
KPX Lslash quoteright -92
KPX Lslash y -55
KPX Lslash yacute -55
KPX Lslash ydieresis -55
KPX N A -35
KPX N Aacute -35
KPX N Abreve -35
KPX N Acircumflex -35
KPX N Adieresis -35
KPX N Agrave -35
KPX N Amacron -35
KPX N Aogonek -35
KPX N Aring -35
KPX N Atilde -35
KPX Nacute A -35
KPX Nacute Aacute -35
KPX Nacute Abreve -35
KPX Nacute Acircumflex -35
KPX Nacute Adieresis -35
KPX Nacute Agrave -35
KPX Nacute Amacron -35
KPX Nacute Aogonek -35
KPX Nacute Aring -35
KPX Nacute Atilde -35
KPX Ncaron A -35
KPX Ncaron Aacute -35
KPX Ncaron Abreve -35
KPX Ncaron Acircumflex -35
KPX Ncaron Adieresis -35
KPX Ncaron Agrave -35
KPX Ncaron Amacron -35
KPX Ncaron Aogonek -35
KPX Ncaron Aring -35
KPX Ncaron Atilde -35
KPX Ncommaaccent A -35
KPX Ncommaaccent Aacute -35
KPX Ncommaaccent Abreve -35
KPX Ncommaaccent Acircumflex -35
KPX Ncommaaccent Adieresis -35
KPX Ncommaaccent Agrave -35
KPX Ncommaaccent Amacron -35
KPX Ncommaaccent Aogonek -35
KPX Ncommaaccent Aring -35
KPX Ncommaaccent Atilde -35
KPX Ntilde A -35
KPX Ntilde Aacute -35
KPX Ntilde Abreve -35
KPX Ntilde Acircumflex -35
KPX Ntilde Adieresis -35
KPX Ntilde Agrave -35
KPX Ntilde Amacron -35
KPX Ntilde Aogonek -35
KPX Ntilde Aring -35
KPX Ntilde Atilde -35
KPX O A -35
KPX O Aacute -35
KPX O Abreve -35
KPX O Acircumflex -35
KPX O Adieresis -35
KPX O Agrave -35
KPX O Amacron -35
KPX O Aogonek -35
KPX O Aring -35
KPX O Atilde -35
KPX O T -40
KPX O Tcaron -40
KPX O Tcommaaccent -40
KPX O V -50
KPX O W -35
KPX O X -40
KPX O Y -50
KPX O Yacute -50
KPX O Ydieresis -50
KPX Oacute A -35
KPX Oacute Aacute -35
KPX Oacute Abreve -35
KPX Oacute Acircumflex -35
KPX Oacute Adieresis -35
KPX Oacute Agrave -35
KPX Oacute Amacron -35
KPX Oacute Aogonek -35
KPX Oacute Aring -35
KPX Oacute Atilde -35
KPX Oacute T -40
KPX Oacute Tcaron -40
KPX Oacute Tcommaaccent -40
KPX Oacute V -50
KPX Oacute W -35
KPX Oacute X -40
KPX Oacute Y -50
KPX Oacute Yacute -50
KPX Oacute Ydieresis -50
KPX Ocircumflex A -35
KPX Ocircumflex Aacute -35
KPX Ocircumflex Abreve -35
KPX Ocircumflex Acircumflex -35
KPX Ocircumflex Adieresis -35
KPX Ocircumflex Agrave -35
KPX Ocircumflex Amacron -35
KPX Ocircumflex Aogonek -35
KPX Ocircumflex Aring -35
KPX Ocircumflex Atilde -35
KPX Ocircumflex T -40
KPX Ocircumflex Tcaron -40
KPX Ocircumflex Tcommaaccent -40
KPX Ocircumflex V -50
KPX Ocircumflex W -35
KPX Ocircumflex X -40
KPX Ocircumflex Y -50
KPX Ocircumflex Yacute -50
KPX Ocircumflex Ydieresis -50
KPX Odieresis A -35
KPX Odieresis Aacute -35
KPX Odieresis Abreve -35
KPX Odieresis Acircumflex -35
KPX Odieresis Adieresis -35
KPX Odieresis Agrave -35
KPX Odieresis Amacron -35
KPX Odieresis Aogonek -35
KPX Odieresis Aring -35
KPX Odieresis Atilde -35
KPX Odieresis T -40
KPX Odieresis Tcaron -40
KPX Odieresis Tcommaaccent -40
KPX Odieresis V -50
KPX Odieresis W -35
KPX Odieresis X -40
KPX Odieresis Y -50
KPX Odieresis Yacute -50
KPX Odieresis Ydieresis -50
KPX Ograve A -35
KPX Ograve Aacute -35
KPX Ograve Abreve -35
KPX Ograve Acircumflex -35
KPX Ograve Adieresis -35
KPX Ograve Agrave -35
KPX Ograve Amacron -35
KPX Ograve Aogonek -35
KPX Ograve Aring -35
KPX Ograve Atilde -35
KPX Ograve T -40
KPX Ograve Tcaron -40
KPX Ograve Tcommaaccent -40
KPX Ograve V -50
KPX Ograve W -35
KPX Ograve X -40
KPX Ograve Y -50
KPX Ograve Yacute -50
KPX Ograve Ydieresis -50
KPX Ohungarumlaut A -35
KPX Ohungarumlaut Aacute -35
KPX Ohungarumlaut Abreve -35
KPX Ohungarumlaut Acircumflex -35
KPX Ohungarumlaut Adieresis -35
KPX Ohungarumlaut Agrave -35
KPX Ohungarumlaut Amacron -35
KPX Ohungarumlaut Aogonek -35
KPX Ohungarumlaut Aring -35
KPX Ohungarumlaut Atilde -35
KPX Ohungarumlaut T -40
KPX Ohungarumlaut Tcaron -40
KPX Ohungarumlaut Tcommaaccent -40
KPX Ohungarumlaut V -50
KPX Ohungarumlaut W -35
KPX Ohungarumlaut X -40
KPX Ohungarumlaut Y -50
KPX Ohungarumlaut Yacute -50
KPX Ohungarumlaut Ydieresis -50
KPX Omacron A -35
KPX Omacron Aacute -35
KPX Omacron Abreve -35
KPX Omacron Acircumflex -35
KPX Omacron Adieresis -35
KPX Omacron Agrave -35
KPX Omacron Amacron -35
KPX Omacron Aogonek -35
KPX Omacron Aring -35
KPX Omacron Atilde -35
KPX Omacron T -40
KPX Omacron Tcaron -40
KPX Omacron Tcommaaccent -40
KPX Omacron V -50
KPX Omacron W -35
KPX Omacron X -40
KPX Omacron Y -50
KPX Omacron Yacute -50
KPX Omacron Ydieresis -50
KPX Oslash A -35
KPX Oslash Aacute -35
KPX Oslash Abreve -35
KPX Oslash Acircumflex -35
KPX Oslash Adieresis -35
KPX Oslash Agrave -35
KPX Oslash Amacron -35
KPX Oslash Aogonek -35
KPX Oslash Aring -35
KPX Oslash Atilde -35
KPX Oslash T -40
KPX Oslash Tcaron -40
KPX Oslash Tcommaaccent -40
KPX Oslash V -50
KPX Oslash W -35
KPX Oslash X -40
KPX Oslash Y -50
KPX Oslash Yacute -50
KPX Oslash Ydieresis -50
KPX Otilde A -35
KPX Otilde Aacute -35
KPX Otilde Abreve -35
KPX Otilde Acircumflex -35
KPX Otilde Adieresis -35
KPX Otilde Agrave -35
KPX Otilde Amacron -35
KPX Otilde Aogonek -35
KPX Otilde Aring -35
KPX Otilde Atilde -35
KPX Otilde T -40
KPX Otilde Tcaron -40
KPX Otilde Tcommaaccent -40
KPX Otilde V -50
KPX Otilde W -35
KPX Otilde X -40
KPX Otilde Y -50
KPX Otilde Yacute -50
KPX Otilde Ydieresis -50
KPX P A -92
KPX P Aacute -92
KPX P Abreve -92
KPX P Acircumflex -92
KPX P Adieresis -92
KPX P Agrave -92
KPX P Amacron -92
KPX P Aogonek -92
KPX P Aring -92
KPX P Atilde -92
KPX P a -15
KPX P aacute -15
KPX P abreve -15
KPX P acircumflex -15
KPX P adieresis -15
KPX P agrave -15
KPX P amacron -15
KPX P aogonek -15
KPX P aring -15
KPX P atilde -15
KPX P comma -111
KPX P period -111
KPX Q U -10
KPX Q Uacute -10
KPX Q Ucircumflex -10
KPX Q Udieresis -10
KPX Q Ugrave -10
KPX Q Uhungarumlaut -10
KPX Q Umacron -10
KPX Q Uogonek -10
KPX Q Uring -10
KPX R O -40
KPX R Oacute -40
KPX R Ocircumflex -40
KPX R Odieresis -40
KPX R Ograve -40
KPX R Ohungarumlaut -40
KPX R Omacron -40
KPX R Oslash -40
KPX R Otilde -40
KPX R T -60
KPX R Tcaron -60
KPX R Tcommaaccent -60
KPX R U -40
KPX R Uacute -40
KPX R Ucircumflex -40
KPX R Udieresis -40
KPX R Ugrave -40
KPX R Uhungarumlaut -40
KPX R Umacron -40
KPX R Uogonek -40
KPX R Uring -40
KPX R V -80
KPX R W -55
KPX R Y -65
KPX R Yacute -65
KPX R Ydieresis -65
KPX Racute O -40
KPX Racute Oacute -40
KPX Racute Ocircumflex -40
KPX Racute Odieresis -40
KPX Racute Ograve -40
KPX Racute Ohungarumlaut -40
KPX Racute Omacron -40
KPX Racute Oslash -40
KPX Racute Otilde -40
KPX Racute T -60
KPX Racute Tcaron -60
KPX Racute Tcommaaccent -60
KPX Racute U -40
KPX Racute Uacute -40
KPX Racute Ucircumflex -40
KPX Racute Udieresis -40
KPX Racute Ugrave -40
KPX Racute Uhungarumlaut -40
KPX Racute Umacron -40
KPX Racute Uogonek -40
KPX Racute Uring -40
KPX Racute V -80
KPX Racute W -55
KPX Racute Y -65
KPX Racute Yacute -65
KPX Racute Ydieresis -65
KPX Rcaron O -40
KPX Rcaron Oacute -40
KPX Rcaron Ocircumflex -40
KPX Rcaron Odieresis -40
KPX Rcaron Ograve -40
KPX Rcaron Ohungarumlaut -40
KPX Rcaron Omacron -40
KPX Rcaron Oslash -40
KPX Rcaron Otilde -40
KPX Rcaron T -60
KPX Rcaron Tcaron -60
KPX Rcaron Tcommaaccent -60
KPX Rcaron U -40
KPX Rcaron Uacute -40
KPX Rcaron Ucircumflex -40
KPX Rcaron Udieresis -40
KPX Rcaron Ugrave -40
KPX Rcaron Uhungarumlaut -40
KPX Rcaron Umacron -40
KPX Rcaron Uogonek -40
KPX Rcaron Uring -40
KPX Rcaron V -80
KPX Rcaron W -55
KPX Rcaron Y -65
KPX Rcaron Yacute -65
KPX Rcaron Ydieresis -65
KPX Rcommaaccent O -40
KPX Rcommaaccent Oacute -40
KPX Rcommaaccent Ocircumflex -40
KPX Rcommaaccent Odieresis -40
KPX Rcommaaccent Ograve -40
KPX Rcommaaccent Ohungarumlaut -40
KPX Rcommaaccent Omacron -40
KPX Rcommaaccent Oslash -40
KPX Rcommaaccent Otilde -40
KPX Rcommaaccent T -60
KPX Rcommaaccent Tcaron -60
KPX Rcommaaccent Tcommaaccent -60
KPX Rcommaaccent U -40
KPX Rcommaaccent Uacute -40
KPX Rcommaaccent Ucircumflex -40
KPX Rcommaaccent Udieresis -40
KPX Rcommaaccent Ugrave -40
KPX Rcommaaccent Uhungarumlaut -40
KPX Rcommaaccent Umacron -40
KPX Rcommaaccent Uogonek -40
KPX Rcommaaccent Uring -40
KPX Rcommaaccent V -80
KPX Rcommaaccent W -55
KPX Rcommaaccent Y -65
KPX Rcommaaccent Yacute -65
KPX Rcommaaccent Ydieresis -65
KPX T A -93
KPX T Aacute -93
KPX T Abreve -93
KPX T Acircumflex -93
KPX T Adieresis -93
KPX T Agrave -93
KPX T Amacron -93
KPX T Aogonek -93
KPX T Aring -93
KPX T Atilde -93
KPX T O -18
KPX T Oacute -18
KPX T Ocircumflex -18
KPX T Odieresis -18
KPX T Ograve -18
KPX T Ohungarumlaut -18
KPX T Omacron -18
KPX T Oslash -18
KPX T Otilde -18
KPX T a -80
KPX T aacute -80
KPX T abreve -80
KPX T acircumflex -80
KPX T adieresis -40
KPX T agrave -40
KPX T amacron -40
KPX T aogonek -80
KPX T aring -80
KPX T atilde -40
KPX T colon -50
KPX T comma -74
KPX T e -70
KPX T eacute -70
KPX T ecaron -70
KPX T ecircumflex -70
KPX T edieresis -30
KPX T edotaccent -70
KPX T egrave -70
KPX T emacron -30
KPX T eogonek -70
KPX T hyphen -92
KPX T i -35
KPX T iacute -35
KPX T iogonek -35
KPX T o -80
KPX T oacute -80
KPX T ocircumflex -80
KPX T odieresis -80
KPX T ograve -80
KPX T ohungarumlaut -80
KPX T omacron -80
KPX T oslash -80
KPX T otilde -80
KPX T period -74
KPX T r -35
KPX T racute -35
KPX T rcaron -35
KPX T rcommaaccent -35
KPX T semicolon -55
KPX T u -45
KPX T uacute -45
KPX T ucircumflex -45
KPX T udieresis -45
KPX T ugrave -45
KPX T uhungarumlaut -45
KPX T umacron -45
KPX T uogonek -45
KPX T uring -45
KPX T w -80
KPX T y -80
KPX T yacute -80
KPX T ydieresis -80
KPX Tcaron A -93
KPX Tcaron Aacute -93
KPX Tcaron Abreve -93
KPX Tcaron Acircumflex -93
KPX Tcaron Adieresis -93
KPX Tcaron Agrave -93
KPX Tcaron Amacron -93
KPX Tcaron Aogonek -93
KPX Tcaron Aring -93
KPX Tcaron Atilde -93
KPX Tcaron O -18
KPX Tcaron Oacute -18
KPX Tcaron Ocircumflex -18
KPX Tcaron Odieresis -18
KPX Tcaron Ograve -18
KPX Tcaron Ohungarumlaut -18
KPX Tcaron Omacron -18
KPX Tcaron Oslash -18
KPX Tcaron Otilde -18
KPX Tcaron a -80
KPX Tcaron aacute -80
KPX Tcaron abreve -80
KPX Tcaron acircumflex -80
KPX Tcaron adieresis -40
KPX Tcaron agrave -40
KPX Tcaron amacron -40
KPX Tcaron aogonek -80
KPX Tcaron aring -80
KPX Tcaron atilde -40
KPX Tcaron colon -50
KPX Tcaron comma -74
KPX Tcaron e -70
KPX Tcaron eacute -70
KPX Tcaron ecaron -70
KPX Tcaron ecircumflex -30
KPX Tcaron edieresis -30
KPX Tcaron edotaccent -70
KPX Tcaron egrave -70
KPX Tcaron emacron -30
KPX Tcaron eogonek -70
KPX Tcaron hyphen -92
KPX Tcaron i -35
KPX Tcaron iacute -35
KPX Tcaron iogonek -35
KPX Tcaron o -80
KPX Tcaron oacute -80
KPX Tcaron ocircumflex -80
KPX Tcaron odieresis -80
KPX Tcaron ograve -80
KPX Tcaron ohungarumlaut -80
KPX Tcaron omacron -80
KPX Tcaron oslash -80
KPX Tcaron otilde -80
KPX Tcaron period -74
KPX Tcaron r -35
KPX Tcaron racute -35
KPX Tcaron rcaron -35
KPX Tcaron rcommaaccent -35
KPX Tcaron semicolon -55
KPX Tcaron u -45
KPX Tcaron uacute -45
KPX Tcaron ucircumflex -45
KPX Tcaron udieresis -45
KPX Tcaron ugrave -45
KPX Tcaron uhungarumlaut -45
KPX Tcaron umacron -45
KPX Tcaron uogonek -45
KPX Tcaron uring -45
KPX Tcaron w -80
KPX Tcaron y -80
KPX Tcaron yacute -80
KPX Tcaron ydieresis -80
KPX Tcommaaccent A -93
KPX Tcommaaccent Aacute -93
KPX Tcommaaccent Abreve -93
KPX Tcommaaccent Acircumflex -93
KPX Tcommaaccent Adieresis -93
KPX Tcommaaccent Agrave -93
KPX Tcommaaccent Amacron -93
KPX Tcommaaccent Aogonek -93
KPX Tcommaaccent Aring -93
KPX Tcommaaccent Atilde -93
KPX Tcommaaccent O -18
KPX Tcommaaccent Oacute -18
KPX Tcommaaccent Ocircumflex -18
KPX Tcommaaccent Odieresis -18
KPX Tcommaaccent Ograve -18
KPX Tcommaaccent Ohungarumlaut -18
KPX Tcommaaccent Omacron -18
KPX Tcommaaccent Oslash -18
KPX Tcommaaccent Otilde -18
KPX Tcommaaccent a -80
KPX Tcommaaccent aacute -80
KPX Tcommaaccent abreve -80
KPX Tcommaaccent acircumflex -80
KPX Tcommaaccent adieresis -40
KPX Tcommaaccent agrave -40
KPX Tcommaaccent amacron -40
KPX Tcommaaccent aogonek -80
KPX Tcommaaccent aring -80
KPX Tcommaaccent atilde -40
KPX Tcommaaccent colon -50
KPX Tcommaaccent comma -74
KPX Tcommaaccent e -70
KPX Tcommaaccent eacute -70
KPX Tcommaaccent ecaron -70
KPX Tcommaaccent ecircumflex -30
KPX Tcommaaccent edieresis -30
KPX Tcommaaccent edotaccent -70
KPX Tcommaaccent egrave -30
KPX Tcommaaccent emacron -70
KPX Tcommaaccent eogonek -70
KPX Tcommaaccent hyphen -92
KPX Tcommaaccent i -35
KPX Tcommaaccent iacute -35
KPX Tcommaaccent iogonek -35
KPX Tcommaaccent o -80
KPX Tcommaaccent oacute -80
KPX Tcommaaccent ocircumflex -80
KPX Tcommaaccent odieresis -80
KPX Tcommaaccent ograve -80
KPX Tcommaaccent ohungarumlaut -80
KPX Tcommaaccent omacron -80
KPX Tcommaaccent oslash -80
KPX Tcommaaccent otilde -80
KPX Tcommaaccent period -74
KPX Tcommaaccent r -35
KPX Tcommaaccent racute -35
KPX Tcommaaccent rcaron -35
KPX Tcommaaccent rcommaaccent -35
KPX Tcommaaccent semicolon -55
KPX Tcommaaccent u -45
KPX Tcommaaccent uacute -45
KPX Tcommaaccent ucircumflex -45
KPX Tcommaaccent udieresis -45
KPX Tcommaaccent ugrave -45
KPX Tcommaaccent uhungarumlaut -45
KPX Tcommaaccent umacron -45
KPX Tcommaaccent uogonek -45
KPX Tcommaaccent uring -45
KPX Tcommaaccent w -80
KPX Tcommaaccent y -80
KPX Tcommaaccent yacute -80
KPX Tcommaaccent ydieresis -80
KPX U A -40
KPX U Aacute -40
KPX U Abreve -40
KPX U Acircumflex -40
KPX U Adieresis -40
KPX U Agrave -40
KPX U Amacron -40
KPX U Aogonek -40
KPX U Aring -40
KPX U Atilde -40
KPX Uacute A -40
KPX Uacute Aacute -40
KPX Uacute Abreve -40
KPX Uacute Acircumflex -40
KPX Uacute Adieresis -40
KPX Uacute Agrave -40
KPX Uacute Amacron -40
KPX Uacute Aogonek -40
KPX Uacute Aring -40
KPX Uacute Atilde -40
KPX Ucircumflex A -40
KPX Ucircumflex Aacute -40
KPX Ucircumflex Abreve -40
KPX Ucircumflex Acircumflex -40
KPX Ucircumflex Adieresis -40
KPX Ucircumflex Agrave -40
KPX Ucircumflex Amacron -40
KPX Ucircumflex Aogonek -40
KPX Ucircumflex Aring -40
KPX Ucircumflex Atilde -40
KPX Udieresis A -40
KPX Udieresis Aacute -40
KPX Udieresis Abreve -40
KPX Udieresis Acircumflex -40
KPX Udieresis Adieresis -40
KPX Udieresis Agrave -40
KPX Udieresis Amacron -40
KPX Udieresis Aogonek -40
KPX Udieresis Aring -40
KPX Udieresis Atilde -40
KPX Ugrave A -40
KPX Ugrave Aacute -40
KPX Ugrave Abreve -40
KPX Ugrave Acircumflex -40
KPX Ugrave Adieresis -40
KPX Ugrave Agrave -40
KPX Ugrave Amacron -40
KPX Ugrave Aogonek -40
KPX Ugrave Aring -40
KPX Ugrave Atilde -40
KPX Uhungarumlaut A -40
KPX Uhungarumlaut Aacute -40
KPX Uhungarumlaut Abreve -40
KPX Uhungarumlaut Acircumflex -40
KPX Uhungarumlaut Adieresis -40
KPX Uhungarumlaut Agrave -40
KPX Uhungarumlaut Amacron -40
KPX Uhungarumlaut Aogonek -40
KPX Uhungarumlaut Aring -40
KPX Uhungarumlaut Atilde -40
KPX Umacron A -40
KPX Umacron Aacute -40
KPX Umacron Abreve -40
KPX Umacron Acircumflex -40
KPX Umacron Adieresis -40
KPX Umacron Agrave -40
KPX Umacron Amacron -40
KPX Umacron Aogonek -40
KPX Umacron Aring -40
KPX Umacron Atilde -40
KPX Uogonek A -40
KPX Uogonek Aacute -40
KPX Uogonek Abreve -40
KPX Uogonek Acircumflex -40
KPX Uogonek Adieresis -40
KPX Uogonek Agrave -40
KPX Uogonek Amacron -40
KPX Uogonek Aogonek -40
KPX Uogonek Aring -40
KPX Uogonek Atilde -40
KPX Uring A -40
KPX Uring Aacute -40
KPX Uring Abreve -40
KPX Uring Acircumflex -40
KPX Uring Adieresis -40
KPX Uring Agrave -40
KPX Uring Amacron -40
KPX Uring Aogonek -40
KPX Uring Aring -40
KPX Uring Atilde -40
KPX V A -135
KPX V Aacute -135
KPX V Abreve -135
KPX V Acircumflex -135
KPX V Adieresis -135
KPX V Agrave -135
KPX V Amacron -135
KPX V Aogonek -135
KPX V Aring -135
KPX V Atilde -135
KPX V G -15
KPX V Gbreve -15
KPX V Gcommaaccent -15
KPX V O -40
KPX V Oacute -40
KPX V Ocircumflex -40
KPX V Odieresis -40
KPX V Ograve -40
KPX V Ohungarumlaut -40
KPX V Omacron -40
KPX V Oslash -40
KPX V Otilde -40
KPX V a -111
KPX V aacute -111
KPX V abreve -111
KPX V acircumflex -71
KPX V adieresis -71
KPX V agrave -71
KPX V amacron -71
KPX V aogonek -111
KPX V aring -111
KPX V atilde -71
KPX V colon -74
KPX V comma -129
KPX V e -111
KPX V eacute -111
KPX V ecaron -71
KPX V ecircumflex -71
KPX V edieresis -71
KPX V edotaccent -111
KPX V egrave -71
KPX V emacron -71
KPX V eogonek -111
KPX V hyphen -100
KPX V i -60
KPX V iacute -60
KPX V icircumflex -20
KPX V idieresis -20
KPX V igrave -20
KPX V imacron -20
KPX V iogonek -60
KPX V o -129
KPX V oacute -129
KPX V ocircumflex -129
KPX V odieresis -89
KPX V ograve -89
KPX V ohungarumlaut -129
KPX V omacron -89
KPX V oslash -129
KPX V otilde -89
KPX V period -129
KPX V semicolon -74
KPX V u -75
KPX V uacute -75
KPX V ucircumflex -75
KPX V udieresis -75
KPX V ugrave -75
KPX V uhungarumlaut -75
KPX V umacron -75
KPX V uogonek -75
KPX V uring -75
KPX W A -120
KPX W Aacute -120
KPX W Abreve -120
KPX W Acircumflex -120
KPX W Adieresis -120
KPX W Agrave -120
KPX W Amacron -120
KPX W Aogonek -120
KPX W Aring -120
KPX W Atilde -120
KPX W O -10
KPX W Oacute -10
KPX W Ocircumflex -10
KPX W Odieresis -10
KPX W Ograve -10
KPX W Ohungarumlaut -10
KPX W Omacron -10
KPX W Oslash -10
KPX W Otilde -10
KPX W a -80
KPX W aacute -80
KPX W abreve -80
KPX W acircumflex -80
KPX W adieresis -80
KPX W agrave -80
KPX W amacron -80
KPX W aogonek -80
KPX W aring -80
KPX W atilde -80
KPX W colon -37
KPX W comma -92
KPX W e -80
KPX W eacute -80
KPX W ecaron -80
KPX W ecircumflex -80
KPX W edieresis -40
KPX W edotaccent -80
KPX W egrave -40
KPX W emacron -40
KPX W eogonek -80
KPX W hyphen -65
KPX W i -40
KPX W iacute -40
KPX W iogonek -40
KPX W o -80
KPX W oacute -80
KPX W ocircumflex -80
KPX W odieresis -80
KPX W ograve -80
KPX W ohungarumlaut -80
KPX W omacron -80
KPX W oslash -80
KPX W otilde -80
KPX W period -92
KPX W semicolon -37
KPX W u -50
KPX W uacute -50
KPX W ucircumflex -50
KPX W udieresis -50
KPX W ugrave -50
KPX W uhungarumlaut -50
KPX W umacron -50
KPX W uogonek -50
KPX W uring -50
KPX W y -73
KPX W yacute -73
KPX W ydieresis -73
KPX Y A -120
KPX Y Aacute -120
KPX Y Abreve -120
KPX Y Acircumflex -120
KPX Y Adieresis -120
KPX Y Agrave -120
KPX Y Amacron -120
KPX Y Aogonek -120
KPX Y Aring -120
KPX Y Atilde -120
KPX Y O -30
KPX Y Oacute -30
KPX Y Ocircumflex -30
KPX Y Odieresis -30
KPX Y Ograve -30
KPX Y Ohungarumlaut -30
KPX Y Omacron -30
KPX Y Oslash -30
KPX Y Otilde -30
KPX Y a -100
KPX Y aacute -100
KPX Y abreve -100
KPX Y acircumflex -100
KPX Y adieresis -60
KPX Y agrave -60
KPX Y amacron -60
KPX Y aogonek -100
KPX Y aring -100
KPX Y atilde -60
KPX Y colon -92
KPX Y comma -129
KPX Y e -100
KPX Y eacute -100
KPX Y ecaron -100
KPX Y ecircumflex -100
KPX Y edieresis -60
KPX Y edotaccent -100
KPX Y egrave -60
KPX Y emacron -60
KPX Y eogonek -100
KPX Y hyphen -111
KPX Y i -55
KPX Y iacute -55
KPX Y iogonek -55
KPX Y o -110
KPX Y oacute -110
KPX Y ocircumflex -110
KPX Y odieresis -70
KPX Y ograve -70
KPX Y ohungarumlaut -110
KPX Y omacron -70
KPX Y oslash -110
KPX Y otilde -70
KPX Y period -129
KPX Y semicolon -92
KPX Y u -111
KPX Y uacute -111
KPX Y ucircumflex -111
KPX Y udieresis -71
KPX Y ugrave -71
KPX Y uhungarumlaut -111
KPX Y umacron -71
KPX Y uogonek -111
KPX Y uring -111
KPX Yacute A -120
KPX Yacute Aacute -120
KPX Yacute Abreve -120
KPX Yacute Acircumflex -120
KPX Yacute Adieresis -120
KPX Yacute Agrave -120
KPX Yacute Amacron -120
KPX Yacute Aogonek -120
KPX Yacute Aring -120
KPX Yacute Atilde -120
KPX Yacute O -30
KPX Yacute Oacute -30
KPX Yacute Ocircumflex -30
KPX Yacute Odieresis -30
KPX Yacute Ograve -30
KPX Yacute Ohungarumlaut -30
KPX Yacute Omacron -30
KPX Yacute Oslash -30
KPX Yacute Otilde -30
KPX Yacute a -100
KPX Yacute aacute -100
KPX Yacute abreve -100
KPX Yacute acircumflex -100
KPX Yacute adieresis -60
KPX Yacute agrave -60
KPX Yacute amacron -60
KPX Yacute aogonek -100
KPX Yacute aring -100
KPX Yacute atilde -60
KPX Yacute colon -92
KPX Yacute comma -129
KPX Yacute e -100
KPX Yacute eacute -100
KPX Yacute ecaron -100
KPX Yacute ecircumflex -100
KPX Yacute edieresis -60
KPX Yacute edotaccent -100
KPX Yacute egrave -60
KPX Yacute emacron -60
KPX Yacute eogonek -100
KPX Yacute hyphen -111
KPX Yacute i -55
KPX Yacute iacute -55
KPX Yacute iogonek -55
KPX Yacute o -110
KPX Yacute oacute -110
KPX Yacute ocircumflex -110
KPX Yacute odieresis -70
KPX Yacute ograve -70
KPX Yacute ohungarumlaut -110
KPX Yacute omacron -70
KPX Yacute oslash -110
KPX Yacute otilde -70
KPX Yacute period -129
KPX Yacute semicolon -92
KPX Yacute u -111
KPX Yacute uacute -111
KPX Yacute ucircumflex -111
KPX Yacute udieresis -71
KPX Yacute ugrave -71
KPX Yacute uhungarumlaut -111
KPX Yacute umacron -71
KPX Yacute uogonek -111
KPX Yacute uring -111
KPX Ydieresis A -120
KPX Ydieresis Aacute -120
KPX Ydieresis Abreve -120
KPX Ydieresis Acircumflex -120
KPX Ydieresis Adieresis -120
KPX Ydieresis Agrave -120
KPX Ydieresis Amacron -120
KPX Ydieresis Aogonek -120
KPX Ydieresis Aring -120
KPX Ydieresis Atilde -120
KPX Ydieresis O -30
KPX Ydieresis Oacute -30
KPX Ydieresis Ocircumflex -30
KPX Ydieresis Odieresis -30
KPX Ydieresis Ograve -30
KPX Ydieresis Ohungarumlaut -30
KPX Ydieresis Omacron -30
KPX Ydieresis Oslash -30
KPX Ydieresis Otilde -30
KPX Ydieresis a -100
KPX Ydieresis aacute -100
KPX Ydieresis abreve -100
KPX Ydieresis acircumflex -100
KPX Ydieresis adieresis -60
KPX Ydieresis agrave -60
KPX Ydieresis amacron -60
KPX Ydieresis aogonek -100
KPX Ydieresis aring -100
KPX Ydieresis atilde -100
KPX Ydieresis colon -92
KPX Ydieresis comma -129
KPX Ydieresis e -100
KPX Ydieresis eacute -100
KPX Ydieresis ecaron -100
KPX Ydieresis ecircumflex -100
KPX Ydieresis edieresis -60
KPX Ydieresis edotaccent -100
KPX Ydieresis egrave -60
KPX Ydieresis emacron -60
KPX Ydieresis eogonek -100
KPX Ydieresis hyphen -111
KPX Ydieresis i -55
KPX Ydieresis iacute -55
KPX Ydieresis iogonek -55
KPX Ydieresis o -110
KPX Ydieresis oacute -110
KPX Ydieresis ocircumflex -110
KPX Ydieresis odieresis -70
KPX Ydieresis ograve -70
KPX Ydieresis ohungarumlaut -110
KPX Ydieresis omacron -70
KPX Ydieresis oslash -110
KPX Ydieresis otilde -70
KPX Ydieresis period -129
KPX Ydieresis semicolon -92
KPX Ydieresis u -111
KPX Ydieresis uacute -111
KPX Ydieresis ucircumflex -111
KPX Ydieresis udieresis -71
KPX Ydieresis ugrave -71
KPX Ydieresis uhungarumlaut -111
KPX Ydieresis umacron -71
KPX Ydieresis uogonek -111
KPX Ydieresis uring -111
KPX a v -20
KPX a w -15
KPX aacute v -20
KPX aacute w -15
KPX abreve v -20
KPX abreve w -15
KPX acircumflex v -20
KPX acircumflex w -15
KPX adieresis v -20
KPX adieresis w -15
KPX agrave v -20
KPX agrave w -15
KPX amacron v -20
KPX amacron w -15
KPX aogonek v -20
KPX aogonek w -15
KPX aring v -20
KPX aring w -15
KPX atilde v -20
KPX atilde w -15
KPX b period -40
KPX b u -20
KPX b uacute -20
KPX b ucircumflex -20
KPX b udieresis -20
KPX b ugrave -20
KPX b uhungarumlaut -20
KPX b umacron -20
KPX b uogonek -20
KPX b uring -20
KPX b v -15
KPX c y -15
KPX c yacute -15
KPX c ydieresis -15
KPX cacute y -15
KPX cacute yacute -15
KPX cacute ydieresis -15
KPX ccaron y -15
KPX ccaron yacute -15
KPX ccaron ydieresis -15
KPX ccedilla y -15
KPX ccedilla yacute -15
KPX ccedilla ydieresis -15
KPX comma quotedblright -70
KPX comma quoteright -70
KPX e g -15
KPX e gbreve -15
KPX e gcommaaccent -15
KPX e v -25
KPX e w -25
KPX e x -15
KPX e y -15
KPX e yacute -15
KPX e ydieresis -15
KPX eacute g -15
KPX eacute gbreve -15
KPX eacute gcommaaccent -15
KPX eacute v -25
KPX eacute w -25
KPX eacute x -15
KPX eacute y -15
KPX eacute yacute -15
KPX eacute ydieresis -15
KPX ecaron g -15
KPX ecaron gbreve -15
KPX ecaron gcommaaccent -15
KPX ecaron v -25
KPX ecaron w -25
KPX ecaron x -15
KPX ecaron y -15
KPX ecaron yacute -15
KPX ecaron ydieresis -15
KPX ecircumflex g -15
KPX ecircumflex gbreve -15
KPX ecircumflex gcommaaccent -15
KPX ecircumflex v -25
KPX ecircumflex w -25
KPX ecircumflex x -15
KPX ecircumflex y -15
KPX ecircumflex yacute -15
KPX ecircumflex ydieresis -15
KPX edieresis g -15
KPX edieresis gbreve -15
KPX edieresis gcommaaccent -15
KPX edieresis v -25
KPX edieresis w -25
KPX edieresis x -15
KPX edieresis y -15
KPX edieresis yacute -15
KPX edieresis ydieresis -15
KPX edotaccent g -15
KPX edotaccent gbreve -15
KPX edotaccent gcommaaccent -15
KPX edotaccent v -25
KPX edotaccent w -25
KPX edotaccent x -15
KPX edotaccent y -15
KPX edotaccent yacute -15
KPX edotaccent ydieresis -15
KPX egrave g -15
KPX egrave gbreve -15
KPX egrave gcommaaccent -15
KPX egrave v -25
KPX egrave w -25
KPX egrave x -15
KPX egrave y -15
KPX egrave yacute -15
KPX egrave ydieresis -15
KPX emacron g -15
KPX emacron gbreve -15
KPX emacron gcommaaccent -15
KPX emacron v -25
KPX emacron w -25
KPX emacron x -15
KPX emacron y -15
KPX emacron yacute -15
KPX emacron ydieresis -15
KPX eogonek g -15
KPX eogonek gbreve -15
KPX eogonek gcommaaccent -15
KPX eogonek v -25
KPX eogonek w -25
KPX eogonek x -15
KPX eogonek y -15
KPX eogonek yacute -15
KPX eogonek ydieresis -15
KPX f a -10
KPX f aacute -10
KPX f abreve -10
KPX f acircumflex -10
KPX f adieresis -10
KPX f agrave -10
KPX f amacron -10
KPX f aogonek -10
KPX f aring -10
KPX f atilde -10
KPX f dotlessi -50
KPX f f -25
KPX f i -20
KPX f iacute -20
KPX f quoteright 55
KPX g a -5
KPX g aacute -5
KPX g abreve -5
KPX g acircumflex -5
KPX g adieresis -5
KPX g agrave -5
KPX g amacron -5
KPX g aogonek -5
KPX g aring -5
KPX g atilde -5
KPX gbreve a -5
KPX gbreve aacute -5
KPX gbreve abreve -5
KPX gbreve acircumflex -5
KPX gbreve adieresis -5
KPX gbreve agrave -5
KPX gbreve amacron -5
KPX gbreve aogonek -5
KPX gbreve aring -5
KPX gbreve atilde -5
KPX gcommaaccent a -5
KPX gcommaaccent aacute -5
KPX gcommaaccent abreve -5
KPX gcommaaccent acircumflex -5
KPX gcommaaccent adieresis -5
KPX gcommaaccent agrave -5
KPX gcommaaccent amacron -5
KPX gcommaaccent aogonek -5
KPX gcommaaccent aring -5
KPX gcommaaccent atilde -5
KPX h y -5
KPX h yacute -5
KPX h ydieresis -5
KPX i v -25
KPX iacute v -25
KPX icircumflex v -25
KPX idieresis v -25
KPX igrave v -25
KPX imacron v -25
KPX iogonek v -25
KPX k e -10
KPX k eacute -10
KPX k ecaron -10
KPX k ecircumflex -10
KPX k edieresis -10
KPX k edotaccent -10
KPX k egrave -10
KPX k emacron -10
KPX k eogonek -10
KPX k o -10
KPX k oacute -10
KPX k ocircumflex -10
KPX k odieresis -10
KPX k ograve -10
KPX k ohungarumlaut -10
KPX k omacron -10
KPX k oslash -10
KPX k otilde -10
KPX k y -15
KPX k yacute -15
KPX k ydieresis -15
KPX kcommaaccent e -10
KPX kcommaaccent eacute -10
KPX kcommaaccent ecaron -10
KPX kcommaaccent ecircumflex -10
KPX kcommaaccent edieresis -10
KPX kcommaaccent edotaccent -10
KPX kcommaaccent egrave -10
KPX kcommaaccent emacron -10
KPX kcommaaccent eogonek -10
KPX kcommaaccent o -10
KPX kcommaaccent oacute -10
KPX kcommaaccent ocircumflex -10
KPX kcommaaccent odieresis -10
KPX kcommaaccent ograve -10
KPX kcommaaccent ohungarumlaut -10
KPX kcommaaccent omacron -10
KPX kcommaaccent oslash -10
KPX kcommaaccent otilde -10
KPX kcommaaccent y -15
KPX kcommaaccent yacute -15
KPX kcommaaccent ydieresis -15
KPX l w -10
KPX lacute w -10
KPX lcommaaccent w -10
KPX lslash w -10
KPX n v -40
KPX n y -15
KPX n yacute -15
KPX n ydieresis -15
KPX nacute v -40
KPX nacute y -15
KPX nacute yacute -15
KPX nacute ydieresis -15
KPX ncaron v -40
KPX ncaron y -15
KPX ncaron yacute -15
KPX ncaron ydieresis -15
KPX ncommaaccent v -40
KPX ncommaaccent y -15
KPX ncommaaccent yacute -15
KPX ncommaaccent ydieresis -15
KPX ntilde v -40
KPX ntilde y -15
KPX ntilde yacute -15
KPX ntilde ydieresis -15
KPX o v -15
KPX o w -25
KPX o y -10
KPX o yacute -10
KPX o ydieresis -10
KPX oacute v -15
KPX oacute w -25
KPX oacute y -10
KPX oacute yacute -10
KPX oacute ydieresis -10
KPX ocircumflex v -15
KPX ocircumflex w -25
KPX ocircumflex y -10
KPX ocircumflex yacute -10
KPX ocircumflex ydieresis -10
KPX odieresis v -15
KPX odieresis w -25
KPX odieresis y -10
KPX odieresis yacute -10
KPX odieresis ydieresis -10
KPX ograve v -15
KPX ograve w -25
KPX ograve y -10
KPX ograve yacute -10
KPX ograve ydieresis -10
KPX ohungarumlaut v -15
KPX ohungarumlaut w -25
KPX ohungarumlaut y -10
KPX ohungarumlaut yacute -10
KPX ohungarumlaut ydieresis -10
KPX omacron v -15
KPX omacron w -25
KPX omacron y -10
KPX omacron yacute -10
KPX omacron ydieresis -10
KPX oslash v -15
KPX oslash w -25
KPX oslash y -10
KPX oslash yacute -10
KPX oslash ydieresis -10
KPX otilde v -15
KPX otilde w -25
KPX otilde y -10
KPX otilde yacute -10
KPX otilde ydieresis -10
KPX p y -10
KPX p yacute -10
KPX p ydieresis -10
KPX period quotedblright -70
KPX period quoteright -70
KPX quotedblleft A -80
KPX quotedblleft Aacute -80
KPX quotedblleft Abreve -80
KPX quotedblleft Acircumflex -80
KPX quotedblleft Adieresis -80
KPX quotedblleft Agrave -80
KPX quotedblleft Amacron -80
KPX quotedblleft Aogonek -80
KPX quotedblleft Aring -80
KPX quotedblleft Atilde -80
KPX quoteleft A -80
KPX quoteleft Aacute -80
KPX quoteleft Abreve -80
KPX quoteleft Acircumflex -80
KPX quoteleft Adieresis -80
KPX quoteleft Agrave -80
KPX quoteleft Amacron -80
KPX quoteleft Aogonek -80
KPX quoteleft Aring -80
KPX quoteleft Atilde -80
KPX quoteleft quoteleft -74
KPX quoteright d -50
KPX quoteright dcroat -50
KPX quoteright l -10
KPX quoteright lacute -10
KPX quoteright lcommaaccent -10
KPX quoteright lslash -10
KPX quoteright quoteright -74
KPX quoteright r -50
KPX quoteright racute -50
KPX quoteright rcaron -50
KPX quoteright rcommaaccent -50
KPX quoteright s -55
KPX quoteright sacute -55
KPX quoteright scaron -55
KPX quoteright scedilla -55
KPX quoteright scommaaccent -55
KPX quoteright space -74
KPX quoteright t -18
KPX quoteright tcommaaccent -18
KPX quoteright v -50
KPX r comma -40
KPX r g -18
KPX r gbreve -18
KPX r gcommaaccent -18
KPX r hyphen -20
KPX r period -55
KPX racute comma -40
KPX racute g -18
KPX racute gbreve -18
KPX racute gcommaaccent -18
KPX racute hyphen -20
KPX racute period -55
KPX rcaron comma -40
KPX rcaron g -18
KPX rcaron gbreve -18
KPX rcaron gcommaaccent -18
KPX rcaron hyphen -20
KPX rcaron period -55
KPX rcommaaccent comma -40
KPX rcommaaccent g -18
KPX rcommaaccent gbreve -18
KPX rcommaaccent gcommaaccent -18
KPX rcommaaccent hyphen -20
KPX rcommaaccent period -55
KPX space A -55
KPX space Aacute -55
KPX space Abreve -55
KPX space Acircumflex -55
KPX space Adieresis -55
KPX space Agrave -55
KPX space Amacron -55
KPX space Aogonek -55
KPX space Aring -55
KPX space Atilde -55
KPX space T -18
KPX space Tcaron -18
KPX space Tcommaaccent -18
KPX space V -50
KPX space W -30
KPX space Y -90
KPX space Yacute -90
KPX space Ydieresis -90
KPX v a -25
KPX v aacute -25
KPX v abreve -25
KPX v acircumflex -25
KPX v adieresis -25
KPX v agrave -25
KPX v amacron -25
KPX v aogonek -25
KPX v aring -25
KPX v atilde -25
KPX v comma -65
KPX v e -15
KPX v eacute -15
KPX v ecaron -15
KPX v ecircumflex -15
KPX v edieresis -15
KPX v edotaccent -15
KPX v egrave -15
KPX v emacron -15
KPX v eogonek -15
KPX v o -20
KPX v oacute -20
KPX v ocircumflex -20
KPX v odieresis -20
KPX v ograve -20
KPX v ohungarumlaut -20
KPX v omacron -20
KPX v oslash -20
KPX v otilde -20
KPX v period -65
KPX w a -10
KPX w aacute -10
KPX w abreve -10
KPX w acircumflex -10
KPX w adieresis -10
KPX w agrave -10
KPX w amacron -10
KPX w aogonek -10
KPX w aring -10
KPX w atilde -10
KPX w comma -65
KPX w o -10
KPX w oacute -10
KPX w ocircumflex -10
KPX w odieresis -10
KPX w ograve -10
KPX w ohungarumlaut -10
KPX w omacron -10
KPX w oslash -10
KPX w otilde -10
KPX w period -65
KPX x e -15
KPX x eacute -15
KPX x ecaron -15
KPX x ecircumflex -15
KPX x edieresis -15
KPX x edotaccent -15
KPX x egrave -15
KPX x emacron -15
KPX x eogonek -15
KPX y comma -65
KPX y period -65
KPX yacute comma -65
KPX yacute period -65
KPX ydieresis comma -65
KPX ydieresis period -65
EndKernPairs
EndKernData
EndFontMetrics"

let times_bold_afm = "StartFontMetrics 4.1
Comment Copyright (c) 1985, 1987, 1989, 1990, 1993, 1997 Adobe Systems Incorporated.  All Rights Reserved.
Comment Creation Date: Thu May  1 12:52:56 1997
Comment UniqueID 43065
Comment VMusage 41636 52661
FontName Times-Bold
FullName Times Bold
FamilyName Times
Weight Bold
ItalicAngle 0
IsFixedPitch false
CharacterSet ExtendedRoman
FontBBox -168 -218 1000 935 
UnderlinePosition -100
UnderlineThickness 50
Version 002.000
Notice Copyright (c) 1985, 1987, 1989, 1990, 1993, 1997 Adobe Systems Incorporated.  All Rights Reserved.Times is a trademark of Linotype-Hell AG and/or its subsidiaries.
EncodingScheme AdobeStandardEncoding
CapHeight 676
XHeight 461
Ascender 683
Descender -217
StdHW 44
StdVW 139
StartCharMetrics 315
C 32 ; WX 250 ; N space ; B 0 0 0 0 ;
C 33 ; WX 333 ; N exclam ; B 81 -13 251 691 ;
C 34 ; WX 555 ; N quotedbl ; B 83 404 472 691 ;
C 35 ; WX 500 ; N numbersign ; B 4 0 496 700 ;
C 36 ; WX 500 ; N dollar ; B 29 -99 472 750 ;
C 37 ; WX 1000 ; N percent ; B 124 -14 877 692 ;
C 38 ; WX 833 ; N ampersand ; B 62 -16 787 691 ;
C 39 ; WX 333 ; N quoteright ; B 79 356 263 691 ;
C 40 ; WX 333 ; N parenleft ; B 46 -168 306 694 ;
C 41 ; WX 333 ; N parenright ; B 27 -168 287 694 ;
C 42 ; WX 500 ; N asterisk ; B 56 255 447 691 ;
C 43 ; WX 570 ; N plus ; B 33 0 537 506 ;
C 44 ; WX 250 ; N comma ; B 39 -180 223 155 ;
C 45 ; WX 333 ; N hyphen ; B 44 171 287 287 ;
C 46 ; WX 250 ; N period ; B 41 -13 210 156 ;
C 47 ; WX 278 ; N slash ; B -24 -19 302 691 ;
C 48 ; WX 500 ; N zero ; B 24 -13 476 688 ;
C 49 ; WX 500 ; N one ; B 65 0 442 688 ;
C 50 ; WX 500 ; N two ; B 17 0 478 688 ;
C 51 ; WX 500 ; N three ; B 16 -14 468 688 ;
C 52 ; WX 500 ; N four ; B 19 0 475 688 ;
C 53 ; WX 500 ; N five ; B 22 -8 470 676 ;
C 54 ; WX 500 ; N six ; B 28 -13 475 688 ;
C 55 ; WX 500 ; N seven ; B 17 0 477 676 ;
C 56 ; WX 500 ; N eight ; B 28 -13 472 688 ;
C 57 ; WX 500 ; N nine ; B 26 -13 473 688 ;
C 58 ; WX 333 ; N colon ; B 82 -13 251 472 ;
C 59 ; WX 333 ; N semicolon ; B 82 -180 266 472 ;
C 60 ; WX 570 ; N less ; B 31 -8 539 514 ;
C 61 ; WX 570 ; N equal ; B 33 107 537 399 ;
C 62 ; WX 570 ; N greater ; B 31 -8 539 514 ;
C 63 ; WX 500 ; N question ; B 57 -13 445 689 ;
C 64 ; WX 930 ; N at ; B 108 -19 822 691 ;
C 65 ; WX 722 ; N A ; B 9 0 689 690 ;
C 66 ; WX 667 ; N B ; B 16 0 619 676 ;
C 67 ; WX 722 ; N C ; B 49 -19 687 691 ;
C 68 ; WX 722 ; N D ; B 14 0 690 676 ;
C 69 ; WX 667 ; N E ; B 16 0 641 676 ;
C 70 ; WX 611 ; N F ; B 16 0 583 676 ;
C 71 ; WX 778 ; N G ; B 37 -19 755 691 ;
C 72 ; WX 778 ; N H ; B 21 0 759 676 ;
C 73 ; WX 389 ; N I ; B 20 0 370 676 ;
C 74 ; WX 500 ; N J ; B 3 -96 479 676 ;
C 75 ; WX 778 ; N K ; B 30 0 769 676 ;
C 76 ; WX 667 ; N L ; B 19 0 638 676 ;
C 77 ; WX 944 ; N M ; B 14 0 921 676 ;
C 78 ; WX 722 ; N N ; B 16 -18 701 676 ;
C 79 ; WX 778 ; N O ; B 35 -19 743 691 ;
C 80 ; WX 611 ; N P ; B 16 0 600 676 ;
C 81 ; WX 778 ; N Q ; B 35 -176 743 691 ;
C 82 ; WX 722 ; N R ; B 26 0 715 676 ;
C 83 ; WX 556 ; N S ; B 35 -19 513 692 ;
C 84 ; WX 667 ; N T ; B 31 0 636 676 ;
C 85 ; WX 722 ; N U ; B 16 -19 701 676 ;
C 86 ; WX 722 ; N V ; B 16 -18 701 676 ;
C 87 ; WX 1000 ; N W ; B 19 -15 981 676 ;
C 88 ; WX 722 ; N X ; B 16 0 699 676 ;
C 89 ; WX 722 ; N Y ; B 15 0 699 676 ;
C 90 ; WX 667 ; N Z ; B 28 0 634 676 ;
C 91 ; WX 333 ; N bracketleft ; B 67 -149 301 678 ;
C 92 ; WX 278 ; N backslash ; B -25 -19 303 691 ;
C 93 ; WX 333 ; N bracketright ; B 32 -149 266 678 ;
C 94 ; WX 581 ; N asciicircum ; B 73 311 509 676 ;
C 95 ; WX 500 ; N underscore ; B 0 -125 500 -75 ;
C 96 ; WX 333 ; N quoteleft ; B 70 356 254 691 ;
C 97 ; WX 500 ; N a ; B 25 -14 488 473 ;
C 98 ; WX 556 ; N b ; B 17 -14 521 676 ;
C 99 ; WX 444 ; N c ; B 25 -14 430 473 ;
C 100 ; WX 556 ; N d ; B 25 -14 534 676 ;
C 101 ; WX 444 ; N e ; B 25 -14 426 473 ;
C 102 ; WX 333 ; N f ; B 14 0 389 691 ; L i fi ; L l fl ;
C 103 ; WX 500 ; N g ; B 28 -206 483 473 ;
C 104 ; WX 556 ; N h ; B 16 0 534 676 ;
C 105 ; WX 278 ; N i ; B 16 0 255 691 ;
C 106 ; WX 333 ; N j ; B -57 -203 263 691 ;
C 107 ; WX 556 ; N k ; B 22 0 543 676 ;
C 108 ; WX 278 ; N l ; B 16 0 255 676 ;
C 109 ; WX 833 ; N m ; B 16 0 814 473 ;
C 110 ; WX 556 ; N n ; B 21 0 539 473 ;
C 111 ; WX 500 ; N o ; B 25 -14 476 473 ;
C 112 ; WX 556 ; N p ; B 19 -205 524 473 ;
C 113 ; WX 556 ; N q ; B 34 -205 536 473 ;
C 114 ; WX 444 ; N r ; B 29 0 434 473 ;
C 115 ; WX 389 ; N s ; B 25 -14 361 473 ;
C 116 ; WX 333 ; N t ; B 20 -12 332 630 ;
C 117 ; WX 556 ; N u ; B 16 -14 537 461 ;
C 118 ; WX 500 ; N v ; B 21 -14 485 461 ;
C 119 ; WX 722 ; N w ; B 23 -14 707 461 ;
C 120 ; WX 500 ; N x ; B 12 0 484 461 ;
C 121 ; WX 500 ; N y ; B 16 -205 480 461 ;
C 122 ; WX 444 ; N z ; B 21 0 420 461 ;
C 123 ; WX 394 ; N braceleft ; B 22 -175 340 698 ;
C 124 ; WX 220 ; N bar ; B 66 -218 154 782 ;
C 125 ; WX 394 ; N braceright ; B 54 -175 372 698 ;
C 126 ; WX 520 ; N asciitilde ; B 29 173 491 333 ;
C 161 ; WX 333 ; N exclamdown ; B 82 -203 252 501 ;
C 162 ; WX 500 ; N cent ; B 53 -140 458 588 ;
C 163 ; WX 500 ; N sterling ; B 21 -14 477 684 ;
C 164 ; WX 167 ; N fraction ; B -168 -12 329 688 ;
C 165 ; WX 500 ; N yen ; B -64 0 547 676 ;
C 166 ; WX 500 ; N florin ; B 0 -155 498 706 ;
C 167 ; WX 500 ; N section ; B 57 -132 443 691 ;
C 168 ; WX 500 ; N currency ; B -26 61 526 613 ;
C 169 ; WX 278 ; N quotesingle ; B 75 404 204 691 ;
C 170 ; WX 500 ; N quotedblleft ; B 32 356 486 691 ;
C 171 ; WX 500 ; N guillemotleft ; B 23 36 473 415 ;
C 172 ; WX 333 ; N guilsinglleft ; B 51 36 305 415 ;
C 173 ; WX 333 ; N guilsinglright ; B 28 36 282 415 ;
C 174 ; WX 556 ; N fi ; B 14 0 536 691 ;
C 175 ; WX 556 ; N fl ; B 14 0 536 691 ;
C 177 ; WX 500 ; N endash ; B 0 181 500 271 ;
C 178 ; WX 500 ; N dagger ; B 47 -134 453 691 ;
C 179 ; WX 500 ; N daggerdbl ; B 45 -132 456 691 ;
C 180 ; WX 250 ; N periodcentered ; B 41 248 210 417 ;
C 182 ; WX 540 ; N paragraph ; B 0 -186 519 676 ;
C 183 ; WX 350 ; N bullet ; B 35 198 315 478 ;
C 184 ; WX 333 ; N quotesinglbase ; B 79 -180 263 155 ;
C 185 ; WX 500 ; N quotedblbase ; B 14 -180 468 155 ;
C 186 ; WX 500 ; N quotedblright ; B 14 356 468 691 ;
C 187 ; WX 500 ; N guillemotright ; B 27 36 477 415 ;
C 188 ; WX 1000 ; N ellipsis ; B 82 -13 917 156 ;
C 189 ; WX 1000 ; N perthousand ; B 7 -29 995 706 ;
C 191 ; WX 500 ; N questiondown ; B 55 -201 443 501 ;
C 193 ; WX 333 ; N grave ; B 8 528 246 713 ;
C 194 ; WX 333 ; N acute ; B 86 528 324 713 ;
C 195 ; WX 333 ; N circumflex ; B -2 528 335 704 ;
C 196 ; WX 333 ; N tilde ; B -16 547 349 674 ;
C 197 ; WX 333 ; N macron ; B 1 565 331 637 ;
C 198 ; WX 333 ; N breve ; B 15 528 318 691 ;
C 199 ; WX 333 ; N dotaccent ; B 103 536 258 691 ;
C 200 ; WX 333 ; N dieresis ; B -2 537 335 667 ;
C 202 ; WX 333 ; N ring ; B 60 527 273 740 ;
C 203 ; WX 333 ; N cedilla ; B 68 -218 294 0 ;
C 205 ; WX 333 ; N hungarumlaut ; B -13 528 425 713 ;
C 206 ; WX 333 ; N ogonek ; B 90 -193 319 24 ;
C 207 ; WX 333 ; N caron ; B -2 528 335 704 ;
C 208 ; WX 1000 ; N emdash ; B 0 181 1000 271 ;
C 225 ; WX 1000 ; N AE ; B 4 0 951 676 ;
C 227 ; WX 300 ; N ordfeminine ; B -1 397 301 688 ;
C 232 ; WX 667 ; N Lslash ; B 19 0 638 676 ;
C 233 ; WX 778 ; N Oslash ; B 35 -74 743 737 ;
C 234 ; WX 1000 ; N OE ; B 22 -5 981 684 ;
C 235 ; WX 330 ; N ordmasculine ; B 18 397 312 688 ;
C 241 ; WX 722 ; N ae ; B 33 -14 693 473 ;
C 245 ; WX 278 ; N dotlessi ; B 16 0 255 461 ;
C 248 ; WX 278 ; N lslash ; B -22 0 303 676 ;
C 249 ; WX 500 ; N oslash ; B 25 -92 476 549 ;
C 250 ; WX 722 ; N oe ; B 22 -14 696 473 ;
C 251 ; WX 556 ; N germandbls ; B 19 -12 517 691 ;
C -1 ; WX 389 ; N Idieresis ; B 20 0 370 877 ;
C -1 ; WX 444 ; N eacute ; B 25 -14 426 713 ;
C -1 ; WX 500 ; N abreve ; B 25 -14 488 691 ;
C -1 ; WX 556 ; N uhungarumlaut ; B 16 -14 557 713 ;
C -1 ; WX 444 ; N ecaron ; B 25 -14 426 704 ;
C -1 ; WX 722 ; N Ydieresis ; B 15 0 699 877 ;
C -1 ; WX 570 ; N divide ; B 33 -31 537 537 ;
C -1 ; WX 722 ; N Yacute ; B 15 0 699 923 ;
C -1 ; WX 722 ; N Acircumflex ; B 9 0 689 914 ;
C -1 ; WX 500 ; N aacute ; B 25 -14 488 713 ;
C -1 ; WX 722 ; N Ucircumflex ; B 16 -19 701 914 ;
C -1 ; WX 500 ; N yacute ; B 16 -205 480 713 ;
C -1 ; WX 389 ; N scommaaccent ; B 25 -218 361 473 ;
C -1 ; WX 444 ; N ecircumflex ; B 25 -14 426 704 ;
C -1 ; WX 722 ; N Uring ; B 16 -19 701 935 ;
C -1 ; WX 722 ; N Udieresis ; B 16 -19 701 877 ;
C -1 ; WX 500 ; N aogonek ; B 25 -193 504 473 ;
C -1 ; WX 722 ; N Uacute ; B 16 -19 701 923 ;
C -1 ; WX 556 ; N uogonek ; B 16 -193 539 461 ;
C -1 ; WX 667 ; N Edieresis ; B 16 0 641 877 ;
C -1 ; WX 722 ; N Dcroat ; B 6 0 690 676 ;
C -1 ; WX 250 ; N commaaccent ; B 47 -218 203 -50 ;
C -1 ; WX 747 ; N copyright ; B 26 -19 721 691 ;
C -1 ; WX 667 ; N Emacron ; B 16 0 641 847 ;
C -1 ; WX 444 ; N ccaron ; B 25 -14 430 704 ;
C -1 ; WX 500 ; N aring ; B 25 -14 488 740 ;
C -1 ; WX 722 ; N Ncommaaccent ; B 16 -188 701 676 ;
C -1 ; WX 278 ; N lacute ; B 16 0 297 923 ;
C -1 ; WX 500 ; N agrave ; B 25 -14 488 713 ;
C -1 ; WX 667 ; N Tcommaaccent ; B 31 -218 636 676 ;
C -1 ; WX 722 ; N Cacute ; B 49 -19 687 923 ;
C -1 ; WX 500 ; N atilde ; B 25 -14 488 674 ;
C -1 ; WX 667 ; N Edotaccent ; B 16 0 641 901 ;
C -1 ; WX 389 ; N scaron ; B 25 -14 363 704 ;
C -1 ; WX 389 ; N scedilla ; B 25 -218 361 473 ;
C -1 ; WX 278 ; N iacute ; B 16 0 289 713 ;
C -1 ; WX 494 ; N lozenge ; B 10 0 484 745 ;
C -1 ; WX 722 ; N Rcaron ; B 26 0 715 914 ;
C -1 ; WX 778 ; N Gcommaaccent ; B 37 -218 755 691 ;
C -1 ; WX 556 ; N ucircumflex ; B 16 -14 537 704 ;
C -1 ; WX 500 ; N acircumflex ; B 25 -14 488 704 ;
C -1 ; WX 722 ; N Amacron ; B 9 0 689 847 ;
C -1 ; WX 444 ; N rcaron ; B 29 0 434 704 ;
C -1 ; WX 444 ; N ccedilla ; B 25 -218 430 473 ;
C -1 ; WX 667 ; N Zdotaccent ; B 28 0 634 901 ;
C -1 ; WX 611 ; N Thorn ; B 16 0 600 676 ;
C -1 ; WX 778 ; N Omacron ; B 35 -19 743 847 ;
C -1 ; WX 722 ; N Racute ; B 26 0 715 923 ;
C -1 ; WX 556 ; N Sacute ; B 35 -19 513 923 ;
C -1 ; WX 672 ; N dcaron ; B 25 -14 681 682 ;
C -1 ; WX 722 ; N Umacron ; B 16 -19 701 847 ;
C -1 ; WX 556 ; N uring ; B 16 -14 537 740 ;
C -1 ; WX 300 ; N threesuperior ; B 3 268 297 688 ;
C -1 ; WX 778 ; N Ograve ; B 35 -19 743 923 ;
C -1 ; WX 722 ; N Agrave ; B 9 0 689 923 ;
C -1 ; WX 722 ; N Abreve ; B 9 0 689 901 ;
C -1 ; WX 570 ; N multiply ; B 48 16 522 490 ;
C -1 ; WX 556 ; N uacute ; B 16 -14 537 713 ;
C -1 ; WX 667 ; N Tcaron ; B 31 0 636 914 ;
C -1 ; WX 494 ; N partialdiff ; B 11 -21 494 750 ;
C -1 ; WX 500 ; N ydieresis ; B 16 -205 480 667 ;
C -1 ; WX 722 ; N Nacute ; B 16 -18 701 923 ;
C -1 ; WX 278 ; N icircumflex ; B -37 0 300 704 ;
C -1 ; WX 667 ; N Ecircumflex ; B 16 0 641 914 ;
C -1 ; WX 500 ; N adieresis ; B 25 -14 488 667 ;
C -1 ; WX 444 ; N edieresis ; B 25 -14 426 667 ;
C -1 ; WX 444 ; N cacute ; B 25 -14 430 713 ;
C -1 ; WX 556 ; N nacute ; B 21 0 539 713 ;
C -1 ; WX 556 ; N umacron ; B 16 -14 537 637 ;
C -1 ; WX 722 ; N Ncaron ; B 16 -18 701 914 ;
C -1 ; WX 389 ; N Iacute ; B 20 0 370 923 ;
C -1 ; WX 570 ; N plusminus ; B 33 0 537 506 ;
C -1 ; WX 220 ; N brokenbar ; B 66 -143 154 707 ;
C -1 ; WX 747 ; N registered ; B 26 -19 721 691 ;
C -1 ; WX 778 ; N Gbreve ; B 37 -19 755 901 ;
C -1 ; WX 389 ; N Idotaccent ; B 20 0 370 901 ;
C -1 ; WX 600 ; N summation ; B 14 -10 585 706 ;
C -1 ; WX 667 ; N Egrave ; B 16 0 641 923 ;
C -1 ; WX 444 ; N racute ; B 29 0 434 713 ;
C -1 ; WX 500 ; N omacron ; B 25 -14 476 637 ;
C -1 ; WX 667 ; N Zacute ; B 28 0 634 923 ;
C -1 ; WX 667 ; N Zcaron ; B 28 0 634 914 ;
C -1 ; WX 549 ; N greaterequal ; B 26 0 523 704 ;
C -1 ; WX 722 ; N Eth ; B 6 0 690 676 ;
C -1 ; WX 722 ; N Ccedilla ; B 49 -218 687 691 ;
C -1 ; WX 278 ; N lcommaaccent ; B 16 -218 255 676 ;
C -1 ; WX 416 ; N tcaron ; B 20 -12 425 815 ;
C -1 ; WX 444 ; N eogonek ; B 25 -193 426 473 ;
C -1 ; WX 722 ; N Uogonek ; B 16 -193 701 676 ;
C -1 ; WX 722 ; N Aacute ; B 9 0 689 923 ;
C -1 ; WX 722 ; N Adieresis ; B 9 0 689 877 ;
C -1 ; WX 444 ; N egrave ; B 25 -14 426 713 ;
C -1 ; WX 444 ; N zacute ; B 21 0 420 713 ;
C -1 ; WX 278 ; N iogonek ; B 16 -193 274 691 ;
C -1 ; WX 778 ; N Oacute ; B 35 -19 743 923 ;
C -1 ; WX 500 ; N oacute ; B 25 -14 476 713 ;
C -1 ; WX 500 ; N amacron ; B 25 -14 488 637 ;
C -1 ; WX 389 ; N sacute ; B 25 -14 361 713 ;
C -1 ; WX 278 ; N idieresis ; B -37 0 300 667 ;
C -1 ; WX 778 ; N Ocircumflex ; B 35 -19 743 914 ;
C -1 ; WX 722 ; N Ugrave ; B 16 -19 701 923 ;
C -1 ; WX 612 ; N Delta ; B 6 0 608 688 ;
C -1 ; WX 556 ; N thorn ; B 19 -205 524 676 ;
C -1 ; WX 300 ; N twosuperior ; B 0 275 300 688 ;
C -1 ; WX 778 ; N Odieresis ; B 35 -19 743 877 ;
C -1 ; WX 556 ; N mu ; B 33 -206 536 461 ;
C -1 ; WX 278 ; N igrave ; B -27 0 255 713 ;
C -1 ; WX 500 ; N ohungarumlaut ; B 25 -14 529 713 ;
C -1 ; WX 667 ; N Eogonek ; B 16 -193 644 676 ;
C -1 ; WX 556 ; N dcroat ; B 25 -14 534 676 ;
C -1 ; WX 750 ; N threequarters ; B 23 -12 733 688 ;
C -1 ; WX 556 ; N Scedilla ; B 35 -218 513 692 ;
C -1 ; WX 394 ; N lcaron ; B 16 0 412 682 ;
C -1 ; WX 778 ; N Kcommaaccent ; B 30 -218 769 676 ;
C -1 ; WX 667 ; N Lacute ; B 19 0 638 923 ;
C -1 ; WX 1000 ; N trademark ; B 24 271 977 676 ;
C -1 ; WX 444 ; N edotaccent ; B 25 -14 426 691 ;
C -1 ; WX 389 ; N Igrave ; B 20 0 370 923 ;
C -1 ; WX 389 ; N Imacron ; B 20 0 370 847 ;
C -1 ; WX 667 ; N Lcaron ; B 19 0 652 682 ;
C -1 ; WX 750 ; N onehalf ; B -7 -12 775 688 ;
C -1 ; WX 549 ; N lessequal ; B 29 0 526 704 ;
C -1 ; WX 500 ; N ocircumflex ; B 25 -14 476 704 ;
C -1 ; WX 556 ; N ntilde ; B 21 0 539 674 ;
C -1 ; WX 722 ; N Uhungarumlaut ; B 16 -19 701 923 ;
C -1 ; WX 667 ; N Eacute ; B 16 0 641 923 ;
C -1 ; WX 444 ; N emacron ; B 25 -14 426 637 ;
C -1 ; WX 500 ; N gbreve ; B 28 -206 483 691 ;
C -1 ; WX 750 ; N onequarter ; B 28 -12 743 688 ;
C -1 ; WX 556 ; N Scaron ; B 35 -19 513 914 ;
C -1 ; WX 556 ; N Scommaaccent ; B 35 -218 513 692 ;
C -1 ; WX 778 ; N Ohungarumlaut ; B 35 -19 743 923 ;
C -1 ; WX 400 ; N degree ; B 57 402 343 688 ;
C -1 ; WX 500 ; N ograve ; B 25 -14 476 713 ;
C -1 ; WX 722 ; N Ccaron ; B 49 -19 687 914 ;
C -1 ; WX 556 ; N ugrave ; B 16 -14 537 713 ;
C -1 ; WX 549 ; N radical ; B 10 -46 512 850 ;
C -1 ; WX 722 ; N Dcaron ; B 14 0 690 914 ;
C -1 ; WX 444 ; N rcommaaccent ; B 29 -218 434 473 ;
C -1 ; WX 722 ; N Ntilde ; B 16 -18 701 884 ;
C -1 ; WX 500 ; N otilde ; B 25 -14 476 674 ;
C -1 ; WX 722 ; N Rcommaaccent ; B 26 -218 715 676 ;
C -1 ; WX 667 ; N Lcommaaccent ; B 19 -218 638 676 ;
C -1 ; WX 722 ; N Atilde ; B 9 0 689 884 ;
C -1 ; WX 722 ; N Aogonek ; B 9 -193 699 690 ;
C -1 ; WX 722 ; N Aring ; B 9 0 689 935 ;
C -1 ; WX 778 ; N Otilde ; B 35 -19 743 884 ;
C -1 ; WX 444 ; N zdotaccent ; B 21 0 420 691 ;
C -1 ; WX 667 ; N Ecaron ; B 16 0 641 914 ;
C -1 ; WX 389 ; N Iogonek ; B 20 -193 370 676 ;
C -1 ; WX 556 ; N kcommaaccent ; B 22 -218 543 676 ;
C -1 ; WX 570 ; N minus ; B 33 209 537 297 ;
C -1 ; WX 389 ; N Icircumflex ; B 20 0 370 914 ;
C -1 ; WX 556 ; N ncaron ; B 21 0 539 704 ;
C -1 ; WX 333 ; N tcommaaccent ; B 20 -218 332 630 ;
C -1 ; WX 570 ; N logicalnot ; B 33 108 537 399 ;
C -1 ; WX 500 ; N odieresis ; B 25 -14 476 667 ;
C -1 ; WX 556 ; N udieresis ; B 16 -14 537 667 ;
C -1 ; WX 549 ; N notequal ; B 15 -49 540 570 ;
C -1 ; WX 500 ; N gcommaaccent ; B 28 -206 483 829 ;
C -1 ; WX 500 ; N eth ; B 25 -14 476 691 ;
C -1 ; WX 444 ; N zcaron ; B 21 0 420 704 ;
C -1 ; WX 556 ; N ncommaaccent ; B 21 -218 539 473 ;
C -1 ; WX 300 ; N onesuperior ; B 28 275 273 688 ;
C -1 ; WX 278 ; N imacron ; B -8 0 272 637 ;
C -1 ; WX 500 ; N Euro ; B 0 0 0 0 ;
EndCharMetrics
StartKernData
StartKernPairs 2242
KPX A C -55
KPX A Cacute -55
KPX A Ccaron -55
KPX A Ccedilla -55
KPX A G -55
KPX A Gbreve -55
KPX A Gcommaaccent -55
KPX A O -45
KPX A Oacute -45
KPX A Ocircumflex -45
KPX A Odieresis -45
KPX A Ograve -45
KPX A Ohungarumlaut -45
KPX A Omacron -45
KPX A Oslash -45
KPX A Otilde -45
KPX A Q -45
KPX A T -95
KPX A Tcaron -95
KPX A Tcommaaccent -95
KPX A U -50
KPX A Uacute -50
KPX A Ucircumflex -50
KPX A Udieresis -50
KPX A Ugrave -50
KPX A Uhungarumlaut -50
KPX A Umacron -50
KPX A Uogonek -50
KPX A Uring -50
KPX A V -145
KPX A W -130
KPX A Y -100
KPX A Yacute -100
KPX A Ydieresis -100
KPX A p -25
KPX A quoteright -74
KPX A u -50
KPX A uacute -50
KPX A ucircumflex -50
KPX A udieresis -50
KPX A ugrave -50
KPX A uhungarumlaut -50
KPX A umacron -50
KPX A uogonek -50
KPX A uring -50
KPX A v -100
KPX A w -90
KPX A y -74
KPX A yacute -74
KPX A ydieresis -74
KPX Aacute C -55
KPX Aacute Cacute -55
KPX Aacute Ccaron -55
KPX Aacute Ccedilla -55
KPX Aacute G -55
KPX Aacute Gbreve -55
KPX Aacute Gcommaaccent -55
KPX Aacute O -45
KPX Aacute Oacute -45
KPX Aacute Ocircumflex -45
KPX Aacute Odieresis -45
KPX Aacute Ograve -45
KPX Aacute Ohungarumlaut -45
KPX Aacute Omacron -45
KPX Aacute Oslash -45
KPX Aacute Otilde -45
KPX Aacute Q -45
KPX Aacute T -95
KPX Aacute Tcaron -95
KPX Aacute Tcommaaccent -95
KPX Aacute U -50
KPX Aacute Uacute -50
KPX Aacute Ucircumflex -50
KPX Aacute Udieresis -50
KPX Aacute Ugrave -50
KPX Aacute Uhungarumlaut -50
KPX Aacute Umacron -50
KPX Aacute Uogonek -50
KPX Aacute Uring -50
KPX Aacute V -145
KPX Aacute W -130
KPX Aacute Y -100
KPX Aacute Yacute -100
KPX Aacute Ydieresis -100
KPX Aacute p -25
KPX Aacute quoteright -74
KPX Aacute u -50
KPX Aacute uacute -50
KPX Aacute ucircumflex -50
KPX Aacute udieresis -50
KPX Aacute ugrave -50
KPX Aacute uhungarumlaut -50
KPX Aacute umacron -50
KPX Aacute uogonek -50
KPX Aacute uring -50
KPX Aacute v -100
KPX Aacute w -90
KPX Aacute y -74
KPX Aacute yacute -74
KPX Aacute ydieresis -74
KPX Abreve C -55
KPX Abreve Cacute -55
KPX Abreve Ccaron -55
KPX Abreve Ccedilla -55
KPX Abreve G -55
KPX Abreve Gbreve -55
KPX Abreve Gcommaaccent -55
KPX Abreve O -45
KPX Abreve Oacute -45
KPX Abreve Ocircumflex -45
KPX Abreve Odieresis -45
KPX Abreve Ograve -45
KPX Abreve Ohungarumlaut -45
KPX Abreve Omacron -45
KPX Abreve Oslash -45
KPX Abreve Otilde -45
KPX Abreve Q -45
KPX Abreve T -95
KPX Abreve Tcaron -95
KPX Abreve Tcommaaccent -95
KPX Abreve U -50
KPX Abreve Uacute -50
KPX Abreve Ucircumflex -50
KPX Abreve Udieresis -50
KPX Abreve Ugrave -50
KPX Abreve Uhungarumlaut -50
KPX Abreve Umacron -50
KPX Abreve Uogonek -50
KPX Abreve Uring -50
KPX Abreve V -145
KPX Abreve W -130
KPX Abreve Y -100
KPX Abreve Yacute -100
KPX Abreve Ydieresis -100
KPX Abreve p -25
KPX Abreve quoteright -74
KPX Abreve u -50
KPX Abreve uacute -50
KPX Abreve ucircumflex -50
KPX Abreve udieresis -50
KPX Abreve ugrave -50
KPX Abreve uhungarumlaut -50
KPX Abreve umacron -50
KPX Abreve uogonek -50
KPX Abreve uring -50
KPX Abreve v -100
KPX Abreve w -90
KPX Abreve y -74
KPX Abreve yacute -74
KPX Abreve ydieresis -74
KPX Acircumflex C -55
KPX Acircumflex Cacute -55
KPX Acircumflex Ccaron -55
KPX Acircumflex Ccedilla -55
KPX Acircumflex G -55
KPX Acircumflex Gbreve -55
KPX Acircumflex Gcommaaccent -55
KPX Acircumflex O -45
KPX Acircumflex Oacute -45
KPX Acircumflex Ocircumflex -45
KPX Acircumflex Odieresis -45
KPX Acircumflex Ograve -45
KPX Acircumflex Ohungarumlaut -45
KPX Acircumflex Omacron -45
KPX Acircumflex Oslash -45
KPX Acircumflex Otilde -45
KPX Acircumflex Q -45
KPX Acircumflex T -95
KPX Acircumflex Tcaron -95
KPX Acircumflex Tcommaaccent -95
KPX Acircumflex U -50
KPX Acircumflex Uacute -50
KPX Acircumflex Ucircumflex -50
KPX Acircumflex Udieresis -50
KPX Acircumflex Ugrave -50
KPX Acircumflex Uhungarumlaut -50
KPX Acircumflex Umacron -50
KPX Acircumflex Uogonek -50
KPX Acircumflex Uring -50
KPX Acircumflex V -145
KPX Acircumflex W -130
KPX Acircumflex Y -100
KPX Acircumflex Yacute -100
KPX Acircumflex Ydieresis -100
KPX Acircumflex p -25
KPX Acircumflex quoteright -74
KPX Acircumflex u -50
KPX Acircumflex uacute -50
KPX Acircumflex ucircumflex -50
KPX Acircumflex udieresis -50
KPX Acircumflex ugrave -50
KPX Acircumflex uhungarumlaut -50
KPX Acircumflex umacron -50
KPX Acircumflex uogonek -50
KPX Acircumflex uring -50
KPX Acircumflex v -100
KPX Acircumflex w -90
KPX Acircumflex y -74
KPX Acircumflex yacute -74
KPX Acircumflex ydieresis -74
KPX Adieresis C -55
KPX Adieresis Cacute -55
KPX Adieresis Ccaron -55
KPX Adieresis Ccedilla -55
KPX Adieresis G -55
KPX Adieresis Gbreve -55
KPX Adieresis Gcommaaccent -55
KPX Adieresis O -45
KPX Adieresis Oacute -45
KPX Adieresis Ocircumflex -45
KPX Adieresis Odieresis -45
KPX Adieresis Ograve -45
KPX Adieresis Ohungarumlaut -45
KPX Adieresis Omacron -45
KPX Adieresis Oslash -45
KPX Adieresis Otilde -45
KPX Adieresis Q -45
KPX Adieresis T -95
KPX Adieresis Tcaron -95
KPX Adieresis Tcommaaccent -95
KPX Adieresis U -50
KPX Adieresis Uacute -50
KPX Adieresis Ucircumflex -50
KPX Adieresis Udieresis -50
KPX Adieresis Ugrave -50
KPX Adieresis Uhungarumlaut -50
KPX Adieresis Umacron -50
KPX Adieresis Uogonek -50
KPX Adieresis Uring -50
KPX Adieresis V -145
KPX Adieresis W -130
KPX Adieresis Y -100
KPX Adieresis Yacute -100
KPX Adieresis Ydieresis -100
KPX Adieresis p -25
KPX Adieresis quoteright -74
KPX Adieresis u -50
KPX Adieresis uacute -50
KPX Adieresis ucircumflex -50
KPX Adieresis udieresis -50
KPX Adieresis ugrave -50
KPX Adieresis uhungarumlaut -50
KPX Adieresis umacron -50
KPX Adieresis uogonek -50
KPX Adieresis uring -50
KPX Adieresis v -100
KPX Adieresis w -90
KPX Adieresis y -74
KPX Adieresis yacute -74
KPX Adieresis ydieresis -74
KPX Agrave C -55
KPX Agrave Cacute -55
KPX Agrave Ccaron -55
KPX Agrave Ccedilla -55
KPX Agrave G -55
KPX Agrave Gbreve -55
KPX Agrave Gcommaaccent -55
KPX Agrave O -45
KPX Agrave Oacute -45
KPX Agrave Ocircumflex -45
KPX Agrave Odieresis -45
KPX Agrave Ograve -45
KPX Agrave Ohungarumlaut -45
KPX Agrave Omacron -45
KPX Agrave Oslash -45
KPX Agrave Otilde -45
KPX Agrave Q -45
KPX Agrave T -95
KPX Agrave Tcaron -95
KPX Agrave Tcommaaccent -95
KPX Agrave U -50
KPX Agrave Uacute -50
KPX Agrave Ucircumflex -50
KPX Agrave Udieresis -50
KPX Agrave Ugrave -50
KPX Agrave Uhungarumlaut -50
KPX Agrave Umacron -50
KPX Agrave Uogonek -50
KPX Agrave Uring -50
KPX Agrave V -145
KPX Agrave W -130
KPX Agrave Y -100
KPX Agrave Yacute -100
KPX Agrave Ydieresis -100
KPX Agrave p -25
KPX Agrave quoteright -74
KPX Agrave u -50
KPX Agrave uacute -50
KPX Agrave ucircumflex -50
KPX Agrave udieresis -50
KPX Agrave ugrave -50
KPX Agrave uhungarumlaut -50
KPX Agrave umacron -50
KPX Agrave uogonek -50
KPX Agrave uring -50
KPX Agrave v -100
KPX Agrave w -90
KPX Agrave y -74
KPX Agrave yacute -74
KPX Agrave ydieresis -74
KPX Amacron C -55
KPX Amacron Cacute -55
KPX Amacron Ccaron -55
KPX Amacron Ccedilla -55
KPX Amacron G -55
KPX Amacron Gbreve -55
KPX Amacron Gcommaaccent -55
KPX Amacron O -45
KPX Amacron Oacute -45
KPX Amacron Ocircumflex -45
KPX Amacron Odieresis -45
KPX Amacron Ograve -45
KPX Amacron Ohungarumlaut -45
KPX Amacron Omacron -45
KPX Amacron Oslash -45
KPX Amacron Otilde -45
KPX Amacron Q -45
KPX Amacron T -95
KPX Amacron Tcaron -95
KPX Amacron Tcommaaccent -95
KPX Amacron U -50
KPX Amacron Uacute -50
KPX Amacron Ucircumflex -50
KPX Amacron Udieresis -50
KPX Amacron Ugrave -50
KPX Amacron Uhungarumlaut -50
KPX Amacron Umacron -50
KPX Amacron Uogonek -50
KPX Amacron Uring -50
KPX Amacron V -145
KPX Amacron W -130
KPX Amacron Y -100
KPX Amacron Yacute -100
KPX Amacron Ydieresis -100
KPX Amacron p -25
KPX Amacron quoteright -74
KPX Amacron u -50
KPX Amacron uacute -50
KPX Amacron ucircumflex -50
KPX Amacron udieresis -50
KPX Amacron ugrave -50
KPX Amacron uhungarumlaut -50
KPX Amacron umacron -50
KPX Amacron uogonek -50
KPX Amacron uring -50
KPX Amacron v -100
KPX Amacron w -90
KPX Amacron y -74
KPX Amacron yacute -74
KPX Amacron ydieresis -74
KPX Aogonek C -55
KPX Aogonek Cacute -55
KPX Aogonek Ccaron -55
KPX Aogonek Ccedilla -55
KPX Aogonek G -55
KPX Aogonek Gbreve -55
KPX Aogonek Gcommaaccent -55
KPX Aogonek O -45
KPX Aogonek Oacute -45
KPX Aogonek Ocircumflex -45
KPX Aogonek Odieresis -45
KPX Aogonek Ograve -45
KPX Aogonek Ohungarumlaut -45
KPX Aogonek Omacron -45
KPX Aogonek Oslash -45
KPX Aogonek Otilde -45
KPX Aogonek Q -45
KPX Aogonek T -95
KPX Aogonek Tcaron -95
KPX Aogonek Tcommaaccent -95
KPX Aogonek U -50
KPX Aogonek Uacute -50
KPX Aogonek Ucircumflex -50
KPX Aogonek Udieresis -50
KPX Aogonek Ugrave -50
KPX Aogonek Uhungarumlaut -50
KPX Aogonek Umacron -50
KPX Aogonek Uogonek -50
KPX Aogonek Uring -50
KPX Aogonek V -145
KPX Aogonek W -130
KPX Aogonek Y -100
KPX Aogonek Yacute -100
KPX Aogonek Ydieresis -100
KPX Aogonek p -25
KPX Aogonek quoteright -74
KPX Aogonek u -50
KPX Aogonek uacute -50
KPX Aogonek ucircumflex -50
KPX Aogonek udieresis -50
KPX Aogonek ugrave -50
KPX Aogonek uhungarumlaut -50
KPX Aogonek umacron -50
KPX Aogonek uogonek -50
KPX Aogonek uring -50
KPX Aogonek v -100
KPX Aogonek w -90
KPX Aogonek y -34
KPX Aogonek yacute -34
KPX Aogonek ydieresis -34
KPX Aring C -55
KPX Aring Cacute -55
KPX Aring Ccaron -55
KPX Aring Ccedilla -55
KPX Aring G -55
KPX Aring Gbreve -55
KPX Aring Gcommaaccent -55
KPX Aring O -45
KPX Aring Oacute -45
KPX Aring Ocircumflex -45
KPX Aring Odieresis -45
KPX Aring Ograve -45
KPX Aring Ohungarumlaut -45
KPX Aring Omacron -45
KPX Aring Oslash -45
KPX Aring Otilde -45
KPX Aring Q -45
KPX Aring T -95
KPX Aring Tcaron -95
KPX Aring Tcommaaccent -95
KPX Aring U -50
KPX Aring Uacute -50
KPX Aring Ucircumflex -50
KPX Aring Udieresis -50
KPX Aring Ugrave -50
KPX Aring Uhungarumlaut -50
KPX Aring Umacron -50
KPX Aring Uogonek -50
KPX Aring Uring -50
KPX Aring V -145
KPX Aring W -130
KPX Aring Y -100
KPX Aring Yacute -100
KPX Aring Ydieresis -100
KPX Aring p -25
KPX Aring quoteright -74
KPX Aring u -50
KPX Aring uacute -50
KPX Aring ucircumflex -50
KPX Aring udieresis -50
KPX Aring ugrave -50
KPX Aring uhungarumlaut -50
KPX Aring umacron -50
KPX Aring uogonek -50
KPX Aring uring -50
KPX Aring v -100
KPX Aring w -90
KPX Aring y -74
KPX Aring yacute -74
KPX Aring ydieresis -74
KPX Atilde C -55
KPX Atilde Cacute -55
KPX Atilde Ccaron -55
KPX Atilde Ccedilla -55
KPX Atilde G -55
KPX Atilde Gbreve -55
KPX Atilde Gcommaaccent -55
KPX Atilde O -45
KPX Atilde Oacute -45
KPX Atilde Ocircumflex -45
KPX Atilde Odieresis -45
KPX Atilde Ograve -45
KPX Atilde Ohungarumlaut -45
KPX Atilde Omacron -45
KPX Atilde Oslash -45
KPX Atilde Otilde -45
KPX Atilde Q -45
KPX Atilde T -95
KPX Atilde Tcaron -95
KPX Atilde Tcommaaccent -95
KPX Atilde U -50
KPX Atilde Uacute -50
KPX Atilde Ucircumflex -50
KPX Atilde Udieresis -50
KPX Atilde Ugrave -50
KPX Atilde Uhungarumlaut -50
KPX Atilde Umacron -50
KPX Atilde Uogonek -50
KPX Atilde Uring -50
KPX Atilde V -145
KPX Atilde W -130
KPX Atilde Y -100
KPX Atilde Yacute -100
KPX Atilde Ydieresis -100
KPX Atilde p -25
KPX Atilde quoteright -74
KPX Atilde u -50
KPX Atilde uacute -50
KPX Atilde ucircumflex -50
KPX Atilde udieresis -50
KPX Atilde ugrave -50
KPX Atilde uhungarumlaut -50
KPX Atilde umacron -50
KPX Atilde uogonek -50
KPX Atilde uring -50
KPX Atilde v -100
KPX Atilde w -90
KPX Atilde y -74
KPX Atilde yacute -74
KPX Atilde ydieresis -74
KPX B A -30
KPX B Aacute -30
KPX B Abreve -30
KPX B Acircumflex -30
KPX B Adieresis -30
KPX B Agrave -30
KPX B Amacron -30
KPX B Aogonek -30
KPX B Aring -30
KPX B Atilde -30
KPX B U -10
KPX B Uacute -10
KPX B Ucircumflex -10
KPX B Udieresis -10
KPX B Ugrave -10
KPX B Uhungarumlaut -10
KPX B Umacron -10
KPX B Uogonek -10
KPX B Uring -10
KPX D A -35
KPX D Aacute -35
KPX D Abreve -35
KPX D Acircumflex -35
KPX D Adieresis -35
KPX D Agrave -35
KPX D Amacron -35
KPX D Aogonek -35
KPX D Aring -35
KPX D Atilde -35
KPX D V -40
KPX D W -40
KPX D Y -40
KPX D Yacute -40
KPX D Ydieresis -40
KPX D period -20
KPX Dcaron A -35
KPX Dcaron Aacute -35
KPX Dcaron Abreve -35
KPX Dcaron Acircumflex -35
KPX Dcaron Adieresis -35
KPX Dcaron Agrave -35
KPX Dcaron Amacron -35
KPX Dcaron Aogonek -35
KPX Dcaron Aring -35
KPX Dcaron Atilde -35
KPX Dcaron V -40
KPX Dcaron W -40
KPX Dcaron Y -40
KPX Dcaron Yacute -40
KPX Dcaron Ydieresis -40
KPX Dcaron period -20
KPX Dcroat A -35
KPX Dcroat Aacute -35
KPX Dcroat Abreve -35
KPX Dcroat Acircumflex -35
KPX Dcroat Adieresis -35
KPX Dcroat Agrave -35
KPX Dcroat Amacron -35
KPX Dcroat Aogonek -35
KPX Dcroat Aring -35
KPX Dcroat Atilde -35
KPX Dcroat V -40
KPX Dcroat W -40
KPX Dcroat Y -40
KPX Dcroat Yacute -40
KPX Dcroat Ydieresis -40
KPX Dcroat period -20
KPX F A -90
KPX F Aacute -90
KPX F Abreve -90
KPX F Acircumflex -90
KPX F Adieresis -90
KPX F Agrave -90
KPX F Amacron -90
KPX F Aogonek -90
KPX F Aring -90
KPX F Atilde -90
KPX F a -25
KPX F aacute -25
KPX F abreve -25
KPX F acircumflex -25
KPX F adieresis -25
KPX F agrave -25
KPX F amacron -25
KPX F aogonek -25
KPX F aring -25
KPX F atilde -25
KPX F comma -92
KPX F e -25
KPX F eacute -25
KPX F ecaron -25
KPX F ecircumflex -25
KPX F edieresis -25
KPX F edotaccent -25
KPX F egrave -25
KPX F emacron -25
KPX F eogonek -25
KPX F o -25
KPX F oacute -25
KPX F ocircumflex -25
KPX F odieresis -25
KPX F ograve -25
KPX F ohungarumlaut -25
KPX F omacron -25
KPX F oslash -25
KPX F otilde -25
KPX F period -110
KPX J A -30
KPX J Aacute -30
KPX J Abreve -30
KPX J Acircumflex -30
KPX J Adieresis -30
KPX J Agrave -30
KPX J Amacron -30
KPX J Aogonek -30
KPX J Aring -30
KPX J Atilde -30
KPX J a -15
KPX J aacute -15
KPX J abreve -15
KPX J acircumflex -15
KPX J adieresis -15
KPX J agrave -15
KPX J amacron -15
KPX J aogonek -15
KPX J aring -15
KPX J atilde -15
KPX J e -15
KPX J eacute -15
KPX J ecaron -15
KPX J ecircumflex -15
KPX J edieresis -15
KPX J edotaccent -15
KPX J egrave -15
KPX J emacron -15
KPX J eogonek -15
KPX J o -15
KPX J oacute -15
KPX J ocircumflex -15
KPX J odieresis -15
KPX J ograve -15
KPX J ohungarumlaut -15
KPX J omacron -15
KPX J oslash -15
KPX J otilde -15
KPX J period -20
KPX J u -15
KPX J uacute -15
KPX J ucircumflex -15
KPX J udieresis -15
KPX J ugrave -15
KPX J uhungarumlaut -15
KPX J umacron -15
KPX J uogonek -15
KPX J uring -15
KPX K O -30
KPX K Oacute -30
KPX K Ocircumflex -30
KPX K Odieresis -30
KPX K Ograve -30
KPX K Ohungarumlaut -30
KPX K Omacron -30
KPX K Oslash -30
KPX K Otilde -30
KPX K e -25
KPX K eacute -25
KPX K ecaron -25
KPX K ecircumflex -25
KPX K edieresis -25
KPX K edotaccent -25
KPX K egrave -25
KPX K emacron -25
KPX K eogonek -25
KPX K o -25
KPX K oacute -25
KPX K ocircumflex -25
KPX K odieresis -25
KPX K ograve -25
KPX K ohungarumlaut -25
KPX K omacron -25
KPX K oslash -25
KPX K otilde -25
KPX K u -15
KPX K uacute -15
KPX K ucircumflex -15
KPX K udieresis -15
KPX K ugrave -15
KPX K uhungarumlaut -15
KPX K umacron -15
KPX K uogonek -15
KPX K uring -15
KPX K y -45
KPX K yacute -45
KPX K ydieresis -45
KPX Kcommaaccent O -30
KPX Kcommaaccent Oacute -30
KPX Kcommaaccent Ocircumflex -30
KPX Kcommaaccent Odieresis -30
KPX Kcommaaccent Ograve -30
KPX Kcommaaccent Ohungarumlaut -30
KPX Kcommaaccent Omacron -30
KPX Kcommaaccent Oslash -30
KPX Kcommaaccent Otilde -30
KPX Kcommaaccent e -25
KPX Kcommaaccent eacute -25
KPX Kcommaaccent ecaron -25
KPX Kcommaaccent ecircumflex -25
KPX Kcommaaccent edieresis -25
KPX Kcommaaccent edotaccent -25
KPX Kcommaaccent egrave -25
KPX Kcommaaccent emacron -25
KPX Kcommaaccent eogonek -25
KPX Kcommaaccent o -25
KPX Kcommaaccent oacute -25
KPX Kcommaaccent ocircumflex -25
KPX Kcommaaccent odieresis -25
KPX Kcommaaccent ograve -25
KPX Kcommaaccent ohungarumlaut -25
KPX Kcommaaccent omacron -25
KPX Kcommaaccent oslash -25
KPX Kcommaaccent otilde -25
KPX Kcommaaccent u -15
KPX Kcommaaccent uacute -15
KPX Kcommaaccent ucircumflex -15
KPX Kcommaaccent udieresis -15
KPX Kcommaaccent ugrave -15
KPX Kcommaaccent uhungarumlaut -15
KPX Kcommaaccent umacron -15
KPX Kcommaaccent uogonek -15
KPX Kcommaaccent uring -15
KPX Kcommaaccent y -45
KPX Kcommaaccent yacute -45
KPX Kcommaaccent ydieresis -45
KPX L T -92
KPX L Tcaron -92
KPX L Tcommaaccent -92
KPX L V -92
KPX L W -92
KPX L Y -92
KPX L Yacute -92
KPX L Ydieresis -92
KPX L quotedblright -20
KPX L quoteright -110
KPX L y -55
KPX L yacute -55
KPX L ydieresis -55
KPX Lacute T -92
KPX Lacute Tcaron -92
KPX Lacute Tcommaaccent -92
KPX Lacute V -92
KPX Lacute W -92
KPX Lacute Y -92
KPX Lacute Yacute -92
KPX Lacute Ydieresis -92
KPX Lacute quotedblright -20
KPX Lacute quoteright -110
KPX Lacute y -55
KPX Lacute yacute -55
KPX Lacute ydieresis -55
KPX Lcommaaccent T -92
KPX Lcommaaccent Tcaron -92
KPX Lcommaaccent Tcommaaccent -92
KPX Lcommaaccent V -92
KPX Lcommaaccent W -92
KPX Lcommaaccent Y -92
KPX Lcommaaccent Yacute -92
KPX Lcommaaccent Ydieresis -92
KPX Lcommaaccent quotedblright -20
KPX Lcommaaccent quoteright -110
KPX Lcommaaccent y -55
KPX Lcommaaccent yacute -55
KPX Lcommaaccent ydieresis -55
KPX Lslash T -92
KPX Lslash Tcaron -92
KPX Lslash Tcommaaccent -92
KPX Lslash V -92
KPX Lslash W -92
KPX Lslash Y -92
KPX Lslash Yacute -92
KPX Lslash Ydieresis -92
KPX Lslash quotedblright -20
KPX Lslash quoteright -110
KPX Lslash y -55
KPX Lslash yacute -55
KPX Lslash ydieresis -55
KPX N A -20
KPX N Aacute -20
KPX N Abreve -20
KPX N Acircumflex -20
KPX N Adieresis -20
KPX N Agrave -20
KPX N Amacron -20
KPX N Aogonek -20
KPX N Aring -20
KPX N Atilde -20
KPX Nacute A -20
KPX Nacute Aacute -20
KPX Nacute Abreve -20
KPX Nacute Acircumflex -20
KPX Nacute Adieresis -20
KPX Nacute Agrave -20
KPX Nacute Amacron -20
KPX Nacute Aogonek -20
KPX Nacute Aring -20
KPX Nacute Atilde -20
KPX Ncaron A -20
KPX Ncaron Aacute -20
KPX Ncaron Abreve -20
KPX Ncaron Acircumflex -20
KPX Ncaron Adieresis -20
KPX Ncaron Agrave -20
KPX Ncaron Amacron -20
KPX Ncaron Aogonek -20
KPX Ncaron Aring -20
KPX Ncaron Atilde -20
KPX Ncommaaccent A -20
KPX Ncommaaccent Aacute -20
KPX Ncommaaccent Abreve -20
KPX Ncommaaccent Acircumflex -20
KPX Ncommaaccent Adieresis -20
KPX Ncommaaccent Agrave -20
KPX Ncommaaccent Amacron -20
KPX Ncommaaccent Aogonek -20
KPX Ncommaaccent Aring -20
KPX Ncommaaccent Atilde -20
KPX Ntilde A -20
KPX Ntilde Aacute -20
KPX Ntilde Abreve -20
KPX Ntilde Acircumflex -20
KPX Ntilde Adieresis -20
KPX Ntilde Agrave -20
KPX Ntilde Amacron -20
KPX Ntilde Aogonek -20
KPX Ntilde Aring -20
KPX Ntilde Atilde -20
KPX O A -40
KPX O Aacute -40
KPX O Abreve -40
KPX O Acircumflex -40
KPX O Adieresis -40
KPX O Agrave -40
KPX O Amacron -40
KPX O Aogonek -40
KPX O Aring -40
KPX O Atilde -40
KPX O T -40
KPX O Tcaron -40
KPX O Tcommaaccent -40
KPX O V -50
KPX O W -50
KPX O X -40
KPX O Y -50
KPX O Yacute -50
KPX O Ydieresis -50
KPX Oacute A -40
KPX Oacute Aacute -40
KPX Oacute Abreve -40
KPX Oacute Acircumflex -40
KPX Oacute Adieresis -40
KPX Oacute Agrave -40
KPX Oacute Amacron -40
KPX Oacute Aogonek -40
KPX Oacute Aring -40
KPX Oacute Atilde -40
KPX Oacute T -40
KPX Oacute Tcaron -40
KPX Oacute Tcommaaccent -40
KPX Oacute V -50
KPX Oacute W -50
KPX Oacute X -40
KPX Oacute Y -50
KPX Oacute Yacute -50
KPX Oacute Ydieresis -50
KPX Ocircumflex A -40
KPX Ocircumflex Aacute -40
KPX Ocircumflex Abreve -40
KPX Ocircumflex Acircumflex -40
KPX Ocircumflex Adieresis -40
KPX Ocircumflex Agrave -40
KPX Ocircumflex Amacron -40
KPX Ocircumflex Aogonek -40
KPX Ocircumflex Aring -40
KPX Ocircumflex Atilde -40
KPX Ocircumflex T -40
KPX Ocircumflex Tcaron -40
KPX Ocircumflex Tcommaaccent -40
KPX Ocircumflex V -50
KPX Ocircumflex W -50
KPX Ocircumflex X -40
KPX Ocircumflex Y -50
KPX Ocircumflex Yacute -50
KPX Ocircumflex Ydieresis -50
KPX Odieresis A -40
KPX Odieresis Aacute -40
KPX Odieresis Abreve -40
KPX Odieresis Acircumflex -40
KPX Odieresis Adieresis -40
KPX Odieresis Agrave -40
KPX Odieresis Amacron -40
KPX Odieresis Aogonek -40
KPX Odieresis Aring -40
KPX Odieresis Atilde -40
KPX Odieresis T -40
KPX Odieresis Tcaron -40
KPX Odieresis Tcommaaccent -40
KPX Odieresis V -50
KPX Odieresis W -50
KPX Odieresis X -40
KPX Odieresis Y -50
KPX Odieresis Yacute -50
KPX Odieresis Ydieresis -50
KPX Ograve A -40
KPX Ograve Aacute -40
KPX Ograve Abreve -40
KPX Ograve Acircumflex -40
KPX Ograve Adieresis -40
KPX Ograve Agrave -40
KPX Ograve Amacron -40
KPX Ograve Aogonek -40
KPX Ograve Aring -40
KPX Ograve Atilde -40
KPX Ograve T -40
KPX Ograve Tcaron -40
KPX Ograve Tcommaaccent -40
KPX Ograve V -50
KPX Ograve W -50
KPX Ograve X -40
KPX Ograve Y -50
KPX Ograve Yacute -50
KPX Ograve Ydieresis -50
KPX Ohungarumlaut A -40
KPX Ohungarumlaut Aacute -40
KPX Ohungarumlaut Abreve -40
KPX Ohungarumlaut Acircumflex -40
KPX Ohungarumlaut Adieresis -40
KPX Ohungarumlaut Agrave -40
KPX Ohungarumlaut Amacron -40
KPX Ohungarumlaut Aogonek -40
KPX Ohungarumlaut Aring -40
KPX Ohungarumlaut Atilde -40
KPX Ohungarumlaut T -40
KPX Ohungarumlaut Tcaron -40
KPX Ohungarumlaut Tcommaaccent -40
KPX Ohungarumlaut V -50
KPX Ohungarumlaut W -50
KPX Ohungarumlaut X -40
KPX Ohungarumlaut Y -50
KPX Ohungarumlaut Yacute -50
KPX Ohungarumlaut Ydieresis -50
KPX Omacron A -40
KPX Omacron Aacute -40
KPX Omacron Abreve -40
KPX Omacron Acircumflex -40
KPX Omacron Adieresis -40
KPX Omacron Agrave -40
KPX Omacron Amacron -40
KPX Omacron Aogonek -40
KPX Omacron Aring -40
KPX Omacron Atilde -40
KPX Omacron T -40
KPX Omacron Tcaron -40
KPX Omacron Tcommaaccent -40
KPX Omacron V -50
KPX Omacron W -50
KPX Omacron X -40
KPX Omacron Y -50
KPX Omacron Yacute -50
KPX Omacron Ydieresis -50
KPX Oslash A -40
KPX Oslash Aacute -40
KPX Oslash Abreve -40
KPX Oslash Acircumflex -40
KPX Oslash Adieresis -40
KPX Oslash Agrave -40
KPX Oslash Amacron -40
KPX Oslash Aogonek -40
KPX Oslash Aring -40
KPX Oslash Atilde -40
KPX Oslash T -40
KPX Oslash Tcaron -40
KPX Oslash Tcommaaccent -40
KPX Oslash V -50
KPX Oslash W -50
KPX Oslash X -40
KPX Oslash Y -50
KPX Oslash Yacute -50
KPX Oslash Ydieresis -50
KPX Otilde A -40
KPX Otilde Aacute -40
KPX Otilde Abreve -40
KPX Otilde Acircumflex -40
KPX Otilde Adieresis -40
KPX Otilde Agrave -40
KPX Otilde Amacron -40
KPX Otilde Aogonek -40
KPX Otilde Aring -40
KPX Otilde Atilde -40
KPX Otilde T -40
KPX Otilde Tcaron -40
KPX Otilde Tcommaaccent -40
KPX Otilde V -50
KPX Otilde W -50
KPX Otilde X -40
KPX Otilde Y -50
KPX Otilde Yacute -50
KPX Otilde Ydieresis -50
KPX P A -74
KPX P Aacute -74
KPX P Abreve -74
KPX P Acircumflex -74
KPX P Adieresis -74
KPX P Agrave -74
KPX P Amacron -74
KPX P Aogonek -74
KPX P Aring -74
KPX P Atilde -74
KPX P a -10
KPX P aacute -10
KPX P abreve -10
KPX P acircumflex -10
KPX P adieresis -10
KPX P agrave -10
KPX P amacron -10
KPX P aogonek -10
KPX P aring -10
KPX P atilde -10
KPX P comma -92
KPX P e -20
KPX P eacute -20
KPX P ecaron -20
KPX P ecircumflex -20
KPX P edieresis -20
KPX P edotaccent -20
KPX P egrave -20
KPX P emacron -20
KPX P eogonek -20
KPX P o -20
KPX P oacute -20
KPX P ocircumflex -20
KPX P odieresis -20
KPX P ograve -20
KPX P ohungarumlaut -20
KPX P omacron -20
KPX P oslash -20
KPX P otilde -20
KPX P period -110
KPX Q U -10
KPX Q Uacute -10
KPX Q Ucircumflex -10
KPX Q Udieresis -10
KPX Q Ugrave -10
KPX Q Uhungarumlaut -10
KPX Q Umacron -10
KPX Q Uogonek -10
KPX Q Uring -10
KPX Q period -20
KPX R O -30
KPX R Oacute -30
KPX R Ocircumflex -30
KPX R Odieresis -30
KPX R Ograve -30
KPX R Ohungarumlaut -30
KPX R Omacron -30
KPX R Oslash -30
KPX R Otilde -30
KPX R T -40
KPX R Tcaron -40
KPX R Tcommaaccent -40
KPX R U -30
KPX R Uacute -30
KPX R Ucircumflex -30
KPX R Udieresis -30
KPX R Ugrave -30
KPX R Uhungarumlaut -30
KPX R Umacron -30
KPX R Uogonek -30
KPX R Uring -30
KPX R V -55
KPX R W -35
KPX R Y -35
KPX R Yacute -35
KPX R Ydieresis -35
KPX Racute O -30
KPX Racute Oacute -30
KPX Racute Ocircumflex -30
KPX Racute Odieresis -30
KPX Racute Ograve -30
KPX Racute Ohungarumlaut -30
KPX Racute Omacron -30
KPX Racute Oslash -30
KPX Racute Otilde -30
KPX Racute T -40
KPX Racute Tcaron -40
KPX Racute Tcommaaccent -40
KPX Racute U -30
KPX Racute Uacute -30
KPX Racute Ucircumflex -30
KPX Racute Udieresis -30
KPX Racute Ugrave -30
KPX Racute Uhungarumlaut -30
KPX Racute Umacron -30
KPX Racute Uogonek -30
KPX Racute Uring -30
KPX Racute V -55
KPX Racute W -35
KPX Racute Y -35
KPX Racute Yacute -35
KPX Racute Ydieresis -35
KPX Rcaron O -30
KPX Rcaron Oacute -30
KPX Rcaron Ocircumflex -30
KPX Rcaron Odieresis -30
KPX Rcaron Ograve -30
KPX Rcaron Ohungarumlaut -30
KPX Rcaron Omacron -30
KPX Rcaron Oslash -30
KPX Rcaron Otilde -30
KPX Rcaron T -40
KPX Rcaron Tcaron -40
KPX Rcaron Tcommaaccent -40
KPX Rcaron U -30
KPX Rcaron Uacute -30
KPX Rcaron Ucircumflex -30
KPX Rcaron Udieresis -30
KPX Rcaron Ugrave -30
KPX Rcaron Uhungarumlaut -30
KPX Rcaron Umacron -30
KPX Rcaron Uogonek -30
KPX Rcaron Uring -30
KPX Rcaron V -55
KPX Rcaron W -35
KPX Rcaron Y -35
KPX Rcaron Yacute -35
KPX Rcaron Ydieresis -35
KPX Rcommaaccent O -30
KPX Rcommaaccent Oacute -30
KPX Rcommaaccent Ocircumflex -30
KPX Rcommaaccent Odieresis -30
KPX Rcommaaccent Ograve -30
KPX Rcommaaccent Ohungarumlaut -30
KPX Rcommaaccent Omacron -30
KPX Rcommaaccent Oslash -30
KPX Rcommaaccent Otilde -30
KPX Rcommaaccent T -40
KPX Rcommaaccent Tcaron -40
KPX Rcommaaccent Tcommaaccent -40
KPX Rcommaaccent U -30
KPX Rcommaaccent Uacute -30
KPX Rcommaaccent Ucircumflex -30
KPX Rcommaaccent Udieresis -30
KPX Rcommaaccent Ugrave -30
KPX Rcommaaccent Uhungarumlaut -30
KPX Rcommaaccent Umacron -30
KPX Rcommaaccent Uogonek -30
KPX Rcommaaccent Uring -30
KPX Rcommaaccent V -55
KPX Rcommaaccent W -35
KPX Rcommaaccent Y -35
KPX Rcommaaccent Yacute -35
KPX Rcommaaccent Ydieresis -35
KPX T A -90
KPX T Aacute -90
KPX T Abreve -90
KPX T Acircumflex -90
KPX T Adieresis -90
KPX T Agrave -90
KPX T Amacron -90
KPX T Aogonek -90
KPX T Aring -90
KPX T Atilde -90
KPX T O -18
KPX T Oacute -18
KPX T Ocircumflex -18
KPX T Odieresis -18
KPX T Ograve -18
KPX T Ohungarumlaut -18
KPX T Omacron -18
KPX T Oslash -18
KPX T Otilde -18
KPX T a -92
KPX T aacute -92
KPX T abreve -52
KPX T acircumflex -52
KPX T adieresis -52
KPX T agrave -52
KPX T amacron -52
KPX T aogonek -92
KPX T aring -92
KPX T atilde -52
KPX T colon -74
KPX T comma -74
KPX T e -92
KPX T eacute -92
KPX T ecaron -92
KPX T ecircumflex -92
KPX T edieresis -52
KPX T edotaccent -92
KPX T egrave -52
KPX T emacron -52
KPX T eogonek -92
KPX T hyphen -92
KPX T i -18
KPX T iacute -18
KPX T iogonek -18
KPX T o -92
KPX T oacute -92
KPX T ocircumflex -92
KPX T odieresis -92
KPX T ograve -92
KPX T ohungarumlaut -92
KPX T omacron -92
KPX T oslash -92
KPX T otilde -92
KPX T period -90
KPX T r -74
KPX T racute -74
KPX T rcaron -74
KPX T rcommaaccent -74
KPX T semicolon -74
KPX T u -92
KPX T uacute -92
KPX T ucircumflex -92
KPX T udieresis -92
KPX T ugrave -92
KPX T uhungarumlaut -92
KPX T umacron -92
KPX T uogonek -92
KPX T uring -92
KPX T w -74
KPX T y -34
KPX T yacute -34
KPX T ydieresis -34
KPX Tcaron A -90
KPX Tcaron Aacute -90
KPX Tcaron Abreve -90
KPX Tcaron Acircumflex -90
KPX Tcaron Adieresis -90
KPX Tcaron Agrave -90
KPX Tcaron Amacron -90
KPX Tcaron Aogonek -90
KPX Tcaron Aring -90
KPX Tcaron Atilde -90
KPX Tcaron O -18
KPX Tcaron Oacute -18
KPX Tcaron Ocircumflex -18
KPX Tcaron Odieresis -18
KPX Tcaron Ograve -18
KPX Tcaron Ohungarumlaut -18
KPX Tcaron Omacron -18
KPX Tcaron Oslash -18
KPX Tcaron Otilde -18
KPX Tcaron a -92
KPX Tcaron aacute -92
KPX Tcaron abreve -52
KPX Tcaron acircumflex -52
KPX Tcaron adieresis -52
KPX Tcaron agrave -52
KPX Tcaron amacron -52
KPX Tcaron aogonek -92
KPX Tcaron aring -92
KPX Tcaron atilde -52
KPX Tcaron colon -74
KPX Tcaron comma -74
KPX Tcaron e -92
KPX Tcaron eacute -92
KPX Tcaron ecaron -92
KPX Tcaron ecircumflex -92
KPX Tcaron edieresis -52
KPX Tcaron edotaccent -92
KPX Tcaron egrave -52
KPX Tcaron emacron -52
KPX Tcaron eogonek -92
KPX Tcaron hyphen -92
KPX Tcaron i -18
KPX Tcaron iacute -18
KPX Tcaron iogonek -18
KPX Tcaron o -92
KPX Tcaron oacute -92
KPX Tcaron ocircumflex -92
KPX Tcaron odieresis -92
KPX Tcaron ograve -92
KPX Tcaron ohungarumlaut -92
KPX Tcaron omacron -92
KPX Tcaron oslash -92
KPX Tcaron otilde -92
KPX Tcaron period -90
KPX Tcaron r -74
KPX Tcaron racute -74
KPX Tcaron rcaron -74
KPX Tcaron rcommaaccent -74
KPX Tcaron semicolon -74
KPX Tcaron u -92
KPX Tcaron uacute -92
KPX Tcaron ucircumflex -92
KPX Tcaron udieresis -92
KPX Tcaron ugrave -92
KPX Tcaron uhungarumlaut -92
KPX Tcaron umacron -92
KPX Tcaron uogonek -92
KPX Tcaron uring -92
KPX Tcaron w -74
KPX Tcaron y -34
KPX Tcaron yacute -34
KPX Tcaron ydieresis -34
KPX Tcommaaccent A -90
KPX Tcommaaccent Aacute -90
KPX Tcommaaccent Abreve -90
KPX Tcommaaccent Acircumflex -90
KPX Tcommaaccent Adieresis -90
KPX Tcommaaccent Agrave -90
KPX Tcommaaccent Amacron -90
KPX Tcommaaccent Aogonek -90
KPX Tcommaaccent Aring -90
KPX Tcommaaccent Atilde -90
KPX Tcommaaccent O -18
KPX Tcommaaccent Oacute -18
KPX Tcommaaccent Ocircumflex -18
KPX Tcommaaccent Odieresis -18
KPX Tcommaaccent Ograve -18
KPX Tcommaaccent Ohungarumlaut -18
KPX Tcommaaccent Omacron -18
KPX Tcommaaccent Oslash -18
KPX Tcommaaccent Otilde -18
KPX Tcommaaccent a -92
KPX Tcommaaccent aacute -92
KPX Tcommaaccent abreve -52
KPX Tcommaaccent acircumflex -52
KPX Tcommaaccent adieresis -52
KPX Tcommaaccent agrave -52
KPX Tcommaaccent amacron -52
KPX Tcommaaccent aogonek -92
KPX Tcommaaccent aring -92
KPX Tcommaaccent atilde -52
KPX Tcommaaccent colon -74
KPX Tcommaaccent comma -74
KPX Tcommaaccent e -92
KPX Tcommaaccent eacute -92
KPX Tcommaaccent ecaron -92
KPX Tcommaaccent ecircumflex -92
KPX Tcommaaccent edieresis -52
KPX Tcommaaccent edotaccent -92
KPX Tcommaaccent egrave -52
KPX Tcommaaccent emacron -52
KPX Tcommaaccent eogonek -92
KPX Tcommaaccent hyphen -92
KPX Tcommaaccent i -18
KPX Tcommaaccent iacute -18
KPX Tcommaaccent iogonek -18
KPX Tcommaaccent o -92
KPX Tcommaaccent oacute -92
KPX Tcommaaccent ocircumflex -92
KPX Tcommaaccent odieresis -92
KPX Tcommaaccent ograve -92
KPX Tcommaaccent ohungarumlaut -92
KPX Tcommaaccent omacron -92
KPX Tcommaaccent oslash -92
KPX Tcommaaccent otilde -92
KPX Tcommaaccent period -90
KPX Tcommaaccent r -74
KPX Tcommaaccent racute -74
KPX Tcommaaccent rcaron -74
KPX Tcommaaccent rcommaaccent -74
KPX Tcommaaccent semicolon -74
KPX Tcommaaccent u -92
KPX Tcommaaccent uacute -92
KPX Tcommaaccent ucircumflex -92
KPX Tcommaaccent udieresis -92
KPX Tcommaaccent ugrave -92
KPX Tcommaaccent uhungarumlaut -92
KPX Tcommaaccent umacron -92
KPX Tcommaaccent uogonek -92
KPX Tcommaaccent uring -92
KPX Tcommaaccent w -74
KPX Tcommaaccent y -34
KPX Tcommaaccent yacute -34
KPX Tcommaaccent ydieresis -34
KPX U A -60
KPX U Aacute -60
KPX U Abreve -60
KPX U Acircumflex -60
KPX U Adieresis -60
KPX U Agrave -60
KPX U Amacron -60
KPX U Aogonek -60
KPX U Aring -60
KPX U Atilde -60
KPX U comma -50
KPX U period -50
KPX Uacute A -60
KPX Uacute Aacute -60
KPX Uacute Abreve -60
KPX Uacute Acircumflex -60
KPX Uacute Adieresis -60
KPX Uacute Agrave -60
KPX Uacute Amacron -60
KPX Uacute Aogonek -60
KPX Uacute Aring -60
KPX Uacute Atilde -60
KPX Uacute comma -50
KPX Uacute period -50
KPX Ucircumflex A -60
KPX Ucircumflex Aacute -60
KPX Ucircumflex Abreve -60
KPX Ucircumflex Acircumflex -60
KPX Ucircumflex Adieresis -60
KPX Ucircumflex Agrave -60
KPX Ucircumflex Amacron -60
KPX Ucircumflex Aogonek -60
KPX Ucircumflex Aring -60
KPX Ucircumflex Atilde -60
KPX Ucircumflex comma -50
KPX Ucircumflex period -50
KPX Udieresis A -60
KPX Udieresis Aacute -60
KPX Udieresis Abreve -60
KPX Udieresis Acircumflex -60
KPX Udieresis Adieresis -60
KPX Udieresis Agrave -60
KPX Udieresis Amacron -60
KPX Udieresis Aogonek -60
KPX Udieresis Aring -60
KPX Udieresis Atilde -60
KPX Udieresis comma -50
KPX Udieresis period -50
KPX Ugrave A -60
KPX Ugrave Aacute -60
KPX Ugrave Abreve -60
KPX Ugrave Acircumflex -60
KPX Ugrave Adieresis -60
KPX Ugrave Agrave -60
KPX Ugrave Amacron -60
KPX Ugrave Aogonek -60
KPX Ugrave Aring -60
KPX Ugrave Atilde -60
KPX Ugrave comma -50
KPX Ugrave period -50
KPX Uhungarumlaut A -60
KPX Uhungarumlaut Aacute -60
KPX Uhungarumlaut Abreve -60
KPX Uhungarumlaut Acircumflex -60
KPX Uhungarumlaut Adieresis -60
KPX Uhungarumlaut Agrave -60
KPX Uhungarumlaut Amacron -60
KPX Uhungarumlaut Aogonek -60
KPX Uhungarumlaut Aring -60
KPX Uhungarumlaut Atilde -60
KPX Uhungarumlaut comma -50
KPX Uhungarumlaut period -50
KPX Umacron A -60
KPX Umacron Aacute -60
KPX Umacron Abreve -60
KPX Umacron Acircumflex -60
KPX Umacron Adieresis -60
KPX Umacron Agrave -60
KPX Umacron Amacron -60
KPX Umacron Aogonek -60
KPX Umacron Aring -60
KPX Umacron Atilde -60
KPX Umacron comma -50
KPX Umacron period -50
KPX Uogonek A -60
KPX Uogonek Aacute -60
KPX Uogonek Abreve -60
KPX Uogonek Acircumflex -60
KPX Uogonek Adieresis -60
KPX Uogonek Agrave -60
KPX Uogonek Amacron -60
KPX Uogonek Aogonek -60
KPX Uogonek Aring -60
KPX Uogonek Atilde -60
KPX Uogonek comma -50
KPX Uogonek period -50
KPX Uring A -60
KPX Uring Aacute -60
KPX Uring Abreve -60
KPX Uring Acircumflex -60
KPX Uring Adieresis -60
KPX Uring Agrave -60
KPX Uring Amacron -60
KPX Uring Aogonek -60
KPX Uring Aring -60
KPX Uring Atilde -60
KPX Uring comma -50
KPX Uring period -50
KPX V A -135
KPX V Aacute -135
KPX V Abreve -135
KPX V Acircumflex -135
KPX V Adieresis -135
KPX V Agrave -135
KPX V Amacron -135
KPX V Aogonek -135
KPX V Aring -135
KPX V Atilde -135
KPX V G -30
KPX V Gbreve -30
KPX V Gcommaaccent -30
KPX V O -45
KPX V Oacute -45
KPX V Ocircumflex -45
KPX V Odieresis -45
KPX V Ograve -45
KPX V Ohungarumlaut -45
KPX V Omacron -45
KPX V Oslash -45
KPX V Otilde -45
KPX V a -92
KPX V aacute -92
KPX V abreve -92
KPX V acircumflex -92
KPX V adieresis -92
KPX V agrave -92
KPX V amacron -92
KPX V aogonek -92
KPX V aring -92
KPX V atilde -92
KPX V colon -92
KPX V comma -129
KPX V e -100
KPX V eacute -100
KPX V ecaron -100
KPX V ecircumflex -100
KPX V edieresis -100
KPX V edotaccent -100
KPX V egrave -100
KPX V emacron -100
KPX V eogonek -100
KPX V hyphen -74
KPX V i -37
KPX V iacute -37
KPX V icircumflex -37
KPX V idieresis -37
KPX V igrave -37
KPX V imacron -37
KPX V iogonek -37
KPX V o -100
KPX V oacute -100
KPX V ocircumflex -100
KPX V odieresis -100
KPX V ograve -100
KPX V ohungarumlaut -100
KPX V omacron -100
KPX V oslash -100
KPX V otilde -100
KPX V period -145
KPX V semicolon -92
KPX V u -92
KPX V uacute -92
KPX V ucircumflex -92
KPX V udieresis -92
KPX V ugrave -92
KPX V uhungarumlaut -92
KPX V umacron -92
KPX V uogonek -92
KPX V uring -92
KPX W A -120
KPX W Aacute -120
KPX W Abreve -120
KPX W Acircumflex -120
KPX W Adieresis -120
KPX W Agrave -120
KPX W Amacron -120
KPX W Aogonek -120
KPX W Aring -120
KPX W Atilde -120
KPX W O -10
KPX W Oacute -10
KPX W Ocircumflex -10
KPX W Odieresis -10
KPX W Ograve -10
KPX W Ohungarumlaut -10
KPX W Omacron -10
KPX W Oslash -10
KPX W Otilde -10
KPX W a -65
KPX W aacute -65
KPX W abreve -65
KPX W acircumflex -65
KPX W adieresis -65
KPX W agrave -65
KPX W amacron -65
KPX W aogonek -65
KPX W aring -65
KPX W atilde -65
KPX W colon -55
KPX W comma -92
KPX W e -65
KPX W eacute -65
KPX W ecaron -65
KPX W ecircumflex -65
KPX W edieresis -65
KPX W edotaccent -65
KPX W egrave -65
KPX W emacron -65
KPX W eogonek -65
KPX W hyphen -37
KPX W i -18
KPX W iacute -18
KPX W iogonek -18
KPX W o -75
KPX W oacute -75
KPX W ocircumflex -75
KPX W odieresis -75
KPX W ograve -75
KPX W ohungarumlaut -75
KPX W omacron -75
KPX W oslash -75
KPX W otilde -75
KPX W period -92
KPX W semicolon -55
KPX W u -50
KPX W uacute -50
KPX W ucircumflex -50
KPX W udieresis -50
KPX W ugrave -50
KPX W uhungarumlaut -50
KPX W umacron -50
KPX W uogonek -50
KPX W uring -50
KPX W y -60
KPX W yacute -60
KPX W ydieresis -60
KPX Y A -110
KPX Y Aacute -110
KPX Y Abreve -110
KPX Y Acircumflex -110
KPX Y Adieresis -110
KPX Y Agrave -110
KPX Y Amacron -110
KPX Y Aogonek -110
KPX Y Aring -110
KPX Y Atilde -110
KPX Y O -35
KPX Y Oacute -35
KPX Y Ocircumflex -35
KPX Y Odieresis -35
KPX Y Ograve -35
KPX Y Ohungarumlaut -35
KPX Y Omacron -35
KPX Y Oslash -35
KPX Y Otilde -35
KPX Y a -85
KPX Y aacute -85
KPX Y abreve -85
KPX Y acircumflex -85
KPX Y adieresis -85
KPX Y agrave -85
KPX Y amacron -85
KPX Y aogonek -85
KPX Y aring -85
KPX Y atilde -85
KPX Y colon -92
KPX Y comma -92
KPX Y e -111
KPX Y eacute -111
KPX Y ecaron -111
KPX Y ecircumflex -111
KPX Y edieresis -71
KPX Y edotaccent -111
KPX Y egrave -71
KPX Y emacron -71
KPX Y eogonek -111
KPX Y hyphen -92
KPX Y i -37
KPX Y iacute -37
KPX Y iogonek -37
KPX Y o -111
KPX Y oacute -111
KPX Y ocircumflex -111
KPX Y odieresis -111
KPX Y ograve -111
KPX Y ohungarumlaut -111
KPX Y omacron -111
KPX Y oslash -111
KPX Y otilde -111
KPX Y period -92
KPX Y semicolon -92
KPX Y u -92
KPX Y uacute -92
KPX Y ucircumflex -92
KPX Y udieresis -92
KPX Y ugrave -92
KPX Y uhungarumlaut -92
KPX Y umacron -92
KPX Y uogonek -92
KPX Y uring -92
KPX Yacute A -110
KPX Yacute Aacute -110
KPX Yacute Abreve -110
KPX Yacute Acircumflex -110
KPX Yacute Adieresis -110
KPX Yacute Agrave -110
KPX Yacute Amacron -110
KPX Yacute Aogonek -110
KPX Yacute Aring -110
KPX Yacute Atilde -110
KPX Yacute O -35
KPX Yacute Oacute -35
KPX Yacute Ocircumflex -35
KPX Yacute Odieresis -35
KPX Yacute Ograve -35
KPX Yacute Ohungarumlaut -35
KPX Yacute Omacron -35
KPX Yacute Oslash -35
KPX Yacute Otilde -35
KPX Yacute a -85
KPX Yacute aacute -85
KPX Yacute abreve -85
KPX Yacute acircumflex -85
KPX Yacute adieresis -85
KPX Yacute agrave -85
KPX Yacute amacron -85
KPX Yacute aogonek -85
KPX Yacute aring -85
KPX Yacute atilde -85
KPX Yacute colon -92
KPX Yacute comma -92
KPX Yacute e -111
KPX Yacute eacute -111
KPX Yacute ecaron -111
KPX Yacute ecircumflex -111
KPX Yacute edieresis -71
KPX Yacute edotaccent -111
KPX Yacute egrave -71
KPX Yacute emacron -71
KPX Yacute eogonek -111
KPX Yacute hyphen -92
KPX Yacute i -37
KPX Yacute iacute -37
KPX Yacute iogonek -37
KPX Yacute o -111
KPX Yacute oacute -111
KPX Yacute ocircumflex -111
KPX Yacute odieresis -111
KPX Yacute ograve -111
KPX Yacute ohungarumlaut -111
KPX Yacute omacron -111
KPX Yacute oslash -111
KPX Yacute otilde -111
KPX Yacute period -92
KPX Yacute semicolon -92
KPX Yacute u -92
KPX Yacute uacute -92
KPX Yacute ucircumflex -92
KPX Yacute udieresis -92
KPX Yacute ugrave -92
KPX Yacute uhungarumlaut -92
KPX Yacute umacron -92
KPX Yacute uogonek -92
KPX Yacute uring -92
KPX Ydieresis A -110
KPX Ydieresis Aacute -110
KPX Ydieresis Abreve -110
KPX Ydieresis Acircumflex -110
KPX Ydieresis Adieresis -110
KPX Ydieresis Agrave -110
KPX Ydieresis Amacron -110
KPX Ydieresis Aogonek -110
KPX Ydieresis Aring -110
KPX Ydieresis Atilde -110
KPX Ydieresis O -35
KPX Ydieresis Oacute -35
KPX Ydieresis Ocircumflex -35
KPX Ydieresis Odieresis -35
KPX Ydieresis Ograve -35
KPX Ydieresis Ohungarumlaut -35
KPX Ydieresis Omacron -35
KPX Ydieresis Oslash -35
KPX Ydieresis Otilde -35
KPX Ydieresis a -85
KPX Ydieresis aacute -85
KPX Ydieresis abreve -85
KPX Ydieresis acircumflex -85
KPX Ydieresis adieresis -85
KPX Ydieresis agrave -85
KPX Ydieresis amacron -85
KPX Ydieresis aogonek -85
KPX Ydieresis aring -85
KPX Ydieresis atilde -85
KPX Ydieresis colon -92
KPX Ydieresis comma -92
KPX Ydieresis e -111
KPX Ydieresis eacute -111
KPX Ydieresis ecaron -111
KPX Ydieresis ecircumflex -111
KPX Ydieresis edieresis -71
KPX Ydieresis edotaccent -111
KPX Ydieresis egrave -71
KPX Ydieresis emacron -71
KPX Ydieresis eogonek -111
KPX Ydieresis hyphen -92
KPX Ydieresis i -37
KPX Ydieresis iacute -37
KPX Ydieresis iogonek -37
KPX Ydieresis o -111
KPX Ydieresis oacute -111
KPX Ydieresis ocircumflex -111
KPX Ydieresis odieresis -111
KPX Ydieresis ograve -111
KPX Ydieresis ohungarumlaut -111
KPX Ydieresis omacron -111
KPX Ydieresis oslash -111
KPX Ydieresis otilde -111
KPX Ydieresis period -92
KPX Ydieresis semicolon -92
KPX Ydieresis u -92
KPX Ydieresis uacute -92
KPX Ydieresis ucircumflex -92
KPX Ydieresis udieresis -92
KPX Ydieresis ugrave -92
KPX Ydieresis uhungarumlaut -92
KPX Ydieresis umacron -92
KPX Ydieresis uogonek -92
KPX Ydieresis uring -92
KPX a v -25
KPX aacute v -25
KPX abreve v -25
KPX acircumflex v -25
KPX adieresis v -25
KPX agrave v -25
KPX amacron v -25
KPX aogonek v -25
KPX aring v -25
KPX atilde v -25
KPX b b -10
KPX b period -40
KPX b u -20
KPX b uacute -20
KPX b ucircumflex -20
KPX b udieresis -20
KPX b ugrave -20
KPX b uhungarumlaut -20
KPX b umacron -20
KPX b uogonek -20
KPX b uring -20
KPX b v -15
KPX comma quotedblright -45
KPX comma quoteright -55
KPX d w -15
KPX dcroat w -15
KPX e v -15
KPX eacute v -15
KPX ecaron v -15
KPX ecircumflex v -15
KPX edieresis v -15
KPX edotaccent v -15
KPX egrave v -15
KPX emacron v -15
KPX eogonek v -15
KPX f comma -15
KPX f dotlessi -35
KPX f i -25
KPX f o -25
KPX f oacute -25
KPX f ocircumflex -25
KPX f odieresis -25
KPX f ograve -25
KPX f ohungarumlaut -25
KPX f omacron -25
KPX f oslash -25
KPX f otilde -25
KPX f period -15
KPX f quotedblright 50
KPX f quoteright 55
KPX g period -15
KPX gbreve period -15
KPX gcommaaccent period -15
KPX h y -15
KPX h yacute -15
KPX h ydieresis -15
KPX i v -10
KPX iacute v -10
KPX icircumflex v -10
KPX idieresis v -10
KPX igrave v -10
KPX imacron v -10
KPX iogonek v -10
KPX k e -10
KPX k eacute -10
KPX k ecaron -10
KPX k ecircumflex -10
KPX k edieresis -10
KPX k edotaccent -10
KPX k egrave -10
KPX k emacron -10
KPX k eogonek -10
KPX k o -15
KPX k oacute -15
KPX k ocircumflex -15
KPX k odieresis -15
KPX k ograve -15
KPX k ohungarumlaut -15
KPX k omacron -15
KPX k oslash -15
KPX k otilde -15
KPX k y -15
KPX k yacute -15
KPX k ydieresis -15
KPX kcommaaccent e -10
KPX kcommaaccent eacute -10
KPX kcommaaccent ecaron -10
KPX kcommaaccent ecircumflex -10
KPX kcommaaccent edieresis -10
KPX kcommaaccent edotaccent -10
KPX kcommaaccent egrave -10
KPX kcommaaccent emacron -10
KPX kcommaaccent eogonek -10
KPX kcommaaccent o -15
KPX kcommaaccent oacute -15
KPX kcommaaccent ocircumflex -15
KPX kcommaaccent odieresis -15
KPX kcommaaccent ograve -15
KPX kcommaaccent ohungarumlaut -15
KPX kcommaaccent omacron -15
KPX kcommaaccent oslash -15
KPX kcommaaccent otilde -15
KPX kcommaaccent y -15
KPX kcommaaccent yacute -15
KPX kcommaaccent ydieresis -15
KPX n v -40
KPX nacute v -40
KPX ncaron v -40
KPX ncommaaccent v -40
KPX ntilde v -40
KPX o v -10
KPX o w -10
KPX oacute v -10
KPX oacute w -10
KPX ocircumflex v -10
KPX ocircumflex w -10
KPX odieresis v -10
KPX odieresis w -10
KPX ograve v -10
KPX ograve w -10
KPX ohungarumlaut v -10
KPX ohungarumlaut w -10
KPX omacron v -10
KPX omacron w -10
KPX oslash v -10
KPX oslash w -10
KPX otilde v -10
KPX otilde w -10
KPX period quotedblright -55
KPX period quoteright -55
KPX quotedblleft A -10
KPX quotedblleft Aacute -10
KPX quotedblleft Abreve -10
KPX quotedblleft Acircumflex -10
KPX quotedblleft Adieresis -10
KPX quotedblleft Agrave -10
KPX quotedblleft Amacron -10
KPX quotedblleft Aogonek -10
KPX quotedblleft Aring -10
KPX quotedblleft Atilde -10
KPX quoteleft A -10
KPX quoteleft Aacute -10
KPX quoteleft Abreve -10
KPX quoteleft Acircumflex -10
KPX quoteleft Adieresis -10
KPX quoteleft Agrave -10
KPX quoteleft Amacron -10
KPX quoteleft Aogonek -10
KPX quoteleft Aring -10
KPX quoteleft Atilde -10
KPX quoteleft quoteleft -63
KPX quoteright d -20
KPX quoteright dcroat -20
KPX quoteright quoteright -63
KPX quoteright r -20
KPX quoteright racute -20
KPX quoteright rcaron -20
KPX quoteright rcommaaccent -20
KPX quoteright s -37
KPX quoteright sacute -37
KPX quoteright scaron -37
KPX quoteright scedilla -37
KPX quoteright scommaaccent -37
KPX quoteright space -74
KPX quoteright v -20
KPX r c -18
KPX r cacute -18
KPX r ccaron -18
KPX r ccedilla -18
KPX r comma -92
KPX r e -18
KPX r eacute -18
KPX r ecaron -18
KPX r ecircumflex -18
KPX r edieresis -18
KPX r edotaccent -18
KPX r egrave -18
KPX r emacron -18
KPX r eogonek -18
KPX r g -10
KPX r gbreve -10
KPX r gcommaaccent -10
KPX r hyphen -37
KPX r n -15
KPX r nacute -15
KPX r ncaron -15
KPX r ncommaaccent -15
KPX r ntilde -15
KPX r o -18
KPX r oacute -18
KPX r ocircumflex -18
KPX r odieresis -18
KPX r ograve -18
KPX r ohungarumlaut -18
KPX r omacron -18
KPX r oslash -18
KPX r otilde -18
KPX r p -10
KPX r period -100
KPX r q -18
KPX r v -10
KPX racute c -18
KPX racute cacute -18
KPX racute ccaron -18
KPX racute ccedilla -18
KPX racute comma -92
KPX racute e -18
KPX racute eacute -18
KPX racute ecaron -18
KPX racute ecircumflex -18
KPX racute edieresis -18
KPX racute edotaccent -18
KPX racute egrave -18
KPX racute emacron -18
KPX racute eogonek -18
KPX racute g -10
KPX racute gbreve -10
KPX racute gcommaaccent -10
KPX racute hyphen -37
KPX racute n -15
KPX racute nacute -15
KPX racute ncaron -15
KPX racute ncommaaccent -15
KPX racute ntilde -15
KPX racute o -18
KPX racute oacute -18
KPX racute ocircumflex -18
KPX racute odieresis -18
KPX racute ograve -18
KPX racute ohungarumlaut -18
KPX racute omacron -18
KPX racute oslash -18
KPX racute otilde -18
KPX racute p -10
KPX racute period -100
KPX racute q -18
KPX racute v -10
KPX rcaron c -18
KPX rcaron cacute -18
KPX rcaron ccaron -18
KPX rcaron ccedilla -18
KPX rcaron comma -92
KPX rcaron e -18
KPX rcaron eacute -18
KPX rcaron ecaron -18
KPX rcaron ecircumflex -18
KPX rcaron edieresis -18
KPX rcaron edotaccent -18
KPX rcaron egrave -18
KPX rcaron emacron -18
KPX rcaron eogonek -18
KPX rcaron g -10
KPX rcaron gbreve -10
KPX rcaron gcommaaccent -10
KPX rcaron hyphen -37
KPX rcaron n -15
KPX rcaron nacute -15
KPX rcaron ncaron -15
KPX rcaron ncommaaccent -15
KPX rcaron ntilde -15
KPX rcaron o -18
KPX rcaron oacute -18
KPX rcaron ocircumflex -18
KPX rcaron odieresis -18
KPX rcaron ograve -18
KPX rcaron ohungarumlaut -18
KPX rcaron omacron -18
KPX rcaron oslash -18
KPX rcaron otilde -18
KPX rcaron p -10
KPX rcaron period -100
KPX rcaron q -18
KPX rcaron v -10
KPX rcommaaccent c -18
KPX rcommaaccent cacute -18
KPX rcommaaccent ccaron -18
KPX rcommaaccent ccedilla -18
KPX rcommaaccent comma -92
KPX rcommaaccent e -18
KPX rcommaaccent eacute -18
KPX rcommaaccent ecaron -18
KPX rcommaaccent ecircumflex -18
KPX rcommaaccent edieresis -18
KPX rcommaaccent edotaccent -18
KPX rcommaaccent egrave -18
KPX rcommaaccent emacron -18
KPX rcommaaccent eogonek -18
KPX rcommaaccent g -10
KPX rcommaaccent gbreve -10
KPX rcommaaccent gcommaaccent -10
KPX rcommaaccent hyphen -37
KPX rcommaaccent n -15
KPX rcommaaccent nacute -15
KPX rcommaaccent ncaron -15
KPX rcommaaccent ncommaaccent -15
KPX rcommaaccent ntilde -15
KPX rcommaaccent o -18
KPX rcommaaccent oacute -18
KPX rcommaaccent ocircumflex -18
KPX rcommaaccent odieresis -18
KPX rcommaaccent ograve -18
KPX rcommaaccent ohungarumlaut -18
KPX rcommaaccent omacron -18
KPX rcommaaccent oslash -18
KPX rcommaaccent otilde -18
KPX rcommaaccent p -10
KPX rcommaaccent period -100
KPX rcommaaccent q -18
KPX rcommaaccent v -10
KPX space A -55
KPX space Aacute -55
KPX space Abreve -55
KPX space Acircumflex -55
KPX space Adieresis -55
KPX space Agrave -55
KPX space Amacron -55
KPX space Aogonek -55
KPX space Aring -55
KPX space Atilde -55
KPX space T -30
KPX space Tcaron -30
KPX space Tcommaaccent -30
KPX space V -45
KPX space W -30
KPX space Y -55
KPX space Yacute -55
KPX space Ydieresis -55
KPX v a -10
KPX v aacute -10
KPX v abreve -10
KPX v acircumflex -10
KPX v adieresis -10
KPX v agrave -10
KPX v amacron -10
KPX v aogonek -10
KPX v aring -10
KPX v atilde -10
KPX v comma -55
KPX v e -10
KPX v eacute -10
KPX v ecaron -10
KPX v ecircumflex -10
KPX v edieresis -10
KPX v edotaccent -10
KPX v egrave -10
KPX v emacron -10
KPX v eogonek -10
KPX v o -10
KPX v oacute -10
KPX v ocircumflex -10
KPX v odieresis -10
KPX v ograve -10
KPX v ohungarumlaut -10
KPX v omacron -10
KPX v oslash -10
KPX v otilde -10
KPX v period -70
KPX w comma -55
KPX w o -10
KPX w oacute -10
KPX w ocircumflex -10
KPX w odieresis -10
KPX w ograve -10
KPX w ohungarumlaut -10
KPX w omacron -10
KPX w oslash -10
KPX w otilde -10
KPX w period -70
KPX y comma -55
KPX y e -10
KPX y eacute -10
KPX y ecaron -10
KPX y ecircumflex -10
KPX y edieresis -10
KPX y edotaccent -10
KPX y egrave -10
KPX y emacron -10
KPX y eogonek -10
KPX y o -25
KPX y oacute -25
KPX y ocircumflex -25
KPX y odieresis -25
KPX y ograve -25
KPX y ohungarumlaut -25
KPX y omacron -25
KPX y oslash -25
KPX y otilde -25
KPX y period -70
KPX yacute comma -55
KPX yacute e -10
KPX yacute eacute -10
KPX yacute ecaron -10
KPX yacute ecircumflex -10
KPX yacute edieresis -10
KPX yacute edotaccent -10
KPX yacute egrave -10
KPX yacute emacron -10
KPX yacute eogonek -10
KPX yacute o -25
KPX yacute oacute -25
KPX yacute ocircumflex -25
KPX yacute odieresis -25
KPX yacute ograve -25
KPX yacute ohungarumlaut -25
KPX yacute omacron -25
KPX yacute oslash -25
KPX yacute otilde -25
KPX yacute period -70
KPX ydieresis comma -55
KPX ydieresis e -10
KPX ydieresis eacute -10
KPX ydieresis ecaron -10
KPX ydieresis ecircumflex -10
KPX ydieresis edieresis -10
KPX ydieresis edotaccent -10
KPX ydieresis egrave -10
KPX ydieresis emacron -10
KPX ydieresis eogonek -10
KPX ydieresis o -25
KPX ydieresis oacute -25
KPX ydieresis ocircumflex -25
KPX ydieresis odieresis -25
KPX ydieresis ograve -25
KPX ydieresis ohungarumlaut -25
KPX ydieresis omacron -25
KPX ydieresis oslash -25
KPX ydieresis otilde -25
KPX ydieresis period -70
EndKernPairs
EndKernData
EndFontMetrics"

let times_italic_afm = "StartFontMetrics 4.1
Comment Copyright (c) 1985, 1987, 1989, 1990, 1993, 1997 Adobe Systems Incorporated.  All Rights Reserved.
Comment Creation Date: Thu May  1 12:56:55 1997
Comment UniqueID 43067
Comment VMusage 47727 58752
FontName Times-Italic
FullName Times Italic
FamilyName Times
Weight Medium
ItalicAngle -15.5
IsFixedPitch false
CharacterSet ExtendedRoman
FontBBox -169 -217 1010 883 
UnderlinePosition -100
UnderlineThickness 50
Version 002.000
Notice Copyright (c) 1985, 1987, 1989, 1990, 1993, 1997 Adobe Systems Incorporated.  All Rights Reserved.Times is a trademark of Linotype-Hell AG and/or its subsidiaries.
EncodingScheme AdobeStandardEncoding
CapHeight 653
XHeight 441
Ascender 683
Descender -217
StdHW 32
StdVW 76
StartCharMetrics 315
C 32 ; WX 250 ; N space ; B 0 0 0 0 ;
C 33 ; WX 333 ; N exclam ; B 39 -11 302 667 ;
C 34 ; WX 420 ; N quotedbl ; B 144 421 432 666 ;
C 35 ; WX 500 ; N numbersign ; B 2 0 540 676 ;
C 36 ; WX 500 ; N dollar ; B 31 -89 497 731 ;
C 37 ; WX 833 ; N percent ; B 79 -13 790 676 ;
C 38 ; WX 778 ; N ampersand ; B 76 -18 723 666 ;
C 39 ; WX 333 ; N quoteright ; B 151 436 290 666 ;
C 40 ; WX 333 ; N parenleft ; B 42 -181 315 669 ;
C 41 ; WX 333 ; N parenright ; B 16 -180 289 669 ;
C 42 ; WX 500 ; N asterisk ; B 128 255 492 666 ;
C 43 ; WX 675 ; N plus ; B 86 0 590 506 ;
C 44 ; WX 250 ; N comma ; B -4 -129 135 101 ;
C 45 ; WX 333 ; N hyphen ; B 49 192 282 255 ;
C 46 ; WX 250 ; N period ; B 27 -11 138 100 ;
C 47 ; WX 278 ; N slash ; B -65 -18 386 666 ;
C 48 ; WX 500 ; N zero ; B 32 -7 497 676 ;
C 49 ; WX 500 ; N one ; B 49 0 409 676 ;
C 50 ; WX 500 ; N two ; B 12 0 452 676 ;
C 51 ; WX 500 ; N three ; B 15 -7 465 676 ;
C 52 ; WX 500 ; N four ; B 1 0 479 676 ;
C 53 ; WX 500 ; N five ; B 15 -7 491 666 ;
C 54 ; WX 500 ; N six ; B 30 -7 521 686 ;
C 55 ; WX 500 ; N seven ; B 75 -8 537 666 ;
C 56 ; WX 500 ; N eight ; B 30 -7 493 676 ;
C 57 ; WX 500 ; N nine ; B 23 -17 492 676 ;
C 58 ; WX 333 ; N colon ; B 50 -11 261 441 ;
C 59 ; WX 333 ; N semicolon ; B 27 -129 261 441 ;
C 60 ; WX 675 ; N less ; B 84 -8 592 514 ;
C 61 ; WX 675 ; N equal ; B 86 120 590 386 ;
C 62 ; WX 675 ; N greater ; B 84 -8 592 514 ;
C 63 ; WX 500 ; N question ; B 132 -12 472 664 ;
C 64 ; WX 920 ; N at ; B 118 -18 806 666 ;
C 65 ; WX 611 ; N A ; B -51 0 564 668 ;
C 66 ; WX 611 ; N B ; B -8 0 588 653 ;
C 67 ; WX 667 ; N C ; B 66 -18 689 666 ;
C 68 ; WX 722 ; N D ; B -8 0 700 653 ;
C 69 ; WX 611 ; N E ; B -1 0 634 653 ;
C 70 ; WX 611 ; N F ; B 8 0 645 653 ;
C 71 ; WX 722 ; N G ; B 52 -18 722 666 ;
C 72 ; WX 722 ; N H ; B -8 0 767 653 ;
C 73 ; WX 333 ; N I ; B -8 0 384 653 ;
C 74 ; WX 444 ; N J ; B -6 -18 491 653 ;
C 75 ; WX 667 ; N K ; B 7 0 722 653 ;
C 76 ; WX 556 ; N L ; B -8 0 559 653 ;
C 77 ; WX 833 ; N M ; B -18 0 873 653 ;
C 78 ; WX 667 ; N N ; B -20 -15 727 653 ;
C 79 ; WX 722 ; N O ; B 60 -18 699 666 ;
C 80 ; WX 611 ; N P ; B 0 0 605 653 ;
C 81 ; WX 722 ; N Q ; B 59 -182 699 666 ;
C 82 ; WX 611 ; N R ; B -13 0 588 653 ;
C 83 ; WX 500 ; N S ; B 17 -18 508 667 ;
C 84 ; WX 556 ; N T ; B 59 0 633 653 ;
C 85 ; WX 722 ; N U ; B 102 -18 765 653 ;
C 86 ; WX 611 ; N V ; B 76 -18 688 653 ;
C 87 ; WX 833 ; N W ; B 71 -18 906 653 ;
C 88 ; WX 611 ; N X ; B -29 0 655 653 ;
C 89 ; WX 556 ; N Y ; B 78 0 633 653 ;
C 90 ; WX 556 ; N Z ; B -6 0 606 653 ;
C 91 ; WX 389 ; N bracketleft ; B 21 -153 391 663 ;
C 92 ; WX 278 ; N backslash ; B -41 -18 319 666 ;
C 93 ; WX 389 ; N bracketright ; B 12 -153 382 663 ;
C 94 ; WX 422 ; N asciicircum ; B 0 301 422 666 ;
C 95 ; WX 500 ; N underscore ; B 0 -125 500 -75 ;
C 96 ; WX 333 ; N quoteleft ; B 171 436 310 666 ;
C 97 ; WX 500 ; N a ; B 17 -11 476 441 ;
C 98 ; WX 500 ; N b ; B 23 -11 473 683 ;
C 99 ; WX 444 ; N c ; B 30 -11 425 441 ;
C 100 ; WX 500 ; N d ; B 15 -13 527 683 ;
C 101 ; WX 444 ; N e ; B 31 -11 412 441 ;
C 102 ; WX 278 ; N f ; B -147 -207 424 678 ; L i fi ; L l fl ;
C 103 ; WX 500 ; N g ; B 8 -206 472 441 ;
C 104 ; WX 500 ; N h ; B 19 -9 478 683 ;
C 105 ; WX 278 ; N i ; B 49 -11 264 654 ;
C 106 ; WX 278 ; N j ; B -124 -207 276 654 ;
C 107 ; WX 444 ; N k ; B 14 -11 461 683 ;
C 108 ; WX 278 ; N l ; B 41 -11 279 683 ;
C 109 ; WX 722 ; N m ; B 12 -9 704 441 ;
C 110 ; WX 500 ; N n ; B 14 -9 474 441 ;
C 111 ; WX 500 ; N o ; B 27 -11 468 441 ;
C 112 ; WX 500 ; N p ; B -75 -205 469 441 ;
C 113 ; WX 500 ; N q ; B 25 -209 483 441 ;
C 114 ; WX 389 ; N r ; B 45 0 412 441 ;
C 115 ; WX 389 ; N s ; B 16 -13 366 442 ;
C 116 ; WX 278 ; N t ; B 37 -11 296 546 ;
C 117 ; WX 500 ; N u ; B 42 -11 475 441 ;
C 118 ; WX 444 ; N v ; B 21 -18 426 441 ;
C 119 ; WX 667 ; N w ; B 16 -18 648 441 ;
C 120 ; WX 444 ; N x ; B -27 -11 447 441 ;
C 121 ; WX 444 ; N y ; B -24 -206 426 441 ;
C 122 ; WX 389 ; N z ; B -2 -81 380 428 ;
C 123 ; WX 400 ; N braceleft ; B 51 -177 407 687 ;
C 124 ; WX 275 ; N bar ; B 105 -217 171 783 ;
C 125 ; WX 400 ; N braceright ; B -7 -177 349 687 ;
C 126 ; WX 541 ; N asciitilde ; B 40 183 502 323 ;
C 161 ; WX 389 ; N exclamdown ; B 59 -205 322 473 ;
C 162 ; WX 500 ; N cent ; B 77 -143 472 560 ;
C 163 ; WX 500 ; N sterling ; B 10 -6 517 670 ;
C 164 ; WX 167 ; N fraction ; B -169 -10 337 676 ;
C 165 ; WX 500 ; N yen ; B 27 0 603 653 ;
C 166 ; WX 500 ; N florin ; B 25 -182 507 682 ;
C 167 ; WX 500 ; N section ; B 53 -162 461 666 ;
C 168 ; WX 500 ; N currency ; B -22 53 522 597 ;
C 169 ; WX 214 ; N quotesingle ; B 132 421 241 666 ;
C 170 ; WX 556 ; N quotedblleft ; B 166 436 514 666 ;
C 171 ; WX 500 ; N guillemotleft ; B 53 37 445 403 ;
C 172 ; WX 333 ; N guilsinglleft ; B 51 37 281 403 ;
C 173 ; WX 333 ; N guilsinglright ; B 52 37 282 403 ;
C 174 ; WX 500 ; N fi ; B -141 -207 481 681 ;
C 175 ; WX 500 ; N fl ; B -141 -204 518 682 ;
C 177 ; WX 500 ; N endash ; B -6 197 505 243 ;
C 178 ; WX 500 ; N dagger ; B 101 -159 488 666 ;
C 179 ; WX 500 ; N daggerdbl ; B 22 -143 491 666 ;
C 180 ; WX 250 ; N periodcentered ; B 70 199 181 310 ;
C 182 ; WX 523 ; N paragraph ; B 55 -123 616 653 ;
C 183 ; WX 350 ; N bullet ; B 40 191 310 461 ;
C 184 ; WX 333 ; N quotesinglbase ; B 44 -129 183 101 ;
C 185 ; WX 556 ; N quotedblbase ; B 57 -129 405 101 ;
C 186 ; WX 556 ; N quotedblright ; B 151 436 499 666 ;
C 187 ; WX 500 ; N guillemotright ; B 55 37 447 403 ;
C 188 ; WX 889 ; N ellipsis ; B 57 -11 762 100 ;
C 189 ; WX 1000 ; N perthousand ; B 25 -19 1010 706 ;
C 191 ; WX 500 ; N questiondown ; B 28 -205 368 471 ;
C 193 ; WX 333 ; N grave ; B 121 492 311 664 ;
C 194 ; WX 333 ; N acute ; B 180 494 403 664 ;
C 195 ; WX 333 ; N circumflex ; B 91 492 385 661 ;
C 196 ; WX 333 ; N tilde ; B 100 517 427 624 ;
C 197 ; WX 333 ; N macron ; B 99 532 411 583 ;
C 198 ; WX 333 ; N breve ; B 117 492 418 650 ;
C 199 ; WX 333 ; N dotaccent ; B 207 548 305 646 ;
C 200 ; WX 333 ; N dieresis ; B 107 548 405 646 ;
C 202 ; WX 333 ; N ring ; B 155 492 355 691 ;
C 203 ; WX 333 ; N cedilla ; B -30 -217 182 0 ;
C 205 ; WX 333 ; N hungarumlaut ; B 93 494 486 664 ;
C 206 ; WX 333 ; N ogonek ; B 20 -169 203 40 ;
C 207 ; WX 333 ; N caron ; B 121 492 426 661 ;
C 208 ; WX 889 ; N emdash ; B -6 197 894 243 ;
C 225 ; WX 889 ; N AE ; B -27 0 911 653 ;
C 227 ; WX 276 ; N ordfeminine ; B 42 406 352 676 ;
C 232 ; WX 556 ; N Lslash ; B -8 0 559 653 ;
C 233 ; WX 722 ; N Oslash ; B 60 -105 699 722 ;
C 234 ; WX 944 ; N OE ; B 49 -8 964 666 ;
C 235 ; WX 310 ; N ordmasculine ; B 67 406 362 676 ;
C 241 ; WX 667 ; N ae ; B 23 -11 640 441 ;
C 245 ; WX 278 ; N dotlessi ; B 49 -11 235 441 ;
C 248 ; WX 278 ; N lslash ; B 41 -11 312 683 ;
C 249 ; WX 500 ; N oslash ; B 28 -135 469 554 ;
C 250 ; WX 667 ; N oe ; B 20 -12 646 441 ;
C 251 ; WX 500 ; N germandbls ; B -168 -207 493 679 ;
C -1 ; WX 333 ; N Idieresis ; B -8 0 435 818 ;
C -1 ; WX 444 ; N eacute ; B 31 -11 459 664 ;
C -1 ; WX 500 ; N abreve ; B 17 -11 502 650 ;
C -1 ; WX 500 ; N uhungarumlaut ; B 42 -11 580 664 ;
C -1 ; WX 444 ; N ecaron ; B 31 -11 482 661 ;
C -1 ; WX 556 ; N Ydieresis ; B 78 0 633 818 ;
C -1 ; WX 675 ; N divide ; B 86 -11 590 517 ;
C -1 ; WX 556 ; N Yacute ; B 78 0 633 876 ;
C -1 ; WX 611 ; N Acircumflex ; B -51 0 564 873 ;
C -1 ; WX 500 ; N aacute ; B 17 -11 487 664 ;
C -1 ; WX 722 ; N Ucircumflex ; B 102 -18 765 873 ;
C -1 ; WX 444 ; N yacute ; B -24 -206 459 664 ;
C -1 ; WX 389 ; N scommaaccent ; B 16 -217 366 442 ;
C -1 ; WX 444 ; N ecircumflex ; B 31 -11 441 661 ;
C -1 ; WX 722 ; N Uring ; B 102 -18 765 883 ;
C -1 ; WX 722 ; N Udieresis ; B 102 -18 765 818 ;
C -1 ; WX 500 ; N aogonek ; B 17 -169 476 441 ;
C -1 ; WX 722 ; N Uacute ; B 102 -18 765 876 ;
C -1 ; WX 500 ; N uogonek ; B 42 -169 477 441 ;
C -1 ; WX 611 ; N Edieresis ; B -1 0 634 818 ;
C -1 ; WX 722 ; N Dcroat ; B -8 0 700 653 ;
C -1 ; WX 250 ; N commaaccent ; B 8 -217 133 -50 ;
C -1 ; WX 760 ; N copyright ; B 41 -18 719 666 ;
C -1 ; WX 611 ; N Emacron ; B -1 0 634 795 ;
C -1 ; WX 444 ; N ccaron ; B 30 -11 482 661 ;
C -1 ; WX 500 ; N aring ; B 17 -11 476 691 ;
C -1 ; WX 667 ; N Ncommaaccent ; B -20 -187 727 653 ;
C -1 ; WX 278 ; N lacute ; B 41 -11 395 876 ;
C -1 ; WX 500 ; N agrave ; B 17 -11 476 664 ;
C -1 ; WX 556 ; N Tcommaaccent ; B 59 -217 633 653 ;
C -1 ; WX 667 ; N Cacute ; B 66 -18 690 876 ;
C -1 ; WX 500 ; N atilde ; B 17 -11 511 624 ;
C -1 ; WX 611 ; N Edotaccent ; B -1 0 634 818 ;
C -1 ; WX 389 ; N scaron ; B 16 -13 454 661 ;
C -1 ; WX 389 ; N scedilla ; B 16 -217 366 442 ;
C -1 ; WX 278 ; N iacute ; B 49 -11 355 664 ;
C -1 ; WX 471 ; N lozenge ; B 13 0 459 724 ;
C -1 ; WX 611 ; N Rcaron ; B -13 0 588 873 ;
C -1 ; WX 722 ; N Gcommaaccent ; B 52 -217 722 666 ;
C -1 ; WX 500 ; N ucircumflex ; B 42 -11 475 661 ;
C -1 ; WX 500 ; N acircumflex ; B 17 -11 476 661 ;
C -1 ; WX 611 ; N Amacron ; B -51 0 564 795 ;
C -1 ; WX 389 ; N rcaron ; B 45 0 434 661 ;
C -1 ; WX 444 ; N ccedilla ; B 30 -217 425 441 ;
C -1 ; WX 556 ; N Zdotaccent ; B -6 0 606 818 ;
C -1 ; WX 611 ; N Thorn ; B 0 0 569 653 ;
C -1 ; WX 722 ; N Omacron ; B 60 -18 699 795 ;
C -1 ; WX 611 ; N Racute ; B -13 0 588 876 ;
C -1 ; WX 500 ; N Sacute ; B 17 -18 508 876 ;
C -1 ; WX 544 ; N dcaron ; B 15 -13 658 683 ;
C -1 ; WX 722 ; N Umacron ; B 102 -18 765 795 ;
C -1 ; WX 500 ; N uring ; B 42 -11 475 691 ;
C -1 ; WX 300 ; N threesuperior ; B 43 268 339 676 ;
C -1 ; WX 722 ; N Ograve ; B 60 -18 699 876 ;
C -1 ; WX 611 ; N Agrave ; B -51 0 564 876 ;
C -1 ; WX 611 ; N Abreve ; B -51 0 564 862 ;
C -1 ; WX 675 ; N multiply ; B 93 8 582 497 ;
C -1 ; WX 500 ; N uacute ; B 42 -11 477 664 ;
C -1 ; WX 556 ; N Tcaron ; B 59 0 633 873 ;
C -1 ; WX 476 ; N partialdiff ; B 17 -38 459 710 ;
C -1 ; WX 444 ; N ydieresis ; B -24 -206 441 606 ;
C -1 ; WX 667 ; N Nacute ; B -20 -15 727 876 ;
C -1 ; WX 278 ; N icircumflex ; B 33 -11 327 661 ;
C -1 ; WX 611 ; N Ecircumflex ; B -1 0 634 873 ;
C -1 ; WX 500 ; N adieresis ; B 17 -11 489 606 ;
C -1 ; WX 444 ; N edieresis ; B 31 -11 451 606 ;
C -1 ; WX 444 ; N cacute ; B 30 -11 459 664 ;
C -1 ; WX 500 ; N nacute ; B 14 -9 477 664 ;
C -1 ; WX 500 ; N umacron ; B 42 -11 485 583 ;
C -1 ; WX 667 ; N Ncaron ; B -20 -15 727 873 ;
C -1 ; WX 333 ; N Iacute ; B -8 0 433 876 ;
C -1 ; WX 675 ; N plusminus ; B 86 0 590 506 ;
C -1 ; WX 275 ; N brokenbar ; B 105 -142 171 708 ;
C -1 ; WX 760 ; N registered ; B 41 -18 719 666 ;
C -1 ; WX 722 ; N Gbreve ; B 52 -18 722 862 ;
C -1 ; WX 333 ; N Idotaccent ; B -8 0 384 818 ;
C -1 ; WX 600 ; N summation ; B 15 -10 585 706 ;
C -1 ; WX 611 ; N Egrave ; B -1 0 634 876 ;
C -1 ; WX 389 ; N racute ; B 45 0 431 664 ;
C -1 ; WX 500 ; N omacron ; B 27 -11 495 583 ;
C -1 ; WX 556 ; N Zacute ; B -6 0 606 876 ;
C -1 ; WX 556 ; N Zcaron ; B -6 0 606 873 ;
C -1 ; WX 549 ; N greaterequal ; B 26 0 523 658 ;
C -1 ; WX 722 ; N Eth ; B -8 0 700 653 ;
C -1 ; WX 667 ; N Ccedilla ; B 66 -217 689 666 ;
C -1 ; WX 278 ; N lcommaaccent ; B 22 -217 279 683 ;
C -1 ; WX 300 ; N tcaron ; B 37 -11 407 681 ;
C -1 ; WX 444 ; N eogonek ; B 31 -169 412 441 ;
C -1 ; WX 722 ; N Uogonek ; B 102 -184 765 653 ;
C -1 ; WX 611 ; N Aacute ; B -51 0 564 876 ;
C -1 ; WX 611 ; N Adieresis ; B -51 0 564 818 ;
C -1 ; WX 444 ; N egrave ; B 31 -11 412 664 ;
C -1 ; WX 389 ; N zacute ; B -2 -81 431 664 ;
C -1 ; WX 278 ; N iogonek ; B 49 -169 264 654 ;
C -1 ; WX 722 ; N Oacute ; B 60 -18 699 876 ;
C -1 ; WX 500 ; N oacute ; B 27 -11 487 664 ;
C -1 ; WX 500 ; N amacron ; B 17 -11 495 583 ;
C -1 ; WX 389 ; N sacute ; B 16 -13 431 664 ;
C -1 ; WX 278 ; N idieresis ; B 49 -11 352 606 ;
C -1 ; WX 722 ; N Ocircumflex ; B 60 -18 699 873 ;
C -1 ; WX 722 ; N Ugrave ; B 102 -18 765 876 ;
C -1 ; WX 612 ; N Delta ; B 6 0 608 688 ;
C -1 ; WX 500 ; N thorn ; B -75 -205 469 683 ;
C -1 ; WX 300 ; N twosuperior ; B 33 271 324 676 ;
C -1 ; WX 722 ; N Odieresis ; B 60 -18 699 818 ;
C -1 ; WX 500 ; N mu ; B -30 -209 497 428 ;
C -1 ; WX 278 ; N igrave ; B 49 -11 284 664 ;
C -1 ; WX 500 ; N ohungarumlaut ; B 27 -11 590 664 ;
C -1 ; WX 611 ; N Eogonek ; B -1 -169 634 653 ;
C -1 ; WX 500 ; N dcroat ; B 15 -13 572 683 ;
C -1 ; WX 750 ; N threequarters ; B 23 -10 736 676 ;
C -1 ; WX 500 ; N Scedilla ; B 17 -217 508 667 ;
C -1 ; WX 300 ; N lcaron ; B 41 -11 407 683 ;
C -1 ; WX 667 ; N Kcommaaccent ; B 7 -217 722 653 ;
C -1 ; WX 556 ; N Lacute ; B -8 0 559 876 ;
C -1 ; WX 980 ; N trademark ; B 30 247 957 653 ;
C -1 ; WX 444 ; N edotaccent ; B 31 -11 412 606 ;
C -1 ; WX 333 ; N Igrave ; B -8 0 384 876 ;
C -1 ; WX 333 ; N Imacron ; B -8 0 441 795 ;
C -1 ; WX 611 ; N Lcaron ; B -8 0 586 653 ;
C -1 ; WX 750 ; N onehalf ; B 34 -10 749 676 ;
C -1 ; WX 549 ; N lessequal ; B 26 0 523 658 ;
C -1 ; WX 500 ; N ocircumflex ; B 27 -11 468 661 ;
C -1 ; WX 500 ; N ntilde ; B 14 -9 476 624 ;
C -1 ; WX 722 ; N Uhungarumlaut ; B 102 -18 765 876 ;
C -1 ; WX 611 ; N Eacute ; B -1 0 634 876 ;
C -1 ; WX 444 ; N emacron ; B 31 -11 457 583 ;
C -1 ; WX 500 ; N gbreve ; B 8 -206 487 650 ;
C -1 ; WX 750 ; N onequarter ; B 33 -10 736 676 ;
C -1 ; WX 500 ; N Scaron ; B 17 -18 520 873 ;
C -1 ; WX 500 ; N Scommaaccent ; B 17 -217 508 667 ;
C -1 ; WX 722 ; N Ohungarumlaut ; B 60 -18 699 876 ;
C -1 ; WX 400 ; N degree ; B 101 390 387 676 ;
C -1 ; WX 500 ; N ograve ; B 27 -11 468 664 ;
C -1 ; WX 667 ; N Ccaron ; B 66 -18 689 873 ;
C -1 ; WX 500 ; N ugrave ; B 42 -11 475 664 ;
C -1 ; WX 453 ; N radical ; B 2 -60 452 768 ;
C -1 ; WX 722 ; N Dcaron ; B -8 0 700 873 ;
C -1 ; WX 389 ; N rcommaaccent ; B -3 -217 412 441 ;
C -1 ; WX 667 ; N Ntilde ; B -20 -15 727 836 ;
C -1 ; WX 500 ; N otilde ; B 27 -11 496 624 ;
C -1 ; WX 611 ; N Rcommaaccent ; B -13 -187 588 653 ;
C -1 ; WX 556 ; N Lcommaaccent ; B -8 -217 559 653 ;
C -1 ; WX 611 ; N Atilde ; B -51 0 566 836 ;
C -1 ; WX 611 ; N Aogonek ; B -51 -169 566 668 ;
C -1 ; WX 611 ; N Aring ; B -51 0 564 883 ;
C -1 ; WX 722 ; N Otilde ; B 60 -18 699 836 ;
C -1 ; WX 389 ; N zdotaccent ; B -2 -81 380 606 ;
C -1 ; WX 611 ; N Ecaron ; B -1 0 634 873 ;
C -1 ; WX 333 ; N Iogonek ; B -8 -169 384 653 ;
C -1 ; WX 444 ; N kcommaaccent ; B 14 -187 461 683 ;
C -1 ; WX 675 ; N minus ; B 86 220 590 286 ;
C -1 ; WX 333 ; N Icircumflex ; B -8 0 425 873 ;
C -1 ; WX 500 ; N ncaron ; B 14 -9 510 661 ;
C -1 ; WX 278 ; N tcommaaccent ; B 2 -217 296 546 ;
C -1 ; WX 675 ; N logicalnot ; B 86 108 590 386 ;
C -1 ; WX 500 ; N odieresis ; B 27 -11 489 606 ;
C -1 ; WX 500 ; N udieresis ; B 42 -11 479 606 ;
C -1 ; WX 549 ; N notequal ; B 12 -29 537 541 ;
C -1 ; WX 500 ; N gcommaaccent ; B 8 -206 472 706 ;
C -1 ; WX 500 ; N eth ; B 27 -11 482 683 ;
C -1 ; WX 389 ; N zcaron ; B -2 -81 434 661 ;
C -1 ; WX 500 ; N ncommaaccent ; B 14 -187 474 441 ;
C -1 ; WX 300 ; N onesuperior ; B 43 271 284 676 ;
C -1 ; WX 278 ; N imacron ; B 46 -11 311 583 ;
C -1 ; WX 500 ; N Euro ; B 0 0 0 0 ;
EndCharMetrics
StartKernData
StartKernPairs 2321
KPX A C -30
KPX A Cacute -30
KPX A Ccaron -30
KPX A Ccedilla -30
KPX A G -35
KPX A Gbreve -35
KPX A Gcommaaccent -35
KPX A O -40
KPX A Oacute -40
KPX A Ocircumflex -40
KPX A Odieresis -40
KPX A Ograve -40
KPX A Ohungarumlaut -40
KPX A Omacron -40
KPX A Oslash -40
KPX A Otilde -40
KPX A Q -40
KPX A T -37
KPX A Tcaron -37
KPX A Tcommaaccent -37
KPX A U -50
KPX A Uacute -50
KPX A Ucircumflex -50
KPX A Udieresis -50
KPX A Ugrave -50
KPX A Uhungarumlaut -50
KPX A Umacron -50
KPX A Uogonek -50
KPX A Uring -50
KPX A V -105
KPX A W -95
KPX A Y -55
KPX A Yacute -55
KPX A Ydieresis -55
KPX A quoteright -37
KPX A u -20
KPX A uacute -20
KPX A ucircumflex -20
KPX A udieresis -20
KPX A ugrave -20
KPX A uhungarumlaut -20
KPX A umacron -20
KPX A uogonek -20
KPX A uring -20
KPX A v -55
KPX A w -55
KPX A y -55
KPX A yacute -55
KPX A ydieresis -55
KPX Aacute C -30
KPX Aacute Cacute -30
KPX Aacute Ccaron -30
KPX Aacute Ccedilla -30
KPX Aacute G -35
KPX Aacute Gbreve -35
KPX Aacute Gcommaaccent -35
KPX Aacute O -40
KPX Aacute Oacute -40
KPX Aacute Ocircumflex -40
KPX Aacute Odieresis -40
KPX Aacute Ograve -40
KPX Aacute Ohungarumlaut -40
KPX Aacute Omacron -40
KPX Aacute Oslash -40
KPX Aacute Otilde -40
KPX Aacute Q -40
KPX Aacute T -37
KPX Aacute Tcaron -37
KPX Aacute Tcommaaccent -37
KPX Aacute U -50
KPX Aacute Uacute -50
KPX Aacute Ucircumflex -50
KPX Aacute Udieresis -50
KPX Aacute Ugrave -50
KPX Aacute Uhungarumlaut -50
KPX Aacute Umacron -50
KPX Aacute Uogonek -50
KPX Aacute Uring -50
KPX Aacute V -105
KPX Aacute W -95
KPX Aacute Y -55
KPX Aacute Yacute -55
KPX Aacute Ydieresis -55
KPX Aacute quoteright -37
KPX Aacute u -20
KPX Aacute uacute -20
KPX Aacute ucircumflex -20
KPX Aacute udieresis -20
KPX Aacute ugrave -20
KPX Aacute uhungarumlaut -20
KPX Aacute umacron -20
KPX Aacute uogonek -20
KPX Aacute uring -20
KPX Aacute v -55
KPX Aacute w -55
KPX Aacute y -55
KPX Aacute yacute -55
KPX Aacute ydieresis -55
KPX Abreve C -30
KPX Abreve Cacute -30
KPX Abreve Ccaron -30
KPX Abreve Ccedilla -30
KPX Abreve G -35
KPX Abreve Gbreve -35
KPX Abreve Gcommaaccent -35
KPX Abreve O -40
KPX Abreve Oacute -40
KPX Abreve Ocircumflex -40
KPX Abreve Odieresis -40
KPX Abreve Ograve -40
KPX Abreve Ohungarumlaut -40
KPX Abreve Omacron -40
KPX Abreve Oslash -40
KPX Abreve Otilde -40
KPX Abreve Q -40
KPX Abreve T -37
KPX Abreve Tcaron -37
KPX Abreve Tcommaaccent -37
KPX Abreve U -50
KPX Abreve Uacute -50
KPX Abreve Ucircumflex -50
KPX Abreve Udieresis -50
KPX Abreve Ugrave -50
KPX Abreve Uhungarumlaut -50
KPX Abreve Umacron -50
KPX Abreve Uogonek -50
KPX Abreve Uring -50
KPX Abreve V -105
KPX Abreve W -95
KPX Abreve Y -55
KPX Abreve Yacute -55
KPX Abreve Ydieresis -55
KPX Abreve quoteright -37
KPX Abreve u -20
KPX Abreve uacute -20
KPX Abreve ucircumflex -20
KPX Abreve udieresis -20
KPX Abreve ugrave -20
KPX Abreve uhungarumlaut -20
KPX Abreve umacron -20
KPX Abreve uogonek -20
KPX Abreve uring -20
KPX Abreve v -55
KPX Abreve w -55
KPX Abreve y -55
KPX Abreve yacute -55
KPX Abreve ydieresis -55
KPX Acircumflex C -30
KPX Acircumflex Cacute -30
KPX Acircumflex Ccaron -30
KPX Acircumflex Ccedilla -30
KPX Acircumflex G -35
KPX Acircumflex Gbreve -35
KPX Acircumflex Gcommaaccent -35
KPX Acircumflex O -40
KPX Acircumflex Oacute -40
KPX Acircumflex Ocircumflex -40
KPX Acircumflex Odieresis -40
KPX Acircumflex Ograve -40
KPX Acircumflex Ohungarumlaut -40
KPX Acircumflex Omacron -40
KPX Acircumflex Oslash -40
KPX Acircumflex Otilde -40
KPX Acircumflex Q -40
KPX Acircumflex T -37
KPX Acircumflex Tcaron -37
KPX Acircumflex Tcommaaccent -37
KPX Acircumflex U -50
KPX Acircumflex Uacute -50
KPX Acircumflex Ucircumflex -50
KPX Acircumflex Udieresis -50
KPX Acircumflex Ugrave -50
KPX Acircumflex Uhungarumlaut -50
KPX Acircumflex Umacron -50
KPX Acircumflex Uogonek -50
KPX Acircumflex Uring -50
KPX Acircumflex V -105
KPX Acircumflex W -95
KPX Acircumflex Y -55
KPX Acircumflex Yacute -55
KPX Acircumflex Ydieresis -55
KPX Acircumflex quoteright -37
KPX Acircumflex u -20
KPX Acircumflex uacute -20
KPX Acircumflex ucircumflex -20
KPX Acircumflex udieresis -20
KPX Acircumflex ugrave -20
KPX Acircumflex uhungarumlaut -20
KPX Acircumflex umacron -20
KPX Acircumflex uogonek -20
KPX Acircumflex uring -20
KPX Acircumflex v -55
KPX Acircumflex w -55
KPX Acircumflex y -55
KPX Acircumflex yacute -55
KPX Acircumflex ydieresis -55
KPX Adieresis C -30
KPX Adieresis Cacute -30
KPX Adieresis Ccaron -30
KPX Adieresis Ccedilla -30
KPX Adieresis G -35
KPX Adieresis Gbreve -35
KPX Adieresis Gcommaaccent -35
KPX Adieresis O -40
KPX Adieresis Oacute -40
KPX Adieresis Ocircumflex -40
KPX Adieresis Odieresis -40
KPX Adieresis Ograve -40
KPX Adieresis Ohungarumlaut -40
KPX Adieresis Omacron -40
KPX Adieresis Oslash -40
KPX Adieresis Otilde -40
KPX Adieresis Q -40
KPX Adieresis T -37
KPX Adieresis Tcaron -37
KPX Adieresis Tcommaaccent -37
KPX Adieresis U -50
KPX Adieresis Uacute -50
KPX Adieresis Ucircumflex -50
KPX Adieresis Udieresis -50
KPX Adieresis Ugrave -50
KPX Adieresis Uhungarumlaut -50
KPX Adieresis Umacron -50
KPX Adieresis Uogonek -50
KPX Adieresis Uring -50
KPX Adieresis V -105
KPX Adieresis W -95
KPX Adieresis Y -55
KPX Adieresis Yacute -55
KPX Adieresis Ydieresis -55
KPX Adieresis quoteright -37
KPX Adieresis u -20
KPX Adieresis uacute -20
KPX Adieresis ucircumflex -20
KPX Adieresis udieresis -20
KPX Adieresis ugrave -20
KPX Adieresis uhungarumlaut -20
KPX Adieresis umacron -20
KPX Adieresis uogonek -20
KPX Adieresis uring -20
KPX Adieresis v -55
KPX Adieresis w -55
KPX Adieresis y -55
KPX Adieresis yacute -55
KPX Adieresis ydieresis -55
KPX Agrave C -30
KPX Agrave Cacute -30
KPX Agrave Ccaron -30
KPX Agrave Ccedilla -30
KPX Agrave G -35
KPX Agrave Gbreve -35
KPX Agrave Gcommaaccent -35
KPX Agrave O -40
KPX Agrave Oacute -40
KPX Agrave Ocircumflex -40
KPX Agrave Odieresis -40
KPX Agrave Ograve -40
KPX Agrave Ohungarumlaut -40
KPX Agrave Omacron -40
KPX Agrave Oslash -40
KPX Agrave Otilde -40
KPX Agrave Q -40
KPX Agrave T -37
KPX Agrave Tcaron -37
KPX Agrave Tcommaaccent -37
KPX Agrave U -50
KPX Agrave Uacute -50
KPX Agrave Ucircumflex -50
KPX Agrave Udieresis -50
KPX Agrave Ugrave -50
KPX Agrave Uhungarumlaut -50
KPX Agrave Umacron -50
KPX Agrave Uogonek -50
KPX Agrave Uring -50
KPX Agrave V -105
KPX Agrave W -95
KPX Agrave Y -55
KPX Agrave Yacute -55
KPX Agrave Ydieresis -55
KPX Agrave quoteright -37
KPX Agrave u -20
KPX Agrave uacute -20
KPX Agrave ucircumflex -20
KPX Agrave udieresis -20
KPX Agrave ugrave -20
KPX Agrave uhungarumlaut -20
KPX Agrave umacron -20
KPX Agrave uogonek -20
KPX Agrave uring -20
KPX Agrave v -55
KPX Agrave w -55
KPX Agrave y -55
KPX Agrave yacute -55
KPX Agrave ydieresis -55
KPX Amacron C -30
KPX Amacron Cacute -30
KPX Amacron Ccaron -30
KPX Amacron Ccedilla -30
KPX Amacron G -35
KPX Amacron Gbreve -35
KPX Amacron Gcommaaccent -35
KPX Amacron O -40
KPX Amacron Oacute -40
KPX Amacron Ocircumflex -40
KPX Amacron Odieresis -40
KPX Amacron Ograve -40
KPX Amacron Ohungarumlaut -40
KPX Amacron Omacron -40
KPX Amacron Oslash -40
KPX Amacron Otilde -40
KPX Amacron Q -40
KPX Amacron T -37
KPX Amacron Tcaron -37
KPX Amacron Tcommaaccent -37
KPX Amacron U -50
KPX Amacron Uacute -50
KPX Amacron Ucircumflex -50
KPX Amacron Udieresis -50
KPX Amacron Ugrave -50
KPX Amacron Uhungarumlaut -50
KPX Amacron Umacron -50
KPX Amacron Uogonek -50
KPX Amacron Uring -50
KPX Amacron V -105
KPX Amacron W -95
KPX Amacron Y -55
KPX Amacron Yacute -55
KPX Amacron Ydieresis -55
KPX Amacron quoteright -37
KPX Amacron u -20
KPX Amacron uacute -20
KPX Amacron ucircumflex -20
KPX Amacron udieresis -20
KPX Amacron ugrave -20
KPX Amacron uhungarumlaut -20
KPX Amacron umacron -20
KPX Amacron uogonek -20
KPX Amacron uring -20
KPX Amacron v -55
KPX Amacron w -55
KPX Amacron y -55
KPX Amacron yacute -55
KPX Amacron ydieresis -55
KPX Aogonek C -30
KPX Aogonek Cacute -30
KPX Aogonek Ccaron -30
KPX Aogonek Ccedilla -30
KPX Aogonek G -35
KPX Aogonek Gbreve -35
KPX Aogonek Gcommaaccent -35
KPX Aogonek O -40
KPX Aogonek Oacute -40
KPX Aogonek Ocircumflex -40
KPX Aogonek Odieresis -40
KPX Aogonek Ograve -40
KPX Aogonek Ohungarumlaut -40
KPX Aogonek Omacron -40
KPX Aogonek Oslash -40
KPX Aogonek Otilde -40
KPX Aogonek Q -40
KPX Aogonek T -37
KPX Aogonek Tcaron -37
KPX Aogonek Tcommaaccent -37
KPX Aogonek U -50
KPX Aogonek Uacute -50
KPX Aogonek Ucircumflex -50
KPX Aogonek Udieresis -50
KPX Aogonek Ugrave -50
KPX Aogonek Uhungarumlaut -50
KPX Aogonek Umacron -50
KPX Aogonek Uogonek -50
KPX Aogonek Uring -50
KPX Aogonek V -105
KPX Aogonek W -95
KPX Aogonek Y -55
KPX Aogonek Yacute -55
KPX Aogonek Ydieresis -55
KPX Aogonek quoteright -37
KPX Aogonek u -20
KPX Aogonek uacute -20
KPX Aogonek ucircumflex -20
KPX Aogonek udieresis -20
KPX Aogonek ugrave -20
KPX Aogonek uhungarumlaut -20
KPX Aogonek umacron -20
KPX Aogonek uogonek -20
KPX Aogonek uring -20
KPX Aogonek v -55
KPX Aogonek w -55
KPX Aogonek y -55
KPX Aogonek yacute -55
KPX Aogonek ydieresis -55
KPX Aring C -30
KPX Aring Cacute -30
KPX Aring Ccaron -30
KPX Aring Ccedilla -30
KPX Aring G -35
KPX Aring Gbreve -35
KPX Aring Gcommaaccent -35
KPX Aring O -40
KPX Aring Oacute -40
KPX Aring Ocircumflex -40
KPX Aring Odieresis -40
KPX Aring Ograve -40
KPX Aring Ohungarumlaut -40
KPX Aring Omacron -40
KPX Aring Oslash -40
KPX Aring Otilde -40
KPX Aring Q -40
KPX Aring T -37
KPX Aring Tcaron -37
KPX Aring Tcommaaccent -37
KPX Aring U -50
KPX Aring Uacute -50
KPX Aring Ucircumflex -50
KPX Aring Udieresis -50
KPX Aring Ugrave -50
KPX Aring Uhungarumlaut -50
KPX Aring Umacron -50
KPX Aring Uogonek -50
KPX Aring Uring -50
KPX Aring V -105
KPX Aring W -95
KPX Aring Y -55
KPX Aring Yacute -55
KPX Aring Ydieresis -55
KPX Aring quoteright -37
KPX Aring u -20
KPX Aring uacute -20
KPX Aring ucircumflex -20
KPX Aring udieresis -20
KPX Aring ugrave -20
KPX Aring uhungarumlaut -20
KPX Aring umacron -20
KPX Aring uogonek -20
KPX Aring uring -20
KPX Aring v -55
KPX Aring w -55
KPX Aring y -55
KPX Aring yacute -55
KPX Aring ydieresis -55
KPX Atilde C -30
KPX Atilde Cacute -30
KPX Atilde Ccaron -30
KPX Atilde Ccedilla -30
KPX Atilde G -35
KPX Atilde Gbreve -35
KPX Atilde Gcommaaccent -35
KPX Atilde O -40
KPX Atilde Oacute -40
KPX Atilde Ocircumflex -40
KPX Atilde Odieresis -40
KPX Atilde Ograve -40
KPX Atilde Ohungarumlaut -40
KPX Atilde Omacron -40
KPX Atilde Oslash -40
KPX Atilde Otilde -40
KPX Atilde Q -40
KPX Atilde T -37
KPX Atilde Tcaron -37
KPX Atilde Tcommaaccent -37
KPX Atilde U -50
KPX Atilde Uacute -50
KPX Atilde Ucircumflex -50
KPX Atilde Udieresis -50
KPX Atilde Ugrave -50
KPX Atilde Uhungarumlaut -50
KPX Atilde Umacron -50
KPX Atilde Uogonek -50
KPX Atilde Uring -50
KPX Atilde V -105
KPX Atilde W -95
KPX Atilde Y -55
KPX Atilde Yacute -55
KPX Atilde Ydieresis -55
KPX Atilde quoteright -37
KPX Atilde u -20
KPX Atilde uacute -20
KPX Atilde ucircumflex -20
KPX Atilde udieresis -20
KPX Atilde ugrave -20
KPX Atilde uhungarumlaut -20
KPX Atilde umacron -20
KPX Atilde uogonek -20
KPX Atilde uring -20
KPX Atilde v -55
KPX Atilde w -55
KPX Atilde y -55
KPX Atilde yacute -55
KPX Atilde ydieresis -55
KPX B A -25
KPX B Aacute -25
KPX B Abreve -25
KPX B Acircumflex -25
KPX B Adieresis -25
KPX B Agrave -25
KPX B Amacron -25
KPX B Aogonek -25
KPX B Aring -25
KPX B Atilde -25
KPX B U -10
KPX B Uacute -10
KPX B Ucircumflex -10
KPX B Udieresis -10
KPX B Ugrave -10
KPX B Uhungarumlaut -10
KPX B Umacron -10
KPX B Uogonek -10
KPX B Uring -10
KPX D A -35
KPX D Aacute -35
KPX D Abreve -35
KPX D Acircumflex -35
KPX D Adieresis -35
KPX D Agrave -35
KPX D Amacron -35
KPX D Aogonek -35
KPX D Aring -35
KPX D Atilde -35
KPX D V -40
KPX D W -40
KPX D Y -40
KPX D Yacute -40
KPX D Ydieresis -40
KPX Dcaron A -35
KPX Dcaron Aacute -35
KPX Dcaron Abreve -35
KPX Dcaron Acircumflex -35
KPX Dcaron Adieresis -35
KPX Dcaron Agrave -35
KPX Dcaron Amacron -35
KPX Dcaron Aogonek -35
KPX Dcaron Aring -35
KPX Dcaron Atilde -35
KPX Dcaron V -40
KPX Dcaron W -40
KPX Dcaron Y -40
KPX Dcaron Yacute -40
KPX Dcaron Ydieresis -40
KPX Dcroat A -35
KPX Dcroat Aacute -35
KPX Dcroat Abreve -35
KPX Dcroat Acircumflex -35
KPX Dcroat Adieresis -35
KPX Dcroat Agrave -35
KPX Dcroat Amacron -35
KPX Dcroat Aogonek -35
KPX Dcroat Aring -35
KPX Dcroat Atilde -35
KPX Dcroat V -40
KPX Dcroat W -40
KPX Dcroat Y -40
KPX Dcroat Yacute -40
KPX Dcroat Ydieresis -40
KPX F A -115
KPX F Aacute -115
KPX F Abreve -115
KPX F Acircumflex -115
KPX F Adieresis -115
KPX F Agrave -115
KPX F Amacron -115
KPX F Aogonek -115
KPX F Aring -115
KPX F Atilde -115
KPX F a -75
KPX F aacute -75
KPX F abreve -75
KPX F acircumflex -75
KPX F adieresis -75
KPX F agrave -75
KPX F amacron -75
KPX F aogonek -75
KPX F aring -75
KPX F atilde -75
KPX F comma -135
KPX F e -75
KPX F eacute -75
KPX F ecaron -75
KPX F ecircumflex -75
KPX F edieresis -75
KPX F edotaccent -75
KPX F egrave -75
KPX F emacron -75
KPX F eogonek -75
KPX F i -45
KPX F iacute -45
KPX F icircumflex -45
KPX F idieresis -45
KPX F igrave -45
KPX F imacron -45
KPX F iogonek -45
KPX F o -105
KPX F oacute -105
KPX F ocircumflex -105
KPX F odieresis -105
KPX F ograve -105
KPX F ohungarumlaut -105
KPX F omacron -105
KPX F oslash -105
KPX F otilde -105
KPX F period -135
KPX F r -55
KPX F racute -55
KPX F rcaron -55
KPX F rcommaaccent -55
KPX J A -40
KPX J Aacute -40
KPX J Abreve -40
KPX J Acircumflex -40
KPX J Adieresis -40
KPX J Agrave -40
KPX J Amacron -40
KPX J Aogonek -40
KPX J Aring -40
KPX J Atilde -40
KPX J a -35
KPX J aacute -35
KPX J abreve -35
KPX J acircumflex -35
KPX J adieresis -35
KPX J agrave -35
KPX J amacron -35
KPX J aogonek -35
KPX J aring -35
KPX J atilde -35
KPX J comma -25
KPX J e -25
KPX J eacute -25
KPX J ecaron -25
KPX J ecircumflex -25
KPX J edieresis -25
KPX J edotaccent -25
KPX J egrave -25
KPX J emacron -25
KPX J eogonek -25
KPX J o -25
KPX J oacute -25
KPX J ocircumflex -25
KPX J odieresis -25
KPX J ograve -25
KPX J ohungarumlaut -25
KPX J omacron -25
KPX J oslash -25
KPX J otilde -25
KPX J period -25
KPX J u -35
KPX J uacute -35
KPX J ucircumflex -35
KPX J udieresis -35
KPX J ugrave -35
KPX J uhungarumlaut -35
KPX J umacron -35
KPX J uogonek -35
KPX J uring -35
KPX K O -50
KPX K Oacute -50
KPX K Ocircumflex -50
KPX K Odieresis -50
KPX K Ograve -50
KPX K Ohungarumlaut -50
KPX K Omacron -50
KPX K Oslash -50
KPX K Otilde -50
KPX K e -35
KPX K eacute -35
KPX K ecaron -35
KPX K ecircumflex -35
KPX K edieresis -35
KPX K edotaccent -35
KPX K egrave -35
KPX K emacron -35
KPX K eogonek -35
KPX K o -40
KPX K oacute -40
KPX K ocircumflex -40
KPX K odieresis -40
KPX K ograve -40
KPX K ohungarumlaut -40
KPX K omacron -40
KPX K oslash -40
KPX K otilde -40
KPX K u -40
KPX K uacute -40
KPX K ucircumflex -40
KPX K udieresis -40
KPX K ugrave -40
KPX K uhungarumlaut -40
KPX K umacron -40
KPX K uogonek -40
KPX K uring -40
KPX K y -40
KPX K yacute -40
KPX K ydieresis -40
KPX Kcommaaccent O -50
KPX Kcommaaccent Oacute -50
KPX Kcommaaccent Ocircumflex -50
KPX Kcommaaccent Odieresis -50
KPX Kcommaaccent Ograve -50
KPX Kcommaaccent Ohungarumlaut -50
KPX Kcommaaccent Omacron -50
KPX Kcommaaccent Oslash -50
KPX Kcommaaccent Otilde -50
KPX Kcommaaccent e -35
KPX Kcommaaccent eacute -35
KPX Kcommaaccent ecaron -35
KPX Kcommaaccent ecircumflex -35
KPX Kcommaaccent edieresis -35
KPX Kcommaaccent edotaccent -35
KPX Kcommaaccent egrave -35
KPX Kcommaaccent emacron -35
KPX Kcommaaccent eogonek -35
KPX Kcommaaccent o -40
KPX Kcommaaccent oacute -40
KPX Kcommaaccent ocircumflex -40
KPX Kcommaaccent odieresis -40
KPX Kcommaaccent ograve -40
KPX Kcommaaccent ohungarumlaut -40
KPX Kcommaaccent omacron -40
KPX Kcommaaccent oslash -40
KPX Kcommaaccent otilde -40
KPX Kcommaaccent u -40
KPX Kcommaaccent uacute -40
KPX Kcommaaccent ucircumflex -40
KPX Kcommaaccent udieresis -40
KPX Kcommaaccent ugrave -40
KPX Kcommaaccent uhungarumlaut -40
KPX Kcommaaccent umacron -40
KPX Kcommaaccent uogonek -40
KPX Kcommaaccent uring -40
KPX Kcommaaccent y -40
KPX Kcommaaccent yacute -40
KPX Kcommaaccent ydieresis -40
KPX L T -20
KPX L Tcaron -20
KPX L Tcommaaccent -20
KPX L V -55
KPX L W -55
KPX L Y -20
KPX L Yacute -20
KPX L Ydieresis -20
KPX L quoteright -37
KPX L y -30
KPX L yacute -30
KPX L ydieresis -30
KPX Lacute T -20
KPX Lacute Tcaron -20
KPX Lacute Tcommaaccent -20
KPX Lacute V -55
KPX Lacute W -55
KPX Lacute Y -20
KPX Lacute Yacute -20
KPX Lacute Ydieresis -20
KPX Lacute quoteright -37
KPX Lacute y -30
KPX Lacute yacute -30
KPX Lacute ydieresis -30
KPX Lcommaaccent T -20
KPX Lcommaaccent Tcaron -20
KPX Lcommaaccent Tcommaaccent -20
KPX Lcommaaccent V -55
KPX Lcommaaccent W -55
KPX Lcommaaccent Y -20
KPX Lcommaaccent Yacute -20
KPX Lcommaaccent Ydieresis -20
KPX Lcommaaccent quoteright -37
KPX Lcommaaccent y -30
KPX Lcommaaccent yacute -30
KPX Lcommaaccent ydieresis -30
KPX Lslash T -20
KPX Lslash Tcaron -20
KPX Lslash Tcommaaccent -20
KPX Lslash V -55
KPX Lslash W -55
KPX Lslash Y -20
KPX Lslash Yacute -20
KPX Lslash Ydieresis -20
KPX Lslash quoteright -37
KPX Lslash y -30
KPX Lslash yacute -30
KPX Lslash ydieresis -30
KPX N A -27
KPX N Aacute -27
KPX N Abreve -27
KPX N Acircumflex -27
KPX N Adieresis -27
KPX N Agrave -27
KPX N Amacron -27
KPX N Aogonek -27
KPX N Aring -27
KPX N Atilde -27
KPX Nacute A -27
KPX Nacute Aacute -27
KPX Nacute Abreve -27
KPX Nacute Acircumflex -27
KPX Nacute Adieresis -27
KPX Nacute Agrave -27
KPX Nacute Amacron -27
KPX Nacute Aogonek -27
KPX Nacute Aring -27
KPX Nacute Atilde -27
KPX Ncaron A -27
KPX Ncaron Aacute -27
KPX Ncaron Abreve -27
KPX Ncaron Acircumflex -27
KPX Ncaron Adieresis -27
KPX Ncaron Agrave -27
KPX Ncaron Amacron -27
KPX Ncaron Aogonek -27
KPX Ncaron Aring -27
KPX Ncaron Atilde -27
KPX Ncommaaccent A -27
KPX Ncommaaccent Aacute -27
KPX Ncommaaccent Abreve -27
KPX Ncommaaccent Acircumflex -27
KPX Ncommaaccent Adieresis -27
KPX Ncommaaccent Agrave -27
KPX Ncommaaccent Amacron -27
KPX Ncommaaccent Aogonek -27
KPX Ncommaaccent Aring -27
KPX Ncommaaccent Atilde -27
KPX Ntilde A -27
KPX Ntilde Aacute -27
KPX Ntilde Abreve -27
KPX Ntilde Acircumflex -27
KPX Ntilde Adieresis -27
KPX Ntilde Agrave -27
KPX Ntilde Amacron -27
KPX Ntilde Aogonek -27
KPX Ntilde Aring -27
KPX Ntilde Atilde -27
KPX O A -55
KPX O Aacute -55
KPX O Abreve -55
KPX O Acircumflex -55
KPX O Adieresis -55
KPX O Agrave -55
KPX O Amacron -55
KPX O Aogonek -55
KPX O Aring -55
KPX O Atilde -55
KPX O T -40
KPX O Tcaron -40
KPX O Tcommaaccent -40
KPX O V -50
KPX O W -50
KPX O X -40
KPX O Y -50
KPX O Yacute -50
KPX O Ydieresis -50
KPX Oacute A -55
KPX Oacute Aacute -55
KPX Oacute Abreve -55
KPX Oacute Acircumflex -55
KPX Oacute Adieresis -55
KPX Oacute Agrave -55
KPX Oacute Amacron -55
KPX Oacute Aogonek -55
KPX Oacute Aring -55
KPX Oacute Atilde -55
KPX Oacute T -40
KPX Oacute Tcaron -40
KPX Oacute Tcommaaccent -40
KPX Oacute V -50
KPX Oacute W -50
KPX Oacute X -40
KPX Oacute Y -50
KPX Oacute Yacute -50
KPX Oacute Ydieresis -50
KPX Ocircumflex A -55
KPX Ocircumflex Aacute -55
KPX Ocircumflex Abreve -55
KPX Ocircumflex Acircumflex -55
KPX Ocircumflex Adieresis -55
KPX Ocircumflex Agrave -55
KPX Ocircumflex Amacron -55
KPX Ocircumflex Aogonek -55
KPX Ocircumflex Aring -55
KPX Ocircumflex Atilde -55
KPX Ocircumflex T -40
KPX Ocircumflex Tcaron -40
KPX Ocircumflex Tcommaaccent -40
KPX Ocircumflex V -50
KPX Ocircumflex W -50
KPX Ocircumflex X -40
KPX Ocircumflex Y -50
KPX Ocircumflex Yacute -50
KPX Ocircumflex Ydieresis -50
KPX Odieresis A -55
KPX Odieresis Aacute -55
KPX Odieresis Abreve -55
KPX Odieresis Acircumflex -55
KPX Odieresis Adieresis -55
KPX Odieresis Agrave -55
KPX Odieresis Amacron -55
KPX Odieresis Aogonek -55
KPX Odieresis Aring -55
KPX Odieresis Atilde -55
KPX Odieresis T -40
KPX Odieresis Tcaron -40
KPX Odieresis Tcommaaccent -40
KPX Odieresis V -50
KPX Odieresis W -50
KPX Odieresis X -40
KPX Odieresis Y -50
KPX Odieresis Yacute -50
KPX Odieresis Ydieresis -50
KPX Ograve A -55
KPX Ograve Aacute -55
KPX Ograve Abreve -55
KPX Ograve Acircumflex -55
KPX Ograve Adieresis -55
KPX Ograve Agrave -55
KPX Ograve Amacron -55
KPX Ograve Aogonek -55
KPX Ograve Aring -55
KPX Ograve Atilde -55
KPX Ograve T -40
KPX Ograve Tcaron -40
KPX Ograve Tcommaaccent -40
KPX Ograve V -50
KPX Ograve W -50
KPX Ograve X -40
KPX Ograve Y -50
KPX Ograve Yacute -50
KPX Ograve Ydieresis -50
KPX Ohungarumlaut A -55
KPX Ohungarumlaut Aacute -55
KPX Ohungarumlaut Abreve -55
KPX Ohungarumlaut Acircumflex -55
KPX Ohungarumlaut Adieresis -55
KPX Ohungarumlaut Agrave -55
KPX Ohungarumlaut Amacron -55
KPX Ohungarumlaut Aogonek -55
KPX Ohungarumlaut Aring -55
KPX Ohungarumlaut Atilde -55
KPX Ohungarumlaut T -40
KPX Ohungarumlaut Tcaron -40
KPX Ohungarumlaut Tcommaaccent -40
KPX Ohungarumlaut V -50
KPX Ohungarumlaut W -50
KPX Ohungarumlaut X -40
KPX Ohungarumlaut Y -50
KPX Ohungarumlaut Yacute -50
KPX Ohungarumlaut Ydieresis -50
KPX Omacron A -55
KPX Omacron Aacute -55
KPX Omacron Abreve -55
KPX Omacron Acircumflex -55
KPX Omacron Adieresis -55
KPX Omacron Agrave -55
KPX Omacron Amacron -55
KPX Omacron Aogonek -55
KPX Omacron Aring -55
KPX Omacron Atilde -55
KPX Omacron T -40
KPX Omacron Tcaron -40
KPX Omacron Tcommaaccent -40
KPX Omacron V -50
KPX Omacron W -50
KPX Omacron X -40
KPX Omacron Y -50
KPX Omacron Yacute -50
KPX Omacron Ydieresis -50
KPX Oslash A -55
KPX Oslash Aacute -55
KPX Oslash Abreve -55
KPX Oslash Acircumflex -55
KPX Oslash Adieresis -55
KPX Oslash Agrave -55
KPX Oslash Amacron -55
KPX Oslash Aogonek -55
KPX Oslash Aring -55
KPX Oslash Atilde -55
KPX Oslash T -40
KPX Oslash Tcaron -40
KPX Oslash Tcommaaccent -40
KPX Oslash V -50
KPX Oslash W -50
KPX Oslash X -40
KPX Oslash Y -50
KPX Oslash Yacute -50
KPX Oslash Ydieresis -50
KPX Otilde A -55
KPX Otilde Aacute -55
KPX Otilde Abreve -55
KPX Otilde Acircumflex -55
KPX Otilde Adieresis -55
KPX Otilde Agrave -55
KPX Otilde Amacron -55
KPX Otilde Aogonek -55
KPX Otilde Aring -55
KPX Otilde Atilde -55
KPX Otilde T -40
KPX Otilde Tcaron -40
KPX Otilde Tcommaaccent -40
KPX Otilde V -50
KPX Otilde W -50
KPX Otilde X -40
KPX Otilde Y -50
KPX Otilde Yacute -50
KPX Otilde Ydieresis -50
KPX P A -90
KPX P Aacute -90
KPX P Abreve -90
KPX P Acircumflex -90
KPX P Adieresis -90
KPX P Agrave -90
KPX P Amacron -90
KPX P Aogonek -90
KPX P Aring -90
KPX P Atilde -90
KPX P a -80
KPX P aacute -80
KPX P abreve -80
KPX P acircumflex -80
KPX P adieresis -80
KPX P agrave -80
KPX P amacron -80
KPX P aogonek -80
KPX P aring -80
KPX P atilde -80
KPX P comma -135
KPX P e -80
KPX P eacute -80
KPX P ecaron -80
KPX P ecircumflex -80
KPX P edieresis -80
KPX P edotaccent -80
KPX P egrave -80
KPX P emacron -80
KPX P eogonek -80
KPX P o -80
KPX P oacute -80
KPX P ocircumflex -80
KPX P odieresis -80
KPX P ograve -80
KPX P ohungarumlaut -80
KPX P omacron -80
KPX P oslash -80
KPX P otilde -80
KPX P period -135
KPX Q U -10
KPX Q Uacute -10
KPX Q Ucircumflex -10
KPX Q Udieresis -10
KPX Q Ugrave -10
KPX Q Uhungarumlaut -10
KPX Q Umacron -10
KPX Q Uogonek -10
KPX Q Uring -10
KPX R O -40
KPX R Oacute -40
KPX R Ocircumflex -40
KPX R Odieresis -40
KPX R Ograve -40
KPX R Ohungarumlaut -40
KPX R Omacron -40
KPX R Oslash -40
KPX R Otilde -40
KPX R U -40
KPX R Uacute -40
KPX R Ucircumflex -40
KPX R Udieresis -40
KPX R Ugrave -40
KPX R Uhungarumlaut -40
KPX R Umacron -40
KPX R Uogonek -40
KPX R Uring -40
KPX R V -18
KPX R W -18
KPX R Y -18
KPX R Yacute -18
KPX R Ydieresis -18
KPX Racute O -40
KPX Racute Oacute -40
KPX Racute Ocircumflex -40
KPX Racute Odieresis -40
KPX Racute Ograve -40
KPX Racute Ohungarumlaut -40
KPX Racute Omacron -40
KPX Racute Oslash -40
KPX Racute Otilde -40
KPX Racute U -40
KPX Racute Uacute -40
KPX Racute Ucircumflex -40
KPX Racute Udieresis -40
KPX Racute Ugrave -40
KPX Racute Uhungarumlaut -40
KPX Racute Umacron -40
KPX Racute Uogonek -40
KPX Racute Uring -40
KPX Racute V -18
KPX Racute W -18
KPX Racute Y -18
KPX Racute Yacute -18
KPX Racute Ydieresis -18
KPX Rcaron O -40
KPX Rcaron Oacute -40
KPX Rcaron Ocircumflex -40
KPX Rcaron Odieresis -40
KPX Rcaron Ograve -40
KPX Rcaron Ohungarumlaut -40
KPX Rcaron Omacron -40
KPX Rcaron Oslash -40
KPX Rcaron Otilde -40
KPX Rcaron U -40
KPX Rcaron Uacute -40
KPX Rcaron Ucircumflex -40
KPX Rcaron Udieresis -40
KPX Rcaron Ugrave -40
KPX Rcaron Uhungarumlaut -40
KPX Rcaron Umacron -40
KPX Rcaron Uogonek -40
KPX Rcaron Uring -40
KPX Rcaron V -18
KPX Rcaron W -18
KPX Rcaron Y -18
KPX Rcaron Yacute -18
KPX Rcaron Ydieresis -18
KPX Rcommaaccent O -40
KPX Rcommaaccent Oacute -40
KPX Rcommaaccent Ocircumflex -40
KPX Rcommaaccent Odieresis -40
KPX Rcommaaccent Ograve -40
KPX Rcommaaccent Ohungarumlaut -40
KPX Rcommaaccent Omacron -40
KPX Rcommaaccent Oslash -40
KPX Rcommaaccent Otilde -40
KPX Rcommaaccent U -40
KPX Rcommaaccent Uacute -40
KPX Rcommaaccent Ucircumflex -40
KPX Rcommaaccent Udieresis -40
KPX Rcommaaccent Ugrave -40
KPX Rcommaaccent Uhungarumlaut -40
KPX Rcommaaccent Umacron -40
KPX Rcommaaccent Uogonek -40
KPX Rcommaaccent Uring -40
KPX Rcommaaccent V -18
KPX Rcommaaccent W -18
KPX Rcommaaccent Y -18
KPX Rcommaaccent Yacute -18
KPX Rcommaaccent Ydieresis -18
KPX T A -50
KPX T Aacute -50
KPX T Abreve -50
KPX T Acircumflex -50
KPX T Adieresis -50
KPX T Agrave -50
KPX T Amacron -50
KPX T Aogonek -50
KPX T Aring -50
KPX T Atilde -50
KPX T O -18
KPX T Oacute -18
KPX T Ocircumflex -18
KPX T Odieresis -18
KPX T Ograve -18
KPX T Ohungarumlaut -18
KPX T Omacron -18
KPX T Oslash -18
KPX T Otilde -18
KPX T a -92
KPX T aacute -92
KPX T abreve -92
KPX T acircumflex -92
KPX T adieresis -92
KPX T agrave -92
KPX T amacron -92
KPX T aogonek -92
KPX T aring -92
KPX T atilde -92
KPX T colon -55
KPX T comma -74
KPX T e -92
KPX T eacute -92
KPX T ecaron -92
KPX T ecircumflex -52
KPX T edieresis -52
KPX T edotaccent -92
KPX T egrave -52
KPX T emacron -52
KPX T eogonek -92
KPX T hyphen -74
KPX T i -55
KPX T iacute -55
KPX T iogonek -55
KPX T o -92
KPX T oacute -92
KPX T ocircumflex -92
KPX T odieresis -92
KPX T ograve -92
KPX T ohungarumlaut -92
KPX T omacron -92
KPX T oslash -92
KPX T otilde -92
KPX T period -74
KPX T r -55
KPX T racute -55
KPX T rcaron -55
KPX T rcommaaccent -55
KPX T semicolon -65
KPX T u -55
KPX T uacute -55
KPX T ucircumflex -55
KPX T udieresis -55
KPX T ugrave -55
KPX T uhungarumlaut -55
KPX T umacron -55
KPX T uogonek -55
KPX T uring -55
KPX T w -74
KPX T y -74
KPX T yacute -74
KPX T ydieresis -34
KPX Tcaron A -50
KPX Tcaron Aacute -50
KPX Tcaron Abreve -50
KPX Tcaron Acircumflex -50
KPX Tcaron Adieresis -50
KPX Tcaron Agrave -50
KPX Tcaron Amacron -50
KPX Tcaron Aogonek -50
KPX Tcaron Aring -50
KPX Tcaron Atilde -50
KPX Tcaron O -18
KPX Tcaron Oacute -18
KPX Tcaron Ocircumflex -18
KPX Tcaron Odieresis -18
KPX Tcaron Ograve -18
KPX Tcaron Ohungarumlaut -18
KPX Tcaron Omacron -18
KPX Tcaron Oslash -18
KPX Tcaron Otilde -18
KPX Tcaron a -92
KPX Tcaron aacute -92
KPX Tcaron abreve -92
KPX Tcaron acircumflex -92
KPX Tcaron adieresis -92
KPX Tcaron agrave -92
KPX Tcaron amacron -92
KPX Tcaron aogonek -92
KPX Tcaron aring -92
KPX Tcaron atilde -92
KPX Tcaron colon -55
KPX Tcaron comma -74
KPX Tcaron e -92
KPX Tcaron eacute -92
KPX Tcaron ecaron -92
KPX Tcaron ecircumflex -52
KPX Tcaron edieresis -52
KPX Tcaron edotaccent -92
KPX Tcaron egrave -52
KPX Tcaron emacron -52
KPX Tcaron eogonek -92
KPX Tcaron hyphen -74
KPX Tcaron i -55
KPX Tcaron iacute -55
KPX Tcaron iogonek -55
KPX Tcaron o -92
KPX Tcaron oacute -92
KPX Tcaron ocircumflex -92
KPX Tcaron odieresis -92
KPX Tcaron ograve -92
KPX Tcaron ohungarumlaut -92
KPX Tcaron omacron -92
KPX Tcaron oslash -92
KPX Tcaron otilde -92
KPX Tcaron period -74
KPX Tcaron r -55
KPX Tcaron racute -55
KPX Tcaron rcaron -55
KPX Tcaron rcommaaccent -55
KPX Tcaron semicolon -65
KPX Tcaron u -55
KPX Tcaron uacute -55
KPX Tcaron ucircumflex -55
KPX Tcaron udieresis -55
KPX Tcaron ugrave -55
KPX Tcaron uhungarumlaut -55
KPX Tcaron umacron -55
KPX Tcaron uogonek -55
KPX Tcaron uring -55
KPX Tcaron w -74
KPX Tcaron y -74
KPX Tcaron yacute -74
KPX Tcaron ydieresis -34
KPX Tcommaaccent A -50
KPX Tcommaaccent Aacute -50
KPX Tcommaaccent Abreve -50
KPX Tcommaaccent Acircumflex -50
KPX Tcommaaccent Adieresis -50
KPX Tcommaaccent Agrave -50
KPX Tcommaaccent Amacron -50
KPX Tcommaaccent Aogonek -50
KPX Tcommaaccent Aring -50
KPX Tcommaaccent Atilde -50
KPX Tcommaaccent O -18
KPX Tcommaaccent Oacute -18
KPX Tcommaaccent Ocircumflex -18
KPX Tcommaaccent Odieresis -18
KPX Tcommaaccent Ograve -18
KPX Tcommaaccent Ohungarumlaut -18
KPX Tcommaaccent Omacron -18
KPX Tcommaaccent Oslash -18
KPX Tcommaaccent Otilde -18
KPX Tcommaaccent a -92
KPX Tcommaaccent aacute -92
KPX Tcommaaccent abreve -92
KPX Tcommaaccent acircumflex -92
KPX Tcommaaccent adieresis -92
KPX Tcommaaccent agrave -92
KPX Tcommaaccent amacron -92
KPX Tcommaaccent aogonek -92
KPX Tcommaaccent aring -92
KPX Tcommaaccent atilde -92
KPX Tcommaaccent colon -55
KPX Tcommaaccent comma -74
KPX Tcommaaccent e -92
KPX Tcommaaccent eacute -92
KPX Tcommaaccent ecaron -92
KPX Tcommaaccent ecircumflex -52
KPX Tcommaaccent edieresis -52
KPX Tcommaaccent edotaccent -92
KPX Tcommaaccent egrave -52
KPX Tcommaaccent emacron -52
KPX Tcommaaccent eogonek -92
KPX Tcommaaccent hyphen -74
KPX Tcommaaccent i -55
KPX Tcommaaccent iacute -55
KPX Tcommaaccent iogonek -55
KPX Tcommaaccent o -92
KPX Tcommaaccent oacute -92
KPX Tcommaaccent ocircumflex -92
KPX Tcommaaccent odieresis -92
KPX Tcommaaccent ograve -92
KPX Tcommaaccent ohungarumlaut -92
KPX Tcommaaccent omacron -92
KPX Tcommaaccent oslash -92
KPX Tcommaaccent otilde -92
KPX Tcommaaccent period -74
KPX Tcommaaccent r -55
KPX Tcommaaccent racute -55
KPX Tcommaaccent rcaron -55
KPX Tcommaaccent rcommaaccent -55
KPX Tcommaaccent semicolon -65
KPX Tcommaaccent u -55
KPX Tcommaaccent uacute -55
KPX Tcommaaccent ucircumflex -55
KPX Tcommaaccent udieresis -55
KPX Tcommaaccent ugrave -55
KPX Tcommaaccent uhungarumlaut -55
KPX Tcommaaccent umacron -55
KPX Tcommaaccent uogonek -55
KPX Tcommaaccent uring -55
KPX Tcommaaccent w -74
KPX Tcommaaccent y -74
KPX Tcommaaccent yacute -74
KPX Tcommaaccent ydieresis -34
KPX U A -40
KPX U Aacute -40
KPX U Abreve -40
KPX U Acircumflex -40
KPX U Adieresis -40
KPX U Agrave -40
KPX U Amacron -40
KPX U Aogonek -40
KPX U Aring -40
KPX U Atilde -40
KPX U comma -25
KPX U period -25
KPX Uacute A -40
KPX Uacute Aacute -40
KPX Uacute Abreve -40
KPX Uacute Acircumflex -40
KPX Uacute Adieresis -40
KPX Uacute Agrave -40
KPX Uacute Amacron -40
KPX Uacute Aogonek -40
KPX Uacute Aring -40
KPX Uacute Atilde -40
KPX Uacute comma -25
KPX Uacute period -25
KPX Ucircumflex A -40
KPX Ucircumflex Aacute -40
KPX Ucircumflex Abreve -40
KPX Ucircumflex Acircumflex -40
KPX Ucircumflex Adieresis -40
KPX Ucircumflex Agrave -40
KPX Ucircumflex Amacron -40
KPX Ucircumflex Aogonek -40
KPX Ucircumflex Aring -40
KPX Ucircumflex Atilde -40
KPX Ucircumflex comma -25
KPX Ucircumflex period -25
KPX Udieresis A -40
KPX Udieresis Aacute -40
KPX Udieresis Abreve -40
KPX Udieresis Acircumflex -40
KPX Udieresis Adieresis -40
KPX Udieresis Agrave -40
KPX Udieresis Amacron -40
KPX Udieresis Aogonek -40
KPX Udieresis Aring -40
KPX Udieresis Atilde -40
KPX Udieresis comma -25
KPX Udieresis period -25
KPX Ugrave A -40
KPX Ugrave Aacute -40
KPX Ugrave Abreve -40
KPX Ugrave Acircumflex -40
KPX Ugrave Adieresis -40
KPX Ugrave Agrave -40
KPX Ugrave Amacron -40
KPX Ugrave Aogonek -40
KPX Ugrave Aring -40
KPX Ugrave Atilde -40
KPX Ugrave comma -25
KPX Ugrave period -25
KPX Uhungarumlaut A -40
KPX Uhungarumlaut Aacute -40
KPX Uhungarumlaut Abreve -40
KPX Uhungarumlaut Acircumflex -40
KPX Uhungarumlaut Adieresis -40
KPX Uhungarumlaut Agrave -40
KPX Uhungarumlaut Amacron -40
KPX Uhungarumlaut Aogonek -40
KPX Uhungarumlaut Aring -40
KPX Uhungarumlaut Atilde -40
KPX Uhungarumlaut comma -25
KPX Uhungarumlaut period -25
KPX Umacron A -40
KPX Umacron Aacute -40
KPX Umacron Abreve -40
KPX Umacron Acircumflex -40
KPX Umacron Adieresis -40
KPX Umacron Agrave -40
KPX Umacron Amacron -40
KPX Umacron Aogonek -40
KPX Umacron Aring -40
KPX Umacron Atilde -40
KPX Umacron comma -25
KPX Umacron period -25
KPX Uogonek A -40
KPX Uogonek Aacute -40
KPX Uogonek Abreve -40
KPX Uogonek Acircumflex -40
KPX Uogonek Adieresis -40
KPX Uogonek Agrave -40
KPX Uogonek Amacron -40
KPX Uogonek Aogonek -40
KPX Uogonek Aring -40
KPX Uogonek Atilde -40
KPX Uogonek comma -25
KPX Uogonek period -25
KPX Uring A -40
KPX Uring Aacute -40
KPX Uring Abreve -40
KPX Uring Acircumflex -40
KPX Uring Adieresis -40
KPX Uring Agrave -40
KPX Uring Amacron -40
KPX Uring Aogonek -40
KPX Uring Aring -40
KPX Uring Atilde -40
KPX Uring comma -25
KPX Uring period -25
KPX V A -60
KPX V Aacute -60
KPX V Abreve -60
KPX V Acircumflex -60
KPX V Adieresis -60
KPX V Agrave -60
KPX V Amacron -60
KPX V Aogonek -60
KPX V Aring -60
KPX V Atilde -60
KPX V O -30
KPX V Oacute -30
KPX V Ocircumflex -30
KPX V Odieresis -30
KPX V Ograve -30
KPX V Ohungarumlaut -30
KPX V Omacron -30
KPX V Oslash -30
KPX V Otilde -30
KPX V a -111
KPX V aacute -111
KPX V abreve -111
KPX V acircumflex -111
KPX V adieresis -111
KPX V agrave -111
KPX V amacron -111
KPX V aogonek -111
KPX V aring -111
KPX V atilde -111
KPX V colon -65
KPX V comma -129
KPX V e -111
KPX V eacute -111
KPX V ecaron -111
KPX V ecircumflex -111
KPX V edieresis -71
KPX V edotaccent -111
KPX V egrave -71
KPX V emacron -71
KPX V eogonek -111
KPX V hyphen -55
KPX V i -74
KPX V iacute -74
KPX V icircumflex -34
KPX V idieresis -34
KPX V igrave -34
KPX V imacron -34
KPX V iogonek -74
KPX V o -111
KPX V oacute -111
KPX V ocircumflex -111
KPX V odieresis -111
KPX V ograve -111
KPX V ohungarumlaut -111
KPX V omacron -111
KPX V oslash -111
KPX V otilde -111
KPX V period -129
KPX V semicolon -74
KPX V u -74
KPX V uacute -74
KPX V ucircumflex -74
KPX V udieresis -74
KPX V ugrave -74
KPX V uhungarumlaut -74
KPX V umacron -74
KPX V uogonek -74
KPX V uring -74
KPX W A -60
KPX W Aacute -60
KPX W Abreve -60
KPX W Acircumflex -60
KPX W Adieresis -60
KPX W Agrave -60
KPX W Amacron -60
KPX W Aogonek -60
KPX W Aring -60
KPX W Atilde -60
KPX W O -25
KPX W Oacute -25
KPX W Ocircumflex -25
KPX W Odieresis -25
KPX W Ograve -25
KPX W Ohungarumlaut -25
KPX W Omacron -25
KPX W Oslash -25
KPX W Otilde -25
KPX W a -92
KPX W aacute -92
KPX W abreve -92
KPX W acircumflex -92
KPX W adieresis -92
KPX W agrave -92
KPX W amacron -92
KPX W aogonek -92
KPX W aring -92
KPX W atilde -92
KPX W colon -65
KPX W comma -92
KPX W e -92
KPX W eacute -92
KPX W ecaron -92
KPX W ecircumflex -92
KPX W edieresis -52
KPX W edotaccent -92
KPX W egrave -52
KPX W emacron -52
KPX W eogonek -92
KPX W hyphen -37
KPX W i -55
KPX W iacute -55
KPX W iogonek -55
KPX W o -92
KPX W oacute -92
KPX W ocircumflex -92
KPX W odieresis -92
KPX W ograve -92
KPX W ohungarumlaut -92
KPX W omacron -92
KPX W oslash -92
KPX W otilde -92
KPX W period -92
KPX W semicolon -65
KPX W u -55
KPX W uacute -55
KPX W ucircumflex -55
KPX W udieresis -55
KPX W ugrave -55
KPX W uhungarumlaut -55
KPX W umacron -55
KPX W uogonek -55
KPX W uring -55
KPX W y -70
KPX W yacute -70
KPX W ydieresis -70
KPX Y A -50
KPX Y Aacute -50
KPX Y Abreve -50
KPX Y Acircumflex -50
KPX Y Adieresis -50
KPX Y Agrave -50
KPX Y Amacron -50
KPX Y Aogonek -50
KPX Y Aring -50
KPX Y Atilde -50
KPX Y O -15
KPX Y Oacute -15
KPX Y Ocircumflex -15
KPX Y Odieresis -15
KPX Y Ograve -15
KPX Y Ohungarumlaut -15
KPX Y Omacron -15
KPX Y Oslash -15
KPX Y Otilde -15
KPX Y a -92
KPX Y aacute -92
KPX Y abreve -92
KPX Y acircumflex -92
KPX Y adieresis -92
KPX Y agrave -92
KPX Y amacron -92
KPX Y aogonek -92
KPX Y aring -92
KPX Y atilde -92
KPX Y colon -65
KPX Y comma -92
KPX Y e -92
KPX Y eacute -92
KPX Y ecaron -92
KPX Y ecircumflex -92
KPX Y edieresis -52
KPX Y edotaccent -92
KPX Y egrave -52
KPX Y emacron -52
KPX Y eogonek -92
KPX Y hyphen -74
KPX Y i -74
KPX Y iacute -74
KPX Y icircumflex -34
KPX Y idieresis -34
KPX Y igrave -34
KPX Y imacron -34
KPX Y iogonek -74
KPX Y o -92
KPX Y oacute -92
KPX Y ocircumflex -92
KPX Y odieresis -92
KPX Y ograve -92
KPX Y ohungarumlaut -92
KPX Y omacron -92
KPX Y oslash -92
KPX Y otilde -92
KPX Y period -92
KPX Y semicolon -65
KPX Y u -92
KPX Y uacute -92
KPX Y ucircumflex -92
KPX Y udieresis -92
KPX Y ugrave -92
KPX Y uhungarumlaut -92
KPX Y umacron -92
KPX Y uogonek -92
KPX Y uring -92
KPX Yacute A -50
KPX Yacute Aacute -50
KPX Yacute Abreve -50
KPX Yacute Acircumflex -50
KPX Yacute Adieresis -50
KPX Yacute Agrave -50
KPX Yacute Amacron -50
KPX Yacute Aogonek -50
KPX Yacute Aring -50
KPX Yacute Atilde -50
KPX Yacute O -15
KPX Yacute Oacute -15
KPX Yacute Ocircumflex -15
KPX Yacute Odieresis -15
KPX Yacute Ograve -15
KPX Yacute Ohungarumlaut -15
KPX Yacute Omacron -15
KPX Yacute Oslash -15
KPX Yacute Otilde -15
KPX Yacute a -92
KPX Yacute aacute -92
KPX Yacute abreve -92
KPX Yacute acircumflex -92
KPX Yacute adieresis -92
KPX Yacute agrave -92
KPX Yacute amacron -92
KPX Yacute aogonek -92
KPX Yacute aring -92
KPX Yacute atilde -92
KPX Yacute colon -65
KPX Yacute comma -92
KPX Yacute e -92
KPX Yacute eacute -92
KPX Yacute ecaron -92
KPX Yacute ecircumflex -92
KPX Yacute edieresis -52
KPX Yacute edotaccent -92
KPX Yacute egrave -52
KPX Yacute emacron -52
KPX Yacute eogonek -92
KPX Yacute hyphen -74
KPX Yacute i -74
KPX Yacute iacute -74
KPX Yacute icircumflex -34
KPX Yacute idieresis -34
KPX Yacute igrave -34
KPX Yacute imacron -34
KPX Yacute iogonek -74
KPX Yacute o -92
KPX Yacute oacute -92
KPX Yacute ocircumflex -92
KPX Yacute odieresis -92
KPX Yacute ograve -92
KPX Yacute ohungarumlaut -92
KPX Yacute omacron -92
KPX Yacute oslash -92
KPX Yacute otilde -92
KPX Yacute period -92
KPX Yacute semicolon -65
KPX Yacute u -92
KPX Yacute uacute -92
KPX Yacute ucircumflex -92
KPX Yacute udieresis -92
KPX Yacute ugrave -92
KPX Yacute uhungarumlaut -92
KPX Yacute umacron -92
KPX Yacute uogonek -92
KPX Yacute uring -92
KPX Ydieresis A -50
KPX Ydieresis Aacute -50
KPX Ydieresis Abreve -50
KPX Ydieresis Acircumflex -50
KPX Ydieresis Adieresis -50
KPX Ydieresis Agrave -50
KPX Ydieresis Amacron -50
KPX Ydieresis Aogonek -50
KPX Ydieresis Aring -50
KPX Ydieresis Atilde -50
KPX Ydieresis O -15
KPX Ydieresis Oacute -15
KPX Ydieresis Ocircumflex -15
KPX Ydieresis Odieresis -15
KPX Ydieresis Ograve -15
KPX Ydieresis Ohungarumlaut -15
KPX Ydieresis Omacron -15
KPX Ydieresis Oslash -15
KPX Ydieresis Otilde -15
KPX Ydieresis a -92
KPX Ydieresis aacute -92
KPX Ydieresis abreve -92
KPX Ydieresis acircumflex -92
KPX Ydieresis adieresis -92
KPX Ydieresis agrave -92
KPX Ydieresis amacron -92
KPX Ydieresis aogonek -92
KPX Ydieresis aring -92
KPX Ydieresis atilde -92
KPX Ydieresis colon -65
KPX Ydieresis comma -92
KPX Ydieresis e -92
KPX Ydieresis eacute -92
KPX Ydieresis ecaron -92
KPX Ydieresis ecircumflex -92
KPX Ydieresis edieresis -52
KPX Ydieresis edotaccent -92
KPX Ydieresis egrave -52
KPX Ydieresis emacron -52
KPX Ydieresis eogonek -92
KPX Ydieresis hyphen -74
KPX Ydieresis i -74
KPX Ydieresis iacute -74
KPX Ydieresis icircumflex -34
KPX Ydieresis idieresis -34
KPX Ydieresis igrave -34
KPX Ydieresis imacron -34
KPX Ydieresis iogonek -74
KPX Ydieresis o -92
KPX Ydieresis oacute -92
KPX Ydieresis ocircumflex -92
KPX Ydieresis odieresis -92
KPX Ydieresis ograve -92
KPX Ydieresis ohungarumlaut -92
KPX Ydieresis omacron -92
KPX Ydieresis oslash -92
KPX Ydieresis otilde -92
KPX Ydieresis period -92
KPX Ydieresis semicolon -65
KPX Ydieresis u -92
KPX Ydieresis uacute -92
KPX Ydieresis ucircumflex -92
KPX Ydieresis udieresis -92
KPX Ydieresis ugrave -92
KPX Ydieresis uhungarumlaut -92
KPX Ydieresis umacron -92
KPX Ydieresis uogonek -92
KPX Ydieresis uring -92
KPX a g -10
KPX a gbreve -10
KPX a gcommaaccent -10
KPX aacute g -10
KPX aacute gbreve -10
KPX aacute gcommaaccent -10
KPX abreve g -10
KPX abreve gbreve -10
KPX abreve gcommaaccent -10
KPX acircumflex g -10
KPX acircumflex gbreve -10
KPX acircumflex gcommaaccent -10
KPX adieresis g -10
KPX adieresis gbreve -10
KPX adieresis gcommaaccent -10
KPX agrave g -10
KPX agrave gbreve -10
KPX agrave gcommaaccent -10
KPX amacron g -10
KPX amacron gbreve -10
KPX amacron gcommaaccent -10
KPX aogonek g -10
KPX aogonek gbreve -10
KPX aogonek gcommaaccent -10
KPX aring g -10
KPX aring gbreve -10
KPX aring gcommaaccent -10
KPX atilde g -10
KPX atilde gbreve -10
KPX atilde gcommaaccent -10
KPX b period -40
KPX b u -20
KPX b uacute -20
KPX b ucircumflex -20
KPX b udieresis -20
KPX b ugrave -20
KPX b uhungarumlaut -20
KPX b umacron -20
KPX b uogonek -20
KPX b uring -20
KPX c h -15
KPX c k -20
KPX c kcommaaccent -20
KPX cacute h -15
KPX cacute k -20
KPX cacute kcommaaccent -20
KPX ccaron h -15
KPX ccaron k -20
KPX ccaron kcommaaccent -20
KPX ccedilla h -15
KPX ccedilla k -20
KPX ccedilla kcommaaccent -20
KPX comma quotedblright -140
KPX comma quoteright -140
KPX e comma -10
KPX e g -40
KPX e gbreve -40
KPX e gcommaaccent -40
KPX e period -15
KPX e v -15
KPX e w -15
KPX e x -20
KPX e y -30
KPX e yacute -30
KPX e ydieresis -30
KPX eacute comma -10
KPX eacute g -40
KPX eacute gbreve -40
KPX eacute gcommaaccent -40
KPX eacute period -15
KPX eacute v -15
KPX eacute w -15
KPX eacute x -20
KPX eacute y -30
KPX eacute yacute -30
KPX eacute ydieresis -30
KPX ecaron comma -10
KPX ecaron g -40
KPX ecaron gbreve -40
KPX ecaron gcommaaccent -40
KPX ecaron period -15
KPX ecaron v -15
KPX ecaron w -15
KPX ecaron x -20
KPX ecaron y -30
KPX ecaron yacute -30
KPX ecaron ydieresis -30
KPX ecircumflex comma -10
KPX ecircumflex g -40
KPX ecircumflex gbreve -40
KPX ecircumflex gcommaaccent -40
KPX ecircumflex period -15
KPX ecircumflex v -15
KPX ecircumflex w -15
KPX ecircumflex x -20
KPX ecircumflex y -30
KPX ecircumflex yacute -30
KPX ecircumflex ydieresis -30
KPX edieresis comma -10
KPX edieresis g -40
KPX edieresis gbreve -40
KPX edieresis gcommaaccent -40
KPX edieresis period -15
KPX edieresis v -15
KPX edieresis w -15
KPX edieresis x -20
KPX edieresis y -30
KPX edieresis yacute -30
KPX edieresis ydieresis -30
KPX edotaccent comma -10
KPX edotaccent g -40
KPX edotaccent gbreve -40
KPX edotaccent gcommaaccent -40
KPX edotaccent period -15
KPX edotaccent v -15
KPX edotaccent w -15
KPX edotaccent x -20
KPX edotaccent y -30
KPX edotaccent yacute -30
KPX edotaccent ydieresis -30
KPX egrave comma -10
KPX egrave g -40
KPX egrave gbreve -40
KPX egrave gcommaaccent -40
KPX egrave period -15
KPX egrave v -15
KPX egrave w -15
KPX egrave x -20
KPX egrave y -30
KPX egrave yacute -30
KPX egrave ydieresis -30
KPX emacron comma -10
KPX emacron g -40
KPX emacron gbreve -40
KPX emacron gcommaaccent -40
KPX emacron period -15
KPX emacron v -15
KPX emacron w -15
KPX emacron x -20
KPX emacron y -30
KPX emacron yacute -30
KPX emacron ydieresis -30
KPX eogonek comma -10
KPX eogonek g -40
KPX eogonek gbreve -40
KPX eogonek gcommaaccent -40
KPX eogonek period -15
KPX eogonek v -15
KPX eogonek w -15
KPX eogonek x -20
KPX eogonek y -30
KPX eogonek yacute -30
KPX eogonek ydieresis -30
KPX f comma -10
KPX f dotlessi -60
KPX f f -18
KPX f i -20
KPX f iogonek -20
KPX f period -15
KPX f quoteright 92
KPX g comma -10
KPX g e -10
KPX g eacute -10
KPX g ecaron -10
KPX g ecircumflex -10
KPX g edieresis -10
KPX g edotaccent -10
KPX g egrave -10
KPX g emacron -10
KPX g eogonek -10
KPX g g -10
KPX g gbreve -10
KPX g gcommaaccent -10
KPX g period -15
KPX gbreve comma -10
KPX gbreve e -10
KPX gbreve eacute -10
KPX gbreve ecaron -10
KPX gbreve ecircumflex -10
KPX gbreve edieresis -10
KPX gbreve edotaccent -10
KPX gbreve egrave -10
KPX gbreve emacron -10
KPX gbreve eogonek -10
KPX gbreve g -10
KPX gbreve gbreve -10
KPX gbreve gcommaaccent -10
KPX gbreve period -15
KPX gcommaaccent comma -10
KPX gcommaaccent e -10
KPX gcommaaccent eacute -10
KPX gcommaaccent ecaron -10
KPX gcommaaccent ecircumflex -10
KPX gcommaaccent edieresis -10
KPX gcommaaccent edotaccent -10
KPX gcommaaccent egrave -10
KPX gcommaaccent emacron -10
KPX gcommaaccent eogonek -10
KPX gcommaaccent g -10
KPX gcommaaccent gbreve -10
KPX gcommaaccent gcommaaccent -10
KPX gcommaaccent period -15
KPX k e -10
KPX k eacute -10
KPX k ecaron -10
KPX k ecircumflex -10
KPX k edieresis -10
KPX k edotaccent -10
KPX k egrave -10
KPX k emacron -10
KPX k eogonek -10
KPX k o -10
KPX k oacute -10
KPX k ocircumflex -10
KPX k odieresis -10
KPX k ograve -10
KPX k ohungarumlaut -10
KPX k omacron -10
KPX k oslash -10
KPX k otilde -10
KPX k y -10
KPX k yacute -10
KPX k ydieresis -10
KPX kcommaaccent e -10
KPX kcommaaccent eacute -10
KPX kcommaaccent ecaron -10
KPX kcommaaccent ecircumflex -10
KPX kcommaaccent edieresis -10
KPX kcommaaccent edotaccent -10
KPX kcommaaccent egrave -10
KPX kcommaaccent emacron -10
KPX kcommaaccent eogonek -10
KPX kcommaaccent o -10
KPX kcommaaccent oacute -10
KPX kcommaaccent ocircumflex -10
KPX kcommaaccent odieresis -10
KPX kcommaaccent ograve -10
KPX kcommaaccent ohungarumlaut -10
KPX kcommaaccent omacron -10
KPX kcommaaccent oslash -10
KPX kcommaaccent otilde -10
KPX kcommaaccent y -10
KPX kcommaaccent yacute -10
KPX kcommaaccent ydieresis -10
KPX n v -40
KPX nacute v -40
KPX ncaron v -40
KPX ncommaaccent v -40
KPX ntilde v -40
KPX o g -10
KPX o gbreve -10
KPX o gcommaaccent -10
KPX o v -10
KPX oacute g -10
KPX oacute gbreve -10
KPX oacute gcommaaccent -10
KPX oacute v -10
KPX ocircumflex g -10
KPX ocircumflex gbreve -10
KPX ocircumflex gcommaaccent -10
KPX ocircumflex v -10
KPX odieresis g -10
KPX odieresis gbreve -10
KPX odieresis gcommaaccent -10
KPX odieresis v -10
KPX ograve g -10
KPX ograve gbreve -10
KPX ograve gcommaaccent -10
KPX ograve v -10
KPX ohungarumlaut g -10
KPX ohungarumlaut gbreve -10
KPX ohungarumlaut gcommaaccent -10
KPX ohungarumlaut v -10
KPX omacron g -10
KPX omacron gbreve -10
KPX omacron gcommaaccent -10
KPX omacron v -10
KPX oslash g -10
KPX oslash gbreve -10
KPX oslash gcommaaccent -10
KPX oslash v -10
KPX otilde g -10
KPX otilde gbreve -10
KPX otilde gcommaaccent -10
KPX otilde v -10
KPX period quotedblright -140
KPX period quoteright -140
KPX quoteleft quoteleft -111
KPX quoteright d -25
KPX quoteright dcroat -25
KPX quoteright quoteright -111
KPX quoteright r -25
KPX quoteright racute -25
KPX quoteright rcaron -25
KPX quoteright rcommaaccent -25
KPX quoteright s -40
KPX quoteright sacute -40
KPX quoteright scaron -40
KPX quoteright scedilla -40
KPX quoteright scommaaccent -40
KPX quoteright space -111
KPX quoteright t -30
KPX quoteright tcommaaccent -30
KPX quoteright v -10
KPX r a -15
KPX r aacute -15
KPX r abreve -15
KPX r acircumflex -15
KPX r adieresis -15
KPX r agrave -15
KPX r amacron -15
KPX r aogonek -15
KPX r aring -15
KPX r atilde -15
KPX r c -37
KPX r cacute -37
KPX r ccaron -37
KPX r ccedilla -37
KPX r comma -111
KPX r d -37
KPX r dcroat -37
KPX r e -37
KPX r eacute -37
KPX r ecaron -37
KPX r ecircumflex -37
KPX r edieresis -37
KPX r edotaccent -37
KPX r egrave -37
KPX r emacron -37
KPX r eogonek -37
KPX r g -37
KPX r gbreve -37
KPX r gcommaaccent -37
KPX r hyphen -20
KPX r o -45
KPX r oacute -45
KPX r ocircumflex -45
KPX r odieresis -45
KPX r ograve -45
KPX r ohungarumlaut -45
KPX r omacron -45
KPX r oslash -45
KPX r otilde -45
KPX r period -111
KPX r q -37
KPX r s -10
KPX r sacute -10
KPX r scaron -10
KPX r scedilla -10
KPX r scommaaccent -10
KPX racute a -15
KPX racute aacute -15
KPX racute abreve -15
KPX racute acircumflex -15
KPX racute adieresis -15
KPX racute agrave -15
KPX racute amacron -15
KPX racute aogonek -15
KPX racute aring -15
KPX racute atilde -15
KPX racute c -37
KPX racute cacute -37
KPX racute ccaron -37
KPX racute ccedilla -37
KPX racute comma -111
KPX racute d -37
KPX racute dcroat -37
KPX racute e -37
KPX racute eacute -37
KPX racute ecaron -37
KPX racute ecircumflex -37
KPX racute edieresis -37
KPX racute edotaccent -37
KPX racute egrave -37
KPX racute emacron -37
KPX racute eogonek -37
KPX racute g -37
KPX racute gbreve -37
KPX racute gcommaaccent -37
KPX racute hyphen -20
KPX racute o -45
KPX racute oacute -45
KPX racute ocircumflex -45
KPX racute odieresis -45
KPX racute ograve -45
KPX racute ohungarumlaut -45
KPX racute omacron -45
KPX racute oslash -45
KPX racute otilde -45
KPX racute period -111
KPX racute q -37
KPX racute s -10
KPX racute sacute -10
KPX racute scaron -10
KPX racute scedilla -10
KPX racute scommaaccent -10
KPX rcaron a -15
KPX rcaron aacute -15
KPX rcaron abreve -15
KPX rcaron acircumflex -15
KPX rcaron adieresis -15
KPX rcaron agrave -15
KPX rcaron amacron -15
KPX rcaron aogonek -15
KPX rcaron aring -15
KPX rcaron atilde -15
KPX rcaron c -37
KPX rcaron cacute -37
KPX rcaron ccaron -37
KPX rcaron ccedilla -37
KPX rcaron comma -111
KPX rcaron d -37
KPX rcaron dcroat -37
KPX rcaron e -37
KPX rcaron eacute -37
KPX rcaron ecaron -37
KPX rcaron ecircumflex -37
KPX rcaron edieresis -37
KPX rcaron edotaccent -37
KPX rcaron egrave -37
KPX rcaron emacron -37
KPX rcaron eogonek -37
KPX rcaron g -37
KPX rcaron gbreve -37
KPX rcaron gcommaaccent -37
KPX rcaron hyphen -20
KPX rcaron o -45
KPX rcaron oacute -45
KPX rcaron ocircumflex -45
KPX rcaron odieresis -45
KPX rcaron ograve -45
KPX rcaron ohungarumlaut -45
KPX rcaron omacron -45
KPX rcaron oslash -45
KPX rcaron otilde -45
KPX rcaron period -111
KPX rcaron q -37
KPX rcaron s -10
KPX rcaron sacute -10
KPX rcaron scaron -10
KPX rcaron scedilla -10
KPX rcaron scommaaccent -10
KPX rcommaaccent a -15
KPX rcommaaccent aacute -15
KPX rcommaaccent abreve -15
KPX rcommaaccent acircumflex -15
KPX rcommaaccent adieresis -15
KPX rcommaaccent agrave -15
KPX rcommaaccent amacron -15
KPX rcommaaccent aogonek -15
KPX rcommaaccent aring -15
KPX rcommaaccent atilde -15
KPX rcommaaccent c -37
KPX rcommaaccent cacute -37
KPX rcommaaccent ccaron -37
KPX rcommaaccent ccedilla -37
KPX rcommaaccent comma -111
KPX rcommaaccent d -37
KPX rcommaaccent dcroat -37
KPX rcommaaccent e -37
KPX rcommaaccent eacute -37
KPX rcommaaccent ecaron -37
KPX rcommaaccent ecircumflex -37
KPX rcommaaccent edieresis -37
KPX rcommaaccent edotaccent -37
KPX rcommaaccent egrave -37
KPX rcommaaccent emacron -37
KPX rcommaaccent eogonek -37
KPX rcommaaccent g -37
KPX rcommaaccent gbreve -37
KPX rcommaaccent gcommaaccent -37
KPX rcommaaccent hyphen -20
KPX rcommaaccent o -45
KPX rcommaaccent oacute -45
KPX rcommaaccent ocircumflex -45
KPX rcommaaccent odieresis -45
KPX rcommaaccent ograve -45
KPX rcommaaccent ohungarumlaut -45
KPX rcommaaccent omacron -45
KPX rcommaaccent oslash -45
KPX rcommaaccent otilde -45
KPX rcommaaccent period -111
KPX rcommaaccent q -37
KPX rcommaaccent s -10
KPX rcommaaccent sacute -10
KPX rcommaaccent scaron -10
KPX rcommaaccent scedilla -10
KPX rcommaaccent scommaaccent -10
KPX space A -18
KPX space Aacute -18
KPX space Abreve -18
KPX space Acircumflex -18
KPX space Adieresis -18
KPX space Agrave -18
KPX space Amacron -18
KPX space Aogonek -18
KPX space Aring -18
KPX space Atilde -18
KPX space T -18
KPX space Tcaron -18
KPX space Tcommaaccent -18
KPX space V -35
KPX space W -40
KPX space Y -75
KPX space Yacute -75
KPX space Ydieresis -75
KPX v comma -74
KPX v period -74
KPX w comma -74
KPX w period -74
KPX y comma -55
KPX y period -55
KPX yacute comma -55
KPX yacute period -55
KPX ydieresis comma -55
KPX ydieresis period -55
EndKernPairs
EndKernData
EndFontMetrics"

let times_bold_italic_afm = "StartFontMetrics 4.1
Comment Copyright (c) 1985, 1987, 1989, 1990, 1993, 1997 Adobe Systems Incorporated.  All Rights Reserved.
Comment Creation Date: Thu May  1 13:04:06 1997
Comment UniqueID 43066
Comment VMusage 45874 56899
FontName Times-BoldItalic
FullName Times Bold Italic
FamilyName Times
Weight Bold
ItalicAngle -15
IsFixedPitch false
CharacterSet ExtendedRoman
FontBBox -200 -218 996 921 
UnderlinePosition -100
UnderlineThickness 50
Version 002.000
Notice Copyright (c) 1985, 1987, 1989, 1990, 1993, 1997 Adobe Systems Incorporated.  All Rights Reserved.Times is a trademark of Linotype-Hell AG and/or its subsidiaries.
EncodingScheme AdobeStandardEncoding
CapHeight 669
XHeight 462
Ascender 683
Descender -217
StdHW 42
StdVW 121
StartCharMetrics 315
C 32 ; WX 250 ; N space ; B 0 0 0 0 ;
C 33 ; WX 389 ; N exclam ; B 67 -13 370 684 ;
C 34 ; WX 555 ; N quotedbl ; B 136 398 536 685 ;
C 35 ; WX 500 ; N numbersign ; B -33 0 533 700 ;
C 36 ; WX 500 ; N dollar ; B -20 -100 497 733 ;
C 37 ; WX 833 ; N percent ; B 39 -10 793 692 ;
C 38 ; WX 778 ; N ampersand ; B 5 -19 699 682 ;
C 39 ; WX 333 ; N quoteright ; B 98 369 302 685 ;
C 40 ; WX 333 ; N parenleft ; B 28 -179 344 685 ;
C 41 ; WX 333 ; N parenright ; B -44 -179 271 685 ;
C 42 ; WX 500 ; N asterisk ; B 65 249 456 685 ;
C 43 ; WX 570 ; N plus ; B 33 0 537 506 ;
C 44 ; WX 250 ; N comma ; B -60 -182 144 134 ;
C 45 ; WX 333 ; N hyphen ; B 2 166 271 282 ;
C 46 ; WX 250 ; N period ; B -9 -13 139 135 ;
C 47 ; WX 278 ; N slash ; B -64 -18 342 685 ;
C 48 ; WX 500 ; N zero ; B 17 -14 477 683 ;
C 49 ; WX 500 ; N one ; B 5 0 419 683 ;
C 50 ; WX 500 ; N two ; B -27 0 446 683 ;
C 51 ; WX 500 ; N three ; B -15 -13 450 683 ;
C 52 ; WX 500 ; N four ; B -15 0 503 683 ;
C 53 ; WX 500 ; N five ; B -11 -13 487 669 ;
C 54 ; WX 500 ; N six ; B 23 -15 509 679 ;
C 55 ; WX 500 ; N seven ; B 52 0 525 669 ;
C 56 ; WX 500 ; N eight ; B 3 -13 476 683 ;
C 57 ; WX 500 ; N nine ; B -12 -10 475 683 ;
C 58 ; WX 333 ; N colon ; B 23 -13 264 459 ;
C 59 ; WX 333 ; N semicolon ; B -25 -183 264 459 ;
C 60 ; WX 570 ; N less ; B 31 -8 539 514 ;
C 61 ; WX 570 ; N equal ; B 33 107 537 399 ;
C 62 ; WX 570 ; N greater ; B 31 -8 539 514 ;
C 63 ; WX 500 ; N question ; B 79 -13 470 684 ;
C 64 ; WX 832 ; N at ; B 63 -18 770 685 ;
C 65 ; WX 667 ; N A ; B -67 0 593 683 ;
C 66 ; WX 667 ; N B ; B -24 0 624 669 ;
C 67 ; WX 667 ; N C ; B 32 -18 677 685 ;
C 68 ; WX 722 ; N D ; B -46 0 685 669 ;
C 69 ; WX 667 ; N E ; B -27 0 653 669 ;
C 70 ; WX 667 ; N F ; B -13 0 660 669 ;
C 71 ; WX 722 ; N G ; B 21 -18 706 685 ;
C 72 ; WX 778 ; N H ; B -24 0 799 669 ;
C 73 ; WX 389 ; N I ; B -32 0 406 669 ;
C 74 ; WX 500 ; N J ; B -46 -99 524 669 ;
C 75 ; WX 667 ; N K ; B -21 0 702 669 ;
C 76 ; WX 611 ; N L ; B -22 0 590 669 ;
C 77 ; WX 889 ; N M ; B -29 -12 917 669 ;
C 78 ; WX 722 ; N N ; B -27 -15 748 669 ;
C 79 ; WX 722 ; N O ; B 27 -18 691 685 ;
C 80 ; WX 611 ; N P ; B -27 0 613 669 ;
C 81 ; WX 722 ; N Q ; B 27 -208 691 685 ;
C 82 ; WX 667 ; N R ; B -29 0 623 669 ;
C 83 ; WX 556 ; N S ; B 2 -18 526 685 ;
C 84 ; WX 611 ; N T ; B 50 0 650 669 ;
C 85 ; WX 722 ; N U ; B 67 -18 744 669 ;
C 86 ; WX 667 ; N V ; B 65 -18 715 669 ;
C 87 ; WX 889 ; N W ; B 65 -18 940 669 ;
C 88 ; WX 667 ; N X ; B -24 0 694 669 ;
C 89 ; WX 611 ; N Y ; B 73 0 659 669 ;
C 90 ; WX 611 ; N Z ; B -11 0 590 669 ;
C 91 ; WX 333 ; N bracketleft ; B -37 -159 362 674 ;
C 92 ; WX 278 ; N backslash ; B -1 -18 279 685 ;
C 93 ; WX 333 ; N bracketright ; B -56 -157 343 674 ;
C 94 ; WX 570 ; N asciicircum ; B 67 304 503 669 ;
C 95 ; WX 500 ; N underscore ; B 0 -125 500 -75 ;
C 96 ; WX 333 ; N quoteleft ; B 128 369 332 685 ;
C 97 ; WX 500 ; N a ; B -21 -14 455 462 ;
C 98 ; WX 500 ; N b ; B -14 -13 444 699 ;
C 99 ; WX 444 ; N c ; B -5 -13 392 462 ;
C 100 ; WX 500 ; N d ; B -21 -13 517 699 ;
C 101 ; WX 444 ; N e ; B 5 -13 398 462 ;
C 102 ; WX 333 ; N f ; B -169 -205 446 698 ; L i fi ; L l fl ;
C 103 ; WX 500 ; N g ; B -52 -203 478 462 ;
C 104 ; WX 556 ; N h ; B -13 -9 498 699 ;
C 105 ; WX 278 ; N i ; B 2 -9 263 684 ;
C 106 ; WX 278 ; N j ; B -189 -207 279 684 ;
C 107 ; WX 500 ; N k ; B -23 -8 483 699 ;
C 108 ; WX 278 ; N l ; B 2 -9 290 699 ;
C 109 ; WX 778 ; N m ; B -14 -9 722 462 ;
C 110 ; WX 556 ; N n ; B -6 -9 493 462 ;
C 111 ; WX 500 ; N o ; B -3 -13 441 462 ;
C 112 ; WX 500 ; N p ; B -120 -205 446 462 ;
C 113 ; WX 500 ; N q ; B 1 -205 471 462 ;
C 114 ; WX 389 ; N r ; B -21 0 389 462 ;
C 115 ; WX 389 ; N s ; B -19 -13 333 462 ;
C 116 ; WX 278 ; N t ; B -11 -9 281 594 ;
C 117 ; WX 556 ; N u ; B 15 -9 492 462 ;
C 118 ; WX 444 ; N v ; B 16 -13 401 462 ;
C 119 ; WX 667 ; N w ; B 16 -13 614 462 ;
C 120 ; WX 500 ; N x ; B -46 -13 469 462 ;
C 121 ; WX 444 ; N y ; B -94 -205 392 462 ;
C 122 ; WX 389 ; N z ; B -43 -78 368 449 ;
C 123 ; WX 348 ; N braceleft ; B 5 -187 436 686 ;
C 124 ; WX 220 ; N bar ; B 66 -218 154 782 ;
C 125 ; WX 348 ; N braceright ; B -129 -187 302 686 ;
C 126 ; WX 570 ; N asciitilde ; B 54 173 516 333 ;
C 161 ; WX 389 ; N exclamdown ; B 19 -205 322 492 ;
C 162 ; WX 500 ; N cent ; B 42 -143 439 576 ;
C 163 ; WX 500 ; N sterling ; B -32 -12 510 683 ;
C 164 ; WX 167 ; N fraction ; B -169 -14 324 683 ;
C 165 ; WX 500 ; N yen ; B 33 0 628 669 ;
C 166 ; WX 500 ; N florin ; B -87 -156 537 707 ;
C 167 ; WX 500 ; N section ; B 36 -143 459 685 ;
C 168 ; WX 500 ; N currency ; B -26 34 526 586 ;
C 169 ; WX 278 ; N quotesingle ; B 128 398 268 685 ;
C 170 ; WX 500 ; N quotedblleft ; B 53 369 513 685 ;
C 171 ; WX 500 ; N guillemotleft ; B 12 32 468 415 ;
C 172 ; WX 333 ; N guilsinglleft ; B 32 32 303 415 ;
C 173 ; WX 333 ; N guilsinglright ; B 10 32 281 415 ;
C 174 ; WX 556 ; N fi ; B -188 -205 514 703 ;
C 175 ; WX 556 ; N fl ; B -186 -205 553 704 ;
C 177 ; WX 500 ; N endash ; B -40 178 477 269 ;
C 178 ; WX 500 ; N dagger ; B 91 -145 494 685 ;
C 179 ; WX 500 ; N daggerdbl ; B 10 -139 493 685 ;
C 180 ; WX 250 ; N periodcentered ; B 51 257 199 405 ;
C 182 ; WX 500 ; N paragraph ; B -57 -193 562 669 ;
C 183 ; WX 350 ; N bullet ; B 0 175 350 525 ;
C 184 ; WX 333 ; N quotesinglbase ; B -5 -182 199 134 ;
C 185 ; WX 500 ; N quotedblbase ; B -57 -182 403 134 ;
C 186 ; WX 500 ; N quotedblright ; B 53 369 513 685 ;
C 187 ; WX 500 ; N guillemotright ; B 12 32 468 415 ;
C 188 ; WX 1000 ; N ellipsis ; B 40 -13 852 135 ;
C 189 ; WX 1000 ; N perthousand ; B 7 -29 996 706 ;
C 191 ; WX 500 ; N questiondown ; B 30 -205 421 492 ;
C 193 ; WX 333 ; N grave ; B 85 516 297 697 ;
C 194 ; WX 333 ; N acute ; B 139 516 379 697 ;
C 195 ; WX 333 ; N circumflex ; B 40 516 367 690 ;
C 196 ; WX 333 ; N tilde ; B 48 536 407 655 ;
C 197 ; WX 333 ; N macron ; B 51 553 393 623 ;
C 198 ; WX 333 ; N breve ; B 71 516 387 678 ;
C 199 ; WX 333 ; N dotaccent ; B 163 550 298 684 ;
C 200 ; WX 333 ; N dieresis ; B 55 550 402 684 ;
C 202 ; WX 333 ; N ring ; B 127 516 340 729 ;
C 203 ; WX 333 ; N cedilla ; B -80 -218 156 5 ;
C 205 ; WX 333 ; N hungarumlaut ; B 69 516 498 697 ;
C 206 ; WX 333 ; N ogonek ; B 15 -183 244 34 ;
C 207 ; WX 333 ; N caron ; B 79 516 411 690 ;
C 208 ; WX 1000 ; N emdash ; B -40 178 977 269 ;
C 225 ; WX 944 ; N AE ; B -64 0 918 669 ;
C 227 ; WX 266 ; N ordfeminine ; B 16 399 330 685 ;
C 232 ; WX 611 ; N Lslash ; B -22 0 590 669 ;
C 233 ; WX 722 ; N Oslash ; B 27 -125 691 764 ;
C 234 ; WX 944 ; N OE ; B 23 -8 946 677 ;
C 235 ; WX 300 ; N ordmasculine ; B 56 400 347 685 ;
C 241 ; WX 722 ; N ae ; B -5 -13 673 462 ;
C 245 ; WX 278 ; N dotlessi ; B 2 -9 238 462 ;
C 248 ; WX 278 ; N lslash ; B -7 -9 307 699 ;
C 249 ; WX 500 ; N oslash ; B -3 -119 441 560 ;
C 250 ; WX 722 ; N oe ; B 6 -13 674 462 ;
C 251 ; WX 500 ; N germandbls ; B -200 -200 473 705 ;
C -1 ; WX 389 ; N Idieresis ; B -32 0 450 862 ;
C -1 ; WX 444 ; N eacute ; B 5 -13 435 697 ;
C -1 ; WX 500 ; N abreve ; B -21 -14 471 678 ;
C -1 ; WX 556 ; N uhungarumlaut ; B 15 -9 610 697 ;
C -1 ; WX 444 ; N ecaron ; B 5 -13 467 690 ;
C -1 ; WX 611 ; N Ydieresis ; B 73 0 659 862 ;
C -1 ; WX 570 ; N divide ; B 33 -29 537 535 ;
C -1 ; WX 611 ; N Yacute ; B 73 0 659 904 ;
C -1 ; WX 667 ; N Acircumflex ; B -67 0 593 897 ;
C -1 ; WX 500 ; N aacute ; B -21 -14 463 697 ;
C -1 ; WX 722 ; N Ucircumflex ; B 67 -18 744 897 ;
C -1 ; WX 444 ; N yacute ; B -94 -205 435 697 ;
C -1 ; WX 389 ; N scommaaccent ; B -19 -218 333 462 ;
C -1 ; WX 444 ; N ecircumflex ; B 5 -13 423 690 ;
C -1 ; WX 722 ; N Uring ; B 67 -18 744 921 ;
C -1 ; WX 722 ; N Udieresis ; B 67 -18 744 862 ;
C -1 ; WX 500 ; N aogonek ; B -21 -183 455 462 ;
C -1 ; WX 722 ; N Uacute ; B 67 -18 744 904 ;
C -1 ; WX 556 ; N uogonek ; B 15 -183 492 462 ;
C -1 ; WX 667 ; N Edieresis ; B -27 0 653 862 ;
C -1 ; WX 722 ; N Dcroat ; B -31 0 700 669 ;
C -1 ; WX 250 ; N commaaccent ; B -36 -218 131 -50 ;
C -1 ; WX 747 ; N copyright ; B 30 -18 718 685 ;
C -1 ; WX 667 ; N Emacron ; B -27 0 653 830 ;
C -1 ; WX 444 ; N ccaron ; B -5 -13 467 690 ;
C -1 ; WX 500 ; N aring ; B -21 -14 455 729 ;
C -1 ; WX 722 ; N Ncommaaccent ; B -27 -218 748 669 ;
C -1 ; WX 278 ; N lacute ; B 2 -9 392 904 ;
C -1 ; WX 500 ; N agrave ; B -21 -14 455 697 ;
C -1 ; WX 611 ; N Tcommaaccent ; B 50 -218 650 669 ;
C -1 ; WX 667 ; N Cacute ; B 32 -18 677 904 ;
C -1 ; WX 500 ; N atilde ; B -21 -14 491 655 ;
C -1 ; WX 667 ; N Edotaccent ; B -27 0 653 862 ;
C -1 ; WX 389 ; N scaron ; B -19 -13 424 690 ;
C -1 ; WX 389 ; N scedilla ; B -19 -218 333 462 ;
C -1 ; WX 278 ; N iacute ; B 2 -9 352 697 ;
C -1 ; WX 494 ; N lozenge ; B 10 0 484 745 ;
C -1 ; WX 667 ; N Rcaron ; B -29 0 623 897 ;
C -1 ; WX 722 ; N Gcommaaccent ; B 21 -218 706 685 ;
C -1 ; WX 556 ; N ucircumflex ; B 15 -9 492 690 ;
C -1 ; WX 500 ; N acircumflex ; B -21 -14 455 690 ;
C -1 ; WX 667 ; N Amacron ; B -67 0 593 830 ;
C -1 ; WX 389 ; N rcaron ; B -21 0 424 690 ;
C -1 ; WX 444 ; N ccedilla ; B -5 -218 392 462 ;
C -1 ; WX 611 ; N Zdotaccent ; B -11 0 590 862 ;
C -1 ; WX 611 ; N Thorn ; B -27 0 573 669 ;
C -1 ; WX 722 ; N Omacron ; B 27 -18 691 830 ;
C -1 ; WX 667 ; N Racute ; B -29 0 623 904 ;
C -1 ; WX 556 ; N Sacute ; B 2 -18 531 904 ;
C -1 ; WX 608 ; N dcaron ; B -21 -13 675 708 ;
C -1 ; WX 722 ; N Umacron ; B 67 -18 744 830 ;
C -1 ; WX 556 ; N uring ; B 15 -9 492 729 ;
C -1 ; WX 300 ; N threesuperior ; B 17 265 321 683 ;
C -1 ; WX 722 ; N Ograve ; B 27 -18 691 904 ;
C -1 ; WX 667 ; N Agrave ; B -67 0 593 904 ;
C -1 ; WX 667 ; N Abreve ; B -67 0 593 885 ;
C -1 ; WX 570 ; N multiply ; B 48 16 522 490 ;
C -1 ; WX 556 ; N uacute ; B 15 -9 492 697 ;
C -1 ; WX 611 ; N Tcaron ; B 50 0 650 897 ;
C -1 ; WX 494 ; N partialdiff ; B 11 -21 494 750 ;
C -1 ; WX 444 ; N ydieresis ; B -94 -205 443 655 ;
C -1 ; WX 722 ; N Nacute ; B -27 -15 748 904 ;
C -1 ; WX 278 ; N icircumflex ; B -3 -9 324 690 ;
C -1 ; WX 667 ; N Ecircumflex ; B -27 0 653 897 ;
C -1 ; WX 500 ; N adieresis ; B -21 -14 476 655 ;
C -1 ; WX 444 ; N edieresis ; B 5 -13 448 655 ;
C -1 ; WX 444 ; N cacute ; B -5 -13 435 697 ;
C -1 ; WX 556 ; N nacute ; B -6 -9 493 697 ;
C -1 ; WX 556 ; N umacron ; B 15 -9 492 623 ;
C -1 ; WX 722 ; N Ncaron ; B -27 -15 748 897 ;
C -1 ; WX 389 ; N Iacute ; B -32 0 432 904 ;
C -1 ; WX 570 ; N plusminus ; B 33 0 537 506 ;
C -1 ; WX 220 ; N brokenbar ; B 66 -143 154 707 ;
C -1 ; WX 747 ; N registered ; B 30 -18 718 685 ;
C -1 ; WX 722 ; N Gbreve ; B 21 -18 706 885 ;
C -1 ; WX 389 ; N Idotaccent ; B -32 0 406 862 ;
C -1 ; WX 600 ; N summation ; B 14 -10 585 706 ;
C -1 ; WX 667 ; N Egrave ; B -27 0 653 904 ;
C -1 ; WX 389 ; N racute ; B -21 0 407 697 ;
C -1 ; WX 500 ; N omacron ; B -3 -13 462 623 ;
C -1 ; WX 611 ; N Zacute ; B -11 0 590 904 ;
C -1 ; WX 611 ; N Zcaron ; B -11 0 590 897 ;
C -1 ; WX 549 ; N greaterequal ; B 26 0 523 704 ;
C -1 ; WX 722 ; N Eth ; B -31 0 700 669 ;
C -1 ; WX 667 ; N Ccedilla ; B 32 -218 677 685 ;
C -1 ; WX 278 ; N lcommaaccent ; B -42 -218 290 699 ;
C -1 ; WX 366 ; N tcaron ; B -11 -9 434 754 ;
C -1 ; WX 444 ; N eogonek ; B 5 -183 398 462 ;
C -1 ; WX 722 ; N Uogonek ; B 67 -183 744 669 ;
C -1 ; WX 667 ; N Aacute ; B -67 0 593 904 ;
C -1 ; WX 667 ; N Adieresis ; B -67 0 593 862 ;
C -1 ; WX 444 ; N egrave ; B 5 -13 398 697 ;
C -1 ; WX 389 ; N zacute ; B -43 -78 407 697 ;
C -1 ; WX 278 ; N iogonek ; B -20 -183 263 684 ;
C -1 ; WX 722 ; N Oacute ; B 27 -18 691 904 ;
C -1 ; WX 500 ; N oacute ; B -3 -13 463 697 ;
C -1 ; WX 500 ; N amacron ; B -21 -14 467 623 ;
C -1 ; WX 389 ; N sacute ; B -19 -13 407 697 ;
C -1 ; WX 278 ; N idieresis ; B 2 -9 364 655 ;
C -1 ; WX 722 ; N Ocircumflex ; B 27 -18 691 897 ;
C -1 ; WX 722 ; N Ugrave ; B 67 -18 744 904 ;
C -1 ; WX 612 ; N Delta ; B 6 0 608 688 ;
C -1 ; WX 500 ; N thorn ; B -120 -205 446 699 ;
C -1 ; WX 300 ; N twosuperior ; B 2 274 313 683 ;
C -1 ; WX 722 ; N Odieresis ; B 27 -18 691 862 ;
C -1 ; WX 576 ; N mu ; B -60 -207 516 449 ;
C -1 ; WX 278 ; N igrave ; B 2 -9 259 697 ;
C -1 ; WX 500 ; N ohungarumlaut ; B -3 -13 582 697 ;
C -1 ; WX 667 ; N Eogonek ; B -27 -183 653 669 ;
C -1 ; WX 500 ; N dcroat ; B -21 -13 552 699 ;
C -1 ; WX 750 ; N threequarters ; B 7 -14 726 683 ;
C -1 ; WX 556 ; N Scedilla ; B 2 -218 526 685 ;
C -1 ; WX 382 ; N lcaron ; B 2 -9 448 708 ;
C -1 ; WX 667 ; N Kcommaaccent ; B -21 -218 702 669 ;
C -1 ; WX 611 ; N Lacute ; B -22 0 590 904 ;
C -1 ; WX 1000 ; N trademark ; B 32 263 968 669 ;
C -1 ; WX 444 ; N edotaccent ; B 5 -13 398 655 ;
C -1 ; WX 389 ; N Igrave ; B -32 0 406 904 ;
C -1 ; WX 389 ; N Imacron ; B -32 0 461 830 ;
C -1 ; WX 611 ; N Lcaron ; B -22 0 671 718 ;
C -1 ; WX 750 ; N onehalf ; B -9 -14 723 683 ;
C -1 ; WX 549 ; N lessequal ; B 29 0 526 704 ;
C -1 ; WX 500 ; N ocircumflex ; B -3 -13 451 690 ;
C -1 ; WX 556 ; N ntilde ; B -6 -9 504 655 ;
C -1 ; WX 722 ; N Uhungarumlaut ; B 67 -18 744 904 ;
C -1 ; WX 667 ; N Eacute ; B -27 0 653 904 ;
C -1 ; WX 444 ; N emacron ; B 5 -13 439 623 ;
C -1 ; WX 500 ; N gbreve ; B -52 -203 478 678 ;
C -1 ; WX 750 ; N onequarter ; B 7 -14 721 683 ;
C -1 ; WX 556 ; N Scaron ; B 2 -18 553 897 ;
C -1 ; WX 556 ; N Scommaaccent ; B 2 -218 526 685 ;
C -1 ; WX 722 ; N Ohungarumlaut ; B 27 -18 723 904 ;
C -1 ; WX 400 ; N degree ; B 83 397 369 683 ;
C -1 ; WX 500 ; N ograve ; B -3 -13 441 697 ;
C -1 ; WX 667 ; N Ccaron ; B 32 -18 677 897 ;
C -1 ; WX 556 ; N ugrave ; B 15 -9 492 697 ;
C -1 ; WX 549 ; N radical ; B 10 -46 512 850 ;
C -1 ; WX 722 ; N Dcaron ; B -46 0 685 897 ;
C -1 ; WX 389 ; N rcommaaccent ; B -67 -218 389 462 ;
C -1 ; WX 722 ; N Ntilde ; B -27 -15 748 862 ;
C -1 ; WX 500 ; N otilde ; B -3 -13 491 655 ;
C -1 ; WX 667 ; N Rcommaaccent ; B -29 -218 623 669 ;
C -1 ; WX 611 ; N Lcommaaccent ; B -22 -218 590 669 ;
C -1 ; WX 667 ; N Atilde ; B -67 0 593 862 ;
C -1 ; WX 667 ; N Aogonek ; B -67 -183 604 683 ;
C -1 ; WX 667 ; N Aring ; B -67 0 593 921 ;
C -1 ; WX 722 ; N Otilde ; B 27 -18 691 862 ;
C -1 ; WX 389 ; N zdotaccent ; B -43 -78 368 655 ;
C -1 ; WX 667 ; N Ecaron ; B -27 0 653 897 ;
C -1 ; WX 389 ; N Iogonek ; B -32 -183 406 669 ;
C -1 ; WX 500 ; N kcommaaccent ; B -23 -218 483 699 ;
C -1 ; WX 606 ; N minus ; B 51 209 555 297 ;
C -1 ; WX 389 ; N Icircumflex ; B -32 0 450 897 ;
C -1 ; WX 556 ; N ncaron ; B -6 -9 523 690 ;
C -1 ; WX 278 ; N tcommaaccent ; B -62 -218 281 594 ;
C -1 ; WX 606 ; N logicalnot ; B 51 108 555 399 ;
C -1 ; WX 500 ; N odieresis ; B -3 -13 471 655 ;
C -1 ; WX 556 ; N udieresis ; B 15 -9 499 655 ;
C -1 ; WX 549 ; N notequal ; B 15 -49 540 570 ;
C -1 ; WX 500 ; N gcommaaccent ; B -52 -203 478 767 ;
C -1 ; WX 500 ; N eth ; B -3 -13 454 699 ;
C -1 ; WX 389 ; N zcaron ; B -43 -78 424 690 ;
C -1 ; WX 556 ; N ncommaaccent ; B -6 -218 493 462 ;
C -1 ; WX 300 ; N onesuperior ; B 30 274 301 683 ;
C -1 ; WX 278 ; N imacron ; B 2 -9 294 623 ;
C -1 ; WX 500 ; N Euro ; B 0 0 0 0 ;
EndCharMetrics
StartKernData
StartKernPairs 2038
KPX A C -65
KPX A Cacute -65
KPX A Ccaron -65
KPX A Ccedilla -65
KPX A G -60
KPX A Gbreve -60
KPX A Gcommaaccent -60
KPX A O -50
KPX A Oacute -50
KPX A Ocircumflex -50
KPX A Odieresis -50
KPX A Ograve -50
KPX A Ohungarumlaut -50
KPX A Omacron -50
KPX A Oslash -50
KPX A Otilde -50
KPX A Q -55
KPX A T -55
KPX A Tcaron -55
KPX A Tcommaaccent -55
KPX A U -50
KPX A Uacute -50
KPX A Ucircumflex -50
KPX A Udieresis -50
KPX A Ugrave -50
KPX A Uhungarumlaut -50
KPX A Umacron -50
KPX A Uogonek -50
KPX A Uring -50
KPX A V -95
KPX A W -100
KPX A Y -70
KPX A Yacute -70
KPX A Ydieresis -70
KPX A quoteright -74
KPX A u -30
KPX A uacute -30
KPX A ucircumflex -30
KPX A udieresis -30
KPX A ugrave -30
KPX A uhungarumlaut -30
KPX A umacron -30
KPX A uogonek -30
KPX A uring -30
KPX A v -74
KPX A w -74
KPX A y -74
KPX A yacute -74
KPX A ydieresis -74
KPX Aacute C -65
KPX Aacute Cacute -65
KPX Aacute Ccaron -65
KPX Aacute Ccedilla -65
KPX Aacute G -60
KPX Aacute Gbreve -60
KPX Aacute Gcommaaccent -60
KPX Aacute O -50
KPX Aacute Oacute -50
KPX Aacute Ocircumflex -50
KPX Aacute Odieresis -50
KPX Aacute Ograve -50
KPX Aacute Ohungarumlaut -50
KPX Aacute Omacron -50
KPX Aacute Oslash -50
KPX Aacute Otilde -50
KPX Aacute Q -55
KPX Aacute T -55
KPX Aacute Tcaron -55
KPX Aacute Tcommaaccent -55
KPX Aacute U -50
KPX Aacute Uacute -50
KPX Aacute Ucircumflex -50
KPX Aacute Udieresis -50
KPX Aacute Ugrave -50
KPX Aacute Uhungarumlaut -50
KPX Aacute Umacron -50
KPX Aacute Uogonek -50
KPX Aacute Uring -50
KPX Aacute V -95
KPX Aacute W -100
KPX Aacute Y -70
KPX Aacute Yacute -70
KPX Aacute Ydieresis -70
KPX Aacute quoteright -74
KPX Aacute u -30
KPX Aacute uacute -30
KPX Aacute ucircumflex -30
KPX Aacute udieresis -30
KPX Aacute ugrave -30
KPX Aacute uhungarumlaut -30
KPX Aacute umacron -30
KPX Aacute uogonek -30
KPX Aacute uring -30
KPX Aacute v -74
KPX Aacute w -74
KPX Aacute y -74
KPX Aacute yacute -74
KPX Aacute ydieresis -74
KPX Abreve C -65
KPX Abreve Cacute -65
KPX Abreve Ccaron -65
KPX Abreve Ccedilla -65
KPX Abreve G -60
KPX Abreve Gbreve -60
KPX Abreve Gcommaaccent -60
KPX Abreve O -50
KPX Abreve Oacute -50
KPX Abreve Ocircumflex -50
KPX Abreve Odieresis -50
KPX Abreve Ograve -50
KPX Abreve Ohungarumlaut -50
KPX Abreve Omacron -50
KPX Abreve Oslash -50
KPX Abreve Otilde -50
KPX Abreve Q -55
KPX Abreve T -55
KPX Abreve Tcaron -55
KPX Abreve Tcommaaccent -55
KPX Abreve U -50
KPX Abreve Uacute -50
KPX Abreve Ucircumflex -50
KPX Abreve Udieresis -50
KPX Abreve Ugrave -50
KPX Abreve Uhungarumlaut -50
KPX Abreve Umacron -50
KPX Abreve Uogonek -50
KPX Abreve Uring -50
KPX Abreve V -95
KPX Abreve W -100
KPX Abreve Y -70
KPX Abreve Yacute -70
KPX Abreve Ydieresis -70
KPX Abreve quoteright -74
KPX Abreve u -30
KPX Abreve uacute -30
KPX Abreve ucircumflex -30
KPX Abreve udieresis -30
KPX Abreve ugrave -30
KPX Abreve uhungarumlaut -30
KPX Abreve umacron -30
KPX Abreve uogonek -30
KPX Abreve uring -30
KPX Abreve v -74
KPX Abreve w -74
KPX Abreve y -74
KPX Abreve yacute -74
KPX Abreve ydieresis -74
KPX Acircumflex C -65
KPX Acircumflex Cacute -65
KPX Acircumflex Ccaron -65
KPX Acircumflex Ccedilla -65
KPX Acircumflex G -60
KPX Acircumflex Gbreve -60
KPX Acircumflex Gcommaaccent -60
KPX Acircumflex O -50
KPX Acircumflex Oacute -50
KPX Acircumflex Ocircumflex -50
KPX Acircumflex Odieresis -50
KPX Acircumflex Ograve -50
KPX Acircumflex Ohungarumlaut -50
KPX Acircumflex Omacron -50
KPX Acircumflex Oslash -50
KPX Acircumflex Otilde -50
KPX Acircumflex Q -55
KPX Acircumflex T -55
KPX Acircumflex Tcaron -55
KPX Acircumflex Tcommaaccent -55
KPX Acircumflex U -50
KPX Acircumflex Uacute -50
KPX Acircumflex Ucircumflex -50
KPX Acircumflex Udieresis -50
KPX Acircumflex Ugrave -50
KPX Acircumflex Uhungarumlaut -50
KPX Acircumflex Umacron -50
KPX Acircumflex Uogonek -50
KPX Acircumflex Uring -50
KPX Acircumflex V -95
KPX Acircumflex W -100
KPX Acircumflex Y -70
KPX Acircumflex Yacute -70
KPX Acircumflex Ydieresis -70
KPX Acircumflex quoteright -74
KPX Acircumflex u -30
KPX Acircumflex uacute -30
KPX Acircumflex ucircumflex -30
KPX Acircumflex udieresis -30
KPX Acircumflex ugrave -30
KPX Acircumflex uhungarumlaut -30
KPX Acircumflex umacron -30
KPX Acircumflex uogonek -30
KPX Acircumflex uring -30
KPX Acircumflex v -74
KPX Acircumflex w -74
KPX Acircumflex y -74
KPX Acircumflex yacute -74
KPX Acircumflex ydieresis -74
KPX Adieresis C -65
KPX Adieresis Cacute -65
KPX Adieresis Ccaron -65
KPX Adieresis Ccedilla -65
KPX Adieresis G -60
KPX Adieresis Gbreve -60
KPX Adieresis Gcommaaccent -60
KPX Adieresis O -50
KPX Adieresis Oacute -50
KPX Adieresis Ocircumflex -50
KPX Adieresis Odieresis -50
KPX Adieresis Ograve -50
KPX Adieresis Ohungarumlaut -50
KPX Adieresis Omacron -50
KPX Adieresis Oslash -50
KPX Adieresis Otilde -50
KPX Adieresis Q -55
KPX Adieresis T -55
KPX Adieresis Tcaron -55
KPX Adieresis Tcommaaccent -55
KPX Adieresis U -50
KPX Adieresis Uacute -50
KPX Adieresis Ucircumflex -50
KPX Adieresis Udieresis -50
KPX Adieresis Ugrave -50
KPX Adieresis Uhungarumlaut -50
KPX Adieresis Umacron -50
KPX Adieresis Uogonek -50
KPX Adieresis Uring -50
KPX Adieresis V -95
KPX Adieresis W -100
KPX Adieresis Y -70
KPX Adieresis Yacute -70
KPX Adieresis Ydieresis -70
KPX Adieresis quoteright -74
KPX Adieresis u -30
KPX Adieresis uacute -30
KPX Adieresis ucircumflex -30
KPX Adieresis udieresis -30
KPX Adieresis ugrave -30
KPX Adieresis uhungarumlaut -30
KPX Adieresis umacron -30
KPX Adieresis uogonek -30
KPX Adieresis uring -30
KPX Adieresis v -74
KPX Adieresis w -74
KPX Adieresis y -74
KPX Adieresis yacute -74
KPX Adieresis ydieresis -74
KPX Agrave C -65
KPX Agrave Cacute -65
KPX Agrave Ccaron -65
KPX Agrave Ccedilla -65
KPX Agrave G -60
KPX Agrave Gbreve -60
KPX Agrave Gcommaaccent -60
KPX Agrave O -50
KPX Agrave Oacute -50
KPX Agrave Ocircumflex -50
KPX Agrave Odieresis -50
KPX Agrave Ograve -50
KPX Agrave Ohungarumlaut -50
KPX Agrave Omacron -50
KPX Agrave Oslash -50
KPX Agrave Otilde -50
KPX Agrave Q -55
KPX Agrave T -55
KPX Agrave Tcaron -55
KPX Agrave Tcommaaccent -55
KPX Agrave U -50
KPX Agrave Uacute -50
KPX Agrave Ucircumflex -50
KPX Agrave Udieresis -50
KPX Agrave Ugrave -50
KPX Agrave Uhungarumlaut -50
KPX Agrave Umacron -50
KPX Agrave Uogonek -50
KPX Agrave Uring -50
KPX Agrave V -95
KPX Agrave W -100
KPX Agrave Y -70
KPX Agrave Yacute -70
KPX Agrave Ydieresis -70
KPX Agrave quoteright -74
KPX Agrave u -30
KPX Agrave uacute -30
KPX Agrave ucircumflex -30
KPX Agrave udieresis -30
KPX Agrave ugrave -30
KPX Agrave uhungarumlaut -30
KPX Agrave umacron -30
KPX Agrave uogonek -30
KPX Agrave uring -30
KPX Agrave v -74
KPX Agrave w -74
KPX Agrave y -74
KPX Agrave yacute -74
KPX Agrave ydieresis -74
KPX Amacron C -65
KPX Amacron Cacute -65
KPX Amacron Ccaron -65
KPX Amacron Ccedilla -65
KPX Amacron G -60
KPX Amacron Gbreve -60
KPX Amacron Gcommaaccent -60
KPX Amacron O -50
KPX Amacron Oacute -50
KPX Amacron Ocircumflex -50
KPX Amacron Odieresis -50
KPX Amacron Ograve -50
KPX Amacron Ohungarumlaut -50
KPX Amacron Omacron -50
KPX Amacron Oslash -50
KPX Amacron Otilde -50
KPX Amacron Q -55
KPX Amacron T -55
KPX Amacron Tcaron -55
KPX Amacron Tcommaaccent -55
KPX Amacron U -50
KPX Amacron Uacute -50
KPX Amacron Ucircumflex -50
KPX Amacron Udieresis -50
KPX Amacron Ugrave -50
KPX Amacron Uhungarumlaut -50
KPX Amacron Umacron -50
KPX Amacron Uogonek -50
KPX Amacron Uring -50
KPX Amacron V -95
KPX Amacron W -100
KPX Amacron Y -70
KPX Amacron Yacute -70
KPX Amacron Ydieresis -70
KPX Amacron quoteright -74
KPX Amacron u -30
KPX Amacron uacute -30
KPX Amacron ucircumflex -30
KPX Amacron udieresis -30
KPX Amacron ugrave -30
KPX Amacron uhungarumlaut -30
KPX Amacron umacron -30
KPX Amacron uogonek -30
KPX Amacron uring -30
KPX Amacron v -74
KPX Amacron w -74
KPX Amacron y -74
KPX Amacron yacute -74
KPX Amacron ydieresis -74
KPX Aogonek C -65
KPX Aogonek Cacute -65
KPX Aogonek Ccaron -65
KPX Aogonek Ccedilla -65
KPX Aogonek G -60
KPX Aogonek Gbreve -60
KPX Aogonek Gcommaaccent -60
KPX Aogonek O -50
KPX Aogonek Oacute -50
KPX Aogonek Ocircumflex -50
KPX Aogonek Odieresis -50
KPX Aogonek Ograve -50
KPX Aogonek Ohungarumlaut -50
KPX Aogonek Omacron -50
KPX Aogonek Oslash -50
KPX Aogonek Otilde -50
KPX Aogonek Q -55
KPX Aogonek T -55
KPX Aogonek Tcaron -55
KPX Aogonek Tcommaaccent -55
KPX Aogonek U -50
KPX Aogonek Uacute -50
KPX Aogonek Ucircumflex -50
KPX Aogonek Udieresis -50
KPX Aogonek Ugrave -50
KPX Aogonek Uhungarumlaut -50
KPX Aogonek Umacron -50
KPX Aogonek Uogonek -50
KPX Aogonek Uring -50
KPX Aogonek V -95
KPX Aogonek W -100
KPX Aogonek Y -70
KPX Aogonek Yacute -70
KPX Aogonek Ydieresis -70
KPX Aogonek quoteright -74
KPX Aogonek u -30
KPX Aogonek uacute -30
KPX Aogonek ucircumflex -30
KPX Aogonek udieresis -30
KPX Aogonek ugrave -30
KPX Aogonek uhungarumlaut -30
KPX Aogonek umacron -30
KPX Aogonek uogonek -30
KPX Aogonek uring -30
KPX Aogonek v -74
KPX Aogonek w -74
KPX Aogonek y -34
KPX Aogonek yacute -34
KPX Aogonek ydieresis -34
KPX Aring C -65
KPX Aring Cacute -65
KPX Aring Ccaron -65
KPX Aring Ccedilla -65
KPX Aring G -60
KPX Aring Gbreve -60
KPX Aring Gcommaaccent -60
KPX Aring O -50
KPX Aring Oacute -50
KPX Aring Ocircumflex -50
KPX Aring Odieresis -50
KPX Aring Ograve -50
KPX Aring Ohungarumlaut -50
KPX Aring Omacron -50
KPX Aring Oslash -50
KPX Aring Otilde -50
KPX Aring Q -55
KPX Aring T -55
KPX Aring Tcaron -55
KPX Aring Tcommaaccent -55
KPX Aring U -50
KPX Aring Uacute -50
KPX Aring Ucircumflex -50
KPX Aring Udieresis -50
KPX Aring Ugrave -50
KPX Aring Uhungarumlaut -50
KPX Aring Umacron -50
KPX Aring Uogonek -50
KPX Aring Uring -50
KPX Aring V -95
KPX Aring W -100
KPX Aring Y -70
KPX Aring Yacute -70
KPX Aring Ydieresis -70
KPX Aring quoteright -74
KPX Aring u -30
KPX Aring uacute -30
KPX Aring ucircumflex -30
KPX Aring udieresis -30
KPX Aring ugrave -30
KPX Aring uhungarumlaut -30
KPX Aring umacron -30
KPX Aring uogonek -30
KPX Aring uring -30
KPX Aring v -74
KPX Aring w -74
KPX Aring y -74
KPX Aring yacute -74
KPX Aring ydieresis -74
KPX Atilde C -65
KPX Atilde Cacute -65
KPX Atilde Ccaron -65
KPX Atilde Ccedilla -65
KPX Atilde G -60
KPX Atilde Gbreve -60
KPX Atilde Gcommaaccent -60
KPX Atilde O -50
KPX Atilde Oacute -50
KPX Atilde Ocircumflex -50
KPX Atilde Odieresis -50
KPX Atilde Ograve -50
KPX Atilde Ohungarumlaut -50
KPX Atilde Omacron -50
KPX Atilde Oslash -50
KPX Atilde Otilde -50
KPX Atilde Q -55
KPX Atilde T -55
KPX Atilde Tcaron -55
KPX Atilde Tcommaaccent -55
KPX Atilde U -50
KPX Atilde Uacute -50
KPX Atilde Ucircumflex -50
KPX Atilde Udieresis -50
KPX Atilde Ugrave -50
KPX Atilde Uhungarumlaut -50
KPX Atilde Umacron -50
KPX Atilde Uogonek -50
KPX Atilde Uring -50
KPX Atilde V -95
KPX Atilde W -100
KPX Atilde Y -70
KPX Atilde Yacute -70
KPX Atilde Ydieresis -70
KPX Atilde quoteright -74
KPX Atilde u -30
KPX Atilde uacute -30
KPX Atilde ucircumflex -30
KPX Atilde udieresis -30
KPX Atilde ugrave -30
KPX Atilde uhungarumlaut -30
KPX Atilde umacron -30
KPX Atilde uogonek -30
KPX Atilde uring -30
KPX Atilde v -74
KPX Atilde w -74
KPX Atilde y -74
KPX Atilde yacute -74
KPX Atilde ydieresis -74
KPX B A -25
KPX B Aacute -25
KPX B Abreve -25
KPX B Acircumflex -25
KPX B Adieresis -25
KPX B Agrave -25
KPX B Amacron -25
KPX B Aogonek -25
KPX B Aring -25
KPX B Atilde -25
KPX B U -10
KPX B Uacute -10
KPX B Ucircumflex -10
KPX B Udieresis -10
KPX B Ugrave -10
KPX B Uhungarumlaut -10
KPX B Umacron -10
KPX B Uogonek -10
KPX B Uring -10
KPX D A -25
KPX D Aacute -25
KPX D Abreve -25
KPX D Acircumflex -25
KPX D Adieresis -25
KPX D Agrave -25
KPX D Amacron -25
KPX D Aogonek -25
KPX D Aring -25
KPX D Atilde -25
KPX D V -50
KPX D W -40
KPX D Y -50
KPX D Yacute -50
KPX D Ydieresis -50
KPX Dcaron A -25
KPX Dcaron Aacute -25
KPX Dcaron Abreve -25
KPX Dcaron Acircumflex -25
KPX Dcaron Adieresis -25
KPX Dcaron Agrave -25
KPX Dcaron Amacron -25
KPX Dcaron Aogonek -25
KPX Dcaron Aring -25
KPX Dcaron Atilde -25
KPX Dcaron V -50
KPX Dcaron W -40
KPX Dcaron Y -50
KPX Dcaron Yacute -50
KPX Dcaron Ydieresis -50
KPX Dcroat A -25
KPX Dcroat Aacute -25
KPX Dcroat Abreve -25
KPX Dcroat Acircumflex -25
KPX Dcroat Adieresis -25
KPX Dcroat Agrave -25
KPX Dcroat Amacron -25
KPX Dcroat Aogonek -25
KPX Dcroat Aring -25
KPX Dcroat Atilde -25
KPX Dcroat V -50
KPX Dcroat W -40
KPX Dcroat Y -50
KPX Dcroat Yacute -50
KPX Dcroat Ydieresis -50
KPX F A -100
KPX F Aacute -100
KPX F Abreve -100
KPX F Acircumflex -100
KPX F Adieresis -100
KPX F Agrave -100
KPX F Amacron -100
KPX F Aogonek -100
KPX F Aring -100
KPX F Atilde -100
KPX F a -95
KPX F aacute -95
KPX F abreve -95
KPX F acircumflex -95
KPX F adieresis -95
KPX F agrave -95
KPX F amacron -95
KPX F aogonek -95
KPX F aring -95
KPX F atilde -95
KPX F comma -129
KPX F e -100
KPX F eacute -100
KPX F ecaron -100
KPX F ecircumflex -100
KPX F edieresis -100
KPX F edotaccent -100
KPX F egrave -100
KPX F emacron -100
KPX F eogonek -100
KPX F i -40
KPX F iacute -40
KPX F icircumflex -40
KPX F idieresis -40
KPX F igrave -40
KPX F imacron -40
KPX F iogonek -40
KPX F o -70
KPX F oacute -70
KPX F ocircumflex -70
KPX F odieresis -70
KPX F ograve -70
KPX F ohungarumlaut -70
KPX F omacron -70
KPX F oslash -70
KPX F otilde -70
KPX F period -129
KPX F r -50
KPX F racute -50
KPX F rcaron -50
KPX F rcommaaccent -50
KPX J A -25
KPX J Aacute -25
KPX J Abreve -25
KPX J Acircumflex -25
KPX J Adieresis -25
KPX J Agrave -25
KPX J Amacron -25
KPX J Aogonek -25
KPX J Aring -25
KPX J Atilde -25
KPX J a -40
KPX J aacute -40
KPX J abreve -40
KPX J acircumflex -40
KPX J adieresis -40
KPX J agrave -40
KPX J amacron -40
KPX J aogonek -40
KPX J aring -40
KPX J atilde -40
KPX J comma -10
KPX J e -40
KPX J eacute -40
KPX J ecaron -40
KPX J ecircumflex -40
KPX J edieresis -40
KPX J edotaccent -40
KPX J egrave -40
KPX J emacron -40
KPX J eogonek -40
KPX J o -40
KPX J oacute -40
KPX J ocircumflex -40
KPX J odieresis -40
KPX J ograve -40
KPX J ohungarumlaut -40
KPX J omacron -40
KPX J oslash -40
KPX J otilde -40
KPX J period -10
KPX J u -40
KPX J uacute -40
KPX J ucircumflex -40
KPX J udieresis -40
KPX J ugrave -40
KPX J uhungarumlaut -40
KPX J umacron -40
KPX J uogonek -40
KPX J uring -40
KPX K O -30
KPX K Oacute -30
KPX K Ocircumflex -30
KPX K Odieresis -30
KPX K Ograve -30
KPX K Ohungarumlaut -30
KPX K Omacron -30
KPX K Oslash -30
KPX K Otilde -30
KPX K e -25
KPX K eacute -25
KPX K ecaron -25
KPX K ecircumflex -25
KPX K edieresis -25
KPX K edotaccent -25
KPX K egrave -25
KPX K emacron -25
KPX K eogonek -25
KPX K o -25
KPX K oacute -25
KPX K ocircumflex -25
KPX K odieresis -25
KPX K ograve -25
KPX K ohungarumlaut -25
KPX K omacron -25
KPX K oslash -25
KPX K otilde -25
KPX K u -20
KPX K uacute -20
KPX K ucircumflex -20
KPX K udieresis -20
KPX K ugrave -20
KPX K uhungarumlaut -20
KPX K umacron -20
KPX K uogonek -20
KPX K uring -20
KPX K y -20
KPX K yacute -20
KPX K ydieresis -20
KPX Kcommaaccent O -30
KPX Kcommaaccent Oacute -30
KPX Kcommaaccent Ocircumflex -30
KPX Kcommaaccent Odieresis -30
KPX Kcommaaccent Ograve -30
KPX Kcommaaccent Ohungarumlaut -30
KPX Kcommaaccent Omacron -30
KPX Kcommaaccent Oslash -30
KPX Kcommaaccent Otilde -30
KPX Kcommaaccent e -25
KPX Kcommaaccent eacute -25
KPX Kcommaaccent ecaron -25
KPX Kcommaaccent ecircumflex -25
KPX Kcommaaccent edieresis -25
KPX Kcommaaccent edotaccent -25
KPX Kcommaaccent egrave -25
KPX Kcommaaccent emacron -25
KPX Kcommaaccent eogonek -25
KPX Kcommaaccent o -25
KPX Kcommaaccent oacute -25
KPX Kcommaaccent ocircumflex -25
KPX Kcommaaccent odieresis -25
KPX Kcommaaccent ograve -25
KPX Kcommaaccent ohungarumlaut -25
KPX Kcommaaccent omacron -25
KPX Kcommaaccent oslash -25
KPX Kcommaaccent otilde -25
KPX Kcommaaccent u -20
KPX Kcommaaccent uacute -20
KPX Kcommaaccent ucircumflex -20
KPX Kcommaaccent udieresis -20
KPX Kcommaaccent ugrave -20
KPX Kcommaaccent uhungarumlaut -20
KPX Kcommaaccent umacron -20
KPX Kcommaaccent uogonek -20
KPX Kcommaaccent uring -20
KPX Kcommaaccent y -20
KPX Kcommaaccent yacute -20
KPX Kcommaaccent ydieresis -20
KPX L T -18
KPX L Tcaron -18
KPX L Tcommaaccent -18
KPX L V -37
KPX L W -37
KPX L Y -37
KPX L Yacute -37
KPX L Ydieresis -37
KPX L quoteright -55
KPX L y -37
KPX L yacute -37
KPX L ydieresis -37
KPX Lacute T -18
KPX Lacute Tcaron -18
KPX Lacute Tcommaaccent -18
KPX Lacute V -37
KPX Lacute W -37
KPX Lacute Y -37
KPX Lacute Yacute -37
KPX Lacute Ydieresis -37
KPX Lacute quoteright -55
KPX Lacute y -37
KPX Lacute yacute -37
KPX Lacute ydieresis -37
KPX Lcommaaccent T -18
KPX Lcommaaccent Tcaron -18
KPX Lcommaaccent Tcommaaccent -18
KPX Lcommaaccent V -37
KPX Lcommaaccent W -37
KPX Lcommaaccent Y -37
KPX Lcommaaccent Yacute -37
KPX Lcommaaccent Ydieresis -37
KPX Lcommaaccent quoteright -55
KPX Lcommaaccent y -37
KPX Lcommaaccent yacute -37
KPX Lcommaaccent ydieresis -37
KPX Lslash T -18
KPX Lslash Tcaron -18
KPX Lslash Tcommaaccent -18
KPX Lslash V -37
KPX Lslash W -37
KPX Lslash Y -37
KPX Lslash Yacute -37
KPX Lslash Ydieresis -37
KPX Lslash quoteright -55
KPX Lslash y -37
KPX Lslash yacute -37
KPX Lslash ydieresis -37
KPX N A -30
KPX N Aacute -30
KPX N Abreve -30
KPX N Acircumflex -30
KPX N Adieresis -30
KPX N Agrave -30
KPX N Amacron -30
KPX N Aogonek -30
KPX N Aring -30
KPX N Atilde -30
KPX Nacute A -30
KPX Nacute Aacute -30
KPX Nacute Abreve -30
KPX Nacute Acircumflex -30
KPX Nacute Adieresis -30
KPX Nacute Agrave -30
KPX Nacute Amacron -30
KPX Nacute Aogonek -30
KPX Nacute Aring -30
KPX Nacute Atilde -30
KPX Ncaron A -30
KPX Ncaron Aacute -30
KPX Ncaron Abreve -30
KPX Ncaron Acircumflex -30
KPX Ncaron Adieresis -30
KPX Ncaron Agrave -30
KPX Ncaron Amacron -30
KPX Ncaron Aogonek -30
KPX Ncaron Aring -30
KPX Ncaron Atilde -30
KPX Ncommaaccent A -30
KPX Ncommaaccent Aacute -30
KPX Ncommaaccent Abreve -30
KPX Ncommaaccent Acircumflex -30
KPX Ncommaaccent Adieresis -30
KPX Ncommaaccent Agrave -30
KPX Ncommaaccent Amacron -30
KPX Ncommaaccent Aogonek -30
KPX Ncommaaccent Aring -30
KPX Ncommaaccent Atilde -30
KPX Ntilde A -30
KPX Ntilde Aacute -30
KPX Ntilde Abreve -30
KPX Ntilde Acircumflex -30
KPX Ntilde Adieresis -30
KPX Ntilde Agrave -30
KPX Ntilde Amacron -30
KPX Ntilde Aogonek -30
KPX Ntilde Aring -30
KPX Ntilde Atilde -30
KPX O A -40
KPX O Aacute -40
KPX O Abreve -40
KPX O Acircumflex -40
KPX O Adieresis -40
KPX O Agrave -40
KPX O Amacron -40
KPX O Aogonek -40
KPX O Aring -40
KPX O Atilde -40
KPX O T -40
KPX O Tcaron -40
KPX O Tcommaaccent -40
KPX O V -50
KPX O W -50
KPX O X -40
KPX O Y -50
KPX O Yacute -50
KPX O Ydieresis -50
KPX Oacute A -40
KPX Oacute Aacute -40
KPX Oacute Abreve -40
KPX Oacute Acircumflex -40
KPX Oacute Adieresis -40
KPX Oacute Agrave -40
KPX Oacute Amacron -40
KPX Oacute Aogonek -40
KPX Oacute Aring -40
KPX Oacute Atilde -40
KPX Oacute T -40
KPX Oacute Tcaron -40
KPX Oacute Tcommaaccent -40
KPX Oacute V -50
KPX Oacute W -50
KPX Oacute X -40
KPX Oacute Y -50
KPX Oacute Yacute -50
KPX Oacute Ydieresis -50
KPX Ocircumflex A -40
KPX Ocircumflex Aacute -40
KPX Ocircumflex Abreve -40
KPX Ocircumflex Acircumflex -40
KPX Ocircumflex Adieresis -40
KPX Ocircumflex Agrave -40
KPX Ocircumflex Amacron -40
KPX Ocircumflex Aogonek -40
KPX Ocircumflex Aring -40
KPX Ocircumflex Atilde -40
KPX Ocircumflex T -40
KPX Ocircumflex Tcaron -40
KPX Ocircumflex Tcommaaccent -40
KPX Ocircumflex V -50
KPX Ocircumflex W -50
KPX Ocircumflex X -40
KPX Ocircumflex Y -50
KPX Ocircumflex Yacute -50
KPX Ocircumflex Ydieresis -50
KPX Odieresis A -40
KPX Odieresis Aacute -40
KPX Odieresis Abreve -40
KPX Odieresis Acircumflex -40
KPX Odieresis Adieresis -40
KPX Odieresis Agrave -40
KPX Odieresis Amacron -40
KPX Odieresis Aogonek -40
KPX Odieresis Aring -40
KPX Odieresis Atilde -40
KPX Odieresis T -40
KPX Odieresis Tcaron -40
KPX Odieresis Tcommaaccent -40
KPX Odieresis V -50
KPX Odieresis W -50
KPX Odieresis X -40
KPX Odieresis Y -50
KPX Odieresis Yacute -50
KPX Odieresis Ydieresis -50
KPX Ograve A -40
KPX Ograve Aacute -40
KPX Ograve Abreve -40
KPX Ograve Acircumflex -40
KPX Ograve Adieresis -40
KPX Ograve Agrave -40
KPX Ograve Amacron -40
KPX Ograve Aogonek -40
KPX Ograve Aring -40
KPX Ograve Atilde -40
KPX Ograve T -40
KPX Ograve Tcaron -40
KPX Ograve Tcommaaccent -40
KPX Ograve V -50
KPX Ograve W -50
KPX Ograve X -40
KPX Ograve Y -50
KPX Ograve Yacute -50
KPX Ograve Ydieresis -50
KPX Ohungarumlaut A -40
KPX Ohungarumlaut Aacute -40
KPX Ohungarumlaut Abreve -40
KPX Ohungarumlaut Acircumflex -40
KPX Ohungarumlaut Adieresis -40
KPX Ohungarumlaut Agrave -40
KPX Ohungarumlaut Amacron -40
KPX Ohungarumlaut Aogonek -40
KPX Ohungarumlaut Aring -40
KPX Ohungarumlaut Atilde -40
KPX Ohungarumlaut T -40
KPX Ohungarumlaut Tcaron -40
KPX Ohungarumlaut Tcommaaccent -40
KPX Ohungarumlaut V -50
KPX Ohungarumlaut W -50
KPX Ohungarumlaut X -40
KPX Ohungarumlaut Y -50
KPX Ohungarumlaut Yacute -50
KPX Ohungarumlaut Ydieresis -50
KPX Omacron A -40
KPX Omacron Aacute -40
KPX Omacron Abreve -40
KPX Omacron Acircumflex -40
KPX Omacron Adieresis -40
KPX Omacron Agrave -40
KPX Omacron Amacron -40
KPX Omacron Aogonek -40
KPX Omacron Aring -40
KPX Omacron Atilde -40
KPX Omacron T -40
KPX Omacron Tcaron -40
KPX Omacron Tcommaaccent -40
KPX Omacron V -50
KPX Omacron W -50
KPX Omacron X -40
KPX Omacron Y -50
KPX Omacron Yacute -50
KPX Omacron Ydieresis -50
KPX Oslash A -40
KPX Oslash Aacute -40
KPX Oslash Abreve -40
KPX Oslash Acircumflex -40
KPX Oslash Adieresis -40
KPX Oslash Agrave -40
KPX Oslash Amacron -40
KPX Oslash Aogonek -40
KPX Oslash Aring -40
KPX Oslash Atilde -40
KPX Oslash T -40
KPX Oslash Tcaron -40
KPX Oslash Tcommaaccent -40
KPX Oslash V -50
KPX Oslash W -50
KPX Oslash X -40
KPX Oslash Y -50
KPX Oslash Yacute -50
KPX Oslash Ydieresis -50
KPX Otilde A -40
KPX Otilde Aacute -40
KPX Otilde Abreve -40
KPX Otilde Acircumflex -40
KPX Otilde Adieresis -40
KPX Otilde Agrave -40
KPX Otilde Amacron -40
KPX Otilde Aogonek -40
KPX Otilde Aring -40
KPX Otilde Atilde -40
KPX Otilde T -40
KPX Otilde Tcaron -40
KPX Otilde Tcommaaccent -40
KPX Otilde V -50
KPX Otilde W -50
KPX Otilde X -40
KPX Otilde Y -50
KPX Otilde Yacute -50
KPX Otilde Ydieresis -50
KPX P A -85
KPX P Aacute -85
KPX P Abreve -85
KPX P Acircumflex -85
KPX P Adieresis -85
KPX P Agrave -85
KPX P Amacron -85
KPX P Aogonek -85
KPX P Aring -85
KPX P Atilde -85
KPX P a -40
KPX P aacute -40
KPX P abreve -40
KPX P acircumflex -40
KPX P adieresis -40
KPX P agrave -40
KPX P amacron -40
KPX P aogonek -40
KPX P aring -40
KPX P atilde -40
KPX P comma -129
KPX P e -50
KPX P eacute -50
KPX P ecaron -50
KPX P ecircumflex -50
KPX P edieresis -50
KPX P edotaccent -50
KPX P egrave -50
KPX P emacron -50
KPX P eogonek -50
KPX P o -55
KPX P oacute -55
KPX P ocircumflex -55
KPX P odieresis -55
KPX P ograve -55
KPX P ohungarumlaut -55
KPX P omacron -55
KPX P oslash -55
KPX P otilde -55
KPX P period -129
KPX Q U -10
KPX Q Uacute -10
KPX Q Ucircumflex -10
KPX Q Udieresis -10
KPX Q Ugrave -10
KPX Q Uhungarumlaut -10
KPX Q Umacron -10
KPX Q Uogonek -10
KPX Q Uring -10
KPX R O -40
KPX R Oacute -40
KPX R Ocircumflex -40
KPX R Odieresis -40
KPX R Ograve -40
KPX R Ohungarumlaut -40
KPX R Omacron -40
KPX R Oslash -40
KPX R Otilde -40
KPX R T -30
KPX R Tcaron -30
KPX R Tcommaaccent -30
KPX R U -40
KPX R Uacute -40
KPX R Ucircumflex -40
KPX R Udieresis -40
KPX R Ugrave -40
KPX R Uhungarumlaut -40
KPX R Umacron -40
KPX R Uogonek -40
KPX R Uring -40
KPX R V -18
KPX R W -18
KPX R Y -18
KPX R Yacute -18
KPX R Ydieresis -18
KPX Racute O -40
KPX Racute Oacute -40
KPX Racute Ocircumflex -40
KPX Racute Odieresis -40
KPX Racute Ograve -40
KPX Racute Ohungarumlaut -40
KPX Racute Omacron -40
KPX Racute Oslash -40
KPX Racute Otilde -40
KPX Racute T -30
KPX Racute Tcaron -30
KPX Racute Tcommaaccent -30
KPX Racute U -40
KPX Racute Uacute -40
KPX Racute Ucircumflex -40
KPX Racute Udieresis -40
KPX Racute Ugrave -40
KPX Racute Uhungarumlaut -40
KPX Racute Umacron -40
KPX Racute Uogonek -40
KPX Racute Uring -40
KPX Racute V -18
KPX Racute W -18
KPX Racute Y -18
KPX Racute Yacute -18
KPX Racute Ydieresis -18
KPX Rcaron O -40
KPX Rcaron Oacute -40
KPX Rcaron Ocircumflex -40
KPX Rcaron Odieresis -40
KPX Rcaron Ograve -40
KPX Rcaron Ohungarumlaut -40
KPX Rcaron Omacron -40
KPX Rcaron Oslash -40
KPX Rcaron Otilde -40
KPX Rcaron T -30
KPX Rcaron Tcaron -30
KPX Rcaron Tcommaaccent -30
KPX Rcaron U -40
KPX Rcaron Uacute -40
KPX Rcaron Ucircumflex -40
KPX Rcaron Udieresis -40
KPX Rcaron Ugrave -40
KPX Rcaron Uhungarumlaut -40
KPX Rcaron Umacron -40
KPX Rcaron Uogonek -40
KPX Rcaron Uring -40
KPX Rcaron V -18
KPX Rcaron W -18
KPX Rcaron Y -18
KPX Rcaron Yacute -18
KPX Rcaron Ydieresis -18
KPX Rcommaaccent O -40
KPX Rcommaaccent Oacute -40
KPX Rcommaaccent Ocircumflex -40
KPX Rcommaaccent Odieresis -40
KPX Rcommaaccent Ograve -40
KPX Rcommaaccent Ohungarumlaut -40
KPX Rcommaaccent Omacron -40
KPX Rcommaaccent Oslash -40
KPX Rcommaaccent Otilde -40
KPX Rcommaaccent T -30
KPX Rcommaaccent Tcaron -30
KPX Rcommaaccent Tcommaaccent -30
KPX Rcommaaccent U -40
KPX Rcommaaccent Uacute -40
KPX Rcommaaccent Ucircumflex -40
KPX Rcommaaccent Udieresis -40
KPX Rcommaaccent Ugrave -40
KPX Rcommaaccent Uhungarumlaut -40
KPX Rcommaaccent Umacron -40
KPX Rcommaaccent Uogonek -40
KPX Rcommaaccent Uring -40
KPX Rcommaaccent V -18
KPX Rcommaaccent W -18
KPX Rcommaaccent Y -18
KPX Rcommaaccent Yacute -18
KPX Rcommaaccent Ydieresis -18
KPX T A -55
KPX T Aacute -55
KPX T Abreve -55
KPX T Acircumflex -55
KPX T Adieresis -55
KPX T Agrave -55
KPX T Amacron -55
KPX T Aogonek -55
KPX T Aring -55
KPX T Atilde -55
KPX T O -18
KPX T Oacute -18
KPX T Ocircumflex -18
KPX T Odieresis -18
KPX T Ograve -18
KPX T Ohungarumlaut -18
KPX T Omacron -18
KPX T Oslash -18
KPX T Otilde -18
KPX T a -92
KPX T aacute -92
KPX T abreve -92
KPX T acircumflex -92
KPX T adieresis -92
KPX T agrave -92
KPX T amacron -92
KPX T aogonek -92
KPX T aring -92
KPX T atilde -92
KPX T colon -74
KPX T comma -92
KPX T e -92
KPX T eacute -92
KPX T ecaron -92
KPX T ecircumflex -92
KPX T edieresis -52
KPX T edotaccent -92
KPX T egrave -52
KPX T emacron -52
KPX T eogonek -92
KPX T hyphen -92
KPX T i -37
KPX T iacute -37
KPX T iogonek -37
KPX T o -95
KPX T oacute -95
KPX T ocircumflex -95
KPX T odieresis -95
KPX T ograve -95
KPX T ohungarumlaut -95
KPX T omacron -95
KPX T oslash -95
KPX T otilde -95
KPX T period -92
KPX T r -37
KPX T racute -37
KPX T rcaron -37
KPX T rcommaaccent -37
KPX T semicolon -74
KPX T u -37
KPX T uacute -37
KPX T ucircumflex -37
KPX T udieresis -37
KPX T ugrave -37
KPX T uhungarumlaut -37
KPX T umacron -37
KPX T uogonek -37
KPX T uring -37
KPX T w -37
KPX T y -37
KPX T yacute -37
KPX T ydieresis -37
KPX Tcaron A -55
KPX Tcaron Aacute -55
KPX Tcaron Abreve -55
KPX Tcaron Acircumflex -55
KPX Tcaron Adieresis -55
KPX Tcaron Agrave -55
KPX Tcaron Amacron -55
KPX Tcaron Aogonek -55
KPX Tcaron Aring -55
KPX Tcaron Atilde -55
KPX Tcaron O -18
KPX Tcaron Oacute -18
KPX Tcaron Ocircumflex -18
KPX Tcaron Odieresis -18
KPX Tcaron Ograve -18
KPX Tcaron Ohungarumlaut -18
KPX Tcaron Omacron -18
KPX Tcaron Oslash -18
KPX Tcaron Otilde -18
KPX Tcaron a -92
KPX Tcaron aacute -92
KPX Tcaron abreve -92
KPX Tcaron acircumflex -92
KPX Tcaron adieresis -92
KPX Tcaron agrave -92
KPX Tcaron amacron -92
KPX Tcaron aogonek -92
KPX Tcaron aring -92
KPX Tcaron atilde -92
KPX Tcaron colon -74
KPX Tcaron comma -92
KPX Tcaron e -92
KPX Tcaron eacute -92
KPX Tcaron ecaron -92
KPX Tcaron ecircumflex -92
KPX Tcaron edieresis -52
KPX Tcaron edotaccent -92
KPX Tcaron egrave -52
KPX Tcaron emacron -52
KPX Tcaron eogonek -92
KPX Tcaron hyphen -92
KPX Tcaron i -37
KPX Tcaron iacute -37
KPX Tcaron iogonek -37
KPX Tcaron o -95
KPX Tcaron oacute -95
KPX Tcaron ocircumflex -95
KPX Tcaron odieresis -95
KPX Tcaron ograve -95
KPX Tcaron ohungarumlaut -95
KPX Tcaron omacron -95
KPX Tcaron oslash -95
KPX Tcaron otilde -95
KPX Tcaron period -92
KPX Tcaron r -37
KPX Tcaron racute -37
KPX Tcaron rcaron -37
KPX Tcaron rcommaaccent -37
KPX Tcaron semicolon -74
KPX Tcaron u -37
KPX Tcaron uacute -37
KPX Tcaron ucircumflex -37
KPX Tcaron udieresis -37
KPX Tcaron ugrave -37
KPX Tcaron uhungarumlaut -37
KPX Tcaron umacron -37
KPX Tcaron uogonek -37
KPX Tcaron uring -37
KPX Tcaron w -37
KPX Tcaron y -37
KPX Tcaron yacute -37
KPX Tcaron ydieresis -37
KPX Tcommaaccent A -55
KPX Tcommaaccent Aacute -55
KPX Tcommaaccent Abreve -55
KPX Tcommaaccent Acircumflex -55
KPX Tcommaaccent Adieresis -55
KPX Tcommaaccent Agrave -55
KPX Tcommaaccent Amacron -55
KPX Tcommaaccent Aogonek -55
KPX Tcommaaccent Aring -55
KPX Tcommaaccent Atilde -55
KPX Tcommaaccent O -18
KPX Tcommaaccent Oacute -18
KPX Tcommaaccent Ocircumflex -18
KPX Tcommaaccent Odieresis -18
KPX Tcommaaccent Ograve -18
KPX Tcommaaccent Ohungarumlaut -18
KPX Tcommaaccent Omacron -18
KPX Tcommaaccent Oslash -18
KPX Tcommaaccent Otilde -18
KPX Tcommaaccent a -92
KPX Tcommaaccent aacute -92
KPX Tcommaaccent abreve -92
KPX Tcommaaccent acircumflex -92
KPX Tcommaaccent adieresis -92
KPX Tcommaaccent agrave -92
KPX Tcommaaccent amacron -92
KPX Tcommaaccent aogonek -92
KPX Tcommaaccent aring -92
KPX Tcommaaccent atilde -92
KPX Tcommaaccent colon -74
KPX Tcommaaccent comma -92
KPX Tcommaaccent e -92
KPX Tcommaaccent eacute -92
KPX Tcommaaccent ecaron -92
KPX Tcommaaccent ecircumflex -92
KPX Tcommaaccent edieresis -52
KPX Tcommaaccent edotaccent -92
KPX Tcommaaccent egrave -52
KPX Tcommaaccent emacron -52
KPX Tcommaaccent eogonek -92
KPX Tcommaaccent hyphen -92
KPX Tcommaaccent i -37
KPX Tcommaaccent iacute -37
KPX Tcommaaccent iogonek -37
KPX Tcommaaccent o -95
KPX Tcommaaccent oacute -95
KPX Tcommaaccent ocircumflex -95
KPX Tcommaaccent odieresis -95
KPX Tcommaaccent ograve -95
KPX Tcommaaccent ohungarumlaut -95
KPX Tcommaaccent omacron -95
KPX Tcommaaccent oslash -95
KPX Tcommaaccent otilde -95
KPX Tcommaaccent period -92
KPX Tcommaaccent r -37
KPX Tcommaaccent racute -37
KPX Tcommaaccent rcaron -37
KPX Tcommaaccent rcommaaccent -37
KPX Tcommaaccent semicolon -74
KPX Tcommaaccent u -37
KPX Tcommaaccent uacute -37
KPX Tcommaaccent ucircumflex -37
KPX Tcommaaccent udieresis -37
KPX Tcommaaccent ugrave -37
KPX Tcommaaccent uhungarumlaut -37
KPX Tcommaaccent umacron -37
KPX Tcommaaccent uogonek -37
KPX Tcommaaccent uring -37
KPX Tcommaaccent w -37
KPX Tcommaaccent y -37
KPX Tcommaaccent yacute -37
KPX Tcommaaccent ydieresis -37
KPX U A -45
KPX U Aacute -45
KPX U Abreve -45
KPX U Acircumflex -45
KPX U Adieresis -45
KPX U Agrave -45
KPX U Amacron -45
KPX U Aogonek -45
KPX U Aring -45
KPX U Atilde -45
KPX Uacute A -45
KPX Uacute Aacute -45
KPX Uacute Abreve -45
KPX Uacute Acircumflex -45
KPX Uacute Adieresis -45
KPX Uacute Agrave -45
KPX Uacute Amacron -45
KPX Uacute Aogonek -45
KPX Uacute Aring -45
KPX Uacute Atilde -45
KPX Ucircumflex A -45
KPX Ucircumflex Aacute -45
KPX Ucircumflex Abreve -45
KPX Ucircumflex Acircumflex -45
KPX Ucircumflex Adieresis -45
KPX Ucircumflex Agrave -45
KPX Ucircumflex Amacron -45
KPX Ucircumflex Aogonek -45
KPX Ucircumflex Aring -45
KPX Ucircumflex Atilde -45
KPX Udieresis A -45
KPX Udieresis Aacute -45
KPX Udieresis Abreve -45
KPX Udieresis Acircumflex -45
KPX Udieresis Adieresis -45
KPX Udieresis Agrave -45
KPX Udieresis Amacron -45
KPX Udieresis Aogonek -45
KPX Udieresis Aring -45
KPX Udieresis Atilde -45
KPX Ugrave A -45
KPX Ugrave Aacute -45
KPX Ugrave Abreve -45
KPX Ugrave Acircumflex -45
KPX Ugrave Adieresis -45
KPX Ugrave Agrave -45
KPX Ugrave Amacron -45
KPX Ugrave Aogonek -45
KPX Ugrave Aring -45
KPX Ugrave Atilde -45
KPX Uhungarumlaut A -45
KPX Uhungarumlaut Aacute -45
KPX Uhungarumlaut Abreve -45
KPX Uhungarumlaut Acircumflex -45
KPX Uhungarumlaut Adieresis -45
KPX Uhungarumlaut Agrave -45
KPX Uhungarumlaut Amacron -45
KPX Uhungarumlaut Aogonek -45
KPX Uhungarumlaut Aring -45
KPX Uhungarumlaut Atilde -45
KPX Umacron A -45
KPX Umacron Aacute -45
KPX Umacron Abreve -45
KPX Umacron Acircumflex -45
KPX Umacron Adieresis -45
KPX Umacron Agrave -45
KPX Umacron Amacron -45
KPX Umacron Aogonek -45
KPX Umacron Aring -45
KPX Umacron Atilde -45
KPX Uogonek A -45
KPX Uogonek Aacute -45
KPX Uogonek Abreve -45
KPX Uogonek Acircumflex -45
KPX Uogonek Adieresis -45
KPX Uogonek Agrave -45
KPX Uogonek Amacron -45
KPX Uogonek Aogonek -45
KPX Uogonek Aring -45
KPX Uogonek Atilde -45
KPX Uring A -45
KPX Uring Aacute -45
KPX Uring Abreve -45
KPX Uring Acircumflex -45
KPX Uring Adieresis -45
KPX Uring Agrave -45
KPX Uring Amacron -45
KPX Uring Aogonek -45
KPX Uring Aring -45
KPX Uring Atilde -45
KPX V A -85
KPX V Aacute -85
KPX V Abreve -85
KPX V Acircumflex -85
KPX V Adieresis -85
KPX V Agrave -85
KPX V Amacron -85
KPX V Aogonek -85
KPX V Aring -85
KPX V Atilde -85
KPX V G -10
KPX V Gbreve -10
KPX V Gcommaaccent -10
KPX V O -30
KPX V Oacute -30
KPX V Ocircumflex -30
KPX V Odieresis -30
KPX V Ograve -30
KPX V Ohungarumlaut -30
KPX V Omacron -30
KPX V Oslash -30
KPX V Otilde -30
KPX V a -111
KPX V aacute -111
KPX V abreve -111
KPX V acircumflex -111
KPX V adieresis -111
KPX V agrave -111
KPX V amacron -111
KPX V aogonek -111
KPX V aring -111
KPX V atilde -111
KPX V colon -74
KPX V comma -129
KPX V e -111
KPX V eacute -111
KPX V ecaron -111
KPX V ecircumflex -111
KPX V edieresis -71
KPX V edotaccent -111
KPX V egrave -71
KPX V emacron -71
KPX V eogonek -111
KPX V hyphen -70
KPX V i -55
KPX V iacute -55
KPX V iogonek -55
KPX V o -111
KPX V oacute -111
KPX V ocircumflex -111
KPX V odieresis -111
KPX V ograve -111
KPX V ohungarumlaut -111
KPX V omacron -111
KPX V oslash -111
KPX V otilde -111
KPX V period -129
KPX V semicolon -74
KPX V u -55
KPX V uacute -55
KPX V ucircumflex -55
KPX V udieresis -55
KPX V ugrave -55
KPX V uhungarumlaut -55
KPX V umacron -55
KPX V uogonek -55
KPX V uring -55
KPX W A -74
KPX W Aacute -74
KPX W Abreve -74
KPX W Acircumflex -74
KPX W Adieresis -74
KPX W Agrave -74
KPX W Amacron -74
KPX W Aogonek -74
KPX W Aring -74
KPX W Atilde -74
KPX W O -15
KPX W Oacute -15
KPX W Ocircumflex -15
KPX W Odieresis -15
KPX W Ograve -15
KPX W Ohungarumlaut -15
KPX W Omacron -15
KPX W Oslash -15
KPX W Otilde -15
KPX W a -85
KPX W aacute -85
KPX W abreve -85
KPX W acircumflex -85
KPX W adieresis -85
KPX W agrave -85
KPX W amacron -85
KPX W aogonek -85
KPX W aring -85
KPX W atilde -85
KPX W colon -55
KPX W comma -74
KPX W e -90
KPX W eacute -90
KPX W ecaron -90
KPX W ecircumflex -90
KPX W edieresis -50
KPX W edotaccent -90
KPX W egrave -50
KPX W emacron -50
KPX W eogonek -90
KPX W hyphen -50
KPX W i -37
KPX W iacute -37
KPX W iogonek -37
KPX W o -80
KPX W oacute -80
KPX W ocircumflex -80
KPX W odieresis -80
KPX W ograve -80
KPX W ohungarumlaut -80
KPX W omacron -80
KPX W oslash -80
KPX W otilde -80
KPX W period -74
KPX W semicolon -55
KPX W u -55
KPX W uacute -55
KPX W ucircumflex -55
KPX W udieresis -55
KPX W ugrave -55
KPX W uhungarumlaut -55
KPX W umacron -55
KPX W uogonek -55
KPX W uring -55
KPX W y -55
KPX W yacute -55
KPX W ydieresis -55
KPX Y A -74
KPX Y Aacute -74
KPX Y Abreve -74
KPX Y Acircumflex -74
KPX Y Adieresis -74
KPX Y Agrave -74
KPX Y Amacron -74
KPX Y Aogonek -74
KPX Y Aring -74
KPX Y Atilde -74
KPX Y O -25
KPX Y Oacute -25
KPX Y Ocircumflex -25
KPX Y Odieresis -25
KPX Y Ograve -25
KPX Y Ohungarumlaut -25
KPX Y Omacron -25
KPX Y Oslash -25
KPX Y Otilde -25
KPX Y a -92
KPX Y aacute -92
KPX Y abreve -92
KPX Y acircumflex -92
KPX Y adieresis -92
KPX Y agrave -92
KPX Y amacron -92
KPX Y aogonek -92
KPX Y aring -92
KPX Y atilde -92
KPX Y colon -92
KPX Y comma -92
KPX Y e -111
KPX Y eacute -111
KPX Y ecaron -111
KPX Y ecircumflex -71
KPX Y edieresis -71
KPX Y edotaccent -111
KPX Y egrave -71
KPX Y emacron -71
KPX Y eogonek -111
KPX Y hyphen -92
KPX Y i -55
KPX Y iacute -55
KPX Y iogonek -55
KPX Y o -111
KPX Y oacute -111
KPX Y ocircumflex -111
KPX Y odieresis -111
KPX Y ograve -111
KPX Y ohungarumlaut -111
KPX Y omacron -111
KPX Y oslash -111
KPX Y otilde -111
KPX Y period -74
KPX Y semicolon -92
KPX Y u -92
KPX Y uacute -92
KPX Y ucircumflex -92
KPX Y udieresis -92
KPX Y ugrave -92
KPX Y uhungarumlaut -92
KPX Y umacron -92
KPX Y uogonek -92
KPX Y uring -92
KPX Yacute A -74
KPX Yacute Aacute -74
KPX Yacute Abreve -74
KPX Yacute Acircumflex -74
KPX Yacute Adieresis -74
KPX Yacute Agrave -74
KPX Yacute Amacron -74
KPX Yacute Aogonek -74
KPX Yacute Aring -74
KPX Yacute Atilde -74
KPX Yacute O -25
KPX Yacute Oacute -25
KPX Yacute Ocircumflex -25
KPX Yacute Odieresis -25
KPX Yacute Ograve -25
KPX Yacute Ohungarumlaut -25
KPX Yacute Omacron -25
KPX Yacute Oslash -25
KPX Yacute Otilde -25
KPX Yacute a -92
KPX Yacute aacute -92
KPX Yacute abreve -92
KPX Yacute acircumflex -92
KPX Yacute adieresis -92
KPX Yacute agrave -92
KPX Yacute amacron -92
KPX Yacute aogonek -92
KPX Yacute aring -92
KPX Yacute atilde -92
KPX Yacute colon -92
KPX Yacute comma -92
KPX Yacute e -111
KPX Yacute eacute -111
KPX Yacute ecaron -111
KPX Yacute ecircumflex -71
KPX Yacute edieresis -71
KPX Yacute edotaccent -111
KPX Yacute egrave -71
KPX Yacute emacron -71
KPX Yacute eogonek -111
KPX Yacute hyphen -92
KPX Yacute i -55
KPX Yacute iacute -55
KPX Yacute iogonek -55
KPX Yacute o -111
KPX Yacute oacute -111
KPX Yacute ocircumflex -111
KPX Yacute odieresis -111
KPX Yacute ograve -111
KPX Yacute ohungarumlaut -111
KPX Yacute omacron -111
KPX Yacute oslash -111
KPX Yacute otilde -111
KPX Yacute period -74
KPX Yacute semicolon -92
KPX Yacute u -92
KPX Yacute uacute -92
KPX Yacute ucircumflex -92
KPX Yacute udieresis -92
KPX Yacute ugrave -92
KPX Yacute uhungarumlaut -92
KPX Yacute umacron -92
KPX Yacute uogonek -92
KPX Yacute uring -92
KPX Ydieresis A -74
KPX Ydieresis Aacute -74
KPX Ydieresis Abreve -74
KPX Ydieresis Acircumflex -74
KPX Ydieresis Adieresis -74
KPX Ydieresis Agrave -74
KPX Ydieresis Amacron -74
KPX Ydieresis Aogonek -74
KPX Ydieresis Aring -74
KPX Ydieresis Atilde -74
KPX Ydieresis O -25
KPX Ydieresis Oacute -25
KPX Ydieresis Ocircumflex -25
KPX Ydieresis Odieresis -25
KPX Ydieresis Ograve -25
KPX Ydieresis Ohungarumlaut -25
KPX Ydieresis Omacron -25
KPX Ydieresis Oslash -25
KPX Ydieresis Otilde -25
KPX Ydieresis a -92
KPX Ydieresis aacute -92
KPX Ydieresis abreve -92
KPX Ydieresis acircumflex -92
KPX Ydieresis adieresis -92
KPX Ydieresis agrave -92
KPX Ydieresis amacron -92
KPX Ydieresis aogonek -92
KPX Ydieresis aring -92
KPX Ydieresis atilde -92
KPX Ydieresis colon -92
KPX Ydieresis comma -92
KPX Ydieresis e -111
KPX Ydieresis eacute -111
KPX Ydieresis ecaron -111
KPX Ydieresis ecircumflex -71
KPX Ydieresis edieresis -71
KPX Ydieresis edotaccent -111
KPX Ydieresis egrave -71
KPX Ydieresis emacron -71
KPX Ydieresis eogonek -111
KPX Ydieresis hyphen -92
KPX Ydieresis i -55
KPX Ydieresis iacute -55
KPX Ydieresis iogonek -55
KPX Ydieresis o -111
KPX Ydieresis oacute -111
KPX Ydieresis ocircumflex -111
KPX Ydieresis odieresis -111
KPX Ydieresis ograve -111
KPX Ydieresis ohungarumlaut -111
KPX Ydieresis omacron -111
KPX Ydieresis oslash -111
KPX Ydieresis otilde -111
KPX Ydieresis period -74
KPX Ydieresis semicolon -92
KPX Ydieresis u -92
KPX Ydieresis uacute -92
KPX Ydieresis ucircumflex -92
KPX Ydieresis udieresis -92
KPX Ydieresis ugrave -92
KPX Ydieresis uhungarumlaut -92
KPX Ydieresis umacron -92
KPX Ydieresis uogonek -92
KPX Ydieresis uring -92
KPX b b -10
KPX b period -40
KPX b u -20
KPX b uacute -20
KPX b ucircumflex -20
KPX b udieresis -20
KPX b ugrave -20
KPX b uhungarumlaut -20
KPX b umacron -20
KPX b uogonek -20
KPX b uring -20
KPX c h -10
KPX c k -10
KPX c kcommaaccent -10
KPX cacute h -10
KPX cacute k -10
KPX cacute kcommaaccent -10
KPX ccaron h -10
KPX ccaron k -10
KPX ccaron kcommaaccent -10
KPX ccedilla h -10
KPX ccedilla k -10
KPX ccedilla kcommaaccent -10
KPX comma quotedblright -95
KPX comma quoteright -95
KPX e b -10
KPX eacute b -10
KPX ecaron b -10
KPX ecircumflex b -10
KPX edieresis b -10
KPX edotaccent b -10
KPX egrave b -10
KPX emacron b -10
KPX eogonek b -10
KPX f comma -10
KPX f dotlessi -30
KPX f e -10
KPX f eacute -10
KPX f edotaccent -10
KPX f eogonek -10
KPX f f -18
KPX f o -10
KPX f oacute -10
KPX f ocircumflex -10
KPX f ograve -10
KPX f ohungarumlaut -10
KPX f oslash -10
KPX f otilde -10
KPX f period -10
KPX f quoteright 55
KPX k e -30
KPX k eacute -30
KPX k ecaron -30
KPX k ecircumflex -30
KPX k edieresis -30
KPX k edotaccent -30
KPX k egrave -30
KPX k emacron -30
KPX k eogonek -30
KPX k o -10
KPX k oacute -10
KPX k ocircumflex -10
KPX k odieresis -10
KPX k ograve -10
KPX k ohungarumlaut -10
KPX k omacron -10
KPX k oslash -10
KPX k otilde -10
KPX kcommaaccent e -30
KPX kcommaaccent eacute -30
KPX kcommaaccent ecaron -30
KPX kcommaaccent ecircumflex -30
KPX kcommaaccent edieresis -30
KPX kcommaaccent edotaccent -30
KPX kcommaaccent egrave -30
KPX kcommaaccent emacron -30
KPX kcommaaccent eogonek -30
KPX kcommaaccent o -10
KPX kcommaaccent oacute -10
KPX kcommaaccent ocircumflex -10
KPX kcommaaccent odieresis -10
KPX kcommaaccent ograve -10
KPX kcommaaccent ohungarumlaut -10
KPX kcommaaccent omacron -10
KPX kcommaaccent oslash -10
KPX kcommaaccent otilde -10
KPX n v -40
KPX nacute v -40
KPX ncaron v -40
KPX ncommaaccent v -40
KPX ntilde v -40
KPX o v -15
KPX o w -25
KPX o x -10
KPX o y -10
KPX o yacute -10
KPX o ydieresis -10
KPX oacute v -15
KPX oacute w -25
KPX oacute x -10
KPX oacute y -10
KPX oacute yacute -10
KPX oacute ydieresis -10
KPX ocircumflex v -15
KPX ocircumflex w -25
KPX ocircumflex x -10
KPX ocircumflex y -10
KPX ocircumflex yacute -10
KPX ocircumflex ydieresis -10
KPX odieresis v -15
KPX odieresis w -25
KPX odieresis x -10
KPX odieresis y -10
KPX odieresis yacute -10
KPX odieresis ydieresis -10
KPX ograve v -15
KPX ograve w -25
KPX ograve x -10
KPX ograve y -10
KPX ograve yacute -10
KPX ograve ydieresis -10
KPX ohungarumlaut v -15
KPX ohungarumlaut w -25
KPX ohungarumlaut x -10
KPX ohungarumlaut y -10
KPX ohungarumlaut yacute -10
KPX ohungarumlaut ydieresis -10
KPX omacron v -15
KPX omacron w -25
KPX omacron x -10
KPX omacron y -10
KPX omacron yacute -10
KPX omacron ydieresis -10
KPX oslash v -15
KPX oslash w -25
KPX oslash x -10
KPX oslash y -10
KPX oslash yacute -10
KPX oslash ydieresis -10
KPX otilde v -15
KPX otilde w -25
KPX otilde x -10
KPX otilde y -10
KPX otilde yacute -10
KPX otilde ydieresis -10
KPX period quotedblright -95
KPX period quoteright -95
KPX quoteleft quoteleft -74
KPX quoteright d -15
KPX quoteright dcroat -15
KPX quoteright quoteright -74
KPX quoteright r -15
KPX quoteright racute -15
KPX quoteright rcaron -15
KPX quoteright rcommaaccent -15
KPX quoteright s -74
KPX quoteright sacute -74
KPX quoteright scaron -74
KPX quoteright scedilla -74
KPX quoteright scommaaccent -74
KPX quoteright space -74
KPX quoteright t -37
KPX quoteright tcommaaccent -37
KPX quoteright v -15
KPX r comma -65
KPX r period -65
KPX racute comma -65
KPX racute period -65
KPX rcaron comma -65
KPX rcaron period -65
KPX rcommaaccent comma -65
KPX rcommaaccent period -65
KPX space A -37
KPX space Aacute -37
KPX space Abreve -37
KPX space Acircumflex -37
KPX space Adieresis -37
KPX space Agrave -37
KPX space Amacron -37
KPX space Aogonek -37
KPX space Aring -37
KPX space Atilde -37
KPX space V -70
KPX space W -70
KPX space Y -70
KPX space Yacute -70
KPX space Ydieresis -70
KPX v comma -37
KPX v e -15
KPX v eacute -15
KPX v ecaron -15
KPX v ecircumflex -15
KPX v edieresis -15
KPX v edotaccent -15
KPX v egrave -15
KPX v emacron -15
KPX v eogonek -15
KPX v o -15
KPX v oacute -15
KPX v ocircumflex -15
KPX v odieresis -15
KPX v ograve -15
KPX v ohungarumlaut -15
KPX v omacron -15
KPX v oslash -15
KPX v otilde -15
KPX v period -37
KPX w a -10
KPX w aacute -10
KPX w abreve -10
KPX w acircumflex -10
KPX w adieresis -10
KPX w agrave -10
KPX w amacron -10
KPX w aogonek -10
KPX w aring -10
KPX w atilde -10
KPX w comma -37
KPX w e -10
KPX w eacute -10
KPX w ecaron -10
KPX w ecircumflex -10
KPX w edieresis -10
KPX w edotaccent -10
KPX w egrave -10
KPX w emacron -10
KPX w eogonek -10
KPX w o -15
KPX w oacute -15
KPX w ocircumflex -15
KPX w odieresis -15
KPX w ograve -15
KPX w ohungarumlaut -15
KPX w omacron -15
KPX w oslash -15
KPX w otilde -15
KPX w period -37
KPX x e -10
KPX x eacute -10
KPX x ecaron -10
KPX x ecircumflex -10
KPX x edieresis -10
KPX x edotaccent -10
KPX x egrave -10
KPX x emacron -10
KPX x eogonek -10
KPX y comma -37
KPX y period -37
KPX yacute comma -37
KPX yacute period -37
KPX ydieresis comma -37
KPX ydieresis period -37
EndKernPairs
EndKernData
EndFontMetrics"

let helvetica_afm = "StartFontMetrics 4.1
Comment Copyright (c) 1985, 1987, 1989, 1990, 1997 Adobe Systems Incorporated.  All Rights Reserved.
Comment Creation Date: Thu May  1 12:38:23 1997
Comment UniqueID 43054
Comment VMusage 37069 48094
FontName Helvetica
FullName Helvetica
FamilyName Helvetica
Weight Medium
ItalicAngle 0
IsFixedPitch false
CharacterSet ExtendedRoman
FontBBox -166 -225 1000 931 
UnderlinePosition -100
UnderlineThickness 50
Version 002.000
Notice Copyright (c) 1985, 1987, 1989, 1990, 1997 Adobe Systems Incorporated.  All Rights Reserved.Helvetica is a trademark of Linotype-Hell AG and/or its subsidiaries.
EncodingScheme AdobeStandardEncoding
CapHeight 718
XHeight 523
Ascender 718
Descender -207
StdHW 76
StdVW 88
StartCharMetrics 315
C 32 ; WX 278 ; N space ; B 0 0 0 0 ;
C 33 ; WX 278 ; N exclam ; B 90 0 187 718 ;
C 34 ; WX 355 ; N quotedbl ; B 70 463 285 718 ;
C 35 ; WX 556 ; N numbersign ; B 28 0 529 688 ;
C 36 ; WX 556 ; N dollar ; B 32 -115 520 775 ;
C 37 ; WX 889 ; N percent ; B 39 -19 850 703 ;
C 38 ; WX 667 ; N ampersand ; B 44 -15 645 718 ;
C 39 ; WX 222 ; N quoteright ; B 53 463 157 718 ;
C 40 ; WX 333 ; N parenleft ; B 68 -207 299 733 ;
C 41 ; WX 333 ; N parenright ; B 34 -207 265 733 ;
C 42 ; WX 389 ; N asterisk ; B 39 431 349 718 ;
C 43 ; WX 584 ; N plus ; B 39 0 545 505 ;
C 44 ; WX 278 ; N comma ; B 87 -147 191 106 ;
C 45 ; WX 333 ; N hyphen ; B 44 232 289 322 ;
C 46 ; WX 278 ; N period ; B 87 0 191 106 ;
C 47 ; WX 278 ; N slash ; B -17 -19 295 737 ;
C 48 ; WX 556 ; N zero ; B 37 -19 519 703 ;
C 49 ; WX 556 ; N one ; B 101 0 359 703 ;
C 50 ; WX 556 ; N two ; B 26 0 507 703 ;
C 51 ; WX 556 ; N three ; B 34 -19 522 703 ;
C 52 ; WX 556 ; N four ; B 25 0 523 703 ;
C 53 ; WX 556 ; N five ; B 32 -19 514 688 ;
C 54 ; WX 556 ; N six ; B 38 -19 518 703 ;
C 55 ; WX 556 ; N seven ; B 37 0 523 688 ;
C 56 ; WX 556 ; N eight ; B 38 -19 517 703 ;
C 57 ; WX 556 ; N nine ; B 42 -19 514 703 ;
C 58 ; WX 278 ; N colon ; B 87 0 191 516 ;
C 59 ; WX 278 ; N semicolon ; B 87 -147 191 516 ;
C 60 ; WX 584 ; N less ; B 48 11 536 495 ;
C 61 ; WX 584 ; N equal ; B 39 115 545 390 ;
C 62 ; WX 584 ; N greater ; B 48 11 536 495 ;
C 63 ; WX 556 ; N question ; B 56 0 492 727 ;
C 64 ; WX 1015 ; N at ; B 147 -19 868 737 ;
C 65 ; WX 667 ; N A ; B 14 0 654 718 ;
C 66 ; WX 667 ; N B ; B 74 0 627 718 ;
C 67 ; WX 722 ; N C ; B 44 -19 681 737 ;
C 68 ; WX 722 ; N D ; B 81 0 674 718 ;
C 69 ; WX 667 ; N E ; B 86 0 616 718 ;
C 70 ; WX 611 ; N F ; B 86 0 583 718 ;
C 71 ; WX 778 ; N G ; B 48 -19 704 737 ;
C 72 ; WX 722 ; N H ; B 77 0 646 718 ;
C 73 ; WX 278 ; N I ; B 91 0 188 718 ;
C 74 ; WX 500 ; N J ; B 17 -19 428 718 ;
C 75 ; WX 667 ; N K ; B 76 0 663 718 ;
C 76 ; WX 556 ; N L ; B 76 0 537 718 ;
C 77 ; WX 833 ; N M ; B 73 0 761 718 ;
C 78 ; WX 722 ; N N ; B 76 0 646 718 ;
C 79 ; WX 778 ; N O ; B 39 -19 739 737 ;
C 80 ; WX 667 ; N P ; B 86 0 622 718 ;
C 81 ; WX 778 ; N Q ; B 39 -56 739 737 ;
C 82 ; WX 722 ; N R ; B 88 0 684 718 ;
C 83 ; WX 667 ; N S ; B 49 -19 620 737 ;
C 84 ; WX 611 ; N T ; B 14 0 597 718 ;
C 85 ; WX 722 ; N U ; B 79 -19 644 718 ;
C 86 ; WX 667 ; N V ; B 20 0 647 718 ;
C 87 ; WX 944 ; N W ; B 16 0 928 718 ;
C 88 ; WX 667 ; N X ; B 19 0 648 718 ;
C 89 ; WX 667 ; N Y ; B 14 0 653 718 ;
C 90 ; WX 611 ; N Z ; B 23 0 588 718 ;
C 91 ; WX 278 ; N bracketleft ; B 63 -196 250 722 ;
C 92 ; WX 278 ; N backslash ; B -17 -19 295 737 ;
C 93 ; WX 278 ; N bracketright ; B 28 -196 215 722 ;
C 94 ; WX 469 ; N asciicircum ; B -14 264 483 688 ;
C 95 ; WX 556 ; N underscore ; B 0 -125 556 -75 ;
C 96 ; WX 222 ; N quoteleft ; B 65 470 169 725 ;
C 97 ; WX 556 ; N a ; B 36 -15 530 538 ;
C 98 ; WX 556 ; N b ; B 58 -15 517 718 ;
C 99 ; WX 500 ; N c ; B 30 -15 477 538 ;
C 100 ; WX 556 ; N d ; B 35 -15 499 718 ;
C 101 ; WX 556 ; N e ; B 40 -15 516 538 ;
C 102 ; WX 278 ; N f ; B 14 0 262 728 ; L i fi ; L l fl ;
C 103 ; WX 556 ; N g ; B 40 -220 499 538 ;
C 104 ; WX 556 ; N h ; B 65 0 491 718 ;
C 105 ; WX 222 ; N i ; B 67 0 155 718 ;
C 106 ; WX 222 ; N j ; B -16 -210 155 718 ;
C 107 ; WX 500 ; N k ; B 67 0 501 718 ;
C 108 ; WX 222 ; N l ; B 67 0 155 718 ;
C 109 ; WX 833 ; N m ; B 65 0 769 538 ;
C 110 ; WX 556 ; N n ; B 65 0 491 538 ;
C 111 ; WX 556 ; N o ; B 35 -14 521 538 ;
C 112 ; WX 556 ; N p ; B 58 -207 517 538 ;
C 113 ; WX 556 ; N q ; B 35 -207 494 538 ;
C 114 ; WX 333 ; N r ; B 77 0 332 538 ;
C 115 ; WX 500 ; N s ; B 32 -15 464 538 ;
C 116 ; WX 278 ; N t ; B 14 -7 257 669 ;
C 117 ; WX 556 ; N u ; B 68 -15 489 523 ;
C 118 ; WX 500 ; N v ; B 8 0 492 523 ;
C 119 ; WX 722 ; N w ; B 14 0 709 523 ;
C 120 ; WX 500 ; N x ; B 11 0 490 523 ;
C 121 ; WX 500 ; N y ; B 11 -214 489 523 ;
C 122 ; WX 500 ; N z ; B 31 0 469 523 ;
C 123 ; WX 334 ; N braceleft ; B 42 -196 292 722 ;
C 124 ; WX 260 ; N bar ; B 94 -225 167 775 ;
C 125 ; WX 334 ; N braceright ; B 42 -196 292 722 ;
C 126 ; WX 584 ; N asciitilde ; B 61 180 523 326 ;
C 161 ; WX 333 ; N exclamdown ; B 118 -195 215 523 ;
C 162 ; WX 556 ; N cent ; B 51 -115 513 623 ;
C 163 ; WX 556 ; N sterling ; B 33 -16 539 718 ;
C 164 ; WX 167 ; N fraction ; B -166 -19 333 703 ;
C 165 ; WX 556 ; N yen ; B 3 0 553 688 ;
C 166 ; WX 556 ; N florin ; B -11 -207 501 737 ;
C 167 ; WX 556 ; N section ; B 43 -191 512 737 ;
C 168 ; WX 556 ; N currency ; B 28 99 528 603 ;
C 169 ; WX 191 ; N quotesingle ; B 59 463 132 718 ;
C 170 ; WX 333 ; N quotedblleft ; B 38 470 307 725 ;
C 171 ; WX 556 ; N guillemotleft ; B 97 108 459 446 ;
C 172 ; WX 333 ; N guilsinglleft ; B 88 108 245 446 ;
C 173 ; WX 333 ; N guilsinglright ; B 88 108 245 446 ;
C 174 ; WX 500 ; N fi ; B 14 0 434 728 ;
C 175 ; WX 500 ; N fl ; B 14 0 432 728 ;
C 177 ; WX 556 ; N endash ; B 0 240 556 313 ;
C 178 ; WX 556 ; N dagger ; B 43 -159 514 718 ;
C 179 ; WX 556 ; N daggerdbl ; B 43 -159 514 718 ;
C 180 ; WX 278 ; N periodcentered ; B 77 190 202 315 ;
C 182 ; WX 537 ; N paragraph ; B 18 -173 497 718 ;
C 183 ; WX 350 ; N bullet ; B 18 202 333 517 ;
C 184 ; WX 222 ; N quotesinglbase ; B 53 -149 157 106 ;
C 185 ; WX 333 ; N quotedblbase ; B 26 -149 295 106 ;
C 186 ; WX 333 ; N quotedblright ; B 26 463 295 718 ;
C 187 ; WX 556 ; N guillemotright ; B 97 108 459 446 ;
C 188 ; WX 1000 ; N ellipsis ; B 115 0 885 106 ;
C 189 ; WX 1000 ; N perthousand ; B 7 -19 994 703 ;
C 191 ; WX 611 ; N questiondown ; B 91 -201 527 525 ;
C 193 ; WX 333 ; N grave ; B 14 593 211 734 ;
C 194 ; WX 333 ; N acute ; B 122 593 319 734 ;
C 195 ; WX 333 ; N circumflex ; B 21 593 312 734 ;
C 196 ; WX 333 ; N tilde ; B -4 606 337 722 ;
C 197 ; WX 333 ; N macron ; B 10 627 323 684 ;
C 198 ; WX 333 ; N breve ; B 13 595 321 731 ;
C 199 ; WX 333 ; N dotaccent ; B 121 604 212 706 ;
C 200 ; WX 333 ; N dieresis ; B 40 604 293 706 ;
C 202 ; WX 333 ; N ring ; B 75 572 259 756 ;
C 203 ; WX 333 ; N cedilla ; B 45 -225 259 0 ;
C 205 ; WX 333 ; N hungarumlaut ; B 31 593 409 734 ;
C 206 ; WX 333 ; N ogonek ; B 73 -225 287 0 ;
C 207 ; WX 333 ; N caron ; B 21 593 312 734 ;
C 208 ; WX 1000 ; N emdash ; B 0 240 1000 313 ;
C 225 ; WX 1000 ; N AE ; B 8 0 951 718 ;
C 227 ; WX 370 ; N ordfeminine ; B 24 405 346 737 ;
C 232 ; WX 556 ; N Lslash ; B -20 0 537 718 ;
C 233 ; WX 778 ; N Oslash ; B 39 -19 740 737 ;
C 234 ; WX 1000 ; N OE ; B 36 -19 965 737 ;
C 235 ; WX 365 ; N ordmasculine ; B 25 405 341 737 ;
C 241 ; WX 889 ; N ae ; B 36 -15 847 538 ;
C 245 ; WX 278 ; N dotlessi ; B 95 0 183 523 ;
C 248 ; WX 222 ; N lslash ; B -20 0 242 718 ;
C 249 ; WX 611 ; N oslash ; B 28 -22 537 545 ;
C 250 ; WX 944 ; N oe ; B 35 -15 902 538 ;
C 251 ; WX 611 ; N germandbls ; B 67 -15 571 728 ;
C -1 ; WX 278 ; N Idieresis ; B 13 0 266 901 ;
C -1 ; WX 556 ; N eacute ; B 40 -15 516 734 ;
C -1 ; WX 556 ; N abreve ; B 36 -15 530 731 ;
C -1 ; WX 556 ; N uhungarumlaut ; B 68 -15 521 734 ;
C -1 ; WX 556 ; N ecaron ; B 40 -15 516 734 ;
C -1 ; WX 667 ; N Ydieresis ; B 14 0 653 901 ;
C -1 ; WX 584 ; N divide ; B 39 -19 545 524 ;
C -1 ; WX 667 ; N Yacute ; B 14 0 653 929 ;
C -1 ; WX 667 ; N Acircumflex ; B 14 0 654 929 ;
C -1 ; WX 556 ; N aacute ; B 36 -15 530 734 ;
C -1 ; WX 722 ; N Ucircumflex ; B 79 -19 644 929 ;
C -1 ; WX 500 ; N yacute ; B 11 -214 489 734 ;
C -1 ; WX 500 ; N scommaaccent ; B 32 -225 464 538 ;
C -1 ; WX 556 ; N ecircumflex ; B 40 -15 516 734 ;
C -1 ; WX 722 ; N Uring ; B 79 -19 644 931 ;
C -1 ; WX 722 ; N Udieresis ; B 79 -19 644 901 ;
C -1 ; WX 556 ; N aogonek ; B 36 -220 547 538 ;
C -1 ; WX 722 ; N Uacute ; B 79 -19 644 929 ;
C -1 ; WX 556 ; N uogonek ; B 68 -225 519 523 ;
C -1 ; WX 667 ; N Edieresis ; B 86 0 616 901 ;
C -1 ; WX 722 ; N Dcroat ; B 0 0 674 718 ;
C -1 ; WX 250 ; N commaaccent ; B 87 -225 181 -40 ;
C -1 ; WX 737 ; N copyright ; B -14 -19 752 737 ;
C -1 ; WX 667 ; N Emacron ; B 86 0 616 879 ;
C -1 ; WX 500 ; N ccaron ; B 30 -15 477 734 ;
C -1 ; WX 556 ; N aring ; B 36 -15 530 756 ;
C -1 ; WX 722 ; N Ncommaaccent ; B 76 -225 646 718 ;
C -1 ; WX 222 ; N lacute ; B 67 0 264 929 ;
C -1 ; WX 556 ; N agrave ; B 36 -15 530 734 ;
C -1 ; WX 611 ; N Tcommaaccent ; B 14 -225 597 718 ;
C -1 ; WX 722 ; N Cacute ; B 44 -19 681 929 ;
C -1 ; WX 556 ; N atilde ; B 36 -15 530 722 ;
C -1 ; WX 667 ; N Edotaccent ; B 86 0 616 901 ;
C -1 ; WX 500 ; N scaron ; B 32 -15 464 734 ;
C -1 ; WX 500 ; N scedilla ; B 32 -225 464 538 ;
C -1 ; WX 278 ; N iacute ; B 95 0 292 734 ;
C -1 ; WX 471 ; N lozenge ; B 10 0 462 728 ;
C -1 ; WX 722 ; N Rcaron ; B 88 0 684 929 ;
C -1 ; WX 778 ; N Gcommaaccent ; B 48 -225 704 737 ;
C -1 ; WX 556 ; N ucircumflex ; B 68 -15 489 734 ;
C -1 ; WX 556 ; N acircumflex ; B 36 -15 530 734 ;
C -1 ; WX 667 ; N Amacron ; B 14 0 654 879 ;
C -1 ; WX 333 ; N rcaron ; B 61 0 352 734 ;
C -1 ; WX 500 ; N ccedilla ; B 30 -225 477 538 ;
C -1 ; WX 611 ; N Zdotaccent ; B 23 0 588 901 ;
C -1 ; WX 667 ; N Thorn ; B 86 0 622 718 ;
C -1 ; WX 778 ; N Omacron ; B 39 -19 739 879 ;
C -1 ; WX 722 ; N Racute ; B 88 0 684 929 ;
C -1 ; WX 667 ; N Sacute ; B 49 -19 620 929 ;
C -1 ; WX 643 ; N dcaron ; B 35 -15 655 718 ;
C -1 ; WX 722 ; N Umacron ; B 79 -19 644 879 ;
C -1 ; WX 556 ; N uring ; B 68 -15 489 756 ;
C -1 ; WX 333 ; N threesuperior ; B 5 270 325 703 ;
C -1 ; WX 778 ; N Ograve ; B 39 -19 739 929 ;
C -1 ; WX 667 ; N Agrave ; B 14 0 654 929 ;
C -1 ; WX 667 ; N Abreve ; B 14 0 654 926 ;
C -1 ; WX 584 ; N multiply ; B 39 0 545 506 ;
C -1 ; WX 556 ; N uacute ; B 68 -15 489 734 ;
C -1 ; WX 611 ; N Tcaron ; B 14 0 597 929 ;
C -1 ; WX 476 ; N partialdiff ; B 13 -38 463 714 ;
C -1 ; WX 500 ; N ydieresis ; B 11 -214 489 706 ;
C -1 ; WX 722 ; N Nacute ; B 76 0 646 929 ;
C -1 ; WX 278 ; N icircumflex ; B -6 0 285 734 ;
C -1 ; WX 667 ; N Ecircumflex ; B 86 0 616 929 ;
C -1 ; WX 556 ; N adieresis ; B 36 -15 530 706 ;
C -1 ; WX 556 ; N edieresis ; B 40 -15 516 706 ;
C -1 ; WX 500 ; N cacute ; B 30 -15 477 734 ;
C -1 ; WX 556 ; N nacute ; B 65 0 491 734 ;
C -1 ; WX 556 ; N umacron ; B 68 -15 489 684 ;
C -1 ; WX 722 ; N Ncaron ; B 76 0 646 929 ;
C -1 ; WX 278 ; N Iacute ; B 91 0 292 929 ;
C -1 ; WX 584 ; N plusminus ; B 39 0 545 506 ;
C -1 ; WX 260 ; N brokenbar ; B 94 -150 167 700 ;
C -1 ; WX 737 ; N registered ; B -14 -19 752 737 ;
C -1 ; WX 778 ; N Gbreve ; B 48 -19 704 926 ;
C -1 ; WX 278 ; N Idotaccent ; B 91 0 188 901 ;
C -1 ; WX 600 ; N summation ; B 15 -10 586 706 ;
C -1 ; WX 667 ; N Egrave ; B 86 0 616 929 ;
C -1 ; WX 333 ; N racute ; B 77 0 332 734 ;
C -1 ; WX 556 ; N omacron ; B 35 -14 521 684 ;
C -1 ; WX 611 ; N Zacute ; B 23 0 588 929 ;
C -1 ; WX 611 ; N Zcaron ; B 23 0 588 929 ;
C -1 ; WX 549 ; N greaterequal ; B 26 0 523 674 ;
C -1 ; WX 722 ; N Eth ; B 0 0 674 718 ;
C -1 ; WX 722 ; N Ccedilla ; B 44 -225 681 737 ;
C -1 ; WX 222 ; N lcommaaccent ; B 67 -225 167 718 ;
C -1 ; WX 317 ; N tcaron ; B 14 -7 329 808 ;
C -1 ; WX 556 ; N eogonek ; B 40 -225 516 538 ;
C -1 ; WX 722 ; N Uogonek ; B 79 -225 644 718 ;
C -1 ; WX 667 ; N Aacute ; B 14 0 654 929 ;
C -1 ; WX 667 ; N Adieresis ; B 14 0 654 901 ;
C -1 ; WX 556 ; N egrave ; B 40 -15 516 734 ;
C -1 ; WX 500 ; N zacute ; B 31 0 469 734 ;
C -1 ; WX 222 ; N iogonek ; B -31 -225 183 718 ;
C -1 ; WX 778 ; N Oacute ; B 39 -19 739 929 ;
C -1 ; WX 556 ; N oacute ; B 35 -14 521 734 ;
C -1 ; WX 556 ; N amacron ; B 36 -15 530 684 ;
C -1 ; WX 500 ; N sacute ; B 32 -15 464 734 ;
C -1 ; WX 278 ; N idieresis ; B 13 0 266 706 ;
C -1 ; WX 778 ; N Ocircumflex ; B 39 -19 739 929 ;
C -1 ; WX 722 ; N Ugrave ; B 79 -19 644 929 ;
C -1 ; WX 612 ; N Delta ; B 6 0 608 688 ;
C -1 ; WX 556 ; N thorn ; B 58 -207 517 718 ;
C -1 ; WX 333 ; N twosuperior ; B 4 281 323 703 ;
C -1 ; WX 778 ; N Odieresis ; B 39 -19 739 901 ;
C -1 ; WX 556 ; N mu ; B 68 -207 489 523 ;
C -1 ; WX 278 ; N igrave ; B -13 0 184 734 ;
C -1 ; WX 556 ; N ohungarumlaut ; B 35 -14 521 734 ;
C -1 ; WX 667 ; N Eogonek ; B 86 -220 633 718 ;
C -1 ; WX 556 ; N dcroat ; B 35 -15 550 718 ;
C -1 ; WX 834 ; N threequarters ; B 45 -19 810 703 ;
C -1 ; WX 667 ; N Scedilla ; B 49 -225 620 737 ;
C -1 ; WX 299 ; N lcaron ; B 67 0 311 718 ;
C -1 ; WX 667 ; N Kcommaaccent ; B 76 -225 663 718 ;
C -1 ; WX 556 ; N Lacute ; B 76 0 537 929 ;
C -1 ; WX 1000 ; N trademark ; B 46 306 903 718 ;
C -1 ; WX 556 ; N edotaccent ; B 40 -15 516 706 ;
C -1 ; WX 278 ; N Igrave ; B -13 0 188 929 ;
C -1 ; WX 278 ; N Imacron ; B -17 0 296 879 ;
C -1 ; WX 556 ; N Lcaron ; B 76 0 537 718 ;
C -1 ; WX 834 ; N onehalf ; B 43 -19 773 703 ;
C -1 ; WX 549 ; N lessequal ; B 26 0 523 674 ;
C -1 ; WX 556 ; N ocircumflex ; B 35 -14 521 734 ;
C -1 ; WX 556 ; N ntilde ; B 65 0 491 722 ;
C -1 ; WX 722 ; N Uhungarumlaut ; B 79 -19 644 929 ;
C -1 ; WX 667 ; N Eacute ; B 86 0 616 929 ;
C -1 ; WX 556 ; N emacron ; B 40 -15 516 684 ;
C -1 ; WX 556 ; N gbreve ; B 40 -220 499 731 ;
C -1 ; WX 834 ; N onequarter ; B 73 -19 756 703 ;
C -1 ; WX 667 ; N Scaron ; B 49 -19 620 929 ;
C -1 ; WX 667 ; N Scommaaccent ; B 49 -225 620 737 ;
C -1 ; WX 778 ; N Ohungarumlaut ; B 39 -19 739 929 ;
C -1 ; WX 400 ; N degree ; B 54 411 346 703 ;
C -1 ; WX 556 ; N ograve ; B 35 -14 521 734 ;
C -1 ; WX 722 ; N Ccaron ; B 44 -19 681 929 ;
C -1 ; WX 556 ; N ugrave ; B 68 -15 489 734 ;
C -1 ; WX 453 ; N radical ; B -4 -80 458 762 ;
C -1 ; WX 722 ; N Dcaron ; B 81 0 674 929 ;
C -1 ; WX 333 ; N rcommaaccent ; B 77 -225 332 538 ;
C -1 ; WX 722 ; N Ntilde ; B 76 0 646 917 ;
C -1 ; WX 556 ; N otilde ; B 35 -14 521 722 ;
C -1 ; WX 722 ; N Rcommaaccent ; B 88 -225 684 718 ;
C -1 ; WX 556 ; N Lcommaaccent ; B 76 -225 537 718 ;
C -1 ; WX 667 ; N Atilde ; B 14 0 654 917 ;
C -1 ; WX 667 ; N Aogonek ; B 14 -225 654 718 ;
C -1 ; WX 667 ; N Aring ; B 14 0 654 931 ;
C -1 ; WX 778 ; N Otilde ; B 39 -19 739 917 ;
C -1 ; WX 500 ; N zdotaccent ; B 31 0 469 706 ;
C -1 ; WX 667 ; N Ecaron ; B 86 0 616 929 ;
C -1 ; WX 278 ; N Iogonek ; B -3 -225 211 718 ;
C -1 ; WX 500 ; N kcommaaccent ; B 67 -225 501 718 ;
C -1 ; WX 584 ; N minus ; B 39 216 545 289 ;
C -1 ; WX 278 ; N Icircumflex ; B -6 0 285 929 ;
C -1 ; WX 556 ; N ncaron ; B 65 0 491 734 ;
C -1 ; WX 278 ; N tcommaaccent ; B 14 -225 257 669 ;
C -1 ; WX 584 ; N logicalnot ; B 39 108 545 390 ;
C -1 ; WX 556 ; N odieresis ; B 35 -14 521 706 ;
C -1 ; WX 556 ; N udieresis ; B 68 -15 489 706 ;
C -1 ; WX 549 ; N notequal ; B 12 -35 537 551 ;
C -1 ; WX 556 ; N gcommaaccent ; B 40 -220 499 822 ;
C -1 ; WX 556 ; N eth ; B 35 -15 522 737 ;
C -1 ; WX 500 ; N zcaron ; B 31 0 469 734 ;
C -1 ; WX 556 ; N ncommaaccent ; B 65 -225 491 538 ;
C -1 ; WX 333 ; N onesuperior ; B 43 281 222 703 ;
C -1 ; WX 278 ; N imacron ; B 5 0 272 684 ;
C -1 ; WX 556 ; N Euro ; B 0 0 0 0 ;
EndCharMetrics
StartKernData
StartKernPairs 2705
KPX A C -30
KPX A Cacute -30
KPX A Ccaron -30
KPX A Ccedilla -30
KPX A G -30
KPX A Gbreve -30
KPX A Gcommaaccent -30
KPX A O -30
KPX A Oacute -30
KPX A Ocircumflex -30
KPX A Odieresis -30
KPX A Ograve -30
KPX A Ohungarumlaut -30
KPX A Omacron -30
KPX A Oslash -30
KPX A Otilde -30
KPX A Q -30
KPX A T -120
KPX A Tcaron -120
KPX A Tcommaaccent -120
KPX A U -50
KPX A Uacute -50
KPX A Ucircumflex -50
KPX A Udieresis -50
KPX A Ugrave -50
KPX A Uhungarumlaut -50
KPX A Umacron -50
KPX A Uogonek -50
KPX A Uring -50
KPX A V -70
KPX A W -50
KPX A Y -100
KPX A Yacute -100
KPX A Ydieresis -100
KPX A u -30
KPX A uacute -30
KPX A ucircumflex -30
KPX A udieresis -30
KPX A ugrave -30
KPX A uhungarumlaut -30
KPX A umacron -30
KPX A uogonek -30
KPX A uring -30
KPX A v -40
KPX A w -40
KPX A y -40
KPX A yacute -40
KPX A ydieresis -40
KPX Aacute C -30
KPX Aacute Cacute -30
KPX Aacute Ccaron -30
KPX Aacute Ccedilla -30
KPX Aacute G -30
KPX Aacute Gbreve -30
KPX Aacute Gcommaaccent -30
KPX Aacute O -30
KPX Aacute Oacute -30
KPX Aacute Ocircumflex -30
KPX Aacute Odieresis -30
KPX Aacute Ograve -30
KPX Aacute Ohungarumlaut -30
KPX Aacute Omacron -30
KPX Aacute Oslash -30
KPX Aacute Otilde -30
KPX Aacute Q -30
KPX Aacute T -120
KPX Aacute Tcaron -120
KPX Aacute Tcommaaccent -120
KPX Aacute U -50
KPX Aacute Uacute -50
KPX Aacute Ucircumflex -50
KPX Aacute Udieresis -50
KPX Aacute Ugrave -50
KPX Aacute Uhungarumlaut -50
KPX Aacute Umacron -50
KPX Aacute Uogonek -50
KPX Aacute Uring -50
KPX Aacute V -70
KPX Aacute W -50
KPX Aacute Y -100
KPX Aacute Yacute -100
KPX Aacute Ydieresis -100
KPX Aacute u -30
KPX Aacute uacute -30
KPX Aacute ucircumflex -30
KPX Aacute udieresis -30
KPX Aacute ugrave -30
KPX Aacute uhungarumlaut -30
KPX Aacute umacron -30
KPX Aacute uogonek -30
KPX Aacute uring -30
KPX Aacute v -40
KPX Aacute w -40
KPX Aacute y -40
KPX Aacute yacute -40
KPX Aacute ydieresis -40
KPX Abreve C -30
KPX Abreve Cacute -30
KPX Abreve Ccaron -30
KPX Abreve Ccedilla -30
KPX Abreve G -30
KPX Abreve Gbreve -30
KPX Abreve Gcommaaccent -30
KPX Abreve O -30
KPX Abreve Oacute -30
KPX Abreve Ocircumflex -30
KPX Abreve Odieresis -30
KPX Abreve Ograve -30
KPX Abreve Ohungarumlaut -30
KPX Abreve Omacron -30
KPX Abreve Oslash -30
KPX Abreve Otilde -30
KPX Abreve Q -30
KPX Abreve T -120
KPX Abreve Tcaron -120
KPX Abreve Tcommaaccent -120
KPX Abreve U -50
KPX Abreve Uacute -50
KPX Abreve Ucircumflex -50
KPX Abreve Udieresis -50
KPX Abreve Ugrave -50
KPX Abreve Uhungarumlaut -50
KPX Abreve Umacron -50
KPX Abreve Uogonek -50
KPX Abreve Uring -50
KPX Abreve V -70
KPX Abreve W -50
KPX Abreve Y -100
KPX Abreve Yacute -100
KPX Abreve Ydieresis -100
KPX Abreve u -30
KPX Abreve uacute -30
KPX Abreve ucircumflex -30
KPX Abreve udieresis -30
KPX Abreve ugrave -30
KPX Abreve uhungarumlaut -30
KPX Abreve umacron -30
KPX Abreve uogonek -30
KPX Abreve uring -30
KPX Abreve v -40
KPX Abreve w -40
KPX Abreve y -40
KPX Abreve yacute -40
KPX Abreve ydieresis -40
KPX Acircumflex C -30
KPX Acircumflex Cacute -30
KPX Acircumflex Ccaron -30
KPX Acircumflex Ccedilla -30
KPX Acircumflex G -30
KPX Acircumflex Gbreve -30
KPX Acircumflex Gcommaaccent -30
KPX Acircumflex O -30
KPX Acircumflex Oacute -30
KPX Acircumflex Ocircumflex -30
KPX Acircumflex Odieresis -30
KPX Acircumflex Ograve -30
KPX Acircumflex Ohungarumlaut -30
KPX Acircumflex Omacron -30
KPX Acircumflex Oslash -30
KPX Acircumflex Otilde -30
KPX Acircumflex Q -30
KPX Acircumflex T -120
KPX Acircumflex Tcaron -120
KPX Acircumflex Tcommaaccent -120
KPX Acircumflex U -50
KPX Acircumflex Uacute -50
KPX Acircumflex Ucircumflex -50
KPX Acircumflex Udieresis -50
KPX Acircumflex Ugrave -50
KPX Acircumflex Uhungarumlaut -50
KPX Acircumflex Umacron -50
KPX Acircumflex Uogonek -50
KPX Acircumflex Uring -50
KPX Acircumflex V -70
KPX Acircumflex W -50
KPX Acircumflex Y -100
KPX Acircumflex Yacute -100
KPX Acircumflex Ydieresis -100
KPX Acircumflex u -30
KPX Acircumflex uacute -30
KPX Acircumflex ucircumflex -30
KPX Acircumflex udieresis -30
KPX Acircumflex ugrave -30
KPX Acircumflex uhungarumlaut -30
KPX Acircumflex umacron -30
KPX Acircumflex uogonek -30
KPX Acircumflex uring -30
KPX Acircumflex v -40
KPX Acircumflex w -40
KPX Acircumflex y -40
KPX Acircumflex yacute -40
KPX Acircumflex ydieresis -40
KPX Adieresis C -30
KPX Adieresis Cacute -30
KPX Adieresis Ccaron -30
KPX Adieresis Ccedilla -30
KPX Adieresis G -30
KPX Adieresis Gbreve -30
KPX Adieresis Gcommaaccent -30
KPX Adieresis O -30
KPX Adieresis Oacute -30
KPX Adieresis Ocircumflex -30
KPX Adieresis Odieresis -30
KPX Adieresis Ograve -30
KPX Adieresis Ohungarumlaut -30
KPX Adieresis Omacron -30
KPX Adieresis Oslash -30
KPX Adieresis Otilde -30
KPX Adieresis Q -30
KPX Adieresis T -120
KPX Adieresis Tcaron -120
KPX Adieresis Tcommaaccent -120
KPX Adieresis U -50
KPX Adieresis Uacute -50
KPX Adieresis Ucircumflex -50
KPX Adieresis Udieresis -50
KPX Adieresis Ugrave -50
KPX Adieresis Uhungarumlaut -50
KPX Adieresis Umacron -50
KPX Adieresis Uogonek -50
KPX Adieresis Uring -50
KPX Adieresis V -70
KPX Adieresis W -50
KPX Adieresis Y -100
KPX Adieresis Yacute -100
KPX Adieresis Ydieresis -100
KPX Adieresis u -30
KPX Adieresis uacute -30
KPX Adieresis ucircumflex -30
KPX Adieresis udieresis -30
KPX Adieresis ugrave -30
KPX Adieresis uhungarumlaut -30
KPX Adieresis umacron -30
KPX Adieresis uogonek -30
KPX Adieresis uring -30
KPX Adieresis v -40
KPX Adieresis w -40
KPX Adieresis y -40
KPX Adieresis yacute -40
KPX Adieresis ydieresis -40
KPX Agrave C -30
KPX Agrave Cacute -30
KPX Agrave Ccaron -30
KPX Agrave Ccedilla -30
KPX Agrave G -30
KPX Agrave Gbreve -30
KPX Agrave Gcommaaccent -30
KPX Agrave O -30
KPX Agrave Oacute -30
KPX Agrave Ocircumflex -30
KPX Agrave Odieresis -30
KPX Agrave Ograve -30
KPX Agrave Ohungarumlaut -30
KPX Agrave Omacron -30
KPX Agrave Oslash -30
KPX Agrave Otilde -30
KPX Agrave Q -30
KPX Agrave T -120
KPX Agrave Tcaron -120
KPX Agrave Tcommaaccent -120
KPX Agrave U -50
KPX Agrave Uacute -50
KPX Agrave Ucircumflex -50
KPX Agrave Udieresis -50
KPX Agrave Ugrave -50
KPX Agrave Uhungarumlaut -50
KPX Agrave Umacron -50
KPX Agrave Uogonek -50
KPX Agrave Uring -50
KPX Agrave V -70
KPX Agrave W -50
KPX Agrave Y -100
KPX Agrave Yacute -100
KPX Agrave Ydieresis -100
KPX Agrave u -30
KPX Agrave uacute -30
KPX Agrave ucircumflex -30
KPX Agrave udieresis -30
KPX Agrave ugrave -30
KPX Agrave uhungarumlaut -30
KPX Agrave umacron -30
KPX Agrave uogonek -30
KPX Agrave uring -30
KPX Agrave v -40
KPX Agrave w -40
KPX Agrave y -40
KPX Agrave yacute -40
KPX Agrave ydieresis -40
KPX Amacron C -30
KPX Amacron Cacute -30
KPX Amacron Ccaron -30
KPX Amacron Ccedilla -30
KPX Amacron G -30
KPX Amacron Gbreve -30
KPX Amacron Gcommaaccent -30
KPX Amacron O -30
KPX Amacron Oacute -30
KPX Amacron Ocircumflex -30
KPX Amacron Odieresis -30
KPX Amacron Ograve -30
KPX Amacron Ohungarumlaut -30
KPX Amacron Omacron -30
KPX Amacron Oslash -30
KPX Amacron Otilde -30
KPX Amacron Q -30
KPX Amacron T -120
KPX Amacron Tcaron -120
KPX Amacron Tcommaaccent -120
KPX Amacron U -50
KPX Amacron Uacute -50
KPX Amacron Ucircumflex -50
KPX Amacron Udieresis -50
KPX Amacron Ugrave -50
KPX Amacron Uhungarumlaut -50
KPX Amacron Umacron -50
KPX Amacron Uogonek -50
KPX Amacron Uring -50
KPX Amacron V -70
KPX Amacron W -50
KPX Amacron Y -100
KPX Amacron Yacute -100
KPX Amacron Ydieresis -100
KPX Amacron u -30
KPX Amacron uacute -30
KPX Amacron ucircumflex -30
KPX Amacron udieresis -30
KPX Amacron ugrave -30
KPX Amacron uhungarumlaut -30
KPX Amacron umacron -30
KPX Amacron uogonek -30
KPX Amacron uring -30
KPX Amacron v -40
KPX Amacron w -40
KPX Amacron y -40
KPX Amacron yacute -40
KPX Amacron ydieresis -40
KPX Aogonek C -30
KPX Aogonek Cacute -30
KPX Aogonek Ccaron -30
KPX Aogonek Ccedilla -30
KPX Aogonek G -30
KPX Aogonek Gbreve -30
KPX Aogonek Gcommaaccent -30
KPX Aogonek O -30
KPX Aogonek Oacute -30
KPX Aogonek Ocircumflex -30
KPX Aogonek Odieresis -30
KPX Aogonek Ograve -30
KPX Aogonek Ohungarumlaut -30
KPX Aogonek Omacron -30
KPX Aogonek Oslash -30
KPX Aogonek Otilde -30
KPX Aogonek Q -30
KPX Aogonek T -120
KPX Aogonek Tcaron -120
KPX Aogonek Tcommaaccent -120
KPX Aogonek U -50
KPX Aogonek Uacute -50
KPX Aogonek Ucircumflex -50
KPX Aogonek Udieresis -50
KPX Aogonek Ugrave -50
KPX Aogonek Uhungarumlaut -50
KPX Aogonek Umacron -50
KPX Aogonek Uogonek -50
KPX Aogonek Uring -50
KPX Aogonek V -70
KPX Aogonek W -50
KPX Aogonek Y -100
KPX Aogonek Yacute -100
KPX Aogonek Ydieresis -100
KPX Aogonek u -30
KPX Aogonek uacute -30
KPX Aogonek ucircumflex -30
KPX Aogonek udieresis -30
KPX Aogonek ugrave -30
KPX Aogonek uhungarumlaut -30
KPX Aogonek umacron -30
KPX Aogonek uogonek -30
KPX Aogonek uring -30
KPX Aogonek v -40
KPX Aogonek w -40
KPX Aogonek y -40
KPX Aogonek yacute -40
KPX Aogonek ydieresis -40
KPX Aring C -30
KPX Aring Cacute -30
KPX Aring Ccaron -30
KPX Aring Ccedilla -30
KPX Aring G -30
KPX Aring Gbreve -30
KPX Aring Gcommaaccent -30
KPX Aring O -30
KPX Aring Oacute -30
KPX Aring Ocircumflex -30
KPX Aring Odieresis -30
KPX Aring Ograve -30
KPX Aring Ohungarumlaut -30
KPX Aring Omacron -30
KPX Aring Oslash -30
KPX Aring Otilde -30
KPX Aring Q -30
KPX Aring T -120
KPX Aring Tcaron -120
KPX Aring Tcommaaccent -120
KPX Aring U -50
KPX Aring Uacute -50
KPX Aring Ucircumflex -50
KPX Aring Udieresis -50
KPX Aring Ugrave -50
KPX Aring Uhungarumlaut -50
KPX Aring Umacron -50
KPX Aring Uogonek -50
KPX Aring Uring -50
KPX Aring V -70
KPX Aring W -50
KPX Aring Y -100
KPX Aring Yacute -100
KPX Aring Ydieresis -100
KPX Aring u -30
KPX Aring uacute -30
KPX Aring ucircumflex -30
KPX Aring udieresis -30
KPX Aring ugrave -30
KPX Aring uhungarumlaut -30
KPX Aring umacron -30
KPX Aring uogonek -30
KPX Aring uring -30
KPX Aring v -40
KPX Aring w -40
KPX Aring y -40
KPX Aring yacute -40
KPX Aring ydieresis -40
KPX Atilde C -30
KPX Atilde Cacute -30
KPX Atilde Ccaron -30
KPX Atilde Ccedilla -30
KPX Atilde G -30
KPX Atilde Gbreve -30
KPX Atilde Gcommaaccent -30
KPX Atilde O -30
KPX Atilde Oacute -30
KPX Atilde Ocircumflex -30
KPX Atilde Odieresis -30
KPX Atilde Ograve -30
KPX Atilde Ohungarumlaut -30
KPX Atilde Omacron -30
KPX Atilde Oslash -30
KPX Atilde Otilde -30
KPX Atilde Q -30
KPX Atilde T -120
KPX Atilde Tcaron -120
KPX Atilde Tcommaaccent -120
KPX Atilde U -50
KPX Atilde Uacute -50
KPX Atilde Ucircumflex -50
KPX Atilde Udieresis -50
KPX Atilde Ugrave -50
KPX Atilde Uhungarumlaut -50
KPX Atilde Umacron -50
KPX Atilde Uogonek -50
KPX Atilde Uring -50
KPX Atilde V -70
KPX Atilde W -50
KPX Atilde Y -100
KPX Atilde Yacute -100
KPX Atilde Ydieresis -100
KPX Atilde u -30
KPX Atilde uacute -30
KPX Atilde ucircumflex -30
KPX Atilde udieresis -30
KPX Atilde ugrave -30
KPX Atilde uhungarumlaut -30
KPX Atilde umacron -30
KPX Atilde uogonek -30
KPX Atilde uring -30
KPX Atilde v -40
KPX Atilde w -40
KPX Atilde y -40
KPX Atilde yacute -40
KPX Atilde ydieresis -40
KPX B U -10
KPX B Uacute -10
KPX B Ucircumflex -10
KPX B Udieresis -10
KPX B Ugrave -10
KPX B Uhungarumlaut -10
KPX B Umacron -10
KPX B Uogonek -10
KPX B Uring -10
KPX B comma -20
KPX B period -20
KPX C comma -30
KPX C period -30
KPX Cacute comma -30
KPX Cacute period -30
KPX Ccaron comma -30
KPX Ccaron period -30
KPX Ccedilla comma -30
KPX Ccedilla period -30
KPX D A -40
KPX D Aacute -40
KPX D Abreve -40
KPX D Acircumflex -40
KPX D Adieresis -40
KPX D Agrave -40
KPX D Amacron -40
KPX D Aogonek -40
KPX D Aring -40
KPX D Atilde -40
KPX D V -70
KPX D W -40
KPX D Y -90
KPX D Yacute -90
KPX D Ydieresis -90
KPX D comma -70
KPX D period -70
KPX Dcaron A -40
KPX Dcaron Aacute -40
KPX Dcaron Abreve -40
KPX Dcaron Acircumflex -40
KPX Dcaron Adieresis -40
KPX Dcaron Agrave -40
KPX Dcaron Amacron -40
KPX Dcaron Aogonek -40
KPX Dcaron Aring -40
KPX Dcaron Atilde -40
KPX Dcaron V -70
KPX Dcaron W -40
KPX Dcaron Y -90
KPX Dcaron Yacute -90
KPX Dcaron Ydieresis -90
KPX Dcaron comma -70
KPX Dcaron period -70
KPX Dcroat A -40
KPX Dcroat Aacute -40
KPX Dcroat Abreve -40
KPX Dcroat Acircumflex -40
KPX Dcroat Adieresis -40
KPX Dcroat Agrave -40
KPX Dcroat Amacron -40
KPX Dcroat Aogonek -40
KPX Dcroat Aring -40
KPX Dcroat Atilde -40
KPX Dcroat V -70
KPX Dcroat W -40
KPX Dcroat Y -90
KPX Dcroat Yacute -90
KPX Dcroat Ydieresis -90
KPX Dcroat comma -70
KPX Dcroat period -70
KPX F A -80
KPX F Aacute -80
KPX F Abreve -80
KPX F Acircumflex -80
KPX F Adieresis -80
KPX F Agrave -80
KPX F Amacron -80
KPX F Aogonek -80
KPX F Aring -80
KPX F Atilde -80
KPX F a -50
KPX F aacute -50
KPX F abreve -50
KPX F acircumflex -50
KPX F adieresis -50
KPX F agrave -50
KPX F amacron -50
KPX F aogonek -50
KPX F aring -50
KPX F atilde -50
KPX F comma -150
KPX F e -30
KPX F eacute -30
KPX F ecaron -30
KPX F ecircumflex -30
KPX F edieresis -30
KPX F edotaccent -30
KPX F egrave -30
KPX F emacron -30
KPX F eogonek -30
KPX F o -30
KPX F oacute -30
KPX F ocircumflex -30
KPX F odieresis -30
KPX F ograve -30
KPX F ohungarumlaut -30
KPX F omacron -30
KPX F oslash -30
KPX F otilde -30
KPX F period -150
KPX F r -45
KPX F racute -45
KPX F rcaron -45
KPX F rcommaaccent -45
KPX J A -20
KPX J Aacute -20
KPX J Abreve -20
KPX J Acircumflex -20
KPX J Adieresis -20
KPX J Agrave -20
KPX J Amacron -20
KPX J Aogonek -20
KPX J Aring -20
KPX J Atilde -20
KPX J a -20
KPX J aacute -20
KPX J abreve -20
KPX J acircumflex -20
KPX J adieresis -20
KPX J agrave -20
KPX J amacron -20
KPX J aogonek -20
KPX J aring -20
KPX J atilde -20
KPX J comma -30
KPX J period -30
KPX J u -20
KPX J uacute -20
KPX J ucircumflex -20
KPX J udieresis -20
KPX J ugrave -20
KPX J uhungarumlaut -20
KPX J umacron -20
KPX J uogonek -20
KPX J uring -20
KPX K O -50
KPX K Oacute -50
KPX K Ocircumflex -50
KPX K Odieresis -50
KPX K Ograve -50
KPX K Ohungarumlaut -50
KPX K Omacron -50
KPX K Oslash -50
KPX K Otilde -50
KPX K e -40
KPX K eacute -40
KPX K ecaron -40
KPX K ecircumflex -40
KPX K edieresis -40
KPX K edotaccent -40
KPX K egrave -40
KPX K emacron -40
KPX K eogonek -40
KPX K o -40
KPX K oacute -40
KPX K ocircumflex -40
KPX K odieresis -40
KPX K ograve -40
KPX K ohungarumlaut -40
KPX K omacron -40
KPX K oslash -40
KPX K otilde -40
KPX K u -30
KPX K uacute -30
KPX K ucircumflex -30
KPX K udieresis -30
KPX K ugrave -30
KPX K uhungarumlaut -30
KPX K umacron -30
KPX K uogonek -30
KPX K uring -30
KPX K y -50
KPX K yacute -50
KPX K ydieresis -50
KPX Kcommaaccent O -50
KPX Kcommaaccent Oacute -50
KPX Kcommaaccent Ocircumflex -50
KPX Kcommaaccent Odieresis -50
KPX Kcommaaccent Ograve -50
KPX Kcommaaccent Ohungarumlaut -50
KPX Kcommaaccent Omacron -50
KPX Kcommaaccent Oslash -50
KPX Kcommaaccent Otilde -50
KPX Kcommaaccent e -40
KPX Kcommaaccent eacute -40
KPX Kcommaaccent ecaron -40
KPX Kcommaaccent ecircumflex -40
KPX Kcommaaccent edieresis -40
KPX Kcommaaccent edotaccent -40
KPX Kcommaaccent egrave -40
KPX Kcommaaccent emacron -40
KPX Kcommaaccent eogonek -40
KPX Kcommaaccent o -40
KPX Kcommaaccent oacute -40
KPX Kcommaaccent ocircumflex -40
KPX Kcommaaccent odieresis -40
KPX Kcommaaccent ograve -40
KPX Kcommaaccent ohungarumlaut -40
KPX Kcommaaccent omacron -40
KPX Kcommaaccent oslash -40
KPX Kcommaaccent otilde -40
KPX Kcommaaccent u -30
KPX Kcommaaccent uacute -30
KPX Kcommaaccent ucircumflex -30
KPX Kcommaaccent udieresis -30
KPX Kcommaaccent ugrave -30
KPX Kcommaaccent uhungarumlaut -30
KPX Kcommaaccent umacron -30
KPX Kcommaaccent uogonek -30
KPX Kcommaaccent uring -30
KPX Kcommaaccent y -50
KPX Kcommaaccent yacute -50
KPX Kcommaaccent ydieresis -50
KPX L T -110
KPX L Tcaron -110
KPX L Tcommaaccent -110
KPX L V -110
KPX L W -70
KPX L Y -140
KPX L Yacute -140
KPX L Ydieresis -140
KPX L quotedblright -140
KPX L quoteright -160
KPX L y -30
KPX L yacute -30
KPX L ydieresis -30
KPX Lacute T -110
KPX Lacute Tcaron -110
KPX Lacute Tcommaaccent -110
KPX Lacute V -110
KPX Lacute W -70
KPX Lacute Y -140
KPX Lacute Yacute -140
KPX Lacute Ydieresis -140
KPX Lacute quotedblright -140
KPX Lacute quoteright -160
KPX Lacute y -30
KPX Lacute yacute -30
KPX Lacute ydieresis -30
KPX Lcaron T -110
KPX Lcaron Tcaron -110
KPX Lcaron Tcommaaccent -110
KPX Lcaron V -110
KPX Lcaron W -70
KPX Lcaron Y -140
KPX Lcaron Yacute -140
KPX Lcaron Ydieresis -140
KPX Lcaron quotedblright -140
KPX Lcaron quoteright -160
KPX Lcaron y -30
KPX Lcaron yacute -30
KPX Lcaron ydieresis -30
KPX Lcommaaccent T -110
KPX Lcommaaccent Tcaron -110
KPX Lcommaaccent Tcommaaccent -110
KPX Lcommaaccent V -110
KPX Lcommaaccent W -70
KPX Lcommaaccent Y -140
KPX Lcommaaccent Yacute -140
KPX Lcommaaccent Ydieresis -140
KPX Lcommaaccent quotedblright -140
KPX Lcommaaccent quoteright -160
KPX Lcommaaccent y -30
KPX Lcommaaccent yacute -30
KPX Lcommaaccent ydieresis -30
KPX Lslash T -110
KPX Lslash Tcaron -110
KPX Lslash Tcommaaccent -110
KPX Lslash V -110
KPX Lslash W -70
KPX Lslash Y -140
KPX Lslash Yacute -140
KPX Lslash Ydieresis -140
KPX Lslash quotedblright -140
KPX Lslash quoteright -160
KPX Lslash y -30
KPX Lslash yacute -30
KPX Lslash ydieresis -30
KPX O A -20
KPX O Aacute -20
KPX O Abreve -20
KPX O Acircumflex -20
KPX O Adieresis -20
KPX O Agrave -20
KPX O Amacron -20
KPX O Aogonek -20
KPX O Aring -20
KPX O Atilde -20
KPX O T -40
KPX O Tcaron -40
KPX O Tcommaaccent -40
KPX O V -50
KPX O W -30
KPX O X -60
KPX O Y -70
KPX O Yacute -70
KPX O Ydieresis -70
KPX O comma -40
KPX O period -40
KPX Oacute A -20
KPX Oacute Aacute -20
KPX Oacute Abreve -20
KPX Oacute Acircumflex -20
KPX Oacute Adieresis -20
KPX Oacute Agrave -20
KPX Oacute Amacron -20
KPX Oacute Aogonek -20
KPX Oacute Aring -20
KPX Oacute Atilde -20
KPX Oacute T -40
KPX Oacute Tcaron -40
KPX Oacute Tcommaaccent -40
KPX Oacute V -50
KPX Oacute W -30
KPX Oacute X -60
KPX Oacute Y -70
KPX Oacute Yacute -70
KPX Oacute Ydieresis -70
KPX Oacute comma -40
KPX Oacute period -40
KPX Ocircumflex A -20
KPX Ocircumflex Aacute -20
KPX Ocircumflex Abreve -20
KPX Ocircumflex Acircumflex -20
KPX Ocircumflex Adieresis -20
KPX Ocircumflex Agrave -20
KPX Ocircumflex Amacron -20
KPX Ocircumflex Aogonek -20
KPX Ocircumflex Aring -20
KPX Ocircumflex Atilde -20
KPX Ocircumflex T -40
KPX Ocircumflex Tcaron -40
KPX Ocircumflex Tcommaaccent -40
KPX Ocircumflex V -50
KPX Ocircumflex W -30
KPX Ocircumflex X -60
KPX Ocircumflex Y -70
KPX Ocircumflex Yacute -70
KPX Ocircumflex Ydieresis -70
KPX Ocircumflex comma -40
KPX Ocircumflex period -40
KPX Odieresis A -20
KPX Odieresis Aacute -20
KPX Odieresis Abreve -20
KPX Odieresis Acircumflex -20
KPX Odieresis Adieresis -20
KPX Odieresis Agrave -20
KPX Odieresis Amacron -20
KPX Odieresis Aogonek -20
KPX Odieresis Aring -20
KPX Odieresis Atilde -20
KPX Odieresis T -40
KPX Odieresis Tcaron -40
KPX Odieresis Tcommaaccent -40
KPX Odieresis V -50
KPX Odieresis W -30
KPX Odieresis X -60
KPX Odieresis Y -70
KPX Odieresis Yacute -70
KPX Odieresis Ydieresis -70
KPX Odieresis comma -40
KPX Odieresis period -40
KPX Ograve A -20
KPX Ograve Aacute -20
KPX Ograve Abreve -20
KPX Ograve Acircumflex -20
KPX Ograve Adieresis -20
KPX Ograve Agrave -20
KPX Ograve Amacron -20
KPX Ograve Aogonek -20
KPX Ograve Aring -20
KPX Ograve Atilde -20
KPX Ograve T -40
KPX Ograve Tcaron -40
KPX Ograve Tcommaaccent -40
KPX Ograve V -50
KPX Ograve W -30
KPX Ograve X -60
KPX Ograve Y -70
KPX Ograve Yacute -70
KPX Ograve Ydieresis -70
KPX Ograve comma -40
KPX Ograve period -40
KPX Ohungarumlaut A -20
KPX Ohungarumlaut Aacute -20
KPX Ohungarumlaut Abreve -20
KPX Ohungarumlaut Acircumflex -20
KPX Ohungarumlaut Adieresis -20
KPX Ohungarumlaut Agrave -20
KPX Ohungarumlaut Amacron -20
KPX Ohungarumlaut Aogonek -20
KPX Ohungarumlaut Aring -20
KPX Ohungarumlaut Atilde -20
KPX Ohungarumlaut T -40
KPX Ohungarumlaut Tcaron -40
KPX Ohungarumlaut Tcommaaccent -40
KPX Ohungarumlaut V -50
KPX Ohungarumlaut W -30
KPX Ohungarumlaut X -60
KPX Ohungarumlaut Y -70
KPX Ohungarumlaut Yacute -70
KPX Ohungarumlaut Ydieresis -70
KPX Ohungarumlaut comma -40
KPX Ohungarumlaut period -40
KPX Omacron A -20
KPX Omacron Aacute -20
KPX Omacron Abreve -20
KPX Omacron Acircumflex -20
KPX Omacron Adieresis -20
KPX Omacron Agrave -20
KPX Omacron Amacron -20
KPX Omacron Aogonek -20
KPX Omacron Aring -20
KPX Omacron Atilde -20
KPX Omacron T -40
KPX Omacron Tcaron -40
KPX Omacron Tcommaaccent -40
KPX Omacron V -50
KPX Omacron W -30
KPX Omacron X -60
KPX Omacron Y -70
KPX Omacron Yacute -70
KPX Omacron Ydieresis -70
KPX Omacron comma -40
KPX Omacron period -40
KPX Oslash A -20
KPX Oslash Aacute -20
KPX Oslash Abreve -20
KPX Oslash Acircumflex -20
KPX Oslash Adieresis -20
KPX Oslash Agrave -20
KPX Oslash Amacron -20
KPX Oslash Aogonek -20
KPX Oslash Aring -20
KPX Oslash Atilde -20
KPX Oslash T -40
KPX Oslash Tcaron -40
KPX Oslash Tcommaaccent -40
KPX Oslash V -50
KPX Oslash W -30
KPX Oslash X -60
KPX Oslash Y -70
KPX Oslash Yacute -70
KPX Oslash Ydieresis -70
KPX Oslash comma -40
KPX Oslash period -40
KPX Otilde A -20
KPX Otilde Aacute -20
KPX Otilde Abreve -20
KPX Otilde Acircumflex -20
KPX Otilde Adieresis -20
KPX Otilde Agrave -20
KPX Otilde Amacron -20
KPX Otilde Aogonek -20
KPX Otilde Aring -20
KPX Otilde Atilde -20
KPX Otilde T -40
KPX Otilde Tcaron -40
KPX Otilde Tcommaaccent -40
KPX Otilde V -50
KPX Otilde W -30
KPX Otilde X -60
KPX Otilde Y -70
KPX Otilde Yacute -70
KPX Otilde Ydieresis -70
KPX Otilde comma -40
KPX Otilde period -40
KPX P A -120
KPX P Aacute -120
KPX P Abreve -120
KPX P Acircumflex -120
KPX P Adieresis -120
KPX P Agrave -120
KPX P Amacron -120
KPX P Aogonek -120
KPX P Aring -120
KPX P Atilde -120
KPX P a -40
KPX P aacute -40
KPX P abreve -40
KPX P acircumflex -40
KPX P adieresis -40
KPX P agrave -40
KPX P amacron -40
KPX P aogonek -40
KPX P aring -40
KPX P atilde -40
KPX P comma -180
KPX P e -50
KPX P eacute -50
KPX P ecaron -50
KPX P ecircumflex -50
KPX P edieresis -50
KPX P edotaccent -50
KPX P egrave -50
KPX P emacron -50
KPX P eogonek -50
KPX P o -50
KPX P oacute -50
KPX P ocircumflex -50
KPX P odieresis -50
KPX P ograve -50
KPX P ohungarumlaut -50
KPX P omacron -50
KPX P oslash -50
KPX P otilde -50
KPX P period -180
KPX Q U -10
KPX Q Uacute -10
KPX Q Ucircumflex -10
KPX Q Udieresis -10
KPX Q Ugrave -10
KPX Q Uhungarumlaut -10
KPX Q Umacron -10
KPX Q Uogonek -10
KPX Q Uring -10
KPX R O -20
KPX R Oacute -20
KPX R Ocircumflex -20
KPX R Odieresis -20
KPX R Ograve -20
KPX R Ohungarumlaut -20
KPX R Omacron -20
KPX R Oslash -20
KPX R Otilde -20
KPX R T -30
KPX R Tcaron -30
KPX R Tcommaaccent -30
KPX R U -40
KPX R Uacute -40
KPX R Ucircumflex -40
KPX R Udieresis -40
KPX R Ugrave -40
KPX R Uhungarumlaut -40
KPX R Umacron -40
KPX R Uogonek -40
KPX R Uring -40
KPX R V -50
KPX R W -30
KPX R Y -50
KPX R Yacute -50
KPX R Ydieresis -50
KPX Racute O -20
KPX Racute Oacute -20
KPX Racute Ocircumflex -20
KPX Racute Odieresis -20
KPX Racute Ograve -20
KPX Racute Ohungarumlaut -20
KPX Racute Omacron -20
KPX Racute Oslash -20
KPX Racute Otilde -20
KPX Racute T -30
KPX Racute Tcaron -30
KPX Racute Tcommaaccent -30
KPX Racute U -40
KPX Racute Uacute -40
KPX Racute Ucircumflex -40
KPX Racute Udieresis -40
KPX Racute Ugrave -40
KPX Racute Uhungarumlaut -40
KPX Racute Umacron -40
KPX Racute Uogonek -40
KPX Racute Uring -40
KPX Racute V -50
KPX Racute W -30
KPX Racute Y -50
KPX Racute Yacute -50
KPX Racute Ydieresis -50
KPX Rcaron O -20
KPX Rcaron Oacute -20
KPX Rcaron Ocircumflex -20
KPX Rcaron Odieresis -20
KPX Rcaron Ograve -20
KPX Rcaron Ohungarumlaut -20
KPX Rcaron Omacron -20
KPX Rcaron Oslash -20
KPX Rcaron Otilde -20
KPX Rcaron T -30
KPX Rcaron Tcaron -30
KPX Rcaron Tcommaaccent -30
KPX Rcaron U -40
KPX Rcaron Uacute -40
KPX Rcaron Ucircumflex -40
KPX Rcaron Udieresis -40
KPX Rcaron Ugrave -40
KPX Rcaron Uhungarumlaut -40
KPX Rcaron Umacron -40
KPX Rcaron Uogonek -40
KPX Rcaron Uring -40
KPX Rcaron V -50
KPX Rcaron W -30
KPX Rcaron Y -50
KPX Rcaron Yacute -50
KPX Rcaron Ydieresis -50
KPX Rcommaaccent O -20
KPX Rcommaaccent Oacute -20
KPX Rcommaaccent Ocircumflex -20
KPX Rcommaaccent Odieresis -20
KPX Rcommaaccent Ograve -20
KPX Rcommaaccent Ohungarumlaut -20
KPX Rcommaaccent Omacron -20
KPX Rcommaaccent Oslash -20
KPX Rcommaaccent Otilde -20
KPX Rcommaaccent T -30
KPX Rcommaaccent Tcaron -30
KPX Rcommaaccent Tcommaaccent -30
KPX Rcommaaccent U -40
KPX Rcommaaccent Uacute -40
KPX Rcommaaccent Ucircumflex -40
KPX Rcommaaccent Udieresis -40
KPX Rcommaaccent Ugrave -40
KPX Rcommaaccent Uhungarumlaut -40
KPX Rcommaaccent Umacron -40
KPX Rcommaaccent Uogonek -40
KPX Rcommaaccent Uring -40
KPX Rcommaaccent V -50
KPX Rcommaaccent W -30
KPX Rcommaaccent Y -50
KPX Rcommaaccent Yacute -50
KPX Rcommaaccent Ydieresis -50
KPX S comma -20
KPX S period -20
KPX Sacute comma -20
KPX Sacute period -20
KPX Scaron comma -20
KPX Scaron period -20
KPX Scedilla comma -20
KPX Scedilla period -20
KPX Scommaaccent comma -20
KPX Scommaaccent period -20
KPX T A -120
KPX T Aacute -120
KPX T Abreve -120
KPX T Acircumflex -120
KPX T Adieresis -120
KPX T Agrave -120
KPX T Amacron -120
KPX T Aogonek -120
KPX T Aring -120
KPX T Atilde -120
KPX T O -40
KPX T Oacute -40
KPX T Ocircumflex -40
KPX T Odieresis -40
KPX T Ograve -40
KPX T Ohungarumlaut -40
KPX T Omacron -40
KPX T Oslash -40
KPX T Otilde -40
KPX T a -120
KPX T aacute -120
KPX T abreve -60
KPX T acircumflex -120
KPX T adieresis -120
KPX T agrave -120
KPX T amacron -60
KPX T aogonek -120
KPX T aring -120
KPX T atilde -60
KPX T colon -20
KPX T comma -120
KPX T e -120
KPX T eacute -120
KPX T ecaron -120
KPX T ecircumflex -120
KPX T edieresis -120
KPX T edotaccent -120
KPX T egrave -60
KPX T emacron -60
KPX T eogonek -120
KPX T hyphen -140
KPX T o -120
KPX T oacute -120
KPX T ocircumflex -120
KPX T odieresis -120
KPX T ograve -120
KPX T ohungarumlaut -120
KPX T omacron -60
KPX T oslash -120
KPX T otilde -60
KPX T period -120
KPX T r -120
KPX T racute -120
KPX T rcaron -120
KPX T rcommaaccent -120
KPX T semicolon -20
KPX T u -120
KPX T uacute -120
KPX T ucircumflex -120
KPX T udieresis -120
KPX T ugrave -120
KPX T uhungarumlaut -120
KPX T umacron -60
KPX T uogonek -120
KPX T uring -120
KPX T w -120
KPX T y -120
KPX T yacute -120
KPX T ydieresis -60
KPX Tcaron A -120
KPX Tcaron Aacute -120
KPX Tcaron Abreve -120
KPX Tcaron Acircumflex -120
KPX Tcaron Adieresis -120
KPX Tcaron Agrave -120
KPX Tcaron Amacron -120
KPX Tcaron Aogonek -120
KPX Tcaron Aring -120
KPX Tcaron Atilde -120
KPX Tcaron O -40
KPX Tcaron Oacute -40
KPX Tcaron Ocircumflex -40
KPX Tcaron Odieresis -40
KPX Tcaron Ograve -40
KPX Tcaron Ohungarumlaut -40
KPX Tcaron Omacron -40
KPX Tcaron Oslash -40
KPX Tcaron Otilde -40
KPX Tcaron a -120
KPX Tcaron aacute -120
KPX Tcaron abreve -60
KPX Tcaron acircumflex -120
KPX Tcaron adieresis -120
KPX Tcaron agrave -120
KPX Tcaron amacron -60
KPX Tcaron aogonek -120
KPX Tcaron aring -120
KPX Tcaron atilde -60
KPX Tcaron colon -20
KPX Tcaron comma -120
KPX Tcaron e -120
KPX Tcaron eacute -120
KPX Tcaron ecaron -120
KPX Tcaron ecircumflex -120
KPX Tcaron edieresis -120
KPX Tcaron edotaccent -120
KPX Tcaron egrave -60
KPX Tcaron emacron -60
KPX Tcaron eogonek -120
KPX Tcaron hyphen -140
KPX Tcaron o -120
KPX Tcaron oacute -120
KPX Tcaron ocircumflex -120
KPX Tcaron odieresis -120
KPX Tcaron ograve -120
KPX Tcaron ohungarumlaut -120
KPX Tcaron omacron -60
KPX Tcaron oslash -120
KPX Tcaron otilde -60
KPX Tcaron period -120
KPX Tcaron r -120
KPX Tcaron racute -120
KPX Tcaron rcaron -120
KPX Tcaron rcommaaccent -120
KPX Tcaron semicolon -20
KPX Tcaron u -120
KPX Tcaron uacute -120
KPX Tcaron ucircumflex -120
KPX Tcaron udieresis -120
KPX Tcaron ugrave -120
KPX Tcaron uhungarumlaut -120
KPX Tcaron umacron -60
KPX Tcaron uogonek -120
KPX Tcaron uring -120
KPX Tcaron w -120
KPX Tcaron y -120
KPX Tcaron yacute -120
KPX Tcaron ydieresis -60
KPX Tcommaaccent A -120
KPX Tcommaaccent Aacute -120
KPX Tcommaaccent Abreve -120
KPX Tcommaaccent Acircumflex -120
KPX Tcommaaccent Adieresis -120
KPX Tcommaaccent Agrave -120
KPX Tcommaaccent Amacron -120
KPX Tcommaaccent Aogonek -120
KPX Tcommaaccent Aring -120
KPX Tcommaaccent Atilde -120
KPX Tcommaaccent O -40
KPX Tcommaaccent Oacute -40
KPX Tcommaaccent Ocircumflex -40
KPX Tcommaaccent Odieresis -40
KPX Tcommaaccent Ograve -40
KPX Tcommaaccent Ohungarumlaut -40
KPX Tcommaaccent Omacron -40
KPX Tcommaaccent Oslash -40
KPX Tcommaaccent Otilde -40
KPX Tcommaaccent a -120
KPX Tcommaaccent aacute -120
KPX Tcommaaccent abreve -60
KPX Tcommaaccent acircumflex -120
KPX Tcommaaccent adieresis -120
KPX Tcommaaccent agrave -120
KPX Tcommaaccent amacron -60
KPX Tcommaaccent aogonek -120
KPX Tcommaaccent aring -120
KPX Tcommaaccent atilde -60
KPX Tcommaaccent colon -20
KPX Tcommaaccent comma -120
KPX Tcommaaccent e -120
KPX Tcommaaccent eacute -120
KPX Tcommaaccent ecaron -120
KPX Tcommaaccent ecircumflex -120
KPX Tcommaaccent edieresis -120
KPX Tcommaaccent edotaccent -120
KPX Tcommaaccent egrave -60
KPX Tcommaaccent emacron -60
KPX Tcommaaccent eogonek -120
KPX Tcommaaccent hyphen -140
KPX Tcommaaccent o -120
KPX Tcommaaccent oacute -120
KPX Tcommaaccent ocircumflex -120
KPX Tcommaaccent odieresis -120
KPX Tcommaaccent ograve -120
KPX Tcommaaccent ohungarumlaut -120
KPX Tcommaaccent omacron -60
KPX Tcommaaccent oslash -120
KPX Tcommaaccent otilde -60
KPX Tcommaaccent period -120
KPX Tcommaaccent r -120
KPX Tcommaaccent racute -120
KPX Tcommaaccent rcaron -120
KPX Tcommaaccent rcommaaccent -120
KPX Tcommaaccent semicolon -20
KPX Tcommaaccent u -120
KPX Tcommaaccent uacute -120
KPX Tcommaaccent ucircumflex -120
KPX Tcommaaccent udieresis -120
KPX Tcommaaccent ugrave -120
KPX Tcommaaccent uhungarumlaut -120
KPX Tcommaaccent umacron -60
KPX Tcommaaccent uogonek -120
KPX Tcommaaccent uring -120
KPX Tcommaaccent w -120
KPX Tcommaaccent y -120
KPX Tcommaaccent yacute -120
KPX Tcommaaccent ydieresis -60
KPX U A -40
KPX U Aacute -40
KPX U Abreve -40
KPX U Acircumflex -40
KPX U Adieresis -40
KPX U Agrave -40
KPX U Amacron -40
KPX U Aogonek -40
KPX U Aring -40
KPX U Atilde -40
KPX U comma -40
KPX U period -40
KPX Uacute A -40
KPX Uacute Aacute -40
KPX Uacute Abreve -40
KPX Uacute Acircumflex -40
KPX Uacute Adieresis -40
KPX Uacute Agrave -40
KPX Uacute Amacron -40
KPX Uacute Aogonek -40
KPX Uacute Aring -40
KPX Uacute Atilde -40
KPX Uacute comma -40
KPX Uacute period -40
KPX Ucircumflex A -40
KPX Ucircumflex Aacute -40
KPX Ucircumflex Abreve -40
KPX Ucircumflex Acircumflex -40
KPX Ucircumflex Adieresis -40
KPX Ucircumflex Agrave -40
KPX Ucircumflex Amacron -40
KPX Ucircumflex Aogonek -40
KPX Ucircumflex Aring -40
KPX Ucircumflex Atilde -40
KPX Ucircumflex comma -40
KPX Ucircumflex period -40
KPX Udieresis A -40
KPX Udieresis Aacute -40
KPX Udieresis Abreve -40
KPX Udieresis Acircumflex -40
KPX Udieresis Adieresis -40
KPX Udieresis Agrave -40
KPX Udieresis Amacron -40
KPX Udieresis Aogonek -40
KPX Udieresis Aring -40
KPX Udieresis Atilde -40
KPX Udieresis comma -40
KPX Udieresis period -40
KPX Ugrave A -40
KPX Ugrave Aacute -40
KPX Ugrave Abreve -40
KPX Ugrave Acircumflex -40
KPX Ugrave Adieresis -40
KPX Ugrave Agrave -40
KPX Ugrave Amacron -40
KPX Ugrave Aogonek -40
KPX Ugrave Aring -40
KPX Ugrave Atilde -40
KPX Ugrave comma -40
KPX Ugrave period -40
KPX Uhungarumlaut A -40
KPX Uhungarumlaut Aacute -40
KPX Uhungarumlaut Abreve -40
KPX Uhungarumlaut Acircumflex -40
KPX Uhungarumlaut Adieresis -40
KPX Uhungarumlaut Agrave -40
KPX Uhungarumlaut Amacron -40
KPX Uhungarumlaut Aogonek -40
KPX Uhungarumlaut Aring -40
KPX Uhungarumlaut Atilde -40
KPX Uhungarumlaut comma -40
KPX Uhungarumlaut period -40
KPX Umacron A -40
KPX Umacron Aacute -40
KPX Umacron Abreve -40
KPX Umacron Acircumflex -40
KPX Umacron Adieresis -40
KPX Umacron Agrave -40
KPX Umacron Amacron -40
KPX Umacron Aogonek -40
KPX Umacron Aring -40
KPX Umacron Atilde -40
KPX Umacron comma -40
KPX Umacron period -40
KPX Uogonek A -40
KPX Uogonek Aacute -40
KPX Uogonek Abreve -40
KPX Uogonek Acircumflex -40
KPX Uogonek Adieresis -40
KPX Uogonek Agrave -40
KPX Uogonek Amacron -40
KPX Uogonek Aogonek -40
KPX Uogonek Aring -40
KPX Uogonek Atilde -40
KPX Uogonek comma -40
KPX Uogonek period -40
KPX Uring A -40
KPX Uring Aacute -40
KPX Uring Abreve -40
KPX Uring Acircumflex -40
KPX Uring Adieresis -40
KPX Uring Agrave -40
KPX Uring Amacron -40
KPX Uring Aogonek -40
KPX Uring Aring -40
KPX Uring Atilde -40
KPX Uring comma -40
KPX Uring period -40
KPX V A -80
KPX V Aacute -80
KPX V Abreve -80
KPX V Acircumflex -80
KPX V Adieresis -80
KPX V Agrave -80
KPX V Amacron -80
KPX V Aogonek -80
KPX V Aring -80
KPX V Atilde -80
KPX V G -40
KPX V Gbreve -40
KPX V Gcommaaccent -40
KPX V O -40
KPX V Oacute -40
KPX V Ocircumflex -40
KPX V Odieresis -40
KPX V Ograve -40
KPX V Ohungarumlaut -40
KPX V Omacron -40
KPX V Oslash -40
KPX V Otilde -40
KPX V a -70
KPX V aacute -70
KPX V abreve -70
KPX V acircumflex -70
KPX V adieresis -70
KPX V agrave -70
KPX V amacron -70
KPX V aogonek -70
KPX V aring -70
KPX V atilde -70
KPX V colon -40
KPX V comma -125
KPX V e -80
KPX V eacute -80
KPX V ecaron -80
KPX V ecircumflex -80
KPX V edieresis -80
KPX V edotaccent -80
KPX V egrave -80
KPX V emacron -80
KPX V eogonek -80
KPX V hyphen -80
KPX V o -80
KPX V oacute -80
KPX V ocircumflex -80
KPX V odieresis -80
KPX V ograve -80
KPX V ohungarumlaut -80
KPX V omacron -80
KPX V oslash -80
KPX V otilde -80
KPX V period -125
KPX V semicolon -40
KPX V u -70
KPX V uacute -70
KPX V ucircumflex -70
KPX V udieresis -70
KPX V ugrave -70
KPX V uhungarumlaut -70
KPX V umacron -70
KPX V uogonek -70
KPX V uring -70
KPX W A -50
KPX W Aacute -50
KPX W Abreve -50
KPX W Acircumflex -50
KPX W Adieresis -50
KPX W Agrave -50
KPX W Amacron -50
KPX W Aogonek -50
KPX W Aring -50
KPX W Atilde -50
KPX W O -20
KPX W Oacute -20
KPX W Ocircumflex -20
KPX W Odieresis -20
KPX W Ograve -20
KPX W Ohungarumlaut -20
KPX W Omacron -20
KPX W Oslash -20
KPX W Otilde -20
KPX W a -40
KPX W aacute -40
KPX W abreve -40
KPX W acircumflex -40
KPX W adieresis -40
KPX W agrave -40
KPX W amacron -40
KPX W aogonek -40
KPX W aring -40
KPX W atilde -40
KPX W comma -80
KPX W e -30
KPX W eacute -30
KPX W ecaron -30
KPX W ecircumflex -30
KPX W edieresis -30
KPX W edotaccent -30
KPX W egrave -30
KPX W emacron -30
KPX W eogonek -30
KPX W hyphen -40
KPX W o -30
KPX W oacute -30
KPX W ocircumflex -30
KPX W odieresis -30
KPX W ograve -30
KPX W ohungarumlaut -30
KPX W omacron -30
KPX W oslash -30
KPX W otilde -30
KPX W period -80
KPX W u -30
KPX W uacute -30
KPX W ucircumflex -30
KPX W udieresis -30
KPX W ugrave -30
KPX W uhungarumlaut -30
KPX W umacron -30
KPX W uogonek -30
KPX W uring -30
KPX W y -20
KPX W yacute -20
KPX W ydieresis -20
KPX Y A -110
KPX Y Aacute -110
KPX Y Abreve -110
KPX Y Acircumflex -110
KPX Y Adieresis -110
KPX Y Agrave -110
KPX Y Amacron -110
KPX Y Aogonek -110
KPX Y Aring -110
KPX Y Atilde -110
KPX Y O -85
KPX Y Oacute -85
KPX Y Ocircumflex -85
KPX Y Odieresis -85
KPX Y Ograve -85
KPX Y Ohungarumlaut -85
KPX Y Omacron -85
KPX Y Oslash -85
KPX Y Otilde -85
KPX Y a -140
KPX Y aacute -140
KPX Y abreve -70
KPX Y acircumflex -140
KPX Y adieresis -140
KPX Y agrave -140
KPX Y amacron -70
KPX Y aogonek -140
KPX Y aring -140
KPX Y atilde -140
KPX Y colon -60
KPX Y comma -140
KPX Y e -140
KPX Y eacute -140
KPX Y ecaron -140
KPX Y ecircumflex -140
KPX Y edieresis -140
KPX Y edotaccent -140
KPX Y egrave -140
KPX Y emacron -70
KPX Y eogonek -140
KPX Y hyphen -140
KPX Y i -20
KPX Y iacute -20
KPX Y iogonek -20
KPX Y o -140
KPX Y oacute -140
KPX Y ocircumflex -140
KPX Y odieresis -140
KPX Y ograve -140
KPX Y ohungarumlaut -140
KPX Y omacron -140
KPX Y oslash -140
KPX Y otilde -140
KPX Y period -140
KPX Y semicolon -60
KPX Y u -110
KPX Y uacute -110
KPX Y ucircumflex -110
KPX Y udieresis -110
KPX Y ugrave -110
KPX Y uhungarumlaut -110
KPX Y umacron -110
KPX Y uogonek -110
KPX Y uring -110
KPX Yacute A -110
KPX Yacute Aacute -110
KPX Yacute Abreve -110
KPX Yacute Acircumflex -110
KPX Yacute Adieresis -110
KPX Yacute Agrave -110
KPX Yacute Amacron -110
KPX Yacute Aogonek -110
KPX Yacute Aring -110
KPX Yacute Atilde -110
KPX Yacute O -85
KPX Yacute Oacute -85
KPX Yacute Ocircumflex -85
KPX Yacute Odieresis -85
KPX Yacute Ograve -85
KPX Yacute Ohungarumlaut -85
KPX Yacute Omacron -85
KPX Yacute Oslash -85
KPX Yacute Otilde -85
KPX Yacute a -140
KPX Yacute aacute -140
KPX Yacute abreve -70
KPX Yacute acircumflex -140
KPX Yacute adieresis -140
KPX Yacute agrave -140
KPX Yacute amacron -70
KPX Yacute aogonek -140
KPX Yacute aring -140
KPX Yacute atilde -70
KPX Yacute colon -60
KPX Yacute comma -140
KPX Yacute e -140
KPX Yacute eacute -140
KPX Yacute ecaron -140
KPX Yacute ecircumflex -140
KPX Yacute edieresis -140
KPX Yacute edotaccent -140
KPX Yacute egrave -140
KPX Yacute emacron -70
KPX Yacute eogonek -140
KPX Yacute hyphen -140
KPX Yacute i -20
KPX Yacute iacute -20
KPX Yacute iogonek -20
KPX Yacute o -140
KPX Yacute oacute -140
KPX Yacute ocircumflex -140
KPX Yacute odieresis -140
KPX Yacute ograve -140
KPX Yacute ohungarumlaut -140
KPX Yacute omacron -70
KPX Yacute oslash -140
KPX Yacute otilde -140
KPX Yacute period -140
KPX Yacute semicolon -60
KPX Yacute u -110
KPX Yacute uacute -110
KPX Yacute ucircumflex -110
KPX Yacute udieresis -110
KPX Yacute ugrave -110
KPX Yacute uhungarumlaut -110
KPX Yacute umacron -110
KPX Yacute uogonek -110
KPX Yacute uring -110
KPX Ydieresis A -110
KPX Ydieresis Aacute -110
KPX Ydieresis Abreve -110
KPX Ydieresis Acircumflex -110
KPX Ydieresis Adieresis -110
KPX Ydieresis Agrave -110
KPX Ydieresis Amacron -110
KPX Ydieresis Aogonek -110
KPX Ydieresis Aring -110
KPX Ydieresis Atilde -110
KPX Ydieresis O -85
KPX Ydieresis Oacute -85
KPX Ydieresis Ocircumflex -85
KPX Ydieresis Odieresis -85
KPX Ydieresis Ograve -85
KPX Ydieresis Ohungarumlaut -85
KPX Ydieresis Omacron -85
KPX Ydieresis Oslash -85
KPX Ydieresis Otilde -85
KPX Ydieresis a -140
KPX Ydieresis aacute -140
KPX Ydieresis abreve -70
KPX Ydieresis acircumflex -140
KPX Ydieresis adieresis -140
KPX Ydieresis agrave -140
KPX Ydieresis amacron -70
KPX Ydieresis aogonek -140
KPX Ydieresis aring -140
KPX Ydieresis atilde -70
KPX Ydieresis colon -60
KPX Ydieresis comma -140
KPX Ydieresis e -140
KPX Ydieresis eacute -140
KPX Ydieresis ecaron -140
KPX Ydieresis ecircumflex -140
KPX Ydieresis edieresis -140
KPX Ydieresis edotaccent -140
KPX Ydieresis egrave -140
KPX Ydieresis emacron -70
KPX Ydieresis eogonek -140
KPX Ydieresis hyphen -140
KPX Ydieresis i -20
KPX Ydieresis iacute -20
KPX Ydieresis iogonek -20
KPX Ydieresis o -140
KPX Ydieresis oacute -140
KPX Ydieresis ocircumflex -140
KPX Ydieresis odieresis -140
KPX Ydieresis ograve -140
KPX Ydieresis ohungarumlaut -140
KPX Ydieresis omacron -140
KPX Ydieresis oslash -140
KPX Ydieresis otilde -140
KPX Ydieresis period -140
KPX Ydieresis semicolon -60
KPX Ydieresis u -110
KPX Ydieresis uacute -110
KPX Ydieresis ucircumflex -110
KPX Ydieresis udieresis -110
KPX Ydieresis ugrave -110
KPX Ydieresis uhungarumlaut -110
KPX Ydieresis umacron -110
KPX Ydieresis uogonek -110
KPX Ydieresis uring -110
KPX a v -20
KPX a w -20
KPX a y -30
KPX a yacute -30
KPX a ydieresis -30
KPX aacute v -20
KPX aacute w -20
KPX aacute y -30
KPX aacute yacute -30
KPX aacute ydieresis -30
KPX abreve v -20
KPX abreve w -20
KPX abreve y -30
KPX abreve yacute -30
KPX abreve ydieresis -30
KPX acircumflex v -20
KPX acircumflex w -20
KPX acircumflex y -30
KPX acircumflex yacute -30
KPX acircumflex ydieresis -30
KPX adieresis v -20
KPX adieresis w -20
KPX adieresis y -30
KPX adieresis yacute -30
KPX adieresis ydieresis -30
KPX agrave v -20
KPX agrave w -20
KPX agrave y -30
KPX agrave yacute -30
KPX agrave ydieresis -30
KPX amacron v -20
KPX amacron w -20
KPX amacron y -30
KPX amacron yacute -30
KPX amacron ydieresis -30
KPX aogonek v -20
KPX aogonek w -20
KPX aogonek y -30
KPX aogonek yacute -30
KPX aogonek ydieresis -30
KPX aring v -20
KPX aring w -20
KPX aring y -30
KPX aring yacute -30
KPX aring ydieresis -30
KPX atilde v -20
KPX atilde w -20
KPX atilde y -30
KPX atilde yacute -30
KPX atilde ydieresis -30
KPX b b -10
KPX b comma -40
KPX b l -20
KPX b lacute -20
KPX b lcommaaccent -20
KPX b lslash -20
KPX b period -40
KPX b u -20
KPX b uacute -20
KPX b ucircumflex -20
KPX b udieresis -20
KPX b ugrave -20
KPX b uhungarumlaut -20
KPX b umacron -20
KPX b uogonek -20
KPX b uring -20
KPX b v -20
KPX b y -20
KPX b yacute -20
KPX b ydieresis -20
KPX c comma -15
KPX c k -20
KPX c kcommaaccent -20
KPX cacute comma -15
KPX cacute k -20
KPX cacute kcommaaccent -20
KPX ccaron comma -15
KPX ccaron k -20
KPX ccaron kcommaaccent -20
KPX ccedilla comma -15
KPX ccedilla k -20
KPX ccedilla kcommaaccent -20
KPX colon space -50
KPX comma quotedblright -100
KPX comma quoteright -100
KPX e comma -15
KPX e period -15
KPX e v -30
KPX e w -20
KPX e x -30
KPX e y -20
KPX e yacute -20
KPX e ydieresis -20
KPX eacute comma -15
KPX eacute period -15
KPX eacute v -30
KPX eacute w -20
KPX eacute x -30
KPX eacute y -20
KPX eacute yacute -20
KPX eacute ydieresis -20
KPX ecaron comma -15
KPX ecaron period -15
KPX ecaron v -30
KPX ecaron w -20
KPX ecaron x -30
KPX ecaron y -20
KPX ecaron yacute -20
KPX ecaron ydieresis -20
KPX ecircumflex comma -15
KPX ecircumflex period -15
KPX ecircumflex v -30
KPX ecircumflex w -20
KPX ecircumflex x -30
KPX ecircumflex y -20
KPX ecircumflex yacute -20
KPX ecircumflex ydieresis -20
KPX edieresis comma -15
KPX edieresis period -15
KPX edieresis v -30
KPX edieresis w -20
KPX edieresis x -30
KPX edieresis y -20
KPX edieresis yacute -20
KPX edieresis ydieresis -20
KPX edotaccent comma -15
KPX edotaccent period -15
KPX edotaccent v -30
KPX edotaccent w -20
KPX edotaccent x -30
KPX edotaccent y -20
KPX edotaccent yacute -20
KPX edotaccent ydieresis -20
KPX egrave comma -15
KPX egrave period -15
KPX egrave v -30
KPX egrave w -20
KPX egrave x -30
KPX egrave y -20
KPX egrave yacute -20
KPX egrave ydieresis -20
KPX emacron comma -15
KPX emacron period -15
KPX emacron v -30
KPX emacron w -20
KPX emacron x -30
KPX emacron y -20
KPX emacron yacute -20
KPX emacron ydieresis -20
KPX eogonek comma -15
KPX eogonek period -15
KPX eogonek v -30
KPX eogonek w -20
KPX eogonek x -30
KPX eogonek y -20
KPX eogonek yacute -20
KPX eogonek ydieresis -20
KPX f a -30
KPX f aacute -30
KPX f abreve -30
KPX f acircumflex -30
KPX f adieresis -30
KPX f agrave -30
KPX f amacron -30
KPX f aogonek -30
KPX f aring -30
KPX f atilde -30
KPX f comma -30
KPX f dotlessi -28
KPX f e -30
KPX f eacute -30
KPX f ecaron -30
KPX f ecircumflex -30
KPX f edieresis -30
KPX f edotaccent -30
KPX f egrave -30
KPX f emacron -30
KPX f eogonek -30
KPX f o -30
KPX f oacute -30
KPX f ocircumflex -30
KPX f odieresis -30
KPX f ograve -30
KPX f ohungarumlaut -30
KPX f omacron -30
KPX f oslash -30
KPX f otilde -30
KPX f period -30
KPX f quotedblright 60
KPX f quoteright 50
KPX g r -10
KPX g racute -10
KPX g rcaron -10
KPX g rcommaaccent -10
KPX gbreve r -10
KPX gbreve racute -10
KPX gbreve rcaron -10
KPX gbreve rcommaaccent -10
KPX gcommaaccent r -10
KPX gcommaaccent racute -10
KPX gcommaaccent rcaron -10
KPX gcommaaccent rcommaaccent -10
KPX h y -30
KPX h yacute -30
KPX h ydieresis -30
KPX k e -20
KPX k eacute -20
KPX k ecaron -20
KPX k ecircumflex -20
KPX k edieresis -20
KPX k edotaccent -20
KPX k egrave -20
KPX k emacron -20
KPX k eogonek -20
KPX k o -20
KPX k oacute -20
KPX k ocircumflex -20
KPX k odieresis -20
KPX k ograve -20
KPX k ohungarumlaut -20
KPX k omacron -20
KPX k oslash -20
KPX k otilde -20
KPX kcommaaccent e -20
KPX kcommaaccent eacute -20
KPX kcommaaccent ecaron -20
KPX kcommaaccent ecircumflex -20
KPX kcommaaccent edieresis -20
KPX kcommaaccent edotaccent -20
KPX kcommaaccent egrave -20
KPX kcommaaccent emacron -20
KPX kcommaaccent eogonek -20
KPX kcommaaccent o -20
KPX kcommaaccent oacute -20
KPX kcommaaccent ocircumflex -20
KPX kcommaaccent odieresis -20
KPX kcommaaccent ograve -20
KPX kcommaaccent ohungarumlaut -20
KPX kcommaaccent omacron -20
KPX kcommaaccent oslash -20
KPX kcommaaccent otilde -20
KPX m u -10
KPX m uacute -10
KPX m ucircumflex -10
KPX m udieresis -10
KPX m ugrave -10
KPX m uhungarumlaut -10
KPX m umacron -10
KPX m uogonek -10
KPX m uring -10
KPX m y -15
KPX m yacute -15
KPX m ydieresis -15
KPX n u -10
KPX n uacute -10
KPX n ucircumflex -10
KPX n udieresis -10
KPX n ugrave -10
KPX n uhungarumlaut -10
KPX n umacron -10
KPX n uogonek -10
KPX n uring -10
KPX n v -20
KPX n y -15
KPX n yacute -15
KPX n ydieresis -15
KPX nacute u -10
KPX nacute uacute -10
KPX nacute ucircumflex -10
KPX nacute udieresis -10
KPX nacute ugrave -10
KPX nacute uhungarumlaut -10
KPX nacute umacron -10
KPX nacute uogonek -10
KPX nacute uring -10
KPX nacute v -20
KPX nacute y -15
KPX nacute yacute -15
KPX nacute ydieresis -15
KPX ncaron u -10
KPX ncaron uacute -10
KPX ncaron ucircumflex -10
KPX ncaron udieresis -10
KPX ncaron ugrave -10
KPX ncaron uhungarumlaut -10
KPX ncaron umacron -10
KPX ncaron uogonek -10
KPX ncaron uring -10
KPX ncaron v -20
KPX ncaron y -15
KPX ncaron yacute -15
KPX ncaron ydieresis -15
KPX ncommaaccent u -10
KPX ncommaaccent uacute -10
KPX ncommaaccent ucircumflex -10
KPX ncommaaccent udieresis -10
KPX ncommaaccent ugrave -10
KPX ncommaaccent uhungarumlaut -10
KPX ncommaaccent umacron -10
KPX ncommaaccent uogonek -10
KPX ncommaaccent uring -10
KPX ncommaaccent v -20
KPX ncommaaccent y -15
KPX ncommaaccent yacute -15
KPX ncommaaccent ydieresis -15
KPX ntilde u -10
KPX ntilde uacute -10
KPX ntilde ucircumflex -10
KPX ntilde udieresis -10
KPX ntilde ugrave -10
KPX ntilde uhungarumlaut -10
KPX ntilde umacron -10
KPX ntilde uogonek -10
KPX ntilde uring -10
KPX ntilde v -20
KPX ntilde y -15
KPX ntilde yacute -15
KPX ntilde ydieresis -15
KPX o comma -40
KPX o period -40
KPX o v -15
KPX o w -15
KPX o x -30
KPX o y -30
KPX o yacute -30
KPX o ydieresis -30
KPX oacute comma -40
KPX oacute period -40
KPX oacute v -15
KPX oacute w -15
KPX oacute x -30
KPX oacute y -30
KPX oacute yacute -30
KPX oacute ydieresis -30
KPX ocircumflex comma -40
KPX ocircumflex period -40
KPX ocircumflex v -15
KPX ocircumflex w -15
KPX ocircumflex x -30
KPX ocircumflex y -30
KPX ocircumflex yacute -30
KPX ocircumflex ydieresis -30
KPX odieresis comma -40
KPX odieresis period -40
KPX odieresis v -15
KPX odieresis w -15
KPX odieresis x -30
KPX odieresis y -30
KPX odieresis yacute -30
KPX odieresis ydieresis -30
KPX ograve comma -40
KPX ograve period -40
KPX ograve v -15
KPX ograve w -15
KPX ograve x -30
KPX ograve y -30
KPX ograve yacute -30
KPX ograve ydieresis -30
KPX ohungarumlaut comma -40
KPX ohungarumlaut period -40
KPX ohungarumlaut v -15
KPX ohungarumlaut w -15
KPX ohungarumlaut x -30
KPX ohungarumlaut y -30
KPX ohungarumlaut yacute -30
KPX ohungarumlaut ydieresis -30
KPX omacron comma -40
KPX omacron period -40
KPX omacron v -15
KPX omacron w -15
KPX omacron x -30
KPX omacron y -30
KPX omacron yacute -30
KPX omacron ydieresis -30
KPX oslash a -55
KPX oslash aacute -55
KPX oslash abreve -55
KPX oslash acircumflex -55
KPX oslash adieresis -55
KPX oslash agrave -55
KPX oslash amacron -55
KPX oslash aogonek -55
KPX oslash aring -55
KPX oslash atilde -55
KPX oslash b -55
KPX oslash c -55
KPX oslash cacute -55
KPX oslash ccaron -55
KPX oslash ccedilla -55
KPX oslash comma -95
KPX oslash d -55
KPX oslash dcroat -55
KPX oslash e -55
KPX oslash eacute -55
KPX oslash ecaron -55
KPX oslash ecircumflex -55
KPX oslash edieresis -55
KPX oslash edotaccent -55
KPX oslash egrave -55
KPX oslash emacron -55
KPX oslash eogonek -55
KPX oslash f -55
KPX oslash g -55
KPX oslash gbreve -55
KPX oslash gcommaaccent -55
KPX oslash h -55
KPX oslash i -55
KPX oslash iacute -55
KPX oslash icircumflex -55
KPX oslash idieresis -55
KPX oslash igrave -55
KPX oslash imacron -55
KPX oslash iogonek -55
KPX oslash j -55
KPX oslash k -55
KPX oslash kcommaaccent -55
KPX oslash l -55
KPX oslash lacute -55
KPX oslash lcommaaccent -55
KPX oslash lslash -55
KPX oslash m -55
KPX oslash n -55
KPX oslash nacute -55
KPX oslash ncaron -55
KPX oslash ncommaaccent -55
KPX oslash ntilde -55
KPX oslash o -55
KPX oslash oacute -55
KPX oslash ocircumflex -55
KPX oslash odieresis -55
KPX oslash ograve -55
KPX oslash ohungarumlaut -55
KPX oslash omacron -55
KPX oslash oslash -55
KPX oslash otilde -55
KPX oslash p -55
KPX oslash period -95
KPX oslash q -55
KPX oslash r -55
KPX oslash racute -55
KPX oslash rcaron -55
KPX oslash rcommaaccent -55
KPX oslash s -55
KPX oslash sacute -55
KPX oslash scaron -55
KPX oslash scedilla -55
KPX oslash scommaaccent -55
KPX oslash t -55
KPX oslash tcommaaccent -55
KPX oslash u -55
KPX oslash uacute -55
KPX oslash ucircumflex -55
KPX oslash udieresis -55
KPX oslash ugrave -55
KPX oslash uhungarumlaut -55
KPX oslash umacron -55
KPX oslash uogonek -55
KPX oslash uring -55
KPX oslash v -70
KPX oslash w -70
KPX oslash x -85
KPX oslash y -70
KPX oslash yacute -70
KPX oslash ydieresis -70
KPX oslash z -55
KPX oslash zacute -55
KPX oslash zcaron -55
KPX oslash zdotaccent -55
KPX otilde comma -40
KPX otilde period -40
KPX otilde v -15
KPX otilde w -15
KPX otilde x -30
KPX otilde y -30
KPX otilde yacute -30
KPX otilde ydieresis -30
KPX p comma -35
KPX p period -35
KPX p y -30
KPX p yacute -30
KPX p ydieresis -30
KPX period quotedblright -100
KPX period quoteright -100
KPX period space -60
KPX quotedblright space -40
KPX quoteleft quoteleft -57
KPX quoteright d -50
KPX quoteright dcroat -50
KPX quoteright quoteright -57
KPX quoteright r -50
KPX quoteright racute -50
KPX quoteright rcaron -50
KPX quoteright rcommaaccent -50
KPX quoteright s -50
KPX quoteright sacute -50
KPX quoteright scaron -50
KPX quoteright scedilla -50
KPX quoteright scommaaccent -50
KPX quoteright space -70
KPX r a -10
KPX r aacute -10
KPX r abreve -10
KPX r acircumflex -10
KPX r adieresis -10
KPX r agrave -10
KPX r amacron -10
KPX r aogonek -10
KPX r aring -10
KPX r atilde -10
KPX r colon 30
KPX r comma -50
KPX r i 15
KPX r iacute 15
KPX r icircumflex 15
KPX r idieresis 15
KPX r igrave 15
KPX r imacron 15
KPX r iogonek 15
KPX r k 15
KPX r kcommaaccent 15
KPX r l 15
KPX r lacute 15
KPX r lcommaaccent 15
KPX r lslash 15
KPX r m 25
KPX r n 25
KPX r nacute 25
KPX r ncaron 25
KPX r ncommaaccent 25
KPX r ntilde 25
KPX r p 30
KPX r period -50
KPX r semicolon 30
KPX r t 40
KPX r tcommaaccent 40
KPX r u 15
KPX r uacute 15
KPX r ucircumflex 15
KPX r udieresis 15
KPX r ugrave 15
KPX r uhungarumlaut 15
KPX r umacron 15
KPX r uogonek 15
KPX r uring 15
KPX r v 30
KPX r y 30
KPX r yacute 30
KPX r ydieresis 30
KPX racute a -10
KPX racute aacute -10
KPX racute abreve -10
KPX racute acircumflex -10
KPX racute adieresis -10
KPX racute agrave -10
KPX racute amacron -10
KPX racute aogonek -10
KPX racute aring -10
KPX racute atilde -10
KPX racute colon 30
KPX racute comma -50
KPX racute i 15
KPX racute iacute 15
KPX racute icircumflex 15
KPX racute idieresis 15
KPX racute igrave 15
KPX racute imacron 15
KPX racute iogonek 15
KPX racute k 15
KPX racute kcommaaccent 15
KPX racute l 15
KPX racute lacute 15
KPX racute lcommaaccent 15
KPX racute lslash 15
KPX racute m 25
KPX racute n 25
KPX racute nacute 25
KPX racute ncaron 25
KPX racute ncommaaccent 25
KPX racute ntilde 25
KPX racute p 30
KPX racute period -50
KPX racute semicolon 30
KPX racute t 40
KPX racute tcommaaccent 40
KPX racute u 15
KPX racute uacute 15
KPX racute ucircumflex 15
KPX racute udieresis 15
KPX racute ugrave 15
KPX racute uhungarumlaut 15
KPX racute umacron 15
KPX racute uogonek 15
KPX racute uring 15
KPX racute v 30
KPX racute y 30
KPX racute yacute 30
KPX racute ydieresis 30
KPX rcaron a -10
KPX rcaron aacute -10
KPX rcaron abreve -10
KPX rcaron acircumflex -10
KPX rcaron adieresis -10
KPX rcaron agrave -10
KPX rcaron amacron -10
KPX rcaron aogonek -10
KPX rcaron aring -10
KPX rcaron atilde -10
KPX rcaron colon 30
KPX rcaron comma -50
KPX rcaron i 15
KPX rcaron iacute 15
KPX rcaron icircumflex 15
KPX rcaron idieresis 15
KPX rcaron igrave 15
KPX rcaron imacron 15
KPX rcaron iogonek 15
KPX rcaron k 15
KPX rcaron kcommaaccent 15
KPX rcaron l 15
KPX rcaron lacute 15
KPX rcaron lcommaaccent 15
KPX rcaron lslash 15
KPX rcaron m 25
KPX rcaron n 25
KPX rcaron nacute 25
KPX rcaron ncaron 25
KPX rcaron ncommaaccent 25
KPX rcaron ntilde 25
KPX rcaron p 30
KPX rcaron period -50
KPX rcaron semicolon 30
KPX rcaron t 40
KPX rcaron tcommaaccent 40
KPX rcaron u 15
KPX rcaron uacute 15
KPX rcaron ucircumflex 15
KPX rcaron udieresis 15
KPX rcaron ugrave 15
KPX rcaron uhungarumlaut 15
KPX rcaron umacron 15
KPX rcaron uogonek 15
KPX rcaron uring 15
KPX rcaron v 30
KPX rcaron y 30
KPX rcaron yacute 30
KPX rcaron ydieresis 30
KPX rcommaaccent a -10
KPX rcommaaccent aacute -10
KPX rcommaaccent abreve -10
KPX rcommaaccent acircumflex -10
KPX rcommaaccent adieresis -10
KPX rcommaaccent agrave -10
KPX rcommaaccent amacron -10
KPX rcommaaccent aogonek -10
KPX rcommaaccent aring -10
KPX rcommaaccent atilde -10
KPX rcommaaccent colon 30
KPX rcommaaccent comma -50
KPX rcommaaccent i 15
KPX rcommaaccent iacute 15
KPX rcommaaccent icircumflex 15
KPX rcommaaccent idieresis 15
KPX rcommaaccent igrave 15
KPX rcommaaccent imacron 15
KPX rcommaaccent iogonek 15
KPX rcommaaccent k 15
KPX rcommaaccent kcommaaccent 15
KPX rcommaaccent l 15
KPX rcommaaccent lacute 15
KPX rcommaaccent lcommaaccent 15
KPX rcommaaccent lslash 15
KPX rcommaaccent m 25
KPX rcommaaccent n 25
KPX rcommaaccent nacute 25
KPX rcommaaccent ncaron 25
KPX rcommaaccent ncommaaccent 25
KPX rcommaaccent ntilde 25
KPX rcommaaccent p 30
KPX rcommaaccent period -50
KPX rcommaaccent semicolon 30
KPX rcommaaccent t 40
KPX rcommaaccent tcommaaccent 40
KPX rcommaaccent u 15
KPX rcommaaccent uacute 15
KPX rcommaaccent ucircumflex 15
KPX rcommaaccent udieresis 15
KPX rcommaaccent ugrave 15
KPX rcommaaccent uhungarumlaut 15
KPX rcommaaccent umacron 15
KPX rcommaaccent uogonek 15
KPX rcommaaccent uring 15
KPX rcommaaccent v 30
KPX rcommaaccent y 30
KPX rcommaaccent yacute 30
KPX rcommaaccent ydieresis 30
KPX s comma -15
KPX s period -15
KPX s w -30
KPX sacute comma -15
KPX sacute period -15
KPX sacute w -30
KPX scaron comma -15
KPX scaron period -15
KPX scaron w -30
KPX scedilla comma -15
KPX scedilla period -15
KPX scedilla w -30
KPX scommaaccent comma -15
KPX scommaaccent period -15
KPX scommaaccent w -30
KPX semicolon space -50
KPX space T -50
KPX space Tcaron -50
KPX space Tcommaaccent -50
KPX space V -50
KPX space W -40
KPX space Y -90
KPX space Yacute -90
KPX space Ydieresis -90
KPX space quotedblleft -30
KPX space quoteleft -60
KPX v a -25
KPX v aacute -25
KPX v abreve -25
KPX v acircumflex -25
KPX v adieresis -25
KPX v agrave -25
KPX v amacron -25
KPX v aogonek -25
KPX v aring -25
KPX v atilde -25
KPX v comma -80
KPX v e -25
KPX v eacute -25
KPX v ecaron -25
KPX v ecircumflex -25
KPX v edieresis -25
KPX v edotaccent -25
KPX v egrave -25
KPX v emacron -25
KPX v eogonek -25
KPX v o -25
KPX v oacute -25
KPX v ocircumflex -25
KPX v odieresis -25
KPX v ograve -25
KPX v ohungarumlaut -25
KPX v omacron -25
KPX v oslash -25
KPX v otilde -25
KPX v period -80
KPX w a -15
KPX w aacute -15
KPX w abreve -15
KPX w acircumflex -15
KPX w adieresis -15
KPX w agrave -15
KPX w amacron -15
KPX w aogonek -15
KPX w aring -15
KPX w atilde -15
KPX w comma -60
KPX w e -10
KPX w eacute -10
KPX w ecaron -10
KPX w ecircumflex -10
KPX w edieresis -10
KPX w edotaccent -10
KPX w egrave -10
KPX w emacron -10
KPX w eogonek -10
KPX w o -10
KPX w oacute -10
KPX w ocircumflex -10
KPX w odieresis -10
KPX w ograve -10
KPX w ohungarumlaut -10
KPX w omacron -10
KPX w oslash -10
KPX w otilde -10
KPX w period -60
KPX x e -30
KPX x eacute -30
KPX x ecaron -30
KPX x ecircumflex -30
KPX x edieresis -30
KPX x edotaccent -30
KPX x egrave -30
KPX x emacron -30
KPX x eogonek -30
KPX y a -20
KPX y aacute -20
KPX y abreve -20
KPX y acircumflex -20
KPX y adieresis -20
KPX y agrave -20
KPX y amacron -20
KPX y aogonek -20
KPX y aring -20
KPX y atilde -20
KPX y comma -100
KPX y e -20
KPX y eacute -20
KPX y ecaron -20
KPX y ecircumflex -20
KPX y edieresis -20
KPX y edotaccent -20
KPX y egrave -20
KPX y emacron -20
KPX y eogonek -20
KPX y o -20
KPX y oacute -20
KPX y ocircumflex -20
KPX y odieresis -20
KPX y ograve -20
KPX y ohungarumlaut -20
KPX y omacron -20
KPX y oslash -20
KPX y otilde -20
KPX y period -100
KPX yacute a -20
KPX yacute aacute -20
KPX yacute abreve -20
KPX yacute acircumflex -20
KPX yacute adieresis -20
KPX yacute agrave -20
KPX yacute amacron -20
KPX yacute aogonek -20
KPX yacute aring -20
KPX yacute atilde -20
KPX yacute comma -100
KPX yacute e -20
KPX yacute eacute -20
KPX yacute ecaron -20
KPX yacute ecircumflex -20
KPX yacute edieresis -20
KPX yacute edotaccent -20
KPX yacute egrave -20
KPX yacute emacron -20
KPX yacute eogonek -20
KPX yacute o -20
KPX yacute oacute -20
KPX yacute ocircumflex -20
KPX yacute odieresis -20
KPX yacute ograve -20
KPX yacute ohungarumlaut -20
KPX yacute omacron -20
KPX yacute oslash -20
KPX yacute otilde -20
KPX yacute period -100
KPX ydieresis a -20
KPX ydieresis aacute -20
KPX ydieresis abreve -20
KPX ydieresis acircumflex -20
KPX ydieresis adieresis -20
KPX ydieresis agrave -20
KPX ydieresis amacron -20
KPX ydieresis aogonek -20
KPX ydieresis aring -20
KPX ydieresis atilde -20
KPX ydieresis comma -100
KPX ydieresis e -20
KPX ydieresis eacute -20
KPX ydieresis ecaron -20
KPX ydieresis ecircumflex -20
KPX ydieresis edieresis -20
KPX ydieresis edotaccent -20
KPX ydieresis egrave -20
KPX ydieresis emacron -20
KPX ydieresis eogonek -20
KPX ydieresis o -20
KPX ydieresis oacute -20
KPX ydieresis ocircumflex -20
KPX ydieresis odieresis -20
KPX ydieresis ograve -20
KPX ydieresis ohungarumlaut -20
KPX ydieresis omacron -20
KPX ydieresis oslash -20
KPX ydieresis otilde -20
KPX ydieresis period -100
KPX z e -15
KPX z eacute -15
KPX z ecaron -15
KPX z ecircumflex -15
KPX z edieresis -15
KPX z edotaccent -15
KPX z egrave -15
KPX z emacron -15
KPX z eogonek -15
KPX z o -15
KPX z oacute -15
KPX z ocircumflex -15
KPX z odieresis -15
KPX z ograve -15
KPX z ohungarumlaut -15
KPX z omacron -15
KPX z oslash -15
KPX z otilde -15
KPX zacute e -15
KPX zacute eacute -15
KPX zacute ecaron -15
KPX zacute ecircumflex -15
KPX zacute edieresis -15
KPX zacute edotaccent -15
KPX zacute egrave -15
KPX zacute emacron -15
KPX zacute eogonek -15
KPX zacute o -15
KPX zacute oacute -15
KPX zacute ocircumflex -15
KPX zacute odieresis -15
KPX zacute ograve -15
KPX zacute ohungarumlaut -15
KPX zacute omacron -15
KPX zacute oslash -15
KPX zacute otilde -15
KPX zcaron e -15
KPX zcaron eacute -15
KPX zcaron ecaron -15
KPX zcaron ecircumflex -15
KPX zcaron edieresis -15
KPX zcaron edotaccent -15
KPX zcaron egrave -15
KPX zcaron emacron -15
KPX zcaron eogonek -15
KPX zcaron o -15
KPX zcaron oacute -15
KPX zcaron ocircumflex -15
KPX zcaron odieresis -15
KPX zcaron ograve -15
KPX zcaron ohungarumlaut -15
KPX zcaron omacron -15
KPX zcaron oslash -15
KPX zcaron otilde -15
KPX zdotaccent e -15
KPX zdotaccent eacute -15
KPX zdotaccent ecaron -15
KPX zdotaccent ecircumflex -15
KPX zdotaccent edieresis -15
KPX zdotaccent edotaccent -15
KPX zdotaccent egrave -15
KPX zdotaccent emacron -15
KPX zdotaccent eogonek -15
KPX zdotaccent o -15
KPX zdotaccent oacute -15
KPX zdotaccent ocircumflex -15
KPX zdotaccent odieresis -15
KPX zdotaccent ograve -15
KPX zdotaccent ohungarumlaut -15
KPX zdotaccent omacron -15
KPX zdotaccent oslash -15
KPX zdotaccent otilde -15
EndKernPairs
EndKernData
EndFontMetrics"

let helvetica_bold_afm = "StartFontMetrics 4.1
Comment Copyright (c) 1985, 1987, 1989, 1990, 1997 Adobe Systems Incorporated.  All Rights Reserved.
Comment Creation Date: Thu May  1 12:43:52 1997
Comment UniqueID 43052
Comment VMusage 37169 48194
FontName Helvetica-Bold
FullName Helvetica Bold
FamilyName Helvetica
Weight Bold
ItalicAngle 0
IsFixedPitch false
CharacterSet ExtendedRoman
FontBBox -170 -228 1003 962 
UnderlinePosition -100
UnderlineThickness 50
Version 002.000
Notice Copyright (c) 1985, 1987, 1989, 1990, 1997 Adobe Systems Incorporated.  All Rights Reserved.Helvetica is a trademark of Linotype-Hell AG and/or its subsidiaries.
EncodingScheme AdobeStandardEncoding
CapHeight 718
XHeight 532
Ascender 718
Descender -207
StdHW 118
StdVW 140
StartCharMetrics 315
C 32 ; WX 278 ; N space ; B 0 0 0 0 ;
C 33 ; WX 333 ; N exclam ; B 90 0 244 718 ;
C 34 ; WX 474 ; N quotedbl ; B 98 447 376 718 ;
C 35 ; WX 556 ; N numbersign ; B 18 0 538 698 ;
C 36 ; WX 556 ; N dollar ; B 30 -115 523 775 ;
C 37 ; WX 889 ; N percent ; B 28 -19 861 710 ;
C 38 ; WX 722 ; N ampersand ; B 54 -19 701 718 ;
C 39 ; WX 278 ; N quoteright ; B 69 445 209 718 ;
C 40 ; WX 333 ; N parenleft ; B 35 -208 314 734 ;
C 41 ; WX 333 ; N parenright ; B 19 -208 298 734 ;
C 42 ; WX 389 ; N asterisk ; B 27 387 362 718 ;
C 43 ; WX 584 ; N plus ; B 40 0 544 506 ;
C 44 ; WX 278 ; N comma ; B 64 -168 214 146 ;
C 45 ; WX 333 ; N hyphen ; B 27 215 306 345 ;
C 46 ; WX 278 ; N period ; B 64 0 214 146 ;
C 47 ; WX 278 ; N slash ; B -33 -19 311 737 ;
C 48 ; WX 556 ; N zero ; B 32 -19 524 710 ;
C 49 ; WX 556 ; N one ; B 69 0 378 710 ;
C 50 ; WX 556 ; N two ; B 26 0 511 710 ;
C 51 ; WX 556 ; N three ; B 27 -19 516 710 ;
C 52 ; WX 556 ; N four ; B 27 0 526 710 ;
C 53 ; WX 556 ; N five ; B 27 -19 516 698 ;
C 54 ; WX 556 ; N six ; B 31 -19 520 710 ;
C 55 ; WX 556 ; N seven ; B 25 0 528 698 ;
C 56 ; WX 556 ; N eight ; B 32 -19 524 710 ;
C 57 ; WX 556 ; N nine ; B 30 -19 522 710 ;
C 58 ; WX 333 ; N colon ; B 92 0 242 512 ;
C 59 ; WX 333 ; N semicolon ; B 92 -168 242 512 ;
C 60 ; WX 584 ; N less ; B 38 -8 546 514 ;
C 61 ; WX 584 ; N equal ; B 40 87 544 419 ;
C 62 ; WX 584 ; N greater ; B 38 -8 546 514 ;
C 63 ; WX 611 ; N question ; B 60 0 556 727 ;
C 64 ; WX 975 ; N at ; B 118 -19 856 737 ;
C 65 ; WX 722 ; N A ; B 20 0 702 718 ;
C 66 ; WX 722 ; N B ; B 76 0 669 718 ;
C 67 ; WX 722 ; N C ; B 44 -19 684 737 ;
C 68 ; WX 722 ; N D ; B 76 0 685 718 ;
C 69 ; WX 667 ; N E ; B 76 0 621 718 ;
C 70 ; WX 611 ; N F ; B 76 0 587 718 ;
C 71 ; WX 778 ; N G ; B 44 -19 713 737 ;
C 72 ; WX 722 ; N H ; B 71 0 651 718 ;
C 73 ; WX 278 ; N I ; B 64 0 214 718 ;
C 74 ; WX 556 ; N J ; B 22 -18 484 718 ;
C 75 ; WX 722 ; N K ; B 87 0 722 718 ;
C 76 ; WX 611 ; N L ; B 76 0 583 718 ;
C 77 ; WX 833 ; N M ; B 69 0 765 718 ;
C 78 ; WX 722 ; N N ; B 69 0 654 718 ;
C 79 ; WX 778 ; N O ; B 44 -19 734 737 ;
C 80 ; WX 667 ; N P ; B 76 0 627 718 ;
C 81 ; WX 778 ; N Q ; B 44 -52 737 737 ;
C 82 ; WX 722 ; N R ; B 76 0 677 718 ;
C 83 ; WX 667 ; N S ; B 39 -19 629 737 ;
C 84 ; WX 611 ; N T ; B 14 0 598 718 ;
C 85 ; WX 722 ; N U ; B 72 -19 651 718 ;
C 86 ; WX 667 ; N V ; B 19 0 648 718 ;
C 87 ; WX 944 ; N W ; B 16 0 929 718 ;
C 88 ; WX 667 ; N X ; B 14 0 653 718 ;
C 89 ; WX 667 ; N Y ; B 15 0 653 718 ;
C 90 ; WX 611 ; N Z ; B 25 0 586 718 ;
C 91 ; WX 333 ; N bracketleft ; B 63 -196 309 722 ;
C 92 ; WX 278 ; N backslash ; B -33 -19 311 737 ;
C 93 ; WX 333 ; N bracketright ; B 24 -196 270 722 ;
C 94 ; WX 584 ; N asciicircum ; B 62 323 522 698 ;
C 95 ; WX 556 ; N underscore ; B 0 -125 556 -75 ;
C 96 ; WX 278 ; N quoteleft ; B 69 454 209 727 ;
C 97 ; WX 556 ; N a ; B 29 -14 527 546 ;
C 98 ; WX 611 ; N b ; B 61 -14 578 718 ;
C 99 ; WX 556 ; N c ; B 34 -14 524 546 ;
C 100 ; WX 611 ; N d ; B 34 -14 551 718 ;
C 101 ; WX 556 ; N e ; B 23 -14 528 546 ;
C 102 ; WX 333 ; N f ; B 10 0 318 727 ; L i fi ; L l fl ;
C 103 ; WX 611 ; N g ; B 40 -217 553 546 ;
C 104 ; WX 611 ; N h ; B 65 0 546 718 ;
C 105 ; WX 278 ; N i ; B 69 0 209 725 ;
C 106 ; WX 278 ; N j ; B 3 -214 209 725 ;
C 107 ; WX 556 ; N k ; B 69 0 562 718 ;
C 108 ; WX 278 ; N l ; B 69 0 209 718 ;
C 109 ; WX 889 ; N m ; B 64 0 826 546 ;
C 110 ; WX 611 ; N n ; B 65 0 546 546 ;
C 111 ; WX 611 ; N o ; B 34 -14 578 546 ;
C 112 ; WX 611 ; N p ; B 62 -207 578 546 ;
C 113 ; WX 611 ; N q ; B 34 -207 552 546 ;
C 114 ; WX 389 ; N r ; B 64 0 373 546 ;
C 115 ; WX 556 ; N s ; B 30 -14 519 546 ;
C 116 ; WX 333 ; N t ; B 10 -6 309 676 ;
C 117 ; WX 611 ; N u ; B 66 -14 545 532 ;
C 118 ; WX 556 ; N v ; B 13 0 543 532 ;
C 119 ; WX 778 ; N w ; B 10 0 769 532 ;
C 120 ; WX 556 ; N x ; B 15 0 541 532 ;
C 121 ; WX 556 ; N y ; B 10 -214 539 532 ;
C 122 ; WX 500 ; N z ; B 20 0 480 532 ;
C 123 ; WX 389 ; N braceleft ; B 48 -196 365 722 ;
C 124 ; WX 280 ; N bar ; B 84 -225 196 775 ;
C 125 ; WX 389 ; N braceright ; B 24 -196 341 722 ;
C 126 ; WX 584 ; N asciitilde ; B 61 163 523 343 ;
C 161 ; WX 333 ; N exclamdown ; B 90 -186 244 532 ;
C 162 ; WX 556 ; N cent ; B 34 -118 524 628 ;
C 163 ; WX 556 ; N sterling ; B 28 -16 541 718 ;
C 164 ; WX 167 ; N fraction ; B -170 -19 336 710 ;
C 165 ; WX 556 ; N yen ; B -9 0 565 698 ;
C 166 ; WX 556 ; N florin ; B -10 -210 516 737 ;
C 167 ; WX 556 ; N section ; B 34 -184 522 727 ;
C 168 ; WX 556 ; N currency ; B -3 76 559 636 ;
C 169 ; WX 238 ; N quotesingle ; B 70 447 168 718 ;
C 170 ; WX 500 ; N quotedblleft ; B 64 454 436 727 ;
C 171 ; WX 556 ; N guillemotleft ; B 88 76 468 484 ;
C 172 ; WX 333 ; N guilsinglleft ; B 83 76 250 484 ;
C 173 ; WX 333 ; N guilsinglright ; B 83 76 250 484 ;
C 174 ; WX 611 ; N fi ; B 10 0 542 727 ;
C 175 ; WX 611 ; N fl ; B 10 0 542 727 ;
C 177 ; WX 556 ; N endash ; B 0 227 556 333 ;
C 178 ; WX 556 ; N dagger ; B 36 -171 520 718 ;
C 179 ; WX 556 ; N daggerdbl ; B 36 -171 520 718 ;
C 180 ; WX 278 ; N periodcentered ; B 58 172 220 334 ;
C 182 ; WX 556 ; N paragraph ; B -8 -191 539 700 ;
C 183 ; WX 350 ; N bullet ; B 10 194 340 524 ;
C 184 ; WX 278 ; N quotesinglbase ; B 69 -146 209 127 ;
C 185 ; WX 500 ; N quotedblbase ; B 64 -146 436 127 ;
C 186 ; WX 500 ; N quotedblright ; B 64 445 436 718 ;
C 187 ; WX 556 ; N guillemotright ; B 88 76 468 484 ;
C 188 ; WX 1000 ; N ellipsis ; B 92 0 908 146 ;
C 189 ; WX 1000 ; N perthousand ; B -3 -19 1003 710 ;
C 191 ; WX 611 ; N questiondown ; B 55 -195 551 532 ;
C 193 ; WX 333 ; N grave ; B -23 604 225 750 ;
C 194 ; WX 333 ; N acute ; B 108 604 356 750 ;
C 195 ; WX 333 ; N circumflex ; B -10 604 343 750 ;
C 196 ; WX 333 ; N tilde ; B -17 610 350 737 ;
C 197 ; WX 333 ; N macron ; B -6 604 339 678 ;
C 198 ; WX 333 ; N breve ; B -2 604 335 750 ;
C 199 ; WX 333 ; N dotaccent ; B 104 614 230 729 ;
C 200 ; WX 333 ; N dieresis ; B 6 614 327 729 ;
C 202 ; WX 333 ; N ring ; B 59 568 275 776 ;
C 203 ; WX 333 ; N cedilla ; B 6 -228 245 0 ;
C 205 ; WX 333 ; N hungarumlaut ; B 9 604 486 750 ;
C 206 ; WX 333 ; N ogonek ; B 71 -228 304 0 ;
C 207 ; WX 333 ; N caron ; B -10 604 343 750 ;
C 208 ; WX 1000 ; N emdash ; B 0 227 1000 333 ;
C 225 ; WX 1000 ; N AE ; B 5 0 954 718 ;
C 227 ; WX 370 ; N ordfeminine ; B 22 401 347 737 ;
C 232 ; WX 611 ; N Lslash ; B -20 0 583 718 ;
C 233 ; WX 778 ; N Oslash ; B 33 -27 744 745 ;
C 234 ; WX 1000 ; N OE ; B 37 -19 961 737 ;
C 235 ; WX 365 ; N ordmasculine ; B 6 401 360 737 ;
C 241 ; WX 889 ; N ae ; B 29 -14 858 546 ;
C 245 ; WX 278 ; N dotlessi ; B 69 0 209 532 ;
C 248 ; WX 278 ; N lslash ; B -18 0 296 718 ;
C 249 ; WX 611 ; N oslash ; B 22 -29 589 560 ;
C 250 ; WX 944 ; N oe ; B 34 -14 912 546 ;
C 251 ; WX 611 ; N germandbls ; B 69 -14 579 731 ;
C -1 ; WX 278 ; N Idieresis ; B -21 0 300 915 ;
C -1 ; WX 556 ; N eacute ; B 23 -14 528 750 ;
C -1 ; WX 556 ; N abreve ; B 29 -14 527 750 ;
C -1 ; WX 611 ; N uhungarumlaut ; B 66 -14 625 750 ;
C -1 ; WX 556 ; N ecaron ; B 23 -14 528 750 ;
C -1 ; WX 667 ; N Ydieresis ; B 15 0 653 915 ;
C -1 ; WX 584 ; N divide ; B 40 -42 544 548 ;
C -1 ; WX 667 ; N Yacute ; B 15 0 653 936 ;
C -1 ; WX 722 ; N Acircumflex ; B 20 0 702 936 ;
C -1 ; WX 556 ; N aacute ; B 29 -14 527 750 ;
C -1 ; WX 722 ; N Ucircumflex ; B 72 -19 651 936 ;
C -1 ; WX 556 ; N yacute ; B 10 -214 539 750 ;
C -1 ; WX 556 ; N scommaaccent ; B 30 -228 519 546 ;
C -1 ; WX 556 ; N ecircumflex ; B 23 -14 528 750 ;
C -1 ; WX 722 ; N Uring ; B 72 -19 651 962 ;
C -1 ; WX 722 ; N Udieresis ; B 72 -19 651 915 ;
C -1 ; WX 556 ; N aogonek ; B 29 -224 545 546 ;
C -1 ; WX 722 ; N Uacute ; B 72 -19 651 936 ;
C -1 ; WX 611 ; N uogonek ; B 66 -228 545 532 ;
C -1 ; WX 667 ; N Edieresis ; B 76 0 621 915 ;
C -1 ; WX 722 ; N Dcroat ; B -5 0 685 718 ;
C -1 ; WX 250 ; N commaaccent ; B 64 -228 199 -50 ;
C -1 ; WX 737 ; N copyright ; B -11 -19 749 737 ;
C -1 ; WX 667 ; N Emacron ; B 76 0 621 864 ;
C -1 ; WX 556 ; N ccaron ; B 34 -14 524 750 ;
C -1 ; WX 556 ; N aring ; B 29 -14 527 776 ;
C -1 ; WX 722 ; N Ncommaaccent ; B 69 -228 654 718 ;
C -1 ; WX 278 ; N lacute ; B 69 0 329 936 ;
C -1 ; WX 556 ; N agrave ; B 29 -14 527 750 ;
C -1 ; WX 611 ; N Tcommaaccent ; B 14 -228 598 718 ;
C -1 ; WX 722 ; N Cacute ; B 44 -19 684 936 ;
C -1 ; WX 556 ; N atilde ; B 29 -14 527 737 ;
C -1 ; WX 667 ; N Edotaccent ; B 76 0 621 915 ;
C -1 ; WX 556 ; N scaron ; B 30 -14 519 750 ;
C -1 ; WX 556 ; N scedilla ; B 30 -228 519 546 ;
C -1 ; WX 278 ; N iacute ; B 69 0 329 750 ;
C -1 ; WX 494 ; N lozenge ; B 10 0 484 745 ;
C -1 ; WX 722 ; N Rcaron ; B 76 0 677 936 ;
C -1 ; WX 778 ; N Gcommaaccent ; B 44 -228 713 737 ;
C -1 ; WX 611 ; N ucircumflex ; B 66 -14 545 750 ;
C -1 ; WX 556 ; N acircumflex ; B 29 -14 527 750 ;
C -1 ; WX 722 ; N Amacron ; B 20 0 702 864 ;
C -1 ; WX 389 ; N rcaron ; B 18 0 373 750 ;
C -1 ; WX 556 ; N ccedilla ; B 34 -228 524 546 ;
C -1 ; WX 611 ; N Zdotaccent ; B 25 0 586 915 ;
C -1 ; WX 667 ; N Thorn ; B 76 0 627 718 ;
C -1 ; WX 778 ; N Omacron ; B 44 -19 734 864 ;
C -1 ; WX 722 ; N Racute ; B 76 0 677 936 ;
C -1 ; WX 667 ; N Sacute ; B 39 -19 629 936 ;
C -1 ; WX 743 ; N dcaron ; B 34 -14 750 718 ;
C -1 ; WX 722 ; N Umacron ; B 72 -19 651 864 ;
C -1 ; WX 611 ; N uring ; B 66 -14 545 776 ;
C -1 ; WX 333 ; N threesuperior ; B 8 271 326 710 ;
C -1 ; WX 778 ; N Ograve ; B 44 -19 734 936 ;
C -1 ; WX 722 ; N Agrave ; B 20 0 702 936 ;
C -1 ; WX 722 ; N Abreve ; B 20 0 702 936 ;
C -1 ; WX 584 ; N multiply ; B 40 1 545 505 ;
C -1 ; WX 611 ; N uacute ; B 66 -14 545 750 ;
C -1 ; WX 611 ; N Tcaron ; B 14 0 598 936 ;
C -1 ; WX 494 ; N partialdiff ; B 11 -21 494 750 ;
C -1 ; WX 556 ; N ydieresis ; B 10 -214 539 729 ;
C -1 ; WX 722 ; N Nacute ; B 69 0 654 936 ;
C -1 ; WX 278 ; N icircumflex ; B -37 0 316 750 ;
C -1 ; WX 667 ; N Ecircumflex ; B 76 0 621 936 ;
C -1 ; WX 556 ; N adieresis ; B 29 -14 527 729 ;
C -1 ; WX 556 ; N edieresis ; B 23 -14 528 729 ;
C -1 ; WX 556 ; N cacute ; B 34 -14 524 750 ;
C -1 ; WX 611 ; N nacute ; B 65 0 546 750 ;
C -1 ; WX 611 ; N umacron ; B 66 -14 545 678 ;
C -1 ; WX 722 ; N Ncaron ; B 69 0 654 936 ;
C -1 ; WX 278 ; N Iacute ; B 64 0 329 936 ;
C -1 ; WX 584 ; N plusminus ; B 40 0 544 506 ;
C -1 ; WX 280 ; N brokenbar ; B 84 -150 196 700 ;
C -1 ; WX 737 ; N registered ; B -11 -19 748 737 ;
C -1 ; WX 778 ; N Gbreve ; B 44 -19 713 936 ;
C -1 ; WX 278 ; N Idotaccent ; B 64 0 214 915 ;
C -1 ; WX 600 ; N summation ; B 14 -10 585 706 ;
C -1 ; WX 667 ; N Egrave ; B 76 0 621 936 ;
C -1 ; WX 389 ; N racute ; B 64 0 384 750 ;
C -1 ; WX 611 ; N omacron ; B 34 -14 578 678 ;
C -1 ; WX 611 ; N Zacute ; B 25 0 586 936 ;
C -1 ; WX 611 ; N Zcaron ; B 25 0 586 936 ;
C -1 ; WX 549 ; N greaterequal ; B 26 0 523 704 ;
C -1 ; WX 722 ; N Eth ; B -5 0 685 718 ;
C -1 ; WX 722 ; N Ccedilla ; B 44 -228 684 737 ;
C -1 ; WX 278 ; N lcommaaccent ; B 69 -228 213 718 ;
C -1 ; WX 389 ; N tcaron ; B 10 -6 421 878 ;
C -1 ; WX 556 ; N eogonek ; B 23 -228 528 546 ;
C -1 ; WX 722 ; N Uogonek ; B 72 -228 651 718 ;
C -1 ; WX 722 ; N Aacute ; B 20 0 702 936 ;
C -1 ; WX 722 ; N Adieresis ; B 20 0 702 915 ;
C -1 ; WX 556 ; N egrave ; B 23 -14 528 750 ;
C -1 ; WX 500 ; N zacute ; B 20 0 480 750 ;
C -1 ; WX 278 ; N iogonek ; B 16 -224 249 725 ;
C -1 ; WX 778 ; N Oacute ; B 44 -19 734 936 ;
C -1 ; WX 611 ; N oacute ; B 34 -14 578 750 ;
C -1 ; WX 556 ; N amacron ; B 29 -14 527 678 ;
C -1 ; WX 556 ; N sacute ; B 30 -14 519 750 ;
C -1 ; WX 278 ; N idieresis ; B -21 0 300 729 ;
C -1 ; WX 778 ; N Ocircumflex ; B 44 -19 734 936 ;
C -1 ; WX 722 ; N Ugrave ; B 72 -19 651 936 ;
C -1 ; WX 612 ; N Delta ; B 6 0 608 688 ;
C -1 ; WX 611 ; N thorn ; B 62 -208 578 718 ;
C -1 ; WX 333 ; N twosuperior ; B 9 283 324 710 ;
C -1 ; WX 778 ; N Odieresis ; B 44 -19 734 915 ;
C -1 ; WX 611 ; N mu ; B 66 -207 545 532 ;
C -1 ; WX 278 ; N igrave ; B -50 0 209 750 ;
C -1 ; WX 611 ; N ohungarumlaut ; B 34 -14 625 750 ;
C -1 ; WX 667 ; N Eogonek ; B 76 -224 639 718 ;
C -1 ; WX 611 ; N dcroat ; B 34 -14 650 718 ;
C -1 ; WX 834 ; N threequarters ; B 16 -19 799 710 ;
C -1 ; WX 667 ; N Scedilla ; B 39 -228 629 737 ;
C -1 ; WX 400 ; N lcaron ; B 69 0 408 718 ;
C -1 ; WX 722 ; N Kcommaaccent ; B 87 -228 722 718 ;
C -1 ; WX 611 ; N Lacute ; B 76 0 583 936 ;
C -1 ; WX 1000 ; N trademark ; B 44 306 956 718 ;
C -1 ; WX 556 ; N edotaccent ; B 23 -14 528 729 ;
C -1 ; WX 278 ; N Igrave ; B -50 0 214 936 ;
C -1 ; WX 278 ; N Imacron ; B -33 0 312 864 ;
C -1 ; WX 611 ; N Lcaron ; B 76 0 583 718 ;
C -1 ; WX 834 ; N onehalf ; B 26 -19 794 710 ;
C -1 ; WX 549 ; N lessequal ; B 29 0 526 704 ;
C -1 ; WX 611 ; N ocircumflex ; B 34 -14 578 750 ;
C -1 ; WX 611 ; N ntilde ; B 65 0 546 737 ;
C -1 ; WX 722 ; N Uhungarumlaut ; B 72 -19 681 936 ;
C -1 ; WX 667 ; N Eacute ; B 76 0 621 936 ;
C -1 ; WX 556 ; N emacron ; B 23 -14 528 678 ;
C -1 ; WX 611 ; N gbreve ; B 40 -217 553 750 ;
C -1 ; WX 834 ; N onequarter ; B 26 -19 766 710 ;
C -1 ; WX 667 ; N Scaron ; B 39 -19 629 936 ;
C -1 ; WX 667 ; N Scommaaccent ; B 39 -228 629 737 ;
C -1 ; WX 778 ; N Ohungarumlaut ; B 44 -19 734 936 ;
C -1 ; WX 400 ; N degree ; B 57 426 343 712 ;
C -1 ; WX 611 ; N ograve ; B 34 -14 578 750 ;
C -1 ; WX 722 ; N Ccaron ; B 44 -19 684 936 ;
C -1 ; WX 611 ; N ugrave ; B 66 -14 545 750 ;
C -1 ; WX 549 ; N radical ; B 10 -46 512 850 ;
C -1 ; WX 722 ; N Dcaron ; B 76 0 685 936 ;
C -1 ; WX 389 ; N rcommaaccent ; B 64 -228 373 546 ;
C -1 ; WX 722 ; N Ntilde ; B 69 0 654 923 ;
C -1 ; WX 611 ; N otilde ; B 34 -14 578 737 ;
C -1 ; WX 722 ; N Rcommaaccent ; B 76 -228 677 718 ;
C -1 ; WX 611 ; N Lcommaaccent ; B 76 -228 583 718 ;
C -1 ; WX 722 ; N Atilde ; B 20 0 702 923 ;
C -1 ; WX 722 ; N Aogonek ; B 20 -224 742 718 ;
C -1 ; WX 722 ; N Aring ; B 20 0 702 962 ;
C -1 ; WX 778 ; N Otilde ; B 44 -19 734 923 ;
C -1 ; WX 500 ; N zdotaccent ; B 20 0 480 729 ;
C -1 ; WX 667 ; N Ecaron ; B 76 0 621 936 ;
C -1 ; WX 278 ; N Iogonek ; B -11 -228 222 718 ;
C -1 ; WX 556 ; N kcommaaccent ; B 69 -228 562 718 ;
C -1 ; WX 584 ; N minus ; B 40 197 544 309 ;
C -1 ; WX 278 ; N Icircumflex ; B -37 0 316 936 ;
C -1 ; WX 611 ; N ncaron ; B 65 0 546 750 ;
C -1 ; WX 333 ; N tcommaaccent ; B 10 -228 309 676 ;
C -1 ; WX 584 ; N logicalnot ; B 40 108 544 419 ;
C -1 ; WX 611 ; N odieresis ; B 34 -14 578 729 ;
C -1 ; WX 611 ; N udieresis ; B 66 -14 545 729 ;
C -1 ; WX 549 ; N notequal ; B 15 -49 540 570 ;
C -1 ; WX 611 ; N gcommaaccent ; B 40 -217 553 850 ;
C -1 ; WX 611 ; N eth ; B 34 -14 578 737 ;
C -1 ; WX 500 ; N zcaron ; B 20 0 480 750 ;
C -1 ; WX 611 ; N ncommaaccent ; B 65 -228 546 546 ;
C -1 ; WX 333 ; N onesuperior ; B 26 283 237 710 ;
C -1 ; WX 278 ; N imacron ; B -8 0 285 678 ;
C -1 ; WX 556 ; N Euro ; B 0 0 0 0 ;
EndCharMetrics
StartKernData
StartKernPairs 2481
KPX A C -40
KPX A Cacute -40
KPX A Ccaron -40
KPX A Ccedilla -40
KPX A G -50
KPX A Gbreve -50
KPX A Gcommaaccent -50
KPX A O -40
KPX A Oacute -40
KPX A Ocircumflex -40
KPX A Odieresis -40
KPX A Ograve -40
KPX A Ohungarumlaut -40
KPX A Omacron -40
KPX A Oslash -40
KPX A Otilde -40
KPX A Q -40
KPX A T -90
KPX A Tcaron -90
KPX A Tcommaaccent -90
KPX A U -50
KPX A Uacute -50
KPX A Ucircumflex -50
KPX A Udieresis -50
KPX A Ugrave -50
KPX A Uhungarumlaut -50
KPX A Umacron -50
KPX A Uogonek -50
KPX A Uring -50
KPX A V -80
KPX A W -60
KPX A Y -110
KPX A Yacute -110
KPX A Ydieresis -110
KPX A u -30
KPX A uacute -30
KPX A ucircumflex -30
KPX A udieresis -30
KPX A ugrave -30
KPX A uhungarumlaut -30
KPX A umacron -30
KPX A uogonek -30
KPX A uring -30
KPX A v -40
KPX A w -30
KPX A y -30
KPX A yacute -30
KPX A ydieresis -30
KPX Aacute C -40
KPX Aacute Cacute -40
KPX Aacute Ccaron -40
KPX Aacute Ccedilla -40
KPX Aacute G -50
KPX Aacute Gbreve -50
KPX Aacute Gcommaaccent -50
KPX Aacute O -40
KPX Aacute Oacute -40
KPX Aacute Ocircumflex -40
KPX Aacute Odieresis -40
KPX Aacute Ograve -40
KPX Aacute Ohungarumlaut -40
KPX Aacute Omacron -40
KPX Aacute Oslash -40
KPX Aacute Otilde -40
KPX Aacute Q -40
KPX Aacute T -90
KPX Aacute Tcaron -90
KPX Aacute Tcommaaccent -90
KPX Aacute U -50
KPX Aacute Uacute -50
KPX Aacute Ucircumflex -50
KPX Aacute Udieresis -50
KPX Aacute Ugrave -50
KPX Aacute Uhungarumlaut -50
KPX Aacute Umacron -50
KPX Aacute Uogonek -50
KPX Aacute Uring -50
KPX Aacute V -80
KPX Aacute W -60
KPX Aacute Y -110
KPX Aacute Yacute -110
KPX Aacute Ydieresis -110
KPX Aacute u -30
KPX Aacute uacute -30
KPX Aacute ucircumflex -30
KPX Aacute udieresis -30
KPX Aacute ugrave -30
KPX Aacute uhungarumlaut -30
KPX Aacute umacron -30
KPX Aacute uogonek -30
KPX Aacute uring -30
KPX Aacute v -40
KPX Aacute w -30
KPX Aacute y -30
KPX Aacute yacute -30
KPX Aacute ydieresis -30
KPX Abreve C -40
KPX Abreve Cacute -40
KPX Abreve Ccaron -40
KPX Abreve Ccedilla -40
KPX Abreve G -50
KPX Abreve Gbreve -50
KPX Abreve Gcommaaccent -50
KPX Abreve O -40
KPX Abreve Oacute -40
KPX Abreve Ocircumflex -40
KPX Abreve Odieresis -40
KPX Abreve Ograve -40
KPX Abreve Ohungarumlaut -40
KPX Abreve Omacron -40
KPX Abreve Oslash -40
KPX Abreve Otilde -40
KPX Abreve Q -40
KPX Abreve T -90
KPX Abreve Tcaron -90
KPX Abreve Tcommaaccent -90
KPX Abreve U -50
KPX Abreve Uacute -50
KPX Abreve Ucircumflex -50
KPX Abreve Udieresis -50
KPX Abreve Ugrave -50
KPX Abreve Uhungarumlaut -50
KPX Abreve Umacron -50
KPX Abreve Uogonek -50
KPX Abreve Uring -50
KPX Abreve V -80
KPX Abreve W -60
KPX Abreve Y -110
KPX Abreve Yacute -110
KPX Abreve Ydieresis -110
KPX Abreve u -30
KPX Abreve uacute -30
KPX Abreve ucircumflex -30
KPX Abreve udieresis -30
KPX Abreve ugrave -30
KPX Abreve uhungarumlaut -30
KPX Abreve umacron -30
KPX Abreve uogonek -30
KPX Abreve uring -30
KPX Abreve v -40
KPX Abreve w -30
KPX Abreve y -30
KPX Abreve yacute -30
KPX Abreve ydieresis -30
KPX Acircumflex C -40
KPX Acircumflex Cacute -40
KPX Acircumflex Ccaron -40
KPX Acircumflex Ccedilla -40
KPX Acircumflex G -50
KPX Acircumflex Gbreve -50
KPX Acircumflex Gcommaaccent -50
KPX Acircumflex O -40
KPX Acircumflex Oacute -40
KPX Acircumflex Ocircumflex -40
KPX Acircumflex Odieresis -40
KPX Acircumflex Ograve -40
KPX Acircumflex Ohungarumlaut -40
KPX Acircumflex Omacron -40
KPX Acircumflex Oslash -40
KPX Acircumflex Otilde -40
KPX Acircumflex Q -40
KPX Acircumflex T -90
KPX Acircumflex Tcaron -90
KPX Acircumflex Tcommaaccent -90
KPX Acircumflex U -50
KPX Acircumflex Uacute -50
KPX Acircumflex Ucircumflex -50
KPX Acircumflex Udieresis -50
KPX Acircumflex Ugrave -50
KPX Acircumflex Uhungarumlaut -50
KPX Acircumflex Umacron -50
KPX Acircumflex Uogonek -50
KPX Acircumflex Uring -50
KPX Acircumflex V -80
KPX Acircumflex W -60
KPX Acircumflex Y -110
KPX Acircumflex Yacute -110
KPX Acircumflex Ydieresis -110
KPX Acircumflex u -30
KPX Acircumflex uacute -30
KPX Acircumflex ucircumflex -30
KPX Acircumflex udieresis -30
KPX Acircumflex ugrave -30
KPX Acircumflex uhungarumlaut -30
KPX Acircumflex umacron -30
KPX Acircumflex uogonek -30
KPX Acircumflex uring -30
KPX Acircumflex v -40
KPX Acircumflex w -30
KPX Acircumflex y -30
KPX Acircumflex yacute -30
KPX Acircumflex ydieresis -30
KPX Adieresis C -40
KPX Adieresis Cacute -40
KPX Adieresis Ccaron -40
KPX Adieresis Ccedilla -40
KPX Adieresis G -50
KPX Adieresis Gbreve -50
KPX Adieresis Gcommaaccent -50
KPX Adieresis O -40
KPX Adieresis Oacute -40
KPX Adieresis Ocircumflex -40
KPX Adieresis Odieresis -40
KPX Adieresis Ograve -40
KPX Adieresis Ohungarumlaut -40
KPX Adieresis Omacron -40
KPX Adieresis Oslash -40
KPX Adieresis Otilde -40
KPX Adieresis Q -40
KPX Adieresis T -90
KPX Adieresis Tcaron -90
KPX Adieresis Tcommaaccent -90
KPX Adieresis U -50
KPX Adieresis Uacute -50
KPX Adieresis Ucircumflex -50
KPX Adieresis Udieresis -50
KPX Adieresis Ugrave -50
KPX Adieresis Uhungarumlaut -50
KPX Adieresis Umacron -50
KPX Adieresis Uogonek -50
KPX Adieresis Uring -50
KPX Adieresis V -80
KPX Adieresis W -60
KPX Adieresis Y -110
KPX Adieresis Yacute -110
KPX Adieresis Ydieresis -110
KPX Adieresis u -30
KPX Adieresis uacute -30
KPX Adieresis ucircumflex -30
KPX Adieresis udieresis -30
KPX Adieresis ugrave -30
KPX Adieresis uhungarumlaut -30
KPX Adieresis umacron -30
KPX Adieresis uogonek -30
KPX Adieresis uring -30
KPX Adieresis v -40
KPX Adieresis w -30
KPX Adieresis y -30
KPX Adieresis yacute -30
KPX Adieresis ydieresis -30
KPX Agrave C -40
KPX Agrave Cacute -40
KPX Agrave Ccaron -40
KPX Agrave Ccedilla -40
KPX Agrave G -50
KPX Agrave Gbreve -50
KPX Agrave Gcommaaccent -50
KPX Agrave O -40
KPX Agrave Oacute -40
KPX Agrave Ocircumflex -40
KPX Agrave Odieresis -40
KPX Agrave Ograve -40
KPX Agrave Ohungarumlaut -40
KPX Agrave Omacron -40
KPX Agrave Oslash -40
KPX Agrave Otilde -40
KPX Agrave Q -40
KPX Agrave T -90
KPX Agrave Tcaron -90
KPX Agrave Tcommaaccent -90
KPX Agrave U -50
KPX Agrave Uacute -50
KPX Agrave Ucircumflex -50
KPX Agrave Udieresis -50
KPX Agrave Ugrave -50
KPX Agrave Uhungarumlaut -50
KPX Agrave Umacron -50
KPX Agrave Uogonek -50
KPX Agrave Uring -50
KPX Agrave V -80
KPX Agrave W -60
KPX Agrave Y -110
KPX Agrave Yacute -110
KPX Agrave Ydieresis -110
KPX Agrave u -30
KPX Agrave uacute -30
KPX Agrave ucircumflex -30
KPX Agrave udieresis -30
KPX Agrave ugrave -30
KPX Agrave uhungarumlaut -30
KPX Agrave umacron -30
KPX Agrave uogonek -30
KPX Agrave uring -30
KPX Agrave v -40
KPX Agrave w -30
KPX Agrave y -30
KPX Agrave yacute -30
KPX Agrave ydieresis -30
KPX Amacron C -40
KPX Amacron Cacute -40
KPX Amacron Ccaron -40
KPX Amacron Ccedilla -40
KPX Amacron G -50
KPX Amacron Gbreve -50
KPX Amacron Gcommaaccent -50
KPX Amacron O -40
KPX Amacron Oacute -40
KPX Amacron Ocircumflex -40
KPX Amacron Odieresis -40
KPX Amacron Ograve -40
KPX Amacron Ohungarumlaut -40
KPX Amacron Omacron -40
KPX Amacron Oslash -40
KPX Amacron Otilde -40
KPX Amacron Q -40
KPX Amacron T -90
KPX Amacron Tcaron -90
KPX Amacron Tcommaaccent -90
KPX Amacron U -50
KPX Amacron Uacute -50
KPX Amacron Ucircumflex -50
KPX Amacron Udieresis -50
KPX Amacron Ugrave -50
KPX Amacron Uhungarumlaut -50
KPX Amacron Umacron -50
KPX Amacron Uogonek -50
KPX Amacron Uring -50
KPX Amacron V -80
KPX Amacron W -60
KPX Amacron Y -110
KPX Amacron Yacute -110
KPX Amacron Ydieresis -110
KPX Amacron u -30
KPX Amacron uacute -30
KPX Amacron ucircumflex -30
KPX Amacron udieresis -30
KPX Amacron ugrave -30
KPX Amacron uhungarumlaut -30
KPX Amacron umacron -30
KPX Amacron uogonek -30
KPX Amacron uring -30
KPX Amacron v -40
KPX Amacron w -30
KPX Amacron y -30
KPX Amacron yacute -30
KPX Amacron ydieresis -30
KPX Aogonek C -40
KPX Aogonek Cacute -40
KPX Aogonek Ccaron -40
KPX Aogonek Ccedilla -40
KPX Aogonek G -50
KPX Aogonek Gbreve -50
KPX Aogonek Gcommaaccent -50
KPX Aogonek O -40
KPX Aogonek Oacute -40
KPX Aogonek Ocircumflex -40
KPX Aogonek Odieresis -40
KPX Aogonek Ograve -40
KPX Aogonek Ohungarumlaut -40
KPX Aogonek Omacron -40
KPX Aogonek Oslash -40
KPX Aogonek Otilde -40
KPX Aogonek Q -40
KPX Aogonek T -90
KPX Aogonek Tcaron -90
KPX Aogonek Tcommaaccent -90
KPX Aogonek U -50
KPX Aogonek Uacute -50
KPX Aogonek Ucircumflex -50
KPX Aogonek Udieresis -50
KPX Aogonek Ugrave -50
KPX Aogonek Uhungarumlaut -50
KPX Aogonek Umacron -50
KPX Aogonek Uogonek -50
KPX Aogonek Uring -50
KPX Aogonek V -80
KPX Aogonek W -60
KPX Aogonek Y -110
KPX Aogonek Yacute -110
KPX Aogonek Ydieresis -110
KPX Aogonek u -30
KPX Aogonek uacute -30
KPX Aogonek ucircumflex -30
KPX Aogonek udieresis -30
KPX Aogonek ugrave -30
KPX Aogonek uhungarumlaut -30
KPX Aogonek umacron -30
KPX Aogonek uogonek -30
KPX Aogonek uring -30
KPX Aogonek v -40
KPX Aogonek w -30
KPX Aogonek y -30
KPX Aogonek yacute -30
KPX Aogonek ydieresis -30
KPX Aring C -40
KPX Aring Cacute -40
KPX Aring Ccaron -40
KPX Aring Ccedilla -40
KPX Aring G -50
KPX Aring Gbreve -50
KPX Aring Gcommaaccent -50
KPX Aring O -40
KPX Aring Oacute -40
KPX Aring Ocircumflex -40
KPX Aring Odieresis -40
KPX Aring Ograve -40
KPX Aring Ohungarumlaut -40
KPX Aring Omacron -40
KPX Aring Oslash -40
KPX Aring Otilde -40
KPX Aring Q -40
KPX Aring T -90
KPX Aring Tcaron -90
KPX Aring Tcommaaccent -90
KPX Aring U -50
KPX Aring Uacute -50
KPX Aring Ucircumflex -50
KPX Aring Udieresis -50
KPX Aring Ugrave -50
KPX Aring Uhungarumlaut -50
KPX Aring Umacron -50
KPX Aring Uogonek -50
KPX Aring Uring -50
KPX Aring V -80
KPX Aring W -60
KPX Aring Y -110
KPX Aring Yacute -110
KPX Aring Ydieresis -110
KPX Aring u -30
KPX Aring uacute -30
KPX Aring ucircumflex -30
KPX Aring udieresis -30
KPX Aring ugrave -30
KPX Aring uhungarumlaut -30
KPX Aring umacron -30
KPX Aring uogonek -30
KPX Aring uring -30
KPX Aring v -40
KPX Aring w -30
KPX Aring y -30
KPX Aring yacute -30
KPX Aring ydieresis -30
KPX Atilde C -40
KPX Atilde Cacute -40
KPX Atilde Ccaron -40
KPX Atilde Ccedilla -40
KPX Atilde G -50
KPX Atilde Gbreve -50
KPX Atilde Gcommaaccent -50
KPX Atilde O -40
KPX Atilde Oacute -40
KPX Atilde Ocircumflex -40
KPX Atilde Odieresis -40
KPX Atilde Ograve -40
KPX Atilde Ohungarumlaut -40
KPX Atilde Omacron -40
KPX Atilde Oslash -40
KPX Atilde Otilde -40
KPX Atilde Q -40
KPX Atilde T -90
KPX Atilde Tcaron -90
KPX Atilde Tcommaaccent -90
KPX Atilde U -50
KPX Atilde Uacute -50
KPX Atilde Ucircumflex -50
KPX Atilde Udieresis -50
KPX Atilde Ugrave -50
KPX Atilde Uhungarumlaut -50
KPX Atilde Umacron -50
KPX Atilde Uogonek -50
KPX Atilde Uring -50
KPX Atilde V -80
KPX Atilde W -60
KPX Atilde Y -110
KPX Atilde Yacute -110
KPX Atilde Ydieresis -110
KPX Atilde u -30
KPX Atilde uacute -30
KPX Atilde ucircumflex -30
KPX Atilde udieresis -30
KPX Atilde ugrave -30
KPX Atilde uhungarumlaut -30
KPX Atilde umacron -30
KPX Atilde uogonek -30
KPX Atilde uring -30
KPX Atilde v -40
KPX Atilde w -30
KPX Atilde y -30
KPX Atilde yacute -30
KPX Atilde ydieresis -30
KPX B A -30
KPX B Aacute -30
KPX B Abreve -30
KPX B Acircumflex -30
KPX B Adieresis -30
KPX B Agrave -30
KPX B Amacron -30
KPX B Aogonek -30
KPX B Aring -30
KPX B Atilde -30
KPX B U -10
KPX B Uacute -10
KPX B Ucircumflex -10
KPX B Udieresis -10
KPX B Ugrave -10
KPX B Uhungarumlaut -10
KPX B Umacron -10
KPX B Uogonek -10
KPX B Uring -10
KPX D A -40
KPX D Aacute -40
KPX D Abreve -40
KPX D Acircumflex -40
KPX D Adieresis -40
KPX D Agrave -40
KPX D Amacron -40
KPX D Aogonek -40
KPX D Aring -40
KPX D Atilde -40
KPX D V -40
KPX D W -40
KPX D Y -70
KPX D Yacute -70
KPX D Ydieresis -70
KPX D comma -30
KPX D period -30
KPX Dcaron A -40
KPX Dcaron Aacute -40
KPX Dcaron Abreve -40
KPX Dcaron Acircumflex -40
KPX Dcaron Adieresis -40
KPX Dcaron Agrave -40
KPX Dcaron Amacron -40
KPX Dcaron Aogonek -40
KPX Dcaron Aring -40
KPX Dcaron Atilde -40
KPX Dcaron V -40
KPX Dcaron W -40
KPX Dcaron Y -70
KPX Dcaron Yacute -70
KPX Dcaron Ydieresis -70
KPX Dcaron comma -30
KPX Dcaron period -30
KPX Dcroat A -40
KPX Dcroat Aacute -40
KPX Dcroat Abreve -40
KPX Dcroat Acircumflex -40
KPX Dcroat Adieresis -40
KPX Dcroat Agrave -40
KPX Dcroat Amacron -40
KPX Dcroat Aogonek -40
KPX Dcroat Aring -40
KPX Dcroat Atilde -40
KPX Dcroat V -40
KPX Dcroat W -40
KPX Dcroat Y -70
KPX Dcroat Yacute -70
KPX Dcroat Ydieresis -70
KPX Dcroat comma -30
KPX Dcroat period -30
KPX F A -80
KPX F Aacute -80
KPX F Abreve -80
KPX F Acircumflex -80
KPX F Adieresis -80
KPX F Agrave -80
KPX F Amacron -80
KPX F Aogonek -80
KPX F Aring -80
KPX F Atilde -80
KPX F a -20
KPX F aacute -20
KPX F abreve -20
KPX F acircumflex -20
KPX F adieresis -20
KPX F agrave -20
KPX F amacron -20
KPX F aogonek -20
KPX F aring -20
KPX F atilde -20
KPX F comma -100
KPX F period -100
KPX J A -20
KPX J Aacute -20
KPX J Abreve -20
KPX J Acircumflex -20
KPX J Adieresis -20
KPX J Agrave -20
KPX J Amacron -20
KPX J Aogonek -20
KPX J Aring -20
KPX J Atilde -20
KPX J comma -20
KPX J period -20
KPX J u -20
KPX J uacute -20
KPX J ucircumflex -20
KPX J udieresis -20
KPX J ugrave -20
KPX J uhungarumlaut -20
KPX J umacron -20
KPX J uogonek -20
KPX J uring -20
KPX K O -30
KPX K Oacute -30
KPX K Ocircumflex -30
KPX K Odieresis -30
KPX K Ograve -30
KPX K Ohungarumlaut -30
KPX K Omacron -30
KPX K Oslash -30
KPX K Otilde -30
KPX K e -15
KPX K eacute -15
KPX K ecaron -15
KPX K ecircumflex -15
KPX K edieresis -15
KPX K edotaccent -15
KPX K egrave -15
KPX K emacron -15
KPX K eogonek -15
KPX K o -35
KPX K oacute -35
KPX K ocircumflex -35
KPX K odieresis -35
KPX K ograve -35
KPX K ohungarumlaut -35
KPX K omacron -35
KPX K oslash -35
KPX K otilde -35
KPX K u -30
KPX K uacute -30
KPX K ucircumflex -30
KPX K udieresis -30
KPX K ugrave -30
KPX K uhungarumlaut -30
KPX K umacron -30
KPX K uogonek -30
KPX K uring -30
KPX K y -40
KPX K yacute -40
KPX K ydieresis -40
KPX Kcommaaccent O -30
KPX Kcommaaccent Oacute -30
KPX Kcommaaccent Ocircumflex -30
KPX Kcommaaccent Odieresis -30
KPX Kcommaaccent Ograve -30
KPX Kcommaaccent Ohungarumlaut -30
KPX Kcommaaccent Omacron -30
KPX Kcommaaccent Oslash -30
KPX Kcommaaccent Otilde -30
KPX Kcommaaccent e -15
KPX Kcommaaccent eacute -15
KPX Kcommaaccent ecaron -15
KPX Kcommaaccent ecircumflex -15
KPX Kcommaaccent edieresis -15
KPX Kcommaaccent edotaccent -15
KPX Kcommaaccent egrave -15
KPX Kcommaaccent emacron -15
KPX Kcommaaccent eogonek -15
KPX Kcommaaccent o -35
KPX Kcommaaccent oacute -35
KPX Kcommaaccent ocircumflex -35
KPX Kcommaaccent odieresis -35
KPX Kcommaaccent ograve -35
KPX Kcommaaccent ohungarumlaut -35
KPX Kcommaaccent omacron -35
KPX Kcommaaccent oslash -35
KPX Kcommaaccent otilde -35
KPX Kcommaaccent u -30
KPX Kcommaaccent uacute -30
KPX Kcommaaccent ucircumflex -30
KPX Kcommaaccent udieresis -30
KPX Kcommaaccent ugrave -30
KPX Kcommaaccent uhungarumlaut -30
KPX Kcommaaccent umacron -30
KPX Kcommaaccent uogonek -30
KPX Kcommaaccent uring -30
KPX Kcommaaccent y -40
KPX Kcommaaccent yacute -40
KPX Kcommaaccent ydieresis -40
KPX L T -90
KPX L Tcaron -90
KPX L Tcommaaccent -90
KPX L V -110
KPX L W -80
KPX L Y -120
KPX L Yacute -120
KPX L Ydieresis -120
KPX L quotedblright -140
KPX L quoteright -140
KPX L y -30
KPX L yacute -30
KPX L ydieresis -30
KPX Lacute T -90
KPX Lacute Tcaron -90
KPX Lacute Tcommaaccent -90
KPX Lacute V -110
KPX Lacute W -80
KPX Lacute Y -120
KPX Lacute Yacute -120
KPX Lacute Ydieresis -120
KPX Lacute quotedblright -140
KPX Lacute quoteright -140
KPX Lacute y -30
KPX Lacute yacute -30
KPX Lacute ydieresis -30
KPX Lcommaaccent T -90
KPX Lcommaaccent Tcaron -90
KPX Lcommaaccent Tcommaaccent -90
KPX Lcommaaccent V -110
KPX Lcommaaccent W -80
KPX Lcommaaccent Y -120
KPX Lcommaaccent Yacute -120
KPX Lcommaaccent Ydieresis -120
KPX Lcommaaccent quotedblright -140
KPX Lcommaaccent quoteright -140
KPX Lcommaaccent y -30
KPX Lcommaaccent yacute -30
KPX Lcommaaccent ydieresis -30
KPX Lslash T -90
KPX Lslash Tcaron -90
KPX Lslash Tcommaaccent -90
KPX Lslash V -110
KPX Lslash W -80
KPX Lslash Y -120
KPX Lslash Yacute -120
KPX Lslash Ydieresis -120
KPX Lslash quotedblright -140
KPX Lslash quoteright -140
KPX Lslash y -30
KPX Lslash yacute -30
KPX Lslash ydieresis -30
KPX O A -50
KPX O Aacute -50
KPX O Abreve -50
KPX O Acircumflex -50
KPX O Adieresis -50
KPX O Agrave -50
KPX O Amacron -50
KPX O Aogonek -50
KPX O Aring -50
KPX O Atilde -50
KPX O T -40
KPX O Tcaron -40
KPX O Tcommaaccent -40
KPX O V -50
KPX O W -50
KPX O X -50
KPX O Y -70
KPX O Yacute -70
KPX O Ydieresis -70
KPX O comma -40
KPX O period -40
KPX Oacute A -50
KPX Oacute Aacute -50
KPX Oacute Abreve -50
KPX Oacute Acircumflex -50
KPX Oacute Adieresis -50
KPX Oacute Agrave -50
KPX Oacute Amacron -50
KPX Oacute Aogonek -50
KPX Oacute Aring -50
KPX Oacute Atilde -50
KPX Oacute T -40
KPX Oacute Tcaron -40
KPX Oacute Tcommaaccent -40
KPX Oacute V -50
KPX Oacute W -50
KPX Oacute X -50
KPX Oacute Y -70
KPX Oacute Yacute -70
KPX Oacute Ydieresis -70
KPX Oacute comma -40
KPX Oacute period -40
KPX Ocircumflex A -50
KPX Ocircumflex Aacute -50
KPX Ocircumflex Abreve -50
KPX Ocircumflex Acircumflex -50
KPX Ocircumflex Adieresis -50
KPX Ocircumflex Agrave -50
KPX Ocircumflex Amacron -50
KPX Ocircumflex Aogonek -50
KPX Ocircumflex Aring -50
KPX Ocircumflex Atilde -50
KPX Ocircumflex T -40
KPX Ocircumflex Tcaron -40
KPX Ocircumflex Tcommaaccent -40
KPX Ocircumflex V -50
KPX Ocircumflex W -50
KPX Ocircumflex X -50
KPX Ocircumflex Y -70
KPX Ocircumflex Yacute -70
KPX Ocircumflex Ydieresis -70
KPX Ocircumflex comma -40
KPX Ocircumflex period -40
KPX Odieresis A -50
KPX Odieresis Aacute -50
KPX Odieresis Abreve -50
KPX Odieresis Acircumflex -50
KPX Odieresis Adieresis -50
KPX Odieresis Agrave -50
KPX Odieresis Amacron -50
KPX Odieresis Aogonek -50
KPX Odieresis Aring -50
KPX Odieresis Atilde -50
KPX Odieresis T -40
KPX Odieresis Tcaron -40
KPX Odieresis Tcommaaccent -40
KPX Odieresis V -50
KPX Odieresis W -50
KPX Odieresis X -50
KPX Odieresis Y -70
KPX Odieresis Yacute -70
KPX Odieresis Ydieresis -70
KPX Odieresis comma -40
KPX Odieresis period -40
KPX Ograve A -50
KPX Ograve Aacute -50
KPX Ograve Abreve -50
KPX Ograve Acircumflex -50
KPX Ograve Adieresis -50
KPX Ograve Agrave -50
KPX Ograve Amacron -50
KPX Ograve Aogonek -50
KPX Ograve Aring -50
KPX Ograve Atilde -50
KPX Ograve T -40
KPX Ograve Tcaron -40
KPX Ograve Tcommaaccent -40
KPX Ograve V -50
KPX Ograve W -50
KPX Ograve X -50
KPX Ograve Y -70
KPX Ograve Yacute -70
KPX Ograve Ydieresis -70
KPX Ograve comma -40
KPX Ograve period -40
KPX Ohungarumlaut A -50
KPX Ohungarumlaut Aacute -50
KPX Ohungarumlaut Abreve -50
KPX Ohungarumlaut Acircumflex -50
KPX Ohungarumlaut Adieresis -50
KPX Ohungarumlaut Agrave -50
KPX Ohungarumlaut Amacron -50
KPX Ohungarumlaut Aogonek -50
KPX Ohungarumlaut Aring -50
KPX Ohungarumlaut Atilde -50
KPX Ohungarumlaut T -40
KPX Ohungarumlaut Tcaron -40
KPX Ohungarumlaut Tcommaaccent -40
KPX Ohungarumlaut V -50
KPX Ohungarumlaut W -50
KPX Ohungarumlaut X -50
KPX Ohungarumlaut Y -70
KPX Ohungarumlaut Yacute -70
KPX Ohungarumlaut Ydieresis -70
KPX Ohungarumlaut comma -40
KPX Ohungarumlaut period -40
KPX Omacron A -50
KPX Omacron Aacute -50
KPX Omacron Abreve -50
KPX Omacron Acircumflex -50
KPX Omacron Adieresis -50
KPX Omacron Agrave -50
KPX Omacron Amacron -50
KPX Omacron Aogonek -50
KPX Omacron Aring -50
KPX Omacron Atilde -50
KPX Omacron T -40
KPX Omacron Tcaron -40
KPX Omacron Tcommaaccent -40
KPX Omacron V -50
KPX Omacron W -50
KPX Omacron X -50
KPX Omacron Y -70
KPX Omacron Yacute -70
KPX Omacron Ydieresis -70
KPX Omacron comma -40
KPX Omacron period -40
KPX Oslash A -50
KPX Oslash Aacute -50
KPX Oslash Abreve -50
KPX Oslash Acircumflex -50
KPX Oslash Adieresis -50
KPX Oslash Agrave -50
KPX Oslash Amacron -50
KPX Oslash Aogonek -50
KPX Oslash Aring -50
KPX Oslash Atilde -50
KPX Oslash T -40
KPX Oslash Tcaron -40
KPX Oslash Tcommaaccent -40
KPX Oslash V -50
KPX Oslash W -50
KPX Oslash X -50
KPX Oslash Y -70
KPX Oslash Yacute -70
KPX Oslash Ydieresis -70
KPX Oslash comma -40
KPX Oslash period -40
KPX Otilde A -50
KPX Otilde Aacute -50
KPX Otilde Abreve -50
KPX Otilde Acircumflex -50
KPX Otilde Adieresis -50
KPX Otilde Agrave -50
KPX Otilde Amacron -50
KPX Otilde Aogonek -50
KPX Otilde Aring -50
KPX Otilde Atilde -50
KPX Otilde T -40
KPX Otilde Tcaron -40
KPX Otilde Tcommaaccent -40
KPX Otilde V -50
KPX Otilde W -50
KPX Otilde X -50
KPX Otilde Y -70
KPX Otilde Yacute -70
KPX Otilde Ydieresis -70
KPX Otilde comma -40
KPX Otilde period -40
KPX P A -100
KPX P Aacute -100
KPX P Abreve -100
KPX P Acircumflex -100
KPX P Adieresis -100
KPX P Agrave -100
KPX P Amacron -100
KPX P Aogonek -100
KPX P Aring -100
KPX P Atilde -100
KPX P a -30
KPX P aacute -30
KPX P abreve -30
KPX P acircumflex -30
KPX P adieresis -30
KPX P agrave -30
KPX P amacron -30
KPX P aogonek -30
KPX P aring -30
KPX P atilde -30
KPX P comma -120
KPX P e -30
KPX P eacute -30
KPX P ecaron -30
KPX P ecircumflex -30
KPX P edieresis -30
KPX P edotaccent -30
KPX P egrave -30
KPX P emacron -30
KPX P eogonek -30
KPX P o -40
KPX P oacute -40
KPX P ocircumflex -40
KPX P odieresis -40
KPX P ograve -40
KPX P ohungarumlaut -40
KPX P omacron -40
KPX P oslash -40
KPX P otilde -40
KPX P period -120
KPX Q U -10
KPX Q Uacute -10
KPX Q Ucircumflex -10
KPX Q Udieresis -10
KPX Q Ugrave -10
KPX Q Uhungarumlaut -10
KPX Q Umacron -10
KPX Q Uogonek -10
KPX Q Uring -10
KPX Q comma 20
KPX Q period 20
KPX R O -20
KPX R Oacute -20
KPX R Ocircumflex -20
KPX R Odieresis -20
KPX R Ograve -20
KPX R Ohungarumlaut -20
KPX R Omacron -20
KPX R Oslash -20
KPX R Otilde -20
KPX R T -20
KPX R Tcaron -20
KPX R Tcommaaccent -20
KPX R U -20
KPX R Uacute -20
KPX R Ucircumflex -20
KPX R Udieresis -20
KPX R Ugrave -20
KPX R Uhungarumlaut -20
KPX R Umacron -20
KPX R Uogonek -20
KPX R Uring -20
KPX R V -50
KPX R W -40
KPX R Y -50
KPX R Yacute -50
KPX R Ydieresis -50
KPX Racute O -20
KPX Racute Oacute -20
KPX Racute Ocircumflex -20
KPX Racute Odieresis -20
KPX Racute Ograve -20
KPX Racute Ohungarumlaut -20
KPX Racute Omacron -20
KPX Racute Oslash -20
KPX Racute Otilde -20
KPX Racute T -20
KPX Racute Tcaron -20
KPX Racute Tcommaaccent -20
KPX Racute U -20
KPX Racute Uacute -20
KPX Racute Ucircumflex -20
KPX Racute Udieresis -20
KPX Racute Ugrave -20
KPX Racute Uhungarumlaut -20
KPX Racute Umacron -20
KPX Racute Uogonek -20
KPX Racute Uring -20
KPX Racute V -50
KPX Racute W -40
KPX Racute Y -50
KPX Racute Yacute -50
KPX Racute Ydieresis -50
KPX Rcaron O -20
KPX Rcaron Oacute -20
KPX Rcaron Ocircumflex -20
KPX Rcaron Odieresis -20
KPX Rcaron Ograve -20
KPX Rcaron Ohungarumlaut -20
KPX Rcaron Omacron -20
KPX Rcaron Oslash -20
KPX Rcaron Otilde -20
KPX Rcaron T -20
KPX Rcaron Tcaron -20
KPX Rcaron Tcommaaccent -20
KPX Rcaron U -20
KPX Rcaron Uacute -20
KPX Rcaron Ucircumflex -20
KPX Rcaron Udieresis -20
KPX Rcaron Ugrave -20
KPX Rcaron Uhungarumlaut -20
KPX Rcaron Umacron -20
KPX Rcaron Uogonek -20
KPX Rcaron Uring -20
KPX Rcaron V -50
KPX Rcaron W -40
KPX Rcaron Y -50
KPX Rcaron Yacute -50
KPX Rcaron Ydieresis -50
KPX Rcommaaccent O -20
KPX Rcommaaccent Oacute -20
KPX Rcommaaccent Ocircumflex -20
KPX Rcommaaccent Odieresis -20
KPX Rcommaaccent Ograve -20
KPX Rcommaaccent Ohungarumlaut -20
KPX Rcommaaccent Omacron -20
KPX Rcommaaccent Oslash -20
KPX Rcommaaccent Otilde -20
KPX Rcommaaccent T -20
KPX Rcommaaccent Tcaron -20
KPX Rcommaaccent Tcommaaccent -20
KPX Rcommaaccent U -20
KPX Rcommaaccent Uacute -20
KPX Rcommaaccent Ucircumflex -20
KPX Rcommaaccent Udieresis -20
KPX Rcommaaccent Ugrave -20
KPX Rcommaaccent Uhungarumlaut -20
KPX Rcommaaccent Umacron -20
KPX Rcommaaccent Uogonek -20
KPX Rcommaaccent Uring -20
KPX Rcommaaccent V -50
KPX Rcommaaccent W -40
KPX Rcommaaccent Y -50
KPX Rcommaaccent Yacute -50
KPX Rcommaaccent Ydieresis -50
KPX T A -90
KPX T Aacute -90
KPX T Abreve -90
KPX T Acircumflex -90
KPX T Adieresis -90
KPX T Agrave -90
KPX T Amacron -90
KPX T Aogonek -90
KPX T Aring -90
KPX T Atilde -90
KPX T O -40
KPX T Oacute -40
KPX T Ocircumflex -40
KPX T Odieresis -40
KPX T Ograve -40
KPX T Ohungarumlaut -40
KPX T Omacron -40
KPX T Oslash -40
KPX T Otilde -40
KPX T a -80
KPX T aacute -80
KPX T abreve -80
KPX T acircumflex -80
KPX T adieresis -80
KPX T agrave -80
KPX T amacron -80
KPX T aogonek -80
KPX T aring -80
KPX T atilde -80
KPX T colon -40
KPX T comma -80
KPX T e -60
KPX T eacute -60
KPX T ecaron -60
KPX T ecircumflex -60
KPX T edieresis -60
KPX T edotaccent -60
KPX T egrave -60
KPX T emacron -60
KPX T eogonek -60
KPX T hyphen -120
KPX T o -80
KPX T oacute -80
KPX T ocircumflex -80
KPX T odieresis -80
KPX T ograve -80
KPX T ohungarumlaut -80
KPX T omacron -80
KPX T oslash -80
KPX T otilde -80
KPX T period -80
KPX T r -80
KPX T racute -80
KPX T rcommaaccent -80
KPX T semicolon -40
KPX T u -90
KPX T uacute -90
KPX T ucircumflex -90
KPX T udieresis -90
KPX T ugrave -90
KPX T uhungarumlaut -90
KPX T umacron -90
KPX T uogonek -90
KPX T uring -90
KPX T w -60
KPX T y -60
KPX T yacute -60
KPX T ydieresis -60
KPX Tcaron A -90
KPX Tcaron Aacute -90
KPX Tcaron Abreve -90
KPX Tcaron Acircumflex -90
KPX Tcaron Adieresis -90
KPX Tcaron Agrave -90
KPX Tcaron Amacron -90
KPX Tcaron Aogonek -90
KPX Tcaron Aring -90
KPX Tcaron Atilde -90
KPX Tcaron O -40
KPX Tcaron Oacute -40
KPX Tcaron Ocircumflex -40
KPX Tcaron Odieresis -40
KPX Tcaron Ograve -40
KPX Tcaron Ohungarumlaut -40
KPX Tcaron Omacron -40
KPX Tcaron Oslash -40
KPX Tcaron Otilde -40
KPX Tcaron a -80
KPX Tcaron aacute -80
KPX Tcaron abreve -80
KPX Tcaron acircumflex -80
KPX Tcaron adieresis -80
KPX Tcaron agrave -80
KPX Tcaron amacron -80
KPX Tcaron aogonek -80
KPX Tcaron aring -80
KPX Tcaron atilde -80
KPX Tcaron colon -40
KPX Tcaron comma -80
KPX Tcaron e -60
KPX Tcaron eacute -60
KPX Tcaron ecaron -60
KPX Tcaron ecircumflex -60
KPX Tcaron edieresis -60
KPX Tcaron edotaccent -60
KPX Tcaron egrave -60
KPX Tcaron emacron -60
KPX Tcaron eogonek -60
KPX Tcaron hyphen -120
KPX Tcaron o -80
KPX Tcaron oacute -80
KPX Tcaron ocircumflex -80
KPX Tcaron odieresis -80
KPX Tcaron ograve -80
KPX Tcaron ohungarumlaut -80
KPX Tcaron omacron -80
KPX Tcaron oslash -80
KPX Tcaron otilde -80
KPX Tcaron period -80
KPX Tcaron r -80
KPX Tcaron racute -80
KPX Tcaron rcommaaccent -80
KPX Tcaron semicolon -40
KPX Tcaron u -90
KPX Tcaron uacute -90
KPX Tcaron ucircumflex -90
KPX Tcaron udieresis -90
KPX Tcaron ugrave -90
KPX Tcaron uhungarumlaut -90
KPX Tcaron umacron -90
KPX Tcaron uogonek -90
KPX Tcaron uring -90
KPX Tcaron w -60
KPX Tcaron y -60
KPX Tcaron yacute -60
KPX Tcaron ydieresis -60
KPX Tcommaaccent A -90
KPX Tcommaaccent Aacute -90
KPX Tcommaaccent Abreve -90
KPX Tcommaaccent Acircumflex -90
KPX Tcommaaccent Adieresis -90
KPX Tcommaaccent Agrave -90
KPX Tcommaaccent Amacron -90
KPX Tcommaaccent Aogonek -90
KPX Tcommaaccent Aring -90
KPX Tcommaaccent Atilde -90
KPX Tcommaaccent O -40
KPX Tcommaaccent Oacute -40
KPX Tcommaaccent Ocircumflex -40
KPX Tcommaaccent Odieresis -40
KPX Tcommaaccent Ograve -40
KPX Tcommaaccent Ohungarumlaut -40
KPX Tcommaaccent Omacron -40
KPX Tcommaaccent Oslash -40
KPX Tcommaaccent Otilde -40
KPX Tcommaaccent a -80
KPX Tcommaaccent aacute -80
KPX Tcommaaccent abreve -80
KPX Tcommaaccent acircumflex -80
KPX Tcommaaccent adieresis -80
KPX Tcommaaccent agrave -80
KPX Tcommaaccent amacron -80
KPX Tcommaaccent aogonek -80
KPX Tcommaaccent aring -80
KPX Tcommaaccent atilde -80
KPX Tcommaaccent colon -40
KPX Tcommaaccent comma -80
KPX Tcommaaccent e -60
KPX Tcommaaccent eacute -60
KPX Tcommaaccent ecaron -60
KPX Tcommaaccent ecircumflex -60
KPX Tcommaaccent edieresis -60
KPX Tcommaaccent edotaccent -60
KPX Tcommaaccent egrave -60
KPX Tcommaaccent emacron -60
KPX Tcommaaccent eogonek -60
KPX Tcommaaccent hyphen -120
KPX Tcommaaccent o -80
KPX Tcommaaccent oacute -80
KPX Tcommaaccent ocircumflex -80
KPX Tcommaaccent odieresis -80
KPX Tcommaaccent ograve -80
KPX Tcommaaccent ohungarumlaut -80
KPX Tcommaaccent omacron -80
KPX Tcommaaccent oslash -80
KPX Tcommaaccent otilde -80
KPX Tcommaaccent period -80
KPX Tcommaaccent r -80
KPX Tcommaaccent racute -80
KPX Tcommaaccent rcommaaccent -80
KPX Tcommaaccent semicolon -40
KPX Tcommaaccent u -90
KPX Tcommaaccent uacute -90
KPX Tcommaaccent ucircumflex -90
KPX Tcommaaccent udieresis -90
KPX Tcommaaccent ugrave -90
KPX Tcommaaccent uhungarumlaut -90
KPX Tcommaaccent umacron -90
KPX Tcommaaccent uogonek -90
KPX Tcommaaccent uring -90
KPX Tcommaaccent w -60
KPX Tcommaaccent y -60
KPX Tcommaaccent yacute -60
KPX Tcommaaccent ydieresis -60
KPX U A -50
KPX U Aacute -50
KPX U Abreve -50
KPX U Acircumflex -50
KPX U Adieresis -50
KPX U Agrave -50
KPX U Amacron -50
KPX U Aogonek -50
KPX U Aring -50
KPX U Atilde -50
KPX U comma -30
KPX U period -30
KPX Uacute A -50
KPX Uacute Aacute -50
KPX Uacute Abreve -50
KPX Uacute Acircumflex -50
KPX Uacute Adieresis -50
KPX Uacute Agrave -50
KPX Uacute Amacron -50
KPX Uacute Aogonek -50
KPX Uacute Aring -50
KPX Uacute Atilde -50
KPX Uacute comma -30
KPX Uacute period -30
KPX Ucircumflex A -50
KPX Ucircumflex Aacute -50
KPX Ucircumflex Abreve -50
KPX Ucircumflex Acircumflex -50
KPX Ucircumflex Adieresis -50
KPX Ucircumflex Agrave -50
KPX Ucircumflex Amacron -50
KPX Ucircumflex Aogonek -50
KPX Ucircumflex Aring -50
KPX Ucircumflex Atilde -50
KPX Ucircumflex comma -30
KPX Ucircumflex period -30
KPX Udieresis A -50
KPX Udieresis Aacute -50
KPX Udieresis Abreve -50
KPX Udieresis Acircumflex -50
KPX Udieresis Adieresis -50
KPX Udieresis Agrave -50
KPX Udieresis Amacron -50
KPX Udieresis Aogonek -50
KPX Udieresis Aring -50
KPX Udieresis Atilde -50
KPX Udieresis comma -30
KPX Udieresis period -30
KPX Ugrave A -50
KPX Ugrave Aacute -50
KPX Ugrave Abreve -50
KPX Ugrave Acircumflex -50
KPX Ugrave Adieresis -50
KPX Ugrave Agrave -50
KPX Ugrave Amacron -50
KPX Ugrave Aogonek -50
KPX Ugrave Aring -50
KPX Ugrave Atilde -50
KPX Ugrave comma -30
KPX Ugrave period -30
KPX Uhungarumlaut A -50
KPX Uhungarumlaut Aacute -50
KPX Uhungarumlaut Abreve -50
KPX Uhungarumlaut Acircumflex -50
KPX Uhungarumlaut Adieresis -50
KPX Uhungarumlaut Agrave -50
KPX Uhungarumlaut Amacron -50
KPX Uhungarumlaut Aogonek -50
KPX Uhungarumlaut Aring -50
KPX Uhungarumlaut Atilde -50
KPX Uhungarumlaut comma -30
KPX Uhungarumlaut period -30
KPX Umacron A -50
KPX Umacron Aacute -50
KPX Umacron Abreve -50
KPX Umacron Acircumflex -50
KPX Umacron Adieresis -50
KPX Umacron Agrave -50
KPX Umacron Amacron -50
KPX Umacron Aogonek -50
KPX Umacron Aring -50
KPX Umacron Atilde -50
KPX Umacron comma -30
KPX Umacron period -30
KPX Uogonek A -50
KPX Uogonek Aacute -50
KPX Uogonek Abreve -50
KPX Uogonek Acircumflex -50
KPX Uogonek Adieresis -50
KPX Uogonek Agrave -50
KPX Uogonek Amacron -50
KPX Uogonek Aogonek -50
KPX Uogonek Aring -50
KPX Uogonek Atilde -50
KPX Uogonek comma -30
KPX Uogonek period -30
KPX Uring A -50
KPX Uring Aacute -50
KPX Uring Abreve -50
KPX Uring Acircumflex -50
KPX Uring Adieresis -50
KPX Uring Agrave -50
KPX Uring Amacron -50
KPX Uring Aogonek -50
KPX Uring Aring -50
KPX Uring Atilde -50
KPX Uring comma -30
KPX Uring period -30
KPX V A -80
KPX V Aacute -80
KPX V Abreve -80
KPX V Acircumflex -80
KPX V Adieresis -80
KPX V Agrave -80
KPX V Amacron -80
KPX V Aogonek -80
KPX V Aring -80
KPX V Atilde -80
KPX V G -50
KPX V Gbreve -50
KPX V Gcommaaccent -50
KPX V O -50
KPX V Oacute -50
KPX V Ocircumflex -50
KPX V Odieresis -50
KPX V Ograve -50
KPX V Ohungarumlaut -50
KPX V Omacron -50
KPX V Oslash -50
KPX V Otilde -50
KPX V a -60
KPX V aacute -60
KPX V abreve -60
KPX V acircumflex -60
KPX V adieresis -60
KPX V agrave -60
KPX V amacron -60
KPX V aogonek -60
KPX V aring -60
KPX V atilde -60
KPX V colon -40
KPX V comma -120
KPX V e -50
KPX V eacute -50
KPX V ecaron -50
KPX V ecircumflex -50
KPX V edieresis -50
KPX V edotaccent -50
KPX V egrave -50
KPX V emacron -50
KPX V eogonek -50
KPX V hyphen -80
KPX V o -90
KPX V oacute -90
KPX V ocircumflex -90
KPX V odieresis -90
KPX V ograve -90
KPX V ohungarumlaut -90
KPX V omacron -90
KPX V oslash -90
KPX V otilde -90
KPX V period -120
KPX V semicolon -40
KPX V u -60
KPX V uacute -60
KPX V ucircumflex -60
KPX V udieresis -60
KPX V ugrave -60
KPX V uhungarumlaut -60
KPX V umacron -60
KPX V uogonek -60
KPX V uring -60
KPX W A -60
KPX W Aacute -60
KPX W Abreve -60
KPX W Acircumflex -60
KPX W Adieresis -60
KPX W Agrave -60
KPX W Amacron -60
KPX W Aogonek -60
KPX W Aring -60
KPX W Atilde -60
KPX W O -20
KPX W Oacute -20
KPX W Ocircumflex -20
KPX W Odieresis -20
KPX W Ograve -20
KPX W Ohungarumlaut -20
KPX W Omacron -20
KPX W Oslash -20
KPX W Otilde -20
KPX W a -40
KPX W aacute -40
KPX W abreve -40
KPX W acircumflex -40
KPX W adieresis -40
KPX W agrave -40
KPX W amacron -40
KPX W aogonek -40
KPX W aring -40
KPX W atilde -40
KPX W colon -10
KPX W comma -80
KPX W e -35
KPX W eacute -35
KPX W ecaron -35
KPX W ecircumflex -35
KPX W edieresis -35
KPX W edotaccent -35
KPX W egrave -35
KPX W emacron -35
KPX W eogonek -35
KPX W hyphen -40
KPX W o -60
KPX W oacute -60
KPX W ocircumflex -60
KPX W odieresis -60
KPX W ograve -60
KPX W ohungarumlaut -60
KPX W omacron -60
KPX W oslash -60
KPX W otilde -60
KPX W period -80
KPX W semicolon -10
KPX W u -45
KPX W uacute -45
KPX W ucircumflex -45
KPX W udieresis -45
KPX W ugrave -45
KPX W uhungarumlaut -45
KPX W umacron -45
KPX W uogonek -45
KPX W uring -45
KPX W y -20
KPX W yacute -20
KPX W ydieresis -20
KPX Y A -110
KPX Y Aacute -110
KPX Y Abreve -110
KPX Y Acircumflex -110
KPX Y Adieresis -110
KPX Y Agrave -110
KPX Y Amacron -110
KPX Y Aogonek -110
KPX Y Aring -110
KPX Y Atilde -110
KPX Y O -70
KPX Y Oacute -70
KPX Y Ocircumflex -70
KPX Y Odieresis -70
KPX Y Ograve -70
KPX Y Ohungarumlaut -70
KPX Y Omacron -70
KPX Y Oslash -70
KPX Y Otilde -70
KPX Y a -90
KPX Y aacute -90
KPX Y abreve -90
KPX Y acircumflex -90
KPX Y adieresis -90
KPX Y agrave -90
KPX Y amacron -90
KPX Y aogonek -90
KPX Y aring -90
KPX Y atilde -90
KPX Y colon -50
KPX Y comma -100
KPX Y e -80
KPX Y eacute -80
KPX Y ecaron -80
KPX Y ecircumflex -80
KPX Y edieresis -80
KPX Y edotaccent -80
KPX Y egrave -80
KPX Y emacron -80
KPX Y eogonek -80
KPX Y o -100
KPX Y oacute -100
KPX Y ocircumflex -100
KPX Y odieresis -100
KPX Y ograve -100
KPX Y ohungarumlaut -100
KPX Y omacron -100
KPX Y oslash -100
KPX Y otilde -100
KPX Y period -100
KPX Y semicolon -50
KPX Y u -100
KPX Y uacute -100
KPX Y ucircumflex -100
KPX Y udieresis -100
KPX Y ugrave -100
KPX Y uhungarumlaut -100
KPX Y umacron -100
KPX Y uogonek -100
KPX Y uring -100
KPX Yacute A -110
KPX Yacute Aacute -110
KPX Yacute Abreve -110
KPX Yacute Acircumflex -110
KPX Yacute Adieresis -110
KPX Yacute Agrave -110
KPX Yacute Amacron -110
KPX Yacute Aogonek -110
KPX Yacute Aring -110
KPX Yacute Atilde -110
KPX Yacute O -70
KPX Yacute Oacute -70
KPX Yacute Ocircumflex -70
KPX Yacute Odieresis -70
KPX Yacute Ograve -70
KPX Yacute Ohungarumlaut -70
KPX Yacute Omacron -70
KPX Yacute Oslash -70
KPX Yacute Otilde -70
KPX Yacute a -90
KPX Yacute aacute -90
KPX Yacute abreve -90
KPX Yacute acircumflex -90
KPX Yacute adieresis -90
KPX Yacute agrave -90
KPX Yacute amacron -90
KPX Yacute aogonek -90
KPX Yacute aring -90
KPX Yacute atilde -90
KPX Yacute colon -50
KPX Yacute comma -100
KPX Yacute e -80
KPX Yacute eacute -80
KPX Yacute ecaron -80
KPX Yacute ecircumflex -80
KPX Yacute edieresis -80
KPX Yacute edotaccent -80
KPX Yacute egrave -80
KPX Yacute emacron -80
KPX Yacute eogonek -80
KPX Yacute o -100
KPX Yacute oacute -100
KPX Yacute ocircumflex -100
KPX Yacute odieresis -100
KPX Yacute ograve -100
KPX Yacute ohungarumlaut -100
KPX Yacute omacron -100
KPX Yacute oslash -100
KPX Yacute otilde -100
KPX Yacute period -100
KPX Yacute semicolon -50
KPX Yacute u -100
KPX Yacute uacute -100
KPX Yacute ucircumflex -100
KPX Yacute udieresis -100
KPX Yacute ugrave -100
KPX Yacute uhungarumlaut -100
KPX Yacute umacron -100
KPX Yacute uogonek -100
KPX Yacute uring -100
KPX Ydieresis A -110
KPX Ydieresis Aacute -110
KPX Ydieresis Abreve -110
KPX Ydieresis Acircumflex -110
KPX Ydieresis Adieresis -110
KPX Ydieresis Agrave -110
KPX Ydieresis Amacron -110
KPX Ydieresis Aogonek -110
KPX Ydieresis Aring -110
KPX Ydieresis Atilde -110
KPX Ydieresis O -70
KPX Ydieresis Oacute -70
KPX Ydieresis Ocircumflex -70
KPX Ydieresis Odieresis -70
KPX Ydieresis Ograve -70
KPX Ydieresis Ohungarumlaut -70
KPX Ydieresis Omacron -70
KPX Ydieresis Oslash -70
KPX Ydieresis Otilde -70
KPX Ydieresis a -90
KPX Ydieresis aacute -90
KPX Ydieresis abreve -90
KPX Ydieresis acircumflex -90
KPX Ydieresis adieresis -90
KPX Ydieresis agrave -90
KPX Ydieresis amacron -90
KPX Ydieresis aogonek -90
KPX Ydieresis aring -90
KPX Ydieresis atilde -90
KPX Ydieresis colon -50
KPX Ydieresis comma -100
KPX Ydieresis e -80
KPX Ydieresis eacute -80
KPX Ydieresis ecaron -80
KPX Ydieresis ecircumflex -80
KPX Ydieresis edieresis -80
KPX Ydieresis edotaccent -80
KPX Ydieresis egrave -80
KPX Ydieresis emacron -80
KPX Ydieresis eogonek -80
KPX Ydieresis o -100
KPX Ydieresis oacute -100
KPX Ydieresis ocircumflex -100
KPX Ydieresis odieresis -100
KPX Ydieresis ograve -100
KPX Ydieresis ohungarumlaut -100
KPX Ydieresis omacron -100
KPX Ydieresis oslash -100
KPX Ydieresis otilde -100
KPX Ydieresis period -100
KPX Ydieresis semicolon -50
KPX Ydieresis u -100
KPX Ydieresis uacute -100
KPX Ydieresis ucircumflex -100
KPX Ydieresis udieresis -100
KPX Ydieresis ugrave -100
KPX Ydieresis uhungarumlaut -100
KPX Ydieresis umacron -100
KPX Ydieresis uogonek -100
KPX Ydieresis uring -100
KPX a g -10
KPX a gbreve -10
KPX a gcommaaccent -10
KPX a v -15
KPX a w -15
KPX a y -20
KPX a yacute -20
KPX a ydieresis -20
KPX aacute g -10
KPX aacute gbreve -10
KPX aacute gcommaaccent -10
KPX aacute v -15
KPX aacute w -15
KPX aacute y -20
KPX aacute yacute -20
KPX aacute ydieresis -20
KPX abreve g -10
KPX abreve gbreve -10
KPX abreve gcommaaccent -10
KPX abreve v -15
KPX abreve w -15
KPX abreve y -20
KPX abreve yacute -20
KPX abreve ydieresis -20
KPX acircumflex g -10
KPX acircumflex gbreve -10
KPX acircumflex gcommaaccent -10
KPX acircumflex v -15
KPX acircumflex w -15
KPX acircumflex y -20
KPX acircumflex yacute -20
KPX acircumflex ydieresis -20
KPX adieresis g -10
KPX adieresis gbreve -10
KPX adieresis gcommaaccent -10
KPX adieresis v -15
KPX adieresis w -15
KPX adieresis y -20
KPX adieresis yacute -20
KPX adieresis ydieresis -20
KPX agrave g -10
KPX agrave gbreve -10
KPX agrave gcommaaccent -10
KPX agrave v -15
KPX agrave w -15
KPX agrave y -20
KPX agrave yacute -20
KPX agrave ydieresis -20
KPX amacron g -10
KPX amacron gbreve -10
KPX amacron gcommaaccent -10
KPX amacron v -15
KPX amacron w -15
KPX amacron y -20
KPX amacron yacute -20
KPX amacron ydieresis -20
KPX aogonek g -10
KPX aogonek gbreve -10
KPX aogonek gcommaaccent -10
KPX aogonek v -15
KPX aogonek w -15
KPX aogonek y -20
KPX aogonek yacute -20
KPX aogonek ydieresis -20
KPX aring g -10
KPX aring gbreve -10
KPX aring gcommaaccent -10
KPX aring v -15
KPX aring w -15
KPX aring y -20
KPX aring yacute -20
KPX aring ydieresis -20
KPX atilde g -10
KPX atilde gbreve -10
KPX atilde gcommaaccent -10
KPX atilde v -15
KPX atilde w -15
KPX atilde y -20
KPX atilde yacute -20
KPX atilde ydieresis -20
KPX b l -10
KPX b lacute -10
KPX b lcommaaccent -10
KPX b lslash -10
KPX b u -20
KPX b uacute -20
KPX b ucircumflex -20
KPX b udieresis -20
KPX b ugrave -20
KPX b uhungarumlaut -20
KPX b umacron -20
KPX b uogonek -20
KPX b uring -20
KPX b v -20
KPX b y -20
KPX b yacute -20
KPX b ydieresis -20
KPX c h -10
KPX c k -20
KPX c kcommaaccent -20
KPX c l -20
KPX c lacute -20
KPX c lcommaaccent -20
KPX c lslash -20
KPX c y -10
KPX c yacute -10
KPX c ydieresis -10
KPX cacute h -10
KPX cacute k -20
KPX cacute kcommaaccent -20
KPX cacute l -20
KPX cacute lacute -20
KPX cacute lcommaaccent -20
KPX cacute lslash -20
KPX cacute y -10
KPX cacute yacute -10
KPX cacute ydieresis -10
KPX ccaron h -10
KPX ccaron k -20
KPX ccaron kcommaaccent -20
KPX ccaron l -20
KPX ccaron lacute -20
KPX ccaron lcommaaccent -20
KPX ccaron lslash -20
KPX ccaron y -10
KPX ccaron yacute -10
KPX ccaron ydieresis -10
KPX ccedilla h -10
KPX ccedilla k -20
KPX ccedilla kcommaaccent -20
KPX ccedilla l -20
KPX ccedilla lacute -20
KPX ccedilla lcommaaccent -20
KPX ccedilla lslash -20
KPX ccedilla y -10
KPX ccedilla yacute -10
KPX ccedilla ydieresis -10
KPX colon space -40
KPX comma quotedblright -120
KPX comma quoteright -120
KPX comma space -40
KPX d d -10
KPX d dcroat -10
KPX d v -15
KPX d w -15
KPX d y -15
KPX d yacute -15
KPX d ydieresis -15
KPX dcroat d -10
KPX dcroat dcroat -10
KPX dcroat v -15
KPX dcroat w -15
KPX dcroat y -15
KPX dcroat yacute -15
KPX dcroat ydieresis -15
KPX e comma 10
KPX e period 20
KPX e v -15
KPX e w -15
KPX e x -15
KPX e y -15
KPX e yacute -15
KPX e ydieresis -15
KPX eacute comma 10
KPX eacute period 20
KPX eacute v -15
KPX eacute w -15
KPX eacute x -15
KPX eacute y -15
KPX eacute yacute -15
KPX eacute ydieresis -15
KPX ecaron comma 10
KPX ecaron period 20
KPX ecaron v -15
KPX ecaron w -15
KPX ecaron x -15
KPX ecaron y -15
KPX ecaron yacute -15
KPX ecaron ydieresis -15
KPX ecircumflex comma 10
KPX ecircumflex period 20
KPX ecircumflex v -15
KPX ecircumflex w -15
KPX ecircumflex x -15
KPX ecircumflex y -15
KPX ecircumflex yacute -15
KPX ecircumflex ydieresis -15
KPX edieresis comma 10
KPX edieresis period 20
KPX edieresis v -15
KPX edieresis w -15
KPX edieresis x -15
KPX edieresis y -15
KPX edieresis yacute -15
KPX edieresis ydieresis -15
KPX edotaccent comma 10
KPX edotaccent period 20
KPX edotaccent v -15
KPX edotaccent w -15
KPX edotaccent x -15
KPX edotaccent y -15
KPX edotaccent yacute -15
KPX edotaccent ydieresis -15
KPX egrave comma 10
KPX egrave period 20
KPX egrave v -15
KPX egrave w -15
KPX egrave x -15
KPX egrave y -15
KPX egrave yacute -15
KPX egrave ydieresis -15
KPX emacron comma 10
KPX emacron period 20
KPX emacron v -15
KPX emacron w -15
KPX emacron x -15
KPX emacron y -15
KPX emacron yacute -15
KPX emacron ydieresis -15
KPX eogonek comma 10
KPX eogonek period 20
KPX eogonek v -15
KPX eogonek w -15
KPX eogonek x -15
KPX eogonek y -15
KPX eogonek yacute -15
KPX eogonek ydieresis -15
KPX f comma -10
KPX f e -10
KPX f eacute -10
KPX f ecaron -10
KPX f ecircumflex -10
KPX f edieresis -10
KPX f edotaccent -10
KPX f egrave -10
KPX f emacron -10
KPX f eogonek -10
KPX f o -20
KPX f oacute -20
KPX f ocircumflex -20
KPX f odieresis -20
KPX f ograve -20
KPX f ohungarumlaut -20
KPX f omacron -20
KPX f oslash -20
KPX f otilde -20
KPX f period -10
KPX f quotedblright 30
KPX f quoteright 30
KPX g e 10
KPX g eacute 10
KPX g ecaron 10
KPX g ecircumflex 10
KPX g edieresis 10
KPX g edotaccent 10
KPX g egrave 10
KPX g emacron 10
KPX g eogonek 10
KPX g g -10
KPX g gbreve -10
KPX g gcommaaccent -10
KPX gbreve e 10
KPX gbreve eacute 10
KPX gbreve ecaron 10
KPX gbreve ecircumflex 10
KPX gbreve edieresis 10
KPX gbreve edotaccent 10
KPX gbreve egrave 10
KPX gbreve emacron 10
KPX gbreve eogonek 10
KPX gbreve g -10
KPX gbreve gbreve -10
KPX gbreve gcommaaccent -10
KPX gcommaaccent e 10
KPX gcommaaccent eacute 10
KPX gcommaaccent ecaron 10
KPX gcommaaccent ecircumflex 10
KPX gcommaaccent edieresis 10
KPX gcommaaccent edotaccent 10
KPX gcommaaccent egrave 10
KPX gcommaaccent emacron 10
KPX gcommaaccent eogonek 10
KPX gcommaaccent g -10
KPX gcommaaccent gbreve -10
KPX gcommaaccent gcommaaccent -10
KPX h y -20
KPX h yacute -20
KPX h ydieresis -20
KPX k o -15
KPX k oacute -15
KPX k ocircumflex -15
KPX k odieresis -15
KPX k ograve -15
KPX k ohungarumlaut -15
KPX k omacron -15
KPX k oslash -15
KPX k otilde -15
KPX kcommaaccent o -15
KPX kcommaaccent oacute -15
KPX kcommaaccent ocircumflex -15
KPX kcommaaccent odieresis -15
KPX kcommaaccent ograve -15
KPX kcommaaccent ohungarumlaut -15
KPX kcommaaccent omacron -15
KPX kcommaaccent oslash -15
KPX kcommaaccent otilde -15
KPX l w -15
KPX l y -15
KPX l yacute -15
KPX l ydieresis -15
KPX lacute w -15
KPX lacute y -15
KPX lacute yacute -15
KPX lacute ydieresis -15
KPX lcommaaccent w -15
KPX lcommaaccent y -15
KPX lcommaaccent yacute -15
KPX lcommaaccent ydieresis -15
KPX lslash w -15
KPX lslash y -15
KPX lslash yacute -15
KPX lslash ydieresis -15
KPX m u -20
KPX m uacute -20
KPX m ucircumflex -20
KPX m udieresis -20
KPX m ugrave -20
KPX m uhungarumlaut -20
KPX m umacron -20
KPX m uogonek -20
KPX m uring -20
KPX m y -30
KPX m yacute -30
KPX m ydieresis -30
KPX n u -10
KPX n uacute -10
KPX n ucircumflex -10
KPX n udieresis -10
KPX n ugrave -10
KPX n uhungarumlaut -10
KPX n umacron -10
KPX n uogonek -10
KPX n uring -10
KPX n v -40
KPX n y -20
KPX n yacute -20
KPX n ydieresis -20
KPX nacute u -10
KPX nacute uacute -10
KPX nacute ucircumflex -10
KPX nacute udieresis -10
KPX nacute ugrave -10
KPX nacute uhungarumlaut -10
KPX nacute umacron -10
KPX nacute uogonek -10
KPX nacute uring -10
KPX nacute v -40
KPX nacute y -20
KPX nacute yacute -20
KPX nacute ydieresis -20
KPX ncaron u -10
KPX ncaron uacute -10
KPX ncaron ucircumflex -10
KPX ncaron udieresis -10
KPX ncaron ugrave -10
KPX ncaron uhungarumlaut -10
KPX ncaron umacron -10
KPX ncaron uogonek -10
KPX ncaron uring -10
KPX ncaron v -40
KPX ncaron y -20
KPX ncaron yacute -20
KPX ncaron ydieresis -20
KPX ncommaaccent u -10
KPX ncommaaccent uacute -10
KPX ncommaaccent ucircumflex -10
KPX ncommaaccent udieresis -10
KPX ncommaaccent ugrave -10
KPX ncommaaccent uhungarumlaut -10
KPX ncommaaccent umacron -10
KPX ncommaaccent uogonek -10
KPX ncommaaccent uring -10
KPX ncommaaccent v -40
KPX ncommaaccent y -20
KPX ncommaaccent yacute -20
KPX ncommaaccent ydieresis -20
KPX ntilde u -10
KPX ntilde uacute -10
KPX ntilde ucircumflex -10
KPX ntilde udieresis -10
KPX ntilde ugrave -10
KPX ntilde uhungarumlaut -10
KPX ntilde umacron -10
KPX ntilde uogonek -10
KPX ntilde uring -10
KPX ntilde v -40
KPX ntilde y -20
KPX ntilde yacute -20
KPX ntilde ydieresis -20
KPX o v -20
KPX o w -15
KPX o x -30
KPX o y -20
KPX o yacute -20
KPX o ydieresis -20
KPX oacute v -20
KPX oacute w -15
KPX oacute x -30
KPX oacute y -20
KPX oacute yacute -20
KPX oacute ydieresis -20
KPX ocircumflex v -20
KPX ocircumflex w -15
KPX ocircumflex x -30
KPX ocircumflex y -20
KPX ocircumflex yacute -20
KPX ocircumflex ydieresis -20
KPX odieresis v -20
KPX odieresis w -15
KPX odieresis x -30
KPX odieresis y -20
KPX odieresis yacute -20
KPX odieresis ydieresis -20
KPX ograve v -20
KPX ograve w -15
KPX ograve x -30
KPX ograve y -20
KPX ograve yacute -20
KPX ograve ydieresis -20
KPX ohungarumlaut v -20
KPX ohungarumlaut w -15
KPX ohungarumlaut x -30
KPX ohungarumlaut y -20
KPX ohungarumlaut yacute -20
KPX ohungarumlaut ydieresis -20
KPX omacron v -20
KPX omacron w -15
KPX omacron x -30
KPX omacron y -20
KPX omacron yacute -20
KPX omacron ydieresis -20
KPX oslash v -20
KPX oslash w -15
KPX oslash x -30
KPX oslash y -20
KPX oslash yacute -20
KPX oslash ydieresis -20
KPX otilde v -20
KPX otilde w -15
KPX otilde x -30
KPX otilde y -20
KPX otilde yacute -20
KPX otilde ydieresis -20
KPX p y -15
KPX p yacute -15
KPX p ydieresis -15
KPX period quotedblright -120
KPX period quoteright -120
KPX period space -40
KPX quotedblright space -80
KPX quoteleft quoteleft -46
KPX quoteright d -80
KPX quoteright dcroat -80
KPX quoteright l -20
KPX quoteright lacute -20
KPX quoteright lcommaaccent -20
KPX quoteright lslash -20
KPX quoteright quoteright -46
KPX quoteright r -40
KPX quoteright racute -40
KPX quoteright rcaron -40
KPX quoteright rcommaaccent -40
KPX quoteright s -60
KPX quoteright sacute -60
KPX quoteright scaron -60
KPX quoteright scedilla -60
KPX quoteright scommaaccent -60
KPX quoteright space -80
KPX quoteright v -20
KPX r c -20
KPX r cacute -20
KPX r ccaron -20
KPX r ccedilla -20
KPX r comma -60
KPX r d -20
KPX r dcroat -20
KPX r g -15
KPX r gbreve -15
KPX r gcommaaccent -15
KPX r hyphen -20
KPX r o -20
KPX r oacute -20
KPX r ocircumflex -20
KPX r odieresis -20
KPX r ograve -20
KPX r ohungarumlaut -20
KPX r omacron -20
KPX r oslash -20
KPX r otilde -20
KPX r period -60
KPX r q -20
KPX r s -15
KPX r sacute -15
KPX r scaron -15
KPX r scedilla -15
KPX r scommaaccent -15
KPX r t 20
KPX r tcommaaccent 20
KPX r v 10
KPX r y 10
KPX r yacute 10
KPX r ydieresis 10
KPX racute c -20
KPX racute cacute -20
KPX racute ccaron -20
KPX racute ccedilla -20
KPX racute comma -60
KPX racute d -20
KPX racute dcroat -20
KPX racute g -15
KPX racute gbreve -15
KPX racute gcommaaccent -15
KPX racute hyphen -20
KPX racute o -20
KPX racute oacute -20
KPX racute ocircumflex -20
KPX racute odieresis -20
KPX racute ograve -20
KPX racute ohungarumlaut -20
KPX racute omacron -20
KPX racute oslash -20
KPX racute otilde -20
KPX racute period -60
KPX racute q -20
KPX racute s -15
KPX racute sacute -15
KPX racute scaron -15
KPX racute scedilla -15
KPX racute scommaaccent -15
KPX racute t 20
KPX racute tcommaaccent 20
KPX racute v 10
KPX racute y 10
KPX racute yacute 10
KPX racute ydieresis 10
KPX rcaron c -20
KPX rcaron cacute -20
KPX rcaron ccaron -20
KPX rcaron ccedilla -20
KPX rcaron comma -60
KPX rcaron d -20
KPX rcaron dcroat -20
KPX rcaron g -15
KPX rcaron gbreve -15
KPX rcaron gcommaaccent -15
KPX rcaron hyphen -20
KPX rcaron o -20
KPX rcaron oacute -20
KPX rcaron ocircumflex -20
KPX rcaron odieresis -20
KPX rcaron ograve -20
KPX rcaron ohungarumlaut -20
KPX rcaron omacron -20
KPX rcaron oslash -20
KPX rcaron otilde -20
KPX rcaron period -60
KPX rcaron q -20
KPX rcaron s -15
KPX rcaron sacute -15
KPX rcaron scaron -15
KPX rcaron scedilla -15
KPX rcaron scommaaccent -15
KPX rcaron t 20
KPX rcaron tcommaaccent 20
KPX rcaron v 10
KPX rcaron y 10
KPX rcaron yacute 10
KPX rcaron ydieresis 10
KPX rcommaaccent c -20
KPX rcommaaccent cacute -20
KPX rcommaaccent ccaron -20
KPX rcommaaccent ccedilla -20
KPX rcommaaccent comma -60
KPX rcommaaccent d -20
KPX rcommaaccent dcroat -20
KPX rcommaaccent g -15
KPX rcommaaccent gbreve -15
KPX rcommaaccent gcommaaccent -15
KPX rcommaaccent hyphen -20
KPX rcommaaccent o -20
KPX rcommaaccent oacute -20
KPX rcommaaccent ocircumflex -20
KPX rcommaaccent odieresis -20
KPX rcommaaccent ograve -20
KPX rcommaaccent ohungarumlaut -20
KPX rcommaaccent omacron -20
KPX rcommaaccent oslash -20
KPX rcommaaccent otilde -20
KPX rcommaaccent period -60
KPX rcommaaccent q -20
KPX rcommaaccent s -15
KPX rcommaaccent sacute -15
KPX rcommaaccent scaron -15
KPX rcommaaccent scedilla -15
KPX rcommaaccent scommaaccent -15
KPX rcommaaccent t 20
KPX rcommaaccent tcommaaccent 20
KPX rcommaaccent v 10
KPX rcommaaccent y 10
KPX rcommaaccent yacute 10
KPX rcommaaccent ydieresis 10
KPX s w -15
KPX sacute w -15
KPX scaron w -15
KPX scedilla w -15
KPX scommaaccent w -15
KPX semicolon space -40
KPX space T -100
KPX space Tcaron -100
KPX space Tcommaaccent -100
KPX space V -80
KPX space W -80
KPX space Y -120
KPX space Yacute -120
KPX space Ydieresis -120
KPX space quotedblleft -80
KPX space quoteleft -60
KPX v a -20
KPX v aacute -20
KPX v abreve -20
KPX v acircumflex -20
KPX v adieresis -20
KPX v agrave -20
KPX v amacron -20
KPX v aogonek -20
KPX v aring -20
KPX v atilde -20
KPX v comma -80
KPX v o -30
KPX v oacute -30
KPX v ocircumflex -30
KPX v odieresis -30
KPX v ograve -30
KPX v ohungarumlaut -30
KPX v omacron -30
KPX v oslash -30
KPX v otilde -30
KPX v period -80
KPX w comma -40
KPX w o -20
KPX w oacute -20
KPX w ocircumflex -20
KPX w odieresis -20
KPX w ograve -20
KPX w ohungarumlaut -20
KPX w omacron -20
KPX w oslash -20
KPX w otilde -20
KPX w period -40
KPX x e -10
KPX x eacute -10
KPX x ecaron -10
KPX x ecircumflex -10
KPX x edieresis -10
KPX x edotaccent -10
KPX x egrave -10
KPX x emacron -10
KPX x eogonek -10
KPX y a -30
KPX y aacute -30
KPX y abreve -30
KPX y acircumflex -30
KPX y adieresis -30
KPX y agrave -30
KPX y amacron -30
KPX y aogonek -30
KPX y aring -30
KPX y atilde -30
KPX y comma -80
KPX y e -10
KPX y eacute -10
KPX y ecaron -10
KPX y ecircumflex -10
KPX y edieresis -10
KPX y edotaccent -10
KPX y egrave -10
KPX y emacron -10
KPX y eogonek -10
KPX y o -25
KPX y oacute -25
KPX y ocircumflex -25
KPX y odieresis -25
KPX y ograve -25
KPX y ohungarumlaut -25
KPX y omacron -25
KPX y oslash -25
KPX y otilde -25
KPX y period -80
KPX yacute a -30
KPX yacute aacute -30
KPX yacute abreve -30
KPX yacute acircumflex -30
KPX yacute adieresis -30
KPX yacute agrave -30
KPX yacute amacron -30
KPX yacute aogonek -30
KPX yacute aring -30
KPX yacute atilde -30
KPX yacute comma -80
KPX yacute e -10
KPX yacute eacute -10
KPX yacute ecaron -10
KPX yacute ecircumflex -10
KPX yacute edieresis -10
KPX yacute edotaccent -10
KPX yacute egrave -10
KPX yacute emacron -10
KPX yacute eogonek -10
KPX yacute o -25
KPX yacute oacute -25
KPX yacute ocircumflex -25
KPX yacute odieresis -25
KPX yacute ograve -25
KPX yacute ohungarumlaut -25
KPX yacute omacron -25
KPX yacute oslash -25
KPX yacute otilde -25
KPX yacute period -80
KPX ydieresis a -30
KPX ydieresis aacute -30
KPX ydieresis abreve -30
KPX ydieresis acircumflex -30
KPX ydieresis adieresis -30
KPX ydieresis agrave -30
KPX ydieresis amacron -30
KPX ydieresis aogonek -30
KPX ydieresis aring -30
KPX ydieresis atilde -30
KPX ydieresis comma -80
KPX ydieresis e -10
KPX ydieresis eacute -10
KPX ydieresis ecaron -10
KPX ydieresis ecircumflex -10
KPX ydieresis edieresis -10
KPX ydieresis edotaccent -10
KPX ydieresis egrave -10
KPX ydieresis emacron -10
KPX ydieresis eogonek -10
KPX ydieresis o -25
KPX ydieresis oacute -25
KPX ydieresis ocircumflex -25
KPX ydieresis odieresis -25
KPX ydieresis ograve -25
KPX ydieresis ohungarumlaut -25
KPX ydieresis omacron -25
KPX ydieresis oslash -25
KPX ydieresis otilde -25
KPX ydieresis period -80
KPX z e 10
KPX z eacute 10
KPX z ecaron 10
KPX z ecircumflex 10
KPX z edieresis 10
KPX z edotaccent 10
KPX z egrave 10
KPX z emacron 10
KPX z eogonek 10
KPX zacute e 10
KPX zacute eacute 10
KPX zacute ecaron 10
KPX zacute ecircumflex 10
KPX zacute edieresis 10
KPX zacute edotaccent 10
KPX zacute egrave 10
KPX zacute emacron 10
KPX zacute eogonek 10
KPX zcaron e 10
KPX zcaron eacute 10
KPX zcaron ecaron 10
KPX zcaron ecircumflex 10
KPX zcaron edieresis 10
KPX zcaron edotaccent 10
KPX zcaron egrave 10
KPX zcaron emacron 10
KPX zcaron eogonek 10
KPX zdotaccent e 10
KPX zdotaccent eacute 10
KPX zdotaccent ecaron 10
KPX zdotaccent ecircumflex 10
KPX zdotaccent edieresis 10
KPX zdotaccent edotaccent 10
KPX zdotaccent egrave 10
KPX zdotaccent emacron 10
KPX zdotaccent eogonek 10
EndKernPairs
EndKernData
EndFontMetrics"

let helvetica_oblique_afm = "StartFontMetrics 4.1
Comment Copyright (c) 1985, 1987, 1989, 1990, 1997 Adobe Systems Incorporated.  All Rights Reserved.
Comment Creation Date: Thu May  1 12:44:31 1997
Comment UniqueID 43055
Comment VMusage 14960 69346
FontName Helvetica-Oblique
FullName Helvetica Oblique
FamilyName Helvetica
Weight Medium
ItalicAngle -12
IsFixedPitch false
CharacterSet ExtendedRoman
FontBBox -170 -225 1116 931 
UnderlinePosition -100
UnderlineThickness 50
Version 002.000
Notice Copyright (c) 1985, 1987, 1989, 1990, 1997 Adobe Systems Incorporated.  All Rights Reserved.Helvetica is a trademark of Linotype-Hell AG and/or its subsidiaries.
EncodingScheme AdobeStandardEncoding
CapHeight 718
XHeight 523
Ascender 718
Descender -207
StdHW 76
StdVW 88
StartCharMetrics 315
C 32 ; WX 278 ; N space ; B 0 0 0 0 ;
C 33 ; WX 278 ; N exclam ; B 90 0 340 718 ;
C 34 ; WX 355 ; N quotedbl ; B 168 463 438 718 ;
C 35 ; WX 556 ; N numbersign ; B 73 0 631 688 ;
C 36 ; WX 556 ; N dollar ; B 69 -115 617 775 ;
C 37 ; WX 889 ; N percent ; B 147 -19 889 703 ;
C 38 ; WX 667 ; N ampersand ; B 77 -15 647 718 ;
C 39 ; WX 222 ; N quoteright ; B 151 463 310 718 ;
C 40 ; WX 333 ; N parenleft ; B 108 -207 454 733 ;
C 41 ; WX 333 ; N parenright ; B -9 -207 337 733 ;
C 42 ; WX 389 ; N asterisk ; B 165 431 475 718 ;
C 43 ; WX 584 ; N plus ; B 85 0 606 505 ;
C 44 ; WX 278 ; N comma ; B 56 -147 214 106 ;
C 45 ; WX 333 ; N hyphen ; B 93 232 357 322 ;
C 46 ; WX 278 ; N period ; B 87 0 214 106 ;
C 47 ; WX 278 ; N slash ; B -21 -19 452 737 ;
C 48 ; WX 556 ; N zero ; B 93 -19 608 703 ;
C 49 ; WX 556 ; N one ; B 207 0 508 703 ;
C 50 ; WX 556 ; N two ; B 26 0 617 703 ;
C 51 ; WX 556 ; N three ; B 75 -19 610 703 ;
C 52 ; WX 556 ; N four ; B 61 0 576 703 ;
C 53 ; WX 556 ; N five ; B 68 -19 621 688 ;
C 54 ; WX 556 ; N six ; B 91 -19 615 703 ;
C 55 ; WX 556 ; N seven ; B 137 0 669 688 ;
C 56 ; WX 556 ; N eight ; B 74 -19 607 703 ;
C 57 ; WX 556 ; N nine ; B 82 -19 609 703 ;
C 58 ; WX 278 ; N colon ; B 87 0 301 516 ;
C 59 ; WX 278 ; N semicolon ; B 56 -147 301 516 ;
C 60 ; WX 584 ; N less ; B 94 11 641 495 ;
C 61 ; WX 584 ; N equal ; B 63 115 628 390 ;
C 62 ; WX 584 ; N greater ; B 50 11 597 495 ;
C 63 ; WX 556 ; N question ; B 161 0 610 727 ;
C 64 ; WX 1015 ; N at ; B 215 -19 965 737 ;
C 65 ; WX 667 ; N A ; B 14 0 654 718 ;
C 66 ; WX 667 ; N B ; B 74 0 712 718 ;
C 67 ; WX 722 ; N C ; B 108 -19 782 737 ;
C 68 ; WX 722 ; N D ; B 81 0 764 718 ;
C 69 ; WX 667 ; N E ; B 86 0 762 718 ;
C 70 ; WX 611 ; N F ; B 86 0 736 718 ;
C 71 ; WX 778 ; N G ; B 111 -19 799 737 ;
C 72 ; WX 722 ; N H ; B 77 0 799 718 ;
C 73 ; WX 278 ; N I ; B 91 0 341 718 ;
C 74 ; WX 500 ; N J ; B 47 -19 581 718 ;
C 75 ; WX 667 ; N K ; B 76 0 808 718 ;
C 76 ; WX 556 ; N L ; B 76 0 555 718 ;
C 77 ; WX 833 ; N M ; B 73 0 914 718 ;
C 78 ; WX 722 ; N N ; B 76 0 799 718 ;
C 79 ; WX 778 ; N O ; B 105 -19 826 737 ;
C 80 ; WX 667 ; N P ; B 86 0 737 718 ;
C 81 ; WX 778 ; N Q ; B 105 -56 826 737 ;
C 82 ; WX 722 ; N R ; B 88 0 773 718 ;
C 83 ; WX 667 ; N S ; B 90 -19 713 737 ;
C 84 ; WX 611 ; N T ; B 148 0 750 718 ;
C 85 ; WX 722 ; N U ; B 123 -19 797 718 ;
C 86 ; WX 667 ; N V ; B 173 0 800 718 ;
C 87 ; WX 944 ; N W ; B 169 0 1081 718 ;
C 88 ; WX 667 ; N X ; B 19 0 790 718 ;
C 89 ; WX 667 ; N Y ; B 167 0 806 718 ;
C 90 ; WX 611 ; N Z ; B 23 0 741 718 ;
C 91 ; WX 278 ; N bracketleft ; B 21 -196 403 722 ;
C 92 ; WX 278 ; N backslash ; B 140 -19 291 737 ;
C 93 ; WX 278 ; N bracketright ; B -14 -196 368 722 ;
C 94 ; WX 469 ; N asciicircum ; B 42 264 539 688 ;
C 95 ; WX 556 ; N underscore ; B -27 -125 540 -75 ;
C 96 ; WX 222 ; N quoteleft ; B 165 470 323 725 ;
C 97 ; WX 556 ; N a ; B 61 -15 559 538 ;
C 98 ; WX 556 ; N b ; B 58 -15 584 718 ;
C 99 ; WX 500 ; N c ; B 74 -15 553 538 ;
C 100 ; WX 556 ; N d ; B 84 -15 652 718 ;
C 101 ; WX 556 ; N e ; B 84 -15 578 538 ;
C 102 ; WX 278 ; N f ; B 86 0 416 728 ; L i fi ; L l fl ;
C 103 ; WX 556 ; N g ; B 42 -220 610 538 ;
C 104 ; WX 556 ; N h ; B 65 0 573 718 ;
C 105 ; WX 222 ; N i ; B 67 0 308 718 ;
C 106 ; WX 222 ; N j ; B -60 -210 308 718 ;
C 107 ; WX 500 ; N k ; B 67 0 600 718 ;
C 108 ; WX 222 ; N l ; B 67 0 308 718 ;
C 109 ; WX 833 ; N m ; B 65 0 852 538 ;
C 110 ; WX 556 ; N n ; B 65 0 573 538 ;
C 111 ; WX 556 ; N o ; B 83 -14 585 538 ;
C 112 ; WX 556 ; N p ; B 14 -207 584 538 ;
C 113 ; WX 556 ; N q ; B 84 -207 605 538 ;
C 114 ; WX 333 ; N r ; B 77 0 446 538 ;
C 115 ; WX 500 ; N s ; B 63 -15 529 538 ;
C 116 ; WX 278 ; N t ; B 102 -7 368 669 ;
C 117 ; WX 556 ; N u ; B 94 -15 600 523 ;
C 118 ; WX 500 ; N v ; B 119 0 603 523 ;
C 119 ; WX 722 ; N w ; B 125 0 820 523 ;
C 120 ; WX 500 ; N x ; B 11 0 594 523 ;
C 121 ; WX 500 ; N y ; B 15 -214 600 523 ;
C 122 ; WX 500 ; N z ; B 31 0 571 523 ;
C 123 ; WX 334 ; N braceleft ; B 92 -196 445 722 ;
C 124 ; WX 260 ; N bar ; B 46 -225 332 775 ;
C 125 ; WX 334 ; N braceright ; B 0 -196 354 722 ;
C 126 ; WX 584 ; N asciitilde ; B 111 180 580 326 ;
C 161 ; WX 333 ; N exclamdown ; B 77 -195 326 523 ;
C 162 ; WX 556 ; N cent ; B 95 -115 584 623 ;
C 163 ; WX 556 ; N sterling ; B 49 -16 634 718 ;
C 164 ; WX 167 ; N fraction ; B -170 -19 482 703 ;
C 165 ; WX 556 ; N yen ; B 81 0 699 688 ;
C 166 ; WX 556 ; N florin ; B -52 -207 654 737 ;
C 167 ; WX 556 ; N section ; B 76 -191 584 737 ;
C 168 ; WX 556 ; N currency ; B 60 99 646 603 ;
C 169 ; WX 191 ; N quotesingle ; B 157 463 285 718 ;
C 170 ; WX 333 ; N quotedblleft ; B 138 470 461 725 ;
C 171 ; WX 556 ; N guillemotleft ; B 146 108 554 446 ;
C 172 ; WX 333 ; N guilsinglleft ; B 137 108 340 446 ;
C 173 ; WX 333 ; N guilsinglright ; B 111 108 314 446 ;
C 174 ; WX 500 ; N fi ; B 86 0 587 728 ;
C 175 ; WX 500 ; N fl ; B 86 0 585 728 ;
C 177 ; WX 556 ; N endash ; B 51 240 623 313 ;
C 178 ; WX 556 ; N dagger ; B 135 -159 622 718 ;
C 179 ; WX 556 ; N daggerdbl ; B 52 -159 623 718 ;
C 180 ; WX 278 ; N periodcentered ; B 129 190 257 315 ;
C 182 ; WX 537 ; N paragraph ; B 126 -173 650 718 ;
C 183 ; WX 350 ; N bullet ; B 91 202 413 517 ;
C 184 ; WX 222 ; N quotesinglbase ; B 21 -149 180 106 ;
C 185 ; WX 333 ; N quotedblbase ; B -6 -149 318 106 ;
C 186 ; WX 333 ; N quotedblright ; B 124 463 448 718 ;
C 187 ; WX 556 ; N guillemotright ; B 120 108 528 446 ;
C 188 ; WX 1000 ; N ellipsis ; B 115 0 908 106 ;
C 189 ; WX 1000 ; N perthousand ; B 88 -19 1029 703 ;
C 191 ; WX 611 ; N questiondown ; B 85 -201 534 525 ;
C 193 ; WX 333 ; N grave ; B 170 593 337 734 ;
C 194 ; WX 333 ; N acute ; B 248 593 475 734 ;
C 195 ; WX 333 ; N circumflex ; B 147 593 438 734 ;
C 196 ; WX 333 ; N tilde ; B 125 606 490 722 ;
C 197 ; WX 333 ; N macron ; B 143 627 468 684 ;
C 198 ; WX 333 ; N breve ; B 167 595 476 731 ;
C 199 ; WX 333 ; N dotaccent ; B 249 604 362 706 ;
C 200 ; WX 333 ; N dieresis ; B 168 604 443 706 ;
C 202 ; WX 333 ; N ring ; B 214 572 402 756 ;
C 203 ; WX 333 ; N cedilla ; B 2 -225 232 0 ;
C 205 ; WX 333 ; N hungarumlaut ; B 157 593 565 734 ;
C 206 ; WX 333 ; N ogonek ; B 43 -225 249 0 ;
C 207 ; WX 333 ; N caron ; B 177 593 468 734 ;
C 208 ; WX 1000 ; N emdash ; B 51 240 1067 313 ;
C 225 ; WX 1000 ; N AE ; B 8 0 1097 718 ;
C 227 ; WX 370 ; N ordfeminine ; B 127 405 449 737 ;
C 232 ; WX 556 ; N Lslash ; B 41 0 555 718 ;
C 233 ; WX 778 ; N Oslash ; B 43 -19 890 737 ;
C 234 ; WX 1000 ; N OE ; B 98 -19 1116 737 ;
C 235 ; WX 365 ; N ordmasculine ; B 141 405 468 737 ;
C 241 ; WX 889 ; N ae ; B 61 -15 909 538 ;
C 245 ; WX 278 ; N dotlessi ; B 95 0 294 523 ;
C 248 ; WX 222 ; N lslash ; B 41 0 347 718 ;
C 249 ; WX 611 ; N oslash ; B 29 -22 647 545 ;
C 250 ; WX 944 ; N oe ; B 83 -15 964 538 ;
C 251 ; WX 611 ; N germandbls ; B 67 -15 658 728 ;
C -1 ; WX 278 ; N Idieresis ; B 91 0 458 901 ;
C -1 ; WX 556 ; N eacute ; B 84 -15 587 734 ;
C -1 ; WX 556 ; N abreve ; B 61 -15 578 731 ;
C -1 ; WX 556 ; N uhungarumlaut ; B 94 -15 677 734 ;
C -1 ; WX 556 ; N ecaron ; B 84 -15 580 734 ;
C -1 ; WX 667 ; N Ydieresis ; B 167 0 806 901 ;
C -1 ; WX 584 ; N divide ; B 85 -19 606 524 ;
C -1 ; WX 667 ; N Yacute ; B 167 0 806 929 ;
C -1 ; WX 667 ; N Acircumflex ; B 14 0 654 929 ;
C -1 ; WX 556 ; N aacute ; B 61 -15 587 734 ;
C -1 ; WX 722 ; N Ucircumflex ; B 123 -19 797 929 ;
C -1 ; WX 500 ; N yacute ; B 15 -214 600 734 ;
C -1 ; WX 500 ; N scommaaccent ; B 63 -225 529 538 ;
C -1 ; WX 556 ; N ecircumflex ; B 84 -15 578 734 ;
C -1 ; WX 722 ; N Uring ; B 123 -19 797 931 ;
C -1 ; WX 722 ; N Udieresis ; B 123 -19 797 901 ;
C -1 ; WX 556 ; N aogonek ; B 61 -220 559 538 ;
C -1 ; WX 722 ; N Uacute ; B 123 -19 797 929 ;
C -1 ; WX 556 ; N uogonek ; B 94 -225 600 523 ;
C -1 ; WX 667 ; N Edieresis ; B 86 0 762 901 ;
C -1 ; WX 722 ; N Dcroat ; B 69 0 764 718 ;
C -1 ; WX 250 ; N commaaccent ; B 39 -225 172 -40 ;
C -1 ; WX 737 ; N copyright ; B 54 -19 837 737 ;
C -1 ; WX 667 ; N Emacron ; B 86 0 762 879 ;
C -1 ; WX 500 ; N ccaron ; B 74 -15 553 734 ;
C -1 ; WX 556 ; N aring ; B 61 -15 559 756 ;
C -1 ; WX 722 ; N Ncommaaccent ; B 76 -225 799 718 ;
C -1 ; WX 222 ; N lacute ; B 67 0 461 929 ;
C -1 ; WX 556 ; N agrave ; B 61 -15 559 734 ;
C -1 ; WX 611 ; N Tcommaaccent ; B 148 -225 750 718 ;
C -1 ; WX 722 ; N Cacute ; B 108 -19 782 929 ;
C -1 ; WX 556 ; N atilde ; B 61 -15 592 722 ;
C -1 ; WX 667 ; N Edotaccent ; B 86 0 762 901 ;
C -1 ; WX 500 ; N scaron ; B 63 -15 552 734 ;
C -1 ; WX 500 ; N scedilla ; B 63 -225 529 538 ;
C -1 ; WX 278 ; N iacute ; B 95 0 448 734 ;
C -1 ; WX 471 ; N lozenge ; B 88 0 540 728 ;
C -1 ; WX 722 ; N Rcaron ; B 88 0 773 929 ;
C -1 ; WX 778 ; N Gcommaaccent ; B 111 -225 799 737 ;
C -1 ; WX 556 ; N ucircumflex ; B 94 -15 600 734 ;
C -1 ; WX 556 ; N acircumflex ; B 61 -15 559 734 ;
C -1 ; WX 667 ; N Amacron ; B 14 0 677 879 ;
C -1 ; WX 333 ; N rcaron ; B 77 0 508 734 ;
C -1 ; WX 500 ; N ccedilla ; B 74 -225 553 538 ;
C -1 ; WX 611 ; N Zdotaccent ; B 23 0 741 901 ;
C -1 ; WX 667 ; N Thorn ; B 86 0 712 718 ;
C -1 ; WX 778 ; N Omacron ; B 105 -19 826 879 ;
C -1 ; WX 722 ; N Racute ; B 88 0 773 929 ;
C -1 ; WX 667 ; N Sacute ; B 90 -19 713 929 ;
C -1 ; WX 643 ; N dcaron ; B 84 -15 808 718 ;
C -1 ; WX 722 ; N Umacron ; B 123 -19 797 879 ;
C -1 ; WX 556 ; N uring ; B 94 -15 600 756 ;
C -1 ; WX 333 ; N threesuperior ; B 90 270 436 703 ;
C -1 ; WX 778 ; N Ograve ; B 105 -19 826 929 ;
C -1 ; WX 667 ; N Agrave ; B 14 0 654 929 ;
C -1 ; WX 667 ; N Abreve ; B 14 0 685 926 ;
C -1 ; WX 584 ; N multiply ; B 50 0 642 506 ;
C -1 ; WX 556 ; N uacute ; B 94 -15 600 734 ;
C -1 ; WX 611 ; N Tcaron ; B 148 0 750 929 ;
C -1 ; WX 476 ; N partialdiff ; B 41 -38 550 714 ;
C -1 ; WX 500 ; N ydieresis ; B 15 -214 600 706 ;
C -1 ; WX 722 ; N Nacute ; B 76 0 799 929 ;
C -1 ; WX 278 ; N icircumflex ; B 95 0 411 734 ;
C -1 ; WX 667 ; N Ecircumflex ; B 86 0 762 929 ;
C -1 ; WX 556 ; N adieresis ; B 61 -15 559 706 ;
C -1 ; WX 556 ; N edieresis ; B 84 -15 578 706 ;
C -1 ; WX 500 ; N cacute ; B 74 -15 559 734 ;
C -1 ; WX 556 ; N nacute ; B 65 0 587 734 ;
C -1 ; WX 556 ; N umacron ; B 94 -15 600 684 ;
C -1 ; WX 722 ; N Ncaron ; B 76 0 799 929 ;
C -1 ; WX 278 ; N Iacute ; B 91 0 489 929 ;
C -1 ; WX 584 ; N plusminus ; B 39 0 618 506 ;
C -1 ; WX 260 ; N brokenbar ; B 62 -150 316 700 ;
C -1 ; WX 737 ; N registered ; B 54 -19 837 737 ;
C -1 ; WX 778 ; N Gbreve ; B 111 -19 799 926 ;
C -1 ; WX 278 ; N Idotaccent ; B 91 0 377 901 ;
C -1 ; WX 600 ; N summation ; B 15 -10 671 706 ;
C -1 ; WX 667 ; N Egrave ; B 86 0 762 929 ;
C -1 ; WX 333 ; N racute ; B 77 0 475 734 ;
C -1 ; WX 556 ; N omacron ; B 83 -14 585 684 ;
C -1 ; WX 611 ; N Zacute ; B 23 0 741 929 ;
C -1 ; WX 611 ; N Zcaron ; B 23 0 741 929 ;
C -1 ; WX 549 ; N greaterequal ; B 26 0 620 674 ;
C -1 ; WX 722 ; N Eth ; B 69 0 764 718 ;
C -1 ; WX 722 ; N Ccedilla ; B 108 -225 782 737 ;
C -1 ; WX 222 ; N lcommaaccent ; B 25 -225 308 718 ;
C -1 ; WX 317 ; N tcaron ; B 102 -7 501 808 ;
C -1 ; WX 556 ; N eogonek ; B 84 -225 578 538 ;
C -1 ; WX 722 ; N Uogonek ; B 123 -225 797 718 ;
C -1 ; WX 667 ; N Aacute ; B 14 0 683 929 ;
C -1 ; WX 667 ; N Adieresis ; B 14 0 654 901 ;
C -1 ; WX 556 ; N egrave ; B 84 -15 578 734 ;
C -1 ; WX 500 ; N zacute ; B 31 0 571 734 ;
C -1 ; WX 222 ; N iogonek ; B -61 -225 308 718 ;
C -1 ; WX 778 ; N Oacute ; B 105 -19 826 929 ;
C -1 ; WX 556 ; N oacute ; B 83 -14 587 734 ;
C -1 ; WX 556 ; N amacron ; B 61 -15 580 684 ;
C -1 ; WX 500 ; N sacute ; B 63 -15 559 734 ;
C -1 ; WX 278 ; N idieresis ; B 95 0 416 706 ;
C -1 ; WX 778 ; N Ocircumflex ; B 105 -19 826 929 ;
C -1 ; WX 722 ; N Ugrave ; B 123 -19 797 929 ;
C -1 ; WX 612 ; N Delta ; B 6 0 608 688 ;
C -1 ; WX 556 ; N thorn ; B 14 -207 584 718 ;
C -1 ; WX 333 ; N twosuperior ; B 64 281 449 703 ;
C -1 ; WX 778 ; N Odieresis ; B 105 -19 826 901 ;
C -1 ; WX 556 ; N mu ; B 24 -207 600 523 ;
C -1 ; WX 278 ; N igrave ; B 95 0 310 734 ;
C -1 ; WX 556 ; N ohungarumlaut ; B 83 -14 677 734 ;
C -1 ; WX 667 ; N Eogonek ; B 86 -220 762 718 ;
C -1 ; WX 556 ; N dcroat ; B 84 -15 689 718 ;
C -1 ; WX 834 ; N threequarters ; B 130 -19 861 703 ;
C -1 ; WX 667 ; N Scedilla ; B 90 -225 713 737 ;
C -1 ; WX 299 ; N lcaron ; B 67 0 464 718 ;
C -1 ; WX 667 ; N Kcommaaccent ; B 76 -225 808 718 ;
C -1 ; WX 556 ; N Lacute ; B 76 0 555 929 ;
C -1 ; WX 1000 ; N trademark ; B 186 306 1056 718 ;
C -1 ; WX 556 ; N edotaccent ; B 84 -15 578 706 ;
C -1 ; WX 278 ; N Igrave ; B 91 0 351 929 ;
C -1 ; WX 278 ; N Imacron ; B 91 0 483 879 ;
C -1 ; WX 556 ; N Lcaron ; B 76 0 570 718 ;
C -1 ; WX 834 ; N onehalf ; B 114 -19 839 703 ;
C -1 ; WX 549 ; N lessequal ; B 26 0 666 674 ;
C -1 ; WX 556 ; N ocircumflex ; B 83 -14 585 734 ;
C -1 ; WX 556 ; N ntilde ; B 65 0 592 722 ;
C -1 ; WX 722 ; N Uhungarumlaut ; B 123 -19 801 929 ;
C -1 ; WX 667 ; N Eacute ; B 86 0 762 929 ;
C -1 ; WX 556 ; N emacron ; B 84 -15 580 684 ;
C -1 ; WX 556 ; N gbreve ; B 42 -220 610 731 ;
C -1 ; WX 834 ; N onequarter ; B 150 -19 802 703 ;
C -1 ; WX 667 ; N Scaron ; B 90 -19 713 929 ;
C -1 ; WX 667 ; N Scommaaccent ; B 90 -225 713 737 ;
C -1 ; WX 778 ; N Ohungarumlaut ; B 105 -19 829 929 ;
C -1 ; WX 400 ; N degree ; B 169 411 468 703 ;
C -1 ; WX 556 ; N ograve ; B 83 -14 585 734 ;
C -1 ; WX 722 ; N Ccaron ; B 108 -19 782 929 ;
C -1 ; WX 556 ; N ugrave ; B 94 -15 600 734 ;
C -1 ; WX 453 ; N radical ; B 79 -80 617 762 ;
C -1 ; WX 722 ; N Dcaron ; B 81 0 764 929 ;
C -1 ; WX 333 ; N rcommaaccent ; B 30 -225 446 538 ;
C -1 ; WX 722 ; N Ntilde ; B 76 0 799 917 ;
C -1 ; WX 556 ; N otilde ; B 83 -14 602 722 ;
C -1 ; WX 722 ; N Rcommaaccent ; B 88 -225 773 718 ;
C -1 ; WX 556 ; N Lcommaaccent ; B 76 -225 555 718 ;
C -1 ; WX 667 ; N Atilde ; B 14 0 699 917 ;
C -1 ; WX 667 ; N Aogonek ; B 14 -225 654 718 ;
C -1 ; WX 667 ; N Aring ; B 14 0 654 931 ;
C -1 ; WX 778 ; N Otilde ; B 105 -19 826 917 ;
C -1 ; WX 500 ; N zdotaccent ; B 31 0 571 706 ;
C -1 ; WX 667 ; N Ecaron ; B 86 0 762 929 ;
C -1 ; WX 278 ; N Iogonek ; B -33 -225 341 718 ;
C -1 ; WX 500 ; N kcommaaccent ; B 67 -225 600 718 ;
C -1 ; WX 584 ; N minus ; B 85 216 606 289 ;
C -1 ; WX 278 ; N Icircumflex ; B 91 0 452 929 ;
C -1 ; WX 556 ; N ncaron ; B 65 0 580 734 ;
C -1 ; WX 278 ; N tcommaaccent ; B 63 -225 368 669 ;
C -1 ; WX 584 ; N logicalnot ; B 106 108 628 390 ;
C -1 ; WX 556 ; N odieresis ; B 83 -14 585 706 ;
C -1 ; WX 556 ; N udieresis ; B 94 -15 600 706 ;
C -1 ; WX 549 ; N notequal ; B 34 -35 623 551 ;
C -1 ; WX 556 ; N gcommaaccent ; B 42 -220 610 822 ;
C -1 ; WX 556 ; N eth ; B 81 -15 617 737 ;
C -1 ; WX 500 ; N zcaron ; B 31 0 571 734 ;
C -1 ; WX 556 ; N ncommaaccent ; B 65 -225 573 538 ;
C -1 ; WX 333 ; N onesuperior ; B 166 281 371 703 ;
C -1 ; WX 278 ; N imacron ; B 95 0 417 684 ;
C -1 ; WX 556 ; N Euro ; B 0 0 0 0 ;
EndCharMetrics
StartKernData
StartKernPairs 2705
KPX A C -30
KPX A Cacute -30
KPX A Ccaron -30
KPX A Ccedilla -30
KPX A G -30
KPX A Gbreve -30
KPX A Gcommaaccent -30
KPX A O -30
KPX A Oacute -30
KPX A Ocircumflex -30
KPX A Odieresis -30
KPX A Ograve -30
KPX A Ohungarumlaut -30
KPX A Omacron -30
KPX A Oslash -30
KPX A Otilde -30
KPX A Q -30
KPX A T -120
KPX A Tcaron -120
KPX A Tcommaaccent -120
KPX A U -50
KPX A Uacute -50
KPX A Ucircumflex -50
KPX A Udieresis -50
KPX A Ugrave -50
KPX A Uhungarumlaut -50
KPX A Umacron -50
KPX A Uogonek -50
KPX A Uring -50
KPX A V -70
KPX A W -50
KPX A Y -100
KPX A Yacute -100
KPX A Ydieresis -100
KPX A u -30
KPX A uacute -30
KPX A ucircumflex -30
KPX A udieresis -30
KPX A ugrave -30
KPX A uhungarumlaut -30
KPX A umacron -30
KPX A uogonek -30
KPX A uring -30
KPX A v -40
KPX A w -40
KPX A y -40
KPX A yacute -40
KPX A ydieresis -40
KPX Aacute C -30
KPX Aacute Cacute -30
KPX Aacute Ccaron -30
KPX Aacute Ccedilla -30
KPX Aacute G -30
KPX Aacute Gbreve -30
KPX Aacute Gcommaaccent -30
KPX Aacute O -30
KPX Aacute Oacute -30
KPX Aacute Ocircumflex -30
KPX Aacute Odieresis -30
KPX Aacute Ograve -30
KPX Aacute Ohungarumlaut -30
KPX Aacute Omacron -30
KPX Aacute Oslash -30
KPX Aacute Otilde -30
KPX Aacute Q -30
KPX Aacute T -120
KPX Aacute Tcaron -120
KPX Aacute Tcommaaccent -120
KPX Aacute U -50
KPX Aacute Uacute -50
KPX Aacute Ucircumflex -50
KPX Aacute Udieresis -50
KPX Aacute Ugrave -50
KPX Aacute Uhungarumlaut -50
KPX Aacute Umacron -50
KPX Aacute Uogonek -50
KPX Aacute Uring -50
KPX Aacute V -70
KPX Aacute W -50
KPX Aacute Y -100
KPX Aacute Yacute -100
KPX Aacute Ydieresis -100
KPX Aacute u -30
KPX Aacute uacute -30
KPX Aacute ucircumflex -30
KPX Aacute udieresis -30
KPX Aacute ugrave -30
KPX Aacute uhungarumlaut -30
KPX Aacute umacron -30
KPX Aacute uogonek -30
KPX Aacute uring -30
KPX Aacute v -40
KPX Aacute w -40
KPX Aacute y -40
KPX Aacute yacute -40
KPX Aacute ydieresis -40
KPX Abreve C -30
KPX Abreve Cacute -30
KPX Abreve Ccaron -30
KPX Abreve Ccedilla -30
KPX Abreve G -30
KPX Abreve Gbreve -30
KPX Abreve Gcommaaccent -30
KPX Abreve O -30
KPX Abreve Oacute -30
KPX Abreve Ocircumflex -30
KPX Abreve Odieresis -30
KPX Abreve Ograve -30
KPX Abreve Ohungarumlaut -30
KPX Abreve Omacron -30
KPX Abreve Oslash -30
KPX Abreve Otilde -30
KPX Abreve Q -30
KPX Abreve T -120
KPX Abreve Tcaron -120
KPX Abreve Tcommaaccent -120
KPX Abreve U -50
KPX Abreve Uacute -50
KPX Abreve Ucircumflex -50
KPX Abreve Udieresis -50
KPX Abreve Ugrave -50
KPX Abreve Uhungarumlaut -50
KPX Abreve Umacron -50
KPX Abreve Uogonek -50
KPX Abreve Uring -50
KPX Abreve V -70
KPX Abreve W -50
KPX Abreve Y -100
KPX Abreve Yacute -100
KPX Abreve Ydieresis -100
KPX Abreve u -30
KPX Abreve uacute -30
KPX Abreve ucircumflex -30
KPX Abreve udieresis -30
KPX Abreve ugrave -30
KPX Abreve uhungarumlaut -30
KPX Abreve umacron -30
KPX Abreve uogonek -30
KPX Abreve uring -30
KPX Abreve v -40
KPX Abreve w -40
KPX Abreve y -40
KPX Abreve yacute -40
KPX Abreve ydieresis -40
KPX Acircumflex C -30
KPX Acircumflex Cacute -30
KPX Acircumflex Ccaron -30
KPX Acircumflex Ccedilla -30
KPX Acircumflex G -30
KPX Acircumflex Gbreve -30
KPX Acircumflex Gcommaaccent -30
KPX Acircumflex O -30
KPX Acircumflex Oacute -30
KPX Acircumflex Ocircumflex -30
KPX Acircumflex Odieresis -30
KPX Acircumflex Ograve -30
KPX Acircumflex Ohungarumlaut -30
KPX Acircumflex Omacron -30
KPX Acircumflex Oslash -30
KPX Acircumflex Otilde -30
KPX Acircumflex Q -30
KPX Acircumflex T -120
KPX Acircumflex Tcaron -120
KPX Acircumflex Tcommaaccent -120
KPX Acircumflex U -50
KPX Acircumflex Uacute -50
KPX Acircumflex Ucircumflex -50
KPX Acircumflex Udieresis -50
KPX Acircumflex Ugrave -50
KPX Acircumflex Uhungarumlaut -50
KPX Acircumflex Umacron -50
KPX Acircumflex Uogonek -50
KPX Acircumflex Uring -50
KPX Acircumflex V -70
KPX Acircumflex W -50
KPX Acircumflex Y -100
KPX Acircumflex Yacute -100
KPX Acircumflex Ydieresis -100
KPX Acircumflex u -30
KPX Acircumflex uacute -30
KPX Acircumflex ucircumflex -30
KPX Acircumflex udieresis -30
KPX Acircumflex ugrave -30
KPX Acircumflex uhungarumlaut -30
KPX Acircumflex umacron -30
KPX Acircumflex uogonek -30
KPX Acircumflex uring -30
KPX Acircumflex v -40
KPX Acircumflex w -40
KPX Acircumflex y -40
KPX Acircumflex yacute -40
KPX Acircumflex ydieresis -40
KPX Adieresis C -30
KPX Adieresis Cacute -30
KPX Adieresis Ccaron -30
KPX Adieresis Ccedilla -30
KPX Adieresis G -30
KPX Adieresis Gbreve -30
KPX Adieresis Gcommaaccent -30
KPX Adieresis O -30
KPX Adieresis Oacute -30
KPX Adieresis Ocircumflex -30
KPX Adieresis Odieresis -30
KPX Adieresis Ograve -30
KPX Adieresis Ohungarumlaut -30
KPX Adieresis Omacron -30
KPX Adieresis Oslash -30
KPX Adieresis Otilde -30
KPX Adieresis Q -30
KPX Adieresis T -120
KPX Adieresis Tcaron -120
KPX Adieresis Tcommaaccent -120
KPX Adieresis U -50
KPX Adieresis Uacute -50
KPX Adieresis Ucircumflex -50
KPX Adieresis Udieresis -50
KPX Adieresis Ugrave -50
KPX Adieresis Uhungarumlaut -50
KPX Adieresis Umacron -50
KPX Adieresis Uogonek -50
KPX Adieresis Uring -50
KPX Adieresis V -70
KPX Adieresis W -50
KPX Adieresis Y -100
KPX Adieresis Yacute -100
KPX Adieresis Ydieresis -100
KPX Adieresis u -30
KPX Adieresis uacute -30
KPX Adieresis ucircumflex -30
KPX Adieresis udieresis -30
KPX Adieresis ugrave -30
KPX Adieresis uhungarumlaut -30
KPX Adieresis umacron -30
KPX Adieresis uogonek -30
KPX Adieresis uring -30
KPX Adieresis v -40
KPX Adieresis w -40
KPX Adieresis y -40
KPX Adieresis yacute -40
KPX Adieresis ydieresis -40
KPX Agrave C -30
KPX Agrave Cacute -30
KPX Agrave Ccaron -30
KPX Agrave Ccedilla -30
KPX Agrave G -30
KPX Agrave Gbreve -30
KPX Agrave Gcommaaccent -30
KPX Agrave O -30
KPX Agrave Oacute -30
KPX Agrave Ocircumflex -30
KPX Agrave Odieresis -30
KPX Agrave Ograve -30
KPX Agrave Ohungarumlaut -30
KPX Agrave Omacron -30
KPX Agrave Oslash -30
KPX Agrave Otilde -30
KPX Agrave Q -30
KPX Agrave T -120
KPX Agrave Tcaron -120
KPX Agrave Tcommaaccent -120
KPX Agrave U -50
KPX Agrave Uacute -50
KPX Agrave Ucircumflex -50
KPX Agrave Udieresis -50
KPX Agrave Ugrave -50
KPX Agrave Uhungarumlaut -50
KPX Agrave Umacron -50
KPX Agrave Uogonek -50
KPX Agrave Uring -50
KPX Agrave V -70
KPX Agrave W -50
KPX Agrave Y -100
KPX Agrave Yacute -100
KPX Agrave Ydieresis -100
KPX Agrave u -30
KPX Agrave uacute -30
KPX Agrave ucircumflex -30
KPX Agrave udieresis -30
KPX Agrave ugrave -30
KPX Agrave uhungarumlaut -30
KPX Agrave umacron -30
KPX Agrave uogonek -30
KPX Agrave uring -30
KPX Agrave v -40
KPX Agrave w -40
KPX Agrave y -40
KPX Agrave yacute -40
KPX Agrave ydieresis -40
KPX Amacron C -30
KPX Amacron Cacute -30
KPX Amacron Ccaron -30
KPX Amacron Ccedilla -30
KPX Amacron G -30
KPX Amacron Gbreve -30
KPX Amacron Gcommaaccent -30
KPX Amacron O -30
KPX Amacron Oacute -30
KPX Amacron Ocircumflex -30
KPX Amacron Odieresis -30
KPX Amacron Ograve -30
KPX Amacron Ohungarumlaut -30
KPX Amacron Omacron -30
KPX Amacron Oslash -30
KPX Amacron Otilde -30
KPX Amacron Q -30
KPX Amacron T -120
KPX Amacron Tcaron -120
KPX Amacron Tcommaaccent -120
KPX Amacron U -50
KPX Amacron Uacute -50
KPX Amacron Ucircumflex -50
KPX Amacron Udieresis -50
KPX Amacron Ugrave -50
KPX Amacron Uhungarumlaut -50
KPX Amacron Umacron -50
KPX Amacron Uogonek -50
KPX Amacron Uring -50
KPX Amacron V -70
KPX Amacron W -50
KPX Amacron Y -100
KPX Amacron Yacute -100
KPX Amacron Ydieresis -100
KPX Amacron u -30
KPX Amacron uacute -30
KPX Amacron ucircumflex -30
KPX Amacron udieresis -30
KPX Amacron ugrave -30
KPX Amacron uhungarumlaut -30
KPX Amacron umacron -30
KPX Amacron uogonek -30
KPX Amacron uring -30
KPX Amacron v -40
KPX Amacron w -40
KPX Amacron y -40
KPX Amacron yacute -40
KPX Amacron ydieresis -40
KPX Aogonek C -30
KPX Aogonek Cacute -30
KPX Aogonek Ccaron -30
KPX Aogonek Ccedilla -30
KPX Aogonek G -30
KPX Aogonek Gbreve -30
KPX Aogonek Gcommaaccent -30
KPX Aogonek O -30
KPX Aogonek Oacute -30
KPX Aogonek Ocircumflex -30
KPX Aogonek Odieresis -30
KPX Aogonek Ograve -30
KPX Aogonek Ohungarumlaut -30
KPX Aogonek Omacron -30
KPX Aogonek Oslash -30
KPX Aogonek Otilde -30
KPX Aogonek Q -30
KPX Aogonek T -120
KPX Aogonek Tcaron -120
KPX Aogonek Tcommaaccent -120
KPX Aogonek U -50
KPX Aogonek Uacute -50
KPX Aogonek Ucircumflex -50
KPX Aogonek Udieresis -50
KPX Aogonek Ugrave -50
KPX Aogonek Uhungarumlaut -50
KPX Aogonek Umacron -50
KPX Aogonek Uogonek -50
KPX Aogonek Uring -50
KPX Aogonek V -70
KPX Aogonek W -50
KPX Aogonek Y -100
KPX Aogonek Yacute -100
KPX Aogonek Ydieresis -100
KPX Aogonek u -30
KPX Aogonek uacute -30
KPX Aogonek ucircumflex -30
KPX Aogonek udieresis -30
KPX Aogonek ugrave -30
KPX Aogonek uhungarumlaut -30
KPX Aogonek umacron -30
KPX Aogonek uogonek -30
KPX Aogonek uring -30
KPX Aogonek v -40
KPX Aogonek w -40
KPX Aogonek y -40
KPX Aogonek yacute -40
KPX Aogonek ydieresis -40
KPX Aring C -30
KPX Aring Cacute -30
KPX Aring Ccaron -30
KPX Aring Ccedilla -30
KPX Aring G -30
KPX Aring Gbreve -30
KPX Aring Gcommaaccent -30
KPX Aring O -30
KPX Aring Oacute -30
KPX Aring Ocircumflex -30
KPX Aring Odieresis -30
KPX Aring Ograve -30
KPX Aring Ohungarumlaut -30
KPX Aring Omacron -30
KPX Aring Oslash -30
KPX Aring Otilde -30
KPX Aring Q -30
KPX Aring T -120
KPX Aring Tcaron -120
KPX Aring Tcommaaccent -120
KPX Aring U -50
KPX Aring Uacute -50
KPX Aring Ucircumflex -50
KPX Aring Udieresis -50
KPX Aring Ugrave -50
KPX Aring Uhungarumlaut -50
KPX Aring Umacron -50
KPX Aring Uogonek -50
KPX Aring Uring -50
KPX Aring V -70
KPX Aring W -50
KPX Aring Y -100
KPX Aring Yacute -100
KPX Aring Ydieresis -100
KPX Aring u -30
KPX Aring uacute -30
KPX Aring ucircumflex -30
KPX Aring udieresis -30
KPX Aring ugrave -30
KPX Aring uhungarumlaut -30
KPX Aring umacron -30
KPX Aring uogonek -30
KPX Aring uring -30
KPX Aring v -40
KPX Aring w -40
KPX Aring y -40
KPX Aring yacute -40
KPX Aring ydieresis -40
KPX Atilde C -30
KPX Atilde Cacute -30
KPX Atilde Ccaron -30
KPX Atilde Ccedilla -30
KPX Atilde G -30
KPX Atilde Gbreve -30
KPX Atilde Gcommaaccent -30
KPX Atilde O -30
KPX Atilde Oacute -30
KPX Atilde Ocircumflex -30
KPX Atilde Odieresis -30
KPX Atilde Ograve -30
KPX Atilde Ohungarumlaut -30
KPX Atilde Omacron -30
KPX Atilde Oslash -30
KPX Atilde Otilde -30
KPX Atilde Q -30
KPX Atilde T -120
KPX Atilde Tcaron -120
KPX Atilde Tcommaaccent -120
KPX Atilde U -50
KPX Atilde Uacute -50
KPX Atilde Ucircumflex -50
KPX Atilde Udieresis -50
KPX Atilde Ugrave -50
KPX Atilde Uhungarumlaut -50
KPX Atilde Umacron -50
KPX Atilde Uogonek -50
KPX Atilde Uring -50
KPX Atilde V -70
KPX Atilde W -50
KPX Atilde Y -100
KPX Atilde Yacute -100
KPX Atilde Ydieresis -100
KPX Atilde u -30
KPX Atilde uacute -30
KPX Atilde ucircumflex -30
KPX Atilde udieresis -30
KPX Atilde ugrave -30
KPX Atilde uhungarumlaut -30
KPX Atilde umacron -30
KPX Atilde uogonek -30
KPX Atilde uring -30
KPX Atilde v -40
KPX Atilde w -40
KPX Atilde y -40
KPX Atilde yacute -40
KPX Atilde ydieresis -40
KPX B U -10
KPX B Uacute -10
KPX B Ucircumflex -10
KPX B Udieresis -10
KPX B Ugrave -10
KPX B Uhungarumlaut -10
KPX B Umacron -10
KPX B Uogonek -10
KPX B Uring -10
KPX B comma -20
KPX B period -20
KPX C comma -30
KPX C period -30
KPX Cacute comma -30
KPX Cacute period -30
KPX Ccaron comma -30
KPX Ccaron period -30
KPX Ccedilla comma -30
KPX Ccedilla period -30
KPX D A -40
KPX D Aacute -40
KPX D Abreve -40
KPX D Acircumflex -40
KPX D Adieresis -40
KPX D Agrave -40
KPX D Amacron -40
KPX D Aogonek -40
KPX D Aring -40
KPX D Atilde -40
KPX D V -70
KPX D W -40
KPX D Y -90
KPX D Yacute -90
KPX D Ydieresis -90
KPX D comma -70
KPX D period -70
KPX Dcaron A -40
KPX Dcaron Aacute -40
KPX Dcaron Abreve -40
KPX Dcaron Acircumflex -40
KPX Dcaron Adieresis -40
KPX Dcaron Agrave -40
KPX Dcaron Amacron -40
KPX Dcaron Aogonek -40
KPX Dcaron Aring -40
KPX Dcaron Atilde -40
KPX Dcaron V -70
KPX Dcaron W -40
KPX Dcaron Y -90
KPX Dcaron Yacute -90
KPX Dcaron Ydieresis -90
KPX Dcaron comma -70
KPX Dcaron period -70
KPX Dcroat A -40
KPX Dcroat Aacute -40
KPX Dcroat Abreve -40
KPX Dcroat Acircumflex -40
KPX Dcroat Adieresis -40
KPX Dcroat Agrave -40
KPX Dcroat Amacron -40
KPX Dcroat Aogonek -40
KPX Dcroat Aring -40
KPX Dcroat Atilde -40
KPX Dcroat V -70
KPX Dcroat W -40
KPX Dcroat Y -90
KPX Dcroat Yacute -90
KPX Dcroat Ydieresis -90
KPX Dcroat comma -70
KPX Dcroat period -70
KPX F A -80
KPX F Aacute -80
KPX F Abreve -80
KPX F Acircumflex -80
KPX F Adieresis -80
KPX F Agrave -80
KPX F Amacron -80
KPX F Aogonek -80
KPX F Aring -80
KPX F Atilde -80
KPX F a -50
KPX F aacute -50
KPX F abreve -50
KPX F acircumflex -50
KPX F adieresis -50
KPX F agrave -50
KPX F amacron -50
KPX F aogonek -50
KPX F aring -50
KPX F atilde -50
KPX F comma -150
KPX F e -30
KPX F eacute -30
KPX F ecaron -30
KPX F ecircumflex -30
KPX F edieresis -30
KPX F edotaccent -30
KPX F egrave -30
KPX F emacron -30
KPX F eogonek -30
KPX F o -30
KPX F oacute -30
KPX F ocircumflex -30
KPX F odieresis -30
KPX F ograve -30
KPX F ohungarumlaut -30
KPX F omacron -30
KPX F oslash -30
KPX F otilde -30
KPX F period -150
KPX F r -45
KPX F racute -45
KPX F rcaron -45
KPX F rcommaaccent -45
KPX J A -20
KPX J Aacute -20
KPX J Abreve -20
KPX J Acircumflex -20
KPX J Adieresis -20
KPX J Agrave -20
KPX J Amacron -20
KPX J Aogonek -20
KPX J Aring -20
KPX J Atilde -20
KPX J a -20
KPX J aacute -20
KPX J abreve -20
KPX J acircumflex -20
KPX J adieresis -20
KPX J agrave -20
KPX J amacron -20
KPX J aogonek -20
KPX J aring -20
KPX J atilde -20
KPX J comma -30
KPX J period -30
KPX J u -20
KPX J uacute -20
KPX J ucircumflex -20
KPX J udieresis -20
KPX J ugrave -20
KPX J uhungarumlaut -20
KPX J umacron -20
KPX J uogonek -20
KPX J uring -20
KPX K O -50
KPX K Oacute -50
KPX K Ocircumflex -50
KPX K Odieresis -50
KPX K Ograve -50
KPX K Ohungarumlaut -50
KPX K Omacron -50
KPX K Oslash -50
KPX K Otilde -50
KPX K e -40
KPX K eacute -40
KPX K ecaron -40
KPX K ecircumflex -40
KPX K edieresis -40
KPX K edotaccent -40
KPX K egrave -40
KPX K emacron -40
KPX K eogonek -40
KPX K o -40
KPX K oacute -40
KPX K ocircumflex -40
KPX K odieresis -40
KPX K ograve -40
KPX K ohungarumlaut -40
KPX K omacron -40
KPX K oslash -40
KPX K otilde -40
KPX K u -30
KPX K uacute -30
KPX K ucircumflex -30
KPX K udieresis -30
KPX K ugrave -30
KPX K uhungarumlaut -30
KPX K umacron -30
KPX K uogonek -30
KPX K uring -30
KPX K y -50
KPX K yacute -50
KPX K ydieresis -50
KPX Kcommaaccent O -50
KPX Kcommaaccent Oacute -50
KPX Kcommaaccent Ocircumflex -50
KPX Kcommaaccent Odieresis -50
KPX Kcommaaccent Ograve -50
KPX Kcommaaccent Ohungarumlaut -50
KPX Kcommaaccent Omacron -50
KPX Kcommaaccent Oslash -50
KPX Kcommaaccent Otilde -50
KPX Kcommaaccent e -40
KPX Kcommaaccent eacute -40
KPX Kcommaaccent ecaron -40
KPX Kcommaaccent ecircumflex -40
KPX Kcommaaccent edieresis -40
KPX Kcommaaccent edotaccent -40
KPX Kcommaaccent egrave -40
KPX Kcommaaccent emacron -40
KPX Kcommaaccent eogonek -40
KPX Kcommaaccent o -40
KPX Kcommaaccent oacute -40
KPX Kcommaaccent ocircumflex -40
KPX Kcommaaccent odieresis -40
KPX Kcommaaccent ograve -40
KPX Kcommaaccent ohungarumlaut -40
KPX Kcommaaccent omacron -40
KPX Kcommaaccent oslash -40
KPX Kcommaaccent otilde -40
KPX Kcommaaccent u -30
KPX Kcommaaccent uacute -30
KPX Kcommaaccent ucircumflex -30
KPX Kcommaaccent udieresis -30
KPX Kcommaaccent ugrave -30
KPX Kcommaaccent uhungarumlaut -30
KPX Kcommaaccent umacron -30
KPX Kcommaaccent uogonek -30
KPX Kcommaaccent uring -30
KPX Kcommaaccent y -50
KPX Kcommaaccent yacute -50
KPX Kcommaaccent ydieresis -50
KPX L T -110
KPX L Tcaron -110
KPX L Tcommaaccent -110
KPX L V -110
KPX L W -70
KPX L Y -140
KPX L Yacute -140
KPX L Ydieresis -140
KPX L quotedblright -140
KPX L quoteright -160
KPX L y -30
KPX L yacute -30
KPX L ydieresis -30
KPX Lacute T -110
KPX Lacute Tcaron -110
KPX Lacute Tcommaaccent -110
KPX Lacute V -110
KPX Lacute W -70
KPX Lacute Y -140
KPX Lacute Yacute -140
KPX Lacute Ydieresis -140
KPX Lacute quotedblright -140
KPX Lacute quoteright -160
KPX Lacute y -30
KPX Lacute yacute -30
KPX Lacute ydieresis -30
KPX Lcaron T -110
KPX Lcaron Tcaron -110
KPX Lcaron Tcommaaccent -110
KPX Lcaron V -110
KPX Lcaron W -70
KPX Lcaron Y -140
KPX Lcaron Yacute -140
KPX Lcaron Ydieresis -140
KPX Lcaron quotedblright -140
KPX Lcaron quoteright -160
KPX Lcaron y -30
KPX Lcaron yacute -30
KPX Lcaron ydieresis -30
KPX Lcommaaccent T -110
KPX Lcommaaccent Tcaron -110
KPX Lcommaaccent Tcommaaccent -110
KPX Lcommaaccent V -110
KPX Lcommaaccent W -70
KPX Lcommaaccent Y -140
KPX Lcommaaccent Yacute -140
KPX Lcommaaccent Ydieresis -140
KPX Lcommaaccent quotedblright -140
KPX Lcommaaccent quoteright -160
KPX Lcommaaccent y -30
KPX Lcommaaccent yacute -30
KPX Lcommaaccent ydieresis -30
KPX Lslash T -110
KPX Lslash Tcaron -110
KPX Lslash Tcommaaccent -110
KPX Lslash V -110
KPX Lslash W -70
KPX Lslash Y -140
KPX Lslash Yacute -140
KPX Lslash Ydieresis -140
KPX Lslash quotedblright -140
KPX Lslash quoteright -160
KPX Lslash y -30
KPX Lslash yacute -30
KPX Lslash ydieresis -30
KPX O A -20
KPX O Aacute -20
KPX O Abreve -20
KPX O Acircumflex -20
KPX O Adieresis -20
KPX O Agrave -20
KPX O Amacron -20
KPX O Aogonek -20
KPX O Aring -20
KPX O Atilde -20
KPX O T -40
KPX O Tcaron -40
KPX O Tcommaaccent -40
KPX O V -50
KPX O W -30
KPX O X -60
KPX O Y -70
KPX O Yacute -70
KPX O Ydieresis -70
KPX O comma -40
KPX O period -40
KPX Oacute A -20
KPX Oacute Aacute -20
KPX Oacute Abreve -20
KPX Oacute Acircumflex -20
KPX Oacute Adieresis -20
KPX Oacute Agrave -20
KPX Oacute Amacron -20
KPX Oacute Aogonek -20
KPX Oacute Aring -20
KPX Oacute Atilde -20
KPX Oacute T -40
KPX Oacute Tcaron -40
KPX Oacute Tcommaaccent -40
KPX Oacute V -50
KPX Oacute W -30
KPX Oacute X -60
KPX Oacute Y -70
KPX Oacute Yacute -70
KPX Oacute Ydieresis -70
KPX Oacute comma -40
KPX Oacute period -40
KPX Ocircumflex A -20
KPX Ocircumflex Aacute -20
KPX Ocircumflex Abreve -20
KPX Ocircumflex Acircumflex -20
KPX Ocircumflex Adieresis -20
KPX Ocircumflex Agrave -20
KPX Ocircumflex Amacron -20
KPX Ocircumflex Aogonek -20
KPX Ocircumflex Aring -20
KPX Ocircumflex Atilde -20
KPX Ocircumflex T -40
KPX Ocircumflex Tcaron -40
KPX Ocircumflex Tcommaaccent -40
KPX Ocircumflex V -50
KPX Ocircumflex W -30
KPX Ocircumflex X -60
KPX Ocircumflex Y -70
KPX Ocircumflex Yacute -70
KPX Ocircumflex Ydieresis -70
KPX Ocircumflex comma -40
KPX Ocircumflex period -40
KPX Odieresis A -20
KPX Odieresis Aacute -20
KPX Odieresis Abreve -20
KPX Odieresis Acircumflex -20
KPX Odieresis Adieresis -20
KPX Odieresis Agrave -20
KPX Odieresis Amacron -20
KPX Odieresis Aogonek -20
KPX Odieresis Aring -20
KPX Odieresis Atilde -20
KPX Odieresis T -40
KPX Odieresis Tcaron -40
KPX Odieresis Tcommaaccent -40
KPX Odieresis V -50
KPX Odieresis W -30
KPX Odieresis X -60
KPX Odieresis Y -70
KPX Odieresis Yacute -70
KPX Odieresis Ydieresis -70
KPX Odieresis comma -40
KPX Odieresis period -40
KPX Ograve A -20
KPX Ograve Aacute -20
KPX Ograve Abreve -20
KPX Ograve Acircumflex -20
KPX Ograve Adieresis -20
KPX Ograve Agrave -20
KPX Ograve Amacron -20
KPX Ograve Aogonek -20
KPX Ograve Aring -20
KPX Ograve Atilde -20
KPX Ograve T -40
KPX Ograve Tcaron -40
KPX Ograve Tcommaaccent -40
KPX Ograve V -50
KPX Ograve W -30
KPX Ograve X -60
KPX Ograve Y -70
KPX Ograve Yacute -70
KPX Ograve Ydieresis -70
KPX Ograve comma -40
KPX Ograve period -40
KPX Ohungarumlaut A -20
KPX Ohungarumlaut Aacute -20
KPX Ohungarumlaut Abreve -20
KPX Ohungarumlaut Acircumflex -20
KPX Ohungarumlaut Adieresis -20
KPX Ohungarumlaut Agrave -20
KPX Ohungarumlaut Amacron -20
KPX Ohungarumlaut Aogonek -20
KPX Ohungarumlaut Aring -20
KPX Ohungarumlaut Atilde -20
KPX Ohungarumlaut T -40
KPX Ohungarumlaut Tcaron -40
KPX Ohungarumlaut Tcommaaccent -40
KPX Ohungarumlaut V -50
KPX Ohungarumlaut W -30
KPX Ohungarumlaut X -60
KPX Ohungarumlaut Y -70
KPX Ohungarumlaut Yacute -70
KPX Ohungarumlaut Ydieresis -70
KPX Ohungarumlaut comma -40
KPX Ohungarumlaut period -40
KPX Omacron A -20
KPX Omacron Aacute -20
KPX Omacron Abreve -20
KPX Omacron Acircumflex -20
KPX Omacron Adieresis -20
KPX Omacron Agrave -20
KPX Omacron Amacron -20
KPX Omacron Aogonek -20
KPX Omacron Aring -20
KPX Omacron Atilde -20
KPX Omacron T -40
KPX Omacron Tcaron -40
KPX Omacron Tcommaaccent -40
KPX Omacron V -50
KPX Omacron W -30
KPX Omacron X -60
KPX Omacron Y -70
KPX Omacron Yacute -70
KPX Omacron Ydieresis -70
KPX Omacron comma -40
KPX Omacron period -40
KPX Oslash A -20
KPX Oslash Aacute -20
KPX Oslash Abreve -20
KPX Oslash Acircumflex -20
KPX Oslash Adieresis -20
KPX Oslash Agrave -20
KPX Oslash Amacron -20
KPX Oslash Aogonek -20
KPX Oslash Aring -20
KPX Oslash Atilde -20
KPX Oslash T -40
KPX Oslash Tcaron -40
KPX Oslash Tcommaaccent -40
KPX Oslash V -50
KPX Oslash W -30
KPX Oslash X -60
KPX Oslash Y -70
KPX Oslash Yacute -70
KPX Oslash Ydieresis -70
KPX Oslash comma -40
KPX Oslash period -40
KPX Otilde A -20
KPX Otilde Aacute -20
KPX Otilde Abreve -20
KPX Otilde Acircumflex -20
KPX Otilde Adieresis -20
KPX Otilde Agrave -20
KPX Otilde Amacron -20
KPX Otilde Aogonek -20
KPX Otilde Aring -20
KPX Otilde Atilde -20
KPX Otilde T -40
KPX Otilde Tcaron -40
KPX Otilde Tcommaaccent -40
KPX Otilde V -50
KPX Otilde W -30
KPX Otilde X -60
KPX Otilde Y -70
KPX Otilde Yacute -70
KPX Otilde Ydieresis -70
KPX Otilde comma -40
KPX Otilde period -40
KPX P A -120
KPX P Aacute -120
KPX P Abreve -120
KPX P Acircumflex -120
KPX P Adieresis -120
KPX P Agrave -120
KPX P Amacron -120
KPX P Aogonek -120
KPX P Aring -120
KPX P Atilde -120
KPX P a -40
KPX P aacute -40
KPX P abreve -40
KPX P acircumflex -40
KPX P adieresis -40
KPX P agrave -40
KPX P amacron -40
KPX P aogonek -40
KPX P aring -40
KPX P atilde -40
KPX P comma -180
KPX P e -50
KPX P eacute -50
KPX P ecaron -50
KPX P ecircumflex -50
KPX P edieresis -50
KPX P edotaccent -50
KPX P egrave -50
KPX P emacron -50
KPX P eogonek -50
KPX P o -50
KPX P oacute -50
KPX P ocircumflex -50
KPX P odieresis -50
KPX P ograve -50
KPX P ohungarumlaut -50
KPX P omacron -50
KPX P oslash -50
KPX P otilde -50
KPX P period -180
KPX Q U -10
KPX Q Uacute -10
KPX Q Ucircumflex -10
KPX Q Udieresis -10
KPX Q Ugrave -10
KPX Q Uhungarumlaut -10
KPX Q Umacron -10
KPX Q Uogonek -10
KPX Q Uring -10
KPX R O -20
KPX R Oacute -20
KPX R Ocircumflex -20
KPX R Odieresis -20
KPX R Ograve -20
KPX R Ohungarumlaut -20
KPX R Omacron -20
KPX R Oslash -20
KPX R Otilde -20
KPX R T -30
KPX R Tcaron -30
KPX R Tcommaaccent -30
KPX R U -40
KPX R Uacute -40
KPX R Ucircumflex -40
KPX R Udieresis -40
KPX R Ugrave -40
KPX R Uhungarumlaut -40
KPX R Umacron -40
KPX R Uogonek -40
KPX R Uring -40
KPX R V -50
KPX R W -30
KPX R Y -50
KPX R Yacute -50
KPX R Ydieresis -50
KPX Racute O -20
KPX Racute Oacute -20
KPX Racute Ocircumflex -20
KPX Racute Odieresis -20
KPX Racute Ograve -20
KPX Racute Ohungarumlaut -20
KPX Racute Omacron -20
KPX Racute Oslash -20
KPX Racute Otilde -20
KPX Racute T -30
KPX Racute Tcaron -30
KPX Racute Tcommaaccent -30
KPX Racute U -40
KPX Racute Uacute -40
KPX Racute Ucircumflex -40
KPX Racute Udieresis -40
KPX Racute Ugrave -40
KPX Racute Uhungarumlaut -40
KPX Racute Umacron -40
KPX Racute Uogonek -40
KPX Racute Uring -40
KPX Racute V -50
KPX Racute W -30
KPX Racute Y -50
KPX Racute Yacute -50
KPX Racute Ydieresis -50
KPX Rcaron O -20
KPX Rcaron Oacute -20
KPX Rcaron Ocircumflex -20
KPX Rcaron Odieresis -20
KPX Rcaron Ograve -20
KPX Rcaron Ohungarumlaut -20
KPX Rcaron Omacron -20
KPX Rcaron Oslash -20
KPX Rcaron Otilde -20
KPX Rcaron T -30
KPX Rcaron Tcaron -30
KPX Rcaron Tcommaaccent -30
KPX Rcaron U -40
KPX Rcaron Uacute -40
KPX Rcaron Ucircumflex -40
KPX Rcaron Udieresis -40
KPX Rcaron Ugrave -40
KPX Rcaron Uhungarumlaut -40
KPX Rcaron Umacron -40
KPX Rcaron Uogonek -40
KPX Rcaron Uring -40
KPX Rcaron V -50
KPX Rcaron W -30
KPX Rcaron Y -50
KPX Rcaron Yacute -50
KPX Rcaron Ydieresis -50
KPX Rcommaaccent O -20
KPX Rcommaaccent Oacute -20
KPX Rcommaaccent Ocircumflex -20
KPX Rcommaaccent Odieresis -20
KPX Rcommaaccent Ograve -20
KPX Rcommaaccent Ohungarumlaut -20
KPX Rcommaaccent Omacron -20
KPX Rcommaaccent Oslash -20
KPX Rcommaaccent Otilde -20
KPX Rcommaaccent T -30
KPX Rcommaaccent Tcaron -30
KPX Rcommaaccent Tcommaaccent -30
KPX Rcommaaccent U -40
KPX Rcommaaccent Uacute -40
KPX Rcommaaccent Ucircumflex -40
KPX Rcommaaccent Udieresis -40
KPX Rcommaaccent Ugrave -40
KPX Rcommaaccent Uhungarumlaut -40
KPX Rcommaaccent Umacron -40
KPX Rcommaaccent Uogonek -40
KPX Rcommaaccent Uring -40
KPX Rcommaaccent V -50
KPX Rcommaaccent W -30
KPX Rcommaaccent Y -50
KPX Rcommaaccent Yacute -50
KPX Rcommaaccent Ydieresis -50
KPX S comma -20
KPX S period -20
KPX Sacute comma -20
KPX Sacute period -20
KPX Scaron comma -20
KPX Scaron period -20
KPX Scedilla comma -20
KPX Scedilla period -20
KPX Scommaaccent comma -20
KPX Scommaaccent period -20
KPX T A -120
KPX T Aacute -120
KPX T Abreve -120
KPX T Acircumflex -120
KPX T Adieresis -120
KPX T Agrave -120
KPX T Amacron -120
KPX T Aogonek -120
KPX T Aring -120
KPX T Atilde -120
KPX T O -40
KPX T Oacute -40
KPX T Ocircumflex -40
KPX T Odieresis -40
KPX T Ograve -40
KPX T Ohungarumlaut -40
KPX T Omacron -40
KPX T Oslash -40
KPX T Otilde -40
KPX T a -120
KPX T aacute -120
KPX T abreve -60
KPX T acircumflex -120
KPX T adieresis -120
KPX T agrave -120
KPX T amacron -60
KPX T aogonek -120
KPX T aring -120
KPX T atilde -60
KPX T colon -20
KPX T comma -120
KPX T e -120
KPX T eacute -120
KPX T ecaron -120
KPX T ecircumflex -120
KPX T edieresis -120
KPX T edotaccent -120
KPX T egrave -60
KPX T emacron -60
KPX T eogonek -120
KPX T hyphen -140
KPX T o -120
KPX T oacute -120
KPX T ocircumflex -120
KPX T odieresis -120
KPX T ograve -120
KPX T ohungarumlaut -120
KPX T omacron -60
KPX T oslash -120
KPX T otilde -60
KPX T period -120
KPX T r -120
KPX T racute -120
KPX T rcaron -120
KPX T rcommaaccent -120
KPX T semicolon -20
KPX T u -120
KPX T uacute -120
KPX T ucircumflex -120
KPX T udieresis -120
KPX T ugrave -120
KPX T uhungarumlaut -120
KPX T umacron -60
KPX T uogonek -120
KPX T uring -120
KPX T w -120
KPX T y -120
KPX T yacute -120
KPX T ydieresis -60
KPX Tcaron A -120
KPX Tcaron Aacute -120
KPX Tcaron Abreve -120
KPX Tcaron Acircumflex -120
KPX Tcaron Adieresis -120
KPX Tcaron Agrave -120
KPX Tcaron Amacron -120
KPX Tcaron Aogonek -120
KPX Tcaron Aring -120
KPX Tcaron Atilde -120
KPX Tcaron O -40
KPX Tcaron Oacute -40
KPX Tcaron Ocircumflex -40
KPX Tcaron Odieresis -40
KPX Tcaron Ograve -40
KPX Tcaron Ohungarumlaut -40
KPX Tcaron Omacron -40
KPX Tcaron Oslash -40
KPX Tcaron Otilde -40
KPX Tcaron a -120
KPX Tcaron aacute -120
KPX Tcaron abreve -60
KPX Tcaron acircumflex -120
KPX Tcaron adieresis -120
KPX Tcaron agrave -120
KPX Tcaron amacron -60
KPX Tcaron aogonek -120
KPX Tcaron aring -120
KPX Tcaron atilde -60
KPX Tcaron colon -20
KPX Tcaron comma -120
KPX Tcaron e -120
KPX Tcaron eacute -120
KPX Tcaron ecaron -120
KPX Tcaron ecircumflex -120
KPX Tcaron edieresis -120
KPX Tcaron edotaccent -120
KPX Tcaron egrave -60
KPX Tcaron emacron -60
KPX Tcaron eogonek -120
KPX Tcaron hyphen -140
KPX Tcaron o -120
KPX Tcaron oacute -120
KPX Tcaron ocircumflex -120
KPX Tcaron odieresis -120
KPX Tcaron ograve -120
KPX Tcaron ohungarumlaut -120
KPX Tcaron omacron -60
KPX Tcaron oslash -120
KPX Tcaron otilde -60
KPX Tcaron period -120
KPX Tcaron r -120
KPX Tcaron racute -120
KPX Tcaron rcaron -120
KPX Tcaron rcommaaccent -120
KPX Tcaron semicolon -20
KPX Tcaron u -120
KPX Tcaron uacute -120
KPX Tcaron ucircumflex -120
KPX Tcaron udieresis -120
KPX Tcaron ugrave -120
KPX Tcaron uhungarumlaut -120
KPX Tcaron umacron -60
KPX Tcaron uogonek -120
KPX Tcaron uring -120
KPX Tcaron w -120
KPX Tcaron y -120
KPX Tcaron yacute -120
KPX Tcaron ydieresis -60
KPX Tcommaaccent A -120
KPX Tcommaaccent Aacute -120
KPX Tcommaaccent Abreve -120
KPX Tcommaaccent Acircumflex -120
KPX Tcommaaccent Adieresis -120
KPX Tcommaaccent Agrave -120
KPX Tcommaaccent Amacron -120
KPX Tcommaaccent Aogonek -120
KPX Tcommaaccent Aring -120
KPX Tcommaaccent Atilde -120
KPX Tcommaaccent O -40
KPX Tcommaaccent Oacute -40
KPX Tcommaaccent Ocircumflex -40
KPX Tcommaaccent Odieresis -40
KPX Tcommaaccent Ograve -40
KPX Tcommaaccent Ohungarumlaut -40
KPX Tcommaaccent Omacron -40
KPX Tcommaaccent Oslash -40
KPX Tcommaaccent Otilde -40
KPX Tcommaaccent a -120
KPX Tcommaaccent aacute -120
KPX Tcommaaccent abreve -60
KPX Tcommaaccent acircumflex -120
KPX Tcommaaccent adieresis -120
KPX Tcommaaccent agrave -120
KPX Tcommaaccent amacron -60
KPX Tcommaaccent aogonek -120
KPX Tcommaaccent aring -120
KPX Tcommaaccent atilde -60
KPX Tcommaaccent colon -20
KPX Tcommaaccent comma -120
KPX Tcommaaccent e -120
KPX Tcommaaccent eacute -120
KPX Tcommaaccent ecaron -120
KPX Tcommaaccent ecircumflex -120
KPX Tcommaaccent edieresis -120
KPX Tcommaaccent edotaccent -120
KPX Tcommaaccent egrave -60
KPX Tcommaaccent emacron -60
KPX Tcommaaccent eogonek -120
KPX Tcommaaccent hyphen -140
KPX Tcommaaccent o -120
KPX Tcommaaccent oacute -120
KPX Tcommaaccent ocircumflex -120
KPX Tcommaaccent odieresis -120
KPX Tcommaaccent ograve -120
KPX Tcommaaccent ohungarumlaut -120
KPX Tcommaaccent omacron -60
KPX Tcommaaccent oslash -120
KPX Tcommaaccent otilde -60
KPX Tcommaaccent period -120
KPX Tcommaaccent r -120
KPX Tcommaaccent racute -120
KPX Tcommaaccent rcaron -120
KPX Tcommaaccent rcommaaccent -120
KPX Tcommaaccent semicolon -20
KPX Tcommaaccent u -120
KPX Tcommaaccent uacute -120
KPX Tcommaaccent ucircumflex -120
KPX Tcommaaccent udieresis -120
KPX Tcommaaccent ugrave -120
KPX Tcommaaccent uhungarumlaut -120
KPX Tcommaaccent umacron -60
KPX Tcommaaccent uogonek -120
KPX Tcommaaccent uring -120
KPX Tcommaaccent w -120
KPX Tcommaaccent y -120
KPX Tcommaaccent yacute -120
KPX Tcommaaccent ydieresis -60
KPX U A -40
KPX U Aacute -40
KPX U Abreve -40
KPX U Acircumflex -40
KPX U Adieresis -40
KPX U Agrave -40
KPX U Amacron -40
KPX U Aogonek -40
KPX U Aring -40
KPX U Atilde -40
KPX U comma -40
KPX U period -40
KPX Uacute A -40
KPX Uacute Aacute -40
KPX Uacute Abreve -40
KPX Uacute Acircumflex -40
KPX Uacute Adieresis -40
KPX Uacute Agrave -40
KPX Uacute Amacron -40
KPX Uacute Aogonek -40
KPX Uacute Aring -40
KPX Uacute Atilde -40
KPX Uacute comma -40
KPX Uacute period -40
KPX Ucircumflex A -40
KPX Ucircumflex Aacute -40
KPX Ucircumflex Abreve -40
KPX Ucircumflex Acircumflex -40
KPX Ucircumflex Adieresis -40
KPX Ucircumflex Agrave -40
KPX Ucircumflex Amacron -40
KPX Ucircumflex Aogonek -40
KPX Ucircumflex Aring -40
KPX Ucircumflex Atilde -40
KPX Ucircumflex comma -40
KPX Ucircumflex period -40
KPX Udieresis A -40
KPX Udieresis Aacute -40
KPX Udieresis Abreve -40
KPX Udieresis Acircumflex -40
KPX Udieresis Adieresis -40
KPX Udieresis Agrave -40
KPX Udieresis Amacron -40
KPX Udieresis Aogonek -40
KPX Udieresis Aring -40
KPX Udieresis Atilde -40
KPX Udieresis comma -40
KPX Udieresis period -40
KPX Ugrave A -40
KPX Ugrave Aacute -40
KPX Ugrave Abreve -40
KPX Ugrave Acircumflex -40
KPX Ugrave Adieresis -40
KPX Ugrave Agrave -40
KPX Ugrave Amacron -40
KPX Ugrave Aogonek -40
KPX Ugrave Aring -40
KPX Ugrave Atilde -40
KPX Ugrave comma -40
KPX Ugrave period -40
KPX Uhungarumlaut A -40
KPX Uhungarumlaut Aacute -40
KPX Uhungarumlaut Abreve -40
KPX Uhungarumlaut Acircumflex -40
KPX Uhungarumlaut Adieresis -40
KPX Uhungarumlaut Agrave -40
KPX Uhungarumlaut Amacron -40
KPX Uhungarumlaut Aogonek -40
KPX Uhungarumlaut Aring -40
KPX Uhungarumlaut Atilde -40
KPX Uhungarumlaut comma -40
KPX Uhungarumlaut period -40
KPX Umacron A -40
KPX Umacron Aacute -40
KPX Umacron Abreve -40
KPX Umacron Acircumflex -40
KPX Umacron Adieresis -40
KPX Umacron Agrave -40
KPX Umacron Amacron -40
KPX Umacron Aogonek -40
KPX Umacron Aring -40
KPX Umacron Atilde -40
KPX Umacron comma -40
KPX Umacron period -40
KPX Uogonek A -40
KPX Uogonek Aacute -40
KPX Uogonek Abreve -40
KPX Uogonek Acircumflex -40
KPX Uogonek Adieresis -40
KPX Uogonek Agrave -40
KPX Uogonek Amacron -40
KPX Uogonek Aogonek -40
KPX Uogonek Aring -40
KPX Uogonek Atilde -40
KPX Uogonek comma -40
KPX Uogonek period -40
KPX Uring A -40
KPX Uring Aacute -40
KPX Uring Abreve -40
KPX Uring Acircumflex -40
KPX Uring Adieresis -40
KPX Uring Agrave -40
KPX Uring Amacron -40
KPX Uring Aogonek -40
KPX Uring Aring -40
KPX Uring Atilde -40
KPX Uring comma -40
KPX Uring period -40
KPX V A -80
KPX V Aacute -80
KPX V Abreve -80
KPX V Acircumflex -80
KPX V Adieresis -80
KPX V Agrave -80
KPX V Amacron -80
KPX V Aogonek -80
KPX V Aring -80
KPX V Atilde -80
KPX V G -40
KPX V Gbreve -40
KPX V Gcommaaccent -40
KPX V O -40
KPX V Oacute -40
KPX V Ocircumflex -40
KPX V Odieresis -40
KPX V Ograve -40
KPX V Ohungarumlaut -40
KPX V Omacron -40
KPX V Oslash -40
KPX V Otilde -40
KPX V a -70
KPX V aacute -70
KPX V abreve -70
KPX V acircumflex -70
KPX V adieresis -70
KPX V agrave -70
KPX V amacron -70
KPX V aogonek -70
KPX V aring -70
KPX V atilde -70
KPX V colon -40
KPX V comma -125
KPX V e -80
KPX V eacute -80
KPX V ecaron -80
KPX V ecircumflex -80
KPX V edieresis -80
KPX V edotaccent -80
KPX V egrave -80
KPX V emacron -80
KPX V eogonek -80
KPX V hyphen -80
KPX V o -80
KPX V oacute -80
KPX V ocircumflex -80
KPX V odieresis -80
KPX V ograve -80
KPX V ohungarumlaut -80
KPX V omacron -80
KPX V oslash -80
KPX V otilde -80
KPX V period -125
KPX V semicolon -40
KPX V u -70
KPX V uacute -70
KPX V ucircumflex -70
KPX V udieresis -70
KPX V ugrave -70
KPX V uhungarumlaut -70
KPX V umacron -70
KPX V uogonek -70
KPX V uring -70
KPX W A -50
KPX W Aacute -50
KPX W Abreve -50
KPX W Acircumflex -50
KPX W Adieresis -50
KPX W Agrave -50
KPX W Amacron -50
KPX W Aogonek -50
KPX W Aring -50
KPX W Atilde -50
KPX W O -20
KPX W Oacute -20
KPX W Ocircumflex -20
KPX W Odieresis -20
KPX W Ograve -20
KPX W Ohungarumlaut -20
KPX W Omacron -20
KPX W Oslash -20
KPX W Otilde -20
KPX W a -40
KPX W aacute -40
KPX W abreve -40
KPX W acircumflex -40
KPX W adieresis -40
KPX W agrave -40
KPX W amacron -40
KPX W aogonek -40
KPX W aring -40
KPX W atilde -40
KPX W comma -80
KPX W e -30
KPX W eacute -30
KPX W ecaron -30
KPX W ecircumflex -30
KPX W edieresis -30
KPX W edotaccent -30
KPX W egrave -30
KPX W emacron -30
KPX W eogonek -30
KPX W hyphen -40
KPX W o -30
KPX W oacute -30
KPX W ocircumflex -30
KPX W odieresis -30
KPX W ograve -30
KPX W ohungarumlaut -30
KPX W omacron -30
KPX W oslash -30
KPX W otilde -30
KPX W period -80
KPX W u -30
KPX W uacute -30
KPX W ucircumflex -30
KPX W udieresis -30
KPX W ugrave -30
KPX W uhungarumlaut -30
KPX W umacron -30
KPX W uogonek -30
KPX W uring -30
KPX W y -20
KPX W yacute -20
KPX W ydieresis -20
KPX Y A -110
KPX Y Aacute -110
KPX Y Abreve -110
KPX Y Acircumflex -110
KPX Y Adieresis -110
KPX Y Agrave -110
KPX Y Amacron -110
KPX Y Aogonek -110
KPX Y Aring -110
KPX Y Atilde -110
KPX Y O -85
KPX Y Oacute -85
KPX Y Ocircumflex -85
KPX Y Odieresis -85
KPX Y Ograve -85
KPX Y Ohungarumlaut -85
KPX Y Omacron -85
KPX Y Oslash -85
KPX Y Otilde -85
KPX Y a -140
KPX Y aacute -140
KPX Y abreve -70
KPX Y acircumflex -140
KPX Y adieresis -140
KPX Y agrave -140
KPX Y amacron -70
KPX Y aogonek -140
KPX Y aring -140
KPX Y atilde -140
KPX Y colon -60
KPX Y comma -140
KPX Y e -140
KPX Y eacute -140
KPX Y ecaron -140
KPX Y ecircumflex -140
KPX Y edieresis -140
KPX Y edotaccent -140
KPX Y egrave -140
KPX Y emacron -70
KPX Y eogonek -140
KPX Y hyphen -140
KPX Y i -20
KPX Y iacute -20
KPX Y iogonek -20
KPX Y o -140
KPX Y oacute -140
KPX Y ocircumflex -140
KPX Y odieresis -140
KPX Y ograve -140
KPX Y ohungarumlaut -140
KPX Y omacron -140
KPX Y oslash -140
KPX Y otilde -140
KPX Y period -140
KPX Y semicolon -60
KPX Y u -110
KPX Y uacute -110
KPX Y ucircumflex -110
KPX Y udieresis -110
KPX Y ugrave -110
KPX Y uhungarumlaut -110
KPX Y umacron -110
KPX Y uogonek -110
KPX Y uring -110
KPX Yacute A -110
KPX Yacute Aacute -110
KPX Yacute Abreve -110
KPX Yacute Acircumflex -110
KPX Yacute Adieresis -110
KPX Yacute Agrave -110
KPX Yacute Amacron -110
KPX Yacute Aogonek -110
KPX Yacute Aring -110
KPX Yacute Atilde -110
KPX Yacute O -85
KPX Yacute Oacute -85
KPX Yacute Ocircumflex -85
KPX Yacute Odieresis -85
KPX Yacute Ograve -85
KPX Yacute Ohungarumlaut -85
KPX Yacute Omacron -85
KPX Yacute Oslash -85
KPX Yacute Otilde -85
KPX Yacute a -140
KPX Yacute aacute -140
KPX Yacute abreve -70
KPX Yacute acircumflex -140
KPX Yacute adieresis -140
KPX Yacute agrave -140
KPX Yacute amacron -70
KPX Yacute aogonek -140
KPX Yacute aring -140
KPX Yacute atilde -70
KPX Yacute colon -60
KPX Yacute comma -140
KPX Yacute e -140
KPX Yacute eacute -140
KPX Yacute ecaron -140
KPX Yacute ecircumflex -140
KPX Yacute edieresis -140
KPX Yacute edotaccent -140
KPX Yacute egrave -140
KPX Yacute emacron -70
KPX Yacute eogonek -140
KPX Yacute hyphen -140
KPX Yacute i -20
KPX Yacute iacute -20
KPX Yacute iogonek -20
KPX Yacute o -140
KPX Yacute oacute -140
KPX Yacute ocircumflex -140
KPX Yacute odieresis -140
KPX Yacute ograve -140
KPX Yacute ohungarumlaut -140
KPX Yacute omacron -70
KPX Yacute oslash -140
KPX Yacute otilde -140
KPX Yacute period -140
KPX Yacute semicolon -60
KPX Yacute u -110
KPX Yacute uacute -110
KPX Yacute ucircumflex -110
KPX Yacute udieresis -110
KPX Yacute ugrave -110
KPX Yacute uhungarumlaut -110
KPX Yacute umacron -110
KPX Yacute uogonek -110
KPX Yacute uring -110
KPX Ydieresis A -110
KPX Ydieresis Aacute -110
KPX Ydieresis Abreve -110
KPX Ydieresis Acircumflex -110
KPX Ydieresis Adieresis -110
KPX Ydieresis Agrave -110
KPX Ydieresis Amacron -110
KPX Ydieresis Aogonek -110
KPX Ydieresis Aring -110
KPX Ydieresis Atilde -110
KPX Ydieresis O -85
KPX Ydieresis Oacute -85
KPX Ydieresis Ocircumflex -85
KPX Ydieresis Odieresis -85
KPX Ydieresis Ograve -85
KPX Ydieresis Ohungarumlaut -85
KPX Ydieresis Omacron -85
KPX Ydieresis Oslash -85
KPX Ydieresis Otilde -85
KPX Ydieresis a -140
KPX Ydieresis aacute -140
KPX Ydieresis abreve -70
KPX Ydieresis acircumflex -140
KPX Ydieresis adieresis -140
KPX Ydieresis agrave -140
KPX Ydieresis amacron -70
KPX Ydieresis aogonek -140
KPX Ydieresis aring -140
KPX Ydieresis atilde -70
KPX Ydieresis colon -60
KPX Ydieresis comma -140
KPX Ydieresis e -140
KPX Ydieresis eacute -140
KPX Ydieresis ecaron -140
KPX Ydieresis ecircumflex -140
KPX Ydieresis edieresis -140
KPX Ydieresis edotaccent -140
KPX Ydieresis egrave -140
KPX Ydieresis emacron -70
KPX Ydieresis eogonek -140
KPX Ydieresis hyphen -140
KPX Ydieresis i -20
KPX Ydieresis iacute -20
KPX Ydieresis iogonek -20
KPX Ydieresis o -140
KPX Ydieresis oacute -140
KPX Ydieresis ocircumflex -140
KPX Ydieresis odieresis -140
KPX Ydieresis ograve -140
KPX Ydieresis ohungarumlaut -140
KPX Ydieresis omacron -140
KPX Ydieresis oslash -140
KPX Ydieresis otilde -140
KPX Ydieresis period -140
KPX Ydieresis semicolon -60
KPX Ydieresis u -110
KPX Ydieresis uacute -110
KPX Ydieresis ucircumflex -110
KPX Ydieresis udieresis -110
KPX Ydieresis ugrave -110
KPX Ydieresis uhungarumlaut -110
KPX Ydieresis umacron -110
KPX Ydieresis uogonek -110
KPX Ydieresis uring -110
KPX a v -20
KPX a w -20
KPX a y -30
KPX a yacute -30
KPX a ydieresis -30
KPX aacute v -20
KPX aacute w -20
KPX aacute y -30
KPX aacute yacute -30
KPX aacute ydieresis -30
KPX abreve v -20
KPX abreve w -20
KPX abreve y -30
KPX abreve yacute -30
KPX abreve ydieresis -30
KPX acircumflex v -20
KPX acircumflex w -20
KPX acircumflex y -30
KPX acircumflex yacute -30
KPX acircumflex ydieresis -30
KPX adieresis v -20
KPX adieresis w -20
KPX adieresis y -30
KPX adieresis yacute -30
KPX adieresis ydieresis -30
KPX agrave v -20
KPX agrave w -20
KPX agrave y -30
KPX agrave yacute -30
KPX agrave ydieresis -30
KPX amacron v -20
KPX amacron w -20
KPX amacron y -30
KPX amacron yacute -30
KPX amacron ydieresis -30
KPX aogonek v -20
KPX aogonek w -20
KPX aogonek y -30
KPX aogonek yacute -30
KPX aogonek ydieresis -30
KPX aring v -20
KPX aring w -20
KPX aring y -30
KPX aring yacute -30
KPX aring ydieresis -30
KPX atilde v -20
KPX atilde w -20
KPX atilde y -30
KPX atilde yacute -30
KPX atilde ydieresis -30
KPX b b -10
KPX b comma -40
KPX b l -20
KPX b lacute -20
KPX b lcommaaccent -20
KPX b lslash -20
KPX b period -40
KPX b u -20
KPX b uacute -20
KPX b ucircumflex -20
KPX b udieresis -20
KPX b ugrave -20
KPX b uhungarumlaut -20
KPX b umacron -20
KPX b uogonek -20
KPX b uring -20
KPX b v -20
KPX b y -20
KPX b yacute -20
KPX b ydieresis -20
KPX c comma -15
KPX c k -20
KPX c kcommaaccent -20
KPX cacute comma -15
KPX cacute k -20
KPX cacute kcommaaccent -20
KPX ccaron comma -15
KPX ccaron k -20
KPX ccaron kcommaaccent -20
KPX ccedilla comma -15
KPX ccedilla k -20
KPX ccedilla kcommaaccent -20
KPX colon space -50
KPX comma quotedblright -100
KPX comma quoteright -100
KPX e comma -15
KPX e period -15
KPX e v -30
KPX e w -20
KPX e x -30
KPX e y -20
KPX e yacute -20
KPX e ydieresis -20
KPX eacute comma -15
KPX eacute period -15
KPX eacute v -30
KPX eacute w -20
KPX eacute x -30
KPX eacute y -20
KPX eacute yacute -20
KPX eacute ydieresis -20
KPX ecaron comma -15
KPX ecaron period -15
KPX ecaron v -30
KPX ecaron w -20
KPX ecaron x -30
KPX ecaron y -20
KPX ecaron yacute -20
KPX ecaron ydieresis -20
KPX ecircumflex comma -15
KPX ecircumflex period -15
KPX ecircumflex v -30
KPX ecircumflex w -20
KPX ecircumflex x -30
KPX ecircumflex y -20
KPX ecircumflex yacute -20
KPX ecircumflex ydieresis -20
KPX edieresis comma -15
KPX edieresis period -15
KPX edieresis v -30
KPX edieresis w -20
KPX edieresis x -30
KPX edieresis y -20
KPX edieresis yacute -20
KPX edieresis ydieresis -20
KPX edotaccent comma -15
KPX edotaccent period -15
KPX edotaccent v -30
KPX edotaccent w -20
KPX edotaccent x -30
KPX edotaccent y -20
KPX edotaccent yacute -20
KPX edotaccent ydieresis -20
KPX egrave comma -15
KPX egrave period -15
KPX egrave v -30
KPX egrave w -20
KPX egrave x -30
KPX egrave y -20
KPX egrave yacute -20
KPX egrave ydieresis -20
KPX emacron comma -15
KPX emacron period -15
KPX emacron v -30
KPX emacron w -20
KPX emacron x -30
KPX emacron y -20
KPX emacron yacute -20
KPX emacron ydieresis -20
KPX eogonek comma -15
KPX eogonek period -15
KPX eogonek v -30
KPX eogonek w -20
KPX eogonek x -30
KPX eogonek y -20
KPX eogonek yacute -20
KPX eogonek ydieresis -20
KPX f a -30
KPX f aacute -30
KPX f abreve -30
KPX f acircumflex -30
KPX f adieresis -30
KPX f agrave -30
KPX f amacron -30
KPX f aogonek -30
KPX f aring -30
KPX f atilde -30
KPX f comma -30
KPX f dotlessi -28
KPX f e -30
KPX f eacute -30
KPX f ecaron -30
KPX f ecircumflex -30
KPX f edieresis -30
KPX f edotaccent -30
KPX f egrave -30
KPX f emacron -30
KPX f eogonek -30
KPX f o -30
KPX f oacute -30
KPX f ocircumflex -30
KPX f odieresis -30
KPX f ograve -30
KPX f ohungarumlaut -30
KPX f omacron -30
KPX f oslash -30
KPX f otilde -30
KPX f period -30
KPX f quotedblright 60
KPX f quoteright 50
KPX g r -10
KPX g racute -10
KPX g rcaron -10
KPX g rcommaaccent -10
KPX gbreve r -10
KPX gbreve racute -10
KPX gbreve rcaron -10
KPX gbreve rcommaaccent -10
KPX gcommaaccent r -10
KPX gcommaaccent racute -10
KPX gcommaaccent rcaron -10
KPX gcommaaccent rcommaaccent -10
KPX h y -30
KPX h yacute -30
KPX h ydieresis -30
KPX k e -20
KPX k eacute -20
KPX k ecaron -20
KPX k ecircumflex -20
KPX k edieresis -20
KPX k edotaccent -20
KPX k egrave -20
KPX k emacron -20
KPX k eogonek -20
KPX k o -20
KPX k oacute -20
KPX k ocircumflex -20
KPX k odieresis -20
KPX k ograve -20
KPX k ohungarumlaut -20
KPX k omacron -20
KPX k oslash -20
KPX k otilde -20
KPX kcommaaccent e -20
KPX kcommaaccent eacute -20
KPX kcommaaccent ecaron -20
KPX kcommaaccent ecircumflex -20
KPX kcommaaccent edieresis -20
KPX kcommaaccent edotaccent -20
KPX kcommaaccent egrave -20
KPX kcommaaccent emacron -20
KPX kcommaaccent eogonek -20
KPX kcommaaccent o -20
KPX kcommaaccent oacute -20
KPX kcommaaccent ocircumflex -20
KPX kcommaaccent odieresis -20
KPX kcommaaccent ograve -20
KPX kcommaaccent ohungarumlaut -20
KPX kcommaaccent omacron -20
KPX kcommaaccent oslash -20
KPX kcommaaccent otilde -20
KPX m u -10
KPX m uacute -10
KPX m ucircumflex -10
KPX m udieresis -10
KPX m ugrave -10
KPX m uhungarumlaut -10
KPX m umacron -10
KPX m uogonek -10
KPX m uring -10
KPX m y -15
KPX m yacute -15
KPX m ydieresis -15
KPX n u -10
KPX n uacute -10
KPX n ucircumflex -10
KPX n udieresis -10
KPX n ugrave -10
KPX n uhungarumlaut -10
KPX n umacron -10
KPX n uogonek -10
KPX n uring -10
KPX n v -20
KPX n y -15
KPX n yacute -15
KPX n ydieresis -15
KPX nacute u -10
KPX nacute uacute -10
KPX nacute ucircumflex -10
KPX nacute udieresis -10
KPX nacute ugrave -10
KPX nacute uhungarumlaut -10
KPX nacute umacron -10
KPX nacute uogonek -10
KPX nacute uring -10
KPX nacute v -20
KPX nacute y -15
KPX nacute yacute -15
KPX nacute ydieresis -15
KPX ncaron u -10
KPX ncaron uacute -10
KPX ncaron ucircumflex -10
KPX ncaron udieresis -10
KPX ncaron ugrave -10
KPX ncaron uhungarumlaut -10
KPX ncaron umacron -10
KPX ncaron uogonek -10
KPX ncaron uring -10
KPX ncaron v -20
KPX ncaron y -15
KPX ncaron yacute -15
KPX ncaron ydieresis -15
KPX ncommaaccent u -10
KPX ncommaaccent uacute -10
KPX ncommaaccent ucircumflex -10
KPX ncommaaccent udieresis -10
KPX ncommaaccent ugrave -10
KPX ncommaaccent uhungarumlaut -10
KPX ncommaaccent umacron -10
KPX ncommaaccent uogonek -10
KPX ncommaaccent uring -10
KPX ncommaaccent v -20
KPX ncommaaccent y -15
KPX ncommaaccent yacute -15
KPX ncommaaccent ydieresis -15
KPX ntilde u -10
KPX ntilde uacute -10
KPX ntilde ucircumflex -10
KPX ntilde udieresis -10
KPX ntilde ugrave -10
KPX ntilde uhungarumlaut -10
KPX ntilde umacron -10
KPX ntilde uogonek -10
KPX ntilde uring -10
KPX ntilde v -20
KPX ntilde y -15
KPX ntilde yacute -15
KPX ntilde ydieresis -15
KPX o comma -40
KPX o period -40
KPX o v -15
KPX o w -15
KPX o x -30
KPX o y -30
KPX o yacute -30
KPX o ydieresis -30
KPX oacute comma -40
KPX oacute period -40
KPX oacute v -15
KPX oacute w -15
KPX oacute x -30
KPX oacute y -30
KPX oacute yacute -30
KPX oacute ydieresis -30
KPX ocircumflex comma -40
KPX ocircumflex period -40
KPX ocircumflex v -15
KPX ocircumflex w -15
KPX ocircumflex x -30
KPX ocircumflex y -30
KPX ocircumflex yacute -30
KPX ocircumflex ydieresis -30
KPX odieresis comma -40
KPX odieresis period -40
KPX odieresis v -15
KPX odieresis w -15
KPX odieresis x -30
KPX odieresis y -30
KPX odieresis yacute -30
KPX odieresis ydieresis -30
KPX ograve comma -40
KPX ograve period -40
KPX ograve v -15
KPX ograve w -15
KPX ograve x -30
KPX ograve y -30
KPX ograve yacute -30
KPX ograve ydieresis -30
KPX ohungarumlaut comma -40
KPX ohungarumlaut period -40
KPX ohungarumlaut v -15
KPX ohungarumlaut w -15
KPX ohungarumlaut x -30
KPX ohungarumlaut y -30
KPX ohungarumlaut yacute -30
KPX ohungarumlaut ydieresis -30
KPX omacron comma -40
KPX omacron period -40
KPX omacron v -15
KPX omacron w -15
KPX omacron x -30
KPX omacron y -30
KPX omacron yacute -30
KPX omacron ydieresis -30
KPX oslash a -55
KPX oslash aacute -55
KPX oslash abreve -55
KPX oslash acircumflex -55
KPX oslash adieresis -55
KPX oslash agrave -55
KPX oslash amacron -55
KPX oslash aogonek -55
KPX oslash aring -55
KPX oslash atilde -55
KPX oslash b -55
KPX oslash c -55
KPX oslash cacute -55
KPX oslash ccaron -55
KPX oslash ccedilla -55
KPX oslash comma -95
KPX oslash d -55
KPX oslash dcroat -55
KPX oslash e -55
KPX oslash eacute -55
KPX oslash ecaron -55
KPX oslash ecircumflex -55
KPX oslash edieresis -55
KPX oslash edotaccent -55
KPX oslash egrave -55
KPX oslash emacron -55
KPX oslash eogonek -55
KPX oslash f -55
KPX oslash g -55
KPX oslash gbreve -55
KPX oslash gcommaaccent -55
KPX oslash h -55
KPX oslash i -55
KPX oslash iacute -55
KPX oslash icircumflex -55
KPX oslash idieresis -55
KPX oslash igrave -55
KPX oslash imacron -55
KPX oslash iogonek -55
KPX oslash j -55
KPX oslash k -55
KPX oslash kcommaaccent -55
KPX oslash l -55
KPX oslash lacute -55
KPX oslash lcommaaccent -55
KPX oslash lslash -55
KPX oslash m -55
KPX oslash n -55
KPX oslash nacute -55
KPX oslash ncaron -55
KPX oslash ncommaaccent -55
KPX oslash ntilde -55
KPX oslash o -55
KPX oslash oacute -55
KPX oslash ocircumflex -55
KPX oslash odieresis -55
KPX oslash ograve -55
KPX oslash ohungarumlaut -55
KPX oslash omacron -55
KPX oslash oslash -55
KPX oslash otilde -55
KPX oslash p -55
KPX oslash period -95
KPX oslash q -55
KPX oslash r -55
KPX oslash racute -55
KPX oslash rcaron -55
KPX oslash rcommaaccent -55
KPX oslash s -55
KPX oslash sacute -55
KPX oslash scaron -55
KPX oslash scedilla -55
KPX oslash scommaaccent -55
KPX oslash t -55
KPX oslash tcommaaccent -55
KPX oslash u -55
KPX oslash uacute -55
KPX oslash ucircumflex -55
KPX oslash udieresis -55
KPX oslash ugrave -55
KPX oslash uhungarumlaut -55
KPX oslash umacron -55
KPX oslash uogonek -55
KPX oslash uring -55
KPX oslash v -70
KPX oslash w -70
KPX oslash x -85
KPX oslash y -70
KPX oslash yacute -70
KPX oslash ydieresis -70
KPX oslash z -55
KPX oslash zacute -55
KPX oslash zcaron -55
KPX oslash zdotaccent -55
KPX otilde comma -40
KPX otilde period -40
KPX otilde v -15
KPX otilde w -15
KPX otilde x -30
KPX otilde y -30
KPX otilde yacute -30
KPX otilde ydieresis -30
KPX p comma -35
KPX p period -35
KPX p y -30
KPX p yacute -30
KPX p ydieresis -30
KPX period quotedblright -100
KPX period quoteright -100
KPX period space -60
KPX quotedblright space -40
KPX quoteleft quoteleft -57
KPX quoteright d -50
KPX quoteright dcroat -50
KPX quoteright quoteright -57
KPX quoteright r -50
KPX quoteright racute -50
KPX quoteright rcaron -50
KPX quoteright rcommaaccent -50
KPX quoteright s -50
KPX quoteright sacute -50
KPX quoteright scaron -50
KPX quoteright scedilla -50
KPX quoteright scommaaccent -50
KPX quoteright space -70
KPX r a -10
KPX r aacute -10
KPX r abreve -10
KPX r acircumflex -10
KPX r adieresis -10
KPX r agrave -10
KPX r amacron -10
KPX r aogonek -10
KPX r aring -10
KPX r atilde -10
KPX r colon 30
KPX r comma -50
KPX r i 15
KPX r iacute 15
KPX r icircumflex 15
KPX r idieresis 15
KPX r igrave 15
KPX r imacron 15
KPX r iogonek 15
KPX r k 15
KPX r kcommaaccent 15
KPX r l 15
KPX r lacute 15
KPX r lcommaaccent 15
KPX r lslash 15
KPX r m 25
KPX r n 25
KPX r nacute 25
KPX r ncaron 25
KPX r ncommaaccent 25
KPX r ntilde 25
KPX r p 30
KPX r period -50
KPX r semicolon 30
KPX r t 40
KPX r tcommaaccent 40
KPX r u 15
KPX r uacute 15
KPX r ucircumflex 15
KPX r udieresis 15
KPX r ugrave 15
KPX r uhungarumlaut 15
KPX r umacron 15
KPX r uogonek 15
KPX r uring 15
KPX r v 30
KPX r y 30
KPX r yacute 30
KPX r ydieresis 30
KPX racute a -10
KPX racute aacute -10
KPX racute abreve -10
KPX racute acircumflex -10
KPX racute adieresis -10
KPX racute agrave -10
KPX racute amacron -10
KPX racute aogonek -10
KPX racute aring -10
KPX racute atilde -10
KPX racute colon 30
KPX racute comma -50
KPX racute i 15
KPX racute iacute 15
KPX racute icircumflex 15
KPX racute idieresis 15
KPX racute igrave 15
KPX racute imacron 15
KPX racute iogonek 15
KPX racute k 15
KPX racute kcommaaccent 15
KPX racute l 15
KPX racute lacute 15
KPX racute lcommaaccent 15
KPX racute lslash 15
KPX racute m 25
KPX racute n 25
KPX racute nacute 25
KPX racute ncaron 25
KPX racute ncommaaccent 25
KPX racute ntilde 25
KPX racute p 30
KPX racute period -50
KPX racute semicolon 30
KPX racute t 40
KPX racute tcommaaccent 40
KPX racute u 15
KPX racute uacute 15
KPX racute ucircumflex 15
KPX racute udieresis 15
KPX racute ugrave 15
KPX racute uhungarumlaut 15
KPX racute umacron 15
KPX racute uogonek 15
KPX racute uring 15
KPX racute v 30
KPX racute y 30
KPX racute yacute 30
KPX racute ydieresis 30
KPX rcaron a -10
KPX rcaron aacute -10
KPX rcaron abreve -10
KPX rcaron acircumflex -10
KPX rcaron adieresis -10
KPX rcaron agrave -10
KPX rcaron amacron -10
KPX rcaron aogonek -10
KPX rcaron aring -10
KPX rcaron atilde -10
KPX rcaron colon 30
KPX rcaron comma -50
KPX rcaron i 15
KPX rcaron iacute 15
KPX rcaron icircumflex 15
KPX rcaron idieresis 15
KPX rcaron igrave 15
KPX rcaron imacron 15
KPX rcaron iogonek 15
KPX rcaron k 15
KPX rcaron kcommaaccent 15
KPX rcaron l 15
KPX rcaron lacute 15
KPX rcaron lcommaaccent 15
KPX rcaron lslash 15
KPX rcaron m 25
KPX rcaron n 25
KPX rcaron nacute 25
KPX rcaron ncaron 25
KPX rcaron ncommaaccent 25
KPX rcaron ntilde 25
KPX rcaron p 30
KPX rcaron period -50
KPX rcaron semicolon 30
KPX rcaron t 40
KPX rcaron tcommaaccent 40
KPX rcaron u 15
KPX rcaron uacute 15
KPX rcaron ucircumflex 15
KPX rcaron udieresis 15
KPX rcaron ugrave 15
KPX rcaron uhungarumlaut 15
KPX rcaron umacron 15
KPX rcaron uogonek 15
KPX rcaron uring 15
KPX rcaron v 30
KPX rcaron y 30
KPX rcaron yacute 30
KPX rcaron ydieresis 30
KPX rcommaaccent a -10
KPX rcommaaccent aacute -10
KPX rcommaaccent abreve -10
KPX rcommaaccent acircumflex -10
KPX rcommaaccent adieresis -10
KPX rcommaaccent agrave -10
KPX rcommaaccent amacron -10
KPX rcommaaccent aogonek -10
KPX rcommaaccent aring -10
KPX rcommaaccent atilde -10
KPX rcommaaccent colon 30
KPX rcommaaccent comma -50
KPX rcommaaccent i 15
KPX rcommaaccent iacute 15
KPX rcommaaccent icircumflex 15
KPX rcommaaccent idieresis 15
KPX rcommaaccent igrave 15
KPX rcommaaccent imacron 15
KPX rcommaaccent iogonek 15
KPX rcommaaccent k 15
KPX rcommaaccent kcommaaccent 15
KPX rcommaaccent l 15
KPX rcommaaccent lacute 15
KPX rcommaaccent lcommaaccent 15
KPX rcommaaccent lslash 15
KPX rcommaaccent m 25
KPX rcommaaccent n 25
KPX rcommaaccent nacute 25
KPX rcommaaccent ncaron 25
KPX rcommaaccent ncommaaccent 25
KPX rcommaaccent ntilde 25
KPX rcommaaccent p 30
KPX rcommaaccent period -50
KPX rcommaaccent semicolon 30
KPX rcommaaccent t 40
KPX rcommaaccent tcommaaccent 40
KPX rcommaaccent u 15
KPX rcommaaccent uacute 15
KPX rcommaaccent ucircumflex 15
KPX rcommaaccent udieresis 15
KPX rcommaaccent ugrave 15
KPX rcommaaccent uhungarumlaut 15
KPX rcommaaccent umacron 15
KPX rcommaaccent uogonek 15
KPX rcommaaccent uring 15
KPX rcommaaccent v 30
KPX rcommaaccent y 30
KPX rcommaaccent yacute 30
KPX rcommaaccent ydieresis 30
KPX s comma -15
KPX s period -15
KPX s w -30
KPX sacute comma -15
KPX sacute period -15
KPX sacute w -30
KPX scaron comma -15
KPX scaron period -15
KPX scaron w -30
KPX scedilla comma -15
KPX scedilla period -15
KPX scedilla w -30
KPX scommaaccent comma -15
KPX scommaaccent period -15
KPX scommaaccent w -30
KPX semicolon space -50
KPX space T -50
KPX space Tcaron -50
KPX space Tcommaaccent -50
KPX space V -50
KPX space W -40
KPX space Y -90
KPX space Yacute -90
KPX space Ydieresis -90
KPX space quotedblleft -30
KPX space quoteleft -60
KPX v a -25
KPX v aacute -25
KPX v abreve -25
KPX v acircumflex -25
KPX v adieresis -25
KPX v agrave -25
KPX v amacron -25
KPX v aogonek -25
KPX v aring -25
KPX v atilde -25
KPX v comma -80
KPX v e -25
KPX v eacute -25
KPX v ecaron -25
KPX v ecircumflex -25
KPX v edieresis -25
KPX v edotaccent -25
KPX v egrave -25
KPX v emacron -25
KPX v eogonek -25
KPX v o -25
KPX v oacute -25
KPX v ocircumflex -25
KPX v odieresis -25
KPX v ograve -25
KPX v ohungarumlaut -25
KPX v omacron -25
KPX v oslash -25
KPX v otilde -25
KPX v period -80
KPX w a -15
KPX w aacute -15
KPX w abreve -15
KPX w acircumflex -15
KPX w adieresis -15
KPX w agrave -15
KPX w amacron -15
KPX w aogonek -15
KPX w aring -15
KPX w atilde -15
KPX w comma -60
KPX w e -10
KPX w eacute -10
KPX w ecaron -10
KPX w ecircumflex -10
KPX w edieresis -10
KPX w edotaccent -10
KPX w egrave -10
KPX w emacron -10
KPX w eogonek -10
KPX w o -10
KPX w oacute -10
KPX w ocircumflex -10
KPX w odieresis -10
KPX w ograve -10
KPX w ohungarumlaut -10
KPX w omacron -10
KPX w oslash -10
KPX w otilde -10
KPX w period -60
KPX x e -30
KPX x eacute -30
KPX x ecaron -30
KPX x ecircumflex -30
KPX x edieresis -30
KPX x edotaccent -30
KPX x egrave -30
KPX x emacron -30
KPX x eogonek -30
KPX y a -20
KPX y aacute -20
KPX y abreve -20
KPX y acircumflex -20
KPX y adieresis -20
KPX y agrave -20
KPX y amacron -20
KPX y aogonek -20
KPX y aring -20
KPX y atilde -20
KPX y comma -100
KPX y e -20
KPX y eacute -20
KPX y ecaron -20
KPX y ecircumflex -20
KPX y edieresis -20
KPX y edotaccent -20
KPX y egrave -20
KPX y emacron -20
KPX y eogonek -20
KPX y o -20
KPX y oacute -20
KPX y ocircumflex -20
KPX y odieresis -20
KPX y ograve -20
KPX y ohungarumlaut -20
KPX y omacron -20
KPX y oslash -20
KPX y otilde -20
KPX y period -100
KPX yacute a -20
KPX yacute aacute -20
KPX yacute abreve -20
KPX yacute acircumflex -20
KPX yacute adieresis -20
KPX yacute agrave -20
KPX yacute amacron -20
KPX yacute aogonek -20
KPX yacute aring -20
KPX yacute atilde -20
KPX yacute comma -100
KPX yacute e -20
KPX yacute eacute -20
KPX yacute ecaron -20
KPX yacute ecircumflex -20
KPX yacute edieresis -20
KPX yacute edotaccent -20
KPX yacute egrave -20
KPX yacute emacron -20
KPX yacute eogonek -20
KPX yacute o -20
KPX yacute oacute -20
KPX yacute ocircumflex -20
KPX yacute odieresis -20
KPX yacute ograve -20
KPX yacute ohungarumlaut -20
KPX yacute omacron -20
KPX yacute oslash -20
KPX yacute otilde -20
KPX yacute period -100
KPX ydieresis a -20
KPX ydieresis aacute -20
KPX ydieresis abreve -20
KPX ydieresis acircumflex -20
KPX ydieresis adieresis -20
KPX ydieresis agrave -20
KPX ydieresis amacron -20
KPX ydieresis aogonek -20
KPX ydieresis aring -20
KPX ydieresis atilde -20
KPX ydieresis comma -100
KPX ydieresis e -20
KPX ydieresis eacute -20
KPX ydieresis ecaron -20
KPX ydieresis ecircumflex -20
KPX ydieresis edieresis -20
KPX ydieresis edotaccent -20
KPX ydieresis egrave -20
KPX ydieresis emacron -20
KPX ydieresis eogonek -20
KPX ydieresis o -20
KPX ydieresis oacute -20
KPX ydieresis ocircumflex -20
KPX ydieresis odieresis -20
KPX ydieresis ograve -20
KPX ydieresis ohungarumlaut -20
KPX ydieresis omacron -20
KPX ydieresis oslash -20
KPX ydieresis otilde -20
KPX ydieresis period -100
KPX z e -15
KPX z eacute -15
KPX z ecaron -15
KPX z ecircumflex -15
KPX z edieresis -15
KPX z edotaccent -15
KPX z egrave -15
KPX z emacron -15
KPX z eogonek -15
KPX z o -15
KPX z oacute -15
KPX z ocircumflex -15
KPX z odieresis -15
KPX z ograve -15
KPX z ohungarumlaut -15
KPX z omacron -15
KPX z oslash -15
KPX z otilde -15
KPX zacute e -15
KPX zacute eacute -15
KPX zacute ecaron -15
KPX zacute ecircumflex -15
KPX zacute edieresis -15
KPX zacute edotaccent -15
KPX zacute egrave -15
KPX zacute emacron -15
KPX zacute eogonek -15
KPX zacute o -15
KPX zacute oacute -15
KPX zacute ocircumflex -15
KPX zacute odieresis -15
KPX zacute ograve -15
KPX zacute ohungarumlaut -15
KPX zacute omacron -15
KPX zacute oslash -15
KPX zacute otilde -15
KPX zcaron e -15
KPX zcaron eacute -15
KPX zcaron ecaron -15
KPX zcaron ecircumflex -15
KPX zcaron edieresis -15
KPX zcaron edotaccent -15
KPX zcaron egrave -15
KPX zcaron emacron -15
KPX zcaron eogonek -15
KPX zcaron o -15
KPX zcaron oacute -15
KPX zcaron ocircumflex -15
KPX zcaron odieresis -15
KPX zcaron ograve -15
KPX zcaron ohungarumlaut -15
KPX zcaron omacron -15
KPX zcaron oslash -15
KPX zcaron otilde -15
KPX zdotaccent e -15
KPX zdotaccent eacute -15
KPX zdotaccent ecaron -15
KPX zdotaccent ecircumflex -15
KPX zdotaccent edieresis -15
KPX zdotaccent edotaccent -15
KPX zdotaccent egrave -15
KPX zdotaccent emacron -15
KPX zdotaccent eogonek -15
KPX zdotaccent o -15
KPX zdotaccent oacute -15
KPX zdotaccent ocircumflex -15
KPX zdotaccent odieresis -15
KPX zdotaccent ograve -15
KPX zdotaccent ohungarumlaut -15
KPX zdotaccent omacron -15
KPX zdotaccent oslash -15
KPX zdotaccent otilde -15
EndKernPairs
EndKernData
EndFontMetrics"

let helvetica_bold_oblique_afm = "StartFontMetrics 4.1
Comment Copyright (c) 1985, 1987, 1989, 1990, 1997 Adobe Systems Incorporated.  All Rights Reserved.
Comment Creation Date: Thu May  1 12:45:12 1997
Comment UniqueID 43053
Comment VMusage 14482 68586
FontName Helvetica-BoldOblique
FullName Helvetica Bold Oblique
FamilyName Helvetica
Weight Bold
ItalicAngle -12
IsFixedPitch false
CharacterSet ExtendedRoman
FontBBox -174 -228 1114 962 
UnderlinePosition -100
UnderlineThickness 50
Version 002.000
Notice Copyright (c) 1985, 1987, 1989, 1990, 1997 Adobe Systems Incorporated.  All Rights Reserved.Helvetica is a trademark of Linotype-Hell AG and/or its subsidiaries.
EncodingScheme AdobeStandardEncoding
CapHeight 718
XHeight 532
Ascender 718
Descender -207
StdHW 118
StdVW 140
StartCharMetrics 315
C 32 ; WX 278 ; N space ; B 0 0 0 0 ;
C 33 ; WX 333 ; N exclam ; B 94 0 397 718 ;
C 34 ; WX 474 ; N quotedbl ; B 193 447 529 718 ;
C 35 ; WX 556 ; N numbersign ; B 60 0 644 698 ;
C 36 ; WX 556 ; N dollar ; B 67 -115 622 775 ;
C 37 ; WX 889 ; N percent ; B 136 -19 901 710 ;
C 38 ; WX 722 ; N ampersand ; B 89 -19 732 718 ;
C 39 ; WX 278 ; N quoteright ; B 167 445 362 718 ;
C 40 ; WX 333 ; N parenleft ; B 76 -208 470 734 ;
C 41 ; WX 333 ; N parenright ; B -25 -208 369 734 ;
C 42 ; WX 389 ; N asterisk ; B 146 387 481 718 ;
C 43 ; WX 584 ; N plus ; B 82 0 610 506 ;
C 44 ; WX 278 ; N comma ; B 28 -168 245 146 ;
C 45 ; WX 333 ; N hyphen ; B 73 215 379 345 ;
C 46 ; WX 278 ; N period ; B 64 0 245 146 ;
C 47 ; WX 278 ; N slash ; B -37 -19 468 737 ;
C 48 ; WX 556 ; N zero ; B 86 -19 617 710 ;
C 49 ; WX 556 ; N one ; B 173 0 529 710 ;
C 50 ; WX 556 ; N two ; B 26 0 619 710 ;
C 51 ; WX 556 ; N three ; B 65 -19 608 710 ;
C 52 ; WX 556 ; N four ; B 60 0 598 710 ;
C 53 ; WX 556 ; N five ; B 64 -19 636 698 ;
C 54 ; WX 556 ; N six ; B 85 -19 619 710 ;
C 55 ; WX 556 ; N seven ; B 125 0 676 698 ;
C 56 ; WX 556 ; N eight ; B 69 -19 616 710 ;
C 57 ; WX 556 ; N nine ; B 78 -19 615 710 ;
C 58 ; WX 333 ; N colon ; B 92 0 351 512 ;
C 59 ; WX 333 ; N semicolon ; B 56 -168 351 512 ;
C 60 ; WX 584 ; N less ; B 82 -8 655 514 ;
C 61 ; WX 584 ; N equal ; B 58 87 633 419 ;
C 62 ; WX 584 ; N greater ; B 36 -8 609 514 ;
C 63 ; WX 611 ; N question ; B 165 0 671 727 ;
C 64 ; WX 975 ; N at ; B 186 -19 954 737 ;
C 65 ; WX 722 ; N A ; B 20 0 702 718 ;
C 66 ; WX 722 ; N B ; B 76 0 764 718 ;
C 67 ; WX 722 ; N C ; B 107 -19 789 737 ;
C 68 ; WX 722 ; N D ; B 76 0 777 718 ;
C 69 ; WX 667 ; N E ; B 76 0 757 718 ;
C 70 ; WX 611 ; N F ; B 76 0 740 718 ;
C 71 ; WX 778 ; N G ; B 108 -19 817 737 ;
C 72 ; WX 722 ; N H ; B 71 0 804 718 ;
C 73 ; WX 278 ; N I ; B 64 0 367 718 ;
C 74 ; WX 556 ; N J ; B 60 -18 637 718 ;
C 75 ; WX 722 ; N K ; B 87 0 858 718 ;
C 76 ; WX 611 ; N L ; B 76 0 611 718 ;
C 77 ; WX 833 ; N M ; B 69 0 918 718 ;
C 78 ; WX 722 ; N N ; B 69 0 807 718 ;
C 79 ; WX 778 ; N O ; B 107 -19 823 737 ;
C 80 ; WX 667 ; N P ; B 76 0 738 718 ;
C 81 ; WX 778 ; N Q ; B 107 -52 823 737 ;
C 82 ; WX 722 ; N R ; B 76 0 778 718 ;
C 83 ; WX 667 ; N S ; B 81 -19 718 737 ;
C 84 ; WX 611 ; N T ; B 140 0 751 718 ;
C 85 ; WX 722 ; N U ; B 116 -19 804 718 ;
C 86 ; WX 667 ; N V ; B 172 0 801 718 ;
C 87 ; WX 944 ; N W ; B 169 0 1082 718 ;
C 88 ; WX 667 ; N X ; B 14 0 791 718 ;
C 89 ; WX 667 ; N Y ; B 168 0 806 718 ;
C 90 ; WX 611 ; N Z ; B 25 0 737 718 ;
C 91 ; WX 333 ; N bracketleft ; B 21 -196 462 722 ;
C 92 ; WX 278 ; N backslash ; B 124 -19 307 737 ;
C 93 ; WX 333 ; N bracketright ; B -18 -196 423 722 ;
C 94 ; WX 584 ; N asciicircum ; B 131 323 591 698 ;
C 95 ; WX 556 ; N underscore ; B -27 -125 540 -75 ;
C 96 ; WX 278 ; N quoteleft ; B 165 454 361 727 ;
C 97 ; WX 556 ; N a ; B 55 -14 583 546 ;
C 98 ; WX 611 ; N b ; B 61 -14 645 718 ;
C 99 ; WX 556 ; N c ; B 79 -14 599 546 ;
C 100 ; WX 611 ; N d ; B 82 -14 704 718 ;
C 101 ; WX 556 ; N e ; B 70 -14 593 546 ;
C 102 ; WX 333 ; N f ; B 87 0 469 727 ; L i fi ; L l fl ;
C 103 ; WX 611 ; N g ; B 38 -217 666 546 ;
C 104 ; WX 611 ; N h ; B 65 0 629 718 ;
C 105 ; WX 278 ; N i ; B 69 0 363 725 ;
C 106 ; WX 278 ; N j ; B -42 -214 363 725 ;
C 107 ; WX 556 ; N k ; B 69 0 670 718 ;
C 108 ; WX 278 ; N l ; B 69 0 362 718 ;
C 109 ; WX 889 ; N m ; B 64 0 909 546 ;
C 110 ; WX 611 ; N n ; B 65 0 629 546 ;
C 111 ; WX 611 ; N o ; B 82 -14 643 546 ;
C 112 ; WX 611 ; N p ; B 18 -207 645 546 ;
C 113 ; WX 611 ; N q ; B 80 -207 665 546 ;
C 114 ; WX 389 ; N r ; B 64 0 489 546 ;
C 115 ; WX 556 ; N s ; B 63 -14 584 546 ;
C 116 ; WX 333 ; N t ; B 100 -6 422 676 ;
C 117 ; WX 611 ; N u ; B 98 -14 658 532 ;
C 118 ; WX 556 ; N v ; B 126 0 656 532 ;
C 119 ; WX 778 ; N w ; B 123 0 882 532 ;
C 120 ; WX 556 ; N x ; B 15 0 648 532 ;
C 121 ; WX 556 ; N y ; B 42 -214 652 532 ;
C 122 ; WX 500 ; N z ; B 20 0 583 532 ;
C 123 ; WX 389 ; N braceleft ; B 94 -196 518 722 ;
C 124 ; WX 280 ; N bar ; B 36 -225 361 775 ;
C 125 ; WX 389 ; N braceright ; B -18 -196 407 722 ;
C 126 ; WX 584 ; N asciitilde ; B 115 163 577 343 ;
C 161 ; WX 333 ; N exclamdown ; B 50 -186 353 532 ;
C 162 ; WX 556 ; N cent ; B 79 -118 599 628 ;
C 163 ; WX 556 ; N sterling ; B 50 -16 635 718 ;
C 164 ; WX 167 ; N fraction ; B -174 -19 487 710 ;
C 165 ; WX 556 ; N yen ; B 60 0 713 698 ;
C 166 ; WX 556 ; N florin ; B -50 -210 669 737 ;
C 167 ; WX 556 ; N section ; B 61 -184 598 727 ;
C 168 ; WX 556 ; N currency ; B 27 76 680 636 ;
C 169 ; WX 238 ; N quotesingle ; B 165 447 321 718 ;
C 170 ; WX 500 ; N quotedblleft ; B 160 454 588 727 ;
C 171 ; WX 556 ; N guillemotleft ; B 135 76 571 484 ;
C 172 ; WX 333 ; N guilsinglleft ; B 130 76 353 484 ;
C 173 ; WX 333 ; N guilsinglright ; B 99 76 322 484 ;
C 174 ; WX 611 ; N fi ; B 87 0 696 727 ;
C 175 ; WX 611 ; N fl ; B 87 0 695 727 ;
C 177 ; WX 556 ; N endash ; B 48 227 627 333 ;
C 178 ; WX 556 ; N dagger ; B 118 -171 626 718 ;
C 179 ; WX 556 ; N daggerdbl ; B 46 -171 628 718 ;
C 180 ; WX 278 ; N periodcentered ; B 110 172 276 334 ;
C 182 ; WX 556 ; N paragraph ; B 98 -191 688 700 ;
C 183 ; WX 350 ; N bullet ; B 83 194 420 524 ;
C 184 ; WX 278 ; N quotesinglbase ; B 41 -146 236 127 ;
C 185 ; WX 500 ; N quotedblbase ; B 36 -146 463 127 ;
C 186 ; WX 500 ; N quotedblright ; B 162 445 589 718 ;
C 187 ; WX 556 ; N guillemotright ; B 104 76 540 484 ;
C 188 ; WX 1000 ; N ellipsis ; B 92 0 939 146 ;
C 189 ; WX 1000 ; N perthousand ; B 76 -19 1038 710 ;
C 191 ; WX 611 ; N questiondown ; B 53 -195 559 532 ;
C 193 ; WX 333 ; N grave ; B 136 604 353 750 ;
C 194 ; WX 333 ; N acute ; B 236 604 515 750 ;
C 195 ; WX 333 ; N circumflex ; B 118 604 471 750 ;
C 196 ; WX 333 ; N tilde ; B 113 610 507 737 ;
C 197 ; WX 333 ; N macron ; B 122 604 483 678 ;
C 198 ; WX 333 ; N breve ; B 156 604 494 750 ;
C 199 ; WX 333 ; N dotaccent ; B 235 614 385 729 ;
C 200 ; WX 333 ; N dieresis ; B 137 614 482 729 ;
C 202 ; WX 333 ; N ring ; B 200 568 420 776 ;
C 203 ; WX 333 ; N cedilla ; B -37 -228 220 0 ;
C 205 ; WX 333 ; N hungarumlaut ; B 137 604 645 750 ;
C 206 ; WX 333 ; N ogonek ; B 41 -228 264 0 ;
C 207 ; WX 333 ; N caron ; B 149 604 502 750 ;
C 208 ; WX 1000 ; N emdash ; B 48 227 1071 333 ;
C 225 ; WX 1000 ; N AE ; B 5 0 1100 718 ;
C 227 ; WX 370 ; N ordfeminine ; B 125 401 465 737 ;
C 232 ; WX 611 ; N Lslash ; B 34 0 611 718 ;
C 233 ; WX 778 ; N Oslash ; B 35 -27 894 745 ;
C 234 ; WX 1000 ; N OE ; B 99 -19 1114 737 ;
C 235 ; WX 365 ; N ordmasculine ; B 123 401 485 737 ;
C 241 ; WX 889 ; N ae ; B 56 -14 923 546 ;
C 245 ; WX 278 ; N dotlessi ; B 69 0 322 532 ;
C 248 ; WX 278 ; N lslash ; B 40 0 407 718 ;
C 249 ; WX 611 ; N oslash ; B 22 -29 701 560 ;
C 250 ; WX 944 ; N oe ; B 82 -14 977 546 ;
C 251 ; WX 611 ; N germandbls ; B 69 -14 657 731 ;
C -1 ; WX 278 ; N Idieresis ; B 64 0 494 915 ;
C -1 ; WX 556 ; N eacute ; B 70 -14 627 750 ;
C -1 ; WX 556 ; N abreve ; B 55 -14 606 750 ;
C -1 ; WX 611 ; N uhungarumlaut ; B 98 -14 784 750 ;
C -1 ; WX 556 ; N ecaron ; B 70 -14 614 750 ;
C -1 ; WX 667 ; N Ydieresis ; B 168 0 806 915 ;
C -1 ; WX 584 ; N divide ; B 82 -42 610 548 ;
C -1 ; WX 667 ; N Yacute ; B 168 0 806 936 ;
C -1 ; WX 722 ; N Acircumflex ; B 20 0 706 936 ;
C -1 ; WX 556 ; N aacute ; B 55 -14 627 750 ;
C -1 ; WX 722 ; N Ucircumflex ; B 116 -19 804 936 ;
C -1 ; WX 556 ; N yacute ; B 42 -214 652 750 ;
C -1 ; WX 556 ; N scommaaccent ; B 63 -228 584 546 ;
C -1 ; WX 556 ; N ecircumflex ; B 70 -14 593 750 ;
C -1 ; WX 722 ; N Uring ; B 116 -19 804 962 ;
C -1 ; WX 722 ; N Udieresis ; B 116 -19 804 915 ;
C -1 ; WX 556 ; N aogonek ; B 55 -224 583 546 ;
C -1 ; WX 722 ; N Uacute ; B 116 -19 804 936 ;
C -1 ; WX 611 ; N uogonek ; B 98 -228 658 532 ;
C -1 ; WX 667 ; N Edieresis ; B 76 0 757 915 ;
C -1 ; WX 722 ; N Dcroat ; B 62 0 777 718 ;
C -1 ; WX 250 ; N commaaccent ; B 16 -228 188 -50 ;
C -1 ; WX 737 ; N copyright ; B 56 -19 835 737 ;
C -1 ; WX 667 ; N Emacron ; B 76 0 757 864 ;
C -1 ; WX 556 ; N ccaron ; B 79 -14 614 750 ;
C -1 ; WX 556 ; N aring ; B 55 -14 583 776 ;
C -1 ; WX 722 ; N Ncommaaccent ; B 69 -228 807 718 ;
C -1 ; WX 278 ; N lacute ; B 69 0 528 936 ;
C -1 ; WX 556 ; N agrave ; B 55 -14 583 750 ;
C -1 ; WX 611 ; N Tcommaaccent ; B 140 -228 751 718 ;
C -1 ; WX 722 ; N Cacute ; B 107 -19 789 936 ;
C -1 ; WX 556 ; N atilde ; B 55 -14 619 737 ;
C -1 ; WX 667 ; N Edotaccent ; B 76 0 757 915 ;
C -1 ; WX 556 ; N scaron ; B 63 -14 614 750 ;
C -1 ; WX 556 ; N scedilla ; B 63 -228 584 546 ;
C -1 ; WX 278 ; N iacute ; B 69 0 488 750 ;
C -1 ; WX 494 ; N lozenge ; B 90 0 564 745 ;
C -1 ; WX 722 ; N Rcaron ; B 76 0 778 936 ;
C -1 ; WX 778 ; N Gcommaaccent ; B 108 -228 817 737 ;
C -1 ; WX 611 ; N ucircumflex ; B 98 -14 658 750 ;
C -1 ; WX 556 ; N acircumflex ; B 55 -14 583 750 ;
C -1 ; WX 722 ; N Amacron ; B 20 0 718 864 ;
C -1 ; WX 389 ; N rcaron ; B 64 0 530 750 ;
C -1 ; WX 556 ; N ccedilla ; B 79 -228 599 546 ;
C -1 ; WX 611 ; N Zdotaccent ; B 25 0 737 915 ;
C -1 ; WX 667 ; N Thorn ; B 76 0 716 718 ;
C -1 ; WX 778 ; N Omacron ; B 107 -19 823 864 ;
C -1 ; WX 722 ; N Racute ; B 76 0 778 936 ;
C -1 ; WX 667 ; N Sacute ; B 81 -19 722 936 ;
C -1 ; WX 743 ; N dcaron ; B 82 -14 903 718 ;
C -1 ; WX 722 ; N Umacron ; B 116 -19 804 864 ;
C -1 ; WX 611 ; N uring ; B 98 -14 658 776 ;
C -1 ; WX 333 ; N threesuperior ; B 91 271 441 710 ;
C -1 ; WX 778 ; N Ograve ; B 107 -19 823 936 ;
C -1 ; WX 722 ; N Agrave ; B 20 0 702 936 ;
C -1 ; WX 722 ; N Abreve ; B 20 0 729 936 ;
C -1 ; WX 584 ; N multiply ; B 57 1 635 505 ;
C -1 ; WX 611 ; N uacute ; B 98 -14 658 750 ;
C -1 ; WX 611 ; N Tcaron ; B 140 0 751 936 ;
C -1 ; WX 494 ; N partialdiff ; B 43 -21 585 750 ;
C -1 ; WX 556 ; N ydieresis ; B 42 -214 652 729 ;
C -1 ; WX 722 ; N Nacute ; B 69 0 807 936 ;
C -1 ; WX 278 ; N icircumflex ; B 69 0 444 750 ;
C -1 ; WX 667 ; N Ecircumflex ; B 76 0 757 936 ;
C -1 ; WX 556 ; N adieresis ; B 55 -14 594 729 ;
C -1 ; WX 556 ; N edieresis ; B 70 -14 594 729 ;
C -1 ; WX 556 ; N cacute ; B 79 -14 627 750 ;
C -1 ; WX 611 ; N nacute ; B 65 0 654 750 ;
C -1 ; WX 611 ; N umacron ; B 98 -14 658 678 ;
C -1 ; WX 722 ; N Ncaron ; B 69 0 807 936 ;
C -1 ; WX 278 ; N Iacute ; B 64 0 528 936 ;
C -1 ; WX 584 ; N plusminus ; B 40 0 625 506 ;
C -1 ; WX 280 ; N brokenbar ; B 52 -150 345 700 ;
C -1 ; WX 737 ; N registered ; B 55 -19 834 737 ;
C -1 ; WX 778 ; N Gbreve ; B 108 -19 817 936 ;
C -1 ; WX 278 ; N Idotaccent ; B 64 0 397 915 ;
C -1 ; WX 600 ; N summation ; B 14 -10 670 706 ;
C -1 ; WX 667 ; N Egrave ; B 76 0 757 936 ;
C -1 ; WX 389 ; N racute ; B 64 0 543 750 ;
C -1 ; WX 611 ; N omacron ; B 82 -14 643 678 ;
C -1 ; WX 611 ; N Zacute ; B 25 0 737 936 ;
C -1 ; WX 611 ; N Zcaron ; B 25 0 737 936 ;
C -1 ; WX 549 ; N greaterequal ; B 26 0 629 704 ;
C -1 ; WX 722 ; N Eth ; B 62 0 777 718 ;
C -1 ; WX 722 ; N Ccedilla ; B 107 -228 789 737 ;
C -1 ; WX 278 ; N lcommaaccent ; B 30 -228 362 718 ;
C -1 ; WX 389 ; N tcaron ; B 100 -6 608 878 ;
C -1 ; WX 556 ; N eogonek ; B 70 -228 593 546 ;
C -1 ; WX 722 ; N Uogonek ; B 116 -228 804 718 ;
C -1 ; WX 722 ; N Aacute ; B 20 0 750 936 ;
C -1 ; WX 722 ; N Adieresis ; B 20 0 716 915 ;
C -1 ; WX 556 ; N egrave ; B 70 -14 593 750 ;
C -1 ; WX 500 ; N zacute ; B 20 0 599 750 ;
C -1 ; WX 278 ; N iogonek ; B -14 -224 363 725 ;
C -1 ; WX 778 ; N Oacute ; B 107 -19 823 936 ;
C -1 ; WX 611 ; N oacute ; B 82 -14 654 750 ;
C -1 ; WX 556 ; N amacron ; B 55 -14 595 678 ;
C -1 ; WX 556 ; N sacute ; B 63 -14 627 750 ;
C -1 ; WX 278 ; N idieresis ; B 69 0 455 729 ;
C -1 ; WX 778 ; N Ocircumflex ; B 107 -19 823 936 ;
C -1 ; WX 722 ; N Ugrave ; B 116 -19 804 936 ;
C -1 ; WX 612 ; N Delta ; B 6 0 608 688 ;
C -1 ; WX 611 ; N thorn ; B 18 -208 645 718 ;
C -1 ; WX 333 ; N twosuperior ; B 69 283 449 710 ;
C -1 ; WX 778 ; N Odieresis ; B 107 -19 823 915 ;
C -1 ; WX 611 ; N mu ; B 22 -207 658 532 ;
C -1 ; WX 278 ; N igrave ; B 69 0 326 750 ;
C -1 ; WX 611 ; N ohungarumlaut ; B 82 -14 784 750 ;
C -1 ; WX 667 ; N Eogonek ; B 76 -224 757 718 ;
C -1 ; WX 611 ; N dcroat ; B 82 -14 789 718 ;
C -1 ; WX 834 ; N threequarters ; B 99 -19 839 710 ;
C -1 ; WX 667 ; N Scedilla ; B 81 -228 718 737 ;
C -1 ; WX 400 ; N lcaron ; B 69 0 561 718 ;
C -1 ; WX 722 ; N Kcommaaccent ; B 87 -228 858 718 ;
C -1 ; WX 611 ; N Lacute ; B 76 0 611 936 ;
C -1 ; WX 1000 ; N trademark ; B 179 306 1109 718 ;
C -1 ; WX 556 ; N edotaccent ; B 70 -14 593 729 ;
C -1 ; WX 278 ; N Igrave ; B 64 0 367 936 ;
C -1 ; WX 278 ; N Imacron ; B 64 0 496 864 ;
C -1 ; WX 611 ; N Lcaron ; B 76 0 643 718 ;
C -1 ; WX 834 ; N onehalf ; B 132 -19 858 710 ;
C -1 ; WX 549 ; N lessequal ; B 29 0 676 704 ;
C -1 ; WX 611 ; N ocircumflex ; B 82 -14 643 750 ;
C -1 ; WX 611 ; N ntilde ; B 65 0 646 737 ;
C -1 ; WX 722 ; N Uhungarumlaut ; B 116 -19 880 936 ;
C -1 ; WX 667 ; N Eacute ; B 76 0 757 936 ;
C -1 ; WX 556 ; N emacron ; B 70 -14 595 678 ;
C -1 ; WX 611 ; N gbreve ; B 38 -217 666 750 ;
C -1 ; WX 834 ; N onequarter ; B 132 -19 806 710 ;
C -1 ; WX 667 ; N Scaron ; B 81 -19 718 936 ;
C -1 ; WX 667 ; N Scommaaccent ; B 81 -228 718 737 ;
C -1 ; WX 778 ; N Ohungarumlaut ; B 107 -19 908 936 ;
C -1 ; WX 400 ; N degree ; B 175 426 467 712 ;
C -1 ; WX 611 ; N ograve ; B 82 -14 643 750 ;
C -1 ; WX 722 ; N Ccaron ; B 107 -19 789 936 ;
C -1 ; WX 611 ; N ugrave ; B 98 -14 658 750 ;
C -1 ; WX 549 ; N radical ; B 112 -46 689 850 ;
C -1 ; WX 722 ; N Dcaron ; B 76 0 777 936 ;
C -1 ; WX 389 ; N rcommaaccent ; B 26 -228 489 546 ;
C -1 ; WX 722 ; N Ntilde ; B 69 0 807 923 ;
C -1 ; WX 611 ; N otilde ; B 82 -14 646 737 ;
C -1 ; WX 722 ; N Rcommaaccent ; B 76 -228 778 718 ;
C -1 ; WX 611 ; N Lcommaaccent ; B 76 -228 611 718 ;
C -1 ; WX 722 ; N Atilde ; B 20 0 741 923 ;
C -1 ; WX 722 ; N Aogonek ; B 20 -224 702 718 ;
C -1 ; WX 722 ; N Aring ; B 20 0 702 962 ;
C -1 ; WX 778 ; N Otilde ; B 107 -19 823 923 ;
C -1 ; WX 500 ; N zdotaccent ; B 20 0 583 729 ;
C -1 ; WX 667 ; N Ecaron ; B 76 0 757 936 ;
C -1 ; WX 278 ; N Iogonek ; B -41 -228 367 718 ;
C -1 ; WX 556 ; N kcommaaccent ; B 69 -228 670 718 ;
C -1 ; WX 584 ; N minus ; B 82 197 610 309 ;
C -1 ; WX 278 ; N Icircumflex ; B 64 0 484 936 ;
C -1 ; WX 611 ; N ncaron ; B 65 0 641 750 ;
C -1 ; WX 333 ; N tcommaaccent ; B 58 -228 422 676 ;
C -1 ; WX 584 ; N logicalnot ; B 105 108 633 419 ;
C -1 ; WX 611 ; N odieresis ; B 82 -14 643 729 ;
C -1 ; WX 611 ; N udieresis ; B 98 -14 658 729 ;
C -1 ; WX 549 ; N notequal ; B 32 -49 630 570 ;
C -1 ; WX 611 ; N gcommaaccent ; B 38 -217 666 850 ;
C -1 ; WX 611 ; N eth ; B 82 -14 670 737 ;
C -1 ; WX 500 ; N zcaron ; B 20 0 586 750 ;
C -1 ; WX 611 ; N ncommaaccent ; B 65 -228 629 546 ;
C -1 ; WX 333 ; N onesuperior ; B 148 283 388 710 ;
C -1 ; WX 278 ; N imacron ; B 69 0 429 678 ;
C -1 ; WX 556 ; N Euro ; B 0 0 0 0 ;
EndCharMetrics
StartKernData
StartKernPairs 2481
KPX A C -40
KPX A Cacute -40
KPX A Ccaron -40
KPX A Ccedilla -40
KPX A G -50
KPX A Gbreve -50
KPX A Gcommaaccent -50
KPX A O -40
KPX A Oacute -40
KPX A Ocircumflex -40
KPX A Odieresis -40
KPX A Ograve -40
KPX A Ohungarumlaut -40
KPX A Omacron -40
KPX A Oslash -40
KPX A Otilde -40
KPX A Q -40
KPX A T -90
KPX A Tcaron -90
KPX A Tcommaaccent -90
KPX A U -50
KPX A Uacute -50
KPX A Ucircumflex -50
KPX A Udieresis -50
KPX A Ugrave -50
KPX A Uhungarumlaut -50
KPX A Umacron -50
KPX A Uogonek -50
KPX A Uring -50
KPX A V -80
KPX A W -60
KPX A Y -110
KPX A Yacute -110
KPX A Ydieresis -110
KPX A u -30
KPX A uacute -30
KPX A ucircumflex -30
KPX A udieresis -30
KPX A ugrave -30
KPX A uhungarumlaut -30
KPX A umacron -30
KPX A uogonek -30
KPX A uring -30
KPX A v -40
KPX A w -30
KPX A y -30
KPX A yacute -30
KPX A ydieresis -30
KPX Aacute C -40
KPX Aacute Cacute -40
KPX Aacute Ccaron -40
KPX Aacute Ccedilla -40
KPX Aacute G -50
KPX Aacute Gbreve -50
KPX Aacute Gcommaaccent -50
KPX Aacute O -40
KPX Aacute Oacute -40
KPX Aacute Ocircumflex -40
KPX Aacute Odieresis -40
KPX Aacute Ograve -40
KPX Aacute Ohungarumlaut -40
KPX Aacute Omacron -40
KPX Aacute Oslash -40
KPX Aacute Otilde -40
KPX Aacute Q -40
KPX Aacute T -90
KPX Aacute Tcaron -90
KPX Aacute Tcommaaccent -90
KPX Aacute U -50
KPX Aacute Uacute -50
KPX Aacute Ucircumflex -50
KPX Aacute Udieresis -50
KPX Aacute Ugrave -50
KPX Aacute Uhungarumlaut -50
KPX Aacute Umacron -50
KPX Aacute Uogonek -50
KPX Aacute Uring -50
KPX Aacute V -80
KPX Aacute W -60
KPX Aacute Y -110
KPX Aacute Yacute -110
KPX Aacute Ydieresis -110
KPX Aacute u -30
KPX Aacute uacute -30
KPX Aacute ucircumflex -30
KPX Aacute udieresis -30
KPX Aacute ugrave -30
KPX Aacute uhungarumlaut -30
KPX Aacute umacron -30
KPX Aacute uogonek -30
KPX Aacute uring -30
KPX Aacute v -40
KPX Aacute w -30
KPX Aacute y -30
KPX Aacute yacute -30
KPX Aacute ydieresis -30
KPX Abreve C -40
KPX Abreve Cacute -40
KPX Abreve Ccaron -40
KPX Abreve Ccedilla -40
KPX Abreve G -50
KPX Abreve Gbreve -50
KPX Abreve Gcommaaccent -50
KPX Abreve O -40
KPX Abreve Oacute -40
KPX Abreve Ocircumflex -40
KPX Abreve Odieresis -40
KPX Abreve Ograve -40
KPX Abreve Ohungarumlaut -40
KPX Abreve Omacron -40
KPX Abreve Oslash -40
KPX Abreve Otilde -40
KPX Abreve Q -40
KPX Abreve T -90
KPX Abreve Tcaron -90
KPX Abreve Tcommaaccent -90
KPX Abreve U -50
KPX Abreve Uacute -50
KPX Abreve Ucircumflex -50
KPX Abreve Udieresis -50
KPX Abreve Ugrave -50
KPX Abreve Uhungarumlaut -50
KPX Abreve Umacron -50
KPX Abreve Uogonek -50
KPX Abreve Uring -50
KPX Abreve V -80
KPX Abreve W -60
KPX Abreve Y -110
KPX Abreve Yacute -110
KPX Abreve Ydieresis -110
KPX Abreve u -30
KPX Abreve uacute -30
KPX Abreve ucircumflex -30
KPX Abreve udieresis -30
KPX Abreve ugrave -30
KPX Abreve uhungarumlaut -30
KPX Abreve umacron -30
KPX Abreve uogonek -30
KPX Abreve uring -30
KPX Abreve v -40
KPX Abreve w -30
KPX Abreve y -30
KPX Abreve yacute -30
KPX Abreve ydieresis -30
KPX Acircumflex C -40
KPX Acircumflex Cacute -40
KPX Acircumflex Ccaron -40
KPX Acircumflex Ccedilla -40
KPX Acircumflex G -50
KPX Acircumflex Gbreve -50
KPX Acircumflex Gcommaaccent -50
KPX Acircumflex O -40
KPX Acircumflex Oacute -40
KPX Acircumflex Ocircumflex -40
KPX Acircumflex Odieresis -40
KPX Acircumflex Ograve -40
KPX Acircumflex Ohungarumlaut -40
KPX Acircumflex Omacron -40
KPX Acircumflex Oslash -40
KPX Acircumflex Otilde -40
KPX Acircumflex Q -40
KPX Acircumflex T -90
KPX Acircumflex Tcaron -90
KPX Acircumflex Tcommaaccent -90
KPX Acircumflex U -50
KPX Acircumflex Uacute -50
KPX Acircumflex Ucircumflex -50
KPX Acircumflex Udieresis -50
KPX Acircumflex Ugrave -50
KPX Acircumflex Uhungarumlaut -50
KPX Acircumflex Umacron -50
KPX Acircumflex Uogonek -50
KPX Acircumflex Uring -50
KPX Acircumflex V -80
KPX Acircumflex W -60
KPX Acircumflex Y -110
KPX Acircumflex Yacute -110
KPX Acircumflex Ydieresis -110
KPX Acircumflex u -30
KPX Acircumflex uacute -30
KPX Acircumflex ucircumflex -30
KPX Acircumflex udieresis -30
KPX Acircumflex ugrave -30
KPX Acircumflex uhungarumlaut -30
KPX Acircumflex umacron -30
KPX Acircumflex uogonek -30
KPX Acircumflex uring -30
KPX Acircumflex v -40
KPX Acircumflex w -30
KPX Acircumflex y -30
KPX Acircumflex yacute -30
KPX Acircumflex ydieresis -30
KPX Adieresis C -40
KPX Adieresis Cacute -40
KPX Adieresis Ccaron -40
KPX Adieresis Ccedilla -40
KPX Adieresis G -50
KPX Adieresis Gbreve -50
KPX Adieresis Gcommaaccent -50
KPX Adieresis O -40
KPX Adieresis Oacute -40
KPX Adieresis Ocircumflex -40
KPX Adieresis Odieresis -40
KPX Adieresis Ograve -40
KPX Adieresis Ohungarumlaut -40
KPX Adieresis Omacron -40
KPX Adieresis Oslash -40
KPX Adieresis Otilde -40
KPX Adieresis Q -40
KPX Adieresis T -90
KPX Adieresis Tcaron -90
KPX Adieresis Tcommaaccent -90
KPX Adieresis U -50
KPX Adieresis Uacute -50
KPX Adieresis Ucircumflex -50
KPX Adieresis Udieresis -50
KPX Adieresis Ugrave -50
KPX Adieresis Uhungarumlaut -50
KPX Adieresis Umacron -50
KPX Adieresis Uogonek -50
KPX Adieresis Uring -50
KPX Adieresis V -80
KPX Adieresis W -60
KPX Adieresis Y -110
KPX Adieresis Yacute -110
KPX Adieresis Ydieresis -110
KPX Adieresis u -30
KPX Adieresis uacute -30
KPX Adieresis ucircumflex -30
KPX Adieresis udieresis -30
KPX Adieresis ugrave -30
KPX Adieresis uhungarumlaut -30
KPX Adieresis umacron -30
KPX Adieresis uogonek -30
KPX Adieresis uring -30
KPX Adieresis v -40
KPX Adieresis w -30
KPX Adieresis y -30
KPX Adieresis yacute -30
KPX Adieresis ydieresis -30
KPX Agrave C -40
KPX Agrave Cacute -40
KPX Agrave Ccaron -40
KPX Agrave Ccedilla -40
KPX Agrave G -50
KPX Agrave Gbreve -50
KPX Agrave Gcommaaccent -50
KPX Agrave O -40
KPX Agrave Oacute -40
KPX Agrave Ocircumflex -40
KPX Agrave Odieresis -40
KPX Agrave Ograve -40
KPX Agrave Ohungarumlaut -40
KPX Agrave Omacron -40
KPX Agrave Oslash -40
KPX Agrave Otilde -40
KPX Agrave Q -40
KPX Agrave T -90
KPX Agrave Tcaron -90
KPX Agrave Tcommaaccent -90
KPX Agrave U -50
KPX Agrave Uacute -50
KPX Agrave Ucircumflex -50
KPX Agrave Udieresis -50
KPX Agrave Ugrave -50
KPX Agrave Uhungarumlaut -50
KPX Agrave Umacron -50
KPX Agrave Uogonek -50
KPX Agrave Uring -50
KPX Agrave V -80
KPX Agrave W -60
KPX Agrave Y -110
KPX Agrave Yacute -110
KPX Agrave Ydieresis -110
KPX Agrave u -30
KPX Agrave uacute -30
KPX Agrave ucircumflex -30
KPX Agrave udieresis -30
KPX Agrave ugrave -30
KPX Agrave uhungarumlaut -30
KPX Agrave umacron -30
KPX Agrave uogonek -30
KPX Agrave uring -30
KPX Agrave v -40
KPX Agrave w -30
KPX Agrave y -30
KPX Agrave yacute -30
KPX Agrave ydieresis -30
KPX Amacron C -40
KPX Amacron Cacute -40
KPX Amacron Ccaron -40
KPX Amacron Ccedilla -40
KPX Amacron G -50
KPX Amacron Gbreve -50
KPX Amacron Gcommaaccent -50
KPX Amacron O -40
KPX Amacron Oacute -40
KPX Amacron Ocircumflex -40
KPX Amacron Odieresis -40
KPX Amacron Ograve -40
KPX Amacron Ohungarumlaut -40
KPX Amacron Omacron -40
KPX Amacron Oslash -40
KPX Amacron Otilde -40
KPX Amacron Q -40
KPX Amacron T -90
KPX Amacron Tcaron -90
KPX Amacron Tcommaaccent -90
KPX Amacron U -50
KPX Amacron Uacute -50
KPX Amacron Ucircumflex -50
KPX Amacron Udieresis -50
KPX Amacron Ugrave -50
KPX Amacron Uhungarumlaut -50
KPX Amacron Umacron -50
KPX Amacron Uogonek -50
KPX Amacron Uring -50
KPX Amacron V -80
KPX Amacron W -60
KPX Amacron Y -110
KPX Amacron Yacute -110
KPX Amacron Ydieresis -110
KPX Amacron u -30
KPX Amacron uacute -30
KPX Amacron ucircumflex -30
KPX Amacron udieresis -30
KPX Amacron ugrave -30
KPX Amacron uhungarumlaut -30
KPX Amacron umacron -30
KPX Amacron uogonek -30
KPX Amacron uring -30
KPX Amacron v -40
KPX Amacron w -30
KPX Amacron y -30
KPX Amacron yacute -30
KPX Amacron ydieresis -30
KPX Aogonek C -40
KPX Aogonek Cacute -40
KPX Aogonek Ccaron -40
KPX Aogonek Ccedilla -40
KPX Aogonek G -50
KPX Aogonek Gbreve -50
KPX Aogonek Gcommaaccent -50
KPX Aogonek O -40
KPX Aogonek Oacute -40
KPX Aogonek Ocircumflex -40
KPX Aogonek Odieresis -40
KPX Aogonek Ograve -40
KPX Aogonek Ohungarumlaut -40
KPX Aogonek Omacron -40
KPX Aogonek Oslash -40
KPX Aogonek Otilde -40
KPX Aogonek Q -40
KPX Aogonek T -90
KPX Aogonek Tcaron -90
KPX Aogonek Tcommaaccent -90
KPX Aogonek U -50
KPX Aogonek Uacute -50
KPX Aogonek Ucircumflex -50
KPX Aogonek Udieresis -50
KPX Aogonek Ugrave -50
KPX Aogonek Uhungarumlaut -50
KPX Aogonek Umacron -50
KPX Aogonek Uogonek -50
KPX Aogonek Uring -50
KPX Aogonek V -80
KPX Aogonek W -60
KPX Aogonek Y -110
KPX Aogonek Yacute -110
KPX Aogonek Ydieresis -110
KPX Aogonek u -30
KPX Aogonek uacute -30
KPX Aogonek ucircumflex -30
KPX Aogonek udieresis -30
KPX Aogonek ugrave -30
KPX Aogonek uhungarumlaut -30
KPX Aogonek umacron -30
KPX Aogonek uogonek -30
KPX Aogonek uring -30
KPX Aogonek v -40
KPX Aogonek w -30
KPX Aogonek y -30
KPX Aogonek yacute -30
KPX Aogonek ydieresis -30
KPX Aring C -40
KPX Aring Cacute -40
KPX Aring Ccaron -40
KPX Aring Ccedilla -40
KPX Aring G -50
KPX Aring Gbreve -50
KPX Aring Gcommaaccent -50
KPX Aring O -40
KPX Aring Oacute -40
KPX Aring Ocircumflex -40
KPX Aring Odieresis -40
KPX Aring Ograve -40
KPX Aring Ohungarumlaut -40
KPX Aring Omacron -40
KPX Aring Oslash -40
KPX Aring Otilde -40
KPX Aring Q -40
KPX Aring T -90
KPX Aring Tcaron -90
KPX Aring Tcommaaccent -90
KPX Aring U -50
KPX Aring Uacute -50
KPX Aring Ucircumflex -50
KPX Aring Udieresis -50
KPX Aring Ugrave -50
KPX Aring Uhungarumlaut -50
KPX Aring Umacron -50
KPX Aring Uogonek -50
KPX Aring Uring -50
KPX Aring V -80
KPX Aring W -60
KPX Aring Y -110
KPX Aring Yacute -110
KPX Aring Ydieresis -110
KPX Aring u -30
KPX Aring uacute -30
KPX Aring ucircumflex -30
KPX Aring udieresis -30
KPX Aring ugrave -30
KPX Aring uhungarumlaut -30
KPX Aring umacron -30
KPX Aring uogonek -30
KPX Aring uring -30
KPX Aring v -40
KPX Aring w -30
KPX Aring y -30
KPX Aring yacute -30
KPX Aring ydieresis -30
KPX Atilde C -40
KPX Atilde Cacute -40
KPX Atilde Ccaron -40
KPX Atilde Ccedilla -40
KPX Atilde G -50
KPX Atilde Gbreve -50
KPX Atilde Gcommaaccent -50
KPX Atilde O -40
KPX Atilde Oacute -40
KPX Atilde Ocircumflex -40
KPX Atilde Odieresis -40
KPX Atilde Ograve -40
KPX Atilde Ohungarumlaut -40
KPX Atilde Omacron -40
KPX Atilde Oslash -40
KPX Atilde Otilde -40
KPX Atilde Q -40
KPX Atilde T -90
KPX Atilde Tcaron -90
KPX Atilde Tcommaaccent -90
KPX Atilde U -50
KPX Atilde Uacute -50
KPX Atilde Ucircumflex -50
KPX Atilde Udieresis -50
KPX Atilde Ugrave -50
KPX Atilde Uhungarumlaut -50
KPX Atilde Umacron -50
KPX Atilde Uogonek -50
KPX Atilde Uring -50
KPX Atilde V -80
KPX Atilde W -60
KPX Atilde Y -110
KPX Atilde Yacute -110
KPX Atilde Ydieresis -110
KPX Atilde u -30
KPX Atilde uacute -30
KPX Atilde ucircumflex -30
KPX Atilde udieresis -30
KPX Atilde ugrave -30
KPX Atilde uhungarumlaut -30
KPX Atilde umacron -30
KPX Atilde uogonek -30
KPX Atilde uring -30
KPX Atilde v -40
KPX Atilde w -30
KPX Atilde y -30
KPX Atilde yacute -30
KPX Atilde ydieresis -30
KPX B A -30
KPX B Aacute -30
KPX B Abreve -30
KPX B Acircumflex -30
KPX B Adieresis -30
KPX B Agrave -30
KPX B Amacron -30
KPX B Aogonek -30
KPX B Aring -30
KPX B Atilde -30
KPX B U -10
KPX B Uacute -10
KPX B Ucircumflex -10
KPX B Udieresis -10
KPX B Ugrave -10
KPX B Uhungarumlaut -10
KPX B Umacron -10
KPX B Uogonek -10
KPX B Uring -10
KPX D A -40
KPX D Aacute -40
KPX D Abreve -40
KPX D Acircumflex -40
KPX D Adieresis -40
KPX D Agrave -40
KPX D Amacron -40
KPX D Aogonek -40
KPX D Aring -40
KPX D Atilde -40
KPX D V -40
KPX D W -40
KPX D Y -70
KPX D Yacute -70
KPX D Ydieresis -70
KPX D comma -30
KPX D period -30
KPX Dcaron A -40
KPX Dcaron Aacute -40
KPX Dcaron Abreve -40
KPX Dcaron Acircumflex -40
KPX Dcaron Adieresis -40
KPX Dcaron Agrave -40
KPX Dcaron Amacron -40
KPX Dcaron Aogonek -40
KPX Dcaron Aring -40
KPX Dcaron Atilde -40
KPX Dcaron V -40
KPX Dcaron W -40
KPX Dcaron Y -70
KPX Dcaron Yacute -70
KPX Dcaron Ydieresis -70
KPX Dcaron comma -30
KPX Dcaron period -30
KPX Dcroat A -40
KPX Dcroat Aacute -40
KPX Dcroat Abreve -40
KPX Dcroat Acircumflex -40
KPX Dcroat Adieresis -40
KPX Dcroat Agrave -40
KPX Dcroat Amacron -40
KPX Dcroat Aogonek -40
KPX Dcroat Aring -40
KPX Dcroat Atilde -40
KPX Dcroat V -40
KPX Dcroat W -40
KPX Dcroat Y -70
KPX Dcroat Yacute -70
KPX Dcroat Ydieresis -70
KPX Dcroat comma -30
KPX Dcroat period -30
KPX F A -80
KPX F Aacute -80
KPX F Abreve -80
KPX F Acircumflex -80
KPX F Adieresis -80
KPX F Agrave -80
KPX F Amacron -80
KPX F Aogonek -80
KPX F Aring -80
KPX F Atilde -80
KPX F a -20
KPX F aacute -20
KPX F abreve -20
KPX F acircumflex -20
KPX F adieresis -20
KPX F agrave -20
KPX F amacron -20
KPX F aogonek -20
KPX F aring -20
KPX F atilde -20
KPX F comma -100
KPX F period -100
KPX J A -20
KPX J Aacute -20
KPX J Abreve -20
KPX J Acircumflex -20
KPX J Adieresis -20
KPX J Agrave -20
KPX J Amacron -20
KPX J Aogonek -20
KPX J Aring -20
KPX J Atilde -20
KPX J comma -20
KPX J period -20
KPX J u -20
KPX J uacute -20
KPX J ucircumflex -20
KPX J udieresis -20
KPX J ugrave -20
KPX J uhungarumlaut -20
KPX J umacron -20
KPX J uogonek -20
KPX J uring -20
KPX K O -30
KPX K Oacute -30
KPX K Ocircumflex -30
KPX K Odieresis -30
KPX K Ograve -30
KPX K Ohungarumlaut -30
KPX K Omacron -30
KPX K Oslash -30
KPX K Otilde -30
KPX K e -15
KPX K eacute -15
KPX K ecaron -15
KPX K ecircumflex -15
KPX K edieresis -15
KPX K edotaccent -15
KPX K egrave -15
KPX K emacron -15
KPX K eogonek -15
KPX K o -35
KPX K oacute -35
KPX K ocircumflex -35
KPX K odieresis -35
KPX K ograve -35
KPX K ohungarumlaut -35
KPX K omacron -35
KPX K oslash -35
KPX K otilde -35
KPX K u -30
KPX K uacute -30
KPX K ucircumflex -30
KPX K udieresis -30
KPX K ugrave -30
KPX K uhungarumlaut -30
KPX K umacron -30
KPX K uogonek -30
KPX K uring -30
KPX K y -40
KPX K yacute -40
KPX K ydieresis -40
KPX Kcommaaccent O -30
KPX Kcommaaccent Oacute -30
KPX Kcommaaccent Ocircumflex -30
KPX Kcommaaccent Odieresis -30
KPX Kcommaaccent Ograve -30
KPX Kcommaaccent Ohungarumlaut -30
KPX Kcommaaccent Omacron -30
KPX Kcommaaccent Oslash -30
KPX Kcommaaccent Otilde -30
KPX Kcommaaccent e -15
KPX Kcommaaccent eacute -15
KPX Kcommaaccent ecaron -15
KPX Kcommaaccent ecircumflex -15
KPX Kcommaaccent edieresis -15
KPX Kcommaaccent edotaccent -15
KPX Kcommaaccent egrave -15
KPX Kcommaaccent emacron -15
KPX Kcommaaccent eogonek -15
KPX Kcommaaccent o -35
KPX Kcommaaccent oacute -35
KPX Kcommaaccent ocircumflex -35
KPX Kcommaaccent odieresis -35
KPX Kcommaaccent ograve -35
KPX Kcommaaccent ohungarumlaut -35
KPX Kcommaaccent omacron -35
KPX Kcommaaccent oslash -35
KPX Kcommaaccent otilde -35
KPX Kcommaaccent u -30
KPX Kcommaaccent uacute -30
KPX Kcommaaccent ucircumflex -30
KPX Kcommaaccent udieresis -30
KPX Kcommaaccent ugrave -30
KPX Kcommaaccent uhungarumlaut -30
KPX Kcommaaccent umacron -30
KPX Kcommaaccent uogonek -30
KPX Kcommaaccent uring -30
KPX Kcommaaccent y -40
KPX Kcommaaccent yacute -40
KPX Kcommaaccent ydieresis -40
KPX L T -90
KPX L Tcaron -90
KPX L Tcommaaccent -90
KPX L V -110
KPX L W -80
KPX L Y -120
KPX L Yacute -120
KPX L Ydieresis -120
KPX L quotedblright -140
KPX L quoteright -140
KPX L y -30
KPX L yacute -30
KPX L ydieresis -30
KPX Lacute T -90
KPX Lacute Tcaron -90
KPX Lacute Tcommaaccent -90
KPX Lacute V -110
KPX Lacute W -80
KPX Lacute Y -120
KPX Lacute Yacute -120
KPX Lacute Ydieresis -120
KPX Lacute quotedblright -140
KPX Lacute quoteright -140
KPX Lacute y -30
KPX Lacute yacute -30
KPX Lacute ydieresis -30
KPX Lcommaaccent T -90
KPX Lcommaaccent Tcaron -90
KPX Lcommaaccent Tcommaaccent -90
KPX Lcommaaccent V -110
KPX Lcommaaccent W -80
KPX Lcommaaccent Y -120
KPX Lcommaaccent Yacute -120
KPX Lcommaaccent Ydieresis -120
KPX Lcommaaccent quotedblright -140
KPX Lcommaaccent quoteright -140
KPX Lcommaaccent y -30
KPX Lcommaaccent yacute -30
KPX Lcommaaccent ydieresis -30
KPX Lslash T -90
KPX Lslash Tcaron -90
KPX Lslash Tcommaaccent -90
KPX Lslash V -110
KPX Lslash W -80
KPX Lslash Y -120
KPX Lslash Yacute -120
KPX Lslash Ydieresis -120
KPX Lslash quotedblright -140
KPX Lslash quoteright -140
KPX Lslash y -30
KPX Lslash yacute -30
KPX Lslash ydieresis -30
KPX O A -50
KPX O Aacute -50
KPX O Abreve -50
KPX O Acircumflex -50
KPX O Adieresis -50
KPX O Agrave -50
KPX O Amacron -50
KPX O Aogonek -50
KPX O Aring -50
KPX O Atilde -50
KPX O T -40
KPX O Tcaron -40
KPX O Tcommaaccent -40
KPX O V -50
KPX O W -50
KPX O X -50
KPX O Y -70
KPX O Yacute -70
KPX O Ydieresis -70
KPX O comma -40
KPX O period -40
KPX Oacute A -50
KPX Oacute Aacute -50
KPX Oacute Abreve -50
KPX Oacute Acircumflex -50
KPX Oacute Adieresis -50
KPX Oacute Agrave -50
KPX Oacute Amacron -50
KPX Oacute Aogonek -50
KPX Oacute Aring -50
KPX Oacute Atilde -50
KPX Oacute T -40
KPX Oacute Tcaron -40
KPX Oacute Tcommaaccent -40
KPX Oacute V -50
KPX Oacute W -50
KPX Oacute X -50
KPX Oacute Y -70
KPX Oacute Yacute -70
KPX Oacute Ydieresis -70
KPX Oacute comma -40
KPX Oacute period -40
KPX Ocircumflex A -50
KPX Ocircumflex Aacute -50
KPX Ocircumflex Abreve -50
KPX Ocircumflex Acircumflex -50
KPX Ocircumflex Adieresis -50
KPX Ocircumflex Agrave -50
KPX Ocircumflex Amacron -50
KPX Ocircumflex Aogonek -50
KPX Ocircumflex Aring -50
KPX Ocircumflex Atilde -50
KPX Ocircumflex T -40
KPX Ocircumflex Tcaron -40
KPX Ocircumflex Tcommaaccent -40
KPX Ocircumflex V -50
KPX Ocircumflex W -50
KPX Ocircumflex X -50
KPX Ocircumflex Y -70
KPX Ocircumflex Yacute -70
KPX Ocircumflex Ydieresis -70
KPX Ocircumflex comma -40
KPX Ocircumflex period -40
KPX Odieresis A -50
KPX Odieresis Aacute -50
KPX Odieresis Abreve -50
KPX Odieresis Acircumflex -50
KPX Odieresis Adieresis -50
KPX Odieresis Agrave -50
KPX Odieresis Amacron -50
KPX Odieresis Aogonek -50
KPX Odieresis Aring -50
KPX Odieresis Atilde -50
KPX Odieresis T -40
KPX Odieresis Tcaron -40
KPX Odieresis Tcommaaccent -40
KPX Odieresis V -50
KPX Odieresis W -50
KPX Odieresis X -50
KPX Odieresis Y -70
KPX Odieresis Yacute -70
KPX Odieresis Ydieresis -70
KPX Odieresis comma -40
KPX Odieresis period -40
KPX Ograve A -50
KPX Ograve Aacute -50
KPX Ograve Abreve -50
KPX Ograve Acircumflex -50
KPX Ograve Adieresis -50
KPX Ograve Agrave -50
KPX Ograve Amacron -50
KPX Ograve Aogonek -50
KPX Ograve Aring -50
KPX Ograve Atilde -50
KPX Ograve T -40
KPX Ograve Tcaron -40
KPX Ograve Tcommaaccent -40
KPX Ograve V -50
KPX Ograve W -50
KPX Ograve X -50
KPX Ograve Y -70
KPX Ograve Yacute -70
KPX Ograve Ydieresis -70
KPX Ograve comma -40
KPX Ograve period -40
KPX Ohungarumlaut A -50
KPX Ohungarumlaut Aacute -50
KPX Ohungarumlaut Abreve -50
KPX Ohungarumlaut Acircumflex -50
KPX Ohungarumlaut Adieresis -50
KPX Ohungarumlaut Agrave -50
KPX Ohungarumlaut Amacron -50
KPX Ohungarumlaut Aogonek -50
KPX Ohungarumlaut Aring -50
KPX Ohungarumlaut Atilde -50
KPX Ohungarumlaut T -40
KPX Ohungarumlaut Tcaron -40
KPX Ohungarumlaut Tcommaaccent -40
KPX Ohungarumlaut V -50
KPX Ohungarumlaut W -50
KPX Ohungarumlaut X -50
KPX Ohungarumlaut Y -70
KPX Ohungarumlaut Yacute -70
KPX Ohungarumlaut Ydieresis -70
KPX Ohungarumlaut comma -40
KPX Ohungarumlaut period -40
KPX Omacron A -50
KPX Omacron Aacute -50
KPX Omacron Abreve -50
KPX Omacron Acircumflex -50
KPX Omacron Adieresis -50
KPX Omacron Agrave -50
KPX Omacron Amacron -50
KPX Omacron Aogonek -50
KPX Omacron Aring -50
KPX Omacron Atilde -50
KPX Omacron T -40
KPX Omacron Tcaron -40
KPX Omacron Tcommaaccent -40
KPX Omacron V -50
KPX Omacron W -50
KPX Omacron X -50
KPX Omacron Y -70
KPX Omacron Yacute -70
KPX Omacron Ydieresis -70
KPX Omacron comma -40
KPX Omacron period -40
KPX Oslash A -50
KPX Oslash Aacute -50
KPX Oslash Abreve -50
KPX Oslash Acircumflex -50
KPX Oslash Adieresis -50
KPX Oslash Agrave -50
KPX Oslash Amacron -50
KPX Oslash Aogonek -50
KPX Oslash Aring -50
KPX Oslash Atilde -50
KPX Oslash T -40
KPX Oslash Tcaron -40
KPX Oslash Tcommaaccent -40
KPX Oslash V -50
KPX Oslash W -50
KPX Oslash X -50
KPX Oslash Y -70
KPX Oslash Yacute -70
KPX Oslash Ydieresis -70
KPX Oslash comma -40
KPX Oslash period -40
KPX Otilde A -50
KPX Otilde Aacute -50
KPX Otilde Abreve -50
KPX Otilde Acircumflex -50
KPX Otilde Adieresis -50
KPX Otilde Agrave -50
KPX Otilde Amacron -50
KPX Otilde Aogonek -50
KPX Otilde Aring -50
KPX Otilde Atilde -50
KPX Otilde T -40
KPX Otilde Tcaron -40
KPX Otilde Tcommaaccent -40
KPX Otilde V -50
KPX Otilde W -50
KPX Otilde X -50
KPX Otilde Y -70
KPX Otilde Yacute -70
KPX Otilde Ydieresis -70
KPX Otilde comma -40
KPX Otilde period -40
KPX P A -100
KPX P Aacute -100
KPX P Abreve -100
KPX P Acircumflex -100
KPX P Adieresis -100
KPX P Agrave -100
KPX P Amacron -100
KPX P Aogonek -100
KPX P Aring -100
KPX P Atilde -100
KPX P a -30
KPX P aacute -30
KPX P abreve -30
KPX P acircumflex -30
KPX P adieresis -30
KPX P agrave -30
KPX P amacron -30
KPX P aogonek -30
KPX P aring -30
KPX P atilde -30
KPX P comma -120
KPX P e -30
KPX P eacute -30
KPX P ecaron -30
KPX P ecircumflex -30
KPX P edieresis -30
KPX P edotaccent -30
KPX P egrave -30
KPX P emacron -30
KPX P eogonek -30
KPX P o -40
KPX P oacute -40
KPX P ocircumflex -40
KPX P odieresis -40
KPX P ograve -40
KPX P ohungarumlaut -40
KPX P omacron -40
KPX P oslash -40
KPX P otilde -40
KPX P period -120
KPX Q U -10
KPX Q Uacute -10
KPX Q Ucircumflex -10
KPX Q Udieresis -10
KPX Q Ugrave -10
KPX Q Uhungarumlaut -10
KPX Q Umacron -10
KPX Q Uogonek -10
KPX Q Uring -10
KPX Q comma 20
KPX Q period 20
KPX R O -20
KPX R Oacute -20
KPX R Ocircumflex -20
KPX R Odieresis -20
KPX R Ograve -20
KPX R Ohungarumlaut -20
KPX R Omacron -20
KPX R Oslash -20
KPX R Otilde -20
KPX R T -20
KPX R Tcaron -20
KPX R Tcommaaccent -20
KPX R U -20
KPX R Uacute -20
KPX R Ucircumflex -20
KPX R Udieresis -20
KPX R Ugrave -20
KPX R Uhungarumlaut -20
KPX R Umacron -20
KPX R Uogonek -20
KPX R Uring -20
KPX R V -50
KPX R W -40
KPX R Y -50
KPX R Yacute -50
KPX R Ydieresis -50
KPX Racute O -20
KPX Racute Oacute -20
KPX Racute Ocircumflex -20
KPX Racute Odieresis -20
KPX Racute Ograve -20
KPX Racute Ohungarumlaut -20
KPX Racute Omacron -20
KPX Racute Oslash -20
KPX Racute Otilde -20
KPX Racute T -20
KPX Racute Tcaron -20
KPX Racute Tcommaaccent -20
KPX Racute U -20
KPX Racute Uacute -20
KPX Racute Ucircumflex -20
KPX Racute Udieresis -20
KPX Racute Ugrave -20
KPX Racute Uhungarumlaut -20
KPX Racute Umacron -20
KPX Racute Uogonek -20
KPX Racute Uring -20
KPX Racute V -50
KPX Racute W -40
KPX Racute Y -50
KPX Racute Yacute -50
KPX Racute Ydieresis -50
KPX Rcaron O -20
KPX Rcaron Oacute -20
KPX Rcaron Ocircumflex -20
KPX Rcaron Odieresis -20
KPX Rcaron Ograve -20
KPX Rcaron Ohungarumlaut -20
KPX Rcaron Omacron -20
KPX Rcaron Oslash -20
KPX Rcaron Otilde -20
KPX Rcaron T -20
KPX Rcaron Tcaron -20
KPX Rcaron Tcommaaccent -20
KPX Rcaron U -20
KPX Rcaron Uacute -20
KPX Rcaron Ucircumflex -20
KPX Rcaron Udieresis -20
KPX Rcaron Ugrave -20
KPX Rcaron Uhungarumlaut -20
KPX Rcaron Umacron -20
KPX Rcaron Uogonek -20
KPX Rcaron Uring -20
KPX Rcaron V -50
KPX Rcaron W -40
KPX Rcaron Y -50
KPX Rcaron Yacute -50
KPX Rcaron Ydieresis -50
KPX Rcommaaccent O -20
KPX Rcommaaccent Oacute -20
KPX Rcommaaccent Ocircumflex -20
KPX Rcommaaccent Odieresis -20
KPX Rcommaaccent Ograve -20
KPX Rcommaaccent Ohungarumlaut -20
KPX Rcommaaccent Omacron -20
KPX Rcommaaccent Oslash -20
KPX Rcommaaccent Otilde -20
KPX Rcommaaccent T -20
KPX Rcommaaccent Tcaron -20
KPX Rcommaaccent Tcommaaccent -20
KPX Rcommaaccent U -20
KPX Rcommaaccent Uacute -20
KPX Rcommaaccent Ucircumflex -20
KPX Rcommaaccent Udieresis -20
KPX Rcommaaccent Ugrave -20
KPX Rcommaaccent Uhungarumlaut -20
KPX Rcommaaccent Umacron -20
KPX Rcommaaccent Uogonek -20
KPX Rcommaaccent Uring -20
KPX Rcommaaccent V -50
KPX Rcommaaccent W -40
KPX Rcommaaccent Y -50
KPX Rcommaaccent Yacute -50
KPX Rcommaaccent Ydieresis -50
KPX T A -90
KPX T Aacute -90
KPX T Abreve -90
KPX T Acircumflex -90
KPX T Adieresis -90
KPX T Agrave -90
KPX T Amacron -90
KPX T Aogonek -90
KPX T Aring -90
KPX T Atilde -90
KPX T O -40
KPX T Oacute -40
KPX T Ocircumflex -40
KPX T Odieresis -40
KPX T Ograve -40
KPX T Ohungarumlaut -40
KPX T Omacron -40
KPX T Oslash -40
KPX T Otilde -40
KPX T a -80
KPX T aacute -80
KPX T abreve -80
KPX T acircumflex -80
KPX T adieresis -80
KPX T agrave -80
KPX T amacron -80
KPX T aogonek -80
KPX T aring -80
KPX T atilde -80
KPX T colon -40
KPX T comma -80
KPX T e -60
KPX T eacute -60
KPX T ecaron -60
KPX T ecircumflex -60
KPX T edieresis -60
KPX T edotaccent -60
KPX T egrave -60
KPX T emacron -60
KPX T eogonek -60
KPX T hyphen -120
KPX T o -80
KPX T oacute -80
KPX T ocircumflex -80
KPX T odieresis -80
KPX T ograve -80
KPX T ohungarumlaut -80
KPX T omacron -80
KPX T oslash -80
KPX T otilde -80
KPX T period -80
KPX T r -80
KPX T racute -80
KPX T rcommaaccent -80
KPX T semicolon -40
KPX T u -90
KPX T uacute -90
KPX T ucircumflex -90
KPX T udieresis -90
KPX T ugrave -90
KPX T uhungarumlaut -90
KPX T umacron -90
KPX T uogonek -90
KPX T uring -90
KPX T w -60
KPX T y -60
KPX T yacute -60
KPX T ydieresis -60
KPX Tcaron A -90
KPX Tcaron Aacute -90
KPX Tcaron Abreve -90
KPX Tcaron Acircumflex -90
KPX Tcaron Adieresis -90
KPX Tcaron Agrave -90
KPX Tcaron Amacron -90
KPX Tcaron Aogonek -90
KPX Tcaron Aring -90
KPX Tcaron Atilde -90
KPX Tcaron O -40
KPX Tcaron Oacute -40
KPX Tcaron Ocircumflex -40
KPX Tcaron Odieresis -40
KPX Tcaron Ograve -40
KPX Tcaron Ohungarumlaut -40
KPX Tcaron Omacron -40
KPX Tcaron Oslash -40
KPX Tcaron Otilde -40
KPX Tcaron a -80
KPX Tcaron aacute -80
KPX Tcaron abreve -80
KPX Tcaron acircumflex -80
KPX Tcaron adieresis -80
KPX Tcaron agrave -80
KPX Tcaron amacron -80
KPX Tcaron aogonek -80
KPX Tcaron aring -80
KPX Tcaron atilde -80
KPX Tcaron colon -40
KPX Tcaron comma -80
KPX Tcaron e -60
KPX Tcaron eacute -60
KPX Tcaron ecaron -60
KPX Tcaron ecircumflex -60
KPX Tcaron edieresis -60
KPX Tcaron edotaccent -60
KPX Tcaron egrave -60
KPX Tcaron emacron -60
KPX Tcaron eogonek -60
KPX Tcaron hyphen -120
KPX Tcaron o -80
KPX Tcaron oacute -80
KPX Tcaron ocircumflex -80
KPX Tcaron odieresis -80
KPX Tcaron ograve -80
KPX Tcaron ohungarumlaut -80
KPX Tcaron omacron -80
KPX Tcaron oslash -80
KPX Tcaron otilde -80
KPX Tcaron period -80
KPX Tcaron r -80
KPX Tcaron racute -80
KPX Tcaron rcommaaccent -80
KPX Tcaron semicolon -40
KPX Tcaron u -90
KPX Tcaron uacute -90
KPX Tcaron ucircumflex -90
KPX Tcaron udieresis -90
KPX Tcaron ugrave -90
KPX Tcaron uhungarumlaut -90
KPX Tcaron umacron -90
KPX Tcaron uogonek -90
KPX Tcaron uring -90
KPX Tcaron w -60
KPX Tcaron y -60
KPX Tcaron yacute -60
KPX Tcaron ydieresis -60
KPX Tcommaaccent A -90
KPX Tcommaaccent Aacute -90
KPX Tcommaaccent Abreve -90
KPX Tcommaaccent Acircumflex -90
KPX Tcommaaccent Adieresis -90
KPX Tcommaaccent Agrave -90
KPX Tcommaaccent Amacron -90
KPX Tcommaaccent Aogonek -90
KPX Tcommaaccent Aring -90
KPX Tcommaaccent Atilde -90
KPX Tcommaaccent O -40
KPX Tcommaaccent Oacute -40
KPX Tcommaaccent Ocircumflex -40
KPX Tcommaaccent Odieresis -40
KPX Tcommaaccent Ograve -40
KPX Tcommaaccent Ohungarumlaut -40
KPX Tcommaaccent Omacron -40
KPX Tcommaaccent Oslash -40
KPX Tcommaaccent Otilde -40
KPX Tcommaaccent a -80
KPX Tcommaaccent aacute -80
KPX Tcommaaccent abreve -80
KPX Tcommaaccent acircumflex -80
KPX Tcommaaccent adieresis -80
KPX Tcommaaccent agrave -80
KPX Tcommaaccent amacron -80
KPX Tcommaaccent aogonek -80
KPX Tcommaaccent aring -80
KPX Tcommaaccent atilde -80
KPX Tcommaaccent colon -40
KPX Tcommaaccent comma -80
KPX Tcommaaccent e -60
KPX Tcommaaccent eacute -60
KPX Tcommaaccent ecaron -60
KPX Tcommaaccent ecircumflex -60
KPX Tcommaaccent edieresis -60
KPX Tcommaaccent edotaccent -60
KPX Tcommaaccent egrave -60
KPX Tcommaaccent emacron -60
KPX Tcommaaccent eogonek -60
KPX Tcommaaccent hyphen -120
KPX Tcommaaccent o -80
KPX Tcommaaccent oacute -80
KPX Tcommaaccent ocircumflex -80
KPX Tcommaaccent odieresis -80
KPX Tcommaaccent ograve -80
KPX Tcommaaccent ohungarumlaut -80
KPX Tcommaaccent omacron -80
KPX Tcommaaccent oslash -80
KPX Tcommaaccent otilde -80
KPX Tcommaaccent period -80
KPX Tcommaaccent r -80
KPX Tcommaaccent racute -80
KPX Tcommaaccent rcommaaccent -80
KPX Tcommaaccent semicolon -40
KPX Tcommaaccent u -90
KPX Tcommaaccent uacute -90
KPX Tcommaaccent ucircumflex -90
KPX Tcommaaccent udieresis -90
KPX Tcommaaccent ugrave -90
KPX Tcommaaccent uhungarumlaut -90
KPX Tcommaaccent umacron -90
KPX Tcommaaccent uogonek -90
KPX Tcommaaccent uring -90
KPX Tcommaaccent w -60
KPX Tcommaaccent y -60
KPX Tcommaaccent yacute -60
KPX Tcommaaccent ydieresis -60
KPX U A -50
KPX U Aacute -50
KPX U Abreve -50
KPX U Acircumflex -50
KPX U Adieresis -50
KPX U Agrave -50
KPX U Amacron -50
KPX U Aogonek -50
KPX U Aring -50
KPX U Atilde -50
KPX U comma -30
KPX U period -30
KPX Uacute A -50
KPX Uacute Aacute -50
KPX Uacute Abreve -50
KPX Uacute Acircumflex -50
KPX Uacute Adieresis -50
KPX Uacute Agrave -50
KPX Uacute Amacron -50
KPX Uacute Aogonek -50
KPX Uacute Aring -50
KPX Uacute Atilde -50
KPX Uacute comma -30
KPX Uacute period -30
KPX Ucircumflex A -50
KPX Ucircumflex Aacute -50
KPX Ucircumflex Abreve -50
KPX Ucircumflex Acircumflex -50
KPX Ucircumflex Adieresis -50
KPX Ucircumflex Agrave -50
KPX Ucircumflex Amacron -50
KPX Ucircumflex Aogonek -50
KPX Ucircumflex Aring -50
KPX Ucircumflex Atilde -50
KPX Ucircumflex comma -30
KPX Ucircumflex period -30
KPX Udieresis A -50
KPX Udieresis Aacute -50
KPX Udieresis Abreve -50
KPX Udieresis Acircumflex -50
KPX Udieresis Adieresis -50
KPX Udieresis Agrave -50
KPX Udieresis Amacron -50
KPX Udieresis Aogonek -50
KPX Udieresis Aring -50
KPX Udieresis Atilde -50
KPX Udieresis comma -30
KPX Udieresis period -30
KPX Ugrave A -50
KPX Ugrave Aacute -50
KPX Ugrave Abreve -50
KPX Ugrave Acircumflex -50
KPX Ugrave Adieresis -50
KPX Ugrave Agrave -50
KPX Ugrave Amacron -50
KPX Ugrave Aogonek -50
KPX Ugrave Aring -50
KPX Ugrave Atilde -50
KPX Ugrave comma -30
KPX Ugrave period -30
KPX Uhungarumlaut A -50
KPX Uhungarumlaut Aacute -50
KPX Uhungarumlaut Abreve -50
KPX Uhungarumlaut Acircumflex -50
KPX Uhungarumlaut Adieresis -50
KPX Uhungarumlaut Agrave -50
KPX Uhungarumlaut Amacron -50
KPX Uhungarumlaut Aogonek -50
KPX Uhungarumlaut Aring -50
KPX Uhungarumlaut Atilde -50
KPX Uhungarumlaut comma -30
KPX Uhungarumlaut period -30
KPX Umacron A -50
KPX Umacron Aacute -50
KPX Umacron Abreve -50
KPX Umacron Acircumflex -50
KPX Umacron Adieresis -50
KPX Umacron Agrave -50
KPX Umacron Amacron -50
KPX Umacron Aogonek -50
KPX Umacron Aring -50
KPX Umacron Atilde -50
KPX Umacron comma -30
KPX Umacron period -30
KPX Uogonek A -50
KPX Uogonek Aacute -50
KPX Uogonek Abreve -50
KPX Uogonek Acircumflex -50
KPX Uogonek Adieresis -50
KPX Uogonek Agrave -50
KPX Uogonek Amacron -50
KPX Uogonek Aogonek -50
KPX Uogonek Aring -50
KPX Uogonek Atilde -50
KPX Uogonek comma -30
KPX Uogonek period -30
KPX Uring A -50
KPX Uring Aacute -50
KPX Uring Abreve -50
KPX Uring Acircumflex -50
KPX Uring Adieresis -50
KPX Uring Agrave -50
KPX Uring Amacron -50
KPX Uring Aogonek -50
KPX Uring Aring -50
KPX Uring Atilde -50
KPX Uring comma -30
KPX Uring period -30
KPX V A -80
KPX V Aacute -80
KPX V Abreve -80
KPX V Acircumflex -80
KPX V Adieresis -80
KPX V Agrave -80
KPX V Amacron -80
KPX V Aogonek -80
KPX V Aring -80
KPX V Atilde -80
KPX V G -50
KPX V Gbreve -50
KPX V Gcommaaccent -50
KPX V O -50
KPX V Oacute -50
KPX V Ocircumflex -50
KPX V Odieresis -50
KPX V Ograve -50
KPX V Ohungarumlaut -50
KPX V Omacron -50
KPX V Oslash -50
KPX V Otilde -50
KPX V a -60
KPX V aacute -60
KPX V abreve -60
KPX V acircumflex -60
KPX V adieresis -60
KPX V agrave -60
KPX V amacron -60
KPX V aogonek -60
KPX V aring -60
KPX V atilde -60
KPX V colon -40
KPX V comma -120
KPX V e -50
KPX V eacute -50
KPX V ecaron -50
KPX V ecircumflex -50
KPX V edieresis -50
KPX V edotaccent -50
KPX V egrave -50
KPX V emacron -50
KPX V eogonek -50
KPX V hyphen -80
KPX V o -90
KPX V oacute -90
KPX V ocircumflex -90
KPX V odieresis -90
KPX V ograve -90
KPX V ohungarumlaut -90
KPX V omacron -90
KPX V oslash -90
KPX V otilde -90
KPX V period -120
KPX V semicolon -40
KPX V u -60
KPX V uacute -60
KPX V ucircumflex -60
KPX V udieresis -60
KPX V ugrave -60
KPX V uhungarumlaut -60
KPX V umacron -60
KPX V uogonek -60
KPX V uring -60
KPX W A -60
KPX W Aacute -60
KPX W Abreve -60
KPX W Acircumflex -60
KPX W Adieresis -60
KPX W Agrave -60
KPX W Amacron -60
KPX W Aogonek -60
KPX W Aring -60
KPX W Atilde -60
KPX W O -20
KPX W Oacute -20
KPX W Ocircumflex -20
KPX W Odieresis -20
KPX W Ograve -20
KPX W Ohungarumlaut -20
KPX W Omacron -20
KPX W Oslash -20
KPX W Otilde -20
KPX W a -40
KPX W aacute -40
KPX W abreve -40
KPX W acircumflex -40
KPX W adieresis -40
KPX W agrave -40
KPX W amacron -40
KPX W aogonek -40
KPX W aring -40
KPX W atilde -40
KPX W colon -10
KPX W comma -80
KPX W e -35
KPX W eacute -35
KPX W ecaron -35
KPX W ecircumflex -35
KPX W edieresis -35
KPX W edotaccent -35
KPX W egrave -35
KPX W emacron -35
KPX W eogonek -35
KPX W hyphen -40
KPX W o -60
KPX W oacute -60
KPX W ocircumflex -60
KPX W odieresis -60
KPX W ograve -60
KPX W ohungarumlaut -60
KPX W omacron -60
KPX W oslash -60
KPX W otilde -60
KPX W period -80
KPX W semicolon -10
KPX W u -45
KPX W uacute -45
KPX W ucircumflex -45
KPX W udieresis -45
KPX W ugrave -45
KPX W uhungarumlaut -45
KPX W umacron -45
KPX W uogonek -45
KPX W uring -45
KPX W y -20
KPX W yacute -20
KPX W ydieresis -20
KPX Y A -110
KPX Y Aacute -110
KPX Y Abreve -110
KPX Y Acircumflex -110
KPX Y Adieresis -110
KPX Y Agrave -110
KPX Y Amacron -110
KPX Y Aogonek -110
KPX Y Aring -110
KPX Y Atilde -110
KPX Y O -70
KPX Y Oacute -70
KPX Y Ocircumflex -70
KPX Y Odieresis -70
KPX Y Ograve -70
KPX Y Ohungarumlaut -70
KPX Y Omacron -70
KPX Y Oslash -70
KPX Y Otilde -70
KPX Y a -90
KPX Y aacute -90
KPX Y abreve -90
KPX Y acircumflex -90
KPX Y adieresis -90
KPX Y agrave -90
KPX Y amacron -90
KPX Y aogonek -90
KPX Y aring -90
KPX Y atilde -90
KPX Y colon -50
KPX Y comma -100
KPX Y e -80
KPX Y eacute -80
KPX Y ecaron -80
KPX Y ecircumflex -80
KPX Y edieresis -80
KPX Y edotaccent -80
KPX Y egrave -80
KPX Y emacron -80
KPX Y eogonek -80
KPX Y o -100
KPX Y oacute -100
KPX Y ocircumflex -100
KPX Y odieresis -100
KPX Y ograve -100
KPX Y ohungarumlaut -100
KPX Y omacron -100
KPX Y oslash -100
KPX Y otilde -100
KPX Y period -100
KPX Y semicolon -50
KPX Y u -100
KPX Y uacute -100
KPX Y ucircumflex -100
KPX Y udieresis -100
KPX Y ugrave -100
KPX Y uhungarumlaut -100
KPX Y umacron -100
KPX Y uogonek -100
KPX Y uring -100
KPX Yacute A -110
KPX Yacute Aacute -110
KPX Yacute Abreve -110
KPX Yacute Acircumflex -110
KPX Yacute Adieresis -110
KPX Yacute Agrave -110
KPX Yacute Amacron -110
KPX Yacute Aogonek -110
KPX Yacute Aring -110
KPX Yacute Atilde -110
KPX Yacute O -70
KPX Yacute Oacute -70
KPX Yacute Ocircumflex -70
KPX Yacute Odieresis -70
KPX Yacute Ograve -70
KPX Yacute Ohungarumlaut -70
KPX Yacute Omacron -70
KPX Yacute Oslash -70
KPX Yacute Otilde -70
KPX Yacute a -90
KPX Yacute aacute -90
KPX Yacute abreve -90
KPX Yacute acircumflex -90
KPX Yacute adieresis -90
KPX Yacute agrave -90
KPX Yacute amacron -90
KPX Yacute aogonek -90
KPX Yacute aring -90
KPX Yacute atilde -90
KPX Yacute colon -50
KPX Yacute comma -100
KPX Yacute e -80
KPX Yacute eacute -80
KPX Yacute ecaron -80
KPX Yacute ecircumflex -80
KPX Yacute edieresis -80
KPX Yacute edotaccent -80
KPX Yacute egrave -80
KPX Yacute emacron -80
KPX Yacute eogonek -80
KPX Yacute o -100
KPX Yacute oacute -100
KPX Yacute ocircumflex -100
KPX Yacute odieresis -100
KPX Yacute ograve -100
KPX Yacute ohungarumlaut -100
KPX Yacute omacron -100
KPX Yacute oslash -100
KPX Yacute otilde -100
KPX Yacute period -100
KPX Yacute semicolon -50
KPX Yacute u -100
KPX Yacute uacute -100
KPX Yacute ucircumflex -100
KPX Yacute udieresis -100
KPX Yacute ugrave -100
KPX Yacute uhungarumlaut -100
KPX Yacute umacron -100
KPX Yacute uogonek -100
KPX Yacute uring -100
KPX Ydieresis A -110
KPX Ydieresis Aacute -110
KPX Ydieresis Abreve -110
KPX Ydieresis Acircumflex -110
KPX Ydieresis Adieresis -110
KPX Ydieresis Agrave -110
KPX Ydieresis Amacron -110
KPX Ydieresis Aogonek -110
KPX Ydieresis Aring -110
KPX Ydieresis Atilde -110
KPX Ydieresis O -70
KPX Ydieresis Oacute -70
KPX Ydieresis Ocircumflex -70
KPX Ydieresis Odieresis -70
KPX Ydieresis Ograve -70
KPX Ydieresis Ohungarumlaut -70
KPX Ydieresis Omacron -70
KPX Ydieresis Oslash -70
KPX Ydieresis Otilde -70
KPX Ydieresis a -90
KPX Ydieresis aacute -90
KPX Ydieresis abreve -90
KPX Ydieresis acircumflex -90
KPX Ydieresis adieresis -90
KPX Ydieresis agrave -90
KPX Ydieresis amacron -90
KPX Ydieresis aogonek -90
KPX Ydieresis aring -90
KPX Ydieresis atilde -90
KPX Ydieresis colon -50
KPX Ydieresis comma -100
KPX Ydieresis e -80
KPX Ydieresis eacute -80
KPX Ydieresis ecaron -80
KPX Ydieresis ecircumflex -80
KPX Ydieresis edieresis -80
KPX Ydieresis edotaccent -80
KPX Ydieresis egrave -80
KPX Ydieresis emacron -80
KPX Ydieresis eogonek -80
KPX Ydieresis o -100
KPX Ydieresis oacute -100
KPX Ydieresis ocircumflex -100
KPX Ydieresis odieresis -100
KPX Ydieresis ograve -100
KPX Ydieresis ohungarumlaut -100
KPX Ydieresis omacron -100
KPX Ydieresis oslash -100
KPX Ydieresis otilde -100
KPX Ydieresis period -100
KPX Ydieresis semicolon -50
KPX Ydieresis u -100
KPX Ydieresis uacute -100
KPX Ydieresis ucircumflex -100
KPX Ydieresis udieresis -100
KPX Ydieresis ugrave -100
KPX Ydieresis uhungarumlaut -100
KPX Ydieresis umacron -100
KPX Ydieresis uogonek -100
KPX Ydieresis uring -100
KPX a g -10
KPX a gbreve -10
KPX a gcommaaccent -10
KPX a v -15
KPX a w -15
KPX a y -20
KPX a yacute -20
KPX a ydieresis -20
KPX aacute g -10
KPX aacute gbreve -10
KPX aacute gcommaaccent -10
KPX aacute v -15
KPX aacute w -15
KPX aacute y -20
KPX aacute yacute -20
KPX aacute ydieresis -20
KPX abreve g -10
KPX abreve gbreve -10
KPX abreve gcommaaccent -10
KPX abreve v -15
KPX abreve w -15
KPX abreve y -20
KPX abreve yacute -20
KPX abreve ydieresis -20
KPX acircumflex g -10
KPX acircumflex gbreve -10
KPX acircumflex gcommaaccent -10
KPX acircumflex v -15
KPX acircumflex w -15
KPX acircumflex y -20
KPX acircumflex yacute -20
KPX acircumflex ydieresis -20
KPX adieresis g -10
KPX adieresis gbreve -10
KPX adieresis gcommaaccent -10
KPX adieresis v -15
KPX adieresis w -15
KPX adieresis y -20
KPX adieresis yacute -20
KPX adieresis ydieresis -20
KPX agrave g -10
KPX agrave gbreve -10
KPX agrave gcommaaccent -10
KPX agrave v -15
KPX agrave w -15
KPX agrave y -20
KPX agrave yacute -20
KPX agrave ydieresis -20
KPX amacron g -10
KPX amacron gbreve -10
KPX amacron gcommaaccent -10
KPX amacron v -15
KPX amacron w -15
KPX amacron y -20
KPX amacron yacute -20
KPX amacron ydieresis -20
KPX aogonek g -10
KPX aogonek gbreve -10
KPX aogonek gcommaaccent -10
KPX aogonek v -15
KPX aogonek w -15
KPX aogonek y -20
KPX aogonek yacute -20
KPX aogonek ydieresis -20
KPX aring g -10
KPX aring gbreve -10
KPX aring gcommaaccent -10
KPX aring v -15
KPX aring w -15
KPX aring y -20
KPX aring yacute -20
KPX aring ydieresis -20
KPX atilde g -10
KPX atilde gbreve -10
KPX atilde gcommaaccent -10
KPX atilde v -15
KPX atilde w -15
KPX atilde y -20
KPX atilde yacute -20
KPX atilde ydieresis -20
KPX b l -10
KPX b lacute -10
KPX b lcommaaccent -10
KPX b lslash -10
KPX b u -20
KPX b uacute -20
KPX b ucircumflex -20
KPX b udieresis -20
KPX b ugrave -20
KPX b uhungarumlaut -20
KPX b umacron -20
KPX b uogonek -20
KPX b uring -20
KPX b v -20
KPX b y -20
KPX b yacute -20
KPX b ydieresis -20
KPX c h -10
KPX c k -20
KPX c kcommaaccent -20
KPX c l -20
KPX c lacute -20
KPX c lcommaaccent -20
KPX c lslash -20
KPX c y -10
KPX c yacute -10
KPX c ydieresis -10
KPX cacute h -10
KPX cacute k -20
KPX cacute kcommaaccent -20
KPX cacute l -20
KPX cacute lacute -20
KPX cacute lcommaaccent -20
KPX cacute lslash -20
KPX cacute y -10
KPX cacute yacute -10
KPX cacute ydieresis -10
KPX ccaron h -10
KPX ccaron k -20
KPX ccaron kcommaaccent -20
KPX ccaron l -20
KPX ccaron lacute -20
KPX ccaron lcommaaccent -20
KPX ccaron lslash -20
KPX ccaron y -10
KPX ccaron yacute -10
KPX ccaron ydieresis -10
KPX ccedilla h -10
KPX ccedilla k -20
KPX ccedilla kcommaaccent -20
KPX ccedilla l -20
KPX ccedilla lacute -20
KPX ccedilla lcommaaccent -20
KPX ccedilla lslash -20
KPX ccedilla y -10
KPX ccedilla yacute -10
KPX ccedilla ydieresis -10
KPX colon space -40
KPX comma quotedblright -120
KPX comma quoteright -120
KPX comma space -40
KPX d d -10
KPX d dcroat -10
KPX d v -15
KPX d w -15
KPX d y -15
KPX d yacute -15
KPX d ydieresis -15
KPX dcroat d -10
KPX dcroat dcroat -10
KPX dcroat v -15
KPX dcroat w -15
KPX dcroat y -15
KPX dcroat yacute -15
KPX dcroat ydieresis -15
KPX e comma 10
KPX e period 20
KPX e v -15
KPX e w -15
KPX e x -15
KPX e y -15
KPX e yacute -15
KPX e ydieresis -15
KPX eacute comma 10
KPX eacute period 20
KPX eacute v -15
KPX eacute w -15
KPX eacute x -15
KPX eacute y -15
KPX eacute yacute -15
KPX eacute ydieresis -15
KPX ecaron comma 10
KPX ecaron period 20
KPX ecaron v -15
KPX ecaron w -15
KPX ecaron x -15
KPX ecaron y -15
KPX ecaron yacute -15
KPX ecaron ydieresis -15
KPX ecircumflex comma 10
KPX ecircumflex period 20
KPX ecircumflex v -15
KPX ecircumflex w -15
KPX ecircumflex x -15
KPX ecircumflex y -15
KPX ecircumflex yacute -15
KPX ecircumflex ydieresis -15
KPX edieresis comma 10
KPX edieresis period 20
KPX edieresis v -15
KPX edieresis w -15
KPX edieresis x -15
KPX edieresis y -15
KPX edieresis yacute -15
KPX edieresis ydieresis -15
KPX edotaccent comma 10
KPX edotaccent period 20
KPX edotaccent v -15
KPX edotaccent w -15
KPX edotaccent x -15
KPX edotaccent y -15
KPX edotaccent yacute -15
KPX edotaccent ydieresis -15
KPX egrave comma 10
KPX egrave period 20
KPX egrave v -15
KPX egrave w -15
KPX egrave x -15
KPX egrave y -15
KPX egrave yacute -15
KPX egrave ydieresis -15
KPX emacron comma 10
KPX emacron period 20
KPX emacron v -15
KPX emacron w -15
KPX emacron x -15
KPX emacron y -15
KPX emacron yacute -15
KPX emacron ydieresis -15
KPX eogonek comma 10
KPX eogonek period 20
KPX eogonek v -15
KPX eogonek w -15
KPX eogonek x -15
KPX eogonek y -15
KPX eogonek yacute -15
KPX eogonek ydieresis -15
KPX f comma -10
KPX f e -10
KPX f eacute -10
KPX f ecaron -10
KPX f ecircumflex -10
KPX f edieresis -10
KPX f edotaccent -10
KPX f egrave -10
KPX f emacron -10
KPX f eogonek -10
KPX f o -20
KPX f oacute -20
KPX f ocircumflex -20
KPX f odieresis -20
KPX f ograve -20
KPX f ohungarumlaut -20
KPX f omacron -20
KPX f oslash -20
KPX f otilde -20
KPX f period -10
KPX f quotedblright 30
KPX f quoteright 30
KPX g e 10
KPX g eacute 10
KPX g ecaron 10
KPX g ecircumflex 10
KPX g edieresis 10
KPX g edotaccent 10
KPX g egrave 10
KPX g emacron 10
KPX g eogonek 10
KPX g g -10
KPX g gbreve -10
KPX g gcommaaccent -10
KPX gbreve e 10
KPX gbreve eacute 10
KPX gbreve ecaron 10
KPX gbreve ecircumflex 10
KPX gbreve edieresis 10
KPX gbreve edotaccent 10
KPX gbreve egrave 10
KPX gbreve emacron 10
KPX gbreve eogonek 10
KPX gbreve g -10
KPX gbreve gbreve -10
KPX gbreve gcommaaccent -10
KPX gcommaaccent e 10
KPX gcommaaccent eacute 10
KPX gcommaaccent ecaron 10
KPX gcommaaccent ecircumflex 10
KPX gcommaaccent edieresis 10
KPX gcommaaccent edotaccent 10
KPX gcommaaccent egrave 10
KPX gcommaaccent emacron 10
KPX gcommaaccent eogonek 10
KPX gcommaaccent g -10
KPX gcommaaccent gbreve -10
KPX gcommaaccent gcommaaccent -10
KPX h y -20
KPX h yacute -20
KPX h ydieresis -20
KPX k o -15
KPX k oacute -15
KPX k ocircumflex -15
KPX k odieresis -15
KPX k ograve -15
KPX k ohungarumlaut -15
KPX k omacron -15
KPX k oslash -15
KPX k otilde -15
KPX kcommaaccent o -15
KPX kcommaaccent oacute -15
KPX kcommaaccent ocircumflex -15
KPX kcommaaccent odieresis -15
KPX kcommaaccent ograve -15
KPX kcommaaccent ohungarumlaut -15
KPX kcommaaccent omacron -15
KPX kcommaaccent oslash -15
KPX kcommaaccent otilde -15
KPX l w -15
KPX l y -15
KPX l yacute -15
KPX l ydieresis -15
KPX lacute w -15
KPX lacute y -15
KPX lacute yacute -15
KPX lacute ydieresis -15
KPX lcommaaccent w -15
KPX lcommaaccent y -15
KPX lcommaaccent yacute -15
KPX lcommaaccent ydieresis -15
KPX lslash w -15
KPX lslash y -15
KPX lslash yacute -15
KPX lslash ydieresis -15
KPX m u -20
KPX m uacute -20
KPX m ucircumflex -20
KPX m udieresis -20
KPX m ugrave -20
KPX m uhungarumlaut -20
KPX m umacron -20
KPX m uogonek -20
KPX m uring -20
KPX m y -30
KPX m yacute -30
KPX m ydieresis -30
KPX n u -10
KPX n uacute -10
KPX n ucircumflex -10
KPX n udieresis -10
KPX n ugrave -10
KPX n uhungarumlaut -10
KPX n umacron -10
KPX n uogonek -10
KPX n uring -10
KPX n v -40
KPX n y -20
KPX n yacute -20
KPX n ydieresis -20
KPX nacute u -10
KPX nacute uacute -10
KPX nacute ucircumflex -10
KPX nacute udieresis -10
KPX nacute ugrave -10
KPX nacute uhungarumlaut -10
KPX nacute umacron -10
KPX nacute uogonek -10
KPX nacute uring -10
KPX nacute v -40
KPX nacute y -20
KPX nacute yacute -20
KPX nacute ydieresis -20
KPX ncaron u -10
KPX ncaron uacute -10
KPX ncaron ucircumflex -10
KPX ncaron udieresis -10
KPX ncaron ugrave -10
KPX ncaron uhungarumlaut -10
KPX ncaron umacron -10
KPX ncaron uogonek -10
KPX ncaron uring -10
KPX ncaron v -40
KPX ncaron y -20
KPX ncaron yacute -20
KPX ncaron ydieresis -20
KPX ncommaaccent u -10
KPX ncommaaccent uacute -10
KPX ncommaaccent ucircumflex -10
KPX ncommaaccent udieresis -10
KPX ncommaaccent ugrave -10
KPX ncommaaccent uhungarumlaut -10
KPX ncommaaccent umacron -10
KPX ncommaaccent uogonek -10
KPX ncommaaccent uring -10
KPX ncommaaccent v -40
KPX ncommaaccent y -20
KPX ncommaaccent yacute -20
KPX ncommaaccent ydieresis -20
KPX ntilde u -10
KPX ntilde uacute -10
KPX ntilde ucircumflex -10
KPX ntilde udieresis -10
KPX ntilde ugrave -10
KPX ntilde uhungarumlaut -10
KPX ntilde umacron -10
KPX ntilde uogonek -10
KPX ntilde uring -10
KPX ntilde v -40
KPX ntilde y -20
KPX ntilde yacute -20
KPX ntilde ydieresis -20
KPX o v -20
KPX o w -15
KPX o x -30
KPX o y -20
KPX o yacute -20
KPX o ydieresis -20
KPX oacute v -20
KPX oacute w -15
KPX oacute x -30
KPX oacute y -20
KPX oacute yacute -20
KPX oacute ydieresis -20
KPX ocircumflex v -20
KPX ocircumflex w -15
KPX ocircumflex x -30
KPX ocircumflex y -20
KPX ocircumflex yacute -20
KPX ocircumflex ydieresis -20
KPX odieresis v -20
KPX odieresis w -15
KPX odieresis x -30
KPX odieresis y -20
KPX odieresis yacute -20
KPX odieresis ydieresis -20
KPX ograve v -20
KPX ograve w -15
KPX ograve x -30
KPX ograve y -20
KPX ograve yacute -20
KPX ograve ydieresis -20
KPX ohungarumlaut v -20
KPX ohungarumlaut w -15
KPX ohungarumlaut x -30
KPX ohungarumlaut y -20
KPX ohungarumlaut yacute -20
KPX ohungarumlaut ydieresis -20
KPX omacron v -20
KPX omacron w -15
KPX omacron x -30
KPX omacron y -20
KPX omacron yacute -20
KPX omacron ydieresis -20
KPX oslash v -20
KPX oslash w -15
KPX oslash x -30
KPX oslash y -20
KPX oslash yacute -20
KPX oslash ydieresis -20
KPX otilde v -20
KPX otilde w -15
KPX otilde x -30
KPX otilde y -20
KPX otilde yacute -20
KPX otilde ydieresis -20
KPX p y -15
KPX p yacute -15
KPX p ydieresis -15
KPX period quotedblright -120
KPX period quoteright -120
KPX period space -40
KPX quotedblright space -80
KPX quoteleft quoteleft -46
KPX quoteright d -80
KPX quoteright dcroat -80
KPX quoteright l -20
KPX quoteright lacute -20
KPX quoteright lcommaaccent -20
KPX quoteright lslash -20
KPX quoteright quoteright -46
KPX quoteright r -40
KPX quoteright racute -40
KPX quoteright rcaron -40
KPX quoteright rcommaaccent -40
KPX quoteright s -60
KPX quoteright sacute -60
KPX quoteright scaron -60
KPX quoteright scedilla -60
KPX quoteright scommaaccent -60
KPX quoteright space -80
KPX quoteright v -20
KPX r c -20
KPX r cacute -20
KPX r ccaron -20
KPX r ccedilla -20
KPX r comma -60
KPX r d -20
KPX r dcroat -20
KPX r g -15
KPX r gbreve -15
KPX r gcommaaccent -15
KPX r hyphen -20
KPX r o -20
KPX r oacute -20
KPX r ocircumflex -20
KPX r odieresis -20
KPX r ograve -20
KPX r ohungarumlaut -20
KPX r omacron -20
KPX r oslash -20
KPX r otilde -20
KPX r period -60
KPX r q -20
KPX r s -15
KPX r sacute -15
KPX r scaron -15
KPX r scedilla -15
KPX r scommaaccent -15
KPX r t 20
KPX r tcommaaccent 20
KPX r v 10
KPX r y 10
KPX r yacute 10
KPX r ydieresis 10
KPX racute c -20
KPX racute cacute -20
KPX racute ccaron -20
KPX racute ccedilla -20
KPX racute comma -60
KPX racute d -20
KPX racute dcroat -20
KPX racute g -15
KPX racute gbreve -15
KPX racute gcommaaccent -15
KPX racute hyphen -20
KPX racute o -20
KPX racute oacute -20
KPX racute ocircumflex -20
KPX racute odieresis -20
KPX racute ograve -20
KPX racute ohungarumlaut -20
KPX racute omacron -20
KPX racute oslash -20
KPX racute otilde -20
KPX racute period -60
KPX racute q -20
KPX racute s -15
KPX racute sacute -15
KPX racute scaron -15
KPX racute scedilla -15
KPX racute scommaaccent -15
KPX racute t 20
KPX racute tcommaaccent 20
KPX racute v 10
KPX racute y 10
KPX racute yacute 10
KPX racute ydieresis 10
KPX rcaron c -20
KPX rcaron cacute -20
KPX rcaron ccaron -20
KPX rcaron ccedilla -20
KPX rcaron comma -60
KPX rcaron d -20
KPX rcaron dcroat -20
KPX rcaron g -15
KPX rcaron gbreve -15
KPX rcaron gcommaaccent -15
KPX rcaron hyphen -20
KPX rcaron o -20
KPX rcaron oacute -20
KPX rcaron ocircumflex -20
KPX rcaron odieresis -20
KPX rcaron ograve -20
KPX rcaron ohungarumlaut -20
KPX rcaron omacron -20
KPX rcaron oslash -20
KPX rcaron otilde -20
KPX rcaron period -60
KPX rcaron q -20
KPX rcaron s -15
KPX rcaron sacute -15
KPX rcaron scaron -15
KPX rcaron scedilla -15
KPX rcaron scommaaccent -15
KPX rcaron t 20
KPX rcaron tcommaaccent 20
KPX rcaron v 10
KPX rcaron y 10
KPX rcaron yacute 10
KPX rcaron ydieresis 10
KPX rcommaaccent c -20
KPX rcommaaccent cacute -20
KPX rcommaaccent ccaron -20
KPX rcommaaccent ccedilla -20
KPX rcommaaccent comma -60
KPX rcommaaccent d -20
KPX rcommaaccent dcroat -20
KPX rcommaaccent g -15
KPX rcommaaccent gbreve -15
KPX rcommaaccent gcommaaccent -15
KPX rcommaaccent hyphen -20
KPX rcommaaccent o -20
KPX rcommaaccent oacute -20
KPX rcommaaccent ocircumflex -20
KPX rcommaaccent odieresis -20
KPX rcommaaccent ograve -20
KPX rcommaaccent ohungarumlaut -20
KPX rcommaaccent omacron -20
KPX rcommaaccent oslash -20
KPX rcommaaccent otilde -20
KPX rcommaaccent period -60
KPX rcommaaccent q -20
KPX rcommaaccent s -15
KPX rcommaaccent sacute -15
KPX rcommaaccent scaron -15
KPX rcommaaccent scedilla -15
KPX rcommaaccent scommaaccent -15
KPX rcommaaccent t 20
KPX rcommaaccent tcommaaccent 20
KPX rcommaaccent v 10
KPX rcommaaccent y 10
KPX rcommaaccent yacute 10
KPX rcommaaccent ydieresis 10
KPX s w -15
KPX sacute w -15
KPX scaron w -15
KPX scedilla w -15
KPX scommaaccent w -15
KPX semicolon space -40
KPX space T -100
KPX space Tcaron -100
KPX space Tcommaaccent -100
KPX space V -80
KPX space W -80
KPX space Y -120
KPX space Yacute -120
KPX space Ydieresis -120
KPX space quotedblleft -80
KPX space quoteleft -60
KPX v a -20
KPX v aacute -20
KPX v abreve -20
KPX v acircumflex -20
KPX v adieresis -20
KPX v agrave -20
KPX v amacron -20
KPX v aogonek -20
KPX v aring -20
KPX v atilde -20
KPX v comma -80
KPX v o -30
KPX v oacute -30
KPX v ocircumflex -30
KPX v odieresis -30
KPX v ograve -30
KPX v ohungarumlaut -30
KPX v omacron -30
KPX v oslash -30
KPX v otilde -30
KPX v period -80
KPX w comma -40
KPX w o -20
KPX w oacute -20
KPX w ocircumflex -20
KPX w odieresis -20
KPX w ograve -20
KPX w ohungarumlaut -20
KPX w omacron -20
KPX w oslash -20
KPX w otilde -20
KPX w period -40
KPX x e -10
KPX x eacute -10
KPX x ecaron -10
KPX x ecircumflex -10
KPX x edieresis -10
KPX x edotaccent -10
KPX x egrave -10
KPX x emacron -10
KPX x eogonek -10
KPX y a -30
KPX y aacute -30
KPX y abreve -30
KPX y acircumflex -30
KPX y adieresis -30
KPX y agrave -30
KPX y amacron -30
KPX y aogonek -30
KPX y aring -30
KPX y atilde -30
KPX y comma -80
KPX y e -10
KPX y eacute -10
KPX y ecaron -10
KPX y ecircumflex -10
KPX y edieresis -10
KPX y edotaccent -10
KPX y egrave -10
KPX y emacron -10
KPX y eogonek -10
KPX y o -25
KPX y oacute -25
KPX y ocircumflex -25
KPX y odieresis -25
KPX y ograve -25
KPX y ohungarumlaut -25
KPX y omacron -25
KPX y oslash -25
KPX y otilde -25
KPX y period -80
KPX yacute a -30
KPX yacute aacute -30
KPX yacute abreve -30
KPX yacute acircumflex -30
KPX yacute adieresis -30
KPX yacute agrave -30
KPX yacute amacron -30
KPX yacute aogonek -30
KPX yacute aring -30
KPX yacute atilde -30
KPX yacute comma -80
KPX yacute e -10
KPX yacute eacute -10
KPX yacute ecaron -10
KPX yacute ecircumflex -10
KPX yacute edieresis -10
KPX yacute edotaccent -10
KPX yacute egrave -10
KPX yacute emacron -10
KPX yacute eogonek -10
KPX yacute o -25
KPX yacute oacute -25
KPX yacute ocircumflex -25
KPX yacute odieresis -25
KPX yacute ograve -25
KPX yacute ohungarumlaut -25
KPX yacute omacron -25
KPX yacute oslash -25
KPX yacute otilde -25
KPX yacute period -80
KPX ydieresis a -30
KPX ydieresis aacute -30
KPX ydieresis abreve -30
KPX ydieresis acircumflex -30
KPX ydieresis adieresis -30
KPX ydieresis agrave -30
KPX ydieresis amacron -30
KPX ydieresis aogonek -30
KPX ydieresis aring -30
KPX ydieresis atilde -30
KPX ydieresis comma -80
KPX ydieresis e -10
KPX ydieresis eacute -10
KPX ydieresis ecaron -10
KPX ydieresis ecircumflex -10
KPX ydieresis edieresis -10
KPX ydieresis edotaccent -10
KPX ydieresis egrave -10
KPX ydieresis emacron -10
KPX ydieresis eogonek -10
KPX ydieresis o -25
KPX ydieresis oacute -25
KPX ydieresis ocircumflex -25
KPX ydieresis odieresis -25
KPX ydieresis ograve -25
KPX ydieresis ohungarumlaut -25
KPX ydieresis omacron -25
KPX ydieresis oslash -25
KPX ydieresis otilde -25
KPX ydieresis period -80
KPX z e 10
KPX z eacute 10
KPX z ecaron 10
KPX z ecircumflex 10
KPX z edieresis 10
KPX z edotaccent 10
KPX z egrave 10
KPX z emacron 10
KPX z eogonek 10
KPX zacute e 10
KPX zacute eacute 10
KPX zacute ecaron 10
KPX zacute ecircumflex 10
KPX zacute edieresis 10
KPX zacute edotaccent 10
KPX zacute egrave 10
KPX zacute emacron 10
KPX zacute eogonek 10
KPX zcaron e 10
KPX zcaron eacute 10
KPX zcaron ecaron 10
KPX zcaron ecircumflex 10
KPX zcaron edieresis 10
KPX zcaron edotaccent 10
KPX zcaron egrave 10
KPX zcaron emacron 10
KPX zcaron eogonek 10
KPX zdotaccent e 10
KPX zdotaccent eacute 10
KPX zdotaccent ecaron 10
KPX zdotaccent ecircumflex 10
KPX zdotaccent edieresis 10
KPX zdotaccent edotaccent 10
KPX zdotaccent egrave 10
KPX zdotaccent emacron 10
KPX zdotaccent eogonek 10
EndKernPairs
EndKernData
EndFontMetrics"

let symbol_afm = "StartFontMetrics 4.1
Comment Copyright (c) 1985, 1987, 1989, 1990, 1997 Adobe Systems Incorporated. All rights reserved.
Comment Creation Date: Thu May  1 15:12:25 1997
Comment UniqueID 43064
Comment VMusage 30820 39997
FontName Symbol
FullName Symbol
FamilyName Symbol
Weight Medium
ItalicAngle 0
IsFixedPitch false
CharacterSet Special
FontBBox -180 -293 1090 1010 
UnderlinePosition -100
UnderlineThickness 50
Version 001.008
Notice Copyright (c) 1985, 1987, 1989, 1990, 1997 Adobe Systems Incorporated. All rights reserved.
EncodingScheme FontSpecific
StdHW 92
StdVW 85
StartCharMetrics 190
C 32 ; WX 250 ; N space ; B 0 0 0 0 ;
C 33 ; WX 333 ; N exclam ; B 128 -17 240 672 ;
C 34 ; WX 713 ; N universal ; B 31 0 681 705 ;
C 35 ; WX 500 ; N numbersign ; B 20 -16 481 673 ;
C 36 ; WX 549 ; N existential ; B 25 0 478 707 ;
C 37 ; WX 833 ; N percent ; B 63 -36 771 655 ;
C 38 ; WX 778 ; N ampersand ; B 41 -18 750 661 ;
C 39 ; WX 439 ; N suchthat ; B 48 -17 414 500 ;
C 40 ; WX 333 ; N parenleft ; B 53 -191 300 673 ;
C 41 ; WX 333 ; N parenright ; B 30 -191 277 673 ;
C 42 ; WX 500 ; N asteriskmath ; B 65 134 427 551 ;
C 43 ; WX 549 ; N plus ; B 10 0 539 533 ;
C 44 ; WX 250 ; N comma ; B 56 -152 194 104 ;
C 45 ; WX 549 ; N minus ; B 11 233 535 288 ;
C 46 ; WX 250 ; N period ; B 69 -17 181 95 ;
C 47 ; WX 278 ; N slash ; B 0 -18 254 646 ;
C 48 ; WX 500 ; N zero ; B 24 -14 476 685 ;
C 49 ; WX 500 ; N one ; B 117 0 390 673 ;
C 50 ; WX 500 ; N two ; B 25 0 475 685 ;
C 51 ; WX 500 ; N three ; B 43 -14 435 685 ;
C 52 ; WX 500 ; N four ; B 15 0 469 685 ;
C 53 ; WX 500 ; N five ; B 32 -14 445 690 ;
C 54 ; WX 500 ; N six ; B 34 -14 468 685 ;
C 55 ; WX 500 ; N seven ; B 24 -16 448 673 ;
C 56 ; WX 500 ; N eight ; B 56 -14 445 685 ;
C 57 ; WX 500 ; N nine ; B 30 -18 459 685 ;
C 58 ; WX 278 ; N colon ; B 81 -17 193 460 ;
C 59 ; WX 278 ; N semicolon ; B 83 -152 221 460 ;
C 60 ; WX 549 ; N less ; B 26 0 523 522 ;
C 61 ; WX 549 ; N equal ; B 11 141 537 390 ;
C 62 ; WX 549 ; N greater ; B 26 0 523 522 ;
C 63 ; WX 444 ; N question ; B 70 -17 412 686 ;
C 64 ; WX 549 ; N congruent ; B 11 0 537 475 ;
C 65 ; WX 722 ; N Alpha ; B 4 0 684 673 ;
C 66 ; WX 667 ; N Beta ; B 29 0 592 673 ;
C 67 ; WX 722 ; N Chi ; B -9 0 704 673 ;
C 68 ; WX 612 ; N Delta ; B 6 0 608 688 ;
C 69 ; WX 611 ; N Epsilon ; B 32 0 617 673 ;
C 70 ; WX 763 ; N Phi ; B 26 0 741 673 ;
C 71 ; WX 603 ; N Gamma ; B 24 0 609 673 ;
C 72 ; WX 722 ; N Eta ; B 39 0 729 673 ;
C 73 ; WX 333 ; N Iota ; B 32 0 316 673 ;
C 74 ; WX 631 ; N theta1 ; B 18 -18 623 689 ;
C 75 ; WX 722 ; N Kappa ; B 35 0 722 673 ;
C 76 ; WX 686 ; N Lambda ; B 6 0 680 688 ;
C 77 ; WX 889 ; N Mu ; B 28 0 887 673 ;
C 78 ; WX 722 ; N Nu ; B 29 -8 720 673 ;
C 79 ; WX 722 ; N Omicron ; B 41 -17 715 685 ;
C 80 ; WX 768 ; N Pi ; B 25 0 745 673 ;
C 81 ; WX 741 ; N Theta ; B 41 -17 715 685 ;
C 82 ; WX 556 ; N Rho ; B 28 0 563 673 ;
C 83 ; WX 592 ; N Sigma ; B 5 0 589 673 ;
C 84 ; WX 611 ; N Tau ; B 33 0 607 673 ;
C 85 ; WX 690 ; N Upsilon ; B -8 0 694 673 ;
C 86 ; WX 439 ; N sigma1 ; B 40 -233 436 500 ;
C 87 ; WX 768 ; N Omega ; B 34 0 736 688 ;
C 88 ; WX 645 ; N Xi ; B 40 0 599 673 ;
C 89 ; WX 795 ; N Psi ; B 15 0 781 684 ;
C 90 ; WX 611 ; N Zeta ; B 44 0 636 673 ;
C 91 ; WX 333 ; N bracketleft ; B 86 -155 299 674 ;
C 92 ; WX 863 ; N therefore ; B 163 0 701 487 ;
C 93 ; WX 333 ; N bracketright ; B 33 -155 246 674 ;
C 94 ; WX 658 ; N perpendicular ; B 15 0 652 674 ;
C 95 ; WX 500 ; N underscore ; B -2 -125 502 -75 ;
C 96 ; WX 500 ; N radicalex ; B 480 881 1090 917 ;
C 97 ; WX 631 ; N alpha ; B 41 -18 622 500 ;
C 98 ; WX 549 ; N beta ; B 61 -223 515 741 ;
C 99 ; WX 549 ; N chi ; B 12 -231 522 499 ;
C 100 ; WX 494 ; N delta ; B 40 -19 481 740 ;
C 101 ; WX 439 ; N epsilon ; B 22 -19 427 502 ;
C 102 ; WX 521 ; N phi ; B 28 -224 492 673 ;
C 103 ; WX 411 ; N gamma ; B 5 -225 484 499 ;
C 104 ; WX 603 ; N eta ; B 0 -202 527 514 ;
C 105 ; WX 329 ; N iota ; B 0 -17 301 503 ;
C 106 ; WX 603 ; N phi1 ; B 36 -224 587 499 ;
C 107 ; WX 549 ; N kappa ; B 33 0 558 501 ;
C 108 ; WX 549 ; N lambda ; B 24 -17 548 739 ;
C 109 ; WX 576 ; N mu ; B 33 -223 567 500 ;
C 110 ; WX 521 ; N nu ; B -9 -16 475 507 ;
C 111 ; WX 549 ; N omicron ; B 35 -19 501 499 ;
C 112 ; WX 549 ; N pi ; B 10 -19 530 487 ;
C 113 ; WX 521 ; N theta ; B 43 -17 485 690 ;
C 114 ; WX 549 ; N rho ; B 50 -230 490 499 ;
C 115 ; WX 603 ; N sigma ; B 30 -21 588 500 ;
C 116 ; WX 439 ; N tau ; B 10 -19 418 500 ;
C 117 ; WX 576 ; N upsilon ; B 7 -18 535 507 ;
C 118 ; WX 713 ; N omega1 ; B 12 -18 671 583 ;
C 119 ; WX 686 ; N omega ; B 42 -17 684 500 ;
C 120 ; WX 493 ; N xi ; B 27 -224 469 766 ;
C 121 ; WX 686 ; N psi ; B 12 -228 701 500 ;
C 122 ; WX 494 ; N zeta ; B 60 -225 467 756 ;
C 123 ; WX 480 ; N braceleft ; B 58 -183 397 673 ;
C 124 ; WX 200 ; N bar ; B 65 -293 135 707 ;
C 125 ; WX 480 ; N braceright ; B 79 -183 418 673 ;
C 126 ; WX 549 ; N similar ; B 17 203 529 307 ;
C 160 ; WX 750 ; N Euro ; B 20 -12 714 685 ;
C 161 ; WX 620 ; N Upsilon1 ; B -2 0 610 685 ;
C 162 ; WX 247 ; N minute ; B 27 459 228 735 ;
C 163 ; WX 549 ; N lessequal ; B 29 0 526 639 ;
C 164 ; WX 167 ; N fraction ; B -180 -12 340 677 ;
C 165 ; WX 713 ; N infinity ; B 26 124 688 404 ;
C 166 ; WX 500 ; N florin ; B 2 -193 494 686 ;
C 167 ; WX 753 ; N club ; B 86 -26 660 533 ;
C 168 ; WX 753 ; N diamond ; B 142 -36 600 550 ;
C 169 ; WX 753 ; N heart ; B 117 -33 631 532 ;
C 170 ; WX 753 ; N spade ; B 113 -36 629 548 ;
C 171 ; WX 1042 ; N arrowboth ; B 24 -15 1024 511 ;
C 172 ; WX 987 ; N arrowleft ; B 32 -15 942 511 ;
C 173 ; WX 603 ; N arrowup ; B 45 0 571 910 ;
C 174 ; WX 987 ; N arrowright ; B 49 -15 959 511 ;
C 175 ; WX 603 ; N arrowdown ; B 45 -22 571 888 ;
C 176 ; WX 400 ; N degree ; B 50 385 350 685 ;
C 177 ; WX 549 ; N plusminus ; B 10 0 539 645 ;
C 178 ; WX 411 ; N second ; B 20 459 413 737 ;
C 179 ; WX 549 ; N greaterequal ; B 29 0 526 639 ;
C 180 ; WX 549 ; N multiply ; B 17 8 533 524 ;
C 181 ; WX 713 ; N proportional ; B 27 123 639 404 ;
C 182 ; WX 494 ; N partialdiff ; B 26 -20 462 746 ;
C 183 ; WX 460 ; N bullet ; B 50 113 410 473 ;
C 184 ; WX 549 ; N divide ; B 10 71 536 456 ;
C 185 ; WX 549 ; N notequal ; B 15 -25 540 549 ;
C 186 ; WX 549 ; N equivalence ; B 14 82 538 443 ;
C 187 ; WX 549 ; N approxequal ; B 14 135 527 394 ;
C 188 ; WX 1000 ; N ellipsis ; B 111 -17 889 95 ;
C 189 ; WX 603 ; N arrowvertex ; B 280 -120 336 1010 ;
C 190 ; WX 1000 ; N arrowhorizex ; B -60 220 1050 276 ;
C 191 ; WX 658 ; N carriagereturn ; B 15 -16 602 629 ;
C 192 ; WX 823 ; N aleph ; B 175 -18 661 658 ;
C 193 ; WX 686 ; N Ifraktur ; B 10 -53 578 740 ;
C 194 ; WX 795 ; N Rfraktur ; B 26 -15 759 734 ;
C 195 ; WX 987 ; N weierstrass ; B 159 -211 870 573 ;
C 196 ; WX 768 ; N circlemultiply ; B 43 -17 733 673 ;
C 197 ; WX 768 ; N circleplus ; B 43 -15 733 675 ;
C 198 ; WX 823 ; N emptyset ; B 39 -24 781 719 ;
C 199 ; WX 768 ; N intersection ; B 40 0 732 509 ;
C 200 ; WX 768 ; N union ; B 40 -17 732 492 ;
C 201 ; WX 713 ; N propersuperset ; B 20 0 673 470 ;
C 202 ; WX 713 ; N reflexsuperset ; B 20 -125 673 470 ;
C 203 ; WX 713 ; N notsubset ; B 36 -70 690 540 ;
C 204 ; WX 713 ; N propersubset ; B 37 0 690 470 ;
C 205 ; WX 713 ; N reflexsubset ; B 37 -125 690 470 ;
C 206 ; WX 713 ; N element ; B 45 0 505 468 ;
C 207 ; WX 713 ; N notelement ; B 45 -58 505 555 ;
C 208 ; WX 768 ; N angle ; B 26 0 738 673 ;
C 209 ; WX 713 ; N gradient ; B 36 -19 681 718 ;
C 210 ; WX 790 ; N registerserif ; B 50 -17 740 673 ;
C 211 ; WX 790 ; N copyrightserif ; B 51 -15 741 675 ;
C 212 ; WX 890 ; N trademarkserif ; B 18 293 855 673 ;
C 213 ; WX 823 ; N product ; B 25 -101 803 751 ;
C 214 ; WX 549 ; N radical ; B 10 -38 515 917 ;
C 215 ; WX 250 ; N dotmath ; B 69 210 169 310 ;
C 216 ; WX 713 ; N logicalnot ; B 15 0 680 288 ;
C 217 ; WX 603 ; N logicaland ; B 23 0 583 454 ;
C 218 ; WX 603 ; N logicalor ; B 30 0 578 477 ;
C 219 ; WX 1042 ; N arrowdblboth ; B 27 -20 1023 510 ;
C 220 ; WX 987 ; N arrowdblleft ; B 30 -15 939 513 ;
C 221 ; WX 603 ; N arrowdblup ; B 39 2 567 911 ;
C 222 ; WX 987 ; N arrowdblright ; B 45 -20 954 508 ;
C 223 ; WX 603 ; N arrowdbldown ; B 44 -19 572 890 ;
C 224 ; WX 494 ; N lozenge ; B 18 0 466 745 ;
C 225 ; WX 329 ; N angleleft ; B 25 -198 306 746 ;
C 226 ; WX 790 ; N registersans ; B 50 -20 740 670 ;
C 227 ; WX 790 ; N copyrightsans ; B 49 -15 739 675 ;
C 228 ; WX 786 ; N trademarksans ; B 5 293 725 673 ;
C 229 ; WX 713 ; N summation ; B 14 -108 695 752 ;
C 230 ; WX 384 ; N parenlefttp ; B 24 -293 436 926 ;
C 231 ; WX 384 ; N parenleftex ; B 24 -85 108 925 ;
C 232 ; WX 384 ; N parenleftbt ; B 24 -293 436 926 ;
C 233 ; WX 384 ; N bracketlefttp ; B 0 -80 349 926 ;
C 234 ; WX 384 ; N bracketleftex ; B 0 -79 77 925 ;
C 235 ; WX 384 ; N bracketleftbt ; B 0 -80 349 926 ;
C 236 ; WX 494 ; N bracelefttp ; B 209 -85 445 925 ;
C 237 ; WX 494 ; N braceleftmid ; B 20 -85 284 935 ;
C 238 ; WX 494 ; N braceleftbt ; B 209 -75 445 935 ;
C 239 ; WX 494 ; N braceex ; B 209 -85 284 935 ;
C 241 ; WX 329 ; N angleright ; B 21 -198 302 746 ;
C 242 ; WX 274 ; N integral ; B 2 -107 291 916 ;
C 243 ; WX 686 ; N integraltp ; B 308 -88 675 920 ;
C 244 ; WX 686 ; N integralex ; B 308 -88 378 975 ;
C 245 ; WX 686 ; N integralbt ; B 11 -87 378 921 ;
C 246 ; WX 384 ; N parenrighttp ; B 54 -293 466 926 ;
C 247 ; WX 384 ; N parenrightex ; B 382 -85 466 925 ;
C 248 ; WX 384 ; N parenrightbt ; B 54 -293 466 926 ;
C 249 ; WX 384 ; N bracketrighttp ; B 22 -80 371 926 ;
C 250 ; WX 384 ; N bracketrightex ; B 294 -79 371 925 ;
C 251 ; WX 384 ; N bracketrightbt ; B 22 -80 371 926 ;
C 252 ; WX 494 ; N bracerighttp ; B 48 -85 284 925 ;
C 253 ; WX 494 ; N bracerightmid ; B 209 -85 473 935 ;
C 254 ; WX 494 ; N bracerightbt ; B 48 -75 284 935 ;
C -1 ; WX 790 ; N apple ; B 56 -3 733 808 ;
EndCharMetrics
EndFontMetrics"

let zapf_dingbats_afm = "StartFontMetrics 4.1
Comment Copyright (c) 1985, 1987, 1988, 1989, 1997 Adobe Systems Incorporated. All Rights Reserved.
Comment Creation Date: Thu May  1 15:14:13 1997
Comment UniqueID 43082
Comment VMusage 45775 55535
FontName ZapfDingbats
FullName ITC Zapf Dingbats
FamilyName ZapfDingbats
Weight Medium
ItalicAngle 0
IsFixedPitch false
CharacterSet Special
FontBBox -1 -143 981 820 
UnderlinePosition -100
UnderlineThickness 50
Version 002.000
Notice Copyright (c) 1985, 1987, 1988, 1989, 1997 Adobe Systems Incorporated. All Rights Reserved.ITC Zapf Dingbats is a registered trademark of International Typeface Corporation.
EncodingScheme FontSpecific
StdHW 28
StdVW 90
StartCharMetrics 202
C 32 ; WX 278 ; N space ; B 0 0 0 0 ;
C 33 ; WX 974 ; N a1 ; B 35 72 939 621 ;
C 34 ; WX 961 ; N a2 ; B 35 81 927 611 ;
C 35 ; WX 974 ; N a202 ; B 35 72 939 621 ;
C 36 ; WX 980 ; N a3 ; B 35 0 945 692 ;
C 37 ; WX 719 ; N a4 ; B 34 139 685 566 ;
C 38 ; WX 789 ; N a5 ; B 35 -14 755 705 ;
C 39 ; WX 790 ; N a119 ; B 35 -14 755 705 ;
C 40 ; WX 791 ; N a118 ; B 35 -13 761 705 ;
C 41 ; WX 690 ; N a117 ; B 34 138 655 553 ;
C 42 ; WX 960 ; N a11 ; B 35 123 925 568 ;
C 43 ; WX 939 ; N a12 ; B 35 134 904 559 ;
C 44 ; WX 549 ; N a13 ; B 29 -11 516 705 ;
C 45 ; WX 855 ; N a14 ; B 34 59 820 632 ;
C 46 ; WX 911 ; N a15 ; B 35 50 876 642 ;
C 47 ; WX 933 ; N a16 ; B 35 139 899 550 ;
C 48 ; WX 911 ; N a105 ; B 35 50 876 642 ;
C 49 ; WX 945 ; N a17 ; B 35 139 909 553 ;
C 50 ; WX 974 ; N a18 ; B 35 104 938 587 ;
C 51 ; WX 755 ; N a19 ; B 34 -13 721 705 ;
C 52 ; WX 846 ; N a20 ; B 36 -14 811 705 ;
C 53 ; WX 762 ; N a21 ; B 35 0 727 692 ;
C 54 ; WX 761 ; N a22 ; B 35 0 727 692 ;
C 55 ; WX 571 ; N a23 ; B -1 -68 571 661 ;
C 56 ; WX 677 ; N a24 ; B 36 -13 642 705 ;
C 57 ; WX 763 ; N a25 ; B 35 0 728 692 ;
C 58 ; WX 760 ; N a26 ; B 35 0 726 692 ;
C 59 ; WX 759 ; N a27 ; B 35 0 725 692 ;
C 60 ; WX 754 ; N a28 ; B 35 0 720 692 ;
C 61 ; WX 494 ; N a6 ; B 35 0 460 692 ;
C 62 ; WX 552 ; N a7 ; B 35 0 517 692 ;
C 63 ; WX 537 ; N a8 ; B 35 0 503 692 ;
C 64 ; WX 577 ; N a9 ; B 35 96 542 596 ;
C 65 ; WX 692 ; N a10 ; B 35 -14 657 705 ;
C 66 ; WX 786 ; N a29 ; B 35 -14 751 705 ;
C 67 ; WX 788 ; N a30 ; B 35 -14 752 705 ;
C 68 ; WX 788 ; N a31 ; B 35 -14 753 705 ;
C 69 ; WX 790 ; N a32 ; B 35 -14 756 705 ;
C 70 ; WX 793 ; N a33 ; B 35 -13 759 705 ;
C 71 ; WX 794 ; N a34 ; B 35 -13 759 705 ;
C 72 ; WX 816 ; N a35 ; B 35 -14 782 705 ;
C 73 ; WX 823 ; N a36 ; B 35 -14 787 705 ;
C 74 ; WX 789 ; N a37 ; B 35 -14 754 705 ;
C 75 ; WX 841 ; N a38 ; B 35 -14 807 705 ;
C 76 ; WX 823 ; N a39 ; B 35 -14 789 705 ;
C 77 ; WX 833 ; N a40 ; B 35 -14 798 705 ;
C 78 ; WX 816 ; N a41 ; B 35 -13 782 705 ;
C 79 ; WX 831 ; N a42 ; B 35 -14 796 705 ;
C 80 ; WX 923 ; N a43 ; B 35 -14 888 705 ;
C 81 ; WX 744 ; N a44 ; B 35 0 710 692 ;
C 82 ; WX 723 ; N a45 ; B 35 0 688 692 ;
C 83 ; WX 749 ; N a46 ; B 35 0 714 692 ;
C 84 ; WX 790 ; N a47 ; B 34 -14 756 705 ;
C 85 ; WX 792 ; N a48 ; B 35 -14 758 705 ;
C 86 ; WX 695 ; N a49 ; B 35 -14 661 706 ;
C 87 ; WX 776 ; N a50 ; B 35 -6 741 699 ;
C 88 ; WX 768 ; N a51 ; B 35 -7 734 699 ;
C 89 ; WX 792 ; N a52 ; B 35 -14 757 705 ;
C 90 ; WX 759 ; N a53 ; B 35 0 725 692 ;
C 91 ; WX 707 ; N a54 ; B 35 -13 672 704 ;
C 92 ; WX 708 ; N a55 ; B 35 -14 672 705 ;
C 93 ; WX 682 ; N a56 ; B 35 -14 647 705 ;
C 94 ; WX 701 ; N a57 ; B 35 -14 666 705 ;
C 95 ; WX 826 ; N a58 ; B 35 -14 791 705 ;
C 96 ; WX 815 ; N a59 ; B 35 -14 780 705 ;
C 97 ; WX 789 ; N a60 ; B 35 -14 754 705 ;
C 98 ; WX 789 ; N a61 ; B 35 -14 754 705 ;
C 99 ; WX 707 ; N a62 ; B 34 -14 673 705 ;
C 100 ; WX 687 ; N a63 ; B 36 0 651 692 ;
C 101 ; WX 696 ; N a64 ; B 35 0 661 691 ;
C 102 ; WX 689 ; N a65 ; B 35 0 655 692 ;
C 103 ; WX 786 ; N a66 ; B 34 -14 751 705 ;
C 104 ; WX 787 ; N a67 ; B 35 -14 752 705 ;
C 105 ; WX 713 ; N a68 ; B 35 -14 678 705 ;
C 106 ; WX 791 ; N a69 ; B 35 -14 756 705 ;
C 107 ; WX 785 ; N a70 ; B 36 -14 751 705 ;
C 108 ; WX 791 ; N a71 ; B 35 -14 757 705 ;
C 109 ; WX 873 ; N a72 ; B 35 -14 838 705 ;
C 110 ; WX 761 ; N a73 ; B 35 0 726 692 ;
C 111 ; WX 762 ; N a74 ; B 35 0 727 692 ;
C 112 ; WX 762 ; N a203 ; B 35 0 727 692 ;
C 113 ; WX 759 ; N a75 ; B 35 0 725 692 ;
C 114 ; WX 759 ; N a204 ; B 35 0 725 692 ;
C 115 ; WX 892 ; N a76 ; B 35 0 858 705 ;
C 116 ; WX 892 ; N a77 ; B 35 -14 858 692 ;
C 117 ; WX 788 ; N a78 ; B 35 -14 754 705 ;
C 118 ; WX 784 ; N a79 ; B 35 -14 749 705 ;
C 119 ; WX 438 ; N a81 ; B 35 -14 403 705 ;
C 120 ; WX 138 ; N a82 ; B 35 0 104 692 ;
C 121 ; WX 277 ; N a83 ; B 35 0 242 692 ;
C 122 ; WX 415 ; N a84 ; B 35 0 380 692 ;
C 123 ; WX 392 ; N a97 ; B 35 263 357 705 ;
C 124 ; WX 392 ; N a98 ; B 34 263 357 705 ;
C 125 ; WX 668 ; N a99 ; B 35 263 633 705 ;
C 126 ; WX 668 ; N a100 ; B 36 263 634 705 ;
C 128 ; WX 390 ; N a89 ; B 35 -14 356 705 ;
C 129 ; WX 390 ; N a90 ; B 35 -14 355 705 ;
C 130 ; WX 317 ; N a93 ; B 35 0 283 692 ;
C 131 ; WX 317 ; N a94 ; B 35 0 283 692 ;
C 132 ; WX 276 ; N a91 ; B 35 0 242 692 ;
C 133 ; WX 276 ; N a92 ; B 35 0 242 692 ;
C 134 ; WX 509 ; N a205 ; B 35 0 475 692 ;
C 135 ; WX 509 ; N a85 ; B 35 0 475 692 ;
C 136 ; WX 410 ; N a206 ; B 35 0 375 692 ;
C 137 ; WX 410 ; N a86 ; B 35 0 375 692 ;
C 138 ; WX 234 ; N a87 ; B 35 -14 199 705 ;
C 139 ; WX 234 ; N a88 ; B 35 -14 199 705 ;
C 140 ; WX 334 ; N a95 ; B 35 0 299 692 ;
C 141 ; WX 334 ; N a96 ; B 35 0 299 692 ;
C 161 ; WX 732 ; N a101 ; B 35 -143 697 806 ;
C 162 ; WX 544 ; N a102 ; B 56 -14 488 706 ;
C 163 ; WX 544 ; N a103 ; B 34 -14 508 705 ;
C 164 ; WX 910 ; N a104 ; B 35 40 875 651 ;
C 165 ; WX 667 ; N a106 ; B 35 -14 633 705 ;
C 166 ; WX 760 ; N a107 ; B 35 -14 726 705 ;
C 167 ; WX 760 ; N a108 ; B 0 121 758 569 ;
C 168 ; WX 776 ; N a112 ; B 35 0 741 705 ;
C 169 ; WX 595 ; N a111 ; B 34 -14 560 705 ;
C 170 ; WX 694 ; N a110 ; B 35 -14 659 705 ;
C 171 ; WX 626 ; N a109 ; B 34 0 591 705 ;
C 172 ; WX 788 ; N a120 ; B 35 -14 754 705 ;
C 173 ; WX 788 ; N a121 ; B 35 -14 754 705 ;
C 174 ; WX 788 ; N a122 ; B 35 -14 754 705 ;
C 175 ; WX 788 ; N a123 ; B 35 -14 754 705 ;
C 176 ; WX 788 ; N a124 ; B 35 -14 754 705 ;
C 177 ; WX 788 ; N a125 ; B 35 -14 754 705 ;
C 178 ; WX 788 ; N a126 ; B 35 -14 754 705 ;
C 179 ; WX 788 ; N a127 ; B 35 -14 754 705 ;
C 180 ; WX 788 ; N a128 ; B 35 -14 754 705 ;
C 181 ; WX 788 ; N a129 ; B 35 -14 754 705 ;
C 182 ; WX 788 ; N a130 ; B 35 -14 754 705 ;
C 183 ; WX 788 ; N a131 ; B 35 -14 754 705 ;
C 184 ; WX 788 ; N a132 ; B 35 -14 754 705 ;
C 185 ; WX 788 ; N a133 ; B 35 -14 754 705 ;
C 186 ; WX 788 ; N a134 ; B 35 -14 754 705 ;
C 187 ; WX 788 ; N a135 ; B 35 -14 754 705 ;
C 188 ; WX 788 ; N a136 ; B 35 -14 754 705 ;
C 189 ; WX 788 ; N a137 ; B 35 -14 754 705 ;
C 190 ; WX 788 ; N a138 ; B 35 -14 754 705 ;
C 191 ; WX 788 ; N a139 ; B 35 -14 754 705 ;
C 192 ; WX 788 ; N a140 ; B 35 -14 754 705 ;
C 193 ; WX 788 ; N a141 ; B 35 -14 754 705 ;
C 194 ; WX 788 ; N a142 ; B 35 -14 754 705 ;
C 195 ; WX 788 ; N a143 ; B 35 -14 754 705 ;
C 196 ; WX 788 ; N a144 ; B 35 -14 754 705 ;
C 197 ; WX 788 ; N a145 ; B 35 -14 754 705 ;
C 198 ; WX 788 ; N a146 ; B 35 -14 754 705 ;
C 199 ; WX 788 ; N a147 ; B 35 -14 754 705 ;
C 200 ; WX 788 ; N a148 ; B 35 -14 754 705 ;
C 201 ; WX 788 ; N a149 ; B 35 -14 754 705 ;
C 202 ; WX 788 ; N a150 ; B 35 -14 754 705 ;
C 203 ; WX 788 ; N a151 ; B 35 -14 754 705 ;
C 204 ; WX 788 ; N a152 ; B 35 -14 754 705 ;
C 205 ; WX 788 ; N a153 ; B 35 -14 754 705 ;
C 206 ; WX 788 ; N a154 ; B 35 -14 754 705 ;
C 207 ; WX 788 ; N a155 ; B 35 -14 754 705 ;
C 208 ; WX 788 ; N a156 ; B 35 -14 754 705 ;
C 209 ; WX 788 ; N a157 ; B 35 -14 754 705 ;
C 210 ; WX 788 ; N a158 ; B 35 -14 754 705 ;
C 211 ; WX 788 ; N a159 ; B 35 -14 754 705 ;
C 212 ; WX 894 ; N a160 ; B 35 58 860 634 ;
C 213 ; WX 838 ; N a161 ; B 35 152 803 540 ;
C 214 ; WX 1016 ; N a163 ; B 34 152 981 540 ;
C 215 ; WX 458 ; N a164 ; B 35 -127 422 820 ;
C 216 ; WX 748 ; N a196 ; B 35 94 698 597 ;
C 217 ; WX 924 ; N a165 ; B 35 140 890 552 ;
C 218 ; WX 748 ; N a192 ; B 35 94 698 597 ;
C 219 ; WX 918 ; N a166 ; B 35 166 884 526 ;
C 220 ; WX 927 ; N a167 ; B 35 32 892 660 ;
C 221 ; WX 928 ; N a168 ; B 35 129 891 562 ;
C 222 ; WX 928 ; N a169 ; B 35 128 893 563 ;
C 223 ; WX 834 ; N a170 ; B 35 155 799 537 ;
C 224 ; WX 873 ; N a171 ; B 35 93 838 599 ;
C 225 ; WX 828 ; N a172 ; B 35 104 791 588 ;
C 226 ; WX 924 ; N a173 ; B 35 98 889 594 ;
C 227 ; WX 924 ; N a162 ; B 35 98 889 594 ;
C 228 ; WX 917 ; N a174 ; B 35 0 882 692 ;
C 229 ; WX 930 ; N a175 ; B 35 84 896 608 ;
C 230 ; WX 931 ; N a176 ; B 35 84 896 608 ;
C 231 ; WX 463 ; N a177 ; B 35 -99 429 791 ;
C 232 ; WX 883 ; N a178 ; B 35 71 848 623 ;
C 233 ; WX 836 ; N a179 ; B 35 44 802 648 ;
C 234 ; WX 836 ; N a193 ; B 35 44 802 648 ;
C 235 ; WX 867 ; N a180 ; B 35 101 832 591 ;
C 236 ; WX 867 ; N a199 ; B 35 101 832 591 ;
C 237 ; WX 696 ; N a181 ; B 35 44 661 648 ;
C 238 ; WX 696 ; N a200 ; B 35 44 661 648 ;
C 239 ; WX 874 ; N a182 ; B 35 77 840 619 ;
C 241 ; WX 874 ; N a201 ; B 35 73 840 615 ;
C 242 ; WX 760 ; N a183 ; B 35 0 725 692 ;
C 243 ; WX 946 ; N a184 ; B 35 160 911 533 ;
C 244 ; WX 771 ; N a197 ; B 34 37 736 655 ;
C 245 ; WX 865 ; N a185 ; B 35 207 830 481 ;
C 246 ; WX 771 ; N a194 ; B 34 37 736 655 ;
C 247 ; WX 888 ; N a198 ; B 34 -19 853 712 ;
C 248 ; WX 967 ; N a186 ; B 35 124 932 568 ;
C 249 ; WX 888 ; N a195 ; B 34 -19 853 712 ;
C 250 ; WX 831 ; N a187 ; B 35 113 796 579 ;
C 251 ; WX 873 ; N a188 ; B 36 118 838 578 ;
C 252 ; WX 927 ; N a189 ; B 35 150 891 542 ;
C 253 ; WX 970 ; N a190 ; B 35 76 931 616 ;
C 254 ; WX 918 ; N a191 ; B 34 99 884 593 ;
EndCharMetrics
EndFontMetrics"
