/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2013 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

// -- Core stuff
#include <Application.h>
#include <Core.h>
#include <ExtensionManager.h>
using namespace camitk;

#include <iostream>
#include <QDateTime>

#include "CommandLineOptions.hxx"
#include "CamiTKVersionInformation.h"

// usage for this application
void usage(char *appName) {
    std::cerr << appName << std::endl;
    std::cerr << std::endl;
    std::cerr << "Usage: " << appName << " [options]" << std::endl;
    std::cerr << "Build using " << Core::version << std::endl;
    std::cerr << std::endl;
    std::cerr << "Options:" << endl;
    options::print_usage(std::cerr);
}

int main(int argc, char *argv[]) {
    try {
        int end; // End of options.
        options o(argc, argv, end);

        // if specific help or no options provided
        if (o.help()) {
            usage(argv[0]);
            return EXIT_SUCCESS;
        }
        else {
            // print all types of versions (just using the char* defined in CamiTKVersion.h at configuration time)
            if (o.version()) {
                std::cout << argv[0] << " build using " << Core::version << std::endl;
                if (compiledFromPackageSource())
                    std::cout << "Compiled using package source." << std::endl;
                else {
                    std::cout << "Compiled using svn";                    
                    if (hasMoreSvnInformation()) {
                        std::cout << " Rev: " << svnRevision() << ", Date: " << svnDate() << std::endl;
                    }
                    std::cout << "." << std::endl;                       
                }
                return EXIT_SUCCESS;
            }
            else if (o.completeVersion()) {
                std::cout << Core::version << std::endl;
                return EXIT_SUCCESS;
            }
            else if (o.shortVersion()) {
                std::cout << Core::shortVersion << std::endl;
                return EXIT_SUCCESS;
            }
            else if (o.timeStamp()) {
                QDateTime now = QDateTime::currentDateTime();
                std::cout << now.toString("yyyy-MM-dd").toStdString() << "T" << now.toString("hh:mm:ss").toStdString() << std::endl;
                return EXIT_SUCCESS;
            }
            else if (o.printPath()) {
                // init the camitk application context without auto-loading all extensions
                Application a("config", argc, argv, false);
                std::cout << Core::getPaths().toStdString() << std::endl;
                return EXIT_SUCCESS;
            }
            else if (o.camitkDir()) {
                // init the camitk application context without auto-loading all extensions
                Application a("config", argc, argv, false);
                std::cout << Core::getGlobalInstallDir().toStdString() << std::endl;
                return EXIT_SUCCESS;
            }
            else if (o.config()) {
                // init the camitk application context (auto-load of all extensions)
                Application a("camitk-config", argc, argv);
                std::cout << Core::getConfig().toStdString() << std::endl;
                return EXIT_SUCCESS;
            }
            else {
                usage(argv[0]);
                //NO GUI for the time being
                //return a.exec();
                return EXIT_SUCCESS;
            }
        }
    }
    catch (const cli::exception& e) {
        cerr << e << endl;
        usage(argv[0]);
        return EXIT_FAILURE;
    }

}
