/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2013 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#include "GenerateModel.h"
#include <Component.h>
#include <Log.h>
#include <Core.h>
#include <Application.h>
#include <MeshComponent.h>
using namespace camitk;


#include <set>



// -------------------- GenerateModel --------------------
GenerateModel::GenerateModel(ActionExtension* extension) : Action(extension) {
    this->setName("Generate Model");
    this->setDescription("Generates a model from a mesh: mml, pml and corresponding lml are generated");
    this->setComponent("MeshComponent");
    this->setFamily("Mesh Processing");
    this->addTag("Build Biomechanical Model");
}


// --------------- apply -------------------
Action::ApplyStatus GenerateModel::apply() {
    CAMITK_INFO("GenerateModel", "apply", "GenerateModel " << getTargets().last()->getName().toStdString());

    // set waiting cursor
    QApplication::setOverrideCursor ( QCursor ( Qt::WaitCursor ) );    

    // TODO: write the code here!
    
    // restore the normal cursor
    QApplication::restoreOverrideCursor();

    return SUCCESS;
}
