/*
   debug.h

   Bygfoot Football Manager -- a small and simple GTK2-based
   football management game.

   http://bygfoot.sourceforge.net

   Copyright (C) 2005  Gyözö Both (gyboth@bygfoot.com)

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#ifndef DEBUG_H
#define DEBUG_H

#include <gtk/gtk.h>
//#include "bygfoot.h"

enum DebugOutput
{
    DEBUG_OUT_STDOUT = 0,
    DEBUG_OUT_LOGFILE,
    DEBUG_OUT_STDOUT_LOGFILE
};

void
debug_action(const gchar *text);

gboolean
debug_reset_counter(gpointer data);

void
debug_calibrate_betting_odds(gint skilldiffmax, gint matches_per_skilldiff);

gboolean
debug_egg_forwards_boost_style(void);

void
debug_writer_out(const gchar *file_name,
				 const gchar *method_name,
			 	 const gchar *text,
			 	 gint debuglevel);

void
debug_print_message(gchar *format, ...);

#endif

