BMORE(1)                                                 BMORE(1)


NAME
       bmore - browse through a binary file

SYNOPSIS
       bmore [ -acdi ] [ -n lines ] [ -w cols ] [ +linenumber ] [
       +/ASCII-pattern ] [ +\Hex-pattern ] [ filename ... ]


DESCRIPTION
       more is a filter that displays the contents  of  a  binary
       file  on  the  terminal, one screenful at a time.  It nor-
       mally pauses after each screenful, and prints --More--  at
       the bottom of the screen.  bmore provides a two-line over-
       lap between screens for continuity.  If bmore  is  reading
       from  a file rather than a pipe, the percentage of charac-
       ters displayed so far is also shown.

       bmore scrolls up  to  display  one  more  screen  line  in
       response  to  a  RETURN  character;  it  displays  another
       screenful in response to a SPACE  character.   Other  com-
       mands are listed below.

       The screen is divided in three sections or panes: The byte
       offset (extreme left), the hex pane (middle), and an ascii
       pane  (right)  which  shows  as printable characters those
       bytes in the hex pane.  On an  80  column  terminal  there
       will  be sixteen hex values and their ASCII values on each
       screen line.  Note that (as one would  expect)  the  first
       byte has the offset 0 (zero).

       bmore sets the terminal to noecho mode, so that the output
       can be continuous.  Commands that you type do not normally
       show up on your terminal, except for the / , \ and !  com-
       mands.

       If the standard output is not a terminal, more  acts  just
       like  cat(1V), except that a header is printed before each
       file in a series.

OPTIONS
       -a     ASCII mode: no hex representation of the  contents.
              Non printable characters are displayed as a dot (.)

       -c     Clear  before  displaying.  Redrawing  the   screen
              instead of scrolling.

       -d     Display error messages rather than ringing the ter-
              minal bell if  an  unrecognized  command  is  used.
              This is helpful for inexperienced users.

       -i     Ignore case for searching.

       -n lines
              Displays  the  indicated  number  of  lines in each
              screenful, rather than the default (the  number  of
              lines in the terminal screen less two).

       -w cols
              Display number of cols in each line.

       +linenumber
              Start up at linenumber.

       +/ASCII-pattern
              Start up at the line containing the regular expres-
              sion pattern.  Note: unlike editors, this construct
              should  not  end  with a `/'.  If it does, then the
              trailing slash is  taken  as  a  character  in  the
              search pattern.


USAGE

   Commands
       The commands take effect immediately;  it is not necessary
       to type a carriage return.  Up to the time when  the  com-
       mand character itself is given, the user may type the line
       kill character to  cancel  the  numerical  argument  being
       formed.   In addition, the user may type the erase charac-
       ter to redisplay the `--More--(xx%)' message.

       In the following commands, i is a numerical argument (1 by
       default).

       iSPACE    Display  another screenful, or i more lines if i
                 is specified.

       iRETURN   Display another line, or i more lines, if speci-
                 fied.

       i^D       (CTRL-D) Display (scroll down) 11 more lines.  i
                 is given, the scroll size is set to i.

       id        Same as ^D.

       iz        Same  as  SPACE,  except  that  i,  if  present,
                 becomes  the  new  default  number  of lines per
                 screenful.

       is        Skip i lines and then print a screenful.

       if        Skip i screenfuls and then print a screenful.

       i^B       (CTRL-B) Skip back i screenfuls and then print a
                 screenful.

       b         Same as ^B (CTRL-D).

       q
       Q         Exit from more.

       =         Display the current line number.

       v         Drop  into the bvi(1) editor at the current off-
                 set of the current file.
       w         Drop into the bvi(1) editor at the current  off-
                 set of the current file. Only the portion of the
                 file displayed on the screen will be loaded.

       h         Help.  Give a description of all the  more  com-
                 mands.

       i/pattern Search  for  the  ith  occurrence of the regular
                 expression  pattern.   Display   the   screenful
                 starting  at the file position that contains the
                 ith match for the regular expression  ASCII-pat-
                 tern,  or  the  end  of  a pipe, whichever comes
                 first.  If bmore is displaying a file and  there
                 is  no  such  match,  its  position  in the file
                 remains unchanged.  Regular expressions  can  be
                 edited using erase and kill characters.  Erasing
                 back past the first column  cancels  the  search
                 command.

       '         Single  quote.   Go  to the point from which the
                 last search started.  If no search has been per-
                 formed  in the current file, go to the beginning
                 of the file.

       !command  Invoke a shell to execute command.  The  charac-
                 ters  %  and  !,  when  used  within command are
                 replaced with the current filename and the  pre-
                 vious  shell command, respectively.  If there is
                 no current filename, % is not expanded.  Prepend
                 a backslash to these characters to escape expan-
                 sion.

       i:n       Skip to the ith next filename given in the  com-
                 mand  line,  or to the last filename in the list
                 if i is out of range.

       i:p       Skip to the ith previous filename given  in  the
                 command  line,  or to the first filename if i is
                 out of range.  If given while more is positioned
                 within  a file, go to the beginning of the file.
                 If more is reading  from  a  pipe,  more  simply
                 rings the terminal bell.

       :f        Display  the current filename and offset number.

       :q
       :Q        Exit from bmore (same as q or Q ).

       .         Dot.  Repeat the previous command.


       FILES
       /etc/termcap        terminal data base
       /usr/local/share/bmore.help
                           help file

SEE ALSO
       bvi(1), termcap(5)
 
                            3 Jan 2004
