# THIS FILE IS AUTOMATICALLY GENERATED.  EDIT THE SOURCE FILE NOT THIS ONE

"""Various descriptions of data specific to LG VX8550"""

from p_lgvx8700 import *
# same as the VX-8700 except as noted below

NUMPHONEBOOKENTRIES=1000
NUMPHONENUMBERENTRIES=5000

NUMSPEEDDIALS=100
FIRSTSPEEDDIAL=1
LASTSPEEDDIAL=99

NUMCALENDARENTRIES=300
NUMEMERGENCYCONTACTS=3

# sizes of pbfileentry and pnfileentry
PHONEBOOKENTRYSIZE=256
PHONENUMBERENTRYSIZE=64

NUM_EMAILS=2
NUMPHONENUMBERS=5

pb_file_name         = 'pim/pbentry.dat'
pb_recordid_filename = 'pim/record_id.dat'
pn_file_name         = 'pim/pbnumber.dat'
speed_file_name      = 'pim/pbspeed.dat'
ice_file_name        = 'pim/pbiceentry.dat'

PB_ENTRY_SOR='<PE>'
PB_NUMBER_SOR='<PN>'

class speeddial(BaseProtogenClass):
    __fields=['entry', 'number']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(speeddial,self).__init__(**dict)
        if self.__class__ is speeddial:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(speeddial,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(speeddial,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_entry
        except:
            self.__field_entry=UINT(**{'sizeinbytes': 2, 'default': 0xffff})
        self.__field_entry.writetobuffer(buf)
        try: self.__field_number
        except:
            self.__field_number=UINT(**{'sizeinbytes': 1, 'default': 0xff})
        self.__field_number.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_entry=UINT(**{'sizeinbytes': 2, 'default': 0xffff})
        self.__field_entry.readfrombuffer(buf)
        self.__field_number=UINT(**{'sizeinbytes': 1, 'default': 0xff})
        self.__field_number.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_entry(self):
        try: self.__field_entry
        except:
            self.__field_entry=UINT(**{'sizeinbytes': 2, 'default': 0xffff})
        return self.__field_entry.getvalue()

    def __setfield_entry(self, value):
        if isinstance(value,UINT):
            self.__field_entry=value
        else:
            self.__field_entry=UINT(value,**{'sizeinbytes': 2, 'default': 0xffff})

    def __delfield_entry(self): del self.__field_entry

    entry=property(__getfield_entry, __setfield_entry, __delfield_entry, "0-based entry number")

    def __getfield_number(self):
        try: self.__field_number
        except:
            self.__field_number=UINT(**{'sizeinbytes': 1, 'default': 0xff})
        return self.__field_number.getvalue()

    def __setfield_number(self, value):
        if isinstance(value,UINT):
            self.__field_number=value
        else:
            self.__field_number=UINT(value,**{'sizeinbytes': 1, 'default': 0xff})

    def __delfield_number(self): del self.__field_number

    number=property(__getfield_number, __setfield_number, __delfield_number, "number type")

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('entry', self.__field_entry, "0-based entry number")
        yield ('number', self.__field_number, "number type")

    def valid(self):
        return self.entry!=0xffff




class speeddials(BaseProtogenClass):
    __fields=['speeddials']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(speeddials,self).__init__(**dict)
        if self.__class__ is speeddials:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(speeddials,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(speeddials,kwargs)
        if len(args):
            dict2={'length': NUMSPEEDDIALS, 'elementclass': speeddial}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_speeddials=LIST(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_speeddials
        except:
            self.__field_speeddials=LIST(**{'length': NUMSPEEDDIALS, 'elementclass': speeddial})
        self.__field_speeddials.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_speeddials=LIST(**{'length': NUMSPEEDDIALS, 'elementclass': speeddial})
        self.__field_speeddials.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_speeddials(self):
        try: self.__field_speeddials
        except:
            self.__field_speeddials=LIST(**{'length': NUMSPEEDDIALS, 'elementclass': speeddial})
        return self.__field_speeddials.getvalue()

    def __setfield_speeddials(self, value):
        if isinstance(value,LIST):
            self.__field_speeddials=value
        else:
            self.__field_speeddials=LIST(value,**{'length': NUMSPEEDDIALS, 'elementclass': speeddial})

    def __delfield_speeddials(self): del self.__field_speeddials

    speeddials=property(__getfield_speeddials, __setfield_speeddials, __delfield_speeddials, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('speeddials', self.__field_speeddials, None)




class pbfileentry(BaseProtogenClass):
    __fields=['entry_tag', 'mod_date', 'unk0', 'entry_number1', 'entry_number0', 'name', 'group', 'emails', 'ringtone', 'wallpaper', 'numbertypes', 'numberindices', 'memo', 'exit_tag', 'dontcare']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(pbfileentry,self).__init__(**dict)
        if self.__class__ is pbfileentry:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(pbfileentry,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(pbfileentry,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_entry_tag
        except:
            self.__field_entry_tag=STRING(**{'sizeinbytes': 5,  'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '\xff\xff\xff\xff\xff' })
        self.__field_entry_tag.writetobuffer(buf)
        if self.entry_tag==PB_ENTRY_SOR:
            try: self.__field_mod_date
            except:
                self.__field_mod_date=PBDateTime(**{ 'defaulttocurrenttime': True })
            self.__field_mod_date.writetobuffer(buf)
            try: self.__field_unk0
            except:
                self.__field_unk0=STRING(**{'sizeinbytes': 6,  'terminator': None, 'default': '\xff\xff\xff\xff\xff\xff' })
            self.__field_unk0.writetobuffer(buf)
            self.__field_entry_number1.writetobuffer(buf)
            self.__field_entry_number0.writetobuffer(buf)
            try: self.__field_name
            except:
                self.__field_name=USTRING(**{'sizeinbytes': 33,  'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False })
            self.__field_name.writetobuffer(buf)
            try: self.__field_group
            except:
                self.__field_group=UINT(**{'sizeinbytes': 2,  'default': 0 })
            self.__field_group.writetobuffer(buf)
            try: self.__field_emails
            except:
                self.__field_emails=LIST(**{'elementclass': _gen_p_lgvx8550_72, 'length': NUMEMAILS})
            self.__field_emails.writetobuffer(buf)
            try: self.__field_ringtone
            except:
                self.__field_ringtone=UINT(**{'sizeinbytes': 2,  'default': 0xffff })
            self.__field_ringtone.writetobuffer(buf)
            try: self.__field_wallpaper
            except:
                self.__field_wallpaper=UINT(**{'sizeinbytes': 2,  'default': 0 })
            self.__field_wallpaper.writetobuffer(buf)
            try: self.__field_numbertypes
            except:
                self.__field_numbertypes=LIST(**{'elementclass': _gen_p_lgvx8550_76, 'length': NUMPHONENUMBERS})
            self.__field_numbertypes.writetobuffer(buf)
            try: self.__field_numberindices
            except:
                self.__field_numberindices=LIST(**{'elementclass': _gen_p_lgvx8550_78, 'length': NUMPHONENUMBERS})
            self.__field_numberindices.writetobuffer(buf)
            try: self.__field_memo
            except:
                self.__field_memo=USTRING(**{'sizeinbytes': 69,  'raiseonunterminatedread': False, 'default': '', 'encoding': PHONE_ENCODING })
            self.__field_memo.writetobuffer(buf)
            try: self.__field_exit_tag
            except:
                self.__field_exit_tag=USTRING(**{'sizeinbytes': 6,  'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '</PE>'})
            self.__field_exit_tag.writetobuffer(buf)
        else:
            try: self.__field_dontcare
            except:
                self.__field_dontcare=DATA(**{'sizeinbytes': 251,  'default': '\xff'*251 })
            self.__field_dontcare.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_entry_tag=STRING(**{'sizeinbytes': 5,  'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '\xff\xff\xff\xff\xff' })
        self.__field_entry_tag.readfrombuffer(buf)
        if self.entry_tag==PB_ENTRY_SOR:
            self.__field_mod_date=PBDateTime(**{ 'defaulttocurrenttime': True })
            self.__field_mod_date.readfrombuffer(buf)
            self.__field_unk0=STRING(**{'sizeinbytes': 6,  'terminator': None, 'default': '\xff\xff\xff\xff\xff\xff' })
            self.__field_unk0.readfrombuffer(buf)
            self.__field_entry_number1=UINT(**{'sizeinbytes': 4})
            self.__field_entry_number1.readfrombuffer(buf)
            self.__field_entry_number0=UINT(**{'sizeinbytes': 2})
            self.__field_entry_number0.readfrombuffer(buf)
            self.__field_name=USTRING(**{'sizeinbytes': 33,  'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False })
            self.__field_name.readfrombuffer(buf)
            self.__field_group=UINT(**{'sizeinbytes': 2,  'default': 0 })
            self.__field_group.readfrombuffer(buf)
            self.__field_emails=LIST(**{'elementclass': _gen_p_lgvx8550_72, 'length': NUMEMAILS})
            self.__field_emails.readfrombuffer(buf)
            self.__field_ringtone=UINT(**{'sizeinbytes': 2,  'default': 0xffff })
            self.__field_ringtone.readfrombuffer(buf)
            self.__field_wallpaper=UINT(**{'sizeinbytes': 2,  'default': 0 })
            self.__field_wallpaper.readfrombuffer(buf)
            self.__field_numbertypes=LIST(**{'elementclass': _gen_p_lgvx8550_76, 'length': NUMPHONENUMBERS})
            self.__field_numbertypes.readfrombuffer(buf)
            self.__field_numberindices=LIST(**{'elementclass': _gen_p_lgvx8550_78, 'length': NUMPHONENUMBERS})
            self.__field_numberindices.readfrombuffer(buf)
            self.__field_memo=USTRING(**{'sizeinbytes': 69,  'raiseonunterminatedread': False, 'default': '', 'encoding': PHONE_ENCODING })
            self.__field_memo.readfrombuffer(buf)
            self.__field_exit_tag=USTRING(**{'sizeinbytes': 6,  'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '</PE>'})
            self.__field_exit_tag.readfrombuffer(buf)
        else:
            self.__field_dontcare=DATA(**{'sizeinbytes': 251,  'default': '\xff'*251 })
            self.__field_dontcare.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_entry_tag(self):
        try: self.__field_entry_tag
        except:
            self.__field_entry_tag=STRING(**{'sizeinbytes': 5,  'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '\xff\xff\xff\xff\xff' })
        return self.__field_entry_tag.getvalue()

    def __setfield_entry_tag(self, value):
        if isinstance(value,STRING):
            self.__field_entry_tag=value
        else:
            self.__field_entry_tag=STRING(value,**{'sizeinbytes': 5,  'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '\xff\xff\xff\xff\xff' })

    def __delfield_entry_tag(self): del self.__field_entry_tag

    entry_tag=property(__getfield_entry_tag, __setfield_entry_tag, __delfield_entry_tag, None)

    def __getfield_mod_date(self):
        try: self.__field_mod_date
        except:
            self.__field_mod_date=PBDateTime(**{ 'defaulttocurrenttime': True })
        return self.__field_mod_date.getvalue()

    def __setfield_mod_date(self, value):
        if isinstance(value,PBDateTime):
            self.__field_mod_date=value
        else:
            self.__field_mod_date=PBDateTime(value,**{ 'defaulttocurrenttime': True })

    def __delfield_mod_date(self): del self.__field_mod_date

    mod_date=property(__getfield_mod_date, __setfield_mod_date, __delfield_mod_date, None)

    def __getfield_unk0(self):
        try: self.__field_unk0
        except:
            self.__field_unk0=STRING(**{'sizeinbytes': 6,  'terminator': None, 'default': '\xff\xff\xff\xff\xff\xff' })
        return self.__field_unk0.getvalue()

    def __setfield_unk0(self, value):
        if isinstance(value,STRING):
            self.__field_unk0=value
        else:
            self.__field_unk0=STRING(value,**{'sizeinbytes': 6,  'terminator': None, 'default': '\xff\xff\xff\xff\xff\xff' })

    def __delfield_unk0(self): del self.__field_unk0

    unk0=property(__getfield_unk0, __setfield_unk0, __delfield_unk0, None)

    def __getfield_entry_number1(self):
        return self.__field_entry_number1.getvalue()

    def __setfield_entry_number1(self, value):
        if isinstance(value,UINT):
            self.__field_entry_number1=value
        else:
            self.__field_entry_number1=UINT(value,**{'sizeinbytes': 4})

    def __delfield_entry_number1(self): del self.__field_entry_number1

    entry_number1=property(__getfield_entry_number1, __setfield_entry_number1, __delfield_entry_number1, None)

    def __getfield_entry_number0(self):
        return self.__field_entry_number0.getvalue()

    def __setfield_entry_number0(self, value):
        if isinstance(value,UINT):
            self.__field_entry_number0=value
        else:
            self.__field_entry_number0=UINT(value,**{'sizeinbytes': 2})

    def __delfield_entry_number0(self): del self.__field_entry_number0

    entry_number0=property(__getfield_entry_number0, __setfield_entry_number0, __delfield_entry_number0, None)

    def __getfield_name(self):
        try: self.__field_name
        except:
            self.__field_name=USTRING(**{'sizeinbytes': 33,  'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False })
        return self.__field_name.getvalue()

    def __setfield_name(self, value):
        if isinstance(value,USTRING):
            self.__field_name=value
        else:
            self.__field_name=USTRING(value,**{'sizeinbytes': 33,  'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False })

    def __delfield_name(self): del self.__field_name

    name=property(__getfield_name, __setfield_name, __delfield_name, None)

    def __getfield_group(self):
        try: self.__field_group
        except:
            self.__field_group=UINT(**{'sizeinbytes': 2,  'default': 0 })
        return self.__field_group.getvalue()

    def __setfield_group(self, value):
        if isinstance(value,UINT):
            self.__field_group=value
        else:
            self.__field_group=UINT(value,**{'sizeinbytes': 2,  'default': 0 })

    def __delfield_group(self): del self.__field_group

    group=property(__getfield_group, __setfield_group, __delfield_group, None)

    def __getfield_emails(self):
        try: self.__field_emails
        except:
            self.__field_emails=LIST(**{'elementclass': _gen_p_lgvx8550_72, 'length': NUMEMAILS})
        return self.__field_emails.getvalue()

    def __setfield_emails(self, value):
        if isinstance(value,LIST):
            self.__field_emails=value
        else:
            self.__field_emails=LIST(value,**{'elementclass': _gen_p_lgvx8550_72, 'length': NUMEMAILS})

    def __delfield_emails(self): del self.__field_emails

    emails=property(__getfield_emails, __setfield_emails, __delfield_emails, None)

    def __getfield_ringtone(self):
        try: self.__field_ringtone
        except:
            self.__field_ringtone=UINT(**{'sizeinbytes': 2,  'default': 0xffff })
        return self.__field_ringtone.getvalue()

    def __setfield_ringtone(self, value):
        if isinstance(value,UINT):
            self.__field_ringtone=value
        else:
            self.__field_ringtone=UINT(value,**{'sizeinbytes': 2,  'default': 0xffff })

    def __delfield_ringtone(self): del self.__field_ringtone

    ringtone=property(__getfield_ringtone, __setfield_ringtone, __delfield_ringtone, None)

    def __getfield_wallpaper(self):
        try: self.__field_wallpaper
        except:
            self.__field_wallpaper=UINT(**{'sizeinbytes': 2,  'default': 0 })
        return self.__field_wallpaper.getvalue()

    def __setfield_wallpaper(self, value):
        if isinstance(value,UINT):
            self.__field_wallpaper=value
        else:
            self.__field_wallpaper=UINT(value,**{'sizeinbytes': 2,  'default': 0 })

    def __delfield_wallpaper(self): del self.__field_wallpaper

    wallpaper=property(__getfield_wallpaper, __setfield_wallpaper, __delfield_wallpaper, None)

    def __getfield_numbertypes(self):
        try: self.__field_numbertypes
        except:
            self.__field_numbertypes=LIST(**{'elementclass': _gen_p_lgvx8550_76, 'length': NUMPHONENUMBERS})
        return self.__field_numbertypes.getvalue()

    def __setfield_numbertypes(self, value):
        if isinstance(value,LIST):
            self.__field_numbertypes=value
        else:
            self.__field_numbertypes=LIST(value,**{'elementclass': _gen_p_lgvx8550_76, 'length': NUMPHONENUMBERS})

    def __delfield_numbertypes(self): del self.__field_numbertypes

    numbertypes=property(__getfield_numbertypes, __setfield_numbertypes, __delfield_numbertypes, None)

    def __getfield_numberindices(self):
        try: self.__field_numberindices
        except:
            self.__field_numberindices=LIST(**{'elementclass': _gen_p_lgvx8550_78, 'length': NUMPHONENUMBERS})
        return self.__field_numberindices.getvalue()

    def __setfield_numberindices(self, value):
        if isinstance(value,LIST):
            self.__field_numberindices=value
        else:
            self.__field_numberindices=LIST(value,**{'elementclass': _gen_p_lgvx8550_78, 'length': NUMPHONENUMBERS})

    def __delfield_numberindices(self): del self.__field_numberindices

    numberindices=property(__getfield_numberindices, __setfield_numberindices, __delfield_numberindices, None)

    def __getfield_memo(self):
        try: self.__field_memo
        except:
            self.__field_memo=USTRING(**{'sizeinbytes': 69,  'raiseonunterminatedread': False, 'default': '', 'encoding': PHONE_ENCODING })
        return self.__field_memo.getvalue()

    def __setfield_memo(self, value):
        if isinstance(value,USTRING):
            self.__field_memo=value
        else:
            self.__field_memo=USTRING(value,**{'sizeinbytes': 69,  'raiseonunterminatedread': False, 'default': '', 'encoding': PHONE_ENCODING })

    def __delfield_memo(self): del self.__field_memo

    memo=property(__getfield_memo, __setfield_memo, __delfield_memo, None)

    def __getfield_exit_tag(self):
        try: self.__field_exit_tag
        except:
            self.__field_exit_tag=USTRING(**{'sizeinbytes': 6,  'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '</PE>'})
        return self.__field_exit_tag.getvalue()

    def __setfield_exit_tag(self, value):
        if isinstance(value,USTRING):
            self.__field_exit_tag=value
        else:
            self.__field_exit_tag=USTRING(value,**{'sizeinbytes': 6,  'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '</PE>'})

    def __delfield_exit_tag(self): del self.__field_exit_tag

    exit_tag=property(__getfield_exit_tag, __setfield_exit_tag, __delfield_exit_tag, None)

    def __getfield_dontcare(self):
        try: self.__field_dontcare
        except:
            self.__field_dontcare=DATA(**{'sizeinbytes': 251,  'default': '\xff'*251 })
        return self.__field_dontcare.getvalue()

    def __setfield_dontcare(self, value):
        if isinstance(value,DATA):
            self.__field_dontcare=value
        else:
            self.__field_dontcare=DATA(value,**{'sizeinbytes': 251,  'default': '\xff'*251 })

    def __delfield_dontcare(self): del self.__field_dontcare

    dontcare=property(__getfield_dontcare, __setfield_dontcare, __delfield_dontcare, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('entry_tag', self.__field_entry_tag, None)
        if self.entry_tag==PB_ENTRY_SOR:
            yield ('mod_date', self.__field_mod_date, None)
            yield ('unk0', self.__field_unk0, None)
            yield ('entry_number1', self.__field_entry_number1, None)
            yield ('entry_number0', self.__field_entry_number0, None)
            yield ('name', self.__field_name, None)
            yield ('group', self.__field_group, None)
            yield ('emails', self.__field_emails, None)
            yield ('ringtone', self.__field_ringtone, None)
            yield ('wallpaper', self.__field_wallpaper, None)
            yield ('numbertypes', self.__field_numbertypes, None)
            yield ('numberindices', self.__field_numberindices, None)
            yield ('memo', self.__field_memo, None)
            yield ('exit_tag', self.__field_exit_tag, None)
        else:
            yield ('dontcare', self.__field_dontcare, None)

    def valid(self):
        global PB_ENTRY_SOR
        return self.entry_tag==PB_ENTRY_SOR and ord(self.name[0]) != 0xff




class _gen_p_lgvx8550_72(BaseProtogenClass):
    'Anonymous inner class'
    __fields=['email']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(_gen_p_lgvx8550_72,self).__init__(**dict)
        if self.__class__ is _gen_p_lgvx8550_72:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(_gen_p_lgvx8550_72,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(_gen_p_lgvx8550_72,kwargs)
        if len(args):
            dict2={'sizeinbytes': 49, 'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_email=USTRING(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_email.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_email=USTRING(**{'sizeinbytes': 49, 'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False})
        self.__field_email.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_email(self):
        return self.__field_email.getvalue()

    def __setfield_email(self, value):
        if isinstance(value,USTRING):
            self.__field_email=value
        else:
            self.__field_email=USTRING(value,**{'sizeinbytes': 49, 'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False})

    def __delfield_email(self): del self.__field_email

    email=property(__getfield_email, __setfield_email, __delfield_email, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('email', self.__field_email, None)




class _gen_p_lgvx8550_76(BaseProtogenClass):
    'Anonymous inner class'
    __fields=['numbertype']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(_gen_p_lgvx8550_76,self).__init__(**dict)
        if self.__class__ is _gen_p_lgvx8550_76:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(_gen_p_lgvx8550_76,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(_gen_p_lgvx8550_76,kwargs)
        if len(args):
            dict2={'sizeinbytes': 1,  'default': 0 }
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_numbertype=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_numbertype.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_numbertype=UINT(**{'sizeinbytes': 1,  'default': 0 })
        self.__field_numbertype.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_numbertype(self):
        return self.__field_numbertype.getvalue()

    def __setfield_numbertype(self, value):
        if isinstance(value,UINT):
            self.__field_numbertype=value
        else:
            self.__field_numbertype=UINT(value,**{'sizeinbytes': 1,  'default': 0 })

    def __delfield_numbertype(self): del self.__field_numbertype

    numbertype=property(__getfield_numbertype, __setfield_numbertype, __delfield_numbertype, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('numbertype', self.__field_numbertype, None)




class _gen_p_lgvx8550_78(BaseProtogenClass):
    'Anonymous inner class'
    __fields=['numberindex']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(_gen_p_lgvx8550_78,self).__init__(**dict)
        if self.__class__ is _gen_p_lgvx8550_78:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(_gen_p_lgvx8550_78,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(_gen_p_lgvx8550_78,kwargs)
        if len(args):
            dict2={'sizeinbytes': 2,  'default': 0xffff }
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_numberindex=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_numberindex.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_numberindex=UINT(**{'sizeinbytes': 2,  'default': 0xffff })
        self.__field_numberindex.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_numberindex(self):
        return self.__field_numberindex.getvalue()

    def __setfield_numberindex(self, value):
        if isinstance(value,UINT):
            self.__field_numberindex=value
        else:
            self.__field_numberindex=UINT(value,**{'sizeinbytes': 2,  'default': 0xffff })

    def __delfield_numberindex(self): del self.__field_numberindex

    numberindex=property(__getfield_numberindex, __setfield_numberindex, __delfield_numberindex, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('numberindex', self.__field_numberindex, None)




class pbfile(BaseProtogenClass):
    __fields=['items', 'eof_tag', 'model_name', 'mod_date', 'blanks', 'eof_close_tag']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(pbfile,self).__init__(**dict)
        if self.__class__ is pbfile:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(pbfile,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(pbfile,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_items
        except:
            self.__field_items=LIST(**{ 'elementclass': pbfileentry,             'length': NUMPHONEBOOKENTRIES,             'createdefault': True})
        self.__field_items.writetobuffer(buf)
        try: self.__field_eof_tag
        except:
            self.__field_eof_tag=STRING(**{'sizeinbytes': 6,  'default': '<HPE>',               'raiseonunterminatedread': False,               'raiseontruncate': False })
        self.__field_eof_tag.writetobuffer(buf)
        try: self.__field_model_name
        except:
            self.__field_model_name=STRING(**{'sizeinbytes': 10,  'raiseonunterminatedread': False,                'raiseontruncate': False })
        self.__field_model_name.writetobuffer(buf)
        try: self.__field_mod_date
        except:
            self.__field_mod_date=PBDateTime(**{ 'defaulttocurrenttime': True })
        self.__field_mod_date.writetobuffer(buf)
        try: self.__field_blanks
        except:
            self.__field_blanks=DATA(**{'sizeinbytes': 221,  'default': '\x00'*221 })
        self.__field_blanks.writetobuffer(buf)
        try: self.__field_eof_close_tag
        except:
            self.__field_eof_close_tag=STRING(**{'sizeinbytes': 7,  'default': '</HPE>',               'raiseonunterminatedread': False,               'raiseontruncate': False  })
        self.__field_eof_close_tag.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_items=LIST(**{ 'elementclass': pbfileentry,             'length': NUMPHONEBOOKENTRIES,             'createdefault': True})
        self.__field_items.readfrombuffer(buf)
        self.__field_eof_tag=STRING(**{'sizeinbytes': 6,  'default': '<HPE>',               'raiseonunterminatedread': False,               'raiseontruncate': False })
        self.__field_eof_tag.readfrombuffer(buf)
        self.__field_model_name=STRING(**{'sizeinbytes': 10,  'raiseonunterminatedread': False,                'raiseontruncate': False })
        self.__field_model_name.readfrombuffer(buf)
        self.__field_mod_date=PBDateTime(**{ 'defaulttocurrenttime': True })
        self.__field_mod_date.readfrombuffer(buf)
        self.__field_blanks=DATA(**{'sizeinbytes': 221,  'default': '\x00'*221 })
        self.__field_blanks.readfrombuffer(buf)
        self.__field_eof_close_tag=STRING(**{'sizeinbytes': 7,  'default': '</HPE>',               'raiseonunterminatedread': False,               'raiseontruncate': False  })
        self.__field_eof_close_tag.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_items(self):
        try: self.__field_items
        except:
            self.__field_items=LIST(**{ 'elementclass': pbfileentry,             'length': NUMPHONEBOOKENTRIES,             'createdefault': True})
        return self.__field_items.getvalue()

    def __setfield_items(self, value):
        if isinstance(value,LIST):
            self.__field_items=value
        else:
            self.__field_items=LIST(value,**{ 'elementclass': pbfileentry,             'length': NUMPHONEBOOKENTRIES,             'createdefault': True})

    def __delfield_items(self): del self.__field_items

    items=property(__getfield_items, __setfield_items, __delfield_items, None)

    def __getfield_eof_tag(self):
        try: self.__field_eof_tag
        except:
            self.__field_eof_tag=STRING(**{'sizeinbytes': 6,  'default': '<HPE>',               'raiseonunterminatedread': False,               'raiseontruncate': False })
        return self.__field_eof_tag.getvalue()

    def __setfield_eof_tag(self, value):
        if isinstance(value,STRING):
            self.__field_eof_tag=value
        else:
            self.__field_eof_tag=STRING(value,**{'sizeinbytes': 6,  'default': '<HPE>',               'raiseonunterminatedread': False,               'raiseontruncate': False })

    def __delfield_eof_tag(self): del self.__field_eof_tag

    eof_tag=property(__getfield_eof_tag, __setfield_eof_tag, __delfield_eof_tag, None)

    def __getfield_model_name(self):
        try: self.__field_model_name
        except:
            self.__field_model_name=STRING(**{'sizeinbytes': 10,  'raiseonunterminatedread': False,                'raiseontruncate': False })
        return self.__field_model_name.getvalue()

    def __setfield_model_name(self, value):
        if isinstance(value,STRING):
            self.__field_model_name=value
        else:
            self.__field_model_name=STRING(value,**{'sizeinbytes': 10,  'raiseonunterminatedread': False,                'raiseontruncate': False })

    def __delfield_model_name(self): del self.__field_model_name

    model_name=property(__getfield_model_name, __setfield_model_name, __delfield_model_name, None)

    def __getfield_mod_date(self):
        try: self.__field_mod_date
        except:
            self.__field_mod_date=PBDateTime(**{ 'defaulttocurrenttime': True })
        return self.__field_mod_date.getvalue()

    def __setfield_mod_date(self, value):
        if isinstance(value,PBDateTime):
            self.__field_mod_date=value
        else:
            self.__field_mod_date=PBDateTime(value,**{ 'defaulttocurrenttime': True })

    def __delfield_mod_date(self): del self.__field_mod_date

    mod_date=property(__getfield_mod_date, __setfield_mod_date, __delfield_mod_date, None)

    def __getfield_blanks(self):
        try: self.__field_blanks
        except:
            self.__field_blanks=DATA(**{'sizeinbytes': 221,  'default': '\x00'*221 })
        return self.__field_blanks.getvalue()

    def __setfield_blanks(self, value):
        if isinstance(value,DATA):
            self.__field_blanks=value
        else:
            self.__field_blanks=DATA(value,**{'sizeinbytes': 221,  'default': '\x00'*221 })

    def __delfield_blanks(self): del self.__field_blanks

    blanks=property(__getfield_blanks, __setfield_blanks, __delfield_blanks, None)

    def __getfield_eof_close_tag(self):
        try: self.__field_eof_close_tag
        except:
            self.__field_eof_close_tag=STRING(**{'sizeinbytes': 7,  'default': '</HPE>',               'raiseonunterminatedread': False,               'raiseontruncate': False  })
        return self.__field_eof_close_tag.getvalue()

    def __setfield_eof_close_tag(self, value):
        if isinstance(value,STRING):
            self.__field_eof_close_tag=value
        else:
            self.__field_eof_close_tag=STRING(value,**{'sizeinbytes': 7,  'default': '</HPE>',               'raiseonunterminatedread': False,               'raiseontruncate': False  })

    def __delfield_eof_close_tag(self): del self.__field_eof_close_tag

    eof_close_tag=property(__getfield_eof_close_tag, __setfield_eof_close_tag, __delfield_eof_close_tag, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('items', self.__field_items, None)
        yield ('eof_tag', self.__field_eof_tag, None)
        yield ('model_name', self.__field_model_name, None)
        yield ('mod_date', self.__field_mod_date, None)
        yield ('blanks', self.__field_blanks, None)
        yield ('eof_close_tag', self.__field_eof_close_tag, None)




class pnfileentry(BaseProtogenClass):
    __fields=['entry_tag', 'pad00', 'mod_date', 'unk0', 'pn_id', 'pe_id', 'pn_order', 'phone_number', 'ntype', 'unk2', 'exit_tag', 'blanks']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(pnfileentry,self).__init__(**dict)
        if self.__class__ is pnfileentry:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(pnfileentry,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(pnfileentry,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_entry_tag
        except:
            self.__field_entry_tag=STRING(**{'sizeinbytes': 4,  'terminator': None,                 'raiseonunterminatedread': False,                 'raiseontruncate': False,                 'default': '\xff\xff\xff\xff'})
        self.__field_entry_tag.writetobuffer(buf)
        if self.entry_tag != '\xff\xff\xff\xff':
            try: self.__field_pad00
            except:
                self.__field_pad00=UINT(**{'sizeinbytes': 1,  'default': 0 })
            self.__field_pad00.writetobuffer(buf)
            try: self.__field_mod_date
            except:
                self.__field_mod_date=PBDateTime(**{'defaulttocurrenttime': True })
            self.__field_mod_date.writetobuffer(buf)
            try: self.__field_unk0
            except:
                self.__field_unk0=STRING(**{'sizeinbytes': 6,  'default': '', 'raiseonunterminatedread': False })
            self.__field_unk0.writetobuffer(buf)
            self.__field_pn_id.writetobuffer(buf)
            self.__field_pe_id.writetobuffer(buf)
            self.__field_pn_order.writetobuffer(buf)
            self.__field_phone_number.writetobuffer(buf)
            self.__field_ntype.writetobuffer(buf)
            try: self.__field_unk2
            except:
                self.__field_unk2=UINT(**{'sizeinbytes': 3,  'default': 0 })
            self.__field_unk2.writetobuffer(buf)
            try: self.__field_exit_tag
            except:
                self.__field_exit_tag=USTRING(**{'sizeinbytes': 6,  'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '</PN>'})
            self.__field_exit_tag.writetobuffer(buf)
        else:
            try: self.__field_blanks
            except:
                self.__field_blanks=DATA(**{'sizeinbytes': 60,  'default': '\xFF'*60 })
            self.__field_blanks.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_entry_tag=STRING(**{'sizeinbytes': 4,  'terminator': None,                 'raiseonunterminatedread': False,                 'raiseontruncate': False,                 'default': '\xff\xff\xff\xff'})
        self.__field_entry_tag.readfrombuffer(buf)
        if self.entry_tag != '\xff\xff\xff\xff':
            self.__field_pad00=UINT(**{'sizeinbytes': 1,  'default': 0 })
            self.__field_pad00.readfrombuffer(buf)
            self.__field_mod_date=PBDateTime(**{'defaulttocurrenttime': True })
            self.__field_mod_date.readfrombuffer(buf)
            self.__field_unk0=STRING(**{'sizeinbytes': 6,  'default': '', 'raiseonunterminatedread': False })
            self.__field_unk0.readfrombuffer(buf)
            self.__field_pn_id=UINT(**{'sizeinbytes': 2})
            self.__field_pn_id.readfrombuffer(buf)
            self.__field_pe_id=UINT(**{'sizeinbytes': 2})
            self.__field_pe_id.readfrombuffer(buf)
            self.__field_pn_order=UINT(**{'sizeinbytes': 1})
            self.__field_pn_order.readfrombuffer(buf)
            self.__field_phone_number=LGHEXPN(**{'sizeinbytes': 25})
            self.__field_phone_number.readfrombuffer(buf)
            self.__field_ntype=UINT(**{'sizeinbytes': 2})
            self.__field_ntype.readfrombuffer(buf)
            self.__field_unk2=UINT(**{'sizeinbytes': 3,  'default': 0 })
            self.__field_unk2.readfrombuffer(buf)
            self.__field_exit_tag=USTRING(**{'sizeinbytes': 6,  'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '</PN>'})
            self.__field_exit_tag.readfrombuffer(buf)
        else:
            self.__field_blanks=DATA(**{'sizeinbytes': 60,  'default': '\xFF'*60 })
            self.__field_blanks.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_entry_tag(self):
        try: self.__field_entry_tag
        except:
            self.__field_entry_tag=STRING(**{'sizeinbytes': 4,  'terminator': None,                 'raiseonunterminatedread': False,                 'raiseontruncate': False,                 'default': '\xff\xff\xff\xff'})
        return self.__field_entry_tag.getvalue()

    def __setfield_entry_tag(self, value):
        if isinstance(value,STRING):
            self.__field_entry_tag=value
        else:
            self.__field_entry_tag=STRING(value,**{'sizeinbytes': 4,  'terminator': None,                 'raiseonunterminatedread': False,                 'raiseontruncate': False,                 'default': '\xff\xff\xff\xff'})

    def __delfield_entry_tag(self): del self.__field_entry_tag

    entry_tag=property(__getfield_entry_tag, __setfield_entry_tag, __delfield_entry_tag, None)

    def __getfield_pad00(self):
        try: self.__field_pad00
        except:
            self.__field_pad00=UINT(**{'sizeinbytes': 1,  'default': 0 })
        return self.__field_pad00.getvalue()

    def __setfield_pad00(self, value):
        if isinstance(value,UINT):
            self.__field_pad00=value
        else:
            self.__field_pad00=UINT(value,**{'sizeinbytes': 1,  'default': 0 })

    def __delfield_pad00(self): del self.__field_pad00

    pad00=property(__getfield_pad00, __setfield_pad00, __delfield_pad00, None)

    def __getfield_mod_date(self):
        try: self.__field_mod_date
        except:
            self.__field_mod_date=PBDateTime(**{'defaulttocurrenttime': True })
        return self.__field_mod_date.getvalue()

    def __setfield_mod_date(self, value):
        if isinstance(value,PBDateTime):
            self.__field_mod_date=value
        else:
            self.__field_mod_date=PBDateTime(value,**{'defaulttocurrenttime': True })

    def __delfield_mod_date(self): del self.__field_mod_date

    mod_date=property(__getfield_mod_date, __setfield_mod_date, __delfield_mod_date, None)

    def __getfield_unk0(self):
        try: self.__field_unk0
        except:
            self.__field_unk0=STRING(**{'sizeinbytes': 6,  'default': '', 'raiseonunterminatedread': False })
        return self.__field_unk0.getvalue()

    def __setfield_unk0(self, value):
        if isinstance(value,STRING):
            self.__field_unk0=value
        else:
            self.__field_unk0=STRING(value,**{'sizeinbytes': 6,  'default': '', 'raiseonunterminatedread': False })

    def __delfield_unk0(self): del self.__field_unk0

    unk0=property(__getfield_unk0, __setfield_unk0, __delfield_unk0, None)

    def __getfield_pn_id(self):
        return self.__field_pn_id.getvalue()

    def __setfield_pn_id(self, value):
        if isinstance(value,UINT):
            self.__field_pn_id=value
        else:
            self.__field_pn_id=UINT(value,**{'sizeinbytes': 2})

    def __delfield_pn_id(self): del self.__field_pn_id

    pn_id=property(__getfield_pn_id, __setfield_pn_id, __delfield_pn_id, None)

    def __getfield_pe_id(self):
        return self.__field_pe_id.getvalue()

    def __setfield_pe_id(self, value):
        if isinstance(value,UINT):
            self.__field_pe_id=value
        else:
            self.__field_pe_id=UINT(value,**{'sizeinbytes': 2})

    def __delfield_pe_id(self): del self.__field_pe_id

    pe_id=property(__getfield_pe_id, __setfield_pe_id, __delfield_pe_id, None)

    def __getfield_pn_order(self):
        return self.__field_pn_order.getvalue()

    def __setfield_pn_order(self, value):
        if isinstance(value,UINT):
            self.__field_pn_order=value
        else:
            self.__field_pn_order=UINT(value,**{'sizeinbytes': 1})

    def __delfield_pn_order(self): del self.__field_pn_order

    pn_order=property(__getfield_pn_order, __setfield_pn_order, __delfield_pn_order, "0-based order of this phone within this contact")

    def __getfield_phone_number(self):
        return self.__field_phone_number.getvalue()

    def __setfield_phone_number(self, value):
        if isinstance(value,LGHEXPN):
            self.__field_phone_number=value
        else:
            self.__field_phone_number=LGHEXPN(value,**{'sizeinbytes': 25})

    def __delfield_phone_number(self): del self.__field_phone_number

    phone_number=property(__getfield_phone_number, __setfield_phone_number, __delfield_phone_number, None)

    def __getfield_ntype(self):
        return self.__field_ntype.getvalue()

    def __setfield_ntype(self, value):
        if isinstance(value,UINT):
            self.__field_ntype=value
        else:
            self.__field_ntype=UINT(value,**{'sizeinbytes': 2})

    def __delfield_ntype(self): del self.__field_ntype

    ntype=property(__getfield_ntype, __setfield_ntype, __delfield_ntype, None)

    def __getfield_unk2(self):
        try: self.__field_unk2
        except:
            self.__field_unk2=UINT(**{'sizeinbytes': 3,  'default': 0 })
        return self.__field_unk2.getvalue()

    def __setfield_unk2(self, value):
        if isinstance(value,UINT):
            self.__field_unk2=value
        else:
            self.__field_unk2=UINT(value,**{'sizeinbytes': 3,  'default': 0 })

    def __delfield_unk2(self): del self.__field_unk2

    unk2=property(__getfield_unk2, __setfield_unk2, __delfield_unk2, None)

    def __getfield_exit_tag(self):
        try: self.__field_exit_tag
        except:
            self.__field_exit_tag=USTRING(**{'sizeinbytes': 6,  'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '</PN>'})
        return self.__field_exit_tag.getvalue()

    def __setfield_exit_tag(self, value):
        if isinstance(value,USTRING):
            self.__field_exit_tag=value
        else:
            self.__field_exit_tag=USTRING(value,**{'sizeinbytes': 6,  'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '</PN>'})

    def __delfield_exit_tag(self): del self.__field_exit_tag

    exit_tag=property(__getfield_exit_tag, __setfield_exit_tag, __delfield_exit_tag, None)

    def __getfield_blanks(self):
        try: self.__field_blanks
        except:
            self.__field_blanks=DATA(**{'sizeinbytes': 60,  'default': '\xFF'*60 })
        return self.__field_blanks.getvalue()

    def __setfield_blanks(self, value):
        if isinstance(value,DATA):
            self.__field_blanks=value
        else:
            self.__field_blanks=DATA(value,**{'sizeinbytes': 60,  'default': '\xFF'*60 })

    def __delfield_blanks(self): del self.__field_blanks

    blanks=property(__getfield_blanks, __setfield_blanks, __delfield_blanks, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('entry_tag', self.__field_entry_tag, None)
        if self.entry_tag != '\xff\xff\xff\xff':
            yield ('pad00', self.__field_pad00, None)
            yield ('mod_date', self.__field_mod_date, None)
            yield ('unk0', self.__field_unk0, None)
            yield ('pn_id', self.__field_pn_id, None)
            yield ('pe_id', self.__field_pe_id, None)
            yield ('pn_order', self.__field_pn_order, "0-based order of this phone within this contact")
            yield ('phone_number', self.__field_phone_number, None)
            yield ('ntype', self.__field_ntype, None)
            yield ('unk2', self.__field_unk2, None)
            yield ('exit_tag', self.__field_exit_tag, None)
        else:
            yield ('blanks', self.__field_blanks, None)

    def valid(self):
         return self.phone_number != None
    def malformed(self):
         # malformed (yet valid) entries have been seen on several phones including the VX-8550 and VX-10000
         return self.entry_tag != PB_NUMBER_SOR




class pnfile(BaseProtogenClass):
    __fields=['items']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(pnfile,self).__init__(**dict)
        if self.__class__ is pnfile:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(pnfile,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(pnfile,kwargs)
        if len(args):
            dict2={ 'elementclass': pnfileentry,             'createdefault': True,             'length': NUMPHONENUMBERENTRIES }
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_items=LIST(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_items
        except:
            self.__field_items=LIST(**{ 'elementclass': pnfileentry,             'createdefault': True,             'length': NUMPHONENUMBERENTRIES })
        self.__field_items.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_items=LIST(**{ 'elementclass': pnfileentry,             'createdefault': True,             'length': NUMPHONENUMBERENTRIES })
        self.__field_items.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_items(self):
        try: self.__field_items
        except:
            self.__field_items=LIST(**{ 'elementclass': pnfileentry,             'createdefault': True,             'length': NUMPHONENUMBERENTRIES })
        return self.__field_items.getvalue()

    def __setfield_items(self, value):
        if isinstance(value,LIST):
            self.__field_items=value
        else:
            self.__field_items=LIST(value,**{ 'elementclass': pnfileentry,             'createdefault': True,             'length': NUMPHONENUMBERENTRIES })

    def __delfield_items(self): del self.__field_items

    items=property(__getfield_items, __setfield_items, __delfield_items, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('items', self.__field_items, None)




class PathIndexEntry(BaseProtogenClass):
    __fields=['pathname']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(PathIndexEntry,self).__init__(**dict)
        if self.__class__ is PathIndexEntry:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(PathIndexEntry,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(PathIndexEntry,kwargs)
        if len(args):
            dict2={'sizeinbytes': 255,  'encoding': PHONE_ENCODING,                  'default': '' }
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_pathname=USTRING(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_pathname
        except:
            self.__field_pathname=USTRING(**{'sizeinbytes': 255,  'encoding': PHONE_ENCODING,                  'default': '' })
        self.__field_pathname.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_pathname=USTRING(**{'sizeinbytes': 255,  'encoding': PHONE_ENCODING,                  'default': '' })
        self.__field_pathname.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_pathname(self):
        try: self.__field_pathname
        except:
            self.__field_pathname=USTRING(**{'sizeinbytes': 255,  'encoding': PHONE_ENCODING,                  'default': '' })
        return self.__field_pathname.getvalue()

    def __setfield_pathname(self, value):
        if isinstance(value,USTRING):
            self.__field_pathname=value
        else:
            self.__field_pathname=USTRING(value,**{'sizeinbytes': 255,  'encoding': PHONE_ENCODING,                  'default': '' })

    def __delfield_pathname(self): del self.__field_pathname

    pathname=property(__getfield_pathname, __setfield_pathname, __delfield_pathname, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('pathname', self.__field_pathname, None)




class PathIndexFile(BaseProtogenClass):
    __fields=['items']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(PathIndexFile,self).__init__(**dict)
        if self.__class__ is PathIndexFile:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(PathIndexFile,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(PathIndexFile,kwargs)
        if len(args):
            dict2={ 'elementclass': PathIndexEntry,             'createdefault': True,             'length': NUMPHONEBOOKENTRIES }
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_items=LIST(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_items
        except:
            self.__field_items=LIST(**{ 'elementclass': PathIndexEntry,             'createdefault': True,             'length': NUMPHONEBOOKENTRIES })
        self.__field_items.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_items=LIST(**{ 'elementclass': PathIndexEntry,             'createdefault': True,             'length': NUMPHONEBOOKENTRIES })
        self.__field_items.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_items(self):
        try: self.__field_items
        except:
            self.__field_items=LIST(**{ 'elementclass': PathIndexEntry,             'createdefault': True,             'length': NUMPHONEBOOKENTRIES })
        return self.__field_items.getvalue()

    def __setfield_items(self, value):
        if isinstance(value,LIST):
            self.__field_items=value
        else:
            self.__field_items=LIST(value,**{ 'elementclass': PathIndexEntry,             'createdefault': True,             'length': NUMPHONEBOOKENTRIES })

    def __delfield_items(self): del self.__field_items

    items=property(__getfield_items, __setfield_items, __delfield_items, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('items', self.__field_items, None)




class RecordIdEntry(BaseProtogenClass):
    __fields=['idnum']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(RecordIdEntry,self).__init__(**dict)
        if self.__class__ is RecordIdEntry:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(RecordIdEntry,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(RecordIdEntry,kwargs)
        if len(args):
            dict2={'sizeinbytes': 4}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_idnum=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_idnum.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_idnum=UINT(**{'sizeinbytes': 4})
        self.__field_idnum.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_idnum(self):
        return self.__field_idnum.getvalue()

    def __setfield_idnum(self, value):
        if isinstance(value,UINT):
            self.__field_idnum=value
        else:
            self.__field_idnum=UINT(value,**{'sizeinbytes': 4})

    def __delfield_idnum(self): del self.__field_idnum

    idnum=property(__getfield_idnum, __setfield_idnum, __delfield_idnum, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('idnum', self.__field_idnum, None)




class iceentry(BaseProtogenClass):
    "ICE index entries"
    __fields=['entry_assigned', 'entry_number', 'pb_index', 'dontcare']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(iceentry,self).__init__(**dict)
        if self.__class__ is iceentry:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(iceentry,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(iceentry,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_entry_assigned
        except:
            self.__field_entry_assigned=UINT(**{'sizeinbytes': 2,  'default': 0 })
        self.__field_entry_assigned.writetobuffer(buf)
        try: self.__field_entry_number
        except:
            self.__field_entry_number=UINT(**{'sizeinbytes': 2,  'default': 0xffff })
        self.__field_entry_number.writetobuffer(buf)
        try: self.__field_pb_index
        except:
            self.__field_pb_index=UINT(**{'sizeinbytes': 2,  'default': 0 })
        self.__field_pb_index.writetobuffer(buf)
        try: self.__field_dontcare
        except:
            self.__field_dontcare=DATA(**{'sizeinbytes': 82,  'default': '\x00'*82 })
        self.__field_dontcare.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_entry_assigned=UINT(**{'sizeinbytes': 2,  'default': 0 })
        self.__field_entry_assigned.readfrombuffer(buf)
        self.__field_entry_number=UINT(**{'sizeinbytes': 2,  'default': 0xffff })
        self.__field_entry_number.readfrombuffer(buf)
        self.__field_pb_index=UINT(**{'sizeinbytes': 2,  'default': 0 })
        self.__field_pb_index.readfrombuffer(buf)
        self.__field_dontcare=DATA(**{'sizeinbytes': 82,  'default': '\x00'*82 })
        self.__field_dontcare.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_entry_assigned(self):
        try: self.__field_entry_assigned
        except:
            self.__field_entry_assigned=UINT(**{'sizeinbytes': 2,  'default': 0 })
        return self.__field_entry_assigned.getvalue()

    def __setfield_entry_assigned(self, value):
        if isinstance(value,UINT):
            self.__field_entry_assigned=value
        else:
            self.__field_entry_assigned=UINT(value,**{'sizeinbytes': 2,  'default': 0 })

    def __delfield_entry_assigned(self): del self.__field_entry_assigned

    entry_assigned=property(__getfield_entry_assigned, __setfield_entry_assigned, __delfield_entry_assigned, "0 if not assigned, 1 if assigned")

    def __getfield_entry_number(self):
        try: self.__field_entry_number
        except:
            self.__field_entry_number=UINT(**{'sizeinbytes': 2,  'default': 0xffff })
        return self.__field_entry_number.getvalue()

    def __setfield_entry_number(self, value):
        if isinstance(value,UINT):
            self.__field_entry_number=value
        else:
            self.__field_entry_number=UINT(value,**{'sizeinbytes': 2,  'default': 0xffff })

    def __delfield_entry_number(self): del self.__field_entry_number

    entry_number=property(__getfield_entry_number, __setfield_entry_number, __delfield_entry_number, "0-based ICE entry number")

    def __getfield_pb_index(self):
        try: self.__field_pb_index
        except:
            self.__field_pb_index=UINT(**{'sizeinbytes': 2,  'default': 0 })
        return self.__field_pb_index.getvalue()

    def __setfield_pb_index(self, value):
        if isinstance(value,UINT):
            self.__field_pb_index=value
        else:
            self.__field_pb_index=UINT(value,**{'sizeinbytes': 2,  'default': 0 })

    def __delfield_pb_index(self): del self.__field_pb_index

    pb_index=property(__getfield_pb_index, __setfield_pb_index, __delfield_pb_index, "0-based phone book entry number")

    def __getfield_dontcare(self):
        try: self.__field_dontcare
        except:
            self.__field_dontcare=DATA(**{'sizeinbytes': 82,  'default': '\x00'*82 })
        return self.__field_dontcare.getvalue()

    def __setfield_dontcare(self, value):
        if isinstance(value,DATA):
            self.__field_dontcare=value
        else:
            self.__field_dontcare=DATA(value,**{'sizeinbytes': 82,  'default': '\x00'*82 })

    def __delfield_dontcare(self): del self.__field_dontcare

    dontcare=property(__getfield_dontcare, __setfield_dontcare, __delfield_dontcare, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('entry_assigned', self.__field_entry_assigned, "0 if not assigned, 1 if assigned")
        yield ('entry_number', self.__field_entry_number, "0-based ICE entry number")
        yield ('pb_index', self.__field_pb_index, "0-based phone book entry number")
        yield ('dontcare', self.__field_dontcare, None)

    def valid(self):
        return self.entry_assigned==1 and \
               self.entry_number<NUMEMERGENCYCONTACTS and \
               self.pb_index<NUMPHONEBOOKENTRIES




class iceentryfile(BaseProtogenClass):
    __fields=['items']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(iceentryfile,self).__init__(**dict)
        if self.__class__ is iceentryfile:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(iceentryfile,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(iceentryfile,kwargs)
        if len(args):
            dict2={ 'elementclass': iceentry,              'createdefault': True,              'length': NUMEMERGENCYCONTACTS }
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_items=LIST(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_items
        except:
            self.__field_items=LIST(**{ 'elementclass': iceentry,              'createdefault': True,              'length': NUMEMERGENCYCONTACTS })
        self.__field_items.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_items=LIST(**{ 'elementclass': iceentry,              'createdefault': True,              'length': NUMEMERGENCYCONTACTS })
        self.__field_items.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_items(self):
        try: self.__field_items
        except:
            self.__field_items=LIST(**{ 'elementclass': iceentry,              'createdefault': True,              'length': NUMEMERGENCYCONTACTS })
        return self.__field_items.getvalue()

    def __setfield_items(self, value):
        if isinstance(value,LIST):
            self.__field_items=value
        else:
            self.__field_items=LIST(value,**{ 'elementclass': iceentry,              'createdefault': True,              'length': NUMEMERGENCYCONTACTS })

    def __delfield_items(self): del self.__field_items

    items=property(__getfield_items, __setfield_items, __delfield_items, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('items', self.__field_items, None)




class scheduleevent(BaseProtogenClass):
    __fields=['packet_size', 'pos', 'description', 'cdate', 'mdate', 'start', 'end_time', 'end_date', 'repeat', 'alarmindex_vibrate', 'ringtone', 'unknown1', 'alarmminutes', 'alarmhours', 'unknown2', 'unknown3', 'unknown4', 'serial_number']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(scheduleevent,self).__init__(**dict)
        if self.__class__ is scheduleevent:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(scheduleevent,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(scheduleevent,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed
        try: self.__field_packet_size
        except:
            self.__field_packet_size=UINT(**{ 'constant': 138 })


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_pos
        except:
            self.__field_pos=UINT(**{'sizeinbytes': 4,  'default': 0 })
        self.__field_pos.writetobuffer(buf)
        try: self.__field_description
        except:
            self.__field_description=USTRING(**{'sizeinbytes': 33, 'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '' })
        self.__field_description.writetobuffer(buf)
        try: self.__field_cdate
        except:
            self.__field_cdate=GPSDATE(**{'sizeinbytes': 4,  'default': GPSDATE.now() })
        self.__field_cdate.writetobuffer(buf)
        try: self.__field_mdate
        except:
            self.__field_mdate=GPSDATE(**{'sizeinbytes': 4,  'default': GPSDATE.now() })
        self.__field_mdate.writetobuffer(buf)
        try: self.__field_start
        except:
            self.__field_start=LGCALDATE(**{'sizeinbytes': 4,  'default': (0,0,0,0,0) })
        self.__field_start.writetobuffer(buf)
        try: self.__field_end_time
        except:
            self.__field_end_time=LGCALDATE(**{'sizeinbytes': 4,  'default': (0,0,0,0,0) })
        self.__field_end_time.writetobuffer(buf)
        try: self.__field_end_date
        except:
            self.__field_end_date=LGCALDATE(**{'sizeinbytes': 4,  'default': (0,0,0,0,0) })
        self.__field_end_date.writetobuffer(buf)
        try: self.__field_repeat
        except:
            self.__field_repeat=LGCALREPEAT(**{'sizeinbytes': 4,  'default': (0,0,0,0,0) })
        self.__field_repeat.writetobuffer(buf)
        try: self.__field_alarmindex_vibrate
        except:
            self.__field_alarmindex_vibrate=UINT(**{'sizeinbytes': 1,  'default': 0 })
        self.__field_alarmindex_vibrate.writetobuffer(buf)
        try: self.__field_ringtone
        except:
            self.__field_ringtone=UINT(**{'sizeinbytes': 1,  'default': 0 })
        self.__field_ringtone.writetobuffer(buf)
        try: self.__field_unknown1
        except:
            self.__field_unknown1=UINT(**{'sizeinbytes': 1,  'default': 0 })
        self.__field_unknown1.writetobuffer(buf)
        try: self.__field_alarmminutes
        except:
            self.__field_alarmminutes=UINT(**{'sizeinbytes': 1,  'default': 0xff })
        self.__field_alarmminutes.writetobuffer(buf)
        try: self.__field_alarmhours
        except:
            self.__field_alarmhours=UINT(**{'sizeinbytes': 1,  'default': 0xff })
        self.__field_alarmhours.writetobuffer(buf)
        try: self.__field_unknown2
        except:
            self.__field_unknown2=UINT(**{'sizeinbytes': 1,  'default': 0 })
        self.__field_unknown2.writetobuffer(buf)
        try: self.__field_unknown3
        except:
            self.__field_unknown3=UINT(**{'sizeinbytes': 2,  'default': 0x01FB })
        self.__field_unknown3.writetobuffer(buf)
        try: self.__field_unknown4
        except:
            self.__field_unknown4=UINT(**{'sizeinbytes': 4,  'default': 0 })
        self.__field_unknown4.writetobuffer(buf)
        try: self.__field_serial_number
        except:
            self.__field_serial_number=USTRING(**{'sizeinbytes': 65,  'default': '000000ca-00000000-0000000000-VX855V01', 'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False })
        self.__field_serial_number.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_pos=UINT(**{'sizeinbytes': 4,  'default': 0 })
        self.__field_pos.readfrombuffer(buf)
        self.__field_description=USTRING(**{'sizeinbytes': 33, 'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '' })
        self.__field_description.readfrombuffer(buf)
        self.__field_cdate=GPSDATE(**{'sizeinbytes': 4,  'default': GPSDATE.now() })
        self.__field_cdate.readfrombuffer(buf)
        self.__field_mdate=GPSDATE(**{'sizeinbytes': 4,  'default': GPSDATE.now() })
        self.__field_mdate.readfrombuffer(buf)
        self.__field_start=LGCALDATE(**{'sizeinbytes': 4,  'default': (0,0,0,0,0) })
        self.__field_start.readfrombuffer(buf)
        self.__field_end_time=LGCALDATE(**{'sizeinbytes': 4,  'default': (0,0,0,0,0) })
        self.__field_end_time.readfrombuffer(buf)
        self.__field_end_date=LGCALDATE(**{'sizeinbytes': 4,  'default': (0,0,0,0,0) })
        self.__field_end_date.readfrombuffer(buf)
        self.__field_repeat=LGCALREPEAT(**{'sizeinbytes': 4,  'default': (0,0,0,0,0) })
        self.__field_repeat.readfrombuffer(buf)
        self.__field_alarmindex_vibrate=UINT(**{'sizeinbytes': 1,  'default': 0 })
        self.__field_alarmindex_vibrate.readfrombuffer(buf)
        self.__field_ringtone=UINT(**{'sizeinbytes': 1,  'default': 0 })
        self.__field_ringtone.readfrombuffer(buf)
        self.__field_unknown1=UINT(**{'sizeinbytes': 1,  'default': 0 })
        self.__field_unknown1.readfrombuffer(buf)
        self.__field_alarmminutes=UINT(**{'sizeinbytes': 1,  'default': 0xff })
        self.__field_alarmminutes.readfrombuffer(buf)
        self.__field_alarmhours=UINT(**{'sizeinbytes': 1,  'default': 0xff })
        self.__field_alarmhours.readfrombuffer(buf)
        self.__field_unknown2=UINT(**{'sizeinbytes': 1,  'default': 0 })
        self.__field_unknown2.readfrombuffer(buf)
        self.__field_unknown3=UINT(**{'sizeinbytes': 2,  'default': 0x01FB })
        self.__field_unknown3.readfrombuffer(buf)
        self.__field_unknown4=UINT(**{'sizeinbytes': 4,  'default': 0 })
        self.__field_unknown4.readfrombuffer(buf)
        self.__field_serial_number=USTRING(**{'sizeinbytes': 65,  'default': '000000ca-00000000-0000000000-VX855V01', 'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False })
        self.__field_serial_number.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_packet_size(self):
        return self.__field_packet_size.getvalue()

    def __setfield_packet_size(self, value):
        if isinstance(value,UINT):
            self.__field_packet_size=value
        else:
            self.__field_packet_size=UINT(value,**{ 'constant': 138 })

    def __delfield_packet_size(self): del self.__field_packet_size

    packet_size=property(__getfield_packet_size, __setfield_packet_size, __delfield_packet_size, None)

    def __getfield_pos(self):
        try: self.__field_pos
        except:
            self.__field_pos=UINT(**{'sizeinbytes': 4,  'default': 0 })
        return self.__field_pos.getvalue()

    def __setfield_pos(self, value):
        if isinstance(value,UINT):
            self.__field_pos=value
        else:
            self.__field_pos=UINT(value,**{'sizeinbytes': 4,  'default': 0 })

    def __delfield_pos(self): del self.__field_pos

    pos=property(__getfield_pos, __setfield_pos, __delfield_pos, "position within file, used as an event id")

    def __getfield_description(self):
        try: self.__field_description
        except:
            self.__field_description=USTRING(**{'sizeinbytes': 33, 'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '' })
        return self.__field_description.getvalue()

    def __setfield_description(self, value):
        if isinstance(value,USTRING):
            self.__field_description=value
        else:
            self.__field_description=USTRING(value,**{'sizeinbytes': 33, 'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '' })

    def __delfield_description(self): del self.__field_description

    description=property(__getfield_description, __setfield_description, __delfield_description, None)

    def __getfield_cdate(self):
        try: self.__field_cdate
        except:
            self.__field_cdate=GPSDATE(**{'sizeinbytes': 4,  'default': GPSDATE.now() })
        return self.__field_cdate.getvalue()

    def __setfield_cdate(self, value):
        if isinstance(value,GPSDATE):
            self.__field_cdate=value
        else:
            self.__field_cdate=GPSDATE(value,**{'sizeinbytes': 4,  'default': GPSDATE.now() })

    def __delfield_cdate(self): del self.__field_cdate

    cdate=property(__getfield_cdate, __setfield_cdate, __delfield_cdate, None)

    def __getfield_mdate(self):
        try: self.__field_mdate
        except:
            self.__field_mdate=GPSDATE(**{'sizeinbytes': 4,  'default': GPSDATE.now() })
        return self.__field_mdate.getvalue()

    def __setfield_mdate(self, value):
        if isinstance(value,GPSDATE):
            self.__field_mdate=value
        else:
            self.__field_mdate=GPSDATE(value,**{'sizeinbytes': 4,  'default': GPSDATE.now() })

    def __delfield_mdate(self): del self.__field_mdate

    mdate=property(__getfield_mdate, __setfield_mdate, __delfield_mdate, None)

    def __getfield_start(self):
        try: self.__field_start
        except:
            self.__field_start=LGCALDATE(**{'sizeinbytes': 4,  'default': (0,0,0,0,0) })
        return self.__field_start.getvalue()

    def __setfield_start(self, value):
        if isinstance(value,LGCALDATE):
            self.__field_start=value
        else:
            self.__field_start=LGCALDATE(value,**{'sizeinbytes': 4,  'default': (0,0,0,0,0) })

    def __delfield_start(self): del self.__field_start

    start=property(__getfield_start, __setfield_start, __delfield_start, None)

    def __getfield_end_time(self):
        try: self.__field_end_time
        except:
            self.__field_end_time=LGCALDATE(**{'sizeinbytes': 4,  'default': (0,0,0,0,0) })
        return self.__field_end_time.getvalue()

    def __setfield_end_time(self, value):
        if isinstance(value,LGCALDATE):
            self.__field_end_time=value
        else:
            self.__field_end_time=LGCALDATE(value,**{'sizeinbytes': 4,  'default': (0,0,0,0,0) })

    def __delfield_end_time(self): del self.__field_end_time

    end_time=property(__getfield_end_time, __setfield_end_time, __delfield_end_time, None)

    def __getfield_end_date(self):
        try: self.__field_end_date
        except:
            self.__field_end_date=LGCALDATE(**{'sizeinbytes': 4,  'default': (0,0,0,0,0) })
        return self.__field_end_date.getvalue()

    def __setfield_end_date(self, value):
        if isinstance(value,LGCALDATE):
            self.__field_end_date=value
        else:
            self.__field_end_date=LGCALDATE(value,**{'sizeinbytes': 4,  'default': (0,0,0,0,0) })

    def __delfield_end_date(self): del self.__field_end_date

    end_date=property(__getfield_end_date, __setfield_end_date, __delfield_end_date, None)

    def __getfield_repeat(self):
        try: self.__field_repeat
        except:
            self.__field_repeat=LGCALREPEAT(**{'sizeinbytes': 4,  'default': (0,0,0,0,0) })
        return self.__field_repeat.getvalue()

    def __setfield_repeat(self, value):
        if isinstance(value,LGCALREPEAT):
            self.__field_repeat=value
        else:
            self.__field_repeat=LGCALREPEAT(value,**{'sizeinbytes': 4,  'default': (0,0,0,0,0) })

    def __delfield_repeat(self): del self.__field_repeat

    repeat=property(__getfield_repeat, __setfield_repeat, __delfield_repeat, None)

    def __getfield_alarmindex_vibrate(self):
        try: self.__field_alarmindex_vibrate
        except:
            self.__field_alarmindex_vibrate=UINT(**{'sizeinbytes': 1,  'default': 0 })
        return self.__field_alarmindex_vibrate.getvalue()

    def __setfield_alarmindex_vibrate(self, value):
        if isinstance(value,UINT):
            self.__field_alarmindex_vibrate=value
        else:
            self.__field_alarmindex_vibrate=UINT(value,**{'sizeinbytes': 1,  'default': 0 })

    def __delfield_alarmindex_vibrate(self): del self.__field_alarmindex_vibrate

    alarmindex_vibrate=property(__getfield_alarmindex_vibrate, __setfield_alarmindex_vibrate, __delfield_alarmindex_vibrate, None)

    def __getfield_ringtone(self):
        try: self.__field_ringtone
        except:
            self.__field_ringtone=UINT(**{'sizeinbytes': 1,  'default': 0 })
        return self.__field_ringtone.getvalue()

    def __setfield_ringtone(self, value):
        if isinstance(value,UINT):
            self.__field_ringtone=value
        else:
            self.__field_ringtone=UINT(value,**{'sizeinbytes': 1,  'default': 0 })

    def __delfield_ringtone(self): del self.__field_ringtone

    ringtone=property(__getfield_ringtone, __setfield_ringtone, __delfield_ringtone, None)

    def __getfield_unknown1(self):
        try: self.__field_unknown1
        except:
            self.__field_unknown1=UINT(**{'sizeinbytes': 1,  'default': 0 })
        return self.__field_unknown1.getvalue()

    def __setfield_unknown1(self, value):
        if isinstance(value,UINT):
            self.__field_unknown1=value
        else:
            self.__field_unknown1=UINT(value,**{'sizeinbytes': 1,  'default': 0 })

    def __delfield_unknown1(self): del self.__field_unknown1

    unknown1=property(__getfield_unknown1, __setfield_unknown1, __delfield_unknown1, None)

    def __getfield_alarmminutes(self):
        try: self.__field_alarmminutes
        except:
            self.__field_alarmminutes=UINT(**{'sizeinbytes': 1,  'default': 0xff })
        return self.__field_alarmminutes.getvalue()

    def __setfield_alarmminutes(self, value):
        if isinstance(value,UINT):
            self.__field_alarmminutes=value
        else:
            self.__field_alarmminutes=UINT(value,**{'sizeinbytes': 1,  'default': 0xff })

    def __delfield_alarmminutes(self): del self.__field_alarmminutes

    alarmminutes=property(__getfield_alarmminutes, __setfield_alarmminutes, __delfield_alarmminutes, "a value of 0xFF indicates not set")

    def __getfield_alarmhours(self):
        try: self.__field_alarmhours
        except:
            self.__field_alarmhours=UINT(**{'sizeinbytes': 1,  'default': 0xff })
        return self.__field_alarmhours.getvalue()

    def __setfield_alarmhours(self, value):
        if isinstance(value,UINT):
            self.__field_alarmhours=value
        else:
            self.__field_alarmhours=UINT(value,**{'sizeinbytes': 1,  'default': 0xff })

    def __delfield_alarmhours(self): del self.__field_alarmhours

    alarmhours=property(__getfield_alarmhours, __setfield_alarmhours, __delfield_alarmhours, "a value of 0xFF indicates not set")

    def __getfield_unknown2(self):
        try: self.__field_unknown2
        except:
            self.__field_unknown2=UINT(**{'sizeinbytes': 1,  'default': 0 })
        return self.__field_unknown2.getvalue()

    def __setfield_unknown2(self, value):
        if isinstance(value,UINT):
            self.__field_unknown2=value
        else:
            self.__field_unknown2=UINT(value,**{'sizeinbytes': 1,  'default': 0 })

    def __delfield_unknown2(self): del self.__field_unknown2

    unknown2=property(__getfield_unknown2, __setfield_unknown2, __delfield_unknown2, None)

    def __getfield_unknown3(self):
        try: self.__field_unknown3
        except:
            self.__field_unknown3=UINT(**{'sizeinbytes': 2,  'default': 0x01FB })
        return self.__field_unknown3.getvalue()

    def __setfield_unknown3(self, value):
        if isinstance(value,UINT):
            self.__field_unknown3=value
        else:
            self.__field_unknown3=UINT(value,**{'sizeinbytes': 2,  'default': 0x01FB })

    def __delfield_unknown3(self): del self.__field_unknown3

    unknown3=property(__getfield_unknown3, __setfield_unknown3, __delfield_unknown3, None)

    def __getfield_unknown4(self):
        try: self.__field_unknown4
        except:
            self.__field_unknown4=UINT(**{'sizeinbytes': 4,  'default': 0 })
        return self.__field_unknown4.getvalue()

    def __setfield_unknown4(self, value):
        if isinstance(value,UINT):
            self.__field_unknown4=value
        else:
            self.__field_unknown4=UINT(value,**{'sizeinbytes': 4,  'default': 0 })

    def __delfield_unknown4(self): del self.__field_unknown4

    unknown4=property(__getfield_unknown4, __setfield_unknown4, __delfield_unknown4, None)

    def __getfield_serial_number(self):
        try: self.__field_serial_number
        except:
            self.__field_serial_number=USTRING(**{'sizeinbytes': 65,  'default': '000000ca-00000000-0000000000-VX855V01', 'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False })
        return self.__field_serial_number.getvalue()

    def __setfield_serial_number(self, value):
        if isinstance(value,USTRING):
            self.__field_serial_number=value
        else:
            self.__field_serial_number=USTRING(value,**{'sizeinbytes': 65,  'default': '000000ca-00000000-0000000000-VX855V01', 'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False })

    def __delfield_serial_number(self): del self.__field_serial_number

    serial_number=property(__getfield_serial_number, __setfield_serial_number, __delfield_serial_number, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('packet_size', self.__field_packet_size, None)
        yield ('pos', self.__field_pos, "position within file, used as an event id")
        yield ('description', self.__field_description, None)
        yield ('cdate', self.__field_cdate, None)
        yield ('mdate', self.__field_mdate, None)
        yield ('start', self.__field_start, None)
        yield ('end_time', self.__field_end_time, None)
        yield ('end_date', self.__field_end_date, None)
        yield ('repeat', self.__field_repeat, None)
        yield ('alarmindex_vibrate', self.__field_alarmindex_vibrate, None)
        yield ('ringtone', self.__field_ringtone, None)
        yield ('unknown1', self.__field_unknown1, None)
        yield ('alarmminutes', self.__field_alarmminutes, "a value of 0xFF indicates not set")
        yield ('alarmhours', self.__field_alarmhours, "a value of 0xFF indicates not set")
        yield ('unknown2', self.__field_unknown2, None)
        yield ('unknown3', self.__field_unknown3, None)
        yield ('unknown4', self.__field_unknown4, None)
        yield ('serial_number', self.__field_serial_number, None)




class schedulefile(BaseProtogenClass):
    __fields=['numactiveitems', 'events']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(schedulefile,self).__init__(**dict)
        if self.__class__ is schedulefile:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(schedulefile,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(schedulefile,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_numactiveitems.writetobuffer(buf)
        try: self.__field_events
        except:
            self.__field_events=LIST(**{ 'elementclass': scheduleevent, 'length': NUMCALENDARENTRIES, 'createdefault': True })
        self.__field_events.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_numactiveitems=UINT(**{'sizeinbytes': 2})
        self.__field_numactiveitems.readfrombuffer(buf)
        self.__field_events=LIST(**{ 'elementclass': scheduleevent, 'length': NUMCALENDARENTRIES, 'createdefault': True })
        self.__field_events.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_numactiveitems(self):
        return self.__field_numactiveitems.getvalue()

    def __setfield_numactiveitems(self, value):
        if isinstance(value,UINT):
            self.__field_numactiveitems=value
        else:
            self.__field_numactiveitems=UINT(value,**{'sizeinbytes': 2})

    def __delfield_numactiveitems(self): del self.__field_numactiveitems

    numactiveitems=property(__getfield_numactiveitems, __setfield_numactiveitems, __delfield_numactiveitems, None)

    def __getfield_events(self):
        try: self.__field_events
        except:
            self.__field_events=LIST(**{ 'elementclass': scheduleevent, 'length': NUMCALENDARENTRIES, 'createdefault': True })
        return self.__field_events.getvalue()

    def __setfield_events(self, value):
        if isinstance(value,LIST):
            self.__field_events=value
        else:
            self.__field_events=LIST(value,**{ 'elementclass': scheduleevent, 'length': NUMCALENDARENTRIES, 'createdefault': True })

    def __delfield_events(self): del self.__field_events

    events=property(__getfield_events, __setfield_events, __delfield_events, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('numactiveitems', self.__field_numactiveitems, None)
        yield ('events', self.__field_events, None)




class scheduleringerfile(BaseProtogenClass):
    __fields=['numringers', 'ringerpaths']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(scheduleringerfile,self).__init__(**dict)
        if self.__class__ is scheduleringerfile:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(scheduleringerfile,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(scheduleringerfile,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_numringers.writetobuffer(buf)
        try: self.__field_ringerpaths
        except:
            self.__field_ringerpaths=LIST(**{'elementclass': _gen_p_lgvx8550_205})
        self.__field_ringerpaths.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_numringers=UINT(**{'sizeinbytes': 4})
        self.__field_numringers.readfrombuffer(buf)
        self.__field_ringerpaths=LIST(**{'elementclass': _gen_p_lgvx8550_205})
        self.__field_ringerpaths.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_numringers(self):
        return self.__field_numringers.getvalue()

    def __setfield_numringers(self, value):
        if isinstance(value,UINT):
            self.__field_numringers=value
        else:
            self.__field_numringers=UINT(value,**{'sizeinbytes': 4})

    def __delfield_numringers(self): del self.__field_numringers

    numringers=property(__getfield_numringers, __setfield_numringers, __delfield_numringers, None)

    def __getfield_ringerpaths(self):
        try: self.__field_ringerpaths
        except:
            self.__field_ringerpaths=LIST(**{'elementclass': _gen_p_lgvx8550_205})
        return self.__field_ringerpaths.getvalue()

    def __setfield_ringerpaths(self, value):
        if isinstance(value,LIST):
            self.__field_ringerpaths=value
        else:
            self.__field_ringerpaths=LIST(value,**{'elementclass': _gen_p_lgvx8550_205})

    def __delfield_ringerpaths(self): del self.__field_ringerpaths

    ringerpaths=property(__getfield_ringerpaths, __setfield_ringerpaths, __delfield_ringerpaths, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('numringers', self.__field_numringers, None)
        yield ('ringerpaths', self.__field_ringerpaths, None)




class _gen_p_lgvx8550_205(BaseProtogenClass):
    'Anonymous inner class'
    __fields=['path']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(_gen_p_lgvx8550_205,self).__init__(**dict)
        if self.__class__ is _gen_p_lgvx8550_205:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(_gen_p_lgvx8550_205,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(_gen_p_lgvx8550_205,kwargs)
        if len(args):
            dict2={'sizeinbytes': 256,  'encoding': PHONE_ENCODING, 'raiseontruncate': True }
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_path=USTRING(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_path.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_path=USTRING(**{'sizeinbytes': 256,  'encoding': PHONE_ENCODING, 'raiseontruncate': True })
        self.__field_path.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_path(self):
        return self.__field_path.getvalue()

    def __setfield_path(self, value):
        if isinstance(value,USTRING):
            self.__field_path=value
        else:
            self.__field_path=USTRING(value,**{'sizeinbytes': 256,  'encoding': PHONE_ENCODING, 'raiseontruncate': True })

    def __delfield_path(self): del self.__field_path

    path=property(__getfield_path, __setfield_path, __delfield_path, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('path', self.__field_path, None)




class textmemo(BaseProtogenClass):
    __fields=['cdate', 'text', 'memotime', 'zeros']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(textmemo,self).__init__(**dict)
        if self.__class__ is textmemo:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(textmemo,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(textmemo,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_cdate
        except:
            self.__field_cdate=GPSDATE(**{'sizeinbytes': 4,  'default': GPSDATE.now(),                'unique': True })
        self.__field_cdate.writetobuffer(buf)
        self.__field_text.writetobuffer(buf)
        self.__field_memotime.writetobuffer(buf)
        try: self.__field_zeros
        except:
            self.__field_zeros=UNKNOWN(**{'sizeinbytes': 3})
        self.__field_zeros.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_cdate=GPSDATE(**{'sizeinbytes': 4,  'default': GPSDATE.now(),                'unique': True })
        self.__field_cdate.readfrombuffer(buf)
        self.__field_text=USTRING(**{'sizeinbytes': 301, 'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False })
        self.__field_text.readfrombuffer(buf)
        self.__field_memotime=LGCALDATE(**{'sizeinbytes': 4})
        self.__field_memotime.readfrombuffer(buf)
        self.__field_zeros=UNKNOWN(**{'sizeinbytes': 3})
        self.__field_zeros.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_cdate(self):
        try: self.__field_cdate
        except:
            self.__field_cdate=GPSDATE(**{'sizeinbytes': 4,  'default': GPSDATE.now(),                'unique': True })
        return self.__field_cdate.getvalue()

    def __setfield_cdate(self, value):
        if isinstance(value,GPSDATE):
            self.__field_cdate=value
        else:
            self.__field_cdate=GPSDATE(value,**{'sizeinbytes': 4,  'default': GPSDATE.now(),                'unique': True })

    def __delfield_cdate(self): del self.__field_cdate

    cdate=property(__getfield_cdate, __setfield_cdate, __delfield_cdate, None)

    def __getfield_text(self):
        return self.__field_text.getvalue()

    def __setfield_text(self, value):
        if isinstance(value,USTRING):
            self.__field_text=value
        else:
            self.__field_text=USTRING(value,**{'sizeinbytes': 301, 'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False })

    def __delfield_text(self): del self.__field_text

    text=property(__getfield_text, __setfield_text, __delfield_text, None)

    def __getfield_memotime(self):
        return self.__field_memotime.getvalue()

    def __setfield_memotime(self, value):
        if isinstance(value,LGCALDATE):
            self.__field_memotime=value
        else:
            self.__field_memotime=LGCALDATE(value,**{'sizeinbytes': 4})

    def __delfield_memotime(self): del self.__field_memotime

    memotime=property(__getfield_memotime, __setfield_memotime, __delfield_memotime, None)

    def __getfield_zeros(self):
        try: self.__field_zeros
        except:
            self.__field_zeros=UNKNOWN(**{'sizeinbytes': 3})
        return self.__field_zeros.getvalue()

    def __setfield_zeros(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_zeros=value
        else:
            self.__field_zeros=UNKNOWN(value,**{'sizeinbytes': 3})

    def __delfield_zeros(self): del self.__field_zeros

    zeros=property(__getfield_zeros, __setfield_zeros, __delfield_zeros, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('cdate', self.__field_cdate, None)
        yield ('text', self.__field_text, None)
        yield ('memotime', self.__field_memotime, None)
        yield ('zeros', self.__field_zeros, None)




class textmemofile(BaseProtogenClass):
    __fields=['itemcount', 'items']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(textmemofile,self).__init__(**dict)
        if self.__class__ is textmemofile:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(textmemofile,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(textmemofile,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_itemcount.writetobuffer(buf)
        try: self.__field_items
        except:
            self.__field_items=LIST(**{ 'elementclass': textmemo })
        self.__field_items.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_itemcount=UINT(**{'sizeinbytes': 4})
        self.__field_itemcount.readfrombuffer(buf)
        self.__field_items=LIST(**{ 'elementclass': textmemo })
        self.__field_items.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_itemcount(self):
        return self.__field_itemcount.getvalue()

    def __setfield_itemcount(self, value):
        if isinstance(value,UINT):
            self.__field_itemcount=value
        else:
            self.__field_itemcount=UINT(value,**{'sizeinbytes': 4})

    def __delfield_itemcount(self): del self.__field_itemcount

    itemcount=property(__getfield_itemcount, __setfield_itemcount, __delfield_itemcount, None)

    def __getfield_items(self):
        try: self.__field_items
        except:
            self.__field_items=LIST(**{ 'elementclass': textmemo })
        return self.__field_items.getvalue()

    def __setfield_items(self, value):
        if isinstance(value,LIST):
            self.__field_items=value
        else:
            self.__field_items=LIST(value,**{ 'elementclass': textmemo })

    def __delfield_items(self): del self.__field_items

    items=property(__getfield_items, __setfield_items, __delfield_items, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('itemcount', self.__field_itemcount, None)
        yield ('items', self.__field_items, None)




