/*
 * Decompiled with CFR 0.152.
 */
package yuku.alkitabconverter.yet;

import gnu.trove.list.array.TIntArrayList;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import yuku.alkitab.model.FootnoteEntry;
import yuku.alkitab.model.XrefEntry;
import yuku.alkitab.util.Ari;
import yuku.alkitab.yes2.model.PericopeData;
import yuku.alkitabconverter.util.Rec;

public class YetFileInput {
    static Matcher xrefMatcher = Pattern.compile("@<x([0-9]+)@>").matcher("");
    static Matcher footnoteMatcher = Pattern.compile("@<f([0-9]+)@>").matcher("");

    public YetFileInputResult parse(String nf) throws Exception {
        LinkedHashMap<Integer, Integer> nversePerBook = new LinkedHashMap<Integer, Integer>();
        int lastBook_1 = 1;
        int lastChapter_1 = 1;
        int lastVerse_1 = 0;
        PericopeData.Entry lastPericopeEntry = null;
        YetFileInputResult res = new YetFileInputResult();
        int report_line_number = 0;
        String report_line_text = null;
        try {
            Scanner sc = new Scanner((InputStream)new BufferedInputStream(new FileInputStream(nf), 0x1400000), "utf-8");
            while (sc.hasNextLine()) {
                int verse_1;
                String line = sc.nextLine();
                ++report_line_number;
                report_line_text = line;
                String[] splits = line.split("\t", -1);
                String command = splits[0];
                if ("info".equals(command)) {
                    String k = splits[1];
                    String v = splits[2];
                    res.addInfo(k, v);
                    continue;
                }
                if ("pericope".equals(command)) {
                    int book_1 = Integer.parseInt(splits[1]);
                    int chapter_1 = Integer.parseInt(splits[2]);
                    verse_1 = Integer.parseInt(splits[3]);
                    String text = splits[4];
                    lastPericopeEntry = new PericopeData.Entry();
                    res.addPericopeEntry(lastPericopeEntry);
                    lastPericopeEntry.ari = book_1 - 1 << 16 | chapter_1 << 8 | verse_1;
                    lastPericopeEntry.block = new PericopeData.Block();
                    lastPericopeEntry.block.title = text;
                    continue;
                }
                if ("parallel".equals(command)) {
                    String text = splits[1];
                    if (lastPericopeEntry == null) {
                        throw new RuntimeException("parallel encountered before pericope title: " + line);
                    }
                    lastPericopeEntry.block.addParallel(text);
                    continue;
                }
                if ("book_name".equals(command)) {
                    int book_1 = Integer.parseInt(splits[1]);
                    String bookName = splits[2];
                    String bookAbbreviation = splits.length > 3 && splits[3] != null && !splits[3].isEmpty() ? splits[3] : null;
                    res.addBookName(book_1, bookName, bookAbbreviation);
                    continue;
                }
                if ("verse".equals(command)) {
                    int book_1 = Integer.parseInt(splits[1]);
                    int chapter_1 = Integer.parseInt(splits[2]);
                    verse_1 = Integer.parseInt(splits[3]);
                    String text = splits[4];
                    boolean validOrdering = false;
                    if (verse_1 == lastVerse_1 + 1) {
                        validOrdering = true;
                    } else if (verse_1 == 1 && chapter_1 == lastChapter_1 + 1) {
                        validOrdering = true;
                    } else if (verse_1 == 1 && chapter_1 == 1) {
                        validOrdering = true;
                        if (book_1 != lastBook_1 + 1) {
                            System.err.println("warning: some book(s) skipped. current book_1: " + book_1 + " previous book_1: " + lastBook_1);
                        }
                    }
                    if (!validOrdering) {
                        throw new RuntimeException("wrong verse ordering at line: " + line);
                    }
                    Rec rec = new Rec();
                    rec.book_1 = book_1;
                    rec.chapter_1 = chapter_1;
                    rec.verse_1 = verse_1;
                    rec.text = text;
                    res.addRec(rec);
                    nversePerBook.put(book_1, (nversePerBook.get(book_1) == null ? 0 : (Integer)nversePerBook.get(book_1)) + 1);
                    lastBook_1 = book_1;
                    lastChapter_1 = chapter_1;
                    lastVerse_1 = verse_1;
                    continue;
                }
                if ("xref".equals(command)) {
                    int book_1 = Integer.parseInt(splits[1]);
                    int chapter_1 = Integer.parseInt(splits[2]);
                    verse_1 = Integer.parseInt(splits[3]);
                    int field_1 = Integer.parseInt(splits[4]);
                    String content = splits[5];
                    XrefEntry xe = new XrefEntry();
                    xe.content = content;
                    res.addXrefEntry(Ari.encode(book_1 - 1, chapter_1, verse_1) << 8 | field_1, xe);
                    continue;
                }
                if ("footnote".equals(command)) {
                    int book_1 = Integer.parseInt(splits[1]);
                    int chapter_1 = Integer.parseInt(splits[2]);
                    verse_1 = Integer.parseInt(splits[3]);
                    int field_1 = Integer.parseInt(splits[4]);
                    String content = splits[5];
                    FootnoteEntry fe = new FootnoteEntry();
                    fe.content = content;
                    res.addFootnoteEntry(Ari.encode(book_1 - 1, chapter_1, verse_1) << 8 | field_1, fe);
                    continue;
                }
                if (command.trim().startsWith("#") || command.trim().length() == 0) continue;
                System.err.println("unknown line encountered: " + line);
                return null;
            }
        }
        catch (Exception e) {
            System.err.println("Error in line " + report_line_number + ": " + report_line_text);
            throw e;
        }
        TIntArrayList footnoteArifs = new TIntArrayList();
        TIntArrayList xrefArifs = new TIntArrayList();
        ArrayList<String> errors = new ArrayList<String>();
        for (Rec rec : res.recs) {
            int field;
            int ari = Ari.encode(rec.book_1 - 1, rec.chapter_1, rec.verse_1);
            String text = rec.text;
            footnoteMatcher.reset(text);
            while (footnoteMatcher.find()) {
                field = Integer.parseInt(footnoteMatcher.group(1));
                if (field < 1 || field > 255) {
                    throw new RuntimeException("footnote field not in 1-255: " + text);
                }
                footnoteArifs.add(ari << 8 | field);
            }
            xrefMatcher.reset(text);
            while (xrefMatcher.find()) {
                field = Integer.parseInt(xrefMatcher.group(1));
                if (field < 1 || field > 255) {
                    throw new RuntimeException("xref field not in 1-255: " + text);
                }
                xrefArifs.add(ari << 8 | field);
            }
        }
        for (Object arif : (Iterator)footnoteArifs.toArray()) {
            if (res.footnoteEntries != null && res.footnoteEntries.containsKey((int)arif)) continue;
            reference ari = arif >>> 8;
            errors.add(String.format("footnote referenced in verse text not found: arif 0x%08x (book_1=%d, chapter_1=%d, verse_1=%d, field=%d)", (int)arif, Ari.toBook((int)ari) + 1, Ari.toChapter((int)ari), Ari.toVerse((int)ari), arif & 0xFF));
        }
        for (Object arif : (Iterator)xrefArifs.toArray()) {
            if (res.xrefEntries != null && res.xrefEntries.containsKey((int)arif)) continue;
            reference ari = arif >>> 8;
            errors.add(String.format("xref referenced in verse text not found: arif 0x%08x (book_1=%d, chapter_1=%d, verse_1=%d, field=%d)", (int)arif, Ari.toBook((int)ari) + 1, Ari.toChapter((int)ari), Ari.toVerse((int)ari), arif & 0xFF));
        }
        if (errors.size() != 0) {
            for (String error : errors) {
                System.err.println(error);
            }
            throw new RuntimeException("there are footnotes and/or xrefs not resolved");
        }
        for (Map.Entry e : nversePerBook.entrySet()) {
            System.err.println("book_1 " + e.getKey() + ": " + e.getValue() + " verses");
        }
        res.setNumberOfBooks(nversePerBook.size());
        return res;
    }

    public static class YetFileInputResult {
        public List<Rec> recs;
        public PericopeData pericopeData;
        public Map<String, String> infos;
        public int numberOfBooks;
        public Map<Integer, String> bookNames;
        public Map<Integer, String> bookAbbreviations;
        public LinkedHashMap<Integer, XrefEntry> xrefEntries;
        public LinkedHashMap<Integer, FootnoteEntry> footnoteEntries;

        void addInfo(String k, String v) {
            if (this.infos == null) {
                this.infos = new LinkedHashMap<String, String>();
            }
            this.infos.put(k, v);
        }

        void addPericopeEntry(PericopeData.Entry e) {
            if (this.pericopeData == null) {
                this.pericopeData = new PericopeData();
            }
            this.pericopeData.addEntry(e);
        }

        void addRec(Rec rec) {
            if (this.recs == null) {
                this.recs = new ArrayList<Rec>();
            }
            this.recs.add(rec);
        }

        void addBookName(int book_1, String bookName, String bookAbbreviation) {
            if (this.bookNames == null) {
                this.bookNames = new TreeMap<Integer, String>();
                this.bookAbbreviations = new TreeMap<Integer, String>();
            }
            this.bookNames.put(book_1, bookName);
            this.bookAbbreviations.put(book_1, bookAbbreviation);
        }

        void setNumberOfBooks(int numberOfBooks) {
            this.numberOfBooks = numberOfBooks;
        }

        public void addXrefEntry(int arif, XrefEntry xe) {
            if (this.xrefEntries == null) {
                this.xrefEntries = new LinkedHashMap();
            }
            this.xrefEntries.put(arif, xe);
        }

        public void addFootnoteEntry(int arif, FootnoteEntry fe) {
            if (this.footnoteEntries == null) {
                this.footnoteEntries = new LinkedHashMap();
            }
            this.footnoteEntries.put(arif, fe);
        }

        public List<String> getBookNamesAsList() {
            ArrayList<String> res = new ArrayList<String>();
            for (Map.Entry<Integer, String> e : this.bookNames.entrySet()) {
                int index = e.getKey() - 1;
                while (index + 1 > res.size()) {
                    res.add(null);
                }
                res.set(index, e.getValue());
            }
            return res;
        }

        public List<String> getBookAbbreviationsAsList() {
            ArrayList<String> res = new ArrayList<String>();
            for (Map.Entry<Integer, String> e : this.bookAbbreviations.entrySet()) {
                int index = e.getKey() - 1;
                while (index + 1 > res.size()) {
                    res.add(null);
                }
                res.set(index, e.getValue());
            }
            return res;
        }
    }
}

