#!/usr/bin/python
#Copyright (C) 2007-2008 Don Brown 2010 Spike Burch <spikeb@gmail.com>
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.

import pygame, sys,os, random, string
from pygame.locals import * 

# figure out the install base to use with image and sound loading
progInstallBase = os.path.dirname(os.path.normpath(sys.argv[0]));
screenheight, screenwidth = 600,800

# Load image in data/, handling setting of the transparency color key
def load_image(name, colorkey=None):
    fullname = os.path.join(progInstallBase, 'data', name)
    
    try:
        image = pygame.image.load(fullname)
    except pygame.error, message:
        print "Cannot load image:", name
        raise SystemExit, message
    image = image.convert()
    if colorkey is not None:
        if colorkey is -1:
            colorkey = image.get_at((0,0))
        image.set_colorkey(colorkey, RLEACCEL)
    return image, image.get_rect()

# Load sound file in data/
def load_sound(name):
    class NoneSound:
        def play(self): pass
    if not pygame.mixer:
        return NoneSound()
    fullname = os.path.join(progInstallBase, 'data', name)
    try:
        sound = pygame.mixer.Sound(fullname)
    except pygame.error, message:
        print "Cannot load sound:", fullname
        raise SystemExit, message
    return sound

# Loads a list of sounds
def load_sounds(lst):
    result = []
    for name in lst:
        result.append(load_sound(name))
    return result

# Processes events
def input(events, quit_pos):
    
    for event in events: 
        if event.type == QUIT: 
            sys.exit(0) 
        elif event.type == KEYDOWN or event.type == MOUSEBUTTONDOWN:
            #print "eepos: %s" % (quit_pos)
            
            if event.type == KEYDOWN:
                if event.key == K_q:
                    quit_pos = 1
                elif ((event.key == K_u) and (quit_pos == 1)):
                    quit_pos = 2
                elif event.key == K_i and quit_pos == 2:
                    quit_pos = 3
                elif event.key == K_t and quit_pos == 3:
                    sys.exit(0)
                else:
                    quit_pos = 0

            # Clear the background 10% of the time
            if random.randint(0, 10) == 1:
                screen.blit(background, (0, 0))
                pygame.display.flip()
            sounds[random.randint(0, len(sounds) -1)].play()

            if event.type == MOUSEBUTTONDOWN or not(is_alpha(event.key)):
                print_image()
            else:
                print_letter(event.key)
            
            pygame.display.flip() 
    return quit_pos

# Prints an image at a random location
def print_image():
    global screenheight, screenwidth
    img = images[random.randint(0, len(images) -1)]
    w = random.randint(0, screenwidth-img.get_width())
    h = random.randint(0, screenheight-img.get_height())
    screen.blit(img, (w, h)) 

# Is the key that was pressed alphanumeric
def is_alpha(key):
    return key < 255 and (chr(key) in string.letters or chr(key) in string.digits)

# Prints a letter at a random location
def print_letter(key):
    global screenheight, screenwidth
    font = pygame.font.Font(None, 256)
    text = font.render(chr(key), 1, colors[random.randint(0, len(colors) -1)])
    textpos = text.get_rect()
    center = (textpos.width / 2, textpos.height / 2)
    w = random.randint(0+center[0], screenwidth-center[0])
    h = random.randint(0+center[1], screenheight-center[1])
    textpos.centerx = w
    textpos.centery = h
    screen.blit(text, textpos) 

# Main application
#
if not pygame.font: print 'Warning, fonts disabled'
if not pygame.mixer: print 'Warning, sound disabled'
 
pygame.init() 
 
window = pygame.display.set_mode((0,0), pygame.FULLSCREEN) 
pygame.display.set_caption('Bam Bam') 
screen = pygame.display.get_surface() 
screenwidth = screen.get_width()
screenheight = screen.get_height()
background = pygame.Surface(screen.get_size())
background = background.convert()
background.fill((250, 250, 250))

screen.blit(background, (0, 0))
pygame.display.flip()

sounds = load_sounds(('boilingwater1a.wav','whiff.wav', 'punch.wav','boom.wav','house_lo.wav','secosmic_lo.wav','churchbell1.wav', 'hen2.wav','horse1a.wav','jet2.wav','lamb.wav','register.wav','splat2a.wav', 'splat3a.wav','zipperdn1.wav'))
colors = ((0,0,255), (255,0,0), (0,255,0), (255, 0, 255),(255, 255, 0))
images = (load_image("chimp.bmp", -1)[0],load_image('alien1.gif')[0],load_image('dog.gif')[0],load_image('frog.gif')[0],load_image('tux.gif')[0],load_image('bear.gif')[0],load_image('iguana.gif')[0],load_image('kangaroo.gif')[0])

quit_pos = 0   

clock = pygame.time.Clock()
while True:
    clock.tick(60)
    quit_pos = input(pygame.event.get(), quit_pos) 

