/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 16:40:39 GMT 2018
 */

package uk.ac.sanger.artemis;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.datatransfer.Clipboard;
import java.util.NoSuchElementException;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.ActionController;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.EntryChangeEvent;
import uk.ac.sanger.artemis.EntryGroupChangeListener;
import uk.ac.sanger.artemis.EntryVector;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.FeatureEnumeration;
import uk.ac.sanger.artemis.FeatureKeyPredicate;
import uk.ac.sanger.artemis.FeatureKeyQualifierPredicate;
import uk.ac.sanger.artemis.FeatureVector;
import uk.ac.sanger.artemis.FilteredEntryGroup;
import uk.ac.sanger.artemis.Selection;
import uk.ac.sanger.artemis.SimpleEntryGroup;
import uk.ac.sanger.artemis.io.EmblStreamSequence;
import uk.ac.sanger.artemis.io.GenbankStreamSequence;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.RawStreamSequence;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.sequence.Bases;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class SimpleEntryGroup_ESTest extends SimpleEntryGroup_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      
      // Undeclared exception!
      try { 
        simpleEntryGroup0.getFeaturesInIndexRange((-481), 0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - index out of range: -481
         //
         verifyException("uk.ac.sanger.artemis.SimpleEntryGroup", e);
      }
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      
      Entry entry0 = simpleEntryGroup0.createEntry();
      assertNotNull(entry0);
      assertEquals(1, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertFalse(entry0.isReadOnly());
      
      // Undeclared exception!
      try { 
        simpleEntryGroup0.getFeaturesInIndexRange(0, 0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - index out of range: 0
         //
         verifyException("uk.ac.sanger.artemis.SimpleEntryGroup", e);
      }
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      
      simpleEntryGroup0.ref();
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(1, simpleEntryGroup0.refCount());
      
      int int0 = simpleEntryGroup0.refCount();
      assertEquals(1, int0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(1, simpleEntryGroup0.refCount());
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("5_3Xe<vy\"?Ro)bhS");
      assertNotNull(emblStreamSequence0);
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(16, emblStreamSequence0.getOtherCount());
      assertEquals(16, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(0, emblStreamSequence0.getGCount());
      
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence(emblStreamSequence0);
      assertNotNull(rawStreamSequence0);
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(16, emblStreamSequence0.getOtherCount());
      assertEquals(16, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(16, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(16, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getACount());
      
      Bases bases0 = new Bases(rawStreamSequence0);
      assertNotNull(bases0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(16, emblStreamSequence0.getOtherCount());
      assertEquals(16, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(16, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(16, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(16, bases0.getLength());
      
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      assertNotNull(simpleEntryGroup0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(16, emblStreamSequence0.getOtherCount());
      assertEquals(16, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(16, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(16, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(16, bases0.getLength());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(16, simpleEntryGroup0.getSequenceLength());
      assertEquals(0, simpleEntryGroup0.size());
      
      Entry entry0 = simpleEntryGroup0.createEntry();
      assertNotNull(entry0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(16, emblStreamSequence0.getOtherCount());
      assertEquals(16, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(16, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(16, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(16, bases0.getLength());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(1, simpleEntryGroup0.size());
      assertEquals(16, simpleEntryGroup0.getSequenceLength());
      assertFalse(entry0.isReadOnly());
      
      Entry entry1 = simpleEntryGroup0.getDefaultEntry();
      assertNotNull(entry1);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertSame(entry1, entry0);
      assertEquals(0, emblStreamSequence0.getACount());
      assertEquals(1, emblStreamSequence0.getFormatType());
      assertEquals(0, emblStreamSequence0.getCCount());
      assertEquals(0, emblStreamSequence0.getTCount());
      assertEquals(16, emblStreamSequence0.getOtherCount());
      assertEquals(16, emblStreamSequence0.length());
      assertNull(emblStreamSequence0.getHeader());
      assertEquals(0, emblStreamSequence0.getGCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(16, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(16, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(16, bases0.getLength());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(1, simpleEntryGroup0.size());
      assertEquals(16, simpleEntryGroup0.getSequenceLength());
      assertFalse(entry1.isReadOnly());
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      
      simpleEntryGroup0.ref();
      assertEquals(1, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      
      simpleEntryGroup0.addEntryGroupChangeListener((EntryGroupChangeListener) null);
      assertEquals(1, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      
      // Undeclared exception!
      try { 
        simpleEntryGroup0.unref();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.SimpleEntryGroup", e);
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      
      Range range0 = new Range((-2561));
      assertNotNull(range0);
      assertEquals(1, range0.getCount());
      assertEquals((-2561), range0.getStart());
      assertEquals((-2561), range0.getEnd());
      
      // Undeclared exception!
      try { 
        simpleEntryGroup0.truncate(range0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.SimpleEntryGroup", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      
      // Undeclared exception!
      try { 
        simpleEntryGroup0.setIsActive((Entry) null, false);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      
      // Undeclared exception!
      try { 
        simpleEntryGroup0.setIsActive(2312, true);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // 2312 >= 0
         //
         verifyException("java.util.Vector", e);
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      
      // Undeclared exception!
      try { 
        simpleEntryGroup0.removeElement((Entry) null);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      
      // Undeclared exception!
      try { 
        simpleEntryGroup0.getSequenceLength();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.SimpleEntryGroup", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      
      Key key0 = Key.CDS;
      assertNotNull(key0);
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      
      FeatureKeyPredicate featureKeyPredicate0 = new FeatureKeyPredicate(key0);
      assertNotNull(featureKeyPredicate0);
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureKeyPredicate0, "Object is not in this ontology: ");
      assertNotNull(filteredEntryGroup0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals("Object is not in this ontology: ", filteredEntryGroup0.getFilterName());
      assertEquals(0, filteredEntryGroup0.size());
      assertEquals(0, filteredEntryGroup0.refCount());
      
      // Undeclared exception!
      try { 
        simpleEntryGroup0.entryChanged((EntryChangeEvent) null);
        fail("Expecting exception: ClassCastException");
      
      } catch(ClassCastException e) {
         //
         // uk.ac.sanger.artemis.FilteredEntryGroup$2 cannot be cast to uk.ac.sanger.artemis.FeatureChangeListener
         //
         verifyException("uk.ac.sanger.artemis.SimpleEntryGroup", e);
      }
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      
      Entry entry0 = simpleEntryGroup0.createEntry("Warning");
      assertNotNull(entry0);
      assertEquals(1, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertFalse(entry0.isReadOnly());
      
      // Undeclared exception!
      simpleEntryGroup0.createEntry("Overlaying a GFF with a sequence onto an entry with a sequence.");
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      
      // Undeclared exception!
      try { 
        simpleEntryGroup0.addElement((Entry) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.SimpleEntryGroup", e);
      }
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      
      // Undeclared exception!
      try { 
        simpleEntryGroup0.add((Entry) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.SimpleEntryGroup", e);
      }
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = null;
      try {
        simpleEntryGroup0 = new SimpleEntryGroup((Bases) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.SimpleEntryGroup", e);
      }
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      
      Key key0 = new Key("q7,L9'\"uf?S/X?TG'");
      assertNotNull(key0);
      assertEquals("q7,L9'\"uf?S/X?TG'", key0.toString());
      assertEquals(17, key0.length());
      assertEquals("q7,L9'\"uf?S/X?TG'", key0.getKeyString());
      
      FeatureKeyQualifierPredicate featureKeyQualifierPredicate0 = new FeatureKeyQualifierPredicate(key0, "q7,L9'\"uf?S/X?TG'");
      assertNotNull(featureKeyQualifierPredicate0);
      assertEquals("q7,L9'\"uf?S/X?TG'", key0.toString());
      assertEquals(17, key0.length());
      assertEquals("q7,L9'\"uf?S/X?TG'", key0.getKeyString());
      
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureKeyQualifierPredicate0, "%]cF-42!!i");
      assertNotNull(filteredEntryGroup0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals("q7,L9'\"uf?S/X?TG'", key0.toString());
      assertEquals(17, key0.length());
      assertEquals("q7,L9'\"uf?S/X?TG'", key0.getKeyString());
      assertEquals(0, filteredEntryGroup0.size());
      assertEquals(0, filteredEntryGroup0.refCount());
      assertEquals("%]cF-42!!i", filteredEntryGroup0.getFilterName());
      
      Entry entry0 = filteredEntryGroup0.createEntry("Cannot apply changes: ");
      assertNotNull(entry0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(1, simpleEntryGroup0.size());
      assertEquals("q7,L9'\"uf?S/X?TG'", key0.toString());
      assertEquals(17, key0.length());
      assertEquals("q7,L9'\"uf?S/X?TG'", key0.getKeyString());
      assertEquals(1, filteredEntryGroup0.size());
      assertEquals(0, filteredEntryGroup0.refCount());
      assertEquals("%]cF-42!!i", filteredEntryGroup0.getFilterName());
      assertFalse(entry0.isReadOnly());
      
      simpleEntryGroup0.add(entry0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(1, simpleEntryGroup0.size());
      assertEquals("q7,L9'\"uf?S/X?TG'", key0.toString());
      assertEquals(17, key0.length());
      assertEquals("q7,L9'\"uf?S/X?TG'", key0.getKeyString());
      assertEquals(1, filteredEntryGroup0.size());
      assertEquals(0, filteredEntryGroup0.refCount());
      assertEquals("%]cF-42!!i", filteredEntryGroup0.getFilterName());
      assertFalse(entry0.isReadOnly());
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      
      Entry entry0 = simpleEntryGroup0.createEntry();
      assertNotNull(entry0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(1, simpleEntryGroup0.size());
      assertFalse(entry0.isReadOnly());
      
      boolean boolean0 = simpleEntryGroup0.remove(entry0);
      assertTrue(boolean0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertFalse(entry0.isReadOnly());
      
      simpleEntryGroup0.addElement(entry0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(1, simpleEntryGroup0.size());
      assertFalse(entry0.isReadOnly());
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      
      // Undeclared exception!
      try { 
        simpleEntryGroup0.featureAt(2312);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - index out of range: 2312
         //
         verifyException("uk.ac.sanger.artemis.SimpleEntryGroup", e);
      }
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      
      Entry entry0 = simpleEntryGroup0.createEntry("");
      assertNotNull(entry0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(1, simpleEntryGroup0.size());
      assertFalse(entry0.isReadOnly());
      
      boolean boolean0 = simpleEntryGroup0.isActive(entry0);
      assertTrue(boolean0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(1, simpleEntryGroup0.size());
      assertFalse(entry0.isReadOnly());
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      
      boolean boolean0 = simpleEntryGroup0.isActive((Entry) null);
      assertFalse(boolean0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      
      Selection selection0 = new Selection((Clipboard) null);
      assertNotNull(selection0);
      
      FeatureVector featureVector0 = selection0.getAllFeatures();
      assertNotNull(featureVector0);
      
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "vJMxKhS{zxVtM");
      assertNotNull(filteredEntryGroup0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals("vJMxKhS{zxVtM", filteredEntryGroup0.getFilterName());
      assertEquals(0, filteredEntryGroup0.refCount());
      assertEquals(0, filteredEntryGroup0.size());
      
      Entry entry0 = filteredEntryGroup0.createEntry("vJMxKhS{zxVtM");
      assertNotNull(entry0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(1, simpleEntryGroup0.size());
      assertEquals("vJMxKhS{zxVtM", filteredEntryGroup0.getFilterName());
      assertEquals(0, filteredEntryGroup0.refCount());
      assertEquals(1, filteredEntryGroup0.size());
      assertFalse(entry0.isReadOnly());
      
      simpleEntryGroup0.setDefaultEntry(entry0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(1, simpleEntryGroup0.size());
      assertEquals("vJMxKhS{zxVtM", filteredEntryGroup0.getFilterName());
      assertEquals(0, filteredEntryGroup0.refCount());
      assertEquals(1, filteredEntryGroup0.size());
      assertFalse(entry0.isReadOnly());
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      
      FeatureVector featureVector0 = new FeatureVector();
      assertNotNull(featureVector0);
      
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "s;m9>i\"~d[m\">gp");
      assertNotNull(filteredEntryGroup0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, filteredEntryGroup0.refCount());
      assertEquals(0, filteredEntryGroup0.size());
      assertEquals("s;m9>i\"~d[m\">gp", filteredEntryGroup0.getFilterName());
      
      Entry entry0 = filteredEntryGroup0.createEntry("s;m9>i\"~d[m\">gp");
      assertNotNull(entry0);
      assertEquals(1, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, filteredEntryGroup0.refCount());
      assertEquals(1, filteredEntryGroup0.size());
      assertEquals("s;m9>i\"~d[m\">gp", filteredEntryGroup0.getFilterName());
      assertFalse(entry0.isReadOnly());
      
      simpleEntryGroup0.addFeatureChangeListener(entry0);
      assertEquals(1, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, filteredEntryGroup0.refCount());
      assertEquals(1, filteredEntryGroup0.size());
      assertEquals("s;m9>i\"~d[m\">gp", filteredEntryGroup0.getFilterName());
      assertFalse(entry0.isReadOnly());
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      
      Entry entry0 = simpleEntryGroup0.getDefaultEntry();
      assertNull(entry0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
  }

  @Test(timeout = 4000)
  public void test23()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      
      Bases bases0 = simpleEntryGroup0.getBases();
      assertNull(bases0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
  }

  @Test(timeout = 4000)
  public void test24()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      assertNotNull(bases0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      
      EntryVector entryVector0 = simpleEntryGroup0.getActiveEntries();
      assertNotNull(entryVector0);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, entryVector0.size());
  }

  @Test(timeout = 4000)
  public void test25()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      
      ActionController actionController0 = simpleEntryGroup0.getActionController();
      assertNotNull(actionController0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertFalse(actionController0.canUndo());
      
      simpleEntryGroup0.addEntryChangeListener(actionController0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertFalse(actionController0.canUndo());
  }

  @Test(timeout = 4000)
  public void test26()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      assertNotNull(bases0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      assertNotNull(simpleEntryGroup0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      
      simpleEntryGroup0.entryChanged((EntryChangeEvent) null);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
  }

  @Test(timeout = 4000)
  public void test27()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      
      Entry entry0 = simpleEntryGroup0.createEntry();
      assertNotNull(entry0);
      assertEquals(1, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertFalse(entry0.isReadOnly());
      
      SimpleEntryGroup.FeatureEnumerator simpleEntryGroup_FeatureEnumerator0 = simpleEntryGroup0.new FeatureEnumerator();
      assertNotNull(simpleEntryGroup_FeatureEnumerator0);
      assertEquals(1, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      
      // Undeclared exception!
      try { 
        simpleEntryGroup_FeatureEnumerator0.nextFeature();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.Entry", e);
      }
  }

  @Test(timeout = 4000)
  public void test28()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      
      SimpleEntryGroup.FeatureEnumerator simpleEntryGroup_FeatureEnumerator0 = simpleEntryGroup0.new FeatureEnumerator();
      assertNotNull(simpleEntryGroup_FeatureEnumerator0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      
      boolean boolean0 = simpleEntryGroup_FeatureEnumerator0.hasMoreFeatures();
      assertFalse(boolean0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
  }

  @Test(timeout = 4000)
  public void test29()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      
      Entry entry0 = simpleEntryGroup0.createEntry();
      assertNotNull(entry0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(1, simpleEntryGroup0.size());
      assertFalse(entry0.isReadOnly());
      
      SimpleEntryGroup.FeatureEnumerator simpleEntryGroup_FeatureEnumerator0 = simpleEntryGroup0.new FeatureEnumerator();
      assertNotNull(simpleEntryGroup_FeatureEnumerator0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(1, simpleEntryGroup0.size());
      
      boolean boolean0 = simpleEntryGroup_FeatureEnumerator0.hasMoreFeatures();
      assertFalse(boolean0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(1, simpleEntryGroup0.size());
      
      // Undeclared exception!
      try { 
        simpleEntryGroup_FeatureEnumerator0.hasMoreFeatures();
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // 2 >= 1
         //
         verifyException("java.util.Vector", e);
      }
  }

  @Test(timeout = 4000)
  public void test30()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.size());
      
      Entry entry0 = simpleEntryGroup0.createEntry();
      assertNotNull(entry0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(1, simpleEntryGroup0.size());
      assertFalse(entry0.isReadOnly());
      
      FeatureEnumeration featureEnumeration0 = simpleEntryGroup0.features();
      assertNotNull(featureEnumeration0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(1, simpleEntryGroup0.size());
  }

  @Test(timeout = 4000)
  public void test31()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      
      Entry entry0 = simpleEntryGroup0.createEntry();
      assertNotNull(entry0);
      assertEquals(1, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertFalse(entry0.isReadOnly());
      
      // Undeclared exception!
      simpleEntryGroup0.createEntry();
  }

  @Test(timeout = 4000)
  public void test32()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      
      Key key0 = Key.CDS;
      assertNotNull(key0);
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      
      FeatureKeyQualifierPredicate featureKeyQualifierPredicate0 = new FeatureKeyQualifierPredicate(key0, "sP", false);
      assertNotNull(featureKeyQualifierPredicate0);
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureKeyQualifierPredicate0, "sP");
      assertNotNull(filteredEntryGroup0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(0, filteredEntryGroup0.size());
      assertEquals("sP", filteredEntryGroup0.getFilterName());
      assertEquals(0, filteredEntryGroup0.refCount());
      
      Entry entry0 = filteredEntryGroup0.createEntry("Warning");
      assertNotNull(entry0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(1, simpleEntryGroup0.size());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(1, filteredEntryGroup0.size());
      assertEquals("sP", filteredEntryGroup0.getFilterName());
      assertEquals(0, filteredEntryGroup0.refCount());
      assertFalse(entry0.isReadOnly());
      
      simpleEntryGroup0.addElement(entry0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(1, simpleEntryGroup0.size());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(1, filteredEntryGroup0.size());
      assertEquals("sP", filteredEntryGroup0.getFilterName());
      assertEquals(0, filteredEntryGroup0.refCount());
      assertFalse(entry0.isReadOnly());
  }

  @Test(timeout = 4000)
  public void test33()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      simpleEntryGroup0.createEntry();
      int int0 = simpleEntryGroup0.getAllFeaturesCount();
      assertEquals(0, simpleEntryGroup0.refCount());
      assertEquals(0, int0);
  }

  @Test(timeout = 4000)
  public void test34()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      simpleEntryGroup0.createEntry("Overlaying a GFF with a sequence onto an entry with a sequence.");
      simpleEntryGroup0.getAllFeatures();
      assertEquals(0, simpleEntryGroup0.refCount());
  }

  @Test(timeout = 4000)
  public void test35()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      simpleEntryGroup0.createEntry();
      Range range0 = new Range(1167);
      simpleEntryGroup0.getFeaturesInRange(range0);
      assertEquals(0, simpleEntryGroup0.refCount());
  }

  @Test(timeout = 4000)
  public void test36()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      simpleEntryGroup0.getFeaturesInIndexRange(5, (-1418));
      assertEquals(0, simpleEntryGroup0.refCount());
  }

  @Test(timeout = 4000)
  public void test37()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      simpleEntryGroup0.createEntry();
      // Undeclared exception!
      try { 
        simpleEntryGroup0.getFeaturesInIndexRange(5, 5);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - index out of range: 5
         //
         verifyException("uk.ac.sanger.artemis.SimpleEntryGroup", e);
      }
  }

  @Test(timeout = 4000)
  public void test38()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      // Undeclared exception!
      try { 
        simpleEntryGroup0.featureAt((-2872));
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - index out of range: -2872
         //
         verifyException("uk.ac.sanger.artemis.SimpleEntryGroup", e);
      }
  }

  @Test(timeout = 4000)
  public void test39()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      simpleEntryGroup0.createEntry();
      simpleEntryGroup0.ref();
      simpleEntryGroup0.unref();
      assertEquals(0, simpleEntryGroup0.refCount());
  }

  @Test(timeout = 4000)
  public void test40()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      simpleEntryGroup0.unref();
      int int0 = simpleEntryGroup0.refCount();
      assertEquals((-1), int0);
  }

  @Test(timeout = 4000)
  public void test41()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      simpleEntryGroup0.createEntry();
      boolean boolean0 = simpleEntryGroup0.isReadOnly();
      assertEquals(0, simpleEntryGroup0.refCount());
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test42()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      // Undeclared exception!
      try { 
        simpleEntryGroup0.reverseComplement();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.SimpleEntryGroup", e);
      }
  }

  @Test(timeout = 4000)
  public void test43()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      simpleEntryGroup0.getSequenceEntry();
      assertEquals(0, simpleEntryGroup0.refCount());
  }

  @Test(timeout = 4000)
  public void test44()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      simpleEntryGroup0.createEntry();
      Entry entry0 = simpleEntryGroup0.getSequenceEntry();
      assertNotNull(entry0);
      assertEquals(0, simpleEntryGroup0.refCount());
  }

  @Test(timeout = 4000)
  public void test45()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      boolean boolean0 = simpleEntryGroup0.contains((Feature) null);
      assertFalse(boolean0);
      assertEquals(0, simpleEntryGroup0.refCount());
  }

  @Test(timeout = 4000)
  public void test46()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      int int0 = simpleEntryGroup0.indexOf((Feature) null);
      assertEquals((-1), int0);
      assertEquals(0, simpleEntryGroup0.refCount());
  }

  @Test(timeout = 4000)
  public void test47()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry("46");
      boolean boolean0 = simpleEntryGroup0.removeElement(entry0);
      assertTrue(boolean0);
      
      simpleEntryGroup0.setDefaultEntry(entry0);
      assertEquals(0, simpleEntryGroup0.refCount());
  }

  @Test(timeout = 4000)
  public void test48()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      simpleEntryGroup0.createEntry();
      boolean boolean0 = simpleEntryGroup0.hasUnsavedChanges();
      assertEquals(0, simpleEntryGroup0.refCount());
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test49()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry("M.ity`KBzoEEELYvL@");
      simpleEntryGroup0.setIsActive(entry0, false);
      boolean boolean0 = simpleEntryGroup0.remove(entry0);
      assertEquals(0, simpleEntryGroup0.refCount());
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test50()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Key key0 = Key.CDS;
      FeatureKeyPredicate featureKeyPredicate0 = new FeatureKeyPredicate(key0);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureKeyPredicate0, "Object is not in this ontology: ");
      ActionController actionController0 = filteredEntryGroup0.getActionController();
      simpleEntryGroup0.removeEntryGroupChangeListener(actionController0);
      assertEquals(0, filteredEntryGroup0.refCount());
      assertEquals(0, simpleEntryGroup0.refCount());
  }

  @Test(timeout = 4000)
  public void test51()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry();
      simpleEntryGroup0.removeFeatureChangeListener(entry0);
  }

  @Test(timeout = 4000)
  public void test52()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      int int0 = simpleEntryGroup0.refCount();
      assertEquals(0, int0);
  }

  @Test(timeout = 4000)
  public void test53()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      // Undeclared exception!
      try { 
        simpleEntryGroup0.createFeature();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.SimpleEntryGroup", e);
      }
  }

  @Test(timeout = 4000)
  public void test54()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("/ ~\"N2q@E+k!\"");
      Bases bases0 = new Bases(genbankStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      simpleEntryGroup0.getSequenceLength();
      assertEquals(0, simpleEntryGroup0.refCount());
  }

  @Test(timeout = 4000)
  public void test55()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FeatureEnumeration featureEnumeration0 = simpleEntryGroup0.features();
      try { 
        featureEnumeration0.nextFeature();
        fail("Expecting exception: NoSuchElementException");
      
      } catch(NoSuchElementException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.SimpleEntryGroup$FeatureEnumerator", e);
      }
  }

  @Test(timeout = 4000)
  public void test56()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      ActionController actionController0 = simpleEntryGroup0.getActionController();
      simpleEntryGroup0.removeEntryChangeListener(actionController0);
      assertEquals(0, simpleEntryGroup0.refCount());
  }
}
