/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 15:53:27 GMT 2018
 */

package uk.ac.sanger.artemis;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import com.sshtools.j2ssh.io.ByteArrayReader;
import java.awt.Color;
import java.awt.Font;
import java.awt.HeadlessException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import javax.swing.JLayeredPane;
import javax.swing.plaf.FontUIResource;
import org.apache.batik.ext.awt.ColorSpaceHintKey;
import org.apache.log4j.Appender;
import org.apache.log4j.AsyncAppender;
import org.apache.log4j.helpers.Loader;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.LoggerRepository;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.mock.java.io.MockFile;
import org.evosuite.runtime.mock.java.io.MockFileOutputStream;
import org.evosuite.runtime.mock.java.net.MockURL;
import org.evosuite.runtime.mock.java.time.chrono.MockHijrahDate;
import org.evosuite.runtime.testdata.EvoSuiteFile;
import org.evosuite.runtime.testdata.FileSystemHandling;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.ExternalProgramVector;
import uk.ac.sanger.artemis.OptionChangeListener;
import uk.ac.sanger.artemis.Options;
import uk.ac.sanger.artemis.SimpleEntryGroup;
import uk.ac.sanger.artemis.components.Splash;
import uk.ac.sanger.artemis.components.filetree.FileList;
import uk.ac.sanger.artemis.io.BlastEntryInformation;
import uk.ac.sanger.artemis.io.EntryInformation;
import uk.ac.sanger.artemis.io.IndexedGFFDocumentEntry;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.QualifierInfoVector;
import uk.ac.sanger.artemis.io.SimpleEntryInformation;
import uk.ac.sanger.artemis.util.DatabaseDocument;
import uk.ac.sanger.artemis.util.StringVector;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class Options_ESTest extends Options_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      Options options0 = Options.getOptions();
      assertNotNull(options0);
      assertFalse(options0.isEmpty());
      assertFalse(options0.isUnixHost());
      assertEquals(216, options0.size());
      
      Set<String> set0 = options0.stringPropertyNames();
      assertNotNull(set0);
      assertFalse(options0.isEmpty());
      assertFalse(options0.isUnixHost());
      assertEquals(216, options0.size());
      assertFalse(set0.isEmpty());
      assertEquals(216, set0.size());
      
      options0.clear();
      assertTrue(options0.isEmpty());
      assertEquals(0, options0.size());
      assertFalse(options0.isUnixHost());
      
      DatabaseDocument.EXONMODEL = "MJro,{bg+)P";
      StringVector stringVector0 = options0.getDisplayQualifierNames();
      assertNotNull(stringVector0);
      assertTrue(options0.isEmpty());
      assertEquals(0, options0.size());
      assertFalse(options0.isUnixHost());
      assertFalse(stringVector0.isEmpty());
      assertEquals(1, stringVector0.size());
      assertEquals(10, stringVector0.capacity());
      assertEquals("[gene]", stringVector0.toString());
      
      int int0 = options0.getMinimumORFSize();
      assertEquals(100, int0);
      assertTrue(options0.isEmpty());
      assertEquals(0, options0.size());
      assertFalse(options0.isUnixHost());
      
      options0.setDisplayNameQualifiers("!B4v0cHY`-[");
      assertEquals(1, options0.size());
      assertFalse(options0.isEmpty());
      assertFalse(options0.isUnixHost());
      
      EntryInformation entryInformation0 = Options.getArtemisEntryInformation();
      assertNotNull(entryInformation0);
      assertFalse(entryInformation0.useEMBLFormat());
      
      ExternalProgramVector externalProgramVector0 = options0.getExternalPrograms();
      assertNotNull(externalProgramVector0);
      assertEquals(1, options0.size());
      assertFalse(options0.isEmpty());
      assertFalse(options0.isUnixHost());
      assertEquals(28, externalProgramVector0.size());
      
      ExternalProgramVector externalProgramVector1 = options0.getExternalPrograms();
      assertNotNull(externalProgramVector1);
      assertSame(externalProgramVector1, externalProgramVector0);
      assertEquals(1, options0.size());
      assertFalse(options0.isEmpty());
      assertFalse(options0.isUnixHost());
      assertEquals(28, externalProgramVector1.size());
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      Options options0 = Options.getOptions();
      assertNotNull(options0);
      assertFalse(options0.isEmpty());
      assertFalse(options0.isUnixHost());
      assertEquals(215, options0.size());
      
      // Undeclared exception!
      try { 
        options0.setSystematicQualifierNames((String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.util.Hashtable", e);
      }
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      boolean boolean0 = FileSystemHandling.appendStringToFile((EvoSuiteFile) null, "yes");
      assertFalse(boolean0);
      
      EntryInformation entryInformation0 = Options.getDBEntryInformation();
      assertNotNull(entryInformation0);
      assertTrue(entryInformation0.useEMBLFormat());
      
      Options options0 = Options.getOptions();
      assertNotNull(options0);
      assertEquals(215, options0.size());
      assertFalse(options0.isEmpty());
      assertFalse(options0.isUnixHost());
      
      String string0 = options0.getDefaultFeatureFileName();
      assertNull(string0);
      assertEquals(215, options0.size());
      assertFalse(options0.isEmpty());
      assertFalse(options0.isUnixHost());
      
      String string1 = options0.getDefaultFeatureFileName();
      assertNull(string1);
      assertEquals(215, options0.size());
      assertFalse(options0.isEmpty());
      assertFalse(options0.isUnixHost());
      
      int int0 = options0.getMinimumORFSize();
      assertEquals(100, int0);
      assertEquals(215, options0.size());
      assertFalse(options0.isEmpty());
      assertFalse(options0.isUnixHost());
      
      QualifierInfoVector qualifierInfoVector0 = options0.getExtraGffQualifiers();
      assertNotNull(qualifierInfoVector0);
      assertEquals(215, options0.size());
      assertFalse(options0.isEmpty());
      assertFalse(options0.isUnixHost());
      assertEquals(27, qualifierInfoVector0.size());
      
      Font font0 = options0.getFont();
      assertNotNull(font0);
      assertEquals(215, options0.size());
      assertFalse(options0.isEmpty());
      assertFalse(options0.isUnixHost());
      assertFalse(font0.isItalic());
      assertFalse(font0.hasUniformLineMetrics());
      assertTrue(font0.isPlain());
      assertEquals("Monospaced", font0.getName());
      assertEquals(0, font0.getStyle());
      assertFalse(font0.isTransformed());
      assertEquals(12.0F, font0.getSize2D(), 0.01F);
      assertFalse(font0.isBold());
      assertFalse(font0.hasLayoutAttributes());
      assertEquals(12, font0.getSize());
      
      boolean boolean1 = Options.isBlackBeltMode();
      assertTrue(boolean1 == boolean0);
      assertFalse(boolean1);
      
      QualifierInfoVector qualifierInfoVector1 = options0.getExtraQualifiers();
      assertFalse(qualifierInfoVector1.equals((Object)qualifierInfoVector0));
      assertNotNull(qualifierInfoVector1);
      assertNotSame(qualifierInfoVector1, qualifierInfoVector0);
      assertEquals(215, options0.size());
      assertFalse(options0.isEmpty());
      assertFalse(options0.isUnixHost());
      assertEquals(128, qualifierInfoVector1.size());
      
      ExternalProgramVector externalProgramVector0 = options0.getExternalPrograms();
      assertNotNull(externalProgramVector0);
      assertEquals(215, options0.size());
      assertFalse(options0.isEmpty());
      assertFalse(options0.isUnixHost());
      assertEquals(28, externalProgramVector0.size());
      
      int int1 = options0.getMinimumORFSize();
      assertTrue(int1 == int0);
      assertEquals(100, int1);
      assertEquals(215, options0.size());
      assertFalse(options0.isEmpty());
      assertFalse(options0.isUnixHost());
      
      StringVector stringVector0 = options0.getOptionValues("z/");
      assertNull(stringVector0);
      assertEquals(215, options0.size());
      assertFalse(options0.isEmpty());
      assertFalse(options0.isUnixHost());
      
      EntryInformation entryInformation1 = Options.getArtemisEntryInformation();
      assertFalse(entryInformation1.equals((Object)entryInformation0));
      assertNotNull(entryInformation1);
      assertNotSame(entryInformation1, entryInformation0);
      assertFalse(entryInformation1.useEMBLFormat());
      
      options0.reset();
      assertEquals(216, options0.size());
      assertFalse(options0.isEmpty());
      assertFalse(options0.isUnixHost());
      
      // Undeclared exception!
      try { 
        options0.getIntegerProperty((String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      Options options0 = new Options();
      assertNotNull(options0);
      assertFalse(options0.isEmpty());
      assertFalse(options0.isUnixHost());
      assertEquals(216, options0.size());
      
      Options options1 = (Options)options0.clone();
      assertTrue(options1.equals((Object)options0));
      assertNotNull(options1);
      assertNotSame(options0, options1);
      assertNotSame(options1, options0);
      assertFalse(options0.isEmpty());
      assertFalse(options0.isUnixHost());
      assertEquals(216, options0.size());
      assertEquals(216, options1.size());
      assertFalse(options1.isUnixHost());
      assertFalse(options1.isEmpty());
      
      StringVector stringVector0 = options0.getSystematicQualifierNames();
      assertTrue(options0.equals((Object)options1));
      assertNotNull(stringVector0);
      assertNotSame(options0, options1);
      assertFalse(options0.isEmpty());
      assertFalse(options0.isUnixHost());
      assertEquals(216, options0.size());
      assertEquals(7, stringVector0.size());
      assertEquals("[systematic_id, temporary_systematic_id, locus_tag, gene, label, ID, Name]", stringVector0.toString());
      assertEquals(10, stringVector0.capacity());
      assertFalse(stringVector0.isEmpty());
      
      byte[] byteArray0 = new byte[6];
      byteArray0[0] = (byte)16;
      byteArray0[1] = (byte)33;
      byteArray0[2] = (byte)106;
      byteArray0[3] = (byte)39;
      byteArray0[4] = (byte) (-40);
      byteArray0[5] = (byte)91;
      boolean boolean0 = FileSystemHandling.appendDataToFile((EvoSuiteFile) null, byteArray0);
      assertArrayEquals(new byte[] {(byte)16, (byte)33, (byte)106, (byte)39, (byte) (-40), (byte)91}, byteArray0);
      assertFalse(boolean0);
      
      boolean boolean1 = Options.readWritePossible();
      assertFalse(boolean1 == boolean0);
      assertTrue(boolean1);
      
      URL uRL0 = Loader.getResource(java.lang.System.getProperty("user.home") + "/.artemis/cache/");
      assertNull(uRL0);
      
      StringVector stringVector1 = options0.getInvisibleQualifiers(true);
      assertTrue(options0.equals((Object)options1));
      assertFalse(stringVector1.equals((Object)stringVector0));
      assertNotNull(stringVector1);
      assertNotSame(options0, options1);
      assertNotSame(stringVector1, stringVector0);
      assertFalse(options0.isEmpty());
      assertFalse(options0.isUnixHost());
      assertEquals(216, options0.size());
      assertEquals(320, stringVector1.capacity());
      assertFalse(stringVector1.isEmpty());
      assertEquals(163, stringVector1.size());
      
      SimpleEntryInformation simpleEntryInformation0 = (SimpleEntryInformation)Options.getDBEntryInformation();
      assertNotNull(simpleEntryInformation0);
      assertTrue(simpleEntryInformation0.useEMBLFormat());
      
      options0.setDefaultColourMap();
      assertFalse(options0.equals((Object)options1));
      assertNotSame(options0, options1);
      assertFalse(options0.isEmpty());
      assertFalse(options0.isUnixHost());
      assertEquals(216, options0.size());
      
      boolean boolean2 = FileSystemHandling.appendLineToFile((EvoSuiteFile) null, java.lang.System.getProperty("user.home") + "/.artemis/cache/");
      assertFalse(boolean2 == boolean1);
      assertTrue(boolean2 == boolean0);
      assertFalse(boolean2);
      
      StringVector stringVector2 = Options.getPropertyValues(options0, "<da6[=Yb");
      assertFalse(options0.equals((Object)options1));
      assertNull(stringVector2);
      assertNotSame(options0, options1);
      assertFalse(options0.isEmpty());
      assertFalse(options0.isUnixHost());
      assertEquals(216, options0.size());
      
      boolean boolean3 = Options.isUnixHost();
      assertTrue(boolean3 == boolean0);
      assertTrue(boolean3 == boolean2);
      assertFalse(boolean3 == boolean1);
      assertFalse(boolean3);
      
      options0.setSystematicQualifierNames("false");
      assertFalse(options0.equals((Object)options1));
      assertNotSame(options0, options1);
      assertFalse(options0.isEmpty());
      assertFalse(options0.isUnixHost());
      assertEquals(216, options0.size());
      
      Color color0 = options0.getColorFromColourNumber((-643));
      assertFalse(options0.equals((Object)options1));
      assertNull(color0);
      assertNotSame(options0, options1);
      assertFalse(options0.isEmpty());
      assertFalse(options0.isUnixHost());
      assertEquals(216, options0.size());
      
      QualifierInfoVector qualifierInfoVector0 = options0.getExtraQualifiers();
      assertFalse(options0.equals((Object)options1));
      assertNotNull(qualifierInfoVector0);
      assertNotSame(options0, options1);
      assertFalse(options0.isEmpty());
      assertFalse(options0.isUnixHost());
      assertEquals(216, options0.size());
      assertEquals(128, qualifierInfoVector0.size());
      
      boolean boolean4 = options0.isEukaryoticMode();
      assertFalse(options0.equals((Object)options1));
      assertFalse(boolean4 == boolean0);
      assertFalse(boolean4 == boolean2);
      assertTrue(boolean4 == boolean1);
      assertFalse(boolean4 == boolean3);
      assertNotSame(options0, options1);
      assertTrue(boolean4);
      assertFalse(options0.isEmpty());
      assertFalse(options0.isUnixHost());
      assertEquals(216, options0.size());
      
      boolean boolean5 = options0.isBuggyLinuxVM();
      assertFalse(options0.equals((Object)options1));
      assertFalse(boolean5 == boolean4);
      assertFalse(boolean5 == boolean1);
      assertTrue(boolean5 == boolean2);
      assertTrue(boolean5 == boolean0);
      assertTrue(boolean5 == boolean3);
      assertNotSame(options0, options1);
      assertFalse(boolean5);
      assertFalse(options0.isEmpty());
      assertFalse(options0.isUnixHost());
      assertEquals(216, options0.size());
      
      // Undeclared exception!
      try { 
        options0.removeOptionChangeListener((OptionChangeListener) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.util.Hashtable", e);
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      Options options0 = Options.getOptions();
      assertNotNull(options0);
      assertFalse(options0.isEmpty());
      assertFalse(options0.isUnixHost());
      assertEquals(215, options0.size());
      
      Color color0 = options0.getColorFromColourNumber((-337));
      assertNull(color0);
      assertFalse(options0.isEmpty());
      assertFalse(options0.isUnixHost());
      assertEquals(215, options0.size());
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      Options options0 = new Options();
      assertNotNull(options0);
      assertFalse(options0.isEmpty());
      assertFalse(options0.isUnixHost());
      assertEquals(216, options0.size());
      
      byte[] byteArray0 = new byte[6];
      byteArray0[0] = (byte)46;
      byteArray0[1] = (byte) (-88);
      byteArray0[2] = (byte)4;
      byteArray0[3] = (byte)6;
      byteArray0[4] = (byte)64;
      byteArray0[5] = (byte) (-48);
      boolean boolean0 = FileSystemHandling.appendDataToFile((EvoSuiteFile) null, byteArray0);
      assertArrayEquals(new byte[] {(byte)46, (byte) (-88), (byte)4, (byte)6, (byte)64, (byte) (-48)}, byteArray0);
      assertFalse(boolean0);
      
      StringVector stringVector0 = options0.getDisplayQualifierNames();
      assertNotNull(stringVector0);
      assertFalse(options0.isEmpty());
      assertFalse(options0.isUnixHost());
      assertEquals(216, options0.size());
      assertEquals("[primary_name, Name, synonym, systematic_id, temporary_systematic_id, gene, locus_tag, label, ID]", stringVector0.toString());
      assertEquals(9, stringVector0.size());
      assertFalse(stringVector0.isEmpty());
      assertEquals(10, stringVector0.capacity());
      
      Color color0 = options0.getColorFromColourNumber(6);
      assertNotNull(color0);
      assertFalse(options0.isEmpty());
      assertFalse(options0.isUnixHost());
      assertEquals(216, options0.size());
      assertEquals(0, color0.getGreen());
      assertEquals(1, color0.getTransparency());
      assertEquals((-65281), color0.getRGB());
      assertEquals(255, color0.getAlpha());
      assertEquals(255, color0.getRed());
      assertEquals(255, color0.getBlue());
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      boolean boolean0 = FileSystemHandling.appendLineToFile((EvoSuiteFile) null, "x|\"-taDH?73bceC%");
      assertFalse(boolean0);
      
      Options options0 = new Options();
      assertNotNull(options0);
      assertEquals(216, options0.size());
      assertFalse(options0.isUnixHost());
      assertFalse(options0.isEmpty());
      
      boolean boolean1 = options0.isEukaryoticMode();
      assertFalse(boolean1 == boolean0);
      assertTrue(boolean1);
      assertEquals(216, options0.size());
      assertFalse(options0.isUnixHost());
      assertFalse(options0.isEmpty());
      
      QualifierInfoVector qualifierInfoVector0 = options0.getExtraQualifiers();
      assertNotNull(qualifierInfoVector0);
      assertEquals(216, options0.size());
      assertFalse(options0.isUnixHost());
      assertFalse(options0.isEmpty());
      assertEquals(128, qualifierInfoVector0.size());
      
      Set<String> set0 = options0.stringPropertyNames();
      assertNotNull(set0);
      assertEquals(216, options0.size());
      assertFalse(options0.isUnixHost());
      assertFalse(options0.isEmpty());
      assertEquals(216, set0.size());
      assertFalse(set0.isEmpty());
      
      DatabaseDocument.EXONMODEL = "";
      options0.setEukaryoticMode(true);
      assertEquals(216, options0.size());
      assertFalse(options0.isUnixHost());
      assertFalse(options0.isEmpty());
      
      StringVector stringVector0 = options0.getInvisibleQualifiers(true);
      assertNotNull(stringVector0);
      assertEquals(216, options0.size());
      assertFalse(options0.isUnixHost());
      assertFalse(options0.isEmpty());
      assertEquals(320, stringVector0.capacity());
      assertEquals(163, stringVector0.size());
      assertFalse(stringVector0.isEmpty());
      
      options0.setDefaultColourMap();
      assertEquals(216, options0.size());
      assertFalse(options0.isUnixHost());
      assertFalse(options0.isEmpty());
      
      Integer integer0 = options0.getIntegerProperty("x|\"-taDH?73bceC%");
      assertNull(integer0);
      assertEquals(216, options0.size());
      assertFalse(options0.isUnixHost());
      assertFalse(options0.isEmpty());
      
      boolean boolean2 = options0.getPropertyTruthValue("");
      assertFalse(boolean2 == boolean1);
      assertTrue(boolean2 == boolean0);
      assertFalse(boolean2);
      assertEquals(216, options0.size());
      assertFalse(options0.isUnixHost());
      assertFalse(options0.isEmpty());
      
      options0.reset();
      assertEquals(216, options0.size());
      assertFalse(options0.isUnixHost());
      assertFalse(options0.isEmpty());
      
      boolean boolean3 = Options.isBlackBeltMode();
      assertTrue(boolean3 == boolean2);
      assertFalse(boolean3 == boolean1);
      assertTrue(boolean3 == boolean0);
      assertFalse(boolean3);
      
      // Undeclared exception!
      try { 
        options0.setGeneticCode((String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.util.Hashtable", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      Options options0 = new Options();
      assertNotNull(options0);
      assertFalse(options0.isEmpty());
      assertFalse(options0.isUnixHost());
      assertEquals(215, options0.size());
      
      Object object0 = ColorSpaceHintKey.VALUE_COLORSPACE_ARGB;
      assertNotNull(object0);
      
      StringVector stringVector0 = options0.getSystematicQualifierNames();
      assertNotNull(stringVector0);
      assertFalse(options0.isEmpty());
      assertFalse(options0.isUnixHost());
      assertEquals(215, options0.size());
      assertEquals(7, stringVector0.size());
      assertFalse(stringVector0.isEmpty());
      assertEquals("[systematic_id, temporary_systematic_id, locus_tag, gene, label, ID, Name]", stringVector0.toString());
      assertEquals(10, stringVector0.capacity());
      
      Integer integer0 = JLayeredPane.POPUP_LAYER;
      assertNotNull(integer0);
      assertEquals(300, (int)integer0);
      
      boolean boolean0 = options0.replace(object0, (Object) integer0, object0);
      assertFalse(boolean0);
      assertFalse(options0.isEmpty());
      assertFalse(options0.isUnixHost());
      assertEquals(215, options0.size());
      
      options0.setDirectEdit(false);
      assertFalse(options0.isEmpty());
      assertFalse(options0.isUnixHost());
      assertEquals(215, options0.size());
      
      boolean boolean1 = FileSystemHandling.setPermissions((EvoSuiteFile) null, true, false, true);
      assertTrue(boolean1 == boolean0);
      assertFalse(boolean1);
      
      options0.setDisplayNameQualifiers("bases of selection:\n");
      assertFalse(options0.isEmpty());
      assertFalse(options0.isUnixHost());
      assertEquals(215, options0.size());
      
      boolean boolean2 = options0.canDirectEdit();
      assertTrue(boolean2 == boolean0);
      assertTrue(boolean2 == boolean1);
      assertFalse(boolean2);
      assertFalse(options0.isEmpty());
      assertFalse(options0.isUnixHost());
      assertEquals(215, options0.size());
      
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      
      // Undeclared exception!
      try { 
        simpleEntryGroup0.featureAt(226);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - index out of range: 226
         //
         verifyException("uk.ac.sanger.artemis.SimpleEntryGroup", e);
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      Options options0 = Options.getOptions();
      assertNotNull(options0);
      assertFalse(options0.isEmpty());
      assertFalse(options0.isUnixHost());
      assertEquals(215, options0.size());
      
      boolean boolean0 = options0.highlightActiveEntryFlag();
      assertFalse(boolean0);
      assertFalse(options0.isEmpty());
      assertFalse(options0.isUnixHost());
      assertEquals(215, options0.size());
      
      options0.setSystematicQualifierNames("E9$a] [|sqnG");
      assertFalse(options0.isEmpty());
      assertFalse(options0.isUnixHost());
      assertEquals(215, options0.size());
      
      boolean boolean1 = options0.highlightActiveEntryFlag();
      assertTrue(boolean1 == boolean0);
      assertFalse(boolean1);
      assertFalse(options0.isEmpty());
      assertFalse(options0.isUnixHost());
      assertEquals(215, options0.size());
      
      QualifierInfoVector qualifierInfoVector0 = options0.getExtraQualifiers();
      assertNotNull(qualifierInfoVector0);
      assertFalse(options0.isEmpty());
      assertFalse(options0.isUnixHost());
      assertEquals(215, options0.size());
      assertEquals(128, qualifierInfoVector0.size());
      
      QualifierInfoVector qualifierInfoVector1 = options0.getExtraQualifiers();
      assertFalse(qualifierInfoVector1.equals((Object)qualifierInfoVector0));
      assertNotNull(qualifierInfoVector1);
      assertNotSame(qualifierInfoVector1, qualifierInfoVector0);
      assertFalse(options0.isEmpty());
      assertFalse(options0.isUnixHost());
      assertEquals(215, options0.size());
      assertEquals(128, qualifierInfoVector1.size());
      
      StringVector stringVector0 = options0.getAllGeneNames();
      assertNotNull(stringVector0);
      assertFalse(options0.isEmpty());
      assertFalse(options0.isUnixHost());
      assertEquals(215, options0.size());
      assertEquals(16, stringVector0.capacity());
      assertEquals(11, stringVector0.size());
      assertFalse(stringVector0.isEmpty());
      assertEquals("[E9$a], [|sqnG, primary_name, Name, synonym, systematic_id, temporary_systematic_id, gene, locus_tag, label, ID]", stringVector0.toString());
      
      StringVector stringVector1 = Options.getPropertyValues(options0, "");
      assertNull(stringVector1);
      assertFalse(options0.isEmpty());
      assertFalse(options0.isUnixHost());
      assertEquals(215, options0.size());
      
      EntryInformation entryInformation0 = Options.getDBEntryInformation();
      assertNotNull(entryInformation0);
      assertTrue(entryInformation0.useEMBLFormat());
      
      int int0 = options0.getMinimumORFSize();
      assertEquals(100, int0);
      assertFalse(options0.isEmpty());
      assertFalse(options0.isUnixHost());
      assertEquals(215, options0.size());
      
      boolean boolean2 = Options.isBlackBeltMode();
      assertTrue(boolean2 == boolean0);
      assertTrue(boolean2 == boolean1);
      assertFalse(boolean2);
      
      options0.setDirectEdit(false);
      assertFalse(options0.isEmpty());
      assertFalse(options0.isUnixHost());
      assertEquals(215, options0.size());
      
      PipedInputStream pipedInputStream0 = new PipedInputStream();
      assertNotNull(pipedInputStream0);
      assertEquals(0, pipedInputStream0.available());
      
      long long0 = pipedInputStream0.skip((-412L));
      assertEquals(0L, long0);
      assertEquals(0, pipedInputStream0.available());
      
      long long1 = pipedInputStream0.skip((-412L));
      assertTrue(long1 == long0);
      assertEquals(0L, long1);
      assertEquals(0, pipedInputStream0.available());
      
      BufferedInputStream bufferedInputStream0 = new BufferedInputStream(pipedInputStream0);
      assertNotNull(bufferedInputStream0);
      assertEquals(0, pipedInputStream0.available());
      
      bufferedInputStream0.close();
      assertEquals(0, pipedInputStream0.available());
      
      bufferedInputStream0.close();
      assertEquals(0, pipedInputStream0.available());
      
      try { 
        options0.load((InputStream) bufferedInputStream0);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // Stream closed
         //
         verifyException("java.io.BufferedInputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      Options options0 = new Options();
      //  // Unstable assertion: assertNotNull(options0);
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      //  // Unstable assertion: assertEquals(216, options0.size());
      
      MockHijrahDate mockHijrahDate0 = new MockHijrahDate();
      //  // Unstable assertion: assertNotNull(mockHijrahDate0);
      
      Object object0 = options0.remove((Object) mockHijrahDate0);
      //  // Unstable assertion: assertNull(object0);
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      //  // Unstable assertion: assertEquals(216, options0.size());
      
      options0.setDirectEdit(false);
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      //  // Unstable assertion: assertEquals(216, options0.size());
      
      StringVector stringVector0 = options0.getInvisibleQualifiers(true);
      //  // Unstable assertion: assertNotNull(stringVector0);
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      //  // Unstable assertion: assertEquals(216, options0.size());
      //  // Unstable assertion: assertEquals(320, stringVector0.capacity());
      //  // Unstable assertion: assertFalse(stringVector0.isEmpty());
      //  // Unstable assertion: assertEquals(163, stringVector0.size());
      
      options0.setDirectEdit(true);
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      //  // Unstable assertion: assertEquals(216, options0.size());
      
      int int0 = options0.getUndoLevels();
      //  // Unstable assertion: assertEquals(20, int0);
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      //  // Unstable assertion: assertEquals(216, options0.size());
      
      options0.setGeneticCode("O,Mh6Pskywih");
      //  // Unstable assertion: assertEquals(217, options0.size());
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      
      options0.setDisplayNameQualifiers("O,Mh6Pskywih");
      //  // Unstable assertion: assertEquals(217, options0.size());
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      
      boolean boolean0 = Options.isBlackBeltMode();
      //  // Unstable assertion: assertFalse(boolean0);
      
      StringVector stringVector1 = options0.getAllGeneNames();
      //  // Unstable assertion: assertFalse(stringVector1.equals((Object)stringVector0));
      //  // Unstable assertion: assertNotNull(stringVector1);
      //  // Unstable assertion: assertNotSame(stringVector1, stringVector0);
      //  // Unstable assertion: assertEquals(217, options0.size());
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      //  // Unstable assertion: assertFalse(stringVector1.isEmpty());
      //  // Unstable assertion: assertEquals("[systematic_id, temporary_systematic_id, locus_tag, gene, label, ID, Name, O,Mh6Pskywih]", stringVector1.toString());
      //  // Unstable assertion: assertEquals(8, stringVector1.size());
      //  // Unstable assertion: assertEquals(14, stringVector1.capacity());
      
      boolean boolean1 = options0.isBuggyLinuxVM();
      //  // Unstable assertion: assertTrue(boolean1 == boolean0);
      //  // Unstable assertion: assertFalse(boolean1);
      //  // Unstable assertion: assertEquals(217, options0.size());
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      
      StringVector stringVector2 = options0.getStartCodons();
      //  // Unstable assertion: assertFalse(stringVector2.equals((Object)stringVector0));
      //  // Unstable assertion: assertFalse(stringVector2.equals((Object)stringVector1));
      //  // Unstable assertion: assertNotNull(stringVector2);
      //  // Unstable assertion: assertNotSame(stringVector2, stringVector0);
      //  // Unstable assertion: assertNotSame(stringVector2, stringVector1);
      //  // Unstable assertion: assertEquals(217, options0.size());
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      //  // Unstable assertion: assertEquals(1, stringVector2.size());
      //  // Unstable assertion: assertEquals(10, stringVector2.capacity());
      //  // Unstable assertion: assertFalse(stringVector2.isEmpty());
      //  // Unstable assertion: assertEquals("[atg]", stringVector2.toString());
      
      StringVector stringVector3 = options0.getDisplayQualifierNames();
      //  // Unstable assertion: assertFalse(stringVector3.equals((Object)stringVector2));
      //  // Unstable assertion: assertFalse(stringVector3.equals((Object)stringVector1));
      //  // Unstable assertion: assertFalse(stringVector3.equals((Object)stringVector0));
      //  // Unstable assertion: assertNotNull(stringVector3);
      //  // Unstable assertion: assertNotSame(stringVector3, stringVector2);
      //  // Unstable assertion: assertNotSame(stringVector3, stringVector1);
      //  // Unstable assertion: assertNotSame(stringVector3, stringVector0);
      //  // Unstable assertion: assertEquals(217, options0.size());
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      //  // Unstable assertion: assertFalse(stringVector3.isEmpty());
      //  // Unstable assertion: assertEquals("[O,Mh6Pskywih]", stringVector3.toString());
      //  // Unstable assertion: assertEquals(10, stringVector3.capacity());
      //  // Unstable assertion: assertEquals(1, stringVector3.size());
      
      boolean boolean2 = options0.canDirectEdit();
      //  // Unstable assertion: assertFalse(boolean2 == boolean0);
      //  // Unstable assertion: assertFalse(boolean2 == boolean1);
      //  // Unstable assertion: assertTrue(boolean2);
      //  // Unstable assertion: assertEquals(217, options0.size());
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      
      StringVector stringVector4 = options0.getSystematicQualifierNames();
      //  // Unstable assertion: assertFalse(stringVector4.equals((Object)stringVector2));
      //  // Unstable assertion: assertFalse(stringVector4.equals((Object)stringVector3));
      //  // Unstable assertion: assertFalse(stringVector4.equals((Object)stringVector1));
      //  // Unstable assertion: assertFalse(stringVector4.equals((Object)stringVector0));
      //  // Unstable assertion: assertNotNull(stringVector4);
      //  // Unstable assertion: assertNotSame(stringVector4, stringVector2);
      //  // Unstable assertion: assertNotSame(stringVector4, stringVector3);
      //  // Unstable assertion: assertNotSame(stringVector4, stringVector1);
      //  // Unstable assertion: assertNotSame(stringVector4, stringVector0);
      //  // Unstable assertion: assertEquals(217, options0.size());
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      //  // Unstable assertion: assertEquals("[systematic_id, temporary_systematic_id, locus_tag, gene, label, ID, Name]", stringVector4.toString());
      //  // Unstable assertion: assertFalse(stringVector4.isEmpty());
      //  // Unstable assertion: assertEquals(10, stringVector4.capacity());
      //  // Unstable assertion: assertEquals(7, stringVector4.size());
      
      QualifierInfoVector qualifierInfoVector0 = options0.getExtraGffQualifiers();
      //  // Unstable assertion: assertNotNull(qualifierInfoVector0);
      //  // Unstable assertion: assertEquals(27, qualifierInfoVector0.size());
      //  // Unstable assertion: assertEquals(217, options0.size());
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      Options options0 = new Options();
      //  // Unstable assertion: assertNotNull(options0);
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      //  // Unstable assertion: assertEquals(216, options0.size());
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      
      byte[] byteArray0 = new byte[3];
      boolean boolean0 = FileSystemHandling.setPermissions((EvoSuiteFile) null, false, false, false);
      //  // Unstable assertion: assertFalse(boolean0);
      
      byteArray0[0] = (byte) (-38);
      byteArray0[1] = (byte)22;
      DatabaseDocument.EXONMODEL = java.lang.System.getProperty("user.home") + "/.artemis/cache/";
      byteArray0[2] = (byte)93;
      ByteArrayReader byteArrayReader0 = new ByteArrayReader(byteArray0);
      //  // Unstable assertion: assertNotNull(byteArrayReader0);
      //  // Unstable assertion: assertArrayEquals(new byte[] {(byte) (-38), (byte)22, (byte)93}, byteArray0);
      //  // Unstable assertion: assertEquals(3, byteArrayReader0.available());
      
      options0.load((InputStream) byteArrayReader0);
      //  // Unstable assertion: assertArrayEquals(new byte[] {(byte) (-38), (byte)22, (byte)93}, byteArray0);
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertEquals(217, options0.size());
      //  // Unstable assertion: assertEquals(0, byteArrayReader0.available());
      
      String string0 = options0.getDefaultSequenceFileName();
      //  // Unstable assertion: assertNull(string0);
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertEquals(217, options0.size());
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      boolean boolean0 = Options.readWritePossible();
      assertTrue(boolean0);
      
      FileSystemHandling fileSystemHandling0 = new FileSystemHandling();
      assertNotNull(fileSystemHandling0);
      
      Options options0 = new Options();
      assertNotNull(options0);
      assertFalse(options0.isUnixHost());
      assertEquals(215, options0.size());
      assertFalse(options0.isEmpty());
      
      StringVector stringVector0 = options0.getAllGeneNames();
      assertNotNull(stringVector0);
      assertFalse(options0.isUnixHost());
      assertEquals(215, options0.size());
      assertFalse(options0.isEmpty());
      assertEquals("[systematic_id, temporary_systematic_id, locus_tag, gene, label, ID, Name, primary_name, Name, synonym, systematic_id, temporary_systematic_id, gene, locus_tag, label, ID]", stringVector0.toString());
      assertEquals(28, stringVector0.capacity());
      assertEquals(16, stringVector0.size());
      assertFalse(stringVector0.isEmpty());
      
      StringVector stringVector1 = options0.getAllGeneNames();
      assertNotNull(stringVector1);
      assertSame(stringVector1, stringVector0);
      assertFalse(options0.isUnixHost());
      assertEquals(215, options0.size());
      assertFalse(options0.isEmpty());
      assertEquals("[systematic_id, temporary_systematic_id, locus_tag, gene, label, ID, Name, primary_name, Name, synonym, systematic_id, temporary_systematic_id, gene, locus_tag, label, ID]", stringVector1.toString());
      assertEquals(28, stringVector1.capacity());
      assertFalse(stringVector1.isEmpty());
      assertEquals(16, stringVector1.size());
      
      URL uRL0 = MockURL.getHttpExample();
      assertNotNull(uRL0);
      assertEquals("http://www.someFakeButWellFormedURL.org/fooExample", uRL0.toString());
      assertEquals("http://www.someFakeButWellFormedURL.org/fooExample", uRL0.toExternalForm());
      assertEquals("www.someFakeButWellFormedURL.org", uRL0.getAuthority());
      assertEquals("www.someFakeButWellFormedURL.org", uRL0.getHost());
      assertEquals("http", uRL0.getProtocol());
      assertNull(uRL0.getQuery());
      assertNull(uRL0.getUserInfo());
      assertEquals((-1), uRL0.getPort());
      assertNull(uRL0.getRef());
      assertEquals((-1), uRL0.getDefaultPort());
      
      org.apache.log4j.Logger logger0 = IndexedGFFDocumentEntry.logger4j;
      assertNotNull(logger0);
      assertEquals("uk.ac.sanger.artemis.io.IndexedGFFDocumentEntry", logger0.getName());
      assertFalse(logger0.isDebugEnabled());
      assertTrue(logger0.getAdditivity());
      assertFalse(logger0.isInfoEnabled());
      assertFalse(logger0.isTraceEnabled());
      
      AsyncAppender asyncAppender0 = new AsyncAppender();
      assertNotNull(asyncAppender0);
      assertEquals(128, AsyncAppender.DEFAULT_BUFFER_SIZE);
      assertNull(asyncAppender0.getName());
      assertFalse(asyncAppender0.requiresLayout());
      assertFalse(asyncAppender0.getLocationInfo());
      assertTrue(asyncAppender0.getBlocking());
      assertEquals(128, asyncAppender0.getBufferSize());
      
      Appender appender0 = asyncAppender0.getAppender("false");
      assertNull(appender0);
      assertEquals(128, AsyncAppender.DEFAULT_BUFFER_SIZE);
      assertNull(asyncAppender0.getName());
      assertFalse(asyncAppender0.requiresLayout());
      assertFalse(asyncAppender0.getLocationInfo());
      assertTrue(asyncAppender0.getBlocking());
      assertEquals(128, asyncAppender0.getBufferSize());
      
      logger0.addAppender((Appender) null);
      assertEquals("uk.ac.sanger.artemis.io.IndexedGFFDocumentEntry", logger0.getName());
      assertFalse(logger0.isDebugEnabled());
      assertTrue(logger0.getAdditivity());
      assertFalse(logger0.isInfoEnabled());
      assertFalse(logger0.isTraceEnabled());
      
      LoggerRepository loggerRepository0 = logger0.getHierarchy();
      assertNotNull(loggerRepository0);
      assertEquals("uk.ac.sanger.artemis.io.IndexedGFFDocumentEntry", logger0.getName());
      assertFalse(logger0.isDebugEnabled());
      assertTrue(logger0.getAdditivity());
      assertFalse(logger0.isInfoEnabled());
      assertFalse(logger0.isTraceEnabled());
      
      OptionConverter.selectAndConfigure(uRL0, "I2|^?6~M)K?fr6;?iq", loggerRepository0);
      assertEquals("http://www.someFakeButWellFormedURL.org/fooExample", uRL0.toString());
      assertEquals("http://www.someFakeButWellFormedURL.org/fooExample", uRL0.toExternalForm());
      assertEquals("www.someFakeButWellFormedURL.org", uRL0.getAuthority());
      assertEquals("www.someFakeButWellFormedURL.org", uRL0.getHost());
      assertEquals("http", uRL0.getProtocol());
      assertNull(uRL0.getQuery());
      assertNull(uRL0.getUserInfo());
      assertEquals((-1), uRL0.getPort());
      assertNull(uRL0.getRef());
      assertEquals((-1), uRL0.getDefaultPort());
      assertEquals("uk.ac.sanger.artemis.io.IndexedGFFDocumentEntry", logger0.getName());
      assertFalse(logger0.isDebugEnabled());
      assertTrue(logger0.getAdditivity());
      assertFalse(logger0.isInfoEnabled());
      assertFalse(logger0.isTraceEnabled());
      
      options0.setDisplayNameQualifiers("OP*JzH|}$/)=TAxh");
      assertFalse(options0.isUnixHost());
      assertEquals(215, options0.size());
      assertFalse(options0.isEmpty());
      
      options0.setHighlightActiveEntryFlag(true);
      assertFalse(options0.isUnixHost());
      assertFalse(options0.isEmpty());
      assertEquals(216, options0.size());
      
      options0.setDirectEdit(true);
      assertFalse(options0.isUnixHost());
      assertFalse(options0.isEmpty());
      assertEquals(216, options0.size());
      
      Font font0 = options0.getFont();
      assertNotNull(font0);
      assertFalse(options0.isUnixHost());
      assertFalse(options0.isEmpty());
      assertEquals(216, options0.size());
      assertFalse(font0.isTransformed());
      assertEquals("Monospaced", font0.getName());
      assertEquals(0, font0.getStyle());
      assertFalse(font0.isBold());
      assertEquals(12.0F, font0.getSize2D(), 0.01F);
      assertFalse(font0.hasLayoutAttributes());
      assertEquals(12, font0.getSize());
      assertFalse(font0.isItalic());
      assertTrue(font0.isPlain());
      assertFalse(font0.hasUniformLineMetrics());
      
      boolean boolean1 = Options.isUnixHost();
      assertFalse(boolean1 == boolean0);
      assertFalse(boolean1);
      
      StringVector stringVector2 = options0.getAllGeneNames();
      assertNotNull(stringVector2);
      assertSame(stringVector2, stringVector0);
      assertSame(stringVector2, stringVector1);
      assertEquals("[systematic_id, temporary_systematic_id, locus_tag, gene, label, ID, Name, primary_name, Name, synonym, systematic_id, temporary_systematic_id, gene, locus_tag, label, ID]", stringVector2.toString());
      assertEquals(28, stringVector2.capacity());
      assertEquals(16, stringVector2.size());
      assertFalse(stringVector2.isEmpty());
      assertFalse(options0.isUnixHost());
      assertFalse(options0.isEmpty());
      assertEquals(216, options0.size());
      
      boolean boolean2 = options0.highlightActiveEntryFlag();
      assertTrue(boolean2 == boolean0);
      assertFalse(boolean2 == boolean1);
      assertTrue(boolean2);
      assertFalse(options0.isUnixHost());
      assertFalse(options0.isEmpty());
      assertEquals(216, options0.size());
      
      StringVector stringVector3 = options0.getOptionValues("colour_5");
      assertFalse(stringVector3.equals((Object)stringVector0));
      assertFalse(stringVector3.equals((Object)stringVector2));
      assertFalse(stringVector3.equals((Object)stringVector1));
      assertNotNull(stringVector3);
      assertNotSame(stringVector3, stringVector0);
      assertNotSame(stringVector3, stringVector2);
      assertNotSame(stringVector3, stringVector1);
      assertFalse(options0.isUnixHost());
      assertFalse(options0.isEmpty());
      assertEquals(216, options0.size());
      assertFalse(stringVector3.isEmpty());
      assertEquals(3, stringVector3.size());
      assertEquals(10, stringVector3.capacity());
      assertEquals("[0, 255, 255]", stringVector3.toString());
      
      QualifierInfoVector qualifierInfoVector0 = options0.getExtraQualifiers();
      assertNotNull(qualifierInfoVector0);
      assertFalse(options0.isUnixHost());
      assertFalse(options0.isEmpty());
      assertEquals(216, options0.size());
      assertEquals(128, qualifierInfoVector0.size());
      
      int int0 = options0.getUndoLevels();
      assertEquals(20, int0);
      assertFalse(options0.isUnixHost());
      assertFalse(options0.isEmpty());
      assertEquals(216, options0.size());
      
      Font font1 = options0.getFont();
      assertNotNull(font1);
      assertSame(font1, font0);
      assertFalse(options0.isUnixHost());
      assertFalse(options0.isEmpty());
      assertEquals(216, options0.size());
      assertEquals(12.0F, font1.getSize2D(), 0.01F);
      assertEquals(0, font1.getStyle());
      assertFalse(font1.isTransformed());
      assertEquals("Monospaced", font1.getName());
      assertFalse(font1.isBold());
      assertFalse(font1.isItalic());
      assertFalse(font1.hasUniformLineMetrics());
      assertTrue(font1.isPlain());
      assertFalse(font1.hasLayoutAttributes());
      assertEquals(12, font1.getSize());
      
      Options options1 = Options.getOptions();
      assertFalse(options1.equals((Object)options0));
      assertNotNull(options1);
      assertNotSame(options1, options0);
      assertEquals(216, options1.size());
      assertFalse(options1.isEmpty());
      assertFalse(options1.isUnixHost());
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      boolean boolean0 = FileSystemHandling.shouldThrowIOException((EvoSuiteFile) null);
      //  // Unstable assertion: assertFalse(boolean0);
      
      boolean boolean1 = FileSystemHandling.appendStringToFile((EvoSuiteFile) null, "aY '74v F^UDc'l+t");
      //  // Unstable assertion: assertTrue(boolean1 == boolean0);
      //  // Unstable assertion: assertFalse(boolean1);
      
      boolean boolean2 = FileSystemHandling.shouldAllThrowIOExceptions();
      //  // Unstable assertion: assertFalse(boolean2 == boolean0);
      //  // Unstable assertion: assertFalse(boolean2 == boolean1);
      //  // Unstable assertion: assertTrue(boolean2);
      
      Options options0 = Options.getOptions();
      //  // Unstable assertion: assertNotNull(options0);
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertEquals(215, options0.size());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      
      Collection<Object> collection0 = options0.values();
      //  // Unstable assertion: assertNotNull(collection0);
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertEquals(215, options0.size());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      
      boolean boolean3 = options0.isBuggyLinuxVM();
      //  // Unstable assertion: assertFalse(boolean3 == boolean2);
      //  // Unstable assertion: assertTrue(boolean3 == boolean0);
      //  // Unstable assertion: assertTrue(boolean3 == boolean1);
      //  // Unstable assertion: assertFalse(boolean3);
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertEquals(215, options0.size());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      
      options0.setDirectEdit(false);
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertEquals(215, options0.size());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      
      options0.setDisplayNameQualifiers("intron");
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertEquals(215, options0.size());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      
      boolean boolean4 = options0.isBuggyLinuxVM();
      //  // Unstable assertion: assertTrue(boolean4 == boolean1);
      //  // Unstable assertion: assertTrue(boolean4 == boolean0);
      //  // Unstable assertion: assertFalse(boolean4 == boolean2);
      //  // Unstable assertion: assertTrue(boolean4 == boolean3);
      //  // Unstable assertion: assertFalse(boolean4);
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertEquals(215, options0.size());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      
      boolean boolean5 = options0.highlightActiveEntryFlag();
      //  // Unstable assertion: assertTrue(boolean5 == boolean3);
      //  // Unstable assertion: assertTrue(boolean5 == boolean4);
      //  // Unstable assertion: assertFalse(boolean5 == boolean2);
      //  // Unstable assertion: assertTrue(boolean5 == boolean1);
      //  // Unstable assertion: assertTrue(boolean5 == boolean0);
      //  // Unstable assertion: assertFalse(boolean5);
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertEquals(215, options0.size());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      
      boolean boolean6 = options0.isBuggyLinuxVM();
      //  // Unstable assertion: assertTrue(boolean6 == boolean5);
      //  // Unstable assertion: assertTrue(boolean6 == boolean0);
      //  // Unstable assertion: assertTrue(boolean6 == boolean1);
      //  // Unstable assertion: assertTrue(boolean6 == boolean3);
      //  // Unstable assertion: assertFalse(boolean6 == boolean2);
      //  // Unstable assertion: assertTrue(boolean6 == boolean4);
      //  // Unstable assertion: assertFalse(boolean6);
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertEquals(215, options0.size());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      
      options0.setGeneticCode("UjYT9");
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertEquals(216, options0.size());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      
      try { 
        MockFile.createTempFile("intron", "3Wfb'OPI");
       //  fail("Expecting exception: IOException");
       // Unstable assertion
      } catch(IOException e) {
         //
         // Simulated IOException
         //
         verifyException("org.evosuite.runtime.vfs.VirtualFileSystem", e);
      }
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      boolean boolean0 = FileSystemHandling.shouldAllThrowIOExceptions();
      assertTrue(boolean0);
      
      Options options0 = new Options();
      assertNotNull(options0);
      assertFalse(options0.isEmpty());
      assertEquals(137, options0.size());
      assertFalse(options0.isUnixHost());
      
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      assertNotNull(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      
      Entry entry0 = simpleEntryGroup0.createEntry();
      assertNotNull(entry0);
      assertEquals(1, simpleEntryGroup0.size());
      assertEquals(0, simpleEntryGroup0.refCount());
      assertFalse(entry0.isReadOnly());
      
      // Undeclared exception!
      try { 
        simpleEntryGroup0.elementAt((-945));
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      FileSystemHandling fileSystemHandling0 = new FileSystemHandling();
      //  // Unstable assertion: assertNotNull(fileSystemHandling0);
      
      FileSystemHandling fileSystemHandling1 = new FileSystemHandling();
      //  // Unstable assertion: assertFalse(fileSystemHandling1.equals((Object)fileSystemHandling0));
      //  // Unstable assertion: assertNotNull(fileSystemHandling1);
      
      Options options0 = Options.getOptions();
      //  // Unstable assertion: assertNotNull(options0);
      //  // Unstable assertion: assertEquals(215, options0.size());
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      
      URL uRL0 = Loader.getResource("f");
      //  // Unstable assertion: assertNull(uRL0);
      
      boolean boolean0 = options0.canDirectEdit();
      //  // Unstable assertion: assertTrue(boolean0);
      //  // Unstable assertion: assertEquals(215, options0.size());
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      
      Splash.appendToLog((String) null);
      FontUIResource fontUIResource0 = options0.getFontUIResource();
      //  // Unstable assertion: assertNotNull(fontUIResource0);
      //  // Unstable assertion: assertEquals(215, options0.size());
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      //  // Unstable assertion: assertFalse(fontUIResource0.isTransformed());
      //  // Unstable assertion: assertEquals("Monospaced", fontUIResource0.getName());
      //  // Unstable assertion: assertFalse(fontUIResource0.hasLayoutAttributes());
      //  // Unstable assertion: assertFalse(fontUIResource0.isBold());
      //  // Unstable assertion: assertFalse(fontUIResource0.hasUniformLineMetrics());
      //  // Unstable assertion: assertFalse(fontUIResource0.isItalic());
      //  // Unstable assertion: assertEquals(12.0F, fontUIResource0.getSize2D(), 0.01F);
      //  // Unstable assertion: assertEquals(0, fontUIResource0.getStyle());
      //  // Unstable assertion: assertTrue(fontUIResource0.isPlain());
      //  // Unstable assertion: assertEquals(12, fontUIResource0.getSize());
      
      boolean boolean1 = options0.canDirectEdit();
      //  // Unstable assertion: assertTrue(boolean1 == boolean0);
      //  // Unstable assertion: assertTrue(boolean1);
      //  // Unstable assertion: assertEquals(215, options0.size());
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      
      boolean boolean2 = Options.isNoddyMode();
      //  // Unstable assertion: assertTrue(boolean2 == boolean0);
      //  // Unstable assertion: assertTrue(boolean2 == boolean1);
      //  // Unstable assertion: assertTrue(boolean2);
      
      boolean boolean3 = FileSystemHandling.appendLineToFile((EvoSuiteFile) null, (String) null);
      //  // Unstable assertion: assertFalse(boolean3 == boolean2);
      //  // Unstable assertion: assertFalse(boolean3 == boolean0);
      //  // Unstable assertion: assertFalse(boolean3 == boolean1);
      //  // Unstable assertion: assertFalse(boolean3);
      
      Options options1 = Options.getOptions();
      //  // Unstable assertion: assertNotNull(options1);
      //  // Unstable assertion: assertSame(options1, options0);
      //  // Unstable assertion: assertEquals(215, options1.size());
      //  // Unstable assertion: assertFalse(options1.isEmpty());
      //  // Unstable assertion: assertFalse(options1.isUnixHost());
      
      // Undeclared exception!
      try { 
        options1.setDisplayNameQualifiers((String) null);
       //  fail("Expecting exception: NullPointerException");
       // Unstable assertion
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.util.Hashtable", e);
      }
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      Options options0 = new Options();
      
      LogLog.setInternalDebugging(true);
      Key key0 = new Key(java.lang.System.getProperty("user.home") + "/.artemis/cache/");
      
      Color color0 = options0.getDefaultFeatureColour(key0);
      
      Color color1 = options0.getDefaultFeatureColour(key0);
      
      Integer integer0 = options0.getIntegerProperty("yes");
      
      options0.setSystematicQualifierNames("yes");
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
    Future<?> future = executor.submit(new Runnable(){ 
            @Override public void run() { 
          EntryInformation entryInformation0 = Options.getArtemisEntryInformation();
          assertNotNull(entryInformation0);
          assertFalse(entryInformation0.useEMBLFormat());
          
          Options options0 = new Options();
          assertNotNull(options0);
          assertFalse(options0.isEmpty());
          assertFalse(options0.isUnixHost());
          assertEquals(215, options0.size());
          
          options0.setGeneticCode("?;TF][Z,E<s>O");
          assertFalse(options0.isEmpty());
          assertFalse(options0.isUnixHost());
          assertEquals(216, options0.size());
          
          Collection<Object> collection0 = options0.values();
          assertNotNull(collection0);
          assertFalse(options0.isEmpty());
          assertFalse(options0.isUnixHost());
          assertEquals(216, options0.size());
          
          FileSystemHandling fileSystemHandling0 = new FileSystemHandling();
          assertNotNull(fileSystemHandling0);
          
          options0.setDefaultColourMap();
          assertFalse(options0.isEmpty());
          assertFalse(options0.isUnixHost());
          assertEquals(216, options0.size());
          
          StringVector stringVector0 = options0.getOptionValues("yes");
          assertNull(stringVector0);
          assertFalse(options0.isEmpty());
          assertFalse(options0.isUnixHost());
          assertEquals(216, options0.size());
          
          boolean boolean0 = Options.readWritePossible();
          assertTrue(boolean0);
          
          options0.setEukaryoticMode(true);
          assertFalse(options0.isEmpty());
          assertFalse(options0.isUnixHost());
          assertEquals(216, options0.size());
      } 
    });
    future.get(4000, TimeUnit.MILLISECONDS);
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      Options options0 = Options.getOptions();
      //  // Unstable assertion: assertNotNull(options0);
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      //  // Unstable assertion: assertEquals(215, options0.size());
      
      String string0 = options0.getDefaultSequenceFileName();
      //  // Unstable assertion: assertNull(string0);
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      //  // Unstable assertion: assertEquals(215, options0.size());
      
      QualifierInfoVector qualifierInfoVector0 = options0.getExtraGffQualifiers();
      //  // Unstable assertion: assertNotNull(qualifierInfoVector0);
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      //  // Unstable assertion: assertEquals(215, options0.size());
      //  // Unstable assertion: assertEquals(27, qualifierInfoVector0.size());
      
      options0.setGeneticCode("yes");
      //  // Unstable assertion: assertEquals(216, options0.size());
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      
      boolean boolean0 = Options.readWritePossible();
      //  // Unstable assertion: assertTrue(boolean0);
      
      StringVector stringVector0 = options0.getDisplayQualifierNames();
      //  // Unstable assertion: assertNotNull(stringVector0);
      //  // Unstable assertion: assertEquals(216, options0.size());
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      //  // Unstable assertion: assertEquals(9, stringVector0.size());
      //  // Unstable assertion: assertFalse(stringVector0.isEmpty());
      //  // Unstable assertion: assertEquals(10, stringVector0.capacity());
      //  // Unstable assertion: assertEquals("[primary_name, Name, synonym, systematic_id, temporary_systematic_id, gene, locus_tag, label, ID]", stringVector0.toString());
      
      options0.setHighlightActiveEntryFlag(true);
      //  // Unstable assertion: assertEquals(217, options0.size());
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      
      StringVector stringVector1 = options0.getSystematicQualifierNames();
      //  // Unstable assertion: assertFalse(stringVector1.equals((Object)stringVector0));
      //  // Unstable assertion: assertNotNull(stringVector1);
      //  // Unstable assertion: assertNotSame(stringVector1, stringVector0);
      //  // Unstable assertion: assertEquals(217, options0.size());
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      //  // Unstable assertion: assertEquals(7, stringVector1.size());
      //  // Unstable assertion: assertEquals(10, stringVector1.capacity());
      //  // Unstable assertion: assertFalse(stringVector1.isEmpty());
      //  // Unstable assertion: assertEquals("[systematic_id, temporary_systematic_id, locus_tag, gene, label, ID, Name]", stringVector1.toString());
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      boolean boolean0 = FileSystemHandling.setPermissions((EvoSuiteFile) null, true, true, false);
      //  // Unstable assertion: assertFalse(boolean0);
      
      Options options0 = Options.getOptions();
      //  // Unstable assertion: assertNotNull(options0);
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertEquals(215, options0.size());
      
      Options options1 = Options.getOptions();
      //  // Unstable assertion: assertNotNull(options1);
      //  // Unstable assertion: assertSame(options1, options0);
      //  // Unstable assertion: assertEquals(215, options1.size());
      //  // Unstable assertion: assertFalse(options1.isUnixHost());
      //  // Unstable assertion: assertFalse(options1.isEmpty());
      
      // Undeclared exception!
      try { 
        options1.addOptionChangeListener((OptionChangeListener) null);
       //  fail("Expecting exception: NullPointerException");
       // Unstable assertion
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      boolean boolean0 = Options.isNoddyMode();
      //  // Unstable assertion: assertTrue(boolean0);
      
      Options options0 = Options.getOptions();
      //  // Unstable assertion: assertNotNull(options0);
      //  // Unstable assertion: assertEquals(215, options0.size());
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      
      // Undeclared exception!
      try { 
        options0.getPropertyTruthValue((String) null);
       //  fail("Expecting exception: NullPointerException");
       // Unstable assertion
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      Options options0 = Options.getOptions();
      //  // Unstable assertion: assertNotNull(options0);
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      //  // Unstable assertion: assertEquals(215, options0.size());
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      
      options0.setHighlightActiveEntryFlag(false);
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      //  // Unstable assertion: assertEquals(215, options0.size());
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      
      ExternalProgramVector externalProgramVector0 = options0.getNCBIPrograms();
      //  // Unstable assertion: assertNotNull(externalProgramVector0);
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      //  // Unstable assertion: assertEquals(215, options0.size());
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertEquals(5, externalProgramVector0.size());
      
      Color color0 = options0.getColorFromColourNumber(1);
      //  // Unstable assertion: assertNotNull(color0);
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      //  // Unstable assertion: assertEquals(215, options0.size());
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertEquals(100, color0.getBlue());
      //  // Unstable assertion: assertEquals((-10197916), color0.getRGB());
      //  // Unstable assertion: assertEquals(100, color0.getRed());
      //  // Unstable assertion: assertEquals(1, color0.getTransparency());
      //  // Unstable assertion: assertEquals(100, color0.getGreen());
      //  // Unstable assertion: assertEquals(255, color0.getAlpha());
      
      boolean boolean0 = options0.canDirectEdit();
      //  // Unstable assertion: assertTrue(boolean0);
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      //  // Unstable assertion: assertEquals(215, options0.size());
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      
      ExternalProgramVector externalProgramVector1 = options0.getNCBIPrograms();
      //  // Unstable assertion: assertNotNull(externalProgramVector1);
      //  // Unstable assertion: assertSame(externalProgramVector1, externalProgramVector0);
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      //  // Unstable assertion: assertEquals(215, options0.size());
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertEquals(5, externalProgramVector1.size());
      
      Integer integer0 = options0.getIntegerProperty("\"})GDi;Hwo");
      //  // Unstable assertion: assertNull(integer0);
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      //  // Unstable assertion: assertEquals(215, options0.size());
      //  // Unstable assertion: assertFalse(options0.isEmpty());
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      Options options0 = new Options();
      //  // Unstable assertion: assertNotNull(options0);
      //  // Unstable assertion: assertEquals(216, options0.size());
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      //  // Unstable assertion: assertNotNull(blastEntryInformation0);
      //  // Unstable assertion: assertFalse(blastEntryInformation0.useEMBLFormat());
      
      Key key0 = blastEntryInformation0.getDefaultKey();
      //  // Unstable assertion: assertNotNull(key0);
      //  // Unstable assertion: assertFalse(blastEntryInformation0.useEMBLFormat());
      //  // Unstable assertion: assertEquals("misc_feature", key0.getKeyString());
      //  // Unstable assertion: assertEquals("misc_feature", key0.toString());
      //  // Unstable assertion: assertEquals(12, key0.length());
      
      boolean boolean0 = blastEntryInformation0.isRequiredQualifier(key0, java.lang.System.getProperty("user.home") + "/.artemis/cache/");
      //  // Unstable assertion: assertFalse(boolean0);
      //  // Unstable assertion: assertFalse(blastEntryInformation0.useEMBLFormat());
      //  // Unstable assertion: assertEquals("misc_feature", key0.getKeyString());
      //  // Unstable assertion: assertEquals("misc_feature", key0.toString());
      //  // Unstable assertion: assertEquals(12, key0.length());
      
      options0.setEukaryoticMode(false);
      //  // Unstable assertion: assertEquals(217, options0.size());
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      
      Key key1 = blastEntryInformation0.getDefaultKey();
      //  // Unstable assertion: assertTrue(key1.equals((Object)key0));
      //  // Unstable assertion: assertNotNull(key1);
      //  // Unstable assertion: assertNotSame(key1, key0);
      //  // Unstable assertion: assertFalse(blastEntryInformation0.useEMBLFormat());
      //  // Unstable assertion: assertEquals("misc_feature", key1.getKeyString());
      //  // Unstable assertion: assertEquals(12, key1.length());
      //  // Unstable assertion: assertEquals("misc_feature", key1.toString());
      
      Color color0 = options0.getDefaultFeatureColour(key1);
      //  // Unstable assertion: assertTrue(key1.equals((Object)key0));
      //  // Unstable assertion: assertNotNull(color0);
      //  // Unstable assertion: assertNotSame(key1, key0);
      //  // Unstable assertion: assertEquals(217, options0.size());
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      //  // Unstable assertion: assertFalse(blastEntryInformation0.useEMBLFormat());
      //  // Unstable assertion: assertEquals("misc_feature", key1.getKeyString());
      //  // Unstable assertion: assertEquals(12, key1.length());
      //  // Unstable assertion: assertEquals("misc_feature", key1.toString());
      //  // Unstable assertion: assertEquals(255, color0.getGreen());
      //  // Unstable assertion: assertEquals(1, color0.getTransparency());
      //  // Unstable assertion: assertEquals((-16711936), color0.getRGB());
      //  // Unstable assertion: assertEquals(255, color0.getAlpha());
      //  // Unstable assertion: assertEquals(0, color0.getBlue());
      //  // Unstable assertion: assertEquals(0, color0.getRed());
      
      options0.setHighlightActiveEntryFlag(true);
      //  // Unstable assertion: assertEquals(218, options0.size());
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      
      boolean boolean1 = FileSystemHandling.setPermissions((EvoSuiteFile) null, true, true, true);
      //  // Unstable assertion: assertTrue(boolean1 == boolean0);
      //  // Unstable assertion: assertFalse(boolean1);
      
      boolean boolean2 = Options.readWritePossible();
      //  // Unstable assertion: assertFalse(boolean2 == boolean1);
      //  // Unstable assertion: assertFalse(boolean2 == boolean0);
      //  // Unstable assertion: assertTrue(boolean2);
      
      boolean boolean3 = Options.readWritePossible();
      //  // Unstable assertion: assertFalse(boolean3 == boolean0);
      //  // Unstable assertion: assertFalse(boolean3 == boolean1);
      //  // Unstable assertion: assertTrue(boolean3 == boolean2);
      //  // Unstable assertion: assertTrue(boolean3);
      
      QualifierInfoVector qualifierInfoVector0 = options0.getExtraQualifiers();
      //  // Unstable assertion: assertNotNull(qualifierInfoVector0);
      //  // Unstable assertion: assertEquals(218, options0.size());
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      //  // Unstable assertion: assertEquals(128, qualifierInfoVector0.size());
      
      options0.setEukaryoticMode(false);
      //  // Unstable assertion: assertEquals(218, options0.size());
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      //  // Unstable assertion: assertNotNull(simpleEntryGroup0);
      //  // Unstable assertion: assertEquals(0, simpleEntryGroup0.size());
      //  // Unstable assertion: assertEquals(0, simpleEntryGroup0.refCount());
      
      Entry entry0 = simpleEntryGroup0.createEntry();
      //  // Unstable assertion: assertNotNull(entry0);
      //  // Unstable assertion: assertEquals(1, simpleEntryGroup0.size());
      //  // Unstable assertion: assertEquals(0, simpleEntryGroup0.refCount());
      //  // Unstable assertion: assertFalse(entry0.isReadOnly());
      
      // Undeclared exception!
      try { 
        entry0.getFeature(2828);
       //  fail("Expecting exception: NullPointerException");
       // Unstable assertion
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.Entry", e);
      }
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      Options options0 = new Options();
      //  // Unstable assertion: assertNotNull(options0);
      //  // Unstable assertion: assertEquals(216, options0.size());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      
      int int0 = options0.getMinimumORFSize();
      //  // Unstable assertion: assertEquals(100, int0);
      //  // Unstable assertion: assertEquals(216, options0.size());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      
      Set<Map.Entry<Object, Object>> set0 = (Set<Map.Entry<Object, Object>>)options0.entrySet();
      //  // Unstable assertion: assertNotNull(set0);
      //  // Unstable assertion: assertEquals(216, options0.size());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertFalse(set0.isEmpty());
      //  // Unstable assertion: assertEquals(216, set0.size());
      
      Font font0 = options0.getFont();
      //  // Unstable assertion: assertNotNull(font0);
      //  // Unstable assertion: assertEquals(216, options0.size());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertEquals(0, font0.getStyle());
      //  // Unstable assertion: assertEquals("Monospaced", font0.getName());
      //  // Unstable assertion: assertFalse(font0.isTransformed());
      //  // Unstable assertion: assertEquals(12, font0.getSize());
      //  // Unstable assertion: assertEquals(12.0F, font0.getSize2D(), 0.01F);
      //  // Unstable assertion: assertFalse(font0.hasLayoutAttributes());
      //  // Unstable assertion: assertTrue(font0.isPlain());
      //  // Unstable assertion: assertFalse(font0.hasUniformLineMetrics());
      //  // Unstable assertion: assertFalse(font0.isItalic());
      //  // Unstable assertion: assertFalse(font0.isBold());
      
      QualifierInfoVector qualifierInfoVector0 = options0.getExtraGffQualifiers();
      //  // Unstable assertion: assertNotNull(qualifierInfoVector0);
      //  // Unstable assertion: assertEquals(216, options0.size());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertEquals(27, qualifierInfoVector0.size());
      
      options0.reset();
      //  // Unstable assertion: assertEquals(215, options0.size());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      //  // Unstable assertion: assertFalse(options0.isEmpty());
  }

  @Test(timeout = 4000)
  public void test23()  throws Throwable  {
      boolean boolean0 = FileSystemHandling.appendStringToFile((EvoSuiteFile) null, (String) null);
      assertFalse(boolean0);
      
      Options options0 = new Options();
      assertNotNull(options0);
      assertFalse(options0.isUnixHost());
      assertEquals(215, options0.size());
      assertFalse(options0.isEmpty());
      
      options0.clear();
      assertTrue(options0.isEmpty());
      assertEquals(0, options0.size());
      assertFalse(options0.isUnixHost());
      
      // Undeclared exception!
      try { 
        options0.getOptionValues((String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test24()  throws Throwable  {
      Options options0 = Options.getOptions();
      assertNotNull(options0);
      assertFalse(options0.isEmpty());
      assertEquals(216, options0.size());
      assertFalse(options0.isUnixHost());
      
      boolean boolean0 = options0.canDirectEdit();
      assertTrue(boolean0);
      assertFalse(options0.isEmpty());
      assertEquals(216, options0.size());
      assertFalse(options0.isUnixHost());
      
      ExternalProgramVector externalProgramVector0 = options0.getExternalPrograms();
      assertNotNull(externalProgramVector0);
      assertFalse(options0.isEmpty());
      assertEquals(216, options0.size());
      assertFalse(options0.isUnixHost());
      assertEquals(28, externalProgramVector0.size());
      
      StringVector stringVector0 = options0.getInvisibleQualifiers(false);
      assertNotNull(stringVector0);
      assertFalse(options0.isEmpty());
      assertEquals(216, options0.size());
      assertFalse(options0.isUnixHost());
      assertEquals("[CHROMO_LINK, C_processing, C_processing_BigPi, C_processing_DGPI, COM_NAME, FEAT_NAME, LOCUS, PUB_LOCUS, PUB_COMMENT, REPEAT_TYPE, SNP, bicsw_file, blast_file, blast_score, blastn_file, blastp+go_file, blastp_file, blastx_file, cds_id, chloroplast, chromoplast, codon, comment_Cterm, comment_Nterm, created, cyanelle, end_phase, exception, exon_id, fasta_file, fasta_match, gene_id, go_from_interpro, hp_match, hth_file, interpro, map, mitochondrion, modified, number, obsolete_gene_name, pepstats_file, percent_id, pfam_match, prosite_match, pseudo, psu_domain, reserved_gene_name, query_id, sigcleave_file, score, smart_file, start_phase, tblastn_file, tblastx_file, temporary_systematic_id, transl_table, translation, type, usedin]", stringVector0.toString());
      assertEquals(60, stringVector0.size());
      assertEquals(80, stringVector0.capacity());
      assertFalse(stringVector0.isEmpty());
      
      StringVector stringVector1 = options0.getInvisibleQualifiers(false);
      assertNotNull(stringVector1);
      assertSame(stringVector1, stringVector0);
      assertFalse(options0.isEmpty());
      assertEquals(216, options0.size());
      assertFalse(options0.isUnixHost());
      assertEquals(60, stringVector1.size());
      assertEquals(80, stringVector1.capacity());
      assertFalse(stringVector1.isEmpty());
      assertEquals("[CHROMO_LINK, C_processing, C_processing_BigPi, C_processing_DGPI, COM_NAME, FEAT_NAME, LOCUS, PUB_LOCUS, PUB_COMMENT, REPEAT_TYPE, SNP, bicsw_file, blast_file, blast_score, blastn_file, blastp+go_file, blastp_file, blastx_file, cds_id, chloroplast, chromoplast, codon, comment_Cterm, comment_Nterm, created, cyanelle, end_phase, exception, exon_id, fasta_file, fasta_match, gene_id, go_from_interpro, hp_match, hth_file, interpro, map, mitochondrion, modified, number, obsolete_gene_name, pepstats_file, percent_id, pfam_match, prosite_match, pseudo, psu_domain, reserved_gene_name, query_id, sigcleave_file, score, smart_file, start_phase, tblastn_file, tblastx_file, temporary_systematic_id, transl_table, translation, type, usedin]", stringVector1.toString());
      
      int int0 = options0.getMinimumORFSize();
      assertEquals(100, int0);
      assertFalse(options0.isEmpty());
      assertEquals(216, options0.size());
      assertFalse(options0.isUnixHost());
      
      boolean boolean1 = FileSystemHandling.setPermissions((EvoSuiteFile) null, false, false, true);
      assertFalse(boolean1 == boolean0);
      assertFalse(boolean1);
      
      Enumeration<Object> enumeration0 = options0.keys();
      assertNotNull(enumeration0);
      assertFalse(options0.isEmpty());
      assertEquals(216, options0.size());
      assertFalse(options0.isUnixHost());
      
      options0.setGeneticCode("no");
      assertFalse(options0.isEmpty());
      assertEquals(217, options0.size());
      assertFalse(options0.isUnixHost());
      
      Enumeration<Object> enumeration1 = options0.keys();
      assertFalse(enumeration1.equals((Object)enumeration0));
      assertNotNull(enumeration1);
      assertNotSame(enumeration1, enumeration0);
      assertFalse(options0.isEmpty());
      assertEquals(217, options0.size());
      assertFalse(options0.isUnixHost());
      
      String string0 = options0.getDefaultSequenceFileName();
      assertNull(string0);
      assertFalse(options0.isEmpty());
      assertEquals(217, options0.size());
      assertFalse(options0.isUnixHost());
      
      int int1 = options0.getUndoLevels();
      assertFalse(int1 == int0);
      assertEquals(20, int1);
      assertFalse(options0.isEmpty());
      assertEquals(217, options0.size());
      assertFalse(options0.isUnixHost());
      
      EntryInformation entryInformation0 = Options.getDBEntryInformation();
      assertNotNull(entryInformation0);
      assertTrue(entryInformation0.useEMBLFormat());
      
      options0.setSystematicQualifierNames("8D)f#NuH");
      assertFalse(options0.isEmpty());
      assertEquals(217, options0.size());
      assertFalse(options0.isUnixHost());
      
      boolean boolean2 = Options.isBlackBeltMode();
      assertFalse(boolean2 == boolean0);
      assertTrue(boolean2 == boolean1);
      assertFalse(boolean2);
      
      boolean boolean3 = options0.isBuggyLinuxVM();
      assertTrue(boolean3 == boolean2);
      assertTrue(boolean3 == boolean1);
      assertFalse(boolean3 == boolean0);
      assertFalse(boolean3);
      assertFalse(options0.isEmpty());
      assertEquals(217, options0.size());
      assertFalse(options0.isUnixHost());
      
      ExternalProgramVector externalProgramVector1 = options0.getNCBIPrograms();
      assertFalse(externalProgramVector1.equals((Object)externalProgramVector0));
      assertNotNull(externalProgramVector1);
      assertNotSame(externalProgramVector1, externalProgramVector0);
      assertEquals(5, externalProgramVector1.size());
      assertFalse(options0.isEmpty());
      assertEquals(217, options0.size());
      assertFalse(options0.isUnixHost());
      
      boolean boolean4 = Options.isNoddyMode();
      assertFalse(boolean4 == boolean3);
      assertFalse(boolean4 == boolean2);
      assertTrue(boolean4 == boolean0);
      assertFalse(boolean4 == boolean1);
      assertTrue(boolean4);
  }

  @Test(timeout = 4000)
  public void test25()  throws Throwable  {
      Options options0 = Options.getOptions();
      assertNotNull(options0);
      assertFalse(options0.isEmpty());
      assertEquals(216, options0.size());
      assertFalse(options0.isUnixHost());
      
      boolean boolean0 = options0.isBuggyLinuxVM();
      assertFalse(boolean0);
      assertFalse(options0.isEmpty());
      assertEquals(216, options0.size());
      assertFalse(options0.isUnixHost());
      
      EntryInformation entryInformation0 = Options.getDBEntryInformation();
      assertNotNull(entryInformation0);
      assertTrue(entryInformation0.useEMBLFormat());
  }

  @Test(timeout = 4000)
  public void test26()  throws Throwable  {
      Options options0 = Options.getOptions();
      assertNotNull(options0);
      assertEquals(216, options0.size());
      assertFalse(options0.isUnixHost());
      assertFalse(options0.isEmpty());
      
      QualifierInfoVector qualifierInfoVector0 = options0.getExtraGffQualifiers();
      assertNotNull(qualifierInfoVector0);
      assertEquals(216, options0.size());
      assertFalse(options0.isUnixHost());
      assertFalse(options0.isEmpty());
      assertEquals(27, qualifierInfoVector0.size());
  }

  @Test(timeout = 4000)
  public void test27()  throws Throwable  {
      boolean boolean0 = FileSystemHandling.appendStringToFile((EvoSuiteFile) null, "K[9~J");
      assertFalse(boolean0);
      
      boolean boolean1 = Options.isNoddyMode();
      assertFalse(boolean1 == boolean0);
      assertTrue(boolean1);
      
      Options options0 = Options.getOptions();
      assertNotNull(options0);
      assertEquals(216, options0.size());
      assertFalse(options0.isEmpty());
      assertFalse(options0.isUnixHost());
      
      boolean boolean2 = options0.getPropertyTruthValue("Aw6_v");
      assertFalse(boolean2 == boolean1);
      assertTrue(boolean2 == boolean0);
      assertFalse(boolean2);
      assertEquals(216, options0.size());
      assertFalse(options0.isEmpty());
      assertFalse(options0.isUnixHost());
  }

  @Test(timeout = 4000)
  public void test28()  throws Throwable  {
      Options options0 = Options.getOptions();
      //  // Unstable assertion: assertNotNull(options0);
      //  // Unstable assertion: assertEquals(215, options0.size());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      
      Options options1 = (Options)options0.clone();
      //  // Unstable assertion: assertTrue(options1.equals((Object)options0));
      //  // Unstable assertion: assertNotNull(options1);
      //  // Unstable assertion: assertNotSame(options0, options1);
      //  // Unstable assertion: assertNotSame(options1, options0);
      //  // Unstable assertion: assertEquals(215, options0.size());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertEquals(215, options1.size());
      //  // Unstable assertion: assertFalse(options1.isEmpty());
      //  // Unstable assertion: assertFalse(options1.isUnixHost());
      
      options0.setGeneticCode("colour_11");
      //  // Unstable assertion: assertFalse(options0.equals((Object)options1));
      //  // Unstable assertion: assertNotSame(options0, options1);
      //  // Unstable assertion: assertEquals(216, options0.size());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      
      StringVector stringVector0 = options0.getInvisibleQualifiers(false);
      //  // Unstable assertion: assertFalse(options0.equals((Object)options1));
      //  // Unstable assertion: assertNotNull(stringVector0);
      //  // Unstable assertion: assertNotSame(options0, options1);
      //  // Unstable assertion: assertEquals(216, options0.size());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertFalse(stringVector0.isEmpty());
      //  // Unstable assertion: assertEquals("[CHROMO_LINK, C_processing, C_processing_BigPi, C_processing_DGPI, COM_NAME, FEAT_NAME, LOCUS, PUB_LOCUS, PUB_COMMENT, REPEAT_TYPE, SNP, bicsw_file, blast_file, blast_score, blastn_file, blastp+go_file, blastp_file, blastx_file, cds_id, chloroplast, chromoplast, codon, comment_Cterm, comment_Nterm, created, cyanelle, end_phase, exception, exon_id, fasta_file, fasta_match, gene_id, go_from_interpro, hp_match, hth_file, interpro, map, mitochondrion, modified, number, obsolete_gene_name, pepstats_file, percent_id, pfam_match, prosite_match, pseudo, psu_domain, reserved_gene_name, query_id, sigcleave_file, score, smart_file, start_phase, tblastn_file, tblastx_file, temporary_systematic_id, transl_table, translation, type, usedin]", stringVector0.toString());
      //  // Unstable assertion: assertEquals(80, stringVector0.capacity());
      //  // Unstable assertion: assertEquals(60, stringVector0.size());
      
      // Undeclared exception!
      try { 
        options0.getIntegerProperty("colour_11");
       //  fail("Expecting exception: NumberFormatException");
       // Unstable assertion
      } catch(NumberFormatException e) {
         //
         // For input string: \"200 150 100\"
         //
         verifyException("java.lang.NumberFormatException", e);
      }
  }

  @Test(timeout = 4000)
  public void test29()  throws Throwable  {
      Options options0 = new Options();
      //  // Unstable assertion: assertNotNull(options0);
      //  // Unstable assertion: assertEquals(216, options0.size());
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      
      StringVector stringVector0 = options0.getSystematicQualifierNames();
      //  // Unstable assertion: assertNotNull(stringVector0);
      //  // Unstable assertion: assertEquals(216, options0.size());
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      //  // Unstable assertion: assertFalse(stringVector0.isEmpty());
      //  // Unstable assertion: assertEquals("[systematic_id, temporary_systematic_id, locus_tag, gene, label, ID, Name]", stringVector0.toString());
      //  // Unstable assertion: assertEquals(10, stringVector0.capacity());
      //  // Unstable assertion: assertEquals(7, stringVector0.size());
      
      options0.setSystematicQualifierNames("}N%<*\"v}BiU%");
      //  // Unstable assertion: assertEquals(216, options0.size());
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      
      options0.setDisplayNameQualifiers(",^fC/={KbV[");
      //  // Unstable assertion: assertEquals(216, options0.size());
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
  }

  @Test(timeout = 4000)
  public void test30()  throws Throwable  {
      Options options0 = Options.getOptions();
      //  // Unstable assertion: assertNotNull(options0);
      //  // Unstable assertion: assertEquals(215, options0.size());
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      
      String string0 = options0.getDefaultFeatureFileName();
      //  // Unstable assertion: assertNull(string0);
      //  // Unstable assertion: assertEquals(215, options0.size());
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      
      String string1 = options0.getDefaultSequenceFileName();
      //  // Unstable assertion: assertNull(string1);
      //  // Unstable assertion: assertEquals(215, options0.size());
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
  }

  @Test(timeout = 4000)
  public void test31()  throws Throwable  {
      Options options0 = Options.getOptions();
      //  // Unstable assertion: assertNotNull(options0);
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      //  // Unstable assertion: assertEquals(215, options0.size());
      
      StringVector stringVector0 = options0.getInvisibleQualifiers(true);
      //  // Unstable assertion: assertNotNull(stringVector0);
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      //  // Unstable assertion: assertEquals(215, options0.size());
      //  // Unstable assertion: assertEquals(320, stringVector0.capacity());
      //  // Unstable assertion: assertEquals(163, stringVector0.size());
      //  // Unstable assertion: assertFalse(stringVector0.isEmpty());
      
      boolean boolean0 = options0.highlightActiveEntryFlag();
      //  // Unstable assertion: assertFalse(boolean0);
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      //  // Unstable assertion: assertEquals(215, options0.size());
      
      StringVector stringVector1 = Options.getPropertyValues(options0, java.lang.System.getProperty("user.home") + "/.artemis/cache/");
      //  // Unstable assertion: assertNull(stringVector1);
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      //  // Unstable assertion: assertEquals(215, options0.size());
      
      boolean boolean1 = options0.canDirectEdit();
      //  // Unstable assertion: assertFalse(boolean1 == boolean0);
      //  // Unstable assertion: assertTrue(boolean1);
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      //  // Unstable assertion: assertEquals(215, options0.size());
      
      ExternalProgramVector externalProgramVector0 = options0.getNCBIPrograms();
      //  // Unstable assertion: assertNotNull(externalProgramVector0);
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      //  // Unstable assertion: assertEquals(215, options0.size());
      //  // Unstable assertion: assertEquals(5, externalProgramVector0.size());
      
      boolean boolean2 = Options.isBlackBeltMode();
      //  // Unstable assertion: assertTrue(boolean2 == boolean0);
      //  // Unstable assertion: assertFalse(boolean2 == boolean1);
      //  // Unstable assertion: assertFalse(boolean2);
  }

  @Test(timeout = 4000)
  public void test32()  throws Throwable  {
      Options options0 = new Options();
      //  // Unstable assertion: assertNotNull(options0);
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertEquals(216, options0.size());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      
      boolean boolean0 = options0.highlightActiveEntryFlag();
      //  // Unstable assertion: assertFalse(boolean0);
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertEquals(216, options0.size());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      
      options0.setEukaryoticMode(true);
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertEquals(216, options0.size());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      
      boolean boolean1 = Options.readWritePossible();
      //  // Unstable assertion: assertFalse(boolean1 == boolean0);
      //  // Unstable assertion: assertTrue(boolean1);
      
      Color color0 = options0.getColorFromColourNumber(1084);
      //  // Unstable assertion: assertNull(color0);
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertEquals(216, options0.size());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      
      options0.setHighlightActiveEntryFlag(true);
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertEquals(217, options0.size());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      
      boolean boolean2 = Options.isBlackBeltMode();
      //  // Unstable assertion: assertFalse(boolean2 == boolean1);
      //  // Unstable assertion: assertTrue(boolean2 == boolean0);
      //  // Unstable assertion: assertFalse(boolean2);
  }

  @Test(timeout = 4000)
  public void test33()  throws Throwable  {
      Options options0 = new Options();
      //  // Unstable assertion: assertNotNull(options0);
      //  // Unstable assertion: assertEquals(216, options0.size());
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      
      DatabaseDocument.CHADO_INFER_CDS = false;
      QualifierInfoVector qualifierInfoVector0 = options0.getExtraQualifiers();
      //  // Unstable assertion: assertNotNull(qualifierInfoVector0);
      //  // Unstable assertion: assertEquals(216, options0.size());
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      //  // Unstable assertion: assertEquals(128, qualifierInfoVector0.size());
      
      StringVector stringVector0 = options0.getSystematicQualifierNames();
      //  // Unstable assertion: assertNotNull(stringVector0);
      //  // Unstable assertion: assertEquals(216, options0.size());
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      //  // Unstable assertion: assertEquals(7, stringVector0.size());
      //  // Unstable assertion: assertEquals("[systematic_id, temporary_systematic_id, locus_tag, gene, label, ID, Name]", stringVector0.toString());
      //  // Unstable assertion: assertFalse(stringVector0.isEmpty());
      //  // Unstable assertion: assertEquals(10, stringVector0.capacity());
      
      Key key0 = Key.CDS;
      //  // Unstable assertion: assertNotNull(key0);
      //  // Unstable assertion: assertEquals("CDS", key0.toString());
      //  // Unstable assertion: assertEquals("CDS", key0.getKeyString());
      //  // Unstable assertion: assertEquals(3, key0.length());
      
      Color color0 = options0.getDefaultFeatureColour(key0);
      //  // Unstable assertion: assertNotNull(color0);
      //  // Unstable assertion: assertEquals(216, options0.size());
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      //  // Unstable assertion: assertEquals("CDS", key0.toString());
      //  // Unstable assertion: assertEquals("CDS", key0.getKeyString());
      //  // Unstable assertion: assertEquals(3, key0.length());
      //  // Unstable assertion: assertEquals(255, color0.getGreen());
      //  // Unstable assertion: assertEquals(255, color0.getAlpha());
      //  // Unstable assertion: assertEquals(1, color0.getTransparency());
      //  // Unstable assertion: assertEquals((-16711681), color0.getRGB());
      //  // Unstable assertion: assertEquals(0, color0.getRed());
      //  // Unstable assertion: assertEquals(255, color0.getBlue());
      
      options0.setEukaryoticMode(false);
      //  // Unstable assertion: assertEquals(217, options0.size());
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
  }

  @Test(timeout = 4000)
  public void test34()  throws Throwable  {
      Options options0 = Options.getOptions();
      //  // Unstable assertion: assertNotNull(options0);
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      //  // Unstable assertion: assertEquals(215, options0.size());
      
      FontUIResource fontUIResource0 = options0.getFontUIResource();
      //  // Unstable assertion: assertNotNull(fontUIResource0);
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      //  // Unstable assertion: assertEquals(215, options0.size());
      //  // Unstable assertion: assertFalse(fontUIResource0.isTransformed());
      //  // Unstable assertion: assertEquals("Monospaced", fontUIResource0.getName());
      //  // Unstable assertion: assertFalse(fontUIResource0.hasLayoutAttributes());
      //  // Unstable assertion: assertEquals(12, fontUIResource0.getSize());
      //  // Unstable assertion: assertEquals(0, fontUIResource0.getStyle());
      //  // Unstable assertion: assertTrue(fontUIResource0.isPlain());
      //  // Unstable assertion: assertFalse(fontUIResource0.isItalic());
      //  // Unstable assertion: assertEquals(12.0F, fontUIResource0.getSize2D(), 0.01F);
      //  // Unstable assertion: assertFalse(fontUIResource0.isBold());
      //  // Unstable assertion: assertFalse(fontUIResource0.hasUniformLineMetrics());
      
      // Undeclared exception!
      try { 
        options0.remove((Object) null);
       //  fail("Expecting exception: NullPointerException");
       // Unstable assertion
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.util.Hashtable", e);
      }
  }

  @Test(timeout = 4000)
  public void test35()  throws Throwable  {
      boolean boolean0 = Options.readWritePossible();
      //  // Unstable assertion: assertTrue(boolean0);
      
      boolean boolean1 = Options.readWritePossible();
      //  // Unstable assertion: assertTrue(boolean1 == boolean0);
      //  // Unstable assertion: assertTrue(boolean1);
      
      boolean boolean2 = FileSystemHandling.appendStringToFile((EvoSuiteFile) null, (String) null);
      //  // Unstable assertion: assertFalse(boolean2 == boolean0);
      //  // Unstable assertion: assertFalse(boolean2 == boolean1);
      //  // Unstable assertion: assertFalse(boolean2);
      
      Options options0 = new Options();
      //  // Unstable assertion: assertNotNull(options0);
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertEquals(216, options0.size());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      
      ExternalProgramVector externalProgramVector0 = options0.getExternalPrograms();
      //  // Unstable assertion: assertNotNull(externalProgramVector0);
      //  // Unstable assertion: assertFalse(options0.isEmpty());
      //  // Unstable assertion: assertEquals(216, options0.size());
      //  // Unstable assertion: assertFalse(options0.isUnixHost());
      //  // Unstable assertion: assertEquals(28, externalProgramVector0.size());
  }

  @Test(timeout = 4000)
  public void test36()  throws Throwable  {
      Options options0 = new Options();
      options0.setSystematicQualifierNames("?os+nM]n#7'WM24r");
      options0.reset();
      FileSystemHandling.appendStringToFile((EvoSuiteFile) null, "kH/(x-v");
      options0.getIntegerProperty("Token `");
      options0.getSystematicQualifierNames();
      options0.getExternalPrograms();
      options0.getDefaultFeatureFileName();
      Options.readWritePossible();
      options0.getAllGeneNames();
      FileSystemHandling.createFolder((EvoSuiteFile) null);
      // Undeclared exception!
      try { 
        Options.getPropertyValues(options0, (String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test37()  throws Throwable  {
      Options options0 = Options.getOptions();
      options0.getColorFromColourNumber(123);
      options0.setHighlightActiveEntryFlag(false);
      FileSystemHandling.appendStringToFile((EvoSuiteFile) null, "Y/rk&m0=B7-Q}F@@S");
      Options.getPropertyValues(options0, "J-'yi+^&bc=j=Tm%o*");
      options0.getSystematicQualifierNames();
      StringVector stringVector0 = options0.getSystematicQualifierNames();
      //  // Unstable assertion: assertEquals(215, options0.size());
      //  // Unstable assertion: assertEquals("[systematic_id, temporary_systematic_id, locus_tag, gene, label, ID, Name]", stringVector0.toString());
  }

  @Test(timeout = 4000)
  public void test38()  throws Throwable  {
      FileSystemHandling.appendStringToFile((EvoSuiteFile) null, "Um~>#");
      FileSystemHandling.shouldThrowIOException((EvoSuiteFile) null);
      Options options0 = new Options();
      // Undeclared exception!
      try { 
        options0.replaceAll((BiFunction<? super Object, ? super Object, ?>) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.util.Objects", e);
      }
  }

  @Test(timeout = 4000)
  public void test39()  throws Throwable  {
      Options options0 = new Options();
      options0.setDefaultColourMap();
      options0.getExternalPrograms();
      options0.highlightActiveEntryFlag();
      FileList fileList0 = null;
      try {
        fileList0 = new FileList();
        fail("Expecting exception: HeadlessException");
      
      } catch(HeadlessException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.awt.GraphicsEnvironment", e);
      }
  }

  @Test(timeout = 4000)
  public void test40()  throws Throwable  {
      Options.isUnixHost();
      Options options0 = Options.getOptions();
      options0.getUndoLevels();
      FileSystemHandling.createFolder((EvoSuiteFile) null);
      options0.getExtraQualifiers();
      options0.isEukaryoticMode();
      String string0 = "vxF-Yb+";
      Splash.appendToLog("vxF-Yb+");
      FileSystemHandling.shouldAllThrowIOExceptions();
      options0.getStartCodons();
      options0.getStartCodons();
      MockFileOutputStream mockFileOutputStream0 = new MockFileOutputStream("vxF-Yb+");
      mockFileOutputStream0.release();
      mockFileOutputStream0.flush();
      try { 
        mockFileOutputStream0.close();
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // Simulated IOException
         //
         verifyException("org.evosuite.runtime.vfs.VirtualFileSystem", e);
      }
  }

  @Test(timeout = 4000)
  public void test41()  throws Throwable  {
      Options options0 = Options.getOptions();
      options0.getIntegerProperty("aD{6t]I%HsxAMt'm4b");
      MockFile mockFile0 = new MockFile("aD{6t]I%HsxAMt'm4b");
      URL uRL0 = mockFile0.toURL();
      URL uRL1 = MockURL.URL(uRL0, "no");
      org.apache.log4j.Logger logger0 = org.apache.log4j.Logger.getLogger(java.lang.System.getProperty("user.dir") + "/.artemis/cache/");
      LoggerRepository loggerRepository0 = logger0.getLoggerRepository();
      OptionConverter.selectAndConfigure(uRL1, "yes", loggerRepository0);
      options0.getExtraQualifiers();
      options0.setDirectEdit(true);
      Options options1 = Options.getOptions();
      options0.getSystematicQualifierNames();
      options1.getNCBIPrograms();
      Key key0 = Key.CDS;
      FileSystemHandling.shouldAllThrowIOExceptions();
      options1.getDefaultFeatureColour(key0);
      Options.getPropertyValues(options1, "aD{6t]I%HsxAMt'm4b");
      //  // Unstable assertion: assertEquals(215, options1.size());
      
      options0.setGeneticCode("aD{6t]I%HsxAMt'm4b");
      Options.isBlackBeltMode();
      options0.getIntegerProperty("no");
      //  // Unstable assertion: assertEquals(216, options0.size());
      
      options1.getAllGeneNames();
      //  // Unstable assertion: assertEquals(216, options1.size());
  }

  @Test(timeout = 4000)
  public void test42()  throws Throwable  {
      Options options0 = new Options();
      Properties properties0 = new Properties(options0);
      Options.getPropertyValues(properties0, "]HU2Vw<+;ytoj-");
      assertEquals(215, options0.size());
  }
}
