#ifndef RESOURCE_HPP
#define RESOURCE_HPP

#include "cosmic_protector.hpp"

const int RES_DISPLAY = 0;
const int RES_PLAYER = 1;
const int RES_INPUT = 2;
const int RES_LARGEFONT = 3;
const int RES_SMALLFONT = 4;

const int RES_BITMAP_START = 5;
const int RES_LARGEASTEROID = RES_BITMAP_START+0;
const int RES_SMALLASTEROID = RES_BITMAP_START+1;
const int RES_BACKGROUND = RES_BITMAP_START+2;
const int RES_SMALLBULLET = RES_BITMAP_START+3;
const int RES_LARGEEXPLOSION0 = RES_BITMAP_START+4;
const int RES_LARGEEXPLOSION1 = RES_BITMAP_START+5;
const int RES_LARGEEXPLOSION2 = RES_BITMAP_START+6;
const int RES_LARGEEXPLOSION3 = RES_BITMAP_START+7;
const int RES_LARGEEXPLOSION4 = RES_BITMAP_START+8;
const int RES_SMALLEXPLOSION0 = RES_BITMAP_START+9;
const int RES_SMALLEXPLOSION1 = RES_BITMAP_START+10;
const int RES_SMALLEXPLOSION2 = RES_BITMAP_START+11;
const int RES_SMALLEXPLOSION3 = RES_BITMAP_START+12;
const int RES_SMALLEXPLOSION4 = RES_BITMAP_START+13;
const int RES_MEDIUMASTEROID = RES_BITMAP_START+14;
const int RES_LARGEBULLET = RES_BITMAP_START+15;
const int RES_WEAPONPOWERUP = RES_BITMAP_START+16;
const int RES_LIFEPOWERUP = RES_BITMAP_START+17;
const int RES_UFO0 = RES_BITMAP_START+18;
const int RES_UFO1 = RES_BITMAP_START+19;
const int RES_UFO2 = RES_BITMAP_START+20;
const int RES_LOGO = RES_BITMAP_START+21;

const int RES_SAMPLE_START = RES_BITMAP_START+22;
const int RES_BIGEXPLOSION = RES_SAMPLE_START+0;
const int RES_COLLISION = RES_SAMPLE_START+1;
const int RES_FIRELARGE = RES_SAMPLE_START+2;
const int RES_FIRESMALL = RES_SAMPLE_START+3;
const int RES_SMALLEXPLOSION = RES_SAMPLE_START+4;
const int RES_POWERUP = RES_SAMPLE_START+5;
const int RES_SAMPLE_END = RES_POWERUP+1;

const int RES_STREAM_START = RES_SAMPLE_START+6;
const int RES_TITLE_MUSIC = RES_STREAM_START+0;
const int RES_GAME_MUSIC = RES_STREAM_START+1;
const int RES_STREAM_END = RES_GAME_MUSIC+1;

extern const char* BMP_NAMES[];
extern const char* SAMPLE_NAMES[];
extern const char* STREAM_NAMES[];

class Resource {
public:
   virtual void destroy(void) = 0;
   virtual bool load(void) = 0;
   virtual void* get(void) = 0;

   virtual ~Resource() {};
};

#endif // RESOURCE_HPP

