(in-package "RTL")

(local (include-book "arithmetic-5/top" :dir :system))
(include-book "util")
(local (include-book "basic"))
(include-book "float")
(include-book "round")

;; The following lemmas from arithmetic-5 have given me trouble:
#|
(local (in-theory #!acl2(disable |(mod (+ x y) z) where (<= 0 z)| |(mod (+ x (- (mod a b))) y)| |(mod (mod x y) z)| |(mod (+ x (mod a b)) y)|
                    simplify-products-gather-exponents-equal mod-cancel-*-const cancel-mod-+ reduce-additive-constant-<
                    |(floor x 2)| |(equal x (if a b c))| |(equal (if a b c) x)|)))
|#

(local-defthmd near-down-1
  (implies (and (integerp n) (integerp m))
           (= (expt 2 (+ 1 m n)) (* 2 (expt 2 (+ m n))))))

(local-defthm r-exactp-1
  (implies (and (rationalp a)
                (rationalp r)
                (<= 1 a)
                (< a 2)
                (<= r 1)
                (< 1/2 r))
           (and (<= r (* a r))
                (<= (* a r) a)))
  :rule-classes ())

(local-defthm r-exactp-2
  (implies (and (rationalp a)
                (rationalp r)
                (<= 1 a)
                (< a 2)
                (<= r 1)
                (< 1/2 r))
           (and (< 1/2 (* a r))
                (< (* a r) 2)))
  :rule-classes ()
  :hints (("Goal" :use (r-exactp-1)
                  :in-theory
                  #!acl2
                  (disable |(* 1 x)| |(* a (/ a) b)| |(* a (/ a))| |(* y (* x z))| |(* y x)|
                           |(< (/ x) y) with (< 0 x)| |(< x (/ y)) with (< 0 y)|
                           REMOVE-STRICT-INEQUALITIES REMOVE-WEAK-INEQUALITIES
                           SIMPLIFY-PRODUCTS-GATHER-EXPONENTS-<))))

(defthm r-exactp-3
  (implies (and (rationalp a)
                (rationalp b)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2))
           (and (< 1/2 (/ a b))
                (< (/ a b) 2)))
  :rule-classes ()
  :hints (("Goal" :use ((:instance r-exactp-2 (r (/ b)))))))

(defthm r-exactp-4
  (implies (and (rationalp a)
                (rationalp b)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2))
           (member (expo (/ a b)) '(-1 0)))
  :rule-classes ()
  :hints (("Goal" :use (r-exactp-3
                        (:instance expo>= (x (/ a b)) (n -1))
                        (:instance expo<= (x (/ a b)) (n 0))))))

(defthm r-exactp-5
  (implies (and (rationalp a)
                (rationalp b)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (>= a b))
           (equal (expo (/ a b)) 0))
  :rule-classes ()
  :hints (("Goal" :use (r-exactp-3
                        (:instance expo>= (x (/ a b)) (n 0))
                        (:instance expo<= (x (/ a b)) (n 0))))))

(local-defun m (a p) (* (expt 2 (1- p)) (- a 1)))

(defthm r-exactp-6
  (implies (and (rationalp a)
                (<= 1 a)
                (< a 2))
           (equal (expo a) 0))
  :hints (("Goal" :use ((:instance expo>= (x a) (n 0))
                        (:instance expo<= (x a) (n 0))))))

(local-defthm r-exactp-7
  (implies (and (rationalp a)
                (<= 1 a)
                (< a 2)
                (not (zp p))
                (exactp a p))
           (and (integerp (m a p))
                (>= (m a p) 0)
                (< (m a p) (expt 2 (1- p)))))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable exactp2))))

(local-defthm r-exactp-8
  (implies (and (rationalp a)
                (rationalp b)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (> a b))
           (> (m a p) (m b p)))
  :rule-classes ())

(local-defun md (a b p)
 (- (m a p) (m b p)))

(local-defthm r-exactp-9
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (> a b))
           (>= (md a b p) 1))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable m)
                  :use (r-exactp-8
                        r-exactp-7
                        (:instance r-exactp-7 (a b))))))

(local-defthm r-exactp-10
  (implies (and (rationalp a)
                (rationalp b)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (> a b))
           (equal (* a (/ b))
                  (1+ (/ (* (expt 2 (- 1 p)) (md a b p))
                         (1+ (* (expt 2 (- 1 p)) (m b p))))))))

(local-defthm r-exactp-11
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (> a b))
           (>= (1- (/ a b))
               (/ (expt 2 (- 1 p))
                      (1+ (* (expt 2 (- 1 p)) (m b p))))))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable m md)
                  :use (r-exactp-7
                        r-exactp-9
                        (:instance r-exactp-7 (a b))))))

(local-in-theory (disable r-exactp-10))

(local-defthm r-exactp-12
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (> a b))
           (>= (1- (/ a b))
               (/ (expt 2 (- 1 p)) b)))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable md)
                  :use (r-exactp-11))))

(local-defthm r-exactp-13
  (implies (and (not (zp p))
                (rationalp b)
                (<= 1 b)
                (< b 2)
                (> a b))
           (> (/ (expt 2 (- 1 p)) b)
              (expt 2 (- p))))
  :rule-classes ())

(local-defthm r-exactp-14
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (> a b))
           (> (1- (/ a b))
              (expt 2 (- p))))
  :rule-classes ()
  :hints (("Goal" :use (r-exactp-12 r-exactp-13)
                  :in-theory (theory 'minimal-theory))))

(local-defthm r-exactp-15
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (> a b))
           (> (/ a b)
              (1+ (expt 2 (- p)))))
  :rule-classes ()
  :hints (("Goal" :use (r-exactp-14))))

(local-defthm r-exactp-16
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (> a b)
                (rationalp q)
                (exactp q p)
                (< (abs (- (/ a b) q)) (expt 2 (- 1 p))))
           (> q (- (1+ (expt 2 (- p))) (expt 2 (- 1 p)))))
  :rule-classes ()
  :hints (("Goal" :use (r-exactp-15))))

(local-defthmd r-exactp-17
  (implies (not (zp p))
           (equal (expt 2 (+ 1 (- p)))
                  (* 2 (expt 2 (- p))))))

(local-defthm r-exactp-18
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (> a b)
                (rationalp q)
                (exactp q p)
                (< (abs (- (/ a b) q)) (expt 2 (- 1 p))))
           (> q (- 1 (expt 2 (- p)))))
  :rule-classes ()
  :hints (("Goal" :in-theory (e/d (r-exactp-17) (acl2::normalize-factors-gather-exponents))
                  :use (r-exactp-16))))

(local-defthm r-exactp-19
   (implies (not (zp p))
            (equal (expo (- 1 (expt 2 (- p)))) -1))
  :rule-classes ()
  :hints (("Goal" :use ((:instance expo>= (x (- 1 (expt 2 (- p)))) (n -1))
                        (:instance expo<= (x (- 1 (expt 2 (- p)))) (n -1))))))

(local-defthm r-exactp-20
   (implies (not (zp p))
            (exactp (- 1 (expt 2 (- p))) p))
  :rule-classes ()
  :hints (("Goal" :use (r-exactp-19)
                  :in-theory (enable exactp2))))

(local-defthm r-exactp-21
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (> a b)
                (rationalp q)
                (exactp q p)
                (< (abs (- (/ a b) q)) (expt 2 (- 1 p))))
           (>= q 1))
  :rule-classes ()
  :hints (("Goal" :use (r-exactp-18
                        r-exactp-19
                        r-exactp-20
                        (:instance fp+2 (x (- 1 (expt 2 (- p)))) (y q) (n p))))))

(local-defthm r-exactp-22
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (> a b)
                (rationalp q)
                (exactp q p)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (>= (expo q) (expo (/ a b))))
  :rule-classes ()
  :hints (("Goal" :use (r-exactp-21
                        r-exactp-5
                        (:instance expo>= (x q) (n 0))))))

(local-defthm r-exactp-23
   (implies (not (zp p))
            (equal (expo (- 2 (expt 2 (- 1 p)))) 0))
  :rule-classes ()
  :hints (("Goal" :use ((:instance expo>= (x (- 2 (expt 2 (- 1 p)))) (n 0))
                        (:instance expo<= (x (- 2 (expt 2 (- 1 p)))) (n 0))))))

(local-defthm r-exactp-24
   (implies (not (zp p))
            (exactp (- 2 (expt 2 (- 1 p))) p))
  :rule-classes ()
  :hints (("Goal" :use (r-exactp-23)
                  :in-theory (enable exactp2))))

(local-defthm r-exactp-25
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2))
           (<= b (- 2 (expt 2 (- 1 p)))))
  :rule-classes ()
  :hints (("Goal" :use (r-exactp-23
                        r-exactp-24
                        (:instance fp+2 (x (- 2 (expt 2 (- 1 p)))) (y b) (n p))))))

(local-defthm r-exactp-26
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (< a b))
           (>= (/ b) (/ (- 2 (expt 2 (- 1 p))))))
  :rule-classes ()
  :hints (("Goal" :use (r-exactp-25))))

(local-defthm r-exactp-27
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (< a b))
           (>= (/ a b) (/ b)))
  :rule-classes ())

(local-defthm r-exactp-28
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (< a b))
           (>= (/ a b) (/ (- 2 (expt 2 (- 1 p))))))
  :rule-classes ()
  :hints (("Goal" :use (r-exactp-26 r-exactp-27)
                  :in-theory (theory 'minimal-theory))))

(local-defthm r-exactp-29
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (< a b))
           (>= (/ a b)
               (+ (/ (- 1 (expt 2 (- p))) (- 2 (expt 2 (- 1 p))))
                  (/ (expt 2 (- p)) (- 2 (expt 2 (- 1 p)))))))
  :rule-classes ()
  :hints (("Goal" :use (r-exactp-28))))

(local-defthm r-exactp-30
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (< a b))
           (and (rationalp (- 1 (expt 2 (- p))))
                (not (zerop (- 1 (expt 2 (- p)))))
                (= (* 2 (- 1 (expt 2 (- p))))
                   (- 2 (expt 2 (- 1 p))))))
  :rule-classes ())

(local-defthm r-exactp-31
  (implies (and (rationalp x)
                (not (zerop x)))
           (= 1/2 (/ x (* 2 x))))
  :rule-classes ())

(local-defthm r-exactp-32
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (< a b))
           (= 1/2 (/ (- 1 (expt 2 (- p))) (- 2 (expt 2 (- 1 p))))))
  :rule-classes ()
  :hints (("Goal" :use (r-exactp-30
                        (:instance r-exactp-31 (x (- 1 (expt 2 (- p))))))
                  :in-theory (theory 'minimal-theory))))

(local-defthm r-exactp-33
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (< a b))
           (>= (/ a b)
               (+ 1/2
                  (/ (expt 2 (- p)) (- 2 (expt 2 (- 1 p)))))))
  :rule-classes ()
  :hints (("Goal" :use (r-exactp-29 r-exactp-32)
                  :in-theory (theory 'minimal-theory))))

(local-defthm r-exactp-34
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (< a b))
           (and (rationalp (/ (- 2 (expt 2 (- 1 p)))))
                (rationalp (expt 2 (- p)))
                (> (expt 2 (- p)) 0)
                (> (/ (- 2 (expt 2 (- 1 p)))) 1/2)))
  :rule-classes ())

(local-defthm r-exactp-35
  (implies (and (rationalp x)
                (rationalp y)
                (> x 0)
                (> y 1/2))
           (> (* x y) (* 1/2 x)))
  :rule-classes ())

(local-defthm r-exactp-36
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (< a b))
           (> (*  (expt 2 (- p)) (/ (- 2 (expt 2 (- 1 p)))))
              (* 1/2 (expt 2 (- p)))))
  :rule-classes ()
  :hints (("Goal" :use (r-exactp-34
                        (:instance r-exactp-35 (x (expt 2 (- p))) (y (/ (- 2 (expt 2 (- 1 p)))))))
                  :in-theory (theory 'minimal-theory))))

(local-defthm r-exactp-37
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (< a b))
           (> (*  (expt 2 (- p)) (/ (- 2 (expt 2 (- 1 p)))))
              (expt 2 (- (1+ p)))))
  :rule-classes ()
  :hints (("Goal" :use (r-exactp-36))))

(local-defthm r-exactp-38
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (< a b))
           (> (/ a b) (+ 1/2 (expt 2 (- (1+ p))))))
  :rule-classes ()
  :hints (("Goal" :use (r-exactp-33 r-exactp-37)
                  :in-theory (theory 'minimal-theory))))

(defthm r-exactp-39
  (implies (and (rationalp a)
                (rationalp b)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (< a b))
           (equal (expo (/ a b)) -1))
  :rule-classes ()
  :hints (("Goal" :use (r-exactp-3
                        (:instance expo>= (x (/ a b)) (n -1))
                        (:instance expo<= (x (/ a b)) (n -1))))))

(local-defthm r-exactp-40
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (< a b)
                (rationalp q)
                (exactp q p)
                (< (abs (- (/ a b) q)) (expt 2 (- p))))
           (> q (- (+ 1/2 (expt 2 (- (1+ p)))) (expt 2 (- p)))))
  :rule-classes ()
  :hints (("Goal" :use (r-exactp-38))))

(local-defthmd r-exactp-41
  (implies (not (zp p))
           (equal (expt 2 (- p))
                  (* 2 (expt 2 (- (1+ p)))))))

(local-defthm r-exactp-42
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (< a b)
                (rationalp q)
                (exactp q p)
                (< (abs (- (/ a b) q)) (expt 2 (- p))))
           (> q (- 1/2 (expt 2 (- (1+ p))))))
  :rule-classes ()
  :hints (("Goal" :in-theory (e/d (r-exactp-41) (acl2::normalize-factors-gather-exponents))
                  :use (r-exactp-40))))

(local-defthm r-exactp-43
   (implies (not (zp p))
            (equal (expo (- 1/2 (expt 2 (- (1+ p))))) -2))
  :rule-classes ()
  :hints (("Goal" :use ((:instance expo>= (x (- 1/2 (expt 2 (- (1+ p))))) (n -2))
                        (:instance expo<= (x (- 1/2 (expt 2 (- (1+ p))))) (n -2))))))

(local-defthm r-exactp-44
   (implies (not (zp p))
            (exactp (- 1/2 (expt 2 (- (1+ p)))) p))
  :rule-classes ()
  :hints (("Goal" :use (r-exactp-43)
                  :in-theory (enable exactp2))))

(local-defthm r-exactp-45
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (< a b)
                (rationalp q)
                (exactp q p)
                (< (abs (- (/ a b) q)) (expt 2 (- p))))
           (>= q 1/2))
  :rule-classes ()
  :hints (("Goal" :use (r-exactp-42
                        r-exactp-43
                        r-exactp-44
                        (:instance fp+2 (x (- 1/2 (expt 2 (- (1+ p))))) (y q) (n p))))))

(local-defthm r-exactp-46
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (< a b)
                (rationalp q)
                (exactp q p)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (>= (expo q) (expo (/ a b))))
  :rule-classes ()
  :hints (("Goal" :use (r-exactp-45
                        r-exactp-39
                        (:instance expo>= (x q) (n -1))))))

(local-defthm r-exactp-47
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (rationalp q)
                (exactp q p)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p)))
                (< (expo q) (expo (/ a b))))
           (and (= a b)
                (= (expo (/ a b)) 0)
                (< q 1)))
  :rule-classes ()
  :hints (("Goal" :use (r-exactp-46
                        r-exactp-22
                        r-exactp-5
                        (:instance expo>= (x q) (n 0))))))

(local-defthm r-exactp-48
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (rationalp q)
                (exactp q p)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p)))
                (< (expo q) (expo (/ a b))))
           (> q (- 1 (expt 2 (- 1 p)))))
  :rule-classes ()
  :hints (("Goal" :use (r-exactp-47))))

(local-defthm r-exactp-49
   (implies (and (integerp p)
                 (> p 1))
            (equal (expo (- 1 (expt 2 (- 1 p)))) -1))
  :rule-classes ()
  :hints (("Goal" :use ((:instance expo>= (x (- 1 (expt 2 (- 1 p)))) (n -1))
                        (:instance expo<= (x (- 1 (expt 2 (- 1 p)))) (n -1))))))

(local-defthm r-exactp-50
   (implies (and (integerp p)
                 (> p 1))
            (exactp (- 1 (expt 2 (- 1 p))) p))
  :rule-classes ()
  :hints (("Goal" :use (r-exactp-49)
                  :in-theory (enable exactp2))))

(local-defthmd r-exactp-51
  (implies (integerp p)
           (equal (expt 2 (+ 1 (- p)))
                  (* 2 (expt 2 (- p)))))
  :hints (("Goal" :use ((:instance expt (r 2) (i (- p)))
                        (:instance expt (r 2) (i (- 1 p)))))))

(local-defthm r-exactp-52
  (implies (and (rationalp a)
                (rationalp b)
                (integerp p)
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (rationalp q)
                (exactp q p)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p)))
                (< (expo q) (expo (/ a b))))
           (>= q (- 1 (expt 2 (- p)))))
  :rule-classes ()
  :hints (("Goal" :in-theory (e/d (r-exactp-51) (acl2::normalize-factors-gather-exponents))
                  :use (r-exactp-48 r-exactp-49 r-exactp-50
                        (:instance fp+2 (x (- 1 (expt 2 (- 1 p)))) (y q) (n p))))))

(local-defthm r-exactp-53
  (implies (and (rationalp a)
                (rationalp b)
                (integerp p)
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (rationalp q)
                (exactp q p)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p)))
                (< (expo q) (expo (/ a b))))
           (= q (- 1 (expt 2 (- p)))))
  :rule-classes ()
  :hints (("Goal" :use (r-exactp-47 r-exactp-52 r-exactp-19 r-exactp-20
                        (:instance fp+2 (x (- 1 (expt 2 (- p)))) (y q) (n p))))))

(local-defthm r-exactp-54
  (implies (and (rationalp a)
                (rationalp b)
                (integerp p)
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (rationalp q)
                (exactp q p)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p)))
                (< (expo q) (expo (/ a b))))
           (exactp (- a (* b (- 1 (expt 2 (- p))))) p))
  :rule-classes ()
  :hints (("Goal" :use (r-exactp-47
                        (:instance exactp-shift (k (- p)) (x a) (n p))))))

(local-defthm r-exactp-55
  (implies (and (rationalp a)
                (rationalp b)
                (integerp p)
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (rationalp q)
                (exactp q p)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p)))
                (< (expo q) (expo (/ a b))))
           (exactp (- a (* b q)) p))
  :rule-classes ()
  :hints (("Goal" :use (r-exactp-54 r-exactp-53)
                  :in-theory (theory 'minimal-theory))))

(local-defthm r-exactp-56
  (implies (and (rationalp x)
                (>= x 0)
                (rationalp y)
                (rationalp b)
                (<= 1 b)
                (< b 2)
                (< x y))
           (and (< (* b x) (* b y))
                (< (* b y) (* 2 y))))
  :rule-classes ())

(local-defthm r-exactp-57
  (implies (and (rationalp x)
                (>= x 0)
                (rationalp y)
                (rationalp b)
                (<= 1 b)
                (< b 2)
                (< x y))
           (< (* b x) (* 2 y)))
  :rule-classes ()
  :hints (("Goal" :use (r-exactp-56)
                  :in-theory (theory 'minimal-theory))))

(local-defthm r-exactp-58
  (implies (and (rationalp x)
                (rationalp b)
                (integerp n)
                (<= 1 b)
                (< b 2)
                (< (abs x) (expt 2 n)))
           (< (abs (* b x)) (expt 2 (1+ n))))
  :rule-classes ()
  :hints (("Goal" :use ((:instance r-exactp-57 (x (abs x)) (y (expt 2 n)))
                        (:instance expt (r 2) (i n))
                        (:instance expt (r 2) (i (1+ n)))))))

(local-defthm r-exactp-59
  (implies (and (rationalp a)
                (rationalp b)
                (integerp p)
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (rationalp q)
                (exactp q p)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p)))
                (>= (expo q) (expo (/ a b))))
           (< (abs (- a (* b q)))
              (expt 2 (- (+ 2 (expo (/ a b))) p))))
  :rule-classes ()
  :hints (("Goal" :use ((:instance r-exactp-58 (x (- (/ a b) q)) (n (- (1+ (expo (/ a b))) p)))))))

(local-defthm r-exactp-60
  (implies (and (rationalp a)
                (rationalp b)
                (integerp p)
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (rationalp q)
                (exactp q p)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p)))
                (>= (expo q) (expo (/ a b)))
                (not (= (- a (* b q)) 0)))
           (<= (expo (abs (- a (* b q))))
               (- (1+ (expo (/ a b))) p)))
  :rule-classes ()
  :hints (("Goal" :use (r-exactp-59
                        (:instance expo<= (x (abs (- a (* b q)))) (n (- (1+ (expo (/ a b))) p)))))))

(local-defthm r-exactp-61
  (implies (and (rationalp a)
                (rationalp b)
                (integerp p)
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (rationalp q)
                (exactp q p)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p)))
                (>= (expo q) (expo (/ a b)))
                (not (= (- a (* b q)) 0)))
           (<= (expo (- a (* b q)))
               (- (1+ (expo (/ a b))) p)))
  :rule-classes ()
  :hints (("Goal" :use (r-exactp-60)
                  :in-theory (enable expo))))

(local-defthm r-exactp-62
  (implies (and (integerp x)
                (integerp n)
                (>= n 0))
           (integerp (* x (expt 2 n))))
  :rule-classes ())

(local-defthm r-exactp-63
  (implies (and (rationalp x)
                (not (zp p))
                (integerp n)
                (>= n (expo x))
                (integerp (* (expt 2 (- p (1+ n))) x)))
           (exactp x p))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable exactp2)
                  :use ((:instance r-exactp-62 (x (* (expt 2 (- p (1+ n))) x))
                                               (n (- n (expo x))))))))

(local-defthm r-exactp-64
  (implies (integerp p)
           (exactp 0 p))
  :hints (("Goal" :in-theory (enable exactp2))))

(local-defthm r-exactp-65
  (implies (and (rationalp a)
                (rationalp b)
                (integerp p)
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (rationalp q)
                (exactp q p)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p)))
                (>= (expo q) (expo (/ a b)))
                (integerp (* (expt 2 (- (* 2 p) (+ 2 (expo (/ a b))))) a))
                (integerp (* (expt 2 (- (* 2 p) (+ 2 (expo (/ a b))))) b q)))
           (exactp (- a (* b q)) p))
  :rule-classes ()
  :hints (("Goal" :use (r-exactp-61
                        (:instance r-exactp-63 (x (- a (* b q))) (n (- (1+ (expo (/ a b))) p)))))))

(local-defthm r-exactp-66
  (implies (and (rationalp a)
                (rationalp b)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (<= (expo (/ a b)) 0)
                (not (zp p))
                (exactp a p))
           (integerp (* (expt 2 (- (* 2 p) (+ (expo (/ a b)) 2))) a)))
  :hints (("Goal" :in-theory (enable exactp2)
                  :use (;r-exactp-4
                        (:instance r-exactp-62 (x (* (expt 2 (1- p)) a)) (n (- (1- p) (expo (/ a b)))))))))

(local-defthm r-exactp-67
  (implies (and (rationalp a)
                (rationalp b)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (zp p))
                (exactp a p))
           (integerp (* (expt 2 (- (* 2 p) (+ 2 (expo (/ a b))))) a)))
  :hints (("Goal" :use (r-exactp-4 r-exactp-66))))

(local-defthm r-exactp-68
  (implies (and (rationalp a)
                (rationalp b)
                (integerp p)
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (rationalp q)
                (exactp q p)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p)))
                (>= (expo q) (expo (/ a b))))
           (integerp (* (expt 2 (1- p)) b)))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable exactp2))))

(local-defthm r-exactp-69
  (implies (and (rationalp x)
                (not (zp p))
                (exactp x p)
                (integerp n)
                (<= n (expo x)))
           (integerp (* (expt 2 (- p (1+ n))) x)))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable exactp2)
                  :use ((:instance r-exactp-62 (x (* (expt 2 (- p (1+ (expo x)))) x))
                                               (n (- (expo x) n)))))))

(local-defthm r-exactp-70
  (implies (and (rationalp a)
                (rationalp b)
                (integerp p)
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (rationalp q)
                (exactp q p)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p)))
                (>= (expo q) (expo (/ a b))))
           (integerp (* (expt 2 (- (1- p) (expo (/ a b)))) q)))
  :rule-classes ()
  :hints (("Goal" :use ((:instance r-exactp-69 (x q) (n (expo (/ a b))))))))

(local-defthm r-exactp-71
  (implies (and (integerp x) (integerp y))
           (integerp (* x y)))
  :rule-classes ())

(local-defthm r-exactp-72
  (implies (and (rationalp a)
                (rationalp b)
                (integerp p)
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (rationalp q)
                (exactp q p)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p)))
                (>= (expo q) (expo (/ a b))))
           (integerp (* (* (expt 2 (1- p)) b) (* (expt 2 (- (1- p) (expo (/ a b)))) q))))
  :rule-classes ()
  :hints (("Goal" :use (r-exactp-68
                        r-exactp-70
                        (:instance r-exactp-71 (x (* (expt 2 (1- p)) b)) (y (* (expt 2 (- (1- p) (expo (/ a b)))) q)))))))

(local-defthm r-exactp-71
  (implies (and (integerp x) (integerp y))
           (integerp (* x y)))
  :rule-classes ())

(local-defthm r-exactp-72
  (implies (and (rationalp a)
                (rationalp b)
                (integerp p)
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (rationalp q)
                (exactp q p)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p)))
                (>= (expo q) (expo (/ a b))))
           (integerp (* (* (expt 2 (1- p)) b) (* (expt 2 (- (1- p) (expo (/ a b)))) q))))
  :rule-classes ()
  :hints (("Goal" :use (r-exactp-68
                        r-exactp-70
                        (:instance r-exactp-71 (x (* (expt 2 (1- p)) b)) (y (* (expt 2 (- (1- p) (expo (/ a b)))) q)))))))

(local-defthm r-exactp-73
  (implies (and (rationalp a)
                (rationalp b)
                (integerp p)
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (rationalp q)
                (exactp q p)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p)))
                (>= (expo q) (expo (/ a b))))
           (integerp (* (expt 2 (- (* 2 p) (+ 2 (expo (/ a b))))) b q)))
  :rule-classes ()
  :hints (("Goal" :use (r-exactp-72))))

(local-defthm r-exactp-74
  (implies (and (rationalp a)
                (rationalp b)
                (integerp p)
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (rationalp q)
                (exactp q p)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p)))
                (>= (expo q) (expo (/ a b))))
           (exactp (- a (* b q)) p))
  :rule-classes ()
  :hints (("Goal" :use (r-exactp-4 r-exactp-65 r-exactp-66 r-exactp-73))))

(defthm r-exactp-75
  (implies (and (rationalp a)
                (rationalp b)
                (integerp p)
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (rationalp q)
                (exactp q p)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (exactp (- a (* b q)) p))
  :rule-classes ()
  :hints (("Goal" :use (r-exactp-55 r-exactp-74))))

(defthm r-exactp-76
  (implies (and (rationalp a)
                (rationalp b)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2))
           (let ((e (if (> a b) 0 -1)))
             (>= (expo (/ a b)) e)))
  :rule-classes nil
  :hints (("goal" :use (r-exactp-5 r-exactp-39))))

(defthm r-exactp-77
  (implies (and (rationalp a)
                (rationalp b)
                (integerp p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2))
           (let ((e (if (> a b) 0 -1)))
             (>= (expt 2 (- (1+ (expo (/ a b))) p))
                 (expt 2 (- (1+ e) p)))))
  :rule-classes nil
  :hints (("goal" :use (r-exactp-76))))

(defthm r-exactp
  (implies (and (rationalp a)
                (rationalp b)
                (integerp p)
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (rationalp q)
                (exactp q p)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (if (> a b) 0 -1)) p))))
           (exactp (- a (* b q)) p))
  :rule-classes ()
  :hints (("Goal" :use (r-exactp-75 r-exactp-77)
                  :in-theory (theory 'minimal-theory))))



(local-defthm expo-q-1
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (> a b)
                (rationalp q)
                (exactp q p)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (< q (+ (/ a b) (expt 2 (- 1 p)))))
  :rule-classes ()
  :hints (("Goal" :use (r-exactp-5))))

(defthm expo-q-2
  (implies (and (rationalp a)
                (not (zp p))
                (exactp a p)
                (<= 1 a)
                (< a 2))
           (<= a (- 2 (expt 2 (- 1 p)))))
  :rule-classes ()
  :hints (("Goal" :use (r-exactp-23
                        r-exactp-24
                        (:instance fp+2 (x (- 2 (expt 2 (- 1 p)))) (y a) (n p))))))

(local-defthm expo-q-3
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (> a b))
           (<= (/ a b) (/ (- 2 (expt 2 (- 1 p))) b)))
  :rule-classes ()
  :hints (("Goal" :use (expo-q-2))))

(local-defthm expo-q-4
  (implies (and (rationalp x)
                (rationalp b)
                (> x 0)
                (<= 1 b)
                (< b 2))
           (<= (/ x b) x))
  :rule-classes ())

(local-defthm expo-q-5
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (> a b))
           (and (rationalp (/ a (- 2 (expt 2 (- 1 p)))))
                (> (/ a (- 2 (expt 2 (- 1 p)))) 0)))
  :rule-classes ())

(local-defthm expo-q-6
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (> a b))
           (<= (/ a b) (- 2 (expt 2 (- 1 p)))))
  :rule-classes ()
  :hints (("Goal" :use (expo-q-3 expo-q-5
                        (:instance expo-q-4 (x (- 2 (expt 2 (- 1 p))))))
                  :in-theory (theory 'minimal-theory))))

(local-defthm expo-q-7
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (> a b)
                (rationalp q)
                (exactp q p)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (< q 2))
  :rule-classes ()
  :hints (("Goal" :use (expo-q-1 expo-q-6))))

(defthm expo-q-8
  (implies (and (integerp a) (integerp b) (>= a b))
           (>= (expt 2 a) (expt 2 b)))
  :rule-classes ())

(local-defthm expo-q-9
  (implies (and (integerp p) (> p 1))
           (<= (expt 2 (- 1 p)) 1/2))
  :rule-classes ()
  :hints (("Goal" :use ((:instance expo-q-8 (a -1) (b (- 1 p)))))))

(local-defthm expo-q-10
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (rationalp q)
                (exactp q p)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (> q 0))
  :rule-classes ()
  :hints (("Goal" :use (expo-q-9
                        r-exactp-4
                        r-exactp-3))))

(local-defthm expo-q-11
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (> a b)
                (rationalp q)
                (exactp q p)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (= (expo q) (expo (/ a b))))
  :rule-classes ()
  :hints (("Goal" :use (r-exactp-5
                        r-exactp-3
                        r-exactp-22
                        expo-q-7
                        expo-q-10
                        (:instance expo<= (x q) (n 0))))))

(local-defthm expo-q-12
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (< a b)
                (rationalp q)
                (exactp q p)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (>= b (+ a (expt 2 (- 1 p)))))
  :rule-classes ()
  :hints (("Goal" :use ((:instance fp+2 (x a) (y b) (n p))))))

(local-defthm expo-q-13
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (< a b)
                (rationalp q)
                (exactp q p)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (<= (/ a b) (/ a (+ a (expt 2 (- 1 p))))))
  :rule-classes ()
  :hints (("goal" :use (expo-q-12))))

(local-defthm expo-q-14
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (< a b)
                (rationalp q)
                (exactp q p)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (= (/ a (+ a (expt 2 (- 1 p))))
              (- 1 (/ (expt 2 (- 1 p)) (+ a (expt 2 (- 1 p)))))))
  :rule-classes ())

(local-defthm expo-q-15
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (< a b)
                (rationalp q)
                (exactp q p)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (<= (+ a (expt 2 (- 1 p))) 2))
  :rule-classes ()
  :hints (("Goal" :use (expo-q-2))))

(local-defthm expo-q-16
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (< a b)
                (rationalp q)
                (exactp q p)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (>= (/ (expt 2 (- 1 p)) (+ a (expt 2 (- 1 p))))
               (expt 2 (- p))))
  :rule-classes ()
  :hints (("Goal" :use (expo-q-15))))

(local-defthm expo-q-17
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (< a b)
                (rationalp q)
                (exactp q p)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (<= (/ a b) (- 1 (expt 2 (- p)))))
  :rule-classes ()
  :hints (("Goal" :use (expo-q-13 expo-q-14 expo-q-16)
                   :in-theory (theory 'minimal-theory))))

(local-defthm expo-q-18
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (< a b)
                (rationalp q)
                (exactp q p)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (< q 1))
  :rule-classes ()
  :hints (("Goal" :use (r-exactp-39 expo-q-17))))

(local-defthm expo-q-19
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (< a b)
                (rationalp q)
                (exactp q p)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (= (expo q) (expo (/ a b))))
  :rule-classes ()
  :hints (("Goal" :use (r-exactp-39 r-exactp-46 expo-q-10 expo-q-18
                        (:instance expo<= (x q) (n -1))))))

(local-defthm expo-q-20
  (implies (and (rationalp q)
                (integerp p)
                (> p 1))
           (>= (expt 2 (- 1 p))
               (expt 2 (- p))))
  :rule-classes ()
  :hints (("Goal" :use (r-exactp-51))))

(local-defthm expo-q-21
  (implies (and (rationalp q)
                (integerp p)
                (> p 1)
                (rationalp q)
                (exactp q p)
                (< (abs (- 1 q)) (expt 2 (- p))))
           (and (< q (1+ (expt 2 (- p))))
                (> q (- 1 (expt 2 (- p))))))
  :rule-classes ())

(local-defthm expo-q-22
  (implies (and (rationalp q)
                (integerp p)
                (> p 1)
                (rationalp q)
                (exactp q p)
                (< (abs (- 1 q)) (expt 2 (- p))))
           (and (< q (1+ (expt 2 (- 1 p))))
                (> q (- 1 (expt 2 (- p))))))
  :rule-classes ()
  :hints (("Goal" :use (expo-q-20 expo-q-21)
                   :in-theory (theory 'minimal-theory))))

(local-defthm expo-q-23
  (implies (and (rationalp q)
                (integerp p)
                (> p 1)
                (rationalp q)
                (exactp q p)
                (< (abs (- 1 q)) (expt 2 (- p))))
           (= q 1))
  :rule-classes ()
  :hints (("Goal" :use (expo-q-22 r-exactp-19 r-exactp-20
                        (:instance exactp (x 1) (n p))
                        (:instance fp+2 (x 1) (y q) (n p))
                        (:instance fp+2 (x (- 1 (expt 2 (- p)))) (y q) (n p))))))

(local-defthm expo-q-24
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (= a b)
                (rationalp q)
                (exactp q p)
                (< (abs (- (/ a b) q)) (expt 2 (- p))))
           (= (- a (* b q)) 0))
  :rule-classes ()
  :hints (("Goal" :use (expo-q-23))))

(defthm expo-q
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (rationalp q)
                (exactp q p)
                (< (abs (- (/ a b) q)) (expt 2 (- (if (> a b) 1 0) p))))
           (= (expo q) (expo (/ a b))))
  :rule-classes ()
  :hints (("Goal" :use (expo-q-11 expo-q-19 expo-q-24 r-exactp-5 r-exactp-39))))

(defthm expo-q-alt
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp q)
                (exactp q p)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (= (expo q) (expo (/ a b))))
  :rule-classes ()
  :hints (("Goal" :use (expo-q r-exactp-5 r-exactp-39))))

(local-defthm r-pos-1
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp q)
                (exactp q p)
                (> (/ a b) q)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (< (/ a b) (fp+ q p)))
  :rule-classes ()
  :hints (("Goal" :use (expo-q-alt))))

(local-defthm r-pos-2
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp q)
                (exactp q p)
                (> (/ a b) q)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (< (- (/ a b) q) (expt 2 (- (1+ (expo q)) p))))
  :rule-classes ()
  :hints (("Goal" :use (expo-q-alt))))

(local-defthm r-pos-3
  (implies (and (rationalp x)
                (rationalp y)
                (rationalp b)
                (<= 1 b)
                (< b 2)
                (< x y))
           (< (* b x) (* b y)))
  :rule-classes ())

(local-defthm r-pos-4
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp q)
                (exactp q p)
                (> (/ a b) q)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (and (rationalp (- (/ a b) q))
                (rationalp (expt 2 (- (1+ (expo q)) p)))))
  :rule-classes ())

(local-defthm r-pos-5
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp q)
                (exactp q p)
                (> (/ a b) q)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (< (* b (- (/ a b) q)) (* b (expt 2 (- (1+ (expo q)) p)))))
  :rule-classes ()
  :hints (("Goal" :use (r-pos-2 r-pos-4
                        (:instance r-pos-3 (x (- (/ a b) q)) (y (expt 2 (- (1+ (expo q)) p))))))))

(local-defthm r-pos-6
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp q)
                (exactp q p)
                (> (/ a b) q)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (< (- a (* b q)) (* b (expt 2 (- (1+ (expo q)) p)))))
  :rule-classes ()
  :hints (("Goal" :use (r-pos-5))))

(local-defthm r-pos-7
  (implies (and (rationalp y)
                (> y 0)
                (rationalp x)
                (rationalp z)
                (< x z))
           (< (* y x) (* y z)))
  :rule-classes ())

(local-defthm r-pos-8
  (implies (and (rationalp (* b (expt 2 n)))
                (rationalp x)
                (rationalp (expt 2 (- n)))
                (> (expt 2 (- n)) 0)
                (< x (* b (expt 2 n))))
           (< (* (expt 2 (- n)) x) (* (expt 2 (- n)) (* b (expt 2 n)))))
  :rule-classes ()
  :hints (("Goal" :use ((:instance r-pos-7 (y (expt 2 (- n))) (z (* b (expt 2 n))))))))

(local-defthm r-pos-9
  (implies (and (integerp n)
                (rationalp x)
                (rationalp b)
                (< x (* b (expt 2 n))))
           (< (* (expt 2 (- n)) x) b))
  :rule-classes ()
  :hints (("Goal" :use (r-pos-8))))

(local-defthm r-pos-10
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (integerp (- (1+ (expo (/ a b))) p))
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp q)
                (rationalp (- a (* b q)))
                (exactp q p)
                (> (/ a b) q)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (< (* (expt 2 (- (- (1+ (expo q)) p))) (- a (* b q))) b))
  :rule-classes ()
  :hints (("Goal" :use (r-pos-6 expo-q-alt
                        (:instance r-pos-9 (n (- (1+ (expo (/ a b))) p)) (x (- a (* b q)))))
                  :in-theory (theory 'minimal-theory))))

(local-defthm r-pos-11
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp q)
                (exactp q p)
                (> (/ a b) q)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (< (* (expt 2 (- p (1+ (expo q)))) (- a (* b q))) b))
  :rule-classes ()
  :hints (("Goal" :use (r-pos-10))))

(local-defthm r-pos-12
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p))))
            (> y 0))
  :rule-classes ())

(local-defthm r-pos-13
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p))))
            (< (* b y) (1+ (/ (expt 2 p)))))
  :rule-classes ())

(local-defthm r-pos-14
  (implies (and (rationalp x)
                (rationalp y)
                (rationalp b)
                (> x 0)
                (> y 0)
                (> b 0)
                (< x y))
           (< (/ b y) (/ b x)))
  :rule-classes ())

(local-defthm r-pos-15
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (rationalp y)
                (rationalp (* b y))
                (> (* b y) 0)
                (rationalp (1+ (/ (expt 2 p))))
                (> (1+ (/ (expt 2 p))) 0)
                (< (abs (- 1 (* b y))) (/ (expt 2 p))))
            (< (/ b (1+ (/ (expt 2 p))))
               (/ b (* b y))))
  :rule-classes ()
  :hints (("Goal" :use (r-pos-13
                        (:instance r-pos-14 (x (* b y)) (y (1+ (/ (expt 2 p)))))))))

(local-defthm r-pos-16
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p))))
            (< (/ b (1+ (expt 2 (- p))))
               (/ y)))
  :rule-classes ()
  :hints (("Goal" :use (r-pos-15))))

(local-defthm r-pos-17
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (> (/ a b) q)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (exactp (* (expt 2 (- p (1+ (expo q)))) (- a (* b q))) p))
  :rule-classes ()
  :hints (("Goal" :use (r-exactp-75
                        (:instance exactp-shift (n p) (x (- a (* b q))) (k (- p (1+ (expo q)))))))))

(local-defthm r-pos-18
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (< q (/ a b))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (< (* b q) (* b (/ a b))))
  :rule-classes ()
  :hints (("Goal" :use ((:instance r-pos-3 (x q) (y (/ a b)))))))

(local-defthm r-pos-19
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (> (/ a b) q)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (> (- a (* b q)) 0))
  :rule-classes ()
  :hints (("Goal" :use (r-pos-18))))

(local-defthm r-pos-20
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (< 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (> (/ a b) q)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (<= (* (expt 2 (- p (1+ (expo q)))) (- a (* b q))) (- b (expt 2 (- 1 p)))))
  :rule-classes ()
  :hints (("Goal" :use (r-pos-11 r-pos-17 r-pos-19
                        (:instance fp-2 (x b) (y (* (expt 2 (- p (1+ (expo q)))) (- a (* b q)))) (n p))))))

(local-defthm r-pos-21
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (< 1 b)
                (< b 2))
           (<= (* (1+ (expt 2 (- p))) (- b (expt 2 (- 1 p)))) b))
  :rule-classes ())

(local-defthm r-pos-22
  (implies (and (rationalp x)
                (rationalp y)
                (rationalp z)
                (> z 0)
                (<= x y))
           (<= (/ x z) (/ y z)))
  :rule-classes ())

(local-defthm r-pos-23
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (< 1 b)
                (< b 2))
           (<= (/ (* (1+ (expt 2 (- p))) (- b (expt 2 (- 1 p)))) (1+ (expt 2 (- p))))
               (/ b (1+ (expt 2 (- p))))))
  :rule-classes ()
  :hints (("Goal" :use (r-pos-21
                        (:instance r-pos-22 (x (* (1+ (expt 2 (- p))) (- b (expt 2 (- 1 p)))))
                                            (y  b)
                                            (z (1+ (expt 2 (- p)))))))))

(local-defthm r-pos-24
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (< 1 b)
                (< b 2))
           (<= (- b (expt 2 (- 1 p))) (/ b (1+ (expt 2 (- p))))))
  :rule-classes ()
  :hints (("Goal" :use (r-pos-23))))

(local-defthm r-pos-25
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (< 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (> (/ a b) q)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (< (* (expt 2 (- p (1+ (expo q)))) (- a (* b q)))
              (/ y)))
  :rule-classes ()
  :hints (("Goal" :use (r-pos-16 r-pos-20 r-pos-24))))

(local-defthm r-pos-26
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (= 1 b)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (> (/ a b) q)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (<= (* (expt 2 (- p (1+ (expo q)))) (- a (* b q))) (- b (expt 2 (- p)))))
  :rule-classes ()
  :hints (("Goal" :use (r-pos-11 r-pos-17 r-pos-19
                        (:instance fp-2 (x b) (y (* (expt 2 (- p (1+ (expo q)))) (- a (* b q)))) (n p))))))

(local-defthm r-pos-27
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (= 1 b))
           (<= (- b (expt 2 (- p))) (/ b (1+ (expt 2 (- p))))))
  :rule-classes ())

(local-defthm r-pos-28
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (= 1 b)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (> (/ a b) q)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (< (* (expt 2 (- p (1+ (expo q)))) (- a (* b q)))
              (/ y)))
  :rule-classes ()
  :hints (("Goal" :use (r-pos-16 r-pos-26 r-pos-27)
                  :in-theory (theory 'minimal-theory))))

(local-defthm r-pos-29
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (> (/ a b) q)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (< (* (expt 2 (- p (1+ (expo q)))) (- a (* b q)))
              (/ y)))
  :rule-classes ()
  :hints (("Goal" :use (r-pos-28 r-pos-25))))

(local-defthm r-pos-30
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (> (/ y) 0)
                (rationalp (* (expt 2 (+ p (- (+ 1 (expo q))))) (+ a (- (* b q)))))
                (exactp q p)
                (> (/ a b) q)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (< (* y (* (expt 2 (- p (1+ (expo q)))) (- a (* b q))))
              (* y (/ y))))
  :rule-classes ()
  :hints (("Goal" :use (r-pos-29
                        (:instance r-pos-7 (x (* (expt 2 (- p (1+ (expo q)))) (- a (* b q)))) (z (/ y))))
                  :in-theory (theory 'minimal-theory))))

(local-defthm r-pos-31
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (> (/ a b) q)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (< (* (expt 2 (- p (1+ (expo q)))) (- a (* b q)) y)
              (* (expt 2 (- (- p (1+ (expo q))))) (expt 2 (- p (1+ (expo q)))))))
  :rule-classes ()
  :hints (("Goal" :use (r-pos-30))))

(local-defthm r-pos-32
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (rationalp (* (expt 2 (- p (1+ (expo q)))) (- a (* b q)) y))
                (integerp (- p (1+ (expo q))))
                (rationalp (expt 2 (- (- p (1+ (expo q))))))
                (exactp q p)
                (> (/ a b) q)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (< (* (expt 2 (- (- p (1+ (expo q))))) (* (expt 2 (- p (1+ (expo q)))) (- a (* b q)) y))
              (expt 2 (- (- p (1+ (expo q)))))))
  :rule-classes ()
  :hints (("Goal" :use (r-pos-31
                        (:instance r-pos-9 (x (* (expt 2 (- p (1+ (expo q)))) (- a (* b q)) y))
                                           (n (- p (1+ (expo q))))
                                           (b (expt 2 (- (- p (1+ (expo q))))))))
                  :in-theory (theory 'minimal-theory))))

(local-defthm r-pos-33
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (> (/ a b) q)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (< (* (- a (* b q)) y)
              (expt 2 (- (1+ (expo q)) p))))
  :rule-classes ()
  :hints (("Goal" :use (r-pos-32))))

(local-defthm r-pos-34
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (> (/ a b) q)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (and (< q (+ q (* (- a (* b q)) y)))
                (< (+ q (* (- a (* b q)) y)) (+ q (expt 2 (- (1+ (expo q)) p))))
                (< q (/ a b))
                (< (/ a b) (+ q (expt 2 (- (1+ (expo q)) p))))))
  :rule-classes ()
  :hints (("Goal" :use (expo-q-alt r-pos-12 r-pos-19 r-pos-33))))

(local-defthm r-pos-directed
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (> (/ a b) q)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (and (= (rtz (+ q (* (- a (* b q)) y)) p)
                   (rtz (/ a b) p))
                (= (rup (+ q (* (- a (* b q)) y)) p)
                   (rup (/ a b) p))
                (= (rdn (+ q (* (- a (* b q)) y)) p)
                   (rdn (/ a b) p))))
  :rule-classes ()
  :hints (("Goal" :use (expo-q-10 r-pos-19 r-pos-34
                        (:instance rtz-squeeze (x (/ a b)) (a q) (n p))
                        (:instance rtz-squeeze (x (+ q (* (- a (* b q)) y))) (a q) (n p))
                        (:instance raz-squeeze (x (/ a b)) (a q) (n p))
                        (:instance raz-squeeze (x (+ q (* (- a (* b q)) y))) (a q) (n p))))))

(local-defthm not-midpoint-1
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (rationalp q)
                (exactp q p))
           (and (< q (+ q (expt 2 (- (expo q) p))))
                (< (+ q (expt 2 (- (expo q) p))) (fp+ q p))))
  :rule-classes ())

(local-defthm not-midpoint-2
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (rationalp q)
                (exactp q p)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (= (expo (+ q (expt 2 (- (expo q) p)))) (expo q)))
  :rule-classes ()
  :hints (("Goal" :use (expo-q-10
                        not-midpoint-1
                        (:instance expo-monotone (x q) (y (+ q (expt 2 (- (expo q) p)))))
                        (:instance expo-monotone (x (+ q (expt 2 (- (expo q) p)))) (y (fp+ q p)))
                        (:instance fp+expo (x q) (n p))
                        (:instance expo<= (x (+ q (expt 2 (- (expo q) p)))) (n (expo q)))))))

(local-defthm not-midpoint-3
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (rationalp q)
                (exactp q p)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (exactp (+ q (expt 2 (- (expo q) p))) (1+ p)))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable exactp2)
                  :use (not-midpoint-2
                        (:instance exactp-<= (x q) (m p) (n (1+ p)))))))

(local-defthm not-midpoint-4
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (rationalp q)
                (exactp q p)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (not (exactp (+ q (expt 2 (- (expo q) p))) p)))
  :rule-classes ()
  :hints (("Goal" :use (not-midpoint-1 expo-q-10
                        (:instance fp+2 (x q) (y (+ q (expt 2 (- (expo q) p)))) (n p))))))

(local-defthm not-midpoint
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp q)
                (exactp q p)
                (> (/ a b) q)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (not (= (/ a b) (+ q (expt 2 (- (expo q) p))))))
  :rule-classes ()
  :hints (("Goal" :use (not-midpoint-3 not-midpoint-4
                        (:instance exactp-<= (x b) (m p) (n (1+ p)))
                        (:instance exactp-factors (x (/ a b)) (y b) (n p) (k (1+ p)))))))

(local-defthm r-pos-rne-4
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp q)
                (exactp q p)
                (> (/ a b) q)
                (< (/ a b) (+ q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (and (rationalp (- (/ a b) q))
                (rationalp (expt 2 (- (1+ (expo q)) p)))))
  :rule-classes ())

(local-defthm r-pos-rne-5
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp q)
                (exactp q p)
                (> (/ a b) q)
                (< (/ a b) (+ q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (< (* b (- (/ a b) q)) (* b (expt 2 (- (expo q) p)))))
  :rule-classes ()
  :hints (("Goal" :use (r-pos-4
                        (:instance r-pos-3 (x (- (/ a b) q)) (y (expt 2 (- (expo q) p))))))))

(local-defthm r-pos-rne-6
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp q)
                (exactp q p)
                (> (/ a b) q)
                (< (/ a b) (+ q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (< (- a (* b q)) (* b (expt 2 (- (expo q) p)))))
  :rule-classes ()
  :hints (("Goal" :use (r-pos-rne-5))))

(local-defthm r-pos-rne-10
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (integerp (- (expo (/ a b)) p))
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp q)
                (rationalp (- a (* b q)))
                (exactp q p)
                (> (/ a b) q)
                (< (/ a b) (+ q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (< (* (expt 2 (- (- (expo q) p))) (- a (* b q))) b))
  :rule-classes ()
  :hints (("Goal" :use (r-pos-rne-6 expo-q-alt
                        (:instance r-pos-9 (n (- (expo (/ a b)) p)) (x (- a (* b q)))))
                  :in-theory (theory 'minimal-theory))))

(local-defthm r-pos-rne-11
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp q)
                (exactp q p)
                (> (/ a b) q)
                (< (/ a b) (+ q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (< (* (expt 2 (- p (expo q))) (- a (* b q))) b))
  :rule-classes ()
  :hints (("Goal" :use (r-pos-rne-10))))

(local-defthm r-pos-rne-17
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (> (/ a b) q)
                (< (/ a b) (+ q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (exactp (* (expt 2 (- p (expo q))) (- a (* b q))) p))
  :rule-classes ()
  :hints (("Goal" :use (r-exactp-75
                        (:instance exactp-shift (n p) (x (- a (* b q))) (k (- p (expo q))))))))

(local-defthm r-pos-rne-20
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (< 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (> (/ a b) q)
                (< (/ a b) (+ q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (<= (* (expt 2 (- p (expo q))) (- a (* b q))) (- b (expt 2 (- 1 p)))))
  :rule-classes ()
  :hints (("Goal" :use (r-pos-rne-11 r-pos-rne-17 r-pos-19
                        (:instance fp-2 (x b) (y (* (expt 2 (- p (expo q))) (- a (* b q)))) (n p))))))

(local-defthm r-pos-rne-25
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (< 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (> (/ a b) q)
                (< (/ a b) (+ q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (< (* (expt 2 (- p (expo q))) (- a (* b q)))
              (/ y)))
  :rule-classes ()
  :hints (("Goal" :use (r-pos-16 r-pos-rne-20 r-pos-24))))

(local-defthm r-pos-rne-26
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (= 1 b)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (> (/ a b) q)
                (< (/ a b) (+ q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (<= (* (expt 2 (- p (expo q))) (- a (* b q))) (- b (expt 2 (- p)))))
  :rule-classes ()
  :hints (("Goal" :use (r-pos-rne-11 r-pos-rne-17 r-pos-19
                        (:instance fp-2 (x b) (y (* (expt 2 (- p (expo q))) (- a (* b q)))) (n p))))))

(local-defthm r-pos-rne-28
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (= 1 b)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (> (/ a b) q)
                (< (/ a b) (+ q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (< (* (expt 2 (- p (expo q))) (- a (* b q)))
              (/ y)))
  :rule-classes ()
  :hints (("Goal" :use (r-pos-16 r-pos-rne-26 r-pos-27)
                  :in-theory (theory 'minimal-theory))))

(local-defthm r-pos-rne-29
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (> (/ a b) q)
                (< (/ a b) (+ q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (< (* (expt 2 (- p (expo q))) (- a (* b q)))
              (/ y)))
  :rule-classes ()
  :hints (("Goal" :use (r-pos-rne-28 r-pos-rne-25))))

(local-defthm r-pos-rne-30
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (> (/ y) 0)
                (rationalp (* (expt 2 (+ p (- (expo q)))) (+ a (- (* b q)))))
                (exactp q p)
                (> (/ a b) q)
                (< (/ a b) (+ q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (< (* y (* (expt 2 (- p (expo q))) (- a (* b q))))
              (* y (/ y))))
  :rule-classes ()
  :hints (("Goal" :use (r-pos-rne-29
                        (:instance r-pos-7 (x (* (expt 2 (- p (expo q))) (- a (* b q)))) (z (/ y))))
                  :in-theory (theory 'minimal-theory))))

(local-defthm r-pos-rne-31
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (> (/ a b) q)
                (< (/ a b) (+ q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (< (* (expt 2 (- p (expo q))) (- a (* b q)) y)
              (* (expt 2 (- (- p (expo q)))) (expt 2 (- p (expo q))))))
  :rule-classes ()
  :hints (("Goal" :use (r-pos-rne-30))))

(local-defthm r-pos-rne-32
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (rationalp (* (expt 2 (- p (expo q))) (- a (* b q)) y))
                (integerp (- p (expo q)))
                (rationalp (expt 2 (- (- p (expo q)))))
                (exactp q p)
                (> (/ a b) q)
                (< (/ a b) (+ q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (< (* (expt 2 (- (- p (expo q)))) (* (expt 2 (- p (expo q))) (- a (* b q)) y))
              (expt 2 (- (- p (expo q))))))
  :rule-classes ()
  :hints (("Goal" :use (r-pos-rne-31
                        (:instance r-pos-9 (x (* (expt 2 (- p (expo q))) (- a (* b q)) y))
                                           (n (- p (expo q)))
                                           (b (expt 2 (- (- p (expo q)))))))
                  :in-theory (theory 'minimal-theory))))

(local-defthm r-pos-rne-33
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (> (/ a b) q)
                (< (/ a b) (+ q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (< (* (- a (* b q)) y)
              (expt 2 (- (expo q) p))))
  :rule-classes ()
  :hints (("Goal" :use (r-pos-rne-32))))

(local-defthm r-pos-rne-34
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (> (/ a b) q)
                (< (/ a b) (+ q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (and (< q (+ q (* (- a (* b q)) y)))
                (< (+ q (* (- a (* b q)) y)) (+ q (expt 2 (- (expo q) p))))
                (< q (/ a b))
                (< (/ a b) (+ q (expt 2 (- (expo q) p))))))
  :rule-classes ()
  :hints (("Goal" :use (expo-q-alt r-pos-12 r-pos-19 r-pos-rne-33))))

(local-defthm r-pos-rne-down
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (> (/ a b) q)
                (< (/ a b) (+ q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (= (rne (+ q (* (- a (* b q)) y)) p)
              (rne (/ a b) p)))
  :rule-classes ()
  :hints (("Goal" :use (expo-q-10 r-pos-19 r-pos-rne-34
                        (:instance rne-down (x (/ a b)) (a q) (n p))
                        (:instance rne-down (x (+ q (* (- a (* b q)) y))) (a q) (n p))))))

(local-defthm r-pos-rne-up-4
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp q)
                (exactp q p)
                (> (/ a b) q)
                (> (/ a b) (+ q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (and (rationalp (- (/ a b) q))
                (rationalp (expt 2 (- (1+ (expo q)) p)))))
  :rule-classes ())

(local-defthm r-pos-rne-up-5
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp q)
                (exactp q p)
                (> (/ a b) q)
                (> (/ a b) (+ q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (> (* b (- (/ a b) q)) (* b (expt 2 (- (expo q) p)))))
  :rule-classes ()
  :hints (("Goal" :use (r-pos-4
                        (:instance r-pos-3 (y (- (/ a b) q)) (x (expt 2 (- (expo q) p))))))))

(local-defthm r-pos-rne-up-6
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp q)
                (exactp q p)
                (> (/ a b) q)
                (> (/ a b)
                (+ q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q))
                (expt 2 (- (1+ (expo (/ a b))) p))))
           (> (- a (* b q)) (* b (expt 2 (- (expo q) p)))))
  :rule-classes ()
  :hints (("goal" :use (r-pos-rne-up-5))))

(local-defthm r-pos-up-8
  (implies (and (rationalp (* b (expt 2 n)))
                (rationalp x)
                (rationalp (expt 2 (- n)))
                (> (expt 2 (- n)) 0)
                (> x (* b (expt 2 n))))
           (> (* (expt 2 (- n)) x) (* (expt 2 (- n)) (* b (expt 2 n)))))
  :rule-classes ()
  :hints (("Goal" :use ((:instance r-pos-7 (y (expt 2 (- n))) (z x) (x (* b (expt 2 n))))))))

(local-defthm r-pos-up-9
  (implies (and (integerp n)
                (rationalp x)
                (rationalp b)
                (> x (* b (expt 2 n))))
           (> (* (expt 2 (- n)) x) b))
  :rule-classes ()
  :hints (("Goal" :use (r-pos-up-8))))

(local-defthm r-pos-rne-up-10
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (integerp (- (expo (/ a b)) p))
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp q)
                (rationalp (- a (* b q)))
                (exactp q p)
                (> (/ a b) q)
                (> (/ a b) (+ q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (> (* (expt 2 (- (- (expo q) p))) (- a (* b q))) b))
  :rule-classes ()
  :hints (("Goal" :use (r-pos-rne-up-6 expo-q-alt
                        (:instance r-pos-up-9 (n (- (expo (/ a b)) p)) (x (- a (* b q)))))
                  :in-theory (theory 'minimal-theory))))

(local-defthm r-pos-rne-up-11
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp q)
                (exactp q p)
                (> (/ a b) q)
                (> (/ a b) (+ q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (> (* (expt 2 (- p (expo q))) (- a (* b q))) b))
  :rule-classes ()
  :hints (("Goal" :use (r-pos-rne-up-10))))

(local-defthm r-pos-rne-up-17
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (> (/ a b) q)
                (> (/ a b) (+ q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (exactp (* (expt 2 (- p (expo q))) (- a (* b q))) p))
  :rule-classes ()
  :hints (("Goal" :use (r-exactp-75
                        (:instance exactp-shift (n p) (x (- a (* b q))) (k (- p (expo q))))))))

(local-defthm r-pos-rne-up-20
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (> (/ a b) q)
                (> (/ a b) (+ q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (>= (* (expt 2 (- p (expo q))) (- a (* b q))) (+ b (expt 2 (- 1 p)))))
  :rule-classes ()
  :hints (("Goal" :use (r-pos-rne-up-11 r-pos-rne-up-17 r-pos-19
                        (:instance fp+2 (x b) (y (* (expt 2 (- p (expo q))) (- a (* b q)))) (n p))))))

(local-defthm r-pos-up-13
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p))))
            (> (* b y) (- 1 (/ (expt 2 p)))))
  :rule-classes ())

(local-defthm r-pos-up-15
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (rationalp y)
                (rationalp (* b y))
                (> (* b y) 0)
                (rationalp (1+ (/ (expt 2 p))))
                (> (- 1 (/ (expt 2 p))) 0)
                (< (abs (- 1 (* b y))) (/ (expt 2 p))))
            (> (/ b (- 1 (/ (expt 2 p))))
               (/ b (* b y))))
  :rule-classes ()
  :hints (("Goal" :use (r-pos-up-13
                        (:instance r-pos-14 (y (* b y)) (x (- 1 (/ (expt 2 p)))))))))

(local-defthm r-pos-up-16
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p))))
            (> (/ b (- 1 (expt 2 (- p))))
               (/ y)))
  :rule-classes ()
  :hints (("Goal" :use (r-pos-up-15))))

(local-defthm r-pos-up-21
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2))
           (<= (* (expt 2 (- p)) b) (- (expt 2 (- 1 p)) (expt 2 (- 1 (* 2 p))))))
  :rule-classes ()
  :hints (("Goal" :use (r-exactp-25))))

(local-defthm r-pos-up-22
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2))
           (>= (* (- 1 (expt 2 (- p))) (+ b (expt 2 (- 1 p)))) b))
  :rule-classes ()
  :hints (("Goal" :use (r-pos-up-21))))

(local-defthm r-pos-up-23
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2))
           (>= (/ (* (- 1 (expt 2 (- p))) (+ b (expt 2 (- 1 p)))) (- 1 (expt 2 (- p))))
               (/ b (- 1 (expt 2 (- p))))))
  :rule-classes ()
  :hints (("Goal" :use (r-pos-up-22
                        (:instance r-pos-22 (y (* (- 1 (expt 2 (- p))) (+ b (expt 2 (- 1 p)))))
                                            (x  b)
                                            (z (- 1 (expt 2 (- p)))))))))

(local-defthm r-pos-up-24
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2))
           (>= (+ b (expt 2 (- 1 p))) (/ b (- 1 (expt 2 (- p))))))
  :rule-classes ()
  :hints (("Goal" :use (r-pos-up-23))))

(local-defthm r-pos-rne-up-25
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (> (/ a b) q)
                (> (/ a b) (+ q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (> (* (expt 2 (- p (expo q))) (- a (* b q)))
              (/ y)))
  :rule-classes ()
  :hints (("Goal" :use (r-pos-up-16 r-pos-rne-up-20 r-pos-up-24))))

(local-defthm r-pos-rne-up-30
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (> (/ y) 0)
                (rationalp (* (expt 2 (+ p (- (expo q)))) (+ a (- (* b q)))))
                (exactp q p)
                (> (/ a b) q)
                (> (/ a b) (+ q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (> (* y (* (expt 2 (- p (expo q))) (- a (* b q))))
              (* y (/ y))))
  :rule-classes ()
  :hints (("Goal" :use (r-pos-rne-up-25
                        (:instance r-pos-7 (z (* (expt 2 (- p (expo q))) (- a (* b q)))) (x (/ y))))
                  :in-theory (theory 'minimal-theory))))

(local-defthm r-pos-rne-up-31
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (> (/ a b) q)
                (> (/ a b) (+ q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (> (* (expt 2 (- p (expo q))) (- a (* b q)) y) 1))
  :rule-classes ()
  :hints (("Goal" :use (r-pos-rne-up-30))))

(local-defthm r-pos-rne-up-32
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (rationalp (* (expt 2 (- p (expo q))) (- a (* b q)) y))
                (integerp (- p (expo q)))
                (rationalp (expt 2 (- (- p (expo q)))))
                (exactp q p)
                (> (/ a b) q)
                (> (/ a b) (+ q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (> (* (- a (* b q)) y) (expt 2 (- (- p (expo q))))))
  :rule-classes ()
  :hints (("Goal" :use (r-pos-rne-up-31
                        (:instance r-pos-9 (x 1)
                                           (n (- p (expo q)))
                                           (b (* (- a (* b q)) y)))))))

(local-defthm r-pos-rne-up-33
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (> (/ a b) q)
                (> (/ a b) (+ q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (> (* (- a (* b q)) y)
              (expt 2 (- (expo q) p))))
  :rule-classes ()
  :hints (("Goal" :use (r-pos-rne-up-32))))

(local-defthm r-pos-rne-up-34
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (> (/ a b) q)
                (> (/ a b) (+ q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (and (> (+ q (* (- a (* b q)) y)) (+ q (expt 2 (- (expo q) p))))
                (< (+ q (* (- a (* b q)) y)) (+ q (expt 2 (- (1+ (expo q)) p))))
                (> (/ a b) (+ q (expt 2 (- (expo q) p))))
                (< (/ a b) (+ q (expt 2 (- (1+ (expo q)) p))))))
  :rule-classes ()
  :hints (("Goal" :use (expo-q-alt r-pos-12 r-pos-19 r-pos-33 r-pos-rne-up-33))))

(local-defthm r-pos-rne-up
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (> (/ a b) q)
                (> (/ a b) (+ q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (= (rne (+ q (* (- a (* b q)) y)) p)
              (rne (/ a b) p)))
  :rule-classes ()
  :hints (("Goal" :use (expo-q-10 r-pos-19 r-pos-rne-up-34
                        (:instance rne-up (x (/ a b)) (a q) (n p))
                        (:instance rne-up (x (+ q (* (- a (* b q)) y))) (a q) (n p))))))

(local-defthm r-pos-rnd
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (> (/ a b) q)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p)))
                (ieee-rounding-mode-p mode))
           (= (rnd (+ q (* (- a (* b q)) y)) mode p)
              (rnd (/ a b) mode p)))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable rnd ieee-rounding-mode-p)
                  :use (not-midpoint r-pos-rne-down r-pos-rne-up r-pos-directed))))

(local-defthm q-not-expo-q
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp q)
                (exactp q p)
                (< (/ a b) q)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (not (= q (expt 2 (expo q)))))
  :rule-classes ()
  :hints (("Goal" :use (expo-q-alt
                        (:instance expo-lower-bound (x (/ a b)))))))

(local-defthm r-neg-1
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp q)
                (exactp q p)
                (< (/ a b) q)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (> (/ a b) (fp- q p)))
  :rule-classes ()
  :hints (("Goal" :use (q-not-expo-q expo-q-alt))))

(local-defthm r-neg-2
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp q)
                (exactp q p)
                (< (/ a b) q)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (< (- q (/ a b)) (expt 2 (- (1+ (expo q)) p))))
  :rule-classes ()
  :hints (("Goal" :use (expo-q-alt))))

(local-defthm r-neg-4
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp q)
                (exactp q p)
                (< (/ a b) q)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (and (rationalp (- q (/ a b)))
                (rationalp (expt 2 (- (1+ (expo q)) p)))))
  :rule-classes ())

(local-defthm r-neg-5
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp q)
                (exactp q p)
                (< (/ a b) q)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (< (* b (- q (/ a b))) (* b (expt 2 (- (1+ (expo q)) p)))))
  :rule-classes ()
  :hints (("Goal" :use (r-neg-2 r-neg-4
                        (:instance r-pos-3 (x (- q (/ a b))) (y (expt 2 (- (1+ (expo q)) p))))))))

(local-defthm r-neg-6
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp q)
                (exactp q p)
                (< (/ a b) q)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (< (- (* b q) a) (* b (expt 2 (- (1+ (expo q)) p)))))
  :rule-classes ()
  :hints (("Goal" :use (r-neg-5))))

(local-defthm r-neg-10
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (integerp (- (1+ (expo (/ a b))) p))
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp q)
                (rationalp (- a (* b q)))
                (exactp q p)
                (< (/ a b) q)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (< (* (expt 2 (- (- (1+ (expo q)) p))) (- (* b q) a)) b))
  :rule-classes ()
  :hints (("Goal" :use (r-neg-6 expo-q-alt
                        (:instance r-pos-9 (n (- (1+ (expo (/ a b))) p)) (x (- (* b q) a))))
                  :in-theory (theory 'minimal-theory))))

(local-defthm r-neg-11
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp q)
                (exactp q p)
                (< (/ a b) q)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (< (* (expt 2 (- p (1+ (expo q)))) (- (* b q) a)) b))
  :rule-classes ()
  :hints (("Goal" :use (r-neg-10))))

(local-defthm r-neg-17
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (< (/ a b) q)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (exactp (* (expt 2 (- p (1+ (expo q)))) (- (* b q) a)) p))
  :rule-classes ()
  :hints (("Goal" :use (r-exactp-75
                        (:instance minus-exactp (x (- (* b q) a)) (n p))
                        (:instance exactp-shift (n p) (x (- (* b q) a)) (k (- p (1+ (expo q)))))))))

(local-defthm r-neg-18
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (> q (/ a b))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (> (* b q) (* b (/ a b))))
  :rule-classes ()
  :hints (("Goal" :use ((:instance r-pos-3 (y q) (x (/ a b)))))))

(local-defthm r-neg-19
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (< (/ a b) q)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (> (- (* b q) a) 0))
  :rule-classes ()
  :hints (("Goal" :use (r-neg-18))))

(local-defthm r-neg-20
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (< 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (< (/ a b) q)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (<= (* (expt 2 (- p (1+ (expo q)))) (- (* b q) a)) (- b (expt 2 (- 1 p)))))
  :rule-classes ()
  :hints (("Goal" :use (r-neg-11 r-neg-17 r-neg-19
                        (:instance fp-2 (x b) (y (* (expt 2 (- p (1+ (expo q)))) (- (* b q) a))) (n p))))))

(local-defthm r-neg-25
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (< 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (< (/ a b) q)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (< (* (expt 2 (- p (1+ (expo q)))) (- (* b q) a))
              (/ y)))
  :rule-classes ()
  :hints (("Goal" :use (r-pos-16 r-neg-20 r-pos-24))))

(local-defthm r-neg-26
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (= 1 b)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (< (/ a b) q)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (<= (* (expt 2 (- p (1+ (expo q)))) (- (* b q) a)) (- b (expt 2 (- p)))))
  :rule-classes ()
  :hints (("Goal" :use (r-neg-11 r-neg-17 r-neg-19
                        (:instance fp-2 (x b) (y (* (expt 2 (- p (1+ (expo q)))) (- (* b q) a))) (n p))))))

(local-defthm r-neg-28
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (= 1 b)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (< (/ a b) q)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (< (* (expt 2 (- p (1+ (expo q)))) (- (* b q) a))
              (/ y)))
  :rule-classes ()
  :hints (("Goal" :use (r-pos-16 r-neg-26 r-pos-27)
                  :in-theory (theory 'minimal-theory))))

(local-defthm r-neg-29
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (< (/ a b) q)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (< (* (expt 2 (- p (1+ (expo q)))) (- (* b q) a))
              (/ y)))
  :rule-classes ()
  :hints (("Goal" :use (r-neg-28 r-neg-25))))

(local-defthm r-neg-30
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (> (/ y) 0)
                (rationalp (* (expt 2 (+ p (- (+ 1 (expo q))))) (- (* b q) a)))
                (exactp q p)
                (< (/ a b) q)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (< (* y (* (expt 2 (- p (1+ (expo q)))) (- (* b q) a)))
              (* y (/ y))))
  :rule-classes ()
  :hints (("Goal" :use (r-neg-29
                        (:instance r-pos-7 (x (* (expt 2 (- p (1+ (expo q)))) (- (* b q) a))) (z (/ y))))
                  :in-theory (theory 'minimal-theory))))

(local-defthm r-neg-31
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (< (/ a b) q)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (< (* (expt 2 (- p (1+ (expo q)))) (- (* b q) a) y)
              (* (expt 2 (- (- p (1+ (expo q))))) (expt 2 (- p (1+ (expo q)))))))
  :rule-classes ()
  :hints (("Goal" :use (r-neg-30))))

(local-defthm r-neg-32
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (rationalp (* (expt 2 (- p (1+ (expo q)))) (- (* b q) a) y))
                (integerp (- p (1+ (expo q))))
                (rationalp (expt 2 (- (- p (1+ (expo q))))))
                (exactp q p)
                (< (/ a b) q)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (< (* (expt 2 (- (- p (1+ (expo q))))) (* (expt 2 (- p (1+ (expo q)))) (- (* b q) a) y))
              (expt 2 (- (- p (1+ (expo q)))))))
  :rule-classes ()
  :hints (("Goal" :use (r-neg-31
                        (:instance r-pos-9 (x (* (expt 2 (- p (1+ (expo q)))) (- (* b q) a) y))
                                           (n (- p (1+ (expo q))))
                                           (b (expt 2 (- (- p (1+ (expo q))))))))
                  :in-theory (theory 'minimal-theory))))

(local-defthm r-neg-33
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (< (/ a b) q)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (< (* (- (* b q) a) y)
              (expt 2 (- (1+ (expo q)) p))))
  :rule-classes ()
  :hints (("Goal" :use (r-neg-32))))

(local-defthm r-neg-34
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (< (/ a b) q)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (and (> q (+ q (* (- a (* b q)) y)))
                (> (+ q (* (- a (* b q)) y)) (- q (expt 2 (- (1+ (expo q)) p))))
                (> q (/ a b))
                (> (/ a b) (- q (expt 2 (- (1+ (expo q)) p))))))
  :rule-classes ()
  :hints (("Goal" :use (expo-q-alt r-pos-12 r-neg-19 r-neg-33))))

(local-defthm r-neg-directed
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (< (/ a b) q)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (and (= (rtz (+ q (* (- a (* b q)) y)) p)
                   (rtz (/ a b) p))
                (= (rup (+ q (* (- a (* b q)) y)) p)
                   (rup (/ a b) p))
                (= (rdn (+ q (* (- a (* b q)) y)) p)
                   (rdn (/ a b) p))))
  :rule-classes ()
  :hints (("Goal" :use (expo-q-10 r-neg-19 r-neg-34 q-not-expo-q
                        (:instance exactp-fp- (x q) (n p))
                        (:instance fp--non-negative (x q) (n p))
                        (:instance expo-fp- (x q) (n p))
                        (:instance rtz-squeeze (x (/ a b)) (a (- q (expt 2 (- (1+ (expo q)) p)))) (n p))
                        (:instance rtz-squeeze (x (+ q (* (- a (* b q)) y))) (a (- q (expt 2 (- (1+ (expo q)) p)))) (n p))
                        (:instance raz-squeeze (x (/ a b)) (a (- q (expt 2 (- (1+ (expo q)) p)))) (n p))
                        (:instance raz-squeeze (x (+ q (* (- a (* b q)) y))) (a (- q (expt 2 (- (1+ (expo q)) p)))) (n p)))
           :in-theory (disable abs acl2::|(* x (+ y z))|) ; for speed
           )))

(local-defthm not-midpoint-down-1
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp q)
                (exactp q p)
                (< (/ a b) q)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (and (> q (- q (expt 2 (- (expo q) p))))
                (> (- q (expt 2 (- (expo q) p))) (fp- q p))))
  :rule-classes ()
  :hints (("Goal" :use (q-not-expo-q))))

(local-defthm not-midpoint-down-2
  (implies (and (not (zp p))
                (rationalp q))
           (< (EXPT 2 (+ (- P) (EXPO Q)))
              (EXPT 2 (+ 1(- P) (EXPO Q)))))
  :rule-classes ())

(local-defthm not-midpoint-down-3
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp q)
                (exactp q p)
                (< (/ a b) q)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (= (expo (- q (expt 2 (- (expo q) p)))) (expo q)))
  :rule-classes ()
  :hints (("Goal" :use (expo-q-10 q-not-expo-q
                        not-midpoint-down-1
                        (:instance fp--non-negative (x q) (n p))
                        (:instance expo-monotone (y q) (x (- q (expt 2 (- (expo q) p)))))
                        (:instance expo-monotone (y (- q (expt 2 (- (expo q) p)))) (x (fp- q p)))
                        (:instance expo-fp- (x q) (n p))))
          ("Subgoal 1" :use not-midpoint-down-2
                       :in-theory (theory 'minimal-theory))))

(local-defthm not-midpoint-down-4
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp q)
                (exactp q p)
                (< (/ a b) q)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (exactp (- q (expt 2 (- (expo q) p))) (1+ p)))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable exactp2)
                  :use (not-midpoint-down-3
                        (:instance exactp-<= (x q) (m p) (n (1+ p)))))))

(local-defthm not-midpoint-down-5
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp q)
                (exactp q p)
                (< (/ a b) q)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (not (exactp (- q (expt 2 (- (expo q) p))) p)))
  :rule-classes ()
  :hints (("Goal" :use (not-midpoint-down-1 expo-q-10
                        (:instance exactp-fp- (x q) (n p))
                        (:instance expo-fp- (x q) (n p))
                        (:instance fp--non-negative (x q) (n p))
                        (:instance fp+2 (x (fp- q p)) (y (- q (expt 2 (- (expo q) p)))) (n p))))))

(local-defthm not-midpoint-down
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp q)
                (exactp q p)
                (< (/ a b) q)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (not (= (/ a b) (- q (expt 2 (- (expo q) p))))))
  :rule-classes ()
  :hints (("Goal" :use (not-midpoint-down-5 not-midpoint-down-4
                        (:instance exactp-<= (x b) (m p) (n (1+ p)))
                        (:instance exactp-factors (x (/ a b)) (y b) (n p) (k (1+ p)))))))

(local-defthm r-neg-rne-4
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp q)
                (exactp q p)
                (< (/ a b) q)
                (> (/ a b) (- q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (and (rationalp (- q (/ a b)))
                (rationalp (expt 2 (- (expo q) p)))))
  :rule-classes ())

(local-defthm r-neg-rne-5
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp q)
                (exactp q p)
                (< (/ a b) q)
                (> (/ a b) (- q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (< (* b (- q (/ a b))) (* b (expt 2 (- (expo q) p)))))
  :rule-classes ()
  :hints (("Goal" :use (r-neg-4
                        (:instance r-pos-3 (x (- q (/ a b))) (y (expt 2 (- (expo q) p))))))))

(local-defthm r-neg-rne-6
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp q)
                (exactp q p)
                (< (/ a b) q)
                (> (/ a b) (- q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (< (- (* b q) a) (* b (expt 2 (- (expo q) p)))))
  :rule-classes ()
  :hints (("Goal" :use (r-neg-rne-5))))

(local-defthm r-neg-rne-10
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (integerp (- (expo (/ a b)) p))
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp q)
                (rationalp (- (* b q) a))
                (exactp q p)
                (< (/ a b) q)
                (> (/ a b) (- q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (< (* (expt 2 (- (- (expo q) p))) (- (* b q) a)) b))
  :rule-classes ()
  :hints (("Goal" :use (r-neg-rne-6 expo-q-alt
                        (:instance r-pos-9 (n (- (expo (/ a b)) p)) (x (- (* b q) a))))
                  :in-theory (theory 'minimal-theory))))

(local-defthm r-neg-rne-11
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp q)
                (exactp q p)
                (< (/ a b) q)
                (> (/ a b) (- q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (< (* (expt 2 (- p (expo q))) (- (* b q) a)) b))
  :rule-classes ()
  :hints (("Goal" :use (r-neg-rne-10))))

(local-defthm r-neg-rne-17
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (< (/ a b) q)
                (> (/ a b) (- q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (exactp (* (expt 2 (- p (expo q))) (- (* b q) a)) p))
  :rule-classes ()
  :hints (("Goal" :use (r-exactp-75
                        (:instance minus-exactp (x (- (* b q) a)) (n p))
                        (:instance exactp-shift (n p) (x (- (* b q) a)) (k (- p (expo q))))))))

(local-defthm r-neg-rne-20
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (< 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (< (/ a b) q)
                (> (/ a b) (- q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (<= (* (expt 2 (- p (expo q))) (- (* b q) a)) (- b (expt 2 (- 1 p)))))
  :rule-classes ()
  :hints (("Goal" :use (r-neg-rne-11 r-neg-rne-17 r-neg-19
                        (:instance fp-2 (x b) (y (* (expt 2 (- p (expo q))) (- (* b q) a))) (n p))))))

(local-defthm r-neg-rne-25
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (< 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (< (/ a b) q)
                (> (/ a b) (- q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (< (* (expt 2 (- p (expo q))) (- (* b q) a))
              (/ y)))
  :rule-classes ()
  :hints (("Goal" :use (r-pos-16 r-neg-rne-20 r-pos-24))))

(local-defthm r-neg-rne-26
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (= 1 b)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (< (/ a b) q)
                (> (/ a b) (- q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (<= (* (expt 2 (- p (expo q))) (- (* b q) a)) (- b (expt 2 (- p)))))
  :rule-classes ()
  :hints (("Goal" :use (r-neg-rne-11 r-neg-rne-17 r-neg-19
                        (:instance fp-2 (x b) (y (* (expt 2 (- p (expo q))) (- (* b q) a))) (n p))))))

(local-defthm r-neg-rne-28
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (= 1 b)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (< (/ a b) q)
                (> (/ a b) (- q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (< (* (expt 2 (- p (expo q))) (- (* b q) a))
              (/ y)))
  :rule-classes ()
  :hints (("Goal" :use (r-pos-16 r-neg-rne-26 r-pos-27)
                  :in-theory (theory 'minimal-theory))))

(local-defthm r-neg-rne-29
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (< (/ a b) q)
                (> (/ a b) (- q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (< (* (expt 2 (- p (expo q))) (- (* b q) a))
              (/ y)))
  :rule-classes ()
  :hints (("Goal" :use (r-neg-rne-28 r-neg-rne-25))))

(local-defthm r-neg-rne-30
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (> (/ y) 0)
                (rationalp (* (expt 2 (+ p (- (expo q)))) (- (* b q) a)))
                (exactp q p)
                (< (/ a b) q)
                (> (/ a b) (- q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (< (* y (* (expt 2 (- p (expo q))) (- (* b q) a)))
              (* y (/ y))))
  :rule-classes ()
  :hints (("Goal" :use (r-neg-rne-29
                        (:instance r-pos-7 (x (* (expt 2 (- p (expo q))) (- (* b q) a))) (z (/ y))))
                  :in-theory (theory 'minimal-theory))))

(local-defthm r-neg-rne-31
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (< (/ a b) q)
                (> (/ a b) (- q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (< (* (expt 2 (- p (expo q))) (- (* b q) a) y)
              (* (expt 2 (- (- p (expo q)))) (expt 2 (- p (expo q))))))
  :rule-classes ()
  :hints (("Goal" :use (r-neg-rne-30))))

(local-defthm r-neg-rne-32
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (rationalp (* (expt 2 (- p (expo q))) (- (* b q) a) y))
                (integerp (- p (expo q)))
                (rationalp (expt 2 (- (- p (expo q)))))
                (exactp q p)
                (< (/ a b) q)
                (> (/ a b) (- q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (< (* (expt 2 (- (- p (expo q)))) (* (expt 2 (- p (expo q))) (- (* b q) a) y))
              (expt 2 (- (- p (expo q))))))
  :rule-classes ()
  :hints (("Goal" :use (r-neg-rne-31
                        (:instance r-pos-9 (x (* (expt 2 (- p (expo q))) (- (* b q) a) y))
                                           (n (- p (expo q)))
                                           (b (expt 2 (- (- p (expo q)))))))
                  :in-theory (theory 'minimal-theory))))

(local-defthm r-neg-rne-33
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (< (/ a b) q)
                (> (/ a b) (- q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (< (* (- (* b q) a) y)
              (expt 2 (- (expo q) p))))
  :rule-classes ()
  :hints (("Goal" :use (r-neg-rne-32))))

(local-defthm r-neg-rne-34
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (< (/ a b) q)
                (> (/ a b) (- q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (and (> q (+ q (* (- a (* b q)) y)))
                (> (+ q (* (- a (* b q)) y)) (- q (expt 2 (- (expo q) p))))
                (> q (/ a b))
                (> (/ a b) (- q (expt 2 (- (expo q) p))))))
  :rule-classes ()
  :hints (("Goal" :use (expo-q-alt r-pos-12 r-neg-19 r-neg-rne-33))))

(local-defthm r-neg-rne-down
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (< (/ a b) q)
                (> (/ a b) (- q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (= (rne (+ q (* (- a (* b q)) y)) p)
              (rne (/ a b) p)))
  :rule-classes ()
  :hints (("Goal" :in-theory (e/d (near-down-1) (acl2::normalize-factors-gather-exponents
                                                 abs ; for speed
                                                 ))
                  :use (expo-q-10 r-neg-19 r-neg-rne-34 q-not-expo-q
                        (:instance fp--non-negative (x q) (n p))
                        (:instance exactp-fp- (x q) (n p))
                        (:instance expo-fp- (x q) (n p))
                        (:instance rne-up (x (/ a b)) (a (fp- q p)) (n p))
                        (:instance rne-up (x (+ q (* (- a (* b q)) y))) (a (fp- q p)) (n p))))))

(local-defthm r-neg-rne-up-4
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp q)
                (exactp q p)
                (< (/ a b) (- q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (and (rationalp (- q (/ a b)))
                (rationalp (expt 2 (- (1+ (expo q)) p)))))
  :rule-classes ())

(local-defthm r-neg-rne-up-5
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp q)
                (exactp q p)
                (< (/ a b) (- q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (> (* b (- q (/ a b))) (* b (expt 2 (- (expo q) p)))))
  :rule-classes ()
  :hints (("Goal" :use (r-neg-4
                        (:instance r-pos-3 (y (- q (/ a b))) (x (expt 2 (- (expo q) p))))))))

(local-defthm r-neg-rne-up-6
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp q)
                (exactp q p)
                (< (/ a b) (- q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (> (- (* b q) a) (* b (expt 2 (- (expo q) p)))))
  :rule-classes ()
  :hints (("goal" :use (r-neg-rne-up-5))))

(local-defthm r-neg-up-8
  (implies (and (rationalp (* b (expt 2 n)))
                (rationalp x)
                (rationalp (expt 2 (- n)))
                (> (expt 2 (- n)) 0)
                (> x (* b (expt 2 n))))
           (> (* (expt 2 (- n)) x) (* (expt 2 (- n)) (* b (expt 2 n)))))
  :rule-classes ()
  :hints (("Goal" :use ((:instance r-pos-7 (y (expt 2 (- n))) (z x) (x (* b (expt 2 n))))))))

(local-defthm r-neg-up-9
  (implies (and (integerp n)
                (rationalp x)
                (rationalp b)
                (> x (* b (expt 2 n))))
           (> (* (expt 2 (- n)) x) b))
  :rule-classes ()
  :hints (("Goal" :use (r-neg-up-8))))

(local-defthm r-neg-rne-up-10
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (integerp (- (expo (/ a b)) p))
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp q)
                (rationalp (- (* b q) a))
                (exactp q p)
                (< (/ a b) (- q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (> (* (expt 2 (- (- (expo q) p))) (- (* b q) a)) b))
  :rule-classes ()
  :hints (("Goal" :use (r-neg-rne-up-6 expo-q-alt
                        (:instance r-neg-up-9 (n (- (expo (/ a b)) p)) (x (- (* b q) a))))
                  :in-theory (theory 'minimal-theory))))

(local-defthm r-neg-rne-up-11
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp q)
                (exactp q p)
                (< (/ a b) (- q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (> (* (expt 2 (- p (expo q))) (- (* b q) a)) b))
  :rule-classes ()
  :hints (("Goal" :use (r-neg-rne-up-10))))

(local-defthm r-neg-rne-up-17
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (< (/ a b) (- q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (exactp (* (expt 2 (- p (expo q))) (- (* b q) a)) p))
  :rule-classes ()
  :hints (("Goal" :use (r-exactp-75
                        (:instance minus-exactp (x (- (* b q) a)) (n p))
                        (:instance exactp-shift (n p) (x (- (* b q) a)) (k (- p (expo q))))))))

(local-defthm r-neg-rne-up-20
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (< (/ a b) (- q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (>= (* (expt 2 (- p (expo q))) (- (* b q) a)) (+ b (expt 2 (- 1 p)))))
  :rule-classes ()
  :hints (("Goal" :use (r-neg-rne-up-11 r-neg-rne-up-17 r-neg-19
                        (:instance fp+2 (x b) (y (* (expt 2 (- p (expo q))) (- (* b q) a))) (n p))))))

(local-defthm r-neg-up-13
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p))))
            (> (* b y) (- 1 (/ (expt 2 p)))))
  :rule-classes ())

(local-defthm r-neg-up-15
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (rationalp y)
                (rationalp (* b y))
                (> (* b y) 0)
                (rationalp (1+ (/ (expt 2 p))))
                (> (- 1 (/ (expt 2 p))) 0)
                (< (abs (- 1 (* b y))) (/ (expt 2 p))))
            (> (/ b (- 1 (/ (expt 2 p))))
               (/ b (* b y))))
  :rule-classes ()
  :hints (("Goal" :use (r-neg-up-13
                        (:instance r-pos-14 (y (* b y)) (x (- 1 (/ (expt 2 p)))))))))

(local-defthm r-neg-up-16
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p))))
            (> (/ b (- 1 (expt 2 (- p))))
               (/ y)))
  :rule-classes ()
  :hints (("Goal" :use (r-neg-up-15))))

(local-defthm r-neg-up-21
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2))
           (<= (* (expt 2 (- p)) b) (- (expt 2 (- 1 p)) (expt 2 (- 1 (* 2 p))))))
  :rule-classes ()
  :hints (("Goal" :use (r-exactp-25))))

(local-defthm r-neg-up-22
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2))
           (>= (* (- 1 (expt 2 (- p))) (+ b (expt 2 (- 1 p)))) b))
  :rule-classes ()
  :hints (("Goal" :use (r-neg-up-21))))

(local-defthm r-neg-up-23
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2))
           (>= (/ (* (- 1 (expt 2 (- p))) (+ b (expt 2 (- 1 p)))) (- 1 (expt 2 (- p))))
               (/ b (- 1 (expt 2 (- p))))))
  :rule-classes ()
  :hints (("Goal" :use (r-neg-up-22
                        (:instance r-pos-22 (y (* (- 1 (expt 2 (- p))) (+ b (expt 2 (- 1 p)))))
                                            (x  b)
                                            (z (- 1 (expt 2 (- p)))))))))

(local-defthm r-neg-up-24
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2))
           (>= (+ b (expt 2 (- 1 p))) (/ b (- 1 (expt 2 (- p))))))
  :rule-classes ()
  :hints (("Goal" :use (r-neg-up-23))))

(local-defthm r-neg-rne-up-25
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (< (/ a b) (- q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (> (* (expt 2 (- p (expo q))) (- (* b q) a))
              (/ y)))
  :rule-classes ()
  :hints (("Goal" :use (r-neg-up-16 r-neg-rne-up-20 r-neg-up-24))))

(local-defthm r-neg-rne-up-30
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (> (/ y) 0)
                (rationalp (* (expt 2 (+ p (- (expo q)))) (+ a (- (* b q)))))
                (exactp q p)
                (< (/ a b) (- q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (> (* y (* (expt 2 (- p (expo q))) (- (* b q) a)))
              (* y (/ y))))
  :rule-classes ()
  :hints (("Goal" :use (r-neg-rne-up-25
                        (:instance r-pos-7 (z (* (expt 2 (- p (expo q))) (- (* b q) a))) (x (/ y)))))))

(local-defthm r-neg-rne-up-31
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (< (/ a b) (- q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (> (* (expt 2 (- p (expo q))) (- (* b q) a) y) 1))
  :rule-classes ()
  :hints (("Goal" :use (r-neg-rne-up-30))))

(local-defthm r-neg-rne-up-32
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (rationalp (* (expt 2 (- p (expo q))) (- (* b q) a) y))
                (integerp (- p (expo q)))
                (rationalp (expt 2 (- (- p (expo q)))))
                (exactp q p)
                (< (/ a b) (- q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (> (* (- (* b q) a) y) (expt 2 (- (- p (expo q))))))
  :rule-classes ()
  :hints (("Goal" :use (r-neg-rne-up-31
                        (:instance r-pos-9 (x 1)
                                           (n (- p (expo q)))
                                           (b (* (- (* b q) a) y)))))))

(local-defthm r-neg-rne-up-33
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (< (/ a b) (- q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (> (* (- (* b q) a) y)
              (expt 2 (- (expo q) p))))
  :rule-classes ()
  :hints (("Goal" :use (r-neg-rne-up-32))))

(local-defthm r-neg-rne-up-34
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (< (/ a b) (- q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (and (< (+ q (* (- a (* b q)) y)) (- q (expt 2 (- (expo q) p))))
                (> (+ q (* (- a (* b q)) y)) (- q (expt 2 (- (1+ (expo q)) p))))
                (< (/ a b) (- q (expt 2 (- (expo q) p))))
                (> (/ a b) (- q (expt 2 (- (1+ (expo q)) p))))))
  :rule-classes ()
  :hints (("Goal" :use (expo-q-alt r-pos-12 r-neg-19 r-neg-33 r-neg-rne-up-33))))

(local-defthm r-neg-rne-up
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (< (/ a b) (- q (expt 2 (- (expo q) p))))
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p))))
           (= (rne (+ q (* (- a (* b q)) y)) p)
              (rne (/ a b) p)))
  :rule-classes ()
  :hints (("Goal" :in-theory (e/d (near-down-1) (acl2::normalize-factors-gather-exponents
                                                 abs ; for speed
                                                 ))
                  :use (expo-q-10 r-neg-19 r-neg-rne-up-34 q-not-expo-q
                        (:instance fp--non-negative (x q) (n p))
                        (:instance exactp-fp- (x q) (n p))
                        (:instance expo-fp- (x q) (n p))
                        (:instance rne-down (x (/ a b)) (a (fp- q p)) (n p))
                        (:instance rne-down (x (+ q (* (- a (* b q)) y))) (a (fp- q p)) (n p))))))

(local-defthm r-neg-rnd
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (< (/ a b) q)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p)))
                (ieee-rounding-mode-p mode))
           (= (rnd (+ q (* (- a (* b q)) y)) mode p)
              (rnd (/ a b) mode p)))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable rnd ieee-rounding-mode-p)
                  :use (not-midpoint-down r-neg-rne-down r-neg-rne-up r-neg-directed))))

(local-defthm r-rnd-1
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p)))
                (ieee-rounding-mode-p mode))
           (= (rnd (+ q (* (- a (* b q)) y)) mode p)
              (rnd (/ a b) mode p)))
  :rule-classes ()
  :hints (("Goal" :use (r-pos-rnd r-neg-rnd))))

(local-defthm r-rnd-2
  (let ((e (if (> a b) 0 -1))
        (r (- a (* b q))))
    (implies (and (rationalp a)
                  (rationalp b)
                  (not (zp p))
                  (> p 1)
                  (exactp a p)
                  (exactp b p)
                  (<= 1 a)
                  (< a 2)
                  (<= 1 b)
                  (< b 2)
                  (not (= a b))
                  (rationalp y)
                  (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                  (rationalp q)
                  (exactp q p)
                  (< (abs (- (/ a b) q)) (expt 2 (- (1+ e) p)))
                  (ieee-rounding-mode-p mode))
             (= (rnd (+ q (* r y)) mode p)
                (rnd (/ a b) mode p))))
  :rule-classes ()
  :hints (("Goal" :use (r-rnd-1 r-exactp-5 r-exactp-39))))

(local-defthm r-rnd-1
  (implies (and (rationalp a)
                (rationalp b)
                (not (zp p))
                (> p 1)
                (exactp a p)
                (exactp b p)
                (<= 1 a)
                (< a 2)
                (<= 1 b)
                (< b 2)
                (not (= a b))
                (rationalp y)
                (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                (rationalp q)
                (exactp q p)
                (< (abs (- (/ a b) q)) (expt 2 (- (1+ (expo (/ a b))) p)))
                (ieee-rounding-mode-p mode))
           (= (rnd (+ q (* (- a (* b q)) y)) mode p)
              (rnd (/ a b) mode p)))
  :rule-classes ()
  :hints (("Goal" :use (r-pos-rnd r-neg-rnd))))

(local-defthm r-rnd-3
  (implies (and (rationalp a)
                (rationalp s)
                (rationalp q)
                (>= a 1)
                (> s q))
           (> (* a s) (* a q)))
  :rule-classes ())

(local-defthm r-rnd-4
  (implies (and (rationalp a)
                (rationalp q)
                (>= a 1)
                (= a (* a q)))
           (= q 1))
  :rule-classes ()
  :hints (("Goal" :use  ((:instance r-rnd-3 (s 1))
                         (:instance r-rnd-3 (s q) (q 1))))))

(defthm markstein-lemma
  (let ((e (if (> a b) 0 -1))
        (r (- a (* b q))))
    (implies (and (rationalp a)
                  (rationalp b)
                  (rationalp q)
                  (rationalp y)
                  (integerp p)
                  (<= 1 a)
                  (< a 2)
                  (<= 1 b)
                  (< b 2)
                  (> p 1)
                  (exactp a p)
                  (exactp b p)
                  (exactp q p)
                  (< (abs (- 1 (* b y))) (/ (expt 2 p)))
                  (< (abs (- (/ a b) q)) (expt 2 (- (1+ e) p)))
                  (ieee-rounding-mode-p mode))
             (= (rnd (+ q (* r y)) mode p)
                (rnd (/ a b) mode p))))
  :rule-classes ()
  :hints (("Goal" :use (r-rnd-2 expo-q-24 r-rnd-4))))
