Revo.home <- function(component="home")
{
	if (!component %in% c("home", "doc", "licenses"))
		stop("Unknown component.")
	opsys <- version$os
	revoh <- switch(opsys,
 	                "darwin9.4.0" = sub("Revo.*", "Revo", R.home()),
	                "linux-gnu" = system.file("", package="Revobase"),
	                "mingw32" = dirname(R.home()),
	                "intel32" = dirname(R.home()),
	                "intel64" = dirname(R.home()),
	                dirname(dirname(dirname(R.home()))))
	switch(component, home = revoh, file.path(revoh, component))
}
