#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2017 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Pirates
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220709.1

GAME_ID='pirates'
GAME_NAME='Pirates!'

ARCHIVE_BASE_0='gog_pirates_2.0.0.8.sh'
ARCHIVE_BASE_0_MD5='885cdb8f2119a278fb15a32cafad64a8'
ARCHIVE_BASE_0_TYPE='mojosetup'
ARCHIVE_BASE_0_SIZE='12000'
ARCHIVE_BASE_0_VERSION='1.0-gog2.0.0.8'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/pirates_gold_plus'

CONTENT_PATH_DEFAULT='data/noarch/classic/Pirates!'
ARCHIVE_GAME_MAIN_FILES='
*'

APP_MAIN_TYPE='dosbox'
APP_MAIN_EXE='pir.exe'
APP_MAIN_ICON="${CONTENT_PATH_DEFAULT}/../../support/icon.png"

PKG_MAIN_DEPS='dosbox'

# Use persistent storage for user data

DATA_FILES='disks'

# Load common functions

target_version='2.16'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'
prepare_package_layout

# Include game icon

icons_get_from_workdir 'APP_MAIN'

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

launchers_write 'APP_MAIN'

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
