/*###############################################################################
# Linux Management Providers (LMP), SSH provider package
# Copyright (C) 2010 Feng Zhanlei, REDFLAG <fengzhanlei@redflag-linux.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by Guillaume BOTTEX <guillaumebottex@uxsystem.net>, UXSystem, 2010
###############################################################################*/

#include "OpenDRIM_SSHSessionSettingDataAccess.h"

int SSH_OpenDRIM_SSHSessionSettingData_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	/*
	 * for Direct Invocation
	 */
	/*
	CF_assert(SSH_CIM_SettingData_load(broker, errorMessage));
	CF_assert(SSH_CIM_ManagedElement_load(broker, errorMessage));
	*/
	// TODO
	_L_;
	return OK;
}

int SSH_OpenDRIM_SSHSessionSettingData_unload(string& errorMessage) {
	_E_;
	/*
	 * for Direct Invocation
	 */
	/*
	CF_assert(SSH_CIM_SettingData_unload(errorMessage));
	CF_assert(SSH_CIM_ManagedElement_unload(errorMessage));
	*/
	// TODO
	_L_;
	return OK;
}

int SSH_OpenDRIM_SSHSessionSettingData_isAssociated(const Instance& SettingData, const Instance& ManagedElement, bool& isAssociated, string& errorMessage) {
	_E_;
	// TODO Determine if the association can be established or not
	isAssociated=true;
	_L_;
	return OK;
}

int SSH_OpenDRIM_SSHSessionSettingData_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_SSHSessionSettingData>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> subjects;
	// Only get the instance names
	CF_assert(SSH_OpenDRIM_SSHSessionSettingData_enumerateSettingDatas(broker, ctx, subjects, NULL, true, errorMessage));
	// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
	// CF_assert(SSH_OpenDRIM_SSHSessionSettingData_enumerateSettingDatas(broker, ctx, subjects, NULL, false, errorMessage));
	vector<Instance>::iterator c = subjects.begin();
	vector<Instance>::iterator end = subjects.end();
	for (; c != end; ++c) {
		bool leftToRight = true;
		vector<Instance> associatedInstances;
		CF_assert(SSH_OpenDRIM_SSHSessionSettingData_associator(broker, ctx,
			(*c).getObjectpath().getHdl(), (*c),
			SettingData_classnames[0], ManagedElement_classnames[0],
			SettingData_role.c_str(), ManagedElement_role.c_str(), NULL,
			associatedInstances, leftToRight, errorMessage, "an"));

		string ref_discriminant = discriminant == "ein" ? "rn" : "r";
		CF_assert(SSH_OpenDRIM_SSHSessionSettingData_referenceSettingDataToManagedElement(broker, ctx, (*c), associatedInstances, result, NULL, errorMessage, ref_discriminant));
	}
	_L_;
	return OK;
}

int SSH_OpenDRIM_SSHSessionSettingData_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_SSHSessionSettingData& instance, const char** properties, string& errorMessage) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	Objectpath SettingData_objectpath;
	instance.getSettingData(SettingData_objectpath);
	Instance SettingData_instance;
	CF_assert(SSH_OpenDRIM_SSHSessionSettingData_getSettingData(broker, ctx, SettingData_objectpath, SettingData_instance, NULL, errorMessage));
	
	Objectpath ManagedElement_objectpath;
	instance.getManagedElement(ManagedElement_objectpath);
	Instance ManagedElement_instance;
	CF_assert(SSH_OpenDRIM_SSHSessionSettingData_getManagedElement(broker, ctx, ManagedElement_objectpath, ManagedElement_instance, NULL, errorMessage));

	bool isAssociated = false;
	CF_assert(SSH_OpenDRIM_SSHSessionSettingData_isAssociated(SettingData_instance, ManagedElement_instance, isAssociated, errorMessage));
	if (!isAssociated)
	{
		if(errorMessage.empty())
			errorMessage = "No instance";
		
		return NOT_FOUND;
	}
	CF_assert(SSH_OpenDRIM_SSHSessionSettingData_populate(instance, errorMessage));
	_L_;
	return OK;
}

int SSH_OpenDRIM_SSHSessionSettingData_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SSHSessionSettingData& newInstance, const OpenDRIM_SSHSessionSettingData& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int SSH_OpenDRIM_SSHSessionSettingData_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SSHSessionSettingData& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int SSH_OpenDRIM_SSHSessionSettingData_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SSHSessionSettingData& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int SSH_OpenDRIM_SSHSessionSettingData_associatorSettingDataToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& SettingData_instance, const char** properties, vector<Instance>& ManagedElement_associatedInstances, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> ManagedElement_instances;
	if (discriminant=="a")
		CF_assert(SSH_OpenDRIM_SSHSessionSettingData_enumerateManagedElements(broker, ctx, ManagedElement_instances, properties, false, errorMessage));
	if (discriminant=="an") {
		// Only get the instance names
		CF_assert(SSH_OpenDRIM_SSHSessionSettingData_enumerateManagedElements(broker, ctx, ManagedElement_instances, properties, true, errorMessage));
		// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
		// CF_assert(SSH_OpenDRIM_SSHSessionSettingData_enumerateManagedElements(broker, ctx, ManagedElement_instances, properties, false, errorMessage));
	}

	for (size_t i=0; i<ManagedElement_instances.size(); i++) {
		bool isAssociated = false;
		CF_assert(SSH_OpenDRIM_SSHSessionSettingData_isAssociated(SettingData_instance, ManagedElement_instances[i], isAssociated, errorMessage));
		if (isAssociated)
			ManagedElement_associatedInstances.push_back(ManagedElement_instances[i]);
	}
	_L_;
	return OK;
}

int SSH_OpenDRIM_SSHSessionSettingData_associatorManagedElementToSettingData(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const char** properties, vector<Instance>& SettingData_associatedInstances, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> SettingData_instances;
	if (discriminant=="a")
		CF_assert(SSH_OpenDRIM_SSHSessionSettingData_enumerateSettingDatas(broker, ctx, SettingData_instances, properties, false, errorMessage));
	if (discriminant=="an") {
		// Only get the instance names
		CF_assert(SSH_OpenDRIM_SSHSessionSettingData_enumerateSettingDatas(broker, ctx, SettingData_instances, properties, true, errorMessage));
		// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
		// CF_assert(SSH_OpenDRIM_SSHSessionSettingData_enumerateSettingDatas(broker, ctx, SettingData_instances, properties, false, errorMessage));
	}

	for (size_t i=0; i<SettingData_instances.size(); i++) {
		bool isAssociated = false;
		CF_assert(SSH_OpenDRIM_SSHSessionSettingData_isAssociated(SettingData_instances[i], ManagedElement_instance, isAssociated, errorMessage));
		if (isAssociated)
			SettingData_associatedInstances.push_back(SettingData_instances[i]);
	}
	_L_;
	return OK;
}

int SSH_OpenDRIM_SSHSessionSettingData_referenceSettingDataToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& SettingData_instance, const vector<Instance>& ManagedElement_instances, vector<OpenDRIM_SSHSessionSettingData>& OpenDRIM_SSHSessionSettingData_instances, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	for (size_t i=0; i < ManagedElement_instances.size(); i++) {
		OpenDRIM_SSHSessionSettingData instance;
		instance.setSettingData(((Instance) SettingData_instance).getObjectpath());
		instance.setManagedElement(((Instance) ManagedElement_instances[i]).getObjectpath());
			
		if (discriminant == "r") {
			CF_assert(SSH_OpenDRIM_SSHSessionSettingData_populate(instance, errorMessage));
		}
		
		OpenDRIM_SSHSessionSettingData_instances.push_back(instance);
	}
	_L_;
	return OK;
}

int SSH_OpenDRIM_SSHSessionSettingData_referenceManagedElementToSettingData(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const vector<Instance>& SettingData_instances, vector<OpenDRIM_SSHSessionSettingData>& OpenDRIM_SSHSessionSettingData_instances, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	for (size_t i=0; i < SettingData_instances.size(); i++) {
		OpenDRIM_SSHSessionSettingData instance;
		instance.setSettingData(((Instance) SettingData_instances[i]).getObjectpath());
		instance.setManagedElement(((Instance) ManagedElement_instance).getObjectpath());
			
		if (discriminant == "r") {
			CF_assert(SSH_OpenDRIM_SSHSessionSettingData_populate(instance, errorMessage));
		}
		
		OpenDRIM_SSHSessionSettingData_instances.push_back(instance);
	}
	_L_;
	return OK;
}

int SSH_OpenDRIM_SSHSessionSettingData_populate(OpenDRIM_SSHSessionSettingData& instance, string& errorMessage) {
	_E_;
	instance.setIsCurrent(1); // Is Current
	_L_;
	return OK;
}

