/*###############################################################################
# Linux Management Providers (LMP), Physical Asset provider package
# Copyright (C) 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#include "PhysicalAsset_Common.h"

int CF_getComputerSystemPhysicalPackageTag(string& tag,string& errorMessage)
{
	system_information system_info;
	vector<string> dmi_strings;
	string serial_number;

	DS_getProperty(_NAMESPACE, "OpenDRIM_ComputerSystem", "ComputerSystemPhysicalPackage", "OtherIdentifyingInfo", tag, errorMessage);

	if(tag.empty())
	{
		// The tag is set to the system serial number as advised in the CIM Documentation
		CF_assert(SMBIOS_getSystemInformation(system_info,dmi_strings,errorMessage));

		serial_number=CF_trimText(dmi_strings[system_info.serial_number]);

		if(!serial_number.empty())
			tag=serial_number;
		else
			tag="computer-system-physical-package";
		CF_assert(DS_setProperty(_NAMESPACE, "OpenDRIM_ComputerSystem", "ComputerSystemPhysicalPackage", "OtherIdentifyingInfo", tag, errorMessage));
	}

	return OK;
}

int CF_getSystemUUID(string& uuid,string& errorMessage)
{
	system_information system_info;
	vector<string> dmi_strings;
	UUID uuidTest;

	// The tag is set to the system serial number as advised in the CIM Documentation
	CF_assert(SMBIOS_getSystemInformation(system_info,dmi_strings,errorMessage));

	memset(&uuidTest,0xFF,sizeof(UUID));

	if(memcmp(&system_info.uuid,&uuidTest,sizeof(UUID))!=0)
	{
		stringstream sUUID;

		sUUID << uppercase << noshowbase << hex << (unsigned int) system_info.uuid.time_low << "-";
		sUUID << uppercase << noshowbase << hex << (unsigned int) system_info.uuid.time_mid << "-";
		sUUID << uppercase << noshowbase << hex << (unsigned int) system_info.uuid.time_hi_and_version << "-";
		sUUID << uppercase << noshowbase << hex << (unsigned int) system_info.uuid.clock_seq_hi_and_reserved;
		sUUID << uppercase << noshowbase << hex << (unsigned int) system_info.uuid.clock_seq_low << "-";
		for(int i=0;i<6;i++)
			sUUID << uppercase << noshowbase << hex << (unsigned int) system_info.uuid.node[i];

		uuid=sUUID.str();
	}
	else
		uuid="";

	return OK;
}

