/*###############################################################################
# Linux Management Providers (LMP), CPU provider package
# Copyright (C) 2007 Frederic Desmons, ETRI <desmons@etri.re.kr ,desmons_frederic@yahoo.fr>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Rakhimov Rustam, TUIT <rusyasoft@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_PROCESSORCOREACCESS_H_
#define OPENDRIM_PROCESSORCOREACCESS_H_

#include "CPU_Common.h"
#include <SMBIOS.h>

#include "OpenDRIM_ProcessorCore.h"

int CPU_OpenDRIM_ProcessorCore_load(const CMPIBroker* broker, string& errorMessage);

int CPU_OpenDRIM_ProcessorCore_unload(string& errorMessage);

int CPU_OpenDRIM_ProcessorCore_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_ProcessorCore>& instances, const char** properties, string& errorMessage, const string& discriminant);

int CPU_OpenDRIM_ProcessorCore_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_ProcessorCore& instance, const char** properties, string& errorMessage);

int CPU_OpenDRIM_ProcessorCore_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ProcessorCore& newInstance, const OpenDRIM_ProcessorCore& oldInstance, const char** properties, string& errorMessage);

int CPU_OpenDRIM_ProcessorCore_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ProcessorCore& instance, string& errorMessage);

int CPU_OpenDRIM_ProcessorCore_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ProcessorCore& instance, string& errorMessage);

int CPU_OpenDRIM_ProcessorCore_RequestStateChange(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ProcessorCore& instance, unsigned int& returnValue, const OpenDRIM_ProcessorCore_RequestStateChange_In& in, OpenDRIM_ProcessorCore_RequestStateChange_Out& out, string& errorMessage);

int CPU_OpenDRIM_ProcessorCore_populate(OpenDRIM_ProcessorCore& instance, const _processor_topology& cpu_info_processor_information, const _processor_core& processor_core, const _processor_information& SMBIOS_processor_information, bool use_SMBIOS, string& errorMessage);

#endif /*OPENDRIM_PROCESSORCOREACCESS_H_*/
