/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.eclipse.help.search.ISearchDocument;

public class LuceneSearchDocument
implements ISearchDocument {
    private Document doc;

    public LuceneSearchDocument(Document document) {
        this.doc = document;
    }

    public void setTitle(String title) {
        this.doc.add((Fieldable)new Field("title", title, Field.Store.NO, Field.Index.ANALYZED));
        this.doc.add((Fieldable)new Field("exact_title", title, Field.Store.NO, Field.Index.ANALYZED));
        this.doc.add((Fieldable)new Field("raw_title", title, Field.Store.YES, Field.Index.NO));
    }

    public void setSummary(String summary) {
        this.doc.add((Fieldable)new Field("summary", summary, Field.Store.YES, Field.Index.NO));
    }

    public void addContents(String contents) {
        this.doc.add((Fieldable)new Field("contents", (Reader)new StringReader(contents)));
        this.doc.add((Fieldable)new Field("exact_contents", (Reader)new StringReader(contents)));
    }

    public void setHasFilters(boolean hasFilters) {
        this.doc.add((Fieldable)new Field("filters", Boolean.toString(hasFilters), Field.Store.YES, Field.Index.NO));
    }

    public Document getDocument() {
        return this.doc;
    }

    public void addContents(Reader contents, Reader exactContents) {
        this.doc.add((Fieldable)new Field("contents", contents));
        this.doc.add((Fieldable)new Field("exact_contents", exactContents));
    }
}

