/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.elements.adapters;

import com.ibm.icu.text.MessageFormat;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.math.BigInteger;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.model.IDisassemblyInstruction;
import org.eclipse.cdt.debug.core.model.IDisassemblySourceLine;
import org.eclipse.cdt.debug.internal.ui.disassembly.editor.DisassemblyEditorPresentation;
import org.eclipse.cdt.debug.ui.disassembly.IDocumentElementLabelProvider;
import org.eclipse.cdt.debug.ui.disassembly.IDocumentElementLabelUpdate;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;

public class DisassemblyElementLabelProvider
implements IDocumentElementLabelProvider {
    @Override
    public void update(final IDocumentElementLabelUpdate[] updates) {
        Job job = new Job("Label update"){

            protected IStatus run(IProgressMonitor monitor) {
                int i = 0;
                while (i < updates.length) {
                    IDocumentElementLabelUpdate update = updates[i];
                    if (!update.isCanceled()) {
                        DisassemblyElementLabelProvider.this.retrieveLabel(update);
                    }
                    update.done();
                    ++i;
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    protected void retrieveLabel(IDocumentElementLabelUpdate update) {
        IPresentationContext context = update.getPresentationContext();
        if (context instanceof DisassemblyEditorPresentation) {
            DisassemblyEditorPresentation presentation = (DisassemblyEditorPresentation)context;
            Object element = update.getElement();
            if (element instanceof IDisassemblyInstruction) {
                IDisassemblyInstruction instruction = (IDisassemblyInstruction)element;
                StringBuilder sb = new StringBuilder();
                if (presentation.showAddresses()) {
                    BigInteger address = instruction.getAdress().getValue();
                    sb.append("0x");
                    sb.append(CDebugUtils.prependString((String)Long.toHexString(address.longValue()), (int)8, (char)'0'));
                    sb.append('\t');
                }
                sb.append(instruction.getInstructionText());
                update.setLabel("lineLabel", sb.toString());
            } else if (element instanceof IDisassemblySourceLine) {
                IDisassemblySourceLine line = (IDisassemblySourceLine)element;
                StringBuilder sb = new StringBuilder();
                if (presentation.showLineNumbers()) {
                    sb.append(line.getLineNumber());
                    sb.append('\t');
                }
                sb.append(this.getSourceLineText(line));
                update.setLabel("lineLabel", sb.toString());
            }
        }
    }

    private String getSourceLineText(IDisassemblySourceLine line) {
        ISourceLookupDirector director;
        Object sourceElement;
        File file = line.getFile();
        String text = MessageFormat.format((String)"File {0} not found.", (Object[])new Object[]{file.getPath()});
        ISourceLocator locator = line.getDebugTarget().getLaunch().getSourceLocator();
        if (locator instanceof ISourceLookupDirector && (sourceElement = (director = (ISourceLookupDirector)locator).getSourceElement((Object)file.getPath())) != null) {
            File lookupFile = null;
            if (sourceElement instanceof IFile) {
                lookupFile = ((IFile)sourceElement).getLocation().toFile();
            } else if (sourceElement instanceof IStorage) {
                lookupFile = ((IStorage)sourceElement).getFullPath().toFile();
            }
            if (lookupFile != null) {
                try {
                    text = this.readLine(lookupFile, line.getLineNumber() - 1);
                }
                catch (IOException e) {
                    text = e.getLocalizedMessage();
                }
            }
        }
        return text;
    }

    private String readLine(File file, int lineNumber) throws IOException {
        FileReader fr = new FileReader(file);
        try (BufferedReader br = new BufferedReader(fr);){
            int count = 0;
            String result = null;
            do {
                result = br.readLine();
                if (count++ != lineNumber) continue;
                String string = result;
                return string;
            } while (result != null);
        }
        throw new IOException(MessageFormat.format((String)"Line {0} doesn't exist in {1}.", (Object[])new Object[]{lineNumber, file.getPath()}));
    }
}

