/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui.analysis;

import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.analysis.AnalysisResultKernelPriority;
import com.nvidia.viper.model.IModel;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.TimelineIntervalPair;
import com.nvidia.viper.ui.analysis.AnalysisResultControl;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TableColumn;

public class KernelPriorityResultControl
extends AnalysisResultControl {
    private TableViewer tableViewer;
    private TableSelectionListener tableListener;

    public KernelPriorityResultControl(Composite parent, AnalysisResult result, Session session) {
        super(parent, result, session);
    }

    @Override
    protected boolean allowsSelection() {
        return false;
    }

    @Override
    protected boolean hasExtension() {
        return true;
    }

    @Override
    protected void createExtension(Composite parent) {
        this.tableViewer = new TableViewer(parent, 67584);
        this.tableViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.tableViewer.setContentProvider((IContentProvider)new PriorityContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new PriorityLabelProvider());
        this.tableViewer.getTable().setHeaderVisible(true);
        this.tableViewer.getTable().setLinesVisible(true);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer);
        this.tableListener = new TableSelectionListener();
        this.tableViewer.addSelectionChangedListener((ISelectionChangedListener)this.tableListener);
        TableColumn priorityColumn = new TableColumn(this.tableViewer.getTable(), 131072);
        priorityColumn.setText("Rank");
        priorityColumn.setResizable(true);
        TableColumn descColumn = new TableColumn(this.tableViewer.getTable(), 16384);
        descColumn.setText("Description");
        descColumn.setResizable(true);
        this.tableViewer.setInput((Object)this.getKernelPriorityResult());
        this.updatePrioritySelection();
        priorityColumn.pack();
        descColumn.pack();
    }

    private AnalysisResultKernelPriority getKernelPriorityResult() {
        return (AnalysisResultKernelPriority)this.result;
    }

    private void handlePrioritySelection(AnalysisResultKernelPriority.PriorityRecord priority) {
        List<TimelineIntervalPair> pairs = priority.getIntervals();
        if (pairs != null && !pairs.isEmpty()) {
            if (!this.isSelected(pairs)) {
                TimelineIntervalPair primary = pairs.get(0);
                List<TimelineIntervalPair> secondary = pairs.subList(1, pairs.size());
                this.activeSession.setPrimaryAndSecondarySelected(primary, secondary, false, true);
            }
        } else {
            this.activeSession.setPrimarySelected(null, true);
        }
    }

    private boolean isSelected(Collection<TimelineIntervalPair> pairs) {
        Collection<TimelineIntervalPair> selected = this.activeSession.getAllSelected();
        return selected != null && selected.contains(pairs);
    }

    @Override
    public boolean grabsVerticalSpace() {
        return false;
    }

    @Override
    public void propertyChange(IModel model, String propertyName) {
        super.propertyChange(model, propertyName);
        if ("session:sInterval".equals(propertyName)) {
            this.updatePrioritySelection();
        }
    }

    private void updatePrioritySelection() {
        this.tableViewer.removeSelectionChangedListener((ISelectionChangedListener)this.tableListener);
        TimelineIntervalPair pair = this.activeSession.getPrimarySelected();
        if (pair != null) {
            ITimelineInterval interval = pair.getInterval(this.activeSession);
            AnalysisResultKernelPriority priorityResult = this.getKernelPriorityResult();
            AnalysisResultKernelPriority.PriorityRecord record = priorityResult.getPriorityRecord(interval);
            this.tableViewer.setSelection((ISelection)(record == null ? null : new StructuredSelection((Object)record)));
        } else {
            this.tableViewer.setSelection(null);
        }
        this.tableViewer.addSelectionChangedListener((ISelectionChangedListener)this.tableListener);
    }

    private class PriorityContentProvider
    implements IStructuredContentProvider {
        private final Object[] EMPTY_ARRAY = new Object[0];

        private PriorityContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            AnalysisResultKernelPriority result = KernelPriorityResultControl.this.getKernelPriorityResult();
            if (result != null) {
                return result.getPriorityRecords();
            }
            return this.EMPTY_ARRAY;
        }

        public void dispose() {
        }
    }

    private class PriorityLabelProvider
    extends StyledCellLabelProvider {
        private PriorityLabelProvider() {
        }

        public boolean useNativeToolTip(Object object) {
            return true;
        }

        public String getToolTipText(Object element) {
            if (element instanceof AnalysisResultKernelPriority.PriorityRecord) {
                return ((AnalysisResultKernelPriority.PriorityRecord)element).getTooltip();
            }
            return null;
        }

        public void update(ViewerCell cell) {
            Object[] newStyleRanges;
            StyledString styledString = this.getStyledText(cell.getElement(), cell.getColumnIndex());
            String newText = styledString.toString();
            Object[] oldStyleRanges = cell.getStyleRanges();
            Object[] objectArray = newStyleRanges = this.isOwnerDrawEnabled() ? styledString.getStyleRanges() : null;
            if (!Arrays.equals(oldStyleRanges, newStyleRanges)) {
                cell.setStyleRanges((StyleRange[])newStyleRanges);
                if (cell.getText().equals(newText)) {
                    cell.setText("");
                }
            }
            cell.setText(newText);
        }

        private StyledString getStyledText(Object element, int columnIndex) {
            String text = null;
            if (element instanceof AnalysisResultKernelPriority.PriorityRecord) {
                AnalysisResultKernelPriority.PriorityRecord record = (AnalysisResultKernelPriority.PriorityRecord)element;
                if (columnIndex == 0) {
                    long priority = record.getPriority();
                    text = Long.toString(priority);
                } else if (columnIndex == 1) {
                    text = record.getName();
                }
            }
            return new StyledString(text);
        }
    }

    private final class TableSelectionListener
    implements ISelectionChangedListener {
        private TableSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            Object el;
            ISelection sel = event.getSelection();
            if (sel instanceof IStructuredSelection && (el = ((IStructuredSelection)sel).getFirstElement()) instanceof AnalysisResultKernelPriority.PriorityRecord) {
                KernelPriorityResultControl.this.handlePrioritySelection((AnalysisResultKernelPriority.PriorityRecord)el);
            }
        }
    }
}

