/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.analysis;

import com.nvidia.viper.ViperHelp;
import com.nvidia.viper.analysis.AnalysisDescriptor;
import com.nvidia.viper.analysis.AnalysisResultInterval;
import com.nvidia.viper.analysis.ResultOutput;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.value.IValue;
import com.nvidia.viper.value.ValuePercent;
import org.eclipse.jface.action.Action;

public class AnalysisResultBlockSize
extends AnalysisResultInterval<Double> {
    private long totalKernelTime = 0L;

    public AnalysisResultBlockSize(Session session, AnalysisDescriptor desc) {
        super(session, desc);
    }

    public void setTotalKernelTime(long totalKernelTime) {
        this.totalKernelTime = totalKernelTime;
    }

    @Override
    public String getDetails(ResultOutput otpt) {
        if (this.totalKernelTime > 0L) {
            double effAvg = 0.0;
            long effTime = 0L;
            for (ITimelineInterval interval : this.intervals.keySet()) {
                Double eff = (Double)this.getData(interval);
                if (eff == null) continue;
                effAvg += eff.doubleValue();
                effTime += interval.getDuration();
            }
            ValuePercent effValue = new ValuePercent((effAvg /= (double)this.getIntervalCount()) * 100.0);
            double effTimeAvg = (double)effTime / (double)this.totalKernelTime;
            ValuePercent effTimeValue = new ValuePercent(effTimeAvg * 100.0);
            return String.valueOf(effValue.toString()) + " avg efficiency, for kernels accounting for " + effTimeValue.toString() + " of compute";
        }
        return null;
    }

    @Override
    public IValue getValue(ITimelineInterval interval) {
        Double overhead = (Double)this.getData(interval);
        if (overhead == null) {
            return null;
        }
        return new ValuePercent(overhead);
    }

    @Override
    public String getValueDescription(ITimelineInterval interval) {
        return null;
    }

    @Override
    public Action getMoreAction() {
        return new Action(){

            public void run() {
                ViperHelp.displayHelp(ViperHelp.OCCUPANCY_BLOCK);
            }
        };
    }
}

