/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.actions;

import com.nvidia.viper.model.IModel;
import com.nvidia.viper.model.ISessionPropertyChangeListener;
import com.nvidia.viper.ui.SessionEditor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;

public abstract class DependencyAnalysisBaseAction
extends Action {
    private SessionEditor editor;

    public DependencyAnalysisBaseAction(SessionEditor editor, String text, int style) {
        super(text, style);
        this.init(editor);
    }

    public DependencyAnalysisBaseAction(SessionEditor editor, String text, ImageDescriptor image) {
        super(text, image);
        this.init(editor);
    }

    private void init(SessionEditor editor) {
        this.editor = editor;
        this.setEnabled(this.isCriticalPathPresent());
        if (editor != null && editor.getSession() != null) {
            editor.getSession().addPropertyChangeListener(new ISessionPropertyChangeListener(){

                @Override
                public void propertyChange(IModel model, String propertyName) {
                    if ("session:analysis".equals(propertyName)) {
                        DependencyAnalysisBaseAction.this.setEnabled(DependencyAnalysisBaseAction.this.isCriticalPathPresent());
                    }
                }
            });
        }
    }

    protected SessionEditor getEditor() {
        return this.editor;
    }

    protected boolean isCriticalPathPresent() {
        return this.editor.getSession().getCriticalPath() != null;
    }
}

