/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import org.eclipse.cdt.utils.spawner.ProcessFactory;

public class CPPFilt {
    private String[] args;
    private Process cppfilt;
    private BufferedReader stdout;
    private BufferedWriter stdin;

    public CPPFilt(String command, String[] params) throws IOException {
        this.init(command, params);
    }

    public CPPFilt(String command) throws IOException {
        this(command, new String[0]);
    }

    public CPPFilt() throws IOException {
        this("c++filt");
    }

    protected void init(String command, String[] params) throws IOException {
        if (params == null || params.length == 0) {
            this.args = new String[]{command};
        } else {
            this.args = new String[params.length + 1];
            this.args[0] = command;
            System.arraycopy(params, 0, this.args, 1, params.length);
        }
        this.cppfilt = ProcessFactory.getFactory().exec(this.args);
        this.stdin = new BufferedWriter(new OutputStreamWriter(this.cppfilt.getOutputStream()));
        this.stdout = new BufferedReader(new InputStreamReader(this.cppfilt.getInputStream()));
    }

    public String getFunction(String symbol) throws IOException {
        this.stdin.write(String.valueOf(symbol) + "\n");
        this.stdin.flush();
        String str = this.stdout.readLine();
        if (str != null) {
            return str.trim();
        }
        throw new IOException();
    }

    public void dispose() {
        try {
            this.stdout.close();
            this.stdin.close();
            this.cppfilt.getErrorStream().close();
        }
        catch (IOException iOException) {}
        this.cppfilt.destroy();
    }
}

