/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.core.dom.properties.css2;

import org.eclipse.e4.ui.css.core.css2.CSS2ColorHelper;
import org.eclipse.e4.ui.css.core.dom.properties.AbstractCSSPropertyCompositeHandler;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;

public abstract class AbstractCSSPropertyBorderCompositeHandler
extends AbstractCSSPropertyCompositeHandler {
    private static final String[] BORDER_CSSPROPERTIES = new String[]{"border-width", "border-style", "border-color"};

    @Override
    public void applyCSSProperty(Object element, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        if (value.getCssValueType() == 1) {
            CSSPrimitiveValue primitiveValue = (CSSPrimitiveValue)value;
            short type = primitiveValue.getPrimitiveType();
            switch (type) {
                case 21: {
                    if (CSS2ColorHelper.isColorName(primitiveValue.getStringValue())) {
                        engine.applyCSSProperty(element, "border-color", value, pseudo);
                        break;
                    }
                    engine.applyCSSProperty(element, "border-style", value, pseudo);
                    break;
                }
                case 25: {
                    engine.applyCSSProperty(element, "border-color", value, pseudo);
                    break;
                }
                case 1: 
                case 5: 
                case 9: {
                    engine.applyCSSProperty(element, "border-width", value, pseudo);
                }
            }
        }
    }

    @Override
    public boolean isCSSPropertyComposite(String property) {
        return "border".equals(property);
    }

    @Override
    public String[] getCSSPropertiesNames(String property) {
        if ("border".equals(property)) {
            return BORDER_CSSPROPERTIES;
        }
        return null;
    }
}

