/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper;

import java.text.NumberFormat;

public class FlopsFormatter {
    public static final String FORMAT_FLOPS = "FLOP/s";
    public static final String FORMAT_KFLOPS = "KiloFLOP/s";
    public static final String FORMAT_MFLOPS = "MegaFLOP/s";
    public static final String FORMAT_GFLOPS = "GigaFLOP/s";
    public static final String FORMAT_TFLOPS = "TeraFLOP/s";
    private String format = null;
    private long divisor = 1L;
    private static NumberFormat formatter = NumberFormat.getInstance();

    static {
        formatter.setMaximumFractionDigits(3);
    }

    public FlopsFormatter() {
    }

    public FlopsFormatter(long frequency) {
        this.initFormat(frequency);
    }

    public String format(long flops) {
        return this.format(flops, true);
    }

    public String format(long flops, boolean group) {
        if (this.format == null) {
            this.initFormat(flops);
        }
        formatter.setGroupingUsed(group);
        double fsize = (double)flops / (double)this.divisor;
        return String.valueOf(formatter.format(fsize)) + " " + this.format;
    }

    protected void initFormat(long ns) {
        if (ns < 1000L) {
            this.format = FORMAT_FLOPS;
            this.divisor = 1L;
        } else if (ns < 1000000L) {
            this.format = FORMAT_KFLOPS;
            this.divisor = 1000L;
        } else if (ns < 1000000000L) {
            this.format = FORMAT_MFLOPS;
            this.divisor = 1000000L;
        } else if (ns < 1000000000000L) {
            this.format = FORMAT_GFLOPS;
            this.divisor = 1000000000L;
        } else {
            this.format = FORMAT_TFLOPS;
            this.divisor = 1000000000000L;
        }
    }
}

