/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core;

import java.io.IOException;
import java.io.StringReader;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IDebugTarget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CSettingsManager {
    private static final String CONTENT_LIST = "contentList";
    private static final String CONTENT = "content";
    private static final String ATTR_CONTENT_ID = "id";
    private static final String ATTR_CONTENT_VALUE = "val";
    private static int MAX_ELEMENT_COUNT = 100;
    private Map fContentMap = new LinkedHashMap(MAX_ELEMENT_COUNT, 0.75f, true){
        private static final long serialVersionUID = 1L;

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > MAX_ELEMENT_COUNT;
        }
    };
    private CDebugTarget fDebugTarget;

    public synchronized void putValue(String id, String value) {
        this.fContentMap.put(id, value);
    }

    public synchronized void removeValue(String id) {
        this.fContentMap.remove(id);
    }

    public synchronized String getValue(String id) {
        String entry = (String)this.fContentMap.get(id);
        return entry;
    }

    public CSettingsManager(CDebugTarget debugTarget) {
        this.fDebugTarget = debugTarget;
        this.initialize();
    }

    private String getMemento() {
        Document document = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element node = document.createElement(CONTENT_LIST);
            document.appendChild(node);
            Set entrySet = this.fContentMap.entrySet();
            for (Map.Entry entry : entrySet) {
                String id = (String)entry.getKey();
                String value = (String)entry.getValue();
                Element child = document.createElement(CONTENT);
                child.setAttribute(ATTR_CONTENT_ID, id);
                child.setAttribute(ATTR_CONTENT_VALUE, value);
                node.appendChild(child);
            }
            return CDebugUtils.serializeDocument(document, false);
        }
        catch (ParserConfigurationException e) {
            DebugPlugin.log((Throwable)e);
        }
        catch (IOException e) {
            DebugPlugin.log((Throwable)e);
        }
        catch (TransformerException e) {
            DebugPlugin.log((Throwable)e);
        }
        return null;
    }

    private void initializeFromMemento(String memento) throws CoreException {
        try {
            this.fContentMap.clear();
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            StringReader reader = new StringReader(memento);
            InputSource source = new InputSource(reader);
            Element root = parser.parse(source).getDocumentElement();
            if (root.getNodeName().equalsIgnoreCase(CONTENT_LIST)) {
                NodeList list = root.getChildNodes();
                int i = list.getLength() - 1;
                while (i >= 0) {
                    Element elem;
                    Node node = list.item(i);
                    short type = node.getNodeType();
                    if (type == 1 && (elem = (Element)node).getNodeName().equalsIgnoreCase(CONTENT)) {
                        String id = elem.getAttribute(ATTR_CONTENT_ID);
                        String value = elem.getAttribute(ATTR_CONTENT_VALUE);
                        if (id == null || id.length() == 0) {
                            DebugPlugin.logMessage((String)"unexpected entry in CSettingsManager.initializeFromMemento", null);
                        } else {
                            this.putValue(id, value);
                        }
                    }
                    --i;
                }
                return;
            }
            DebugPlugin.logMessage((String)"unexpected content", null);
        }
        catch (ParserConfigurationException e) {
            DebugPlugin.log((Throwable)e);
        }
        catch (SAXException e) {
            DebugPlugin.log((Throwable)e);
        }
        catch (IOException e) {
            DebugPlugin.log((Throwable)e);
        }
    }

    private void initialize() {
        ILaunchConfiguration config = this.getDebugTarget().getLaunch().getLaunchConfiguration();
        try {
            String memento = config.getAttribute("org.eclipse.cdt.launch.FORMAT", "");
            if (memento != null && memento.trim().length() != 0) {
                this.initializeFromMemento(memento);
            }
        }
        catch (CoreException e) {
            DebugPlugin.log((Throwable)e);
        }
    }

    public synchronized void save() {
        ILaunchConfiguration config = this.getDebugTarget().getLaunch().getLaunchConfiguration();
        try {
            ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
            wc.setAttribute("org.eclipse.cdt.launch.FORMAT", this.getMemento());
            wc.doSave();
        }
        catch (CoreException e) {
            DebugPlugin.log((Throwable)e);
        }
    }

    IDebugTarget getDebugTarget() {
        return this.fDebugTarget;
    }
}

