/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.macho;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ISymbolReader;
import org.eclipse.cdt.utils.CPPFilt;
import org.eclipse.cdt.utils.debug.stabs.StabsReader;
import org.eclipse.cdt.utils.macho.ERandomAccessFile;

public class MachO64 {
    protected ERandomAccessFile efile;
    protected MachOhdr mhdr;
    protected LoadCommand[] loadcommands;
    protected boolean cppFiltEnabled = true;
    protected CPPFilt cppFilt;
    protected String file;
    protected boolean debugsym = false;
    protected boolean b64 = false;
    private Symbol[] symbols;
    private Symbol[] local_symbols;
    private boolean dynsym = false;
    Line[] lines;
    private ArrayList<Section> sections = new ArrayList();
    SymtabCommand symtab;
    protected static final String EMPTY_STRING = "";
    protected static final SymbolComparator symbol_comparator = new SymbolComparator();

    private static final int makeInt(byte[] val, int offset, boolean isle) throws IOException {
        if (val.length < offset + 4) {
            throw new IOException();
        }
        if (isle) {
            return (val[offset + 3] & 0xFF) << 24 | (val[offset + 2] & 0xFF) << 16 | (val[offset + 1] & 0xFF) << 8 | val[offset + 0] & 0xFF;
        }
        return (val[offset + 0] & 0xFF) << 24 | (val[offset + 1] & 0xFF) << 16 | (val[offset + 2] & 0xFF) << 8 | val[offset + 3] & 0xFF;
    }

    private void commonSetup(String file, long offset, boolean filton) throws IOException {
        this.cppFiltEnabled = filton;
        try {
            this.efile = new ERandomAccessFile(file, "r");
            this.efile.setFileOffset(offset);
            this.mhdr = new MachOhdr();
            this.file = file;
        }
        finally {
            if (this.mhdr == null) {
                this.dispose();
            }
        }
    }

    protected String string_from_macho_symtab(SymtabCommand symtab, int index) throws IOException {
        if (index > symtab.strsize) {
            return EMPTY_STRING;
        }
        this.efile.seek(symtab.stroff + index);
        return this.getCStr();
    }

    private Line getLine(long value) {
        if (!this.debugsym || this.lines == null) {
            return null;
        }
        int ndx = Arrays.binarySearch(this.lines, new Long(value));
        if (ndx >= 0) {
            return this.lines[ndx];
        }
        if (ndx == -1) {
            return null;
        }
        ndx = -ndx - 1;
        int l = ndx - 1;
        while (l < this.lines.length) {
            Line line = this.lines[l];
            if (value <= line.address) {
                return line;
            }
            ++l;
        }
        return null;
    }

    protected MachO64() {
    }

    public MachO64(String file, long offset) throws IOException {
        this.commonSetup(file, offset, true);
    }

    public MachO64(String file) throws IOException {
        this.commonSetup(file, 0L, true);
    }

    public MachO64(String file, long offset, boolean filton) throws IOException {
        this.commonSetup(file, offset, filton);
    }

    public MachO64(String file, boolean filton) throws IOException {
        this.commonSetup(file, 0L, filton);
    }

    public boolean cppFilterEnabled() {
        return this.cppFiltEnabled;
    }

    public void setCppFilter(boolean enabled) {
        this.cppFiltEnabled = enabled;
    }

    public MachOhdr getMachOhdr() throws IOException {
        return this.mhdr;
    }

    public Attribute getAttributes() throws IOException {
        Attribute attrib = new Attribute();
        switch (this.mhdr.filetype) {
            case 1: {
                attrib.type = 1;
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: {
                attrib.type = 2;
                break;
            }
            case 4: {
                attrib.type = 3;
                break;
            }
            case 3: 
            case 6: {
                attrib.type = 4;
            }
        }
        switch (this.mhdr.cputype) {
            case 0x1000007: {
                attrib.cpu = "x86_64";
                break;
            }
            case 7: {
                attrib.cpu = "x86";
                break;
            }
            case 18: {
                attrib.cpu = "ppc";
                break;
            }
            case 1: {
                attrib.cpu = "vax";
                break;
            }
            case 6: {
                attrib.cpu = "m68k";
                break;
            }
            case 10: {
                attrib.cpu = "98000";
                break;
            }
            case 13: {
                attrib.cpu = "88000";
                break;
            }
            case 11: {
                attrib.cpu = "hp";
                break;
            }
            case 14: {
                attrib.cpu = "sparc";
                break;
            }
            case 15: {
                attrib.cpu = "i860";
                break;
            }
            default: {
                attrib.cpu = "any";
            }
        }
        switch (this.mhdr.magic) {
            case -822415874: 
            case -805638658: {
                attrib.isle = true;
                break;
            }
            case -17958194: 
            case -17958193: {
                attrib.isle = false;
            }
        }
        if (this.debugsym) {
            attrib.debugType = 1;
        }
        return attrib;
    }

    public static Attribute getAttributes(String file) throws IOException {
        MachO64 macho = new MachO64(file);
        Attribute attrib = macho.getAttributes();
        macho.dispose();
        return attrib;
    }

    public static Attribute getAttributes(byte[] array) throws IOException {
        MachO64 emptyMachO;
        MachO64 machO64 = emptyMachO = new MachO64();
        machO64.getClass();
        emptyMachO.mhdr = machO64.new MachOhdr(array);
        Attribute attrib = emptyMachO.getAttributes();
        emptyMachO.dispose();
        return attrib;
    }

    public static boolean isMachOHeader(byte[] bytes) {
        try {
            int magic = MachO64.makeInt(bytes, 0, false);
            return magic == -17958194 || magic == -822415874 || magic == -889275714 || magic == -805638658 || magic == -17958193;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void dispose() {
        if (this.cppFilt != null) {
            this.cppFilt.dispose();
        }
        try {
            if (this.efile != null) {
                this.efile.close();
                this.efile = null;
            }
        }
        catch (IOException iOException) {}
    }

    protected void finalize() throws Throwable {
        try {
            this.dispose();
        }
        finally {
            super.finalize();
        }
    }

    private void loadSymbolTable() throws IOException {
        if (this.loadcommands == null) {
            return;
        }
        DySymtabCommand dysymtab = null;
        LoadCommand[] loadCommandArray = this.loadcommands;
        int n = this.loadcommands.length;
        int n2 = 0;
        while (n2 < n) {
            LoadCommand loadcommand = loadCommandArray[n2];
            switch (loadcommand.cmd) {
                case 2: {
                    this.symtab = (SymtabCommand)loadcommand;
                    this.efile.seek(this.symtab.symoff);
                    ArrayList<Symbol> symList = new ArrayList<Symbol>(this.symtab.nsyms);
                    int s = 0;
                    while (s < this.symtab.nsyms) {
                        Symbol symbol = new Symbol();
                        symbol.is64 = this.b64;
                        symbol.n_strx = this.efile.readIntE();
                        symbol.n_type = (byte)this.efile.readUnsignedByte();
                        symbol.n_sect = (byte)this.efile.readUnsignedByte();
                        symbol.n_desc = this.efile.readShortE();
                        symbol.n_value = this.b64 ? this.efile.readLongE() : (long)this.efile.readIntE();
                        symList.add(symbol);
                        if ((symbol.n_type & 0xE0) != 0) {
                            this.debugsym = true;
                        }
                        ++s;
                    }
                    this.symbols = symList.toArray(new Symbol[0]);
                    break;
                }
                case 11: {
                    dysymtab = (DySymtabCommand)loadcommand;
                }
            }
            ++n2;
        }
        if (dysymtab != null) {
            ArrayList<Symbol> symList = new ArrayList<Symbol>(dysymtab.nlocalsym);
            int s = dysymtab.ilocalsym;
            while (s < dysymtab.nlocalsym) {
                symList.add(this.symbols[s]);
                ++s;
            }
            this.local_symbols = symList.toArray(new Symbol[0]);
        }
    }

    private void loadLineTable() {
        if (this.symbols == null) {
            return;
        }
        int nlines = 0;
        Symbol[] symbolArray = this.symbols;
        int n = this.symbols.length;
        int n2 = 0;
        while (n2 < n) {
            Symbol symbol = symbolArray[n2];
            if (symbol.n_type == 68 || symbol.n_type == 36) {
                ++nlines;
            }
            ++n2;
        }
        if (nlines == 0) {
            return;
        }
        HashMap<Line, Line> lineList = new HashMap<Line, Line>(nlines);
        Symbol[] symbolArray2 = this.symbols;
        int n3 = this.symbols.length;
        n = 0;
        while (n < n3) {
            Symbol sym = symbolArray2[n];
            if (sym.n_type == 68 || sym.n_type == 36) {
                Line lentry = new Line();
                lentry.address = sym.n_value;
                lentry.lineno = sym.n_desc;
                Line lookup = (Line)lineList.get(lentry);
                if (lookup != null) {
                    lentry = lookup;
                } else {
                    lineList.put(lentry, lentry);
                }
                if (lentry.function == null && sym.n_type == 36) {
                    int colon;
                    String func = sym.toString();
                    lentry.function = func != null && func.length() > 0 ? ((colon = func.indexOf(58)) > 0 ? func.substring(0, colon) : func) : EMPTY_STRING;
                }
            }
            ++n;
        }
        Set k = lineList.keySet();
        this.lines = k.toArray(new Line[k.size()]);
        Arrays.sort(this.lines);
        Symbol[] symbolArray3 = this.symbols;
        int n4 = this.symbols.length;
        n3 = 0;
        while (n3 < n4) {
            Line line;
            Symbol sym = symbolArray3[n3];
            if (sym.n_type == 100 && (line = this.getLine(sym.n_value)) != null) {
                line.file = sym.toString();
            }
            ++n3;
        }
    }

    private ArrayList<Section> getSections(SegmentCommand seg) throws IOException {
        if (seg.nsects == 0) {
            return new ArrayList<Section>();
        }
        ArrayList<Section> sections = new ArrayList<Section>();
        int i = 0;
        while (i < seg.nsects) {
            Section section = new Section();
            byte[] sectname = new byte[16];
            byte[] segname = new byte[16];
            this.efile.readFully(sectname);
            section.sectname = new String(sectname, 0, 16);
            this.efile.readFully(segname);
            section.segment = seg;
            section.segname = new String(segname, 0, 16);
            if (this.b64) {
                section.addr = this.efile.readLongE();
                section.size = this.efile.readLongE();
            } else {
                section.addr = this.efile.readIntE();
                section.size = this.efile.readIntE();
            }
            section.offset = this.efile.readIntE();
            section.align = this.efile.readIntE();
            section.reloff = this.efile.readIntE();
            section.nreloc = this.efile.readIntE();
            section.flags = this.efile.readIntE();
            section.reserved1 = this.efile.readIntE();
            section.reserved2 = this.efile.readIntE();
            if (this.b64) {
                section.reserved3 = this.efile.readInt();
            }
            sections.add(section);
            ++i;
        }
        return sections;
    }

    private String getCStr() throws IOException {
        byte tmp;
        StringBuffer str = new StringBuffer();
        while ((tmp = this.efile.readByte()) != 0) {
            str.append((char)tmp);
        }
        return str.toString();
    }

    private String getLCStr(int len) throws IOException {
        if (len == 0) {
            return EMPTY_STRING;
        }
        StringBuffer str = new StringBuffer();
        while (len > 0) {
            byte tmp = this.efile.readByte();
            if (tmp == 0) break;
            str.append((char)tmp);
            --len;
        }
        return str.toString();
    }

    private void loadLoadCommands() throws IOException {
        if (this.loadcommands == null) {
            if (this.mhdr.ncmds == 0) {
                this.loadcommands = new LoadCommand[0];
                return;
            }
            this.loadcommands = new LoadCommand[this.mhdr.ncmds];
            int i = 0;
            while (i < this.mhdr.ncmds) {
                int cmd = this.efile.readIntE();
                int len = this.efile.readIntE();
                switch (cmd) {
                    case 25: {
                        SegmentCommand seg64 = new SegmentCommand();
                        byte[] segname64 = new byte[16];
                        seg64.cmd = cmd;
                        seg64.cmdsize = len;
                        this.efile.readFully(segname64);
                        seg64.segname = new String(segname64, 0, 16);
                        seg64.vmaddr = this.efile.readLongE();
                        seg64.vmsize = this.efile.readLongE();
                        seg64.fileoff = this.efile.readLongE();
                        seg64.filesize = this.efile.readLongE();
                        seg64.maxprot = this.efile.readIntE();
                        seg64.initprot = this.efile.readIntE();
                        seg64.nsects = this.efile.readIntE();
                        seg64.flags = this.efile.readIntE();
                        this.sections.addAll(this.getSections(seg64));
                        this.loadcommands[i] = seg64;
                        break;
                    }
                    case 1: {
                        SegmentCommand seg = new SegmentCommand();
                        byte[] segname = new byte[16];
                        seg.cmd = cmd;
                        seg.cmdsize = len;
                        this.efile.readFully(segname);
                        seg.segname = new String(segname, 0, 16);
                        seg.vmaddr = this.efile.readIntE();
                        seg.vmsize = this.efile.readIntE();
                        seg.fileoff = this.efile.readIntE();
                        seg.filesize = this.efile.readIntE();
                        seg.maxprot = this.efile.readIntE();
                        seg.initprot = this.efile.readIntE();
                        seg.nsects = this.efile.readIntE();
                        seg.flags = this.efile.readIntE();
                        this.sections.addAll(this.getSections(seg));
                        this.loadcommands[i] = seg;
                        break;
                    }
                    case 2: {
                        SymtabCommand stcmd = new SymtabCommand();
                        stcmd.cmd = cmd;
                        stcmd.cmdsize = len;
                        stcmd.symoff = this.efile.readIntE();
                        stcmd.nsyms = this.efile.readIntE();
                        stcmd.stroff = this.efile.readIntE();
                        stcmd.strsize = this.efile.readIntE();
                        this.loadcommands[i] = stcmd;
                        break;
                    }
                    case 3: {
                        SymSegCommand sscmd = new SymSegCommand();
                        sscmd.cmd = cmd;
                        sscmd.cmdsize = len;
                        sscmd.offset = this.efile.readIntE();
                        sscmd.size = this.efile.readIntE();
                        this.loadcommands[i] = sscmd;
                        break;
                    }
                    case 4: 
                    case 5: {
                        ThreadCommand thcmd = new ThreadCommand();
                        thcmd.cmd = cmd;
                        thcmd.cmdsize = len;
                        this.efile.skipBytes(len - 8);
                        this.loadcommands[i] = thcmd;
                        break;
                    }
                    case 6: 
                    case 7: {
                        FVMLibCommand fvmcmd = new FVMLibCommand();
                        fvmcmd.cmd = cmd;
                        fvmcmd.cmdsize = len;
                        fvmcmd.fvmlib = new FVMLib();
                        fvmcmd.fvmlib.name = this.efile.readIntE();
                        fvmcmd.fvmlib.minor_version = this.efile.readIntE();
                        fvmcmd.fvmlib.header_addr = this.efile.readIntE();
                        len = fvmcmd.cmdsize - 20;
                        fvmcmd.fvmlib.lc_str_name = this.getLCStr(len);
                        this.efile.skipBytes(len -= fvmcmd.fvmlib.lc_str_name.length() + 1);
                        this.loadcommands[i] = fvmcmd;
                        break;
                    }
                    case 8: {
                        IdentCommand icmd = new IdentCommand();
                        icmd.cmd = cmd;
                        icmd.cmdsize = len;
                        this.loadcommands[i] = icmd;
                        break;
                    }
                    case 9: {
                        FVMFileCommand fcmd = new FVMFileCommand();
                        fcmd.cmd = cmd;
                        fcmd.cmdsize = len;
                        fcmd.name = this.efile.readIntE();
                        fcmd.header_addr = this.efile.readIntE();
                        len = fcmd.cmdsize - 16;
                        fcmd.lc_str_name = this.getLCStr(len);
                        this.efile.skipBytes(len -= fcmd.lc_str_name.length() + 1);
                        this.loadcommands[i] = fcmd;
                        break;
                    }
                    case 11: {
                        DySymtabCommand dscmd = new DySymtabCommand();
                        dscmd.cmd = cmd;
                        dscmd.cmdsize = len;
                        dscmd.ilocalsym = this.efile.readIntE();
                        dscmd.nlocalsym = this.efile.readIntE();
                        dscmd.iextdefsym = this.efile.readIntE();
                        dscmd.nextdefsym = this.efile.readIntE();
                        dscmd.iundefsym = this.efile.readIntE();
                        dscmd.nundefsym = this.efile.readIntE();
                        dscmd.tocoff = this.efile.readIntE();
                        dscmd.ntoc = this.efile.readIntE();
                        dscmd.modtaboff = this.efile.readIntE();
                        dscmd.nmodtab = this.efile.readIntE();
                        dscmd.extrefsymoff = this.efile.readIntE();
                        dscmd.nextrefsyms = this.efile.readIntE();
                        dscmd.indirectsymoff = this.efile.readIntE();
                        dscmd.nindirectsyms = this.efile.readIntE();
                        dscmd.extreloff = this.efile.readIntE();
                        dscmd.nextrel = this.efile.readIntE();
                        dscmd.locreloff = this.efile.readIntE();
                        dscmd.nlocrel = this.efile.readIntE();
                        this.loadcommands[i] = dscmd;
                        this.dynsym = true;
                        break;
                    }
                    case -2147483624: 
                    case 12: 
                    case 13: {
                        DyLibCommand dylcmd = new DyLibCommand();
                        dylcmd.cmd = cmd;
                        dylcmd.cmdsize = len;
                        dylcmd.dylib = new DyLib();
                        dylcmd.dylib.name = this.efile.readIntE();
                        dylcmd.dylib.timestamp = this.efile.readIntE();
                        dylcmd.dylib.current_version = this.efile.readIntE();
                        dylcmd.dylib.compatibility_version = this.efile.readIntE();
                        len = dylcmd.cmdsize - 24;
                        dylcmd.dylib.lc_str_name = this.getLCStr(len);
                        this.efile.skipBytes(len -= dylcmd.dylib.lc_str_name.length() + 1);
                        this.loadcommands[i] = dylcmd;
                        break;
                    }
                    case 14: 
                    case 15: {
                        DyLinkerCommand dylkcmd = new DyLinkerCommand();
                        dylkcmd.cmd = cmd;
                        dylkcmd.cmdsize = len;
                        dylkcmd.name = this.efile.readIntE();
                        len = dylkcmd.cmdsize - 12;
                        dylkcmd.lc_str_name = this.getLCStr(len);
                        this.efile.skipBytes(len -= dylkcmd.lc_str_name.length() + 1);
                        this.loadcommands[i] = dylkcmd;
                        break;
                    }
                    case 16: {
                        PreboundDyLibCommand pbcmd = new PreboundDyLibCommand();
                        pbcmd.cmd = cmd;
                        pbcmd.cmdsize = len;
                        pbcmd.name = this.efile.readIntE();
                        pbcmd.nmodules = this.efile.readIntE();
                        pbcmd.linked_modules = this.efile.readIntE();
                        len = pbcmd.cmdsize - 20;
                        pbcmd.lc_str_name = this.getLCStr(len);
                        this.efile.skipBytes(len -= pbcmd.lc_str_name.length() + 1);
                        this.loadcommands[i] = pbcmd;
                        break;
                    }
                    case 26: {
                        RoutinesCommand rcmd64 = new RoutinesCommand();
                        rcmd64.cmd = cmd;
                        rcmd64.cmdsize = len;
                        rcmd64.init_address = this.efile.readLongE();
                        rcmd64.init_module = this.efile.readLongE();
                        rcmd64.reserved1 = this.efile.readLongE();
                        rcmd64.reserved2 = this.efile.readLongE();
                        rcmd64.reserved3 = this.efile.readLongE();
                        rcmd64.reserved4 = this.efile.readLongE();
                        rcmd64.reserved5 = this.efile.readLongE();
                        rcmd64.reserved6 = this.efile.readLongE();
                        this.loadcommands[i] = rcmd64;
                        break;
                    }
                    case 17: {
                        RoutinesCommand rcmd = new RoutinesCommand();
                        rcmd.cmd = cmd;
                        rcmd.cmdsize = len;
                        rcmd.init_address = this.efile.readIntE();
                        rcmd.init_module = this.efile.readIntE();
                        rcmd.reserved1 = this.efile.readIntE();
                        rcmd.reserved2 = this.efile.readIntE();
                        rcmd.reserved3 = this.efile.readIntE();
                        rcmd.reserved4 = this.efile.readIntE();
                        rcmd.reserved5 = this.efile.readIntE();
                        rcmd.reserved6 = this.efile.readIntE();
                        this.loadcommands[i] = rcmd;
                        break;
                    }
                    case 18: {
                        SubFrameworkCommand subfcmd = new SubFrameworkCommand();
                        subfcmd.cmd = cmd;
                        subfcmd.cmdsize = len;
                        subfcmd.umbrella = this.efile.readIntE();
                        len = subfcmd.cmdsize - 12;
                        subfcmd.lc_str_name = this.getLCStr(len);
                        this.efile.skipBytes(len -= subfcmd.lc_str_name.length() + 1);
                        this.loadcommands[i] = subfcmd;
                        break;
                    }
                    case 19: {
                        SubUmbrellaCommand subucmd = new SubUmbrellaCommand();
                        subucmd.cmd = cmd;
                        subucmd.cmdsize = len;
                        subucmd.sub_umbrella = this.efile.readIntE();
                        len = subucmd.cmdsize - 12;
                        subucmd.lc_str_name = this.getLCStr(len);
                        this.efile.skipBytes(len -= subucmd.lc_str_name.length() + 1);
                        this.loadcommands[i] = subucmd;
                        break;
                    }
                    case 20: {
                        SubClientCommand subccmd = new SubClientCommand();
                        subccmd.cmd = cmd;
                        subccmd.cmdsize = len;
                        subccmd.client = this.efile.readIntE();
                        len = subccmd.cmdsize - 12;
                        subccmd.lc_str_name = this.getLCStr(len);
                        this.efile.skipBytes(len -= subccmd.lc_str_name.length() + 1);
                        this.loadcommands[i] = subccmd;
                        break;
                    }
                    case 21: {
                        SubLibraryCommand sublcmd = new SubLibraryCommand();
                        sublcmd.cmd = cmd;
                        sublcmd.cmdsize = len;
                        sublcmd.sub_library = this.efile.readIntE();
                        len = sublcmd.cmdsize - 12;
                        sublcmd.lc_str_name = this.getLCStr(len);
                        this.efile.skipBytes(len -= sublcmd.lc_str_name.length() + 1);
                        this.loadcommands[i] = sublcmd;
                        break;
                    }
                    case 22: {
                        TwoLevelHintsCommand tlhcmd = new TwoLevelHintsCommand();
                        tlhcmd.cmd = cmd;
                        tlhcmd.cmdsize = len;
                        tlhcmd.offset = this.efile.readIntE();
                        tlhcmd.nhints = this.efile.readIntE();
                        this.loadcommands[i] = tlhcmd;
                        break;
                    }
                    case 27: {
                        MachUUID uuidCmd = new MachUUID();
                        uuidCmd.cmd = cmd;
                        uuidCmd.cmdsize = len;
                        byte[] uuid = new byte[16];
                        this.efile.readFully(uuid);
                        uuidCmd.uuid = new String(uuid, 0, 16);
                        this.loadcommands[i] = uuidCmd;
                        break;
                    }
                    case 23: {
                        PrebindCksumCommand pbccmd = new PrebindCksumCommand();
                        pbccmd.cmd = cmd;
                        pbccmd.cmdsize = len;
                        pbccmd.cksum = this.efile.readIntE();
                        this.loadcommands[i] = pbccmd;
                        break;
                    }
                    default: {
                        UnknownCommand unknowncmd = new UnknownCommand();
                        unknowncmd.cmd = cmd;
                        unknowncmd.cmdsize = 0;
                        this.loadcommands[i] = unknowncmd;
                    }
                }
                ++i;
            }
        }
    }

    public void loadBinary() throws IOException {
        if (this.loadcommands == null) {
            this.loadLoadCommands();
            this.loadSymbolTable();
            this.loadLineTable();
        }
    }

    public boolean is64() {
        return this.b64;
    }

    public Symbol[] getSymbols() {
        return this.symbols;
    }

    public Symbol[] getDynamicSymbols() {
        if (this.dynsym) {
            return this.symbols;
        }
        return null;
    }

    public Symbol[] getSymtabSymbols() {
        return this.symbols;
    }

    public Symbol[] getLocalSymbols() {
        if (this.local_symbols == null) {
            return this.symbols;
        }
        return this.local_symbols;
    }

    public Line[] getLineTable() {
        return this.lines;
    }

    public Section[] getSections() {
        return this.sections.toArray(new Section[this.sections.size()]);
    }

    public DyLib[] getDyLibs(int type) {
        ArrayList<DyLib> v = new ArrayList<DyLib>();
        LoadCommand[] loadCommandArray = this.loadcommands;
        int n = this.loadcommands.length;
        int n2 = 0;
        while (n2 < n) {
            LoadCommand loadcommand = loadCommandArray[n2];
            if (loadcommand.cmd == type) {
                DyLibCommand dl = (DyLibCommand)loadcommand;
                v.add(dl.dylib);
            }
            ++n2;
        }
        return v.toArray(new DyLib[v.size()]);
    }

    public Symbol getSymbol(long vma) {
        if (this.symbols == null) {
            return null;
        }
        int ndx = Arrays.binarySearch(this.symbols, new Long(vma), symbol_comparator);
        if (ndx > 0) {
            return this.symbols[ndx];
        }
        if (ndx == -1) {
            return null;
        }
        ndx = -ndx - 1;
        return this.symbols[ndx - 1];
    }

    public long swapInt(long val) {
        if (this.mhdr.magic == -822415874 || this.mhdr.magic == -805638658) {
            short[] tmp = new short[]{(short)(val & 0xFFL), (short)(val >> 8 & 0xFFL), (short)(val >> 16 & 0xFFL), (short)(val >> 24 & 0xFFL)};
            return (tmp[0] << 24) + (tmp[1] << 16) + (tmp[2] << 8) + tmp[3];
        }
        return val;
    }

    public int swapShort(short val) {
        if (this.mhdr.magic == -822415874 || this.mhdr.magic == -805638658) {
            short[] tmp = new short[]{(short)(val & 0xFF), (short)(val >> 8 & 0xFF)};
            return (short)((tmp[0] << 8) + tmp[1]);
        }
        return val;
    }

    public String getFilename() {
        return this.file;
    }

    private ISymbolReader createStabsReader() {
        StabsReader symReader = null;
        try {
            if (this.loadcommands == null) {
                this.loadLoadCommands();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        LoadCommand[] loadCommandArray = this.loadcommands;
        int n = this.loadcommands.length;
        int n2 = 0;
        while (n2 < n) {
            LoadCommand loadcommand = loadCommandArray[n2];
            if (loadcommand.cmd == 2) {
                this.symtab = (SymtabCommand)loadcommand;
                try {
                    int symSize = this.symtab.nsyms * (this.mhdr.is64() ? 16 : 12);
                    byte[] data = new byte[symSize];
                    this.efile.seek(this.symtab.symoff);
                    this.efile.readFully(data);
                    byte[] stabstr = new byte[this.symtab.strsize];
                    this.efile.seek(this.symtab.stroff);
                    this.efile.readFully(stabstr);
                    symReader = new StabsReader(data, stabstr, this.getAttributes().isLittleEndian(), this.mhdr.is64());
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        return symReader;
    }

    public Object getSymbolReader() {
        ISymbolReader reader = null;
        reader = this.createStabsReader();
        return reader;
    }

    public class Attribute {
        public static final int MACHO_TYPE_OBJ = 1;
        public static final int MACHO_TYPE_EXE = 2;
        public static final int MACHO_TYPE_CORE = 3;
        public static final int MACHO_TYPE_SHLIB = 4;
        public static final int DEBUG_TYPE_NONE = 0;
        public static final int DEBUG_TYPE_STABS = 1;
        public static final int DEBUG_TYPE_DWARF = 2;
        String cpu;
        int type;
        int debugType;
        boolean bDebug;
        boolean isle;

        public String getCPU() {
            return this.cpu;
        }

        public int getType() {
            return this.type;
        }

        public boolean hasDebug() {
            return this.debugType != 0;
        }

        public int getDebugType() {
            return this.debugType;
        }

        public boolean isLittleEndian() {
            return this.isle;
        }
    }

    public class DyLib {
        public int name;
        public int timestamp;
        public int current_version;
        public int compatibility_version;
        public String lc_str_name = null;

        public String toString() {
            if (this.lc_str_name == null) {
                return MachO64.EMPTY_STRING;
            }
            return this.lc_str_name;
        }
    }

    public class DyLibCommand
    extends LoadCommand {
        public DyLib dylib;
    }

    public class DyLibModule {
        public int module_name;
        public int iextdefsym;
        public int nextdefsym;
        public int irefsym;
        public int nrefsym;
        public int ilocalsym;
        public int nlocalsym;
        public int iextrel;
        public int nextrel;
        public int iinit_iterm;
        public int ninit_nterm;
        public long objc_module_info_addr;
        public int objc_module_info_size;
    }

    public class DyLibReference {
        public int isym;
        public int flags;
    }

    public class DyLibTableOfContents {
        public static final int INDIRECT_SYMBOL_LOCAL = Integer.MIN_VALUE;
        public static final int INDIRECT_SYMBOL_ABS = 0x40000000;
        public int symbol_index;
        public int module_index;
    }

    public class DyLinkerCommand
    extends LoadCommand {
        public int name;
        public String lc_str_name;

        public DyLinkerCommand() {
            this.lc_str_name = null;
        }

        public String toString() {
            if (this.lc_str_name == null) {
                return MachO64.EMPTY_STRING;
            }
            return this.lc_str_name;
        }
    }

    public class DySymtabCommand
    extends LoadCommand {
        public int ilocalsym;
        public int nlocalsym;
        public int iextdefsym;
        public int nextdefsym;
        public int iundefsym;
        public int nundefsym;
        public int tocoff;
        public int ntoc;
        public int modtaboff;
        public int nmodtab;
        public int extrefsymoff;
        public int nextrefsyms;
        public int indirectsymoff;
        public int nindirectsyms;
        public int extreloff;
        public int nextrel;
        public int locreloff;
        public int nlocrel;
    }

    public class FVMFileCommand
    extends LoadCommand {
        public int name;
        public int header_addr;
        public String lc_str_name;

        public FVMFileCommand() {
            this.lc_str_name = null;
        }

        public String toString() {
            if (this.lc_str_name == null) {
                return MachO64.EMPTY_STRING;
            }
            return this.lc_str_name;
        }
    }

    public class FVMLib {
        public int name;
        public int minor_version;
        public int header_addr;
        public String lc_str_name = null;

        public String toString() {
            if (this.lc_str_name == null) {
                return MachO64.EMPTY_STRING;
            }
            return this.lc_str_name;
        }
    }

    public class FVMLibCommand
    extends LoadCommand {
        public FVMLib fvmlib;
    }

    public class IdentCommand
    extends LoadCommand {
    }

    public class LCStr {
        public long offset;
        public long ptr;
    }

    public static class Line
    implements Comparable<Object> {
        public long address;
        public int lineno;
        public String file;
        public String function;

        @Override
        public int compareTo(Object obj) {
            long thisVal = 0L;
            long anotherVal = 0L;
            if (obj instanceof Line) {
                Line l = (Line)obj;
                thisVal = this.address;
                anotherVal = l.address;
            } else if (obj instanceof Long) {
                Long val = (Long)obj;
                anotherVal = val;
                thisVal = this.address;
            }
            return thisVal < anotherVal ? -1 : (thisVal == anotherVal ? 0 : 1);
        }

        public boolean equals(Object obj) {
            Line line = (Line)obj;
            return line.lineno == this.lineno && line.address == this.address;
        }
    }

    public class LoadCommand {
        public static final int LC_REQ_DYLD = Integer.MIN_VALUE;
        public static final int LC_SEGMENT = 1;
        public static final int LC_SYMTAB = 2;
        public static final int LC_SYMSEG = 3;
        public static final int LC_THREAD = 4;
        public static final int LC_UNIXTHREAD = 5;
        public static final int LC_LOADFVMLIB = 6;
        public static final int LC_IDFVMLIB = 7;
        public static final int LC_IDENT = 8;
        public static final int LC_FVMFILE = 9;
        public static final int LC_PREPAGE = 10;
        public static final int LC_DYSYMTAB = 11;
        public static final int LC_LOAD_DYLIB = 12;
        public static final int LC_ID_DYLIB = 13;
        public static final int LC_LOAD_DYLINKER = 14;
        public static final int LC_ID_DYLINKER = 15;
        public static final int LC_PREBOUND_DYLIB = 16;
        public static final int LC_ROUTINES = 17;
        public static final int LC_SUB_FRAMEWORK = 18;
        public static final int LC_SUB_UMBRELLA = 19;
        public static final int LC_SUB_CLIENT = 20;
        public static final int LC_SUB_LIBRARY = 21;
        public static final int LC_TWOLEVEL_HINTS = 22;
        public static final int LC_PREBIND_CKSUM = 23;
        public static final int LC_SEGMENT_64 = 25;
        public static final int LC_ROUTINES_64 = 26;
        public static final int LC_UUID = 27;
        public static final int LC_LOAD_WEAK_DYLIB = -2147483624;
        public int cmd;
        public int cmdsize;
    }

    public class MachOhdr {
        public static final int MH_MAGIC = -17958194;
        public static final int MH_CIGAM = -822415874;
        public static final int MH_UNIVERSAL = -889275714;
        public static final int MH_MAGIC_64 = -17958193;
        public static final int MH_CIGAM_64 = -805638658;
        public static final int CPU_ARCH_MASK = -16777216;
        public static final int CPU_ARCH_ABI64 = 0x1000000;
        public static final int CPU_TYPE_ANY = -1;
        public static final int CPU_TYPE_VAX = 1;
        public static final int CPU_TYPE_MC680x0 = 6;
        public static final int CPU_TYPE_I386 = 7;
        public static final int CPU_TYPE_X86 = 7;
        public static final int CPU_TYPE_X86_64 = 0x1000007;
        public static final int CPU_TYPE_MC98000 = 10;
        public static final int CPU_TYPE_HPPA = 11;
        public static final int CPU_TYPE_MC88000 = 13;
        public static final int CPU_TYPE_SPARC = 14;
        public static final int CPU_TYPE_I860 = 15;
        public static final int CPU_TYPE_POWERPC = 18;
        public static final int CPU_TYPE_POWERPC64 = 0x1000012;
        public static final int CPU_SUBTYPE_MASK = -16777216;
        public static final int CPU_SUBTYPE_LIB64 = Integer.MIN_VALUE;
        public static final int CPU_SUBTYPE_MULTIPLE = -1;
        public static final int CPU_SUBTYPE_LITTLE_ENDIAN = 0;
        public static final int CPU_SUBTYPE_BIG_ENDIAN = 1;
        public static final int CPU_SUBTYPE_VAX_ALL = 0;
        public static final int CPU_SUBTYPE_VAX780 = 1;
        public static final int CPU_SUBTYPE_VAX785 = 2;
        public static final int CPU_SUBTYPE_VAX750 = 3;
        public static final int CPU_SUBTYPE_VAX730 = 4;
        public static final int CPU_SUBTYPE_UVAXI = 5;
        public static final int CPU_SUBTYPE_UVAXII = 6;
        public static final int CPU_SUBTYPE_VAX8200 = 7;
        public static final int CPU_SUBTYPE_VAX8500 = 8;
        public static final int CPU_SUBTYPE_VAX8600 = 9;
        public static final int CPU_SUBTYPE_VAX8650 = 10;
        public static final int CPU_SUBTYPE_VAX8800 = 11;
        public static final int CPU_SUBTYPE_UVAXIII = 12;
        public static final int CPU_SUBTYPE_MC680x0_ALL = 1;
        public static final int CPU_SUBTYPE_MC68030 = 1;
        public static final int CPU_SUBTYPE_MC68040 = 2;
        public static final int CPU_SUBTYPE_MC68030_ONLY = 3;
        public static final int CPU_SUBTYPE_I386_ALL = 3;
        public static final int CPU_SUBTYPE_386 = 3;
        public static final int CPU_SUBTYPE_486 = 4;
        public static final int CPU_SUBTYPE_486SX = 132;
        public static final int CPU_SUBTYPE_586 = 5;
        public static final int CPU_SUBTYPE_PENT = 5;
        public static final int CPU_SUBTYPE_PENTPRO = 32;
        public static final int CPU_SUBTYPE_PENTII_M3 = 54;
        public static final int CPU_SUBTYPE_PENTII_M5 = 86;
        public static final int CPU_SUBTYPE_CELERON = 103;
        public static final int CPU_SUBTYPE_CELERON_MOBILE = 119;
        public static final int CPU_SUBTYPE_PENTIUM_3 = 8;
        public static final int CPU_SUBTYPE_PENTIUM_3_M = 24;
        public static final int CPU_SUBTYPE_PENTIUM_3_XEON = 40;
        public static final int CPU_SUBTYPE_PENTIUM_M = 9;
        public static final int CPU_SUBTYPE_PENTIUM_4 = 10;
        public static final int CPU_SUBTYPE_PENTIUM_4_M = 10;
        public static final int CPU_SUBTYPE_ITANIUM = 11;
        public static final int CPU_SUBTYPE_ITANIUM_2 = 27;
        public static final int CPU_SUBTYPE_XEON = 12;
        public static final int CPU_SUBTYPE_XEON_MP = 28;
        public static final int CPU_SUBTYPE_X86_ALL = 3;
        public static final int CPU_SUBTYPE_X86_64_ALL = 3;
        public static final int CPU_SUBTYPE_X86_ARCH1 = 4;
        public static final int CPU_SUBTYPE_MIPS_ALL = 0;
        public static final int CPU_SUBTYPE_MIPS_R2300 = 1;
        public static final int CPU_SUBTYPE_MIPS_R2600 = 2;
        public static final int CPU_SUBTYPE_MIPS_R2800 = 3;
        public static final int CPU_SUBTYPE_MIPS_R2000a = 4;
        public static final int CPU_SUBTYPE_MIPS_R2000 = 5;
        public static final int CPU_SUBTYPE_MIPS_R3000a = 6;
        public static final int CPU_SUBTYPE_MIPS_R3000 = 7;
        public static final int CPU_SUBTYPE_MC98000_ALL = 0;
        public static final int CPU_SUBTYPE_MC98601 = 1;
        public static final int CPU_SUBTYPE_HPPA_ALL = 0;
        public static final int CPU_SUBTYPE_HPPA_7100 = 0;
        public static final int CPU_SUBTYPE_HPPA_7100LC = 1;
        public static final int CPU_SUBTYPE_MC88000_ALL = 0;
        public static final int CPU_SUBTYPE_MC88100 = 1;
        public static final int CPU_SUBTYPE_MC88110 = 2;
        public static final int CPU_SUBTYPE_SPARC_ALL = 0;
        public static final int CPU_SUBTYPE_I860_ALL = 0;
        public static final int CPU_SUBTYPE_I860_860 = 1;
        public static final int CPU_SUBTYPE_POWERPC_ALL = 0;
        public static final int CPU_SUBTYPE_POWERPC_601 = 1;
        public static final int CPU_SUBTYPE_POWERPC_602 = 2;
        public static final int CPU_SUBTYPE_POWERPC_603 = 3;
        public static final int CPU_SUBTYPE_POWERPC_603e = 4;
        public static final int CPU_SUBTYPE_POWERPC_603ev = 5;
        public static final int CPU_SUBTYPE_POWERPC_604 = 6;
        public static final int CPU_SUBTYPE_POWERPC_604e = 7;
        public static final int CPU_SUBTYPE_POWERPC_620 = 8;
        public static final int CPU_SUBTYPE_POWERPC_750 = 9;
        public static final int CPU_SUBTYPE_POWERPC_7400 = 10;
        public static final int CPU_SUBTYPE_POWERPC_7450 = 11;
        public static final int CPU_SUBTYPE_POWERPC_970 = 100;
        public static final int MH_OBJECT = 1;
        public static final int MH_EXECUTE = 2;
        public static final int MH_FVMLIB = 3;
        public static final int MH_CORE = 4;
        public static final int MH_PRELOAD = 5;
        public static final int MH_DYLIB = 6;
        public static final int MH_DYLINKER = 7;
        public static final int MH_BUNDLE = 8;
        public static final int MH_DYLIB_STUB = 9;
        public static final int MH_DSYM = 10;
        public static final int MH_NOUNDEFS = 1;
        public static final int MH_INCRLINK = 2;
        public static final int MH_DYLDLINK = 4;
        public static final int MH_BINDATLOAD = 8;
        public static final int MH_PREBOUND = 16;
        public static final int MH_SPLIT_SEGS = 32;
        public static final int MH_LAZY_INIT = 64;
        public static final int MH_TWOLEVEL = 128;
        public static final int MH_FORCE_FLAT = 256;
        public static final int MH_NOMULTIDEFS = 512;
        public static final int MH_NOFIXPREBINDING = 1024;
        public static final int MH_PREBINDABLE = 2048;
        public static final int MH_ALLMODSBOUND = 4096;
        public static final int MH_SUBSECTIONS_VIA_SYMBOLS = 8192;
        public static final int MH_CANONICAL = 16384;
        public static final int MH_WEAK_DEFINES = 32768;
        public static final int MH_BINDS_TO_WEAK = 65536;
        public static final int MH_ALLOW_STACK_EXECUTION = 131072;
        public static final int MH_ROOT_SAFE = 262144;
        public static final int MH_SETUID_SAFE = 524288;
        public static final int MH_NO_REEXPORTED_DYLIBS = 0x100000;
        public static final int MH_PIE = 0x200000;
        public int magic;
        public int cputype;
        public int cpusubtype;
        public int filetype;
        public int ncmds;
        public int sizeofcmds;
        public int flags;
        public int reserved;

        protected MachOhdr() throws IOException {
            MachO64.this.efile.seek(0L);
            MachO64.this.efile.setEndian(false);
            this.magic = MachO64.this.efile.readIntE();
            if (this.magic == -822415874 || this.magic == -805638658) {
                MachO64.this.efile.setEndian(true);
                if (-805638658 == this.magic) {
                    MachO64.this.b64 = true;
                }
            } else if (this.magic == -889275714) {
                String arch = System.getProperty("os.arch");
                int numArchives = MachO64.this.efile.readIntE();
                while (numArchives-- > 0) {
                    int cpuType = MachO64.this.efile.readIntE();
                    MachO64.this.efile.readIntE();
                    int archiveOffset = MachO64.this.efile.readIntE();
                    MachO64.this.efile.readIntE();
                    MachO64.this.efile.readIntE();
                    if ((cpuType != 7 || !arch.equalsIgnoreCase("i386") && !arch.equalsIgnoreCase("x86_64")) && (cpuType != 18 || !arch.equalsIgnoreCase("ppc")) && (cpuType != 0x1000007 || !arch.equalsIgnoreCase("x86_64"))) continue;
                    if (cpuType == 0x1000007) {
                        MachO64.this.b64 = true;
                    }
                    MachO64.this.efile.seek(archiveOffset);
                    this.magic = MachO64.this.efile.readIntE();
                    if (this.magic == -822415874 || this.magic == -805638658) {
                        MachO64.this.efile.setEndian(true);
                    } else if (this.magic != -17958194 && this.magic != -17958193) {
                        throw new IOException(CCorePlugin.getResourceString("Util.exception.notMACHO"));
                    }
                    break;
                }
            } else if (this.magic != -17958194 && this.magic != -17958193) {
                throw new IOException(CCorePlugin.getResourceString("Util.exception.notMACHO"));
            }
            if (this.magic == -17958193 || this.magic == -805638658) {
                MachO64.this.b64 = true;
            }
            this.cputype = MachO64.this.efile.readIntE();
            this.cpusubtype = MachO64.this.efile.readIntE();
            this.filetype = MachO64.this.efile.readIntE();
            this.ncmds = MachO64.this.efile.readIntE();
            this.sizeofcmds = MachO64.this.efile.readIntE();
            this.flags = MachO64.this.efile.readIntE();
            if (MachO64.this.b64) {
                this.reserved = MachO64.this.efile.readIntE();
            }
        }

        protected MachOhdr(byte[] bytes) throws IOException {
            boolean isle = false;
            int offset = 0;
            this.magic = MachO64.makeInt(bytes, offset, isle);
            offset += 4;
            if (this.magic == -822415874 || this.magic == -805638658) {
                isle = true;
                if (-805638658 == this.magic) {
                    MachO64.this.b64 = true;
                }
            } else if (this.magic == -889275714) {
                String arch = System.getProperty("os.arch");
                int numArchives = MachO64.makeInt(bytes, offset, isle);
                offset += 4;
                while (numArchives-- > 0) {
                    int cpuType = MachO64.makeInt(bytes, offset, isle);
                    offset += 4;
                    int archiveOffset = MachO64.makeInt(bytes, offset += 4, isle);
                    offset += 4;
                    offset += 4;
                    offset += 4;
                    if ((cpuType != 7 || !arch.equalsIgnoreCase("i386") && !arch.equalsIgnoreCase("x86_64")) && (cpuType != 18 || !arch.equalsIgnoreCase("ppc")) && (cpuType != 0x1000007 || !arch.equalsIgnoreCase("x86_64"))) continue;
                    if (cpuType == 0x1000007) {
                        MachO64.this.b64 = true;
                    }
                    offset = archiveOffset;
                    this.magic = MachO64.makeInt(bytes, offset, isle);
                    offset += 4;
                    if (this.magic == -822415874 || this.magic == -805638658) {
                        isle = true;
                    } else if (this.magic != -17958194 && this.magic != -17958193) {
                        throw new IOException(CCorePlugin.getResourceString("Util.exception.notMACHO"));
                    }
                    break;
                }
            } else if (this.magic != -17958194 && this.magic != -17958193) {
                throw new IOException(CCorePlugin.getResourceString("Util.exception.notMACHO"));
            }
            if (this.magic == -17958193 || this.magic == -805638658) {
                MachO64.this.b64 = true;
            }
            this.cputype = MachO64.makeInt(bytes, offset, isle);
            this.cpusubtype = MachO64.makeInt(bytes, offset += 4, isle);
            this.filetype = MachO64.makeInt(bytes, offset += 4, isle);
            this.ncmds = MachO64.makeInt(bytes, offset += 4, isle);
            this.sizeofcmds = MachO64.makeInt(bytes, offset += 4, isle);
            this.flags = MachO64.makeInt(bytes, offset += 4, isle);
            offset += 4;
            if (MachO64.this.b64) {
                this.reserved = MachO64.makeInt(bytes, offset, isle);
                offset += 4;
            }
        }

        public boolean is64() {
            return MachO64.this.b64;
        }
    }

    public class MachUUID
    extends LoadCommand {
        public String uuid;
    }

    public class PrebindCksumCommand
    extends LoadCommand {
        public int cksum;
    }

    public class PreboundDyLibCommand
    extends LoadCommand {
        public int name;
        public int nmodules;
        public int linked_modules;
        public String lc_str_name = null;

        public String toString() {
            if (this.lc_str_name == null) {
                return MachO64.EMPTY_STRING;
            }
            return this.lc_str_name;
        }
    }

    public class RoutinesCommand
    extends LoadCommand {
        public long init_address;
        public long init_module;
        public long reserved1;
        public long reserved2;
        public long reserved3;
        public long reserved4;
        public long reserved5;
        public long reserved6;
    }

    public class Section {
        public static final int SECTION_TYP = 255;
        public static final int SECTION_ATTRIBUTES = -256;
        public static final int SECTION_ATTRIBUTES_USR = -16777216;
        public static final int S_REGULAR = 0;
        public static final int S_ZEROFILL = 1;
        public static final int S_CSTRING_LITERALS = 2;
        public static final int S_4BYTE_LITERALS = 3;
        public static final int S_8BYTE_LITERALS = 4;
        public static final int S_LITERAL_POINTERS = 5;
        public static final int S_NON_LAZY_SYMBOL_POINTERS = 6;
        public static final int S_LAZY_SYMBOL_POINTERS = 7;
        public static final int S_SYMBOL_STUBS = 8;
        public static final int S_MOD_INIT_FUNC_POINTERS = 9;
        public static final int S_MOD_TERM_FUNC_POINTERS = 10;
        public static final int S_COALESCED = 11;
        public static final int S_ATTR_PURE_INSTRUCTIONS = Integer.MIN_VALUE;
        public static final int S_ATTR_NO_TOC = 0x40000000;
        public static final int S_ATTR_STRIP_STATIC_SYMS = 0x20000000;
        public static final int SECTION_ATTRIBUTES_SYS = 0xFFFF00;
        public static final int S_ATTR_SOME_INSTRUCTIONS = 1024;
        public static final int S_ATTR_EXT_RELOC = 512;
        public static final int S_ATTR_LOC_RELOC = 256;
        public String sectname;
        public String segname;
        public SegmentCommand segment;
        public long addr;
        public long size;
        public int offset;
        public int align;
        public int reloff;
        public int nreloc;
        public int flags;
        public int reserved1;
        public int reserved2;
        public int reserved3;

        public int flags(int mask) {
            return this.flags & mask;
        }
    }

    public class SegmentCommand
    extends LoadCommand {
        public static final long SG_HIGHVM = 1L;
        public static final long SG_FVMLIB = 2L;
        public static final long SG_NORELOC = 4L;
        public static final int VM_PROT_NONE = 0;
        public static final int VM_PROT_READ = 1;
        public static final int VM_PROT_WRITE = 2;
        public static final int VM_PROT_EXECUTE = 4;
        public static final int VM_PROT_DEFAULT = 3;
        public static final int VM_PROT_ALL = 7;
        public static final int VM_PROT_NO_CHANGE = 8;
        public static final int VM_PROT_COPY = 16;
        public static final int VM_PROT_WANTS_COPY = 16;
        public String segname;
        public long vmaddr;
        public long vmsize;
        public long fileoff;
        public long filesize;
        public int maxprot;
        public int initprot;
        public int nsects;
        public int flags;

        public boolean prot(int val) {
            return (this.initprot & val) == val;
        }
    }

    public class SubClientCommand
    extends LoadCommand {
        public int client;
        public String lc_str_name = null;

        public String toString() {
            if (this.lc_str_name == null) {
                return MachO64.EMPTY_STRING;
            }
            return this.lc_str_name;
        }
    }

    public class SubFrameworkCommand
    extends LoadCommand {
        public int umbrella;
        public String lc_str_name = null;

        public String toString() {
            if (this.lc_str_name == null) {
                return MachO64.EMPTY_STRING;
            }
            return this.lc_str_name;
        }
    }

    public class SubLibraryCommand
    extends LoadCommand {
        public int sub_library;
        public String lc_str_name = null;

        public String toString() {
            if (this.lc_str_name == null) {
                return MachO64.EMPTY_STRING;
            }
            return this.lc_str_name;
        }
    }

    public class SubUmbrellaCommand
    extends LoadCommand {
        public int sub_umbrella;
        public String lc_str_name = null;

        public String toString() {
            if (this.lc_str_name == null) {
                return MachO64.EMPTY_STRING;
            }
            return this.lc_str_name;
        }
    }

    public class SymSegCommand
    extends LoadCommand {
        public int offset;
        public int size;
    }

    public class Symbol
    implements Comparable<Object> {
        public static final int N_STAB = 224;
        public static final int N_PEXT = 16;
        public static final int N_EXT = 1;
        public static final int N_TYPE = 14;
        public static final int N_UNDF = 0;
        public static final int N_ABS = 2;
        public static final int N_SECT = 14;
        public static final int N_PBUD = 12;
        public static final int N_INDR = 10;
        public static final int N_GSYM = 32;
        public static final int N_FNAME = 34;
        public static final int N_FUN = 36;
        public static final int N_STSYM = 38;
        public static final int N_LCSYM = 40;
        public static final int N_BNSYM = 46;
        public static final int N_OPT = 60;
        public static final int N_RSYM = 64;
        public static final int N_SLINE = 68;
        public static final int N_ENSYM = 78;
        public static final int N_SSYM = 96;
        public static final int N_SO = 100;
        public static final int N_LSYM = 128;
        public static final int N_BINCL = 130;
        public static final int N_SOL = 132;
        public static final int N_PARAMS = 134;
        public static final int N_VERSION = 136;
        public static final int N_OLEVEL = 138;
        public static final int N_PSYM = 160;
        public static final int N_EINCL = 162;
        public static final int N_ENTRY = 164;
        public static final int N_LBRAC = 192;
        public static final int N_EXCL = 194;
        public static final int N_RBRAC = 224;
        public static final int N_BCOMM = 226;
        public static final int N_ECOMM = 228;
        public static final int N_ECOML = 232;
        public static final int N_LENG = 254;
        public static final int NO_SECT = 0;
        public static final int MAX_SECT = 255;
        public static final int REFERENCE_TYPE = 15;
        public static final int REFERENCE_FLAG_UNDEFINED_NON_LAZY = 0;
        public static final int REFERENCE_FLAG_UNDEFINED_LAZY = 1;
        public static final int REFERENCE_FLAG_DEFINED = 2;
        public static final int REFERENCE_FLAG_PRIVATE_DEFINED = 3;
        public static final int REFERENCE_FLAG_PRIVATE_UNDEFINED_NON_LAZY = 4;
        public static final int REFERENCE_FLAG_PRIVATE_UNDEFINED_LAZY = 5;
        public static final int REFERENCED_DYNAMICALLY = 16;
        public static final int N_DESC_DISCARDED = 32;
        public static final int N_WEAK_REF = 64;
        public static final int N_WEAK_DEF = 128;
        public long n_strx;
        public long n_value;
        public short n_desc;
        public byte n_type;
        public byte n_sect;
        public boolean is64;
        private String name = null;
        private Line line = null;

        private String cppFilt(String in) {
            if (MachO64.this.cppFiltEnabled) {
                try {
                    if (in.indexOf("__") != -1 || in.indexOf("_._") != -1) {
                        if (MachO64.this.cppFilt == null) {
                            MachO64.this.cppFilt = new CPPFilt();
                        }
                        return MachO64.this.cppFilt.getFunction(in);
                    }
                }
                catch (IOException iOException) {
                    return in;
                }
            }
            return in;
        }

        public boolean n_type_mask(int mask) {
            return (this.n_type & mask) != 0;
        }

        public boolean n_type(int val) {
            return (this.n_type & 0xE) == val;
        }

        public boolean n_desc(int val) {
            return (this.n_type & 0xF) == val;
        }

        @Override
        public int compareTo(Object obj) {
            long thisVal = 0L;
            long anotherVal = 0L;
            if (obj instanceof Symbol) {
                Symbol sym = (Symbol)obj;
                thisVal = this.n_value;
                anotherVal = sym.n_value;
            } else if (obj instanceof Long) {
                Long val = (Long)obj;
                anotherVal = val;
                thisVal = this.n_value;
            }
            return thisVal < anotherVal ? -1 : (thisVal == anotherVal ? 0 : 1);
        }

        public String toString() {
            if (this.n_strx == 0L || MachO64.this.symtab == null) {
                return MachO64.EMPTY_STRING;
            }
            if (this.name == null) {
                try {
                    this.name = this.cppFilt(MachO64.this.string_from_macho_symtab(MachO64.this.symtab, (int)this.n_strx));
                }
                catch (IOException iOException) {
                    return MachO64.EMPTY_STRING;
                }
            }
            return this.name;
        }

        public String lineInfo() {
            if (!MachO64.this.debugsym) {
                return null;
            }
            if (this.line == null) {
                long value = this.n_value;
                int i = 0;
                while (i <= 20) {
                    Line l = MachO64.this.getLine(value);
                    if (l != null && l.lineno != 0) {
                        this.line = l;
                        break;
                    }
                    value += (long)(i += 4);
                }
            }
            if (this.line != null) {
                return Integer.toString(this.line.lineno);
            }
            return null;
        }

        public String lineInfo(long vma) {
            Line l = MachO64.this.getLine(vma);
            if (l != null) {
                return Integer.toString(l.lineno);
            }
            return null;
        }

        public String getFunction() {
            if (this.line == null) {
                this.lineInfo();
            }
            if (this.line != null) {
                return this.line.function;
            }
            return null;
        }

        public String getFilename() {
            if (this.line == null) {
                this.lineInfo();
            }
            if (this.line != null) {
                return this.line.file;
            }
            return null;
        }

        public int getFuncLineNumber() {
            if (this.line == null) {
                this.lineInfo();
            }
            if (this.line == null) {
                return -1;
            }
            return this.line.lineno;
        }

        public int getLineNumber(long vma) {
            Line l = MachO64.this.getLine(vma);
            if (l == null) {
                return -1;
            }
            return l.lineno;
        }
    }

    public static class SymbolComparator
    implements Comparator<Object> {
        long val1;
        long val2;

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof Long) {
                this.val1 = (Long)o1;
            } else if (o1 instanceof Symbol) {
                this.val1 = ((Symbol)o1).n_value;
            } else {
                return -1;
            }
            if (o2 instanceof Long) {
                this.val2 = (Long)o2;
            } else if (o2 instanceof Symbol) {
                this.val2 = ((Symbol)o2).n_value;
            } else {
                return -1;
            }
            return this.val1 == this.val2 ? 0 : (this.val1 < this.val2 ? -1 : 1);
        }
    }

    public class SymtabCommand
    extends LoadCommand {
        public int symoff;
        public int nsyms;
        public int stroff;
        public int strsize;
    }

    public class ThreadCommand
    extends LoadCommand {
    }

    public class TwoLevelHint {
        public int isub_image;
        public int itoc;
    }

    public class TwoLevelHintsCommand
    extends LoadCommand {
        public int offset;
        public int nhints;
        public TwoLevelHint[] hints;
    }

    public class UnknownCommand
    extends LoadCommand {
    }
}

